#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_utils.widget.decimal module

This module provides a custom data converter for decimal fields using dots as separator
"""

import decimal

from z3c.form.converter import BaseDataConverter, FormatterValidationError
from z3c.form.interfaces import IWidget, IDataConverter

from pyams_utils.adapter import adapter_config
from pyams_utils.schema import IDottedDecimalField

__docformat__ = 'restructuredtext'

from pyams_utils import _


@adapter_config(context=(IDottedDecimalField, IWidget), provides=IDataConverter)
class DottedDecimalDataConverter(BaseDataConverter):
    """Dotted decimal field data converter"""

    errorMessage = _('The entered value is not a valid decimal literal.')

    def toWidgetValue(self, value):
        if not value:
            return self.field.missing_value
        return value

    def toFieldValue(self, value):
        if value is self.field.missing_value:
            return ''
        if not value:
            return None
        try:
            return decimal.Decimal(value)
        except decimal.InvalidOperation:
            raise FormatterValidationError(self.errorMessage, value)
