#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_utils.timezone.utility module

"""

from persistent import Persistent
from zope.container.contained import Contained
from zope.interface import implementer
from zope.schema.fieldproperty import FieldProperty

from pyams_utils.interfaces.site import ISiteGenerations
from pyams_utils.interfaces.timezone import IServerTimezone
from pyams_utils.registry import utility_config
from pyams_utils.site import check_required_utilities


__docformat__ = 'restructuredtext'


@implementer(IServerTimezone)
class ServerTimezoneUtility(Persistent, Contained):
    """Server timezone utility"""

    timezone = FieldProperty(IServerTimezone['timezone'])


REQUIRED_UTILITIES = ((IServerTimezone, '', ServerTimezoneUtility, 'Server timezone'),)


@utility_config(name='PyAMS timezone', provides=ISiteGenerations)
class TimezoneGenerationsChecker:
    """Timezone generations checker"""

    order = 10
    generation = 1

    @staticmethod
    def evolve(site, current=None):  # pylint: disable=unused-argument
        """Check for required utilities"""
        check_required_utilities(site, REQUIRED_UTILITIES)
