#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_utils.interfaces.site module

This module provides interfaces related to site management, generations and utilities
"""

from zope.annotation.interfaces import IAttributeAnnotatable
from zope.interface import Attribute, Interface
from zope.interface.interfaces import IObjectEvent


__docformat__ = 'restructuredtext'


class ISiteRoot(IAttributeAnnotatable):
    """Marker interface for site root"""


class ISiteRootFactory(Interface):
    """Site root utility factory interface"""


class INewLocalSiteCreatedEvent(IObjectEvent):
    """Event interface when a new site root has been created"""


class ISiteUpgradeEvent(IObjectEvent):
    """Event interface when a site upgrade is requested"""


SITE_GENERATIONS_KEY = 'pyams.generations'


class ISiteGenerations(Interface):
    """Site generations interface"""

    order = Attribute("Order in which generations should be upgraded")
    generation = Attribute("Current schema generation")

    def evolve(self, site, current=None):
        """Evolve database from current generation to last one"""


class IConfigurationManager(IAttributeAnnotatable):
    """Configuration manager marker interface"""


class IOptionalUtility(Interface):
    """Marker interface for site utilities that can be removed"""
