#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_utils.interfaces package

This module defines several generic constants and interfaces.

It is also used to provide translations to common zope.schema exceptions.
"""

from zope.interface import Interface
from zope.schema.interfaces import ConstraintNotSatisfied, InvalidDottedName, InvalidId, \
    InvalidURI, InvalidValue, NotAContainer, NotAnIterator, NotUnique, RequiredMissing, \
    SchemaNotFullyImplemented, SchemaNotProvided, TooBig, TooLong, TooShort, TooSmall, Unbound, \
    WrongContainedType, WrongType

__docformat__ = 'restructuredtext'

from pyams_utils import _


#
# Custom zope.schema exceptions messages
#

WrongContainedType.__doc__ = _("""Wrong contained type""")
NotUnique.__doc__ = _("""One or more entries of sequence are not unique.""")
SchemaNotFullyImplemented.__doc__ = _("""Schema not fully implemented""")
SchemaNotProvided.__doc__ = _("""Schema not provided""")
InvalidURI.__doc__ = _("""The specified URI is not valid.""")
InvalidId.__doc__ = _("""The specified id is not valid.""")
InvalidDottedName.__doc__ = _("""The specified dotted name is not valid.""")
Unbound.__doc__ = _("""The field is not bound.""")

RequiredMissing.__doc__ = _("""Required input is missing.""")
WrongType.__doc__ = _("""Object is of wrong type.""")
TooBig.__doc__ = _("""Value is too big""")
TooSmall.__doc__ = _("""Value is too small""")
TooLong.__doc__ = _("""Value is too long""")
TooShort.__doc__ = _("""Value is too short""")
InvalidValue.__doc__ = _("""Invalid value""")
ConstraintNotSatisfied.__doc__ = _("""Constraint not satisfied""")
NotAContainer.__doc__ = _("""Not a container""")
NotAnIterator.__doc__ = _("""Not an iterator""")

#
# Custom permissions
#

FORBIDDEN_PERMISSION = 'system.forbidden'
'''Custom permission which is never granted to any user, even system manager'''

PUBLIC_PERMISSION = 'public'
'''Public permission which is granted to every principal'''

VIEW_PERMISSION = 'view'
'''View permission is a custom permission used to view contents'''

MANAGE_PERMISSION = 'manage'
'''Permission used to manage basic information; this permission is generally not used by custom
contents'''

VIEW_SYSTEM_PERMISSION = 'pyams.ViewSystem'
'''Permission used to access management screens'''

MANAGE_SYSTEM_PERMISSION = 'pyams.ManageSystem'
'''Permission used to manage system settings'''

MANAGE_SKIN_PERMISSION = 'pyams.ManageSkin'
'''Permission used to manage skin'''

MANAGE_SECURITY_PERMISSION = 'pyams.ManageSecurity'
'''Permission used to manage security settings'''

MANAGE_ROLES_PERMISSION = 'pyams.ManageRoles'
'''Permission used to manage roles'''

USE_APIKEY_PERMISSION = 'pyams.UseAPIKey'
'''Permission used to use an API key'''


#
# Custom string constants
#

PYAMS_APPLICATION_SETTINGS_KEY = 'pyams.application_name'
'''ZODB application name settings key'''

PYAMS_APPLICATION_DEFAULT_NAME = 'application'
'''ZODB default application name'''

PYAMS_APPLICATION_FACTORY_KEY = 'pyams.application_factory'
'''Settings key to define site root factory'''


class MissingRequestError(Exception):
    """Error raised when no request is available"""


class IObjectFactory(Interface):
    """Object factory interface

    This interface can be used to register an "interface's object factory".
    For a given interface, such factory can be used to get an instance of an object providing
    this interface; several factories can be registered for the same interface if they have
    distinct names. See :py:mod:`pyams_utils.factory` module.
    """


class ICacheKeyValue(Interface):
    """Interface used to get string representation of a given object as cache key

    Several default adapters are given for objects (using their "id()"), strings (using string as
    key) and for persistent objects (using their persistent OID); you are free to provide your
    own adapters.
    """
