#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_utils.include module

This module is used for Pyramid integration
"""

from chameleon import PageTemplateFile
from persistent.interfaces import IPersistent
from z3c.pt.pagetemplate import PageTemplateFile as Z3cPageTemplateFile
from zope.annotation.attribute import AttributeAnnotations
from zope.annotation.interfaces import IAnnotations, IAttributeAnnotatable
from zope.keyreference.interfaces import IKeyReference
from zope.keyreference.persistent import KeyReferenceToPersistent

from pyams_utils.container import ParentSelector
from pyams_utils.context import ContextSelector
from pyams_utils.i18n import set_locales
from pyams_utils.request import RequestSelector, get_annotations, get_debug
from pyams_utils.site import site_factory
from pyams_utils.tales import ExtensionExpr
from pyams_utils.url import get_display_context
from pyams_utils.traversing import NamespaceTraverser

__docformat__ = 'restructuredtext'


def include_package(config):
    """Pyramid package include"""

    # add translations
    config.add_translation_dirs('pyams_utils:locales')

    # define locale
    set_locales(config.registry.settings)

    # define root factory
    config.set_root_factory(site_factory)

    # add request annotations
    config.add_request_method(get_annotations, 'annotations', reify=True)
    config.add_request_method(get_debug, 'debug', reify=True)
    config.add_request_method(get_display_context, 'display_context', property=True)

    # add traverser handling namespaces via "++ns++(options)" URLs
    config.add_traverser(NamespaceTraverser)

    # add custom subscriber predicate to filter events via supported interface(s)
    config.add_subscriber_predicate('context_selector', ContextSelector)
    config.add_subscriber_predicate('parent_selector', ParentSelector)
    config.add_subscriber_predicate('request_selector', RequestSelector)

    # load registry components
    config.registry.registerAdapter(AttributeAnnotations, (IAttributeAnnotatable, ), IAnnotations)
    config.registry.registerAdapter(KeyReferenceToPersistent, (IPersistent, ), IKeyReference)

    try:
        import pyams_zmi  # pylint: disable=import-outside-toplevel,unused-import
    except ImportError:
        config.scan(ignore='pyams_utils.zmi')
    else:
        config.scan()

    if hasattr(config, 'load_zcml'):
        config.load_zcml('configure.zcml')

    PageTemplateFile.expression_types['tales'] = ExtensionExpr
    Z3cPageTemplateFile.expression_types['tales'] = ExtensionExpr
