#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_utils package

This package provides several small modules dedicated to generic features
for which dedicated packages are not provided. These features can concern
date and times management, strings and unicode, lists and dictionaries,
custom decorators to define several kinds of properties, and so on.
"""

from pyramid.i18n import TranslationStringFactory
from zope.schema.fieldproperty import FieldProperty


__docformat__ = 'restructuredtext'

_ = TranslationStringFactory('pyams_utils')


def get_field_doc(self):
    """Try to get FieldProperty field docstring from field interface"""
    field = self._FieldProperty__field  # pylint: disable=protected-access
    if field.title:
        if field.description:
            return '{0}: {1}'.format(field.title, field.description)
        return field.title
    return super(self.__class__, self).__doc__


FieldProperty.__doc__ = property(get_field_doc)


def includeme(config):
    """pyams_utils features include"""
    from .include import include_package  # pylint: disable=import-outside-toplevel
    include_package(config)
