### -*- coding: utf-8 -*- ####################################################
##############################################################################
#
# Copyright (c) 2008-2010 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
##############################################################################

"""
This module contains pyams_utils package
"""
import os
from setuptools import setup, find_packages

DOCS = os.path.join(os.path.dirname(__file__),
                    'docs')

README = os.path.join(DOCS, 'README.txt')
HISTORY = os.path.join(DOCS, 'HISTORY.txt')

version = '0.2.1'
long_description = open(README).read() + '\n\n' + open(HISTORY).read()

tests_require = [
    'pyramid_zcml',
    'zope.exceptions'
]

setup(name='pyams_utils',
      version=version,
      description="Utility functions and classes for PyAMS",
      long_description=long_description,
      classifiers=[
          "License :: OSI Approved :: Zope Public License",
          "Development Status :: 4 - Beta",
          "Programming Language :: Python",
          "Framework :: Zope3",
          "Topic :: Software Development :: Libraries :: Python Modules",
      ],
      keywords='Pyramid PyAMS utilities',
      author='Thierry Florac',
      author_email='tflorac@ulthar.net',
      url='http://www.ztfy.org',
      license='ZPL',
      packages=find_packages('src'),
      package_dir={'': 'src'},
      namespace_packages=[],
      include_package_data=True,
      package_data={'': ['*.zcml', '*.txt', '*.pt', '*.pot', '*.po', '*.mo',
                         '*.png', '*.gif', '*.jpeg', '*.jpg', '*.css', '*.js']},
      zip_safe=False,
      # uncomment this to be able to run tests with setup.py
      test_suite="pyams_utils.tests.test_utilsdocs.test_suite",
      tests_require=tests_require,
      extras_require=dict(test=tests_require),
      install_requires=[
          'setuptools',
          # -*- Extra requirements: -*-
          'babel',
          'beaker',
          'BTrees',
          'chameleon',
          'docutils',
          'fanstatic',
          'httplib2',
          'markdown',
          'persistent',
          'pygments',
          'pyramid',
          'pyramid_zodbconn',
          'pyramid_zope_request',
          'pysocks',
          'pytz',
          'transaction',
          'venusian',
          'z3c.form',
          'z3c.pt',
          'z3c.ptcompat',
          'ZEO',
          'ZODB',
          'zope.annotation',
          'zope.component',
          'zope.container',
          'zope.contentprovider',
          'zope.datetime',
          'zope.dublincore',
          'zope.interface',
          'zope.intid',
          'zope.keyreference',
          'zope.lifecycleevent',
          'zope.location',
          'zope.publisher',
          'zope.schema',
          'zope.site',
          'zope.traversing'
      ],
      entry_points="""
      # -*- Entry points: -*-
      [console_scripts]
      pyams_upgrade = pyams_utils.scripts.zodb:upgrade_site
      """,
      )
