#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_skin.interfaces import ISkin
from pyams_skin.layer import IPyAMSUserLayer

# import packages
from pyams_utils.request import check_request
from pyams_utils.vocabulary import vocabulary_config
from zope.componentvocabulary.vocabulary import UtilityVocabulary, UtilityTerm


@vocabulary_config(name='PyAMS skins')
class SkinsVocabulary(UtilityVocabulary):
    "PyAMS skins vocabulary"""

    interface = ISkin
    nameOnly = True

    def __init__(self, context, **kw):
        request = check_request()
        registry = request.registry
        translate = request.localizer.translate
        utils = [(name, translate(util.label))
                 for (name, util) in registry.getUtilitiesFor(self.interface)]
        self._terms = dict((title, UtilityTerm(name, title)) for name, title in utils)


@vocabulary_config(name='PyAMS user skins')
class UserSkinsVocabulary(UtilityVocabulary):
    """PyAMS custom users skins vocabulary"""

    interface = ISkin
    nameOnly = True

    def __init__(self, context, **kw):
        request = check_request()
        registry = request.registry
        translate = request.localizer.translate
        utils = [(name, translate(util.label))
                 for (name, util) in registry.getUtilitiesFor(self.interface)
                 if issubclass(util.layer, IPyAMSUserLayer)]
        self._terms = dict((title, UtilityTerm(name, title)) for name, title in utils)
