#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

# import standard library

# import interfaces
from pyams_skin.interfaces.viewlet import ITopLinksViewletManager, ITopLinksViewlet, ITopLinksMenu, \
    ITopTabsViewlet, ITopTabsTab
from pyams_skin.layer import IPyAMSLayer

# import packages
from pyams_template.template import template_config
from pyams_viewlet.manager import WeightOrderedViewletManager, TemplateBasedViewletManager, viewletmanager_config
from pyams_viewlet.viewlet import Viewlet
from zope.interface import implementer


#
# Top links viewlet manager
#

@viewletmanager_config(name='pyams.toplinks', layer=IPyAMSLayer)
@implementer(ITopLinksViewletManager)
class TopLinksViewletManager(WeightOrderedViewletManager):
    """Top links viewlet manager"""


#
# Top links viewlet
#

@template_config(template='toplinks.pt')
@implementer(ITopLinksViewlet)
class TopLinksViewlet(TemplateBasedViewletManager, WeightOrderedViewletManager, Viewlet):
    """Top links viewlet"""

    label = "Label:"
    css_class = 'top-menu'
    dropdown_label = "Dropdown label"

    def __init__(self, context, request, view, manager=None):
        WeightOrderedViewletManager.__init__(self, context, request, view)
        Viewlet.__init__(self, context, request, view, manager)

    def update(self):
        WeightOrderedViewletManager.update(self)


@implementer(ITopLinksMenu)
class TopLinksMenu(Viewlet):
    """Top link menu"""

    css_class = ""
    label = "Menu label"
    click_handler = None
    url = "#"
    data = {}

    def render(self):
        if self.css_class == 'divider':
            return '<li class="divider"></li>'
        else:
            label = self.request.localizer.translate(self.label)
            return '''<li class="{0}">
                        <a href="{1}" {2}>{3}</a>
                    </li>'''.format(self.css_class,
                                    self.url,
                                    self.get_data_attributes(),
                                    label)

    def get_data_attributes(self):
        data = self.data.copy()
        if self.click_handler:
            data.update({'data-ams-click-handler': self.click_handler})
        return ' '.join('%s=%s' % item for item in data.items())


#
# Top tabs viewlet
#

@template_config(template='toptabs.pt')
@implementer(ITopTabsViewlet)
class TopTabsViewlet(TemplateBasedViewletManager, WeightOrderedViewletManager, Viewlet):
    """Top tabs viewlet"""

    label = "Label:"
    css_class = 'top-tabs'

    def __init__(self, context, request, view, manager=None):
        WeightOrderedViewletManager.__init__(self, context, request, view)
        Viewlet.__init__(self, context, request, view, manager)

    def update(self):
        WeightOrderedViewletManager.update(self)


@implementer(ITopTabsTab)
class TopTabsTab(Viewlet):
    """Top tabs tab"""

    css_class = ""
    label = "Tab label"
    click_handler = None
    url = "#"
    data = {'data-toggle': 'tab'}

    def render(self):
        label = self.request.localizer.translate(self.label, context=self.request)
        return '''<li class="{0}">
                    <a href="{1}" {2}>{3}</a>
                </li>'''.format(self.css_class,
                                self.url,
                                self.get_data_attributes(),
                                label)

    def get_data_attributes(self):
        data = self.data.copy()
        if self.click_handler:
            data.update({'data-ams-click-handler': self.click_handler})
        return ' '.join('%s=%s' % item for item in data.iteritems())
