#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_skin.interfaces.viewlet import IShortcutsViewletManager, IShortcut
from pyams_skin.layer import IPyAMSLayer

# import packages
from pyams_template.template import template_config
from pyams_viewlet.manager import WeightOrderedViewletManager, viewletmanager_config, TemplateBasedViewletManager
from pyams_viewlet.viewlet import Viewlet
from zope.interface import implementer
from zope.schema.fieldproperty import FieldProperty


@viewletmanager_config(name='pyams.shortcuts', layer=IPyAMSLayer, provides=IShortcutsViewletManager)
@template_config(template='manager.pt', layer=IPyAMSLayer)
@implementer(IShortcutsViewletManager)
class ShortcutsViewletManager(TemplateBasedViewletManager, WeightOrderedViewletManager):
    """Shortcuts viewlet manager"""


@template_config(template='shortcut.pt', layer=IPyAMSLayer)
@implementer(IShortcut)
class Shortcut(Viewlet):
    """Shortcut viewlet"""

    bg_color_class = FieldProperty(IShortcut['bg_color_class'])
    icon_class = FieldProperty(IShortcut['icon_class'])
    label = FieldProperty(IShortcut['label'])
    url = FieldProperty(IShortcut['url'])
    target = FieldProperty(IShortcut['target'])
    modal_target = FieldProperty(IShortcut['modal_target'])
    checked = FieldProperty(IShortcut['checked'])

    def get_url(self):
        return self.url


# try:
#     import pyams_zmi
# except ImportError:
#     pass
# else:
#
#     from pyams_content import _
#
#     from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
#     from pyams_viewlet.viewlet import viewlet_config
#
#     @viewlet_config(name='admin.shortcut', manager=IShortcutsViewletManager,
#                     layer=IPyAMSLayer, permission=VIEW_SYSTEM_PERMISSION, weight=9999)
#     class ManagementInterfaceShortcut(Shortcut):
#         """Access to management interface"""
#
#         bg_color_class = 'bg-color-orangeDark'
#         icon_class = 'fa-gears'
#         label = _("Management interface")
#         url = 'admin.html'
#         target = '_blank'
#         modal_target = False
#         checked = False
