#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_skin.layer import IPyAMSLayer

# import packages
from pyams_template.template import template_config
from pyams_viewlet.viewlet import contentprovider_config


@contentprovider_config(name='pyams.site_search')
@template_config(template='site-search.pt', layer=IPyAMSLayer)
class SiteSearchViewlet(object):
    """Site search content provider"""


@contentprovider_config(name='pyams.mobile_search')
@template_config(template='mobile-search.pt', layer=IPyAMSLayer)
class MobileSearchViewlet(object):
    """Mobile search content provider"""
