#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

# import standard library

# import interfaces
from pyams_skin.interfaces.viewlet import IMainMenusViewletManager, IUserMenusViewletManager, IMenu, IMenuItem, \
    IMenuHeader
from pyams_skin.layer import IPyAMSLayer

# import packages
from pyams_template.template import template_config
from pyams_viewlet.manager import WeightOrderedViewletManager, TemplateBasedViewletManager, viewletmanager_config
from pyams_viewlet.viewlet import Viewlet
from zope.schema.fieldproperty import FieldProperty
from zope.interface import implementer


#
# Main menus viewlet manager
#

@viewletmanager_config(name='pyams.menus', layer=IPyAMSLayer, provides=IMainMenusViewletManager)
@template_config(template='manager.pt', layer=IPyAMSLayer)
class MainMenusViewletManager(TemplateBasedViewletManager, WeightOrderedViewletManager):
    """Mains menus viewlet manager"""


#
# User menus viewlet manager
#

@viewletmanager_config(name='pyams.user_menus', layer=IPyAMSLayer, provides=IUserMenusViewletManager)
@template_config(template='user-menus.pt', layer=IPyAMSLayer)
class UserMenusViewletManager(TemplateBasedViewletManager, WeightOrderedViewletManager):
    """User menus viewlet manager"""


#
# Menus group
#

@template_config(template='menu.pt', layer=IPyAMSLayer)
@implementer(IMenu)
class Menu(TemplateBasedViewletManager, WeightOrderedViewletManager, Viewlet):
    """Menu header"""

    _header = FieldProperty(IMenu['header'])

    def __init__(self, context, request, view, manager=None):
        WeightOrderedViewletManager.__init__(self, context, request, view)
        Viewlet.__init__(self, context, request, view, manager)

    @property
    def header(self):
        registry = self.request.registry
        header = registry.queryMultiAdapter((self.context, self.request, self.__parent__, self), IMenuHeader)
        if header is None:
            header = registry.queryMultiAdapter((self.context, self.request, self), IMenuHeader)
        if header is None:
            header = registry.queryMultiAdapter((self.context, self), IMenuHeader)
        if header is not None:
            return header.header
        else:
            return self._header

    def update(self):
        WeightOrderedViewletManager.update(self)

    def render(self):
        return Viewlet.render(self)


@template_config(template='menu-item.pt', layer=IPyAMSLayer)
@implementer(IMenuItem)
class MenuItem(TemplateBasedViewletManager, WeightOrderedViewletManager, Viewlet):
    """Menu viewlet"""

    css_class = FieldProperty(IMenuItem['css_class'])
    icon_class = FieldProperty(IMenuItem['icon_class'])
    label = FieldProperty(IMenuItem['label'])
    badge = FieldProperty(IMenuItem['badge'])
    badge_class = FieldProperty(IMenuItem['badge_class'])
    notice = FieldProperty(IMenuItem['notice'])
    notice_class = FieldProperty(IMenuItem['notice_class'])
    click_handler = FieldProperty(IMenuItem['click_handler'])
    url = FieldProperty(IMenuItem['url'])
    target = FieldProperty(IMenuItem['target'])
    modal_target = FieldProperty(IMenuItem['modal_target'])
    data = FieldProperty(IMenuItem['data'])

    def __init__(self, context, request, view, manager=None):
        WeightOrderedViewletManager.__init__(self, context, request, view)
        Viewlet.__init__(self, context, request, view, manager)

    def update(self):
        WeightOrderedViewletManager.update(self)

    def render(self):
        return Viewlet.render(self)

    def get_url(self):
        return self.url

    def get_data_attributes(self):
        data = self.data.copy()
        if self.click_handler:
            data.update({'data-ams-click-handler': self.click_handler})
        return ' '.join('%s=%s' % item for item in data.iteritems())


@template_config(template='menu-divider.pt', layer=IPyAMSLayer)
@implementer(IMenuItem)
class MenuDivider(Viewlet):
    """Menu divider viewlet"""

    header = None
    css_class = 'divider'
    icon_class = None
    label = None
    badge = None
    badge_class = None
    notice = None
    notice_class = None
    click_handler = None
    url = None
    target = None
    modal_target = False
    data = None

    def get_url(self):
        return None
