#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_i18n.interfaces import INegotiator
from pyams_skin.layer import IPyAMSLayer

# import packages
from pyams_i18n.language import BASE_LANGUAGES
from pyams_template.template import template_config
from pyams_utils.registry import query_utility
from pyams_viewlet.viewlet import contentprovider_config


@contentprovider_config(name='pyams.flags', layer=IPyAMSLayer)
@template_config(template='flags.pt', layer=IPyAMSLayer)
class FlagsContentProvider(object):
    """Flags content provider"""

    @property
    def langs(self):
        negotiator = query_utility(INegotiator)
        if negotiator is not None:
            return negotiator.offered_languages or (self.request.locale_name,)
        return self.request.locale_name

    def get_label(self, lang):
        translate = self.request.localizer.translate
        return translate(BASE_LANGUAGES.get(lang))

    @property
    def current(self):
        negotiator = query_utility(INegotiator)
        if negotiator is not None:
            return negotiator.get_language(self.request) or self.request.locale_name
        return self.request.locale_name
