#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_skin.interfaces.extension import IUserReportInfo, ACTIVATED_ON_FRONT, ACTIVATED_ON_BACK
from pyams_skin.interfaces.viewlet import IJSExtensionsViewletManager
from pyams_skin.layer import IPyAMSLayer
try:
    from pyams_zmi.layer import IAdminLayer
except ImportError:
    IAdminLayer = None

# import packages
from pyams_template.template import template_config
from pyams_viewlet.viewlet import viewlet_config, Viewlet


@viewlet_config(name='user-report', manager=IJSExtensionsViewletManager)
@template_config(template='templates/user_report.pt', layer=IPyAMSLayer)
class UserReportViewlet(Viewlet):
    """Google Analytics viewlet"""

    def __new__(cls, context, request, view, manager):
        info = IUserReportInfo(request.root)
        if not info.enabled:
            return None
        if IAdminLayer is None:
            if info.activation_mode == ACTIVATED_ON_BACK:
                return None
        else:
            if ((info.activation_mode == ACTIVATED_ON_FRONT) and IAdminLayer.providedBy(request)) or \
               ((info.activation_mode == ACTIVATED_ON_BACK) and not IAdminLayer.providedBy(request)):
                return None
        return Viewlet.__new__(cls)

    @property
    def config(self):
        return IUserReportInfo(self.request.root)
