#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_skin.interfaces.viewlet import IBreadcrumbItem
from pyams_skin.layer import IPyAMSLayer

# import packages
from pyams_template.template import template_config
from pyams_utils.adapter import ContextRequestAdapter
from pyams_utils.url import absolute_url
from pyams_viewlet.viewlet import contentprovider_config, ViewContentProvider
from pyramid.location import lineage
from zope.interface import implementer, Interface
from zope.schema.fieldproperty import FieldProperty


@implementer(IBreadcrumbItem)
class BreadcrumbItem(ContextRequestAdapter):
    """Breadcrumb item"""

    label = FieldProperty(IBreadcrumbItem['label'])
    css_class = FieldProperty(IBreadcrumbItem['css_class'])
    view_name = FieldProperty(IBreadcrumbItem['view_name'])

    @property
    def url(self):
        return absolute_url(self.context, self.request, self.view_name)


class BreadcrumbAdminLayerItem(BreadcrumbItem):
    """Breadcrumb item for admin layer"""

    view_name = 'admin'


@contentprovider_config(name='pyams.breadcrumbs', layer=IPyAMSLayer, view=Interface)
@template_config(template='breadcrumbs.pt', layer=IPyAMSLayer)
class BreadcrumbsContentProvider(ViewContentProvider):
    """Breadcrumbs content provider"""

    @property
    def items(self):
        registry = self.request.registry
        for context in reversed(tuple(lineage(self.context))):
            item = registry.queryMultiAdapter((context, self.request, self.view), IBreadcrumbItem)
            if item is None:
                item = registry.queryMultiAdapter((context, self.request), IBreadcrumbItem)
                if item is None:
                    item = registry.queryAdapter(context, IBreadcrumbItem)
            if item is not None:
                yield item
