#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library
from datetime import datetime

from babel.dates import format_datetime
# import interfaces
from pyams_skin.interfaces.viewlet import IActivityViewletManager, IActivityViewlet
from pyams_skin.layer import IPyAMSLayer

# import packages
from pyams_template.template import template_config
from pyams_utils.date import format_datetime
from pyams_viewlet.manager import TemplateBasedViewletManager, WeightOrderedViewletManager, viewletmanager_config
from pyams_viewlet.viewlet import Viewlet
from zope.interface import implementer
from zope.schema.fieldproperty import FieldProperty

from pyams_skin import _


@viewletmanager_config(name='pyams.activity', layer=IPyAMSLayer, provides=IActivityViewletManager)
@template_config(template='manager.pt', layer=IPyAMSLayer)
class ActivityViewletManager(TemplateBasedViewletManager, WeightOrderedViewletManager):
    """Activity viewlet manager"""

    header = FieldProperty(IActivityViewletManager['header'])
    message = FieldProperty(IActivityViewletManager['message'])
    loading_text = FieldProperty(IActivityViewletManager['loading_text'])
    refresh_handler = FieldProperty(IActivityViewletManager['refresh_handler'])

    update_time = _("Last update: {0}")

    def get_last_update(self):
        translate = self.request.localizer.translate
        return translate(self.update_time).format(format_datetime(datetime.utcnow(),
                                                                  request=self.request))


@implementer(IActivityViewlet)
class ActivityViewlet(Viewlet):
    """Activity viewlet panel"""

    name = FieldProperty(IActivityViewlet['name'])
    label = FieldProperty(IActivityViewlet['label'])
    url = FieldProperty(IActivityViewlet['url'])
    click_handler = FieldProperty(IActivityViewlet['click_handler'])

    def get_url(self):
        return self.url
