#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_skin.interfaces import IContextTitlePrefix
from pyams_skin.interfaces.configuration import IBackOfficeConfiguration
from pyams_skin.layer import IPyAMSLayer

# import packages
from pyams_utils.adapter import adapter_config, ContextRequestAdapter
from zope.interface import Interface


@adapter_config(context=(Interface, IPyAMSLayer), provides=IContextTitlePrefix)
class ContextTitlePrefixAdapter(ContextRequestAdapter):
    """Context title prefix adapter"""

    @property
    def prefix(self):
        configuration = IBackOfficeConfiguration(self.request.root, None)
        if configuration is not None:
            return configuration.short_title
