/**
 * MyAMS XML-RPC features
 */
(function($, globals) {

	var MyAMS = globals.MyAMS,
		ams = MyAMS;

	MyAMS.xmlrpc = {

		/**
		 * Get address relative to current page
		 */
		getAddr: function(addr) {
			var href = addr || $('HTML HEAD BASE').attr('href') || window.location.href;
			var target = href.replace(/\+\+skin\+\+\w+\//, '');
			return target.substr(0, target.lastIndexOf("/") + 1);
		},

		/**
		 * Execute given XML-RPC post on given method
		 *
		 * Parameters:
		 *  - @url: base method URL
		 *  - @method: name of JSON-RPC procedure to call
		 *  - @options: additional JSON-RPC procedure parameters
		 *  - @callback: name of a callback which will be called on server response
		 */
		post: function(url, method, data, options, callback) {
			ams.ajax.check($.xmlrpc,
						   ams.baseURL + 'ext/jquery-xmlrpc' + ams.devext + '.js',
						   function() {
								if (typeof(options) === 'function') {
									callback = options;
									options = {};
								}
								else if (!options) {
									options = {};
								}
								if (typeof(callback) === 'undefined') {
									callback = options.callback;
								}
								if (typeof(callback) === 'string') {
									callback = ams.getFunctionByName(callback);
								}
								delete options.callback;

								var result;
								var defaults = {
									url: ams.xmlrpc.getAddr(url),
									methodName: method,
									params: data,
									success: callback || function(response /*, status, xhr*/) {
										result = response;
									},
									error: ams.error.show
								};
								var settings = $.extend({}, defaults, options);
								$.xmlrpc(settings);
								return result;
						   });
		}
	};

})(jQuery, this);
