/**
 * MyAMS tree management
 */
(function($, globals) {

	var MyAMS = globals.MyAMS,
		ams = MyAMS;

	MyAMS.tree = {

		/**
		 * Open close tree node inside a table
		 */
		switchTableNode: function() {

			function removeChildNodes(node_id) {
				$('tr[data-ams-tree-node-parent-id="' + node_id + '"]').each(function() {
					var row = $(this);
					removeChildNodes(row.data('ams-tree-node-id'));
					row.remove();
				})
			}

			var node = $(this);
			var switcher = $('i.switch', node);
			var tr = node.parents('tr').first();
			var table = tr.parents('table').first();
			if (switcher.hasClass('fa-minus-square-o')) {
				removeChildNodes(tr.data('ams-tree-node-id'));
				switcher.removeClass('fa-minus-square-o')
						.addClass('fa-plus-square-o');
			} else {
				var location = tr.data('ams-location') || table.data('ams-location') || '';
				var treeNodesTarget = tr.data('ams-tree-nodes-target') || table.data('ams-tree-nodes-target') || 'get-tree-nodes.json';
				var sourceName = tr.data('ams-element-name');
				switcher.removeClass('fa-plus-square-o')
						.addClass('fa-cog fa-spin');
				MyAMS.ajax.post(location + '/' + sourceName + '/' + treeNodesTarget, {
					can_sort: !$('td.sorter', tr).is(':empty')
				}, function(result, status) {
					if (result.length > 0) {
						var old_row = tr;
						for (var index = 0; index < result.length; index++) {
							var new_row = $(result[index]);
							new_row.insertAfter(old_row)
								   .addClass('no-drag-handle');
							ams.initContent(new_row);
							old_row = new_row;
						}
						if (table.hasClass('table-dnd')) {
							table.tableDnDUpdate();
						}
					}
					switcher.removeClass('fa-cog fa-spin')
							.addClass('fa-minus-square-o');
				});
			}
		},

		/**
		 * Open close all tree nodes
		 */
		switchTree: function() {
			var th = $(this);
			var switcher = $('i.switch', th);
			var table = $(this).parents('table').first();
			var tableID = table.data('ams-tree-node-id');
			if (switcher.hasClass('fa-minus-square-o')) {
				$('tr[data-ams-tree-node-parent-id]').filter('tr[data-ams-tree-node-parent-id!="' + tableID + '"]').remove();
				$('i.switch', table).removeClass('fa-minus-square-o')
									.addClass('fa-plus-square-o');
			} else {
				var tr = $('tbody tr', table).first();
				var location = table.data('ams-location') || '';
				var target = table.data('ams-tree-nodes-target') || 'get-tree.json';
				switcher.removeClass('fa-plus-square-o')
						.addClass('fa-cog fa-spin');
				MyAMS.ajax.post(location + '/' + target, {
					can_sort: !$('td.sorter', tr).is(':empty')
				}, function(result, status) {
					$('tr[data-ams-tree-node-id]', table).remove();
					var old_row = null;
					for (var index = 0; index < result.length; index++) {
						var new_row = $(result[index]);
						if (old_row === null) {
							new_row.appendTo($('tbody', table));
						} else {
							new_row.insertAfter(old_row);
						}
						new_row.addClass('no-drag-handle');
						ams.initContent(new_row);
						old_row = new_row;
					}
					if (table.hasClass('table-dnd')) {
						table.tableDnDUpdate();
					}
					$('i.switch', table).removeClass('fa-plus-square-o')
										.addClass('fa-minus-square-o');
					switcher.removeClass('fa-cog fa-spin')
							.addClass('fa-minus-square-o');
				});
			}
		},

		/**
		 * Sort and re-parent tree elements
		 */
		sortTree: function(dnd_table, row) {
			var data = $(dnd_table).data();
			var target = data.amsTabledndDropTarget;
			if (target) {
				// Disable row click handler
				row = $(row);
				row.data('ams-disabled-handlers', 'click');
				try {
					// Get root ID
					var tableID = row.parents('table').first().data('ams-tree-node-id');
					// Get moved row ID
					var rowID = row.data('ams-tree-node-id');
					var rowParentID = row.data('ams-tree-node-parent-id');
					// Get new parent ID
					var parent = row.prev('tr');
					if (parent.exists()) {
						// Move below an existing row
						var parentID = parent.data('ams-tree-node-id');
						// Check switcher state
						var switcher = $('.switch', parent);
						if (switcher.hasClass('fa-minus-square-o')) {
							// Opened folder: move as child
							if (rowParentID === parentID) {
								// Don't change parent
								var action = 'reorder';
							} else {
								// Change parent
								action = 'reparent';
							}
						} else {
							// Closed folder or simple item: move as sibling
							parentID = parent.data('ams-tree-node-parent-id');
							if (rowParentID === parentID) {
								// Don't change parent
								action = 'reorder';
							} else {
								// Change parent
								action = 'reparent';
							}
						}
					} else {
						// Move to site root
						parentID = tableID;
						switcher = null;
						if (rowParentID === parentID) {
							// Already child of site root
							action = 'reorder';
						} else {
							// Move from inner folder to site root
							action = 'reparent';
						}
					}
					// Call ordering target
					var localTarget = ams.getFunctionByName(target);
					if (typeof(localTarget) === 'function') {
						localTarget.call(table, dnd_table, post_data);
					} else {
						if (!target.startsWith(window.location.protocol)) {
							var location = data.amsLocation;
							if (location) {
								target = location + '/' + target;
							}
						}
						var post_data = {
							action: action,
							child: rowID,
							parent: parentID,
							order: JSON.stringify($('tr[data-ams-tree-node-id]').listattr('data-ams-tree-node-id')),
							can_sort: !$('td.sorter', row).is(':empty')
						};
						ams.ajax.post(target, post_data, function(result) {

							function removeChildRows(rowID) {
								var childs = $('tr[data-ams-tree-node-parent-id="' + rowID + '"]');
								childs.each(function() {
									var childRow = $(this);
									var childID = childRow.attr('data-ams-tree-node-id');
									removeChildRows(childID);
									childRow.remove();
								});
							}

							if (result.status) {
								ams.ajax.handleJSON(result);
							} else {
								// Remove moved row childrens
								var body = $(row).parents('tbody').first();
								removeChildRows(rowID);
								if (post_data.action === 'reparent') {
									// Remove new parent childrens
									removeChildRows(parentID);
									row.remove();
									var old_row = $('tr[data-ams-tree-node-id="' + parentID + '"]');
									for (var index = 0; index < result.length; index++) {
										var new_row = $(result[index]);
										if (old_row.exists()) {
											new_row.insertAfter(old_row)
												.addClass('no-drag-handle');
										} else {
											new_row.prependTo(body)
												.addClass('no-drag-handle');
										}
										ams.initContent(new_row);
										old_row = new_row;
									}
								}
								$('tr').parents('table').tableDnDUpdate();
							}
						});
					}
				} finally {
					// Restore row click handler
					setTimeout(function() {
						$(row).removeData('ams-disabled-handlers');
					}, 50);
				}
			}
			return false;
		}
	};

})(jQuery, this);
