/**
 * MyAMS stats management
 */
(function($, globals) {

	var MyAMS = globals.MyAMS,
		ams = MyAMS;

	MyAMS.stats = {

		/**
		 * Log current or specified page load
		 */
		logPageview: function(url) {
			if (typeof(globals._gaq) === 'undefined') {
				return;
			}
			var location = globals.window.location;
			globals._gaq.push(['_trackPageview', url || location.pathname + location.hash]);
		},

		/**
		 * Send event to Google Analytics platform
		 *
		 * @param category
		 * @param action
		 * @param label
		 */
		logEvent: function(category, action, label) {
			if (typeof(globals._gaq) === 'undefined') {
				return;
			}
			if (typeof(category) === 'object') {
				action = category.action;
				label = category.label;
				category = category.category;
			}
			globals._gaq.push(['_trackEvent', category, action, label]);
		}
	};

})(jQuery, this);
