/**
 * MyAMS menus management
 */
(function($, globals) {

	var MyAMS = globals.MyAMS,
		ams = MyAMS;

	$.fn.extend({

		/**
		 * Context menu handler
		 */
		contextMenu: function(settings) {

			function getMenuPosition(mouse, direction, scrollDir) {
				var win = $(window)[direction](),
					menu = $(settings.menuSelector)[direction](),
					position = mouse;
				// opening menu would pass the side of the page
				if (mouse + menu > win && menu < mouse) {
					position -= menu;
				}
				return position;
			}

			return this.each(function () {

				// Open context menu
				$('a', $(settings.menuSelector)).each(function() {
					$(this).data('ams-context-menu', true);
				});
				$(this).on("contextmenu", function (e) {
					// return native menu if pressing control
					if (e.ctrlKey) {
						return;
					}
					// open menu
					$(settings.menuSelector).data("invokedOn", $(e.target))
											.show()
											.css({
												position: 'fixed',
												left: getMenuPosition(e.clientX, 'width', 'scrollLeft') - 10,
												top: getMenuPosition(e.clientY, 'height', 'scrollTop') - 10
											})
											.off('click')
											.on('click', function (e) {
												$(this).hide();
												var invokedOn = $(this).data("invokedOn");
												var selectedMenu = $(e.target);
												settings.menuSelected.call(this, invokedOn, selectedMenu);
												ams.event.stop(e);
											});
					return false;
				});

				// make sure menu closes on any click
				$(document).click(function () {
					$(settings.menuSelector).hide();
				});
			});
		},

		/*
		 * Main menus manager
		 */
		myams_menu: function(options) {
			// Extend our default options with those provided
			var defaults = {
				accordion : true,
				speed : 200,
				closedSign : '<em class="fa fa-angle-down"></em>',
				openedSign : '<em class="fa fa-angle-up"></em>'
			};
			var settings = $.extend({}, defaults, options);

			// Assign current element to variable, in this case is UL element
			var menu = $(this);

			// Add a mark [+] to a multilevel menu
			menu.find("LI").each(function() {
				var menuItem = $(this);
				if (menuItem.find("UL").size() > 0) {

					// add the multilevel sign next to the link
					menuItem.find("A:first")
							 .append("<b class='collapse-sign'>" + settings.closedSign + "</b>");

					// avoid jumping to the top of the page when the href is an #
					var firstLink = menuItem.find("A:first");
					if (firstLink.attr('href') === "#") {
						firstLink.click(function() {
							return false;
						});
					}
				}
			});

			// Open active level
			menu.find("LI.active").each(function() {
				var activeParent = $(this).parents('UL');
				var activeItem = activeParent.parent('LI');
				activeParent.slideDown(settings.speed);
				activeItem.find("b:first").html(settings.openedSign);
				activeItem.addClass("open");
			});

			menu.find("LI A").on('click', function() {
				var link = $(this);
				if (link.hasClass('active')) {
					return;
				}
				var href = link.attr('href').replace(/^#/,'');
				var parentUL = link.parent().find("UL");
				if (settings.accordion) {
					var parents = link.parent().parents("UL");
					var visible = menu.find("UL:visible");
					visible.each(function(visibleIndex) {
						var close = true;
						parents.each(function(parentIndex) {
							if (parents[parentIndex] === visible[visibleIndex]) {
								close = false;
								return false;
							}
						});
						if (close) {
							if (parentUL !== visible[visibleIndex]) {
								var visibleItem = $(visible[visibleIndex]);
								if (href || !visibleItem.hasClass('active')) {
									visibleItem.slideUp(settings.speed, function () {
										$(this).parent("LI")
											   .removeClass('open')
											   .find("B:first")
											   .delay(settings.speed)
											   .html(settings.closedSign);
									});
								}
							}
						}
					});
				}
				var firstUL = link.parent().find("UL:first");
				if (!href && firstUL.is(":visible") && !firstUL.hasClass("active")) {
					firstUL.slideUp(settings.speed, function() {
						link.parent("LI")
							.removeClass("open")
							.find("B:first")
							.delay(settings.speed)
							.html(settings.closedSign);
					});
				} else /*if (link.attr('href') !== location.hash)*/ {
					firstUL.slideDown(settings.speed, function() {
						link.parent("LI")
							.addClass("open")
							.find("B:first")
							.delay(settings.speed)
							.html(settings.openedSign);
					});
				}
			});
		}
	});

})(jQuery, this);
