/**
 * MyAMS JSON-RPC features
 */
(function($, globals) {

	var MyAMS = globals.MyAMS,
		ams = MyAMS;

	MyAMS.jsonrpc = {

		/**
		 * Get address relative to current page
		 */
		getAddr: function(addr) {
			var href = addr || $('HTML HEAD BASE').attr('href') || window.location.href;
			var target = href.replace(/\+\+skin\+\+\w+\//, '');
			return target.substr(0, target.lastIndexOf("/") + 1);
		},

		/**
		 * Execute JSON-RPC request on given method
		 *
		 * Query can be given as a simple "query" string or as an object containing all query parameters.
		 * Parameters:
		 *  - @query: query string (posted as "query" parameter) or object containing all parameters
		 *  - @method: name of JSON-RPC procedure to call
		 *  - @options: additional JSON-RPC procedure parameters
		 *  - @callback: name of a callback which will be called on server response
		 */
		query: function(query, method, options, callback) {
			ams.ajax.check($.jsonRPC,
						   ams.baseURL + 'ext/jquery-jsonrpc' + ams.devext + '.js',
						   function() {
								if (typeof(options) === 'function') {
									callback = options;
									options = {};
								}
								else if (!options) {
									options = {};
								}
								if (callback === 'undefined') {
									callback = options.callback;
								}
								if (typeof(callback) === 'string') {
									callback = ams.getFunctionByName(callback);
								}
								delete options.callback;

								var params = {};
								if (typeof(query) === 'string') {
									params.query = query;
								} else if (typeof(query) === 'object') {
									$.extend(params, query);
								}
								$.extend(params, options);

								var result;
								var defaults = {
									id: new Date().getTime(),
									params: params,
									success: callback || function(data) {
										result = data;
									},
									error: ams.error.show
								};
								var settings = $.extend({}, defaults, options);
								$.jsonRPC.withOptions({
									endPoint: ams.jsonrpc.getAddr(options.url),
									namespace: options.namespace,
									cache: false
								}, function() {
									$.jsonRPC.request(method, settings);
								});
								return result;
						   });
		},

		/**
		 * Execute given JSON-RPC post on given method
		 *
		 * Parameters:
		 *  - @method: name of JSON-RPC procedure to call
		 *  - @options: additional JSON-RPC method call parameters
		 *  - @callback: name of a callback which will be called on server response
		 */
		post: function(method, data, options, callback) {
			ams.ajax.check($.jsonRPC,
						   ams.baseURL + 'ext/jquery-jsonrpc' + ams.devext + '.js',
						   function() {
								if (typeof(options) === 'function') {
									callback = options;
									options = {};
								}
								else if (!options) {
									options = {};
								}
								if (typeof(callback) === 'undefined') {
									callback = options.callback;
								}
								if (typeof(callback) === 'string') {
									callback = ams.getFunctionByName(callback);
								}
								delete options.callback;

								var result;
								var defaults = {
									id: new Date().getTime(),
									params: data,
									success: callback || function(data) {
										result = data;
									},
									error: ams.error.show
								};
								var settings = $.extend({}, defaults, options);
								$.jsonRPC.withOptions({
									endPoint: ams.jsonrpc.getAddr(options.url),
									namespace: options.namespace,
									cache: false
								}, function() {
									$.jsonRPC.request(method, settings);
								});
								return result;
						   });
		}
	};

})(jQuery, this);
