/**
 * MyAMS helpers
 *
 * These helpers functions are used by several JQuery plug-in extensions.
 * They have been extracted from these extensions management code to reuse them more easily into
 * application specific callbacks.
 */
(function($, globals) {

	var MyAMS = globals.MyAMS,
		ams = MyAMS;

	MyAMS.helpers = {

		/** Sort DOM elements into selected container */
		sort: function(container, attribute) {
			if (!attribute) {
				attribute = 'weight';
			}
			var childs = container.children();
			childs.sort(function(a, b) {
				return +$(a).data(attribute) - +$(b).data(attribute);
			}).each(function() {
				container.append(this);
			});
		},

		/** Clear Select2 slection */
		select2ClearSelection: function() {
			var source = $(this);
			var label = source.parents('label').first();
			var target = source.data('ams-select2-target');
			$('[name="' + target + '"]', label).data('select2').val('');
		},

		/** Select2 selection formatter */
		select2FormatSelection: function(object, container) {
			if (!(object instanceof Array)) {
				object = [object];
			}
			$(object).each(function() {
				if (typeof(this) === 'object') {
					container.append(this.text);
				} else {
					container.append(this);
				}
			});
		},

		/** Select2 'select-all' helper */
		select2SelectAllHelper: function() {
			var source = $(this);
			var label = source.parents('label').first();
			var target = source.data('ams-select2-target');
			var input = $('[name="' + target + '"]', label);
			if (input.get(0).tagName === 'SELECT') {
				input.select2('val', $('option', input).listattr('value'));
			} else {
				input.select2('data', input.data('ams-select2-data'));
			}
		},

		/** Select2 query results callback */
		select2QueryUrlResultsCallback: function(data, page, context) {
			switch (data.status) {
				case 'error':
					ams.skin.messageBox('error', {
						title: ams.i18n.ERROR_OCCURED,
						content: '<h4>' + data.error_message + '</h4>',
						icon: "fa fa-warning animated shake",
						timeout: 10000
					});
					break;
				case 'modal':
					$(this).data('select2').dropdown.hide();
					ams.dialog.open(data.location);
					break;
				default:
					return {
						results: data.results || data,
						more: data.has_more || false,
						context: data.context
					};
			}
		},

		/** Select2 JSON-RPC success callback */
		select2QueryMethodSuccessCallback: function(data, status, options) {
			var result = data.result;
			if (typeof(result) === 'string') {
				try {
					result = JSON.parse(result);
				} catch (e) {}
			}
			switch (result.status) {
				case 'error':
					ams.skin.messageBox('error', {
						title: ams.i18n.ERROR_OCCURED,
						content: '<h4>' + result.error_message + '</h4>',
						icon: "fa fa-warning animated shake",
						timeout: 10000
					});
					break;
				case 'modal':
					$(this).data('select2').dropdown.hide();
					ams.dialog.open(result.location);
					break;
				default:
					options.callback({
						results: result.results || result,
						more: result.has_more || false,
						context: result.context
					});
			}
		},

		/** Select2 helper to automate selection change */
		select2ChangeHelper: function() {
			var source = $(this);
			var data = source.data();
			var target = $(data.amsSelect2HelperTarget);
			switch (data.amsSelect2HelperType) {
				case 'html':
					target.html('<div class="text-center"><i class="fa fa-2x fa-gear fa-spin"></i></div>');
					var params = {};
					params[data.amsSelect2HelperArgument || 'value'] = source.val();
					$.get(data.amsSelect2HelperUrl, params,
						ams.getFunctionByName(data.amsSelect2HelperCallback) || function(result) {
							if (result) {
								target.html(result);
								ams.initContent(target);
							} else {
								target.empty();
							}
						})
					.fail(function() {
						target.empty();
					});
					break;
				case 'json-rpc':
					target.html('<div class="text-center"><i class="fa fa-2x fa-gear fa-spin"></i></div>');
					ams.jsonrpc.post(data.amsSelect2HelperMethod,
									 {value: source.val()},
									 {url: data.amsSelect2HelperUrl},
									 ams.getFunctionByName(data.amsSelect2HelperCallback) || function(result) {
										if (result.result) {
											target.html(result.result);
											ams.initContent(target);
										} else {
											target.empty();
										}
									 });
					break;
				default:
					var callback = data.amsSelect2HelperCallback;
					if (callback) {
						ams.executeFunctionByName(callback, source, data);
					}
			}
		},

		/** Context menu handler */
		contextMenuHandler: function(target, menu) {
			if (menu.get(0).tagName !== 'A') {  // Icon click?
				menu = menu.parents('a').first();
			}
			var menuData = menu.data();
			if (menuData.toggle === 'modal') {
				ams.dialog.open(menu);
			} else {
				var href = menu.attr('href') || menuData.amsUrl;
				if (!href || href.startsWith('javascript') || menu.attr('target')) {
					return;
				}
				ams.event.stop();
				var hrefGetter = ams.getFunctionByName(href);
				if (typeof(hrefGetter) === 'function') {
					href = hrefGetter.call(menu, target);
				}
				if (typeof(href) === 'function') {
					// Javascript function call
					href.call(menu, target);
				} else {
					// Standard AJAX or browser URL call
					// Convert %23 chars to #
					href = href.replace(/\%23/, '#');
					target = menu.data('ams-target');
					if (target) {
						ams.form.confirmChangedForm(target, function () {
							ams.skin.loadURL(href, target, menu.data('ams-link-options'), menu.data('ams-link-callback'));
						});
					} else {
						ams.form.confirmChangedForm(function () {
							if (href.startsWith('#')) {
								if (href !== location.hash) {
									if (ams.root.hasClass('mobile-view-activated')) {
										ams.root.removeClass('hidden-menu');
										window.setTimeout(function () {
											window.location.hash = href;
										}, 150);
									} else {
										window.location.hash = href;
									}
								}
							} else {
								window.location = href;
							}
						});
					}
				}
			}
		},

		/** Datetimepicker dialog cleaner callback */
		datetimepickerDialogHiddenCallback: function() {
			$('.datepicker, .timepicker, .datetimepicker', this).datetimepicker('destroy');
		},

		/** Clear search form target when query is empty */
		clearSearchTarget: function() {
			var input = $(this);
			if (!input.val()) {
				var form = $(input).parents('form').first();
				$(form.data('ams-form-submit-target')).empty();
			}
		},

		/** Set SEO status */
		setSEOStatus: function() {
			var input = $(this);
			var progress = input.siblings('.progress').children('.progress-bar');
			var length = Math.min(input.val().length, 100);
			var status = 'success';
			if (length < 20 || length > 80) {
				status = 'danger';
			} else if (length < 40 || length > 66) {
				status = 'warning';
			}
			progress.removeClassPrefix('progress-bar')
					.addClass('progress-bar')
					.addClass('progress-bar-' + status)
					.css('width', length + '%');
		}
	};

})(jQuery, this);
