/**
 * MyAMS events management
 */
(function($, globals) {

	var MyAMS = globals.MyAMS,
		ams = MyAMS;

	MyAMS.events = {

		/**
		 * Initialize events listeners
		 *
		 * "data-ams-events-handlers" is a data attribute containing a JSON object where:
		 *  - each key is an event name
		 *  - value is a callback name.
		 * For example: data-ams-events-handlers='{"change": "MyAPP.events.changeListener"}'
		 */
		init: function(element) {
			$('[data-ams-events-handlers]', element).each(function() {
				var element = $(this);
				var handlers = element.data('ams-events-handlers');
				if (handlers) {
					for (var event in handlers) {
						if (handlers.hasOwnProperty(event)) {
							element.on(event, ams.getFunctionByName(handlers[event]));
						}
					}
				}
			});
		}
	};

})(jQuery, this);
