/**
 * MyAMS errors management
 */
(function($, globals) {

	var MyAMS = globals.MyAMS,
		ams = MyAMS;

	MyAMS.error = {

		/**
		 * Default JQuery AJAX error handler
		 */
		ajax: function(event, response, request, error) {
			/* user shouldn't be notified of aborted requests */
			if (error === 'abort') {
				return;
			}
			if (response && response.statusText && response.statusText.toUpperCase() === 'OK') {
				return;
			}
			response = ams.ajax.getResponse(response);
			if (response.contentType === 'json') {
				ams.ajax.handleJSON(response.data);
			} else {
				var title = error || event.statusText || event.type;
				var message = response.responseText;
				ams.skin.messageBox('error', {
					title: ams.i18n.ERROR_OCCURED,
					content: '<h4>' + title + '</h4><p>' + (message || '') + '</p>',
					icon: 'fa fa-warning animated shake',
					timeout: 10000
				});
			}
			if (console) {
				console.error && console.error(event);
				console.debug && console.debug(response);
			}
		},

		/**
		 * Show AJAX error
		 */
		show: function(request, status, error) {
			if (!error) {
				return;
			}
			var response = ams.ajax.getResponse(request);
			if (response.contentType === 'json') {
				ams.ajax.handleJSON(response.data);
			} else {
				ams.skin.messageBox('error', {
					title: ams.i18n.ERRORS_OCCURED,
					content: '<h4>' + status + '</h4><p>' + error + '</p>',
					icon: "fa fa-warning animated shake",
					timeout: 10000
				});
			}
			if (console) {
				console.error && console.error(error);
				console.debug && console.debug(request);
			}
		}
	};

})(jQuery, this);
