/**
 * MyAMS containers management
 */
(function($, globals) {

	var MyAMS = globals.MyAMS,
		ams = MyAMS;

	MyAMS.container = {

		/**
		 * Change container elements order
		 *
		 * This is a callback which may be used with TableDnD plug-in which allows you to
		 * change order of table rows.
		 * Rows order is stored in an hidden input which is defined in table's data attribute
		 * called 'data-ams-input-name'
		 */
		changeOrder: function(table, names) {
			var input = $('input[name="' + $(this).data('ams-input-name') + '"]', $(this));
			input.val(names.join(';'));
		},

		/**
		 * Delete an element from a container table
		 *
		 * @returns {Function}
		 */
		deleteElement: function() {
			return function() {
				var link = $(this);
				MyAMS.skin.bigBox({
					title: ams.i18n.WARNING,
					content: '<i class="text-danger fa fa-fw fa-bell"></i>&nbsp; ' + ams.i18n.DELETE_WARNING,
					status: 'info',
					buttons: ams.i18n.BTN_OK_CANCEL
				}, function(button) {
					if (button === ams.i18n.BTN_OK) {
						var tr = link.parents('tr').first();
						var table = tr.parents('table').first();
						var location = tr.data('ams-location') || table.data('ams-location') || '';
						if (location) {
							location += '/';
						}
						var deleteTarget = tr.data('ams-delete-target') || table.data('ams-delete-target') || 'delete-element.json';
						var objectName = tr.data('ams-element-name');
						MyAMS.ajax.post(location + deleteTarget, {'object_name': objectName}, function(result, status) {
							if (result.status === 'success') {
								if (table.hasClass('datatable')) {
									table.dataTable().fnDeleteRow(tr[0]);
								} else {
									tr.remove();
								}
								if (result.handle_json) {
									MyAMS.ajax.handleJSON(result);
								}
							} else {
								MyAMS.ajax.handleJSON(result);
							}
						});
					}
				});
			};
		},

		/**
		 * Switch element visibility
		 */
		switchElementVisibility: function() {
			return function() {
				var source = $(this);
				var cell = source.parents('td').first();
				var row = source.parents('tr').first();
				var table = row.parents('table');
				$('i', source).attr('class', 'fa fa-fw fa-spinner fa-pulse');
				ams.ajax.post(table.data('ams-location') + '/' +
							 (cell.data('ams-attribute-switcher') || table.data('ams-attribute-switcher')),
					{object_name: row.data('ams-element-name')},
					function(result, status) {
						if (result.visible) {
							$('i', source).attr('class', 'fa fa-fw fa-eye');
						} else {
							$('i', source).attr('class', 'fa fa-fw fa-eye-slash text-danger');
						}
					});
			}
		},

		/**
		 * Switch element attribute
		 */
		switchElementAttribute: function() {
			return function() {
				var source = $(this);
				var cell = source.parents('td').first();
				var attribute = cell.data('ams-switcher-attribute-name');
				var row = source.parents('tr').first();
				var table = row.parents('table');
				$('i', source).attr('class', 'fa fa-fw fa-spinner fa-pulse');
				ams.ajax.post(table.data('ams-location') + '/' +
							  (cell.data('ams-attribute-switcher') || table.data('ams-attribute-switcher')),
					{object_name: row.data('ams-element-name')},
					function(result, status) {
						if (result[attribute] || result['on']) {
							$('i', source).attr('class', table.data('ams-' + attribute + '-icon-on') || 'fa fa-fw fa-check-square-o');
						} else {
							$('i', source).attr('class', table.data('ams-' + attribute + '-icon-off') || 'fa fa-fw fa-check-square txt-color-silver opacity-75');
						}
					});
			}
		}
	};

})(jQuery, this);
