/**
 * MyAMS browser related features
 */
(function($, globals) {

	var MyAMS = globals.MyAMS,
		ams = MyAMS;

	MyAMS.browser = {

		/**
		 * Get IE version
		 */
		getInternetExplorerVersion: function() {
			var rv = -1;
			if (navigator.appName === "Microsoft Internet Explorer") {
				var ua = navigator.userAgent;
				var re = new RegExp("MSIE ([0-9]{1,}[.0-9]{0,})");
				if (re.exec(ua) !== null) {
					rv = parseFloat(RegExp.$1);
				}
			}
			return rv;
		},

		/**
		 * Display alert for old IE version
		 */
		checkVersion: function() {
			var msg = "You're not using Windows Internet Explorer.";
			var ver = this.getInternetExplorerVersion();
			if (ver > -1) {
				if (ver >= 8) {
					msg = "You're using a recent copy of Windows Internet Explorer.";
				} else {
					msg = "You should upgrade your copy of Windows Internet Explorer.";
				}
			}
			if (globals.alert) {
				globals.alert(msg);
			}
		},

		/**
		 * Check if IE is in version 8 or lower
		 */
		isIE8orlower: function() {
			var msg = "0";
			var ver = this.getInternetExplorerVersion();
			if (ver > -1) {
				if (ver >= 9) {
					msg = 0;
				} else {
					msg = 1;
				}
			}
			return msg;
		},


		/**
		 * Copy selection to clipboard
		 *
		 * If 'text' argument is provided, given text is copied to clipboard.
		 * Otherwise, text ou event's source is copied.
		 * Several methods are tested to do clipboard copy (based on browser features); il copy can't be done,
		 * a prompt is displayed to allow user to make a manual copy.
		 */
		copyToClipboard: function(text) {

			function doCopy(text) {
				var copied = false;
				if (window.clipboardData && window.clipboardData.setData) {
					// IE specific code
					copied = clipboardData.setData("Text", text);
				} else if (document.queryCommandSupported && document.queryCommandSupported("copy")) {
					var textarea = $("<textarea>");
					textarea.val(text);
					textarea.css('position', 'fixed');  // Prevent scrolling to bottom of page in MS Edge.
					textarea.appendTo($('body'));
					textarea.get(0).select();
					try {
						document.execCommand("copy");  // Security exception may be thrown by some browsers.
						copied = true;
					} catch (ex) {
						if (console) {
							console.warn && console.warn("Copy to clipboard failed.", ex);
						}
					} finally {
						textarea.remove();
					}
				}
				if (copied) {
					ams.skin.smallBox('success',
									  {
										  title: text.length > 1
											  ? ams.i18n.CLIPBOARD_TEXT_COPY_OK
											  : ams.i18n.CLIPBOARD_CHARACTER_COPY_OK,
										  icon: 'fa fa-fw fa-info-circle font-xs align-top margin-top-10',
										  timeout: 3000
									  });
				} else if (globals.prompt) {
					globals.prompt(MyAMS.i18n.CLIPBOARD_COPY, text);
				}
			}

			if (text === undefined) {
				return function() {
					var source = $(this);
					var text = source.text();
					source.parents('.btn-group').removeClass('open');
					doCopy(text);
				};
			} else {
				doCopy(text);
			}
		}
	};

})(jQuery, this);
