(function($, globals) {

	'use strict';

	var MyAMS = globals.MyAMS;

	if ($.datepicker) {
		var locale = {
			closeText: 'Fermer',
			prevText: 'Précédent',
			nextText: 'Suivant',
			currentText: 'Aujourd\'hui',
			monthNames: ['janvier', 'février', 'mars', 'avril', 'mai', 'juin',
				'juillet', 'août', 'septembre', 'octobre', 'novembre', 'décembre'],
			monthNamesShort: ['janv.', 'févr.', 'mars', 'avril', 'mai', 'juin',
				'juil.', 'août', 'sept.', 'oct.', 'nov.', 'déc.'],
			dayNames: ['dimanche', 'lundi', 'mardi', 'mercredi', 'jeudi', 'vendredi', 'samedi'],
			dayNamesShort: ['dim.', 'lun.', 'mar.', 'mer.', 'jeu.', 'ven.', 'sam.'],
			dayNamesMin: ['D','L','M','M','J','V','S'],
			weekHeader: 'Sem.',
			dateFormat: 'dd/mm/yy',
			firstDay: 1,
			isRTL: false,
			showMonthAfterYear: false,
			yearSuffix: ''
		};
		$.datepicker.setDefaults(locale);
	}


	$.extend(MyAMS.i18n, {

		INFO: "Information",
		WARNING: "!! ATTENTION !!",
		ERROR: "ERREUR : ",

		LOADING: "Chargement en cours...",
		PROGRESS: "Traitement en cours",

		WAIT: "Veuillez patienter...",
		FORM_SUBMITTED: "Vous avez déjà soumis ce formulaire !",
		NO_SERVER_RESPONSE: "Pas de réponse du serveur !",
		ERROR_OCCURED: "Une erreur s'est produite !",
		ERRORS_OCCURED: "Des erreurs se sont produites !",

		BAD_LOGIN_TITLE: "Paramètres de connexion incorrects !",
		BAD_LOGIN_MESSAGE: "Your anthentication credentials didn't allow you to open a session; " +
						   "please check your credentials or contact administrator.",

		CONFIRM: "Confirmation",
		CONFIRM_REMOVE: "La suppression de cet élément ne peut pas être annulée. Confirmez-vous ?",

		CLEAR_STORAGE_TITLE: "Effacer le stockage local ?",
		CLEAR_STORAGE_CONTENT: "Le stockage local permet de mémoriser au sein de votre navigateur le paramétrage des composants sur l'ensemble de ce site.<br />" +
							   "Êtes-vous sûr(e) de vouloir effacer ces paramètres pour l'ensemble de l'application ?",

		BTN_OK: "OK",
		BTN_CANCEL: "Annuler",
		BTN_OK_CANCEL: "[OK][Annuler]",
		BTN_YES: "Oui",
		BTN_NO: "Non",
		BTN_YES_NO: "[Oui][Non]",

		CLIPBOARD_COPY: "Copier dans le presse-papier avec Ctrl+C, puis Entrée",
		CLIPBOARD_CHARACTER_COPY_OK: "Caractère copié - vous pouvez le coller dans une zone de saisie",
		CLIPBOARD_TEXT_COPY_OK: "Texte copié - vous pouvez le coller dans une zone de saisie",

		FORM_CHANGED_WARNING: "Certaines modifications n'ont pas été enregistrées.\nCes modifications seront perdues si vous quittez cette page.",
		DELETE_WARNING: "Cette suppression ne pourra pas être annulée. Êtes-vous sûr de vouloir supprimer cet élément ?",
		NO_UPDATE: "Aucune modification effectuée.",
		DATA_UPDATED: "Données enregistrées.",

		HOME: "Accueil",
		LOGOUT: "Déconnexion",
		LOGOUT_COMMENT: "Vous pouvez renforcer votre sécurité en fermant la fenêtre de ce navigateur une fois la déconnexion effectuée...",

		SELECT2_PLURAL: 's',
		SELECT2_MATCH: "Un seul résultat disponible, utilisez la touche Entrée pour le sélectionner.",
		SELECT2_MATCHES: " résultats sont disponibles, utilisez les flèches haut et bas pour naviguer.",
		SELECT2_NOMATCHES: "Pas de correspondance",
		SELECT2_SEARCHING: "Recherche...",
		SELECT2_LOADMORE: "Chargement en cours...",
		SELECT2_INPUT_TOOSHORT: "Veuillez saisir au moins {0} caractère{1}",
		SELECT2_INPUT_TOOLONG: "Veuillez supprimer {0} caractère{1}",
		SELECT2_SELECTION_TOOBIG: "Vous ne pouvez sélectionner que {0} élément{1}",
		SELECT2_FREETAG_PREFIX: "Texte libre : ",

		DT_COLUMNS: "Colonnes"

	});


	$.extend(MyAMS.plugins.i18n, {

		widgets: {
			SETTINGS_KEY_LABEL: "Réinitialiser les paramètres de ce composant ?",
			POSITION_KEY_LABEL: "Réinitialiser la position de ce composant ?",
			TIMESTAMP_FORMAT: "Dernière mise à jour: %d%/%m%/%y% %h%:%i%:%s",
			ERROR_LABEL: "Une erreur s'est produite : ",
			UPDATED_LABEL: "Dernière mise à jour : ",
			REFRESH_LABEL: "Rafraîchir",
			EDIT_BTN: "Modifier le titre",
			DELETE_BTN: "Supprimer",
			DELETE_LABEL: "Supprimer le composant : ",
			DELETE_MSG: "ATTENTION : cette action ne peut pas être annulée !",
			FULLSCREEN_BTN: "Plein écran",
			COLLAPSE_BTN: "Replier",
			REFRESH_BTN: "Recharger le contenu",
			LOADING_MSG: "Chargement..."
		},

		validate: {
			invalidformat: "Format de saisie incorrect.",
			pattern: "Format de saisie incorrect.",
			required: "Ce champ est obligatoire.",
			remote: "Veuillez corriger ce champ.",
			email: "Veuillez saisir une adresse électronique valide.",
			url: "Veuillez saisir une adresse URL valide.",
			date: "Veuillez saisir une date valide.",
			dateISO: "Veuillez saisir une date valide (format ISO).",
			number: "Veuillez saisir un nombre.",
			digits: "Veuillez saisir seulement des chiffres.",
			creditcard: "Veuillez saisir un numéro de carte de crédit valide.",
			equalTo: "Veuillez saisir exactement la même valeur.",
			notEqualTo: "Veuillez saisir une valeur différente, les valeurs ne doivent pas être identiques.",
			extension: "Veuillez saisir une valeur avec une extension valide.",
			maxlength: "Ca champ est limité à {0} caractères.",
			minlength: "Ce champ doit faire au moins {0} caractères.",
			rangelength: "Ce champ doit contenir entre {0} et {1} caractères.",
			range: "Veuillez saisir une valeur entre {0} et {1}.",
			max: "Veuillez saisir une valeur inférieure ou égale à {0}.",
			min: "Veuillez saisir une valeur supérieure ou égale à {0}.",
			step: "Veuillez saisir une valeur multiple de {0}.",
			maxWords: "Veuillez saisir au plus {0} mots.",
			minWords: "Veuillez saisir au moins {0} mots.",
			rangeWords: "Veuillez saisir entre {0} et {1} mots.",
			letterswithbasicpunc: "Veuillez saisir seulement des lettres et des signes de ponctuation.",
			alphanumeric: "Veuillez saisir seulement des lettres, nombres, espaces et soulignages.",
			lettersonly: "Veuillez saisir seulement des lettres.",
			nowhitespace: "Veuillez ne pas saisir d'espaces blancs.",
			ziprange: "Veuillez saisir un code postal entre 902xx-xxxx et 905-xx-xxxx.",
			integer: "Veuillez saisir un nombre non décimal qui est positif ou négatif.",
			vinUS: "Veuillez saisir un numéro d'identification du véhicule (VIN).",
			dateITA: "Veuillez saisir une date valide.",
			time: "Veuillez saisir une heure valide entre 00:00 et 23:59.",
			phoneUS: "Veuillez saisir un numéro de téléphone valide.",
			phoneUK: "Veuillez saisir un numéro de téléphone valide.",
			mobileUK: "Veuillez saisir un numéro de téléphone mobile valide.",
			strippedminlength: "Veuillez saisir au moins {0} caractères.",
			email2: "Veuillez saisir une adresse électronique valide.",
			url2: "Veuillez saisir une adresse URL valide.",
			creditcardtypes: "Veuillez saisir un numéro de carte de crédit valide.",
			ipv4: "Veuillez saisir une adresse IP v4 valide.",
			ipv6: "Veuillez saisir une adresse IP v6 valide.",
			require_from_group: "Veuillez saisir au moins {0} de ces champs.",
			nifES: "Veuillez saisir un numéro NIF valide.",
			nieES: "Veuillez saisir un numéro NIE valide.",
			cifES: "Veuillez saisir un numéro CIF valide.",
			postalCodeCA: "Veuillez saisir un code postal valide."
		},

		datatables: {
			sProcessing:     "Traitement en cours...",
			sSearch:         "Filtrer...",
			sLengthMenu:     "Afficher _MENU_ &eacute;l&eacute;ments par page",
			sInfo:           "Affichage des &eacute;l&eacute;ments _START_ &agrave; _END_ sur _TOTAL_",
			sInfoEmpty:      "Aucun &eacute;l&eacute;ment &agrave; afficher",
			sInfoFiltered:   "(sur un total de _MAX_)",
			sInfoPostFix:    "",
			sLoadingRecords: "Chargement en cours...",
			sZeroRecords:    "Aucun &eacute;l&eacute;ment &agrave; afficher",
			sEmptyTable:     "Aucune donnée disponible dans le tableau",
			oPaginate: {
				sFirst:      "Premier",
				sPrevious:   "Pr&eacute;c&eacute;dent",
				sNext:       "Suivant",
				sLast:       "Dernier"
			},
			sColumns:        "Colonnes",
			oAria: {
				sSortAscending:  ": activer pour trier la colonne par ordre croissant",
				sSortDescending: ": activer pour trier la colonne par ordre décroissant"
			}
		},

		fancybox: {
			ERROR: "Le contenu demandé ne peut pas être chargé.",
			RETRY: "Veuillez vérifier la requête ou ré-essayer plus tard.",
			CLOSE: "Fermer",
			NEXT: "Suivant",
			PREVIOUS: "Précédent"
		},

		dndupload: {
			FILES_SELECTED: '{count} fichiers sélectionnés',
			CHOOSE_FILE: 'Sélectionnez des fichiers',
			ADD_INFO: 'pour les ajouter au dossier courant,',
			DRAG_FILE: 'ou placez-les ici par glisser/déposer !',
			UPLOAD: 'Ajouter',
			UPLOADING: 'Chargement en cours&hellip;',
			DONE: 'Chargement terminé !!',
			UPLOAD_MORE: 'Autre téléchargement ?',
			ERROR: 'Erreur !',
			TRY_AGAIN: 'Essayer à nouveau ?'
		}

	});

})(jQuery, this);
