#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_skin.interfaces.resources import IResources
from pyams_utils.interfaces.tales import ITALESExtension
from pyramid.interfaces import IRequest

# import packages
from pyams_skin import myams
from pyams_utils.adapter import adapter_config, ContextRequestViewAdapter
from zope.interface import Interface


@adapter_config(context=(Interface, IRequest, Interface), provides=IResources)
class ResourcesAdapter(ContextRequestViewAdapter):
    """Get context resources"""

    def get_resources(self):
        myams.need()


@adapter_config(name='resources', context=(Interface, IRequest, Interface), provides=ITALESExtension)
class ResourcesTalesExtension(ContextRequestViewAdapter):
    """extension:resources TALES extension"""

    def render(self, context=None):
        if context is None:
            context = self.context
        for name, adapter in self.request.registry.getAdapters((context, self.request, self.view), IResources):
            adapter.get_resources()
        return ''
