#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_skin.interfaces import IInnerPage, IModalPage, IPageHeader, IContentTitle
from pyams_skin.layer import IPyAMSLayer

# import packages
from pyams_template.template import template_config
from pyams_utils.adapter import ContextRequestViewAdapter
from pyams_viewlet.viewlet import contentprovider_config
from zope.interface import implementer, Interface


@implementer(IInnerPage)
class InnerPage(object):
    """Inner page"""


@implementer(IModalPage)
class ModalPage(object):
    """Modal page"""


@contentprovider_config(name='content_header', view=Interface, layer=IPyAMSLayer)
@template_config(template='templates/header.pt', layer=IPyAMSLayer)
class HeaderContentProvider(object):
    """Header content provider"""

    header = None

    def update(self):
        registry = self.request.registry
        self.header = registry.queryMultiAdapter((self.context, self.request, self.view), IPageHeader)


class DefaultPageHeaderAdapter(ContextRequestViewAdapter):
    """Default page header adapter"""

    back_url = None
    back_target = None

    icon_class = 'fa fa-fw'

    @property
    def title(self):
        adapter = self.request.registry.queryMultiAdapter((self.context, self.request, self.view), IContentTitle)
        if adapter is None:
            adapter = IContentTitle(self.context, None)
        if adapter is not None:
            return adapter.title

    title_badge = None
    title_badge_class = 'badge inbox-badge bg-color-red'

    subtitle = None
    subtitle_badge = None
    subtitle_badge_class = 'badge inbox-badge bg-color-red'
