#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

# import standard library

# import interfaces
from pyams_viewlet.interfaces import IViewlet, IViewletManager

# import packages
from zope.interface import Interface, Attribute
from zope.schema import Text, TextLine, List, Object, Dict, Bool

from pyams_skin import _


#
# Top links viewlet manager
#

class ITopLinksViewletManager(IViewletManager):
    """Topo links viewlet manager interface"""


#
# Top drop-down menus viewlet
#

class ITopLinksMenu(IViewlet):
    """Top link menu"""

    css_class = TextLine(title="Menu CSS class",
                         required=False)

    label = TextLine(title="Menu label")

    click_handler = TextLine(title="Menu click handler",
                             description="Name of a Javascript function handling menu click",
                             required=False)

    url = TextLine(title="Menu link target")

    data = Dict(title="Menu data attributes",
                key_type=TextLine(),
                value_type=TextLine())


class ITopLinksViewlet(IViewlet):
    """Top links viewlet"""

    label = TextLine(title="Main label")

    dropdown_label = TextLine(title="Drop-down menu label")

    css_class = TextLine(title="Main CSS class")

    viewlets = List(title="Top links menu",
                    value_type=Object(schema=ITopLinksMenu))


#
# Top tabs viewlet
#

class ITopTabsTab(IViewlet):
    """Top tabs tab"""

    css_class = TextLine(title="Tab CSS class",
                         required=False)

    label = TextLine(title="Tab label")

    click_handler = TextLine(title="Tab click handler",
                             description="Name of a Javascript function handling tab click",
                             required=False)

    url = TextLine(title="Tab link target")

    data = Dict(title="Tab data attribrutes",
                key_type=TextLine(),
                value_type=TextLine())


class ITopTabsViewlet(IViewlet):
    """Top tabs viewlet"""

    label = TextLine(title="Main label")

    css_class = TextLine(title="Main CSS class")

    viewlets = List(title="Top tabs items",
                    value_type=Object(schema=ITopTabsTab))


#
# Shortcuts viewlet manager
#

class IShortcutsViewletManager(IViewletManager):
    """Shortcuts viewlet manager"""


class IShortcut(IViewlet):
    """Shortcut viewlet interface"""

    bg_color_class = TextLine(title="Shortcut CSS class")

    icon_class = TextLine(title="Shortcut icon class")

    label = TextLine(title="Shortcut title")

    url = TextLine(title="Shortcut target URL")

    target = TextLine(title="Window target",
                      required=False)

    modal_target = Bool(title="Modal target",
                        required=True,
                        default=True)

    checked = TextLine(title="Checked shortcut class",
                       required=False)

    def get_url(self):
        """Return shortcut absolute URL"""


#
# Menus viewlet manager
#

class IMainMenusViewletManager(IViewletManager):
    """Main menus viewlet manager"""


class IUserMenusViewletManager(IViewletManager):
    """User menus viewlet manager"""


class IMenu(IViewlet):
    """Menu interface"""

    header = TextLine(title="Menu header",
                      required=False)


class IMenuHeader(Interface):
    """Menu header interface"""

    header = TextLine(title="Menu header",
                      required=False)


class IMenuItem(IViewlet):
    """Menu item interface

    A menu is a viewlet as well as a viewlets manager,
    containing sub-menus
    """

    css_class = TextLine(title="CSS class",
                         required=False)

    icon_class = TextLine(title="Icon CSS class",
                          required=False)

    label = TextLine(title="Menu title",
                     required=False)

    badge = TextLine(title="Badge text",
                     required=False)

    badge_class = TextLine(title="Badge CSS class",
                           required=False)

    notice = TextLine(title="Notice text",
                      required=False)

    notice_class = TextLine(title="Notice CSS class",
                            required=False)

    click_handler = TextLine(title="Menu click handler",
                             required=False)

    url = TextLine(title="Menu link location",
                   required=False,
                   default=u'#')

    target = TextLine(title="Menu link window target",
                      required=False)

    modal_target = Bool(title="Modal target",
                        required=False,
                        default=False)

    data = Dict(title="Menu data attributes",
                key_type=TextLine(),
                value_type=TextLine(),
                required=False)

    def get_url(self):
        """Get menu target URL"""

    def get_data_attributes(self):
        """Get data attributes"""


#
# Breadcrumbs interfaces
#

class IBreadcrumbItem(Interface):
    """Breadcrumb item interface"""

    label = TextLine(title="Item label")

    view_name = TextLine(title="Link view name")

    css_class = TextLine(title="CSS class")

    url = Attribute("Link absolute target URL")


#
# Extensions viewlet manager
#

class IJSExtensionsViewletManager(IViewletManager):
    """Javascript extensions viewlet manager

    These extensions (like Google Analytics tracking code for example)
    can be included into layouts footer
    """


#
# Activity viewlet manager
#

class IActivityViewletManager(IViewletManager):
    """User activity viewlet manager"""

    header = TextLine(title="Initial header message")

    message = Text(title="Initial message")

    loading_text = TextLine(title="Tab loading text",
                            default=_("&lt;i class=&#39;fa fa-refresh fa-spin&#39;&gt;&lt;/i&gt;"))

    refresh_handler = TextLine(title="Refresh button click handler",
                               default="MyAMS.skin.refreshNotificationsPanel")

    def get_last_update(self):
        """Get last update time"""


class IActivityViewlet(IViewlet):
    """User activity panel viewlet"""

    name = TextLine(title="Tab input value")

    label = TextLine(title="Tab label")

    click_handler = TextLine(title="Tab click handler",
                             required=False)

    url = TextLine(title="Tab content loading URL",
                   required=False)

    def get_url(self):
        """Get menu target URL"""


#
# Widget title extensions viewlet manager
#

class IWidgetTitleViewletManager(IViewletManager):
    """Widget title viewlet manager"""


#
# Toolbar viewlet manager
#

class IToolbarViewletManager(IViewletManager):
    """Toolbar viewlet manager"""


class IToolbarViewlet(IViewlet):
    """Base interface for all toolbar viewlet"""


class IToolbarAction(IToolbarViewlet):
    """Toolbar action viewlet"""

    label = TextLine(title="Button label")

    label_css_class = TextLine(title="Label icon CSS class",
                               default='fa fa-fw fa-plus')

    css_class = TextLine(title="Button CSS class",
                         default='btn btn-xs btn-success')

    click_handler = TextLine(title="Button click handler",
                             required=False)

    url = TextLine(title="Button target URL")

    modal_target = Bool(title="Modal target?",
                        required=False,
                        default=False)

    def get_url(self):
        """Get menu target URL"""


class IToolbarMenu(IToolbarAction):
    """Toolbar actions menu"""

    label_css_class = TextLine(title="Label icon CSS class",
                               default='fa fa-fw fa-plus')

    css_class = TextLine(title="Button CSS class",
                         default='btn btn-xs btn-primary dropdown-toggle')

    menu_css_class = TextLine(title="Menu CSS class",
                              default='dropdown-menu pull-right')


class IToolbarAddingMenu(IToolbarMenu):
    """Toolbar adding actions menu"""


class ITableItemColumnActionsMenu(IViewletManager, IToolbarMenu):
    """Table item actions viewlet manager"""


class IToolbarActionItem(IToolbarAction):
    """Toolbar action menu item"""

    css_class = TextLine(title="Menu CSS class",
                         default='')

    hint_gravity = TextLine(title="Hint gravity",
                            default='sw')

    stop_propagation = Bool(title="Stop click event propagation",
                            required=True,
                            default=True)


class IToolbarMenuItem(IToolbarActionItem):
    """Toolbar menu item"""


class IContextActions(IViewletManager, IToolbarMenu):
    """Context actions viewlet manager"""

    css_class = TextLine(title="Button CSS class",
                         default='btn btn-xs btn-default dropdown-toggle')
