#
# Copyright (c) 2008-2016 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces

# import packages
from zope.interface import Interface
from zope.schema import TextLine, Bool, Choice
from zope.schema.vocabulary import SimpleVocabulary, SimpleTerm

from pyams_skin import _


ACTIVATED_ON_FRONT = 0
ACTIVATED_ON_BACK = 1
ACTIVATED_ON_BOTH = 2

ACTIVATION_MODES_LABELS = {ACTIVATED_ON_FRONT: _("Front-office only"),
                           ACTIVATED_ON_BACK: _("Back-office only"),
                           ACTIVATED_ON_BOTH: _("Front-office and back-office")}

ACTIVATION_MODES = SimpleVocabulary([SimpleTerm(k, title=v) for k, v in ACTIVATION_MODES_LABELS.items()])


GOOGLE_TAGS_INFO_KEY = 'pyams_skin.tagmanager_info'


class IGoogleTagManagerInfo(Interface):
    """Google Tag Manager account info"""

    enabled = Bool(title=_("Activate Google Tag Manager?"),
                   description=_("Is Google Tag Manager activated?"),
                   required=True,
                   default=False)

    container_id = TextLine(title=_("Container ID"),
                            description=_("Google Tag Manager container ID (may start with 'GTM-')"),
                            required=False)

    activation_mode = Choice(title=_("Activation mode"),
                             description=_("Mode(s) in which Google Tags are activated"),
                             vocabulary=ACTIVATION_MODES,
                             default=ACTIVATED_ON_BOTH,
                             required=True)


GOOGLE_ANALYTICS_INFO_KEY = 'pyams_skin.analytics_info'


class IGoogleAnalyticsInfo(Interface):
    """Google Analytics account info"""

    enabled = Bool(title=_("Activate Google Analytics?"),
                   description=_("Are Google Analytics statistics activated?"),
                   required=True,
                   default=False)

    website_id = TextLine(title=_("Web site ID"),
                          description=_("Google Analytics web site ID"),
                          required=False)

    verification_code = TextLine(title=_("Web site verification code"),
                                 description=_("Google site verification code"),
                                 required=False)

    activation_mode = Choice(title=_("Activation mode"),
                             description=_("Mode(s) in which statistics are activated"),
                             vocabulary=ACTIVATION_MODES,
                             default=ACTIVATED_ON_BOTH,
                             required=True)


USER_REPORT_INFO_KEY = 'pyams_skin.user_report_info'


class IUserReportInfo(Interface):
    """UserReport account info"""

    enabled = Bool(title=_("Activate UserReport?"),
                   description=_("Are UserReport comments and feedback activated?"),
                   required=True,
                   default=False)

    account_id = TextLine(title=_("Account ID"),
                          description=_("UserReport account ID, available in 'initSite' code snippet"),
                          required=False)

    activation_mode = Choice(title=_("Activation mode"),
                             description=_("Mode(s) in which reports are activated"),
                             vocabulary=ACTIVATION_MODES,
                             default=ACTIVATED_ON_BOTH,
                             required=True)
