#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyramid.interfaces import IView

# import packages
from zope.interface import Interface
from zope.schema import TextLine, Bool


class IContainerBaseView(IView):
    """Base container marker interface"""


class IOrderedContainerBaseView(Interface):
    """Ordered container marker interface"""


class ITable(Interface):
    """Base table interface"""

    prefix = TextLine(title="Table prefix")

    id = TextLine(title="Table ID")

    title = TextLine(title="Table title")

    click_handler = TextLine(title="Default elements click handler")


class ITableWithActions(ITable):
    """Marker interface for table with inner actions menus"""


class ITableElementName(Interface):
    """Table element name column value interface"""

    name = TextLine(title="Table element name")


class ITableElementEditor(Interface):
    """Table element editor interface"""

    view_name = TextLine(title="Table element editor name")

    url = TextLine(title="Table element editor URL")

    modal_target = Bool(title="Modal target?",
                        required=True,
                        default=True)
