#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.location.interfaces import IContained
from zope.schema import Bool, Text, TextLine

from pyams_file.schema import ImageField

from pyams_skin import _


SKIN_CONFIGURATION_KEY = 'pyams_skin.configuration'


class IConfiguration(IContained):
    """Dynamic application global configuration

    These settings are generally managed by an administrator.
    They are used by default presentation layout.
    """

    title = TextLine(title=_("Title"),
                     description=_("Application title displayed in title bar"),
                     required=False)

    short_title = TextLine(title=_("Short title"),
                           description=_("Application short title visible as title prefix"),
                           required=False)

    def get_title_prefix(self, request):
        """Get title prefix based on current navigation context"""

    description = Text(title=_("Description"),
                       description=_("Main application description"),
                       required=False)

    author = TextLine(title=_("Author"),
                      description=_("Public author name"),
                      required=False)

    icon = ImageField(title=_("Icon"),
                      description=_("Browser favourite icon"),
                      required=False)

    logo = ImageField(title=_("Logo"),
                      description=_("Image containing application logo"),
                      required=False)


SKIN_BACK_CONFIGURATION_KEY = 'pyams_skin.back-office.configuration'


class IBackOfficeConfiguration(IContained):
    """Back-office configuration"""

    title = TextLine(title=_("Title"),
                     description=_("Application title visible in back-office"),
                     required=False)

    short_title = TextLine(title=_("Short title"),
                           description=_("Application short title visible as title prefix"),
                           required=False)

    def get_title_prefix(self, request):
        """Get title prefix based on current navigation context"""

    login_header = Text(title=_("Login header"),
                        description=_("This reStructuredText text will be displayed in login page header"),
                        required=False)

    login_footer = Text(title=_("Login footer"),
                        description=_("This reStructuredText text will be displayed in login page footer"),
                        required=False)

    icon = ImageField(title=_("Icon"),
                      description=_("Browser favourite icon"),
                      required=False)

    logo = ImageField(title=_("Logo"),
                      description=_("Image containing application logo"),
                      required=False)

    login_logo = ImageField(title=_("Login logo"),
                            description=_("Image containing application logo for login form"),
                            required=False)

    display_content_icon = Bool(title=_("Display title icon?"),
                                description=_("Should icons be displayed into content's title area ?"),
                                required=True,
                                default=True)

    display_shared_tool_title = Bool(title=_("Display shared tool title?"),
                                     description=_("Should shared tool title be displayed into shared content's title "
                                                   "area?"),
                                     required=True,
                                     default=True)
