#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_skin.interfaces import IContentHelp
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.interfaces.text import IHTMLRenderer

# import packages
from pyams_template.template import template_config
from pyams_utils.adapter import ContextRequestViewAdapter, adapter_config
from pyams_utils.text import text_to_html
from pyams_viewlet.viewlet import contentprovider_config
from zope.interface import implementer, Interface
from zope.schema.fieldproperty import FieldProperty


@contentprovider_config(name='content_help', view=Interface, layer=IPyAMSLayer)
@template_config(template='templates/help.pt', layer=IPyAMSLayer)
class HelpContentProvider(object):
    """Help content provider"""

    help = None

    def update(self):
        registry = self.request.registry
        self.help = registry.queryMultiAdapter((self.context, self.request, self.view), IContentHelp)


@implementer(IContentHelp)
class ContentHelp(ContextRequestViewAdapter):
    """Content help"""

    outer_margin = FieldProperty(IContentHelp['outer_margin'])
    status = FieldProperty(IContentHelp['status'])
    header = FieldProperty(IContentHelp['header'])
    message = FieldProperty(IContentHelp['message'])
    message_format = FieldProperty(IContentHelp['message_format'])


@adapter_config(context=(IContentHelp, IPyAMSLayer, Interface), provides=IHTMLRenderer)
class HelpRenderer(ContextRequestViewAdapter):
    """Help renderer"""

    def render(self, **kwargs):
        message = self.request.localizer.translate(self.context.message)
        return text_to_html(message, self.context.message_format)
