#
# Copyright (c) 2008-2016 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_skin.interfaces.extension import \
    IGoogleAnalyticsInfo, GOOGLE_ANALYTICS_INFO_KEY, \
    IUserReportInfo, USER_REPORT_INFO_KEY, IGoogleTagManagerInfo, GOOGLE_TAGS_INFO_KEY
from pyams_utils.interfaces.site import ISiteRoot

# import packages
from persistent import Persistent
from pyams_utils.adapter import adapter_config, get_annotation_adapter
from zope.interface import implementer
from zope.schema.fieldproperty import FieldProperty


@implementer(IGoogleTagManagerInfo)
class GoogleTagManagerInfo(Persistent):
    """Google tag manager settings class"""

    enabled = FieldProperty(IGoogleTagManagerInfo['enabled'])
    container_id = FieldProperty(IGoogleTagManagerInfo['container_id'])
    activation_mode = FieldProperty(IGoogleTagManagerInfo['activation_mode'])


@adapter_config(context=ISiteRoot, provides=IGoogleTagManagerInfo)
def google_tag_manager_info_factory(context):
    """Google Tag Manager settings factory"""
    return get_annotation_adapter(context, GOOGLE_TAGS_INFO_KEY, GoogleTagManagerInfo,
                                  notify=False, locate=False)


@implementer(IGoogleAnalyticsInfo)
class GoogleAnalyticsInfo(Persistent):
    """Google Analytics settings class"""

    enabled = FieldProperty(IGoogleAnalyticsInfo['enabled'])
    website_id = FieldProperty(IGoogleAnalyticsInfo['website_id'])
    verification_code = FieldProperty(IGoogleAnalyticsInfo['verification_code'])
    activation_mode = FieldProperty(IGoogleAnalyticsInfo['activation_mode'])


@adapter_config(context=ISiteRoot, provides=IGoogleAnalyticsInfo)
def google_analytics_info_factory(context):
    """Google Analytics settings factory"""
    return get_annotation_adapter(context, GOOGLE_ANALYTICS_INFO_KEY, GoogleAnalyticsInfo,
                                  notify=False, locate=False)


@implementer(IUserReportInfo)
class UserReportInfo(Persistent):
    """User report settings class"""

    enabled = FieldProperty(IUserReportInfo['enabled'])
    account_id = FieldProperty(IUserReportInfo['account_id'])
    activation_mode = FieldProperty(IUserReportInfo['activation_mode'])


@adapter_config(context=ISiteRoot, provides=IUserReportInfo)
def user_report_info_factory(context):
    """User report settings factory"""
    return get_annotation_adapter(context, USER_REPORT_INFO_KEY, UserReportInfo,
                                  notify=False, locate=False)
