#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


from fanstatic import Resource, Library, Group

from pyramid.i18n import TranslationStringFactory
_ = TranslationStringFactory('pyams_skin')


library = Library('pyams_skin', 'resources')


#
# CSS resources
#

bootstrap_css = Resource(library, 'css/ext/bootstrap-3.3.7.css',
                         minified='css/ext/bootstrap-3.3.7.min.css')

bootstrap_theme = Resource(library, 'css/ext/bootstrap-theme.css',
                           minified='css/ext/bootstrap-theme.min.css',
                           depends=(bootstrap_css,))

bootstrap_modal_css = Resource(library, 'css/ext/bootstrap-modal.css',
                               minified='css/ext/bootstrap-modal.min.css',
                               depends=(bootstrap_css,))

awesomefonts_css = Resource(library, 'css/ext/font-awesome-4.7.0.css',
                            minified='css/ext/font-awesome-4.7.0.min.css',
                            depends=(bootstrap_css,))

myams_css = Resource(library, 'css/myams.css',
                     minified='css/myams.min.css',
                     depends=(bootstrap_modal_css, awesomefonts_css))


#
# Javascript resources
#

jquery = Resource(library, 'js/ext/jquery-2.2.4.js',
                  minified='js/ext/jquery-2.2.4.min.js',
                  bottom=True)

jquery_ui = Resource(library, 'js/ext/jquery-ui-1.12.1.js',
                     minified='js/ext/jquery-ui-1.12.1.min.js',
                     depends=(jquery,),
                     bottom=True)

jquery_dataTables = Resource(library, 'js/ext/jquery-dataTables-1.9.4.js',
                             minified='js/ext/jquery-dataTables-1.9.4.min.js',
                             depends=(jquery,),
                             bottom=True)

jquery_dataTables_tableTools = Resource(library, 'js/ext/jquery-dataTables-tableTools.js',
                                        minified='js/ext/jquery-dataTables-tableTools.min.js',
                                        depends=(jquery_dataTables,),
                                        bottom=True)

bootstrap = Resource(library, 'js/ext/bootstrap-3.3.7.js',
                     minified='js/ext/bootstrap-3.3.7.min.js',
                     depends=(jquery, jquery_ui, bootstrap_css, bootstrap_modal_css),
                     bottom=True)

js_cookie = Resource(library, 'js/ext/js-cookie.js',
                     minified='js/ext/js-cookie.min.js',
                     bottom=True)

myams_core = Resource(library, 'js/myams-core.js',
                      minified='js/myams-core.min.js',
                      depends=(jquery,),
                      bottom=True)

myams_js = Resource(library, 'js/myams.js',
                    minified='js/myams.min.js',
                    depends=(bootstrap, js_cookie),
                    bottom=True)

myams_plugins_loader = Resource(library, 'js/myams-plugins-loader.js',
                                minified='js/myams-plugins-loader.min.js',
                                depends=(myams_js,),
                                bottom=True)


#
# Global resources
#

myams = Group(depends=[myams_css, myams_js])


def includeme(config):
    """Pyramid include"""

    # add translations
    config.add_translation_dirs('pyams_skin:locales')

    # load registry components
    config.scan()
