#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_gis.interfaces.configuration import IMapConfigurationTarget
from pyams_gis.interfaces.utility import IMapManager
from pyams_i18n.interfaces import II18n

# import packages
from pyams_utils.registry import get_utility
from pyams_utils.request import check_request
from pyams_utils.vocabulary import vocabulary_config
from zope.container.folder import Folder
from zope.interface import implementer
from zope.schema.vocabulary import SimpleVocabulary, SimpleTerm


@implementer(IMapManager, IMapConfigurationTarget)
class MapManager(Folder):
    """Map manager utility"""


@vocabulary_config(name='PyAMS map layers')
class MapLayersVocabulary(SimpleVocabulary):
    """Map manager layers vocabulary"""

    def __init__(self, context):
        request = check_request()
        manager = get_utility(IMapManager)
        super(MapLayersVocabulary, self).__init__([SimpleTerm(layer.__name__,
                                                              title=II18n(layer).query_attribute('title',
                                                                                                 request=request))
                                                   for layer in manager.values()])
