#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_gis.interfaces.utility import IMapManager
from pyams_utils.interfaces.site import ISiteGenerations

# import packages
from pyams_gis.utility import MapManager
from pyams_utils.registry import utility_config
from pyams_utils.site import check_required_utilities


REQUIRED_UTILITIES = ((IMapManager, '', MapManager, 'Maps manager'), )


@utility_config(name='PyAMS GIS', provides=ISiteGenerations)
class MapGenerationsChecker(object):
    """Maps generations checker"""

    order = 90
    generation = 1

    def evolve(self, site, current=None):
        """Check for required utilities"""
        check_required_utilities(site, REQUIRED_UTILITIES)
