/*!
 * @brief French Geoportal Extension for Leaflet
 *
 * This software is released under the licence CeCILL-B (Free BSD compatible)
 * @see http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.txt
 * @see http://www.cecill.info/licences/Licence_CeCILL-B_V1-fr.txt
 * @see http://www.cecill.info/
 *
 * @copyright copyright (c) IGN 
 * @license CeCILL-B
 * @author IGN
 * @version 2.1.7
 * @date 09/12/2020
 *
 */

/*!
 * @overview  Proj4Leaflet - Smooth Proj4js integration with Leaflet
 * @copyright Copyright (c) 2012, Kartena AB
 * @license   BSD 2-Clause "Simplified" License
 *            See https://raw.githubusercontent.com/kartena/Proj4Leaflet/master/LICENSE
 * @version 1.0.2
 */

/*!
 * @overview  leaflet-draw - Vector drawing and editing plugin for Leaflet 
 * @copyright Copyright (c) 2012-2017 Jon West, Jacob Toye, and Leaflet
 * @license   Licensed under MIT license
 *            See https://raw.githubusercontent.com/Leaflet/Leaflet.draw/master/MIT-LICENSE.md
 * @version   1.0.4
 */

/*!
 * Sortable -- JavaScript library for reorderable drag-and-drop lists on modern
 * browsers and touch devices. No jQuery required. Supports Meteor, AngularJS,
 * React, Polymer, Vue, Knockout and any CSS library, e.g. Bootstrap.
 *
 * Released under MIT LICENSE
 *
 * Copyright Lebedev Konstantin <ibnRubaXa@gmail.com>
 * https://github.com/SortableJS/Sortable
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * @version 1.8.4
 */

/*!
 * @overview  es6-promise - a tiny implementation of Promises/A+.
 * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
 * @license   Licensed under MIT license
 *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
 * @version   v4.2.4
 */

/*!
 * @overview   Proj4js - Javascript reprojection library.
 *
 * @authors
 * - Mike Adair madairATdmsolutions.ca
 * - Richard Greenwood richATgreenwoodmap.com
 * - Didier Richard didier.richardATign.fr
 * - Stephen Irons stephen.ironsATclear.net.nz
 * - Olivier Terral oterralATgmail.com
 * - Calvin Metcalf cmetcalfATappgeo.com
 *
 * @copyright Copyright (c) 2014, Mike Adair, Richard Greenwood, Didier Richard, Stephen Irons, Olivier Terral and Calvin Metcalf
 * @license   Licensed under MIT license
 *            See https://raw.githubusercontent.com/proj4js/proj4js/master/LICENSE.md
 * @version   ^2.6.2
 */

(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("leaflet"), require("request"), require("xmldom"));
	else if(typeof define === 'function' && define.amd)
		define("Gp", ["leaflet", "require", "require"], factory);
	else if(typeof exports === 'object')
		exports["Gp"] = factory(require("leaflet"), require("request"), require("xmldom"));
	else
		root["Gp"] = factory(root["L"], root[undefined], root[undefined]);
})(window, function(__WEBPACK_EXTERNAL_MODULE__2__, __WEBPACK_EXTERNAL_MODULE__53__, __WEBPACK_EXTERNAL_MODULE__54__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Services", function() { return Services; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Error", function() { return Error; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Helper", function() { return Helper; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Protocols", function() { return Protocols; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "servicesDate", function() { return servicesDate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "servicesVersion", function() { return servicesVersion; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "leafletExtVersion", function() { return leafletExtVersion; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "leafletExtDate", function() { return leafletExtDate; });
/* harmony import */ var _package_json__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
var _package_json__WEBPACK_IMPORTED_MODULE_0___namespace = /*#__PURE__*/__webpack_require__.t(1, 1);
/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2);
/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_1__);
/* harmony reexport (default from non-harmony) */ __webpack_require__.d(__webpack_exports__, "LExtended", function() { return leaflet__WEBPACK_IMPORTED_MODULE_1___default.a; });
/* harmony import */ var _Common_Styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3);
/* harmony import */ var _Styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(21);
/* harmony import */ var _Controls_Controls__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(32);
/* harmony import */ var _Controls_ElevationPath__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(166);
/* harmony import */ var _Layers_Layers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(170);
/* harmony import */ var _CRS_CRS__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(150);
/* harmony import */ var _Common_Utils_AutoLoadConfig__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(176);
/* harmony import */ var geoportal_access_lib__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(40);
/* harmony import */ var _Common_Utils_LayerUtils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(172);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LayerUtils", function() { return _Common_Utils_LayerUtils__WEBPACK_IMPORTED_MODULE_10__["default"]; });

/* harmony import */ var _Common_Utils_ProxyUtils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(177);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ProxyUtils", function() { return _Common_Utils_ProxyUtils__WEBPACK_IMPORTED_MODULE_11__["default"]; });

/* harmony import */ var _Common_Utils_ColorUtils__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(178);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ColorUtils", function() { return _Common_Utils_ColorUtils__WEBPACK_IMPORTED_MODULE_12__["default"]; });

/* harmony import */ var _Common_Utils_MathUtils__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(148);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MathUtils", function() { return _Common_Utils_MathUtils__WEBPACK_IMPORTED_MODULE_13__["default"]; });

/**
* Global variable Gp.
*
* @module Gp
* @alias Gp
* @desc
*
* This is the global variable that is exposed in the browser environment.
* Content is composed of constructor, functions and properties...
*
* > Config:  (...)
*
* > ColorUtils: (...)
* > LayerUtils: (...)
* > MathUtils: (...)
* > ProxyUtils: (...)
*
* > LExtended: (...)
*
* > leafletExtDate: "YYYY-MM-DD"
* > leafletExtVersion: "X.X.X"
*
* > Error: (...)
* > Helper: (...)
* > Protocols: (...)
* > Services: (...)
* > servicesDate: "YYYY-MM-DD"
* > servicesVersion: "X.X.X"
*
* The following variables are aslo global :
*   - proj4,
*   - L
*/

 // CSS communes aux extensions !





 // import WMTS from "./Layers/WMTS";
// import WMS from "./Layers/WMS";

 // Autoload...

 // export des services

 // reconstruction des ns

var Services = geoportal_access_lib__WEBPACK_IMPORTED_MODULE_9__["default"].Services;
var Error = geoportal_access_lib__WEBPACK_IMPORTED_MODULE_9__["default"].Error;
var Helper = geoportal_access_lib__WEBPACK_IMPORTED_MODULE_9__["default"].Helper;
var Protocols = geoportal_access_lib__WEBPACK_IMPORTED_MODULE_9__["default"].Protocols;
var servicesDate = geoportal_access_lib__WEBPACK_IMPORTED_MODULE_9__["default"].servicesDate;
var servicesVersion = geoportal_access_lib__WEBPACK_IMPORTED_MODULE_9__["default"].servicesVersion;
 // Rajout des propriétés de l'extension dans le namespace

/** Version */

var leafletExtVersion = _package_json__WEBPACK_IMPORTED_MODULE_0__.leafletExtVersion;
/** Publication date */

var leafletExtDate = _package_json__WEBPACK_IMPORTED_MODULE_0__.date; // Classes utilitaires




 // creation du namespace pour les extensions leaflet

leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.geoportalLayer = _Layers_Layers__WEBPACK_IMPORTED_MODULE_6__["default"]; // WMS et WMTS
// L.geoportalLayers = {};
// L.geoportalLayers.WMTS = WMTS;
// L.geoportalLayers.WMS = WMS;

leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.geoportalControl = _Controls_Controls__WEBPACK_IMPORTED_MODULE_4__["default"]; // IsoChrone, SearchEngine, ...

leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.geoportalControl.ElevationPath.DISPLAY_PROFILE_LIB_D3 = _Controls_ElevationPath__WEBPACK_IMPORTED_MODULE_5__["default"].DISPLAY_PROFILE_LIB_D3;
leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.geoportalControl.ElevationPath.DISPLAY_PROFILE_LIB_AMCHARTS = _Controls_ElevationPath__WEBPACK_IMPORTED_MODULE_5__["default"].DISPLAY_PROFILE_LIB_AMCHARTS;
leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.geoportalControl.ElevationPath.DISPLAY_PROFILE_RAW = _Controls_ElevationPath__WEBPACK_IMPORTED_MODULE_5__["default"].DISPLAY_PROFILE_RAW;
leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.geoportalControl.ElevationPath.DISPLAY_PROFILE_BY_DEFAULT = _Controls_ElevationPath__WEBPACK_IMPORTED_MODULE_5__["default"].DISPLAY_PROFILE_BY_DEFAULT;
leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.geoportalCRS = _CRS_CRS__WEBPACK_IMPORTED_MODULE_7__["default"]; // lambert 93 et lambert 2 étendu

leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.geoportalCRS.EPSG2154 = _CRS_CRS__WEBPACK_IMPORTED_MODULE_7__["default"].EPSG2154(); // lambert 93

leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.geoportalCRS.EPSG27572 = _CRS_CRS__WEBPACK_IMPORTED_MODULE_7__["default"].EPSG27572(); // lambert 2 étendu

leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.geoportalCRS.EPSG4326 = _CRS_CRS__WEBPACK_IMPORTED_MODULE_7__["default"].EPSG4326();


/***/ }),
/* 1 */
/***/ (function(module) {

module.exports = JSON.parse("{\"name\":\"geoportal-extensions\",\"description\":\"French Geoportal Extensions for OpenLayers, Leaflet and iTowns libraries\",\"version\":\"2.3.1\",\"date\":\"09/12/2020\",\"leafletExtName\":\"French Geoportal Extension for Leaflet\",\"leafletExtVersion\":\"2.1.7\",\"olExtName\":\"French Geoportal Extension for OpenLayers\",\"olExtVersion\":\"3.0.13\",\"itownsExtName\":\"French Geoportal Extension for Itowns\",\"itownsExtVersion\":\"2.3.0\",\"main\":\"dist/leaflet/GpPluginLeaflet.js, dist/openlayers/GpPluginOpenLayers.js, dist/itowns/GpPluginItowns.js\",\"module\":\"src/Leaflet/index.js, src/OpenLayers/index.js, src/Itowns/index.js\",\"directories\":{},\"scripts\":{\"setup\":\"npm install\",\"clean\":\"echo \\\"Warning: target not yet implemented!\\\" && exit 0\",\"eslint\":\"eslint src/\",\"test\":\"npm run test:serve\",\"test:serve\":\"cd test && webpack-dev-server --hot --config webpack.test.serve.js\",\"sample\":\"npm run sample:serve\",\"sample:serve\":\"npm run sample:ol:serve\",\"sample:itowns:serve\":\"webpack-dev-server --config build/webpack/webpack.config.itowns --https --open-page samples/index-itowns-map.html --content-base . --output-public-path '/dist/itowns/' --port 9001 --open 'google-chrome'\",\"sample:leaflet:serve\":\"webpack-dev-server --config build/webpack/webpack.config.leaflet --https --open-page samples/index-leaflet-map.html --content-base . --output-public-path '/dist/leaflet/' --port 9001 --open 'google-chrome'\",\"sample:ol:serve\":\"webpack-dev-server --config build/webpack/webpack.config.openlayers --https --open-page samples/index-openlayers-map.html --content-base . --output-public-path '/dist/openlayers/' --port 9001 --open 'google-chrome'\",\"doc\":\"npm run doc:serve\",\"doc:serve\":\"npm run doc:ol:serve\",\"doc:itowns:serve\":\"webpack-dev-server --config build/webpack/webpack.config.itowns --content-base jsdoc/itowns --port 9001 --open\",\"doc:leaflet:serve\":\"webpack-dev-server --config build/webpack/webpack.config.leaflet --content-base jsdoc/leaflet --port 9001 --open\",\"doc:ol:serve\":\"webpack-dev-server --config build/webpack/webpack.config.openlayers --content-base jsdoc/openlayers --port 9001 --open\",\"build:dev\":\"npm-run-all --print-label --print-name build:*:dev\",\"build:prod\":\"npm-run-all --print-label --print-name build:*:prod\",\"build:src\":\"npm-run-all --print-label --print-name build:*:src\",\"build\":\"npm-run-all --print-label --print-name build:*:*\",\"build:itowns\":\"npm-run-all --print-label --print-name build:itowns:*\",\"build:itowns:dev\":\"webpack --config build/webpack/webpack.config.itowns --mode=development\",\"build:itowns:prod\":\"webpack --config build/webpack/webpack.config.itowns --mode=production\",\"build:itowns:src\":\"webpack --config build/webpack/webpack.config.itowns --mode=none\",\"build:ol\":\"npm-run-all --print-label --print-name build:ol:*\",\"build:ol:dev\":\"webpack --config build/webpack/webpack.config.openlayers --mode=development\",\"build:ol:prod\":\"webpack --config build/webpack/webpack.config.openlayers --mode=production\",\"build:ol:src\":\"webpack --config build/webpack/webpack.config.openlayers --mode=none\",\"build:leaflet\":\"npm-run-all --print-label --print-name build:leaflet:*\",\"build:leaflet:dev\":\"webpack --config build/webpack/webpack.config.leaflet --mode=development\",\"build:leaflet:prod\":\"webpack --config build/webpack/webpack.config.leaflet --mode=production\",\"build:leaflet:src\":\"webpack --config build/webpack/webpack.config.leaflet --mode=none\"},\"repository\":{\"type\":\"git\",\"url\":\"https://github.com/IGNF/geoportal-extensions.git\"},\"author\":\"IGNF\",\"keywords\":[\"geoportail\",\"javascript\",\"OpenLayers\",\"Leaflet\",\"Itowns\",\"3D\"],\"license\":\"CECILL-B\",\"bugs\":{\"url\":\"https://github.com/IGNF/geoportal-extensions/issues\"},\"homepage\":\"https://github.com/IGNF/geoportal-extensions#readme\",\"dependencies\":{\"@mapbox/mapbox-gl-style-spec\":\"13.11.0\",\"eventbusjs\":\"0.2.0\",\"geoportal-access-lib\":\"2.1.6\",\"itowns\":\"2.27.0\",\"leaflet\":\"1.7.1\",\"leaflet-draw\":\"1.0.4\",\"loglevel\":\"^1.6.7\",\"ol\":\"5.3.0\",\"ol-mapbox-style\":\"4.2.1\",\"proj4\":\"^2.6.2\",\"proj4leaflet\":\"1.0.2\",\"sortablejs\":\"1.8.4\",\"three\":\"^0.121.1\",\"whatwg-fetch\":\"3.0.0\"},\"devDependencies\":{\"@babel/core\":\"^7.4.4\",\"@babel/plugin-transform-template-literals\":\"^7.7.4\",\"@babel/preset-env\":\"^7.4.4\",\"babel-loader\":\"^8.0.5\",\"chai\":\"^4.2.0\",\"chalk\":\"^4.0.0\",\"clean-webpack-plugin\":\"^3.0.0\",\"copy-webpack-plugin\":\"^5.0.3\",\"core-js\":\"^3.6.4\",\"css-loader\":\"^3.4.2\",\"eslint\":\"^6.8.0\",\"eslint-config-standard\":\"^14.1.1\",\"eslint-loader\":\"^4.0.0\",\"eslint-plugin-import\":\"^2.17.2\",\"eslint-plugin-node\":\"^11.1.0\",\"eslint-plugin-promise\":\"^4.1.1\",\"eslint-plugin-standard\":\"^4.0.0\",\"exports-loader\":\"^0.7.0\",\"expose-loader\":\"^0.7.5\",\"fs-extra\":\"^9.0.0\",\"handlebars\":\"^4.7.5\",\"handlebars-layouts\":\"^3.1.4\",\"html-webpack-plugin\":\"^4.0.4\",\"jsdoc-webpack-plugin\":\"^0.3.0\",\"mini-css-extract-plugin\":\"^0.9.0\",\"mocha\":\"^7.1.1\",\"mocha-loader\":\"^5.0.0\",\"npm-run-all\":\"^4.1.5\",\"optimize-css-assets-webpack-plugin\":\"^5.0.1\",\"path\":\"^0.12.7\",\"replace-bundle-webpack-plugin\":\"^1.0.0\",\"requirejs\":\"^2.3.6\",\"responsive-loader\":\"^1.2.0\",\"speed-measure-webpack-plugin\":\"^1.3.0\",\"string-template\":\"^1.0.0\",\"style-loader\":\"^1.1.3\",\"terser-webpack-plugin\":\"^2.0.0\",\"url-loader\":\"^4.0.0\",\"webpack\":\"^4.30.0\",\"webpack-cli\":\"^3.3.1\",\"webpack-dev-server\":\"^3.3.1\",\"webpack-node-externals\":\"^1.7.2\"}}");

/***/ }),
/* 2 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE__2__;

/***/ }),
/* 3 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _CSS_GPboostRelief_css__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var _CSS_GPboostRelief_css__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_CSS_GPboostRelief_css__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _CSS_GPdrawing_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5);
/* harmony import */ var _CSS_GPdrawing_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_CSS_GPdrawing_css__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _CSS_GPelevationPath_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6);
/* harmony import */ var _CSS_GPelevationPath_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_CSS_GPelevationPath_css__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _CSS_GPgeneralWidget_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7);
/* harmony import */ var _CSS_GPgeneralWidget_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_CSS_GPgeneralWidget_css__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _CSS_GPgetFeatureInfo_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8);
/* harmony import */ var _CSS_GPgetFeatureInfo_css__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_CSS_GPgetFeatureInfo_css__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _CSS_GPisochron_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9);
/* harmony import */ var _CSS_GPisochron_css__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_CSS_GPisochron_css__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _CSS_GPlayerSwitcher_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(10);
/* harmony import */ var _CSS_GPlayerSwitcher_css__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_CSS_GPlayerSwitcher_css__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _CSS_GPlocation_css__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(11);
/* harmony import */ var _CSS_GPlocation_css__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_CSS_GPlocation_css__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _CSS_GPmeasureArea_css__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(12);
/* harmony import */ var _CSS_GPmeasureArea_css__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_CSS_GPmeasureArea_css__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _CSS_GPmeasureAzimuth_css__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(13);
/* harmony import */ var _CSS_GPmeasureAzimuth_css__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_CSS_GPmeasureAzimuth_css__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _CSS_GPmeasureLength_css__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(14);
/* harmony import */ var _CSS_GPmeasureLength_css__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_CSS_GPmeasureLength_css__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _CSS_GPmeasureToolTip_css__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(15);
/* harmony import */ var _CSS_GPmeasureToolTip_css__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_CSS_GPmeasureToolTip_css__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _CSS_GPmousePosition_css__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(16);
/* harmony import */ var _CSS_GPmousePosition_css__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_CSS_GPmousePosition_css__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _CSS_GPreverseGeocoding_css__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(17);
/* harmony import */ var _CSS_GPreverseGeocoding_css__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_CSS_GPreverseGeocoding_css__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _CSS_GProute_css__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(18);
/* harmony import */ var _CSS_GProute_css__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(_CSS_GProute_css__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _CSS_GPsearchEngine_css__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(19);
/* harmony import */ var _CSS_GPsearchEngine_css__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(_CSS_GPsearchEngine_css__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _CSS_GPwaiting_css__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(20);
/* harmony import */ var _CSS_GPwaiting_css__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(_CSS_GPwaiting_css__WEBPACK_IMPORTED_MODULE_16__);


















/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 21 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _CSS_GPgeneralWidgetLeaflet_css__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22);
/* harmony import */ var _CSS_GPgeneralWidgetLeaflet_css__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_CSS_GPgeneralWidgetLeaflet_css__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _CSS_Controls_ElevationPath_GPelevationPathLeaflet_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23);
/* harmony import */ var _CSS_Controls_ElevationPath_GPelevationPathLeaflet_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_CSS_Controls_ElevationPath_GPelevationPathLeaflet_css__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _CSS_Controls_Isochrone_GPisochronLeaflet_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24);
/* harmony import */ var _CSS_Controls_Isochrone_GPisochronLeaflet_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_CSS_Controls_Isochrone_GPisochronLeaflet_css__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _CSS_Controls_LayerSwitcher_GPlayerSwitcherLeaflet_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(25);
/* harmony import */ var _CSS_Controls_LayerSwitcher_GPlayerSwitcherLeaflet_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_CSS_Controls_LayerSwitcher_GPlayerSwitcherLeaflet_css__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _CSS_Controls_LocationSelector_GPlocationLeaflet_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26);
/* harmony import */ var _CSS_Controls_LocationSelector_GPlocationLeaflet_css__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_CSS_Controls_LocationSelector_GPlocationLeaflet_css__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _CSS_Controls_MousePosition_GPmousePositionLeaflet_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(27);
/* harmony import */ var _CSS_Controls_MousePosition_GPmousePositionLeaflet_css__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_CSS_Controls_MousePosition_GPmousePositionLeaflet_css__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _CSS_Controls_ReverseGeocoding_GPreverseGeocodingLeaflet_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(28);
/* harmony import */ var _CSS_Controls_ReverseGeocoding_GPreverseGeocodingLeaflet_css__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_CSS_Controls_ReverseGeocoding_GPreverseGeocodingLeaflet_css__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _CSS_Controls_Route_GProuteLeaflet_css__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(29);
/* harmony import */ var _CSS_Controls_Route_GProuteLeaflet_css__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_CSS_Controls_Route_GProuteLeaflet_css__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _CSS_Controls_SearchEngine_GPsearchEngineLeaflet_css__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(30);
/* harmony import */ var _CSS_Controls_SearchEngine_GPsearchEngineLeaflet_css__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_CSS_Controls_SearchEngine_GPsearchEngineLeaflet_css__WEBPACK_IMPORTED_MODULE_8__);
/* global true */
// En module ES6, on n'a pas besoin de ces CSS, car on utile le CSS géneré avec WebPack.
// L'utilisation de ces imports est utile lors de la creation du bundle...








 // ce flag est substitué via le script de publication des sources du package...

if (true) {
  // plugin leaflet-draw !
  __webpack_require__(31);
}

/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 32 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _LayerSwitcher__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(33);
/* harmony import */ var _Isocurve__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(39);
/* harmony import */ var _MousePosition__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(147);
/* harmony import */ var _ReverseGeocoding__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(158);
/* harmony import */ var _Route__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(161);
/* harmony import */ var _SearchEngine__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(163);
/* harmony import */ var _ElevationPath__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(166);
/* harmony import */ var _Logo__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(169);








/**
 * Geoportal Controls Factory to be used together with Leaflet Maps.
 *
 * @module Controls
 * @alias L.geoportalControl
 * @example
 * var layerSwitcher = L.geoportalControl.LayerSwitcher(options);
 */

var Controls = {
  /**
   * Factory function for LayerSwitcher Control creation.
   *
   * @method LayerSwitcher
   * @static
   * @alias L.geoportalControl.LayerSwitcher
   * @param {Object} options - options for function call.
   * @param {String}  [options.position] - position of component into the map, 'topleft' by default. See {@link http://leafletjs.com/reference-1.0.2.html#control-option L.Control options} for available values.
   * @param {Boolean} [options.collapsed] - collapse mode, false by default
   * @param {Array}   [options.layers] - list of layers to be configured. Each array element is an object, with following properties :
   * @param {Object}  [options.layers.layer] - layer object
   * @param {Boolean} [options.layers.display] - display layer in widget layer list
   * @param {Object}  [options.layers.config] - layer display config
   * @param {String}  [options.layers.config.visibility] - layer visibility on map
   * @param {String}  [options.layers.config.title] - layer alias, to be displayed in widget layer list. E.g. : "Cartes IGN"
   * @param {String}  [options.layers.config.description] - layer description, to be displayed on title hover, or in layer information panel.
   * @param {String}  [options.layers.config.quicklookUrl] - link to a quick look image for this layer.
   * @param {Array}   [options.layers.config.legends] - array of layer legends. Each array element is an object, with following properties :
   *      - url (String, mandatory) : link to a legend
   *      - minScaleDenominator (Number, optional) : min scale denominator for legend validity.
   * @param {Array} [options.layers.config.metadata] - array of layer metadata. Each array element is an object, with property url (String, mandatory) : link to a metadata
   * @returns {L.geoportalControl.LayerSwitcher} - LayerSwitcher Object
   * @example
   *  layers = [
   *      {
   *          layer : wms1,
   *          display : false,
   *          config : {
   *              title : "test layer name 1",
   *              description : "test layer desc 1",
   *          }
   *      }
   *  ];
   *
   *  options = {
   *      position : "topright",
   *      collapsed : true,
   *      layers : layers
   *  };
   *
   *  var layerSwitcher = L.geoportalControl.LayerSwitcher(options);
   */
  LayerSwitcher: function LayerSwitcher(options) {
    return new _LayerSwitcher__WEBPACK_IMPORTED_MODULE_0__["default"](options);
  },

  /**
   * Factory function for Isocurve Control creation.
   *
   * @method Isocurve
   * @static
   * @alias L.geoportalControl.Isocurve
   * @param {Object} options - Isocurve control options
   * @param {Sting}   [options.apiKey] - API key for services call (isocurve and autocomplete services), mandatory if autoconf service has not been charged in advance
   * @param {String}  [options.position] - position of component into the map, 'topleft' by default. See {@link http://leafletjs.com/reference-1.0.2.html#control-option L.Control options} for available values.
   * @param {Boolean} [options.collapsed] - Specify if widget has to be collapsed (true) or not (false) on map loading. Default is true.
   * @param {Boolean} [options.ssl = true] - use of ssl or not (default true, service requested using https protocol)
   * @param {Object}  [options.exclusions] - list of exclusions with status (true = checked), by default : ["toll":false, "tunnel":false, "bridge":false].
   * @param {Array}   [options.graphs] - list of graph resources to be used for isocurve calculation, by default : ["Voiture", "Pieton"]. The first element is selected.
   * @param {Array}   [options.methods] - list of methods, by default : ["time", "distance"]. The first element is selected by default.
   * @param {Array}   [options.directions] - list of directions to be displayed, by default : ["departure", "arrival"]. The first element is selected by default.
   *      Directions enable to specify if input location point will be used as a departure point ("departure") or as an arrival point ("arrival")
   * @param {Boolean} [options.disableReverse = false] - whether to enable/disable the reverse geocoding
   * @param {Object} [options.isocurveOptions] - isocurve service options. see {@link http://ignf.github.io/geoportal-access-lib/latest/jsdoc/module-Services.html#~isoCurve Gp.Services.isoCurve}
   * @param {Object} [options.autocompleteOptions] - autocomplete service options. see {@link http://ignf.github.io/geoportal-access-lib/latest/jsdoc/module-Services.html#~autoComplete Gp.Services.autoComplete}
   * @returns {L.geoportalControl.Isocurve} - Isocurve Object
   * @example
   *  var iso = L.geoportalControl.Isocurve({
   *      collapsed : false
   *      methods : ["time", "distance"],
   *      exclusions : {
   *         toll : true,
   *         bridge : false,
   *         tunnel : true
   *      },
   *      graphs : ["Pieton", "Voiture"],
   *      isocurveOptions : {},
   *      autocompleteOptions : {}
   *  });
   */
  Isocurve: function Isocurve(options) {
    return new _Isocurve__WEBPACK_IMPORTED_MODULE_1__["default"](options);
  },

  /**
   * Factory function for Geoportal MousePosition Control creation.
   *
   * @method MousePosition
   * @static
   * @alias L.geoportalControl.MousePosition
   * @param {Object} options - options for function call.
   * @param {Sting}   [options.apiKey] - API key, mandatory if autoconf service has not been charged in advance
   * @param {String}  [options.position] - position of component into the map, 'bottomleft' by default. See {@link http://leafletjs.com/reference-1.0.2.html#control-option L.Control options} for available values.
   * @param {Boolean} [options.collapsed] - collapse mode, false by default
   * @param {Boolean} [options.ssl = true] - use of ssl or not (default true, service requested using https protocol)
   * @param {Array}   [options.systems] - list of projection systems, GEOGRAPHIC, MERCATOR, LAMB93 and LAMB2E by default
   *      Each array element (=system) is an object with following properties :
   * @param {String}  options.systems.crs - Proj4 crs alias (from proj4 defs). e.g. : "EPSG:4326". Required
   * @param {String}  [options.systems.label] - CRS label to be displayed in control. Default is crs code (e.g. "EPSG:4326")
   * @param {String}  [options.systems.type] - CRS units type for coordinates conversion : "Geographical" or "Metric". Default: "Metric"
   * @param {Object}  [options.systems.geoBBox] - Aera covered by the system (WGS84 coordinates).
   * @param {Number}  options.systems.geoBBox.right - Right bound.
   * @param {Number}  options.systems.geoBBox.left - Left bound.
   * @param {Number}  options.systems.geoBBox.top - Top bound.
   * @param {Number}  options.systems.geoBBox.bottom - Bottom bound.
   * @param {Array}   [options.units] - list of units by system, Geographical and Metric by default
   *      Values may be "DEC" (decimal degrees), "DMS" (sexagecimal), "RAD" (radians) and "GON" (grades) for geographical coordinates,
   *      and "M" or "KM" for metric coordinates
   * @param {Boolean} [options.displayAltitude] - active/desactivate the altitude panel, if desactivate, have just the coordinate panel, true by default
   * @param {Boolean} [options.displayCoordinates] - active/desactivate the coordinate panel, if desactivate, have just the altitude panel, true by default
   * @param {Boolean} [options.editCoordinates = false] - If true, coordinates from the MousePosition control can be edited by users to re-center the view. False by default.
   * @param {Object}  [options.altitude] - elevation configuration
   * @param {Object}  [options.altitude.serviceOptions] - options of elevation service. see {@link http://ignf.github.io/geoportal-access-lib/latest/jsdoc/module-Services.html#~getAltitude Gp.Services.getAltitude}
   * @param {Number}  [options.altitude.responseDelay] - latency for altitude request, 500 ms by default
   * @param {Number}  [options.altitude.triggerDelay] - immobilisation time of movement on the map to trigger the elevation calculation, 200 ms by default
   * @param {Number}  [options.altitude.noDataValue] - value used for altitude service no data (default is -99999). In this case, "---m" will be displayed instead of "-99999m"
   * @param {Number}  [options.altitude.noDataValueTolerance] - tolerance for no data value :
   *                  values in [noDataValue - noDataValueTolerance ; noDataValue + noDataValueTolerance] interval will not be displayed, but "---m" will be displayed instead.
   *                  Default is 90000
   * @returns {L.geoportalControl.MousePosition} - MousePosition Object
   * @example
   *  var MousePosition = L.geoportalControl.MousePosition({
   *      position : 'bottomleft',
   *      collapsed : false,
   *      displayAltitude : true,
   *      editCoordinates : false,
   *      altitude : {
   *           triggerDelay : 100,
   *           responseDelay : 500,
   *           noDataValue : -99999,
   *           noDataValueTolerance : 90000,
   *           serviceOptions : {}
   *      },
   *      systems : [
   *       {
   *          crs : L.CRS.EPSG4326,
   *          label : "Lon,Lat",
   *          type : "Geographical"
   *        },
   *       {
   *          crs : L.geoportalCRS.EPSG2154,
   *          label : "Lambert 93",
   *          type : "Metric"
   *        }
   *      ],
   *      units : ["DEC", "DMS"]
   *  });
   */
  MousePosition: function MousePosition(options) {
    return new _MousePosition__WEBPACK_IMPORTED_MODULE_2__["default"](options);
  },

  /**
   * Factory function for Geoportal ReverseGeocode Control creation.
   *
   * @method ReverseGeocode
   * @static
   * @alias L.geoportalControl.ReverseGeocode
   * @extends {L.Control}
   * @param {Object} options - ReverseGeocoding control options
   * @param {String}  [options.apiKey] - API key for services call (reverse geocode service), mandatory if autoconf service has not been charged in advance
   * @param {String}  [options.position] - position of component into the map, 'topleft' by default. See {@link http://leafletjs.com/reference-1.0.2.html#control-option L.Control options} for available values.
   * @param {Boolean} [options.collapsed] - Specify if widget has to be collapsed (true) or not (false) on map loading. Default is true.
   * @param {Boolean} [options.ssl = true] - use of ssl or not (default true, service requested using https protocol)
   * @param {Array}  [options.resources] - resources for geocoding, by default : ["StreetAddress", "PositionOfInterest"]
   * @param {Array}  [options.delimitations] - delimitations for reverse geocoding, by default : ["Point", "Circle", "Extent"]
   * @param {Object}  [options.ReverseGeocodeOptions] - reverse geocode service options. see {@link http://ignf.github.io/geoportal-access-lib/latest/jsdoc/module-Services.html#~reverseGeocode Gp.Services.reverseGeocode} to know all reverse geocode options.
   * @returns {L.geoportalControl.ReverseGeocode} - ReverseGeocode Object
   * @example
   *  var iso = L.geoportalControl.ReverseGeocode({
   *      collapsed : false,
   *      position : "topright",
   *      resources : ["StreetAddress", "PositionOfInterest"],
   *      delimitations : ["Point", "Circle"],
   *      reverseGeocodeOptions : {}
   *  });
   */
  ReverseGeocode: function ReverseGeocode(options) {
    return new _ReverseGeocoding__WEBPACK_IMPORTED_MODULE_3__["default"](options);
  },

  /**
   * Factory function for Geoportal Route Control creation.
   *
   * @method Route
   * @static
   * @alias L.geoportalControl.Route
   * @extends {L.Control}
   * @param {Object} options - options for function call.
   * @param {Sting}   [options.apiKey] - API key, mandatory if autoconf service has not been charged in advance
   * @param {String}  [options.position = "topleft"] - position of component into the map, 'topleft' by default. See {@link http://leafletjs.com/reference-1.0.2.html#control-option L.Control options} for available values.
   * @param {Boolean} [options.collapsed = false] - collapse mode, false by default
   * @param {Boolean} [options.ssl = true] - use of ssl or not (default true, service requested using https protocol)
   * @param {Boolean} [options.disableReverse = false] - whether to enable/disable the reverse geocoding when entering points.
   *   Active by default. But, you can disable it when entering with the "ctrl" key on the keyboard
   * @param {Object}  [options.exclusions] - list of exclusions with status
   * @param {Array}   [options.graphs] - list of resources, by default : ["Voiture", "Pieton"], and the first element is selected.
   * @param {Object}  [options.autocompleteOptions] - options of autocomplete service. see {@link http://ignf.github.io/geoportal-access-lib/latest/jsdoc/module-Services.html#~autoComplete Gp.Services.autoComplete}
   * @param {Object}  [options.routeOptions] - options of route service. see {@link http://ignf.github.io/geoportal-access-lib/latest/jsdoc/module-Services.html#~route Gp.Services.route}
   * @returns {L.geoportalControl.Route} - Route Object
   * @example
   *  var route = L.geoportalControl.Route({
   *      position : "topright",
   *      collapsed : true,
   *      exclusions : {
   *         "toll" : true,
   *         "bridge" : false,
   *         "tunnel" : true
   *      },
   *      graphs : ['Pieton', 'Voiture'],
   *      autocompleteOptions : {},
   *      routeOptions : {}
   *  });
   */
  Route: function Route(options) {
    return new _Route__WEBPACK_IMPORTED_MODULE_4__["default"](options);
  },

  /**
   * Factory function for Geoportal SearchEngine Control creation.
   *
   * @method SearchEngine
   * @static
   * @alias L.geoportalControl.SearchEngine
   * @extends {L.Control}
   * @param {Object}  options - control options
   * @param {String}  [options.apiKey] - API key, mandatory if autoconf service has not been charged in advance
   * @param {Boolean} [options.collapsed = false] - collapse mode
   * @param {Boolean} [options.ssl = true] - use of ssl or not (default true, service requested using https protocol)
   * @param {String}  [options.position = "topleft"] - position of component into the map. See {@link http://leafletjs.com/reference-1.0.2.html#control-option L.Control options} for available values.
   * @param {String}  [options.placeholder = "Rechercher un lieu, une adresse"] - set placeholder in search bar
   * @param {Boolean} [options.displayMarker = true] - set a marker on search result
   * @param {String|Object}  [options.markerStyle = "blue"] - set a marker style. Currently possible values are "blue" (default value), "orange", "red" and "green". But you can use an L.Icon object (see {@link http://leafletjs.com/reference-1.2.0.html#icon L.Icon })
   * @param {Boolean} [options.displayInfo = true] - get informations on popup marker
   * @param {Sting|Numeric|Function} [options.zoomTo] - zoom to results, by default, current zoom.
   *       possible values : "auto", any fixed zoom level or a function retruning a zoom :
   *
   *       ```
   *       zoomTo : function (info) {
   *           // do some stuff...
   *           return zoom; // required : return the zoom level !
   *       }
   *
   *       With parameter 'info' : {
   *           type : "PositionOfInterest" | "StreetAddress" | ...
   *           service : "SuggestedLocation" | "DirectGeocodedLocation"
   *           fields : { // fields of service response }
   *       }
   *       ```
   * @param {Sting}   [options.apiKey] - API key, mandatory if autoconf service has not been charged in advance
   * @param {Object}  [options.resources] - resources to be used by geocode and autocompletion services, by default : ["StreetAddress", "PositionOfInterest"]
   * @param {Boolean} [options.displayAdvancedSearch] - False to disable advanced search tools (it will not be displayed). Default is true (displayed)
   * @param {Object}  [options.advancedSearch] - advanced search for geocoding (filters)
   * @param {Object}  [options.geocodeOptions] - options of geocode service. see {@link http://ignf.github.io/geoportal-access-lib/latest/jsdoc/module-Services.html#~geocode Gp.Services.geocode}
   * @param {Object}  [options.autocompleteOptions] - options of autocomplete service. see {@link http://ignf.github.io/geoportal-access-lib/latest/jsdoc/module-Services.html#~autoComplete Gp.Services.autoComplete}
   * @param {Object}  [options.autocompleteOptions.serviceOptions] - options of autocomplete service
   * @param {Boolean} [options.autocompleteOptions.triggerGeocode = false] - trigger a geocoding request if the autocompletion does not return any suggestions, false by default
   * @param {Number}  [options.autocompleteOptions.triggerDelay = 1000] - waiting time before sending the geocoding request, 1000ms by default
   * @returns {L.geoportalControl.SearchEngine} - SearchEngine Object
   * @example
   *  var SearchEngine = L.geoportalControl.SearchEngine({
   *      position : "topright",
   *      collapsed : true,
   *      zoomTo : "auto",
   *      displayInfo : true,
   *      displayAdvancedSearch : true,
   *      resources : ["PositionOfInterest", "StreetAddress"],
   *      advancedSearch : {
   *          PositionOfInterest : [{name : "municipality", title : "Ville"}],
   *          StreetAddress : [{...}],
   *          CadastralParcel : null,
   *      },
   *      apiKey : "zfgzrgffg57rfg8ar7gr4g5r4",
   *      geocodeOptions : {},
   *      autocompleteOptions : {}
   *  });
   */
  SearchEngine: function SearchEngine(options) {
    return new _SearchEngine__WEBPACK_IMPORTED_MODULE_5__["default"](options);
  },

  /**
   * Factory function for ElevationPath Control creation.
   *
   * @method ElevationPath
   * @static
   * @alias L.geoportalControl.ElevationPath
   * @param {Object} options - options for function call.
   * @param {Sting}   [options.apiKey] - API key for elevation service call, mandatory if configuration service has not been loaded in advance. See {@link https://github.com/IGNF/geoportal-extensions/blob/master/README-leaflet.md#user-content-config "Configuration de l'accès à la plateforme Géoportail" documentation chapter} for more information.
   * @param {String}  [options.position] - position of component into the map, 'topleft' by default. See {@link http://leafletjs.com/reference-1.0.2.html#control-option L.Control options} for available values.
   * @param {Boolean} [options.ssl = true] - use of ssl or not (default true, service requested using https protocol)
   * @param {Boolean} [options.active = false] - specify if control should be actived at startup. Default is false.
   * @param {Object} [options.stylesOptions = DEFAULT_STYLES] - Styles to use when drawing. see [leaflet options](http://leafletjs.com/reference.html#path-options) for available properties.
   * @param {Object} [options.elevationPathOptions = {}] - elevation path service options. See {@link http://ignf.github.io/geoportal-access-lib/latest/jsdoc/module-Services.html#~getAltitude options} for available options
   * @param {Object} [options.displayProfileOptions = {}] - profile options.
   * @param {Function} [options.displayProfileOptions.apply] - function to display profile if you want to cutomise it. By default, [DISPLAY_PROFILE_BY_DEFAULT()](./L.geoportalControl.ElevationPath.html#.DISPLAY_PROFILE_BY_DEFAULT) is used. Helper functions to use with D3 [DISPLAY_PROFILE_LIB_D3()](./L.geoportalControl.ElevationPath.html#.DISPLAY_PROFILE_LIB_D3) or AmCharts [DISPLAY_PROFILE_LIB_AMCHARTS()](./L.geoportalControl.ElevationPath.html#.DISPLAY_PROFILE_LIB_AMCHARTS) frameworks are also provided. You may also provide your own function.
   * @param {Object} [options.displayProfileOptions.target] - DOM container to use to display the profile.
   * @param {Boolean} [options.displayProfileOptions.greaterSlope = true] - display the greater slope into the graph
   * @param {Boolean} [options.displayProfileOptions.meanSlope = true] -  display the mean slope into the graph
   * @param {Boolean} [options.displayProfileOptions.ascendingElevation = true] -  display the ascending elevation into the graph
   * @param {Boolean} [options.displayProfileOptions.descendingElevation = true] -  display the descending elevation into the graph
   * @param {Boolean} [options.displayProfileOptions.currentSlope = true] -  display current slope value on profile mouseover
   *
   * @returns {L.geoportalControl.ElevationPath} - ElevationPath Object
   * @example
   *  var e = L.geoportalControl.ElevationPath({
   *      active : false
   *      position : "topleft"
   *      stylesOptions : {},
   *      elevationPathOptions : {},
   *      displayProfileOptions  : {
   *          apply : L.geoportalControl.DISPLAY_PROFILE_LIB_AMCHARTS
   *          target : null, // by default
   *          meanSlope : true, // by default
   *          greaterSlope : true, // by default
   *          ascendingElevation : false,
   *          descendingElevation : false,
   *          currentSlope : false
   *      }
   *  });
   */
  ElevationPath: function ElevationPath(options) {
    return new _ElevationPath__WEBPACK_IMPORTED_MODULE_6__["default"](options);
  },

  /**
   * Control Logo
   *
   * @private
   * @method Logo
   * @extends {L.Control}
   * @alias L.geoportalControl.Logo
   * @param {Object} options - options for function call.
   * @param {String} options.position - 'topright' by default. See {@link http://leafletjs.com/reference-1.0.2.html#control-option L.Control options} for available values.
   * @param {String} options.url - URL
   * @param {String} options.text - text
   * @param {String} options.picto - picto
   * @param {String|Object} options.size - picto size
   * @returns {Logo} - Logo Object
   * @example
   * var map  = L.map('map').setView([48, 2], 4);
   * var logo = L.geoportalControl.Logo({
   *   position : "topright",
   *   picto : "http://www.ign.fr/logo-ign.jpg",
   *   url : "http://www.ign.fr",
   *   text : "© IGN"
   *   size : {width : '50px', height : '30px'}
   * });
   * logo.addTo(map);
   */
  Logo: function Logo(options) {
    return new _Logo__WEBPACK_IMPORTED_MODULE_7__["default"](options);
  }
};
/* harmony default export */ __webpack_exports__["default"] = (Controls);

/***/ }),
/* 33 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2);
/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Common_Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(34);
/* harmony import */ var _Common_Utils_SelectorID__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(36);
/* harmony import */ var _Common_Controls_LayerSwitcherDOM__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(37);




var logger = _Common_Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_1__["default"].getLogger("layerswitcher");
/**
 * @classdesc
 *
 * Leaflet Control Class to manage map layers : their order, visibility and opacity, and display their informations (title, description, legends, metadata...)
 *
 * Use {@link module:Controls.LayerSwitcher L.geoportalControl.LayerSwitcher()} factory to create instances of that class.
 *
 * **Extends** Leaflet <a href="http://leafletjs.com/reference.html#control-layers" target="_blank">L.Control.Layers</a> native class.
 *
 * @namespace
 * @alias L.geoportalControl.LayerSwitcher
 */

var LayerSwitcher = leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.Control.Layers.extend(
/** @lends L.geoportalControl.LayerSwitcher.prototype */
{
  includes: _Common_Controls_LayerSwitcherDOM__WEBPACK_IMPORTED_MODULE_3__["default"],

  /**
   * options by default
   * (extend to L.Control.Layers)
   *
   * @private
   */
  options: {
    collapsed: true,
    position: "topright",
    autoZIndex: true,
    layers: []
  },
  // ################################################################### //
  // ##################### Methodes surchargées ######################## //
  // ################################################################### //

  /**
   * @constructor LayerSwitcher
   *
   * @private
   * @alias LayerSwitcher
   * @extends {L.Control}
   * @param {Object} options - options of component
   * @param {String}  [options.position] - position of component into the map, 'topleft' by default
   * @param {Boolean} [options.collapsed] - collapse mode, false by default
   * @param {Array} [options.layers] - list of layers to be configured. Each array element is an object, with following properties :
   * @param {Object} [options.layers.layer] - layer object
   * @param {Boolean} [options.layers.display] - display layer in widget layer list
   * @param {String} [options.layers.config.visibility] - layer visibility on map
   * @param {String} [options.layers.config.title] - layer alias, to be displayed in widget layer list. E.g. : "Cartes IGN"
   * @param {String} [options.layers.config.description] - layer description, to be displayed on title hover, or in layer information panel.
   * @param {String} [options.layers.config.quicklookUrl] - link to a quick look image for this layer.
   * @param {Array} [options.layers.config.legends] - array of layer legends. Each array element is an object, with following properties :
   *      - url (String, mandatory) : link to a legend
   *      - minScaleDenominator (Number, optional) : min scale denominator for legend validity.
   * @param {Array} [options.layers.config.metadata] - array of layer metadata. Each array element is an object, with property url (String, mandatory) : link to a metadata
   *
   * @example
   *  layers = [
   *      {
   *          layer : wms1,
   *          display : false,
   *          config : {
   *              title : "test layer name 1",
   *              description : "test layer desc 1",
   *          }
   *      }
   *  ]
   *  options = {
   *      position : "topright",
   *      collapsed : true,
   *      layers : layers
   *  }
   *
   *  var layerSwitcher = L.geoportalControl.LayerSwitcher(options);
   */
  initialize: function initialize(options) {
    leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.Util.setOptions(this, options); // uuid

    this._uid = _Common_Utils_SelectorID__WEBPACK_IMPORTED_MODULE_2__["default"].generate(); // il faut recuperer tous les layers de la carte (cf. onAdd).
    // si une configuration de layers est renseignée, on exploite cette
    // information pour les layers renseignés.
    // Par contre, pour ceux qui n'ont pas de configuration, on exploite
    // les informations issues de l'autoconf pour les layers IGN,
    // et, pour les layers non IGN, on gére avec l'ID pours les valeurs
    // de titre ou description  ...
    // a ton une configuration des layers ?

    this._hasLayersConfig = !(!this.options.layers || Object.keys(this.options.layers).length === 0); // configuration des layers

    this._layersConfig = this._hasLayersConfig ? this.options.layers : []; // liste des layers (c'est l'interface avec le dom !)

    this._layers = {}; // indice : ordre des layers sur la carte
    // plus c'est haut, plus c'est au dessus de la pile

    this._lastZIndex = 0; // si on a une configuration de layers, on l'exploite tout de suite...

    if (this._hasLayersConfig) {
      for (var i = 0; i < this._layersConfig.length; i++) {
        var obj = this._layersConfig[i]; // signature de la fonction pour une compatibilité avec leaflet...

        this._addLayer(obj.layer, null, true);
      }
    }
  },

  /**
   * Method 'onAdd'
   * (extend to L.Control.Layers)
   * Method to add the control on the map.
   *
   * @param {Object} map - L.Map
   * @returns {HTMLElement} container
   *
   * @private
   */
  onAdd: function onAdd(map) {
    // on charge tous les layers dans le controle avec une
    // configuration automatique des layers pour ceux qui ne sont pas
    // renseignés.
    var layersMap = map._layers; // on est dans le cas où nous avons des layers ajoutés à la carte

    if (Object.keys(layersMap).length !== 0) {
      // pour gerer l'ordre d'affichage des layers sur la map
      // ainsi que dans le controle, on veut le fonctionnement suivant :
      // layers ID   : [21  , 23  , 25  , 27]
      // layers Map  : [21:1, 23:2, 25:3, 27:4]
      // mais l'ordre dans le controle doit être inversé
      // layers Ctrl : [27, 25, 23, 21], et ceci sera realisé lors de
      // la creation du DOM pour chaque layer (cf. _update())
      var layersKeys = Object.keys(layersMap); // trie

      this._lastZIndex = 0;

      for (var i = 0; i < layersKeys.length; i++) {
        var layerId = layersKeys[i]; // gestion des ordres d'affichage des layers

        if (this.options.autoZIndex && layersMap[layerId].setZIndex) {
          this._lastZIndex++;
          layersMap[layerId].setZIndex(this._lastZIndex);
        } // y'a t il une configuration des layers ?
        // si oui, le layer renseigné a déjà été pris en compte dans
        // le constructeur..., on passe à la suite...


        if (this._hasLayersConfig) {
          if (this._layers[layerId]) {
            continue;
          }
        } // sans configuration, on gére en mode auto le layer.
        // on utilise cette methode
        // this.addOverlay() -> this._addLayer()...


        this.addOverlay(layersMap[layerId]);
      }
    } // FIXME au cas où les layers n'ont pas été renseignés sur la carte
    // (via addTo ou options.layers), on decide de prendre ceux qui
    // sont renseignés dans la configuration ?


    if (Object.keys(layersMap).length === 0) {
      var config = this._layersConfig;
      this._lastZIndex = 0;

      for (var j = 0; j < config.length; j++) {
        var layer = config[j].layer;

        if (!map.hasLayer(layer)) {
          // on ajoute le layer à la carte
          map.addLayer(layer); // on met en place la structure

          this.addOverlay(layer, null); // on gère l'ordres d'affichage des layers

          if (this.options.autoZIndex && layer.setZIndex) {
            this._lastZIndex++;
            layer.setZIndex(this._lastZIndex);
          }
        }
      }
    } // mise à jour des visibilités (au niveau du DOM, oeil coché ou non...)


    for (var k in this._layers) {
      if (this._layers.hasOwnProperty(k)) {
        var obj = this._layers[k];
        var _layer = obj.layer;
        var _visibility = obj.visibility; // par defaut, la visibilité de la couche est active, donc avec un oeil non coché !

        if (!_visibility) {
          // on met à jour la liste des layers à afficher !
          this._updateVisibilityLayer(_layer);
        }
      }
    } // le constructeur retourne this._container !
    // on appelle la methode hérité car elle va realisée le boulot :
    // - _initLayout
    // - _update
    // - evenements sur la carte : layeradd + layerremove
    // this._container = L.Control.Layers.prototype.onAdd.call(this, map);


    this._initLayout();

    this._update();

    map.on("layeradd", this._onLayerChange, this);
    map.on("layerremove", this._onLayerChange, this); // expiremental !

    map.eachLayer(function (layer) {
      // ecouteur sur la visibilité des attributions d'un layer IGN
      layer.on("visibilitychange", function () {
        logger.trace("visibilitychange", layer);
      }, this); // ecouteur sur la liste des attributions d'un layer IGN

      layer.on("attributionchange", function () {
        logger.trace("attributionchange", layer);
      }, this);
    });
    return this._container;
  },

  /**
   * Method '_addLayer'
   * (overwritten : L.Control.Layers)
   * Methode creation of a useful structure for the interface with the DOM
   * Method private call by this.initialize() or this.addOverlay()
   *
   * @example
   * {
   *    layer : objectlayer,
   *    id : id,
   *    title : title,
   *    description : description
   *    (...)
   * };
   * @param {Object} layer - object type 'L.TileLayer'
   * @param {String} name - layer name or title
   * @param {Boolean} overlay - overlay or not
   *
   * @private
   */
  _addLayer: function _addLayer(layer, name, overlay) {
    // id du layer (IGN ou non)
    var id = layer._geoportal_id ? layer._geoportal_id : layer._leaflet_id; // pas d'ID !?
    // le layer n'est pas chargé dans la carte...

    if (typeof id === "undefined") {
      return;
    } // recherche de la config pour un layer donné


    var layerConfig = {};

    for (var i in this._layersConfig) {
      if (this._layersConfig.hasOwnProperty(i)) {
        if (id === leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.stamp(this._layersConfig[i].layer)) {
          layerConfig = this._layersConfig[i].config; // display
          // ce layer n'est pas pris en compte dans le controle
          // mais il peut être affiché dans la map
          // si au préalable, le client l'a ajouté...

          var display = typeof this._layersConfig[i].display !== "undefined" ? this._layersConfig[i].display : true;

          if (!display) {
            return;
          }

          break;
        }
      }
    } // construit un objet simplifié pour le dom,
    // par defaut, on prend en compte les layers de type IGN
    // (info de l'autoconf).


    this._layers[id] = {
      layer: layer,
      id: id,
      overlay: overlay,
      // not use !
      title: layer._geoportal_id && layer._title ? layer._title : name || id,
      description: layer._geoportal_id && layer._description ? layer._description : name || id,
      visibility: true,
      // par defaut, sauf si surcharge via la config...
      legends: layer._geoportal_id ? layer._legends : null,
      metadata: layer._geoportal_id ? layer._metadata : null,
      quicklookUrl: layer._geoportal_id ? layer._quicklookUrl : null
    }; // surcharge la config ci dessus avec les options de configuration saisies

    if (layerConfig && Object.keys(layerConfig)) {
      leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.Util.extend(this._layers[id], layerConfig);
    } // mise à jour de la visibilité


    var _visibility = this._layers[id].visibility;

    if (layer._geoportal_id) {
      // mise à jour de la visibilité des attributions pour un layer IGN
      layer.setVisible(_visibility);
    }

    if (!_visibility) {
      // on met à jour la liste des layers à afficher !
      this._updateVisibilityLayer(layer);
    }
  },

  /**
   * Method 'addTo'
   * (overwritten : L.Control.Layers because of exception with _expandIfNotCollapsed())
   *
   * @param {Object} map - the map
   *
   * @returns {Object} this
   */
  addTo: function addTo(map) {
    leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.Control.prototype.addTo.call(this, map);
    return this;
  },

  /**
   * Creation of layers of container
   * (extend to L.Control.Layers)
   *
   * Method private call by this.onAdd()
   *
   * @private
   */
  _initLayout: function _initLayout() {
    // fonctionnement lors de l'initialisation :
    // onAdd -> this._update     -> this._addItem (on boucle sur layers)
    // onAdd -> this._initLayout
    // creation du container principal
    var container = this._container = this._createMainContainerElement(); // ajout dans le container principal d'affichage des layers


    var input = this._createMainLayersShowElement();

    container.appendChild(input); // gestion du mode "collapsed"

    if (!this.options.collapsed) {
      input.checked = true;
    } // ajout dans le container principal de la liste des layers


    var divL = this._overlaysList = this._createMainLayersElement();

    container.appendChild(divL); // ajout dans le container principal du picto du controle

    var picto = this._createMainPictoElement();

    container.appendChild(picto); // ajout dans le container principal du panneau d'information

    var divI = this._createMainInfoElement();

    container.appendChild(divI); // creation du mode draggable

    this._createDraggableElement(this._overlaysList, this); // desactivation des evenements qui peuvent interférer avec la carte


    leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomEvent.disableClickPropagation(container).disableScrollPropagation(container); // gestion des evenements en interaction avec la carte

    this._map.on("moveend", this._onOutOfRangeLayerZoom, this); // gestion des CSS en fonction du placement du controle


    switch (this.getPosition()) {
      case "topright":
        container.style.position = "relative";
        container.style.top = "0";
        container.style.right = "0";
        break;

      case "topleft":
        container.style.position = "relative";
        container.style.top = "0";
        container.style.right = "initial";
        picto.style["float"] = "left";
        divL.style.borderBottomRightRadius = "5px";
        divL.style.borderBottomLeftRadius = "0";
        divI.style.right = "initial";
        divI.style.left = "190px";
        break;

      case "bottomleft":
        container.style.position = "relative";
        container.style.top = "0";
        container.style.right = "initial";
        picto.style["float"] = "left";
        divL.style.borderBottomRightRadius = "5px";
        divL.style.borderBottomLeftRadius = "0";
        divI.style.right = "initial";
        divI.style.left = "190px"; // divI.style.top = "initial";
        // divI.style.bottom = "190px";

        break;

      case "bottomright":
        container.style.position = "relative";
        container.style.top = "0";
        container.style.right = "0"; // divI.style.top = "initial";
        // divI.style.bottom = "190px";

        break;

      default:
        container.style.position = "relative";
        container.style.top = "0";
        container.style.right = "0";
    }
  },

  /**
   * Update the construction of DOM for each layer
   * (extend to L.Control.Layers)
   *
   * Method private call by this.onAdd()
   *
   * @private
   */
  _update: function _update() {
    if (!this._container) {
      return;
    }

    this._overlaysList.innerHTML = "";
    var layersId = [];

    for (var i in this._layers) {
      if (this._layers.hasOwnProperty(i)) {
        layersId.push(i);
      }
    } // inversion du sens des layers dans le controle
    // car on veut le même ordre que sur la map, et comme je suis un peu
    // parano, je re-trie la liste...


    var layers = layersId.sort(function (a, b) {
      var ia = parseInt(a, 10);
      var ib = parseInt(b, 10);
      return ia - ib;
    }).reverse();

    for (var j = 0; j < layers.length; j++) {
      var id = layers[j];
      var obj = this._layers[id];

      this._addItem(obj);
    }
  },

  /**
   * Construction of the DOM for each layer
   * (extend to L.Control.Layers)
   *
   * Method private call by this._update()
   *
   * @private
   * @param {Object} obj - layer
   * @returns {HTMLElement} container
   */
  _addItem: function _addItem(obj) {
    logger.log("_addItem", obj);
    obj.opacity = obj.layer.options.opacity; // ajout de cette option !

    var container = this._createContainerLayerElement(obj); // gestion outOfRange


    obj.layer.options.minZoom > this._map.getZoom() || obj.layer.options.maxZoom < this._map.getZoom() ? leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.addClass(container, "outOfRange") : leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.removeClass(container, "outOfRange"); // ajout du container dans la liste des layers (de type overlay uniquement !)

    this._overlaysList.appendChild(container);

    return container;
  },

  /**
   * Event onLayer change
   * (extend to L.Control.Layers because of version 1.0.0)
   *
   * @private
   * @param {Event} e - event
   */
  _onLayerChange: function _onLayerChange(e) {
    var obj = this._layers[leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.stamp(e.layer)];

    if (!obj) {
      return;
    }

    if (!this._handlingClick) {
      this._update();
    }

    var type = e.type === "layeradd" ? "overlayadd" : "overlayremove";

    if (type) {
      this._map.fire(type, obj);
    }
  },

  /**
   * Event onLayer remove
   * (extend to L.Control.Layers because of version 1.0.0)
   *
   * @private
   * @param {Object} layer - event
   * @returns {Object} layer
   */
  removeLayer: function removeLayer(layer) {
    // clean DOM !
    var id = leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.stamp(layer);
    delete this._layers[id];

    this._update(); // clean Layers


    var map = this._map;

    if (map) {
      if (map.hasLayer(layer)) {
        map.removeLayer(layer);
      }
    }

    return this;
  },
  // ################################################################### //
  // ################ Methodes de l'instance (privées) ################# //
  // ################################################################### //

  /**
   * Set visibility of attribution layer
   * (call by this._onVisibilityLayerClick())
   *
   * @private
   * @param {Object} layer - layer
   */
  _updateVisibilityLayer: function _updateVisibilityLayer(layer) {
    if (!this._map) {
      return;
    }

    this._handlingClick = true;

    var visibility = this._layers[leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.stamp(layer)].visibility;

    if (visibility && !this._map.hasLayer(layer)) {
      // input non checked dans le DOM, on ouvre l'oeil
      // et on ajoute la couche !
      this._map.addLayer(layer);
    } else if (!visibility && this._map.hasLayer(layer)) {
      // input checked dans le DOM, on ferme l'oeil
      // et on supprime la couche !
      this._map.removeLayer(layer);
    } else {
      logger.log("Status unknown layer !?");
    }

    this._handlingClick = false;

    this._refocusOnMap();
  },

  /**
   * Set visibility of layer (DOM)
   * (call by this.setVisibility())
   *
   * @private
   * @param {Object} layer - layer
   */
  _updateVisibilityDOMLayer: function _updateVisibilityDOMLayer(layer) {
    var layerIdx = leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.stamp(layer);
    var visibilityElement = leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.get(this._addUID("GPvisibility_ID_" + layerIdx)); // FIXME ID !

    var visibilityValue = this._layers[layerIdx].visibility;
    visibilityElement.checked = visibilityValue;
  },

  /**
   * Set opacity of layer (DOM)
   * (call by this.setOpacity())
   *
   * @private
   * @param {Object} layer - layer
   */
  _updateOpacityDOMLayer: function _updateOpacityDOMLayer(layer) {
    var layerIdx = leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.stamp(layer);
    var opacityValue = layer.options.opacity;
    var opacityElement = leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.get(this._addUID("GPopacityValue_ID_" + layerIdx)); // FIXME ID !

    opacityElement.innerHTML = parseInt(opacityValue * 100, 10) + "%";
    opacityElement.value = parseInt(opacityValue * 100, 10);
  },
  // ################################################################### //
  // ################## GESTIONNAIRES d'evenements ##################### //
  // ################################################################### //

  /**
   * Event 'zoom' on layers visibility
   *
   * FIXME contrainte sur l'emprise du layer ?
   *
   * @private
   */
  _onOutOfRangeLayerZoom: function _onOutOfRangeLayerZoom() {
    var map = this._map;
    var layers = this._layers;

    for (var i in layers) {
      if (layers.hasOwnProperty(i)) {
        var layer = layers[i].layer;
        var id = layers[i].id;
        var div = leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.get(this._addUID("GPlayerSwitcher_ID_" + id)); // FIXME ID !

        if (layer.options.minZoom > map.getZoom() || layer.options.maxZoom < map.getZoom()) {
          leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.addClass(div, "outOfRange");
        } else {
          leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.removeClass(div, "outOfRange");
        }
      }
    }
  },

  /**
   * Event 'click' on layer visibility
   *
   * @private
   * @param {Event} e - MouseEvent
   */
  _onVisibilityLayerClick: function _onVisibilityLayerClick(e) {
    var visibilityElement = e.target.id; // ex GPvisibilityPicto_ID_26

    var visibilityOrder = _Common_Utils_SelectorID__WEBPACK_IMPORTED_MODULE_2__["default"].index(visibilityElement); // ex. 26
    // on met à jour cette interface...

    this._layers[visibilityOrder].visibility = leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.get(visibilityElement).checked;
    var layer = this._layers[visibilityOrder].layer;

    this._updateVisibilityLayer(layer);
  },

  /**
   * Event 'click' on layer deleted
   *
   * @private
   * @param {Event} e - MouseEvent
   */
  _onDropLayerClick: function _onDropLayerClick(e) {
    var layerElement = e.target.id; // ex GPvisibilityPicto_ID_26

    var layerOrder = _Common_Utils_SelectorID__WEBPACK_IMPORTED_MODULE_2__["default"].index(layerElement); // ex. 26

    var layer = this._layers[layerOrder].layer;
    this.removeLayer(layer);
  },

  /**
   * Event 'onchange' on layer opacity
   *
   * FIXME appel en dur d'un identifiant CSS !
   *
   * @private
   * @param {Event} e - ChangeEvent
   */
  _onChangeLayerOpacity: function _onChangeLayerOpacity(e) {
    var layerElement = e.target.id; // ex GPvisibilityPicto_ID_26

    var layerOrder = _Common_Utils_SelectorID__WEBPACK_IMPORTED_MODULE_2__["default"].index(layerElement); // ex. 26

    var layer = this._layers[layerOrder].layer;
    var opacityValue = e.target.value;
    var opacityId = leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.get(this._addUID("GPopacityValue_ID_" + layerOrder)); // FIXME ID !

    opacityId.innerHTML = opacityValue + "%";

    if (this._map.hasLayer(layer)) {
      if (typeof layer.setOpacity !== "undefined") {
        layer.setOpacity(opacityValue / 100);
      } else {
        // Particularité du format GeoJSON
        layer.setStyle({
          fillOpacity: opacityValue / 100,
          opacity: opacityValue / 100
        });
      }
    }
  },

  /**
   * Event 'click' on opening the information window
   *
   * FIXME appel en dur d'un identifiant CSS !
   *
   * @private
   * @param {Event} e - MouseEvent
   */
  _onOpenLayerInfoClick: function _onOpenLayerInfoClick(e) {
    var layerElement = e.target.id; // ex GPvisibilityPicto_ID_26

    var layerOrder = _Common_Utils_SelectorID__WEBPACK_IMPORTED_MODULE_2__["default"].index(layerElement); // ex. 26

    var layer = this._layers[layerOrder]; // Close layer info panel

    var divId = leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.get(e.target.id);
    var panel = null;
    var info = null;

    if (divId.className === "GPlayerInfoOpened") {
      leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.removeClass(divId, "GPlayerInfoOpened");
      leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.addClass(divId, "GPlayerInfo");
      panel = leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.get(this._addUID("GPlayerInfoPanel"));
      leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.removeClass(panel, "GPpanel");
      leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.removeClass(panel, "GPlayerInfoPanelOpened");
      leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.addClass(panel, "GPlayerInfoPanelClosed");
      info = leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.get(this._addUID("GPlayerInfoContent"));
      panel.removeChild(info);
      return;
    }

    var layers = document.getElementsByClassName("GPlayerInfoOpened");

    for (var i = 0; i < layers.length; i++) {
      layers[i].className = "GPlayerInfo";
    } // Open layer info panel


    leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.removeClass(divId, "GPlayerInfo");
    leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.addClass(divId, "GPlayerInfoOpened");
    panel = leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.get(this._addUID("GPlayerInfoPanel"));
    leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.addClass(panel, "GPpanel");
    leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.removeClass(panel, "GPlayerInfoPanelClosed");
    leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.addClass(panel, "GPlayerInfoPanelOpened");
    info = leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.get(this._addUID("GPlayerInfoContent"));

    if (info) {
      panel.removeChild(info);
    } // on récupére les infos associées au layer pour mettre à jour
    // dynamiquement le contenu du panel d"infos


    var infoLayer = this._createContainerLayerInfoElement(layer);

    panel.appendChild(infoLayer);
  },

  /**
   * Event "drag & drop" on move layer
   *
   * FIXME appel en dur d'un identifiant CSS !
   *
   * @private
   * @param {Event} e - MouseEvent
   */
  _onDragAndDropLayerClick: function _onDragAndDropLayerClick(e) {
    var layerElement = e.target.id; // ex GPvisibilityPicto_ID_26

    var layerOrder = _Common_Utils_SelectorID__WEBPACK_IMPORTED_MODULE_2__["default"].index(layerElement); // ex. 26

    var layer = this._layers[layerOrder];
    logger.log(layer);
    var matchesLayers = document.querySelectorAll("div.GPlayerSwitcher_layer");
    this._lastZIndex = matchesLayers.length;

    for (var i = 0; i < matchesLayers.length; i++) {
      var tag = matchesLayers[i].id;
      var order = _Common_Utils_SelectorID__WEBPACK_IMPORTED_MODULE_2__["default"].index(tag);
      var _layer = this._layers[order].layer;

      if (this.options.autoZIndex && _layer.setZIndex) {
        this._lastZIndex--;

        _layer.setZIndex(this._lastZIndex);
      }
    }
  },
  // ################################################################### //
  // ###### METHODES PUBLIQUES (INTERFACE AVEC LE CONTROLE) ############ //
  // ################################################################### //

  /**
   * Adding layer configuration to be displayed by the control
   *
   * @param {Object} layer - layer to add to layer switcher
   * @param {Object} config - See {@link module:Controls.LayerSwitcher L.geoportalControl.LayerSwitcher()} for layer display config object definition.
   */
  addLayer: function addLayer(layer, config) {
    var map = this._map;
    var cfg = this._layersConfig;

    if (!layer) {
      logger.log("[ERROR] LayerSwitcher:addLayer - missing layer parameter !");
      return;
    }

    if (!map.hasLayer(layer)) {
      logger.log("[WARN] LayerSwitcher:addLayer - layer has not been added on map !");
      map.addLayer(layer);
    }

    var id = leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.stamp(layer);

    for (var i in cfg) {
      if (cfg.hasOwnProperty(i)) {
        // layer already added !
        if (id === leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.stamp(cfg[i].layer)) {
          delete cfg[i];
          break;
        }
      }
    }

    var _config = config || {};

    leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.Util.extend(_config, {
      layer: layer
    });
    cfg.push(_config); // layer déjà configuré, il reprend sa place !

    if (!this._layers[id]) {
      layer.setZIndex(this._lastZIndex++);
    }

    this.addOverlay(layer);

    this._update();
  },

  /**
   * Set the opacity of a layer, and opacity must be a number from 0 to 1.
   *
   * @param {Object} layer - layer into layerswitcher
   * @param {Number} opacity - 0-1.
   */
  setOpacity: function setOpacity(layer, opacity) {
    logger.trace(layer, opacity);

    if (opacity > 1 || opacity < 0) {
      return;
    }

    if (this._map.hasLayer(layer)) {
      if (typeof layer.setOpacity !== "undefined") {
        layer.setOpacity(opacity);
      } else {
        // Particularité du format GeoJSON pour l'opacité
        layer.options.opacity = opacity;
        layer.setStyle({
          fillOpacity: opacity,
          opacity: opacity
        });
      }

      this._updateOpacityDOMLayer(layer);
    }
  },

  /**
   * Set the visibility of a layer.
   *
   * @param {Object} layer - layer into layerswitcher
   * @param {Object} visibility - true/false.
   */
  setVisibility: function setVisibility(layer, visibility) {
    logger.trace(layer, visibility);
    this._layers[leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.stamp(layer)].visibility = visibility;

    this._updateVisibilityDOMLayer(layer);

    this._updateVisibilityLayer(layer);
  }
});
/* harmony default export */ __webpack_exports__["default"] = (LayerSwitcher);

/***/ }),
/* 34 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var loglevel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(35);
/* harmony import */ var loglevel__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(loglevel__WEBPACK_IMPORTED_MODULE_0__);

var LoggerByDefault = {
  /**
   *logger statique
   * @param {String} [name="default"] - the logger name
   *
   * @returns {Object} logger
   */
  getLogger: function getLogger(name) {
    // Substitute global constants configured at compile time
    // cf. webpack.config.js
    // on masque cette constante afin d'eviter "referenceerror not defined"
    "false".match(/true/) ? loglevel__WEBPACK_IMPORTED_MODULE_0__["disableAll"]() : loglevel__WEBPACK_IMPORTED_MODULE_0__["enableAll"]();
    var logname = name || "default";
    return loglevel__WEBPACK_IMPORTED_MODULE_0__["getLogger"](logname);
  }
};
/* harmony default export */ __webpack_exports__["default"] = (LoggerByDefault);

/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
* loglevel - https://github.com/pimterry/loglevel
*
* Copyright (c) 2013 Tim Perry
* Licensed under the MIT license.
*/
(function (root, definition) {
    "use strict";
    if (true) {
        !(__WEBPACK_AMD_DEFINE_FACTORY__ = (definition),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.call(exports, __webpack_require__, exports, module)) :
				__WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else {}
}(this, function () {
    "use strict";

    // Slightly dubious tricks to cut down minimized file size
    var noop = function() {};
    var undefinedType = "undefined";
    var isIE = (typeof window !== undefinedType) && (typeof window.navigator !== undefinedType) && (
        /Trident\/|MSIE /.test(window.navigator.userAgent)
    );

    var logMethods = [
        "trace",
        "debug",
        "info",
        "warn",
        "error"
    ];

    // Cross-browser bind equivalent that works at least back to IE6
    function bindMethod(obj, methodName) {
        var method = obj[methodName];
        if (typeof method.bind === 'function') {
            return method.bind(obj);
        } else {
            try {
                return Function.prototype.bind.call(method, obj);
            } catch (e) {
                // Missing bind shim or IE8 + Modernizr, fallback to wrapping
                return function() {
                    return Function.prototype.apply.apply(method, [obj, arguments]);
                };
            }
        }
    }

    // Trace() doesn't print the message in IE, so for that case we need to wrap it
    function traceForIE() {
        if (console.log) {
            if (console.log.apply) {
                console.log.apply(console, arguments);
            } else {
                // In old IE, native console methods themselves don't have apply().
                Function.prototype.apply.apply(console.log, [console, arguments]);
            }
        }
        if (console.trace) console.trace();
    }

    // Build the best logging method possible for this env
    // Wherever possible we want to bind, not wrap, to preserve stack traces
    function realMethod(methodName) {
        if (methodName === 'debug') {
            methodName = 'log';
        }

        if (typeof console === undefinedType) {
            return false; // No method possible, for now - fixed later by enableLoggingWhenConsoleArrives
        } else if (methodName === 'trace' && isIE) {
            return traceForIE;
        } else if (console[methodName] !== undefined) {
            return bindMethod(console, methodName);
        } else if (console.log !== undefined) {
            return bindMethod(console, 'log');
        } else {
            return noop;
        }
    }

    // These private functions always need `this` to be set properly

    function replaceLoggingMethods(level, loggerName) {
        /*jshint validthis:true */
        for (var i = 0; i < logMethods.length; i++) {
            var methodName = logMethods[i];
            this[methodName] = (i < level) ?
                noop :
                this.methodFactory(methodName, level, loggerName);
        }

        // Define log.log as an alias for log.debug
        this.log = this.debug;
    }

    // In old IE versions, the console isn't present until you first open it.
    // We build realMethod() replacements here that regenerate logging methods
    function enableLoggingWhenConsoleArrives(methodName, level, loggerName) {
        return function () {
            if (typeof console !== undefinedType) {
                replaceLoggingMethods.call(this, level, loggerName);
                this[methodName].apply(this, arguments);
            }
        };
    }

    // By default, we use closely bound real methods wherever possible, and
    // otherwise we wait for a console to appear, and then try again.
    function defaultMethodFactory(methodName, level, loggerName) {
        /*jshint validthis:true */
        return realMethod(methodName) ||
               enableLoggingWhenConsoleArrives.apply(this, arguments);
    }

    function Logger(name, defaultLevel, factory) {
      var self = this;
      var currentLevel;

      var storageKey = "loglevel";
      if (typeof name === "string") {
        storageKey += ":" + name;
      } else if (typeof name === "symbol") {
        storageKey = undefined;
      }

      function persistLevelIfPossible(levelNum) {
          var levelName = (logMethods[levelNum] || 'silent').toUpperCase();

          if (typeof window === undefinedType || !storageKey) return;

          // Use localStorage if available
          try {
              window.localStorage[storageKey] = levelName;
              return;
          } catch (ignore) {}

          // Use session cookie as fallback
          try {
              window.document.cookie =
                encodeURIComponent(storageKey) + "=" + levelName + ";";
          } catch (ignore) {}
      }

      function getPersistedLevel() {
          var storedLevel;

          if (typeof window === undefinedType || !storageKey) return;

          try {
              storedLevel = window.localStorage[storageKey];
          } catch (ignore) {}

          // Fallback to cookies if local storage gives us nothing
          if (typeof storedLevel === undefinedType) {
              try {
                  var cookie = window.document.cookie;
                  var location = cookie.indexOf(
                      encodeURIComponent(storageKey) + "=");
                  if (location !== -1) {
                      storedLevel = /^([^;]+)/.exec(cookie.slice(location))[1];
                  }
              } catch (ignore) {}
          }

          // If the stored level is not valid, treat it as if nothing was stored.
          if (self.levels[storedLevel] === undefined) {
              storedLevel = undefined;
          }

          return storedLevel;
      }

      /*
       *
       * Public logger API - see https://github.com/pimterry/loglevel for details
       *
       */

      self.name = name;

      self.levels = { "TRACE": 0, "DEBUG": 1, "INFO": 2, "WARN": 3,
          "ERROR": 4, "SILENT": 5};

      self.methodFactory = factory || defaultMethodFactory;

      self.getLevel = function () {
          return currentLevel;
      };

      self.setLevel = function (level, persist) {
          if (typeof level === "string" && self.levels[level.toUpperCase()] !== undefined) {
              level = self.levels[level.toUpperCase()];
          }
          if (typeof level === "number" && level >= 0 && level <= self.levels.SILENT) {
              currentLevel = level;
              if (persist !== false) {  // defaults to true
                  persistLevelIfPossible(level);
              }
              replaceLoggingMethods.call(self, level, name);
              if (typeof console === undefinedType && level < self.levels.SILENT) {
                  return "No console available for logging";
              }
          } else {
              throw "log.setLevel() called with invalid level: " + level;
          }
      };

      self.setDefaultLevel = function (level) {
          if (!getPersistedLevel()) {
              self.setLevel(level, false);
          }
      };

      self.enableAll = function(persist) {
          self.setLevel(self.levels.TRACE, persist);
      };

      self.disableAll = function(persist) {
          self.setLevel(self.levels.SILENT, persist);
      };

      // Initialize with the right level
      var initialLevel = getPersistedLevel();
      if (initialLevel == null) {
          initialLevel = defaultLevel == null ? "WARN" : defaultLevel;
      }
      self.setLevel(initialLevel, false);
    }

    /*
     *
     * Top-level API
     *
     */

    var defaultLogger = new Logger();

    var _loggersByName = {};
    defaultLogger.getLogger = function getLogger(name) {
        if ((typeof name !== "symbol" && typeof name !== "string") || name === "") {
          throw new TypeError("You must supply a name when creating a logger.");
        }

        var logger = _loggersByName[name];
        if (!logger) {
          logger = _loggersByName[name] = new Logger(
            name, defaultLogger.getLevel(), defaultLogger.methodFactory);
        }
        return logger;
    };

    // Grab the current global log variable in case of overwrite
    var _log = (typeof window !== undefinedType) ? window.log : undefined;
    defaultLogger.noConflict = function() {
        if (typeof window !== undefinedType &&
               window.log === defaultLogger) {
            window.log = _log;
        }

        return defaultLogger;
    };

    defaultLogger.getLoggers = function getLoggers() {
        return _loggersByName;
    };

    // ES6 default export, for compatibility
    defaultLogger['default'] = defaultLogger;

    return defaultLogger;
}));


/***/ }),
/* 36 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/**
 * formalisme d'un tag ID :
 * -> NAME(_ORDER)-1460636385836
 *
 * Ex.
 *   GProutePoints-1460636385836
 *   GProutePoint_10-1460636385836
 */
var SelectorID = {
  /**
   * Construction d'un identifiant statique basé sur le timestamp,
   * et qui s'incremente de +1 à chaque appel
   */
  generate: function () {
    var timestamp = Math.floor(Date.now());
    return function () {
      return timestamp++;
    };
  }(),

  /**
   * nom du tag
   * @param {String} id - the id
   *
   * @returns {String} index
   */
  name: function name(id) {
    var name = null;
    var i = id.lastIndexOf("-");

    if (i === -1) {
      name = id;
    } else {
      name = id.substring(0, i);
    }

    return name;
  },

  /**
   * numero d'identifiant du tag
   * @param {String} id - the id
   *
   * @returns {String} index
   */
  index: function index(id) {
    var index = null;
    var name = this.name(id); // if (name !== id) {

    var i = name.lastIndexOf("_");

    if (i !== -1) {
      index = name.substring(i + 1);
    } // }


    return index;
  },

  /**
   * uuid du tag
   * @param {String} id - the id
   *
   * @returns {String} uuid
   */
  uuid: function uuid(id) {
    var uuid = null;
    var i = id.lastIndexOf("-");

    if (i !== -1) {
      uuid = parseInt(id.substring(i + 1), 10);
    }

    return uuid;
  }
};
/* harmony default export */ __webpack_exports__["default"] = (SelectorID);

/***/ }),
/* 37 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var sortablejs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38);
/* harmony import */ var sortablejs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(sortablejs__WEBPACK_IMPORTED_MODULE_0__);

var LayerSwitcherDOM = {
  /**
   * Creation du drag and drop
   *
   * @param {Object} elementDraggable - Element HTML (DOM) Container
   * @param {Object} context - this
   */
  _createDraggableElement: function _createDraggableElement(elementDraggable, context) {
    sortablejs__WEBPACK_IMPORTED_MODULE_0___default.a.create(elementDraggable, {
      handle: ".GPlayerName",
      draggable: ".draggable-layer",
      ghostClass: "GPghostLayer",
      animation: 200,
      // Call event function on drag and drop
      onEnd: function onEnd(e) {
        // FIXME pas terrrible, mais il faut bien passer ce contexte...
        context._onDragAndDropLayerClick(e);
      }
    });
  },
  // ################################################################### //
  // ######################### Main container ########################## //
  // ################################################################### //

  /**
  * Add uuid to the tag ID
  * @param {String} id - id selector
  * @returns {String} uid - id selector with an unique id
  */
  _addUID: function _addUID(id) {
    var uid = this._uid ? id + "-" + this._uid : id;
    return uid;
  },

  /**
   * Creation du container principal (DOM)
   *
   * @returns {DOMElement} container - layer switcher DOM element
   */
  _createMainContainerElement: function _createMainContainerElement() {
    var container = document.createElement("div");
    container.id = this._addUID("GPlayerSwitcher");
    container.className = "GPwidget";
    return container;
  },

  /**
   * Creation du container principal d"affichage des layers (DOM)
   *
   * @returns {DOMElement} input - element for minimizing/maximizing the layer switcher
   */
  _createMainLayersShowElement: function _createMainLayersShowElement() {
    // <!-- Hidden checkbox for minimizing/maximizing -->
    var input = document.createElement("input");
    input.id = this._addUID("GPshowLayersList");
    input.type = "checkbox";
    return input;
  },

  /**
   * Creation du container principal des layers (DOM)
   *
   * @returns {DOMElement} container - layers list container
   */
  _createMainLayersElement: function _createMainLayersElement() {
    // ajout de la liste des layers dans le container principal
    // <div id="GPlayersList" class="GPpanel">
    //   (...)
    // </div>
    var div = document.createElement("div");
    div.id = this._addUID("GPlayersList");
    div.className = "GPpanel";
    return div;
  },

  /**
   * Creation du container du picto du controle (DOM)
   *
   * @returns {DOMElement} label
   */
  _createMainPictoElement: function _createMainPictoElement() {
    var self = this; // exemple :
    // <!-- Label for minimizing/maximizing -->
    // <label id="GPshowLayersListPicto" class="GPshowAdvancedToolPicto" for="GPshowLayersList" title="Afficher/masquer le gestionnaire de couches">
    //    <span id="GPshowLayersListOpen" class="GPshowAdvancedToolOpen"></span><span id="GPshowLayersListClose"></span>
    // </label>

    var label = document.createElement("label");
    label.id = this._addUID("GPshowLayersListPicto");
    label.className = "GPshowAdvancedToolPicto";
    label.htmlFor = this._addUID("GPshowLayersList");
    label.title = "Afficher/masquer le gestionnaire de couches";
    var spanOpen = document.createElement("span");
    spanOpen.id = this._addUID("GPshowLayersListOpen");
    spanOpen.className = "GPshowAdvancedToolOpen";
    spanOpen.addEventListener("click", function () {
      if (document.getElementById(self._addUID("GPshowLayersList")).checked) {
        var layers = document.getElementsByClassName("GPlayerInfoOpened");

        for (var i = 0; i < layers.length; i++) {
          layers[i].className = "GPlayerInfo";
        }

        document.getElementById(self._addUID("GPlayerInfoPanel")).className = "GPlayerInfoPanelClosed";
      }
    });
    label.appendChild(spanOpen);
    var spanClose = document.createElement("span");
    spanClose.addEventListener("click", function () {
      if (document.getElementById(self._addUID("GPshowLayersList")).checked) {
        var layers = document.getElementsByClassName("GPlayerInfoOpened");

        for (var i = 0; i < layers.length; i++) {
          layers[i].className = "GPlayerInfo";
        }

        document.getElementById(self._addUID("GPlayerInfoPanel")).className = "GPlayerInfoPanelClosed";
      }
    });
    spanClose.id = self._addUID("GPshowLayersListClose");
    label.appendChild(spanClose);
    return label;
  },

  /**
   * Creation du container du panneau d"information (DOM)
   *
   * @returns {DOMElement} container
   */
  _createMainInfoElement: function _createMainInfoElement() {
    // gestion du panneau d"information dans le container principal
    // <div id="GPlayerInfoPanel" class="GPlayerInfoPanelClosed">...</div>
    var div = document.createElement("div");
    div.id = this._addUID("GPlayerInfoPanel");
    div.className = "GPpanel GPlayerInfoPanelClosed";
    return div;
  },
  // ################################################################### //
  // ######################### Layer container ######################### //
  // ################################################################### //

  /**
   * Creation du container du layer (DOM)
   *
   * @param {Object} obj - options de la couche à ajouter dans le layer switcher
   * @param {Object} obj.layer - couche (ol ou leaflet)
   * @param {String} obj.id - identifiant de la couche (pour ol ou leaflet)
   * @param {String} obj.title - nom de la couche à afficher dans le controle
   * @param {String} obj.description - description de la couche à afficher
   * @param {Boolean} obj.visibility - visibilité de la couche dans la carte (true or false)
   * @param {Float} obj.opacity - opacité de la couche
   *
   * @returns {DOMElement} container
   */
  _createContainerLayerElement: function _createContainerLayerElement(obj) {
    // exemple :
    // <div id="GPlayerSwitcher_ID_Layer1" class="GPlayerSwitcher_layer outOfRange">
    //     <!-- Basic toolbar : visibility / layer name
    //     _createBasicToolElement
    //           _createBasicToolVisibilityElement
    //           _createBasicToolNameElement
    //     -->
    //     <!-- Hidden checkbox + label for showing advanced toolbar
    //     _createAdvancedToolShowElement
    //     -->
    //     <!-- Advanced toolbar : layer info / opacity slider / opacity value / removal
    //     _createAdvancedToolElement
    //           _createAdvancedToolDeleteElement
    //           _createAdvancedToolInformationElement
    //           _createAdvancedToolOpacityElement
    //     -->
    // </div>
    // <!-- Layer entry in layer list -->
    // <!-- Every item is marked with layerID, which is defined at layer import -->
    var container = document.createElement("div");
    container.id = this._addUID("GPlayerSwitcher_ID_" + obj.id);
    container.className = "GPlayerSwitcher_layer draggable-layer"; // ajout des outils basiques (visibility / layer name)

    container.appendChild(this._createBasicToolElement(obj)); // liste des outils avancés (layer info / opacity slider / opacity value / removal)

    var array = this._createAdvancedToolShowElement(obj);

    for (var i = 0; i < array.length; i++) {
      container.appendChild(array[i]);
    } // ajout des outils avancés


    container.appendChild(this._createAdvancedToolElement(obj));
    return container;
  },
  // ################################################################### //
  // ############################ Layer tool ########################### //
  // ################################################################### //

  /**
   * Creation du container des outils basiques du layer (DOM)
   *
   * @param {Object} obj - options de la couche à ajouter dans le layer switcher
   *
   * @returns {DOMElement} container
   */
  _createBasicToolElement: function _createBasicToolElement(obj) {
    // exemple :
    // <div id="GPbasicTools_ID_1" class="GPlayerBasicTools">
    //      <!-- _createBasicToolVisibilityElement -->
    //      <!-- _createBasicToolNameElement -->
    // </div>
    var div = document.createElement("div");
    div.id = this._addUID("GPbasicTools_ID_" + obj.id);
    div.className = "GPlayerBasicTools";
    div.appendChild(this._createBasicToolNameElement(obj));

    var array = this._createBasicToolVisibilityElement(obj);

    for (var i = 0; i < array.length; i++) {
      div.appendChild(array[i]);
    }

    return div;
  },

  /**
   * Creation du nom du layer (DOM)
   *
   * @param {Object} obj - options de la couche à ajouter dans le layer switcher
   *
   * @returns {DOMElement} container
   */
  _createBasicToolNameElement: function _createBasicToolNameElement(obj) {
    // exemple :
    // <span id="GPname_ID_Layer1" class="GPlayerName" title="Quartiers prioritaires de la ville">Quartiers prioritaires de la ville</span>
    var span = document.createElement("span");
    span.id = this._addUID("GPname_ID_" + obj.id);
    span.className = "GPlayerName";
    span.title = obj.description || obj.title;
    span.innerHTML = obj.title;
    return span;
  },

  /**
   * Creation de l'icone de visibilité du layer (DOM)
   *
   * @param {Object} obj - options de la couche à ajouter dans le layer switcher
    * @returns {DOMElement[]} array containing input and label elements
   */
  _createBasicToolVisibilityElement: function _createBasicToolVisibilityElement(obj) {
    // exemple :
    // <input type="checkbox" id="GPvisibility_ID_Layer1" checked="">
    // <label for="GPvisibility_ID_Layer1" id="GPvisibilityPicto_ID_Layer1" class="GPlayerVisibility" title="Afficher/masquer la couche"></label>
    var list = [];
    var checked = typeof obj.visibility !== "undefined" ? obj.visibility : true;

    var id = this._addUID("GPvisibility_ID_" + obj.id);

    var input = document.createElement("input");
    input.id = id;
    input.type = "checkbox";
    input.checked = checked;
    var label = document.createElement("label");
    label.htmlFor = id;
    label.id = this._addUID("GPvisibilityPicto_ID_" + obj.id);
    label.className = "GPlayerVisibility";
    label.title = "Afficher/masquer la couche"; // add event for visibility change

    var context = this;

    if (input.addEventListener) {
      input.addEventListener("click", function (e) {
        context._onVisibilityLayerClick(e);
      });
    } else if (input.attachEvent) {
      // internet explorer
      input.attachEvent("onclick", function (e) {
        context._onVisibilityLayerClick(e);
      });
    }

    list.push(input);
    list.push(label);
    return list;
  },

  /**
   * Creation de l'affichage du menu des outils avancés du layer (DOM)
   *
   * @param {Object} obj - options de la couche à ajouter dans le layer switcher
   *
   * @returns {DOMElement[]} array containing input and label elements
   */
  _createAdvancedToolShowElement: function _createAdvancedToolShowElement(obj) {
    // <input type="checkbox" id="GPshowAdvancedTools_ID_Layer1">
    // <label for="GPshowAdvancedTools_ID_Layer1" id="GPshowAdvancedToolsPicto_ID_Layer1" class="GPshowMoreOptions GPshowLayerAdvancedTools" title="Plus d'outils"></label>
    var list = [];
    var label = document.createElement("label");
    label.id = this._addUID("GPshowAdvancedToolsPicto_ID_" + obj.id);
    label.htmlFor = this._addUID("GPshowAdvancedTools_ID_" + obj.id);
    label.title = "Plus d'outils";
    label.className = "GPshowMoreOptions GPshowLayerAdvancedTools";
    var input = document.createElement("input");
    input.type = "checkbox";
    input.id = this._addUID("GPshowAdvancedTools_ID_" + obj.id);
    list.push(input);
    list.push(label);
    return list;
  },

  /**
   * Creation du container des outils avancés du layer (DOM)
   *
   * @param {Object} obj - options de la couche à ajouter dans le layer switcher
   *
   * @returns {DOMElement} container
   */
  _createAdvancedToolElement: function _createAdvancedToolElement(obj) {
    // exemple :
    // <div id="GPadvancedTools_ID_Layer1" class="GPlayerAdvancedTools">
    //     <!-- _createAdvancedToolDeleteElement -->
    //     <!-- _createAdvancedToolInformationElement -->
    //     <!-- _createAdvancedToolOpacityElement -->
    // </div>
    var container = document.createElement("div");
    container.id = this._addUID("GPadvancedTools_ID_" + obj.id);
    container.className = "GPlayerAdvancedTools";
    container.appendChild(this._createAdvancedToolDeleteElement(obj)); // si on n'a de l'informations à afficher, on met en place ce composant

    if (obj.title && obj.description) {
      container.appendChild(this._createAdvancedToolInformationElement(obj));
    }

    if (obj.type !== "feature") {
      var array = this._createAdvancedToolOpacityElement(obj);

      for (var i = 0; i < array.length; i++) {
        container.appendChild(array[i]);
      }
    }

    return container;
  },

  /**
   * Creation de l'icone de suppression du layer (DOM)
   *
   * @param {Object} obj - options de la couche à ajouter dans le layer switcher
   *
   * @returns {DOMElement} container
   */
  _createAdvancedToolDeleteElement: function _createAdvancedToolDeleteElement(obj) {
    // exemple :
    // <div id="GPremove_ID_Layer1" class="GPlayerRemove" title="Supprimer la couche" onclick="GPdropLayer(this);"></div>
    var div = document.createElement("div");
    div.id = this._addUID("GPremove_ID_" + obj.id);
    div.className = "GPlayerRemove";
    div.title = "Supprimer la couche";
    div.layerId = obj.id;
    var context = this;

    if (div.addEventListener) {
      div.addEventListener("click", function (e) {
        context._onDropLayerClick(e);
      });
    } else if (div.attachEvent) {
      // internet explorer
      div.attachEvent("onclick", function (e) {
        context._onDropLayerClick(e);
      });
    }

    return div;
  },

  /**
   * Creation de l'icone d'information du layer (DOM)
   *
   * @param {Object} obj - options de la couche à ajouter dans le layer switcher
   *
   * @returns {DOMElement} container
   */
  _createAdvancedToolInformationElement: function _createAdvancedToolInformationElement(obj) {
    // exemple :
    // <div id="GPinfo_ID_Layer1" class="GPlayerInfo" title="Informations/légende" onclick="GPopenLayerInfo(this);"></div>
    var div = document.createElement("div");
    div.id = this._addUID("GPinfo_ID_" + obj.id);
    div.className = "GPlayerInfo";
    div.title = "Informations/légende";
    div.layerId = obj.id; // add event on click

    var context = this;

    if (div.addEventListener) {
      div.addEventListener("click", function (e) {
        context._onOpenLayerInfoClick(e);
      });
    } else if (div.attachEvent) {
      // internet explorer
      div.attachEvent("onclick", function (e) {
        context._onOpenLayerInfoClick(e);
      });
    }

    return div;
  },

  /**
   * Creation de l'icone de gestion de l'opacité du layer (DOM)
   *
   * @param {Object} obj - options de la couche à ajouter dans le layer switcher
   *
   * @returns {DOMElement[]} array of two containers
   */
  _createAdvancedToolOpacityElement: function _createAdvancedToolOpacityElement(obj) {
    // exemple :
    // <div id="GPopacity_ID_Layer1" class="GPlayerOpacity" title="Opacité">
    //   <input id="GPopacityRange_ID_Layer1" type="range" value="100" oninput="GPchangeLayerOpacity(this);" onchange="GPchangeLayerOpacity(this);">
    // </div>
    // <div class="GPlayerOpacityValue" id="GPopacityValueDiv_ID_Layer1">
    //   <span id="GPopacityValue_ID_Layer1">100</span>
    //   %
    // </div>
    var list = []; // curseur pour changer l'opacité

    var divO = document.createElement("div");
    divO.id = this._addUID("GPopacity_ID_" + obj.id);
    divO.className = "GPlayerOpacity";
    divO.title = "Opacité";
    var opacity = typeof obj.opacity !== "undefined" ? obj.opacity : 1;
    opacity = Math.round(opacity * 100);
    var input = document.createElement("input");
    input.id = this._addUID("GPopacityValueDiv_ID_" + obj.id);
    input.type = "range";
    input.value = opacity; // add event for opacity change

    var context = this;

    if (input.addEventListener) {
      input.addEventListener("change", function (e) {
        context._onChangeLayerOpacity(e);
      });
    } else if (input.attachEvent) {
      // internet explorer
      input.attachEvent("onchange", function (e) {
        context._onChangeLayerOpacity(e);
      });
    }

    if (input.addEventListener) {
      input.addEventListener("input", function (e) {
        context._onChangeLayerOpacity(e);
      });
    } else if (input.attachEvent) {
      // internet explorer
      input.attachEvent("oninput", function (e) {
        context._onChangeLayerOpacity(e);
      });
    }

    divO.appendChild(input); // Valeur d'opacité

    var divC = document.createElement("div");
    divC.id = this._addUID("GPopacityValueDiv_ID_" + obj.id);
    divC.className = "GPlayerOpacityValue";
    var span = document.createElement("span");
    span.id = this._addUID("GPopacityValue_ID_" + obj.id);
    span.innerHTML = opacity + "%";
    divC.appendChild(span);
    list.push(divO);
    list.push(divC);
    return list;
  },
  // ################################################################### //
  // ############################ Layer info ########################### //
  // ################################################################### //

  /**
   * Creation du container du layer info (DOM)
   *
   * TODO GPlayerInfoPopup : ???
   * TODO GPlayerInfoLink  : mettre en forme les échelles !
   *
   * @param {Object} obj - options de la couche à ajouter dans le layer switcher
   *
   * @returns {DOMElement} container
   */
  _createContainerLayerInfoElement: function _createContainerLayerInfoElement(obj) {
    var container = document.createElement("div");
    container.id = this._addUID("GPlayerInfoContent");
    var title = document.createElement("div");
    title.id = this._addUID("GPlayerInfoTitle");
    title.innerHTML = obj.title;
    container.appendChild(title);

    if (obj.quicklookUrl) {
      var quick = document.createElement("div");
      quick.id = this._addUID("GPlayerInfoQuicklook");
      quick.title = "Afficher un aperçu de la couche";
      var refquick = document.createElement("a");
      refquick.href = obj.quicklookUrl;
      refquick.appendChild(quick);
      container.appendChild(refquick);
    }

    var close = document.createElement("div");
    close.id = this._addUID("GPlayerInfoClose");
    close.title = "Fermer la fenêtre";
    var self = this;
    /** Call event function on close click */

    var onCloseClick = function onCloseClick() {
      document.getElementById(self._addUID("GPlayerInfoPanel")).className = "GPlayerInfoPanelClosed";
      var layers = document.getElementsByClassName("GPlayerInfoOpened");

      for (var i = 0; i < layers.length; i++) {
        layers[i].className = "GPlayerInfo";
      }
    };

    if (close.addEventListener) {
      close.addEventListener("click", onCloseClick);
    } else if (close.attachEvent) {
      // internet explorer
      close.attachEvent("onclick", onCloseClick);
    }

    container.appendChild(close);
    var desc = document.createElement("div");
    desc.id = this._addUID("GPlayerInfoDescription");
    desc.innerHTML = obj.description;
    container.appendChild(desc);

    if (obj.metadata) {
      var mtd = document.createElement("div");
      mtd.id = this._addUID("GPlayerInfoMetadata");
      var mtdtitle = document.createElement("div");
      mtdtitle.className = "GPlayerInfoSubtitle";
      mtdtitle.innerHTML = "Métadonnées";
      mtd.appendChild(mtdtitle);

      for (var i = 0; i < obj.metadata.length; i++) {
        var urlmtd = obj.metadata[i].url;
        var mtdlink = document.createElement("div");
        mtdlink.className = "GPlayerInfoLink";
        var refmtd = document.createElement("a");
        refmtd.href = urlmtd;
        refmtd.innerHTML = urlmtd;
        mtdlink.appendChild(refmtd);
        mtd.appendChild(mtdlink);
      }

      if (obj.metadata.length !== 0) {
        container.appendChild(mtd);
      }
    }

    if (obj.legends) {
      var lgd = document.createElement("div");
      lgd.id = this._addUID("GPlayerInfoLegend");
      var lgdtitle = document.createElement("div");
      lgdtitle.className = "GPlayerInfoSubtitle";
      lgdtitle.innerHTML = "Légende";
      lgd.appendChild(lgdtitle);
      var legends = {};
      var maxScale = obj.maxScaleDenominator || 560000000; // on crée un tableau temporaire pour ordonner les légendes selon le dénominateur d'échelle

      for (var k = 0; k < obj.legends.length; k++) {
        var minScale = obj.legends[k].minScaleDenominator;

        if (minScale) {
          var s = minScale.toString();
          minScale = Math.round(parseInt(s.substring(0, 3), 10) / 10) * Math.pow(10, s.length - 2);
        } else {
          minScale = 270;
        }

        legends[minScale] = obj.legends[k];
      }

      for (var scale in legends) {
        if (legends.hasOwnProperty(scale)) {
          var urllgd = legends[scale].url; // on n'affiche pas les légendes pointant vers "nolegend.jpg"

          if (typeof urllgd === "string" && urllgd.toLowerCase().indexOf("nolegend.jpg") === -1) {
            // TODO GPlayerInfoPopup
            var lgdlink = document.createElement("div");
            lgdlink.className = "GPlayerInfoLink";
            maxScale = legends[scale].maxScaleDenominator || maxScale;
            var reflgd = document.createElement("a");
            reflgd.href = urllgd;
            reflgd.innerHTML = "Du 1/" + scale + " au 1/" + maxScale;
            lgdlink.appendChild(reflgd);
            lgd.appendChild(lgdlink);
          } else {
            delete legends[scale];
          }
        }
      }

      if (Object.keys(legends).length !== 0) {
        container.appendChild(lgd);
      }
    }

    return container;
  }
};
/* harmony default export */ __webpack_exports__["default"] = (LayerSwitcherDOM);

/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_RESULT__;/**!
 * Sortable
 * @author	RubaXa   <trash@rubaxa.org>
 * @author	owenm    <owen23355@gmail.com>
 * @license MIT
 */

(function sortableModule(factory) {
	"use strict";

	if (true) {
		!(__WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.call(exports, __webpack_require__, exports, module)) :
				__WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	}
	else {}
})(function sortableFactory() {
	"use strict";

	if (typeof window === "undefined" || !window.document) {
		return function sortableError() {
			throw new Error("Sortable.js requires a window with a document");
		};
	}

	var dragEl,
		parentEl,
		ghostEl,
		cloneEl,
		rootEl,
		nextEl,
		lastDownEl,

		scrollEl,
		scrollParentEl,
		scrollCustomFn,

		oldIndex,
		newIndex,

		activeGroup,
		putSortable,

		autoScrolls = [],
		scrolling = false,

		awaitingDragStarted = false,
		ignoreNextClick = false,
		sortables = [],

		pointerElemChangedInterval,
		lastPointerElemX,
		lastPointerElemY,

		tapEvt,
		touchEvt,

		moved,


		lastTarget,
		lastDirection,
		pastFirstInvertThresh = false,
		isCircumstantialInvert = false,
		lastMode, // 'swap' or 'insert'

		targetMoveDistance,

		// For positioning ghost absolutely
		ghostRelativeParent,
		ghostRelativeParentInitialScroll = [], // (left, top)


		forRepaintDummy,
		realDragElRect, // dragEl rect after current animation

		/** @const */
		R_SPACE = /\s+/g,

		expando = 'Sortable' + (new Date).getTime(),

		win = window,
		document = win.document,
		parseInt = win.parseInt,
		setTimeout = win.setTimeout,

		$ = win.jQuery || win.Zepto,
		Polymer = win.Polymer,

		captureMode = {
			capture: false,
			passive: false
		},

		IE11OrLess = !!navigator.userAgent.match(/(?:Trident.*rv[ :]?11\.|msie|iemobile)/i),
		Edge = !!navigator.userAgent.match(/Edge/i),
		FireFox = !!navigator.userAgent.match(/firefox/i),
		Safari = !!(navigator.userAgent.match(/safari/i) && !navigator.userAgent.match(/chrome/i) && !navigator.userAgent.match(/android/i)),
		IOS = !!(navigator.userAgent.match(/iP(ad|od|hone)/i)),

		PositionGhostAbsolutely = IOS,

		CSSFloatProperty = Edge || IE11OrLess ? 'cssFloat' : 'float',

		// This will not pass for IE9, because IE9 DnD only works on anchors
		supportDraggable = ('draggable' in document.createElement('div')),

		supportCssPointerEvents = (function() {
			// false when <= IE11
			if (IE11OrLess) {
				return false;
			}
			var el = document.createElement('x');
			el.style.cssText = 'pointer-events:auto';
			return el.style.pointerEvents === 'auto';
		})(),

		_silent = false,
		_alignedSilent = false,

		abs = Math.abs,
		min = Math.min,
		max = Math.max,

		savedInputChecked = [],

		_detectDirection = function(el, options) {
			var elCSS = _css(el),
				elWidth = parseInt(elCSS.width)
					- parseInt(elCSS.paddingLeft)
					- parseInt(elCSS.paddingRight)
					- parseInt(elCSS.borderLeftWidth)
					- parseInt(elCSS.borderRightWidth),
				child1 = _getChild(el, 0, options),
				child2 = _getChild(el, 1, options),
				firstChildCSS = child1 && _css(child1),
				secondChildCSS = child2 && _css(child2),
				firstChildWidth = firstChildCSS && parseInt(firstChildCSS.marginLeft) + parseInt(firstChildCSS.marginRight) + _getRect(child1).width,
				secondChildWidth = secondChildCSS && parseInt(secondChildCSS.marginLeft) + parseInt(secondChildCSS.marginRight) + _getRect(child2).width;

			if (elCSS.display === 'flex') {
				return elCSS.flexDirection === 'column' || elCSS.flexDirection === 'column-reverse'
				? 'vertical' : 'horizontal';
			}

			if (elCSS.display === 'grid') {
				return elCSS.gridTemplateColumns.split(' ').length <= 1 ? 'vertical' : 'horizontal';
			}

			if (child1 && firstChildCSS.float !== 'none') {
				var touchingSideChild2 = firstChildCSS.float === 'left' ? 'left' : 'right';

				return child2 && (secondChildCSS.clear === 'both' || secondChildCSS.clear === touchingSideChild2) ?
					'vertical' : 'horizontal';
			}

			return (child1 &&
				(
					firstChildCSS.display === 'block' ||
					firstChildCSS.display === 'flex' ||
					firstChildCSS.display === 'table' ||
					firstChildCSS.display === 'grid' ||
					firstChildWidth >= elWidth &&
					elCSS[CSSFloatProperty] === 'none' ||
					child2 &&
					elCSS[CSSFloatProperty] === 'none' &&
					firstChildWidth + secondChildWidth > elWidth
				) ?
				'vertical' : 'horizontal'
			);
		},

		/**
		 * Detects first nearest empty sortable to X and Y position using emptyInsertThreshold.
		 * @param  {Number} x      X position
		 * @param  {Number} y      Y position
		 * @return {HTMLElement}   Element of the first found nearest Sortable
		 */
		_detectNearestEmptySortable = function(x, y) {
			for (var i = 0; i < sortables.length; i++) {
				if (_lastChild(sortables[i])) continue;

				var rect = _getRect(sortables[i]),
					threshold = sortables[i][expando].options.emptyInsertThreshold,
					insideHorizontally = x >= (rect.left - threshold) && x <= (rect.right + threshold),
					insideVertically = y >= (rect.top - threshold) && y <= (rect.bottom + threshold);

				if (insideHorizontally && insideVertically) {
					return sortables[i];
				}
			}
		},

		_isClientInRowColumn = function(x, y, el, axis, options) {
			var targetRect = _getRect(el),
				targetS1Opp = axis === 'vertical' ? targetRect.left : targetRect.top,
				targetS2Opp = axis === 'vertical' ? targetRect.right : targetRect.bottom,
				mouseOnOppAxis = axis === 'vertical' ? x : y;

			return targetS1Opp < mouseOnOppAxis && mouseOnOppAxis < targetS2Opp;
		},

		_isElInRowColumn = function(el1, el2, axis) {
			var el1Rect = el1 === dragEl && realDragElRect || _getRect(el1),
				el2Rect = el2 === dragEl && realDragElRect || _getRect(el2),
				el1S1Opp = axis === 'vertical' ? el1Rect.left : el1Rect.top,
				el1S2Opp = axis === 'vertical' ? el1Rect.right : el1Rect.bottom,
				el1OppLength = axis === 'vertical' ? el1Rect.width : el1Rect.height,
				el2S1Opp = axis === 'vertical' ? el2Rect.left : el2Rect.top,
				el2S2Opp = axis === 'vertical' ? el2Rect.right : el2Rect.bottom,
				el2OppLength = axis === 'vertical' ? el2Rect.width : el2Rect.height;

			return (
				el1S1Opp === el2S1Opp ||
				el1S2Opp === el2S2Opp ||
				(el1S1Opp + el1OppLength / 2) === (el2S1Opp + el2OppLength / 2)
			);
		},

		_getParentAutoScrollElement = function(el, includeSelf) {
			// skip to window
			if (!el || !el.getBoundingClientRect) return _getWindowScrollingElement();

			var elem = el;
			var gotSelf = false;
			do {
				// we don't need to get elem css if it isn't even overflowing in the first place (performance)
				if (elem.clientWidth < elem.scrollWidth || elem.clientHeight < elem.scrollHeight) {
					var elemCSS = _css(elem);
					if (
						elem.clientWidth < elem.scrollWidth && (elemCSS.overflowX == 'auto' || elemCSS.overflowX == 'scroll') ||
						elem.clientHeight < elem.scrollHeight && (elemCSS.overflowY == 'auto' || elemCSS.overflowY == 'scroll')
					) {
						if (!elem || !elem.getBoundingClientRect || elem === document.body) return _getWindowScrollingElement();

						if (gotSelf || includeSelf) return elem;
						gotSelf = true;
					}
				}
			/* jshint boss:true */
			} while (elem = elem.parentNode);

			return _getWindowScrollingElement();
		},

		_getWindowScrollingElement = function() {
			if (IE11OrLess) {
				return document.documentElement;
			} else {
				return document.scrollingElement;
			}
		},

		_scrollBy = function(el, x, y) {
			el.scrollLeft += x;
			el.scrollTop += y;
		},

		_autoScroll = _throttle(function (/**Event*/evt, /**Object*/options, /**HTMLElement*/rootEl, /**Boolean*/isFallback) {
			// Bug: https://bugzilla.mozilla.org/show_bug.cgi?id=505521
			if (options.scroll) {
				var _this = rootEl ? rootEl[expando] : window,
					sens = options.scrollSensitivity,
					speed = options.scrollSpeed,

					x = evt.clientX,
					y = evt.clientY,

					winScroller = _getWindowScrollingElement(),

					scrollThisInstance = false;

				// Detect scrollEl
				if (scrollParentEl !== rootEl) {
					_clearAutoScrolls();

					scrollEl = options.scroll;
					scrollCustomFn = options.scrollFn;

					if (scrollEl === true) {
						scrollEl = _getParentAutoScrollElement(rootEl, true);
						scrollParentEl = scrollEl;
					}
				}


				var layersOut = 0;
				var currentParent = scrollEl;
				do {
					var	el = currentParent,
						rect = _getRect(el),

						top = rect.top,
						bottom = rect.bottom,
						left = rect.left,
						right = rect.right,

						width = rect.width,
						height = rect.height,

						scrollWidth,
						scrollHeight,

						css,

						vx,
						vy,

						canScrollX,
						canScrollY,

						scrollPosX,
						scrollPosY;


					scrollWidth = el.scrollWidth;
					scrollHeight = el.scrollHeight;

					css = _css(el);

					scrollPosX = el.scrollLeft;
					scrollPosY = el.scrollTop;

					if (el === winScroller) {
						canScrollX = width < scrollWidth && (css.overflowX === 'auto' || css.overflowX === 'scroll' || css.overflowX === 'visible');
						canScrollY = height < scrollHeight && (css.overflowY === 'auto' || css.overflowY === 'scroll' || css.overflowY === 'visible');
					} else {
						canScrollX = width < scrollWidth && (css.overflowX === 'auto' || css.overflowX === 'scroll');
						canScrollY = height < scrollHeight && (css.overflowY === 'auto' || css.overflowY === 'scroll');
					}

					vx = canScrollX && (abs(right - x) <= sens && (scrollPosX + width) < scrollWidth) - (abs(left - x) <= sens && !!scrollPosX);

					vy = canScrollY && (abs(bottom - y) <= sens && (scrollPosY + height) < scrollHeight) - (abs(top - y) <= sens && !!scrollPosY);


					if (!autoScrolls[layersOut]) {
						for (var i = 0; i <= layersOut; i++) {
							if (!autoScrolls[i]) {
								autoScrolls[i] = {};
							}
						}
					}

					if (autoScrolls[layersOut].vx != vx || autoScrolls[layersOut].vy != vy || autoScrolls[layersOut].el !== el) {
						autoScrolls[layersOut].el = el;
						autoScrolls[layersOut].vx = vx;
						autoScrolls[layersOut].vy = vy;

						clearInterval(autoScrolls[layersOut].pid);

						if (el && (vx != 0 || vy != 0)) {
							scrollThisInstance = true;
							/* jshint loopfunc:true */
							autoScrolls[layersOut].pid = setInterval((function () {
								// emulate drag over during autoscroll (fallback), emulating native DnD behaviour
								if (isFallback && this.layer === 0) {
									Sortable.active._emulateDragOver(true);
									Sortable.active._onTouchMove(touchEvt, true);
								}
								var scrollOffsetY = autoScrolls[this.layer].vy ? autoScrolls[this.layer].vy * speed : 0;
								var scrollOffsetX = autoScrolls[this.layer].vx ? autoScrolls[this.layer].vx * speed : 0;

								if ('function' === typeof(scrollCustomFn)) {
									if (scrollCustomFn.call(_this, scrollOffsetX, scrollOffsetY, evt, touchEvt, autoScrolls[this.layer].el) !== 'continue') {
										return;
									}
								}

								_scrollBy(autoScrolls[this.layer].el, scrollOffsetX, scrollOffsetY);
							}).bind({layer: layersOut}), 24);
						}
					}
					layersOut++;
				} while (options.bubbleScroll && currentParent !== winScroller && (currentParent = _getParentAutoScrollElement(currentParent, false)));
				scrolling = scrollThisInstance; // in case another function catches scrolling as false in between when it is not
			}
		}, 30),

		_clearAutoScrolls = function () {
			autoScrolls.forEach(function(autoScroll) {
				clearInterval(autoScroll.pid);
			});
			autoScrolls = [];
		},

		_prepareGroup = function (options) {
			function toFn(value, pull) {
				return function(to, from, dragEl, evt) {
					var sameGroup = to.options.group.name &&
									from.options.group.name &&
									to.options.group.name === from.options.group.name;

					if (value == null && (pull || sameGroup)) {
						// Default pull value
						// Default pull and put value if same group
						return true;
					} else if (value == null || value === false) {
						return false;
					} else if (pull && value === 'clone') {
						return value;
					} else if (typeof value === 'function') {
						return toFn(value(to, from, dragEl, evt), pull)(to, from, dragEl, evt);
					} else {
						var otherGroup = (pull ? to : from).options.group.name;

						return (value === true ||
						(typeof value === 'string' && value === otherGroup) ||
						(value.join && value.indexOf(otherGroup) > -1));
					}
				};
			}

			var group = {};
			var originalGroup = options.group;

			if (!originalGroup || typeof originalGroup != 'object') {
				originalGroup = {name: originalGroup};
			}

			group.name = originalGroup.name;
			group.checkPull = toFn(originalGroup.pull, true);
			group.checkPut = toFn(originalGroup.put);
			group.revertClone = originalGroup.revertClone;

			options.group = group;
		},

		_checkAlignment = function(evt) {
			if (!dragEl || !dragEl.parentNode) return;
			dragEl.parentNode[expando] && dragEl.parentNode[expando]._computeIsAligned(evt);
		},

		_isTrueParentSortable = function(el, target) {
			var trueParent = target;
			while (!trueParent[expando]) {
				trueParent = trueParent.parentNode;
			}

			return el === trueParent;
		},

		_artificalBubble = function(sortable, originalEvt, method) {
			// Artificial IE bubbling
			var nextParent = sortable.parentNode;
			while (nextParent && !nextParent[expando]) {
				nextParent = nextParent.parentNode;
			}

			if (nextParent) {
				nextParent[expando][method](_extend(originalEvt, {
					artificialBubble: true
				}));
			}
		},

		_hideGhostForTarget = function() {
			if (!supportCssPointerEvents && ghostEl) {
				_css(ghostEl, 'display', 'none');
			}
		},

		_unhideGhostForTarget = function() {
			if (!supportCssPointerEvents && ghostEl) {
				_css(ghostEl, 'display', '');
			}
		};


	// #1184 fix - Prevent click event on fallback if dragged but item not changed position
	document.addEventListener('click', function(evt) {
		if (ignoreNextClick) {
			evt.preventDefault();
			evt.stopPropagation && evt.stopPropagation();
			evt.stopImmediatePropagation && evt.stopImmediatePropagation();
			ignoreNextClick = false;
			return false;
		}
	}, true);

	var nearestEmptyInsertDetectEvent = function(evt) {
		evt = evt.touches ? evt.touches[0] : evt;
		if (dragEl) {
			var nearest = _detectNearestEmptySortable(evt.clientX, evt.clientY);

			if (nearest) {
				nearest[expando]._onDragOver({
					clientX: evt.clientX,
					clientY: evt.clientY,
					target: nearest,
					rootEl: nearest
				});
			}
		}
	};
	// We do not want this to be triggered if completed (bubbling canceled), so only define it here
	_on(document, 'dragover', nearestEmptyInsertDetectEvent);
	_on(document, 'mousemove', nearestEmptyInsertDetectEvent);
	_on(document, 'touchmove', nearestEmptyInsertDetectEvent);

	/**
	 * @class  Sortable
	 * @param  {HTMLElement}  el
	 * @param  {Object}       [options]
	 */
	function Sortable(el, options) {
		if (!(el && el.nodeType && el.nodeType === 1)) {
			throw 'Sortable: `el` must be HTMLElement, not ' + {}.toString.call(el);
		}

		this.el = el; // root element
		this.options = options = _extend({}, options);


		// Export instance
		el[expando] = this;

		// Default options
		var defaults = {
			group: null,
			sort: true,
			disabled: false,
			store: null,
			handle: null,
			scroll: true,
			scrollSensitivity: 30,
			scrollSpeed: 10,
			bubbleScroll: true,
			draggable: /[uo]l/i.test(el.nodeName) ? '>li' : '>*',
			swapThreshold: 1, // percentage; 0 <= x <= 1
			invertSwap: false, // invert always
			invertedSwapThreshold: null, // will be set to same as swapThreshold if default
			removeCloneOnHide: true,
			direction: function() {
				return _detectDirection(el, this.options);
			},
			ghostClass: 'sortable-ghost',
			chosenClass: 'sortable-chosen',
			dragClass: 'sortable-drag',
			ignore: 'a, img',
			filter: null,
			preventOnFilter: true,
			animation: 0,
			easing: null,
			setData: function (dataTransfer, dragEl) {
				dataTransfer.setData('Text', dragEl.textContent);
			},
			dropBubble: false,
			dragoverBubble: false,
			dataIdAttr: 'data-id',
			delay: 0,
			touchStartThreshold: parseInt(window.devicePixelRatio, 10) || 1,
			forceFallback: false,
			fallbackClass: 'sortable-fallback',
			fallbackOnBody: false,
			fallbackTolerance: 0,
			fallbackOffset: {x: 0, y: 0},
			supportPointer: Sortable.supportPointer !== false && (
				('PointerEvent' in window) ||
				window.navigator && ('msPointerEnabled' in window.navigator) // microsoft
			),
			emptyInsertThreshold: 5
		};


		// Set default options
		for (var name in defaults) {
			!(name in options) && (options[name] = defaults[name]);
		}

		_prepareGroup(options);

		// Bind all private methods
		for (var fn in this) {
			if (fn.charAt(0) === '_' && typeof this[fn] === 'function') {
				this[fn] = this[fn].bind(this);
			}
		}

		// Setup drag mode
		this.nativeDraggable = options.forceFallback ? false : supportDraggable;

		if (this.nativeDraggable) {
			// Touch start threshold cannot be greater than the native dragstart threshold
			this.options.touchStartThreshold = 1;
		}

		// Bind events
		if (options.supportPointer) {
			_on(el, 'pointerdown', this._onTapStart);
		} else {
			_on(el, 'mousedown', this._onTapStart);
			_on(el, 'touchstart', this._onTapStart);
		}

		if (this.nativeDraggable) {
			_on(el, 'dragover', this);
			_on(el, 'dragenter', this);
		}

		sortables.push(this.el);

		// Restore sorting
		options.store && options.store.get && this.sort(options.store.get(this) || []);
	}

	Sortable.prototype = /** @lends Sortable.prototype */ {
		constructor: Sortable,

		_computeIsAligned: function(evt) {
			var target;

			if (ghostEl && !supportCssPointerEvents) {
				_hideGhostForTarget();
				target = document.elementFromPoint(evt.clientX, evt.clientY);
				_unhideGhostForTarget();
			} else {
				target = evt.target;
			}

			target = _closest(target, this.options.draggable, this.el, false);
			if (_alignedSilent) return;
			if (!dragEl || dragEl.parentNode !== this.el) return;

			var children = this.el.children;
			for (var i = 0; i < children.length; i++) {
				// Don't change for target in case it is changed to aligned before onDragOver is fired
				if (_closest(children[i], this.options.draggable, this.el, false) && children[i] !== target) {
					children[i].sortableMouseAligned = _isClientInRowColumn(evt.clientX, evt.clientY, children[i], this._getDirection(evt, null), this.options);
				}
			}
			// Used for nulling last target when not in element, nothing to do with checking if aligned
			if (!_closest(target, this.options.draggable, this.el, true)) {
				lastTarget = null;
			}

			_alignedSilent = true;
			setTimeout(function() {
				_alignedSilent = false;
			}, 30);

		},

		_getDirection: function(evt, target) {
			return (typeof this.options.direction === 'function') ? this.options.direction.call(this, evt, target, dragEl) : this.options.direction;
		},

		_onTapStart: function (/** Event|TouchEvent */evt) {
			if (!evt.cancelable) return;
			var _this = this,
				el = this.el,
				options = this.options,
				preventOnFilter = options.preventOnFilter,
				type = evt.type,
				touch = evt.touches && evt.touches[0],
				target = (touch || evt).target,
				originalTarget = evt.target.shadowRoot && ((evt.path && evt.path[0]) || (evt.composedPath && evt.composedPath()[0])) || target,
				filter = options.filter,
				startIndex;

			_saveInputCheckedState(el);


			// IE: Calls events in capture mode if event element is nested. This ensures only correct element's _onTapStart goes through.
			// This process is also done in _onDragOver
			if (IE11OrLess && !evt.artificialBubble && !_isTrueParentSortable(el, target)) {
				return;
			}

			// Don't trigger start event when an element is been dragged, otherwise the evt.oldindex always wrong when set option.group.
			if (dragEl) {
				return;
			}

			if (/mousedown|pointerdown/.test(type) && evt.button !== 0 || options.disabled) {
				return; // only left button and enabled
			}

			// cancel dnd if original target is content editable
			if (originalTarget.isContentEditable) {
				return;
			}

			target = _closest(target, options.draggable, el, false);

			if (!target) {
				if (IE11OrLess) {
					_artificalBubble(el, evt, '_onTapStart');
				}
				return;
			}

			if (lastDownEl === target) {
				// Ignoring duplicate `down`
				return;
			}

			// Get the index of the dragged element within its parent
			startIndex = _index(target, options.draggable);

			// Check filter
			if (typeof filter === 'function') {
				if (filter.call(this, evt, target, this)) {
					_dispatchEvent(_this, originalTarget, 'filter', target, el, el, startIndex);
					preventOnFilter && evt.cancelable && evt.preventDefault();
					return; // cancel dnd
				}
			}
			else if (filter) {
				filter = filter.split(',').some(function (criteria) {
					criteria = _closest(originalTarget, criteria.trim(), el, false);

					if (criteria) {
						_dispatchEvent(_this, criteria, 'filter', target, el, el, startIndex);
						return true;
					}
				});

				if (filter) {
					preventOnFilter && evt.cancelable && evt.preventDefault();
					return; // cancel dnd
				}
			}

			if (options.handle && !_closest(originalTarget, options.handle, el, false)) {
				return;
			}

			// Prepare `dragstart`
			this._prepareDragStart(evt, touch, target, startIndex);
		},


		_handleAutoScroll: function(evt, fallback) {
			if (!dragEl || !this.options.scroll) return;
			var x = evt.clientX,
				y = evt.clientY,

				elem = document.elementFromPoint(x, y),
				_this = this;

			// IE does not seem to have native autoscroll,
			// Edge's autoscroll seems too conditional,
			// MACOS Safari does not have autoscroll,
			// Firefox and Chrome are good
			if (fallback || Edge || IE11OrLess || Safari) {
				_autoScroll(evt, _this.options, elem, fallback);

				// Listener for pointer element change
				var ogElemScroller = _getParentAutoScrollElement(elem, true);
				if (
					scrolling &&
					(
						!pointerElemChangedInterval ||
						x !== lastPointerElemX ||
						y !== lastPointerElemY
					)
				) {

					pointerElemChangedInterval && clearInterval(pointerElemChangedInterval);
					// Detect for pointer elem change, emulating native DnD behaviour
					pointerElemChangedInterval = setInterval(function() {
						if (!dragEl) return;
						// could also check if scroll direction on newElem changes due to parent autoscrolling
						var newElem = _getParentAutoScrollElement(document.elementFromPoint(x, y), true);
						if (newElem !== ogElemScroller) {
							ogElemScroller = newElem;
							_clearAutoScrolls();
							_autoScroll(evt, _this.options, ogElemScroller, fallback);
						}
					}, 10);
					lastPointerElemX = x;
					lastPointerElemY = y;
				}

			} else {
				// if DnD is enabled (and browser has good autoscrolling), first autoscroll will already scroll, so get parent autoscroll of first autoscroll
				if (!_this.options.bubbleScroll || _getParentAutoScrollElement(elem, true) === _getWindowScrollingElement()) {
					_clearAutoScrolls();
					return;
				}
				_autoScroll(evt, _this.options, _getParentAutoScrollElement(elem, false), false);
			}
		},

		_prepareDragStart: function (/** Event */evt, /** Touch */touch, /** HTMLElement */target, /** Number */startIndex) {
			var _this = this,
				el = _this.el,
				options = _this.options,
				ownerDocument = el.ownerDocument,
				dragStartFn;

			if (target && !dragEl && (target.parentNode === el)) {
				rootEl = el;
				dragEl = target;
				parentEl = dragEl.parentNode;
				nextEl = dragEl.nextSibling;
				lastDownEl = target;
				activeGroup = options.group;
				oldIndex = startIndex;

				tapEvt = {
					target: dragEl,
					clientX: (touch || evt).clientX,
					clientY: (touch || evt).clientY
				};

				this._lastX = (touch || evt).clientX;
				this._lastY = (touch || evt).clientY;

				dragEl.style['will-change'] = 'all';
				// undo animation if needed
				dragEl.style.transition = '';
				dragEl.style.transform = '';

				dragStartFn = function () {
					// Delayed drag has been triggered
					// we can re-enable the events: touchmove/mousemove
					_this._disableDelayedDragEvents();

					if (!FireFox && _this.nativeDraggable) {
						dragEl.draggable = true;
					}

					// Bind the events: dragstart/dragend
					_this._triggerDragStart(evt, touch);

					// Drag start event
					_dispatchEvent(_this, rootEl, 'choose', dragEl, rootEl, rootEl, oldIndex);

					// Chosen item
					_toggleClass(dragEl, options.chosenClass, true);
				};

				// Disable "draggable"
				options.ignore.split(',').forEach(function (criteria) {
					_find(dragEl, criteria.trim(), _disableDraggable);
				});

				if (options.supportPointer) {
					_on(ownerDocument, 'pointerup', _this._onDrop);
				} else {
					_on(ownerDocument, 'mouseup', _this._onDrop);
					_on(ownerDocument, 'touchend', _this._onDrop);
					_on(ownerDocument, 'touchcancel', _this._onDrop);
				}

				// Make dragEl draggable (must be before delay for FireFox)
				if (FireFox && this.nativeDraggable) {
					this.options.touchStartThreshold = 4;
					dragEl.draggable = true;
				}

				// Delay is impossible for native DnD in Edge or IE
				if (options.delay && (!this.nativeDraggable || !(Edge || IE11OrLess))) {
					// If the user moves the pointer or let go the click or touch
					// before the delay has been reached:
					// disable the delayed drag
					_on(ownerDocument, 'mouseup', _this._disableDelayedDrag);
					_on(ownerDocument, 'touchend', _this._disableDelayedDrag);
					_on(ownerDocument, 'touchcancel', _this._disableDelayedDrag);
					_on(ownerDocument, 'mousemove', _this._delayedDragTouchMoveHandler);
					_on(ownerDocument, 'touchmove', _this._delayedDragTouchMoveHandler);
					options.supportPointer && _on(ownerDocument, 'pointermove', _this._delayedDragTouchMoveHandler);

					_this._dragStartTimer = setTimeout(dragStartFn, options.delay);
				} else {
					dragStartFn();
				}
			}
		},

		_delayedDragTouchMoveHandler: function (/** TouchEvent|PointerEvent **/e) {
			var touch = e.touches ? e.touches[0] : e;
			if (max(abs(touch.clientX - this._lastX), abs(touch.clientY - this._lastY))
					>= Math.floor(this.options.touchStartThreshold / (this.nativeDraggable && window.devicePixelRatio || 1))
			) {
				this._disableDelayedDrag();
			}
		},

		_disableDelayedDrag: function () {
			dragEl && _disableDraggable(dragEl);
			clearTimeout(this._dragStartTimer);

			this._disableDelayedDragEvents();
		},

		_disableDelayedDragEvents: function () {
			var ownerDocument = this.el.ownerDocument;
			_off(ownerDocument, 'mouseup', this._disableDelayedDrag);
			_off(ownerDocument, 'touchend', this._disableDelayedDrag);
			_off(ownerDocument, 'touchcancel', this._disableDelayedDrag);
			_off(ownerDocument, 'mousemove', this._delayedDragTouchMoveHandler);
			_off(ownerDocument, 'touchmove', this._delayedDragTouchMoveHandler);
			_off(ownerDocument, 'pointermove', this._delayedDragTouchMoveHandler);
		},

		_triggerDragStart: function (/** Event */evt, /** Touch */touch) {
			touch = touch || (evt.pointerType == 'touch' ? evt : null);

			if (!this.nativeDraggable || touch) {
				if (this.options.supportPointer) {
					_on(document, 'pointermove', this._onTouchMove);
				} else if (touch) {
					_on(document, 'touchmove', this._onTouchMove);
				} else {
					_on(document, 'mousemove', this._onTouchMove);
				}
			} else {
				_on(dragEl, 'dragend', this);
				_on(rootEl, 'dragstart', this._onDragStart);
			}

			try {
				if (document.selection) {
					// Timeout neccessary for IE9
					_nextTick(function () {
						document.selection.empty();
					});
				} else {
					window.getSelection().removeAllRanges();
				}
			} catch (err) {
			}
		},

		_dragStarted: function (fallback, evt) {
			awaitingDragStarted = false;
			if (rootEl && dragEl) {
				if (this.nativeDraggable) {
					_on(document, 'dragover', this._handleAutoScroll);
					_on(document, 'dragover', _checkAlignment);
				}
				var options = this.options;

				// Apply effect
				!fallback && _toggleClass(dragEl, options.dragClass, false);
				_toggleClass(dragEl, options.ghostClass, true);

				// In case dragging an animated element
				_css(dragEl, 'transform', '');

				Sortable.active = this;

				fallback && this._appendGhost();

				// Drag start event
				_dispatchEvent(this, rootEl, 'start', dragEl, rootEl, rootEl, oldIndex, undefined, evt);
			} else {
				this._nulling();
			}
		},

		_emulateDragOver: function (forAutoScroll) {
			if (touchEvt) {
				if (this._lastX === touchEvt.clientX && this._lastY === touchEvt.clientY && !forAutoScroll) {
					return;
				}
				this._lastX = touchEvt.clientX;
				this._lastY = touchEvt.clientY;

				_hideGhostForTarget();

				var target = document.elementFromPoint(touchEvt.clientX, touchEvt.clientY);
				var parent = target;

				while (target && target.shadowRoot) {
					target = target.shadowRoot.elementFromPoint(touchEvt.clientX, touchEvt.clientY);
					parent = target;
				}

				if (parent) {
					do {
						if (parent[expando]) {
							var inserted;

							inserted = parent[expando]._onDragOver({
								clientX: touchEvt.clientX,
								clientY: touchEvt.clientY,
								target: target,
								rootEl: parent
							});

							if (inserted && !this.options.dragoverBubble) {
								break;
							}
						}

						target = parent; // store last element
					}
					/* jshint boss:true */
					while (parent = parent.parentNode);
				}
				dragEl.parentNode[expando]._computeIsAligned(touchEvt);

				_unhideGhostForTarget();
			}
		},


		_onTouchMove: function (/**TouchEvent*/evt, forAutoScroll) {
			if (tapEvt) {
				var	options = this.options,
					fallbackTolerance = options.fallbackTolerance,
					fallbackOffset = options.fallbackOffset,
					touch = evt.touches ? evt.touches[0] : evt,
					matrix = ghostEl && _matrix(ghostEl),
					scaleX = ghostEl && matrix && matrix.a,
					scaleY = ghostEl && matrix && matrix.d,
					relativeScrollOffset = PositionGhostAbsolutely && ghostRelativeParent && _getRelativeScrollOffset(ghostRelativeParent),
					dx = ((touch.clientX - tapEvt.clientX)
							+ fallbackOffset.x) / (scaleX || 1)
							+ (relativeScrollOffset ? (relativeScrollOffset[0] - ghostRelativeParentInitialScroll[0]) : 0) / (scaleX || 1),
					dy = ((touch.clientY - tapEvt.clientY)
							+ fallbackOffset.y) / (scaleY || 1)
							+ (relativeScrollOffset ? (relativeScrollOffset[1] - ghostRelativeParentInitialScroll[1]) : 0) / (scaleY || 1),
					translate3d = evt.touches ? 'translate3d(' + dx + 'px,' + dy + 'px,0)' : 'translate(' + dx + 'px,' + dy + 'px)';

				// only set the status to dragging, when we are actually dragging
				if (!Sortable.active && !awaitingDragStarted) {
					if (fallbackTolerance &&
						min(abs(touch.clientX - this._lastX), abs(touch.clientY - this._lastY)) < fallbackTolerance
					) {
						return;
					}
					this._onDragStart(evt, true);
				}

				!forAutoScroll && this._handleAutoScroll(touch, true);

				moved = true;
				touchEvt = touch;

				_css(ghostEl, 'webkitTransform', translate3d);
				_css(ghostEl, 'mozTransform', translate3d);
				_css(ghostEl, 'msTransform', translate3d);
				_css(ghostEl, 'transform', translate3d);

				evt.cancelable && evt.preventDefault();
			}
		},

		_appendGhost: function () {
			// Bug if using scale(): https://stackoverflow.com/questions/2637058
			// Not being adjusted for
			if (!ghostEl) {
				var container = this.options.fallbackOnBody ? document.body : rootEl,
					rect = _getRect(dragEl, true, container, !PositionGhostAbsolutely),
					css = _css(dragEl),
					options = this.options;

				// Position absolutely
				if (PositionGhostAbsolutely) {
					// Get relatively positioned parent
					ghostRelativeParent = container;

					while (
						_css(ghostRelativeParent, 'position') === 'static' &&
						_css(ghostRelativeParent, 'transform') === 'none' &&
						ghostRelativeParent !== document
					) {
						ghostRelativeParent = ghostRelativeParent.parentNode;
					}

					if (ghostRelativeParent !== document) {
						var ghostRelativeParentRect = _getRect(ghostRelativeParent, true);

						rect.top -= ghostRelativeParentRect.top;
						rect.left -= ghostRelativeParentRect.left;
					}

					if (ghostRelativeParent !== document.body && ghostRelativeParent !== document.documentElement) {
						if (ghostRelativeParent === document) ghostRelativeParent = _getWindowScrollingElement();

						rect.top += ghostRelativeParent.scrollTop;
						rect.left += ghostRelativeParent.scrollLeft;
					} else {
						ghostRelativeParent = _getWindowScrollingElement();
					}
					ghostRelativeParentInitialScroll = _getRelativeScrollOffset(ghostRelativeParent);
				}


				ghostEl = dragEl.cloneNode(true);

				_toggleClass(ghostEl, options.ghostClass, false);
				_toggleClass(ghostEl, options.fallbackClass, true);
				_toggleClass(ghostEl, options.dragClass, true);

				_css(ghostEl, 'box-sizing', 'border-box');
				_css(ghostEl, 'margin', 0);
				_css(ghostEl, 'top', rect.top);
				_css(ghostEl, 'left', rect.left);
				_css(ghostEl, 'width', rect.width);
				_css(ghostEl, 'height', rect.height);
				_css(ghostEl, 'opacity', '0.8');
				_css(ghostEl, 'position', (PositionGhostAbsolutely ? 'absolute' : 'fixed'));
				_css(ghostEl, 'zIndex', '100000');
				_css(ghostEl, 'pointerEvents', 'none');

				container.appendChild(ghostEl);
			}
		},

		_onDragStart: function (/**Event*/evt, /**boolean*/fallback) {
			var _this = this;
			var dataTransfer = evt.dataTransfer;
			var options = _this.options;

			// Setup clone
			cloneEl = _clone(dragEl);

			cloneEl.draggable = false;
			cloneEl.style['will-change'] = '';

			this._hideClone();

			_toggleClass(cloneEl, _this.options.chosenClass, false);


			// #1143: IFrame support workaround
			_this._cloneId = _nextTick(function () {
				if (!_this.options.removeCloneOnHide) {
					rootEl.insertBefore(cloneEl, dragEl);
				}
				_dispatchEvent(_this, rootEl, 'clone', dragEl);
			});


			!fallback && _toggleClass(dragEl, options.dragClass, true);

			// Set proper drop events
			if (fallback) {
				ignoreNextClick = true;
				_this._loopId = setInterval(_this._emulateDragOver, 50);
			} else {
				// Undo what was set in _prepareDragStart before drag started
				_off(document, 'mouseup', _this._onDrop);
				_off(document, 'touchend', _this._onDrop);
				_off(document, 'touchcancel', _this._onDrop);

				if (dataTransfer) {
					dataTransfer.effectAllowed = 'move';
					options.setData && options.setData.call(_this, dataTransfer, dragEl);
				}

				_on(document, 'drop', _this);

				// #1276 fix:
				_css(dragEl, 'transform', 'translateZ(0)');
			}

			awaitingDragStarted = true;

			_this._dragStartId = _nextTick(_this._dragStarted.bind(_this, fallback, evt));
			_on(document, 'selectstart', _this);
			if (Safari) {
				_css(document.body, 'user-select', 'none');
			}
		},


		// Returns true - if no further action is needed (either inserted or another condition)
		_onDragOver: function (/**Event*/evt) {
			var el = this.el,
				target = evt.target,
				dragRect,
				targetRect,
				revert,
				options = this.options,
				group = options.group,
				activeSortable = Sortable.active,
				isOwner = (activeGroup === group),
				canSort = options.sort,
				_this = this;

			if (_silent) return;

			// IE event order fix
			if (IE11OrLess && !evt.rootEl && !evt.artificialBubble && !_isTrueParentSortable(el, target)) {
				return;
			}

			// Return invocation when dragEl is inserted (or completed)
			function completed(insertion) {
				if (insertion) {
					if (isOwner) {
						activeSortable._hideClone();
					} else {
						activeSortable._showClone(_this);
					}

					if (activeSortable) {
						// Set ghost class to new sortable's ghost class
						_toggleClass(dragEl, putSortable ? putSortable.options.ghostClass : activeSortable.options.ghostClass, false);
						_toggleClass(dragEl, options.ghostClass, true);
					}

					if (putSortable !== _this && _this !== Sortable.active) {
						putSortable = _this;
					} else if (_this === Sortable.active) {
						putSortable = null;
					}

					// Animation
					dragRect && _this._animate(dragRect, dragEl);
					target && targetRect && _this._animate(targetRect, target);
				}


				// Null lastTarget if it is not inside a previously swapped element
				if ((target === dragEl && !dragEl.animated) || (target === el && !target.animated)) {
					lastTarget = null;
				}
				// no bubbling and not fallback
				if (!options.dragoverBubble && !evt.rootEl && target !== document) {
					_this._handleAutoScroll(evt);
					dragEl.parentNode[expando]._computeIsAligned(evt);
				}

				!options.dragoverBubble && evt.stopPropagation && evt.stopPropagation();

				return true;
			}

			// Call when dragEl has been inserted
			function changed() {
				_dispatchEvent(_this, rootEl, 'change', target, el, rootEl, oldIndex, _index(dragEl, options.draggable), evt);
			}


			if (evt.preventDefault !== void 0) {
				evt.cancelable && evt.preventDefault();
			}


			moved = true;

			target = _closest(target, options.draggable, el, true);

			// target is dragEl or target is animated
			if (!!_closest(evt.target, null, dragEl, true) || target.animated) {
				return completed(false);
			}

			if (target !== dragEl) {
				ignoreNextClick = false;
			}

			if (activeSortable && !options.disabled &&
				(isOwner
					? canSort || (revert = !rootEl.contains(dragEl)) // Reverting item into the original list
					: (
						putSortable === this ||
						(
							(this.lastPutMode = activeGroup.checkPull(this, activeSortable, dragEl, evt)) &&
							group.checkPut(this, activeSortable, dragEl, evt)
						)
					)
				)
			) {
				var axis = this._getDirection(evt, target);

				dragRect = _getRect(dragEl);

				if (revert) {
					this._hideClone();
					parentEl = rootEl; // actualization

					if (nextEl) {
						rootEl.insertBefore(dragEl, nextEl);
					} else {
						rootEl.appendChild(dragEl);
					}

					return completed(true);
				}

				var elLastChild = _lastChild(el);

				if (!elLastChild || _ghostIsLast(evt, axis, el) && !elLastChild.animated) {
					// assign target only if condition is true
					if (elLastChild && el === evt.target) {
						target = elLastChild;
					}

					if (target) {
						targetRect = _getRect(target);
					}

					if (isOwner) {
						activeSortable._hideClone();
					} else {
						activeSortable._showClone(this);
					}

					if (_onMove(rootEl, el, dragEl, dragRect, target, targetRect, evt, !!target) !== false) {
						el.appendChild(dragEl);
						parentEl = el; // actualization
						realDragElRect = null;

						changed();
						return completed(true);
					}
				}
				else if (target && target !== dragEl && target.parentNode === el) {
					var direction = 0,
						targetBeforeFirstSwap,
						aligned = target.sortableMouseAligned,
						differentLevel = dragEl.parentNode !== el,
						side1 = axis === 'vertical' ? 'top' : 'left',
						scrolledPastTop = _isScrolledPast(target, 'top') || _isScrolledPast(dragEl, 'top'),
						scrollBefore = scrolledPastTop ? scrolledPastTop.scrollTop : void 0;


					if (lastTarget !== target) {
						lastMode = null;
						targetBeforeFirstSwap = _getRect(target)[side1];
						pastFirstInvertThresh = false;
					}

					// Reference: https://www.lucidchart.com/documents/view/10fa0e93-e362-4126-aca2-b709ee56bd8b/0
					if (
						_isElInRowColumn(dragEl, target, axis) && aligned ||
						differentLevel ||
						scrolledPastTop ||
						options.invertSwap ||
						lastMode === 'insert' ||
						// Needed, in the case that we are inside target and inserted because not aligned... aligned will stay false while inside
						// and lastMode will change to 'insert', but we must swap
						lastMode === 'swap'
					) {
						// New target that we will be inside
						if (lastMode !== 'swap') {
							isCircumstantialInvert = options.invertSwap || differentLevel;
						}

						direction = _getSwapDirection(evt, target, axis,
							options.swapThreshold, options.invertedSwapThreshold == null ? options.swapThreshold : options.invertedSwapThreshold,
							isCircumstantialInvert,
							lastTarget === target);
						lastMode = 'swap';
					} else {
						// Insert at position
						direction = _getInsertDirection(target);
						lastMode = 'insert';
					}
					if (direction === 0) return completed(false);

					realDragElRect = null;
					lastTarget = target;

					lastDirection = direction;

					targetRect = _getRect(target);

					var nextSibling = target.nextElementSibling,
						after = false;

					after = direction === 1;

					var moveVector = _onMove(rootEl, el, dragEl, dragRect, target, targetRect, evt, after);

					if (moveVector !== false) {
						if (moveVector === 1 || moveVector === -1) {
							after = (moveVector === 1);
						}

						_silent = true;
						setTimeout(_unsilent, 30);

						if (isOwner) {
							activeSortable._hideClone();
						} else {
							activeSortable._showClone(this);
						}

						if (after && !nextSibling) {
							el.appendChild(dragEl);
						} else {
							target.parentNode.insertBefore(dragEl, after ? nextSibling : target);
						}

						// Undo chrome's scroll adjustment
						if (scrolledPastTop) {
							_scrollBy(scrolledPastTop, 0, scrollBefore - scrolledPastTop.scrollTop);
						}

						parentEl = dragEl.parentNode; // actualization

						// must be done before animation
						if (targetBeforeFirstSwap !== undefined && !isCircumstantialInvert) {
							targetMoveDistance = abs(targetBeforeFirstSwap - _getRect(target)[side1]);
						}
						changed();

						return completed(true);
					}
				}

				if (el.contains(dragEl)) {
					return completed(false);
				}
			}

			if (IE11OrLess && !evt.rootEl) {
				_artificalBubble(el, evt, '_onDragOver');
			}

			return false;
		},

		_animate: function (prevRect, target) {
			var ms = this.options.animation;

			if (ms) {
				var currentRect = _getRect(target);

				if (target === dragEl) {
					realDragElRect = currentRect;
				}

				if (prevRect.nodeType === 1) {
					prevRect = _getRect(prevRect);
				}

				// Check if actually moving position
				if ((prevRect.left + prevRect.width / 2) !== (currentRect.left + currentRect.width / 2)
					|| (prevRect.top + prevRect.height / 2) !== (currentRect.top + currentRect.height / 2)
				) {
					var matrix = _matrix(this.el),
						scaleX = matrix && matrix.a,
						scaleY = matrix && matrix.d;

					_css(target, 'transition', 'none');
					_css(target, 'transform', 'translate3d('
						+ (prevRect.left - currentRect.left) / (scaleX ? scaleX : 1) + 'px,'
						+ (prevRect.top - currentRect.top) / (scaleY ? scaleY : 1) + 'px,0)'
					);

					forRepaintDummy = target.offsetWidth; // repaint
					_css(target, 'transition', 'transform ' + ms + 'ms' + (this.options.easing ? ' ' + this.options.easing : ''));
					_css(target, 'transform', 'translate3d(0,0,0)');
				}

				(typeof target.animated === 'number') && clearTimeout(target.animated);
				target.animated = setTimeout(function () {
					_css(target, 'transition', '');
					_css(target, 'transform', '');
					target.animated = false;
				}, ms);
			}
		},

		_offUpEvents: function () {
			var ownerDocument = this.el.ownerDocument;

			_off(document, 'touchmove', this._onTouchMove);
			_off(document, 'pointermove', this._onTouchMove);
			_off(ownerDocument, 'mouseup', this._onDrop);
			_off(ownerDocument, 'touchend', this._onDrop);
			_off(ownerDocument, 'pointerup', this._onDrop);
			_off(ownerDocument, 'touchcancel', this._onDrop);
			_off(document, 'selectstart', this);
		},

		_onDrop: function (/**Event*/evt) {
			var el = this.el,
				options = this.options;
			awaitingDragStarted = false;
			scrolling = false;
			isCircumstantialInvert = false;
			pastFirstInvertThresh = false;

			clearInterval(this._loopId);

			clearInterval(pointerElemChangedInterval);
			_clearAutoScrolls();
			_cancelThrottle();

			clearTimeout(this._dragStartTimer);

			_cancelNextTick(this._cloneId);
			_cancelNextTick(this._dragStartId);

			// Unbind events
			_off(document, 'mousemove', this._onTouchMove);


			if (this.nativeDraggable) {
				_off(document, 'drop', this);
				_off(el, 'dragstart', this._onDragStart);
				_off(document, 'dragover', this._handleAutoScroll);
				_off(document, 'dragover', _checkAlignment);
			}

			if (Safari) {
				_css(document.body, 'user-select', '');
			}

			this._offUpEvents();

			if (evt) {
				if (moved) {
					evt.cancelable && evt.preventDefault();
					!options.dropBubble && evt.stopPropagation();
				}

				ghostEl && ghostEl.parentNode && ghostEl.parentNode.removeChild(ghostEl);

				if (rootEl === parentEl || (putSortable && putSortable.lastPutMode !== 'clone')) {
					// Remove clone
					cloneEl && cloneEl.parentNode && cloneEl.parentNode.removeChild(cloneEl);
				}

				if (dragEl) {
					if (this.nativeDraggable) {
						_off(dragEl, 'dragend', this);
					}

					_disableDraggable(dragEl);
					dragEl.style['will-change'] = '';

					// Remove class's
					_toggleClass(dragEl, putSortable ? putSortable.options.ghostClass : this.options.ghostClass, false);
					_toggleClass(dragEl, this.options.chosenClass, false);

					// Drag stop event
					_dispatchEvent(this, rootEl, 'unchoose', dragEl, parentEl, rootEl, oldIndex, null, evt);

					if (rootEl !== parentEl) {
						newIndex = _index(dragEl, options.draggable);

						if (newIndex >= 0) {
							// Add event
							_dispatchEvent(null, parentEl, 'add', dragEl, parentEl, rootEl, oldIndex, newIndex, evt);

							// Remove event
							_dispatchEvent(this, rootEl, 'remove', dragEl, parentEl, rootEl, oldIndex, newIndex, evt);

							// drag from one list and drop into another
							_dispatchEvent(null, parentEl, 'sort', dragEl, parentEl, rootEl, oldIndex, newIndex, evt);
							_dispatchEvent(this, rootEl, 'sort', dragEl, parentEl, rootEl, oldIndex, newIndex, evt);
						}

						putSortable && putSortable.save();
					}
					else {
						if (dragEl.nextSibling !== nextEl) {
							// Get the index of the dragged element within its parent
							newIndex = _index(dragEl, options.draggable);

							if (newIndex >= 0) {
								// drag & drop within the same list
								_dispatchEvent(this, rootEl, 'update', dragEl, parentEl, rootEl, oldIndex, newIndex, evt);
								_dispatchEvent(this, rootEl, 'sort', dragEl, parentEl, rootEl, oldIndex, newIndex, evt);
							}
						}
					}

					if (Sortable.active) {
						/* jshint eqnull:true */
						if (newIndex == null || newIndex === -1) {
							newIndex = oldIndex;
						}
						_dispatchEvent(this, rootEl, 'end', dragEl, parentEl, rootEl, oldIndex, newIndex, evt);

						// Save sorting
						this.save();
					}
				}

			}
			this._nulling();
		},

		_nulling: function() {
			rootEl =
			dragEl =
			parentEl =
			ghostEl =
			nextEl =
			cloneEl =
			lastDownEl =

			scrollEl =
			scrollParentEl =
			autoScrolls.length =

			pointerElemChangedInterval =
			lastPointerElemX =
			lastPointerElemY =

			tapEvt =
			touchEvt =

			moved =
			newIndex =
			oldIndex =

			lastTarget =
			lastDirection =

			forRepaintDummy =
			realDragElRect =

			putSortable =
			activeGroup =
			Sortable.active = null;

			savedInputChecked.forEach(function (el) {
				el.checked = true;
			});

			savedInputChecked.length = 0;
		},

		handleEvent: function (/**Event*/evt) {
			switch (evt.type) {
				case 'drop':
				case 'dragend':
					this._onDrop(evt);
					break;

				case 'dragenter':
				case 'dragover':
					if (dragEl) {
						this._onDragOver(evt);
						_globalDragOver(evt);
					}
					break;

				case 'selectstart':
					evt.preventDefault();
					break;
			}
		},


		/**
		 * Serializes the item into an array of string.
		 * @returns {String[]}
		 */
		toArray: function () {
			var order = [],
				el,
				children = this.el.children,
				i = 0,
				n = children.length,
				options = this.options;

			for (; i < n; i++) {
				el = children[i];
				if (_closest(el, options.draggable, this.el, false)) {
					order.push(el.getAttribute(options.dataIdAttr) || _generateId(el));
				}
			}

			return order;
		},


		/**
		 * Sorts the elements according to the array.
		 * @param  {String[]}  order  order of the items
		 */
		sort: function (order) {
			var items = {}, rootEl = this.el;

			this.toArray().forEach(function (id, i) {
				var el = rootEl.children[i];

				if (_closest(el, this.options.draggable, rootEl, false)) {
					items[id] = el;
				}
			}, this);

			order.forEach(function (id) {
				if (items[id]) {
					rootEl.removeChild(items[id]);
					rootEl.appendChild(items[id]);
				}
			});
		},


		/**
		 * Save the current sorting
		 */
		save: function () {
			var store = this.options.store;
			store && store.set && store.set(this);
		},


		/**
		 * For each element in the set, get the first element that matches the selector by testing the element itself and traversing up through its ancestors in the DOM tree.
		 * @param   {HTMLElement}  el
		 * @param   {String}       [selector]  default: `options.draggable`
		 * @returns {HTMLElement|null}
		 */
		closest: function (el, selector) {
			return _closest(el, selector || this.options.draggable, this.el, false);
		},


		/**
		 * Set/get option
		 * @param   {string} name
		 * @param   {*}      [value]
		 * @returns {*}
		 */
		option: function (name, value) {
			var options = this.options;

			if (value === void 0) {
				return options[name];
			} else {
				options[name] = value;

				if (name === 'group') {
					_prepareGroup(options);
				}
			}
		},


		/**
		 * Destroy
		 */
		destroy: function () {
			var el = this.el;

			el[expando] = null;

			_off(el, 'mousedown', this._onTapStart);
			_off(el, 'touchstart', this._onTapStart);
			_off(el, 'pointerdown', this._onTapStart);

			if (this.nativeDraggable) {
				_off(el, 'dragover', this);
				_off(el, 'dragenter', this);
			}
			// Remove draggable attributes
			Array.prototype.forEach.call(el.querySelectorAll('[draggable]'), function (el) {
				el.removeAttribute('draggable');
			});

			this._onDrop();

			sortables.splice(sortables.indexOf(this.el), 1);

			this.el = el = null;
		},

		_hideClone: function() {
			if (!cloneEl.cloneHidden) {
				_css(cloneEl, 'display', 'none');
				cloneEl.cloneHidden = true;
				if (cloneEl.parentNode && this.options.removeCloneOnHide) {
					cloneEl.parentNode.removeChild(cloneEl);
				}
			}
		},

		_showClone: function(putSortable) {
			if (putSortable.lastPutMode !== 'clone') {
				this._hideClone();
				return;
			}

			if (cloneEl.cloneHidden) {
				// show clone at dragEl or original position
				if (rootEl.contains(dragEl) && !this.options.group.revertClone) {
					rootEl.insertBefore(cloneEl, dragEl);
				} else if (nextEl) {
					rootEl.insertBefore(cloneEl, nextEl);
				} else {
					rootEl.appendChild(cloneEl);
				}

				if (this.options.group.revertClone) {
					this._animate(dragEl, cloneEl);
				}
				_css(cloneEl, 'display', '');
				cloneEl.cloneHidden = false;
			}
		}
	};

	function _closest(/**HTMLElement*/el, /**String*/selector, /**HTMLElement*/ctx, includeCTX) {
		if (el) {
			ctx = ctx || document;

			do {
				if (
					selector != null &&
					(
						selector[0] === '>' && el.parentNode === ctx && _matches(el, selector.substring(1)) ||
						_matches(el, selector)
					) ||
					includeCTX && el === ctx
				) {
					return el;
				}

				if (el === ctx) break;
				/* jshint boss:true */
			} while (el = _getParentOrHost(el));
		}

		return null;
	}


	function _getParentOrHost(el) {
		return (el.host && el !== document && el.host.nodeType)
			? el.host
			: el.parentNode;
	}


	function _globalDragOver(/**Event*/evt) {
		if (evt.dataTransfer) {
			evt.dataTransfer.dropEffect = 'move';
		}
		evt.cancelable && evt.preventDefault();
	}


	function _on(el, event, fn) {
		el.addEventListener(event, fn, captureMode);
	}


	function _off(el, event, fn) {
		el.removeEventListener(event, fn, captureMode);
	}


	function _toggleClass(el, name, state) {
		if (el && name) {
			if (el.classList) {
				el.classList[state ? 'add' : 'remove'](name);
			}
			else {
				var className = (' ' + el.className + ' ').replace(R_SPACE, ' ').replace(' ' + name + ' ', ' ');
				el.className = (className + (state ? ' ' + name : '')).replace(R_SPACE, ' ');
			}
		}
	}


	function _css(el, prop, val) {
		var style = el && el.style;

		if (style) {
			if (val === void 0) {
				if (document.defaultView && document.defaultView.getComputedStyle) {
					val = document.defaultView.getComputedStyle(el, '');
				}
				else if (el.currentStyle) {
					val = el.currentStyle;
				}

				return prop === void 0 ? val : val[prop];
			}
			else {
				if (!(prop in style) && prop.indexOf('webkit') === -1) {
					prop = '-webkit-' + prop;
				}

				style[prop] = val + (typeof val === 'string' ? '' : 'px');
			}
		}
	}

	function _matrix(el) {
		var appliedTransforms = '';
		do {
			var transform = _css(el, 'transform');

			if (transform && transform !== 'none') {
				appliedTransforms = transform + ' ' + appliedTransforms;
			}
			/* jshint boss:true */
		} while (el = el.parentNode);

		if (window.DOMMatrix) {
			return new DOMMatrix(appliedTransforms);
		} else if (window.WebKitCSSMatrix) {
			return new WebKitCSSMatrix(appliedTransforms);
		} else if (window.CSSMatrix) {
			return new CSSMatrix(appliedTransforms);
		}
	}


	function _find(ctx, tagName, iterator) {
		if (ctx) {
			var list = ctx.getElementsByTagName(tagName), i = 0, n = list.length;

			if (iterator) {
				for (; i < n; i++) {
					iterator(list[i], i);
				}
			}

			return list;
		}

		return [];
	}



	function _dispatchEvent(sortable, rootEl, name, targetEl, toEl, fromEl, startIndex, newIndex, originalEvt) {
		sortable = (sortable || rootEl[expando]);
		var evt,
			options = sortable.options,
			onName = 'on' + name.charAt(0).toUpperCase() + name.substr(1);
		// Support for new CustomEvent feature
		if (window.CustomEvent && !IE11OrLess && !Edge) {
			evt = new CustomEvent(name, {
				bubbles: true,
				cancelable: true
			});
		} else {
			evt = document.createEvent('Event');
			evt.initEvent(name, true, true);
		}

		evt.to = toEl || rootEl;
		evt.from = fromEl || rootEl;
		evt.item = targetEl || rootEl;
		evt.clone = cloneEl;

		evt.oldIndex = startIndex;
		evt.newIndex = newIndex;

		evt.originalEvent = originalEvt;
		evt.pullMode = putSortable ? putSortable.lastPutMode : undefined;

		if (rootEl) {
			rootEl.dispatchEvent(evt);
		}

		if (options[onName]) {
			options[onName].call(sortable, evt);
		}
	}


	function _onMove(fromEl, toEl, dragEl, dragRect, targetEl, targetRect, originalEvt, willInsertAfter) {
		var evt,
			sortable = fromEl[expando],
			onMoveFn = sortable.options.onMove,
			retVal;
		// Support for new CustomEvent feature
		if (window.CustomEvent && !IE11OrLess && !Edge) {
			evt = new CustomEvent('move', {
				bubbles: true,
				cancelable: true
			});
		} else {
			evt = document.createEvent('Event');
			evt.initEvent('move', true, true);
		}

		evt.to = toEl;
		evt.from = fromEl;
		evt.dragged = dragEl;
		evt.draggedRect = dragRect;
		evt.related = targetEl || toEl;
		evt.relatedRect = targetRect || _getRect(toEl);
		evt.willInsertAfter = willInsertAfter;

		evt.originalEvent = originalEvt;

		fromEl.dispatchEvent(evt);

		if (onMoveFn) {
			retVal = onMoveFn.call(sortable, evt, originalEvt);
		}

		return retVal;
	}

	function _disableDraggable(el) {
		el.draggable = false;
	}

	function _unsilent() {
		_silent = false;
	}

	/**
	 * Gets nth child of el, ignoring hidden children, sortable's elements (does not ignore clone if it's visible)
	 * and non-draggable elements
	 * @param  {HTMLElement} el       The parent element
	 * @param  {Number} childNum      The index of the child
	 * @param  {Object} options       Parent Sortable's options
	 * @return {HTMLElement}          The child at index childNum, or null if not found
	 */
	function _getChild(el, childNum, options) {
		var currentChild = 0,
			i = 0,
			children = el.children;

		while (i < children.length) {
			if (
				children[i].style.display !== 'none' &&
				children[i] !== ghostEl &&
				children[i] !== dragEl &&
				_closest(children[i], options.draggable, el, false)
			) {
				if (currentChild === childNum) {
					return children[i];
				}
				currentChild++;
			}

			i++;
		}
		return null;
	}

	/**
	 * Gets the last child in the el, ignoring ghostEl or invisible elements (clones)
	 * @param  {HTMLElement} el       Parent element
	 * @return {HTMLElement}          The last child, ignoring ghostEl
	 */
	function _lastChild(el) {
		var last = el.lastElementChild;

		while (last && (last === ghostEl || last.style.display === 'none')) {
			last = last.previousElementSibling;
		}

		return last || null;
	}

	function _ghostIsLast(evt, axis, el) {
		var elRect = _getRect(_lastChild(el)),
			mouseOnAxis = axis === 'vertical' ? evt.clientY : evt.clientX,
			mouseOnOppAxis = axis === 'vertical' ? evt.clientX : evt.clientY,
			targetS2 = axis === 'vertical' ? elRect.bottom : elRect.right,
			targetS1Opp = axis === 'vertical' ? elRect.left : elRect.top,
			targetS2Opp = axis === 'vertical' ? elRect.right : elRect.bottom,
			spacer = 10;

		return (
			axis === 'vertical' ?
				(mouseOnOppAxis > targetS2Opp + spacer || mouseOnOppAxis <= targetS2Opp && mouseOnAxis > targetS2 && mouseOnOppAxis >= targetS1Opp) :
				(mouseOnAxis > targetS2 && mouseOnOppAxis > targetS1Opp || mouseOnAxis <= targetS2 && mouseOnOppAxis > targetS2Opp + spacer)
		);
	}

	function _getSwapDirection(evt, target, axis, swapThreshold, invertedSwapThreshold, invertSwap, isLastTarget) {
		var targetRect = _getRect(target),
			mouseOnAxis = axis === 'vertical' ? evt.clientY : evt.clientX,
			targetLength = axis === 'vertical' ? targetRect.height : targetRect.width,
			targetS1 = axis === 'vertical' ? targetRect.top : targetRect.left,
			targetS2 = axis === 'vertical' ? targetRect.bottom : targetRect.right,
			dragRect = _getRect(dragEl),
			invert = false;


		if (!invertSwap) {
			// Never invert or create dragEl shadow when target movemenet causes mouse to move past the end of regular swapThreshold
			if (isLastTarget && targetMoveDistance < targetLength * swapThreshold) { // multiplied only by swapThreshold because mouse will already be inside target by (1 - threshold) * targetLength / 2
				// check if past first invert threshold on side opposite of lastDirection
				if (!pastFirstInvertThresh &&
					(lastDirection === 1 ?
						(
							mouseOnAxis > targetS1 + targetLength * invertedSwapThreshold / 2
						) :
						(
							mouseOnAxis < targetS2 - targetLength * invertedSwapThreshold / 2
						)
					)
				)
				{
					// past first invert threshold, do not restrict inverted threshold to dragEl shadow
					pastFirstInvertThresh = true;
				}

				if (!pastFirstInvertThresh) {
					var dragS1 = axis === 'vertical' ? dragRect.top : dragRect.left,
						dragS2 = axis === 'vertical' ? dragRect.bottom : dragRect.right;
					// dragEl shadow (target move distance shadow)
					if (
						lastDirection === 1 ?
						(
							mouseOnAxis < targetS1 + targetMoveDistance // over dragEl shadow
						) :
						(
							mouseOnAxis > targetS2 - targetMoveDistance
						)
					)
					{
						return lastDirection * -1;
					}
				} else {
					invert = true;
				}
			} else {
				// Regular
				if (
					mouseOnAxis > targetS1 + (targetLength * (1 - swapThreshold) / 2) &&
					mouseOnAxis < targetS2 - (targetLength * (1 - swapThreshold) / 2)
				) {
					return _getInsertDirection(target);
				}
			}
		}

		invert = invert || invertSwap;

		if (invert) {
			// Invert of regular
			if (
				mouseOnAxis < targetS1 + (targetLength * invertedSwapThreshold / 2) ||
				mouseOnAxis > targetS2 - (targetLength * invertedSwapThreshold / 2)
			)
			{
				return ((mouseOnAxis > targetS1 + targetLength / 2) ? 1 : -1);
			}
		}

		return 0;
	}

	/**
	 * Gets the direction dragEl must be swapped relative to target in order to make it
	 * seem that dragEl has been "inserted" into that element's position
	 * @param  {HTMLElement} target       The target whose position dragEl is being inserted at
	 * @return {Number}                   Direction dragEl must be swapped
	 */
	function _getInsertDirection(target) {
		var dragElIndex = _index(dragEl),
			targetIndex = _index(target);

		if (dragElIndex < targetIndex) {
			return 1;
		} else {
			return -1;
		}
	}


	/**
	 * Generate id
	 * @param   {HTMLElement} el
	 * @returns {String}
	 * @private
	 */
	function _generateId(el) {
		var str = el.tagName + el.className + el.src + el.href + el.textContent,
			i = str.length,
			sum = 0;

		while (i--) {
			sum += str.charCodeAt(i);
		}

		return sum.toString(36);
	}

	/**
	 * Returns the index of an element within its parent for a selected set of
	 * elements
	 * @param  {HTMLElement} el
	 * @param  {selector} selector
	 * @return {number}
	 */
	function _index(el, selector) {
		var index = 0;

		if (!el || !el.parentNode) {
			return -1;
		}

		while (el && (el = el.previousElementSibling)) {
			if ((el.nodeName.toUpperCase() !== 'TEMPLATE') && el !== cloneEl) {
				index++;
			}
		}

		return index;
	}

	function _matches(/**HTMLElement*/el, /**String*/selector) {
		if (el) {
			try {
				if (el.matches) {
					return el.matches(selector);
				} else if (el.msMatchesSelector) {
					return el.msMatchesSelector(selector);
				} else if (el.webkitMatchesSelector) {
					return el.webkitMatchesSelector(selector);
				}
			} catch(_) {
				return false;
			}
		}

		return false;
	}

	var _throttleTimeout;
	function _throttle(callback, ms) {
		return function () {
			if (!_throttleTimeout) {
				var args = arguments,
					_this = this;

				_throttleTimeout = setTimeout(function () {
					if (args.length === 1) {
						callback.call(_this, args[0]);
					} else {
						callback.apply(_this, args);
					}

					_throttleTimeout = void 0;
				}, ms);
			}
		};
	}

	function _cancelThrottle() {
		clearTimeout(_throttleTimeout);
		_throttleTimeout = void 0;
	}

	function _extend(dst, src) {
		if (dst && src) {
			for (var key in src) {
				if (src.hasOwnProperty(key)) {
					dst[key] = src[key];
				}
			}
		}

		return dst;
	}

	function _clone(el) {
		if (Polymer && Polymer.dom) {
			return Polymer.dom(el).cloneNode(true);
		}
		else if ($) {
			return $(el).clone(true)[0];
		}
		else {
			return el.cloneNode(true);
		}
	}

	function _saveInputCheckedState(root) {
		savedInputChecked.length = 0;

		var inputs = root.getElementsByTagName('input');
		var idx = inputs.length;

		while (idx--) {
			var el = inputs[idx];
			el.checked && savedInputChecked.push(el);
		}
	}

	function _nextTick(fn) {
		return setTimeout(fn, 0);
	}

	function _cancelNextTick(id) {
		return clearTimeout(id);
	}


	/**
	 * Returns the "bounding client rect" of given element
	 * @param  {HTMLElement} el                The element whose boundingClientRect is wanted
	 * @param  {[HTMLElement]} container       the parent the element will be placed in
	 * @param  {[Boolean]} adjustForTransform  Whether the rect should compensate for parent's transform
	 * @return {Object}                        The boundingClientRect of el
	 */
	function _getRect(el, adjustForTransform, container, adjustForFixed) {
		if (!el.getBoundingClientRect && el !== win) return;

		var elRect,
			top,
			left,
			bottom,
			right,
			height,
			width;

		if (el !== win && el !== _getWindowScrollingElement()) {
			elRect = el.getBoundingClientRect();
			top = elRect.top;
			left = elRect.left;
			bottom = elRect.bottom;
			right = elRect.right;
			height = elRect.height;
			width = elRect.width;
		} else {
			top = 0;
			left = 0;
			bottom = window.innerHeight;
			right = window.innerWidth;
			height = window.innerHeight;
			width = window.innerWidth;
		}

		if (adjustForFixed && el !== win) {
			// Adjust for translate()
			container = container || el.parentNode;

			// solves #1123 (see: https://stackoverflow.com/a/37953806/6088312)
			// Not needed on <= IE11
			if (!IE11OrLess) {
				do {
					if (container && container.getBoundingClientRect && _css(container, 'transform') !== 'none') {
						var containerRect = container.getBoundingClientRect();

						// Set relative to edges of padding box of container
						top -= containerRect.top + parseInt(_css(container, 'border-top-width'));
						left -= containerRect.left + parseInt(_css(container, 'border-left-width'));
						bottom = top + elRect.height;
						right = left + elRect.width;

						break;
					}
					/* jshint boss:true */
				} while (container = container.parentNode);
			}
		}

		if (adjustForTransform && el !== win) {
			// Adjust for scale()
			var matrix = _matrix(container || el),
				scaleX = matrix && matrix.a,
				scaleY = matrix && matrix.d;

			if (matrix) {
				top /= scaleY;
				left /= scaleX;

				width /= scaleX;
				height /= scaleY;

				bottom = top + height;
				right = left + width;
			}
		}

		return {
			top: top,
			left: left,
			bottom: bottom,
			right: right,
			width: width,
			height: height
		};
	}


	/**
	 * Checks if a side of an element is scrolled past a side of it's parents
	 * @param  {HTMLElement}  el       The element who's side being scrolled out of view is in question
	 * @param  {String}       side     Side of the element in question ('top', 'left', 'right', 'bottom')
	 * @return {HTMLElement}           The parent scroll element that the el's side is scrolled past, or null if there is no such element
	 */
	function _isScrolledPast(el, side) {
		var parent = _getParentAutoScrollElement(el, true),
			elSide = _getRect(el)[side];

		/* jshint boss:true */
		while (parent) {
			var parentSide = _getRect(parent)[side],
				visible;

			if (side === 'top' || side === 'left') {
				visible = elSide >= parentSide;
			} else {
				visible = elSide <= parentSide;
			}

			if (!visible) return parent;

			if (parent === _getWindowScrollingElement()) break;

			parent = _getParentAutoScrollElement(parent, false);
		}

		return false;
	}

	/**
	 * Returns the scroll offset of the given element, added with all the scroll offsets of parent elements.
	 * The value is returned in real pixels.
	 * @param  {HTMLElement} el
	 * @return {Array}             Offsets in the format of [left, top]
	 */
	function _getRelativeScrollOffset(el) {
		var offsetLeft = 0,
			offsetTop = 0,
			winScroller = _getWindowScrollingElement();

		if (el) {
			do {
				var matrix = _matrix(el),
					scaleX = matrix.a,
					scaleY = matrix.d;

				offsetLeft += el.scrollLeft * scaleX;
				offsetTop += el.scrollTop * scaleY;
			} while (el !== winScroller && (el = el.parentNode));
		}

		return [offsetLeft, offsetTop];
	}

	// Fixed #973:
	_on(document, 'touchmove', function(evt) {
		if ((Sortable.active || awaitingDragStarted) && evt.cancelable) {
			evt.preventDefault();
		}
	});


	// Export utils
	Sortable.utils = {
		on: _on,
		off: _off,
		css: _css,
		find: _find,
		is: function (el, selector) {
			return !!_closest(el, selector, el, false);
		},
		extend: _extend,
		throttle: _throttle,
		closest: _closest,
		toggleClass: _toggleClass,
		clone: _clone,
		index: _index,
		nextTick: _nextTick,
		cancelNextTick: _cancelNextTick,
		detectDirection: _detectDirection,
		getChild: _getChild
	};


	/**
	 * Create sortable instance
	 * @param {HTMLElement}  el
	 * @param {Object}      [options]
	 */
	Sortable.create = function (el, options) {
		return new Sortable(el, options);
	};


	// Export
	Sortable.version = '1.8.4';
	return Sortable;
});


/***/ }),
/* 39 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2);
/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Common_Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(34);
/* harmony import */ var geoportal_access_lib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(40);
/* harmony import */ var _Common_Utils_CheckRightManagement__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(140);
/* harmony import */ var _Common_Utils_SelectorID__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(36);
/* harmony import */ var _LocationSelector__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(142);
/* harmony import */ var _Common_Controls_IsoDOM__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(146);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }








var logger = _Common_Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_1__["default"].getLogger("Isocurve");
/**
 * @classdesc
 *
 * Leaflet Control Class to compute and display Isochrone or isodistances curves.
 *
 * Use {@link module:Controls.Isocurve L.geoportalControl.Isocurve()} factory to create instances of that class.
 *
 * **Extends** Leaflet <a href="http://leafletjs.com/reference.html#control" target="_blank">L.Control</a> native class.
 *
 * @namespace
 * @alias L.geoportalControl.Isocurve
 */

var Isocurve = leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.Control.extend(
/** @lends L.geoportalControl.Isocurve.prototype */
{
  includes: _Common_Controls_IsoDOM__WEBPACK_IMPORTED_MODULE_6__["default"],

  /**
   * Options du service
   *
   * @private
   */
  options: {
    position: "topleft",
    collapsed: true,
    // plier !
    methods: ["time", "distance"],
    graphs: ["Voiture", "Pieton"],
    exclusions: {
      toll: false,
      tunnel: false,
      bridge: false
    },
    directions: ["departure", "arrival"],
    disableReverse: false,
    isocurveOptions: {},
    autocompleteOptions: {}
  },

  /**
   * constructor
   *
   * @private
   * @param {Object} options - Isocurve control options
   * @param {Sting}   [options.apiKey] - API key for services call (isocurve and autocomplete services), mandatory if autoconf service has not been charged in advance
   * @param {Boolean} [options.ssl = true] - use of ssl or not (default true, service requested using https protocol)
   * @param {Boolean} [options.collapsed] - Specify if widget has to be collapsed (true) or not (false) on map loading. Default is true.
   * @param {Object}  [options.exclusions] - list of exclusions with status (true = checked), by default : ["toll":false, "tunnel":false, "bridge":false].
   * @param {Array}   [options.graphs] - list of graph resources to be used for isocurve calculation, by default : ["Voiture", "Pieton"]. The first element is selected.
   * @param {Array}   [options.methods] - list of methods, by default : ["time", "distance"]. The first element is selected by default.
   * @param {Array}   [options.directions] - list of directions to be displayed, by default : ["departure", "arrival"]. The first element is selected by default.
   *      Directions enable to specify if input location point will be used as a departure point ("departure") or as an arrival point ("arrival")
   * @param {Boolean} [options.disableReverse = false] - whether to enable/disable the reverse geocoding
   * @param {Object} [options.isocurveOptions] - isocurve service options.
   * @param {Object} [options.autocompleteOptions] - autocomplete service options.
   * @example
   *  var iso = L.geoportalControl.Isocurve({
   *      collapsed : false
   *      methods : ["time", "distance"],
   *      exclusions : {
   *         toll : true,
   *         bridge : false,
   *         tunnel : true
   *      },
   *      graphs : ["Pieton", "Voiture"],
   *      isocurveOptions : {},
   *      autocompleteOptions : {}
   *  });
   */
  initialize: function initialize(options) {
    // on transmet les options au controle
    leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.Util.setOptions(this, options);
    /** uuid */

    this._uid = _Common_Utils_SelectorID__WEBPACK_IMPORTED_MODULE_4__["default"].generate();
    /** detection du support : desktop ou tactile */

    this._isDesktop = this._detectSupport();
    /** detection si le panneau est reduit */
    // on desactive l'impl. reduction de la fenetre
    // this._reducePanel = false;

    /** container principaux */

    this._waitingContainer = null;
    this._showContainer = null;
    this._pictoContainer = null;
    this._formContainer = null;
    this._submitContainer = null;
    /** Mode de transport selectionné : 'Voiture' ou 'Pieton' */

    this._currentTransport = null;
    /** Sens du parcours selectionné : 'Départ' ou 'Arrivée' */

    this._currentDirection = null;
    /** Type d'isochrone et valeur selectionné : 'isochrone' ou 'distance' */

    this._currentComputation = null;
    this._currentTimeHour = 0;
    this._currentTimeMinute = 0;
    this._currentDistance = 0;
    /** Exclusions selectionnées : Tunnel, Toll et Bridge */

    this._currentExclusions = []; // initialisation

    this._initTransport();

    this._initComputation();

    this._initDirection();

    this._initExclusions();
    /** le point */


    this._currentPoint = null;
    /** la geometrie de l'isochrone */

    this._geojsonIso = null;
    /** si un calcul est en cours ou non */

    this._waiting = false;
    /** timer pour cacher la patience après un certain temps */

    this._timer = null;
    /**
     * reponse du service
     * Ex. {
     *   totalTime, totalDistance, bbox, routeGeometry,
     *   routeInstructions : [{duration, distance, code, instruction, bbox, geometry}]
     * }
     */

    this._currentIsoResults = null;
    /**
     * liste des ressources avec droits par service
     * Ex. {
     *   "IsoChrone" : {
     *       key : "ger4g456re45er456t4er5ge5",
     *       resources : ["Pieton", "Voiture"]
     *   }
     * }
     */

    this._resources = {};
    /** aucun droits sur les ressources */

    this._noRightManagement = false; // gestion des droits sur les ressources/services

    this._checkRightsManagement();
  },

  /**
   * this method is called by this.addTo(map) when the control is added on the map
   * and fills variable 'this._container = this.onAdd(map)',
   * and create or disable events on map.
   * @param {L.Map} map - object map
   * @returns {DOMElement} container
   * @private
   */
  onAdd: function onAdd(map) {
    // initialisation du DOM du composant
    var container = this._container = this._initLayout(map); // deactivate of events that may interfere with the map


    leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomEvent.disableClickPropagation(container).disableScrollPropagation(container);
    return container;
  },

  /**
   * TODO this method is called when the control is removed from the map
   * and removes events on map.
   *
   * @private
   */
  onRemove: function onRemove()
  /* map */
  {},
  // ################################################################### //
  // ####################### init application ########################## //
  // ################################################################### //

  /**
   * this method is called by the constructor and initialize the ...
   *
   * @private
   */
  _initTransport: function _initTransport() {
    // Mode de transport selectionné
    this._currentTransport = "Voiture"; // par defaut
    // par defaut

    var transport = this.options.graphs;

    if (!transport || transport.length === 0) {
      this.options.graphs = ["Voiture", "Pieton"];
    } // option


    if (leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.Util.isArray(transport) && transport.length) {
      // FIXME pb si le 1er graphe n'est pas une ressource connue !
      if (transport[0] === "Voiture" || transport[0] === "Pieton") {
        this._currentTransport = transport[0];
      }
    } // option sur le service


    var serviceOptions = this.options.isocurveOptions;

    if (serviceOptions.graph) {
      this._currentTransport = serviceOptions.graph;
    }
  },

  /**
   * this method is called by the constructor and initialize the ...
   *
   * @private
   */
  _initDirection: function _initDirection() {
    this._currentDirection = "departure"; // par defaut
    // par defaut

    var directions = this.options.directions;

    if (!directions || directions.length === 0) {
      this.options.directions = ["departure", "arrival"];
    } // option


    if (leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.Util.isArray(directions) && directions.length) {
      // FIXME pb si le 1er graphe n'est pas une ressource connue !
      if (directions[0] === "departure" || directions[0] === "arrival") {
        this._currentDirection = directions[0];
      }
    } // si l'utilisateur a spécifié une méthode dans le service, on surcharge les options du widget


    var serviceOptions = this.options.isocurveOptions;

    if (!serviceOptions.reverse) {
      this._currentDirection = "departure";
    }

    if (serviceOptions.reverse === true) {
      this._currentDirection = "arrival";
      this.options.directions = ["arrival", "departure"];
    }
  },

  /**
   * this method is called by the constructor and initialize the ...
   *
   * @private
   */
  _initComputation: function _initComputation() {
    // Mode de calcul selectionné
    this._currentComputation = "time"; // par defaut
    // par defaut

    var methods = this.options.methods;

    if (!methods || methods.length === 0) {
      this.options.methods = ["time", "distance"];
    } // option


    if (leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.Util.isArray(methods) && methods.length) {
      // FIXME pb si le 1er graphe n'est pas une ressource connue !
      if (methods[0] === "time" || methods[0] === "distance") {
        this._currentComputation = methods[0];
      }
    } // si l'utilisateur a spécifié une méthode dans le service, on surcharge les options du widget


    var serviceOptions = this.options.isocurveOptions;

    if (serviceOptions.method) {
      this._currentComputation = serviceOptions.method;
    }

    if (serviceOptions.time) {
      this._currentComputation = "time";
    }

    if (serviceOptions.distance) {
      this._currentComputation = "distance";
    }
  },

  /**
   * this method is called by the constructor and initialize the ...
   *
   * @private
   */
  _initExclusions: function _initExclusions() {
    // Exclusions selectionnées : Tunnel, Toll et Bridge
    this._currentExclusions = []; // par defaut
    // par defaut

    var exclusion = this.options.exclusions;

    if (!exclusion || _typeof(exclusion) === "object" && Object.keys(exclusion).length === 0) {
      this.options.exclusions = {
        toll: false,
        tunnel: false,
        bridge: false
      };
    } // option


    if (exclusion && _typeof(exclusion) === "object" && Object.keys(exclusion).length) {
      for (var k in exclusion) {
        if (exclusion.hasOwnProperty(k)) {
          if (exclusion.k) {
            this._currentExclusions.push(k);
          }
        }
      }
    } // si l'utilisateur a spécifié des exclusions dans le service, on surcharge les options du widget


    var serviceOptions = this.options.isocurveOptions;

    if (Array.isArray(serviceOptions.exclusions)) {
      this._currentExclusions = serviceOptions.exclusions;
    }
  },
  // ################################################################### //
  // ############################## other init ######################### //
  // ################################################################### //

  /**
   * this method is called by constructor
   * and check the rights to resources
   *
   * @private
   */
  _checkRightsManagement: function _checkRightsManagement() {
    var _opts = null;
    var _res = [];
    var _key = null; // les ressources du service du calcul d'isochrone

    _key = this.options.isocurveOptions.apiKey;
    _opts = this.options.isocurveOptions.filterOptions;
    _res = _opts ? _opts.type : [];

    if (!_res || _res.length === 0) {
      _res = ["Voiture", "Pieton"];
    }

    var rightManagementIsochrone = _Common_Utils_CheckRightManagement__WEBPACK_IMPORTED_MODULE_3__["default"].check({
      key: _key || this.options.apiKey,
      resources: _res,
      services: ["Isochrone"]
    });
    logger.log("rightManagementIsochrone", rightManagementIsochrone); // les ressources du service d'autocompletion

    _key = this.options.autocompleteOptions.apiKey;
    _opts = this.options.autocompleteOptions.filterOptions;
    _res = _opts ? _opts.type : [];

    if (!_res || _res.length === 0) {
      _res = ["PositionOfInterest", "StreetAddress"];
    }

    var rightManagementAutoComplete = _Common_Utils_CheckRightManagement__WEBPACK_IMPORTED_MODULE_3__["default"].check({
      key: _key || this.options.apiKey,
      resources: _res,
      services: ["AutoCompletion"]
    });
    logger.log("rightManagementAutoComplete", rightManagementAutoComplete); // au cas où pas de droit !

    if (!rightManagementIsochrone && !rightManagementAutoComplete) {
      this._noRightManagement = true;
    } // FIXME je reconstruis differement la structure pour la gestion des clefs differentes
    // pour chaque service...


    if (rightManagementAutoComplete) {
      this._resources["AutoCompletion"] = {};
      this._resources["AutoCompletion"]["resources"] = rightManagementAutoComplete["AutoCompletion"];
      this._resources["AutoCompletion"]["key"] = rightManagementAutoComplete["key"];
    }

    if (rightManagementIsochrone) {
      this._resources["Isochrone"] = {};
      this._resources["Isochrone"]["resources"] = rightManagementIsochrone["Isochrone"];
      this._resources["Isochrone"]["key"] = rightManagementIsochrone["key"];
    }
  },

  /**
   * this method is called by the constructor.
   * this information is useful to switch to touch mode.
   * Detection : test for desktop or tactile
   * @returns {Boolean} desktop or tactile
   * @private
   */
  _detectSupport: function _detectSupport() {
    // TODO
    // Choix de gérer la détection dans le code du composant au lieu du DOM car :
    // Utilisation de l'implémentation Leaflet
    // http://leafletjs.com/reference.html#browser
    var isDesktop = true;
    var userAgent = window.navigator.userAgent.toLowerCase();

    if (userAgent.indexOf("iphone") !== -1 || userAgent.indexOf("ipod") !== -1 || userAgent.indexOf("ipad") !== -1 || userAgent.indexOf("android") !== -1 || userAgent.indexOf("mobile") !== -1 || userAgent.indexOf("blackberry") !== -1 || userAgent.indexOf("tablet") !== -1 || userAgent.indexOf("phone") !== -1 || userAgent.indexOf("touch") !== -1) {
      isDesktop = false;
    }

    if (userAgent.indexOf("msie") !== -1 || userAgent.indexOf("trident") !== -1) {
      isDesktop = true;
    }

    return isDesktop;
  },
  // ################################################################### //
  // ########################### init dom ############################## //
  // ################################################################### //

  /**
   * this method is called by this.onAdd(map)
   * and initialize the container HTMLElement
   * @param {L.Map} map - object map
   * @returns {DOMElement} container
   * @private
   */
  _initLayout: function _initLayout(map) {
    // create main container
    var container = this._createMainContainerElement();

    var inputShow = this._showContainer = this._createShowIsoElement();

    container.appendChild(inputShow); // mode "collapsed"

    if (!this.options.collapsed) {
      inputShow.checked = true;
    }

    var picto = this._pictoContainer = this._createShowIsoPictoElement();

    container.appendChild(picto); // panneau

    var panel = this._createIsoPanelElement(); // header


    var header = this._createIsoPanelHeaderElement();

    panel.appendChild(header); // form

    var form = this._formContainer = this._createIsoPanelFormElement(); // form: menu des points


    var point = this._createIsoPanelFormPointElement(map);

    form.appendChild(point); // form: menu du choix de la méthode de calcul (time ou distance)

    var isoChronChecked = false;
    var isoDistChecked = false;

    var typeChoice = this._createIsoPanelFormTypeChoiceElement();

    for (var i = 0; i < this.options.methods.length; i++) {
      if (this.options.methods[i] === "time") {
        isoChronChecked = i === 0;
        typeChoice.appendChild(this._createIsoPanelFormTypeChoiceChronElement(isoChronChecked));
      }

      if (this.options.methods[i] === "distance") {
        isoDistChecked = i === 0;
        typeChoice.appendChild(this._createIsoPanelFormTypeChoiceDistElement(isoDistChecked));
      }
    }

    form.appendChild(typeChoice); // form: menu du choix des valeurs

    form.appendChild(this._createIsoPanelFormValueIsochronElement(isoChronChecked));
    form.appendChild(this._createIsoPanelFormValueIsodistanceElement(isoDistChecked)); // form: menu du choix du transport et du sens du parcours

    var modeChoice = this._createIsoPanelFormModeChoiceElement();

    modeChoice.appendChild(this._createIsoPanelFormModeChoiceTransportElement(this.options.graphs));
    modeChoice.appendChild(this._createIsoPanelFormModeChoiceDirectionElement(this.options.directions));
    form.appendChild(modeChoice); // form: menu des exclusions

    if (this.options.exclusions && _typeof(this.options.exclusions) === "object" && Object.keys(this.options.exclusions).length !== 0) {
      form.appendChild(this._createShowIsoExclusionsElement());
      form.appendChild(this._createShowIsoExclusionsPictoElement());

      var exclusion = this._createIsoPanelFormExclusionsElement();

      exclusion.appendChild(this._createIsoPanelFormExclusionOptionsElement(this.options.exclusions));
      form.appendChild(exclusion);
    }

    var divReset = this._createIsoFormResetElement();

    form.appendChild(divReset); // form: bouton du calcul

    var submit = this._submitContainer = this._createIsoSubmitFormElement();

    form.appendChild(submit);
    panel.appendChild(form); // waiting

    var waiting = this._waitingContainer = this._createIsoWaitingElement();

    panel.appendChild(waiting);
    container.appendChild(panel);
    return container;
  },
  // ################################################################### //
  // ############################## DOM ################################ //
  // ################################################################### //

  /**
   * Create a Point
   * OVERWRITTEN
   * @param {L.Map} map - object map
   * @returns {Object} DOM element
   * @private
   */
  _createIsoPanelFormPointElement: function _createIsoPanelFormPointElement(map) {
    // point de depart
    this._currentPoint = new _LocationSelector__WEBPACK_IMPORTED_MODULE_5__["default"]({
      apiKey: this.options.apiKey || null,
      tag: {
        id: 0,
        unique: this._uid,
        label: "Départ",
        color: "red",
        display: true
      },
      displayInfo: true,
      disableReverse: this.options.disableReverse,
      autocompleteOptions: this.options.autocompleteOptions || null
    });

    this._currentPoint.setMap(map);

    return this._currentPoint.getContainer();
  },
  // ################################################################### //
  // ####################### handlers events to dom #################### //
  // ################################################################### //

  /**
   * this method is called by event 'click' on 'GPshowIsochronPicto' picto
   * (cf. this._createShowIsoPictoElement),
   * and clear inputs and previous isochrone drawings
   *
   * @param {Object} e - HTMLElement
   *
   * @private
   */
  onShowIsoPanelClick: function onShowIsoPanelClick(e) {
    logger.log("onShowIsoPanelClick", e); // on desactive l'impl. reduction de la fenetre
    // if (this._geojsonIso && !this._reducePanel) {
    //     this._clear();
    // }
    // this._reducePanel = false;
  },

  /**
   * this method is called by event 'click' on '' arrow button
   * (cf. this.),
   * and clear inputs and previous isochrone drawings
   *
   * @param {Object} e - HTMLElement
   *
   * @private
   */
  onIsoResetClick: function onIsoResetClick(e) {
    logger.log("onIsoResetClick", e);

    this._clear();
  },
  // // on desactive l'impl. reduction de la fenetre
  // /**
  // * this method is called by event 'click' on 'GPisochronPanelReduce' picto
  // * (cf. this.),
  // * and reduce the panel
  // *
  // * @private
  // */
  // onReduceIsoPanelClick : function () {
  //     logger.log("onReduceIsoPanelClick");
  //     this._reducePanel = true;
  // },

  /**
   * this method is called by event 'change' on 'GPisochronChoiceAltDist' or 'GPisochronChoiceAltChron'
   * input (cf. this._createIsoPanelFormTypeChoiceElement),
   * and updates current computation mode
   *
   * @param {Object} e - HTMLElement
   *
   * @private
   */
  onIsoTypeChoiceChange: function onIsoTypeChoiceChange(e) {
    var value = e.target.value;

    if (!value) {
      return;
    }

    if (value === "isodistance") {
      this._currentComputation = "distance";
    }

    if (value === "isochron") {
      this._currentComputation = "time";
    }
  },

  /**
   * this method is called by event 'click' on 'GPisochronTransportPedestrian' or 'GPisochronTransportCar'
   * input (cf. this._createIsoPanelFormModeChoiceTransportElement),
   * and updates current transport mode
   *
   * @param {Object} e - HTMLElement
   *
   * @private
   */
  onIsoModeTransportChange: function onIsoModeTransportChange(e) {
    var value = e.target.value;

    if (!value) {
      return;
    }

    this._currentTransport = value;
  },

  /**
   * this method is called by event 'change' on 'GPisochronDirectionSelect' select
   * (cf. this._createIsoPanelFormModeChoiceDirectionElement),
   * and updates current direction mode
   *
   * @param {Object} e - HTMLElement
   *
   * @private
   */
  onIsoModeDirectionChange: function onIsoModeDirectionChange(e) {
    var value = e.target.value;

    if (!value) {
      return;
    }

    this._currentDirection = value;
  },

  /**
   * this method is called by event 'change' on ''
   * input (cf. this.),
   * and updates current time value
   *
   * @param {Object} e - HTMLElement
   *
   * @private
   */
  onIsoValueChronTimeHourChange: function onIsoValueChronTimeHourChange(e) {
    var value = e.target.value; // pointer to...

    this._timeHourContainer = e.target;

    if (!value) {
      return;
    }

    this._currentTimeHour = value;
  },

  /**
   * this method is called by event 'change' on ''
   * input (cf. this.),
   * and updates current time value
   *
   * @param {Object} e - HTMLElement
   *
   * @private
   */
  onIsoValueChronTimeMinuteChange: function onIsoValueChronTimeMinuteChange(e) {
    var value = e.target.value; // pointer to...

    this._timeMinuteContainer = e.target;

    if (!value) {
      return;
    }

    this._currentTimeMinute = value;
  },

  /**
   * this method is called by event 'change' on ''
   * input (cf. this.),
   * and updates current distance value
   *
   * @param {Object} e - HTMLElement
   *
   * @private
   */
  onIsoValueDistChange: function onIsoValueDistChange(e) {
    var value = e.target.value; // pointer to...

    this._distanceContainer = e.target;

    if (!value) {
      return;
    }

    this._currentDistance = value;
  },

  /**
   * this method is called by event 'change' on 'GPIsoExclusionsToll'
   * or 'GPIsoeExclusionsTunnel' or 'GPIsoExclusionsBridge' tag input
   * (cf. this._createIsoPanelFormExclusionOptionsElement).
   * this value is saved as a parameter for the service isocurve.
   *
   * @param {Object} e - HTMLElement
   *
   * @private
   */
  onIsoExclusionsChange: function onIsoExclusionsChange(e) {
    var value = e.target.value;
    var checked = e.target.checked;

    if (!value) {
      return;
    }

    var bFound = false;
    var iFound = null;

    for (var i = 0; i < this._currentExclusions.length; i++) {
      if (this._currentExclusions[i] === value) {
        iFound = i;
        bFound = true;
      }
    } // on l'ajoute si la valeur n'existe pas et est selectionnée


    if (!bFound && !checked) {
      this._currentExclusions.push(value);
    } // on la retire si la valeur existe et est deselectionnée


    if (bFound && checked) {
      this._currentExclusions.splice(iFound, 1);
    }
  },

  /**
   * this method is called by event 'submit' on 'GPisochronForm' tag form
   * (cf. this._createIsoPanelFormElement),
   * and call isocurve service to display results
   *
   * @private
   */
  onIsoComputationSubmit: function onIsoComputationSubmit() {
    if (!this._currentPoint || !this._currentPoint.getCoordinate || !this._currentPoint.getCoordinate()) {
      return;
    } // récupération du temps


    var time;

    if (this._currentComputation.toLowerCase() === "time") {
      // durée exprimée en secondes
      time = this._currentTimeHour * 3600 + this._currentTimeMinute * 60;
      logger.log("time : ", time);
    } // récupération de la distance


    var distance;

    if (this._currentComputation.toLowerCase() === "distance") {
      // distance exprimée en mètres
      distance = this._currentDistance * 1000;
      logger.log("distance : ", distance);
    } // si on n'a pas de valeur de calcul renseignée, on ne lance pas la requête.


    if (!time && !distance) {
      logger.log("Missing time or distance parameter");
      return;
    } // oups, aucun droits !
    // on evite donc une requête inutile ...


    if (this._noRightManagement) {
      return;
    } // mise en place de la patience


    this._displayWaitingContainer();

    var self = this;

    this._requestIsoCurve({
      position: self._currentPoint.getCoordinate(),
      graph: self._currentTransport,
      exclusions: self._currentExclusions,
      method: self._currentComputation,
      reverse: self._currentDirection.toLowerCase() === "arrival",
      time: time,
      distance: distance,
      smoothing: true,
      timeout: 7000,
      protocol: "XHR",
      // callback onSuccess
      onSuccess: function onSuccess(results) {
        logger.log(results);

        if (results) {
          self._drawIsoResults(results);
        }
      },
      // callback onFailure
      onFailure: function onFailure(error) {
        // FIXME mise à jour du controle mais le service ne repond pas en 200 !?
        self._hideWaitingContainer();

        self._clearIsoResultsGeometry();

        logger.log(error.message);
      }
    });
  },
  // ################################################################### //
  // ######################## isocurve calculation ##################### //
  // ################################################################### //

  /**
   * this method is called by this.onIsoComputationSubmit
   * and executes a request to the service.
   *
   * @param {Object} settings - service settings
   *
   * @private
   */
  _requestIsoCurve: function _requestIsoCurve(settings) {
    // on ne fait pas de requête si on n'a pas renseigné de parametres !
    if (!settings || _typeof(settings) === "object" && Object.keys(settings).length === 0) {
      return;
    } // on ne fait pas de requête si on n'a pas de point d'origine


    if (!settings.position) {
      return;
    } // ni si on n'a aucun droit


    if (this._noRightManagement) {
      return;
    } // gestion des droits !


    var services = this._resources["Isochrone"];

    if (!services) {
      return;
    }

    var resources = services.resources;

    if (!resources || _typeof(resources) === "object" && Object.keys(resources).length === 0) {
      return;
    }

    var options = {}; // on recupere les parametres de saisie et les callbacks

    leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.Util.extend(options, settings); // ainsi que les options du service

    leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.Util.extend(options, this.options.isocurveOptions); // la ressource donne elle des droits ?

    var bFound = false;

    for (var i = 0; i < resources.length; i++) {
      if (resources[i] === options.graph) {
        bFound = true;
      }
    } // on fait quoi ?


    if (!bFound) {
      logger.log("no rights for this service !?");
      return;
    } // cas où la clef API n'est pas renseignée dans les options du service,
    // on utilise celle de l'autoconf ou celle renseignée au niveau du controle


    var key = this._resources["Isochrone"]["key"];
    options.apiKey = this.options.isocurveOptions.apiKey || this.options.apiKey || key; // si l'utilisateur a spécifié le paramètre ssl au niveau du control, on s'en sert
    // true par défaut (https)

    options.ssl = this.options.ssl;
    logger.log(options);
    geoportal_access_lib__WEBPACK_IMPORTED_MODULE_2__["default"].Services.isoCurve(options);
  },

  /**
   * this method is called by this.onIsoComputationSubmit (in case of success)
   * and draw isocurve results geometry on map
   *
   * @param {Object} results - isocurve response results
   *
   * @private
   */
  _drawIsoResults: function _drawIsoResults(results) {
    this._clearIsoResultsGeometry(); // sauvegarde de l'etat des resultats


    this._currentIsoResults = results;

    if (!results.geometry) {
      // cache la patience
      this._hideWaitingContainer();

      return;
    }

    var map = this._map;
    var _geometry = results.geometry;
    var _style = {
      color: "#ff7800",
      weight: 5,
      opacity: 0.65
    };
    this._geojsonIso = leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.geoJson(_geometry, {
      style: _style
    }).addTo(map); // cache la patience

    this._hideWaitingContainer();

    this._formContainer.className = "GPisochroComponentHidden";
  },
  // ################################################################### //
  // ############################# Clean ############################### //
  // ################################################################### //

  /**
   * this method is called by this.onShowIsoPanelClick()
   * and it clears all elements (reinit).
   *
   * @private
   */
  _clear: function _clear() {
    this._initTransport();

    this._initExclusions();

    this._initComputation();

    this._initDirection(); // resultats du service


    this._currentIsoResults = null; // la geometrie

    this._clearIsoResultsGeometry(); // les points


    this._currentPoint.clear(); // nettoyer les valeurs dans le DOM !


    if (this._timeHourContainer) {
      this._timeHourContainer.value = 0;
    }

    if (this._timeMinuteContainer) {
      this._timeMinuteContainer.value = 0;
    }

    if (this._distanceContainer) {
      this._distanceContainer.value = 0;
    }
  },

  /**
   * this method is called by this.onIsoComputationSubmit()
   * and it clears all route geometries.
   *
   * @private
   */
  _clearIsoResultsGeometry: function _clearIsoResultsGeometry() {
    var map = this._map;

    if (this._geojsonIso != null) {
      map.removeLayer(this._geojsonIso);
      this._geojsonIso = null;
    }
  },
  // ################################################################### //
  // ############################ Patience ############################# //
  // ################################################################### //

  /**
   * this method displays waiting container and sets a timeout
   *
   * @private
   */
  _displayWaitingContainer: function _displayWaitingContainer() {
    this._waitingContainer.className = "GPisochronCalcWaitingContainerVisible";
    this._waiting = true; // mise en place d'un timeout pour réinitialiser le panel (cacher la patience)
    // si on est toujours en attente (si la requête est bloquée par exemple)

    if (this._timer) {
      clearTimeout(this._timer);
      this._timer = null;
    }

    var context = this;
    this._timer = setTimeout(function () {
      if (context._waiting === true) {
        context._hideWaitingContainer();
      } else {
        if (context._timer) {
          clearTimeout(context._timer);
        }
      }
    }, 16000);
  },

  /**
   * this method hides waiting container and clears timeout
   *
   * @private
   */
  _hideWaitingContainer: function _hideWaitingContainer() {
    if (this._waiting) {
      this._waitingContainer.className = "GPisochronCalcWaitingContainerHidden";
      this._waiting = false;
      clearTimeout(this._timer);
      this._timer = null;
    }
  },
  // ################################################################### //
  // ###### METHODES PUBLIQUES (INTERFACE AVEC LE CONTROLE) ############ //
  // ################################################################### //

  /**
   * This method is public.
   * It allows to control the execution of a traitment.
   *
   * @param {Object} position - position = {lon: , lat: }
   * @param {Object} value - distance en km ou heures-minutes
   * @param {Object} options - options = {...}
   */
  compute: function compute(position, value, options) {
    if (!this._showContainer.checked) {
      this._pictoContainer.click();
    }

    var map = this._map;

    if (!map) {
      return;
    } // Les options par defauts


    var settings = {
      direction: "departure",
      method: "time",
      transport: "Voiture",
      exclusions: []
    }; // On recupere les options

    leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.Util.extend(settings, options);

    this._currentPoint.setCoordinate(position);

    var input = leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.get("GPlocationOrigin_" + 0 + "-" + this._uid);
    input.value = position.lng + " , " + position.lat;
    this._currentTransport = settings.transport;

    if (settings.transport === "Voiture") {
      leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.get("GPisochronTransportCar-" + this._uid).checked = true;
    } else {
      leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.get("GPisochronTransportPedestrian-" + this._uid).checked = true;
    }

    this._currentExclusions = settings.exclusions;
    this._currentComputation = settings.method;

    if (settings.method === "time") {
      var time = value.split(".");
      this._currentTimeHour = time[0] || 0;
      leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.get("GPisochronValueChronInput1-" + this._uid).value = this._currentTimeHour;
      this._currentTimeMinute = time[1] || 0;
      leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.get("GPisochronValueChronInput2-" + this._uid).value = this._currentTimeMinute;
      leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.get("GPisochronChoiceAltChron-" + this._uid).click();
    } else {
      this._currentDistance = value;
      leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.get("GPisochronValueDistInput-" + this._uid).value = this._currentDistance;
      leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.get("GPisochronChoiceAltDist-" + this._uid).click();
    }

    this._currentDirection = settings.direction;
    settings.direction === "departure" ? leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.get("GPisochronDirectionSelect-" + this._uid).selectedIndex = 0 : leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.DomUtil.get("GPisochronDirectionSelect-" + this._uid).selectedIndex = 1;
    this.onIsoComputationSubmit();
    map.flyTo(position);
  }
});
/* harmony default export */ __webpack_exports__["default"] = (Isocurve);

/***/ }),
/* 40 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "servicesVersion", function() { return servicesVersion; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "servicesDate", function() { return servicesDate; });
/* harmony import */ var _Services_Services__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(41);
/* harmony import */ var _Services_DefaultUrlService__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56);
/* harmony import */ var _Services_Alti_Response_model_AltiResponse__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(68);
/* harmony import */ var _Services_Alti_Response_model_Elevation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(69);
/* harmony import */ var _Services_AutoComplete_Response_model_AutoCompleteResponse__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(117);
/* harmony import */ var _Services_AutoComplete_Response_model_SuggestedLocation__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(118);
/* harmony import */ var _Services_AutoConf_Response_model_AutoConfResponse__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(73);
/* harmony import */ var _Services_AutoConf_Response_model_Constraint__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(74);
/* harmony import */ var _Services_AutoConf_Response_model_Format__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(75);
/* harmony import */ var _Services_AutoConf_Response_model_Layer__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(76);
/* harmony import */ var _Services_AutoConf_Response_model_Legend__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(77);
/* harmony import */ var _Services_AutoConf_Response_model_Metadata__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(78);
/* harmony import */ var _Services_AutoConf_Response_model_Originator__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(79);
/* harmony import */ var _Services_AutoConf_Response_model_Service__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(80);
/* harmony import */ var _Services_AutoConf_Response_model_Style__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(81);
/* harmony import */ var _Services_AutoConf_Response_model_Territory__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(82);
/* harmony import */ var _Services_AutoConf_Response_model_Thematic__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(83);
/* harmony import */ var _Services_AutoConf_Response_model_TileMatrix__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(85);
/* harmony import */ var _Services_AutoConf_Response_model_TileMatrixLimit__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(86);
/* harmony import */ var _Services_AutoConf_Response_model_TileMatrixSet__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(84);
/* harmony import */ var _Services_Geocode_Response_model_GeocodeResponse__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(107);
/* harmony import */ var _Services_Geocode_Response_model_GeocodedLocation__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(109);
/* harmony import */ var _Services_Geocode_Response_model_DirectGeocodedLocation__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(108);
/* harmony import */ var _Services_Geocode_Response_model_ReverseGeocodedLocation__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(114);
/* harmony import */ var _Services_ProcessIsoCurve_Response_model_ProcessIsoCurveResponse__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(139);
/* harmony import */ var _Services_Route_Response_model_RouteResponse__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(131);
/* harmony import */ var _Services_Route_Response_model_RouteInstruction__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(132);
/* harmony import */ var _Protocols_XHR__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(49);
/* harmony import */ var _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(45);
/* harmony import */ var _Utils_Helper__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(47);
/* harmony import */ var _package_json__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(57);
var _package_json__WEBPACK_IMPORTED_MODULE_30___namespace = /*#__PURE__*/__webpack_require__.t(57, 1);
/**
* Global variable Gp.
*
* @module Gp
* @alias Gp
* @description
*
* This is the global variable that is exposed in the browser environment.
* Content is composed of constructor, functions and properties...
*
* > {@link Gp.Error Error()}
*     - .TYPE_SRVERR : "SERVICE_ERROR"
*     - .TYPE_UNKERR : "UNKNOWN_ERROR"
*     - .TYPE_USEERR : "USAGE_ERROR"
*
* > {@link module:Helper Helper}
*     - .indent()
*     - .normalyzeParameters()
*     - .normalyzeUrl()
*
* > {@link module:XHR Protocols.XHR}
*     - .call()
*
* > {@link module:Services Services (objects)}
*     - .Alti
*         - {@link Gp.Services.Alti.Elevation .Elevation()}
*     - {@link Gp.Services.AltiResponse .AltiResponse()}
*     - .AutoComplete
*         - {@link Gp.Services.AutoComplete.SuggestedLocation .SuggestedLocation()}
*     - {@link Gp.Services.AutoCompleteResponse .AutoCompleteResponse()}
*     - {@link Gp.Services.Config .Config()}
*     - {@link Gp.Services.DefaultUrl .DefaultUrl()}
*     - .Geocode
*         - {@link Gp.Services.Geocode.GeocodedLocation .GeocodedLocation()}
*         - {@link Gp.Services.Geocode.ReverseGeocodedLocation .ReverseGeocodedLocation()}
*         - {@link Gp.Services.Geocode.DirectGeocodedLocation .DirectGeocodedLocation()}
*     - {@link Gp.Services.GeocodeResponse .GeocodeResponse()}
*     - {@link Gp.Services.GetConfigResponse .GetConfigResponse()}
*     - {@link Gp.Services.IsoCurveResponse .IsoCurveResponse()}
*     - .Route
*         - {@link Gp.Services.Route.RouteInstruction .RouteInstruction()}
*     - {@link Gp.Services.RouteResponse .RouteResponse()}
*
* > Services (factory)
*     - {@link module:Services~autoComplete .autoComplete()}
*     - {@link module:Services~geocode .geocode()}
*     - {@link module:Services~getAltitude .getAltitude()}
*     - {@link module:Services~getConfig .getConfig()}
*     - {@link module:Services~isoCurve .isoCurve()}
*     - {@link module:Services~reverseGeocode .reverseGeocode()}
*     - {@link module:Services~route .route()}
*
* > servicesDate : "YYYY-MM-DD"
*
* > servicesVersion : "X.X.X"
*
*/


































/** Version */
const servicesVersion = _package_json__WEBPACK_IMPORTED_MODULE_30__.version;
/** Publication date */
const servicesDate = _package_json__WEBPACK_IMPORTED_MODULE_30__.date;

// on declare les ns dans root global
var Gp = {};

Gp.servicesVersion = servicesVersion;
Gp.servicesDate = servicesDate;

// Export Protocols
Gp.Protocols = {};
Gp.Protocols.XHR = _Protocols_XHR__WEBPACK_IMPORTED_MODULE_27__["default"];
// Export services
Gp.Services = _Services_Services__WEBPACK_IMPORTED_MODULE_0__["default"];
// Export DefaultUrls
Gp.Services.DefaultUrl = _Services_DefaultUrlService__WEBPACK_IMPORTED_MODULE_1__["default"];
// Export Alti
Gp.Services.AltiResponse = _Services_Alti_Response_model_AltiResponse__WEBPACK_IMPORTED_MODULE_2__["default"];
Gp.Services.Alti = {};
Gp.Services.Alti.Elevation = _Services_Alti_Response_model_Elevation__WEBPACK_IMPORTED_MODULE_3__["default"];
// Export Autocomplete
Gp.Services.AutoCompleteResponse = _Services_AutoComplete_Response_model_AutoCompleteResponse__WEBPACK_IMPORTED_MODULE_4__["default"];
Gp.Services.AutoComplete = {};
Gp.Services.AutoComplete.SuggestedLocation = _Services_AutoComplete_Response_model_SuggestedLocation__WEBPACK_IMPORTED_MODULE_5__["default"];
// Export Autoconf
Gp.Services.GetConfigResponse = _Services_AutoConf_Response_model_AutoConfResponse__WEBPACK_IMPORTED_MODULE_6__["default"];
Gp.Services.Config = {};
Gp.Services.Config.Constraint = _Services_AutoConf_Response_model_Constraint__WEBPACK_IMPORTED_MODULE_7__["default"];
Gp.Services.Config.Format = _Services_AutoConf_Response_model_Format__WEBPACK_IMPORTED_MODULE_8__["default"];
Gp.Services.Config.Layer = _Services_AutoConf_Response_model_Layer__WEBPACK_IMPORTED_MODULE_9__["default"];
Gp.Services.Config.Legend = _Services_AutoConf_Response_model_Legend__WEBPACK_IMPORTED_MODULE_10__["default"];
Gp.Services.Config.Metadata = _Services_AutoConf_Response_model_Metadata__WEBPACK_IMPORTED_MODULE_11__["default"];
Gp.Services.Config.Originator = _Services_AutoConf_Response_model_Originator__WEBPACK_IMPORTED_MODULE_12__["default"];
Gp.Services.Config.Service = _Services_AutoConf_Response_model_Service__WEBPACK_IMPORTED_MODULE_13__["default"];
Gp.Services.Config.Style = _Services_AutoConf_Response_model_Style__WEBPACK_IMPORTED_MODULE_14__["default"];
Gp.Services.Config.Territory = _Services_AutoConf_Response_model_Territory__WEBPACK_IMPORTED_MODULE_15__["default"];
Gp.Services.Config.Thematic = _Services_AutoConf_Response_model_Thematic__WEBPACK_IMPORTED_MODULE_16__["default"];
Gp.Services.Config.TileMatrix = _Services_AutoConf_Response_model_TileMatrix__WEBPACK_IMPORTED_MODULE_17__["default"];
Gp.Services.Config.TileMatrixLimit = _Services_AutoConf_Response_model_TileMatrixLimit__WEBPACK_IMPORTED_MODULE_18__["default"];
Gp.Services.Config.TileMatrixSet = _Services_AutoConf_Response_model_TileMatrixSet__WEBPACK_IMPORTED_MODULE_19__["default"];
// Export Geocode
Gp.Services.GeocodeResponse = _Services_Geocode_Response_model_GeocodeResponse__WEBPACK_IMPORTED_MODULE_20__["default"];
Gp.Services.Geocode = {};
Gp.Services.Geocode.GeocodedLocation = _Services_Geocode_Response_model_GeocodedLocation__WEBPACK_IMPORTED_MODULE_21__["default"];
Gp.Services.Geocode.DirectGeocodedLocation = _Services_Geocode_Response_model_DirectGeocodedLocation__WEBPACK_IMPORTED_MODULE_22__["default"];
Gp.Services.Geocode.ReverseGeocodedLocation = _Services_Geocode_Response_model_ReverseGeocodedLocation__WEBPACK_IMPORTED_MODULE_23__["default"];
// Export IsoCurve
Gp.Services.IsoCurveResponse = _Services_ProcessIsoCurve_Response_model_ProcessIsoCurveResponse__WEBPACK_IMPORTED_MODULE_24__["default"];
// Export Route
Gp.Services.RouteResponse = _Services_Route_Response_model_RouteResponse__WEBPACK_IMPORTED_MODULE_25__["default"];
Gp.Services.Route = {};
Gp.Services.Route.RouteInstruction = _Services_Route_Response_model_RouteInstruction__WEBPACK_IMPORTED_MODULE_26__["default"];
// Export Erreurs et Outils
Gp.Error = _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_28__["default"];
Gp.Helper = _Utils_Helper__WEBPACK_IMPORTED_MODULE_29__["default"];

/* harmony default export */ __webpack_exports__["default"] = (Gp);


/***/ }),
/* 41 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Alti_Alti__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(42);
/* harmony import */ var _AutoConf_AutoConf__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(70);
/* harmony import */ var _Geocode_Geocode__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(87);
/* harmony import */ var _Geocode_ReverseGeocode__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(110);
/* harmony import */ var _AutoComplete_AutoComplete__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(115);
/* harmony import */ var _Route_Route__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(119);
/* harmony import */ var _ProcessIsoCurve_ProcessIsoCurve__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(134);
/* eslint no-unused-vars: ["error", { "varsIgnorePattern": "point|circle|bbox" }] */

/**
* Geoportal web services invocation namespace.
*
* @module Services
* @alias Gp.Services
*/








var Services = {
    /**
     * Access to Geoportal resources metadata availables with one ore several keys, using [Auto-configuration service]{@link https://wxs.ign.fr/APIKEY/autoconf} of the Geoportal platform.
     *
     * @method getConfig
     * @param {Object} options - Options for function call.
     * @param {String} options.apiKey - Access key to Geoportal platform, obtained [here]{@link http://professionnels.ign.fr/ign/contrats}.
     * @param {Function} options.onSuccess - Callback function for getting successful service response. Takes a {@link Gp.Services.GetConfigResponse} object as a parameter except if "rawResponse" parameter is set to true : a String will be returned.
     * @param {Function} [options.onFailure] - Callback function for handling unsuccessful service responses (timeOut, missing rights, ...). Takes a {@link Gp.Error} object as parameter.
     * @param {Number} [options.timeOut=0] - Number of milliseconds above which a timeOut response will be returned with onFailure callback (see above). Default value is 0 which means timeOut will not be handled.
     * @param {String} [options.serverUrl=http (s)://wxs.ign.fr/APIKEY/autoconf] - Web service URL. If used, options.apiKey parameter is ignored. Only use if you know what you're doing.
     * @param {Boolean} [options.ssl = true] - Use of HTTPS or HTTP protocol to request the services. HTTPS by default (ssl=true).
     * @param {String} [options.protocol=JSONP] - Protocol used to handle dialog with web service. Possible values are 'JSONP' ({@link https://en.wikipedia.org/wiki/JSONP}) and 'XHR' ({@link https://en.wikipedia.org/wiki/XMLHttpRequest}). Only XHR protocol is supported in a NodeJS environment. Only use if you know what you're doing.
     * @param {String} [options.proxyURL] - Proxy URL to use when requesting an underlying web service. Ignored when options.protocol is set to 'JSONP' value. Only use if you know what you're doing.
     * @param {String} [options.callbackSuffix] - Callback function name suffix to use in case of a JSONP protocol use (see above), to set your own suffix instead of auto-increment. Ignored when options.protocol is set to 'XHR' value. Only use if you know what you're doing.
     * @param {String} [options.httpMethod=GET] - HTTP method to use when requesting underlying web service in case of a XHR protocol use (see above). Possible values are 'GET' and 'POST'. Ignored when options.protocol is set to 'JSONP' value. Only use if you know what you are doing.
     * @param {String} [options.contentType="application/xml"] - Content-Type to use when requesting underlying web service in case of a XHR protocol use (see above) and if method HTTP is POST. Ignored when options.protocol is set to 'JSONP' value. Only use if you know what you are doing.
     * @param {Boolean} [options.rawResponse=false] - Setting this parameter to true implies you want to handle the service response by yourself : it will be returned as an unparsed String in onSuccess callback parameter. Only use if you know what you are doing.
     * @param {Function} [options.onBeforeParse] - Callback function for handling service response before parsing (as an unparsed String). Takes a String as a parameter (the raw service response). Returns a String that will be parsed as the service response. Only use if you know what you are doing.
     */
    getConfig : function (options) {
        var autoconfService = new _AutoConf_AutoConf__WEBPACK_IMPORTED_MODULE_1__["default"](options);
        autoconfService.call();
    },

    /**
     * Getting elevations in or along of one or several points on french territories using the [elevation services of the Geoportal Platform]{@link https://geoservices.ign.fr/documentation/geoservices/alti.html}.<br/>
     * Two use cases are availables :<br/>
     * 1. getting elevations of the given points : don't use the options.sampling parameter ;<br/>
     * 2. getting a regular set of elevations along the given points : use the options.sampling parameter.
     *
     * @method getAltitude
     * @param {Object} options - Options for function call.
     * @param {String} options.apiKey - Access key to Geoportal platform, obtained [here]{@link http://professionnels.ign.fr/ign/contrats}.
     * @param {Array.<Object>} options.positions - Array of positions ({lon:float, lat:float}) expressed in CRS:84 coordinates system, where to get elevations. 50 positions maximum may be given. 2 positions minimum are required if you use the options.sampling parameter.
     * @param {Number} [options.sampling] - Number of points to use (between 2 and 5000) in order to compute an elevation path. The points given with the options.positions parameter are used to fix the planimetric path along which the elevations will be computed.<br/>
     * If not used, only elevations of these positions will be returned.
     * @param {Boolean} [options.zonly=false] - Set this parameter to true if you only want to have elevations returned without corresponding coordinates.
     * @param {Function} options.onSuccess - Callback function for getting successful service response. Takes a {@link Gp.Services.AltiResponse} object as a parameter, except if "rawResponse" is set to true.
     * @param {Function} [options.onFailure] - Callback function for handling unsuccessful service responses (timeOut, missing rights, ...). Takes a {@link Gp.Error} object as parameter.
     * @param {Number} [options.timeOut=0] - Number of milliseconds above which a timeOut response will be returned with onFailure callback (see above). Default value is 0 which means timeOut will not be handled.
     * @param {String} [options.serverUrl=http (s)://wxs.ign.fr/APIKEY/alti/rest/elevation.json] - Web service URL. If used, options.apiKey parameter is ignored. Only use if you know what you're doing.
     * @param {Boolean} [options.ssl = true] - Use of HTTPS or HTTP protocol to request the services. HTTPS by default (ssl=true).
     * @param {String} [options.protocol=XHR] - Protocol used to handle dialog with web service. Possible values are 'JSONP' ({@link https://en.wikipedia.org/wiki/JSONP}) and 'XHR' ({@link https://en.wikipedia.org/wiki/XMLHttpRequest}). Only XHR protocol is supported in a NodeJS environment. Only use if you know what you're doing.
     * @param {String} [options.proxyURL] - Proxy URL to use when requesting underlying web service. Ignored when options.protocol is set to 'JSONP' value. Only use if you know what you're doing.
     * @param {String} [options.callbackSuffix] - Callback function name suffix to use in case of a JSONP protocol use (see above), to set your own suffix instead of auto-increment. Ignored when options.protocol is set to 'XHR' value. Only use if you know what you're doing.
     * @param {String} [options.httpMethod=GET] - HTTP method to use when requesting underlying web service in case of a XHR protocol use (see above). Possible values are 'GET' and 'POST'. Ignored when options.protocol is set to 'JSONP' value. Only use if you know what you are doing.
     * @param {String} [options.contentType="application/xml"] - Content-Type to use when requesting underlying web service in case of a XHR protocol use (see above) and if method HTTP is POST. Ignored when options.protocol is set to 'JSONP' value. Only use if you know what you are doing.
     * @param {Boolean} [options.rawResponse=false] - Setting this parameter to true implies you want to handle the service response by yourself : it will be returned as an unparsed String in onSuccess callback parameter. Only use if you know what you are doing.
     * @param {Function} [options.onBeforeParse] - Callback function for handling service response before parsing (as an unparsed String). Takes a String as a parameter (the raw service response). Returns a String that will be parsed as the service response. Only use if you know what you are doing.
     * @param {String} [options.api='REST'] - What API to use for interacting with underlying web service : 'REST' or 'WPS'. Only use if you know what you are doing.
     * @param {String} [options.outputFormat='xml'] - Output format for underlying web service response : 'xml' or 'json'. Only use if you know what you are doing.
     */
    getAltitude : function (options) {
        var altiService = new _Alti_Alti__WEBPACK_IMPORTED_MODULE_0__["default"](options);
        altiService.call();
    },
    /**
     * Getting positon of a geographic identifier (places names, address, cadastral parcel, other...) using the [geocoding web service of the Geoportal Platform]{@link https://geoservices.ign.fr/documentation/geoservices/geocodage.html}.
     *
     * @example
     * Gp.Services.geocode ({
     *     apiKey : "jhyvi0fgmnuxvfv0zjzorvdn",
     *     location : "73 avenue de Paris, Saint-Mandé",
     *     // traitement des resultats
     *     onSuccess  : function (result) {
     *         console.log("found (x:"+result.position.x+", y:"+result.position.y+")") ;
     *     }
     * }) ;
     *
     *
     * @method geocode
     * @param {Object} options - Options for function call.
     * @param {String} options.apiKey - Access key to Geoportal platform, obtained [here]{@link http://professionnels.ign.fr/ign/contrats}.
     * @param {String|Object} options.location - Geographic identifier to locate. May be provided as a single String or a structured Object for an address search. In this last case, the following properties are availaibles.
     *      @param {Number} [options.location.number] - Street number.
     *      @param {String} [options.location.street] - Street name.
     *      @param {String} [options.location.city] - City name.
     *      @param {Number} [options.location.postalCode] - Postal Code
     * @param {Object} [options.filterOptions] - Additional filters to apply to search. The following properties may be given.
     *      @param {Gp.BBox} [options.filterOptions.bbox] - Bounding box where to perform the search. Properties expressed in options.srs coordinates system.
     *      @param {Array.<String>} [options.filterOptions.type] - Geographical identifier types to search. Values currently availables are : "PositionOfInterest" for place names, "StreetAddress" for address search, "CadastralParcel" for Cadastral parcels search. Default is "StreetAddress".
     *
     *      @param {String} [options.filterOptions.[prop]] - Additionnal properties to filter search. Properties depends on options.filterOptions.type, and values type should be "String".
     *      <br/><br/>
     *      Common Properties availables for all search types :<br/>
     *      "municipality", "insee", "department".
     *      <br/><br/>
     *      Properties availables for address search :<br/>
     *      "quality", "ID", "ID_TR" and "territory".
     *      <br/><br/>
     *      Properties availables for place names search :<br/>
     *      "importance", "nature" and "territory".
     *      <br/><br/>
     *      Properties availables for cadastral parcels search :<br/>
     *      "sheet", "section", and "absorbedcity".
     * @param {Number} [options.maximumResponses = 25] - Maximum number of responses. Default underlying service value applies (25) if not provided.
     * @param {Boolean} [options.returnFreeForm = false] - Set this parameter to true if you wish to have an address returned in a single String (unstructured). If unset, default underlying service value (false) applies.
     * @param {String} [options.srs = EPSG:4326] - Coordinates System used to expres coordinates for parameters and responses. Default underlying service value (EPSG:4326) applies.
     * @param {Function} options.onSuccess - Callback function for getting successful service response. Takes a {@link Gp.Services.GeocodeResponse} object as a parameter except if "rawResponse" is set to true.
     * @param {Function} [options.onFailure] - Callback function for handling unsuccessful service responses (timeOut, missing rights, ...). Takes a {@link Gp.Error} object as parameter.
     * @param {Number} [options.timeOut=0] - Number of milliseconds above which a timeOut response will be returned with onFailure callback (see above). Default value is 0 which means timeOut will not be handled.
     * @param {String} [options.serverUrl=http (s)://wxs.ign.fr/APIKEY/geoportail/ols] - Web service URL. If used, options.apiKey parameter is ignored. Only use if you know what you're doing.
     * @param {Boolean} [options.ssl = true] - Use of HTTPS or HTTP protocol to request the services. HTTPS by default (ssl=true).
     * @param {String} [options.protocol=XHR] - Protocol used to handle dialog with web service. Possible values are 'JSONP' ({@link https://en.wikipedia.org/wiki/JSONP}) and 'XHR' ({@link https://en.wikipedia.org/wiki/XMLHttpRequest}). Only XHR protocol is supported in a NodeJS environment. Only use if you know what you're doing.
     * @param {String} [options.proxyURL] - Proxy URL to use when requesting underlying web service. Ignored when options.protocol is set to 'JSONP' value. Only use if you know what you're doing.
     * @param {String} [options.callbackSuffix] - Callback function name suffix to use in case of a JSONP protocol use (see above), to set your own suffix instead of auto-increment. Ignored when options.protocol is set to 'XHR' value. Only use if you know what you're doing.
     * @param {String} [options.httpMethod=GET] - HTTP method to use when requesting underlying web service in case of a XHR protocol use (see above). Possible values are 'GET' and 'POST'. Ignored when options.protocol is set to 'JSONP' value. Only use if you know what you are doing.
     * @param {String} [options.contentType="application/xml"] - Content-Type to use when requesting underlying web service in case of a XHR protocol use (see above) and if method HTTP is POST. Ignored when options.protocol is set to 'JSONP' value. Only use if you know what you are doing.
     * @param {Boolean} [options.rawResponse=false] - Setting this parameter to true implies you want to handle the service response by yourself : it will be returned as an unparsed String in onSuccess callback parameter. Only use if you know what you are doing.
     * @param {Function} [options.onBeforeParse] - Callback function for handling service response before parsing (as an unparsed String). Takes a String as a parameter (the raw service response). Returns a String that will be parsed as the service response. Only use if you know what you are doing.
     */
    geocode : function (options) {
        var geocodeService = new _Geocode_Geocode__WEBPACK_IMPORTED_MODULE_2__["default"](options);
        geocodeService.call();
    },
    /**
     * Retrieving geographical identifiers (place names, address, cadastral parcels, ...) near a given position, using the [reverse geocoding web service of the Geoportal Platform]{@link https://geoservices.ign.fr/documentation/geoservices/geocodage-inverse.html}.
     *
     * @method reverseGeocode
     * @param {Object} options - Options for function call.
     * @param {String} options.apiKey - Access key to Geoportal platform, obtained [here]{@link http://professionnels.ign.fr/ign/contrats}.
     * @param {Gp.Point} options.position - Reference position where to search geographical identifiers. Its coordinates are expressed in the coordinates system given with options.srs parameter. (default is CRS:84, that means position.x is the longitude and position.y the latitude)
     * @param {Object} [options.filterOptions] - Additional filters to apply to search. The following properties may be given.
     *      @param {Array.<String>} [options.filterOptions.type] - Geographical identifier types to search. Values currently availables are : "PositionOfInterest" for place names, "StreetAddress" for address search, "CadastralParcel" for Cadastral parcels search. Default is "StreetAddress".
     *      @param {Gp.BBox} [options.filterOptions.bbox] - Bounding box where to perform the search. Expressed in options.srs coordinates system.
     *      @param {Gp.Circle} [options.filterOptions.circle] - Circle where to perform the search. Expressed in options.srs coordinates system.
     * @param {Array.<Gp.Point>} [options.filterOptions.polygon] - Polygon where to perform the search. Expressed in options.srs coordinates system.
     * @param {Number} [options.maximumResponses] - Maximum number of responses. Default underlying service value applies (25) if not provided.
     * @param {Boolean} [options.returnFreeForm = false] - Set this parameter to true if you wish to have an address returned in a single String (unstructured). If unset, default underlying service value (false) applies.
     * @param {String} [options.srs = CRS:84] - Coordinates System used to express coordinates for parameters and responses. Only WGS 84 geographical positioning is supported. Therefore, two values are allowed : "CRS:84" (position.x is the longitude and position.y the latitude) and "EPSG:4326" (position.x is the latitude and position.y the longitude) . Default is CRS:84.
     * @param {Function} options.onSuccess - Callback function for getting successful service response. Takes a {@link Gp.Services.GeocodeResponse} object as a parameter except if "rawResponse" is set to true.
     * @param {Function} [options.onFailure] - Callback function for handling unsuccessful service responses (timeOut, missing rights, ...). Takes a {@link Gp.Error} object as parameter.
     * @param {Number} [options.timeOut=0] - Number of milliseconds above which a timeOut response will be returned with onFailure callback (see above). Default value is 0 which means timeOut will not be handled.
     * @param {String} [options.serverUrl=http (s)://wxs.ign.fr/APIKEY/geoportail/ols] - Web service URL. If used, options.apiKey parameter is ignored. Only use if you know what you're doing.
     * @param {Boolean} [options.ssl = true] - Use of HTTPS or HTTP protocol to request the services. HTTPS by default (ssl=true).
     * @param {String} [options.protocol=XHR] - Protocol used to handle dialog with web service. Possible values are 'JSONP' ({@link https://en.wikipedia.org/wiki/JSONP}) and 'XHR' ({@link https://en.wikipedia.org/wiki/XMLHttpRequest}). Only XHR protocol is supported in a NodeJS environment. Only use if you know what you're doing.
     * @param {String} [options.proxyURL] - Proxy URL to use when requesting underlying web service. Ignored when options.protocol is set to 'JSONP' value. Only use if you know what you're doing.
     * @param {String} [options.callbackSuffix] - Callback function name suffix to use in case of a JSONP protocol use (see above), to set your own suffix instead of auto-increment. Ignored when options.protocol is set to 'XHR' value. Only use if you know what you're doing.
     * @param {String} [options.httpMethod=GET] - HTTP method to use when requesting underlying web service in case of a XHR protocol use (see above). Possible values are 'GET' and 'POST'. Ignored when options.protocol is set to 'JSONP' value. Only use if you know what you are doing.
     * @param {String} [options.contentType="application/xml"] - Content-Type to use when requesting underlying web service in case of a XHR protocol use (see above) and if method HTTP is POST. Ignored when options.protocol is set to 'JSONP' value. Only use if you know what you are doing.
     * @param {Boolean} [options.rawResponse=false] - Setting this parameter to true implies you want to handle the service response by yourself : it will be returned as an unparsed String in onSuccess callback parameter. Only use if you know what you are doing.
     * @param {Function} [options.onBeforeParse] - Callback function for handling service response before parsing (as an unparsed String). Takes a String as a parameter (the raw service response). Returns a String that will be parsed as the service response. Only use if you know what you are doing.
     */
    reverseGeocode : function (options) {
        var reverseGeocodeService = new _Geocode_ReverseGeocode__WEBPACK_IMPORTED_MODULE_3__["default"](options);
        reverseGeocodeService.call();
    },
    /**
     * Getting suggestions of probable places names or address based on uncomplete texts, using the [autocompletion service of the Geoportal Platform]{@link https://geoservices.ign.fr/documentation/geoservices/autocompletion.html}
     *
     * @method autoComplete
     * @param {Object} options - Options for function call.
     * @param {String} options.apiKey - Access key to Geoportal platform, obtained [here]{@link http://professionnels.ign.fr/ign/contrats}.
     * @param {String} options.text - Text input to complete.
     * @param {Array.<String>} [options.filterOptions.type = "StreetAddress"] - Suggestion types to provide : address ("StreetAddress") and/or place name ("PositionOfInterest").
     * @param {Array.<String>} [options.filterOptions.territory] - Places where to limit the search of suggestions : "METROPOLE" (Corsica and metropolitan France), "DOMTOM" (French overseas departments and territories), or an INSEE code of a department. No limitation by default. For instance : ['METROPOLE', '31']
     * @param {Number} [options.maximumResponses = 10] - Maximum number of responses.
     * @param {Function} options.onSuccess - Callback function for getting successful service response. Takes a {@link Gp.Services.AutoCompleteResponse} object as a parameter except if "rawResponse" is set to true.
     * @param {Function} [options.onFailure] - Callback function for handling unsuccessful service responses (timeOut, missing rights, ...). Takes a {@link Gp.Error} object as parameter.
     * @param {Number} [options.timeOut=0] - Number of milliseconds above which a timeOut response will be returned with onFailure callback (see above). Default value is 0 which means timeOut will not be handled.
     * @param {String} [options.serverUrl=http (s)://wxs.ign.fr/APIKEY/ols/apis/completion] - Web service URL. If used, options.apiKey parameter is ignored. Only use if you know what you're doing.
     * @param {Boolean} [options.ssl = true] - Use of HTTPS or HTTP protocol to request the services. HTTPS by default (ssl=true).
     * @param {String} [options.protocol=XHR] - Protocol used to handle dialog with web service. Possible values are 'JSONP' ({@link https://en.wikipedia.org/wiki/JSONP}) and 'XHR' ({@link https://en.wikipedia.org/wiki/XMLHttpRequest}). Only XHR protocol is supported in a NodeJS environment. Only use if you know what you're doing.
     * @param {String} [options.proxyURL] - Proxy URL to use when requesting underlying web service. Ignored when options.protocol is set to 'JSONP' value. Only use if you know what you're doing.
     * @param {String} [options.callbackSuffix] - Callback function name suffix to use in case of a JSONP protocol use (see above), to set your own suffix instead of auto-increment. Ignored when options.protocol is set to 'XHR' value. Only use if you know what you're doing.
     * @param {String} [options.httpMethod=GET] - HTTP method to use when requesting underlying web service in case of a XHR protocol use (see above). Possible values are 'GET' and 'POST'. Ignored when options.protocol is set to 'JSONP' value. Only use if you know what you are doing.
     * @param {String} [options.contentType="application/xml"] - Content-Type to use when requesting underlying web service in case of a XHR protocol use (see above) and if method HTTP is POST. Ignored when options.protocol is set to 'JSONP' value. Only use if you know what you are doing.
     * @param {Boolean} [options.rawResponse=false] - Setting this parameter to true implies you want to handle the service response by yourself : it will be returned as an unparsed String in onSuccess callback parameter. Only use if you know what you are doing.
     * @param {Function} [options.onBeforeParse] - Callback function for handling service response before parsing (as an unparsed String). Takes a String as a parameter (the raw service response). Returns a String that will be parsed as the service response. Only use if you know what you are doing.
     */
    autoComplete : function (options) {
        var autoCompleteService = new _AutoComplete_AutoComplete__WEBPACK_IMPORTED_MODULE_4__["default"](options);
        autoCompleteService.call();
    },
    /**
     * Getting a route from one point to another using the [route service of the Geoportal Platform]{@link https://geoservices.ign.fr/documentation/geoservices/itineraires.html}.
     *
     * @method route
     * @param {Object} options - Options for function call.
     * @param {String} options.apiKey - Access key to Geoportal platform, obtained [here]{@link http://professionnels.ign.fr/ign/contrats}.
     * @param {String} [options.routePreference = "fastest"] - Indicates the way to compute the route : "fastest" (time optimisation) or "shortest" (distance optimisation).
     * @param {Gp.Point} options.startPoint - Start point of the route. Expressed in CRS:84 coordinates system (startPoint.x corresponds to longitude, startPoint.y corresponds to latitude).
     * @param {Gp.Point} options.endPoint - End point of the route. Expressed in CRS:84 coordinates system (endPoint.x corresponds to longitude, endPoint.y corresponds to latitude).
     * @param {Array.<Gp.Point>} [options.viaPoints] - Ordered via Points of the route. Expressed in CRS:84 coordinates system (viaPoints[i].x corresponds to longitude, viaPoints[i].y corresponds to latitude).
     * @param {String} [options.graph = "Voiture"] - User profile to use to compute the route : "Voiture" (using a vehicule) or "Pieton" (pedestrian). Has an influence on the kind of roads the route may use and the average speed.
     * @param {Array.<String>} [options.exclusions] - Indicates if route has to avoid some features ("toll", "bridge" or "tunnel").
     * @param {Boolean} [options.geometryInInstructions = false] - Indicates if route geometry has to be also returned with route instructions.
     * @param {Boolean} [options.provideBoundingBox = true] - Indicates if route instructions has to be localised with a BBOX in the response.
     * @param {String} [options.distanceUnit = "km"] - The unit used to provide distances in the response ("m" or "km").
     * @param {Function} options.onSuccess - Callback function for getting successful service response. Takes a {@link Gp.Services.RouteResponse} object as a parameter except if "rawResponse" is set to true.
     * @param {Function} [options.onFailure] - Callback function for handling unsuccessful service responses (timeOut, missing rights, ...). Takes a {@link Gp.Error} object as parameter.
     * @param {Number} [options.timeOut=0] - Number of milliseconds above which a timeOut response will be returned with onFailure callback (see above). Default value is 0 which means timeOut will not be handled.
     * @param {String} [options.outputFormat='json'] - Output format ("json" or "xml") to use for underlying webService. Only use if you know what you are doing.
     * @param {String} [options.serverUrl=http (s)://wxs.ign.fr/APIKEY/itineraire/rest/route.json] - Web service URL. If used, options.apiKey parameter is ignored. Only use if you know what you're doing.
     * @param {Boolean} [options.ssl = true] - Use of HTTPS or HTTP protocol to request the services. HTTPS by default (ssl=true).
     * @param {String} [options.protocol=XHR] - Protocol used to handle dialog with web service. Possible values are 'JSONP' ({@link https://en.wikipedia.org/wiki/JSONP}) and 'XHR' ({@link https://en.wikipedia.org/wiki/XMLHttpRequest}). Only XHR protocol is supported in a NodeJS environment. Only use if you know what you're doing.
     * @param {String} [options.proxyURL] - Proxy URL to use when requesting underlying web service. Ignored when options.protocol is set to 'JSONP' value. Only use if you know what you're doing.
     * @param {String} [options.callbackSuffix] - Callback function name suffix to use in case of a JSONP protocol use (see above), to set your own suffix instead of auto-increment. Ignored when options.protocol is set to 'XHR' value. Only use if you know what you're doing.
     * @param {String} [options.httpMethod=GET] - HTTP method to use when requesting underlying web service in case of a XHR protocol use (see above). Possible values are 'GET' and 'POST'. Ignored when options.protocol is set to 'JSONP' value. Only use if you know what you are doing.
     * @param {String} [options.contentType="application/xml"] - Content-Type to use when requesting underlying web service in case of a XHR protocol use (see above) and if method HTTP is POST. Ignored when options.protocol is set to 'JSONP' value. Only use if you know what you are doing.
     * @param {Boolean} [options.rawResponse=false] - Setting this parameter to true implies you want to handle the service response by yourself : it will be returned as an unparsed String in onSuccess callback parameter. Only use if you know what you are doing.
     * @param {Function} [options.onBeforeParse] - Callback function for handling service response before parsing (as an unparsed String). Takes a String as a parameter (the raw service response). Returns a String that will be parsed as the service response. Only use if you know what you are doing.
     */
    route : function (options) {
        var routeService = new _Route_Route__WEBPACK_IMPORTED_MODULE_5__["default"](options);
        routeService.call();
    },
    /**
     * Computing a set of places (curve) reachable from a given point (or from where to start to reach a given point) within a time or distance constraint using the [isochrone service of the Geoportal Platform]{@link https://geoservices.ign.fr/documentation/geoservices/isochrones.html}.
     *
     * @method isoCurve
     * @param {Object} options - Options for function call.
     * @param {String} options.apiKey - Access key to Geoportal platform, obtained [here]{@link http://professionnels.ign.fr/ign/contrats}.
     * @param {Gp.Point} options.position - Start or Arrival (options.reverse===true) Point for the computing. Expressed in CRS:84 coordinates system (position.x corresponds to longitude, position.y corresponds to latitude).
     * @param {String} [options.graph = "Voiture"] - User profile to use to compute the isoCurve : "Voiture" (using a vehicule) or "Pieton" (pedestrian). Has an influence on the kind of roads to use and the average speed.
     * @param {Array.<String>} [options.exclusions] - Indicates if route has to avoid some features ("toll", "bridge" or "tunnel").
     * @param {String} [options.method = "time"] - Computing method to use : "time" (using a duration as a constraint) or "distance" (using a distance as a constraint).
     * @param {Float} options.time - Maximum duration (expressed in seconds) to use when options.method is set to "time".
     * @param {Float} options.distance - Maximum distance (expressed in meters) to use when options.method is set to "distance".
     * @param {Boolean} [options.reverse = false] - Set this parameter to true if you want options.position to be the destination (instead of departure) for the computing.
     * @param {Boolean} [options.smoothing = false] - Set this parameter to true if you want the resulting geometry to be smoothed.
     * @param {Boolean} [options.holes = false] - Set this parameter to true if you want the resulting geometry (polygon) to have holes if pertinent.
     * @param {Function} options.onSuccess - Callback function for getting successful service response. Takes a {@link Gp.Services.IsoCurveResponse} object as a parameter except if "rawResponse" is set to true.
     * @param {Function} [options.onFailure] - Callback function for handling unsuccessful service responses (timeOut, missing rights, ...). Takes a {@link Gp.Error} object as parameter.
     * @param {Number} [options.timeOut=0] - Number of milliseconds above which a timeOut response will be returned with onFailure callback (see above). Default value is 0 which means timeOut will not be handled.
     * @param {String} [options.outputFormat='json'] - Output format ("json" or "xml") to use for underlying webService. Only use if you know what you are doing.
     * @param {String} [options.serverUrl=http (s)://wxs.ign.fr/APIKEY/isochrone/isochrone.json] - Web service URL. If used, options.apiKey parameter is ignored. Only use if you know what you're doing.
     * @param {Boolean} [options.ssl = true] - Use of HTTPS or HTTP protocol to request the services. HTTPS by default (ssl=true).
     * @param {String} [options.protocol=XHR] - Protocol used to handle dialog with web service. Possible values are 'JSONP' ({@link https://en.wikipedia.org/wiki/JSONP}) and 'XHR' ({@link https://en.wikipedia.org/wiki/XMLHttpRequest}). Only XHR protocol is supported in a NodeJS environment. Only use if you know what you're doing.
     * @param {String} [options.proxyURL] - Proxy URL to use when requesting underlying web service. Ignored when options.protocol is set to 'JSONP' value. Only use if you know what you're doing.
     * @param {String} [options.callbackSuffix] - Callback function name suffix to use in case of a JSONP protocol use (see above), to set your own suffix instead of auto-increment. Ignored when options.protocol is set to 'XHR' value. Only use if you know what you're doing.
     * @param {String} [options.httpMethod=GET] - HTTP method to use when requesting underlying web service in case of a XHR protocol use (see above). Possible values are 'GET' and 'POST'. Ignored when options.protocol is set to 'JSONP' value. Only use if you know what you are doing.
     * @param {String} [options.contentType="application/xml"] - Content-Type to use when requesting underlying web service in case of a XHR protocol use (see above) and if method HTTP is POST. Ignored when options.protocol is set to 'JSONP' value. Only use if you know what you are doing.
     * @param {Boolean} [options.rawResponse=false] - Setting this parameter to true implies you want to handle the service response by yourself : it will be returned as an unparsed String in onSuccess callback parameter. Only use if you know what you are doing.
     * @param {Function} [options.onBeforeParse] - Callback function for handling service response before parsing (as an unparsed String). Takes a String as a parameter (the raw service response). Returns a String that will be parsed as the service response. Only use if you know what you are doing.
     */
    isoCurve : function (options) {
        var processIsoCurveService = new _ProcessIsoCurve_ProcessIsoCurve__WEBPACK_IMPORTED_MODULE_6__["default"](options);
        processIsoCurveService.call();
    }
};

/**
 * Point object.
 *
 * @namespace
 * @alias Gp.Point
 *
 * @property {Float} x - Point abscissa
 * @property {Float} y - Point ordinate
 */
var point = {};

/**
 * Circle object.
 *
 * @namespace
 * @alias Gp.Circle
 *
 * @property {Float} x - Circle center abscissa.
 * @property {Float} y - Circle center ordinate.
 * @property {Float} radius - Circle radius.
 */
var circle = {};

/**
 * Bounding box object, expressed with four coordinates.
 *
 * @namespace
 * @alias Gp.BBox
 *
 * @property {Float} left - minimum abscissa
 * @property {Float} right - maximum abscissa
 * @property {Float} bottom - minimum ordinate
 * @property {Float} top - maximum ordinate
 */
var bbox = {};

/* harmony default export */ __webpack_exports__["default"] = (Services);


/***/ }),
/* 42 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44);
/* harmony import */ var _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45);
/* harmony import */ var _CommonService__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46);
/* harmony import */ var _DefaultUrlService__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(56);
/* harmony import */ var _Request_AltiRequestFactory__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(58);
/* harmony import */ var _Response_AltiResponseFactory__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(65);









/**
 * @classdesc
 *
 * Appel du service d'altimétrie du Géoportail
 *
 * @todo gestion du parma. output et callback
 * @todo outputFormat (REST) et format (WPS)
 * @todo La reponse JSON peut encapsuler un XML !
 *
 * @constructor
 * @extends {Gp.Services.CommonService}
 * @alias Gp.Services.Alti
 * @param {Object} options - options spécifiques au service (+ les options heritées)
 *
 * @param {Array.<Object>} options.positions - Tableau ({lon:float,lat:float}) contenant les coordonnées des points (CRS:84)
 *      dont on veut connaître les altitudes (ou à partir desquelles on va calculer le profil).
 *      Chaque élément du tableau est un objet JavaScript avec deux attributs : lon et lat, qui sont des flottants.
 *      Minimum 2 éléments si on souhaite calculer un profil altimétrique (ElevationLine).
 *      Maximum 50 éléments.
 *
 * @param {String} options.outputFormat - Le format de la réponse du service alti : 'xml' ou 'json'.
 *      Ce paramètre déterminera l'extension '.xml' ou '.json' du service dans le cas de l'API REST,
 *      ou la valeur du paramètre 'format' dans le cas de la norme WPS.
 *      Nécessaire si serverUrl est renseigné, et qu'on souhaite passer par l'API REST,
 *      pour connaître le format dans lequel sera fournie la réponse (pour son traitement).
 *      Non nécessaire pour la norme WPS. Par défaut, ce paramètre vaut 'json'.
 *
 * @param {Number} [options.sampling] - Nombre de points à utiliser pour déterminer le tracé d'un profil altimétrique, compris entre 2 et 5000.
 *      A spécifier lorsqu'on souhaite accéder à cette fonctionnalité.
 *      Dans ce cas, les points fournis en entrée (au minimum de deux) servent à déterminer l'axe planimétrique
 *      le long duquel le profil doit être calculé.
 *      Si le paramètre sampling n'est pas spécifié ou moins de deux points sont fournis,
 *      c'est le service Elevation qui sera interrogé (altitudes simples calculées pour les points fournis).
 *      Une valeur de sampling strictement inférieure à 2 déclenchera un échantillonnage avec la valeur par défaut du service (3 points).
 *
 * @param {String} [options.api] - Manière d'accéder au service : 'REST' (via l'API REST) ou 'WPS' (via la norme WPS).
 *      Par défaut, on utilise l'API REST.
 *
 * @param {Boolean} [options.zonly] - Permet de ne récupérer que les altitudes en sortie s'il vaut 'true'.
 *      Vaut 'false' par défaut.
 *
 * @example
 *   var options = {
 *      apiKey : null,
 *      serverUrl : 'http://localhost/service/',
 *      protocol : 'JSONP', // JSONP|XHR
 *      proxyURL : null,
 *      httpMethod : 'GET', // GET|POST
 *      timeOut : 10000, // ms
 *      rawResponse : false, // true|false
 *      scope : null, // this
 *      onSuccess : function (response) {},
 *      onFailure : function (error) {},
 *      // spécifique au service
 *      positions : [{lon:, lat:}, {lon:, lat:}],
 *      outputFormat : 'json' // json|xml
 *      sampling : 3,
 *      api : 'REST', // REST|WPS
 *      zonly : false // false|true
 *   };
 *
 * @private
 */
function Alti (options) {
    if (!(this instanceof Alti)) {
        throw new TypeError(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("CLASS_CONSTRUCTOR", "Alti"));
    }

    /**
     * Nom de la classe (heritage)
     * FIXME instance ou classe ?
     */
    this.CLASSNAME = "Alti";

    // appel du constructeur par heritage
    _CommonService__WEBPACK_IMPORTED_MODULE_3__["default"].apply(this, arguments);

    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("Gp.Services.Alti");
    this.logger.trace("[Constructeur Alti (options)]");

    // #####################
    // analyse des options
    // #####################

    if (!options.positions) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_MISSING", "positions"));
    }

    if (options.positions.length === 0) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_EMPTY", "positions"));
    }

    // ajout des options spécifiques au service
    this.options.positions = options.positions;

    // format de réponse du service : "json" ou "xml" (valeur par défaut), en minuscule !
    this.options.outputFormat = (typeof options.outputFormat === "string") ? options.outputFormat.toLowerCase() : "xml";

    // sampling
    this.options.sampling = options.sampling || null;

    // type d'api utilisé pour requeter le service, en majuscule !
    this.options.api = (typeof options.api === "string") ? options.api.toUpperCase() : "REST";

    // l'api ne peut être interrogée qu'en GET.
    if (this.options.api === "REST") {
        this.options.httpMethod = "GET";
    }

    // param. zonly
    this.options.zonly = options.zonly || false;

    // gestion de l'url du service par defaut
    // si l'url n'est pas renseignée, il faut utiliser les urls par defaut
    // en fonction du type d'api, REST ou WPS, du format de reponse demandé (outputFormat)
    // ainsi que sur le type de service (profil ou elevation)
    if (!this.options.serverUrl) {
        var lstUrlByDefault = _DefaultUrlService__WEBPACK_IMPORTED_MODULE_4__["default"].Alti.url(this.options.apiKey);
        var urlFound = null;
        switch (this.options.api) {
            case "WPS":
                urlFound = lstUrlByDefault.wps;
                break;
            case "REST":
                var key = (options.sampling ? "profil" : "elevation") + "-" + this.options.outputFormat;
                urlFound = lstUrlByDefault[key];
                break;
            default:
                throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_UNKNOWN", "api"));
        }

        if (!urlFound) {
            throw new Error("Url by default not found !");
        }
        this.options.serverUrl = urlFound;
        this.logger.trace("Server URL by default : " + this.options.serverUrl);
    }

    // gestion du type de service
    // si l'extension de l'url est .json ou .xml, on surcharge le format de sortie (outputFormat)
    var idx = this.options.serverUrl.lastIndexOf(".");
    if (idx !== -1) {
        var extension = this.options.serverUrl.substring(idx + 1);
        if (extension && extension.length < 5) { // FIXME extension de moins de 4 car. ...
            this.logger.trace("Server Extension URL : " + extension);
            switch (extension.toLowerCase()) {
                case "json":
                case "xml":
                    this.options.outputFormat = extension.toLowerCase();
                    break;
                default:
                    throw new Error("type of service : unknown or unsupported (json or xml) !");
            }
        }
    }
}

/**
 * @lends module:Alti#
 */
Alti.prototype = Object.create(_CommonService__WEBPACK_IMPORTED_MODULE_3__["default"].prototype, {
    // todo
    // getter/setter
});

/**
 * Constructeur (alias)
 */
Alti.prototype.constructor = Alti;

/**
 * Création de la requête (overwrite)
 *
 * @param {Function} error   - callback des erreurs
 * @param {Function} success - callback
 */
Alti.prototype.buildRequest = function (error, success) {
    // utilisation en mode callback
    var options = {
        httpMethod : this.options.httpMethod,
        // callback
        onSuccess : function (result) {
            // sauvegarde de la requete !
            this.request = result;
            success.call(this, this.request);
        },
        onError : error,
        scope : this,
        // spécifique au service :
        positions : this.options.positions,
        outputFormat : this.options.outputFormat,
        sampling : this.options.sampling,
        api : this.options.api,
        zonly : this.options.zonly
    };

    _Request_AltiRequestFactory__WEBPACK_IMPORTED_MODULE_5__["default"].build(options);
};

/**
 * Analyse de la reponse (overwrite)
 *
 * @param {Function} error   - callback des erreurs
 * @param {Function} success - callback
 */
Alti.prototype.analyzeResponse = function (error, success) {
    // INFO
    // Factory pour masquer la complexité du retour du service qui renvoie soit
    //  - une 'string' qui contient du XML ou JSON natif en mode XHR
    //  - un objet JSON qui est natif ou encapsulé

    if (this.response) {
        var options = {
            response : this.response,
            outputFormat : this.options.outputFormat, // utile pour parser la string en mode XHR : JSON ou XML !
            rawResponse : this.options.rawResponse,
            onError : error,
            onSuccess : success,
            scope : this
        };

        _Response_AltiResponseFactory__WEBPACK_IMPORTED_MODULE_6__["default"].build(options);
    } else {
        error.call(this, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EMPTY")));
    }
};

/* harmony default export */ __webpack_exports__["default"] = (Alti);


/***/ }),
/* 43 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var loglevel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(35);
/* harmony import */ var loglevel__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(loglevel__WEBPACK_IMPORTED_MODULE_0__);


var LoggerByDefault = {
    /**
     * logger statique
     *
     * @static
     * @param {String} name - nom du logger
     * @returns {Object} retourne un logger
     */
    getLogger : function (name) {
        // Substitute global constants configured at compile time
        // cf. webpack.config.js
        // FIXME howtodo !? DefineWebpackPlugin ? EnvironmentWebpackPlugin ?
        ("false".match(/true/))
            ? loglevel__WEBPACK_IMPORTED_MODULE_0__["disableAll"]() : loglevel__WEBPACK_IMPORTED_MODULE_0__["enableAll"]();
        var logname = name || "default";
        return loglevel__WEBPACK_IMPORTED_MODULE_0__["getLogger"](logname);
    }
};

/* harmony default export */ __webpack_exports__["default"] = (LoggerByDefault);


/***/ }),
/* 44 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/**
 * Classe de gestion des erreurs qui permer d'associer un message d'erreur à l'exception lancée.
 *
 * @example
 * MessagesResources.getMessage("ERROR_PARAM_MISSING", "x", "y", "z")));
 * // --> output : Parameter(s) 'x - y - z' missing
 *
 * @module MessagesResources
 * @alias Gp.Utils.MessagesResources
 * @private
 */
var MessagesResources = {

    // Paramètres
    PARAM_MISSING : "Parameter(s) '%var%' missing",
    PARAM_EMPTY : "Parameter(s) '%var%' empty",
    PARAM_TYPE : "Wrong type(s) for parameter(s) '%var%'",
    PARAM_FORMAT : "Parameter(s) '%var%' not correctly formatted",
    PARAM_NOT_SUPPORT : "Value(s) for parameter(s) '%var%' not supported",
    PARAM_NOT_SUPPORT_NODEJS : "Value(s) for parameter(s) '%var%' not supported to NodeJS",
    PARAM_UNKNOWN : "Value(s) for parameter(s) '%var%' unknown",

    // Services
    // Requête
    SERVICE_REQUEST_BUILD : "An error occurred during the request building of the service",
    SERVICE_REQUEST_EMPTY : "The request sent to the service is empty",

    // Réponse
    SERVICE_RESPONSE_EXCEPTION : "The service returned an exception : '%var%'",
    SERVICE_RESPONSE_EXCEPTION_2 : "The service returned an exception",
    SERVICE_RESPONSE_ANALYSE : "An error occurred while parsing the response '%var%' of the service",
    SERVICE_RESPONSE_ANALYSE_2 : "An unknown error occurred while parsing the response",
    SERVICE_RESPONSE_EMPTY : "The response of the service is empty",
    SERVICE_RESPONSE_EMPTY_2 : "The response from the service could not be analyzed or is empty",
    SERVICE_RESPONSE_FORMAT : "The format of the service response is not supported (handled format(s) : '%var%')",
    SERVICE_RESPONSE_FORMAT_2 : "The format of the service response is not supported",
    SERVICE_RESPONSE_FORMAT_3 : "No suggestion matching the search",

    // Classes
    CLASS_CONSTRUCTOR : "'%var%' constructor cannot be called as a function.",

    /**
     * Fonction qui va retourner le message d'erreur associé à la clé donnée
     *
     * @method getMessage
     * @param {String} clef - Clef de l'erreur (ex : ERROR_PARAM)
     * @param {String[]} parametres - Paramètres/variables concernés par le message d'erreur associé à la clef donnée
     * @return {String} message - String contenant le message de l'exception
     */
    getMessage : function (clef, parametres) {
        // param de la fonction uniquement pour la documentation...

        if (Object.keys(arguments).length === 0) {
            return "Message indefined !";
        }

        var params = Array.prototype.slice.call(arguments);
        var key = params.shift();
        var args = params;

        var message = this[key];

        try {
            if (Array.isArray(args) && args.length > 0) {
                message = message.replace("%var%", args.join(" - "));
            } else {
                message = message.replace("%var%", "%var% (not specified)");
            }
        } catch (e) {
            // error de string.replace()

        }

        return message;
    }
};

/* harmony default export */ __webpack_exports__["default"] = (MessagesResources);


/***/ }),
/* 45 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/**
 * Errors raised by API for one among three reasons : wrong API usage, underlying service error or unknown reason.
 *
 * @property {String} message - Error message
 * @property {Number} status - Error status : when {@link Gp.Error.TYPE_SRVERR}, gives the [HTTP status of the underlying web service response]{@link https://en.wikipedia.org/wiki/List_of_HTTP_status_codes} ; -1 otherwise.
 * @property {String} type - Error type ({@link Gp.Error.TYPE_SRVERR}, {@link Gp.Error.TYPE_USEERR} or {@link Gp.Error.TYPE_UNKERR}).
 *
 * @namespace
 * @alias Gp.Error
 * @param {Object|String} error - Options for creating error object. Can be a String (message) or an Object.
 * @param {String} error.message - Error message to return to user.
 * @param {enum} [error.type=TYPE_UNKERR] - Error type
 * @param {status} [error.status=-1] - Error status : when {@link Gp.Error.TYPE_SRVERR}, gives the [HTTP status of the underlying web service response]{@link https://en.wikipedia.org/wiki/List_of_HTTP_status_codes}.
 *
 */
function ErrorService (error) {
    if (!(this instanceof ErrorService)) {
        throw new TypeError("ErrorService constructor cannot be called as a function.");
    }

    var e = error;
    if (typeof error === "string" || error instanceof String) {
        this.message = error;
        this.status = -1;
        this.type = ErrorService.TYPE_UNKERR;
    } else {
        this.message = e.message || "undefined!?";
        this.type = e.type;
        this.status = e.status || -1;
    }

    this.name = "ErrorService";
    this.stack = (new Error()).stack;
}

/**
 * Error raised when underlying geoportal service answers on error.
 *
 * @type {String}
 * @constant
 * @static
 */
ErrorService.TYPE_SRVERR = "SERVICE_ERROR";
/**
 * Error raised when funcion use is inappropriate
 *
 * @type {String}
 * @constant
 * @static
 */
ErrorService.TYPE_USEERR = "USAGE_ERROR";
/**
 * Error raised when API can't perform the job for a reason other than the two other ones.
 *
 * @type {String}
 * @constant
 * @static
 */
ErrorService.TYPE_UNKERR = "UNKNOWN_ERROR";

/**
 * @lends module:ErrorService
 */
ErrorService.prototype = Object.create(Error.prototype, {
    constructor : {
        value : ErrorService,
        writable : true,
        configurable : true
    }
});

/* harmony default export */ __webpack_exports__["default"] = (ErrorService);


/***/ }),
/* 46 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _Utils_Helper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(47);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(44);
/* harmony import */ var _Protocols_Protocol__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(48);
/* harmony import */ var _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(45);
/* harmony import */ var _DefaultUrlService__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(56);
/* harmony import */ var _package_json__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(57);
var _package_json__WEBPACK_IMPORTED_MODULE_6___namespace = /*#__PURE__*/__webpack_require__.t(57, 1);






// package.json (extract version)


/**
 * @classdesc
 * Composant Service
 *
 * @constructor
 * @alias Gp.Services.CommonService
 * @param {Object} options - options communes à tous les services
 *
 * @param {String} options.apiKey - Clef d'accès à la plateforme Géoportail,
 *      nécessaire pour franchir la couche de contrôle des accès pour avoir une réponse du service invoqué.
 *      Plusieurs clefs peuvent être passées dans le cas de l'invocation du service d'autoconfiguration.
 *      Si ce paramètre n'est pas renseigné, alors le paramètre serverUrl doit être renseigné (comprenant alors, si nécessaire la clef API).
 *
 * @param {String} options.serverUrl - URL d'accès au service.
 *      Permet de forcer l'utilisation d'un service équivalent déployé derrière une éventuelle autre URL d'accès.
 *      Si ce paramètre est renseigné alors, le paramètre apiKey est ignoré.
 *
 * @param {String} [options.protocol] - Le protocole à utiliser pour récupérer les informations du service :
 *      peut valoir 'JSONP' ou 'XHR'.
 *      Par défaut, c'est le protocole XHR qui sera utilisé.
 *      Attention, le protocole JSONP n'est pas valide dans un environnement NodeJS (Utilisation du mode XHR).
 *
 * @param {Boolean} [options.ssl] - Indique si l'on souhaite intérroger les services en https.
 *      Ce paramètre ne fonctionne que pour une utilisation hors navigateur (ex. NodeJS).
 *      Sur un navigateur, le protocole est automatiquement extrait de l'url du site...
 *      Par défaut, on utilise le protocole http (ssl=false).
 *
 * @param {String} [options.proxyURL] - Le proxy à utiliser pour pallier au problème de cross-domain dans le cas d'une requête XHR.
 *      Utile si le paramètre 'protocol' vaut 'XHR', il ne sera pas pris en compte si protocol vaut JSONP.
 *
 * @param {String} [options.callbackSuffix] - Suffixe de la fonction de callback à utiliser, dans le cas du protocole JSONP.
 *      Par défaut, la fonction de callback portera un nom du type "callback"+ID, où ID est soit un identifiant unique généré à chaque requête,
 *      soit le paramètre callbackSuffix s'il est spécifié. Par exemple, si callbackSuffix="_2", la fonction sera "callback_2 ()".
 *      Utile pour utiliser une réponse déjà encapsulée dans une fonction de callback, dont le nom est connu (ex : chargement de l'autoconfiguration en local)
 *      Utile seulement si le paramètre 'protocol' vaut 'JSONP', il ne sera pas pris en compte si protocol vaut 'XHR'.
 *
 * @param {String} [options.httpMethod] - La méthode HTTP
 *      à utiliser dans le cas d'une requête XHR : peut valoir 'GET' ou 'POST'.
 *      Non pris en compte si 'protocol' vaut JSONP qui fonctionne obligatoirement en GET.
 *      Par défaut, c'est la méthode GET qui est utilisée.
 *
 * @param {String} [options.contentType] - Content-Type de la requete
 *      à utiliser dans le cas d'une requête XHR en mode POST.
 *      Non pris en compte si 'protocol' vaut JSONP et/ou la méthode HTTP vaut GET.
 *      Par défaut, c'est la méthode GET qui est utilisée donc on n'utilise pas de Content-Type.
 *
 * @param {Number} [options.timeOut] - Délai d'attente maximal (en ms) de la réponse du service (à partir de l'envoi de la requête).
 *      Par défaut, aucun timeOut n'est pris en compte (timeoutDelay= 0).
 *
 * @param {Boolean} [options.rawResponse] - Indique si l'on souhaite que la réponse du service ne soit pas parsée par l'API avant d'être restituée.
 *      (Cf. paramètre « onSuccess » pour plus de détails).
 *
 * @param {Function} [options.onSuccess] - Fonction appelée lorsque le service répond correctement à la requête
 *      (code HTTP 200, sans message d'erreur).
 *      Cette fonction prend en paramètre la réponse du service,
 *      soit sous la forme d'un Object Javascript formaté par le parseur dédié à la syntaxe du service (comportement par défaut) ;
 *      soit brute au format String non prétraité si le paramètre « rawResponse » a été précisé avec la valeur « true ».
 *
 * @param {Function} [options.onFailure] - Fonction appelée lorsque le service ne répond pas correctement
 *      (code HTTP de retour différent de 200 ou pas de réponse).
 *
 * @param {Function} [options.onBeforeParse] - Fonction appelée avant le parsing de la réponse
 *      Permet de modifier la réponse avant parsing et la fonction doit retourner une String.
 *      Cette fonction prend en paramètre la réponse telle que renvoyée par le service
 *      (cad au format json ou xml).
 *      Pour le JSONP, si le paramètre "rawResponse" a été précisé avec la valeur "true",
 *      la fonction prend en paramètre un Object JavaScript contenant la réponse XML.
 *
 * @example
 *   var options = {
 *      apiKey : null,
 *      serverUrl : 'http://localhost/service/',
 *      protocol : 'JSONP', // JSONP|XHR
 *      ssl : false,
 *      proxyURL : null,
 *      callbackName : null,
 *      httpMethod : 'GET', // GET|POST
 *      timeOut : 10000, // ms
 *      rawResponse : false, // true|false
 *      scope : null, // this
 *      onSuccess : function (response) {},
 *      onFailure : function (error) {},
 *      onBeforeParse : function (rawResponse) {}
 *   };
 * @private
 */
function CommonService (options) {
    if (!(this instanceof CommonService)) {
        throw new TypeError(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_2__["default"].getMessage("CLASS_CONSTRUCTOR"));
    }

    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("CommonService");
    this.logger.trace("[Constructeur CommonService (options)]");

    // #####################
    // récupération des options par défaut pour les paramètres optionnels
    // #####################

    /**
     * Options du service
     * @type {Object}
     */
    this.options = {
        // protocol : "JSONP",
        protocol : "XHR",
        ssl : true,
        proxyURL : "",
        // callbackName : "",
        callbackSuffix : null,
        httpMethod : "GET",
        timeOut : 0,
        rawResponse : false,
        scope : this,
        /**
        * callback par defaut pour la reponse
        * @param {Object} response - response
        * @private
        */
        onSuccess : function (response) {
            console.log("onSuccess - la reponse est la suivante : ", response);
        },
        /**
        * callback par defaut pour les erreurs
        * @param {Object} error - error
        * @private
        */
        onFailure : function (error) {
            if (error.status === 200 || !error.status) {
                console.log("onFailure : ", error.message);
            } else {
                console.log("onFailure - Erreur (", error.status, ") : ", error.message);
            }
        }
    };

    // et on ajoute les options en paramètre aux options par défaut
    for (var opt in options) {
        if (options.hasOwnProperty(opt)) {
            this.options[opt] = options[opt];
        }
    }

    // #####################
    // analyse des options
    // #####################

    // gestion des clefs API
    if (!this.options.apiKey && !this.options.serverUrl) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_2__["default"].getMessage("PARAM_MISSING", "apiKey", "serverUrl"));
    }

    // modification de la fonction de callback onSuccess dans le cas où la réponse brute est demandée
    if (this.options.rawResponse && !this.options.onSuccess) {
        /**
        * callback par defaut pour la reponse
        * @param {Object} response - response
        * @private
        */
        this.options.onSuccess = function (response) {
            console.log("onSuccess - la réponse brute du service est la suivante : ", response);
        };
    }

    // gestion du callback onSuccess
    var bOnSuccess = !!((this.options.onSuccess !== null && typeof this.options.onSuccess === "function"));
    if (!bOnSuccess) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_2__["default"].getMessage("PARAM_MISSING", "onSuccess()"));
    }

    // gestion de l'url du service par defaut
    if (!this.options.serverUrl) {
        // INFO
        // gestion de l'url du service par defaut pour les services qui ne possèdent qu'une seul url par defaut
        // les cas particuliers des services avec plusieurs urls (ex. Alti) devront être traité dans la classe du composant
        // donc si l'url n'est pas renseignée, il faut utiliser les urls par defaut
        _DefaultUrlService__WEBPACK_IMPORTED_MODULE_5__["default"].ssl = this.options.ssl;
        var urlByDefault = _DefaultUrlService__WEBPACK_IMPORTED_MODULE_5__["default"][this.CLASSNAME].url(this.options.apiKey);
        if (typeof urlByDefault === "string") {
            this.options.serverUrl = urlByDefault;
        } else {
            this.logger.trace("URL par defaut à determiner au niveau du composant...");
        }
    }

    // FIXME nettoyage des KVP dans l'url du service
    // if (this.options.serverUrl) {
    //     // INFO
    //     // si l'url est renseignée, il faut la nettoyer de tous ses KVP
    //     // ex. on ne veut pas de params. 'callback' ou 'output' car ceci declencherait
    //     // des opérations d'encapsulations des reponses légèrement farfelues ...
    //     var urlsource = this.options.serverUrl;
    //     var urlparts = urlsource.split("?");
    //     this.options.serverUrl = urlparts[0];
    // }

    // gestion de la methode HTTP
    this.options.httpMethod = (typeof options.httpMethod === "string") ? options.httpMethod.toUpperCase() : "GET";

    switch (this.options.httpMethod) {
        case "POST":
        case "GET":
            break;
        case "PUT":
        case "DELETE":
        case "HEAD":
        case "OPTIONS":
            throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_2__["default"].getMessage("PARAM_NOT_SUPPORT", "httpMethod"));
        default:
            throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_2__["default"].getMessage("PARAM_UNKNOWN", "httpMethod"));
    }

    // gestion du protocole
    // this.options.protocol = (typeof options.protocol === "string" ) ? options.protocol.toUpperCase() : "JSONP";
    this.options.protocol = (typeof options.protocol === "string") ? options.protocol.toUpperCase() : "XHR";

    switch (this.options.protocol) {
        case "JSONP":
        case "XHR":
            break;
        default:
            throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_2__["default"].getMessage("PARAM_UNKNOWN", "protocol"));
    }

    // on determine l'environnement d'execution : browser ou non ?
    // et on lance une exception sur l'utilisation du protocole JSONP pour nodeJS...
    if (typeof window === "undefined" && this.options.protocol === "JSONP") {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_2__["default"].getMessage("PARAM_NOT_SUPPORT_NODEJS", "protocol=JSONP (instead use XHR)"));
    }

    // le protocole JSONP ne fonctionne qu'en GET.
    if (this.options.protocol === "JSONP") {
        this.options.httpMethod = "GET";
    }

    // gestion du cache
    this.options.nocache = options.nocache || false;

    // #####################
    // attributs d'instances
    // #####################

    /**
     * Format de réponse du service
     */
    this.options.outputFormat = null;
    /**
     * Requête envoyée au service
     */
    this.request = null;
    /**
     * Reponse du service
     */
    this.response = null;
}

/**
 * @lends module:CommonService
 */
CommonService.prototype = {

    /*
     * Constructeur (alias)
     */
    constructor : CommonService,

    /**
     * Appel du service Géoportail
     */
    call : function () {
        /* jshint validthis : true */
        this.logger.trace("CommonService::call ()");

        var context = this;
        /** fonction d'execution */
        function run () {
            this.logger.trace("CommonService::run ()");
            this.buildRequest.call(context, onError, onBuildRequest);
        }

        run.call(context);

        // callback de fin de construction de la requête
        function onBuildRequest (result) {
            this.logger.trace("CommonService::onBuildRequest : ", result);
            this.callService.call(context, onError, onCallService);
        }

        // callback de fin d'appel au service
        function onCallService (result) {
            this.logger.trace("CommonService::onCallService : ", result);
            this.analyzeResponse.call(context, onError, onAnalyzeResponse);
        }

        // callback de fin de lecture de la reponse
        function onAnalyzeResponse (result) {
            this.logger.trace("CommonService::onAnalyzeResponse : ", result);
            if (result) {
                this.options.onSuccess.call(this, result);
            } else {
                return onError.call(this, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_4__["default"]("Analyse de la reponse en échec !?"));
            }
        }

        // callback de gestion des erreurs : renvoit un objet de type ErrorService
        function onError (error) {
            this.logger.trace("CommonService::onError()");
            // error : l'objet est du type ErrorService ou Error
            var e = error;
            if (!(e instanceof _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_4__["default"])) {
                e = new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_4__["default"](error.message);
            }
            this.options.onFailure.call(this, e);
        }
    },

    /**
     * Création de la requête
     * @param {Function} error - callback
     * @param {Function} success - callback
     */
    buildRequest : function (error, success) {
        // INFO
        this.logger.error("overwritten method !");
        // retourne l'objet 'this.request'
        if (error) {
            error.call(this, "This method must be overwritten !");
        }
        success.call(this, "This method must be overwritten !");
    },

    /**
     * Appel du service
     * @param {Function} error - callback
     * @param {Function} success - callback
     */
    callService : function (error, success) {
        // INFO
        // retourne l'objet 'this.response'

        // NOTES
        //  Pour le mode XHR, on recupère une reponse sous forme d'un json ou xml (#document).
        //  Pour le mode JSONP, on a toujours un objet JSON mais sous 2 formes :
        //      - natif
        //      - XML encapsulé :
        //          {http : {status:200, error:null},xml :'réponse du service'}
        //          {http : {status:400, error:'reponse du service'},xml :null}
        //  En XHR, la reponse est directement sauvegardée dans 'this.response'.
        //  Par contre, en JSONP, on doit analyser la reponse (status ou non vide),
        //  et ne renvoyer que le contenu (xml ou l'objet)

        // gestion de la proxification du service
        var strUrlProxified = null;
        var strData = this.request;

        // a t on mis en place un proxy ?
        // la proxyfication est valable uniquement en mode XHR !
        var bUrlProxified = !!((this.options.proxyURL && this.options.protocol === "XHR"));

        // rajout de l'option gpbibaccess
        // INFO : acces au numero de version de package.conf aprés compilation !
        this.options.serverUrl = _Utils_Helper__WEBPACK_IMPORTED_MODULE_1__["default"].normalyzeUrl(this.options.serverUrl, {
            "gp-access-lib" : _package_json__WEBPACK_IMPORTED_MODULE_6__.version
        }, false);

        // si le proxy est renseigné, on proxifie l'url du service
        if (bUrlProxified) {
            if (this.options.httpMethod === "GET") {
                strUrlProxified = this.options.proxyURL + _Utils_Helper__WEBPACK_IMPORTED_MODULE_1__["default"].normalyzeUrl(this.options.serverUrl, this.request, true);
                strData = null;
            }

            if (this.options.httpMethod === "POST") {
                strUrlProxified = this.options.proxyURL + _Utils_Helper__WEBPACK_IMPORTED_MODULE_1__["default"].normalyzeUrl(this.options.serverUrl, null, true);
                strData = this.request;
            }
        }

        // contexte du composant spécifique !
        var self = this;

        var options = {
            url : strUrlProxified || this.options.serverUrl,
            method : this.options.httpMethod,
            protocol : this.options.protocol,
            timeOut : this.options.timeOut || 0,
            format : this.options.outputFormat, // ceci declenche le parsing de la reponse du service, mais on souhaite toujours une reponse brute (string) !
            nocache : this.options.nocache || false, // ceci permet d'ajouter un timestamp dans la requête
            wrap : this.options.protocol !== "XHR", // ceci declenche l'encapsulation de la reponse XML du service dans du JSON, mais pas en mode XHR !
            callbackSuffix : this.options.callbackSuffix,
            // callbackName : this.options.callbackName || null,
            data : strData,
            headers : null, // TODO...
            content : this.options.contentType || "application/xml",
            scope : this.options.scope || this,
            // callback de reponse
            onResponse : function (response) {
                self.logger.trace("callService::onResponse()");

                // le contenu de la reponse à renvoyer !
                var content = null;

                // XHR : on renvoie toujours la reponse brute du service (json ou xml)
                // au parser du composant...
                if (self.options.protocol === "XHR") {
                    self.logger.trace("Response XHR", response);
                    content = response; // par defaut, la reponse du service  !
                }

                // JSONP : on pre-analyse la reponse brute du service (encapsuler ou pas)
                // avant de l'envoyer au parser du composant...
                if (self.options.protocol === "JSONP") {
                    self.logger.trace("Response JSON", response);
                    if (response) {
                        if (response.http) {
                            // reponse encapsulée :
                            // ex. reponse du service en xml
                            // > {http : {status:200, error:null},xml :'réponse du service'}
                            if (response.http.status !== 200) {
                                error.call(self, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_4__["default"]({
                                    status : response.http.status,
                                    message : response.http.error,
                                    type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_4__["default"].TYPE_SRVERR
                                }));
                                return;
                            } else {
                                content = response.xml; // par defaut !
                                if (self.options.rawResponse) {
                                    content = response;
                                }
                            }
                        } else {
                            // reponse non encapsulée :
                            // ex. reponse du service en json ou xml
                            content = response;
                        }
                    } else {
                        error.call(self, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_4__["default"]("Le contenu de la reponse est vide !?"));
                        return;
                    }
                }

                // si on souhaite parser la reponse du service
                if (typeof self.options.onBeforeParse === "function") {
                    var newResponse = self.options.onBeforeParse(content);
                    if (typeof newResponse === "string") {
                        // la reponse parsée par l'utilisateur est retournée sous
                        // forme de string !
                        content = newResponse;
                    }
                }
                // sauvegarde de la reponse dans l'objet parent (CommonService)
                self.response = content;
                // on renvoie la reponse...
                success.call(self, content);
            },
            // callback des erreurs
            onFailure : function (e) {
                self.logger.trace("callService::onFailure()");
                // on est forcement sur une erreur levée par un service !
                e.type = _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_4__["default"].TYPE_SRVERR;
                error.call(self, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_4__["default"](e));
            },
            // callback de timeOut
            onTimeOut : function () {
                self.logger.trace("callService::onTimeOut()");
                error.call(self, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_4__["default"]("TimeOut!"));
            }
        };

        _Protocols_Protocol__WEBPACK_IMPORTED_MODULE_3__["default"].send(options);
    },

    /**
     * Analyse de la réponse
     * @param {Function} error - callback
     * @param {Function} success - callback
     */
    analyzeResponse : function (error, success) {
        // INFO
        this.logger.error("overwritten method !");
        // retourne l'objet spécifique au type de composant (json)
        if (error) {
            error.call(this, "This method must be overwritten !");
        }
        success.call(this, "This method must be overwritten !");
    }

};

/* harmony default export */ __webpack_exports__["default"] = (CommonService);


/***/ }),
/* 47 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/**
 * Classe utilitaire
 *
 * @module Helper
 * @alias Gp.Helper
 */
var Helper = {

    /**
     * concatenation des parametres key/value dans les urls
     *
     * @method normalyzeParameters
     * @static
     * @param {Object} params - tableau de clef/valeur
     *
     * @example
     *  Gp.Utils.Helper.normalyzeParameters ({
     *         key1:value1,
     *         key2:value2,
     *         key3:value3
     *  });
     *  // out : "key1=value1&key2=value2&key3=value3"
     *
     * @returns {String} retourne les paramètres concaténés
     */
    normalyzeParameters : function (params) {
        var myParams = null;

        if (params) {
            var tabParams = [];
            for (var key in params) {
                if (params.hasOwnProperty(key)) {
                    var value = params[key];
                    if (!value) {
                        value = "";
                    }
                    tabParams.push(key + "=" + value);
                }
            }

            myParams = tabParams.join("&");
        }

        return myParams;
    },

    /**
     * Concaténation et encodage des urls.
     *
     * @method normalyzeUrl
     * @static
     * @param {String} url - url
     * @param {Object|String} params - tableau de clef/valeur ou string
     * @param {Boolean} encode - true|false, false par defaut
     *
     * @example
     *  Gp.Utils.Helper.normalyzeUrl (url, {
     *         key1:value1,
     *         key2=:value2,
     *         key3:value3
     *  });
     *  // out : "url?key1=value1&key2=value2&key3=value3"
     *
     * @returns {String} retourne une url normalisée
     */
    normalyzeUrl : function (url, params, encode) {
        var myUrl = url;

        if (url) {
            var k = url.indexOf("?");
            if (k === -1) { // pas de ? et KVP
                myUrl += "?";
            }

            if (k !== -1 && k !== url.length - 1) { // KVP
                myUrl += "&";
            }
        }

        if (params) {
            if (typeof params === "string") {
                myUrl += params;
            } else {
                myUrl += this.normalyzeParameters(params);
            }
        }

        if (encode) {
            // FIXME bonne idée ?
            myUrl = encodeURIComponent(myUrl);
        }

        return myUrl;
    },

    /**
     * Indentation d'une chaine
     *
     * @method indent
     * @static
     * @param {Number} n - nombre de tabulation
     * @param {String} msg - chaine
     *
     * @example
     * Gp.Utils.Helper.indent (2, "message à indenter")
     * // out
     * // ........message à indenter
     *
     * @returns {String} retourne une chaine indentée
     */
    indent : function (n, msg) {
        var num = n || 0;
        return new Array(num + 1).join("\t") + msg;
    }
};

/* harmony default export */ __webpack_exports__["default"] = (Helper);


/***/ }),
/* 48 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_Helper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(47);
/* harmony import */ var _XHR__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(49);
/* harmony import */ var _JSONP__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55);
/**
 * Interface de dialogue avec les webservices
 *
 * @module Protocols
 * @private
 * @alias Gp.Protocols
 */




var Protocol = {

    /**
     * Interface unique d"envoi d"une requête.
     *
     * @method send
     * @static
     * @param {Object} options - options generales
     * @param {String} options.url      - url du service
     * @param {String} options.method   - GET, POST, PUT, DELETE
     * @param {String} options.protocol - XHR | JSONP
     * @param {String} options.format   - format de la reponse du service : json, xml ou null (brute)...
     * @param {String} options.wrap     - encapsuler la reponse du service dans du JSON : true|false (true par defaut sur le protocole JSONP)
     * @param {String} options.callbackSuffix - suffixe de la fonction de callback (JSONP uniquement) (ex: si callbackSuffix="", la fonction s'appellera "callback")
     * @param {String} options.timeOut  - 0 ms
     * @param {Boolean} options.nocache  - true|false
     * @param {Object|String} options.data        - content (post) ou param (get)
     * @param {Object|String} options.headers     - (post) ex. referer
     * @param {Object|String} options.content - (post) ex. "application/json"
     * @param {String} options.scope       - this (TODO)
     * @param {Function} options.onResponse - callback
     * @param {Function} options.onFailure - callback
     * @param {Function} options.onTimeOut - callback
     * @param {String} options.proxyUrl -  (TODO)
     */
    send : function (options) {
        // INFO
        // "output" - param est interne à la classe "Protocol" (parametrable via "wrap"), et à ajouter à l"url
        //      ce param est independant du service car il est géré par le filtre LUA :
        //          ex. json|xml (json par defaut).
        //          Ce param. permet d"encapsuler du XML dans du JSON :
        //              {http : {status:200, error:null},xml :"réponse du service"}
        //          Utile pour les services qui ne repondent que du XML (ex. Geocodage)
        //
        // |-------------------------------------------------|
        // |      \service |      |     |                    |
        // | output\ format| json | xml |     remarques      |
        // |--------\------|------|-----|--------------------|
        // |    json       | json | json| json/xml encapsulé |
        // |    xml        | json | xml | param inactif      |
        // |-------------------------------------------------|
        // ex. le service demande une reponse native au "format" json et avec un "output" json.
        // on a donc une reponse json encapsulé dans un json : ce qu'on ne souhaite pas !
        // dans ce cas on ne renseigne pas output=json

        // INFO
        // "wrap" - choix d"encapsuler ou non les reponses dans du JSON.
        //      Par defaut, on encapsule uniquement les reponses sur le protocole JSONP (et qui sont en xml) !

        // INFO
        // "callback" - param est interne à la classe "Protocol" (non parametrable), et à ajouter à l"url
        //      ce param est independant du service car il est géré aussi par le filtre LUA :
        //          ex. callback|null
        //          Ce param. permet de renvoyer une reponse javascript :
        //              callback ({http : {status:200, error:null},xml :"réponse du service"})
        //          Ce param. est non renseigné par defaut car pour du JSONP, on utilise le
        //          le protocol JSONP, et ce dernier implemente déjà le callback !

        // settings par defaut
        var settings = options || {
            method : "GET",
            // protocol : "JSONP",
            protocol : "XHR",
            timeOut : 0,
            format : null,
            wrap : true,
            nocache : true,
            output : "json",
            callback : null,
            callbackSuffix : null
        };

        // on determine l'environnement d'execution : browser ou non ?
        // et on stoppe pour nodeJS... sur un protocole JSONP !
        if (typeof window === "undefined" && options.protocol === "JSONP") {
            console.log("Value (s) for parameter (s) 'protocol=JSONP (instead use XHR)' not supported to NodeJS");
            return;
        }

        if (options.protocol === "XHR" || options.format === "json") {
            settings.wrap = false;
        } else if (options.protocol === "JSONP" && options.format === "xml") {
            settings.wrap = true;
        }

        settings.callback = (options.protocol === "JSONP") ? null : null; // FIXME non géré !?
        settings.output = settings.wrap ? "json" : null;

        // on encapsule les reponses dans un objet JSON
        if (settings.wrap) {
            var params = {};
            params.output = settings.output;
            params.callback = settings.callback;
            delete params.callback; // FIXME non géré !?
            settings.url = _Utils_Helper__WEBPACK_IMPORTED_MODULE_0__["default"].normalyzeUrl(options.url, params);
        }

        // choix de l"implementation :
        // XHR ou JSONP
        switch (settings.protocol) {
            case "XHR":
                // on normalise l'url (gestion du cache)
                if (options.method === "GET" && options.nocache) {
                    settings.url = _Utils_Helper__WEBPACK_IMPORTED_MODULE_0__["default"].normalyzeUrl(settings.url, {
                        t : new Date().getTime()
                    });
                }
                // appel du service en XHR
                _XHR__WEBPACK_IMPORTED_MODULE_1__["default"].call(settings);
                break;
            case "JSONP":

                // on normalise l'url si les params. sont renseignés dans la string|object "data"
                if (settings.data) {
                    settings.url = _Utils_Helper__WEBPACK_IMPORTED_MODULE_0__["default"].normalyzeUrl(settings.url, settings.data);
                }

                // appel du service en JSONP
                _JSONP__WEBPACK_IMPORTED_MODULE_2__["default"].call(settings);
                break;
            default:
                throw new Error("protocol not supported (XHR|JSONP) !");
        }
    }

};

/* harmony default export */ __webpack_exports__["default"] = (Protocol);


/***/ }),
/* 49 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _Utils_Helper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(47);
/* harmony import */ var es6_promise__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(50);
/* harmony import */ var es6_promise__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(es6_promise__WEBPACK_IMPORTED_MODULE_2__);
/* global Promise, require */




// import __request from "request";
// import __xmldom from "xmldom";

/**
 * Ajax Request (use of Promises)
 *
 * @module XHR
 * @alias Gp.Protocols.XHR
 * @see dependance 'es6-promise'
 */

// cf. https://xhr.spec.whatwg.org/
// cf. https://developer.mozilla.org/en-US/docs/Web/API/XMLHttpRequest

var XHR = {

    /**
     * Interface unique d'envoi d'une requête.
     *
     * @method call
     * @static
     * @param {Object} settings - options generales
     * @param {String} settings.url    - url du service
     * @param {String} settings.method - GET, POST, PUT, DELETE
     * @param {String} settings.format - format de la reponse du service : json, xml ou null (brute)
     * @param {String} settings.data   - content (post) ou param (get)
     * @param {String} settings.proxy  - proxy url
     * @param {Object|String} settings.headers - (post) ex. referer
     * @param {Object|String} settings.content - (post) ex. 'application/json'
     * @param {String} settings.timeOut - timeout = 0 par defaut
     * @param {String} settings.scope - this
     * @param {Function} settings.onResponse - callback
     * @param {Function} settings.onFailure  - callback
     */
    call : function (settings) {
        // logger
        var logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("XHR");
        logger.trace("[XHR::call()]");

        // FIXME
        // To polyfill the global environment
        es6_promise__WEBPACK_IMPORTED_MODULE_2___default.a.polyfill();

        // test sur les settings obligatoires
        if (!settings.url) {
            throw new Error("missing parameter : url is not defined !");
        }

        if (!settings.method) {
            throw new Error("missing parameter : method is not defined !");
        }

        if (!settings.format) {
            settings.format = "text"; // reponse brute !
        }

        var options = {};
        options.url = settings.url;
        options.data = settings.data ? settings.data : null;
        options.method = settings.method;
        options.timeOut = settings.timeOut || 0;
        options.scope = settings.scope || this;
        options.proxy = settings.proxy || null;
        options.content = settings.content || null;
        options.headers = settings.headers || {
            referer : "http://localhost"
        };

        // test sur les valeurs de 'settings.method'
        switch (settings.method) {
            case "DELETE":
            case "GET":
                break;
            case "PUT":
            case "POST":
                // on force sur ces params spécifiques au mode POST
                options.content = settings.content ? settings.content : "application/x-www-form-urlencoded"; // FIXME en attente des services : bascule en "application/xml" ou "application/json"
                options.headers = settings.headers ? settings.headers : {
                    referer : "http://localhost" // todo ...
                };
                break;
            case "HEAD":
            case "OPTIONS":
                throw new Error("HTTP method not yet supported !");
            default:
                throw new Error("HTTP method unknown !");
        }

        // test sur les valeurs de 'settings.format'
        switch (settings.format) {
            case "text":
                this.__call(options)
                    .then(function (response) {
                        logger.trace(response);
                        settings.onResponse.call(this, response);
                    })
                    .catch(function (error) {
                        settings.onFailure.call(this, error);
                    });
                break;
            case "json":
                this.__callJSON(options)
                    .then(function (response) {
                        logger.trace(response);
                        settings.onResponse.call(this, response);
                    })
                    .catch(function (error) {
                        settings.onFailure.call(this, error);
                    });
                break;
            case "xml":
                this.__callXML(options)
                    .then(function (response) {
                        logger.trace(response);
                        settings.onResponse.call(this, response);
                    })
                    .catch(function (error) {
                        settings.onFailure.call(this, error);
                    });
                break;
            default:
                throw new Error("This output Format is not yet supported !");
        }
    },

    /**
     * Requete
     *
     * @method __call
     * @private
     * @param  {Object} options - options
     * @return {Object} promise
     */
    __call : function (options) {
        var logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("XHR");
        logger.trace("[XHR::__call()]");

        var promise = new Promise(
            function (resolve, reject) {
                // traitement du corps de la requête
                var corps = (options.method === "POST" || options.method === "PUT") ? 1 : 0;

                // seulement si options.data n'est pas vide (peut être un objet ou une chaine de caractères)
                if (options.data && ((typeof options.data === "object" && Object.keys(options.data).length) || (typeof options.data === "string" && options.data.length)) && !corps) {
                    options.url = _Utils_Helper__WEBPACK_IMPORTED_MODULE_1__["default"].normalyzeUrl(options.url, options.data);
                }

                logger.trace("URL = ", options.url);

                var hXHR = null;

                // test on env. nodejs or browser
                if (typeof window === "undefined") {
                    // Utilisation du module :
                    // cf. http://blog.modulus.io/node.js-tutorial-how-to-use-request-module

                    var req = __webpack_require__(53);// __request

                    // mapping data avec body param. pour le mode POST ou PUT (?)
                    if (options.data && typeof options.data === "string" && corps) {
                        options.body = options.data;
                    }

                    // FIXME ERROR : self signed certificate in certificate chain
                    options.rejectUnauthorized = false;

                    req(options, function (error, response, body) {
                        if (!error && response.statusCode === 200 && body) {
                            resolve(body);
                        } else {
                            reject("Errors Occured on Http Request (nodejs) : " + error);
                        }
                    });
                } else {
                    if (window.XMLHttpRequest) {
                        logger.trace("XMLHttpRequest");

                        hXHR = new XMLHttpRequest();
                        hXHR.open(options.method, options.url, true); // async
                        hXHR.overrideMimeType = options.content;

                        // gestion du timeout
                        var onTimeOutTrigger = null;
                        if (options.timeOut > 0) {
                            // FIXME le timeout interne ne me permet pas de declencher le bon message...
                            // hXHR.timeout = options.timeOut;
                            logger.trace("XHR - TimeOut actif !");
                            /**
                             * Description
                             *
                             * @method onTimeOutTrigger
                             * @private
                             */
                            onTimeOutTrigger = window.setTimeout(
                                function () {
                                    var message = "TimeOut Occured on Http Request with XMLHttpRequest !";
                                    reject({
                                        message : message,
                                        status : -1
                                    });
                                }, options.timeOut);
                        }

                        if (corps) {
                            // headers, data, content of data
                            // cf. https://dvcs.w3.org/hg/xhr/raw-file/tip/Overview.html#dom-xmlhttprequest-setrequestheader
                            logger.trace("data = ", options.data);
                            hXHR.setRequestHeader("Content-type", options.content);
                            // FIXME refused to set unsafe header content-length javascript
                            // hXHR.setRequestHeader ("Content-length", options.data.length);
                            // hXHR.setRequestHeader ("Referer", options.headers.referer);
                        }

                        /**
                         * On Error
                         * FIXME ne se declenche pas !?
                         *
                         * @param {Object} e - Event
                         * @method onerror
                         * @private
                         */
                        hXHR.onerror = function (e) {
                            console.log(e);
                            reject(new Error("Errors Occured on Http Request with XMLHttpRequest !"));
                        };

                        /**
                         * On Timeout
                         * FIXME ne se declenche pas !?
                         *
                         * @param {Object} e - Event
                         * @method ontimeout
                         * @private
                         */
                        hXHR.ontimeout = function (e) {
                            console.log(e);
                            reject(new Error("TimeOut Occured on Http Request with XMLHttpRequest !"));
                        };

                        /**
                         * Description
                         *
                         * @method onreadystatechange
                         * @private
                         */
                        hXHR.onreadystatechange = function (e) {
                            if (hXHR.readyState === 4) { // DONE
                                if (hXHR.status === 200) {
                                    window.clearTimeout(onTimeOutTrigger);
                                    resolve(hXHR.response);
                                } else {
                                    var message = "Errors Occured on Http Request (status : '" + e.target.statusText + "' | url : '" + e.target.responseURL + "')";
                                    var status = e.target.status;
                                    reject({
                                        message : message,
                                        status : status
                                    });
                                }
                            }
                        };

                        // gestion du content data
                        var data4xhr = (options.data && corps) ? options.data : null;

                        hXHR.send(data4xhr);
                    } else if (window.XDomainRequest) {
                        // worked in Internet Explorer 8–10 only !
                        logger.trace("XDomainRequest");

                        hXHR = new XDomainRequest();
                        hXHR.open(options.method, options.url);

                        hXHR.overrideMimeType = options.content;

                        if (options.timeOut > 0) {
                            hXHR.timeout = options.timeout;
                            logger.trace("XHR - TimeOut actif !");
                        }

                        if (corps) {
                            // headers, data, content of data
                            // cf. https://dvcs.w3.org/hg/xhr/raw-file/tip/Overview.html#dom-xmlhttprequest-setrequestheader
                            hXHR.setRequestHeader("Content-type", options.content);
                            // FIXME refused to set unsafe header content-length javascript
                            // hXHR.setRequestHeader ("Content-length", options.data.length);
                            // hXHR.setRequestHeader ("Referer", options.headers.referer);
                        }

                        /**
                         * Description
                         *
                         * @method onerror
                         * @private
                         */
                        hXHR.onerror = function () {
                            reject(new Error("Errors Occured on Http Request with XMLHttpRequest !"));
                        };

                        /**
                         * Description
                         *
                         * @method ontimeout
                         * @private
                         */
                        hXHR.ontimeout = function () {
                            reject(new Error("TimeOut Occured on Http Request with XMLHttpRequest !"));
                        };

                        /**
                         * On Load
                         *
                         * @method onload
                         * @private
                         */
                        hXHR.onload = function (e) {
                            if (hXHR.status === 200) {
                                resolve(hXHR.responseText);
                            } else {
                                var message = "Errors Occured on Http Request (status : '" + e.target.statusText + "' | url : '" + e.target.responseURL + "')";
                                var status = e.target.status;
                                reject({
                                    message : message,
                                    status : status
                                });
                            }
                        };

                        var data4xdr = (options.data && corps) ? options.data : null;

                        hXHR.send(data4xdr);
                    } else {
                        throw new Error("CORS not supported");
                    }
                }
            }
        );

        return promise;
    },

    /**
     * Requete avec parser JSON
     *
     * @method __callJSON
     * @private
     * @param  {Object} options - options
     * @return {Object} promise
     */
    __callJSON : function (options) {
        return this.__call(options)
            .then(JSON.parse)
            .catch(function (error) {
                console.log("_callJSON failed on : ", options.url, error);
                // FIXME pas d'exception, laissons le fil se derouler...
                // throw error;
            });
    },

    /**
     * Requete avec parser XML
     *
     * @method __callXML
     * @private
     * @param  {Object} options - options
     * @return {Object} promise
     */
    __callXML : function (options) {
        return this.__call(options)
            .then(function (response) {
                var xmlDoc;

                // test on env. nodejs or browser
                if (typeof window === "undefined") {
                    var DOMParser = __webpack_require__(54).DOMParser; // __xmldom.DOMParser
                    xmlDoc = new DOMParser().parseFromString(response, "text/xml");
                } else {
                    if (window.DOMParser) {
                        var parser = new window.DOMParser();
                        xmlDoc = parser.parseFromString(response, "text/xml");
                    } else { // IE
                        xmlDoc = new window.ActiveXObject("Microsoft.XMLDOM");
                        xmlDoc.async = false;
                        xmlDoc.loadXML(response);
                    }
                }

                return xmlDoc;
            })
            .catch(function (error) {
                console.log("__callXML failed on : ", options.url, error);
                // FIXME pas d'exception, laissons le fil se derouler...
                // throw error;
            });
    }

};

/* harmony default export */ __webpack_exports__["default"] = (XHR);


/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(process, global) {/*!
 * @overview es6-promise - a tiny implementation of Promises/A+.
 * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
 * @license   Licensed under MIT license
 *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
 * @version   v4.2.8+1e68dce6
 */

(function (global, factory) {
	 true ? module.exports = factory() :
	undefined;
}(this, (function () { 'use strict';

function objectOrFunction(x) {
  var type = typeof x;
  return x !== null && (type === 'object' || type === 'function');
}

function isFunction(x) {
  return typeof x === 'function';
}



var _isArray = void 0;
if (Array.isArray) {
  _isArray = Array.isArray;
} else {
  _isArray = function (x) {
    return Object.prototype.toString.call(x) === '[object Array]';
  };
}

var isArray = _isArray;

var len = 0;
var vertxNext = void 0;
var customSchedulerFn = void 0;

var asap = function asap(callback, arg) {
  queue[len] = callback;
  queue[len + 1] = arg;
  len += 2;
  if (len === 2) {
    // If len is 2, that means that we need to schedule an async flush.
    // If additional callbacks are queued before the queue is flushed, they
    // will be processed by this flush that we are scheduling.
    if (customSchedulerFn) {
      customSchedulerFn(flush);
    } else {
      scheduleFlush();
    }
  }
};

function setScheduler(scheduleFn) {
  customSchedulerFn = scheduleFn;
}

function setAsap(asapFn) {
  asap = asapFn;
}

var browserWindow = typeof window !== 'undefined' ? window : undefined;
var browserGlobal = browserWindow || {};
var BrowserMutationObserver = browserGlobal.MutationObserver || browserGlobal.WebKitMutationObserver;
var isNode = typeof self === 'undefined' && typeof process !== 'undefined' && {}.toString.call(process) === '[object process]';

// test for web worker but not in IE10
var isWorker = typeof Uint8ClampedArray !== 'undefined' && typeof importScripts !== 'undefined' && typeof MessageChannel !== 'undefined';

// node
function useNextTick() {
  // node version 0.10.x displays a deprecation warning when nextTick is used recursively
  // see https://github.com/cujojs/when/issues/410 for details
  return function () {
    return process.nextTick(flush);
  };
}

// vertx
function useVertxTimer() {
  if (typeof vertxNext !== 'undefined') {
    return function () {
      vertxNext(flush);
    };
  }

  return useSetTimeout();
}

function useMutationObserver() {
  var iterations = 0;
  var observer = new BrowserMutationObserver(flush);
  var node = document.createTextNode('');
  observer.observe(node, { characterData: true });

  return function () {
    node.data = iterations = ++iterations % 2;
  };
}

// web worker
function useMessageChannel() {
  var channel = new MessageChannel();
  channel.port1.onmessage = flush;
  return function () {
    return channel.port2.postMessage(0);
  };
}

function useSetTimeout() {
  // Store setTimeout reference so es6-promise will be unaffected by
  // other code modifying setTimeout (like sinon.useFakeTimers())
  var globalSetTimeout = setTimeout;
  return function () {
    return globalSetTimeout(flush, 1);
  };
}

var queue = new Array(1000);
function flush() {
  for (var i = 0; i < len; i += 2) {
    var callback = queue[i];
    var arg = queue[i + 1];

    callback(arg);

    queue[i] = undefined;
    queue[i + 1] = undefined;
  }

  len = 0;
}

function attemptVertx() {
  try {
    var vertx = Function('return this')().require('vertx');
    vertxNext = vertx.runOnLoop || vertx.runOnContext;
    return useVertxTimer();
  } catch (e) {
    return useSetTimeout();
  }
}

var scheduleFlush = void 0;
// Decide what async method to use to triggering processing of queued callbacks:
if (isNode) {
  scheduleFlush = useNextTick();
} else if (BrowserMutationObserver) {
  scheduleFlush = useMutationObserver();
} else if (isWorker) {
  scheduleFlush = useMessageChannel();
} else if (browserWindow === undefined && "function" === 'function') {
  scheduleFlush = attemptVertx();
} else {
  scheduleFlush = useSetTimeout();
}

function then(onFulfillment, onRejection) {
  var parent = this;

  var child = new this.constructor(noop);

  if (child[PROMISE_ID] === undefined) {
    makePromise(child);
  }

  var _state = parent._state;


  if (_state) {
    var callback = arguments[_state - 1];
    asap(function () {
      return invokeCallback(_state, child, callback, parent._result);
    });
  } else {
    subscribe(parent, child, onFulfillment, onRejection);
  }

  return child;
}

/**
  `Promise.resolve` returns a promise that will become resolved with the
  passed `value`. It is shorthand for the following:

  ```javascript
  let promise = new Promise(function(resolve, reject){
    resolve(1);
  });

  promise.then(function(value){
    // value === 1
  });
  ```

  Instead of writing the above, your code now simply becomes the following:

  ```javascript
  let promise = Promise.resolve(1);

  promise.then(function(value){
    // value === 1
  });
  ```

  @method resolve
  @static
  @param {Any} value value that the returned promise will be resolved with
  Useful for tooling.
  @return {Promise} a promise that will become fulfilled with the given
  `value`
*/
function resolve$1(object) {
  /*jshint validthis:true */
  var Constructor = this;

  if (object && typeof object === 'object' && object.constructor === Constructor) {
    return object;
  }

  var promise = new Constructor(noop);
  resolve(promise, object);
  return promise;
}

var PROMISE_ID = Math.random().toString(36).substring(2);

function noop() {}

var PENDING = void 0;
var FULFILLED = 1;
var REJECTED = 2;

function selfFulfillment() {
  return new TypeError("You cannot resolve a promise with itself");
}

function cannotReturnOwn() {
  return new TypeError('A promises callback cannot return that same promise.');
}

function tryThen(then$$1, value, fulfillmentHandler, rejectionHandler) {
  try {
    then$$1.call(value, fulfillmentHandler, rejectionHandler);
  } catch (e) {
    return e;
  }
}

function handleForeignThenable(promise, thenable, then$$1) {
  asap(function (promise) {
    var sealed = false;
    var error = tryThen(then$$1, thenable, function (value) {
      if (sealed) {
        return;
      }
      sealed = true;
      if (thenable !== value) {
        resolve(promise, value);
      } else {
        fulfill(promise, value);
      }
    }, function (reason) {
      if (sealed) {
        return;
      }
      sealed = true;

      reject(promise, reason);
    }, 'Settle: ' + (promise._label || ' unknown promise'));

    if (!sealed && error) {
      sealed = true;
      reject(promise, error);
    }
  }, promise);
}

function handleOwnThenable(promise, thenable) {
  if (thenable._state === FULFILLED) {
    fulfill(promise, thenable._result);
  } else if (thenable._state === REJECTED) {
    reject(promise, thenable._result);
  } else {
    subscribe(thenable, undefined, function (value) {
      return resolve(promise, value);
    }, function (reason) {
      return reject(promise, reason);
    });
  }
}

function handleMaybeThenable(promise, maybeThenable, then$$1) {
  if (maybeThenable.constructor === promise.constructor && then$$1 === then && maybeThenable.constructor.resolve === resolve$1) {
    handleOwnThenable(promise, maybeThenable);
  } else {
    if (then$$1 === undefined) {
      fulfill(promise, maybeThenable);
    } else if (isFunction(then$$1)) {
      handleForeignThenable(promise, maybeThenable, then$$1);
    } else {
      fulfill(promise, maybeThenable);
    }
  }
}

function resolve(promise, value) {
  if (promise === value) {
    reject(promise, selfFulfillment());
  } else if (objectOrFunction(value)) {
    var then$$1 = void 0;
    try {
      then$$1 = value.then;
    } catch (error) {
      reject(promise, error);
      return;
    }
    handleMaybeThenable(promise, value, then$$1);
  } else {
    fulfill(promise, value);
  }
}

function publishRejection(promise) {
  if (promise._onerror) {
    promise._onerror(promise._result);
  }

  publish(promise);
}

function fulfill(promise, value) {
  if (promise._state !== PENDING) {
    return;
  }

  promise._result = value;
  promise._state = FULFILLED;

  if (promise._subscribers.length !== 0) {
    asap(publish, promise);
  }
}

function reject(promise, reason) {
  if (promise._state !== PENDING) {
    return;
  }
  promise._state = REJECTED;
  promise._result = reason;

  asap(publishRejection, promise);
}

function subscribe(parent, child, onFulfillment, onRejection) {
  var _subscribers = parent._subscribers;
  var length = _subscribers.length;


  parent._onerror = null;

  _subscribers[length] = child;
  _subscribers[length + FULFILLED] = onFulfillment;
  _subscribers[length + REJECTED] = onRejection;

  if (length === 0 && parent._state) {
    asap(publish, parent);
  }
}

function publish(promise) {
  var subscribers = promise._subscribers;
  var settled = promise._state;

  if (subscribers.length === 0) {
    return;
  }

  var child = void 0,
      callback = void 0,
      detail = promise._result;

  for (var i = 0; i < subscribers.length; i += 3) {
    child = subscribers[i];
    callback = subscribers[i + settled];

    if (child) {
      invokeCallback(settled, child, callback, detail);
    } else {
      callback(detail);
    }
  }

  promise._subscribers.length = 0;
}

function invokeCallback(settled, promise, callback, detail) {
  var hasCallback = isFunction(callback),
      value = void 0,
      error = void 0,
      succeeded = true;

  if (hasCallback) {
    try {
      value = callback(detail);
    } catch (e) {
      succeeded = false;
      error = e;
    }

    if (promise === value) {
      reject(promise, cannotReturnOwn());
      return;
    }
  } else {
    value = detail;
  }

  if (promise._state !== PENDING) {
    // noop
  } else if (hasCallback && succeeded) {
    resolve(promise, value);
  } else if (succeeded === false) {
    reject(promise, error);
  } else if (settled === FULFILLED) {
    fulfill(promise, value);
  } else if (settled === REJECTED) {
    reject(promise, value);
  }
}

function initializePromise(promise, resolver) {
  try {
    resolver(function resolvePromise(value) {
      resolve(promise, value);
    }, function rejectPromise(reason) {
      reject(promise, reason);
    });
  } catch (e) {
    reject(promise, e);
  }
}

var id = 0;
function nextId() {
  return id++;
}

function makePromise(promise) {
  promise[PROMISE_ID] = id++;
  promise._state = undefined;
  promise._result = undefined;
  promise._subscribers = [];
}

function validationError() {
  return new Error('Array Methods must be provided an Array');
}

var Enumerator = function () {
  function Enumerator(Constructor, input) {
    this._instanceConstructor = Constructor;
    this.promise = new Constructor(noop);

    if (!this.promise[PROMISE_ID]) {
      makePromise(this.promise);
    }

    if (isArray(input)) {
      this.length = input.length;
      this._remaining = input.length;

      this._result = new Array(this.length);

      if (this.length === 0) {
        fulfill(this.promise, this._result);
      } else {
        this.length = this.length || 0;
        this._enumerate(input);
        if (this._remaining === 0) {
          fulfill(this.promise, this._result);
        }
      }
    } else {
      reject(this.promise, validationError());
    }
  }

  Enumerator.prototype._enumerate = function _enumerate(input) {
    for (var i = 0; this._state === PENDING && i < input.length; i++) {
      this._eachEntry(input[i], i);
    }
  };

  Enumerator.prototype._eachEntry = function _eachEntry(entry, i) {
    var c = this._instanceConstructor;
    var resolve$$1 = c.resolve;


    if (resolve$$1 === resolve$1) {
      var _then = void 0;
      var error = void 0;
      var didError = false;
      try {
        _then = entry.then;
      } catch (e) {
        didError = true;
        error = e;
      }

      if (_then === then && entry._state !== PENDING) {
        this._settledAt(entry._state, i, entry._result);
      } else if (typeof _then !== 'function') {
        this._remaining--;
        this._result[i] = entry;
      } else if (c === Promise$1) {
        var promise = new c(noop);
        if (didError) {
          reject(promise, error);
        } else {
          handleMaybeThenable(promise, entry, _then);
        }
        this._willSettleAt(promise, i);
      } else {
        this._willSettleAt(new c(function (resolve$$1) {
          return resolve$$1(entry);
        }), i);
      }
    } else {
      this._willSettleAt(resolve$$1(entry), i);
    }
  };

  Enumerator.prototype._settledAt = function _settledAt(state, i, value) {
    var promise = this.promise;


    if (promise._state === PENDING) {
      this._remaining--;

      if (state === REJECTED) {
        reject(promise, value);
      } else {
        this._result[i] = value;
      }
    }

    if (this._remaining === 0) {
      fulfill(promise, this._result);
    }
  };

  Enumerator.prototype._willSettleAt = function _willSettleAt(promise, i) {
    var enumerator = this;

    subscribe(promise, undefined, function (value) {
      return enumerator._settledAt(FULFILLED, i, value);
    }, function (reason) {
      return enumerator._settledAt(REJECTED, i, reason);
    });
  };

  return Enumerator;
}();

/**
  `Promise.all` accepts an array of promises, and returns a new promise which
  is fulfilled with an array of fulfillment values for the passed promises, or
  rejected with the reason of the first passed promise to be rejected. It casts all
  elements of the passed iterable to promises as it runs this algorithm.

  Example:

  ```javascript
  let promise1 = resolve(1);
  let promise2 = resolve(2);
  let promise3 = resolve(3);
  let promises = [ promise1, promise2, promise3 ];

  Promise.all(promises).then(function(array){
    // The array here would be [ 1, 2, 3 ];
  });
  ```

  If any of the `promises` given to `all` are rejected, the first promise
  that is rejected will be given as an argument to the returned promises's
  rejection handler. For example:

  Example:

  ```javascript
  let promise1 = resolve(1);
  let promise2 = reject(new Error("2"));
  let promise3 = reject(new Error("3"));
  let promises = [ promise1, promise2, promise3 ];

  Promise.all(promises).then(function(array){
    // Code here never runs because there are rejected promises!
  }, function(error) {
    // error.message === "2"
  });
  ```

  @method all
  @static
  @param {Array} entries array of promises
  @param {String} label optional string for labeling the promise.
  Useful for tooling.
  @return {Promise} promise that is fulfilled when all `promises` have been
  fulfilled, or rejected if any of them become rejected.
  @static
*/
function all(entries) {
  return new Enumerator(this, entries).promise;
}

/**
  `Promise.race` returns a new promise which is settled in the same way as the
  first passed promise to settle.

  Example:

  ```javascript
  let promise1 = new Promise(function(resolve, reject){
    setTimeout(function(){
      resolve('promise 1');
    }, 200);
  });

  let promise2 = new Promise(function(resolve, reject){
    setTimeout(function(){
      resolve('promise 2');
    }, 100);
  });

  Promise.race([promise1, promise2]).then(function(result){
    // result === 'promise 2' because it was resolved before promise1
    // was resolved.
  });
  ```

  `Promise.race` is deterministic in that only the state of the first
  settled promise matters. For example, even if other promises given to the
  `promises` array argument are resolved, but the first settled promise has
  become rejected before the other promises became fulfilled, the returned
  promise will become rejected:

  ```javascript
  let promise1 = new Promise(function(resolve, reject){
    setTimeout(function(){
      resolve('promise 1');
    }, 200);
  });

  let promise2 = new Promise(function(resolve, reject){
    setTimeout(function(){
      reject(new Error('promise 2'));
    }, 100);
  });

  Promise.race([promise1, promise2]).then(function(result){
    // Code here never runs
  }, function(reason){
    // reason.message === 'promise 2' because promise 2 became rejected before
    // promise 1 became fulfilled
  });
  ```

  An example real-world use case is implementing timeouts:

  ```javascript
  Promise.race([ajax('foo.json'), timeout(5000)])
  ```

  @method race
  @static
  @param {Array} promises array of promises to observe
  Useful for tooling.
  @return {Promise} a promise which settles in the same way as the first passed
  promise to settle.
*/
function race(entries) {
  /*jshint validthis:true */
  var Constructor = this;

  if (!isArray(entries)) {
    return new Constructor(function (_, reject) {
      return reject(new TypeError('You must pass an array to race.'));
    });
  } else {
    return new Constructor(function (resolve, reject) {
      var length = entries.length;
      for (var i = 0; i < length; i++) {
        Constructor.resolve(entries[i]).then(resolve, reject);
      }
    });
  }
}

/**
  `Promise.reject` returns a promise rejected with the passed `reason`.
  It is shorthand for the following:

  ```javascript
  let promise = new Promise(function(resolve, reject){
    reject(new Error('WHOOPS'));
  });

  promise.then(function(value){
    // Code here doesn't run because the promise is rejected!
  }, function(reason){
    // reason.message === 'WHOOPS'
  });
  ```

  Instead of writing the above, your code now simply becomes the following:

  ```javascript
  let promise = Promise.reject(new Error('WHOOPS'));

  promise.then(function(value){
    // Code here doesn't run because the promise is rejected!
  }, function(reason){
    // reason.message === 'WHOOPS'
  });
  ```

  @method reject
  @static
  @param {Any} reason value that the returned promise will be rejected with.
  Useful for tooling.
  @return {Promise} a promise rejected with the given `reason`.
*/
function reject$1(reason) {
  /*jshint validthis:true */
  var Constructor = this;
  var promise = new Constructor(noop);
  reject(promise, reason);
  return promise;
}

function needsResolver() {
  throw new TypeError('You must pass a resolver function as the first argument to the promise constructor');
}

function needsNew() {
  throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.");
}

/**
  Promise objects represent the eventual result of an asynchronous operation. The
  primary way of interacting with a promise is through its `then` method, which
  registers callbacks to receive either a promise's eventual value or the reason
  why the promise cannot be fulfilled.

  Terminology
  -----------

  - `promise` is an object or function with a `then` method whose behavior conforms to this specification.
  - `thenable` is an object or function that defines a `then` method.
  - `value` is any legal JavaScript value (including undefined, a thenable, or a promise).
  - `exception` is a value that is thrown using the throw statement.
  - `reason` is a value that indicates why a promise was rejected.
  - `settled` the final resting state of a promise, fulfilled or rejected.

  A promise can be in one of three states: pending, fulfilled, or rejected.

  Promises that are fulfilled have a fulfillment value and are in the fulfilled
  state.  Promises that are rejected have a rejection reason and are in the
  rejected state.  A fulfillment value is never a thenable.

  Promises can also be said to *resolve* a value.  If this value is also a
  promise, then the original promise's settled state will match the value's
  settled state.  So a promise that *resolves* a promise that rejects will
  itself reject, and a promise that *resolves* a promise that fulfills will
  itself fulfill.


  Basic Usage:
  ------------

  ```js
  let promise = new Promise(function(resolve, reject) {
    // on success
    resolve(value);

    // on failure
    reject(reason);
  });

  promise.then(function(value) {
    // on fulfillment
  }, function(reason) {
    // on rejection
  });
  ```

  Advanced Usage:
  ---------------

  Promises shine when abstracting away asynchronous interactions such as
  `XMLHttpRequest`s.

  ```js
  function getJSON(url) {
    return new Promise(function(resolve, reject){
      let xhr = new XMLHttpRequest();

      xhr.open('GET', url);
      xhr.onreadystatechange = handler;
      xhr.responseType = 'json';
      xhr.setRequestHeader('Accept', 'application/json');
      xhr.send();

      function handler() {
        if (this.readyState === this.DONE) {
          if (this.status === 200) {
            resolve(this.response);
          } else {
            reject(new Error('getJSON: `' + url + '` failed with status: [' + this.status + ']'));
          }
        }
      };
    });
  }

  getJSON('/posts.json').then(function(json) {
    // on fulfillment
  }, function(reason) {
    // on rejection
  });
  ```

  Unlike callbacks, promises are great composable primitives.

  ```js
  Promise.all([
    getJSON('/posts'),
    getJSON('/comments')
  ]).then(function(values){
    values[0] // => postsJSON
    values[1] // => commentsJSON

    return values;
  });
  ```

  @class Promise
  @param {Function} resolver
  Useful for tooling.
  @constructor
*/

var Promise$1 = function () {
  function Promise(resolver) {
    this[PROMISE_ID] = nextId();
    this._result = this._state = undefined;
    this._subscribers = [];

    if (noop !== resolver) {
      typeof resolver !== 'function' && needsResolver();
      this instanceof Promise ? initializePromise(this, resolver) : needsNew();
    }
  }

  /**
  The primary way of interacting with a promise is through its `then` method,
  which registers callbacks to receive either a promise's eventual value or the
  reason why the promise cannot be fulfilled.
   ```js
  findUser().then(function(user){
    // user is available
  }, function(reason){
    // user is unavailable, and you are given the reason why
  });
  ```
   Chaining
  --------
   The return value of `then` is itself a promise.  This second, 'downstream'
  promise is resolved with the return value of the first promise's fulfillment
  or rejection handler, or rejected if the handler throws an exception.
   ```js
  findUser().then(function (user) {
    return user.name;
  }, function (reason) {
    return 'default name';
  }).then(function (userName) {
    // If `findUser` fulfilled, `userName` will be the user's name, otherwise it
    // will be `'default name'`
  });
   findUser().then(function (user) {
    throw new Error('Found user, but still unhappy');
  }, function (reason) {
    throw new Error('`findUser` rejected and we're unhappy');
  }).then(function (value) {
    // never reached
  }, function (reason) {
    // if `findUser` fulfilled, `reason` will be 'Found user, but still unhappy'.
    // If `findUser` rejected, `reason` will be '`findUser` rejected and we're unhappy'.
  });
  ```
  If the downstream promise does not specify a rejection handler, rejection reasons will be propagated further downstream.
   ```js
  findUser().then(function (user) {
    throw new PedagogicalException('Upstream error');
  }).then(function (value) {
    // never reached
  }).then(function (value) {
    // never reached
  }, function (reason) {
    // The `PedgagocialException` is propagated all the way down to here
  });
  ```
   Assimilation
  ------------
   Sometimes the value you want to propagate to a downstream promise can only be
  retrieved asynchronously. This can be achieved by returning a promise in the
  fulfillment or rejection handler. The downstream promise will then be pending
  until the returned promise is settled. This is called *assimilation*.
   ```js
  findUser().then(function (user) {
    return findCommentsByAuthor(user);
  }).then(function (comments) {
    // The user's comments are now available
  });
  ```
   If the assimliated promise rejects, then the downstream promise will also reject.
   ```js
  findUser().then(function (user) {
    return findCommentsByAuthor(user);
  }).then(function (comments) {
    // If `findCommentsByAuthor` fulfills, we'll have the value here
  }, function (reason) {
    // If `findCommentsByAuthor` rejects, we'll have the reason here
  });
  ```
   Simple Example
  --------------
   Synchronous Example
   ```javascript
  let result;
   try {
    result = findResult();
    // success
  } catch(reason) {
    // failure
  }
  ```
   Errback Example
   ```js
  findResult(function(result, err){
    if (err) {
      // failure
    } else {
      // success
    }
  });
  ```
   Promise Example;
   ```javascript
  findResult().then(function(result){
    // success
  }, function(reason){
    // failure
  });
  ```
   Advanced Example
  --------------
   Synchronous Example
   ```javascript
  let author, books;
   try {
    author = findAuthor();
    books  = findBooksByAuthor(author);
    // success
  } catch(reason) {
    // failure
  }
  ```
   Errback Example
   ```js
   function foundBooks(books) {
   }
   function failure(reason) {
   }
   findAuthor(function(author, err){
    if (err) {
      failure(err);
      // failure
    } else {
      try {
        findBoooksByAuthor(author, function(books, err) {
          if (err) {
            failure(err);
          } else {
            try {
              foundBooks(books);
            } catch(reason) {
              failure(reason);
            }
          }
        });
      } catch(error) {
        failure(err);
      }
      // success
    }
  });
  ```
   Promise Example;
   ```javascript
  findAuthor().
    then(findBooksByAuthor).
    then(function(books){
      // found books
  }).catch(function(reason){
    // something went wrong
  });
  ```
   @method then
  @param {Function} onFulfilled
  @param {Function} onRejected
  Useful for tooling.
  @return {Promise}
  */

  /**
  `catch` is simply sugar for `then(undefined, onRejection)` which makes it the same
  as the catch block of a try/catch statement.
  ```js
  function findAuthor(){
  throw new Error('couldn't find that author');
  }
  // synchronous
  try {
  findAuthor();
  } catch(reason) {
  // something went wrong
  }
  // async with promises
  findAuthor().catch(function(reason){
  // something went wrong
  });
  ```
  @method catch
  @param {Function} onRejection
  Useful for tooling.
  @return {Promise}
  */


  Promise.prototype.catch = function _catch(onRejection) {
    return this.then(null, onRejection);
  };

  /**
    `finally` will be invoked regardless of the promise's fate just as native
    try/catch/finally behaves
  
    Synchronous example:
  
    ```js
    findAuthor() {
      if (Math.random() > 0.5) {
        throw new Error();
      }
      return new Author();
    }
  
    try {
      return findAuthor(); // succeed or fail
    } catch(error) {
      return findOtherAuther();
    } finally {
      // always runs
      // doesn't affect the return value
    }
    ```
  
    Asynchronous example:
  
    ```js
    findAuthor().catch(function(reason){
      return findOtherAuther();
    }).finally(function(){
      // author was either found, or not
    });
    ```
  
    @method finally
    @param {Function} callback
    @return {Promise}
  */


  Promise.prototype.finally = function _finally(callback) {
    var promise = this;
    var constructor = promise.constructor;

    if (isFunction(callback)) {
      return promise.then(function (value) {
        return constructor.resolve(callback()).then(function () {
          return value;
        });
      }, function (reason) {
        return constructor.resolve(callback()).then(function () {
          throw reason;
        });
      });
    }

    return promise.then(callback, callback);
  };

  return Promise;
}();

Promise$1.prototype.then = then;
Promise$1.all = all;
Promise$1.race = race;
Promise$1.resolve = resolve$1;
Promise$1.reject = reject$1;
Promise$1._setScheduler = setScheduler;
Promise$1._setAsap = setAsap;
Promise$1._asap = asap;

/*global self*/
function polyfill() {
  var local = void 0;

  if (typeof global !== 'undefined') {
    local = global;
  } else if (typeof self !== 'undefined') {
    local = self;
  } else {
    try {
      local = Function('return this')();
    } catch (e) {
      throw new Error('polyfill failed because global object is unavailable in this environment');
    }
  }

  var P = local.Promise;

  if (P) {
    var promiseToString = null;
    try {
      promiseToString = Object.prototype.toString.call(P.resolve());
    } catch (e) {
      // silently ignored
    }

    if (promiseToString === '[object Promise]' && !P.cast) {
      return;
    }
  }

  local.Promise = Promise$1;
}

// Strange compat..
Promise$1.polyfill = polyfill;
Promise$1.Promise = Promise$1;

return Promise$1;

})));



//# sourceMappingURL=es6-promise.map

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(51), __webpack_require__(52)))

/***/ }),
/* 51 */
/***/ (function(module, exports) {

// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) { return [] }

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function() { return 0; };


/***/ }),
/* 52 */
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || new Function("return this")();
} catch (e) {
	// This works if the window reference is available
	if (typeof window === "object") g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),
/* 53 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE__53__;

/***/ }),
/* 54 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE__54__;

/***/ }),
/* 55 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/**
 * JSONP : Implémentation du protocole JSONP de la plateforme Géoportail
 *
 * @module JSONP
 * @private
 * @alias Gp.Protocols.JSONP
 */


// cf. https://github.com/sobstel/jsonp.js
var JSONP = {

    /**
     * Construction d'un identifiant statique basé sur le timestamp,
     * et qui s'incremente de +1 à chaque appel
     */
    uuid : (function () {
        var id = Math.floor(Date.now());
        return function () {
            return id++;
        };
    })(),

    /**
     * Cette fonction réalise l'appel du service fourni via le paramètre "options.url"
     * en mettant en œuvre le protocole JSONP.
     *
     * @method call
     * @static
     * @param {Object} options - parametres d'invocation du service en JSONP
     * @param {String} options.url - URL du service à invoquer (indépendamment du protocole JSONP).
     *  Cette URL contient déjà les paramètres du service.
     *  Si le paramètre dédié à la mise en oeuvre du protocole JSONP (callback=xxx) n'est pas présent, il est rajouté par la fonction ;
     *  sa valeur est déterminée en fonction du paramètre callbackName.
     * @param {Number} [options.timeOut = 0] - Nombre de ms au bout duquel on considère que le service n'a pas répondu.
     *  Une valeur de 0 pour ce paramètre permet de désactiver la gestion du timeOut.
     * @param {String} [options.callbackSuffix = null] - Suffixe de la fonction de callback à rajouter sur l'URL.
     *  Si aucun suffixe n'est spécifié (cas par défaut), on utilisera l'identifiant this.uuid () comme suffixe. Ex: "callback1458574396582 ()"
     * @param {String} [options.callbackName = gp.protocol.jsonp] - Valeur du paramètre callback à rajouter sur l'URL.
     *  Si l'URL fournie contient déjà le paramètre callback, le paramètre callbackName ne sera pas pris en compte.
     *  La fonction de callback est créée dynamiquement par la fonction JSONP ;
     *  elle a deux fonctions :
     *    elle annule la condition de timeOut
     *    puis appelle la fonction fournie par l'utilisateur via le paramètre onResponse.
     * @param {Function} options.onResponse - Nom de la fonction qui sera appelée lors de la réception des résultats du service.
     *  Ce paramètre sera ignoré si l'URL contient déjà le paramètre callback.
     *  La fonction de rappel appelée sera alors celle ayant pour nom la valeur de ce paramètre.
     * @param {Function} [options.onTimeOut] - Nom de la fonction qui sera appelée en cas de non réponse du service.
     *  Le temps au bout duquel on considère que le service n'a pas répondu est déterminé par le paramètre timeOut.
     *  @example
     *  var options = {
     *      url : 'http://localhost/some/test.json&callback=myResults',
     *      timeOut : 100,
     *      callbackName : 'myResults',
     *      callbackSuffix : "",
     *      onResponse : function (response) {
     *          console.log('results : ', response);
     *      },
     *
     *   };
     *   JSONP.call(options);
     */
    call : function (options) {
        // logger
        var logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("JSONP");
        logger.trace("[JSONP::call ()]");

        // analyse parametres

        if (!options) {
            logger.error("missing parameter : options !");
            throw new Error("missing parameter : options !");
        }

        if (!options.url) {
            logger.error("missing parameter : options.url !");
            throw new Error("missing parameter : options.url !");
        }

        if (!options.timeOut) {
            logger.info("setting 'options.timeOut' default value");
            options.timeOut = 0;
        }

        // FIXME si un callback coté client a été mis en place,
        // cette condition sur cette methode n'a pas de sens !?
        if (!options.onResponse) {
            logger.error("missing parameter : options.onResponse !");
            throw new Error("missing parameter : options.onResponse !");
            // FIXME doit on definir un callback interne par defaut !?
            // options.onResponse = function (data) {
            //    console.log("response callback (inner) : ", data);
            // };
        }

        // ID du callback à utiliser : null ou string.
        // si l'utilisateur a spécifié un suffixe pour le callback, on le récupère comme un ID (ex: options.callbackSuffix = "")
        // sinon, on utilise un timestamp : this.uuid ()
        var callbackId = (typeof options.callbackSuffix === "string") ? options.callbackSuffix : this.uuid();

        // on recherche le parametre callback et son nom de fonction dans l'url
        var urlHasCallbackKey = false;
        var urlHasCallbackName = false;

        var idx = options.url.indexOf("callback=");

        if (idx !== -1) {
            urlHasCallbackKey = true;
            // extraction callbackName de l'url : entre "callback=" et "&" ou fin de ligne
            var j = options.url.indexOf("&", idx);
            if (j === -1) {
                j = options.url.length;
            }

            // on ecrase le parametre options.callbackName s'il avait été défini
            var callbackName = options.url.substring(idx + 9, j);

            if (callbackName) {
                urlHasCallbackName = true;
                options.callbackName = callbackName;
                logger.info("setting 'options.callbackName' value (" + options.callbackName + ") from 'options.url' parameter");
            }
        }

        // on ajoute le parametre callback dans l'URL s'il n'existe pas
        if (!urlHasCallbackKey) {
            // gestion des autres param. et "?"
            var k = options.url.indexOf("?");
            if (k === -1) {
                // aucun param., ni de '?'
                options.url = options.url + "?" + "callback=";
            } else if (k === options.url.length) {
                // uniquement le '?'
                options.url = options.url + "callback=";
            } else {
                // le '?' et les param. existent
                options.url = options.url + "&" + "callback=";
            }
            logger.info("setting callback default key in 'options.url' : " + options.url);
        }

        // utilisation de la fonction callback coté client ?
        var HasCallbackName = options.callbackName ? true : urlHasCallbackName;

        // on ajoute le nom de la fonction callback dans l'URL si elle n'existe pas
        if (!urlHasCallbackName) {
            // fonction callback par defaut
            if (!options.callbackName) {
                logger.info("setting 'options.callbackName' default value");
                options.callbackName = "callback"; // ou "gp.protocol.jsonp" ?
                // info : si on ne veut pas gerer d'ID dans le callback,
                // options.callbackSuffix = ""
                if (callbackId || callbackId === "") {
                    options.callbackName += callbackId;
                }
            }
            options.url = options.url.replace("callback=", "callback=" + options.callbackName);
            logger.info("setting callback function name in 'options.url' : " + options.url);
        }

        // timeOut par defaut
        if (!options.onTimeOut) {
            logger.info("setting 'options.onTimeOut' default value");
            /** callback timeout par defaut */
            options.onTimeOut = function (/* error */) {
                console.log("TimeOut while invoking url : " + options.url);
            };
        }

        if (!HasCallbackName) {
            var self = this;

            // event du timeout
            var onTimeOutTrigger = null;

            // declenche le timeout si > à 0 !
            if (options.timeOut > 0) {
                onTimeOutTrigger = window.setTimeout(
                    function () {
                        /** fonction de reponse du service */
                        window[options.callbackName] = function () {};
                        options.onTimeOut();
                        self._deleteScript(callbackId);
                    }, options.timeOut);
            }

            // FIXME le nom de la fonction n'accepte pas de namespace !
            // ex. Gp.Function.callback
            /**
            * fonction de reponse du service
            * @param {Object} data - data
            * @private
            */
            window[options.callbackName] = function (data) {
                window.clearTimeout(onTimeOutTrigger);
                options.onResponse(data);
                self._deleteScript(callbackId);
            };
        }

        this._createScript(callbackId, options.url);
    },

    /**
    * create Script
    * @param {String} callbackId - callback Id
    * @param {String} url - url
    * @private
    */
    _createScript : function (callbackId, url) {
        var scriptu;
        var scripto = document.getElementById("results" + callbackId);

        scriptu = document.createElement("script");
        scriptu.setAttribute("type", "text/javascript");
        scriptu.setAttribute("src", url);
        scriptu.setAttribute("charset", "UTF-8");
        scriptu.setAttribute("id", "results" + callbackId);
        scriptu.setAttribute("async", "true"); // FIXME async ?
        // head ou body ou autres ?
        var node = document.documentElement || document.getElementsByTagName("head")[0];
        if (scripto === null) {
            node.appendChild(scriptu);
        } else {
            // s'il existe déjà, on le remplace !
            node.replaceChild(scriptu, scripto);
        }
    },

    /**
    * delete Script
    * @param {String} callbackId - callback Id
    * @private
    */
    _deleteScript : function (callbackId) {
        var script = document.getElementById("results" + callbackId);
        if (script) {
            var node = script.parentNode || document.documentElement;
            if (!node) {
                return;
            }
            node.removeChild(script);
        }
    }
};

/* harmony default export */ __webpack_exports__["default"] = (JSONP);


/***/ }),
/* 56 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
// cette classe contient les URLs par defaut des services.
//  DefaultUrlService.Alti.url(key)[elevation-json]
//  DefaultUrlService.Alti.url(key)[elevation-xml]
//  DefaultUrlService.Alti.url(key)[profil-json]
//  DefaultUrlService.Alti.url(key)[profil-xml]
//  DefaultUrlService.Alti.url(key)[wps]
//  DefaultUrlService.ProcessIsoCurve.url(key)
//  DefaultUrlService.AutoComplete.url(key)
//  DefaultUrlService.ReverseGeocode.url(key)
//  DefaultUrlService.AutoConf.url(key)[apiKey]
//  DefaultUrlService.AutoConf.url(key)[apiKeys]
//  DefaultUrlService.AutoConf.url(key)[aggregate]
//  DefaultUrlService.Geocode.url(key)
//  DefaultUrlService.Route.url(key)

// Example :
//
// DefaultUrlService.Alti.url('efe4r54tj4uy5i78o7545eaz7e87a')[elevation-json]
//  output {String} -> http://wxs.ign.fr/efe4r54tj4uy5i78o7545eaz7e87a/alti/rest/elevation.json
//
// DefaultUrlService.Alti.url('efe4r54tj4uy5i78o7545eaz7e87a')
// output {Object|String}
// -> http://wxs.ign.fr/efe4r54tj4uy5i78o7545eaz7e87a/alti/rest/elevation.json
// -> http://wxs.ign.fr/efe4r54tj4uy5i78o7545eaz7e87a/alti/rest/elevation.xml
// -> http://wxs.ign.fr/efe4r54tj4uy5i78o7545eaz7e87a/alti/rest/elevationLine.json
// -> http://wxs.ign.fr/efe4r54tj4uy5i78o7545eaz7e87a/alti/rest/elevationLine.xml
// -> http://wxs.ign.fr/efe4r54tj4uy5i78o7545eaz7e87a/alti/wps
//
// ssl by default.
//
// Force to not do ssl :
// DefaultUrlService.ssl = false;
//
// DefaultUrlService.AutoComplete.url('efe4r54tj4uy5i78o7545eaz7e87a')
// output {Object|String}
// -> https://wxs.ign.fr/efe4r54tj4uy5i78o7545eaz7e87a/ols/apis/completion

// constantes internes
var HOSTNAME = "wxs.ign.fr";

/**
 * Default Geoportal web services URLs access.
 *
 * @namespace
 * @alias Gp.Services.DefaultUrl
 */
var DefaultUrlService = {

    /** if set true, require the use of https protocol */
    ssl : true,

    /**
    * base url of services (ssl protocol management)
    * @param {String} key - key
    * @param {String} path - path
    * @returns {String} url
    */
    url : function (key, path) {
        // comportement par défaut => https
        // sinon, il est fixé par l'option 'ssl' (false => http)
        var _protocol;
        if (DefaultUrlService.ssl === false) {
            _protocol = "http://";
        } else {
            _protocol = "https://";
        }

        return _protocol + HOSTNAME.concat("/", key, path);
    },

    /**
     * Elevation web service access
     *
     * @member {Object}
     * @property {Function} url (key) - Returns elevation service default urls with or without geoportal access key given as a parameter. The result is a javascript object with different urls given used protocols ("elevation-json", "elevation-xml", "profil-json" or "profil-xml").
     */
    Alti : {
        _key : {
            // rest
            "elevation-json" : "/alti/rest/elevation.json",
            "elevation-xml" : "/alti/rest/elevation.xml",
            "profil-json" : "/alti/rest/elevationLine.json",
            "profil-xml" : "/alti/rest/elevationLine.xml",
            // other
            wps : "/alti/wps"
        },
        /**
        * url
        * @param {String} key - key
        * @returns {String} url
        */
        url : function (key) {
            return {
                // rest
                "elevation-json" : DefaultUrlService.url(key, this._key["elevation-json"]),
                "elevation-xml" : DefaultUrlService.url(key, this._key["elevation-xml"]),
                "profil-json" : DefaultUrlService.url(key, this._key["profil-json"]),
                "profil-xml" : DefaultUrlService.url(key, this._key["profil-xml"]),
                // other
                wps : DefaultUrlService.url(key, this._key["wps"])
            };
        }
    },
    /**
     * IsoCurve web service access
     *
     * @member {Object}
     * @property {Function} url (key) - Returns isocurve service default urls with or without geoportal access key given as a parameter. The result is a javascript object with different urls given used protocols ("iso-json" or "iso-xml").
     */
    ProcessIsoCurve : {
        _key : {
            "iso-json" : "/isochrone/isochrone.json", // rest (geoconcept)
            "iso-xml" : "/isochrone/isochrone.xml" // rest (geoconcept)
        },
        /**
        * url
        * @param {String} key - key
        * @returns {String} url
        */
        url : function (key) {
            return {
                "iso-json" : DefaultUrlService.url(key, this._key["iso-json"]),
                "iso-xml" : DefaultUrlService.url(key, this._key["iso-xml"])
            };
        }
    },
    /**
     * Autocompletion web service access
     *
     * @member {Object}
     * @property {Function} url (key) - Returns autocomplete service default urls with or without geoportal access key given as a parameter. The result is a String.
     */
    AutoComplete : {
        _key : "/ols/apis/completion",
        /**
        * url
        * @param {String} key - key
        * @returns {String} url
        */
        url : function (key) {
            return DefaultUrlService.url(key, this._key);
        }
    },
    /**
     * Reverse geocoding web service access
     *
     * @member {Object}
     * @property {Function} url (key) - Returns reverse geocoding service default urls with or without geoportal access key given as a parameter. The result is a String.
     */
    ReverseGeocode : {
        _key : "/geoportail/ols",
        /**
        * url
        * @param {String} key - key
        * @returns {String} url
        */
        url : function (key) {
            return DefaultUrlService.url(key, this._key);
        }
    },
    /**
     * Autoconfiguration web service access
     *
     * @member {Object}
     * @property {Function} url ([key1,...]) - Returns autoconfiguration service default urls with geoportal access key (s) given as a String array parameter. The result is a javascript object with different urls given the access mode ("apiKey", "apiKeys" or "aggregate").
     */
    AutoConf : {
        _key : {
            apiKey : "/autoconf",
            apiKeys : "/autoconf?keys=%KEYS%",
            aggregate : "/autoconf/id/"
        },
        /**
        * url
        * @param {String} key - key
        * @returns {String} url
        */
        url : function (key) {
            var keys = "";
            if (Array.isArray(key) && key.length > 0) {
                keys = key[0];
                for (var i = 1; i < key.length; i++) {
                    keys += "," + key[i];
                }
            }
            return {
                apiKey : DefaultUrlService.url(key, this._key["apiKey"]), // une seule clé
                apiKeys : DefaultUrlService.url(key[0], this._key["apiKeys"]).replace("%KEYS%", keys), // autoconf de plusieurs clés
                aggregate : DefaultUrlService.url(key, this._key["aggregate"])
            };
        }
    },
    /**
     * Geocoding web service access
     *
     * @member {Object}
     * @property {Function} url (key) - Returns geocoding service default urls with or without geoportal access key given as a parameter. The result is a String.
     */
    Geocode : {
        _key : "/geoportail/ols",
        /**
        * url
        * @param {String} key - key
        * @returns {String} url
        */
        url : function (key) {
            return DefaultUrlService.url(key, this._key);
        }
    },
    /**
     * Routing web service access
     *
     * @member {Object}
     * @property {Function} url (key) - Returns routing service default urls with or without geoportal access key given as a parameter. The result is a javascript object with different urls given used protocols ("route-json" or "route-xml").
     */
    Route : {
        _key : {
            ols : "/itineraire/ols", // openLS
            "route-json" : "/itineraire/rest/route.json", // rest (geoconcept)
            "route-xml" : "/itineraire/rest/route.xml" // rest (geoconcept)
        },
        /**
        * url
        * @param {String} key - key
        * @returns {String} url
        */
        url : function (key) {
            return {
                ols : DefaultUrlService.url(key, this._key["ols"]),
                "route-json" : DefaultUrlService.url(key, this._key["route-json"]),
                "route-xml" : DefaultUrlService.url(key, this._key["route-xml"])
            };
        }
    }
};

/* harmony default export */ __webpack_exports__["default"] = (DefaultUrlService);


/***/ }),
/* 57 */
/***/ (function(module) {

module.exports = JSON.parse("{\"_from\":\"geoportal-access-lib@2.1.6\",\"_id\":\"geoportal-access-lib@2.1.6\",\"_inBundle\":false,\"_integrity\":\"sha512-zQpSjZq8YkGW+ooB1WloQd2KZHCKyg4/pbIFLSPCk3et2Zan/O2hZlKOf2alEX2zbsg7Wd+e8KiLc7cHZKniag==\",\"_location\":\"/geoportal-access-lib\",\"_phantomChildren\":{},\"_requested\":{\"type\":\"version\",\"registry\":true,\"raw\":\"geoportal-access-lib@2.1.6\",\"name\":\"geoportal-access-lib\",\"escapedName\":\"geoportal-access-lib\",\"rawSpec\":\"2.1.6\",\"saveSpec\":null,\"fetchSpec\":\"2.1.6\"},\"_requiredBy\":[\"/\"],\"_resolved\":\"https://registry.npmjs.org/geoportal-access-lib/-/geoportal-access-lib-2.1.6.tgz\",\"_shasum\":\"8bb0d4cc7045c39c3392fe076ba699aace2b6066\",\"_spec\":\"geoportal-access-lib@2.1.6\",\"_where\":\"/home/runner/work/geoportal-extensions/geoportal-extensions\",\"author\":{\"name\":\"IGNF\"},\"bugs\":{\"url\":\"https://github.com/IGNF/geoportal-access-lib/issues\"},\"bundleDependencies\":false,\"date\":\"03/10/2019\",\"dependencies\":{\"es6-promise\":\"^4.2.4\",\"request\":\"^2.87.0\",\"xmldom\":\"^0.1.27\"},\"deprecated\":false,\"description\":\"French Geoportal resources access library\",\"devDependencies\":{\"babel-core\":\"^6.26.3\",\"babel-loader\":\"^7.1.2\",\"babel-preset-env\":\"^1.7.0\",\"chai\":\"^4.1.2\",\"clean-webpack-plugin\":\"^0.1.18\",\"copy-webpack-plugin\":\"^4.5.1\",\"eslint\":\"^4.18.2\",\"eslint-config-standard\":\"^11.0.0\",\"eslint-loader\":\"^2.0.0\",\"eslint-plugin-import\":\"^2.9.0\",\"eslint-plugin-node\":\"^6.0.1\",\"eslint-plugin-promise\":\"^3.7.0\",\"eslint-plugin-standard\":\"^3.0.1\",\"glob\":\"^7.1.2\",\"handlebars-layouts\":\"^3.1.4\",\"handlebars-webpack-plugin\":\"^1.4.1\",\"html-webpack-plugin\":\"^2.30.1\",\"istanbul-instrumenter-loader\":\"^3.0.1\",\"jsdoc-webpack-plugin\":\"0.0.1\",\"loglevel\":\"^1.6.1\",\"mocha\":\"^4.0.0\",\"mocha-loader\":\"^1.1.3\",\"mocha-webpack\":\"^1.0.1\",\"nyc\":\"^12.0.2\",\"path\":\"^0.12.7\",\"replace-bundle-webpack-plugin\":\"^1.0.0\",\"sinon\":\"^4.3.0\",\"sinon-es6\":\"0.0.3\",\"speed-measure-webpack-plugin\":\"^1.2.2\",\"string-template\":\"^1.0.0\",\"webpack\":\"^3.11.0\",\"webpack-dev-server\":\"^2.11.3\",\"webpack-node-externals\":\"^1.6.0\",\"webpack-shell-plugin\":\"^0.5.0\"},\"homepage\":\"https://github.com/IGNF/geoportal-access-lib#readme\",\"keywords\":[\"geoportail\",\"webservice\",\"javascript\",\"es6\"],\"license\":\"CECILL-B\",\"main\":\"dist/GpServices-src.js\",\"module\":\"src/Gp.js\",\"name\":\"geoportal-access-lib\",\"nyc\":{\"include\":[\"src/**/*.js\"],\"instrument\":false,\"sourceMap\":false},\"optionalDependencies\":{},\"peerDependencies\":{},\"repository\":{\"type\":\"git\",\"url\":\"git+https://github.com/IGNF/geoportal-access-lib.git\"},\"scripts\":{\"build\":\"webpack\",\"build:dev\":\"webpack --env.development\",\"build:prod\":\"webpack --env.production\",\"clean\":\"echo \\\"Warning: no yet implemented!\\\" && exit 0\",\"cover\":\"nyc --reporter=lcov --reporter=text npm run test\",\"doc\":\"npm run doc:serve\",\"doc:serve\":\"webpack-dev-server --content-base jsdoc --port 9001 --open\",\"sample\":\"npm run sample:serve\",\"sample:serve\":\"webpack-dev-server --open-page samples/index-src.html --https --content-base .  --output-public-path '/dist/' --port 9001 --open 'google-chrome'\",\"sample:serve:dev\":\"webpack-dev-server --env.development --open-page samples/index-map.html --content-base . --output-public-path '/dist/' --port 9001 --open 'google-chrome\",\"sample:serve:prod\":\"webpack-dev-server --env.production --open-page samples/index.html --content-base . --output-public-path '/dist/' --port 9001 --open 'google-chrome\",\"setup\":\"npm install\",\"test\":\"mocha-webpack --webpack-config webpack.test.js --glob \\\"test_*.js\\\" test/spec/\",\"test:end-to-end:serve\":\"webpack-dev-server --hot --config webpack.end-to-end.serve.js\",\"test:serve\":\"webpack-dev-server --hot --config webpack.test.serve.js\"},\"version\":\"2.1.6\"}");

/***/ }),
/* 58 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(45);
/* harmony import */ var _AltiRequestREST__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(59);
/* harmony import */ var _AltiRequestWPS__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(63);
/**
 * Creation d'une requête en REST ou WPS
 * (Factory)
 *
 * @module AltiRequestFactory
 * @alias Gp.Services.Alti.Request.AltiRequestFactory
 * @private
 */





var AltiRequestFactory = {

    /**
     * interface unique
     *
     * @method build
     * @static
     * @param {Object} options - options definies dans le composant Alti
     *
     * @example
     *   var options = {
     *      httpMethod : 'GET', // GET|POST
     *      onSuccess : function (response) {},
     *      onError : function (error) {},
     *      scope : this,
     *      positions : [{lon:, lat:}, {lon:, lat:}],
     *      outputFormat : 'json' // json|xml
     *      sampling : 3,
     *      api : 'REST', // REST|WPS
     *      zonly : false // false|true
     *   };
     *
     */
    build : function (options) {
        // logger
        var logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("AltiRequestFactory");
        logger.trace(["AltiRequestFactory::build()"]);

        var request = null;

        // on factorise les options par groupe;
        // - global,
        // - param, les params pour les data inputs
        // - wps, les param du service
        // - callback

        var settings = {
            // ajout des valeurs par defaut spécifiques au service
            type : options.sampling ? "Profil" : "Elevation",
            method : options.httpMethod,
            param : {
                positions : null,
                delimiter : null, // FIXME par defaut, on ne le met pas en place car ça fait planter la requête !?
                indent : null, // par defaut
                crs : null, // par defaut
                format : null, // (only to POST)
                sampling : null, // (only use by Profil)
                zonly : null // (only use by Elevation)
            }
        };

        // surcharge des valeurs obligatoires
        settings.param.positions = options.positions;
        settings.param.format = options.outputFormat;
        settings.param.sampling = options.sampling;
        settings.param.zonly = options.zonly;

        // gestion des callback
        var bOnError = !!((options.onError !== null && typeof options.onError === "function"));
        var bOnSuccess = !!((options.onSuccess !== null && typeof options.onSuccess === "function"));

        var message = null;
        switch (options.api) {
            case "REST":
                // FIXME les exceptions ne sont pas 'catchées' sur le constructeur !
                var myReq = new _AltiRequestREST__WEBPACK_IMPORTED_MODULE_2__["default"](settings);
                if (!myReq.processRequestString()) {
                    message = "Error in process request (rest) !";
                    if (bOnError) {
                        options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_1__["default"](message));
                        return;
                    }
                    throw new Error(message);
                }
                request = myReq.requestString;
                break;
            case "WPS":
                // ajout des valeurs par defaut spécifiques au service WPS
                settings.wps = {
                    service : null, // par defaut
                    version : null, // par defaut
                    identifier : null, // par defaut
                    rawdataoutput : null, // par defaut
                    request : null // par defaut
                };

                request = _AltiRequestWPS__WEBPACK_IMPORTED_MODULE_3__["default"].build(settings);
                if (!request) {
                    message = "Error in process request (wps) !";
                    if (bOnError) {
                        options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_1__["default"](message));
                        return;
                    }
                    throw new Error(message);
                }
                break;
            default:
                message = "Type of API is not supported by service (REST or WPS) !";
                if (bOnError) {
                    options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_1__["default"](message));
                    return;
                }
                throw new Error(message);
        }

        if (bOnSuccess) {
            options.onSuccess.call(options.scope, request);
        }

        return request;
    }
};

/* harmony default export */ __webpack_exports__["default"] = (AltiRequestFactory);


/***/ }),
/* 59 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44);
/* harmony import */ var _model_AltiElevationRequest__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(60);
/* harmony import */ var _model_AltiProfilRequest__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(62);
/* jshint multistr : true */






/**
 * @classdesc
 * Classe de gestion des requêtes de type REST sur le service altimetrique.
 *
 * @todo Le service Alti n'implemente pas le POST !?
 * @constructor
 * @alias Gp.Services.Alti.Request.AltiRequestREST
 * @param {Object} options - options
 * @param {Object}   options.param.positions - tableau de coordonnées lon/lat
 * @param {String}   options.param.delimiter - '|'
 * @param {Boolean}  options.param.indent - false|true
 * @param {String}   options.param.crs - 'CRS:84'
 * @param {String}   options.param.sampling - 3
 * @param {Boolean}  options.param.zonly - false|true
 * @param {String}   options.param.format - "JSON|XML"
 * @param {String}   options.type - "Profil|Elevation"
 * @param {String}   options.method - GET|POST
 *
 * @example
 *      var options = {
 *           type : 'Profil', // Elevation
 *           method : 'GET',  // par defaut
 *           param : {
 *               positions : [
 *                   {lon:'1.11', lat:'1.11'},
 *                   {lon:'1.10', lat:'1.10'},
 *                   {lon:'1.12', lat:'1.12'}
 *               ],
 *               delimiter : ";",         // par defaut
 *               indent    : true,        // par defaut
 *               crs       : 'EPSG:4326', // par defaut
 *               format    : 'json',      // par defaut (only to POST)
 *               sampling  : 3 ,          // par defaut (only use by Profil)
 *               zonly     : false        // par defaut (only use by Elevation)
 *           }
 *      };
 *
 *      var result;
 *      try {
 *          var obj = new AltiRequestREST (options);
 *          if (! obj.processRequestString ()) {
 *              throw new Error("Request empty !?")
 *          }
 *          result = obj.requestString;
 *      } catch (e) {
 *          // exceptions...
 *      }
 * @private
 */
function AltiRequestREST (options) {
    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("AltiRequestREST");
    this.logger.trace("[Constructeur AltiRequestREST ()]");

    if (!(this instanceof AltiRequestREST)) {
        throw new TypeError("AltiRequestREST constructor cannot be called as a function.");
    }

    this.options = options || {};

    // existance des options
    if (!this.options) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_EMPTY", "options"));
    }

    // type de requete : Altitude ou Profil
    // (param. à determiner en fonction des parametres d'entrée)
    if (!this.options.type) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_EMPTY", "type (Elevation or Profil)"));
    }

    // construction du modele de requête
    // (test du type d'objet candidat)
    this.DataObject = null;
    switch (this.options.type) {
        case "Elevation":
            this.DataObject = new _model_AltiElevationRequest__WEBPACK_IMPORTED_MODULE_2__["default"](this.options.param);
            break;
        case "Profil":
            this.DataObject = new _model_AltiProfilRequest__WEBPACK_IMPORTED_MODULE_3__["default"](this.options.param);
            break;
        default:
            throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_TYPE", "type (Elevation or Profil)"));
    }

    /**
     * methode.
     * Par defaut, "GET".
     */
    this.method = this.options.method || "GET";
}

AltiRequestREST.prototype = {

    /**
     * request
     * @type {String}
     */
    requestString : null,

    /**
     * Constructeur (alias)
     */
    constructor : AltiRequestREST,

    /**
     * Template de la requête.
     */
    template : {
        get : {
            // FIXME on retire le param 'delimiter' : &delimiter='__DELIMITER__'
            value : "lon=__LON__&lat=__LAT__&indent=__INDENT__&crs='__CRS__'",
            input : {
                point : "&zonly=__ZONLY__",
                profil : "&sampling=__SAMPLING__"
            }
        },
        post : {
            // FIXME on retire le param 'delimiter' : delimiter='__DELIMITER__'\n\
            value : "lon=__LON__\n" +
                "lat=__LAT__\n" +
                "indent=__INDENT__\n" +
                "crs='__CRS__'\n",
            input : {
                point : "zonly=__ZONLY__",
                profil : "sampling=__SAMPLING__"
            }
        }
    },

    /**
     * Construction de la requête.
     *
     * @example
     * // GET  out : lon=0.2367,2.1570&lat=48.0551,46.6077&delimiter=,&indent=true&zonly=true&crs='CRS:84'
     * // POST out : Not yet supported method POST !
     * @returns {String}
     */
    processRequestString : function () {
        this.logger.trace("AltiRequestREST::processRequestString ()");

        var template = "";
        if (this.method === "POST") {
            template = this.template.post.value;
        } else if (this.method === "GET") {
            template = this.template.get.value;
        }

        template = template.replace(/__LON__/g, this.DataObject.getLon());
        template = template.replace(/__LAT__/g, this.DataObject.getLat());
        // FIXME on retire le param 'delimiter'
        // template = template.replace(/__DELIMITER__/g, this.DataObject.delimiter);
        template = template.replace(/__INDENT__/g, this.DataObject.indent);
        template = template.replace(/__CRS__/g, this.DataObject.crs);

        // ajout +
        template = template + this.__addDataInputs();
        this.logger.trace("traduction tmpl", template);

        // sauvegarde
        this.requestString = template;

        return this.requestString;
    },

    /**
     * Ajout de parametres spécifiques (ex. zonly)
     *
     * @returns {String}
     */
    __addDataInputs : function () {
        this.logger.trace("AltiRequestREST::addDataInput ()");

        var myTemplate;
        if (this.method === "POST") {
            myTemplate = this.template.post;
        } else if (this.method === "GET") {
            myTemplate = this.template.get;
        } else {
            throw new Error("No other HTTP method supported by the service !");
        }

        var tmpl = null;
        if (this.DataObject.CLASSNAME === "AltiElevationRequest") {
            tmpl = myTemplate.input.point;
            return tmpl.replace(/__ZONLY__/g, this.DataObject.zonly);
        } else if (this.DataObject.CLASSNAME === "AltiProfilRequest") {
            tmpl = myTemplate.input.profil;
            return tmpl.replace(/__SAMPLING__/g, this.DataObject.sampling);
        } else {
            throw new Error("No other object supported than elevation or profil !?");
        }
    }
};

/* harmony default export */ __webpack_exports__["default"] = (AltiRequestREST);


/***/ }),
/* 60 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _AltiRequest__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61);




/**
 * @classdesc
 *
 * Classe de gestion des param. des requêtes de type POINT du service altimetrique.
 *
 * @constructor
 * @alias Gp.Services.Alti.Request.AltiElevationRequest
 * @param {Object} options - options
 * @param {Boolean}  options.zonly - false|true
 *
 * @private
 */
function AltiElevationRequest (options) {
    if (!(this instanceof AltiElevationRequest)) {
        throw new TypeError("AltiElevationRequest constructor cannot be called as a function.");
    }

    /**
     * Nom de la classe (heritage)
     */
    this.CLASSNAME = "AltiElevationRequest";

    // appel du constructeur par heritage
    _AltiRequest__WEBPACK_IMPORTED_MODULE_1__["default"].apply(this, arguments);

    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger();
    this.logger.trace("[Constructeur AltiElevationRequest ()]");

    /**
     * Z uniquement.
     * true|false
     */
    this.zonly = this.options.zonly || false; // test des options héritées !
}

/**
 * @lends module:AltiElevationRequest#
 */

AltiElevationRequest.prototype = Object.create(_AltiRequest__WEBPACK_IMPORTED_MODULE_1__["default"].prototype, {

    /**
     * Setter/getter pour "zonly"
     */
    zonly : {
        /** getter */
        get : function () {
            return this._zonly;
        },
        /** setter */
        set : function (z) {
            this._zonly = z;
        }
    }

});

/**
 * Constructeur (alias)
 */
AltiElevationRequest.prototype.constructor = AltiElevationRequest;

/**
 * Tableau de clefs/valeurs pour param.
 *
 * @returns {Array}
 */
AltiElevationRequest.prototype.getData = function () {
    // par glop..., appel de AltiRequest::getData () !
    var map = [];
    map.push({
        k : "lon",
        v : this.getLon()
    });
    map.push({
        k : "lat",
        v : this.getLat()
    });
    // map.push({k : "delimiter", v : this.delimiter}); // FIXME on retire le param "delimiter"
    map.push({
        k : "indent",
        v : this.indent
    });
    map.push({
        k : "crs",
        v : this.crs
    });
    map.push({
        k : "zonly",
        v : this.zonly
    });
    map.push({
        k : "format",
        v : this.format
    });

    return map;
};

/* harmony default export */ __webpack_exports__["default"] = (AltiElevationRequest);


/***/ }),
/* 61 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);



/**
 * @classdesc
 * Classe de gestion des param. des requêtes du service altimetrique.
 *
 * @constructor
 * @alias Gp.Services.Alti.Request.AltiRequest
 * @param {Object} options - options
 * @param {Object}   options.positions - tableau de coordonnées lon/lat
 * @param {String}   options.delimiter - "|"
 * @param {Boolean}  options.indent - false|true
 * @param {String}   options.crs - "CRS:84"
 * @param {String}   options.format - "JSON|XML"
 *
 * @private
 */
function AltiRequest (options) {
    if (!(this instanceof AltiRequest)) {
        throw new TypeError("AltiRequest constructor cannot be called as a function.");
    }

    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger();
    this.logger.trace("[Constructeur AltiRequest ()]");

    /**
     * Options en paramêtres du constructeur.
     */
    this.options = options || {};

    /**
     * Liste des coordonnées.
     * @example
     * var c = [{lon : "", lat : ""}, {lon : "", lat : ""}];
     */
    this.positions = this.options.positions || [];

    /**
     * Caractère de séparation.
     * Par defaut, "|".
     */
    this.delimiter = this.options.delimiter || "|";

    /**
     * Indentation.
     * true|false
     */
    this.indent = this.options.indent || false;

    /**
     * Projection.
     * Par defaut, CRS:84.
     */
    this.crs = this.options.crs || "CRS:84";

    /**
     * format de sortie.
     * Par defaut, "json".
     */
    this.format = this.options.format || "json";
}

/**
 * CLASSNAME
 */
AltiRequest.CLASSNAME = "AltiRequest";

AltiRequest.prototype = {

    /**
     * @lends module:AltiRequest#
     */

    /**
     * Constructeur (alias)
     */
    constructor : AltiRequest,

    /**
     * Ajout d"une liste de coordonnées.
     *
     * @param {Object[]} lstPosition - liste de positions
     * @example
     * obj.setPositions ([{lon : "0.15", lat : "0.15"}, {lon : "1.15", lat : "1.15"}]);
     */
    setPositions : function (lstPosition) {
        var positions = [];
        for (var i = 0; i < lstPosition.length; i++) {
            var o = lstPosition[i];
            if (o.lon && o.lat) {
                positions.push(o);
            }
        }

        this.positions = positions;
    },

    /**
     * Liste des coordonnées.
     *
     * @param {Int} pos - position
     * @returns {positions}
     * @example
     * obj.getPositions ();  // [{lon : "", lat : ""}, {lon : "", lat : ""}]
     * obj.getPositions (0); // [{lon : "", lat : ""}]
     */
    getPositions : function (pos) {
        // FIXME test if not a number !?
        if (!pos) {
            return this.positions;
        }

        var index = this.positions.length - 1;
        if (pos > index || pos < index) {
            this.logger.warn("index out of range !");
            return this.positions;
        }

        return this.positions[pos];
    },

    /**
     * Ajout d"une liste de coordonnées.
     *
     * @param {Object[]} lstPosition - liste de positions
     * @example
     * obj.addPositions ([{lon : "0.15", lat : "0.15"}, {lon : "1.15", lat : "1.15"}]);
     */
    addPositions : function (lstPosition) {
        for (var i = 0; i < lstPosition.length; i++) {
            var o = lstPosition[i];
            if (o.lon && o.lat) {
                this.positions.push(lstPosition[i]);
            }
        }
    },

    /**
     * Retourne la liste des longitudes avec un caractère de séparation.
     *
     * @returns {String} - une liste de longitudes
     * @example
     * // out : 0.2367|2.1570|43.789|...
     */
    getLon : function () {
        var lstLon = [];
        for (var i = 0; i < this.positions.length; i++) {
            lstLon.push(this.positions[i].lon);
        }
        this.logger.trace(lstLon);
        return lstLon.join(this.delimiter);
    },

    /**
     * Retourne la liste des lattitudes avec un caractère de séparation.
     *
     * @returns {String} - une liste de lattitudes
     * @example
     * // out : 0.2367|2.1570|43.789|...
     */
    getLat : function () {
        var lstLat = [];
        for (var i = 0; i < this.positions.length; i++) {
            lstLat.push(this.positions[i].lat);
        }
        this.logger.trace(lstLat);
        return lstLat.join(this.delimiter);
    }

};

/**
 * Tableau de clefs/valeurs pour param.
 *
 * @returns {Object[]}
 */
AltiRequest.prototype.getData = function () {
    var map = [];

    map.push({
        k : "lon",
        v : this.getLon()
    });
    map.push({
        k : "lat",
        v : this.getLat()
    });
    map.push({
        k : "delimiter",
        v : this.delimiter
    });
    map.push({
        k : "indent",
        v : this.indent
    });
    map.push({
        k : "crs",
        v : this.crs
    });
    map.push({
        k : "format",
        v : this.format
    });

    return map;
};

/* harmony default export */ __webpack_exports__["default"] = (AltiRequest);


/***/ }),
/* 62 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _AltiRequest__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61);




/**
 * @classdesc
 * Classe de gestion des param. des requêtes de type PROFIL du service altimetrique.
 *
 * @constructor
 * @alias Gp.Services.Alti.Request.AltiProfilRequest
 * @param {Object}   options - options
 * @param {String}   options.sampling - 3
 *
 * @private
 */
function AltiProfilRequest (options) {
    if (!(this instanceof AltiProfilRequest)) {
        throw new TypeError("AltiProfilRequest constructor cannot be called as a function.");
    }

    /**
     * Nom de la classe (heritage)
     */
    this.CLASSNAME = "AltiProfilRequest";

    // appel du constructeur par heritage
    _AltiRequest__WEBPACK_IMPORTED_MODULE_1__["default"].apply(this, arguments);

    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger();
    this.logger.trace("[Constructeur AltiProfilRequest ()]");

    /**
     * Sampling
     * Par defaut, 3
     */
    this.sampling = this.options.sampling || 3; // test des options héritées !
}

/**
 * @lends module:AltiProfilRequest#
 */

AltiProfilRequest.prototype = Object.create(_AltiRequest__WEBPACK_IMPORTED_MODULE_1__["default"].prototype, {

    /**
     * Setter/getter pour "sampling"
     */
    sampling : {
        /** getter */
        get : function () {
            return this._sampling;
        },
        /** setter */
        set : function (value) {
            this._sampling = value;
        }
    }
});

/**
 * Constructeur (alias)
 */
AltiProfilRequest.prototype.constructor = AltiProfilRequest;

/**
 * Tableau de clefs/valeurs pour param.
 *
 * @returns {Object[]}
 */
AltiProfilRequest.prototype.getData = function () {
    // par glop..., appel de AltiRequest::getData () !
    var map = [];
    map.push({
        k : "lon",
        v : this.getLon()
    });
    map.push({
        k : "lat",
        v : this.getLat()
    });
    // map.push({k : "delimiter", v : this.delimiter}); // FIXME on retire le param "delimiter"
    map.push({
        k : "indent",
        v : this.indent
    });
    map.push({
        k : "crs",
        v : this.crs
    });
    map.push({
        k : "sampling",
        v : this.sampling
    });
    map.push({
        k : "format",
        v : this.format
    });

    return map;
};

/* harmony default export */ __webpack_exports__["default"] = (AltiProfilRequest);


/***/ }),
/* 63 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44);
/* harmony import */ var _Formats_WPS__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(64);
/* harmony import */ var _model_AltiElevationRequest__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(60);
/* harmony import */ var _model_AltiProfilRequest__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(62);
/**
 * Classe d'interface des requêtes de type WPS sur le service altimetrique.
 * (Factory)
 *
 * @module Gp.Services.Alti.Request.AltiRequestWPS
 * @alias Gp.Services.Alti.Request.AltiRequestWPS
 * @private
 */






var AltiRequestWPS = {

    /**
     * Interface unique de construction de la requête.
     *
     * @method build
     * @param {Object} options - options
     * @param {Object}   options.param.positions - tableau de coordonnées lon/lat
     * @param {String}   options.param.delimiter - '|'
     * @param {Boolean}  options.param.indent - false|true
     * @param {String}   options.param.crs - 'CRS:84'
     * @param {String}   options.param.sampling - 3
     * @param {Boolean}  options.param.zonly - false|true
     * @param {String}   options.param.format - "JSON|XML" (only to POST)
     * @param {String}   options.wps.service - "WPS"
     * @param {String}   options.wps.version - "1.0.0"
     * @param {String}   options.wps.identifier - "gs:WPSElevation|gs:WPSLineElevation"
     * @param {String}   options.wps.rawdataoutput - "result"
     * @param {String}   options.wps.request - "Execute"
     * @param {String}   options.type - "Profil|Elevation"
     * @param {String}   options.method - GET|POST
     * @example
     *      var options = {
     *           type : 'Profil', // Elevation
     *           method : 'GET',  // par defaut
     *           param : {
     *               positions : [
     *                   {lon:'1.11', lat:'1.11'},
     *                   {lon:'1.10', lat:'1.10'},
     *                   {lon:'1.12', lat:'1.12'}
     *               ],
     *               delimiter : ";",         // par defaut
     *               indent    : true,        // par defaut
     *               crs       : 'EPSG:4326', // par defaut
     *               format    : 'json',      // par defaut (only to POST)
     *               sampling  : 3 ,          // par defaut (only use by Profil)
     *               zonly     : false,       // par defaut (only use by Elevation)
     *           },
     *           wps : {
     *                 service : 'WPS',         // par defaut
     *                 version : '1.0.0',       // par defaut
     *                 identifier : 'gs:WPS',   // par defaut, Elevation = gs:WPSElevation, Profil = gs:WPSLineElevation
     *                 rawdataoutput : 'result',// par defaut
     *                 request : 'Execute'      // par defaut
     *           }
     *       };
     */
    build : function (options) {
        // logger
        var logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("AltiRequestWPS");
        logger.trace(["AltiRequestWPS::build()"]);

        // existance des options
        if (!options) {
            throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_EMPTY", "options"));
        }

        // type de requete : Altitude ou Profil
        // (param. à determiner en fonction des parametres d'entrée)
        if (!options.type) {
            throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_EMPTY", "type (Elevation or Profil)"));
        }

        // construction du modele de requête
        // (test du type d'objet candidat)
        var DataObject = null;
        switch (options.type) {
            case "Elevation":
                // surcharge
                options.wps.identifier = "gs:WPSElevation";
                DataObject = new _model_AltiElevationRequest__WEBPACK_IMPORTED_MODULE_3__["default"](options.param);
                break;
            case "Profil":
                // surcharge
                options.wps.identifier = "gs:WPSLineElevation";
                DataObject = new _model_AltiProfilRequest__WEBPACK_IMPORTED_MODULE_4__["default"](options.param);
                break;
            default:
                throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_TYPE", "type (Elevation or Profil)"));
        }

        // construction de la requête WPS
        var settings = {
            data : DataObject,
            method : options.method,
            param : options.wps
        };

        var rqstWPS = new _Formats_WPS__WEBPACK_IMPORTED_MODULE_2__["default"](settings);

        if (!rqstWPS.processRequestString()) {
            throw new Error("Enable to process request !");
        }

        return rqstWPS.requestString;
    }
};

/* harmony default export */ __webpack_exports__["default"] = (AltiRequestWPS);


/***/ }),
/* 64 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);


/**
 * @classdesc
 * Standard WPS
 *
 * @constructor
 * @alias Gp.Formats.WPS
 * @param {Object} options - options
 * @param {Object}   options.data - objet
 * @param {String}   options.method - POST|GET
 * @param {String}   options.param.service - "WPS"
 * @param {String}   options.param.version - "1.0.0"
 * @param {String}   options.param.identifier - "gs:WPSElevation|gs:WPSLineElevation"
 * @param {String}   options.param.rawdataoutput - "result"
 * @param {String}   options.param.request - "Execute"
 * @param {Function} options.onsuccess - function callback success (TODO)
 * @param {Function} options.onerror   - function callback error   (TODO)
 * @private
 */
function WPS (options) {
    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger();
    this.logger.trace("[Constructeur WPS()]");

    if (!(this instanceof WPS)) {
        throw new TypeError("WPS constructor cannot be called as a function.");
    }

    this.options = options || {};

    /**
     * Objet DATA
     */
    this.DataObject = this.options.data;

    if (!this.DataObject) {
        throw new TypeError("This data object is not defined !");
    }

    /**
     * param service.
     * Par defaut, "WPS".
     */
    this.paramservice = this.options.param.service || "WPS";

    /**
     * param version.
     * Par defaut, "1.0.0".
     */
    this.paramversion = this.options.param.version || "1.0.0";

    /**
     * param identifier
     * Par defaut, "gs:WPS"
     */
    this.paramidentifier = this.options.param.identifier || "gs:WPS";

    /**
     * param rawdataoutput
     * Par defaut, "result".
     */
    this.paramrawdataoutput = this.options.param.rawdataoutput || "result";

    /**
     * param request
     * Par defaut, "Execute".
     */
    this.paramrequest = this.options.param.request || "Execute";

    /**
     * methode.
     * Par defaut, "GET".
     */
    this.method = this.options.method || "GET";
}

WPS.prototype = {

    /**
     * @lends module:WPS#
     */

    /**
     * request
     * @type {String}
     */
    requestString : null,

    /**
     * Constructeur (alias)
     */
    constructor : WPS,

    /**
     * Template de la requête.
     */
    template : {
        get : {
            value : "service=__SERVICE__" +
                "&version=__VERSION__" +
                "&rawdataoutput=__RAWDATAOUTPUT__" +
                "&identifier=__IDENTIFIER__" +
                "&request=__REQUEST__" +
                "&datainputs=<!-- __DATAINPUTS__ -->",

            input : "__KEY__=__DATA__"

        },
        post : {

            value : "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" +
                "<wps:__REQUEST__ version=\"__VERSION__\" service=\"__SERVICE__\" " +
                "__NAMESPACE__ __SCHEMALOCATION__>" +
                "<ows:Identifier>__IDENTIFIER__</ows:Identifier>" +
                "<wps:DataInputs>" +
                "<!-- __DATAINPUTS__ -->" +
                "</wps:DataInputs>" +
                "<wps:ResponseForm>" +
                "<wps:RawDataOutput>" +
                "<ows:Identifier>__RAWDATAOUTPUT__</ows:Identifier>" +
                "</wps:RawDataOutput>" +
                "</wps:ResponseForm>" +
                "</wps:__REQUEST__>",

            input : "<wps:Input>" +
                "<ows:Identifier>__KEY__</ows:Identifier>" +
                "<wps:Data>" +
                "<wps:LiteralData>__DATA__</wps:LiteralData>" +
                "</wps:Data>" +
                "</wps:Input>"
        }
    },

    /**
     * Namespace par defaut de la requete POST.
     *
     * @returns {String} namespace
     */
    namespaceByDefault : function () {
        var ns = [
            "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"",
            "xmlns=\"http://www.opengis.net/wps/1.0.0\"",
            "xmlns:wfs=\"http://www.opengis.net/wfs\"",
            "xmlns:wps=\"http://www.opengis.net/wps/1.0.0\"",
            "xmlns:ows=\"http://www.opengis.net/ows/1.1\"",
            "xmlns:gml=\"http://www.opengis.net/gml\"",
            "xmlns:ogc=\"http://www.opengis.net/ogc\"",
            "xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\"",
            "xmlns:xlink=\"http://www.w3.org/1999/xlink\""
        ];

        return ns.join(" ");
    },

    /**
     * Schemalocation par defaut.
     *
     * @returns {String} schemaLocation
     */
    schemaLocationByDefault : function () {
        return "xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\"";
    },

    /**
     * Construction de la requête.
     *
     * @example
     * // GET  out :
     * //  service=__SERVICE__
     * //  &version=__VERSION__
     * //  &rawdataoutput=__RAWDATAOUTPUT__
     * //  &identifier=__IDENTIFIER__
     * //  &request=__REQUEST__
     * //  &datainputs="__DATAINPUTS__"
     * //  avec __DATAINPUTS__ = __KEY__=__DATA__;...
     *
     * // POST out :
     * //      <?xml version=\"1.0\" encoding=\"UTF-8\"?>
     * //      <wps:__REQUEST__ version=\"__VERSION__\" service=\"__SERVICE__\"
     * //         __NAMESPACE__ __SCHEMALOCATION__>
     * //          <ows:Identifier>__IDENTIFIER__</ows:Identifier>
     * //          <wps:DataInputs>
     * //              <!-- __DATAINPUTS__ -->
     * //          </wps:DataInputs>
     * //          <wps:ResponseForm>
     * //              <wps:RawDataOutput>
     * //              <ows:Identifier>__RAWDATAOUTPUT__</ows:Identifier>
     * //              </wps:RawDataOutput>
     * //          </wps:ResponseForm>
     * //      </wps:__REQUEST__>",
     * //      avec __DATAINPUTS__
     * //             <wps:Input>
     * //                  <ows:Identifier>__KEY__</ows:Identifier>
     * //                  <wps:Data>
     * //                    <wps:LiteralData>__DATA__</wps:LiteralData>
     * //                  </wps:Data>
     * //              </wps:Input>
     *
     * @returns {Boolean} validation de la construction de la requete
     */
    processRequestString : function () {
        this.logger.trace("WPS::processRequestString ()");

        var template = "";
        if (this.method === "POST") {
            template = this.template.post.value;
        } else if (this.method === "GET") {
            template = this.template.get.value;
        } else {
            this.logger.error("No other method supported by the service !");
            return false;
        }

        template = template.replace(/__SERVICE__/g, this.paramservice);
        template = template.replace(/__VERSION__/g, this.paramversion);
        template = template.replace(/__RAWDATAOUTPUT__/g, this.paramrawdataoutput);
        template = template.replace(/__IDENTIFIER__/g, this.paramidentifier);
        template = template.replace(/__REQUEST__/g, this.paramrequest);

        // ajout +
        if (this.method === "POST") {
            template = template.replace(/__NAMESPACE__/g, this.namespaceByDefault);
            template = template.replace(/__SCHEMALOCATION__/g, this.schemaLocationByDefault);
        }

        // ajout des datainputs
        template = template.replace(/<!-- __DATAINPUTS__ -->/g, this.__addDataInputs());

        if (!template) {
            this.logger.warn("traduction tmpl : empty request !?");
            return false;
        }

        this.requestString = template;
        this.logger.trace("traduction tmpl", template);

        return true;
    },

    /**
     * Ajout des données
     *
     * @returns {String} Données concaténées dans une chaine
     */
    __addDataInputs : function () {
        this.logger.trace("WPS::__addDataInputs ()");

        // c'est un peu grossier...
        var tmpl = this.method === "GET" ? this.template.get.input : this.template.post.input;
        var sep = this.method === "GET" ? ";" : "";

        var result = "";
        var that = this;
        var map = this.DataObject.getData();
        for (var i = 0; i < map.length; i++) {
            // FIXME closure ?
            (function (j) {
                if (sep) {
                    sep = (j === map.length - 1) ? "" : ";";
                }
                result = result.concat(that.__addDataInput(tmpl, map[j].k, map[j].v), sep);
            })(i);
        }

        return result;
    },

    /**
     * Ajout d'une donnée.
     *
     * @param {String} tmpl - template
     * @param {String} key - clef
     * @param {String} data - valeur
     * @returns {String} chaine avec les substitutions clef/valeur
     */
    __addDataInput : function (tmpl, key, data) {
        var tmp = tmpl;
        tmp = tmp.replace(/__KEY__/g, key);
        tmp = tmp.replace(/__DATA__/g, data);
        return tmp;
    },

    /**
     * Definir le mode de requête
     *
     * @param {String} method - GET|POST
     */
    setMethod : function (method) {
        if (method === "GET" || method === "POST") {
            this.method = method;
        } else {
            this.logger.warn("support only GET and POST method !");
        }
    },

    /**
     * Retourne le mode de requete (GET|POST).
     *
     * @returns {AltiRequest.options.mode|String} methode (GET|POST)
     */
    getMethod : function () {
        return this.method;
    }
};

/* harmony default export */ __webpack_exports__["default"] = (WPS);


/***/ }),
/* 65 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44);
/* harmony import */ var _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45);
/* harmony import */ var _Formats_XML__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(66);
/* harmony import */ var _Formats_AltiResponseReader__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(67);
/* harmony import */ var _model_AltiResponse__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(68);
/* harmony import */ var _model_Elevation__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(69);
/**
 * Factory pour générer une reponse JSON à partir d'un XML ou d'un JSON
 * (Factory)
 *
 * @module AltiResponseFactory
 * @private
 * @alias Gp.Services.Alti.Response.AltiResponseFactory
 */








var AltiResponseFactory = {

    /**
     * interface unique
     *
     * @method build
     * @static
     * @param {Object} options - options definies dans le composant Alti
     *
     * @example
     *   var options = {
     *      response :
     *      outputFormat :
     *      rawResponse :
     *      scope :
     *      onSuccess :
     *      onError :
     *   };
     *
     */
    build : function (options) {
        // logger
        var logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("AltiResponseFactory");
        logger.trace(["AltiResponseFactory::build()"]);

        var data = null;

        if (options.response) {
            if (options.rawResponse) {
                logger.trace("analyze response : raw");
                data = options.response;
            } else {
                switch (options.outputFormat) {
                    case "xml":
                        logger.trace("analyze response : xml");

                        try {
                            var p = new _Formats_XML__WEBPACK_IMPORTED_MODULE_3__["default"]({
                                reader : _Formats_AltiResponseReader__WEBPACK_IMPORTED_MODULE_4__["default"]
                            });

                            if (typeof options.response === "string") {
                                p.setXMLString(options.response);
                            } else {
                                p.setXMLDoc(options.response);
                            }

                            data = p.parse();

                            if (!data) {
                                throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EXCEPTION_2"));
                            }
                        } catch (e) {
                            var message = e.message;
                            options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"]({
                                message : _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EXCEPTION", message),
                                status : 200,
                                type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"].TYPE_SRVERR
                            }));
                            return;
                        }

                        break;

                    case "json":
                        logger.trace("analyze response : json");
                        logger.trace("analyze response : ", typeof options.response);

                        var JSONResponse;
                        if (typeof options.response === "string") {
                            JSONResponse = JSON.parse(options.response);
                        } else {
                            JSONResponse = options.response;
                        }

                        // le service renvoie t il une erreur ?
                        if (JSONResponse.error) {
                            // ex. {"error": {"code": "BAD_PARAMETER","description": "The values () cannot be parsed as a valid longitude (double value such as -180 < lat < 180)."}}
                            options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"]({
                                message : _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EXCEPTION", JSONResponse.error.description),
                                status : 200,
                                type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"].TYPE_SRVERR
                            }));
                            return;
                        }

                        // analyse de la reponse
                        if (JSONResponse) {
                            var elevations = JSONResponse.elevations;
                            var altiResponse = new _model_AltiResponse__WEBPACK_IMPORTED_MODULE_5__["default"]();
                            var elevation;
                            if (Array.isArray(elevations) && elevations.length) {
                                for (var i = 0; i < elevations.length; i++) {
                                    elevation = new _model_Elevation__WEBPACK_IMPORTED_MODULE_6__["default"]();

                                    if (typeof elevations[i] === "object") {
                                        // elevations[i] est un objet elevation
                                        if (elevations[i].lon) {
                                            elevation.lon = elevations[i].lon;
                                        }
                                        if (elevations[i].lat) {
                                            elevation.lat = elevations[i].lat;
                                        }
                                        if (elevations[i].z) {
                                            elevation.z = elevations[i].z;
                                        }
                                        if (elevations[i].acc) {
                                            elevation.acc = elevations[i].acc;
                                        }
                                    } else if (typeof elevations[i] === "number") {
                                        // elevations[i] est un nombre, dans le cas de zonly=true notamment
                                        elevation.z = elevations[i];
                                    }

                                    if (Array.isArray(altiResponse.elevations)) {
                                        altiResponse.elevations.push(elevation);
                                    }
                                }
                            }
                            data = altiResponse;
                        }

                        if (!data) {
                            options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"]({
                                message : _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_ANALYSE_2"),
                                type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"].TYPE_UNKERR,
                                status : -1
                            }));
                            return;
                        }
                        break;

                    default:
                        options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"]({
                            message : _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_FORMAT_2"),
                            type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"].TYPE_UNKERR,
                            status : -1
                        }));
                        return;
                }

                // Si la réponse contenait une exception renvoyée par le service
                if (data.exceptionReport) {
                    options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"]({
                        message : _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EXCEPTION", data.exceptionReport),
                        type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"].TYPE_SRVERR,
                        status : 200
                    }));
                    return;
                } else if (data.error) {
                    var errorMess = data.error.description;
                    options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"]({
                        message : _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EXCEPTION", errorMess),
                        type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"].TYPE_SRVERR,
                        status : 200
                    }));
                    return;
                }
            }
        } else {
            options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EMPTY")));
            return;
        }

        options.onSuccess.call(options.scope, data);
    }
};

/* harmony default export */ __webpack_exports__["default"] = (AltiResponseFactory);


/***/ }),
/* 66 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* global require */


// import __xmldom from "xmldom";

/**
 * @classdesc
 *
 * Classe permettant d'écrire ou de lire du XML, sous forme de document DOM,
 * éventuellement selon des clés de lecture (readers) ou d'écriture (writers) spécifiques.
 *
 * @constructor
 * @alias Gp.Formats.XML
 *
 * @param {Object} [options] - options du format XML
 *
 * @param {Object} [options.reader] - Instance d'un Reader de service (AltiResponseReader, GeocodeRequestReader, etc.)
 *      utile pour interpréter le XML lorsque sa structure est connue.
 *      Ce reader doit comporter au moins une fonction statique read (root) permettant d'initialiser la lecture.
 *
 * @param {Object} [options.writers] - writers
 *
 * @param {String} [options.xmlString] - chaîne de caractère contenant du XML à interpréter.
 *
 * @private
 */
function XML (options) {
    if (!(this instanceof XML)) {
        throw new TypeError("XML constructor cannot be called as a function.");
    }

    // FIXME : notion de singleton

    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger();
    this.logger.trace("[Constructeur XML ()]");

    /**
     * Chaîne de caractères contenant le texte XML
     * @type {String}
     */
    this.xmlString = null;

    /**
     * DOM Element correspondant à la structure du XML.
     * @type {DOMElement}
     */
    this.xmlDoc = null;

    /**
     * Objet contenant des fonctions de lecture des différentes balises XML.
     * @type {Object}
     */
    this.reader = null;

    // traitement des paramètres d'options s'il y en a
    if (options) {
        if (options.xmlString && typeof options.xmlString === "string") {
            this.xmlString = options.xmlString;
            // Si une chaine de caractère a été passée en entrée : on la transforme aussi en XML document
            this.xmlDoc = __getXMLDOC(options.xmlString);
        }
        if (options.reader) {
            this.setReader(options.reader);
        }
    }
}

XML.prototype = {

    /**
     * @lends module:XML
     */

    /*
     * Constructeur (alias)
     */
    constructor : XML,

    /**
     * Méthode permettant de récupérer la chaîne de caractères associée au format XML
     *
     * @returns {String} xmlString - la chaîne de caractères correspondant au format XML
     */
    getXMLString : function () {
        return this.xmlString;
    },

    /**
     * Méthode permettant d'attribuer une chaîne de caractères au format XML (attribut xmlString).
     * La méthode va aussi transformer cette chaîne de caractères en document XML,
     * afin de remplir l'attribut xmlDoc.
     *
     * @param {String} xmlString - la chaîne de caractères correspondant au format XML
     */
    setXMLString : function (xmlString) {
        if (xmlString && typeof xmlString === "string") {
            this.xmlString = xmlString;
            this.xmlDoc = __getXMLDOC(xmlString);
        }
    },

    /**
     * Méthode permettant de récupérer les readers associés au format XML, s'ils ont été définis
     *
     * @return {Object} readers - les readers associés au format XML, s'ils existent,
     *      sous forme d'une collection de fonctions
     */
    getReader : function () {
        return this.reader;
    },

    /**
     * Méthode permettant d'attribuer des readers, sous la forme d'un objet de fonctions (node, data),
     *      lorsqu'ils n'ont pas été définis lors de l'instanciation par exemple (new XML (options)).
     *
     * @param {Object} reader - Instance d'un Reader de service (AltiResponseReader, GeocodeRequestReader, etc.)
     *      utile pour interpréter le XML lorsque sa structure est connue.
     *      Ce reader doit comporter au moins une fonction statique read (root) permettant d'initialiser la lecture.
     */
    setReader : function (reader) {
        if (reader && reader.read && typeof reader.read === "function") {
            this.reader = reader;
        }
    },

    /**
     * Méthode permettant de récupérer le document XML associé au format, s'il existe.
     *
     * @return {DOMElement} xmlDoc - le document XML (DOM document node) s'il existe
     */
    getXMLDoc : function () {
        return this.xmlDoc;
    },

    /**
     * Setter
     */
    setXMLDoc : function (doc) {
        this.xmlDoc = doc;
    },
    /**
     * Méthode initialisant la lecture du XML, à partir d'un XML Document :
     *      création d'un objet JavaScript contenant les informations du XML,
     *      sauf dans le cas où il n'existe pas de XML Document à interpréter (retourne un objet vide).
     *
     * @return {Object} [parserOutput] - un objet JavaScript contenant les informations du XML :
     * - soit toutes les informations si aucun reader n'a été spécifié à la création du format
     * - soit les informations spécifiées dans le reader.
     */
    parse : function () {
        // build xml document from xmlString
        if (!this.xmlDoc && this.xmlString) {
            this.xmlDoc = __getXMLDOC(this.xmlString);
        }
        if (this.xmlDoc) {
            var root = __getRootNode(this.xmlDoc);
            if (root) {
                var parserOutput;
                // call reader if exists
                if (this.reader && this.reader.read) {
                    parserOutput = this.reader.read(root);
                } else {
                    parserOutput = {};
                    parserOutput[root.nodeName] = __readDefault(root);
                }
                return parserOutput;
            } else {
                return {};
            }
        }
    }

};

/**
 * Méthode de la classe (privée) permettant de créer un XML Document à partir d'une chaîne de caractères XML,
 *      en utilisant DOMParser () lorsque c'est possible.
 *      For more information, see: https://dvcs.w3.org/hg/innerhtml/raw-file/tip/index.html#the-domparser-interface
 *
 * @private
 * @memberof XML
 * @method __getXMLDOC
 * @param {String} xmlString - xml string to be converted into DOM element
 * @return {DOMElement} - the corresponding XML Document
 */
function __getXMLDOC (xmlString) {
    if (typeof window === "undefined") {
        // env. nodejs
        var DOMParser = __webpack_require__(54).DOMParser; // __xmldom.DOMParser;
        return new DOMParser().parseFromString(xmlString, "text/xml");
    } else {
        // env. browser

        var parser;
        var xmlDoc;
        var errorMsg = "Erreur lors du parsing de la réponse du service : XML non conforme";

        if (window.ActiveXObject) {
            // Internet Explorer < 9
            xmlDoc = new window.ActiveXObject("Microsoft.XMLDOM");
            xmlDoc.async = false;
            xmlDoc.loadXML(xmlString);
            var parseError = xmlDoc.parseError;
            if (parseError.errorCode) {
                if (parseError.line && parseError.linepos) {
                    errorMsg += "( ligne " + parseError.line + ", colonne " + parseError.linepos;
                }
                if (parseError.reason) {
                    errorMsg += ":  " + parseError.reason + ")";
                }
                throw new Error(errorMsg);
            }
            return xmlDoc;
        } else if (window.DOMParser) {
            // les autres (Chrome, Mozilla, IE >= 9)
            parser = new window.DOMParser();
            try {
                xmlDoc = parser.parseFromString(xmlString, "text/xml");
            } catch (e) {
                // Internet Explorer browser raises exception if xmlString is not valid XML
                if (e.message === "SyntaxError") {
                    throw new Error(errorMsg);
                } else {
                    throw new Error("Erreur lors du parsing de la réponse du service : " + e.message);
                }
            }
            // look for parsing error in case no exception was raised
            if (xmlDoc.getElementsByTagName("parsererror").length > 0) {
                var parsererror = xmlDoc.getElementsByTagName("parsererror");
                for (var i = 0; i < parsererror.length; i++) {
                    var content = parsererror[i].innerHTML;
                    // except in case parsererror is just because of huge xml, but parsing is done.
                    if (content.indexOf("Huge input lookup") === -1) {
                        errorMsg += "(" + content + ")";
                        throw new Error(errorMsg);
                    }
                }
            } else if (!xmlDoc.documentElement) { // may happen in chrome browser
                throw new Error(errorMsg);
            }
            return xmlDoc;
        } else {
            // FIXME
            throw new Error("Incompatible DOM Parser pour ce navigateur !");
        }
    }
}

/**
 * Méthode de la classe (privée) permettant de récupérer le noeud racine du document,
 *      à partir d'un document node (nodeType=9), puis lecture de ce noeud (readNode)
 *
 * @private
 * @memberof XML
 * @method __getRootNode
 * @param {DOMElement} [xmlDoc] - a Document Node
 * @return {DOMElement} root - the document root node
 */
function __getRootNode (xmlDoc) {
    var root;
    if (xmlDoc.nodeType === 9) {
        // INFO : nodeType 9 represents the entire document (the root-node of the DOM tree)
        root = xmlDoc.documentElement;
    } else if (xmlDoc.nodeType === 1) {
        root = xmlDoc;
    }
    return root;
}

/**
 * Méthode de la classe (privée) permettant de lire automatiquement un noeud XML,
 *      lorsqu'aucun reader spécifique n'a été spécifié (parser brut)
 *
 * @private
 * @memberof XML
 * @method readDefault
 * @param {DOMElement} node - a DOM element node
 * @example final data object looks like :
 *          data = {
 *              attributeName: attributeValue,
 *              childName: {
 *                  attributeName: attributeValue,
 *                  attributeName: attributeValue,
 *                  childName: {
 *                      "textContent": textContent
 *                  },
 *                  childName: {
 *                      childName: {
 *                          attributeName:attributeValue
 *                      }
 *                  }
 *              }
 *          }
 */
function __readDefault (node) {
    var data = {};

    // if element node has attributes, set their values to data
    if (node.attributes.length > 0) {
        var dataAttributes = __getAttributes(node);
        data["attributes"] = dataAttributes;
    }

    // if element node has childNodes, read them and set them to data
    if (node.hasChildNodes()) {
        var childData = {};
        var child;
        var children = node.childNodes;

        for (var i = 0; i < children.length; i++) {
            child = children[i];

            if (child.nodeType === 3) { // TEXT_NODE
                data["textContent"] = child.nodeValue;
            } else if (child.nodeType === 1) {
                childData = __readDefault(child);

                if (!data[child.nodeName]) {
                    // store childData in an object
                    data[child.nodeName] = childData;
                } else {
                    // in case several childNodes has the same name : store them in an array.
                    // if data[nodeName] already exists but is not an array
                    if (!Array.isArray(data[child.nodeName])) {
                        var old = data[child.nodeName];
                        data[child.nodeName] = [];
                        data[child.nodeName].push(old);
                    }
                    data[child.nodeName].push(childData);
                }
            }
            // TODO : manage other node types (4=CDATA, etc)
        }
    }

    return data;
}

/**
 * Méthode de la classe (privée) permettant de récupérer les attributs d'un noeud élément
 *
 * @private
 * @memberof XML
 * @method __getAttributes
 * @param {DOMElement} node - noeud contenant l'attribut recherché
 * @return {Object} nodeAttributes - objet contenant les noms et valeurs des différents attributs
 */
function __getAttributes (node) {
    if (node.attributes.length > 0) {
        var nodeAttributes = {};
        var attributes = node.attributes;
        for (var i = 0; i < attributes.length; i++) {
            var attribute = attributes[i];
            nodeAttributes[attribute.nodeName] = attribute.nodeValue;
        }
        return nodeAttributes;
    }
}

/* harmony default export */ __webpack_exports__["default"] = (XML);


/***/ }),
/* 67 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Response_model_AltiResponse__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(68);
/* harmony import */ var _Response_model_Elevation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(69);

/**
 * Fonction retournant un objet contenant des clés de lecture (readers)
 *      qui permettent de parser des réponses XML du service Altimétrique du Géoportail
 *      (calcul altimétrique simple ou profil altimétrique d'une courbe),
 *      lorsque le paramètre output = xml,
 *      afin de récupérer les élévations retournées.
 *
 * @module AltiResponseReader
 * @alias Gp.Services.Alti.Formats.AltiResponseReader
 * @private
 */

// import Logger from "../../../Utils/LoggerByDefault";



/**
 *
 * Objet AltiResponseReader
 *
 * @member {Object} AltiResponseReader
 *
 * @property {Object} AltiResponseReader.READERS - Objet contenant des fonctions de lecture, appelées "readers"
 *      dont chaque clé correspond au nom d'un tag du XML que l'on souhaite lire
 *      et la valeur associée est une fonction (node, data)
 *      où node est un noeud du document DOM
 *      et data est un objet où l'on stocke les informations lues dans le XML.
 *
 * @property {Method} AltiResponseReader.READERS.elevations -  Lecture d'un noeud "elevations" de la réponse XML
 *      du service alti, correspondant logiquement à la racine du document
 *      (contient un ou plusieurs childNodes correspondant chacun à une élévation retournée)
 *
 * @property {Method} AltiResponseReader.READERS.elevation - ecture d'un noeud "elevation" de la réponse xml du service alti.
 *      (contient un ou 4 childNode (s) correspondant à l'altitude (z) et éventuellement lat, lon, et acc)
 *
 * @property {Method} AltiResponseReader.READERS.lat - Lecture d'un noeud "lat" de la réponse xml du service alti.
 *      (contient une valeur de latitude, qui est un flottant)
 *
 * @property {Method} AltiResponseReader.READERS.lon - Lecture d'un noeud "lon" de la réponse xml du service alti.
 *      (contient une valeur de longitude, qui est un flottant)
 *
 * @property {Method} AltiResponseReader.READERS.z - Lecture d'un noeud "z" de la réponse xml du service alti.
 *      (contient une valeur d'altitude, qui est un flottant)
 *
 * @property {Method} AltiResponseReader.READERS.acc - Lecture d'un noeud "acc" de la réponse xml du service alti.
 *      (contient une valeur de précision, qui est un flottant)
 *
 * @property {Method} AltiResponseReader.READERS.exceptionreport - Lecture d'un noeud "ExceptionReport" de la réponse xml du service alti.
 *
 * @property {Method} AltiResponseReader.READERS.exception - Lecture d'un noeud "Exception" de la réponse xml du service alti.
 *
 * @property {Method} AltiResponseReader.read - Méthode permettant de lancer la lecture d'une réponse XML du service altimétrique,
 *      à l'aide des readers de la classe.
 *
 */
var AltiResponseReader = {};

AltiResponseReader.READERS = {

    /**
     * Lecture d'un noeud "elevations" de la réponse XML du service alti, correspondant logiquement à la racine du document
     *      (contient un ou plusieurs childNodes correspondant chacun à une élévation retournée)
     *
     * @param {DOMElement} root - racine de la réponse XML
     * @static
     * @memberof AltiResponseReader
     * @returns {Object} Retourne un objet de type AltiResponse
     */
    elevations : function (root) {
        // INFO : on passe en paramètre l'objet en entrée elevations, vide, à remplir.
        var altiResponse = new _Response_model_AltiResponse__WEBPACK_IMPORTED_MODULE_0__["default"]();

        if (root.hasChildNodes()) {
            var children = root.childNodes;
            var child;
            var elevation;

            for (var i = 0; i < children.length; i++) {
                child = children[i];

                if (AltiResponseReader.READERS[child.nodeName]) {
                    elevation = AltiResponseReader.READERS[child.nodeName](child);
                    altiResponse.elevations.push(elevation);
                }
            }
        }

        return altiResponse;
    },

    /**
     * Lecture d'un noeud "elevation" de la réponse xml du service alti.
     *      (contient un ou 4 childNode (s) correspondant à l'altitude (z) et éventuellement lat, lon, et acc)
     *
     * @param {DOMElement} node - noeud elevation à lire pour récupérer les informations de l'élévation retournée (z [, lon, lat, acc])
     * @return {Array} elevationResponse - format de la réponse en sortie, instance de AltiResponse
     * @static
     * @memberof AltiResponseReader
     */
    elevation : function (node) {
        var elevation = new _Response_model_Elevation__WEBPACK_IMPORTED_MODULE_1__["default"]();

        if (node.hasChildNodes()) {
            var children = node.childNodes;
            var child;
            for (var i = 0; i < children.length; i++) {
                child = children[i];
                if (AltiResponseReader.READERS[child.nodeName]) {
                    // INFO : on passe en paramètre l'objet en entrée elevation, vide, à remplir.
                    AltiResponseReader.READERS[child.nodeName](child, elevation);
                }
            }
        }
        return elevation;
    },

    /**
     * Lecture d'un noeud "lat" de la réponse xml du service alti.
     *      (contient une valeur de latitude, qui est un flottant)
     *
     * @param {DOMElement} node - noeud à lire pour récupérer la latitude
     * @param {Object} elevation - objet dans lequel stocker la latitude retournée
     * @static
     * @memberof AltiResponseReader
     */
    lat : function (node, elevation) {
        var textNode = node.firstChild;
        if (textNode && textNode.nodeType === 3) { // 3 === node.TEXT_NODE
            elevation.lat = parseFloat(textNode.nodeValue);
        } else {
            throw new Error("Erreur dans la lecture de la réponse du service : latitude attendue mais absente");
        }
    },

    /**
     * Lecture d'un noeud "lon" de la réponse xml du service alti.
     *      (contient une valeur de longitude, qui est un flottant)
     *
     * @param {DOMElement} node - noeud à lire pour récupérer la longitude
     * @param {Object} elevation - objet dans lequel stocker la longitude retournée
     * @static
     * @memberof AltiResponseReader
     */
    lon : function (node, elevation) {
        var textNode = node.firstChild;
        if (textNode && textNode.nodeType === 3) { // 3 === node.TEXT_NODE
            elevation.lon = parseFloat(textNode.nodeValue);
        } else {
            throw new Error("Erreur dans la lecture de la réponse du service : longitude attendue mais absente");
        }
    },

    /**
     * Lecture d'un noeud "z" de la réponse xml du service alti.
     *      (contient une valeur d'altitude, qui est un flottant)
     *
     * @param {DOMElement} node - noeud à lire pour récupérer l'altitude
     * @param {Object} elevation - objet dans lequel stocker l'altitude retournée
     * @static
     * @memberof AltiResponseReader
     */
    z : function (node, elevation) {
        var textNode = node.firstChild;
        if (textNode && textNode.nodeType === 3) { // 3 === node.TEXT_NODE
            if (elevation) {
                elevation.z = parseFloat(textNode.nodeValue);
            } else {
                elevation = new _Response_model_Elevation__WEBPACK_IMPORTED_MODULE_1__["default"]();
                elevation.z = parseFloat(textNode.nodeValue);
                return elevation;
            }
        } else {
            throw new Error("Erreur dans la lecture de la réponse du service : altitude attendue mais absente");
        }
    },

    /**
     * Lecture d'un noeud "acc" de la réponse xml du service alti.
     *      (contient une valeur de précision, qui est un flottant)
     *
     * @param {DOMElement} node - noeud à lire pour récupérer la précision
     * @param {Object} elevation - objet dans lequel stocker la précision retournée
     * @static
     * @memberof AltiResponseReader
     */
    acc : function (node, elevation) {
        var textNode = node.firstChild;
        if (textNode && textNode.nodeType === 3) { // 3 === node.TEXT_NODE
            elevation.acc = parseFloat(textNode.nodeValue);
        } else {
            throw new Error("Erreur dans la lecture de la réponse du service : précision (acc) attendue mais absente");
        }
    },

    /**
     * Lecture d'un noeud "ExceptionReport" de la réponse xml du service alti.
     *
     * @param {DOMElement} node - noeud à lire pour récupérer l'exception
     * @return {Object} exceptionReport - objet contenant l'exception
     * @static
     * @memberof AltiResponseReader
     */
    exceptionreport : function (node) {
        var response = {};

        if (node.hasChildNodes()) {
            var children = node.childNodes;
            var child;
            for (var i = 0; i < children.length; i++) {
                child = children[i];
                if (child.nodeName === "Exception") {
                    response.exceptionReport = AltiResponseReader.READERS.exception(child);
                }
            }
        }

        return response;
    },

    /**
     * Lecture d'un noeud "Exception" de la réponse xml du service alti.
     *
     * @param {DOMElement} node - noeud à lire pour récupérer l'exception
     * @return {Object} exceptionReport - objet contenant l'exception, avec deux attributs :
     *      {String} exceptionReport.exceptionCode - qui contient l'identifiant du code de l'exception
     *      {String} exceptionReport.exception - qui contient le message de l'exception
     * @static
     * @memberof AltiResponseReader
     */
    exception : function (node) {
        var exceptionReport = {};

        // get exception code
        var exceptionCode = node.getAttribute("exceptionCode");
        if (exceptionCode) {
            exceptionReport.exceptionCode = exceptionCode;
        }

        // get exception message
        var textNode = node.firstChild;
        if (textNode && textNode.nodeType === 3) { // 3 === node.TEXT_NODE
            exceptionReport.exception = textNode.nodeValue;
        }

        return exceptionReport;
    },

    /**
     * Lecture d'un noeud "Error" de la réponse xml du service alti.
     *
     * @param {DOMElement} node - noeud à lire pour récupérer l'exception
     * @return {Object} error - objet contenant l'exception
     * @static
     */
    error : function (node) {
        var response = {
            error : {}
        };
        // get error code and description
        if (node.hasChildNodes()) {
            var children = node.childNodes;
            var child;
            for (var i = 0; i < children.length; i++) {
                child = children[i];
                var textNode;
                // get error code
                if (child.nodeType === 1 && child.nodeName === "code") { // 1 === node.ELEMENT_NODE
                    textNode = child.firstChild;
                    if (textNode && textNode.nodeType === 3) { // 3 === node.TEXT_NODE
                        response.error.code = textNode.nodeValue;
                    }
                }
                // get error description
                if (child.nodeType === 1 && child.nodeName === "description") { // 1 === node.ELEMENT_NODE
                    textNode = child.firstChild;
                    if (textNode && textNode.nodeType === 3) { // 3 === node.TEXT_NODE
                        response.error.description = textNode.nodeValue;
                    }
                }
            }
        }
        return response;
    }

};

/**
 * Méthode permettant de lancer la lecture d'une réponse XML du service altimétrique,
 *      à l'aide des readers de la classe.
 *
 * @method AltiResponseReader.read
 * @param {DOMElement} root - racine de la réponse XML à lire
 * @static
 * @memberof AltiResponseReader
 */
AltiResponseReader.read = function (root) {
    if (root.nodeName === "elevations") {
        var altiResponse = AltiResponseReader.READERS.elevations(root);
        return altiResponse;
    } else if (root.nodeName === "ExceptionReport") {
        var exceptionReport = AltiResponseReader.READERS.exceptionreport(root);
        return exceptionReport;
    } else if (root.nodeName === "error") {
        var error = AltiResponseReader.READERS.error(root);
        return error;
    } else {
        throw new Error("Erreur lors de la lecture de la réponse : elle n'est pas au format attendu.");
    }
};

/* harmony default export */ __webpack_exports__["default"] = (AltiResponseReader);


/***/ }),
/* 68 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/**
 * Response object for {@link module:Services~getAltitude Gp.Services.getAltitude ()} invocation when successful. Received as the argument of onSuccess callback function.
 *
 * @property {Array.<Gp.Services.Alti.Elevation>} elevations - Elevations array.
 *
 * @namespace
 * @alias Gp.Services.AltiResponse
 */
function AltiResponse () {
    if (!(this instanceof AltiResponse)) {
        throw new TypeError("AltiResponse constructor cannot be called as a function.");
    }

    this.elevations = [];
}

AltiResponse.prototype = {

    constructor : AltiResponse

};

/* harmony default export */ __webpack_exports__["default"] = (AltiResponse);


/***/ }),
/* 69 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

/**
 * Single elevation object returned by underlying web service. Contains at least, one elevation (z). May also contain point coordinates and elevation accuracy if "zonly" parameter wasn't set to true.
 *
 * @property {Float} lat - Point latitude. (only if zonly=false)
 * @property {Float} lon - Point longitude. (only if zonly=false)
 * @property {Float} z - Point elevation.
 * @property {Float} acc - Accuracy of elevation for this point. (only if zonly=false)
 *
 * @namespace
 * @alias Gp.Services.Alti.Elevation
 */
function Elevation () {
    if (!(this instanceof Elevation)) {
        throw new TypeError("Elevation constructor cannot be called as a function.");
    }

    this.z = null;
}

Elevation.prototype = {

    constructor : Elevation

};

/* harmony default export */ __webpack_exports__["default"] = (Elevation);


/***/ }),
/* 70 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44);
/* harmony import */ var _Utils_Helper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(47);
/* harmony import */ var _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(45);
/* harmony import */ var _DefaultUrlService__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(56);
/* harmony import */ var _CommonService__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(46);
/* harmony import */ var _Response_AutoConfResponseFactory__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(71);









/**
 * @classdesc
 * Appel du service d'autoconfiguration du Géoportail
 *
 * @private
 * @constructor
 * @extends {Gp.Services.CommonService}
 * @alias Gp.Services.AutoConf
 *
 * @param {Object} options - options spécifiques au service (+ les options heritées)
 *
 * @param {String} [options.layerId] - Le nom de l'agrégat (couche) dont on veut connaître les informations détaillées.
 *      La présence de cette propriété implique l'utilisation de la deuxième opération du service pour accéder aux informations d'une couche aggrégée.
 *      Dans ce cas, la fonction effectuera quand même dans un premier temps la récupération des informations de l'auto-
 *      configuration complète, sauf si un premier appel à l'autoconf a déjà été fait avec cette clé (i.e. si la variable globale est définie
 *      pour la clé de contrat). Elle ira ensuite chercher les informations des couches agrégées, qui seront ajoutées à la variable globale Gp.Config.
 *
 * @example
 *   var options = {
 *      // options communes aux services
 *      apiKey : "apikey",
 *      protocol : 'JSONP', // JSONP|XHR
 *      timeOut : 10000, // ms
 *      rawResponse : false, // true|false
 *      scope : null, // this
 *      onSuccess : function (response) {},
 *      onFailure : function (error) {},
 *      layerId : "ORTHOIMAGERY.ORTHOPHOTOS.3D$GEOPORTAIL:OGC:WMTS@aggregate"
 *   };
 */
function AutoConf (options) {
    if (!(this instanceof AutoConf)) {
        throw new TypeError(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("CLASS_CONSTRUCTOR", "AutoConf"));
    }

    /**
     * Nom de la classe (heritage)
     * FIXME instance ou classe ?
     */
    this.CLASSNAME = "AutoConf";

    // Autoconf default protocol remains JSONP (#see http://ignf.github.io/geoportal-access-lib/latest/jsdoc/tutorial-optimize-getconfig.html)
    if (!options) {
        options = {};
    }
    options.protocol = options.protocol || "JSONP";

    // appel du constructeur par heritage
    _CommonService__WEBPACK_IMPORTED_MODULE_5__["default"].apply(this, arguments);

    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("Gp.Services.AutoConf");
    this.logger.trace("[Constructeur AutoConf (options)]");

    // #####################
    // analyse des options
    // #####################

    // gestion de l'url du service par defaut
    if (!this.options.serverUrl) {
        // si l'url n'est pas renseignée, il faut utiliser les urls par defaut
        // en fonction du nombre de clés en entrée et du paramètre layerId
        if (!this.options.serverUrl) {
            var lstUrlByDefault = _DefaultUrlService__WEBPACK_IMPORTED_MODULE_4__["default"].AutoConf.url(this.options.apiKey);

            if (!this.options.layerId) {
                // cas d'une autoconf simple
                if (Array.isArray(this.options.apiKey) && this.options.apiKey.length > 0) {
                    // cas d'un tableau de clés en entrée
                    this.options.serverUrl = lstUrlByDefault.apiKeys;
                } else {
                    this.options.serverUrl = lstUrlByDefault.apiKey;
                }
            } else {
                // cas d'une autoconf pour des couches aggrégées
                this.options.serverUrl = lstUrlByDefault.aggregate + this.options.layerId;
            }
        }
    }

    // INFO
    // le service ne repond pas en mode POST (405 Method Not Allowed)
    if (this.options.protocol === "XHR" && this.options.httpMethod === "POST") {
        this.logger.warn("Le service ne gére pas le mode d'interrogation en POST, on bascule sur du GET !");
        this.options.httpMethod = "GET"; // on surcharge !
    }

    // #####################
    // attributs d'instances
    // #####################

    /**
     * Format forcé de la réponse du service : "xml"
     * sauf si l'on souhaite une reponse brute (options.rawResponse)
     */
    this.options.outputFormat = (this.options.rawResponse) ? "" : "xml";
}

/**
 * @lends module:AutoConf#
 */

AutoConf.prototype = Object.create(_CommonService__WEBPACK_IMPORTED_MODULE_5__["default"].prototype, {
    // todo
    // getter/setter
});

/*
 * Constructeur (alias)
 */
AutoConf.prototype.constructor = AutoConf;

/**
 * Création de la requête (overwrite)
 *
 * @param {Function} error   - callback des erreurs
 * @param {Function} success - callback de succès de la création de la requête
 */
AutoConf.prototype.buildRequest = function (error, success) {
    var scope = typeof window !== "undefined" ? window : {};

    if (scope.Gp && scope.Gp.Config && scope.Gp.Config.generalOptions && scope.Gp.Config.layers) {
        if (scope.Gp.Config.generalOptions.apiKeys[this.options.apiKey]) {
            if (this.options.layerId) { // cas d'une autoconf + détaillée sur une couche agrégée
                if (scope.Gp.Config.layers[this.options.layerId] && scope.Gp.Config.layers[this.options.layerId].aggregatedLayers) {
                    this.logger.warn("Gp.Config existe déjà pour cette clé et cette couche");
                    this.options.onSuccess.call(this, scope.Gp.Config);
                    return;
                }
            } else {
                this.logger.warn("Gp.Config existe déjà pour cette clé");
                this.options.onSuccess.call(this, scope.Gp.Config);
                return;
            }
        }
    }

    // requete par defaut
    this.request = "";

    // gestion de l'autoconf local
    // Le fichier en local doit respecter le format de sortie du service.
    //  - En XHR, le format est en xml
    //  - En JSONP, le format est en xml encapsulé dans un json avec une fonction de callback
    //    ex. callback ({"http":{"status":200,"error":null},"xml":"..."})
    var bLocal;
    if (this.options.serverUrl.indexOf("http://") === -1) {
        bLocal = true;
    } else {
        bLocal = false;
    }

    // FIXME param. KVP optionnel sur un service uniquement (pas sur un autoconf local !)
    if (!bLocal && this.layerId) {
        this.request = _Utils_Helper__WEBPACK_IMPORTED_MODULE_2__["default"].normalyzeParameters({
            layerId : this.layerId
        });
    }

    // normalement pas d'erreur d'autoconf...
    (this.request || this.request === "")
        ? success.call(this, this.request)
        : error.call(this, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_3__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_REQUEST_BUILD")));
};

/**
 * Analyse de la reponse (overwrite)
 *
 * @param {Function} error   - callback des erreurs
 * @param {Function} success - callback de succès de l'analyse de la réponse
 */
AutoConf.prototype.analyzeResponse = function (error, success) {
    if (this.response) {
        var options = {
            layerId : this.options.layerId,
            response : this.response,
            rawResponse : this.options.rawResponse,
            onSuccess : success,
            onError : error,
            scope : this
        };

        _Response_AutoConfResponseFactory__WEBPACK_IMPORTED_MODULE_6__["default"].build(options);
    } else {
        error.call(this, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_3__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EMPTY")));
    }
};

/* harmony default export */ __webpack_exports__["default"] = (AutoConf);


/***/ }),
/* 71 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44);
/* harmony import */ var _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45);
/* harmony import */ var _Formats_XML__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(66);
/* harmony import */ var _Formats_AutoConfResponseReader__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(72);
/**
 * Factory pour générer une reponse JSON à partir d'un XML
 *
 * @module AutoConfReponseFactory
 * @private
 * @alias Gp.Services.AutoConf.Response.AutoConfResponseFactory
 * @todo gérer le cas du JSONP qui encapsule du XML ?
 */






var AutoConfReponseFactory = {

    /**
     * interface unique
     * Fabrique d'analyse des réponses (xml) du service d'autoconfiguration.
     * Création d'un format XML, auquel on associe un reader et une chaîne XML, et qui renverra un objet JavaScript correspondant.
     * Si une erreur est levée lors de l'analyse, ou si l'objet est vide ou contient une exception : appel de la fonction de callback onError
     * Sinon, appel de la fonction de callback onSuccess (définies dans Autoconf.analyzeResponse)
     *
     * @method build
     * @static
     * @param {Object} options - options definies dans le composant AutoConf
     *
     * @example
     *   var options = {
     *      layerId :
     *      response :
     *      rawResponse :
     *      scope :
     *      onSuccess :
     *      onError :
     *   };
     */
    build : function (options) {
        // logger
        var logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("AutoConfResponseFactory");
        logger.trace(["AutoConfResponseFactory::build()"]);

        // data de type AutoConfResponse
        var data = null;

        if (options.response) {
            if (options.rawResponse) {
                data = options.response;
            } else {
                try {
                    var p = new _Formats_XML__WEBPACK_IMPORTED_MODULE_3__["default"]({
                        reader : _Formats_AutoConfResponseReader__WEBPACK_IMPORTED_MODULE_4__["default"]
                    });

                    if (typeof options.response === "string") {
                        p.setXMLString(options.response);
                    } else {
                        p.setXMLDoc(options.response);
                    }

                    data = p.parse();
                } catch (e) {
                    // si une exception a été levée, on appelle le callback d'erreur avec le message renvoyé
                    var message = e.message;
                    if (typeof options.response === "string") {
                        message += "\n (raw response service'" + options.response + "')";
                    } else {
                        message += "\n (raw response service'" + options.response.documentElement.innerHTML + "')";
                    }

                    options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"]({
                        message : _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EXCEPTION", message),
                        status : 200,
                        type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"].TYPE_SRVERR
                    }));
                    return;
                }

                // Si la réponse est vide, on appelle le callback d'erreur
                var isEmpty = true;
                for (var key in data) {
                    if (data.hasOwnProperty(key)) {
                        isEmpty = false;
                    }
                }
                if (isEmpty) {
                    options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EMPTY_2")));
                    return;
                }

                // Si la réponse contenait une exception renvoyée par le service, on appelle le callback d'erreur
                if (data.exceptionReport) {
                    options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"]({
                        message : _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EXCEPTION", data.exceptionReport),
                        type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"].TYPE_SRVERR,
                        status : 200
                    }));
                    return;
                }
            }
        } else {
            // si la réponse (xmlString) est vide, on appelle le callback d'erreur
            options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EMPTY")));
            return;
        }

        // définition de la variable globale Gp.Config à partir de la réponse
        var scope = typeof window !== "undefined" ? window : {};

        if (!scope.Gp) {
            scope.Gp = {};
        }
        if (!scope.Gp.Config) {
            scope.Gp.Config = data;
        } else {
            this.mergeConfig(scope.Gp.Config, data, options.layerId);
        }

        // si tout s'est bien passé, on appelle le callback de succès
        options.onSuccess.call(options.scope, scope.Gp.Config);
    },

    /**
     * Fonction utilisée dans le cas où l'autoconfiguration est appelée plusieurs fois
     * (par exemple pour des clés différentes ou pour des infos sur une couche agrégée)
     *
     * @method mergeConfig
     * @static
     * @param {Object} GpConfig - Variable Gp.Config préexistante
     * @param {Object} data - la nouvelle réponse de l'autoconf, à fusionner avec GpConfig
     * @param {String} [layerId] - l'identifiant d'une couche agrégée dans le cas d'une 2è opération de l'autoconf
     */
    mergeConfig : function (GpConfig, data, layerId) {
        if (data && GpConfig) {
            // on boucle sur les propriétés (generalOptions, layers, projections, services, tileMatrixSets, territories)
            for (var prop in data) {
                if (data.hasOwnProperty(prop)) {
                    // on récupère la nouvelle clé dans generalOptions
                    if (prop === "generalOptions") {
                        for (var key in data[prop].apiKeys) {
                            if (data[prop].apiKeys.hasOwnProperty(key) && !GpConfig.generalOptions.apiKeys[key]) {
                                GpConfig.generalOptions.apiKeys[key] = data[prop].apiKeys[key];
                            }
                        }
                        // on récupère les nouveaux objets (TMS, layers, projections...)
                    } else {
                        if (GpConfig[prop]) {
                            for (var obj in data[prop]) {
                                if (data[prop].hasOwnProperty(obj) && !GpConfig[prop][obj]) {
                                    GpConfig[prop][obj] = data[prop][obj];
                                }
                            }
                        }
                    }
                }
            }

            // dans le cas d'une autoconf pour une couche agrégée, on récupère l'info
            if (layerId) {
                var aggregatedLayers = [];

                for (var lyr in data.layers) {
                    if (data.layers.hasOwnProperty(lyr)) {
                        aggregatedLayers.push(lyr);
                    }
                }

                if (GpConfig.layers[layerId]) {
                    GpConfig.layers[layerId].aggregatedLayers = aggregatedLayers;
                }
            }
        }
    }
};

/* harmony default export */ __webpack_exports__["default"] = (AutoConfReponseFactory);


/***/ }),
/* 72 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Response_model_AutoConfResponse__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(73);
/* harmony import */ var _Response_model_Constraint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(74);
/* harmony import */ var _Response_model_Format__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(75);
/* harmony import */ var _Response_model_Layer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(76);
/* harmony import */ var _Response_model_Legend__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(77);
/* harmony import */ var _Response_model_Metadata__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(78);
/* harmony import */ var _Response_model_Originator__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(79);
/* harmony import */ var _Response_model_Service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(80);
/* harmony import */ var _Response_model_Style__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(81);
/* harmony import */ var _Response_model_Territory__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(82);
/* harmony import */ var _Response_model_Thematic__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(83);
/* harmony import */ var _Response_model_TileMatrixSet__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(84);
/* harmony import */ var _Response_model_TileMatrix__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(85);
/* harmony import */ var _Response_model_TileMatrixLimit__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(86);

/**
 * Fonction retournant un objet contenant des clés de lecture (readers)
 *      qui permettent de parser des réponses XML du service d'autoconfiguration du Géoportail
 *      afin de récupérer les informations retournées.
 * @module AutoConfResponseReader
 * @private
 * @alias Gp.Services.AutoConf.Formats.AutoConfResponseReader
 */

// import Logger from "../../../Utils/LoggerByDefault";















var AutoConfResponseReader = {};

/**
 * version du service d'autoconf
 */
AutoConfResponseReader.VERSION = "1.1.0";

/**
 * Objet stockant les différents namespaces et les URI associées
 */
AutoConfResponseReader.NAMESPACES = {
    xmlns : "http://www.opengis.net/context",
    gpp : "http://api.ign.fr/geoportail",
    ows : "http://www.opengis.net/ows/1.1",
    sld : "http://www.opengis.net/sld",
    wmts : "http://www.opengis.net/wmts/1.0",
    xlink : "http://www.w3.org/1999/xlink",
    xsi : "http://www.w3.org/2001/XMLSchema-instance"
};

/**
 * Localisation (URL) du schema de définition du XML (XSD)
 */
AutoConfResponseReader.SCHEMALOCATION = [
    "http://www.opengis.net/context http://wxs.ign.fr/schemas/extContext.xsd http://api.ign.fr/geoportail http://wxs.ign.fr/schemas/autoconf/autoconf.xsd",
    "http://www.opengis.net/context http://wxs.ign.fr/schemas/extContext.xsd http://api.ign.fr/geoportail http://wxs.ign.fr/schemas/autoconf.xsd"
];

/**
 * Namespace par défaut du format
 */
AutoConfResponseReader.DEFAULTPREFIX = "context";

/**
 * Objet contenant des fonctions de lecture, appelées "READERS"
 *      dont chaque clé correspond au nom d'un tag du XML que l'on souhaite lire
 *      et la valeur associée est une fonction (node, data)
 *      où node est un noeud du document DOM
 *      et data est un objet où l'on stocke les informations lues dans le XML.
 */
AutoConfResponseReader.READERS = {

    context : {

        /** ViewContext */
        ViewContext : function (viewContextNode) {
            // info : balise "racine" de la réponse de l'autoconf

            // vérification de la version du service, et des namespaces de l'en-tête
            __checkServiceAttributes(viewContextNode);

            // create AutoConfResponse
            var config = new _Response_model_AutoConfResponse__WEBPACK_IMPORTED_MODULE_0__["default"]();

            __getChildNodes(viewContextNode, config);

            return config;
        },

        // info : /General/Title
        // ou : /LayerList/Layer/Title
        /** Title */
        Title : function (titleNode, data) {
            if (data && data.generalOptions) { // cas de la variable config générale
                data.generalOptions.title = __getChildValue(titleNode);
            } else if (data && data.lyr) { // cas d'une layer
                data.lyr.title = __getChildValue(titleNode);
            }
        },

        // info : /LayerList/Layer/Abstract
        /** Abstract */
        Abstract : function (node, data) {
            if (data && data.lyr) {
                data.lyr.description = __getChildValue(node);
            }
        },

        // info : /General/Extension/gpp:General/gpp:Services/Server
        // ou : /LayerList/Server
        /** Server */
        Server : function (node, data) {
            var serverId = node.getAttribute("service");
            var title = node.getAttribute("title");
            var version = node.getAttribute("version");
            if (serverId) {
                if (data && data.services && typeof data.services === "object" && !data.services[serverId]) {
                    // on est dans la balise Services
                    var s = new _Response_model_Service__WEBPACK_IMPORTED_MODULE_7__["default"]();
                    s.title = title;
                    s.version = version;
                    // récupération de l'url du service, dans une balise enfant "OnlineResource"
                    __getChildNodes(node, s);
                    // ajout du service à la variable config
                    data.services[serverId] = s;
                } else if (data && data.lyr) {
                    // on est dans la balise Layer
                    if (!data.lyr.serviceParams) {
                        // si l'objet serviceParams n'a pas encore été créé, on le crée.
                        data.lyr.serviceParams = {};
                    }
                    data.lyr.serviceParams.id = serverId;
                    data.lyr.serviceParams.version = version;
                }
            }
        },

        // info : /General/Extension/gpp:General/gpp:Services/Server/OnlineResource
        // ou : /LayerList/Layer/Server/OnlineResource
        // ou : /LayerList/Layer/Extention/gpp:Layer/gpp:QuickLook/OnlineResource
        // ou : /LayerList/Layer/Extension/gpp:Layer/gpp:Legends/gpp:Legend/gpp:LegendURL/OnlineResource
        // ou : /LayerList/Layer/Extension/gpp:Layer/gpp:MetadataURL/OnlineResource
        /** OnlineResource */
        OnlineResource : function (node, service) {
            if (service && service.hasOwnProperty("serverUrl")) {
                service.serverUrl = node.getAttribute("xlink:href");
            }
        },

        // info : /LayerList
        /** LayerList */
        LayerList : function (layerListNode, config) {
            // liste de balises "layer"
            __getChildNodes(layerListNode, config);

            if (config && config.layers && config.generalOptions && config.services) {
                // récupération des clés et des couches associées
                for (var lyr in config.layers) {
                    if (config.layers.hasOwnProperty(lyr)) {
                        var layerConfig = config.layers[lyr];

                        // récupération de la clé associée
                        var apiKeys = layerConfig.apiKeys;
                        if (apiKeys && Array.isArray(apiKeys)) {
                            for (var i = 0; i < apiKeys.length; i++) {
                                // pour chaque clé API, on ajoute la couche
                                var key = apiKeys[i];
                                if (config.generalOptions.apiKeys) {
                                    if (!config.generalOptions.apiKeys[key] || !Array.isArray(config.generalOptions.apiKeys[key])) {
                                        config.generalOptions.apiKeys[key] = [];
                                    }
                                    config.generalOptions.apiKeys[key].push(lyr);
                                }
                            }
                        }

                        // récupération du service associé
                        var serviceParams = layerConfig.serviceParams;
                        if (serviceParams && serviceParams.id) {
                            if (!config.services[serviceParams.id]) {
                                var s = new _Response_model_Service__WEBPACK_IMPORTED_MODULE_7__["default"]();
                                if (serviceParams.serverUrl) {
                                    s.serverUrl = serviceParams.serverUrl;
                                }
                                if (serviceParams.version) {
                                    s.version = serviceParams.version;
                                }
                                config.services[serviceParams.id] = s;
                            }
                        }

                        // récupération de la projection associée (dans le cas d'une couche WMTS)
                        if (layerConfig.wmtsOptions && layerConfig.wmtsOptions.tileMatrixSetLink && config.tileMatrixSets) {
                            var tmsLink = layerConfig.wmtsOptions.tileMatrixSetLink;
                            var tileMatrixSets = config.tileMatrixSets;
                            for (var tms in tileMatrixSets) {
                                if (tileMatrixSets.hasOwnProperty(tms) && tms === tmsLink) {
                                    layerConfig.defaultProjection = tileMatrixSets[tms].projection;
                                }
                            }
                        }
                    }
                }
            }
        },

        // info : /LayerList/Layer
        /** Layer */
        Layer : function (layerNode, config) {
            if (config && config.layers) {
                var lyrData = {
                    lyr : new _Response_model_Layer__WEBPACK_IMPORTED_MODULE_3__["default"](),
                    lyrId : null
                };

                var hidden = layerNode.getAttribute("hidden");
                if (hidden === "1") {
                    lyrData.lyr.hidden = true;
                } else {
                    lyrData.lyr.hidden = false;
                }

                var queryable = layerNode.getAttribute("queryable");
                if (queryable === "1") {
                    lyrData.lyr.queryable = true;
                } else {
                    lyrData.lyr.queryable = false;
                }

                // on peut avoir les balises : Server, Name, Title, Abstract, DataURL, MetadataURL,
                // sld:MinScaleDenominator, sld:MaxScaleDenominator, SRS, FormatList, StyleList
                // DimensionList, Extension
                __getChildNodes(layerNode, lyrData);

                // si on a bien récupéré l'identifiant de la couche, on s'en sert pour l'ajouter au tableau associatif des couches disponibles
                if (lyrData.lyrId) {
                    // Dans le cas des services, on modifie le contexte de l'identifiant.
                    if (lyrData.lyr.serviceParams && lyrData.lyr.serviceParams.id) {
                        var serviceid = lyrData.lyr.serviceParams.id;
                        if (serviceid.toUpperCase().indexOf("OPENLS") !== -1 || serviceid.toUpperCase().indexOf("ELEVATION") !== -1) {
                            // Il faut changer l'identifiant de la ressource.
                            var resourceId = lyrData.lyrId.split("$")[0];
                            lyrData.lyrId = resourceId + "$" + serviceid;
                        }
                    }

                    // on ajoute l'information dans les attributs de la couche
                    lyrData.lyr.layerId = lyrData.lyrId;
                    // et dans le tableau Gp.Config.layers
                    config.layers[lyrData.lyrId] = lyrData.lyr;
                }
            }
        },

        // info : /LayerList/Layer/Name
        /** TODO : jsdoc block */
        Name : function (node, lyrData) {
            if (lyrData && lyrData.lyr) {
                lyrData.lyr.name = __getChildValue(node);
            }
        },

        // info : /LayerList/Layer/SRS (dans le cas des couches WMS ou WFS)
        /** TODO : jsdoc block */
        SRS : function (node, lyrData) {
            // on récupère la projection de la couche (SRS)
            if (lyrData && lyrData.lyr) {
                lyrData.lyr.defaultProjection = __getChildValue(node);
            }
        },

        // info : /LayerList/Layer/FormatList/Format
        /** TODO : jsdoc block */
        Format : function (node, lyrData) {
            if (lyrData && lyrData.lyr) {
                var f = new _Response_model_Format__WEBPACK_IMPORTED_MODULE_2__["default"]();
                var current = node.getAttribute("current");
                if (current === "1") {
                    f.current = true;
                } else {
                    f.current = false;
                }
                f.name = __getChildValue(node);
                // si on n'a pas encore ajouté de format, on crée le tableau vide
                if (!lyrData.lyr.formats || !Array.isArray(lyrData.lyr.formats)) {
                    lyrData.lyr.formats = [];
                }
                lyrData.lyr.formats.push(f);
            }
        },

        // info : /LayerList/Layer/StyleList/Style
        /** TODO : jsdoc block */
        Style : function (node, lyrData) {
            if (lyrData && lyrData.lyr) {
                var s = new _Response_model_Style__WEBPACK_IMPORTED_MODULE_8__["default"]();
                var current = node.getAttribute("current");
                if (current === "1" || current === 1) {
                    s.current = true;
                } else {
                    s.current = false;
                }
                if (node.hasChildNodes) {
                    var children = node.childNodes;
                    var child;
                    var childName;
                    for (var i = 0; i < children.length; i++) {
                        child = children[i];
                        if (child.nodeType === 1) { // 1 === node.ELEMENT_NODE
                            childName = child.localName || child.baseName || child.nodeName;
                            if (childName === "Name") {
                                s.name = __getChildValue(child);
                            } else if (childName === "Title") {
                                s.title = __getChildValue(child);
                            } else if (childName === "URL") {
                                s.url = __getChildValue(child);
                            }
                        }
                    }
                }
                // si on n'a pas encore ajouté de style, on crée le tableau vide
                if (!lyrData.lyr.styles || !Array.isArray(lyrData.lyr.styles)) {
                    lyrData.lyr.styles = [];
                }
                lyrData.lyr.styles.push(s);
            }
        },

        // info : /LayerList/Layer/DimensionList/Dimension
        /** TODO : jsdoc block */
        Dimension : function (node, lyrData) {
            // possède des attributs obligatoires : name, units, unitSymbol et userValue
            // et d'autres attributs facultatifs : default, multipleValues, nearestValue, current
            var name = node.getAttribute("name");
            var dim = __getChildValue(node);
            if (lyrData && lyrData.lyr) {
                // si on n'a pas encore ajouté de dimension, on crée l'objet vide
                if (!lyrData.lyr.dimensions) {
                    lyrData.lyr.dimensions = {};
                }
                if (name === "Type") {
                    lyrData.lyr.dimensions.type = dim;
                } else if (name === "VisibilityRange") {
                    lyrData.lyr.dimensions.visibilityRange = dim;
                } else if (name === "VisibilityMode ") {
                    lyrData.lyr.dimensions.visibilityMode = dim;
                } else if (name === "GeometricType") {
                    lyrData.lyr.dimensions.geometricType = dim;
                } else if (name === "NoDataValue") {
                    lyrData.lyr.dimensions.noDataValue = dim;
                }
            }
        }

    },

    gpp : {

        // info : /General/Extension/gpp:General/gpp:Theme
        /** TODO : jsdoc block */
        Theme : function (themeNode, config) {
            if (config && config.generalOptions && config.generalOptions.hasOwnProperty("theme")) {
                config.generalOptions.theme = __getChildValue(themeNode);
            }
        },

        // info : /General/Extension/gpp:General/gpp:defaultGMLGFIStyleUrl
        /** TODO : jsdoc block */
        defaultGMLGFIStyleUrl : function (node, config) {
            if (config && config.generalOptions && config.generalOptions.hasOwnProperty("defaultGMLGFIStyle")) {
                config.generalOptions.defaultGMLGFIStyle = __getChildValue(node);
            }
        },

        // info : /General/Extension/gpp:General/gpp:Territories/gpp:Territory
        /** TODO : jsdoc block */
        Territory : function (territoryNode, config) {
            // info : Information to configure the API for this territory
            var tid = territoryNode.getAttribute("id");
            if (tid) {
                // create a new Territory
                var t = new _Response_model_Territory__WEBPACK_IMPORTED_MODULE_9__["default"]();

                var isDefault = territoryNode.getAttribute("default");
                if (isDefault === "1") {
                    t.isDefault = true;
                } else {
                    t.isDefault = false;
                }
                // read territory informations
                __getChildNodes(territoryNode, t);
                // add territory to config
                if (config && config.territories && typeof config.territories === "object") {
                    config.territories[tid] = t;
                }
            }
        },

        // info : /General/Extension/gpp:General/gpp:Territories/gpp:Territory/gpp:defaultCRS
        /** TODO : jsdoc block */
        defaultCRS : function (node, territory) {
            // info : Identifier for the default Coordinate Reference System (CRS).
            if (territory && territory.hasOwnProperty("defaultCRS")) {
                territory.defaultCRS = __getChildValue(node);
            }
        },

        // info : /General/Extension/gpp:General/gpp:Territories/gpp:Territory/gpp:AdditionalCRS
        // ou : /LayerList/Extension/gpp:Layer/gpp:AdditionalCRS
        /** TODO : jsdoc block */
        AdditionalCRS : function (node, data) {
            // info : Identifier for additional Coordinate Reference System (CRS).
            // info : data peut être une instance de Territory.js, ou une instance de Layer.js
            var addCRS = __getChildValue(node);
            if (addCRS && data) {
                if (Array.isArray(data.additionalCRS)) { // cas d'un territoire
                    data.additionalCRS.push(addCRS);
                } else { // cas d'une couche
                    // si le tableau n'est pas encore créé
                    if (!data.additionalProjections || !Array.isArray(data.additionalProjections)) {
                        data.additionalProjections = [];
                    }
                    data.additionalProjections.push(addCRS);
                }
            }
        },

        // info : /General/Extension/gpp:General/gpp:Territories/gpp:Territory/gpp:DefaultLayer
        /** TODO : jsdoc block */
        DefaultLayer : function (node, territory) {
            var lyr = node.getAttribute("layerId");
            if (lyr && territory && Array.isArray(territory.defaultLayers)) {
                territory.defaultLayers.push(lyr);
            }
        },

        // info : /General/Extension/gpp:General/gpp:Territories/gpp:Territory/gpp:BoundingBox
        // ou : /LayerList/Extension/gpp:Layer/gpp:BoundingBox
        // ou : /LayerList/Layer/Extension/gpp:Layer/gpp:Constraints/gpp:Constraint/gpp:BoundingBox
        // ou : /LayerList/Extension/gpp:Layer/gpp:Originators/gpp:Originator/gpp:Constraints/gpp:Constraint/gpp:BoundingBox
        /** TODO : jsdoc block */
        BoundingBox : function (node, data) {
            if (data) {
                var values = __getChildValue(node).split(",");
                if (values.length === 4) {
                    // get bbox coordinates (wgs84)
                    var bbox = {
                        left : parseFloat(values[0]),
                        right : parseFloat(values[2]),
                        top : parseFloat(values[3]),
                        bottom : parseFloat(values[1])
                    };
                    // get temporal extent params (constraint or layer)
                    var minT = node.getAttribute("minT");
                    var maxT = node.getAttribute("maxT");

                    if (data.hasOwnProperty("geoBBOX")) { // cas d'un territoire
                        data.geoBBOX = bbox;
                    } else if (data.hasOwnProperty("bbox")) { // cas d'une constraint
                        if (data.bbox.left || data.bbox.right || data.bbox.top || data.bbox.bottom) {
                            // si on a déjà une bbox, il faut stocker d'autres contraintes
                            if (!data.multiConstraints) {
                                data.multiConstraints = [];
                            }
                            var newConstraint = new _Response_model_Constraint__WEBPACK_IMPORTED_MODULE_1__["default"]();
                            newConstraint.bbox = bbox;
                            newConstraint.temporalExtent = [minT, maxT];
                            data.multiConstraints.push(newConstraint);
                        } else {
                            // contrainte classique
                            data.bbox = bbox;
                            data.temporalExtent = [minT, maxT];
                        }
                    } else { // cas d'une layer
                        if (!data.globalConstraint) {
                            data.globalConstraint = new _Response_model_Constraint__WEBPACK_IMPORTED_MODULE_1__["default"]();
                        }
                        data.globalConstraint.bbox = bbox;
                        data.globalConstraint.temporalExtent = [minT, maxT];
                    }
                }
            }
        },

        // info : /General/Extension/gpp:General/gpp:Territories/gpp:Territory/gpp:Resolution
        /** TODO : jsdoc block */
        Resolution : function (node, territory) {
            // info : The default resolution to display on this territory, in CRS coordinate system
            var res = __getChildValue(node);
            if (res && territory && territory.defaultOptions && territory.defaultOptions.hasOwnProperty("resolution")) {
                territory.defaultOptions.resolution = parseFloat(res);
            }
        },

        // info : /General/Extension/gpp:General/gpp:Territories/gpp:Territory/gpp:Center/gpp:x
        /** TODO : jsdoc block */
        x : function (node, territory) {
            var lon = __getChildValue(node);
            if (lon && territory && territory.geoCenter && territory.geoCenter.hasOwnProperty("lon")) {
                territory.geoCenter.lon = parseFloat(lon);
            }
        },

        // info : /General/Extension/gpp:General/gpp:Territories/gpp:Territory/gpp:Center/gpp:y
        /** TODO : jsdoc block */
        y : function (node, territory) {
            var lat = __getChildValue(node);
            if (lat && territory && territory.geoCenter && territory.geoCenter.hasOwnProperty("lat")) {
                territory.geoCenter.lat = parseFloat(lat);
            }
        },

        // info : /General/Extension/gpp:General/gpp:Resolutions
        /** TODO : jsdoc block */
        Resolutions : function (resNode, config) {
            // info : List of resolutions in CRS:84 (comma separated values)
            if (config && config.generalOptions && config.generalOptions.hasOwnProperty("wgs84Resolutions")) {
                config.generalOptions.wgs84Resolutions = __getChildValue(resNode).split(",");
            }
        },

        // info : /LayerList/Layer/Extension/gpp:Layer
        /** TODO : jsdoc block */
        Layer : function (node, lyrData) {
            // attributs : id, opacity, order, visibleInCatalog, aggregate, more
            if (lyrData && lyrData.hasOwnProperty("lyrId") && lyrData.lyr) {
                lyrData.lyrId = node.getAttribute("id");
                var aggregate = node.getAttribute("aggregate");
                var more = node.getAttribute("more");
                if (aggregate || more) {
                    lyrData.lyr.isAggregate = true;
                }
                __getChildNodes(node, lyrData.lyr);
            }
        },

        // info : /LayerList/Layer/Extension/gpp:Layer/gpp:Constraints/gpp:Constraint
        // ou : /LayerList/Extension/gpp:Layer/gpp:Originators/gpp:Originator/gpp:Constraints/gpp:Constraint
        /** TODO : jsdoc block */
        Constraint : function (node, data) {
            var c = new _Response_model_Constraint__WEBPACK_IMPORTED_MODULE_1__["default"]();
            __getChildNodes(node, c);
            if (data) {
                // on peut être dans le cas d'un originator ou d'une layer, tous les deux ont l'attribut constraints
                if (!data.constraints || !Array.isArray(data.constraints)) {
                    data.constraints = [];
                }

                // cas de plusieurs contraintes (par ex différents territoires)
                if (c.multiConstraints && Array.isArray(c.multiConstraints)) {
                    // on récupère la première contrainte, stockée normalement
                    var constraint = new _Response_model_Constraint__WEBPACK_IMPORTED_MODULE_1__["default"]();
                    constraint.crs = c.crs;
                    constraint.bbox = c.bbox;
                    constraint.minScaleDenominator = c.minScaleDenominator;
                    constraint.maxScaleDenominator = c.maxScaleDenominator;
                    constraint.temporalExtent = c.temporalExtent;
                    data.constraints.push(constraint);

                    // puis on récupère les autres contraintes, à partir de multiConstraints
                    for (var i = 0; i < c.multiConstraints.length; i++) {
                        constraint = new _Response_model_Constraint__WEBPACK_IMPORTED_MODULE_1__["default"]();
                        constraint.crs = c.crs;
                        constraint.minScaleDenominator = c.minScaleDenominator;
                        constraint.maxScaleDenominator = c.maxScaleDenominator;
                        constraint.bbox = c.multiConstraints[i].bbox;
                        constraint.temporalExtent = c.multiConstraints[i].temporalExtent;
                        data.constraints.push(constraint);
                    }
                } else {
                    // cas d'une contrainte classique
                    data.constraints.push(c);
                }
            }
        },

        // info : /LayerList/Layer/Extension/gpp:Layer/gpp:Originators/gpp:Originator/gpp:Constraints/gpp:Constraint/gpp:CRS
        // ou : /LayerList/Layer/Extension/gpp:Layer/gpp:Constraints/gpp:Constraint/gpp:CRS
        /** TODO : jsdoc block */
        CRS : function (node, data) {
            // nothing to do.
            if (data && data.hasOwnProperty("crs")) {
                data.crs = __getChildValue(node);
            }
        },

        // info : /LayerList/Layer/Extension/gpp:Layer/gpp:Thematics/gpp:Thematic
        /** TODO : jsdoc block */
        Thematic : function (node, lyr) {
            if (lyr) {
                var t = new _Response_model_Thematic__WEBPACK_IMPORTED_MODULE_10__["default"]();
                t.inspire = false;
                t.name = __getChildValue(node);
                // si aucune thématique n'a été ajoutée, on crée le tableau vide
                if (!lyr.thematics || !Array.isArray(lyr.thematics)) {
                    lyr.thematics = [];
                }
                lyr.thematics.push(t);
            }
        },

        // info : /LayerList/Layer/Extension/gpp:Layer/gpp:Thematics/gpp:InspireThematic
        /** TODO : jsdoc block */
        InspireThematic : function (node, lyr) {
            if (lyr) {
                var t = new _Response_model_Thematic__WEBPACK_IMPORTED_MODULE_10__["default"]();
                t.inspire = true;
                t.name = __getChildValue(node);
                // si aucune thématique n'a été ajoutée, on crée le tableau vide
                if (!lyr.thematics || !Array.isArray(lyr.thematics)) {
                    lyr.thematics = [];
                }
                lyr.thematics.push(t);
            }
        },

        // info : /LayerList/Layer/Extension/gpp:Layer/gpp:Originators/gpp:Originator
        /** TODO : jsdoc block */
        Originator : function (node, lyr) {
            if (lyr) {
                // info : contient des balises Attribution, Logo, URL, et Constraints
                var o = new _Response_model_Originator__WEBPACK_IMPORTED_MODULE_6__["default"]();
                o.name = node.getAttribute("name");
                __getChildNodes(node, o);
                // si aucun originator n'a été ajouté, on crée le tableau vide
                if (!lyr.originators || !Array.isArray(lyr.originators)) {
                    lyr.originators = [];
                }
                lyr.originators.push(o);
            }
        },

        // info : /LayerList/Layer/Extension/gpp:Layer/gpp:Originators/gpp:Originator/gpp:Attribution
        /** TODO : jsdoc block */
        Attribution : function (node, originator) {
            if (originator && originator.hasOwnProperty("attribution")) {
                originator.attribution = __getChildValue(node);
            }
        },

        // info : /LayerList/Layer/Extension/gpp:Layer/gpp:Originators/gpp:Originator/gpp:Logo
        /** TODO : jsdoc block */
        Logo : function (node, originator) {
            if (originator && originator.hasOwnProperty("logo")) {
                originator.logo = __getChildValue(node);
            }
        },

        // info : /LayerList/Layer/Extension/gpp:Layer/gpp:Originators/gpp:Originator/gpp:URL
        /** TODO : jsdoc block */
        URL : function (node, originator) {
            if (originator && originator.hasOwnProperty("url")) {
                originator.url = __getChildValue(node);
            }
        },

        // info : /LayerList/Layer/Extension/gpp:Layer/gpp:Legends/gpp:Legend
        /** TODO : jsdoc block */
        Legend : function (node, lyr) {
            // 2 balises : sld:MinScaleDenominator et gpp:LegendURL
            var l = new _Response_model_Legend__WEBPACK_IMPORTED_MODULE_4__["default"]();
            __getChildNodes(node, l);
            if (lyr) {
                // si aucune légende n'a encore été ajoutée, on crée le tableau vide
                if (!lyr.legends || !Array.isArray(lyr.legends)) {
                    lyr.legends = [];
                }
                lyr.legends.push(l);
            }
        },

        // info : /LayerList/Layer/Extension/gpp:Layer/gpp:Legends/gpp:Legend/gpp:LegendURL
        /** TODO : jsdoc block */
        LegendURL : function (node, legend) {
            if (legend && legend.hasOwnProperty("format")) {
                legend.format = node.getAttribute("format");
                if (node.hasChildNodes) {
                    var child = node.childNodes[0];
                    var childName = child.localName || child.baseName || child.nodeName;
                    if (childName === "OnlineResource" && legend.hasOwnProperty("url")) {
                        legend.url = child.getAttribute("xlink:href");
                    }
                }
            }
        },

        // info : /LayerList/Layer/Extension/gpp:Layer/gpp:QuickLook
        /** TODO : jsdoc block */
        QuickLook : function (node, lyr) {
            // info : contient une balise OnlineResource avec l'url dans l'attribut "xlink:href"
            if (node.hasChildNodes) {
                var child = node.childNodes[0];
                var childName = child.localName || child.baseName || child.nodeName;
                if (childName === "OnlineResource" && lyr) {
                    lyr.quicklookUrl = child.getAttribute("xlink:href");
                }
            }
        },

        // info : /LayerList/Layer/Extension/gpp:Layer/gpp:MetadataURL
        /** TODO : jsdoc block */
        MetadataURL : function (node, lyr) {
            if (lyr) {
                // info : contient une balise OnlineResource avec l'url dans l'attribut "xlink:href"
                var m = new _Response_model_Metadata__WEBPACK_IMPORTED_MODULE_5__["default"]();
                m.format = node.getAttribute("format");
                if (node.hasChildNodes) {
                    var child = node.childNodes[0];
                    var childName = child.localName || child.baseName || child.nodeName;
                    if (childName === "OnlineResource") {
                        m.url = child.getAttribute("xlink:href");
                    }
                }
                // si aucune metadata n'a été ajoutée, on crée le tableau vide
                if (!lyr.metadata && !Array.isArray(lyr.metadata)) {
                    lyr.metadata = [];
                }
                lyr.metadata.push(m);
            }
        },

        // info : /LayerList/Layer/Extension/gpp:Layer/gpp:Keys/gpp:Key
        /** TODO : jsdoc block */
        Key : function (node, lyr) {
            if (lyr) {
                // récupération de la clé API
                var key = node.getAttribute("id");
                // si on n'a pas encore ajouté de clé, on crée le tableau vide
                if (!lyr.apiKeys || !Array.isArray(lyr.apiKeys)) {
                    lyr.apiKeys = [];
                }
                lyr.apiKeys.push(key);

                // récupération de l'url du service avec la clé API
                var serverUrl = __getChildValue(node);
                if (!lyr.serviceParams) {
                    lyr.serviceParams = {};
                }
                if (!lyr.serviceParams.serverUrl) {
                    lyr.serviceParams.serverUrl = {};
                }
                if (!lyr.serviceParams.serverUrl[key]) {
                    lyr.serviceParams.serverUrl[key] = serverUrl;
                }
            }
        }

    },

    ows : {
        /** TODO : jsdoc block */
        Identifier : function (node, data) {
            if (data && data.hasOwnProperty("TMS")) { // dans le cas d'un TileMatrixSet
                data.identifier = __getChildValue(node);
            } else if (data && data.hasOwnProperty("matrixId")) { // dans le cas d'une TileMatrix
                data.matrixId = __getChildValue(node);
            }
        },

        /** TODO : jsdoc block */
        SupportedCRS : function (node, tmsData) {
            if (tmsData && tmsData.TMS && tmsData.TMS.hasOwnProperty("projection")) {
                tmsData.TMS.projection = __getChildValue(node);
            }
        }
    },

    sld : {
        // info : /General/Extension/gpp:General/gpp:Territories/gpp:Territory/sld:MinScaleDenominator
        // ou : /LayerList/Layer/sld:MinScaleDenominator
        // ou : /LayerList/Layer/Extension/gpp:Layer/gpp:Originators/gpp:Originator/gpp:Constraints/sld:MinScaleDenominator
        // ou : /LayerList/Layer/Extension/gpp:Layer/gpp:Legends/gpp:Legend/sld:MinScaleDenominator
        /** TODO : jsdoc block */
        MinScaleDenominator : function (node, data) {
            var minScale = __getChildValue(node);
            if (minScale && data) {
                if (data.hasOwnProperty("defaultOptions")) { // cas d'un territoire
                    data.defaultOptions.minScaleDenominator = parseFloat(minScale);
                } else if (data.lyr) { // cas d'une layer
                    if (!data.lyr.globalConstraint) {
                        data.lyr.globalConstraint = new _Response_model_Constraint__WEBPACK_IMPORTED_MODULE_1__["default"]();
                    }
                    data.lyr.globalConstraint.minScaleDenominator = parseFloat(minScale);
                } else if (data.hasOwnProperty("minScaleDenominator")) { // cas d'une contrainte ou d'une légende
                    data.minScaleDenominator = parseFloat(minScale);
                }
            }
        },

        // info : /General/Extension/gpp:General/gpp:Territories/gpp:Territory/sld:MaxScaleDenominator
        // ou : /LayerList/Layer/sld:MaxScaleDenominator
        // ou : /LayerList/Layer/Extension/gpp:Layer/gpp:Originators/gpp:Originator/gpp:Constraints/sld:MaxScaleDenominator
        /** TODO : jsdoc block */
        MaxScaleDenominator : function (node, data) {
            var maxScale = __getChildValue(node);
            if (maxScale && data) {
                if (data.hasOwnProperty("defaultOptions")) { // cas d'un territoire
                    data.defaultOptions.maxScaleDenominator = parseFloat(maxScale);
                } else if (data.lyr) { // cas d'une layer
                    if (!data.lyr.globalConstraint) {
                        data.lyr.globalConstraint = new _Response_model_Constraint__WEBPACK_IMPORTED_MODULE_1__["default"]();
                    }
                    data.lyr.globalConstraint.maxScaleDenominator = parseFloat(maxScale);
                } else if (data.hasOwnProperty("maxScaleDenominator")) { // cas d'une contrainte
                    data.maxScaleDenominator = parseFloat(maxScale);
                }
            }
        }
    },

    wmts : {

        // info : /LayerList/Layer/Extension/gpp:Layer/wmts:TileMatrixSetLink/wmts:TileMatrixSetLimits
        /** TODO : jsdoc block */
        TileMatrixSetLimits : function (node, lyr) {
            // info : contient des balises wmts:TileMatrixLimits
            if (lyr) {
                var limits = {};
                // on récupère les limites dans les balises TileMatrixLimits
                __getChildNodes(node, limits);

                if (!lyr.wmtsOptions) {
                    lyr.wmtsOptions = {};
                }
                lyr.wmtsOptions.tileMatrixSetLimits = limits;
            }
        },

        // info : /LayerList/Layer/Extension/gpp:Layer/wmts:TileMatrixSetLink/wmts:TileMatrixSetLimits/wmts:TileMatrixLimits
        /** TODO : jsdoc block */
        TileMatrixLimits : function (node, limits) {
            var limit = new _Response_model_TileMatrixLimit__WEBPACK_IMPORTED_MODULE_13__["default"]();
            var limitId;
            if (node.hasChildNodes) {
                var children = node.childNodes;
                for (var i = 0; i < children.length; i++) {
                    var child = children[i];
                    var childName = child.localName || child.baseName || child.nodeName;
                    if (childName === "TileMatrix") {
                        limitId = __getChildValue(child);
                    } else if (childName === "MinTileRow") {
                        limit.minTileRow = __getChildValue(child);
                    } else if (childName === "MaxTileRow") {
                        limit.maxTileRow = __getChildValue(child);
                    } else if (childName === "MinTileCol") {
                        limit.minTileCol = __getChildValue(child);
                    } else if (childName === "MaxTileCol") {
                        limit.maxTileCol = __getChildValue(child);
                    }
                }
                if (limitId && limits && !limits[limitId]) {
                    limits[limitId] = limit;
                }
            }
        },

        // info : /General/Extension/gpp:General/gpp:TileMatrixSets/wmts:TileMatrixSet
        // ou : // info : /LayerList/Layer/Extension/gpp:Layer/wmts:TileMatrixSetLink/wmts:TileMatrixSet
        /** TODO : jsdoc block */
        TileMatrixSet : function (node, data) {
            // info : Describes a particular set of tile matrices.

            if (data && data.tileMatrixSets) { // les tileMatrixSets de General
                // nouvel objet TileMatrixSet
                var tmsData = {};
                tmsData.TMS = new _Response_model_TileMatrixSet__WEBPACK_IMPORTED_MODULE_11__["default"]();
                tmsData.resolutions = [];

                // lecture des informations du TMS
                __getChildNodes(node, tmsData);

                // récupération des identifiants des niveaux de matrice (pour faciliter l'accès au WMTS via les API carto)
                var tileMatrices = tmsData.TMS.tileMatrices;
                for (var tm in tileMatrices) {
                    if (tileMatrices.hasOwnProperty(tm)) {
                        tmsData.TMS.matrixIds.push(tm);
                    }
                }

                if (tmsData.TMS.getProjection() === "IGNF:WGS84G" || tmsData.TMS.getProjection() === "EPSG:4326") {
                    if (data.generalOptions && Array.isArray(data.generalOptions.wgs84Resolutions)) {
                        var wgs84Resolutions = data.generalOptions.wgs84Resolutions;
                        for (var i = 0; i < wgs84Resolutions.length; i++) {
                            // info : les résolutions stockées dans wgs84Resolutions, issues de l'autoconf, sont des string
                            tmsData.resolutions[i] = parseFloat(wgs84Resolutions[i]);
                        }
                    }
                }

                // tri des résolutions (par ordre décroissant cette fois)
                if (Array.isArray(tmsData.resolutions) && tmsData.resolutions.sort !== undefined) {
                    tmsData.resolutions.sort(
                        function (x, y) {
                            return y - x;
                        }
                    );
                }
                tmsData.TMS.nativeResolutions = tmsData.resolutions;

                // ajout du TileMatrixSet à la variable config
                data.tileMatrixSets[tmsData.identifier] = tmsData.TMS;
            } else { // le TileMatrixSetLink d'une couche (layer)
                if (data && !data.wmtsOptions) {
                    data.wmtsOptions = {};
                }
                // ajout du lien vers le TMS
                data.wmtsOptions.tileMatrixSetLink = __getChildValue(node);
            }
        },

        // info : /General/Extension/gpp:General/gpp:TileMatrixSets/wmts:TileMatrixSet/wmts:TileMatrix
        /** TODO : jsdoc block */
        TileMatrix : function (node, tmsData) {
            // info : Describes a particular tile matrix.

            if (tmsData) {
                // nouveau niveau de matrice : TileMatrix
                var tileMatrix = new _Response_model_TileMatrix__WEBPACK_IMPORTED_MODULE_12__["default"]();

                // lecture des information du TileMatrix
                __getChildNodes(node, tileMatrix);

                // calcul de la résolution associée au dénominateur d'échelle du niveau de pyramide, selon la projection.
                if (tmsData.TMS && tmsData.TMS.getProjection()) {
                    var proj = tmsData.TMS.getProjection();
                    if (proj === "EPSG:3857" || proj === "EPSG:2154") {
                        // calcul de la résolution associée, en m/px
                        // en se basant sur une "taille standard de pixel" de 0.28mm*0.28mm (standard WMTS 1.0)
                        var r = tileMatrix.scaleDenominator * 0.00028;
                        if (tmsData.resolutions && Array.isArray(tmsData.resolutions)) {
                            tmsData.resolutions.push(r);
                        }
                    }
                }

                // ajout du TileMatrix au TileMatrixSet
                if (tmsData.TMS && tmsData.TMS.tileMatrices) {
                    tmsData.TMS.tileMatrices[tileMatrix.matrixId] = tileMatrix;
                }
            }
        },

        // info : /General/Extension/gpp:General/gpp:TileMatrixSets/wmts:TileMatrixSet/wmts:TileMatrix/wmts:ScaleDenominator
        /** TODO : jsdoc block */
        ScaleDenominator : function (node, tileMatrix) {
            var scale = __getChildValue(node);
            if (scale && tileMatrix && tileMatrix.hasOwnProperty("scaleDenominator")) {
                tileMatrix.scaleDenominator = parseFloat(scale);
            }
        },

        // info : /General/Extension/gpp:General/gpp:TileMatrixSets/wmts:TileMatrixSet/wmts:TileMatrix/wmts:TopLeftCorner
        /** TODO : jsdoc block */
        TopLeftCorner : function (node, tileMatrix) {
            var values = __getChildValue(node).split(" ");
            if (values && tileMatrix) {
                tileMatrix.topLeftCorner = {};
                tileMatrix.topLeftCorner.x = parseFloat(values[0]);
                tileMatrix.topLeftCorner.y = parseFloat(values[1]);
            }
        },

        // info : /General/Extension/gpp:General/gpp:TileMatrixSets/wmts:TileMatrixSet/wmts:TileMatrix/wmts:TileWidth
        /** TODO : jsdoc block */
        TileWidth : function (node, tileMatrix) {
            var value = __getChildValue(node);
            if (value && tileMatrix && tileMatrix.hasOwnProperty("tileWidth")) {
                tileMatrix.tileWidth = parseInt(value, 10);
            }
        },

        // info : /General/Extension/gpp:General/gpp:TileMatrixSets/wmts:TileMatrixSet/wmts:TileMatrix/wmts:TileHeight
        /** TODO : jsdoc block */
        TileHeight : function (node, tileMatrix) {
            var value = __getChildValue(node);
            if (value && tileMatrix && tileMatrix.hasOwnProperty("tileHeight")) {
                tileMatrix.tileHeight = parseInt(value, 10);
            }
        },

        // info : /General/Extension/gpp:General/gpp:TileMatrixSets/wmts:TileMatrixSet/wmts:TileMatrix/wmts:MatrixWidth
        /** TODO : jsdoc block */
        MatrixWidth : function (node, tileMatrix) {
            var value = __getChildValue(node);
            if (value && tileMatrix && tileMatrix.hasOwnProperty("matrixWidth")) {
                tileMatrix.matrixWidth = parseInt(value, 10);
            }
        },

        // info : /General/Extension/gpp:General/gpp:TileMatrixSets/wmts:TileMatrixSet/wmts:TileMatrix/wmts:MatrixHeight
        /** TODO : jsdoc block */
        MatrixHeight : function (node, tileMatrix) {
            var value = __getChildValue(node);
            if (value && tileMatrix && tileMatrix.hasOwnProperty("matrixHeight")) {
                tileMatrix.matrixHeight = parseInt(value, 10);
            }
        }
    },

    /** TODO : jsdoc block */
    serviceException : function (node) {
        var response = {};
        if (node.hasChildNodes()) {
            var children = node.childNodes;
            var child;
            for (var i = 0; i < children.length; i++) {
                child = children[i];
                if (child.nodeName === "exception") {
                    response.exceptionReport = AutoConfResponseReader.READERS["exception"](child);
                }
            }
        }
        return response;
    },

    /** TODO : jsdoc block */
    exception : function (node) {
        var exceptionReport = {};

        // get exception code
        var exceptionCode = node.getAttribute("code");
        if (exceptionCode) {
            exceptionReport.exceptionCode = exceptionCode;
        }

        // get exception message
        var textNode = node.firstChild;
        if (textNode && textNode.nodeType === 3) { // 3 === node.TEXT_NODE
            exceptionReport.exception = textNode.nodeValue;
        }

        return exceptionReport;
    }

};

/**
 * Méthode permettant de lancer la lecture d'une réponse XML du service d'autoconf,
 *      à l'aide des READERS de la classe.
 *
 * @method AutoConfResponseReader.read
 * @param {DOMElement} root - racine de la réponse XML à lire
 * @return {Object} config|exceptionReport : l'objet contenant les informations de la réponse XML,
 *      sous la forme d'un objet AutoConfResponse, ou un objet littéral exceptionReport si le service a renvoyé une exception.
 * @static
 * @memberof AutoConfResponseReader
 */
AutoConfResponseReader.read = function (root) {
    if (root.nodeName === "ViewContext") {
        var nsPrefix = root.prefix || AutoConfResponseReader.DEFAULTPREFIX;
        var config = AutoConfResponseReader.READERS[nsPrefix][root.nodeName](root);
        return config;
    } else if (root.nodeName === "serviceException") {
        var exceptionReport = AutoConfResponseReader.READERS[root.nodeName](root);
        return exceptionReport;
    } else {
        throw new Error("Erreur lors de la lecture de la réponse : elle n'est pas au format attendu.");
    }
};

/**
 * Récupération des attributs d'un noeud élément
 *
 * @private
 * @memberof AutoConfResponseReader
 * @method __getAttributes
 * @param {DOMElement} node - noeud contenant l'attribut recherché
 * @return {Object} nodeAttributes - objet contenant les noms et valeurs des différents attributs
 */
function __getAttributes (node) {
    if (node.attributes.length > 0) {
        var nodeAttributes = {};
        var attributes = node.attributes;
        for (var i = 0; i < attributes.length; i++) {
            var attribute = attributes[i];
            nodeAttributes[attribute.nodeName] = attribute.nodeValue;
        }
        return nodeAttributes;
    }
}

/**
 * Récupération des noeuds enfants (seulement de type ELEMENT), à partir d'un noeud donné, pour lecture (readNode).
 *
 * @private
 * @memberof AutoConfResponseReader
 * @method __getChildNodes
 * @param {DOMElement} node - a DOM node
 * @param {Array|Object} [data] - an object to be filled with node data
 */
function __getChildNodes (node, data) {
    if (node.hasChildNodes()) {
        var children = node.childNodes;
        var child;
        var childName;
        var childPrefix;

        for (var i = 0; i < children.length; i++) {
            child = children[i];

            if (child.nodeType === 1) { // 1 === node.ELEMENT_NODE
                childName = child.localName || child.baseName || child.nodeName;
                childPrefix = child.prefix || AutoConfResponseReader.DEFAULTPREFIX;

                if (AutoConfResponseReader.READERS[childPrefix][childName]) {
                    var reader = AutoConfResponseReader.READERS[childPrefix][childName];
                    reader(child, data);
                } else {
                    __getChildNodes(child, data);
                }
            }
        }
    }
}

/**
 * Lecture de la valeur du premier child d'un noeud, si elle existe.
 *
 * @private
 * @memberof AutoConfResponseReader
 * @method __getChildValue
 * @param {DOMElement} node - a DOM node
 * @return {String} value - valeur du firstChild du noeud en entrée, ou chaîne vide.
 */
function __getChildValue (node) {
    var textNode;
    var value = "";

    if (node.hasChildNodes()) {
        textNode = node.firstChild;
        if (textNode.nodeType === 3 || textNode.nodeType === 4) { // 3 === node.TEXT_NODE
            value = textNode.nodeValue;
        }
    }
    return value;
}

/**
 * Vérification des attributs du service, dans la balise XLS de la réponse :
 *      version, namespaces, et namespace par défaut doivent correspondre à ceux attendus.
 *
 * @private
 * @memberof AutoConfResponseReader
 * @method __checkServiceAttributes
 * @param {DOMElement} viewContextNode - a DOM node, corresponding to XLS first tag.
 */
function __checkServiceAttributes (viewContextNode) {
    if (viewContextNode.attributes.length > 0) {
        // on récupère et parcourt les attributs de la balise XLS de la réponse
        var xlsAttributes = __getAttributes(viewContextNode);
        for (var att in xlsAttributes) {
            if (xlsAttributes.hasOwnProperty(att)) {
                // vérification de la version
                if (att === "version") {
                    if (xlsAttributes["version"] !== AutoConfResponseReader.VERSION) {
                        console.log("[AutoConfResponseReader] autoconf version is not the expected one : there may be errors in parsing");
                        return;
                    }
                }

                // on vérifie que l'uri du namespace par défaut est bien celle que l'on attend
                if (att === "xmlns") {
                    if (xlsAttributes[att] !== AutoConfResponseReader.NAMESPACES.xmlns) {
                        console.log("[AutoConfResponseReader] autoconf response default namespace is not the expected one");
                        return;
                    }
                    continue;
                }

                var prefix = att.split(":")[0];
                var ns = att.split(":")[1];

                // si on a un autre xmlns, on vérifie aussi les URI
                if (prefix === "xmlns" && ns) {
                    // si l'attribut correspond à un namespace défini dans le reader
                    if (AutoConfResponseReader.NAMESPACES[ns]) {
                        // il faut que les URI correspondent aussi.
                        if (AutoConfResponseReader.NAMESPACES[ns] !== xlsAttributes[att]) {
                            console.log("[AutoConfResponseReader] autoconf response " + att + " namespace is not the expected one");
                            return;
                        }
                    }
                }

                // pour finir on vérifie la localisation du schema XSD du service
                if (ns === "schemaLocation") {
                    if (xlsAttributes[att] !== AutoConfResponseReader.SCHEMALOCATION[0] && xlsAttributes[att] !== AutoConfResponseReader.SCHEMALOCATION[1]) {
                        console.log("[AutoConfResponseReader] autoconf response schema location is not the expected one");
                        return;
                    }
                }
            }
        }
    }
}

/* harmony default export */ __webpack_exports__["default"] = (AutoConfResponseReader);


/***/ }),
/* 73 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

/**
 * Response object for {@link module:Services~getConfig Gp.Services.getConfig ()} invocation when successful. Received as the argument of onSuccess callback function.
 *
 * @property {Object} generalOptions - General properties for default map configuration resources.
 * @property {Object} generalOptions.apiKeys - Object that associates apiKey (s) with an array of resources IDs availables with that key.
 * @property {String} generalOptions.title - Underlying web service Title.
 * @property {String} generalOptions.defaultGMLGFIStyle - XSL URL used by default to translate an XML GetFeatureInfo response into an HTML array.
 * @property {String} generalOptions.theme - default theme (FIXME : for what ?)
 * @property {Array.<Float>} generalOptions.wgs84Resolutions - geographical resolutions Array for each [zoom level of the Geoportal platform]{@link http://api.ign.fr/tech-docs-js/webmaster/layers.html#Geoportal_resolutions} from 0 to 21. Expressed in degrees/pixel.
 * @property {Object} layers - Associative array mapping resources availables IDs (keys) with their properties (values given as {@link Gp.Services.Config.Layer}).
 * @property {Object} territories - Associative array mapping french territories IDs (keys) with their properties (values given as {@link Gp.Services.Config.Territory}).
 * @property {Object} tileMatrixSets - Associative Array mapping TileMatrixSets IDs (keys) availables with their properties (values given as {@link Gp.Services.Config.TileMatrixSet}).
 * @property {Object} services - Associative Array mapping Geoportal web services IDs (keys) availables with their properties (values given as {@link Gp.Services.Config.Service}).
 *
 * @namespace
 * @alias Gp.Services.GetConfigResponse
 */
function AutoConfResponse () {
    if (!(this instanceof AutoConfResponse)) {
        throw new TypeError("AutoConfResponse constructor cannot be called as a function.");
    }

    this.generalOptions = {
        apiKeys : {},
        title : null,
        defaultGMLGFIStyle : null,
        theme : null,
        wgs84Resolutions : []
    };

    this.layers = {};

    this.territories = {};

    this.tileMatrixSets = {};

    this.services = {};
}

AutoConfResponse.prototype = {

    /*
     * Constructor (alias)
     */
    constructor : AutoConfResponse,

    /**
     * Check if config is loaded for a given key
     *
     * @param {String} apiKey - Access key to Geoportal platform
     * @returns {Boolean} isConfLoaded - true if config is already loaded, false otherwise
     */
    isConfLoaded : function (apiKey) {
        if (!apiKey) {
            return;
        }
        if (this.generalOptions.apiKeys[apiKey]) {
            return true;
        }
        return false;
    },

    /**
     * Returns an array of Geoportal layers identifiers, corresponding to an API contract key.
     *
     * @param {String} apiKey - Access key to Geoportal platform
     * @returns {Array} apiKeys - Array of geoportal layers identifiers
     */
    getLayersId : function (apiKey) {
        return this.generalOptions.apiKeys[apiKey];
    },

    /**
     * Returns an associative array of Geoportal layers configurations, corresponding to an API contract key.
     * If no key is specified, all layers from configuration are returned.
     *
     * @param {String} apiKey - Access key to Geoportal platform
     * @returns {Object} layers - Object which properties are layers identifiers, and corresponding
     *      values are instances of <Gp.Services.Config.Layer>.
     */
    getLayersConf : function (apiKey) {
        var layers = {};
        var layersIdArray = this.getLayersId(apiKey);
        if (layersIdArray) {
            for (var i = 0; i < layersIdArray.length; i++) {
                var lyrId = layersIdArray[i];
                layers[lyrId] = this.layers[lyrId];
            }
        }
        return layers;
    },

    /**
     * Returns a geoportal layer configuration, given its identifier
     *
     * @param {String} layerId - Geoportal layer identifier (e.g. "GEOGRAPHICALGRIDSYSTEMS.MAPS$GEOPORTAIL:OGC:WMTS")
     * @return {Object} layer - Layer configuration : instance of {@link Gp.Services.Config.Layer}
     */
    getLayerConf : function (layerId) {
        if (!this.layers) {
            return;
        }
        return this.layers[layerId];
    },

    /**
     * Returns an associative array of Tile Matrix Sets configurations.
     *
     * @return {Object} tileMatrixSets - Object which properties are TMS identifiers,
     *      and corresponding values are instances of {@link Gp.Services.Config.TileMatrixSet}.
     */
    getTileMatrixSets : function () {
        return this.tileMatrixSets;
    },

    /**
     * Returns a Tile Matrix Sets configuration, given its identifier.
     *
     * @param {String} tmsID - Tile Matrix Set identifier (e.g. : "PM")
     * @return {Object} tileMatrixSet - Tile Matrix Set configuration, instance of {@link Gp.Services.Config.TileMatrixSet}
     */
    getTMSConf : function (tmsID) {
        if (!this.tileMatrixSets) {
            return;
        }
        return this.tileMatrixSets[tmsID];
    },

    /**
     * Returns an associative array of territories configurations.
     *
     * @return {Object} territories - Object which properties are territory identifiers,
     *      and corresponding values are instances of {@link Gp.Services.Config.Territory}.
     */
    getTerritories : function () {
        return this.territories;
    },

    /**
     * Returns a territory configuration, given its identifier.
     *
     * @param {String} territoryID - territory identifier (e.g. "FXX")
     * @return {Object} territory - Territory configuration, instance of {@link Gp.Services.Config.Territory}
     */
    getTerritoryConf : function (territoryID) {
        if (!this.territories) {
            return;
        }
        return this.territories[territoryID];
    },

    /**
     * Returns an associative array of services configurations.
     *
     * @return {Object} services - Object which properties are services identifiers,
     *      and corresponding values are instances of {@link Gp.Services.Config.Service}.
     */
    getServices : function () {
        return this.services;
    },

    /**
     * Returns a service configuration, given its identifier.
     *
     * @param {String} serviceID - service identifier (e.g. "OGC:WMTS")
     * @return {Object} service - service configuration, instance of {@link Gp.Services.Config.Service}
     */
    getServiceConf : function (serviceID) {
        if (!this.services) {
            return;
        }
        return this.services[serviceID];
    }

};

/* harmony default export */ __webpack_exports__["default"] = (AutoConfResponse);


/***/ }),
/* 74 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

/**
 *
 * Object used to express a geographical (BBOX, scale) and temporal constraint.
 *
 * @property {String} crs - Coordinates System ID used to express coordinates contraints.
 * @property {Gp.BBox} bbox - Constraint Bounding Box.
 * @property {Number} minScaleDenominator - Minimum scale denominator where constraint applies.
 * @property {Number} maxScaleDenominator - Maximum scale denominator where constraint applies.
 * @property {Array.<String>} temporalExtent - Array expressing the time interval of the constraint [minT, maxT]. Dates are expressed in the [ISO-8601]{@link https://en.wikipedia.org/wiki/ISO_8601} way.
 *
 * @namespace
 * @alias Gp.Services.Config.Constraint
 */

function Constraint () {
    if (!(this instanceof Constraint)) {
        throw new TypeError("Constraint constructor cannot be called as a function.");
    }

    this.crs = null;

    this.bbox = {
        left : null,
        right : null,
        top : null,
        bottom : null
    };

    this.minScaleDenominator = null;

    this.maxScaleDenominator = null;

    this.temporalExtent = [null, null];
}

Constraint.prototype = {

    constructor : Constraint

};

/* harmony default export */ __webpack_exports__["default"] = (Constraint);


/***/ }),
/* 75 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

/**
 * Object used to describe a format to use with Geoportal resources.
 *
 * @property {Boolean} current - If true, then this format is used by default.
 * @property {String} name - Format mime-type.
 *
 * @namespace
 * @alias Gp.Services.Config.Format
 */

function Format () {
    if (!(this instanceof Format)) {
        throw new TypeError("Format constructor cannot be called as a function.");
    }

    this.current = null;

    this.name = null;
}

Format.prototype = {

    constructor : Format

};

/* harmony default export */ __webpack_exports__["default"] = (Format);


/***/ }),
/* 76 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

/**
 * Object used to describe geoportal resource (WMTS, WMS, WFS layers, geocoding resources or elevation service) parameters. Properties may be used or not depending on the resource type.
 *
 * @property {String} name - name of the resource to use with the webservice that serves it (eg : "GEOGRAPHICALGRIDSYSTEMS.MAPS").
 * @property {String} title - Human readable name for the resource.
 * @property {String} description - Resource description.
 * @property {String} layerId - Unique resource Identifier (eg : "GEOGRAPHICALGRIDSYSTEMS.MAPS$GEOPORTAIL:OGC:WMTS")
 * @property {String} quicklookUrl - Image URL for the resource.
 * @property {Object} serviceParams - Informations about the webservice that serves the resource (OpenLS, WFS, WMTS)
 * @property {String} serviceParams.id - Web Service identifier ("OGC:WMTS", "OGC:OPENLS;ReverseGeocode", etc...)
 * @property {Object} serviceParams.serverUrl - Associative array mapping geoportal access key (keys) with their properties (URLs of the web service, with the geoportal access key).
 * @property {String} serviceParams.version - webservice version.
 * @property {String} defaultProjection - coordinates system ID used by default for the resource (WMS or WFS layer) or of the TileMatrixSet used by the WMTS layer.
 * @property {Array.<String>} additionalProjections - additional coordinates systems IDs availables for the resource, others than the default one (see defaultProjection) (WMS and WFS layers only).
 * @property {Array.<Gp.Services.Config.Format>} formats - Formats availables for the resource.
 * @property {Array.<Gp.Services.Config.Legend>} legends - Informations about legends associated to the resource.
 * @property {Array.<Gp.Services.Config.Metadata>} metadata - Informations about metadata associated to the resource.
 * @property {Array.<Gp.Services.Config.Style>} styles - Informations about styles availables for the resources (WMS, WFS and WMTS only).
 * @property {Array.<Gp.Services.Config.Thematic>} thematics - Informations about thematics associated to the resource.
 * @property {Gp.Services.Config.Constraint} globalConstraint - geographical constraint for the resource.
 * @property {Array.<Gp.Services.Config.Constraint>} constraints - additionnal geographical constraints for the resource.
 * @property {Array.<Gp.Services.Config.Originator>} originators - Informations about originator of the resource.
 * @property {Object} wmtsOptions - Informations associated to WMTS resources.
 * @property {String} wmtsOptions.tileMatrixSetLink - TileMatrixSet identifier used by the resource (see {@link Gp.Services.Config.TileMatrixSet})
 * @property {Gp.Services.Config.TileMatrixLimit} wmtsOptions.tileMatrixSetLimits - limits of the resource for that TileMAtrixSet.
 * @property {Boolean} queryable - true if a getFeatureInfo request may be done for the resource (WMS or WMTS only).
 * @property {Boolean} hidden - true if the resource is not visible.
 * @property {Boolean} isAggregate - true if the resource is an aggregate of other resources (@see aggregatedLayers).
 * @property {Array.<String>} aggregatedLayers - Layers IDs composing the being described aggregated layer.
 * @property {Array.<String>} apiKeys - Array of access keys that grant access to that resource.
 * @property {Object} dimensions - Dimensions informations associated with the resource.
 * @property {String} dimensions.type
 * @property {String} dimensions.visibilityRange
 * @property {String} dimensions.visibilityMode
 * @property {String} dimensions.noDataValue
 * @property {String} dimensions.geometricType
 *
 * @namespace
 * @alias Gp.Services.Config.Layer
 */
function Layer () {
    if (!(this instanceof Layer)) {
        throw new TypeError("Layer constructor cannot be called as a function.");
    }

    // info : une instance de la classe Layer n'a aucune propriété au départ,.
    // les attributs possibles sont documentés ci-dessus,
    // et seront implémentés au fur et à mesure de la lecture de la réponse de l'autoconf, lorsque l'information est rencontrée.
}

Layer.prototype = {

    constructor : Layer,

    /**
     * Returns the layer name
     *
     * @returns {String} name - name of the resource to use with the webservice that serves it (eg : "GEOGRAPHICALGRIDSYSTEMS.MAPS").
     */
    getName : function () {
        return this.name;
    },

    /**
     * Returns the layer title
     *
     * @returns {String} title - Human readable name for the resource.
     */
    getTitle : function () {
        return this.title;
    },

    /**
     * Returns the layer description
     *
     * @returns {String} description - Resource description.
     */
    getDescription : function () {
        return this.description;
    },

    /**
     * Returns the layer identifier
     *
     * @returns {String} layerId - Unique resource Identifier (eg : "GEOGRAPHICALGRIDSYSTEMS.MAPS$GEOPORTAIL:OGC:WMTS")
     */
    getLayerId : function () {
        return this.layerId;
    },

    /**
     * Returns the layer quicklookUrl
     *
     * @returns {String} quicklookUrl - Image URL for the resource.
     */
    getQuicklookUrl : function () {
        return this.quicklookUrl;
    },

    /**
     * Returns the layer default projection
     *
     * @returns {String} defaultProjection - coordinates system ID used by default for the resource (WMS or WFS layer) or of the TileMatrixSet used by the WMTS layer.
     */
    getDefaultProjection : function () {
        return this.defaultProjection;
    },

    /**
     * Returns the layer projections
     *
     * @returns {Array.<String>} projections - coordinates systems IDs availables for the resource, including the default one.
     */
    getProjections : function () {
        var projections = [];
        projections.push(this.defaultProjection);
        var proj = projections.concat(this.additionalProjections);
        return proj;
    },

    /**
     * Returns the global BBOX
     *
     * @returns {Gp.BBox} bbox - the layer global bounding box, expressed in CRS system.
     */
    getBBOX : function () {
        if (!this.globalConstraint) {
            return;
        }
        return this.globalConstraint.bbox;
    },

    /**
     * Returns the layer minimum scale denominator
     *
     * @returns {Number} minScaleDenominator - minimum scale denominator for this layer
     */
    getMinScaleDenominator : function () {
        if (!this.globalConstraint) {
            return;
        }
        return this.globalConstraint.minScaleDenominator;
    },

    /**
     * Returns the layer maximum scale denominator
     *
     * @returns {Number} maxScaleDenominator - maximum scale denominator for this layer
     */
    getMaxScaleDenominator : function () {
        if (!this.globalConstraint) {
            return;
        }
        return this.globalConstraint.maxScaleDenominator;
    },

    /**
     * Returns layer Tile Matrix Set identifier if exists
     *
     * @returns {String} tileMatrixSetLink - Tile Matrix Set identifier (for instance : "PM")
     */
    getTMSID : function () {
        if (this.wmtsOptions) {
            return this.wmtsOptions.tileMatrixSetLink;
        }
    },

    /**
     * Returns information about the webservice that serves the resource
     *
     * @returns {Object} serviceParams - Information about the webservice that serves the resource (OpenLS, WFS, WMTS)
     */
    getServiceParams : function () {
        return this.serviceParams;
    },

    /**
     * Returns Geoportal server url for a given key
     *
     * @param {String} apiKey - Access key to Geoportal platform
     * @returns {String} serverUrl - general URL of the web service (with the geoportal access key)
     */
    getServerUrl : function (apiKey) {
        if (!apiKey || !this.serviceParams || !this.serviceParams.serverUrl) {
            return;
        }
        return this.serviceParams.serverUrl[apiKey];
    },

    /**
     * Returns information about legends associated to the resource.
     *
     * @returns {Array.<Gp.Services.Config.Legend>} legends - Informations about legends associated to the resource.
     */
    getLegends : function () {
        return this.legends;
    },

    /**
     * Returns information about metadata associated to the resource.
     *
     * @returns {Array.<Gp.Services.Config.Metadata>} metadata - Informations about metadata associated to the resource.
     */
    getMetadata : function () {
        return this.metadata;
    },

    /**
     * Returns information about styles availables for the resources (WMS, WFS and WMTS only).
     *
     * @returns {Array.<Gp.Services.Config.Style>} styles - Informations about styles availables for the resources (WMS, WFS and WMTS only).
     */
    getStyles : function () {
        return this.styles;
    },

    /**
     * Returns layer default style
     *
     * @returns {String} styleName - style identifier (eg : "normal", "bdparcellaire", ...)
     */
    getDefaultStyle : function () {
        if (!this.styles) {
            return;
        }
        var style;
        var s = this.styles;
        for (var i = 0; i < s.length; i++) {
            if (s[i].current === true) {
                style = s[i].name;
                break;
            }
        }
        return style;
    },

    /**
     * Returns information about thematics associated to the resource.
     *
     * @returns {Array.<Gp.Services.Config.Thematic>} thematics - Informations about thematics associated to the resource.
     */
    getThematics : function () {
        return this.thematics;
    },

    /**
     * Returns layer default format
     *
     * @returns {String} formatName - Format mime-type. (eg. "image/jpeg")
     */
    getDefaultFormat : function () {
        if (!this.formats) {
            return;
        }
        var format;
        var f = this.formats;
        for (var i = 0; i < f.length; i++) {
            if (f[i].current === true) {
                format = f[i].name;
                break;
            }
        }
        return format;
    },

    /**
     * Returns information about geographical or temporal constraints for the resource
     *
     * @returns {Array.<Gp.Services.Config.Constraint>} constraints - Informations about geographical or temporal constraints for the resource
     */
    getConstraints : function () {
        return this.constraints;
    },

    /**
     * Returns information about originators of this resource
     *
     * @returns {Array.<Gp.Services.Config.Originator>} originators - Informations about originators of this resource
     */
    getOriginators : function () {
        return this.originators;
    },

    /**
     * Returns information about dimensions associated with this resource
     *
     * @returns {Object} dimensions - Dimensions informations associated with the resource.
     */
    getDimensions : function () {
        return this.dimensions;
    },

    /**
     * Returns information about aggregated layers composing the being described layer, in case the resource is an aggregate of other resources.
     *
     * @returns {Object} aggregatedLayers - Layers IDs composing the being described aggregated layer.
     */
    getAggregatedLayers : function () {
        if (this.isAggregate) {
            return this.aggregatedLayers;
        } else {

        }
    }

};

/* harmony default export */ __webpack_exports__["default"] = (Layer);


/***/ }),
/* 77 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

/**
 * Object used to describe a legend file associated with a geoportal resource (WMTS, WMS, WFS layers).
 *
 * @property {String} format - mime-type of the legend file.
 * @property {String} url - legend file URL
 * @property {Number} minScaleDenominator - minimum scale denominator where this legend applies.
 *
 * @namespace
 * @alias Gp.Services.Config.Legend
 */

function Legend () {
    if (!(this instanceof Legend)) {
        throw new TypeError("Legend constructor cannot be called as a function.");
    }

    this.format = null;

    this.url = null;

    this.minScaleDenominator = null;
}

Legend.prototype = {

    constructor : Legend

};

/* harmony default export */ __webpack_exports__["default"] = (Legend);


/***/ }),
/* 78 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

/**
 * Object used to describe a metadata file associated with a geoportal resource.
 *
 * @property {String} format - mime-type of the metadata file.
 * @property {String} url - metadata file URL
 *
 * @namespace
 * @alias Gp.Services.Config.Metadata
 */

function Metadata () {
    if (!(this instanceof Metadata)) {
        throw new TypeError("Metadata constructor cannot be called as a function.");
    }

    this.format = null;

    this.url = null;
}

Metadata.prototype = {

    constructor : Metadata

};

/* harmony default export */ __webpack_exports__["default"] = (Metadata);


/***/ }),
/* 79 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

/**
 * Object used to describe an Originator of geoportal resource.
 *
 * @property {String} name - originator name
 * @property {String} attribution - originator full name
 * @property {String} logo - originator logo file URL
 * @property {String} url - originator web site URL
 * @property {Array.<Gp.Services.Config.Constraint>} constraints - where and when the originator applies for the ressource.
 *
 * @namespace
 * @alias Gp.Services.Config.Originator
 */

function Originator () {
    if (!(this instanceof Originator)) {
        throw new TypeError("Originator constructor cannot be called as a function.");
    }

    this.name = null;

    this.attribution = null;

    this.logo = null;

    this.url = null;

    this.constraints = [];
}

Originator.prototype = {

    constructor : Originator

};

/* harmony default export */ __webpack_exports__["default"] = (Originator);


/***/ }),
/* 80 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

/**
 * Object used to describe a web service of the geoportal platform.
 *
 * @property {String} title - Web service name
 * @property {Object} serverUrl - Associative array mapping geoportal access key (keys) with their properties (URLs of the web service, with the geoportal access key).
 * @property {String} version - web service version.
 *
 * @namespace
 * @alias Gp.Services.Config.Service
 */
function Service () {
    if (!(this instanceof Service)) {
        throw new TypeError("Service constructor cannot be called as a function.");
    }

    this.title = null;

    this.serverUrl = null;

    this.version = null;
}

Service.prototype = {

    constructor : Service

};

/* harmony default export */ __webpack_exports__["default"] = (Service);


/***/ }),
/* 81 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

/**
 * Object used to describe a style that may be used for a geoportal resource.
 *
 * @property {String} name - Style identifier (eg : "normal", "bdparcellaire", ...)
 * @property {String} title - human readable name of the style.
 * @property {Boolean} current - true if this is the default style.
 * @property {String} url - Url Style (eg: vectortile).
 *
 * @namespace
 * @alias Gp.Services.Config.Style
 */

function Style () {
    if (!(this instanceof Style)) {
        throw new TypeError("Style constructor cannot be called as a function.");
    }

    this.name = null;

    this.title = null;

    this.current = null;

    this.url = null;
}

Style.prototype = {

    constructor : Style

};

/* harmony default export */ __webpack_exports__["default"] = (Style);


/***/ }),
/* 82 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

/**
 * Object used to describe properties of a french territory covered by geoportal resources.
 *
 * @property {Boolean} isDefault - if this territory is to use by default.
 * @property {String} defaultCRS - Identifier of the coordinates system to use by default for that territory.
 * @property {Array.<String>} additionalCRS - Identifiers of additional coordinates systems availables for that territory.
 * @property {Array.<String>} defaultLayers - Identifiers of layers to load by default for that territory.
 * @property {Object} defaultOptions - options to use by default for that territory.
 * @property {Number} defaultOptions.resolution - resolution to use by default for that territory (in meter per pixel).
 * @property {Number} defaultOptions.minScaleDenominator - minimum scaleDenominator accessible for that territory.
 * @property {Number} defaultOptions.maxScaleDenominator - maximum scaleDenominator accessible for that territory.
 * @property {Gp.BBox} geoBBox - Bounding Box of the territory (expressed in geographical coordinates)
 * @property {Object} geoCenter - center of the territory (expressed in geographical coordinates)
 * @property {Float} geoCenter.lon - center longitude
 * @property {Float} geoCenter.lat - center latitude
 *
 * @namespace
 * @alias Gp.Services.Config.Territory
 */
function Territory () {
    if (!(this instanceof Territory)) {
        throw new TypeError("Territory constructor cannot be called as a function.");
    }

    this.isDefault = null;

    this.defaultCRS = null;

    this.additionalCRS = [];

    this.geoBBOX = {
        left : null,
        right : null,
        top : null,
        bottom : null
    };

    this.geoCenter = {
        lon : null,
        lat : null
    };

    this.defaultOptions = {
        resolution : null,
        minScaleDenominator : null,
        maxScaleDenominator : null
    };

    this.defaultLayers = [];
}

Territory.prototype = {

    constructor : Territory

};

/* harmony default export */ __webpack_exports__["default"] = (Territory);


/***/ }),
/* 83 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

/**
 * Object used to describe a thematic
 *
 * @property {String} name - Thematic name
 * @property {Boolean} inspire - true if the thematic name is an [INSPIRE one]{@link http://inspire.ec.europa.eu/index.cfm/pageid/2/list/7}.
 *
 * @namespace
 * @alias Gp.Services.Config.Thematic
 */

function Thematic () {
    if (!(this instanceof Thematic)) {
        throw new TypeError("Thematic constructor cannot be called as a function.");
    }

    this.inspire = null;

    this.name = null;
}

Thematic.prototype = {

    constructor : Thematic

};

/* harmony default export */ __webpack_exports__["default"] = (Thematic);


/***/ }),
/* 84 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

/**
 *
 * Object used to describe a TileMatrix set (for WMTS use).
 *
 * @property {Array.<String>} matrixIds - Array of IDs for each TileMatrix of the set.
 * @property {Array.<Gp.Services.Config.TileMatrix>} tileMatrices - Array of TileMatrix descriptions.
 * @property {Array.<Float>} nativeResolutions - Array of resolutions (in meter per pixel) applying for each TileMatrix of the set.
 * @property {String} projection - Identifier of the Cordinates System used for the tileMatrixSet.
 *
 * @namespace
 * @alias Gp.Services.Config.TileMatrixSet
 */
function TileMatrixSet () {
    if (!(this instanceof TileMatrixSet)) {
        throw new TypeError("TileMatrixSet constructor cannot be called as a function.");
    }

    this.projection = null;

    this.nativeResolutions = [];

    this.matrixIds = [];

    this.tileMatrices = {};
}

TileMatrixSet.prototype = {

    constructor : TileMatrixSet,

    /**
     * Returns Tile Matrix Set resolutions
     *
     * @returns {Array} nativeResolutions - Array of resolutions (in meter per pixel) applying for each TileMatrix of the set.
     */
    getResolutions : function () {
        return this.nativeResolutions;
    },

    /**
     * Returns Tile Matrix Set identifiers
     *
     * @returns {Array} matrixIds - Array of IDs for each TileMatrix of the set.
     */
    getMatrixIds : function () {
        return this.matrixIds;
    },

    /**
     * Returns Tile Matrix Set projection
     *
     * @returns {String} projection - Identifier of the Cordinates System used for the tileMatrixSet.
     */
    getProjection : function () {
        return this.projection;
    },

    /**
     * Returns Tile Matrices descriptions.
     *
     * @returns {Array.<Gp.Services.Config.TileMatrix>} tileMatrices - Array of TileMatrix descriptions.
     */
    getTileMatrices : function () {
        return this.tileMatrices;
    },

    /**
     * Returns top left corner point of matrices
     *
     * @returns {Gp.Point} topLeftCorner - Top Left Corner Point of TMS matrices, expressed in the tileMatrixSet coordinates system.
     */
    getTopLeftCorner : function () {
        var topLeftCorner;
        var matrices = this.getTileMatrices();
        if (matrices) {
            for (var id in matrices) {
                if (matrices.hasOwnProperty(id)) {
                    topLeftCorner = matrices[id].topLeftCorner;
                    break;
                }
            }
        }
        return topLeftCorner;
    }

};

/* harmony default export */ __webpack_exports__["default"] = (TileMatrixSet);


/***/ }),
/* 85 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

/**
 * Object used to describe a TileMatrix.
 *
 * @property {String} matrixId - matrix Identifier
 * @property {Number} matrixHeight - Number of tiles from the top to the bottom of the matrix.
 * @property {Number} matrixWidth - Number of tiles from the left to the right of the matrix.
 * @property {Number} scaleDenominator - Scale denominator associated to that matrix.
 * @property {Number} tileHeight - tile height in number of pixels
 * @property {Number} tileWidth - tile width in number of pixels
 * @property {Gp.Point} topLeftCorner - Top Left Corner Point of the matrix expressed in the tileMatrixSet coordinates system.
 *
 * @namespace
 * @alias Gp.Services.Config.TileMatrix
 */

function TileMatrix () {
    if (!(this instanceof TileMatrix)) {
        throw new TypeError("TileMatrix constructor cannot be called as a function.");
    }

    this.matrixId = null;

    this.matrixHeight = null;

    this.matrixWidth = null;

    this.scaleDenominator = null;

    this.tileHeight = null;

    this.tileWidth = null;

    this.topLeftCorner = null;
}

TileMatrix.prototype = {

    constructor : TileMatrix,

    /**
     * Returns top left corner point of the matrix
     *
     * @returns {Gp.Point} topLeftCorner - Top Left Corner Point of the matrix expressed in the tileMatrixSet coordinates system.
     */
    getTopLeftCorner : function () {
        return this.topLeftCorner;
    },

    /**
     * Returns Scale denominator associated to that matrix.
     *
     * @returns {Number} scaleDenominator - Scale denominator associated to that matrix.
     */
    getScaleDenominator : function () {
        return this.scaleDenominator;
    },

    /**
     * Returns tile height of matrix
     *
     * @returns {Number} tileHeight - tile height in number of pixels
     */
    getTileHeight : function () {
        return this.tileHeight;
    },

    /**
     * Returns tile width of matrix
     *
     * @returns {Number} tileWidth - tile width in number of pixels
     */
    getTileWidth : function () {
        return this.tileWidth;
    },

    /**
     * Returns matrix height (number of tiles)
     *
     * @returns {Number} matrixHeight - Number of tiles from the top to the bottom of the matrix.
     */
    getMatrixHeight : function () {
        return this.matrixHeight;
    },

    /**
     * Returns matrix width (number of tiles)
     *
     * @returns {Number} matrixWidth - Number of tiles from the left to the right of the matrix.
     */
    getMatrixWidth : function () {
        return this.matrixWidth;
    }

};

/* harmony default export */ __webpack_exports__["default"] = (TileMatrix);


/***/ }),
/* 86 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

/**
 * Object used to describe a layer extent on a Tile Matrix.
 *
 * @property {Number} minTileCol - minimum column index where tile can be found on the Tile matrix.
 * @property {Number} maxTileCol - maximum column index where tile can be found on the Tile matrix.
 * @property {Number} minTileRow - minimum row index where tile can be found on the Tile matrix.
 * @property {Number} maxTileCol - maximum row index where tile can be found on the Tile matrix.
 *
 * @namespace
 * @alias Gp.Services.Config.TileMatrixLimit
 */

function TileMatrixLimit () {
    if (!(this instanceof TileMatrixLimit)) {
        throw new TypeError("TileMatrixLimit constructor cannot be called as a function.");
    }

    this.minTileRow = null;

    this.maxTileRow = null;

    this.minTileCol = null;

    this.maxTileCol = null;
}

/**
 * @lends module:Autoconf/Response/TileMatrixLimit
 */
TileMatrixLimit.prototype = {

    constructor : TileMatrixLimit
};

/* harmony default export */ __webpack_exports__["default"] = (TileMatrixLimit);


/***/ }),
/* 87 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44);
/* harmony import */ var _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45);
/* harmony import */ var _CommonService__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46);
/* harmony import */ var _Request_DirectGeocodeRequestFactory__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(88);
/* harmony import */ var _Response_DirectGeocodeResponseFactory__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(105);








/**
 * @classdesc
 * Appel du service de géocodage direct du Géoportail :
 *     envoi de la requête construite selon les paramètres en options,
 *     éventuellement parsing et analyse  de la réponse,
 *     retour d'une réponse en paramètre de la fonction onSuccess.
 *
 *
 * @constructor
 * @extends {Gp.Services.CommonService}
 * @alias Gp.Services.Geocode
 *
 * @param {Object} options - options spécifiques au service (+ les options heritées)
 *
 * @param {String|Object} options.location - Nom de l'adresse, du toponyme, de l'unité administrative ou de la parcelle cadastrale recherchée.
 *      Sous forme de String, la propriété permet de faire une recherche déstructurée.
 *      Sous forme d'objet, la propriété permet de structurer la recherche.
 *      Dans ce cas, les propriétés possibles de cet objet sont décrites ci-après.
 *      @param {Number} [options.location.number] - Numéro du bâtiment de l'adresse recherchée, dans le cas d'une recherche structurée
 *      (si options.location est un objet Javascript).
 *      @param {String} [options.location.street] - Nom de la rue de l'adresse recherchée, dans le cas d'une recherche structurée
 *      (si options.location est un objet Javascript).
 *      @param {String} [options.location.city] - Nom de la ville de l'adresse recherchée, dans le cas d'une recherche structurée
 *      (si options.location est un objet Javascript).
 *      @param {Number} [options.location.postalCode] - Numéro du code postal de l'adresse recherchée, dans le cas d'une recherche structurée
 *      (si options.location est un objet Javascript).
 *
 * @param {Object} [options.filterOptions] - Les propriétés possibles de cet objet sont décrites ci-après.
 * @param {Object} [options.filterOptions.bbox] - Emprise dans laquelle on souhaite effectuer la recherche.
 *      Les propriétés possibles de cet objet sont décrites ci-après.
 *      @param {Float} options.filterOptions.bbox.left - Abscisse du côté gauche de la BBOX
 *      @param {Float} options.filterOptions.bbox.right - Abscisse du côté droit de la BBOX
 *      @param {Float} options.filterOptions.bbox.top - Ordonnée supérieure de la BBOX
 *      @param {Float} options.filterOptions.bbox.bottom - Ordonnée inférieure de la BBOX
 *
 * @param {Array.<String>} [options.filterOptions.type = "StreetAddress"] - Type de l'objet recherché.
 *      Le service de géocodage du Géoportail permet de rechercher des 'PostionOfInterest' pour des toponymes, des 'StreetAddress'
 *      pour des adresses postales, et/ou des 'CadastralParcel' pour des parcelles cadastrales.
 *      D'autres types pourront être rajoutés selon l'évolution du service.
 *      Par défaut, type = ['StreetAddress'].
 *
 * @param {String} [options.filterOptions.[proprietes du filtre]] - Critère supplémentaire pour filtrer la recherche sous la forme
 *      d'un couple clé/valeur à définir selon les possibilités du serveur ajouté à la requête.
 *      Le service de géocodage du Géoportail permet de filtrer tous les résultats avec les propriétés :
 *          "municipality", "insee", et "department".
 *      Il permet aussi de filtrer les adresses postales avec les propriétés :
 *          "quality", "ID", "ID_TR" et "territory".
 *      Il permet de filtrer les toponymes avec les propriétés :
 *          "importance", "nature" et "territory".
 *      Enfin, il permet de filtrer les parcelles cadastrales avec les propriétés :
 *          "sheet", "section", et "absorbedcity". Pas de valeur par défaut.
 *
 * @param {Number} [options.maximumResponses] - Nombre de réponses maximal que l'on souhaite recevoir.
 *      Pas de valeur par défaut.
 *      Si le serveur consulté est celui du Géoportail, la valeur par défaut sera donc celle du service : 25.
 *
 * @param {Boolean} [options.returnFreeForm] - Indique si l'on souhaite en réponse un localisant concaténée plutôt que structuré.
 *      Pas de valeur par défaut. Si le serveur consulté est celui du Géoportail, la valeur par défaut sera donc celle du service : 'false'.
 *
 * @param {String} [options.srs] - Système de coordonnées dans lequel les paramètres géographiques en entrée et la réponse du service sont exprimés.
 *      Pas de valeur par défaut. Si le serveur consulté est celui du Géoportail, la valeur par défaut sera donc celle du service : 'EPSG:4326'.
 *
 * @example
 *   var options = {
 *      apiKey : null,
 *      serverUrl : 'http://localhost/service/',
 *      protocol : 'JSONP', // JSONP|XHR
 *      proxyURL : null,
 *      httpMethod : 'GET', // GET|POST
 *      timeOut : 10000, // ms
 *      rawResponse : false, // true|false
 *      scope : null, // this
 *      onSuccess : function (response) {},
 *      onFailure : function (error) {},
 *      // spécifique au service
 *      positions : [{lon:, lat:}, {lon:, lat:}],
 *      (...)
 *   };
 * @private
 */
function Geocode (options) {
    if (!(this instanceof Geocode)) {
        throw new TypeError(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("CLASS_CONSTRUCTOR", "Geocode"));
    }

    /**
     * Nom de la classe (heritage)
     * FIXME instance ou classe ?
     */
    this.CLASSNAME = "Geocode";

    // appel du constructeur par heritage
    _CommonService__WEBPACK_IMPORTED_MODULE_3__["default"].apply(this, arguments);

    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("Gp.Services.Geocode");
    this.logger.trace("[Constructeur Geocode (options)]");

    if (!options.location) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_MISSING", "location"));
    }

    // FIXME ECMAScript 5 support
    if (typeof options.location === "object" && Object.keys(options.location).length === 0) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_EMPTY", "location"));
    } else if (typeof options.location === "string" && options.location.length === 0) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_EMPTY", "location"));
    }

    // ajout des options spécifiques au service
    this.options.location = options.location;

    // on definit des filtres apr defaut
    if (!options.filterOptions || typeof options.filterOptions !== "object") {
        this.options.filterOptions = options.filterOptions = {
            type : ["StreetAddress"]
        };
    }

    // FIXME ECMAScript 5 support (valable pour un objet uniquement !)
    // ceci permet de tester le cas où 'options.filterOptions' : {}
    if (Object.keys(options.filterOptions).length === 0) {
        this.options.filterOptions = {
            type : ["StreetAddress"]
        };
    }

    var filter = Object.keys(options.filterOptions);
    for (var i = 0; i < filter.length; i++) {
        var key = filter[i];
        // on transforme certains filtres qui pourraient être numériques en string
        var filtersCouldBeNumberList = ["department", "number", "postalCode", "insee", "importance", "ID", "IDTR", "absorbedCity", "sheet", "section", "inseeRegion", "inseeDepartment"];
        if (filtersCouldBeNumberList.indexOf(key) !== -1 && typeof options.filterOptions[key] !== "string") {
            options.filterOptions[key] = options.filterOptions[key].toString();
        }
        // on supprime les filtres vides
        if (!options.filterOptions[key]) {
            delete this.options.filterOptions[key];
        }
    }

    this.options.filterOptions.type = options.filterOptions.type || ["StreetAddress"];
    this.options.maximumResponses = options.maximumResponses || 25;
    this.options.returnFreeForm = options.returnFreeForm || false;
    this.options.srs = options.srs || "EPSG:4326";

    // attributs d'instances

    /**
     * Format forcé de la réponse du service : "xml"
     * sauf si l'on souhaite une reponse brute (options.rawResponse)
     */
    this.options.outputFormat = (this.options.rawResponse) ? "" : "xml";
}

/**
 * @lends module:Geocode#
 */
Geocode.prototype = Object.create(_CommonService__WEBPACK_IMPORTED_MODULE_3__["default"].prototype, {
    // todo
    // getter/setter
});

/*
 * Constructeur (alias)
 */
Geocode.prototype.constructor = Geocode;

/**
 * Création de la requête (overwrite)
 *
 * @param {Function} error   - callback des erreurs
 * @param {Function} success - callback
 */
Geocode.prototype.buildRequest = function (error, success) {
    var options = {
        httpMethod : this.options.httpMethod,
        // options specifiques du service
        location : this.options.location,
        returnFreeForm : this.options.returnFreeForm,
        filterOptions : this.options.filterOptions,
        srs : this.options.srs,
        maximumResponses : this.options.maximumResponses
    };

    this.request = _Request_DirectGeocodeRequestFactory__WEBPACK_IMPORTED_MODULE_4__["default"].build(options);

    // on teste si la requete a bien été construite !
    (!this.request)
        ? error.call(this, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_REQUEST_BUILD")))
        : success.call(this, this.request);
};

/**
 * Analyse de la reponse (overwrite)
 *
 * @param {Function} error   - callback des erreurs
 * @param {Function} success - callback
 */
Geocode.prototype.analyzeResponse = function (error, success) {
    /* INFO :
         Etape 1 : Création de la requête
            -> Appel du format OpenLS pour créer une requête à partir des paramètres (par exemple)
              (soit directement une URL si GET, soit une requête XML si POST)
            /!\ tester si apiKey && serverUrl => on ne garde que serverUrl
            -> stockage de la requête dans this.request
         Etape 2 : Envoi de la requête selon le bon protocole
            -> appel du protocol JSONP ou XHR, et envoi (par ex send ()) (this.protocol)
            -> récupération de la réponse xml dans la fonction onSuccess () (this.response)
            -> si code HTTP 200 et pas de message d'erreur : etape 3
            -> si code HTTP != 200 : lancement de la fonction de callback onFailure avec le message d'erreur
         Etape 3 : Analyse de la réponse xml et construction du JSON (si rawResponse === false )
            -> appel du parser pour récupérer le xmlDocument
            -> appel du reader OpenLS pour lire les éléments et récupérer l'objet JSON
               correspondant au type de géocodage (défini dans les specs)
         Etape 4 : Lancement de la fonction de callback onSuccess avec la réponse :
            -> xmlResponse (si rawResponse === true)
            -> ou geocodedLocations
    */

    if (this.response) {
        var options = {
            response : this.response,
            rawResponse : this.options.rawResponse,
            onError : error,
            onSuccess : success,
            scope : this
        };

        _Response_DirectGeocodeResponseFactory__WEBPACK_IMPORTED_MODULE_5__["default"].build(options);
    } else {
        error.call(this, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EMPTY")));
    }
};

/* harmony default export */ __webpack_exports__["default"] = (Geocode);


/***/ }),
/* 88 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _Formats_XLS__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(89);
/* harmony import */ var _Formats_XLS_LocationUtilityService__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(93);
/* harmony import */ var _Formats_XLS_LocationUtilityService_GeocodeFilterExtension__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(96);
/* harmony import */ var _Request_model_StreetAddress__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(100);
/* harmony import */ var _Request_model_PositionOfInterest__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(102);
/* harmony import */ var _Request_model_CadastralParcel__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(103);
/* harmony import */ var _Request_model_Administratif__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(104);
/**
 * Creation d'une requête OpenLS en mode POST ou GET
 * (Factory)
 *
 * @module DirectGeocodeRequestFactory
 * @alias Gp.Services.Geocode.Request.DirectGeocodeRequestFactory
 * @private
 */









var DirectGeocodeRequestFactory = {

    /**
     * interface unique
     *
     * @method build
     * @static
     * @param {Object} options - options definies dans le composant Geocode
     *
     * @example
     *   var options = {
     *      httpMethod:
     *      // options specifiques du service
     *      location:
     *      returnFreeForm:
     *      filterOptions:
     *      srs:
     *      maximumResponses:
     *   };
     *   var result = DirectGeocodeRequestFactory.build(options);
     *   if (!result) {
     *       // error...
     *   }
     * @returns {String} request
     */
    build : function (options) {
        // logger
        var logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("DirectGeocodeRequestFactory");
        logger.trace(["DirectGeocodeRequestFactory::build()"]);

        var request = null;

        // gestion des filtres (table de geocodage) !
        // par defaut, on les ajoute toute ...
        var oFilter = new _Formats_XLS_LocationUtilityService_GeocodeFilterExtension__WEBPACK_IMPORTED_MODULE_3__["default"]();
        oFilter.addFilterExtensions(new _Request_model_Administratif__WEBPACK_IMPORTED_MODULE_7__["default"]());
        oFilter.addFilterExtensions(new _Request_model_StreetAddress__WEBPACK_IMPORTED_MODULE_4__["default"]());
        oFilter.addFilterExtensions(new _Request_model_PositionOfInterest__WEBPACK_IMPORTED_MODULE_5__["default"]());
        oFilter.addFilterExtensions(new _Request_model_CadastralParcel__WEBPACK_IMPORTED_MODULE_6__["default"]());

        // objet LUS
        // on peut aussi par un objet XLS::GeocodeRequest
        var oLUS = new _Formats_XLS_LocationUtilityService__WEBPACK_IMPORTED_MODULE_2__["default"]({
            location : options.location,
            returnFreeForm : options.returnFreeForm,
            filterOptions : options.filterOptions
        });
        oLUS.addFilter(oFilter);

        // Format XLS
        var oXLS = new _Formats_XLS__WEBPACK_IMPORTED_MODULE_1__["default"]({
            srsName : options.srs,
            maximumResponses : options.maximumResponses
        });
        oXLS.namespace = true;
        oXLS.setService(oLUS);

        // request brute !
        request = oXLS.build();

        // en mode GET, la requête est encodée
        // et le param. 'qxml' est ajouté
        if (options.httpMethod === "GET") {
            var myRequest = "qxml=" +
                encodeURIComponent(request)
                    .replace(/-/g, "%2D")
                    .replace(/_/g, "%5F")
                    .replace(/\./g, "%2E")
                    .replace(/!/g, "%21")
                    .replace(/~/g, "%7E")
                    .replace(/\*/g, "%2A")
                    .replace(/'/g, "%27")
                    .replace(/\(/g, "%28")
                    .replace(/\)/g, "%29");
            request = myRequest;
        }

        logger.trace(request);

        return request;
    }
};

/* harmony default export */ __webpack_exports__["default"] = (DirectGeocodeRequestFactory);


/***/ }),
/* 89 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _XLS_RequestHeader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(90);
/* harmony import */ var _XLS_Request__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(91);
/* harmony import */ var _XLS_AbstractService__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(92);





/**
 * @classdesc
 *
 * standard OpenLS
 * standard XLS
 * (version 1.2)
 *
 * Réfs :
 *     - {@link http://schemas.opengis.net/ols/1.2/}
 *     - {@link http://www.opengeospatial.org/standards/ols}
 *     - {@link http://wxs.ign.fr/schemas/}
 *
 *
 * Création du template XLS (avec gestion des namespaces)
 * ------------------------
 * ```
 *   balise xsd : element name="XLS" attribute name="version" [(attribute ref="lang")]
 * ```
 *
 * Exemple :
 * ```
 * <XLS xmlns="http://www.opengis.net/xls" version="1.2">
 *   < (ref. OLS) />
 * </XLS>
 * ```
 * ```
 * <xls:XLS xmlns:xls="http://www.opengis.net/xls" version="1.2">
 *   <xls: (ref. OLS) />
 * </xls:XLS>
 * ```
 *
 * Création des templates OLS pour LocationUtilityService
 * ------------------------------------------------------
 *
 * Exemple :
 *
 * ```
 * <RequestHeader srsName="epsg:4326"/>
 * <Request maximumResponses="26" methodName="GeocodeRequest" requestID="uid1349081498314_388" version="1.2">
 *      <GeocodeRequest>
 *          <Address countryCode="PositionOfInterest">
 *              <freeFormAddress>saint mandé</freeFormAddress>
 *          </Address>
 *      </GeocodeRequest>
 *  </Request>
 * ```
 * ```
 * <RequestHeader sessionID="" />
 * <Request methodName="ReverseGeocodeRequest" version="1.2" requestID="" maximumResponses="10">
 *   <ReverseGeocodeRequest>
 *     <Position>
 *       <gml:Point xmlns:gml="http://www.opengis.net/gml">
 *           <gml:pos>50.347775 3.205098</gml:pos>
 *       </gml:Point>
 *     </Position>
 *     <ReverseGeocodePreference>StreetAddress</ReverseGeocodePreference>
 *  </ReverseGeocodeRequest>
 * </Request>
 * ```
 * ```
 * Geocodage direct (balise xsd) :
 *   element ref="RequestHeader" [ (attribute name="clientName" attribute name="clientPassword" attribute name="sessionID" attribute name="srsName" attribute name="MSID") ]
 *     element name="Request" attribute name="methodName" attribute name="version" attribute name="requestID" [ attribute name="maximumResponses" ]
 *       element name="GeocodeRequest" attribute name="returnFreeForm"
 *         element ref="xls:Address"
 * ```
 * ```
 * Geocodage inverse (balise xsd) :
 *   element ref="RequestHeader" [ (attribute name="clientName" attribute name="clientPassword" attribute name="sessionID" attribute name="srsName" attribute name="MSID") ]
 *     element name="Request" attribute name="methodName" attribute name="version" attribute name="requestID" [ attribute name="maximumResponses" ]
 *       element name="ReverseGeocodeRequest"
 *         element ref="xls:Position"
 *         element name="ReverseGeocodePreference" (enumeration)
 * ```
 *
 * Il existe 3 sous ensembles d'objets :
 *     - RequestHeader
 *     - Request
 *     - ReverseGeocodeRequest, GeocodeRequest
 *
 * GeocodeRequest est composé d'un objet {@link Gp.Services.Geocode.Response.GeocodeLocation}.
 * ReverseGeocodeRequest est composé d'un objet {@link Gp.Services.ReverseGeocode.Response.ReverseGeocodeLocation}.
 *
 * Les locations font appels aux objets suivants qui possèdent des attributs spécifiques
 * en fonction du type de table de geocodage interrogé :
 *     - StreetAddress
 *     - CadastralParcel
 *     - PositionOfInterest
 *     - Administratif
 *
 *
 * et des élements sous jacents tels que :
 *     - ReverseGeocodePreference -> tables de geocodages :
 *         - StreetAddress
 *         - CadastralParcel
 *         - PositionOfInterest
 *         - Administratif (une balise par table)
 *     - Position -> standard GML 3.2.1
 *     - Address  -> cf. ci-dessous
 *
 * ```
 * Position (balise xsd) :
 *   ex. <Position><gml:Point xmlns:gml="http://www.opengis.net/gml"><gml:pos>50.347775 3.205098</gml:pos></gml:Point></Position>
 *   ex. <Position><gml:CircleByCenterPoint xmlns:gml="http://www.opengis.net/gml"><gml:pos>48.85978570614691 2.2913572761128878</gml:pos><gml:radius>1000</gml:radius></gml:CircleByCenterPoint></Position>
 *   (au choix)
 *   element ref="gml:Point"
 *   element ref="gml:CircleByCenterPoint"
 *   element ref="gml:Polygon"
 *   element ref="gml:MultiPolygon"
 *   les autres elemennts ne sont pas implémentés (QoP, Speed, Direction, Time, ...)
 *
 * Address (balise xsd) :
 *   ex. <Address countryCode="StreetAddress"><freeFormAddress>1 r de paris saint denis</freeFormAddress></Address>
 *   attribute name="countryCode"
 *     element name="freeFormAddress"
 *     element ref="xls:Place"
 *     element ref="gml:Envelope"
 *  ou
 *   ex. <Address countryCode="StreetAddress"><StreetAddress><Street>1 rue Marconi</Street></StreetAddress><Place type="Municipality">Metz</Place><PostalCode>57000</PostalCode></Address>
 *   attribute name="countryCode"
 *     element ref="xls:StreetAddress"
 *     element ref="xls:PostalCode"
 *     element ref="xls:Place"
 *     element ref="gml:Envelope"
 *
 * Place  (balise xsd) :
 *  ex. <Place type="Municipality">Metz</Place>
 *  attribute name="type"
 *   enumeration value="CountrySubdivision"
 *   enumeration value="CountrySecondarySubdivision"
 *   enumeration value="Municipality"
 *   enumeration value="MunicipalitySubdivision"
 *   enumeration value="choume-banchi-go"
 *   enumeration value="Qualite"
 *   enumeration value="Departement"
 *   enumeration value="Bbox"
 *   enumeration value="Commune"
 *   enumeration value="Territoire"
 *   enumeration value="Importance"
 *   enumeration value="Nature"
 *   (la liste n'est pas exhaustives...)
 *
 * StreetAddress (balise xsd) :
 *   ex. <StreetAddress><Street>1 rue Marconi</Street></StreetAddress>
 *   attribute name="locator"
 *    element name="xls:Building"
 *    element ref="xls:Street"
 *
 * Street (balise xsd) :
 *   ex. <Street>1 rue Marconi</Street>
 *   attribute name="officialName" (...)
 *
 * Building (balise xsd) :
 *   ex. <Building number="800"/>
 *   attribute name="number" attribute name="subdivision" attribute name="buildingName"
 *
 * PostalCode (balise xsd) :
 *   ex. <PostalCode>77182</PostalCode>
 *
 * ```
 *
 * Requête
 * -------
 *
 * 2 modes de requête sur les services : GET ou POST.
 *
 * Le mode GET n'est que l'encodage du XML en param (qxml) de la requête (donc pas d'implementation particulière ?)
 *
 * Modèle de classes
 * -----------------
 *
 * ```
 *                 ________  XLS ____________
 *               /            |               \
 *   RequestHeader      AbstractService    Request
 *                            ^
 *                      ______|________________________
 *           (extends) /                               \ (extends)
 *          LocationUtilityService                    RouteService
 *                    |                                    |
 *         ___________|___________                       (...)
 *       /                        \
 * GeocodeRequest          ReverseGeocodeRequest
 *      |                          |
 *      |                     _____|______
 *      |                    /            \
 *   Address              Preference  Position
 *      |
 *    /   \
 * Place   StreetAddress
 *               |
 *             /   \
 *       Street   Building
 * ```
 *
 * @example
 * // encapsule un objet 'LocationUtilityService'
 * // dans une coquille XSL (avec/sans namespace)
 * xsl = new XSL ();
 * xsl.namespace = false;
 * xsl.srsName = "epsg:4326";
 * xsl.maximumResponses = 26;
 * //   methodName fournit par l'objet 'lus'
 * //   requestID est calculé
 * xsl.setService (lus);
 * xsl.build ();
 * // out ->
 * // <XLS xmlns="http://www.opengis.net/xls" version="1.2">
 * // <RequestHeader srsName="epsg:4326"/>
 * // <Request maximumResponses="26" methodName="GeocodeRequest" requestID="uid1349081498314_388" version="1.2">
 * //   < (ref. LocationUtilityService ou vide) />
 * //  </Request>
 * // </XLS>
 *
 *
 * @constructor
 * @alias Gp.Formats.XLS
 * @param {Object} options - options du constructeur
 * @param {Object} options.srsName - identifiant du Systeme de Coordonnees
 * @param {String}   options.maximumResponses - nombre de reponses max d'une requete
 * @param {Function} options.onsuccess - function callback success (TODO)
 * @param {Function} options.onerror   - function callback error   (TODO)
 *
 * @private
 */
function XLS (options) {
    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger();
    this.logger.trace("[Constructeur XLS()]");

    if (!(this instanceof XLS)) {
        throw new TypeError("XLS constructor cannot be called as a function.");
    }

    // options par defaut
    this.options = {
        srsName : "EPSG:4326",
        maximumResponses : 25
    };

    // et on ajoute les options en paramètre aux options par défaut
    for (var opt in options) {
        if (options.hasOwnProperty(opt)) {
            if (options[opt]) {
                this.options[opt] = options[opt];
            }
        }
    }
}

/**
 * Version
 */
XLS.VERSION = "1.2";

XLS.prototype = {

    /**
     * @lends module:XLS#
     */

    /**
     * request (out)
     * @type {String}
     */
    requestString : null,

    /**
     * namespace
     * Surcharge les balises XLS d'un prefixe.
     * Par defaut, false
     * @type {Boolean}
     */
    namespace : false,

    /**
     * Objet Service
     * LocationUtilityService ou RouteService
     * @type {AbstractService}
     */
    oService : null,

    /**
     * Constructeur (alias)
     */
    constructor : XLS,

    /**
     * Template de la requête.
     * substitution des valeurs suivantes :
     * __VERSION__, __NAMESPACE__, __SCHEMALOCATION__
     * __REQUESTHEADER__, __REQUEST__
     */
    template : "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
        "<XLS version=\"__VERSION__\"\n" +
        "__NAMESPACE__ \n" +
        "__SCHEMALOCATION__>\n" +
        "__REQUESTHEADER__\n" +
        "__REQUEST__\n" +
        "</XLS>\n",

    /**
     * Namespace par defaut.
     *
     * @returns {String} namespace
     */
    namespaceByDefault : function () {
        var ns = [
            "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"",
            "xmlns:xls=\"http://www.opengis.net/xls\"",
            "xmlns:gml=\"http://www.opengis.net/gml\""
        ];

        return ns.join(" ");
    },

    /**
     * Schemalocation par defaut
     *
     * @returns {String} schemaLocation
     */
    schemaLocationByDefault : function () {
        return "xsi:schemaLocation=\"http://www.opengis.net/xls http://schemas.opengis.net/ols/1.2/olsAll.xsd\"";
    },

    /**
     * Setter Service
     * Ajout d'un objet de type LocationUtilityService (LUS) ou RouteService
     *
     * @param {Object} oService - GeoceodeRequest / ReverseGeocodeRequest ou RouteRequest
     */
    setService : function (oService) {
        if (!oService) {
            this.logger.trace("L'objet de type Service XSL n'est pas encore defini !?");
            return;
        }

        if (oService instanceof _XLS_AbstractService__WEBPACK_IMPORTED_MODULE_3__["default"]) {
            this.oService = oService;
        } else {
            this.logger.error("L'objet n'est pas du type 'LocationUtilityService' ou 'RouteService' !?");
        }
    },

    /**
     * Getter Service
     * Retourne un objet de type LocationUtilityService (LUS) ou RouteService
     * ex. GeoceodeRequest / ReverseGeocodeRequest ou RouteRequest
     *
     * @returns {Object} service (LocationUtilityService|RouteService)
     */
    getService : function () {
        return this.oService;
    }
};

/**
 * Ajout d'un prefixe de namespace
 *
 * @todo impl. l'ajout de namespace
 * @param {Object} ns - ex. {key:xls, url:http://www.opengis.net/xls}
 * @param {String} request - requête
 * @returns {String} requête
 */
XLS.prototype.addNamespace = function (ns, request) {
    // INFO
    // on recherche la clef dans les namespaces par defaut.
    // si la clef n'existe pas dans les namespaceByDefault (), on l'ajoute.
    // on surcharge toutes les balises, ex. XLS -> xls:XLS
    // sauf celles qui sont déjà prefixées !

    var keyNS = ns.key;
    // var urlNS = ns.url; // TODO not yet implemented !

    // recherche la clef dans les namespaces par defaut
    var bFound = false;
    var allNS = this.namespaceByDefault().split(" ");
    for (var index = 0; index < allNS.length; index++) {
        var element = allNS[index];
        var map = element.split("=");
        var key = map[0];
        // var url = map[1]; // TODO not yet implemented !

        if (key === "xmlns:" + keyNS) {
            bFound = true;
            break;
        }
    }

    // TODO
    // si on a une nouvelle clef, on l'ajoute...
    if (!bFound) {
        this.logger.warn("L'ajout d'un nouvel namespace n'est pas encore implémenté !");
        return request;
    }

    // surcharge toutes les balises
    var regex;
    var subst;

    // regex balise ouvrante
    regex = /<(\w+[\s>])/g;
    subst = "<" + keyNS + ":$1";
    request = request.replace(regex, subst);

    // regex balise fermante
    regex = /<\/(\w+[\s>])/g;
    subst = "</" + keyNS + ":$1";
    request = request.replace(regex, subst);

    this.logger.trace("namespace", request);

    return request;
};

/**
 * Construction de la requête
 * @returns {String} requête
 */
XLS.prototype.build = function () {
    // out ->
    // <XLS xmlns="http://www.opengis.net/xls" version="1.2">
    // <RequestHeader srsName="epsg:4326"/>
    // <Request maximumResponses="26" methodName="GeocodeRequest" requestID="uid1349081498314_388" version="1.2">
    //   < (ref. LocationUtilityService ou vide) />
    //  </Request>
    // </XLS>

    // as t on un objet de type Service XLS à disposition ?
    var bService = !!this.getService();

    var template = "";
    template = this.template;
    template = template.replace(/__VERSION__/g, XLS.VERSION);
    template = template.replace(/__NAMESPACE__/g, this.namespaceByDefault);
    template = template.replace(/__SCHEMALOCATION__/g, this.schemaLocationByDefault);

    // header
    var oHeader = new _XLS_RequestHeader__WEBPACK_IMPORTED_MODULE_1__["default"]({
        srsName : this.options.srsName
    });
    template = template.replace(/__REQUESTHEADER__/g, oHeader.toString());

    // request
    var oRequest = new _XLS_Request__WEBPACK_IMPORTED_MODULE_2__["default"]({
        maximumResponses : this.options.maximumResponses,
        version : XLS.VERSION, // FIXME même version ?
        methodName : bService ? this.getService().CLASSTYPE : null
    });
    template = template.replace(/__REQUEST__/g, oRequest.toString());

    // objet lus ou route
    if (bService) { // INFO : clef __REQUESTSERVICE__ dispo dans l'objet 'Request'
        template = template.replace(/<!-- __REQUESTSERVICE__ -->/g, this.getService().toString());
    }

    if (!template) {
        this.logger.warn("traduction tmpl : empty request !?");
        return;
    }

    // ajout d'un namespace
    if (this.namespace) {
        // ajout de xls par defaut
        template = this.addNamespace({
            key : "xls",
            url : "http://www.opengis.net/xls"
        }, template);
    }

    this.requestString = template;
    this.logger.trace("traduction tmpl", template);

    // on retourne qqchose !
    return this.requestString;
};

/* harmony default export */ __webpack_exports__["default"] = (XLS);


/***/ }),
/* 90 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);


/**
 * @classdesc
 *
 * Entête de la requête XSL
 *
 * @example
 * // header XSL
 * header = new RequestHeader ();
 * header.srsName = "epsg:4326";
 * header.toString();
 * // out ->
 * // <RequestHeader srsName="epsg:4326"/>
 *
 * @constructor
 * @alias Gp.Formats.XLS.RequestHeader
 * @param {Object} options - options
 * @param {Object}   options.srsName - projection
 * @param {Function} options.onsuccess - function callback success (TODO)
 * @param {Function} options.onerror   - function callback error   (TODO)
 *
 * @private
 */
function RequestHeader (options) {
    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger();
    this.logger.trace("[Constructeur RequestHeader ()]");

    if (!(this instanceof RequestHeader)) {
        throw new TypeError("RequestHeader constructor cannot be called as a function.");
    }

    // options par defaut
    this.options = options || {
        srsName : "EPSG:4326"
    };

    // et on ajoute les options en paramètre aux options par défaut
    for (var opt in options) {
        if (options.hasOwnProperty(opt)) {
            this.options[opt] = options[opt];
        }
    }
}

RequestHeader.prototype = {

    /**
     * @lends module:RequestHeader#
     */

    /**
     * request (out)
     * @type {String}
     */
    requestString : null,

    /**
     * Template de la requête.
     * substitution des valeurs suivantes :
     * __SRSNAME__
     */
    template : "<RequestHeader srsName=\"__SRSNAME__\"/>",

    /**
     * Constructeur (alias)
     */
    constructor : RequestHeader,

    /**
     * toString
     * @returns {String} requête
     */
    toString : function () {
        var template = null;
        template = this.template;
        template = template.replace(/__SRSNAME__/g, this.options.srsName);
        this.requestString = template;
        return this.requestString;
    }
};

/* harmony default export */ __webpack_exports__["default"] = (RequestHeader);


/***/ }),
/* 91 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* jshint bitwise: false */


/**
 * @classdesc
 *
 * Requête XLS
 *
 * @example
 * // request XSL
 * request = new Request ();
 * request.maximumResponses = 26;
 * request.methodName = "GeocodeRequest";
 * request.version = "1.2";
 * request.toString();
 * // out ->
 * // <Request maximumResponses="26" methodName="GeocodeRequest" requestID="uid1349081498314_388" version="1.2">
 * //   <!-- __LUS__ -->
 * //  </Request>
 *
 * @constructor
 * @alias Gp.Formats.XLS.Request
 * @param {Object} options - options
 * @param {Object}   options.maximumResponses - 25
 * @param {String}   options.methodName - nom de l'objet LUS, "GeocodeRequest" | "ReverseGeocodeRequest"
 * @param {String}   options.version - '1.2'
 * @param {Function} options.onsuccess - function callback success (TODO)
 * @param {Function} options.onerror   - function callback error   (TODO)
 *
 * @private
 */
function Request (options) {
    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger();
    this.logger.trace("[Constructeur Request ()]");

    if (!(this instanceof Request)) {
        throw new TypeError("Request constructor cannot be called as a function.");
    }

    // options par defaut
    this.options = options || {
        maximumResponses : 25,
        methodName : null,
        version : "1.2"
    };

    // et on ajoute les options en paramètre aux options par défaut
    for (var opt in options) {
        if (options.hasOwnProperty(opt)) {
            this.options[opt] = options[opt];
        }
    }
}

Request.prototype = {

    /**
     * @lends module:Request#
     */

    /**
     * request (out)
     * @type {String}
     */
    requestString : null,

    /**
     * Template de la requête.
     * substitution des valeurs suivantes :
     * __MAXRESPONSES__, __METHODNAME__, __UUID__, __VERSION__
     * __REQUESTSERVICE__
     */
    template : "<Request maximumResponses=\"__MAXRESPONSES__\" methodName=\"__METHODNAME__\" requestID=\"__UUID__\" version=\"__VERSION__\">" +
        "<!-- __REQUESTSERVICE__ -->" +
        "</Request>",

    /**
     * Constructeur (alias)
     */
    constructor : Request,

    /**
     * an rfc4122 version 4 compliant guid
     * @returns {String} guid
     */
    guid : function () {
        // INFO
        // cf. http://byronsalau.com/blog/how-to-create-a-guid-uuid-in-javascript/
        return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function (c) {
            var r = Math.random() * 16 | 0;
            var v = c === "x" ? r : (r & 0x3 | 0x8);
            return v.toString(16);
        });
    },

    /**
     * toString
     * @returns {String} requête
     */
    toString : function () {
        var template = null;
        template = this.template;
        template = template.replace(/__MAXRESPONSES__/g, this.options.maximumResponses);
        template = template.replace(/__METHODNAME__/g, this.options.methodName);
        template = template.replace(/__UUID__/g, this.guid());
        template = template.replace(/__VERSION__/g, this.options.version);

        this.requestString = template;
        return this.requestString;
    }
};

/* harmony default export */ __webpack_exports__["default"] = (Request);


/***/ }),
/* 92 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);


/**
 * @classdesc
 * @private
 *
 * @constructor
 * @alias Gp.Formats.XLS.AbstractService
 *
 * @param {Object} [options] - options
 */
function AbstractService (options) {
    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger();
    this.logger.trace("[Constructeur AbstractService ()]");

    if (!(this instanceof AbstractService)) {
        throw new TypeError("AbstractService constructor cannot be called as a function.");
    }

    // options par defaut
    this.options = options || {};

    // et on ajoute les options en paramètre aux options par défaut
    for (var opt in options) {
        if (options.hasOwnProperty(opt)) {
            this.options[opt] = options[opt];
        }
    }
}

/**
 * @lends module:AbstractService#
 */
AbstractService.prototype = {

    /**
     * request (out)
     * @type {String}
     */
    strRequest : null,

    /**
     * objet Request
     * @type {Request}
     */
    oRequest : null,

    /**
     * Filter
     * @type {FilterExtension}
     */
    oFilter : null,

    /**
     * Constructeur (alias)
     */
    constructor : AbstractService,

    /**
     * Ajout d'un objet de type Request : GeocodeRequest / ReverseGeocodeRequest / RouteRequest
     *
     * @param {Object} oRequest - GeocodeRequest / ReverseGeocodeRequest / RouteRequest
     */
    addRequest : function (oRequest) {
        this.logger.error("overwritten method !");
    },

    /**
     * Ajout d'un objet de type FilterExtension : GeocodeFilterExtension ou RouteRequestExtension
     *
     * @param {Object} oFilter - GeocodeFilterExtension ou RouteRequestExtension
     */
    addFilter : function (oFilter) {
        this.logger.error("overwritten method !");
    },

    /**
     * toString
     */
    toString : function () {
        this.logger.error("overwritten method !");
    }
};

/* harmony default export */ __webpack_exports__["default"] = (AbstractService);


/***/ }),
/* 93 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _AbstractService__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(92);
/* harmony import */ var _LocationUtilityService_GeocodeRequest__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(94);
/* harmony import */ var _LocationUtilityService_ReverseGeocodeRequest__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(97);
/* harmony import */ var _LocationUtilityService_GeocodeFilterExtension__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(96);






/**
 * @classdesc
 *
 * Requête de type LocationUtilityService (LUS)
 * (Factory)
 *
 * @example
 * // encapsule un objet dans une coquille XSL, Factory sur les objets Geocode/ReverseGeocode
 * lus = new LocationUtilityService ();
 * lus.addRequest (req);
 * lus.toString();
 *  ou
 * lus = new LocationUtilityService ({
 *      location : "saint mandé",
 *      returnFreeForm : true,
 *      filterOptions : {
 *          type :  ['PositionOfInterest']
 *      }
 * });
 * lus.toString();
 *
 * // out ->
 * // <GeocodeRequest>
 * //   <Address countryCode="PositionOfInterest">
 * //     <freeFormAddress>saint mandé</freeFormAddress>
 * //   </Address>
 * // </GeocodeRequest>
 *
 * // creation de l'objet Geocode
 * req = new GeocodeRequest ();
 * req.addAddress (new Address (/*todo/*));
 * req.toString();
 * // out ->
 * // <GeocodeRequest>
 * //   <Address countryCode="PositionOfInterest">
 * //     <freeFormAddress>saint mandé</freeFormAddress>
 * //   </Address>
 * // </GeocodeRequest>
 *
 * // creation de l'objet ReverseGeocode
 * req = new ReverseGeocodeRequest ();
 * req.addPosition (new Position (position:{x: , y: }));
 * req.addPreference (['StreetAddress']);
 * req.toString();
 * // out ->
 * // <ReverseGeocodeRequest>
 * //     <Position>
 * //       <gml:Point xmlns:gml="http://www.opengis.net/gml">
 * //           <gml:pos>50.347775 3.205098</gml:pos>
 * //       </gml:Point>
 * //     </Position>
 * //     <ReverseGeocodePreference>StreetAddress</ReverseGeocodePreference>
 * //  </ReverseGeocodeRequest>
 *
 * @constructor
 * @alias Gp.Formats.XLS.LocationUtilityService
 * @param {Object} options - options
 * @param {Object}   options.location - location
 * @param {String}   options.position - position : {x : "", y : ""}
 * @param {String}   options.returnFreeForm - true|false
 * @param {Object}   options.filterOptions - filtres
 * @param {Function} options.onsuccess - function callback success (TODO)
 * @param {Function} options.onerror   - function callback error   (TODO)
 *
 * @private
 */
function LocationUtilityService (options) {
    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger();
    this.logger.trace("[Constructeur LocationUtilityService ()]");

    if (!(this instanceof LocationUtilityService)) {
        throw new TypeError("LocationUtilityService constructor cannot be called as a function.");
    }

    /**
     * Nom de la classe
     */
    this.CLASSNAME = "LocationUtilityService";

    /**
     * Type de classe de geocodage
     * ex. GeocodeRequest ou ReverseGeocodeRequest
     */
    this.CLASSTYPE = null;

    // appel du constructeur par heritage
    _AbstractService__WEBPACK_IMPORTED_MODULE_1__["default"].apply(this, arguments);

    // on determine le type de geocodage si les options sont renseignées
    if (this.options) {
        this.CLASSTYPE = (this.options.location) ? "GeocodeRequest" : (this.options.position) ? "ReverseGeocodeRequest" : null;
    }
}

/**
 * @lends module:LocationUtilityService#
 */
LocationUtilityService.prototype = Object.create(_AbstractService__WEBPACK_IMPORTED_MODULE_1__["default"].prototype, {
    // todo
    // getter/setter
});

/**
 * Constructeur (alias)
 */
LocationUtilityService.prototype.constructor = LocationUtilityService;

/**
 * (overwrite) Ajout d'un objet de type LUS : GeocodeRequest ou ReverseGeocodeRequest
 *
 * @param {Object} oLUSRequest - objet de type LUS
 */
LocationUtilityService.prototype.addRequest = function (oLUSRequest) {
    // on determine le type de geocodage
    this.CLASSTYPE = oLUSRequest.CLASSNAME;

    // on controle les types acceptés
    switch (this.CLASSTYPE) {
        case "GeocodeRequest":
        case "ReverseGeocodeRequest":
            this.oRequest = oLUSRequest;
            break;
        default:
            throw new Error("Ce n'est pas un objet de type 'LUS Request' !?");
    }
};

/**
 * (overwrite) Ajout d'un objet de type GeocodeFilterExtension
 *
 * @param {Object} oFilter - objet de type Filtre
 */
LocationUtilityService.prototype.addFilter = function (oFilter) {
    // FIXME gestion des filtres à partir des tables de geocodages
    if (oFilter instanceof _LocationUtilityService_GeocodeFilterExtension__WEBPACK_IMPORTED_MODULE_4__["default"]) {
        this.oFilter = oFilter;
    }
};

/**
 * (overwrite) toString
 *
 * @returns {String} requête
 */
LocationUtilityService.prototype.toString = function () {
    // soit, on a un objet LUS Request déjà instancié
    // sinon, il faut le construire à partir des options à disposition
    if (!this.oRequest) {
        // il nous faut des options
        if (!this.options) {
            throw new Error("Les options ne sont pas renseignées, impossible de construire la requête !");
        }

        // si les options 'location' et 'position' sont renseignées,
        // on prendra par defaut le choix du geocodage direct
        if (this.CLASSTYPE === "GeocodeRequest") {
            var settingsDirect = {
                location : this.options.location,
                returnFreeForm : this.options.returnFreeForm,
                filterOptions : this.options.filterOptions || {}
            };
            this.oRequest = new _LocationUtilityService_GeocodeRequest__WEBPACK_IMPORTED_MODULE_2__["default"](settingsDirect);
            // ajout des filtres spécifiques au service du geocodage direct de l'IGN
            if (this.oFilter) {
                this.oRequest.addFilter(this.oFilter);
            }
        } else if (this.CLASSTYPE === "ReverseGeocodeRequest") {
            var settingsInv = {
                position : this.options.position,
                returnFreeForm : this.options.returnFreeForm,
                filterOptions : this.options.filterOptions || {}
            };
            this.oRequest = new _LocationUtilityService_ReverseGeocodeRequest__WEBPACK_IMPORTED_MODULE_3__["default"](settingsInv);
        } else {
            this.logger.error("impossible de determiner le type de geocodage : Direct ou Inverse !?");
        }
    }

    // objet indefini !?
    if (!this.oRequest) {
        throw new Error("Type de Geocodage indefini !");
    }

    this.strRequest = this.oRequest.toString();
    return this.strRequest;
};

/* harmony default export */ __webpack_exports__["default"] = (LocationUtilityService);


/***/ }),
/* 94 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _model_Address__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(95);
/* harmony import */ var _GeocodeFilterExtension__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(96);




/**
 * @classdesc
 * Requête de geocodage direct
 *
 * ```
 * XSD
 * Geocodage direct (balise xsd) :
 *   element ref="RequestHeader" [ (attribute name="clientName" attribute name="clientPassword" attribute name="sessionID" attribute name="srsName" attribute name="MSID") ]
 *     element name="Request" attribute name="methodName" attribute name="version" attribute name="requestID" [ attribute name="maximumResponses" ]
 *       element name="GeocodeRequest" attribute name="returnFreeForm"
 *         element ref="xls:Address"
 * ```
 *
 * @example
 * // creation de l'objet Geocode an ajoutant un objet Address
 * req = new GeocodeRequest ();
 * req.returnFreeForm = true; // TODO !
 * req.addAddress (new Address ({
 *      location : "saint mandé",
 *      type : ['PositionOfInterest'],
 *      filter : {
 *          (...)
 *      }
 * }));
 * req.toString();
 * // out ->
 * // <GeocodeRequest>
 * //   <Address countryCode="PositionOfInterest">
 * //     <freeFormAddress>saint mandé</freeFormAddress>
 * //   </Address>
 * // </GeocodeRequest>
 *
 * // creation de l'objet Geocode avec les options uniquement
 * req = new GeocodeRequest ({
 *      location : "saint mandé",
 *      returnFreeForm : true,
 *      filterOptions : {
 *          type : ['PositionOfInterest'],
 *          (...)
 *      }
 * });
 * req.toString();
 * // out ->
 * // <GeocodeRequest>
 * //   <Address countryCode="PositionOfInterest">
 * //     <freeFormAddress>saint mandé</freeFormAddress>
 * //   </Address>
 * // </GeocodeRequest>
 * @constructor
 *
 * @alias Gp.Formats.XLS.LocationUtilityService.GeocodeRequest
 * @param {Object} options - options
 * @param {Object}   options.location - location
 * @param {String}   options.returnFreeForm - returnFreeForm
 * @param {String}   options.filterOptions - filtres
 * @param {Function} options.onsuccess - function callback success (TODO)
 * @param {Function} options.onerror   - function callback error   (TODO)
 *
 * @private
 */
function GeocodeRequest (options) {
    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger();
    this.logger.trace("[Constructeur GeocodeRequest ()]");

    if (!(this instanceof GeocodeRequest)) {
        throw new TypeError("GeocodeRequest constructor cannot be called as a function.");
    }

    // options par defaut
    this.options = options || {};

    // et on ajoute les options en paramètre aux options par défaut
    for (var opt in options) {
        if (options.hasOwnProperty(opt)) {
            this.options[opt] = options[opt];
        }
    }

    // TODO
    // gestion de l'option 'returnFreeForm' si elle n'est pas renseignée dans les options !

    /**
     * Nom de la classe (heritage)
     */
    this.CLASSNAME = "GeocodeRequest";
}

GeocodeRequest.prototype = {

    /**
     * @lends module:GeocodeRequest#
     */

    /**
     * request (out)
     * @type {String}
     */
    strRequest : null,

    /**
     * Addresse
     * @type {Address}
     */
    oAddress : null,

    /**
     * Filter
     * @type {GeocodeFilterExtension}
     */
    oFilter : null,

    /**
     * Template de la requête.
     * substitution des valeurs suivantes :
     * __ADDRESS__, __RETURNFREEFORM__
     */
    template : "<GeocodeRequest returnFreeForm=\"__RETURNFREEFORM__\">" +
        "__ADDRESS__" +
        "</GeocodeRequest>",

    /**
     * Ajout d'un objet de type Adresse
     *
     * @param {Object} oAddress - Adresse
     */
    addAddress : function (oAddress) {
        if (oAddress instanceof _model_Address__WEBPACK_IMPORTED_MODULE_1__["default"]) {
            this.oAddress = oAddress;
        }
    },

    /**
     * Ajout d'un objet de type GeocodeFilterExtension
     *
     * @param {Object} oFilter - GeocodeFilterExtension
     */
    addFilter : function (oFilter) {
        // FIXME gestion des filtres à partir des tables de geocodages
        if (oFilter instanceof _GeocodeFilterExtension__WEBPACK_IMPORTED_MODULE_2__["default"]) {
            this.oFilter = oFilter;
        }
    },

    /**
     * Constructeur (alias)
     */
    constructor : GeocodeRequest,

    /**
     * toString
     *
     * @returns {String} requête
     */
    toString : function () {
        var template = "";
        template = this.template;

        // soit on a déjà un objet Address instancié,
        // sinon, on le fabrique via les options
        if (!this.oAddress) {
            var settings = {};
            settings.location = this.options.location;
            settings.type = this.options.filterOptions.type || ["StreetAddress"];
            settings.filter = this.options.filterOptions;
            delete settings.filter.type; // on ne met pas le 'type' dans les filtres...

            // gestion des filtres
            if (this.oFilter) {
                // on reconstruit les filtres
                settings.filter = {};

                // on determine la liste des filtres possibles
                // pour chaque table de geocodage en param
                for (var idx in settings.type) {
                    var filter = settings.type[idx];
                    var oFilter = this.oFilter.getFilter(filter);

                    if (!oFilter) {
                        this.logger.warn("Le filtre '" + filter + "' n'existe pas !?");
                        continue;
                    }

                    var mFilter = this.options.filterOptions;

                    // correspondances des attributs de filtres possibles avec ceux qui sont en options
                    var attributs = oFilter.attributesList;
                    for (var idxe = 0; idxe < attributs.length; idxe++) {
                        var key = attributs[idxe];
                        if (mFilter[key]) {
                            var matchingKey = oFilter.serviceAttributes[idxe];
                            oFilter.placeAttributes[matchingKey] = mFilter[key];
                            this.logger.trace("Selection du filtre '" + key + "' sur le type '" + filter + "'.");
                        }
                    }

                    // ajout des valeurs des filtres
                    var places = oFilter.placeAttributes;
                    for (var kplace in places) {
                        if (places.hasOwnProperty(kplace)) {
                            settings.filter[kplace] = places[kplace];
                        }
                    }
                }
            }

            this.oAddress = new _model_Address__WEBPACK_IMPORTED_MODULE_1__["default"](settings);
            if (!this.oAddress) {
                throw new Error("La construction de l'adresse n'est pas correctement definie !?");
            }
        }

        // FIXME gestion des filtres pour un objet Address déjà instancié ?

        template = template.replace(/__ADDRESS__/g, this.oAddress.toString());
        template = template.replace(/__RETURNFREEFORM__/g, (this.options.returnFreeForm) ? "true" : "false");

        this.strRequest = template;
        return this.strRequest;
    }
};

/* harmony default export */ __webpack_exports__["default"] = (GeocodeRequest);


/***/ }),
/* 95 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);



/**
 * @classdesc
 *
 * Location type "Address".
 *
 * Modèles de classes :
 * ------------------
 * ```
 *
 *                Address
 *            (est composé de)
 *           ______ | _________ _________________
 *          /       |          \                 \
 *      Place (StreetAddress ou FreeFormAddress) PostalCode
 *       (*)       _|_
 *                /   \
 *           Street   Building
 * ```
 * ```
 * XSD
 * Address (balise xsd) :
 *   ex. <Address countryCode="StreetAddress"><freeFormAddress>1 r de paris saint denis</freeFormAddress></Address>
 *   attribute name="countryCode"
 *     element name="freeFormAddress"
 *     element ref="xls:Place"
 *     element ref="gml:Envelope"
 *  ou
 *   ex. <Address countryCode="StreetAddress"><StreetAddress><Street>1 rue Marconi</Street></StreetAddress><Place type="Municipality">Metz</Place><PostalCode>57000</PostalCode></Address>
 *   attribute name="countryCode"
 *     element ref="xls:StreetAddress"
 *     element ref="xls:PostalCode"
 *     element ref="xls:Place"
 *     element ref="gml:Envelope"
 * ```
 *
 * @example
 * // simple
 * adr = new Address ({
 *    location : "2 av pasteur, Saint-Mandée",
 *    type : ["StreetAddress"],
 *    filter : {}
 * });
 * adr.toString();
 * // -> out
 * // <Address countryCode="StreetAddress">
 * //   <freeFormAddress>2 av pasteur, Saint-Mandée</freeFormAddress>
 * // </Address>
 *
 * // avec filtre
 * adr = new Address ({
 *    location : {
 *      number : 2,
 *      street : "av pasteur",
 *      city : "Saint-Mandée", // FIXME filter Place "commune" ou "municipality" ?
 *      postalCode : "94166"   // FIXME filter Place ou balise PostalCode ?
 *    },
 *    type : ["StreetAddress"],
 *    filter : {
 *      territory : "FR",
 *      department : "94"
 *    }
 * });
 * adr.toString();
 * // -> out
 * // <Address countryCode="StreetAddress">
 * //   <StreetAddress>
 * //   <Building number="2"/>
 * //   <Street>2 av pasteur</Street>
 * // </StreetAddress>
 * // <Place type="municipality">Saint-Mandée</Place>
 * // <Place type="departement">94</Place>
 * // <Place type="territoire">FR</Place>
 * // <PostalCode>94166</PostalCode>
 * // </Address>
 *
 * // avec bbox
 * adr = new Address ({
 *    location : "2 av pasteur, Saint-Mandée",
 *    type : ["StreetAddress"],
 *    filter : {
 *      bbox : {left:1, right:2, top:2, bottom:0}
 *    }
 * });
 * adr.toString();
 * // -> out
 * // <Address countryCode="StreetAddress">
 * //   <freeFormAddress>2 av pasteur, Saint-Mandée</freeFormAddress>
 * //   <gml:Envelope>
 * //     <gml:lowerCorner>1 0</gml:lowerCorner>
 * //     <gml:upperCorner>2 2</gml:upperCorner>
 * //   </gl:Envelope>
 * // </Address>
 *
 * @constructor
 * @alias Gp.Formats.XLS.LocationUtilityService.Address
 * @param {Object} options - options
 * @param {Object} options.location - location
 * @param {String} options.type - type
 * @param {String} options.filter - filtres
 * @param {String} options.filter.* - Filtré en fonction des tables de geocodage interrogées
 *
 * @private
 */
function Address (options) {
    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("Address");
    this.logger.trace("[Constructeur Address ()]");

    if (!(this instanceof Address)) {
        throw new TypeError("Address constructor cannot be called as a function.");
    }

    // param par defaut
    this.options = options || {
        location : {},
        type : ["StreetAddress"],
        filter : {}
    };

    // param obligatoire
    if (!options.location) {
        throw new Error("l'option 'location' n'est pas renseignée !");
    }

    // et on ajoute les options en paramètre aux options par défaut
    for (var opt in options) {
        if (options.hasOwnProperty(opt)) {
            this.options[opt] = options[opt];
        }
    }
}

/**
 * @lends module:Address#
 */
Address.prototype = {

    /**
     * Constructeur (alias)
     */
    constructor : Address,

    /**
     * request (out)
     * @type {String}
     */
    requestString : null,

    /**
     * Template de la requête.
     *
     * substitution des valeurs suivantes :
     * - address :  __COUNTRYCODE__, __LOCATION__, __PLACE__, __POSTALCODE__, __ENVELOPE__
     * - freeFormAddress : __FREEFORMADDRESSVALUE__
     * - streetAddress : __STREET__, __BUILDING__
     * - street : __STREETVALUE__
     * - building : __BUILDINGVALUE__
     * - place : __PLACEATYPE__, __PLACEVALUE__
     * - postalCode : __POSTALCODEVALUE__
     * - gml:envelope : __LEFT__ __BOTTOM__ __RIGHT__ __TOP__
     *
     * @todo gestion de l"indentation
     */
    template : {
        address : "<Address countryCode=\"__COUNTRYCODE__\">" +
            "__LOCATION__" +
            "__PLACE__" +
            "__POSTALCODE__" +
            "__ENVELOPE__" +
            "</Address>",
        location : {
            freeFormAddress : "<freeFormAddress>__FREEFORMADDRESSVALUE__</freeFormAddress>",
            streetAddress : {
                container : "<StreetAddress>" +
                    "__STREET__" +
                    "__BUILDING__" +
                    "</StreetAddress>",
                building : "<Building number=\"__BUILDINGVALUE__\"/>",
                street : "<Street>__STREETVALUE__</Street>"
            }
        },
        place : "<Place type=\"__PLACETYPE__\">__PLACEVALUE__</Place>",
        postalCode : "<PostalCode>__POSTALCODEVALUE__</PostalCode>",
        envelope : "<gml:Envelope>" +
            "<gml:lowerCorner>__LEFT__ __BOTTOM__</gml:lowerCorner>" +
            "<gml:upperCorner>__RIGHT__ __TOP__</gml:upperCorner>" +
            "</gml:Envelope>"
    }

};

/**
 * toString
 *
 * @returns {String} requête
 */
Address.prototype.toString = function () {
    var template = null;
    template = this.template.address;
    template = template.replace(/__COUNTRYCODE__/g, this.options.type);

    // on a une adresse structurée ou libre ?
    if (typeof this.options.location === "string") {
        // balise freeFormeAddress
        var tmplFreeFormAddress = this.template.location.freeFormAddress;
        tmplFreeFormAddress = tmplFreeFormAddress.replace(/__FREEFORMADDRESSVALUE__/g, this.options.location);
        template = template.replace(/__LOCATION__/g, tmplFreeFormAddress);
    } else {
        // balises Street et Building
        var tmplBuilding = "";
        var tmplStreet = "";

        if (this.options.location.number) {
            tmplBuilding = this.template.location.streetAddress.building;
            tmplBuilding = tmplBuilding.replace(/__BUILDINGVALUE__/g, this.options.location.number);
        }

        if (this.options.location.street) {
            tmplStreet = this.template.location.streetAddress.street;
            tmplStreet = tmplStreet.replace(/__STREETVALUE__/g, this.options.location.street);
        }

        // balise streetAddress
        var tmplStreetAddress = this.template.location.streetAddress.container;
        tmplStreetAddress = tmplStreetAddress.replace(/__STREET__/g, tmplStreet);
        tmplStreetAddress = tmplStreetAddress.replace(/__BUILDING__/g, tmplBuilding);
        template = template.replace(/__LOCATION__/g, tmplStreetAddress);
    }

    // a t on un filtre de type PostalCode ?
    var tmplPostalCode = "";
    if (this.options.location.postalCode) {
        tmplPostalCode = this.template.postalCode;
        tmplPostalCode = tmplPostalCode.replace(/__POSTALCODEVALUE__/g, this.options.location.postalCode);
    }

    // a t on un filtre de type GML::Envelope ?
    var tmplEnvelope = "";
    if (this.options.filter) {
        var bbox = this.options.filter.bbox;
        if (bbox) {
            tmplEnvelope = this.template.envelope;
            tmplEnvelope = tmplEnvelope.replace(/__LEFT__/g, bbox.left);
            tmplEnvelope = tmplEnvelope.replace(/__BOTTOM__/g, bbox.bottom);
            tmplEnvelope = tmplEnvelope.replace(/__RIGHT__/g, bbox.right);
            tmplEnvelope = tmplEnvelope.replace(/__TOP__/g, bbox.top);
        }
    }

    // liste des filtres Place
    var Places = [];

    // a t on des filtres de type Place ?
    var tmplPlace = "";
    if (this.options.filter) {
        var filters = this.options.filter;
        for (var filter in filters) {
            if (filter === "bbox") {
                continue;
            }
            // FIXME gestion des filtres spécifiques IGN ?
            tmplPlace = this.template.place;
            tmplPlace = tmplPlace.replace(/__PLACETYPE__/g, filter);
            tmplPlace = tmplPlace.replace(/__PLACEVALUE__/g, filters[filter]);
            Places.push(tmplPlace);
        }
    }

    // a t on un filtre de type Place dans location ?
    var tmplPlaceCity = "";
    if (this.options.location.city) {
        tmplPlaceCity = this.template.place;
        tmplPlaceCity = tmplPlaceCity.replace(/__PLACETYPE__/g, "Municipality");
        tmplPlaceCity = tmplPlaceCity.replace(/__PLACEVALUE__/g, this.options.location.city);
        Places.push(tmplPlaceCity);
    }

    template = template.replace(/__POSTALCODE__/g, tmplPostalCode);
    template = template.replace(/__PLACE__/g, Places.join("\n"));
    template = template.replace(/__ENVELOPE__/g, tmplEnvelope);

    this.requestString = template;
    return this.requestString;
};

/* harmony default export */ __webpack_exports__["default"] = (Address);


/***/ }),
/* 96 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);



/**
 * @classdesc
 *
 * Ajouter des extensions de filtres spécifiques au service de geocodage de l'IGN.
 * Ceci permet de contrôler les options spécifiques de la table de geocodage intérrogées.
 *
 * @example
 * var ext =  new GeocodeFiltersExtension ();
 *     ext.add (new Administratif ());
 *     ext.add (new StreetAddress ());
 *     ext.add (new PositionOfInterest ());
 *     ext.add (new CadastralParcel ());
 *
 * ext.getNames ()
 * // --> out
 * // [Administratif, StreetAddress, PositionOfInterest, CadastralParcel]
 *
 * ext.getFilters ()
 * // --> out
 * // [Object, Object, Object, Object] = tableau d'objet GeocodeLocation
 *
 * ext.getFilter ('StreetAddress')
 * // --> out
 * // {Object} = objet GeocodeLocation
 *
 * ext.getAttributs ('StreetAddress')
 * // --> out
 * // ["bbox", "number", "ID", "IDTR", "postalCode", "quality", "street", "territoire", "commune", "department", "insee", "municipality"]
 *
 * ext.setPlaceAttributs ('StreetAddress', {number:'', territoire:'', quality:'', fake:''})
 * // --> out
 * // (fake est écarté car il n'appartient pas à la liste !)
 *
 * ext.getPlaceAttributs ('StreetAddress')
 * // --> out
 * // {number : '', territoire : '', quality : ''}
 *
 * // Comment ajouter des filtres spécifiques au service de geocodage ?
 * var req = new GeocodeRequest ({
 *      location : "saint mandé",
 *      returnFreeForm : true,
 *      filterOptions : {
 *          type : ['PositionOfInterest'], <-- ajouter une extension afin de gerer les attributs de cette table de geocodage !
 *          (...)
 *      }
 *  })
 *  req.addFilter (new PositionOfInterest ());
 * @constructor
 * @alias Gp.Formats.XLS.LocationUtilityService.GeocodeFilterExtension
 *
 * @private
 */
function GeocodeFilterExtension () {
    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("GeocodeFilterExtension");
    this.logger.trace("[Constructeur GeocodeFilterExtension ()]");

    if (!(this instanceof GeocodeFilterExtension)) {
        throw new TypeError("GeocodeFilterExtension constructor cannot be called as a function.");
    }

    /**
     * Tableau de filtres (table de geocodage)
     */
    this.filters = [];
}

/**
 * @lends module:GeocodeFilterExtension#
 */
GeocodeFilterExtension.prototype = {

    /**
     * Constructeur (alias)
     */
    constructor : GeocodeFilterExtension,

    /**
     * Ajout d'un filtre
     *
     * @param {Object} oGeocodeLocation - objet de type 'GeocodeLocation'
     */
    addFilterExtensions : function (oGeocodeLocation) {
        // FIXME test sur le type d'objet !
        if (oGeocodeLocation) {
            // FIXME ou test sur ses propriétés !
            this.filters.push(oGeocodeLocation);
        }
    },

    // getter

    /**
     * Tableau de noms (tables de geocodage)
     *
     * @returns {Array.<String>} liste des noms de filtres
     */
    getNames : function () {
        var names = [];
        for (var idx in this.filters) {
            names.push(this.filters[idx].CLASSNAME);
        }
        this.logger.trace(names);
        return names;
    },

    /**
     * Retourne une table de geocodage
     *
     * @param {String} name - nom de la table de geocodage
     * @returns {Object} filtre
     */
    getFilter : function (name) {
        var filter = null;
        for (var idx in this.filters) {
            if (this.filters[idx].CLASSNAME === name) {
                filter = this.filters[idx];
            }
        }
        this.logger.trace(filter);
        return filter;
    },

    /**
     * Tableau d'objects (tables de geocodage)
     *
     * @returns {Array.<Object>} liste des filtres
     */
    getFilters : function () {
        this.logger.trace(this.filters);
        return this.filters;
    },

    /**
     * Récupère la liste des attributs (filtres) sur une table de geocodage
     *
     * @param {String} name - nom de la table de geocodage
     * @returns {Array} liste des attributs d'un filtre
     */
    getAttributs : function (name) {
        var attributs = [];
        for (var idx in this.filters) {
            if (this.filters[idx].CLASSNAME === name) {
                attributs = this.filters[idx].attributesList;
            }
        }
        this.logger.trace(attributs);
        return attributs;
    },

    /**
     * Ajout des attributs (filtres) sur une table de geocodage
     *
     * @param {String} name - nom de la table de geocodage
     * @param {Object} options - options de la table de geocodage
     */
    setPlaceAttributs : function (name, options) {
        var filter = this.getFilter(name);
        var attributs = this.getAttributs(name);
        for (var idx in attributs) {
            var value = attributs[idx];
            if (options[value]) {
                filter.placeAttributes[value] = options[value];
            }
        }
    },

    /**
     * Retourne les attributs (filtres) sur une table de geocodage
     *
     * @param {String} name - nom de la table de geocodage
     * @returns {Array} liste des attributs d'un filtre
     */
    getPlaceAttributs : function (name) {
        var places = {};
        for (var idx in this.filters) {
            if (this.filters[idx].CLASSNAME === name) {
                places = this.filters[idx].placeAttributes;
            }
        }
        this.logger.trace(places);
        return places;
    }
};

/* harmony default export */ __webpack_exports__["default"] = (GeocodeFilterExtension);


/***/ }),
/* 97 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _model_Position__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(98);
/* harmony import */ var _model_Preference__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(99);





/**
 * @classdesc
 *
 * Requête de geocodage inverse
 *
 * XSD
 * ```
 * Geocodage inverse (balise xsd) :
 *   element ref="RequestHeader" [ (attribute name="clientName" attribute name="clientPassword" attribute name="sessionID" attribute name="srsName" attribute name="MSID") ]
 *     element name="Request" attribute name="methodName" attribute name="version" attribute name="requestID" [ attribute name="maximumResponses" ]
 *       element name="ReverseGeocodeRequest"
 *         element ref="xls:Position"
 *         element name="ReverseGeocodePreference" (enumeration)
 * ```
 *
 * @example
 * // creation de l"objet ReverseGeocode
 * req = new ReverseGeocodeRequest ();
 * req.addPosition (new Position (position:{x: , y: }));
 * req.addPreference (["StreetAddress"]);
 * req.toString();
 * // out ->
 * // <ReverseGeocodeRequest>
 * //     <Position>
 * //       <gml:Point xmlns:gml="http://www.opengis.net/gml">
 * //           <gml:pos>50.347775 3.205098</gml:pos>
 * //       </gml:Point>
 * //     </Position>
 * //     <ReverseGeocodePreference>StreetAddress</ReverseGeocodePreference>
 * //  </ReverseGeocodeRequest>
 * @constructor
 * @alias Gp.Formats.XLS.ReverseGeocodeRequest
 * @param {Object} options - options
 * @param {Object}   options.position - position
 * @param {String}   options.returnFreeForm - returnFreeForm
 * @param {String}   options.filterOptions - filtres
 * @param {Function} options.onsuccess - function callback success (TODO)
 * @param {Function} options.onerror   - function callback error   (TODO)
 *
 * @private
 */
function ReverseGeocodeRequest (options) {
    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger();
    this.logger.trace("[Constructeur ReverseGeocodeRequest ()]");

    if (!(this instanceof ReverseGeocodeRequest)) {
        throw new TypeError("ReverseGeocodeRequest constructor cannot be called as a function.");
    }

    // options par defaut
    this.options = options || {};

    // et on ajoute les options en paramètre aux options par défaut
    for (var opt in options) {
        if (options.hasOwnProperty(opt)) {
            this.options[opt] = options[opt];
        }
    }

    /**
     * Nom de la classe (heritage)
     */
    this.CLASSNAME = "ReverseGeocodeRequest";
}

ReverseGeocodeRequest.prototype = {

    /**
     * @lends module:ReverseGeocodeRequest#
     */

    /**
     * request (out)
     * @type {String}
     */
    strRequest : null,

    /**
     * Position
     * @type {Position}
     */
    oPosition : null,

    /**
     * Preference
     * @type {Preference}
     */
    oPreference : null,

    /**
     * Constructeur (alias)
     */
    constructor : ReverseGeocodeRequest,

    /**
     * Template de la requête.
     * substitution des valeurs suivantes :
     * __POSITION__, __PREFERENCE__, __RETURNFREEFORM__
     */
    template : "<ReverseGeocodeRequest returnFreeForm=\"__RETURNFREEFORM__\">" +
        "__POSITION__" +
        "__PREFERENCE__" +
        "</ReverseGeocodeRequest>",

    /**
     * Ajout d"un objet de type Position
     *
     * @param {Object} oPosition - Position
     */
    addPosition : function (oPosition) {
        if (oPosition instanceof _model_Position__WEBPACK_IMPORTED_MODULE_1__["default"]) {
            this.oPosition = oPosition;
        }
    },

    /**
     * Ajout d"une liste de table de référence LUS :
     * [StreetAddress, PointOfInterest, CadastralParcel, Administrativ]
     *
     * @param {Object} oPreference - Preference
     */
    addPreferences : function (oPreference) {
        if (oPreference instanceof _model_Preference__WEBPACK_IMPORTED_MODULE_2__["default"]) {
            this.oPreference = oPreference;
        }
    },

    /**
     * toString
     * @returns {String} requête
     */
    toString : function () {
        var template = "";
        template = this.template;

        // si on a déjà un objet Preference instancié,
        // sinon, on le fabrique via les options
        if (!this.oPreference) {
            this.oPreference = new _model_Preference__WEBPACK_IMPORTED_MODULE_2__["default"](this.options.filterOptions.type || ["StreetAddress"]);
            if (!this.oPreference) {
                throw new Error("Les preferences ne sont pas definies !?");
            }
        }
        template = template.replace(/__PREFERENCE__/g, this.oPreference.toString());

        // si on a déjà un objet Position instancié,
        // sinon, on le fabrique via les options
        if (!this.oPosition) {
            var settings = {
                position : this.options.position,
                filter : {}
            };

            // FIXME gestion des filtres ?
            if (this.options.filterOptions) {
                settings.filter = this.options.filterOptions;
                delete settings.filter.type; // pas besoin ?
            }
            this.oPosition = new _model_Position__WEBPACK_IMPORTED_MODULE_1__["default"](settings);
            if (!this.oPosition) {
                throw new Error("La position et ses filtres ne sont pas definis !?");
            }
        }
        template = template.replace(/__POSITION__/g, this.oPosition.toString());
        template = template.replace(/__RETURNFREEFORM__/g, (this.options.returnFreeForm) ? "true" : "false");

        this.strRequest = template;
        return this.strRequest;
    }
};

/* harmony default export */ __webpack_exports__["default"] = (ReverseGeocodeRequest);


/***/ }),
/* 98 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);


/**
 * @classdesc
 * Location de type Position
 *
 * ```
 * XSD
 * Position (balise xsd) :
 *   ex. <Position><gml:Point xmlns:gml="http://www.opengis.net/gml"><gml:pos>50.347775 3.205098</gml:pos></gml:Point></Position>
 *   ex. <Position><gml:CircleByCenterPoint xmlns:gml="http://www.opengis.net/gml"><gml:pos>48.85978570614691 2.2913572761128878</gml:pos><gml:radius>1000</gml:radius></gml:CircleByCenterPoint></Position>
 *   (au choix)
 *   element ref="gml:Point"
 *   element ref="gml:CircleByCenterPoint"
 *   element ref="gml:Polygon"
 *   element ref="gml:MultiPolygon"
 * ```
 *
 * FIXME les autres elements ne sont pas implémentés (QoP, Speed, Direction, Time, ...) ?
 *
 * ```
 * template : "<Position>
 *                  __GMLPOINT__
 *                  __GMLFILTER__
 *             </Position>"
 * ```
 * ```
 * GML : {
 *  pos     : "<gml:pos>__X__ __Y__</gml:pos>",
 *  point   : "<gml:Point xmlns:gml=\"http://www.opengis.net/gml\">__POS__</gml:Point>",
 *  circle  : "<gml:CircleByCenterPoint xmlns:gml=\"http://www.opengis.net/gml\">__POS__<gml:radius>__RADIUS__</gml:radius></gml:CircleByCenterPoint>",
 *  // not yet implemented !
 *  polygon      : "",
 *  multipolygon : ""
 * }
 * ```
 *
 * @constructor
 * @alias Gp.Formats.XLS.LocationUtilityService.Position
 * @param {Object} options - options données en entrée
 * @param {Object} options.position - x/y
 * @param {Object} options.filter - filtre
 * @param {Object} options.filter.circle - un cercle
 * @param {Object} options.filter.polygon - un polygone
 *
 * @private
 */
function Position (options) {
    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("Position");
    this.logger.trace("[Constructeur Position ()]");

    if (!(this instanceof Position)) {
        throw new TypeError("Position constructor cannot be called as a function.");
    }

    // param par defaut
    this.options = options || {};

    // param obligatoire
    if (!options.position) {
        throw new Error("l'option 'position' n'est pas renseignée !");
    }

    // et on ajoute les options en paramètre aux options par défaut
    for (var opt in options) {
        if (options.hasOwnProperty(opt)) {
            this.options[opt] = options[opt];
        }
    }
}

/**
 * @lends module:Position#
 */
Position.prototype = {

    /**
     * Constructeur (alias)
     */
    constructor : Position,

    /**
     * request (out)
     * @type {String}
     */
    requestString : null,

    /**
     * Template de la requête.
     *
     * substitution des valeurs suivantes :
     * __GMLPOINT__ __GMLFILTER__
     * __X__ __Y__ __RADIUS__
     * __XY__
     * @todo indentation XML
     * @todo implementation classe GML
     */
    template : {
        position : "<Position>" +
            "__GMLPOINT__" +
            "__GMLFILTER__" +
            "</Position>",
        gml : {
            point : "<gml:Point xmlns:gml=\"http://www.opengis.net/gml\"><gml:pos>__X__ __Y__</gml:pos></gml:Point>",
            pos : null,
            filter : {
                bbox : "<gml:Envelope xmlns:gml=\"http://www.opengis.net/gml\">" +
                    "<gml:lowerCorner>__LEFT__ __BOTTOM__</gml:lowerCorner>" +
                    "<gml:upperCorner>__RIGHT__ __TOP__</gml:upperCorner>" +
                    "</gml:Envelope>",
                circle : "<gml:CircleByCenterPoint xmlns:gml=\"http://www.opengis.net/gml\"><gml:pos>__X__ __Y__</gml:pos><gml:radius>__RADIUS__</gml:radius></gml:CircleByCenterPoint>",
                polygon : "<gml:Polygon xmlns:gml=\"http://www.opengis.net/gml\"><gml:exterior><gml:LinearRing><gml:posList>__XY__</gml:posList></gml:LinearRing></gml:exterior></gml:Polygon>",
                multipolygon : null
            }
        }
    }
};

/**
 * toString
 *
 * @returns {String} requête
 */
Position.prototype.toString = function () {
    var template = this.template.position;

    var tmplGmlPoint = this.template.gml.point;
    tmplGmlPoint = tmplGmlPoint.replace(/__X__/g, this.options.position.x);
    tmplGmlPoint = tmplGmlPoint.replace(/__Y__/g, this.options.position.y);

    var tmplGmlFilter = "";
    if (this.options.filter) {
        var filter = this.options.filter;

        for (var name in filter) {
            switch (name) {
                case "circle":
                    tmplGmlFilter = this.template.gml.filter[name];
                    tmplGmlFilter = tmplGmlFilter.replace(/__X__/g, filter[name].x);
                    tmplGmlFilter = tmplGmlFilter.replace(/__Y__/g, filter[name].y);
                    tmplGmlFilter = tmplGmlFilter.replace(/__RADIUS__/g, filter[name].radius);
                    break;
                case "bbox":
                    tmplGmlFilter = this.template.gml.filter[name];
                    tmplGmlFilter = tmplGmlFilter.replace(/__LEFT__/g, filter[name].left);
                    tmplGmlFilter = tmplGmlFilter.replace(/__BOTTOM__/g, filter[name].bottom);
                    tmplGmlFilter = tmplGmlFilter.replace(/__RIGHT__/g, filter[name].right);
                    tmplGmlFilter = tmplGmlFilter.replace(/__TOP__/g, filter[name].top);
                    break;
                case "polygon":
                    // FIXME implementation simple du polygone !
                    // aucun test de fermeture du polygone, ni de gestion des trous !
                    tmplGmlFilter = this.template.gml.filter[name];
                    var strPoints = "";
                    var lstPoints = filter[name];
                    for (var i = 0; i < lstPoints.length; i++) {
                        var coord = lstPoints[i];
                        if (Array.isArray(coord)) {
                            this.logger.error("Holes are not implemented !");
                            break;
                        }
                        if ((coord.x && coord.y) || (coord.x === 0 || coord.y === 0)) {
                            strPoints += coord.x + " " + coord.y;
                        }
                        if (lstPoints.length !== i + 1) {
                            strPoints += " ";
                        }
                    }
                    tmplGmlFilter = tmplGmlFilter.replace(/__XY__/g, strPoints);
                    break;
                case "multipolygon":
                    this.logger.warn("Filter '" + name + "' is not yet implemented !");
                    break;
                default:
                    this.logger.error("This filter '" + name + "' is not useful !");
            }
        }
    }

    template = template.replace(/__GMLPOINT__/g, tmplGmlPoint);
    template = template.replace(/__GMLFILTER__/g, tmplGmlFilter);

    this.requestString = template;
    return this.requestString;
};

/* harmony default export */ __webpack_exports__["default"] = (Position);


/***/ }),
/* 99 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);


/**
 * @classdesc
 *
 * Preference (Reverse)
 *
 * FIXME liste des types de tables de geocodage
 *
 * ```
 * template : "<ReverseGeocodePreference>__TYPE__</ReverseGeocodePreference>"
 * ```
 *
 * @constructor
 * @alias Gp.Formats.XLS.LocationUtilityService.Preference
 * @param {String} type - type de table de geocodage
 *
 * @private
 *
 */

function Preference (type) {
    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("Preference");
    this.logger.trace("[Constructeur Preference ()]");

    if (!(this instanceof Preference)) {
        throw new TypeError("Preference constructor cannot be called as a function.");
    }

    /**
     * type de table de geocodage
     * @type {Array.<String>}
     */
    this.type = type;
}

/**
 * @lends module:Preference#
 */
Preference.prototype = {

    /**
     * Constructeur (alias)
     */
    constructor : Preference,

    /**
     * request (out)
     * @type {String}
     */
    requestString : null,

    /**
     * Template de la requête.
     *
     * substitution des valeurs suivantes :
     *  __TYPE__
     *
     */
    template : "<ReverseGeocodePreference>__TYPE__</ReverseGeocodePreference>"
};

/**
 * toString
 *
 * @returns {String} requête
 */
Preference.prototype.toString = function () {
    var Preferences = [];
    var tmplPreference = "";
    for (var idx = 0; idx < this.type.length; idx++) {
        tmplPreference = this.template;
        tmplPreference = tmplPreference.replace(/__TYPE__/g, this.type[idx]);
        Preferences.push(tmplPreference);
    }

    this.strRequest = Preferences.join("\n");
    return this.strRequest;
};

/* harmony default export */ __webpack_exports__["default"] = (Preference);


/***/ }),
/* 100 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _GeocodeLocation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(101);



/**
 * @classdesc
 * Format des attributs d'un résultat de géocodage de type StreetAddress.
 *
 * @constructor
 * @alias Gp.Services.Geocode.Request.StreetAddress
 * @private
 */
function StreetAddress () {
    if (!(this instanceof StreetAddress)) {
        throw new TypeError("StreetAddress constructor cannot be called as a function.");
    }

    // INFO
    // appel du constructeur de la classe mère
    // avec passage de param.
    _GeocodeLocation__WEBPACK_IMPORTED_MODULE_0__["default"].apply(this, arguments);

    /**
     * Nom de la classe (heritage)
     * @type {String}
     */
    this.CLASSNAME = "StreetAddress";

    /**
     * Liste des attributs possibles pour une GeocodeLocation de type StreetAddress
     * - **bbox** : Emprise de l'adresse dans le système de coordonnées demandé {left, right, top, bottom}. *{Object}*
     * - **ID** : Identifiant BD ADRESSE dans le cas où le résultat est une adresse. *{String}*
     * - **IDTR** : Identifiant "Route Adresse" de la voie portant l'adresse dans la base BD ADRESSE. *{String}*
     * - **quality** : Indicateur de qualité du géocodage (pour plus d'infos : http://api.ign.fr/tech-docs-js/fr/developpeur/search.html *{String}*
     * - **territory** : Code du territoire français où se situe l'adresse *{String}*
     * - **commune** : Ville l'adresse. *{String}*
     * - **department** : Département l'adresse. *{String}*
     * - **insee** : Code INSEE de l'adresse. *{Number}*
     * - **municipality** : Municipalité de l'adresse. *{String}*
     */

    this.attributesList = ["bbox", "ID", "IDTR", "quality", "territory", "commune", "department", "insee", "municipality"];

    this.serviceAttributes = ["bbox", "ID", "IDTR", "Qualite", "Territoire", "Commune", "Departement", "INSEE", "Municipality"];
}

/**
 * @lends module:StreetAdress#
 */
StreetAddress.prototype = Object.create(_GeocodeLocation__WEBPACK_IMPORTED_MODULE_0__["default"].prototype);

/**
 * Constructeur (alias)
 */
StreetAddress.prototype.constructor = StreetAddress;

/* harmony default export */ __webpack_exports__["default"] = (StreetAddress);


/***/ }),
/* 101 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

/**
 * @classdesc
 *
 * Liste des attributs des tables de geocodage
 * @constructor
 * @alias Gp.Services.Geocode.Request.GeocodeLocation
 * @private
 */
function GeocodeLocation () {
    if (!(this instanceof GeocodeLocation)) {
        throw new TypeError("GeocodeLocation constructor cannot be called as a function.");
    }

    /**
     * Objet qui peut prendre comme propriétés les valeurs du tableau serviceAttributes
     * @type {Object}
     */
    this.placeAttributes = {};

    /**
     * Tableau qui liste les attributs spécifiques selon le type de la GeocodeLocation.
     * Ces attributs correspondent à ceux saisis par l'utilisateur (légèrement différents de ceux du service)
     * @type {String[]}
     */
    this.attributesList = [];

    /**
     * Tableau qui liste les attributs spécifiques selon le type de la GeocodeLocation
     * Ces attributs correspondent à ceux interprétés par le service (balises Place).
     * @type {String[]}
     */
    this.serviceAttributes = [];
}

/**
 * @lends module:GeocodeLocation
 */
GeocodeLocation.prototype = {

    /**
     * Constructeur (alias)
     */
    constructor : GeocodeLocation

};

/* harmony default export */ __webpack_exports__["default"] = (GeocodeLocation);


/***/ }),
/* 102 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _GeocodeLocation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(101);



/**
 * @classdesc
 * Format des attributs d'un résultat de géocodage de type PositionOfInterest
 *
 * @constructor
 * @alias Gp.Services.Geocode.Request.PositionOfInterest
 * @private
 */
function PositionOfInterest () {
    if (!(this instanceof PositionOfInterest)) {
        throw new TypeError("PositionOfInterest constructor cannot be called as a function.");
    }

    // INFO
    // appel du constructeur de la classe mère
    // avec passage de param.
    _GeocodeLocation__WEBPACK_IMPORTED_MODULE_0__["default"].apply(this, arguments);

    /**
     * Nom de la classe (heritage)
     * @type {String}
     */
    this.CLASSNAME = "PositionOfInterest";

    /**
     * Liste des attributs possibles pour une GeocodeLocation de type PositionOfInterest
     * - **bbox** : Emprise du toponyme dans le système de coordonnées demandé {left, right, top, bottom} *{Object}*
     * - **importance** : Importance du toponyme *{number}*
     * - **nature** : Nature du toponyme. *{String}*
     * - **territory** : Code du territoire français où se situe le toponyme *{String}*
     * - **commune** : Ville du toponyme. *{String}*
     * - **department** : Département du toponyme. *{String}*
     * - **insee** : Code INSEE de la commune où se situe le toponyme. *{Number}*
     * - **municipality** : Municipalité du toponyme. *{String}*
     */

    this.attributesList = ["bbox", "importance", "nature", "territory", "commune", "department", "insee", "municipality"];

    this.serviceAttributes = ["bbox", "Importance", "Nature", "Territoire", "Commune", "Departement", "INSEE", "Municipality"];
}

/**
 * @lends module:PositionOfInterest#
 */
PositionOfInterest.prototype = Object.create(_GeocodeLocation__WEBPACK_IMPORTED_MODULE_0__["default"].prototype);

/**
 * Constructeur (alias)
 */
PositionOfInterest.prototype.constructor = PositionOfInterest;

/* harmony default export */ __webpack_exports__["default"] = (PositionOfInterest);


/***/ }),
/* 103 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _GeocodeLocation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(101);



/**
 * @classdesc
 * Format des attributs d'un filtre de géocodage de type CadastralParcel.
 *
 * @constructor
 * @alias Gp.Services.Geocode.Request.CadastralParcel
 * @private
 */
function CadastralParcel () {
    if (!(this instanceof CadastralParcel)) {
        throw new TypeError("CadastralParcel constructor cannot be called as a function.");
    }

    // INFO
    // appel du constructeur de la classe mère
    // avec passage de param.
    _GeocodeLocation__WEBPACK_IMPORTED_MODULE_0__["default"].apply(this, arguments);

    /**
     * Nom de la classe (heritage)
     */
    this.CLASSNAME = "CadastralParcel";

    /**
     * Liste des attributs possibles pour une GeocodeLocation de type CadastralParcel
     * - **absorbedCity** : Code commune absorbée de la parcelle :
     *      lorsqu'une parcelle est issue p d'une ancienne commune qui a fusionné avec une autre.
     *      Sinon, le code vaut '000'. *{String}*
     * - **sheet** : Feuille de la parcelle (ex 1). *{String}*
     * - **number** : Numéro de la parcelle (ex. 0041) *{String}*
     * - **section** : Section de la parcelle (ex 0D). *{String}*
     * - **commune** : Ville du filtre. *{String}*
     * - **department** : Département du filtre. *{String}*
     * - **insee** : Code INSEE du filtre. *{Number}*
     * - **municipality** : Municipalité du filtre. *{String}*
     * - **origin** : L'origine de l'objet parcellaire renvoyé
     *      (correspond à l'attribut "type" dans la réponse XML)
     *      Pour plus d'informations : http://api.ign.fr/tech-docs-js/fr/developpeur/search.html#Recherche_par_parcelles_cadastrales *{Number}*
     *
     */

    this.attributesList = ["absorbedCity", "sheet", "number", "section", "commune", "department", "insee", "municipality", "origin"];

    this.serviceAttributes = ["CommuneAbsorbee", "Feuille", "Numero", "Section", "Commune", "Departement", "INSEE", "Municipality", "Type"];
}

/**
 * @lends module:CadastralParcel#
 */
CadastralParcel.prototype = Object.create(_GeocodeLocation__WEBPACK_IMPORTED_MODULE_0__["default"].prototype);

/**
 * Constructeur (alias)
 */
CadastralParcel.prototype.constructor = CadastralParcel;

/* harmony default export */ __webpack_exports__["default"] = (CadastralParcel);


/***/ }),
/* 104 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _GeocodeLocation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(101);



/**
 * @classdesc
 * Format des attributs d'un filtre de géocodage de type Administratif.
 * @constructor
 * @alias Gp.Services.Geocode.Request.Administratif
 * @private
 */
function Administratif () {
    if (!(this instanceof Administratif)) {
        throw new TypeError("Administratif constructor cannot be called as a function.");
    }

    // INFO
    // appel du constructeur de la classe mère
    // avec passage de param.
    _GeocodeLocation__WEBPACK_IMPORTED_MODULE_0__["default"].apply(this, arguments);

    /**
     * Nom de la classe (heritage)
     * @type {String}
     */
    this.CLASSNAME = "Administratif";

    /**
     * Liste des attributs possibles pour une GeocodedLocation de type Administratif
     * - **bbox** : Emprise de l'unité administrative dans le système de coordonnées demandé *{left, right, top, bottom}*
     * - **prefecture** - Nom de la préfécture de la région ou du département *{String}*
     * - **inseeRegion** - Numéro INSEE de la région *{String}*
     * - **inseeDepartment** - Numéro INSEE du département *{String}*
     * - **municipality** - Nom de l'unité administrative *{String}*
     *
     */

    this.attributesList = ["bbox", "prefecture", "inseeRegion", "inseeDepartment", "municipality"];

    this.serviceAttributes = ["bbox", "Prefecture", "InseeRegion", "InseeDepartement", "Municipality"];
}

/**
 * @lends module:Administratif#
 */
Administratif.prototype = Object.create(_GeocodeLocation__WEBPACK_IMPORTED_MODULE_0__["default"].prototype);

/**
 * Constructeur (alias)
 */
Administratif.prototype.constructor = Administratif;

/* harmony default export */ __webpack_exports__["default"] = (Administratif);


/***/ }),
/* 105 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(45);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44);
/* harmony import */ var _Formats_XML__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(66);
/* harmony import */ var _Formats_DirectGeocodeResponseReader__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(106);
/**
 * Factory pour générer une reponse JSON à partir d'un XML
 * ou d'un JSON encapsulant du XML
 * (Factory)
 *
 * @module GeocodeResponseFactory
 * @alias Gp.Services.Geocode.Response.GeocodeResponseFactory
 * @todo La reponse JSON peut encapsuler un XML !
 * @private
 */
// import Logger from "../../../Utils/LoggerByDefault";





var DirectGeocodeReponseFactory = {

    /**
     * interface unique
     *
     * @method build
     * @static
     * @param {Object} options - options definies dans le composant Geocode
     *
     * @example
     *   var options = {
     *      response :
     *      rawResponse :
     *      scope :
     *      onSuccess :
     *      onError :
     *   };
     *
     */
    build : function (options) {
        // data de type GeocodeResponse
        var data = null;

        if (options.response) {
            if (options.rawResponse) {
                data = options.response;
            } else {
                try {
                    var p = new _Formats_XML__WEBPACK_IMPORTED_MODULE_2__["default"]({
                        reader : _Formats_DirectGeocodeResponseReader__WEBPACK_IMPORTED_MODULE_3__["default"]
                    });

                    if (typeof options.response === "string") {
                        p.setXMLString(options.response);
                    } else {
                        p.setXMLDoc(options.response);
                    }

                    data = p.parse();

                    if (!data) {
                        throw new Error("L'analyse de la réponse du service !?");
                    }
                } catch (e) {
                    var message = e.message;
                    if (typeof options.response === "string") {
                        message += "('" + options.response + "')";
                    } else {
                        message += "('" + options.response.documentElement.innerHTML + "')";
                    }
                    options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_0__["default"]({
                        message : _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_ANALYSE", message),
                        type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_0__["default"].TYPE_UNKERR,
                        status : -1
                    }));
                    return;
                }

                // Si la réponse contenait une exception renvoyée par le service
                if (data.exceptionReport) {
                    options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_0__["default"]({
                        message : _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EXCEPTION", data.exceptionReport),
                        type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_0__["default"].TYPE_SRVERR,
                        status : 200 // FIXME : 200 ?
                    }));
                    return;
                }
            }
        } else {
            options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_0__["default"]({
                message : _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EMPTY"),
                type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_0__["default"].TYPE_SRVERR,
                status : -1 // FIXME : status response
            }));
            return;
        }

        options.onSuccess.call(options.scope, data);
    }
};

/* harmony default export */ __webpack_exports__["default"] = (DirectGeocodeReponseFactory);


/***/ }),
/* 106 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44);
/* harmony import */ var _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(45);
/* harmony import */ var _Response_model_GeocodeResponse__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(107);
/* harmony import */ var _Response_model_DirectGeocodedLocation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(108);

/**
 * Fonction retournant un objet contenant des clés de lecture (readers)
 *      qui permettent de parser des réponses XML du service de géocodage direct du Géoportail
 *      afin de récupérer les résultats retournés.
 * @module DirectGeocodeResponseReader
 * @alias Gp.Services.Geocode.Formats.DirectGeocodeResponseReader
 * @private
 */

// import Logger from "../../../Utils/LoggerByDefault";





/**
 * @member DirectGeocodeResponseReader
 */
var DirectGeocodeResponseReader = {};

/**
 * @property {String} DirectGeocodeResponseReader.VERSION - version du service de géocodage
 */
DirectGeocodeResponseReader.VERSION = "1.2";

/**
 * Objet stockant les différents namespaces et les URI associées
 */
DirectGeocodeResponseReader.NAMESPACES = {
    xmlns : "http://www.opengis.net/xls",
    gml : "http://www.opengis.net/gml",
    xls : "http://www.opengis.net/xls",
    xlsext : "http://www.opengis.net/xlsext",
    xsi : "http://www.w3.org/2001/XMLSchema-instance"
};

/**
 * Localisation (URL) du schema de définition du XML (XSD)
 */
DirectGeocodeResponseReader.SCHEMALOCATION = "http://wxs.ign.fr/schemas/olsAll.xsd";

/**
 * Namespace par défaut du format
 */
DirectGeocodeResponseReader.DEFAULTPREFIX = "xls";

/**
 * Objet contenant des fonctions de lecture, appelées "READERS"
 *      dont chaque clé correspond au nom d'un tag du XML que l'on souhaite lire
 *      et la valeur associée est une fonction (node, data)
 *      où node est un noeud du document DOM
 *      et data est un objet où l'on stocke les informations lues dans le XML.
 */
DirectGeocodeResponseReader.READERS = {

    xls : {

        /** TODO : jsdoc block */
        XLS : function (root) {
            var geocodeResponse = new _Response_model_GeocodeResponse__WEBPACK_IMPORTED_MODULE_2__["default"]();

            // vérification de la version du service, et des namespaces de l'en-tête
            __checkServiceAttributes(root);

            // puis lancement de la lecture de l'ensemble des noeuds, en bouclant sur les childNodes
            __getChildNodes(root, geocodeResponse);

            return geocodeResponse;
        },

        /** TODO : jsdoc block */
        GeocodedAddress : function (node, geocodeResponse) {
            var geocodedLocation = new _Response_model_DirectGeocodedLocation__WEBPACK_IMPORTED_MODULE_3__["default"]();

            __getChildNodes(node, geocodedLocation);

            // Ajout du résultat au tableau geocodedLocations de geocodeReponse
            if (geocodeResponse && Array.isArray(geocodeResponse.locations)) {
                geocodeResponse.locations.push(geocodedLocation);
            }
        },

        /** TODO : jsdoc block */
        GeocodeMatchCode : function (node, geocodedLocation) {
            var acc = node.getAttribute("accuracy");
            if (acc && geocodedLocation) {
                geocodedLocation.accuracy = parseFloat(acc);
            }
            var matchType = node.getAttribute("matchType");
            if (matchType && geocodedLocation) {
                geocodedLocation.matchType = matchType;
            }
        },

        /** TODO : jsdoc block */
        Address : function (node, geocodedLocation) {
            var countrycode = node.getAttribute("countryCode");
            if (geocodedLocation && countrycode) {
                geocodedLocation.type = countrycode;
            }
            // on va récupérer les autres informations (StreetAddress, place, postalCode...)
            __getChildNodes(node, geocodedLocation);
        },

        /** TODO : jsdoc block */
        freeFormAddress : function (node, geocodedLocation) {
            if (geocodedLocation && geocodedLocation.hasOwnProperty("placeAttributes")) {
                geocodedLocation.placeAttributes.freeform = __getChildValue(node);
            }
        },

        /** TODO : jsdoc block */
        Building : function (node, geocodedLocation) {
            var num = node.getAttribute("number");
            if (geocodedLocation && geocodedLocation.hasOwnProperty("placeAttributes")) {
                if (num) {
                    geocodedLocation.placeAttributes.number = num;
                } else if (node.getAttribute("buildingName")) {
                    geocodedLocation.placeAttributes.number = node.getAttribute("buildingName");
                } else if (node.getAttribute("subdivision")) {
                    geocodedLocation.placeAttributes.number = node.getAttribute("subdivision");
                }
            }
        },

        /** TODO : jsdoc block */
        Street : function (node, geocodedLocation) {
            if (geocodedLocation && geocodedLocation.hasOwnProperty("placeAttributes")) {
                // in case of a streetAddress result : street represents the street name
                if (geocodedLocation.type === "StreetAddress") {
                    geocodedLocation.placeAttributes.street = __getChildValue(node);

                    // in case of a cadastral parcel result : street represents the cadastral parcel identifier
                } else if (geocodedLocation.type === "CadastralParcel") {
                    geocodedLocation.placeAttributes.cadastralParcel = __getChildValue(node);
                }
            }
        },

        /** TODO : jsdoc block */
        Place : function (node, geocodedLocation) {
            var placeType = node.getAttribute("type");
            var placeName = __getChildValue(node);

            if (geocodedLocation && geocodedLocation.hasOwnProperty("placeAttributes")) {
                if (placeType === "Municipality") {
                    geocodedLocation.placeAttributes.municipality = placeName;
                } else if (placeType === "Bbox") {
                    var values = placeName.split(";");
                    if (values.length === 4) {
                        geocodedLocation.placeAttributes.bbox = {
                            left : parseFloat(values[0]),
                            right : parseFloat(values[2]),
                            top : parseFloat(values[1]),
                            bottom : parseFloat(values[3])
                        };
                    }
                } else if (placeType === "Commune") {
                    geocodedLocation.placeAttributes.commune = placeName;
                } else if (placeType === "Departement") {
                    geocodedLocation.placeAttributes.department = placeName;
                } else if (placeType === "INSEE") {
                    geocodedLocation.placeAttributes.insee = placeName;
                } else if (placeType === "Qualite") {
                    geocodedLocation.placeAttributes.quality = placeName;
                } else if (placeType === "Territoire") {
                    geocodedLocation.placeAttributes.territory = placeName;
                } else if (placeType === "ID") {
                    geocodedLocation.placeAttributes.ID = placeName;
                } else if (placeType === "ID_TR") {
                    geocodedLocation.placeAttributes.IDTR = placeName;
                } else if (placeType === "Importance") {
                    geocodedLocation.placeAttributes.importance = parseInt(placeName, 10);
                } else if (placeType === "Nature") {
                    geocodedLocation.placeAttributes.nature = placeName;
                } else if (placeType === "Numero") {
                    geocodedLocation.placeAttributes.number = placeName;
                } else if (placeType === "Feuille") {
                    geocodedLocation.placeAttributes.sheet = placeName;
                } else if (placeType === "Section") {
                    geocodedLocation.placeAttributes.section = placeName;
                } else if (placeType === "CommuneAbsorbee") {
                    geocodedLocation.placeAttributes.absorbedCity = placeName;
                } else if (placeType === "Arrondissement") {
                    if (placeName) {
                        geocodedLocation.placeAttributes.arrondissement = placeName;
                    }
                } else if (placeType === "Type") {
                    geocodedLocation.placeAttributes.origin = placeName;
                } else if (placeType === "Prefecture") {
                    geocodedLocation.placeAttributes.prefecture = placeName;
                } else if (placeType === "InseeRegion") {
                    geocodedLocation.placeAttributes.inseeRegion = placeName;
                } else if (placeType === "InseeDepartment") {
                    geocodedLocation.placeAttributes.inseeDepartment = placeName;
                }
            }
        },

        /** TODO : jsdoc block */
        PostalCode : function (node, geocodedLocation) {
            if (geocodedLocation && geocodedLocation.hasOwnProperty("placeAttributes")) {
                geocodedLocation.placeAttributes.postalCode = __getChildValue(node);
            }
        },

        /** TODO : jsdoc block */
        Error : function (node) {
            // on imagine qu'on a une balise ainsi :
            // <Error message="Message..." errorCode="InternalServerError"/>
            var srvMess = node.getAttribute("message");
            var errorCode = node.getAttribute("errorCode");
            var message = _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_0__["default"].getMessage("SERVICE_RESPONSE_EXCEPTION",
                "(" + errorCode + ") : " + srvMess);
            throw new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_1__["default"]({
                message : message,
                type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_1__["default"].TYPE_SRVERR
            });
        }
    },

    gml : {

        /** TODO : jsdoc block */
        pos : function (node, geocodedLocation) {
            var pos = __getChildValue(node);
            if (geocodedLocation && pos) {
                geocodedLocation.position = {
                    x : parseFloat(pos.split(" ")[0]),
                    y : parseFloat(pos.split(" ")[1])
                };
            }
        }
    },

    /** TODO : jsdoc block */
    ExceptionReport : function (node) {
        var response = {};
        if (node.hasChildNodes()) {
            var children = node.childNodes;
            var child;
            for (var i = 0; i < children.length; i++) {
                child = children[i];
                if (child.nodeName === "Exception") {
                    response.exceptionReport = DirectGeocodeResponseReader.READERS["Exception"](child);
                }
            }
        }
        return response;
    },

    /** TODO : jsdoc block */
    Exception : function (node) {
        var exceptionReport = {};

        // get exception code
        var exceptionCode = node.getAttribute("exceptionCode");
        if (exceptionCode) {
            exceptionReport.exceptionCode = exceptionCode;
        }

        // get exception message
        var textNode = node.firstChild;
        if (textNode && textNode.nodeType === 3) { // 3 === node.TEXT_NODE
            exceptionReport.exception = textNode.nodeValue;
        }

        return exceptionReport;
    }

};

/**
 * Méthode permettant de lancer la lecture d'une réponse XML du service de géocodage,
 *      à l'aide des READERS de la classe.
 *
 * @method DirectGeocodeResponseReader.read
 * @param {DOMElement} root - racine de la réponse XML à lire
 * @return {Object} geocodeResponse|exceptionReport : l'objet contenant les informations de la réponse XML,
 *      sous la forme d'un objet GeocodeResponse, ou un objet littéral exceptionReport si le service a renvoyé une exception.
 * @static
 * @memberof DirectGeocodeResponseReader
 */
DirectGeocodeResponseReader.read = function (root) {
    if (root.nodeName === "XLS") {
        var nsPrefix = root.prefix;
        if (!nsPrefix) {
            nsPrefix = DirectGeocodeResponseReader.DEFAULTPREFIX;
        }
        var geocodeResponse = DirectGeocodeResponseReader.READERS[nsPrefix][root.nodeName](root);
        return geocodeResponse;
    } else if (root.nodeName === "ExceptionReport") {
        var exceptionReport = DirectGeocodeResponseReader.READERS[root.nodeName](root);
        return exceptionReport;
    } else {
        var mess = _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_0__["default"].getMessage("SERVICE_RESPONSE_ANALYSE", root.nodeName);
        throw new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_1__["default"]({
            message : mess,
            type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_1__["default"].TYPE_UNKERR,
            status : 200
        });
    }
};

/**
 * Récupération des attributs d'un noeud élément
 *
 * @private
 * @memberof DirectGeocodeResponseReader
 * @method __getAttributes
 * @param {DOMElement} node - noeud contenant l'attribut recherché
 * @return {Object} nodeAttributes - objet contenant les noms et valeurs des différents attributs
 */
function __getAttributes (node) {
    if (node.attributes.length > 0) {
        var nodeAttributes = {};
        var attributes = node.attributes;
        for (var i = 0; i < attributes.length; i++) {
            var attribute = attributes[i];
            nodeAttributes[attribute.nodeName] = attribute.nodeValue;
        }
        return nodeAttributes;
    }
}

/**
 * Récupération des noeuds enfants à partir d'un noeud donné, pour lecture (readNode).
 *
 * @private
 * @memberof DirectGeocodeResponseReader
 * @method __getChildNodes
 * @param {DOMElement} node - a DOM node
 * @param {Array|Object} [data] - an object to be filled with node data
 */
function __getChildNodes (node, data) {
    if (node.hasChildNodes()) {
        var children = node.childNodes;
        var child;
        var childName;
        var childPrefix;

        for (var i = 0; i < children.length; i++) {
            child = children[i];

            if (child.nodeType === 1) { // 1 === node.ELEMENT_NODE
                childName = child.localName || child.baseName || child.nodeName;
                childPrefix = child.prefix || DirectGeocodeResponseReader.DEFAULTPREFIX;

                if (DirectGeocodeResponseReader.READERS[childPrefix][childName]) {
                    var reader = DirectGeocodeResponseReader.READERS[childPrefix][childName];
                    reader(child, data);
                } else {
                    __getChildNodes(child, data);
                }
            }
        }
    }
}

/**
 * Lecture de la valeur du premier child d'un noeud, si elle existe.
 *
 * @private
 * @memberof DirectGeocodeResponseReader
 * @method __getChildValue
 * @param {DOMElement} node - a DOM node
 * @return {String} value - valeur du firstChild du noeud en entrée, ou chaîne vide.
 */
function __getChildValue (node) {
    var textNode;
    var value = "";

    if (node.hasChildNodes()) {
        textNode = node.firstChild;
        if (textNode.nodeType === 3) { // 3 === node.TEXT_NODE
            value = textNode.nodeValue;
        }
    }
    return value;
}

/**
 * Vérification des attributs du service, dans la balise XLS de la réponse :
 *      version, namespaces, et namespace par défaut doivent correspondre à ceux attendus.
 *
 * @private
 * @memberof DirectGeocodeResponseReader
 * @method __checkServiceAttributes
 * @param {DOMElement} XLSNode - a DOM node, corresponding to XLS first tag.
 */
function __checkServiceAttributes (XLSNode) {
    if (XLSNode.attributes.length > 0) {
        // on récupère et parcourt les attributs de la balise XLS de la réponse
        var xlsAttributes = __getAttributes(XLSNode);
        for (var att in xlsAttributes) {
            if (xlsAttributes.hasOwnProperty(att)) {
                // vérification de la version
                if (att === "version") {
                    if (xlsAttributes["version"] !== DirectGeocodeResponseReader.VERSION) {
                        console.log("[DirectGeocodeResponseReader] geocode version is not the expected one : there may be errors in parsing");
                        return;
                    }
                }

                // on vérifie que l'uri du namespace par défaut est bien celle que l'on attend
                if (att === "xmlns") {
                    if (xlsAttributes[att] !== DirectGeocodeResponseReader.NAMESPACES[DirectGeocodeResponseReader.DEFAULTPREFIX]) {
                        console.log("[DirectGeocodeResponseReader] geocode response default namespace is not the expected one");
                        return;
                    }
                    continue;
                }

                var prefix = att.split(":")[0];
                var ns = att.split(":")[1];

                // si on a un autre xmlns, on vérifie aussi les URI
                if (prefix === "xmlns" && ns) {
                    // si l'attribut correspond à un namespace défini dans le reader
                    if (DirectGeocodeResponseReader.NAMESPACES[ns]) {
                        // il faut que les URI correspondent aussi.
                        if (DirectGeocodeResponseReader.NAMESPACES[ns] !== xlsAttributes[att]) {
                            console.log("[DirectGeocodeResponseReader] geocode response " + att + " namespace is not the expected one");
                            return;
                        }
                    }
                }

                // pour finir on vérifie la localisation du schema XSD du service
                if (ns === "schemaLocation") {
                    if (DirectGeocodeResponseReader.SCHEMALOCATION !== xlsAttributes[att]) {
                        console.log("[DirectGeocodeResponseReader] geocode response schema location is not the expected one");
                        return;
                    }
                }
            }
        }
    }
}

/* harmony default export */ __webpack_exports__["default"] = (DirectGeocodeResponseReader);


/***/ }),
/* 107 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

/**
 * Response object for {@link module:Services~geocode Gp.Services.geocode ()} or {@link module:Services~reverseGeocode Gp.Services.reverseGeocode ()} invocation when successful. Received as the argument of onSuccess callback function.
 *
 * @property {Array.<Gp.Services.Geocode.DirectGeocodedLocation|Gp.Services.Geocode.ReverseGeocodedLocation>} locations - locations array.
 *
 * @namespace
 * @alias Gp.Services.GeocodeResponse
 */
function GeocodeResponse () {
    if (!(this instanceof GeocodeResponse)) {
        throw new TypeError("GeocodeResponse constructor cannot be called as a function.");
    }

    this.locations = [];
}

GeocodeResponse.prototype = {

    constructor : GeocodeResponse

};

/* harmony default export */ __webpack_exports__["default"] = (GeocodeResponse);


/***/ }),
/* 108 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _GeocodedLocation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(109);



/**
 * Single location object returned by the underlying geocoding web service.
 *
 * @property {Float} accuracy - Accuracy of the response towards the requested location between 0 (unaccurate) and 1 (exact match).
 *
 * @namespace
 * @extends {Gp.Services.Geocode.GeocodedLocation}
 * @alias Gp.Services.Geocode.DirectGeocodedLocation
 */
function DirectGeocodedLocation () {
    if (!(this instanceof DirectGeocodedLocation)) {
        throw new TypeError("DirectGeocodedLocation constructor cannot be called as a function.");
    }

    // INFO
    // appel du constructeur de la classe mère
    // avec passage de param.
    _GeocodedLocation__WEBPACK_IMPORTED_MODULE_0__["default"].apply(this, arguments);

    /**
     * Nom de la classe (heritage) : "DirectGeocodedLocation"
     * @type {String}
     */
    this.CLASSNAME = "DirectGeocodedLocation";

    this.accuracy = null;
}

DirectGeocodedLocation.prototype = Object.create(_GeocodedLocation__WEBPACK_IMPORTED_MODULE_0__["default"].prototype);

DirectGeocodedLocation.prototype.constructor = DirectGeocodedLocation;

/* harmony default export */ __webpack_exports__["default"] = (DirectGeocodedLocation);


/***/ }),
/* 109 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

/**
 * Location object holding common properties returned by the underlying geocoding and reverse geocoding web service.
 *
 * @property {Gp.Point} position - Position of the location given in the requested coordinates system.
 * @property {String} type - location type "StreetAddress" (for an address), "PositionOfInterest" (for a place name) or "CadastralParcel" (for cadastral parcel).
 * @property {String} matchType - how geocoding is performed : "street number" (exact address), "street enhanced" (street number calculated by interpolation), "street" (only the street), "city" (only the city).
 * @property {Object} placeAttributes - Associative array matching the following attributes with their values given by the underlying web service :
 *
 * *Common attributes : *
 *
 * - **freeform** - freeform complete Address.
 * - **bbox** - Bounding Box *{@link Gp.BBox}*.
 * - **municipality** - Municipality
 *
 * *if type === "StreetAddress" : *
 *
 * - **number** - Street number.
 * - **ID** - Identifier of the address in the [BD ADRESSE Database]{@link http://professionnels.ign.fr/bdadresse}.
 * - **IDTR** - Identifier of the lineString in the [BD ADRESSE Database]{@link http://professionnels.ign.fr/bdadresse}.
 * - **postalCode** - PostCode
 * - **quality** - Geocoding quality ([see]{@link http://api.ign.fr/tech-docs-js/developpeur/search.html})
 * - **street** - Street name
 * - **territory** - French Territory code
 * - **commune** - City
 * - **department** - Department
 * - **insee** - INSEE Code
 *
 *
 * *if type === "PositionOfInterest" :*
 *
 * - **importance** - Place name importance
 * - **nature** - Place name nature
 * - **postalCode** - PostCode
 * - **territory** - French Territory code
 * - **commune** - City
 * - **department** - Department
 * - **insee** - INSEE Code
 *
 *
 * *si type = "CadastralParcel" :*
 *
 * - **absorbedCity** - when a parcel comes from a city that was absorbed by another, code of that old city. "000" otherwise.
 * - **arrondissement** - arrondissement
 * - **cadastralParcel** - cadastral parcel code
 * - **district** - district
 * - **sheet** - Parcel Sheet (eg. "1").
 * - **number** - Parcel Number (eg. "0041")
 * - **section** - Parcel Section (eg. "0D").
 * - **commune** - Parcel municipality.
 * - **department** - Parcel Department.
 * - **insee** - INSEE Code.
 * - **origin** - Parcel origin (see "type" attribute in the [underlying web service response]{@link http://api.ign.fr/tech-docs-js/developpeur/search.html#Cadastral_parcels_search})
 *
 * @namespace
 * @alias Gp.Services.Geocode.GeocodedLocation
 */
function GeocodedLocation () {
    if (!(this instanceof GeocodedLocation)) {
        throw new TypeError("GeocodedLocation constructor cannot be called as a function.");
    }

    this.position = {
        x : null,
        y : null
    };

    this.matchType = null;

    this.placeAttributes = {};

    this.type = null;
}

GeocodedLocation.prototype = {

    constructor : GeocodedLocation

};

/* harmony default export */ __webpack_exports__["default"] = (GeocodedLocation);


/***/ }),
/* 110 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44);
/* harmony import */ var _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45);
/* harmony import */ var _CommonService__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46);
/* harmony import */ var _Request_ReverseGeocodeRequestFactory__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(111);
/* harmony import */ var _Response_ReverseGeocodeResponseFactory__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(112);








/**
 * @classdesc
 * Appel du service de géocodage inverse du Géoportail :
 *     envoi de la requête construite selon les paramètres en options,
 *     éventuellement parsing et analyse  de la réponse,
 *     retour d'une réponse en paramètre de la fonction onSuccess.
 * @constructor
 * @extends {Gp.Services.CommonService}
 * @alias Gp.Services.ReverseGeocode
 *
 * @param {Object} options - options spécifiques au service (+ les options heritées)
 *
 * @param {Object} options.position - Position du point de référence pour le calcul de proximité exprimée dans le système de référence spécifié par le srs.
 *      @param {Float} options.position.x - Abcisse du point de référence pour le calcul de proximité exprimée dans le système de référence spécifié par le srs. (= longitude si srs = "CRS:84", latitude si srs = "EPSG:4326")
 *      @param {Float} options.position.y - Ordonnée du point de référence pour le calcul de proximité exprimée dans le système de référence spécifié par le srs. (= latitude si srs = "CRS:84", longitude si srs = "EPSG:4326")
 *
 * @param {Object} [options.filterOptions] - Les propriétés possibles de cet objet sont décrites ci-après.
 * @param {Object} [options.filterOptions.bbox] - Emprise dans laquelle on souhaite effectuer la recherche.
 *      Les propriétés possibles de cet objet sont décrites ci-après.
 *      @param {Float} options.filterOptions.bbox.left   - Abscisse du côté gauche de la BBOX
 *      @param {Float} options.filterOptions.bbox.right  - Abscisse du côté droit de la BBOX
 *      @param {Float} options.filterOptions.bbox.top    - Ordonnée supérieure de la BBOX
 *      @param {Float} options.filterOptions.bbox.bottom - Ordonnée inférieure de la BBOX
 *
 * @param {Object} [options.filterOptions.circle] - Cercle dans lequel on souhaite effectuer la recherche.
 *      Les propriétés possibles de cet objet sont décrites ci-après.
 *      @param {Float} options.filterOptions.circle.x      - Abscisse du centre du cercle de recherche.
 *      @param {Float} options.filterOptions.circle.y      - Ordonnée du centre du cercle de recherche.
 *      @param {Float} options.filterOptions.circle.radius - Rayon du cercle de recherche.
 *
 * @param {Array.<Object>} [options.filterOptions.polygon] - Polygone dans lequel on souhaite effectuer la recherche.
 *      Liste des couples x et y pour chaque point constituant le polygone.
 *
 * @param {Array.<String>} [options.filterOptions.type = "StreetAddress"] - Type de l'objet recherché.
 *      Le service de géocodage du Géoportail permet de rechercher des 'PostionOfInterest' pour des toponymes, des 'StreetAddress'
 *      pour des adresses postales et/ou des 'CadastralParcel' pour des parcelles cadastrales.
 *      D'autres types pourront être rajoutés selon l'évolution du service.
 *      Par défaut, type = ['StreetAddress'].
 *
 * @param {Number} [options.maximumResponses] - Nombre de réponses maximal que l'on souhaite recevoir.
 *      Pas de valeur par défaut. Si le serveur consulté est celui du Géoportail, la valeur par défaut sera donc celle du service : 25.
 *
 * @param {String} [options.srs = CRS:84] - Système de coordonnées dans lequel les paramètres géographiques en entrée et la réponse du service sont exprimés.
 *      Pas de valeur par défaut.
 *      Si le serveur consulté est celui du Géoportail, la valeur par défaut est : "CRS:84".
 *
 * @example
 *   var options = {
 *      apiKey : null,
 *      serverUrl : 'http://localhost/service/',
 *      protocol : 'JSONP', // JSONP|XHR
 *      proxyURL : null,
 *      httpMethod : 'GET', // GET|POST
 *      timeOut : 10000, // ms
 *      rawResponse : false, // true|false
 *      scope : null, // this
 *      onSuccess : function (response) {},
 *      onFailure : function (error) {},
 *      // spécifique au service
 *      position : {x:0 , y:0},
 *      filterOptions :{
 *          bbox : {left : 0, right : 1, top : 1, bottom : 0},
 *          [circle : {
 *              x : 0,
 *              y : 0,
 *              radius : 100
 *          }]
 *          [polygon  : [{x:0,y:0}, {x:1,y:1}, {x:2,y:2}, {x:3,y:2}, {x:4,y:1}, {x:0,y:0}]]
 *          type : ['StreetAddress']
 *      },
 *      maximumResponses : 25,
 *      srs : 'EPSG:4326'
 *   };
 *
 * @private
 */
function ReverseGeocode (options) {
    if (!(this instanceof ReverseGeocode)) {
        throw new TypeError(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("CLASS_CONSTRUCTOR", "ReverseGeocode"));
    }

    /**
     * Nom de la classe (heritage)
     * FIXME instance ou classe ?
     */
    this.CLASSNAME = "ReverseGeocode";

    // appel du constructeur par heritage
    _CommonService__WEBPACK_IMPORTED_MODULE_3__["default"].apply(this, arguments);

    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("Gp.Services.ReverseGeocode");
    this.logger.trace("[Constructeur ReverseGeocode (options)]");

    if (!options.position) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_MISSING", "position"));
    }

    // on lance une exception afin d'eviter au service de le faire...
    if (options.position.x === null) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_MISSING", "position.x"));
    }

    if (options.position.y === null) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_MISSING", "position.y"));
    }

    // ajout des options spécifiques au service
    this.options.position = options.position;

    // on definit des filtres par defaut
    if (!options.filterOptions || typeof options.filterOptions !== "object") {
        this.options.filterOptions = options.filterOptions = {
            type : ["StreetAddress"]
        };
    }

    // FIXME ECMAScript 5 support (valable pour un objet uniquement !)
    // ceci permet de tester le cas où : object = {}
    if (Object.keys(options.filterOptions).length === 0) {
        this.options.filterOptions = {
            type : ["StreetAddress"]
        };
    }

    // on teste pour chaque filtre, les conditions suivantes : null ou vide !
    var filter = Object.keys(options.filterOptions);
    for (var i = 0; i < filter.length; i++) {
        var key = filter[i];
        if (!options.filterOptions[key] || Object.keys(options.filterOptions[key]).length === 0) {
            delete this.options.filterOptions[key];
        }
    }

    this.options.filterOptions.type = options.filterOptions.type || ["StreetAddress"];
    // on vérifie que le type est bien dans un tableau
    if (!Array.isArray(this.options.filterOptions.type)) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_TYPE", "filterOptions.type"));
    }

    this.options.maximumResponses = options.maximumResponses || 25;

    // FIXME : cet attribut (returnFreeForm) n'est pas spécifié dans la doc du constructeur ?
    // Il est inutile en effet, mais présent dans les specs...
    this.options.returnFreeForm = options.returnFreeForm || false;
    // info : en réalité le service ne reconnait que EPSG:4326. this.options.srs permet essentiellement de différencier EPSG:4326 (lat,lon) et CRS:84 (lon,lat)
    this.options.srs = options.srs || "CRS:84";

    // si on n'a pas un systeme de coordonnées EPSG géographique, il faut inverser les coordonnées
    // (car elles sont en lon, lat alors que le service attend une position en lat, lon).
    // dans le cas d'EPSG:4326 par exemple, les coordonnées sont bien en lat, lon donc on ne fait rien.
    if (ReverseGeocode.geoEPSG.indexOf(this.options.srs) === -1) {
        // pour la position
        this.options.position = {
            x : this.options.position.y,
            y : this.options.position.x
        };
        // pour les filtres spatiaux s'ils sont spécifiés
        if (this.options.filterOptions && this.options.filterOptions.circle) {
            var circle = this.options.filterOptions.circle;
            this.options.filterOptions.circle = {
                x : circle.y,
                y : circle.x,
                radius : circle.radius
            };
        }
        if (this.options.filterOptions && this.options.filterOptions.polygon) {
            var polygon = this.options.filterOptions.polygon;
            for (i = 0; i < polygon.length; i++) {
                var coords = polygon[i];
                this.options.filterOptions.polygon[i] = {
                    x : coords.y,
                    y : coords.x
                };
            }
        }
    }

    // attributs d'instances

    /**
     * Format forcé de la réponse du service : "xml"
     * sauf si l'on souhaite une reponse brute (options.rawResponse)
     */
    this.options.outputFormat = (this.options.rawResponse) ? "" : "xml";
}

/**
 * @lends module:ReverseGeocode#
 */
ReverseGeocode.prototype = Object.create(_CommonService__WEBPACK_IMPORTED_MODULE_3__["default"].prototype, {
    // todo
    // getter/setter
});

/*
 * Constructeur (alias)
 */
ReverseGeocode.prototype.constructor = ReverseGeocode;

/**
 * (overwrite)
 * Création de la requête
 *
 * @param {Function} error   - callback des erreurs
 * @param {Function} success - callback
 */
ReverseGeocode.prototype.buildRequest = function (error, success) {
    var options = {
        httpMethod : this.options.httpMethod,
        // options specifiques du service
        position : this.options.position,
        returnFreeForm : this.options.returnFreeForm,
        filterOptions : this.options.filterOptions,
        srs : "EPSG:4326", // info : en réalité le service ne reconnait que EPSG:4326. this.options.srs permet essentiellement de différencier EPSG:4326 (lat,lon) et CRS:84 (lon,lat)
        maximumResponses : this.options.maximumResponses
    };

    this.request = _Request_ReverseGeocodeRequestFactory__WEBPACK_IMPORTED_MODULE_4__["default"].build(options);

    // on teste si la requete a bien été construite !
    (!this.request)
        ? error.call(this, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_REQUEST_BUILD")))
        : success.call(this, this.request);
};

/**
 * (overwrite)
 * Analyse de la reponse
 *
 * @param {Function} error   - callback des erreurs
 * @param {Function} success - callback
 */
ReverseGeocode.prototype.analyzeResponse = function (error, success) {
    if (this.response) {
        var options = {
            response : this.response,
            rawResponse : this.options.rawResponse,
            onError : error,
            onSuccess : success,
            scope : this
        };

        _Response_ReverseGeocodeResponseFactory__WEBPACK_IMPORTED_MODULE_5__["default"].build(options);
    } else {
        error.call(this, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EMPTY")));
    }
};

/**
 * Codes EPSG géographiques (lat/lon). Utiles car les coordonnées doivent être inversées.
 */
ReverseGeocode.geoEPSG = ["EPSG:4326"];

/* harmony default export */ __webpack_exports__["default"] = (ReverseGeocode);


/***/ }),
/* 111 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _Formats_XLS__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(89);
/* harmony import */ var _Formats_XLS_LocationUtilityService__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(93);
/**
 * Creation d'une requête OpenLS en mode POST ou GET
 * (Factory)
 *
 * @module ReverseGeocodeRequestFactory
 * @alias Gp.Services.Geocode.Request.ReverseGeocodeRequestFactory
 * @private
 */




var ReverseGeocodeRequestFactory = {

    /**
     * interface unique
     *
     * @method build
     * @static
     * @param {Object} options - options definies dans le composant Geocode
     *
     * @example
     *   var options = {
     *      httpMethod :
     *      // options specifiques du service
     *      position :
     *      returnFreeForm :
     *      filterOptions :
     *      srs :
     *      maximumResponses :
     *   };
     *   var result = ReverseGeocodeRequestFactory.build(options);
     *   if (!result) {
     *       // error...
     *   }
     * @returns {String} request
     */
    build : function (options) {
        // logger
        var logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("ReverseGeocodeRequestFactory");
        logger.trace(["ReverseGeocodeRequestFactory::build()"]);

        // options non definies
        var settings = options || {};

        var request = null;

        // objet LUS
        var oLUS = new _Formats_XLS_LocationUtilityService__WEBPACK_IMPORTED_MODULE_2__["default"]({
            position : settings.position,
            returnFreeForm : settings.returnFreeForm,
            filterOptions : settings.filterOptions
        });

        // Format XLS
        var oXLS = new _Formats_XLS__WEBPACK_IMPORTED_MODULE_1__["default"]({
            srsName : settings.srs,
            maximumResponses : settings.maximumResponses
        });
        oXLS.namespace = true;
        oXLS.setService(oLUS);

        // request brute !
        request = oXLS.build();

        // en mode GET, la requête est encodée
        // et le param. 'qxml' est ajouté
        if (settings.httpMethod === "GET") {
            var myRequest = "qxml=" +
                encodeURIComponent(request)
                    .replace(/-/g, "%2D")
                    .replace(/_/g, "%5F")
                    .replace(/\./g, "%2E")
                    .replace(/!/g, "%21")
                    .replace(/~/g, "%7E")
                    .replace(/\*/g, "%2A")
                    .replace(/'/g, "%27")
                    .replace(/\(/g, "%28")
                    .replace(/\)/g, "%29");
            request = myRequest;
        }

        logger.trace(request);

        return request;
    }
};

/* harmony default export */ __webpack_exports__["default"] = (ReverseGeocodeRequestFactory);


/***/ }),
/* 112 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44);
/* harmony import */ var _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(45);
/* harmony import */ var _Formats_XML__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(66);
/* harmony import */ var _Formats_ReverseGeocodeResponseReader__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(113);
/**
 * Factory pour générer une reponse JSON à partir d'un XML
 * ou d'un JSON encapsulant du XML
 * (Factory)
 *
 * @module ReverseGeocodeResponseFactory
 * @alias Gp.Services.ReverseGeocode.Response.ReverseGeocodeResponseFactory
 * @todo La reponse JSON peut encapsuler un XML !
 * @private
 */






var ReverseGeocodeReponseFactory = {

    /**
     * interface unique
     *
     * @method build
     * @static
     * @param {Object} options - options definies dans le composant ReverseGeocode
     *
     * @example
     *   var options = {
     *      response :
     *      rawResponse :
     *      scope :
     *      onSuccess :
     *      onError :
     *   };
     *
     */
    build : function (options) {
        // data de type ReverseGeocodeResponse
        var data = null;

        if (options.response) {
            if (options.rawResponse) {
                data = options.response;
            } else {
                try {
                    var p = new _Formats_XML__WEBPACK_IMPORTED_MODULE_2__["default"]({
                        reader : _Formats_ReverseGeocodeResponseReader__WEBPACK_IMPORTED_MODULE_3__["default"]
                    });

                    if (typeof options.response === "string") {
                        p.setXMLString(options.response);
                    } else {
                        p.setXMLDoc(options.response);
                    }

                    data = p.parse();

                    if (!data) {
                        throw new Error("L'analyse de la réponse du service !?");
                    }
                } catch (e) {
                    // on relaye l'erreur reçue
                    e.status = 200;
                    options.onError.call(options.scope, e);
                    return;
                }

                // Si la réponse contenait une exception renvoyée par le service
                // TODO : quand cela arrive-t-il ?
                if (data.exceptionReport) {
                    options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_1__["default"]({
                        message : _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_0__["default"].getMessage("SERVICE_RESPONSE_EXCEPTION", data.exceptionReport),
                        type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_1__["default"].TYPE_SRVERR,
                        status : 200
                    }));
                    return;
                }

                // dans le cas d'un srs non EPSG géographique, il faut réinverser les coordonnées (lat,lon => lon,lat)
                if (options.scope && options.scope.options && options.scope.options.srs && options.scope.options.srs !== "EPSG:4326") {
                    var location;
                    var pos;
                    if (data || data.locations || data.locations.length) {
                        for (var i = 0; i < data.locations.length; i++) {
                            location = data.locations[i];
                            if (location) {
                                pos = location.position;
                                if (pos) {
                                    // on inverse les 2 coordonnées
                                    location.position = {
                                        x : pos.y,
                                        y : pos.x
                                    };
                                }
                            }
                        }
                    }
                }
            }
        } else {
            options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_1__["default"]({
                message : _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_0__["default"].getMessage("SERVICE_RESPONSE_EMPTY"),
                type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_1__["default"].TYPE_SRVERR,
                status : -1 // FIXME : status response
            }));
            return;
        }

        options.onSuccess.call(options.scope, data);
    }
};

/* harmony default export */ __webpack_exports__["default"] = (ReverseGeocodeReponseFactory);


/***/ }),
/* 113 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44);
/* harmony import */ var _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(45);
/* harmony import */ var _Response_model_GeocodeResponse__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(107);
/* harmony import */ var _Response_model_ReverseGeocodedLocation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(114);

/**
 * Fonction retournant un objet contenant des clés de lecture (readers)
 *      qui permettent de parser des réponses XML du service de géocodage inverse du Géoportail
 *      afin de récupérer les résultats retournés.
 * @module ReverseGeocodeResponseReader
 * @alias Gp.Services.Geocode.Formats.ReverseGeocodeResponseReader
 * @private
 */

// import Logger from "../../../Utils/LoggerByDefault";





/**
 * Objet ReverseGeocodeResponseReader
 * @member {Object} ReverseGeocodeResponseReader
 *
 * @property {String} ReverseGeocodeResponseReader.VERSION - Version du service de géocodage
 *
 * @property {Object} ReverseGeocodeResponseReader.NAMESPACES - Objet stockant les différents namespaces et les URI associées
 *
 * @property {String} ReverseGeocodeResponseReader.SCHEMALOCATION - Localisation (URL) du schema de définition du XML (XSD)
 *
 * @property {String} ReverseGeocodeResponseReader.DEFAULTPREFIX - Namespace par défaut du format
 *
 * @property {Object} ReverseGeocodeResponseReader.READERS - Objet contenant des fonctions de lecture, appelées "READERS"
 *      dont chaque clé correspond au nom d'un tag du XML que l'on souhaite lire
 *      et la valeur associée est une fonction (node, data)
 *      où node est un noeud du document DOM
 *      et data est un objet où l'on stocke les informations lues dans le XML.
 *
 * @property {Method} ReverseGeocodeResponseReader.read - Méthode permettant de lancer la lecture d'une réponse XML du service de géocodage,
 *      à l'aide des READERS de la classe.
 *
 */

var ReverseGeocodeResponseReader = {};

/**
 * version du service de géocodage
 */
ReverseGeocodeResponseReader.VERSION = "1.2";

/**
 * Objet stockant les différents namespaces et les URI associées
 */
ReverseGeocodeResponseReader.NAMESPACES = {
    xmlns : "http://www.opengis.net/xls",
    gml : "http://www.opengis.net/gml",
    xls : "http://www.opengis.net/xls",
    xlsext : "http://www.opengis.net/xlsext",
    xsi : "http://www.w3.org/2001/XMLSchema-instance"
};

/**
 * Localisation (URL) du schema de définition du XML (XSD)
 */
ReverseGeocodeResponseReader.SCHEMALOCATION = "http://wxs.ign.fr/schemas/olsAll.xsd";

/**
 * Namespace par défaut du format
 */
ReverseGeocodeResponseReader.DEFAULTPREFIX = "xls";

/**
 * Objet contenant des fonctions de lecture, appelées "READERS"
 *      dont chaque clé correspond au nom d'un tag du XML que l'on souhaite lire
 *      et la valeur associée est une fonction (node, data)
 *      où node est un noeud du document DOM
 *      et data est un objet où l'on stocke les informations lues dans le XML.
 */
ReverseGeocodeResponseReader.READERS = {

    xls : {

        /** TODO : jsdoc block */
        XLS : function (root) {
            var reverseGeocodeResponse = new _Response_model_GeocodeResponse__WEBPACK_IMPORTED_MODULE_2__["default"]();

            // vérification de la version du service, et des namespaces de l'en-tête
            __checkServiceAttributes(root);

            // puis lancement de la lecture de l'ensemble des noeuds, en bouclant sur les childNodes
            __getChildNodes(root, reverseGeocodeResponse);

            return reverseGeocodeResponse;
        },

        /** TODO : jsdoc block */
        ReverseGeocodedLocation : function (node, reverseGeocodeResponse) {
            var reverseGeocodedLocation = new _Response_model_ReverseGeocodedLocation__WEBPACK_IMPORTED_MODULE_3__["default"]();

            __getChildNodes(node, reverseGeocodedLocation);

            // Ajout du résultat au tableau locations de reverseGeocodeResponse
            if (reverseGeocodeResponse && Array.isArray(reverseGeocodeResponse.locations)) {
                reverseGeocodeResponse.locations.push(reverseGeocodedLocation);
            }
        },

        /** TODO : jsdoc block */
        Address : function (node, reverseGeocodedLocation) {
            var countrycode = node.getAttribute("countryCode");
            if (reverseGeocodedLocation && countrycode) {
                reverseGeocodedLocation.type = countrycode;
            }
            // on va récupérer les autres informations (StreetAddress, place, postalCode...)
            __getChildNodes(node, reverseGeocodedLocation);
        },

        /** TODO : jsdoc block */
        Building : function (node, reverseGeocodedLocation) {
            var num = node.getAttribute("number");
            if (reverseGeocodedLocation && reverseGeocodedLocation.hasOwnProperty("placeAttributes")) {
                if (num) {
                    reverseGeocodedLocation.placeAttributes.number = num;
                } else if (node.getAttribute("buildingName")) {
                    reverseGeocodedLocation.placeAttributes.number = node.getAttribute("buildingName");
                } else if (node.getAttribute("subdivision")) {
                    reverseGeocodedLocation.placeAttributes.number = node.getAttribute("subdivision");
                }
            }
        },

        /** TODO : jsdoc block */
        Street : function (node, reverseGeocodedLocation) {
            // in case of a streetAddress result : street represents the street name
            if (reverseGeocodedLocation.type === "StreetAddress") {
                reverseGeocodedLocation.placeAttributes.street = __getChildValue(node);

                // in case of a cadastral parcel result : street represents the cadastral parcel identifier
            } else if (reverseGeocodedLocation.type === "CadastralParcel") {
                reverseGeocodedLocation.placeAttributes.cadastralParcel = __getChildValue(node);
            }
        },

        /** TODO : jsdoc block */
        Place : function (node, reverseGeocodedLocation) {
            var placeType = node.getAttribute("type");
            var placeName = __getChildValue(node);

            if (reverseGeocodedLocation && reverseGeocodedLocation.hasOwnProperty("placeAttributes")) {
                if (placeType === "Municipality") {
                    reverseGeocodedLocation.placeAttributes.municipality = placeName;
                } else if (placeType === "Bbox") {
                    var values = placeName.split(";");
                    if (values.length === 4) {
                        reverseGeocodedLocation.placeAttributes.bbox = {
                            left : parseFloat(values[0]),
                            right : parseFloat(values[2]),
                            top : parseFloat(values[1]),
                            bottom : parseFloat(values[3])
                        };
                    }
                } else if (placeType === "Commune") {
                    reverseGeocodedLocation.placeAttributes.commune = placeName;
                } else if (placeType === "Departement") {
                    reverseGeocodedLocation.placeAttributes.department = placeName;
                } else if (placeType === "INSEE") {
                    reverseGeocodedLocation.placeAttributes.insee = placeName;
                } else if (placeType === "Qualite") {
                    reverseGeocodedLocation.placeAttributes.quality = placeName;
                } else if (placeType === "Territoire") {
                    reverseGeocodedLocation.placeAttributes.territory = placeName;
                } else if (placeType === "ID") {
                    reverseGeocodedLocation.placeAttributes.ID = placeName;
                } else if (placeType === "ID_TR") {
                    reverseGeocodedLocation.placeAttributes.IDTR = placeName;
                } else if (placeType === "Importance") {
                    reverseGeocodedLocation.placeAttributes.importance = parseInt(placeName, 10);
                } else if (placeType === "Nature") {
                    reverseGeocodedLocation.placeAttributes.nature = placeName;
                } else if (placeType === "Numero") {
                    reverseGeocodedLocation.placeAttributes.number = placeName;
                } else if (placeType === "Feuille") {
                    reverseGeocodedLocation.placeAttributes.sheet = placeName;
                } else if (placeType === "Section") {
                    reverseGeocodedLocation.placeAttributes.section = placeName;
                } else if (placeType === "CommuneAbsorbee") {
                    reverseGeocodedLocation.placeAttributes.absorbedCity = placeName;
                } else if (placeType === "Arrondissement") {
                    if (placeName) {
                        reverseGeocodedLocation.placeAttributes.arrondissement = placeName;
                    }
                } else if (placeType === "Type") {
                    reverseGeocodedLocation.placeAttributes.origin = placeName;
                } else if (placeType === "Prefecture") {
                    reverseGeocodedLocation.placeAttributes.prefecture = placeName;
                } else if (placeType === "InseeRegion") {
                    reverseGeocodedLocation.placeAttributes.inseeRegion = placeName;
                } else if (placeType === "InseeDepartment") {
                    reverseGeocodedLocation.placeAttributes.inseeDepartment = placeName;
                }
            }
        },

        /** TODO : jsdoc block */
        PostalCode : function (node, reverseGeocodedLocation) {
            if (reverseGeocodedLocation && reverseGeocodedLocation.hasOwnProperty("placeAttributes")) {
                reverseGeocodedLocation.placeAttributes.postalCode = __getChildValue(node);
            }
        },

        /** TODO : jsdoc block */
        SearchCentreDistance : function (node, reverseGeocodedLocation) {
            if (reverseGeocodedLocation) {
                reverseGeocodedLocation.searchCenterDistance = parseFloat(node.getAttribute("value"));
            }
        },

        /** TODO : jsdoc block */
        Error : function (node) {
            // <Error message="For input string : &quot;2,45&quot;" errorCode="InternalServerError"/>
            var srvMess = node.getAttribute("message");
            var errorCode = node.getAttribute("errorCode");
            var message = _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_0__["default"].getMessage("SERVICE_RESPONSE_EXCEPTION",
                "(" + errorCode + ") : " + srvMess);
            throw new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_1__["default"]({
                message : message,
                type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_1__["default"].TYPE_SRVERR
            });
        }
    },

    gml : {

        /** TODO : jsdoc block */
        pos : function (node, reverseGeocodedLocation) {
            var pos = __getChildValue(node);
            if (reverseGeocodedLocation && pos) {
                reverseGeocodedLocation.position = {
                    x : parseFloat(pos.split(" ")[0]),
                    y : parseFloat(pos.split(" ")[1])
                };
            }
        }
    },

    xlsext : {
        /** TODO : jsdoc block */
        ExtendedGeocodeMatchCode : function (node, reverseGeocodedLocation) {
            if (reverseGeocodedLocation) {
                reverseGeocodedLocation.matchType = __getChildValue(node);
            }
        }
    },

    /** TODO : jsdoc block */
    ExceptionReport : function (node) {
        var response = {};
        if (node.hasChildNodes()) {
            var children = node.childNodes;
            var child;
            for (var i = 0; i < children.length; i++) {
                child = children[i];
                if (child.nodeName === "Exception") {
                    response.exceptionReport = ReverseGeocodeResponseReader.READERS["Exception"](child);
                }
            }
        }
        return response;
    },

    /** TODO : jsdoc block */
    Exception : function (node) {
        var exceptionReport = {};

        // get exception code
        var exceptionCode = node.getAttribute("exceptionCode");
        if (exceptionCode) {
            exceptionReport.exceptionCode = exceptionCode;
        }

        // get exception message
        var textNode = node.firstChild;
        if (textNode && textNode.nodeType === 3) { // 3 === node.TEXT_NODE
            exceptionReport.exception = textNode.nodeValue;
        }

        return exceptionReport;
    }

};

/**
 * Méthode permettant de lancer la lecture d'une réponse XML du service de géocodage,
 *      à l'aide des READERS de la classe.
 *
 * @method ReverseGeocodeResponseReader.read
 * @param {DOMElement} root - racine de la réponse XML à lire
 * @return {Object} geocodeResponse|exceptionReport : l'objet contenant les informations de la réponse XML,
 *      sous la forme d'un objet GeocodeResponse, ou un objet littéral exceptionReport si le service a renvoyé une exception.
 * @static
 * @memberof ReverseGeocodeResponseReader
 */
ReverseGeocodeResponseReader.read = function (root) {
    if (root.nodeName === "XLS") {
        var nsPrefix = root.prefix;
        if (!nsPrefix) {
            nsPrefix = ReverseGeocodeResponseReader.DEFAULTPREFIX;
        }
        var geocodeResponse = ReverseGeocodeResponseReader.READERS[nsPrefix][root.nodeName](root);
        return geocodeResponse;
    } else if (root.nodeName === "ExceptionReport") {
        var exceptionReport = ReverseGeocodeResponseReader.READERS[root.nodeName](root);
        return exceptionReport;
    } else {
        throw new Error("Erreur lors de la lecture de la réponse : elle n'est pas au format attendu.");
    }
};

/**
 * Récupération des attributs d'un noeud élément
 *
 * @private
 * @memberof ReverseGeocodeResponseReader
 * @method __getAttributes
 * @param {DOMElement} node - noeud contenant l'attribut recherché
 * @return {Object} nodeAttributes - objet contenant les noms et valeurs des différents attributs
 */
function __getAttributes (node) {
    if (node.attributes.length > 0) {
        var nodeAttributes = {};
        var attributes = node.attributes;
        for (var i = 0; i < attributes.length; i++) {
            var attribute = attributes[i];
            nodeAttributes[attribute.nodeName] = attribute.nodeValue;
        }
        return nodeAttributes;
    }
}

/**
 * Récupération des noeuds enfants à partir d'un noeud donné, pour lecture (readNode).
 *
 * @private
 * @memberof ReverseGeocodeResponseReader
 * @method __getChildNodes
 * @param {DOMElement} node - a DOM node
 * @param {Array|Object} [data] - an object to be filled with node data
 */
function __getChildNodes (node, data) {
    if (node.hasChildNodes()) {
        var children = node.childNodes;
        var child;
        var childName;
        var childPrefix;

        for (var i = 0; i < children.length; i++) {
            child = children[i];

            if (child.nodeType === 1) { // 1 === node.ELEMENT_NODE
                childName = child.localName || child.baseName || child.nodeName;
                childPrefix = child.prefix || ReverseGeocodeResponseReader.DEFAULTPREFIX;

                if (ReverseGeocodeResponseReader.READERS[childPrefix][childName]) {
                    var reader = ReverseGeocodeResponseReader.READERS[childPrefix][childName];
                    reader(child, data);
                } else {
                    __getChildNodes(child, data);
                }
            }
        }
    }
}

/**
 * Lecture de la valeur du premier child d'un noeud, si elle existe.
 *
 * @private
 * @memberof ReverseGeocodeResponseReader
 * @method __getChildValue
 * @param {DOMElement} node - a DOM node
 * @return {String} value - valeur du firstChild du noeud en entrée, ou chaîne vide.
 */
function __getChildValue (node) {
    var textNode;
    var value = "";

    if (node.hasChildNodes()) {
        textNode = node.firstChild;
        if (textNode.nodeType === 3) { // 3 === node.TEXT_NODE
            value = textNode.nodeValue;
        }
    }
    return value;
}

/**
 * Vérification des attributs du service, dans la balise XLS de la réponse :
 *      version, namespaces, et namespace par défaut doivent correspondre à ceux attendus.
 *
 * @private
 * @memberof ReverseGeocodeResponseReader
 * @method __checkServiceAttributes
 * @param {DOMElement} XLSNode - a DOM node, corresponding to XLS first tag.
 */
function __checkServiceAttributes (XLSNode) {
    if (XLSNode.attributes.length > 0) {
        // on récupère et parcourt les attributs de la balise XLS de la réponse
        var xlsAttributes = __getAttributes(XLSNode);
        for (var att in xlsAttributes) {
            if (xlsAttributes.hasOwnProperty(att)) {
                // vérification de la version
                if (att === "version") {
                    if (xlsAttributes["version"] !== ReverseGeocodeResponseReader.VERSION) {
                        console.log("[ReverseGeocodeResponseReader] geocode version is not the expected one : there may be errors in parsing");
                        return;
                    }
                }

                // on vérifie que l'uri du namespace par défaut est bien celle que l'on attend
                if (att === "xmlns") {
                    if (xlsAttributes[att] !== ReverseGeocodeResponseReader.NAMESPACES[ReverseGeocodeResponseReader.DEFAULTPREFIX]) {
                        console.log("[ReverseGeocodeResponseReader] geocode response default namespace is not the expected one");
                        return;
                    }
                    continue;
                }

                var prefix = att.split(":")[0];
                var ns = att.split(":")[1];

                // si on a un autre xmlns, on vérifie aussi les URI
                if (prefix === "xmlns" && ns) {
                    // si l'attribut correspond à un namespace défini dans le reader
                    if (ReverseGeocodeResponseReader.NAMESPACES[ns]) {
                        // il faut que les URI correspondent aussi.
                        if (ReverseGeocodeResponseReader.NAMESPACES[ns] !== xlsAttributes[att]) {
                            console.log("[ReverseGeocodeResponseReader] geocode response " + att + " namespace is not the expected one");
                            return;
                        }
                    }
                }

                // pour finir on vérifie la localisation du schema XSD du service
                if (ns === "schemaLocation") {
                    if (ReverseGeocodeResponseReader.SCHEMALOCATION !== xlsAttributes[att]) {
                        console.log("[ReverseGeocodeResponseReader] geocode response schema location is not the expected one");
                        return;
                    }
                }
            }
        }
    }
}

/* harmony default export */ __webpack_exports__["default"] = (ReverseGeocodeResponseReader);


/***/ }),
/* 114 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _GeocodedLocation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(109);



/**
 * Single location object returned by the underlying reverse geocoding web service.
 *
 * @property {Float} searchCenterDistance - Distance between the requested point and the location.
 *
 * @namespace
 * @extends {Gp.Services.Geocode.GeocodedLocation}
 * @alias Gp.Services.Geocode.ReverseGeocodedLocation
 */
function ReverseGeocodedLocation () {
    if (!(this instanceof ReverseGeocodedLocation)) {
        throw new TypeError("ReverseGeocodedLocation constructor cannot be called as a function.");
    }

    // INFO
    // appel du constructeur de la classe mère
    // avec passage de param.
    _GeocodedLocation__WEBPACK_IMPORTED_MODULE_0__["default"].apply(this, arguments);

    /**
     * Nom de la classe (heritage) : "ReverseGeocodedLocation"
     * @type {String}
     */
    this.CLASSNAME = "ReverseGeocodedLocation";

    this.searchCenterDistance = null;
}

ReverseGeocodedLocation.prototype = Object.create(_GeocodedLocation__WEBPACK_IMPORTED_MODULE_0__["default"].prototype);

ReverseGeocodedLocation.prototype.constructor = ReverseGeocodedLocation;

/* harmony default export */ __webpack_exports__["default"] = (ReverseGeocodedLocation);


/***/ }),
/* 115 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _CommonService__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46);
/* harmony import */ var _Response_AutoCompleteResponseFactory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(116);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(43);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(44);
/* harmony import */ var _Utils_Helper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(47);
/* harmony import */ var _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(45);







/**
 * @classdesc
 * Appel du service d'autocomplétion du Géoportail :
 * envoi de la requête construite selon les paramètres en options,
 * éventuellement parsing et analyse  de la réponse,
 * retour d'une réponse en paramètre de la fonction onSuccess.
 * @constructor
 * @extends {Gp.Services.CommonService}
 * @alias Gp.Services.AutoComplete
 *
 * @param {Object} options - options spécifiques au service (+ les options heritées)
 *
 * @param {String} options.text - La chaîne de caractère à compléter.
 *      Cette chaîne n'est pas "URL encodée".
 *      C'est l'API qui s'occupe de l'encoder pour l'inclure dans la requête.
 *
 * @param {Array.<String>} [options.filterOptions.type = "StreetAddress"] - Type de l'objet recherché.
 *      Le service d'autocomplétion du Géoportail permet de rechercher des toponymes 'PostionOfInterest' et/ou des adresses postales 'StreetAddress'.
 *      D'autres types pourront être rajoutés selon l'évolution du service.
 *      Par défaut, type = ['StreetAddress'].
 *
 * @param {Array.<String>} [options.filterOptions.territory] - Limitation de la zone de recherche de localisants.
 *      Le service d'autocomplétion du Géoportail permet de limiter la recherche à la métropole et la Corse : options.filterOptions.territory = ['METROPOLE'],
 *      DOMS TOMS : options.filterOptions.territory = ['DOMTOM'], ou à une liste de départements : options.filterOptions.territory = ['31', '34']
 *      Pas de valeur par défaut.
 *      La valeur par défaut est donc celle du service.
 *      Le service d'autocomplétion du Géoportail renvoie toutes les informations quand aucun territoire n'est spécifié.
 *
 * @param {Number} [options.maximumResponses = 10] - Nombre de réponses maximal que l'on souhaite recevoir.
 *      Pas de valeur par défaut.
 *      La valeur par défaut sera donc celle du service : 10.
 *
 * @example
 *   var options = {
 *      // options communes aux services
 *      apiKey : null,
 *      serverUrl : 'http://localhost/service/',
 *      protocol : 'JSONP', // JSONP|XHR
 *      proxyURL : null,
 *      httpMethod : 'GET', // GET|POST
 *      timeOut : 10000, // ms
 *      rawResponse : false, // true|false
 *      scope : null, // this
 *      onSuccess : function (response) {},
 *      onFailure : function (error) {},
 *      // spécifique au service
 *      text : "",
 *      filterOptions : {
 *          type : ["StreetAddress"],
 *          territory : ['METROPOLE', 'DOMTOM', '31']
 *      },
 *      maximumResponses : 10
 *   };
 * @private
 */
function AutoComplete (options) {
    if (!(this instanceof AutoComplete)) {
        throw new TypeError(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_3__["default"].getMessage("CLASS_CONSTRUCTOR", "AutoComplete"));
    }

    /**
     * Nom de la classe (heritage)
     * FIXME instance ou classe ?
     */
    this.CLASSNAME = "AutoComplete";

    // appel du constructeur par heritage
    _CommonService__WEBPACK_IMPORTED_MODULE_0__["default"].apply(this, arguments);

    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_2__["default"].getLogger("Gp.Services.AutoComplete");
    this.logger.trace("[Constructeur AutoComplete (options)]");

    if (!options.text) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_3__["default"].getMessage("PARAM_MISSING", "text"));
    }

    // ajout des options spécifiques au service
    this.options.text = options.text;

    // on definit des filtres par defaut
    if (!options.filterOptions || typeof options.filterOptions !== "object") {
        this.options.filterOptions = options.filterOptions = {
            territory : [],
            type : ["StreetAddress"]
        };
    }

    // FIXME ECMAScript 5 support (valable pour un objet uniquement !)
    // ceci permet de tester le cas où : object = {}
    if (Object.keys(options.filterOptions).length === 0) {
        this.options.filterOptions = {
            territory : [],
            type : ["StreetAddress"]
        };
    }

    this.options.filterOptions.type = options.filterOptions.type || ["StreetAddress"];
    this.options.filterOptions.territory = options.filterOptions.territory || [];
    this.options.maximumResponses = options.maximumResponses || 10;

    // INFO
    // le service ne repond pas en mode POST (405 Method Not Allowed)
    if (this.options.protocol === "XHR" && this.options.httpMethod === "POST") {
        this.logger.warn("Le service ne gére pas le mode d'interrogation en POST, on bascule sur du GET !");
        this.options.httpMethod = "GET"; // on surcharge !
    }

    // attributs d'instances

    /**
     * Format forcé de la réponse du service : "json"
     * sauf si l'on souhaite une reponse brute (options.rawResponse)
     */
    this.options.outputFormat = (this.options.rawResponse) ? "" : "json";
}

/**
 * @lends module:AutoComplete#
 */

AutoComplete.prototype = Object.create(_CommonService__WEBPACK_IMPORTED_MODULE_0__["default"].prototype, {
    // todo
    // getter/setter
});

/*
 * Constructeur (alias)
 */
AutoComplete.prototype.constructor = AutoComplete;

/**
 * (overwrite)
 * Création de la requête
 *
 * @param {Function} error   - callback des erreurs
 * @param {Function} success - callback
 */
AutoComplete.prototype.buildRequest = function (error, success) {
    // ex.
    // http://wxs.ign.fr/CLEF/ols/apis/completion?
    // text=Brie-Comt&
    // type=StreetAddress,PositionOfInterest&
    // territory=METROPOLE&
    // maximumResponses=10

    // traitement des param KPV sous forme de tableau
    var territories = "";
    if (this.options.filterOptions.territory) {
        territories = this.options.filterOptions.territory.join(";");
    }

    var types = "";
    if (this.options.filterOptions.type) {
        types = this.options.filterOptions.type.join(",");
    }

    // normalisation de la requete avec param KPV
    this.request = _Utils_Helper__WEBPACK_IMPORTED_MODULE_4__["default"].normalyzeParameters({
        text : encodeURIComponent(this.options.text),
        type : types,
        terr : territories,
        maximumResponses : this.options.maximumResponses
    });

    (!this.request)
        ? error.call(this, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_5__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_3__["default"].getMessage("SERVICE_REQUEST_BUILD")))
        : success.call(this, this.request);
};

/**
 * (overwrite)
 * Analyse de la reponse
 *
 * @param {Function} error   - callback des erreurs
 * @param {Function} success - callback de succès de l'analyse de la réponse
 */
AutoComplete.prototype.analyzeResponse = function (error, success) {
    if (this.response) {
        var options = {
            response : this.response,
            rawResponse : this.options.rawResponse,
            onSuccess : success,
            onError : error,
            scope : this
        };

        _Response_AutoCompleteResponseFactory__WEBPACK_IMPORTED_MODULE_1__["default"].build(options);
    } else {
        error.call(this, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_5__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_3__["default"].getMessage("SERVICE_RESPONSE_EMPTY")));
    }
};

/* harmony default export */ __webpack_exports__["default"] = (AutoComplete);


/***/ }),
/* 116 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44);
/* harmony import */ var _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45);
/* harmony import */ var _model_AutoCompleteResponse__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(117);
/* harmony import */ var _model_SuggestedLocation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(118);
/**
 * Factory pour générer une reponse JSON à partir d'un XML ou d'un JSON
 * (Factory)
 *
 * @module AutoCompleteResponseFactory
 * @private
 * @alias Gp.Services.AutoComplete.Response.AutoCompleteResponseFactory
 */






var AutoCompleteResponseFactory = {

    /**
     * interface unique
     *
     * @method build
     * @static
     * @param {Object} options - options definies dans le composant Alti
     *
     * @example
     *   var options = {
     *      response :
     *      outputFormat :
     *      rawResponse :
     *      scope :
     *      onSuccess :
     *      onError :
     *   };
     *
     */
    build : function (options) {
        // logger
        var logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("AutoCompleteResponseFactory");
        logger.trace(["AutoCompleteResponseFactory::build()"]);

        var data = null;

        if (options.response) {
            if (options.rawResponse) {
                logger.trace("analyze response : raw");
                data = options.response;
            } else {
                var JSONResponse;
                if (typeof options.response === "string") {
                    JSONResponse = JSON.parse(options.response);
                } else {
                    JSONResponse = options.response;
                }

                // analyse de la réponse
                if (JSONResponse) {
                    // le service renvoie t il une erreur ?
                    if (JSONResponse.error) {
                        // ex. ?
                        options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"]({
                            message : _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EXCEPTION", JSONResponse.error.description),
                            status : JSONResponse.error.code,
                            type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"].TYPE_SRVERR
                        }));
                        return;
                    }

                    // création de l'objet réponse
                    data = new _model_AutoCompleteResponse__WEBPACK_IMPORTED_MODULE_3__["default"]();

                    // boucle sur les résultats de l'autocomplétion
                    if (JSONResponse.results && Array.isArray(JSONResponse.results)) {
                        var suggestedLocation;

                        for (var i = 0; i < JSONResponse.results.length; i++) {
                            var result = JSONResponse.results[i];
                            suggestedLocation = new _model_SuggestedLocation__WEBPACK_IMPORTED_MODULE_4__["default"]();

                            if (suggestedLocation) {
                                if (result && result.country === "StreetAddress") {
                                    suggestedLocation.street = result.street;
                                    suggestedLocation.type = "StreetAddress";
                                } else if (result && result.country === "PositionOfInterest") {
                                    suggestedLocation.poi = result.street;
                                    suggestedLocation.kind = result.kind;
                                    suggestedLocation.type = "PositionOfInterest";
                                }

                                if (suggestedLocation.position) {
                                    suggestedLocation.position.x = result.x;
                                    suggestedLocation.position.y = result.y;
                                }

                                suggestedLocation.commune = result.city;
                                suggestedLocation.fullText = result.fulltext;
                                suggestedLocation.postalCode = result.zipcode;
                                suggestedLocation.classification = result.classification;
                            }
                            // Ajout du résultat au tableau reverseGeocodedLocations de geocodedLocation
                            data.suggestedLocations.push(suggestedLocation);
                        }
                    } else {
                        options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_FORMAT_3")));
                        return;
                    }

                    if (!data.suggestedLocations.length) {
                        options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_FORMAT_3")));
                        return;
                    }
                }

                if (!data) {
                    options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"]({
                        message : _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_ANALYSE_2"),
                        type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"].TYPE_UNKERR,
                        status : -1
                    }));
                    return;
                }

                // Si la réponse contenait une exception renvoyée par le service
                if (data.exceptionReport) {
                    options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"]({
                        message : _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EXCEPTION", data.exceptionReport),
                        type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"].TYPE_SRVERR,
                        status : 200
                    }));
                    return;
                }
            }
        } else {
            // si la réponse (xmlString) est vide, on appelle le callback d'erreur
            options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EMPTY")));
            return;
        }

        // si tout s'est bien passé, on appelle le callback de succès
        options.onSuccess.call(options.scope, data);
    }
};

/* harmony default export */ __webpack_exports__["default"] = (AutoCompleteResponseFactory);


/***/ }),
/* 117 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/**
 * Response object for {@link module:Services~autoComplete Gp.Services.autoComplete ()} invocation when successful. Received as the argument of onSuccess callback function.
 *
 * @property {Array.<Gp.Services.AutoComplete.SuggestedLocation>} suggestedLocations - SuggestedLocations array.
 *
 * @namespace
 * @alias Gp.Services.AutoCompleteResponse
 */
function AutoCompleteResponse () {
    if (!(this instanceof AutoCompleteResponse)) {
        throw new TypeError("AutoCompleteResponse constructor cannot be called as a function.");
    }

    this.suggestedLocations = [];
}

AutoCompleteResponse.prototype = {

    constructor : AutoCompleteResponse

};

/* harmony default export */ __webpack_exports__["default"] = (AutoCompleteResponse);


/***/ }),
/* 118 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

/**
 * Single SuggestedLocation Object returned by underlying web service.
 * Each suggested location represents a street address ("StreetAddress") or a place name ("PositionOfInterest").
 *
 * @property {String} type - Suggested location type : "StreetAddress" ou "PositionOfInterest"
 * @property {Gp.Point} position - Position of the suggested location given in requested coordinates system.
 * @property {String} commune - Suggested municipality
 * @property {String} fullText - Full text representation of the suggested location.
 * @property {String} postalCode - Suggested location postcode
 * @property {Integer} classification - Number used to classify the importance of the place where is the suggested location from 1 (most important) to 7 (less important).
 * @property {String} street - Street name of the suggested location ("StreetAddress" only).
 * @property {String} kind - Nature of the suggested location : "prefecture", "monument", "commune", ... for instance ("PositionOfInterest" only).
 *
 * @namespace
 * @alias Gp.Services.AutoComplete.SuggestedLocation
 */
function SuggestedLocation () {
    if (!(this instanceof SuggestedLocation)) {
        throw new TypeError("SuggestedLocation constructor cannot be called as a function.");
    }

    /* REPONSE :
        {
           "status" : "OK",
           "results" : [
              {
                 "country":"PositionOfInterest",
                 "x":-1.559185,
                 "y":47.952603,
                 "city":"Brie",
                 "zipcode":"35150",
                 "street":"corbe",
                 "kind":"Lieu-dit habité",
                 "fulltext":"corbe, 35150 Brie",
                 "classification":6
              },
              {
                 "country":"StreetAddress",
                 "x":1.538295,
                 "y":43.19646,
                 "city":"Brie",
                 "zipcode":"09700",
                 "street":"courreste",
                 "kind":"",
                 "fulltext":"courreste, 09700 Brie",
                 "classification":7
              }
           ]
        }
    */

    /* REPONSE EN ERREUR
        {
            status : "ERROR",
            results : [ ]
        }
    */

    /**
     * Suggested location type : "StreetAddress" ou "PositionOfInterest"
     * @type {String}
     */
    this.type = null;

    /**
     * Position of the suggested location given in requested coordinates system.
     * @type {Gp.Point}
     */
    this.position = {
        x : null,
        y : null
    };

    /**
     * Suggested municipality
     * @type {String}
     */
    this.commune = null;

    /**
     * Full text representation of the suggested location.
     * @type {String}
     */
    this.fullText = null;

    /**
     * Suggested location postcode
     * @type {Number}
     */
    this.postalCode = null;

    /**
     * Number used to classify the importance of the place where is the suggested location from 1 (most important) to 7 (less important).
     * @type {Integer}
     */
    this.classification = null;

    /**
     * Street name of the suggested location ("StreetAddress" only).
     * @type {String}
     */
    this.street = null;

    /**
     * Place name of the suggested location ("PositionOfInterest" only).
     * @type {String}
     */
    this.poi = null;

    /**
     * Nature of the suggested location : "prefecture", "monument", "commune", ... for instance ("PositionOfInterest" only).
     * @type {String}
     */
    this.kind = null;
}

SuggestedLocation.prototype = {

    constructor : SuggestedLocation
};

/* harmony default export */ __webpack_exports__["default"] = (SuggestedLocation);


/***/ }),
/* 119 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44);
/* harmony import */ var _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45);
/* harmony import */ var _CommonService__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46);
/* harmony import */ var _DefaultUrlService__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(56);
/* harmony import */ var _Request_RouteRequestFactory__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(120);
/* harmony import */ var _Response_RouteResponseFactory__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(128);









/**
 * @classdesc
 * Appel du service d'itinéraire du Géoportail :
 *     envoi de la requête construite selon les paramètres en options,
 *     éventuellement parsing et analyse  de la réponse,
 *     retour d'une réponse en paramètre de la fonction onSuccess.
 *
 * @alias Gp.Services.Route
 * @constructor
 * @extends {Gp.Services.CommonService}
 * @param {Object} options - options spécifiques au service (+ les options heritées)
 *
 * @param {String} [options.api] - Manière d'accéder au service : 'REST' (via l'API REST) ou 'OLS' (via la norme XLS).
 * Par défaut, on utilise l'API REST.
 *
 * @param {String} options.outputFormat - Le format de la réponse du service itineraire : 'xml' ou 'json'.
 *      Ce paramètre déterminera l'extension '.xml' ou '.json' du service dans le cas de l'API REST.
 *      Nécessaire si serverUrl est renseigné, et qu'on souhaite passer par l'API REST,
 *      pour connaître le format dans lequel sera fournie la réponse (pour son traitement).
 *      Non nécessaire pour la norme OLS. Par défaut, ce paramètre vaut 'json'.
 *
 * @param {String} [options.routePreference = "fastest"] - Mode de calcul à utiliser :
 * - le plus rapide « fastest »
 * - le plus court « shortest »
 * Par défaut : « fastest ».
 *
 * @param {Object} options.startPoint - Point de départ du calcul. Coordonnées exprimées en longitudes, latitudes (EPSG:4326)
 * @param {Float} options.startPoint.x - Abcisse du point de départ du calcul d'itinéraire.
 * @param {Float} options.startPoint.y - Ordonnée du point de départ du calcul d'itinéraire.
 *
 * @param {Object} options.endPoint - Point d'arrivée du calcul. Coordonnées exprimées en longitudes, latitudes (EPSG:4326)
 * @param {Float} options.endPoint.x - Abcisse du point d'arrivée du calcul d'itinéraire.
 * @param {Float} options.endPoint.y - Ordonnée du point d'arrivée du calcul d'itinéraire.
 *
 * @param {Object[]} [options.viaPoints] - Liste de point ({x:Float,y:Float}) intermédaires que l'itinéraire doit emprunter dans l'ordre du tableau.
 *      Coordonnées exprimées en longitudes, latitudes (EPSG:4326) :{x:float, y:float}
 *
 * @param {String} [options.graph = "voiture"] - Type de graphe utilisé : "Voiture" ou "Pieton".
 *      Détermine le profil de vitesses utilisé pour le calcul ainsi que les tronçons autorisés ou non.
 *      Par défaut, c'est la valeur "Voiture" qui sera utilisée.
 *
 * @param {String[]} [options.exclusions] - Critères d'exclusions à appliquer pour le calcul. (correspond au paramètre "avoidFeature" d'OpenLS)
 *      On précise ici le type de tronçons que l'on ne veut pas que l'itinéraire emprunte
 *      (valeurs possibles : « toll » (éviter les péages), « bridge », « tunnel »).
 *
 * @param {Boolean} [options.geometryInInstructions = false] - Indique si la géométrie de l'itinéraire doit être reprise morceau par morceau dans les instructions.
 *      (correspond au paramètre "provideGeometry" d'OpenLS) Par défaut : false.
 *
 * @param {Boolean} [options.provideBbox = true] - Indique si les instructions doivent être localisées par une bbox dans la réponse.
 *      Par défaut : true.
 *
 * @param {String} [options.distanceUnit = "km"] - Indique si la distance doit être exprimée en km ou m dans la réponse.
 *      Par défaut : km.
 *
 * @param {String} [options.srs] - Système de coordonnées dans lequel les paramètres géographiques en entrée et la réponse du service sont exprimés.
 *      Pas de valeur par défaut. Si le serveur consulté est celui du Géoportail, la valeur par défaut sera donc celle du service : 'EPSG:4326'.
 *
 * @example
 *  var options = {
 *      // options communes aux services
 *      apiKey : null,
 *      serverUrl : 'http://localhost/service/',
 *      protocol : 'JSONP', // JSONP|XHR
 *      proxyURL : null,
 *      httpMethod : 'GET', // GET|POST
 *      timeOut : 10000, // ms
 *      rawResponse : false, // true|false
 *      scope : null, // this
 *      onSuccess : function (response) {},
 *      onFailure : function (error) {},
 *      // spécifique au service
 *      api : 'OLS',
 *      outputFormat : 'xml',
 *      startPoint : {
 *          x : 42.1121,
 *          y : 1.5557
 *      },
 *      endPoint : {
 *          x : 42.1121,
 *          y : 1.5557
 *      },
 *      provideBbox : false,
 *      exclusions : ["Bridge", "Tunnel", "Toll"],
 *      distanceUnit : "km",
 *      graph : "Voiture",
 *      geometryInInstructions : false,
 *      routePreference : "fastest"
 *  };
 *
 * @private
 */
function Route (options) {
    if (!(this instanceof Route)) {
        throw new TypeError(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("CLASS_CONSTRUCTOR", "Route"));
    }

    /**
     * Nom de la classe (heritage)
     */
    this.CLASSNAME = "Route";

    // appel du constructeur par heritage
    _CommonService__WEBPACK_IMPORTED_MODULE_3__["default"].apply(this, arguments);

    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("Gp.Services.Route");
    this.logger.trace("[Constructeur Route (options)]");

    if (!options.startPoint) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_MISSING", "startPoint"));
    }

    // on lance une exception afin d'eviter au service de le faire...
    if (options.startPoint.x === null) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_MISSING", "startPoint.x"));
    }

    if (options.startPoint.y === null) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_MISSING", "startPoint.y"));
    }

    if (!options.endPoint) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_MISSING", "endPoint"));
    }

    // on lance une exception afin d'eviter au service de le faire...
    if (options.endPoint.x === null) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_MISSING", "endPoint.x"));
    }

    if (options.endPoint.y === null) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_MISSING", "endPoint.y"));
    }

    // options par defaut
    // on passe l'option api en majuscules afin d'éviter des exceptions.
    this.options.api = (typeof options.api === "string") ? options.api.toUpperCase() : "REST";

    // on passe l'option outputFormat en minuscules afin d'éviter des exceptions.
    this.options.outputFormat = (typeof options.outputFormat === "string") ? options.outputFormat.toLowerCase() : "json";

    this.options.startPoint = options.startPoint;
    this.options.endPoint = options.endPoint;
    this.options.viaPoints = options.viaPoints || null; // INFO mapping viaPoints <=> xls:viaPoint
    this.options.exclusions = options.exclusions || null; // INFO mapping exclusions <=> xls:avoidFeature
    this.options.routePreference = options.routePreference || "fastest";
    this.options.graph = options.graph || "Voiture";
    this.options.geometryInInstructions = options.geometryInInstructions || false; // INFO mapping geometryInInstructions <=> xls:provideGeometry
    this.options.provideBbox = options.provideBbox || true; // INFO mapping provideBbox <=> xls:provideBoundingBox
    this.options.distanceUnit = options.distanceUnit || "km";
    this.options.expectedStartTime = null; // FIXME not yet implemented !
    this.options.srs = options.srs || "EPSG:4326";

    // FIXME : les readers OLS ne sont pas implémentés. on utilise donc l'API REST.
    this.options.api = "REST";
    this.logger.warn("Surcharge option 'api' : REST (readers OLS non implémentés)");
    if (this.options.protocol === "XHR") {
        this.options.httpMethod = "GET";
        this.logger.trace("Surcharge option 'HttpMethod' : " + this.options.httpMethod);
    }

    // gestion de l'url du service par defaut
    // si l'url n'est pas renseignée, il faut utiliser les urls par defaut
    // en fonction du type d'api, REST ou OLS
    if (!this.options.serverUrl) {
        var lstUrlByDefault = _DefaultUrlService__WEBPACK_IMPORTED_MODULE_4__["default"].Route.url(this.options.apiKey);
        var urlFound = null;
        switch (this.options.api) {
            case "OLS":
                urlFound = lstUrlByDefault.ols;
                break;
            case "REST":
                var key = "route" + "-" + this.options.outputFormat;
                urlFound = lstUrlByDefault[key];
                break;
            default:
                throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_UNKNOWN", "api"));
        }

        if (!urlFound) {
            throw new Error("Url by default not found !");
        }
        this.options.serverUrl = urlFound;
        this.logger.trace("Serveur URL par defaut : " + this.options.serverUrl);
    }

    // gestion du type de service
    // si l'extension de l'url est .json ou .xml, on surcharge le format de sortie (outputFormat)
    var idx = this.options.serverUrl.lastIndexOf(".");
    if (idx !== -1) {
        var extension = this.options.serverUrl.substring(idx + 1);
        if (extension && extension.length < 5) { // FIXME extension de moins de 4 car. ...
            this.logger.trace("Serveur Extension URL : " + extension);
            switch (extension.toLowerCase()) {
                case "json":
                case "xml":
                    this.options.outputFormat = extension.toLowerCase();
                    break;
                default:
                    throw new Error("type of service : unknown or unsupported (json or xml) !");
            }
        }
    }
}

/**
 * @lends module:Route#
 */
Route.prototype = Object.create(_CommonService__WEBPACK_IMPORTED_MODULE_3__["default"].prototype, {
    // todo
    // getter/setter
});

/*
 * Constructeur (alias)
 */
Route.prototype.constructor = Route;

/**
 * (overwrite)
 * Création de la requête
 *
 * @param {Function} error   - callback des erreurs
 * @param {Function} success - callback
 */
Route.prototype.buildRequest = function (error, success) {
    var options = {
        // spécifique au service
        api : this.options.api,
        startPoint : this.options.startPoint,
        endPoint : this.options.endPoint,
        viaPoints : this.options.viaPoints,
        provideBbox : this.options.provideBbox,
        exclusions : this.options.exclusions,
        distanceUnit : this.options.distanceUnit,
        graph : this.options.graph,
        geometryInInstructions : this.options.geometryInInstructions,
        routePreference : this.options.routePreference,
        srs : this.options.srs
    };

    this.request = _Request_RouteRequestFactory__WEBPACK_IMPORTED_MODULE_5__["default"].build(options);

    // on teste si la requete a bien été construite !
    if (!this.request) {
        error.call(this, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_REQUEST_BUILD")));
    } else {
        success.call(this, this.request);
    }
};

/**
 * (overwrite)
 * Analyse de la reponse
 *
 * @param {Function} error   - callback des erreurs
 * @param {Function} success - callback
 */
Route.prototype.analyzeResponse = function (error, success) {
    // INFO
    // Factory pour masquer la complexité du retour du service qui renvoie soit
    //  - une 'string' qui contient du XML ou JSON natif en mode XHR
    //  - un objet JSON qui est natif ou encapsulé

    if (this.response) {
        var options = {
            distanceUnit : this.options.distanceUnit, // FIXME ce parametre nous permet de choisir le type d'unité dans la reponse !
            response : this.response,
            outputFormat : this.options.outputFormat, // utile pour parser la string en mode XHR : JSON ou XML !
            api : this.options.api, // utile de connaitre le type d'API car la reponse est differente !
            rawResponse : this.options.rawResponse,
            onError : error,
            onSuccess : success,
            scope : this
        };

        _Response_RouteResponseFactory__WEBPACK_IMPORTED_MODULE_6__["default"].build(options);
    } else {
        error.call(this, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EMPTY")));
    }
};

/* harmony default export */ __webpack_exports__["default"] = (Route);


/***/ }),
/* 120 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(45);
/* harmony import */ var _RouteRequestOLS__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(121);
/* harmony import */ var _RouteRequestREST__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(126);
/**
 * Creation d'une requête OpenLS ou REST en mode POST ou GET
 * (Factory)
 *
 * @module RouteRequestFactory
 * @alias Gp.Services.Route.Request.RouteRequestFactory
 * @private
 */





var RouteRequestFactory = {

    /**
     * interface unique
     *
     * @method build
     * @static
     * @param {Object} options - options definies dans le composant Route
     *
     * @example
     *   // utilisation avec les callback
     *   var options = {
     *      (...)
     *      onSuccess : function (response) {},
     *      onError : function (error) {},
     *      // spécifique au service
     *      api : 'OLS',
     *      startPoint : {
     *          x : 42.1121,
     *          y : 1.5557
     *      },
     *      endPoint : {
     *          x : 42.1121,
     *          y : 1.5557
     *      },
     *      provideBbox : false,
     *      exclusions : ["Bridge", "Tunnel", "Toll"],
     *      distanceUnit : "km",
     *      graph : "Voiture",
     *      geometryInInstructions : false,
     *      routePreference : "fastest"
     *   };
     *   RouteRequestFactory.build(options);
     *
     *   // utilisation sans callback
     *   var options = {...};
     *   try {
     *      var result = RouteRequestFactory.build(options);
     *      if (! result) { throw new Error("..."):}
     *   } catch (e) {
     *      // todo
     *   }
     * @returns {String} request
     */
    build : function (options) {
        // logger
        var logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("RouteRequestFactory");
        logger.trace(["RouteRequestFactory::build()"]);

        var request = null;

        var settings = options || {};

        // gestion des callback
        var bOnError = !!((options.onError !== null && typeof options.onError === "function"));

        var message = null;
        // choix entre les 2 types d'API pour consulter le service
        switch (options.api) {
            case "REST":
                // FIXME les exceptions ne sont pas 'catchées' sur le constructeur !
                var myReq = new _RouteRequestREST__WEBPACK_IMPORTED_MODULE_3__["default"](settings);
                if (!myReq.processRequestString()) {
                    message = "Error process request (rest) !";
                    if (bOnError) {
                        options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_1__["default"](message));
                        return;
                    }
                    throw new Error(message);
                }
                request = myReq.requestString;
                break;
            case "OLS":
                request = _RouteRequestOLS__WEBPACK_IMPORTED_MODULE_2__["default"].build(settings);
                if (!request) {
                    message = "Error process request (ols) !";
                    if (bOnError) {
                        options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_1__["default"](message));
                        return;
                    }
                    throw new Error(message);
                }
                break;
            default:
                message = "Type of API is not supported by service (REST or OLS) !";
                if (bOnError) {
                    options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_1__["default"](message));
                    return;
                }
                throw new Error(message);
        }

        return request;
    }
};

/* harmony default export */ __webpack_exports__["default"] = (RouteRequestFactory);


/***/ }),
/* 121 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _Formats_XLS__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(89);
/* harmony import */ var _Formats_XLS_RouteService__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(122);
/**
 * Creation d'une requête OpenLS en mode POST ou GET
 * (Factory)
 *
 * @module RouteRequestOLS
 * @alias Gp.Services.Route.Request.RouteRequestOLS
 * @private
 */




var RouteRequestOLS = {

    /**
     * interface unique
     *
     * @method build
     * @static
     * @param {Object} options - options definies dans le composant Route
     *
     * @example
     *   var options = {
     *      (...)
     *   };
     *
     * @returns {String} request
     */
    build : function (options) {
        // logger
        var logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("RouteRequestOLS");
        logger.trace(["RouteRequestOLS::build()"]);

        var request = null;

        // spécifique au service
        var settings = {
            startPoint : options.startPoint,
            endPoint : options.endPoint,
            viaPoint : options.viaPoints, // mapping OLS et options
            provideBoundingBox : options.provideBbox, // mapping OLS et options
            avoidFeature : options.exclusions, // mapping OLS et options
            expectedStartTime : options.expectedStartTime, // TODO format ?
            distanceUnit : options.distanceUnit,
            graph : options.graph,
            provideGeometry : options.geometryInInstructions, // mapping OLS et options
            routePreference : options.routePreference
        };

        // objet RouteService
        var oRS = new _Formats_XLS_RouteService__WEBPACK_IMPORTED_MODULE_2__["default"](settings);

        // Format XLS
        var oXLS = new _Formats_XLS__WEBPACK_IMPORTED_MODULE_1__["default"]({
            srsName : options.srs,
            maximumResponses : options.maximumResponses
        });
        oXLS.namespace = true;
        oXLS.setService(oRS);

        // request brute !
        request = oXLS.build();

        // en mode GET, la requête est encodée
        // et le param. 'qxml' est ajouté
        if (options.httpMethod === "GET") {
            var myRequest = "qxml=" +
                encodeURIComponent(request)
                    .replace(/-/g, "%2D")
                    .replace(/_/g, "%5F")
                    .replace(/\./g, "%2E")
                    .replace(/!/g, "%21")
                    .replace(/~/g, "%7E")
                    .replace(/\*/g, "%2A")
                    .replace(/'/g, "%27")
                    .replace(/\(/g, "%28")
                    .replace(/\)/g, "%29");
            request = myRequest;
        }

        return request;
    }
};

/* harmony default export */ __webpack_exports__["default"] = (RouteRequestOLS);


/***/ }),
/* 122 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _AbstractService__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(92);
/* harmony import */ var _RouteService_DetermineRouteRequest__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(123);
/* harmony import */ var _RouteService_RouteRequestExtension__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(125);
/* harmony import */ var _RouteService_RouteRequestExtension__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_RouteService_RouteRequestExtension__WEBPACK_IMPORTED_MODULE_3__);





/**
 * @classdesc
 *
 * Requête de type RouteService
 * (Factory)
 *
 * XSD :
 * ----
 * [] => non implementé !
 *
 * ```
 * element name="DetermineRouteRequest"
 *  [attribute name="provideRouteHandle" default="false"]
 *  attribute name="distanceUnit"       default="M"
 *      [element ref="xls:RouteHandle" || element ref="xls:RoutePlan"]
 *      element ref="xls:RoutePlan"
 *      element ref="xls:RouteInstructionsRequest"
 *      [element ref="xls:RouteGeometryRequest"]
 *      [element ref="xls:RouteMapRequest"]
 * ```
 * ```
 * element name="RoutePlan"
 *  [attribute name="useRealTimeTraffic" default="false"]
 *  [attribute name="expectedStartTime"  type="dateTime"]
 *  [attribute name="expectedEndTime"    type="dateTime"]
 *      element ref="xls:RoutePreference"
 *      element ref="xls:WayPointList"
 *      element ref="xls:AvoidList"
 * ```
 * ```
 * element name="RoutePreference" => value = Fastest | Shortest | Pedestrian
 * ```
 * ```
 * element name="WayPointList"
 *      element ref="xls:StartPoint"
 *      element ref="xls:ViaPoint" minOccurs="0"
 *      element ref="xls:EndPoint"
 * ```
 * ```
 * element name="StartPoint"
 *    [element name="GeocodeMatchCode"]
 *      [attribute name="accuracy"]
 *      [attribute name="matchType"] => value = City, Street, Street number, Street enhanced, ...
 *    element name="Position"
 *      element ref="gml:Point"
 * ```
 * ```
 * element name="ViaPoint"
 *    [element name="GeocodeMatchCode"]
 *      [attribute name="accuracy"]
 *      [attribute name="matchType"] => value = City, Street, Street number, Street enhanced, ...
 *    element name="Position"
 *      element ref="gml:Point"
 * ```
 * ```
 * element name="EndPoint"
 *    [element name="GeocodeMatchCode"]
 *      [attribute name="accuracy"]
 *      [attribute name="matchType"] => value = City, Street, Street number, Street enhanced, ...
 *    element name="Position"
 *      element ref="gml:Point"
 * ```
 * ```
 * element name="AvoidList"
 *      [element ref="xls:AOI"]
 *      [element ref="xls:_Location"] (cf. element name="Position")
 *      element ref="xls:AvoidFeature"
 * ```
 * ```
 * [element name="AOI"]
 *      [element ref="gml:CircleByCenterPoint" || element ref="gml:Polygon" || element ref="gml:Envelope"]
 * ```
 * ```
 * element name="AvoidFeature" => value = highway | tollway | tunnel | bridge
 * ```
 * ```
 * [element name="RouteMapRequest"]
 *      [element name="Output"]
 *          attribute name="width"
 *          attribute name="height"
 *          attribute name="format"
 *          attribute name="BGcolor"
 *          attribute name="transparent"
 *          attribute name="style" => value = Overview | Maneuver
 *          element name="BBoxContext" type="gml:EnvelopeType"
 * ```
 * ```
 * element name="RouteInstructionsRequest"
 *  [attribute name="format"]           default="text/plain"
 *  attribute name="provideGeometry"    default="false"
 *  attribute name="provideBoundingBox" default="false"
 * ```
 * ```
 * [element name="RouteGeometryRequest"]
 *  [attribute name="scale"]                  default="1"
 *  [attribute name="provideStartingPortion"] default="false"
 *  [attribute name="maxPoints"]              default="100"
 *      [element name="BoundingBox" type="gml:EnvelopeType" ]
 * ```
 *
 * --------
 * Requête :
 * --------
 * ```
 * <?xml version="1.0" encoding="UTF-8"?>
 * <XLS
 * xmlns:xls="http://www.opengis.net/xls"
 * xmlns:sch="http://www.ascc.net/xml/schematron"
 * xmlns:gml="http://www.opengis.net/gml"
 * xmlns:xlsext="http://www.opengis.net/xlsext"
 * xmlns:xlink="http://www.w3.org/1999/xlink"
 * xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
 * xsi:schemaLocation="http://www.opengis.net/xls http://schemas.opengis.net/ols/1.1.0/RouteService.xsd"
 * version="1.1" xls:lang="en">
 * <RequestHeader/>
 * <Request methodName="RouteRequest" requestID="123456789" version="1.1">
 *   <DetermineRouteRequest distanceUnit="KM">
 *     <RoutePlan>
 *       <RoutePreference>Fastest</RoutePreference>
 *       <xlsext:vehicle name="Car" />
 *       <WayPointList>
 *         <StartPoint>
 *           <Position><gml:Point srsName="EPSG:4326"><gml:pos>2.29993 48.87228</gml:pos></gml:Point></Position>
 *         </StartPoint>
 *         <EndPoint>
 *           <Position><gml:Point srsName="EPSG:4326"><gml:pos>-1.53604 47.21548</gml:pos></gml:Point></Position>
 *         </EndPoint>
 *       </WayPointList>
 *     </RoutePlan>
 *     <RouteInstructionsRequest provideGeometry="true"/>
 *     <RouteGeometryRequest/>
 *   </DetermineRouteRequest>
 * </Request>
 * </XLS
 * ```
 * -----------
 * References :
 * -----------
 * - {@link https://geoportail.forge.ign.fr/jira/browse/GPP-CI}
 * - {@link https://geoportail.forge.ign.fr/jira/browse/GPP-CI-1 Specif. ols}
 * - {@link https://geoportail.forge.ign.fr/jira/browse/GPP-CI-9 Extension}
 * - {@link https://github.com/Emergya/openlayers/blob/master/lib/OpenLayers/Format/XLS/v1_2_0.js}
 *
 * @example
 * // encapsule un objet dans une coquille XSL, Factory sur les objets ''
 * rs = new RouteService ();
 * rs.addRequest (req);
 * rs.toString();
 *  ou
 * rs = new RouteService ({
 *      ...
 * });
 * rs.toString();
 *
 * @extends {Gp.Formats.XLS}
 * @constructor
 * @alias Gp.Formats.XLS.RouteService
 * @param {Object} options - options
 * @param {Object}   options.routePreference - « fastest », « shortest » ou « pedestrian »
 * @param {String}   options.startPoint - Point de départ (coordonnées exprimées en WGS84G)
 * @param {String}   options.viaPoint - Liste de points intermédiaires
 * @param {String}   options.endPoint - Point d'arrivée (coordonnées)
 * @param {Object}   options.avoidFeature - « highway », « tollway », « tunnel » ou « bridge »
 * @param {Object}   options.graph - « car »
 * @param {Object}   options.expectedStartTime - Date et heure de départ
 * @param {Object}   options.provideGeometry - true | false
 * @param {Object}   options.provideBoundingBox - true | false
 * @param {Object}   options.distanceUnit - Unité dans lesquelles la distance est exprimée (« m » ou « km »)
 * @param {Function} options.onsuccess - function callback success (TODO)
 * @param {Function} options.onerror   - function callback error   (TODO)
 *
 * @example
 * var options = {
 *      // spécifique au service
 *      startPoint: {
 *          x: 42.1121,
 *          y: 1.5557
 *      },
 *      endPoint: {
 *          x: 42.1121,
 *          y: 1.5557
 *      },
 *      viaPoint : [
 *          {x: 42.1121,y: 1.5557},
 *          {x: 42.1121,y: 1.5557},
 *          {x: 42.1121,y: 1.5557}
 *      ],
 *      provideBoundingBox : false,
 *      avoidFeature : ["bridge", "tunnel", "tollway"],
 *      expectedStartTime : "2015-12-23", // YYYY-MM-DDThh:mm:ssZ
 *      distanceUnit : "km",
 *      vehicle: "car",
 *      provideGeometry : false,
 *      routePreference : "fastest"
 * };
 *
 * @private
 */
function RouteService (options) {
    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger();
    this.logger.trace("[Constructeur RouteService ()]");

    if (!(this instanceof RouteService)) {
        throw new TypeError("RouteService constructor cannot be called as a function.");
    }

    /**
     * Nom de la classe
     */
    this.CLASSNAME = "RouteService";

    /**
     * Type de classe
     * RouteRequest par defaut
     */
    this.CLASSTYPE = "RouteRequest";

    // appel du constructeur par heritage
    _AbstractService__WEBPACK_IMPORTED_MODULE_1__["default"].apply(this, arguments);
}

/**
 * @lends module:RouteService#
 */
RouteService.prototype = Object.create(_AbstractService__WEBPACK_IMPORTED_MODULE_1__["default"].prototype, {
    // todo
    // getter/setter
});

/**
 * Constructeur (alias)
 */
RouteService.prototype.constructor = RouteService;

/**
 * (overwrite) Ajout d'un objet de type  : RouteRequest
 *
 * @param {Object} oRequest - RouteRequest
 */
RouteService.prototype.addRequest = function (oRequest) {
    // on controle les types acceptés
    if (oRequest.CLASSNAME === "DetermineRouteRequest") {
        this.oRequest = oRequest;
    } else {
        throw new Error("Ce n'est pas un objet de type 'Route Request' !?");
    }
};

/**
 * (overwrite) Ajout d'un objet de type RouteFilterExtension
 *
 * @param {Object} oFilter - RouteFilterExtension
 */
RouteService.prototype.addFilter = function (oFilter) {
    // gestion des extensions (vehicle)
    if (oFilter instanceof _RouteService_RouteRequestExtension__WEBPACK_IMPORTED_MODULE_3___default.a) {
        this.oFilter = oFilter;
    }
};

/**
 * (overwrite) toString
 *
 * @returns {String} requête
 */
RouteService.prototype.toString = function () {
    // soit, on a un objet Request déjà instancié
    // sinon, il faut le construire à partir des options à disposition
    if (!this.oRequest) {
        // il nous faut des options
        if (!this.options) {
            throw new Error("Les options ne sont pas renseignées, impossible de construire la requête !");
        }

        if (this.CLASSTYPE === "RouteRequest") {
            var settings = {
                distanceUnit : this.options.distanceUnit || null,
                provideGeometry : this.options.provideGeometry || null,
                provideBoundingBox : this.options.provideBoundingBox || null,
                route : {
                    routePreference : this.options.routePreference || null,
                    startPoint : this.options.startPoint,
                    viaPoint : this.options.viaPoint || null,
                    endPoint : this.options.endPoint,
                    avoidFeature : this.options.avoidFeature || null,
                    graph : this.options.graph || null,
                    expectedStartTime : this.options.expectedStartTime || null
                }
            };
            this.oRequest = new _RouteService_DetermineRouteRequest__WEBPACK_IMPORTED_MODULE_2__["default"](settings);
            // ajout des filtres spécifiques au service
            if (this.oFilter) {
                this.oRequest.addFilter(this.oFilter);
            }
        }
    }

    // objet indefini !?
    if (!this.oRequest) {
        throw new Error("Type de requête indefini !");
    }

    this.strRequest = this.oRequest.toString();
    return this.strRequest;
};

/* harmony default export */ __webpack_exports__["default"] = (RouteService);


/***/ }),
/* 123 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _model_RoutePlan__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(124);



/**
 * @classdesc
 *
 * Requête de calcul d'itinéraire
 *
 * ----
 * XSD :
 * ----
 * [] => non implementé !
 *
 * ```
 * element name="DetermineRouteRequest"
 *  [attribute name="provideRouteHandle" default="false"]
 *  attribute name="distanceUnit"       default="M"
 *      [element ref="xls:RouteHandle" || element ref="xls:RoutePlan"]
 *      element ref="xls:RoutePlan"
 *      element ref="xls:RouteInstructionsRequest"
 *      [element ref="xls:RouteGeometryRequest"]
 *      [element ref="xls:RouteMapRequest"]
 * ```
 * ```
 * element name="RouteInstructionsRequest"
 *  [attribute name="format"]           default="text/plain"
 *  attribute name="provideGeometry"    default="false"
 *  attribute name="provideBoundingBox" default="false"
 * ```
 * ```
 * element name="RouteGeometryRequest"
 *  [attribute name="scale"]                  default="1"
 *  [attribute name="provideStartingPortion"] default="false"
 *  [attribute name="maxPoints"]              default="100"
 *      [element name="BoundingBox" type="gml:EnvelopeType" ]
 * ```
 * ```
 * [element name="RouteMapRequest"]
 *      [element name="Output"]
 *          [attribute name="width"]
 *          [attribute name="height"]
 *          [attribute name="format"]
 *          [attribute name="BGcolor"]
 *          [attribute name="transparent"]
 *          [attribute name="style"] => value = Overview | Maneuver
 *          [element name="BBoxContext" type="gml:EnvelopeType"]
 * ```
 *
 * --------
 * Requête :
 * --------
 * ```
 *   <DetermineRouteRequest distanceUnit="KM">
 *     <RoutePlan>
 *              <RoutePreference>Fastest</RoutePreference>
 *              <xlsext:vehicle name="Car" />
 *              <WayPointList>
 *                  <StartPoint>
 *                      <Position><gml:Point srsName="EPSG:4326"><gml:pos>2.29993 48.87228</gml:pos></gml:Point></Position>
 *                  </StartPoint>
 *                  <EndPoint>
 *                      <Position><gml:Point srsName="EPSG:4326"><gml:pos>-1.53604 47.21548</gml:pos></gml:Point></Position>
 *                  </EndPoint>
 *              </WayPointList>
 *     </RoutePlan>
 *     <RouteInstructionsRequest provideGeometry="true"/>
 *     <RouteGeometryRequest/>
 *   </DetermineRouteRequest>
 * ```
 *
 * @constructor
 * @alias Gp.Formats.XLS.RouteService.DetermineRouteRequest
 * @param {Object} options - options
 * @param {Object}   options.route.routePreference - « fastest », « shortest » ou « pedestrian »
 * @param {String}   options.route.startPoint - Point de départ (coordonnées exprimées en WGS84G)
 * @param {String}   options.route.viaPoint - Liste de points intermédiaires
 * @param {String}   options.route.endPoint - Point d'arrivée (coordonnées)
 * @param {Object}   options.route.avoidFeature - « highway », « tollway », « tunnel » ou « bridge »
 * @param {Object}   options.route.vehicle - « car »
 * @param {Object}   options.route.expectedStartTime - Date et heure de départ
 * @param {Object}   options.provideGeometry - true | false
 * @param {Object}   options.provideBoundingBox - true | false
 * @param {Object}   options.distanceUnit - Unité dans lesquelles la distance est exprimée (« m » ou « km »)
 * @param {Function} options.onsuccess - function callback success (TODO)
 * @param {Function} options.onerror   - function callback error   (TODO)
 *
 * @private
 */
function DetermineRouteRequest (options) {
    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger();
    this.logger.trace("[Constructeur DetermineRouteRequest ()]");

    if (!(this instanceof DetermineRouteRequest)) {
        throw new TypeError("DetermineRouteRequest constructor cannot be called as a function.");
    }

    // options par defaut
    this.options = options || {};

    // et on ajoute les options en paramètre aux options par défaut
    for (var opt in options) {
        if (options.hasOwnProperty(opt)) {
            this.options[opt] = options[opt];
        }
    }

    /**
     * Nom de la classe (heritage)
     */
    this.CLASSNAME = "DetermineRouteRequest";
}

DetermineRouteRequest.prototype = {

    /**
     * @lends module:DetermineRouteRequest#
     */

    /**
     * request (out)
     * @type {String}
     */
    strRequest : null,

    /**
     * RoutePlan
     * @type {Address}
     */
    oRoutePlan : null,

    /**
     * Template de la requête.
     * substitution des valeurs suivantes :
     * __DISTANCEUNIT__,
     * __ROUTEPLAN__, __ROUTEINSTRUCTIONREQUEST__, __ROUTEGEOMETRYREQUEST__, __ROUTEMAPREQUEST__
     * __PROVIDEGEOMETRY__, __PROVIDEBBOX__
     */
    template : {
        determineRouteRequest : "<DetermineRouteRequest distanceUnit=\"__DISTANCEUNIT__\">" +
            "__ROUTEPLAN__" +
            "__ROUTEINSTRUCTIONREQUEST__" +
            "__ROUTEGEOMETRYREQUEST__" +
            "__ROUTEMAPREQUEST__" +
            "</DetermineRouteRequest>",
        routeInstructionRequest : "<RouteInstructionsRequest " +
            "provideGeometry=\"__PROVIDEGEOMETRY__\" " +
            "provideBoundingBox=\"__PROVIDEBBOX__\" />",
        routeGeometryRequest : "<RouteGeometryRequest />",
        routeMapRequest : "" // FIXME <RouteMapRequest/> not yet implemented !
    },

    /**
     * Ajout d'un objet de type RoutePlan
     *
     * @param {Object} oRoutePlan - RoutePlan
     */
    addRoute : function (oRoutePlan) {
        if (oRoutePlan instanceof _model_RoutePlan__WEBPACK_IMPORTED_MODULE_1__["default"]) {
            this.oRoutePlan = oRoutePlan;
        }
    },

    /**
     * Constructeur (alias)
     */
    constructor : DetermineRouteRequest,

    /**
     * toString
     *
     * @returns {String} requête
     */
    toString : function () {
        var template = "";
        template = this.template.determineRouteRequest;
        template = template.replace(/__DISTANCEUNIT__/g, this.options.distanceUnit || "KM");

        // soit on a déjà un objet RoutePlan instancié,
        // sinon, on le fabrique via les options
        if (!this.oRoutePlan) {
            var settings = this.options.route;

            this.oRoutePlan = new _model_RoutePlan__WEBPACK_IMPORTED_MODULE_1__["default"](settings);
            if (!this.oRoutePlan) {
                throw new Error("La construction du calcul d'initineraire n'est pas correctement definie !?");
            }
        }

        // routeplan
        template = template.replace(/__ROUTEPLAN__/g, this.oRoutePlan.toString());

        // instruction
        var tmplInstruction = this.template.routeInstructionRequest;
        tmplInstruction = tmplInstruction.replace(/__PROVIDEGEOMETRY__/g, this.options.provideGeometry || false);
        tmplInstruction = tmplInstruction.replace(/__PROVIDEBBOX__/g, this.options.provideBoundingBox || false);
        template = template.replace(/__ROUTEINSTRUCTIONREQUEST__/g, tmplInstruction);

        // geometry
        var tmplGeometry = this.template.routeGeometryRequest;
        template = template.replace(/__ROUTEGEOMETRYREQUEST__/g, tmplGeometry);

        // map
        var tmplMap = this.template.routeMapRequest;
        template = template.replace(/__ROUTEMAPREQUEST__/g, tmplMap);

        this.strRequest = template;
        return this.strRequest;
    }
};

/* harmony default export */ __webpack_exports__["default"] = (DetermineRouteRequest);


/***/ }),
/* 124 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);


/**
 * @classdesc
 *  * Élément regroupant l'ensemble des données et paramètres pour le calcul d'itinéraire : points de navigation, configuration.
 *
 * ----
 * XSD :
 * ----
 * [] => non implementé !
 *
 * ```
 * element name="RoutePlan"
 *  [attribute name="useRealTimeTraffic" default="false"]
 *  [attribute name="expectedStartTime"  type="dateTime"]
 *  [attribute name="expectedEndTime"    type="dateTime"]
 *      element ref="xls:RoutePreference"
 *      element ref="xls:WayPointList"
 *      element ref="xls:AvoidList"
 * ```
 * ```
 * element name="RoutePreference"
 *  => value = fastest | shortest | pedestrian
 * ```
 * ```
 * element name="WayPointList"
 *      element ref="xls:StartPoint"
 *      element ref="xls:ViaPoint" minOccurs="0"
 *      element ref="xls:EndPoint"
 * ```
 * ```
 * element name="StartPoint"
 *    [element name="GeocodeMatchCode"]
 *      [attribute name="accuracy"]
 *      [attribute name="matchType"] => value = City, Street, Street number, Street enhanced, ...
 *    element name="Position"
 *      element ref="gml:Point"
 * ```
 * ```
 * element name="ViaPoint"
 *    [element name="GeocodeMatchCode"]
 *      [attribute name="accuracy"]
 *      [attribute name="matchType"] => value = City, Street, Street number, Street enhanced, ...
 *    element name="Position"
 *      element ref="gml:Point"
 * ```
 * ```
 * element name="EndPoint"
 *    [element name="GeocodeMatchCode"]
 *      [attribute name="accuracy"]
 *      [attribute name="matchType"] => value = City, Street, Street number, Street enhanced, ...
 *    element name="Position"
 *      element ref="gml:Point"
 * ```
 * ```
 * element name="AvoidList"
 *      [element ref="xls:AOI"]
 *      [element ref="xls:_Location"] (cf. element name="Position")
 *      element ref="xls:AvoidFeature"
 * ```
 * ```
 * [element name="AOI"]
 *      [element ref="gml:CircleByCenterPoint" || element ref="gml:Polygon" || element ref="gml:Envelope"]
 * ```
 * ```
 * element name="AvoidFeature" => value = highway | tollway | tunnel | bridge
 * ```
 *
 * --------
 * Requête :
 * --------
 * ```
 *     <RoutePlan>
 *       <RoutePreference>Fastest</RoutePreference>
 *       <xlsext:vehicle name="Car" />
 *       <WayPointList>
 *         <StartPoint>
 *           <Position><gml:Point srsName="EPSG:4326"><gml:pos>2.29993 48.87228</gml:pos></gml:Point></Position>
 *         </StartPoint>
 *         <EndPoint>
 *           <Position><gml:Point srsName="EPSG:4326"><gml:pos>-1.53604 47.21548</gml:pos></gml:Point></Position>
 *         </EndPoint>
 *       </WayPointList>
 *       <AvoidList>
 *          <AvoidFeature>highway</AvoidFeature>
 *          <AvoidFeature>tollway</AvoidFeature>
 *          <AvoidFeature>tunnel</AvoidFeature>
 *       </AvoidList>
 *     </RoutePlan>
 * ```
 * @constructor
 * @alias Gp.Formats.XLS.RouteService.RoutePlan
 * @param {Object} options - options
 *
 * @private
 */
function RoutePlan (options) {
    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("RoutePlan");
    this.logger.trace("[Constructeur RoutePlan ()]");

    if (!(this instanceof RoutePlan)) {
        throw new TypeError("RoutePlan constructor cannot be called as a function.");
    }

    // param par defaut
    this.options = options || {};

    // param obligatoire
    if (!options.startPoint) {
        throw new Error("l'option 'startPoint' n'est pas renseignée !");
    }

    if (!options.endPoint) {
        throw new Error("l'option 'endPoint' n'est pas renseignée !");
    }

    // et on ajoute les options en paramètre aux options par défaut
    for (var opt in options) {
        if (options.hasOwnProperty(opt)) {
            this.options[opt] = options[opt];
        }
    }
}

RoutePlan.prototype = {

    /**
     * Constructeur (alias)
     */
    constructor : RoutePlan,

    /**
     * request (out)
     * @type {String}
     */
    requestString : null,

    /**
     * Template de la requête.
     * substitution des valeurs suivantes :
     * - __ROUTEPREFERENCE__, __VALUEROUTEPREFERENCE__
     * - __GRAPH__, __VALUEGRAPH__
     * - __WAYPOINTLIST__ (lst?), __STARTPOINT__, __VIAPOINT__, __ENDPOINT__, __POINT__, __X__, __Y__
     * - __AVOIDLIST__ (lst!), __AVOIDFEATURE__, __VALUEAVOIDFEATURE__
     */
    template : {
        routePlan : "<RoutePlan>" +
            "__ROUTEPREFERENCE__" +
            "__GRAPH__" +
            "__WAYPOINTLIST__" +
            "__AVOIDLIST__" +
            "</RoutePlan>",
        routePreference : "<RoutePreference>__VALUEROUTEPREFERENCE__</RoutePreference>",
        graph : "<xlsext:graphName xmlns:xlsext=\"http://www.opengis.net/xlsext\" name=\"__VALUEGRAPH__\"/>",
        wayPointList : {
            container : "<WayPointList>" +
                "__STARTPOINT__" +
                "__VIAPOINT__" +
                "__ENDPOINT__" +
                "</WayPointList>",
            point : "<Position><gml:Point xmlns:gml=\"http://www.opengis.net/gml\"><gml:pos>__X__ __Y__</gml:pos></gml:Point></Position>",
            startPoint : "<StartPoint>" +
                "__POINT__" +
                "</StartPoint>",
            endPoint : "<EndPoint>" +
                "__POINT__" +
                "</EndPoint>",
            viaPoint : "<ViaPoint>" +
                "__POINT__" +
                "</ViaPoint>" // implémentation de plusieurs étapes...
        },
        avoidList : {
            container : "<AvoidList>" +
                "__AVOIDFEATURE__" +
                "</AvoidList>",
            avoidFeature : "<AvoidFeature>__VALUEAVOIDFEATURE__</AvoidFeature>"
        }
    },

    /**
     * toString
     *
     * @returns {String} requête
     */
    toString : function () {
        var template = "";
        template = this.template.routePlan;

        // preference
        if (this.options.routePreference) {
            var tmplPreference = this.template.routePreference;
            tmplPreference = tmplPreference.replace(/__VALUEROUTEPREFERENCE__/, this.options.routePreference);
            template = template.replace(/__ROUTEPREFERENCE__/g, tmplPreference);
        }
        // clean preference
        template = template.replace(/__ROUTEPREFERENCE__/g, "");

        // exclusions
        if (this.options.avoidFeature) {
            var tmplAvoidList = this.template.avoidList.container;
            var avoidFeatures = [];
            for (var i = 0; i < this.options.avoidFeature.length; i++) {
                var tmplAvoidFeature = this.template.avoidList.avoidFeature;
                tmplAvoidFeature = tmplAvoidFeature.replace(/__VALUEAVOIDFEATURE__/, this.options.avoidFeature[i]);
                avoidFeatures.push(tmplAvoidFeature);
            }
            tmplAvoidList = tmplAvoidList.replace(/__AVOIDFEATURE__/, avoidFeatures.join("\n"));
            template = template.replace(/__AVOIDLIST__/g, tmplAvoidList);
        }
        // clean exclusions
        template = template.replace(/__AVOIDLIST__/g, "");

        // graph
        if (this.options.graph) {
            var tmplVehicle = this.template.graph;
            tmplVehicle = tmplVehicle.replace(/__VALUEGRAPH__/, this.options.graph);
            template = template.replace(/__GRAPH__/g, tmplVehicle);
        }
        // clean vehicle
        template = template.replace(/__GRAPH__/g, "");

        // points
        var tmplWayPointList = this.template.wayPointList.container;
        var tmplPoint = "";
        // start
        tmplPoint = this.template.wayPointList.point;
        tmplPoint = tmplPoint.replace(/__X__/, this.options.startPoint.x);
        tmplPoint = tmplPoint.replace(/__Y__/, this.options.startPoint.y);
        tmplWayPointList = tmplWayPointList.replace(/__STARTPOINT__/,
            this.template.wayPointList.startPoint.replace(/__POINT__/, tmplPoint));
        // end
        tmplPoint = this.template.wayPointList.point;
        tmplPoint = tmplPoint.replace(/__X__/, this.options.endPoint.x);
        tmplPoint = tmplPoint.replace(/__Y__/, this.options.endPoint.y);
        tmplWayPointList = tmplWayPointList.replace(/__ENDPOINT__/,
            this.template.wayPointList.endPoint.replace(/__POINT__/, tmplPoint));
        // via
        if (this.options.viaPoint) {
            var points = [];
            for (var j = 0; j < this.options.viaPoint.length; j++) {
                var p = this.options.viaPoint[j];
                tmplPoint = this.template.wayPointList.point;
                tmplPoint = tmplPoint.replace(/__X__/, p.x);
                tmplPoint = tmplPoint.replace(/__Y__/, p.y);
                points.push(tmplPoint);
            }

            tmplWayPointList = tmplWayPointList.replace(/__VIAPOINT__/,
                this.template.wayPointList.viaPoint.replace(/__POINT__/, points.join("\n")));
        } else {
            // clean viaPoint
            tmplWayPointList = tmplWayPointList.replace(/__VIAPOINT__/, "");
        }

        template = template.replace(/__WAYPOINTLIST__/g, tmplWayPointList);

        this.requestString = template;
        return this.requestString;
    }
};

/* harmony default export */ __webpack_exports__["default"] = (RoutePlan);


/***/ }),
/* 125 */
/***/ (function(module, exports) {

/**
 * not implemented !
 *
 * Extension de type 'graphName' de l'objet RoutePlan'
 *
 * FIXME L'extension 'graphName' est intégré comme étant du standard OLS.
 *       La balise <xlsext:GraphName> viendrait surcharger le comportement de RoutePreference...
 *
 * ex. <xlsext:graphName name="Voiture" />
 */


/***/ }),
/* 126 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44);
/* harmony import */ var _model_RouteParamREST__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(127);





/**
 * @classdesc
 * Classe de gestion des requêtes de type REST sur le service de calcul d'itineraire
 * (uniquement en GET)
 *
 * @constructor
 * @alias Gp.Services.Route.Request.RouteRequestREST
 * @param {Object} options - options definies dans le composant Route
 *
 * @example
 * var options = {
 *      (...)
 * };
 *
 * @private
 */
function RouteRequestREST (options) {
    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("RouteRequestREST");
    this.logger.trace("[Constructeur RouteRequestREST ()]");

    if (!(this instanceof RouteRequestREST)) {
        throw new TypeError("RouteRequestREST constructor cannot be called as a function.");
    }

    // existance des options
    if (!options) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_EMPTY", "options"));
    }

    /** liste des options */
    this.settings = options;
}

RouteRequestREST.prototype = {

    /**
     * @lends module:RouteRequestREST#
     */

    /**
     * request
     * @type {String}
     */
    requestString : null,

    /**
     * Constructeur (alias)
     */
    constructor : RouteRequestREST,

    /**
     * Construction de la requête.
     *
     * @example
     * // GET  out : origin=2.416907353809513,48.8465772142297&destination=2.4248037771493673,48.84591353161838
     * // POST out : Not yet supported method POST !
     * @returns {String} request
     */
    processRequestString : function () {
        // INFO
        // construction simple sans template...,
        // mais en attendant que les services soient fixés, on taggue ce composant en mode PROTOTYPE !
        this.logger.warn(" PROTOTYPE !");

        // Mapping des options avec le service de l'API REST
        var oParams = new _model_RouteParamREST__WEBPACK_IMPORTED_MODULE_2__["default"](this.settings);
        var params = oParams.getParams();

        var request = "";
        for (var i = 0; i < params.length; i++) {
            var o = params[i];
            if (request) {
                request += "&";
            }
            request += o.k + "=" + o.v;
        }

        // Exemple :
        //  http://wxs.ign.fr/KEY/itineraire/rest/route.json?
        //  origin=&
        //  destination=&
        //  waypoints=&
        //  method=DISTANCE&
        //  graph=Pieton&
        //  graphName=Pieton&
        //  exclusions=&
        //  tolerance=10&
        //  srs=

        this.logger.trace(request);
        this.requestString = request;

        return this.requestString;
    }
};

/* harmony default export */ __webpack_exports__["default"] = (RouteRequestREST);


/***/ }),
/* 127 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);



/**
 * @classdesc
 * Classe de gestion des param. des requêtes du service de calcul d'itineraire (REST).
 *      Permet le mapping avec les options du service.
 * @constructor
 * @alias Gp.Services.Route.Request.RouteParamREST
 * @param {Object} options - options
 *
 * @private
 */
function RouteParamREST (options) {
    if (!(this instanceof RouteParamREST)) {
        throw new TypeError("RouteParamREST constructor cannot be called as a function.");
    }

    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger();
    this.logger.trace("[Constructeur RouteParamREST ()]");

    /**
     * Options en paramêtres du constructeur.
     */
    this.options = options || {};

    // mapping des options avec l'API REST

    /** Coordonnées du point de départ. */
    this.origin = this.options.startPoint.x + "," + this.options.startPoint.y;

    /** Coordonnées du point d’arrivée. */
    this.destination = this.options.endPoint.x + "," + this.options.endPoint.y;

    /** Coordonnées des étapes point de départ. */
    this.waypoints = this.options.viaPoints || null;

    /** Date et heure de départ */
    this.startDateTime = this.options.expectedStartTime || null; // TODO format !?

    /** Nom du graphe à utiliser */
    this.graphName = this.options.graph;

    /** projection (code EPSG comme epsg:4326 ou wgs84) */
    this.srs = this.options.srs;

    /** Liste des règles de restrictions à utiliser, séparés pas le caractère , ou ; (Exemple : Toll, Tunnel, Bridge) */
    this.exclusions = this.options.exclusions;

    /**
     * itinéraire le plus court (DISTANCE) ou le plus rapide (TIME)
     * Par defaut, DISTANCE...
     * cf. mapping ci dessous
     */
    this.method = "TIME";

    // mapping particulier sur l'option 'routePreference'
    if (this.options.routePreference) {
        var value = this.options.routePreference;
        switch (value) {
            case "fastest":
                this.method = "TIME";
                break;
            case "shortest":
                this.method = "DISTANCE";
                break;
            default:
                this.logger.warn("Par defaut, on prend l'itinéraire le plus rapide !");
                this.method = "TIME";
        }
    }

    /** Format de sortie (résumé de l’itinéraire) */
    this.format = (this.options.geometryInInstructions) ? "STANDARDEXT" : "STANDARD";

    // y'a t-il d'autres options à ajouter (par defaut) ?

    /** Distance de tolérance (en mètre) de simplification de la géométrie. */
    this.tolerance = 10;

    /** identifiant du véhicule (enregistré dans les profils de véhicule) à utiliser */
    this.profileId = null;

    /** Profil du véhicule (enregistré dans les profils de véhicule) à utiliser */
    this.profileName = null;

    // options dont le mapping n'est pas possible :
    // - distanceUnit
    // - provideBoundingBox
}

/**
 * CLASSNAME
 */
RouteParamREST.CLASSNAME = "RouteParamREST";

RouteParamREST.prototype = {

    /**
     * @lends module:RouteParamREST#
     */

    /**
     * Constructeur (alias)
     */
    constructor : RouteParamREST,

    /**
     * Retourne une liste de points
     * @returns {Array} une liste de points (sep ';')
     */
    getWaypoints : function () {
        if (!this.waypoints) {
            return;
        }
        var array = [];
        for (var i = 0; i < this.waypoints.length; i++) {
            var obj = this.waypoints[i];
            array.push(obj.x + "," + obj.y);
        }

        return array.join(";");
    },

    /**
     * Retourne la liste des exclusions
     * @returns {Array} une liste d'exclusions (sep ';')
     */
    getExclusions : function () {
        return this.exclusions.join(";");
    }
};

/**
 * Tableau de clefs/valeurs pour param.
 *
 * @returns {Array} liste de paramêtres
 */
RouteParamREST.prototype.getParams = function () {
    var map = [];

    map.push({
        k : "origin",
        v : this.origin
    });

    map.push({
        k : "destination",
        v : this.destination
    });

    map.push({
        k : "method",
        v : this.method
    });

    if (this.waypoints) {
        map.push({
            k : "waypoints",
            v : this.getWaypoints()
        });
    }

    if (this.startDateTime) {
        map.push({
            k : "startDateTime",
            v : this.startDateTime
        });
    }

    if (this.graphName) {
        map.push({
            k : "graphName",
            v : this.graphName
        });
    }

    if (this.exclusions) {
        map.push({
            k : "exclusions",
            v : this.getExclusions()
        });
    }

    if (this.srs) {
        map.push({
            k : "srs",
            v : this.srs
        });
    }

    if (this.format) {
        map.push({
            k : "format",
            v : this.format
        });
    }

    return map;
};

/* harmony default export */ __webpack_exports__["default"] = (RouteParamREST);


/***/ }),
/* 128 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44);
/* harmony import */ var _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45);
/* harmony import */ var _Formats_XML__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(66);
/* harmony import */ var _Formats_WKT__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(129);
/* harmony import */ var _Formats_RouteResponseRESTReader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(130);
/* harmony import */ var _Formats_RouteResponseOLSReader__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(133);
/* harmony import */ var _model_RouteResponse__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(131);
/* harmony import */ var _model_RouteInstruction__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(132);
/**
 * Factory pour générer une reponse JSON à partir d'un XML ou d'un JSON
 * (Factory)
 *
 * @module RouteResponseFactory
 * @alias Gp.Services.Route.Response.RouteResponseFactory
 * @private
 */










var RouteResponseFactory = {

    /**
     * interface unique
     *
     * @method build
     * @static
     * @param {Object} options - options definies dans le composant Alti
     *
     * @example
     *   var options = {
     *      response :
     *      outputFormat :
     *      rawResponse :
     *      scope :
     *      onSuccess :
     *      onError :
     *   };
     *
     */
    build : function (options) {
        // logger
        var logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("RouteResponseFactory");
        logger.trace("RouteResponseFactory::build()");

        var data = null;

        if (options.response) {
            if (options.rawResponse) {
                logger.trace("analyze response : raw");
                data = options.response;
            } else {
                switch (options.outputFormat) {
                    case "xml":
                        logger.trace("analyze response : xml");

                        // type de reader en fonction de l'API
                        var routeReader = options.api === "REST" ? _Formats_RouteResponseRESTReader__WEBPACK_IMPORTED_MODULE_5__["default"] : _Formats_RouteResponseOLSReader__WEBPACK_IMPORTED_MODULE_6__["default"];

                        try {
                            var p = new _Formats_XML__WEBPACK_IMPORTED_MODULE_3__["default"]({
                                reader : routeReader
                            });

                            // FIXME : mode XHR ne retourne que des string ? JSONP aussi à ce niveau ?
                            if (typeof options.response === "string") {
                                p.setXMLString(options.response);
                            } else {
                                p.setXMLDoc(options.response);
                            }

                            data = p.parse();

                            if (!data) {
                                throw new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_FORMAT", "xml"));
                            }
                        } catch (e) {
                            options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_ANALYSE", options.response)));
                            return;
                        }

                        break;

                    case "json":
                        logger.trace("analyze response : json");

                        var JSONResponse;
                        if (typeof options.response === "string") {
                            JSONResponse = JSON.parse(options.response);
                        } else {
                            JSONResponse = options.response;
                        }

                        // le service renvoie t il une erreur ?
                        if (JSONResponse.message) {
                            // ex. {"message":"message not null", "status":"ERROR"}
                            options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EXCEPTION", JSONResponse.message)));
                            return;
                        }

                        // construction de l'objet réponse JSON
                        if (JSONResponse) {
                            var legs = [];
                            var legSteps = [];
                            var steps = [];

                            data = new _model_RouteResponse__WEBPACK_IMPORTED_MODULE_7__["default"]();

                            if (data.hasOwnProperty("totalTime")) {
                                // info : il y a aussi JSONResponse.duration, qui donne la durée en hh:mm:ss.
                                data.totalTime = parseFloat(JSONResponse.durationSeconds);
                            }
                            if (data.hasOwnProperty("totalDistance")) {
                                data.totalDistance = (options.distanceUnit === "m") ? JSONResponse.distanceMeters : JSONResponse.distance;
                            }

                            if (data.hasOwnProperty("bbox")) {
                                var coords = JSONResponse.bounds.split(/[,;]/);
                                data.bbox.left = parseFloat(coords[0]);
                                data.bbox.bottom = parseFloat(coords[1]);
                                data.bbox.right = parseFloat(coords[2]);
                                data.bbox.top = parseFloat(coords[3]);
                            }
                            /**
                            * callback success
                            * @param {Object} json - json
                            * @private
                            */
                            var onWKTSuccess = function (json) {
                                data.routeGeometry = json;
                            };
                            /**
                            * callback failed
                            * @param {Object} e - event
                            * @private
                            */
                            var onWKTError = function (e) {
                                console.log(e);
                                options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_FORMAT", ["geometryWkt"])));
                            };

                            if (data.hasOwnProperty("routeGeometry")) {
                                var geometry = JSONResponse.geometryWkt || JSONResponse.simplifiedWkt;
                                if (geometry) {
                                    _Formats_WKT__WEBPACK_IMPORTED_MODULE_4__["default"].toJson(geometry, onWKTSuccess, onWKTError);
                                    if (!data.routeGeometry) {
                                        return;
                                    }
                                }
                            }

                            if (data.hasOwnProperty("routeInstructions")) {
                                var legList = JSONResponse.legs;
                                var i;
                                if (Array.isArray(legList) && legList.length) {
                                    for (i = 0; i < legList.length; i++) {
                                        legs.push(legList[i]);
                                    }
                                }
                                if (Array.isArray(legs) && legs.length) {
                                    for (i = 0; i < legs.length; i++) {
                                        legSteps.push(legs[i].steps);
                                    }
                                }
                                if (Array.isArray(legSteps) && legSteps.length) {
                                    for (i = 0; i < legSteps.length; i++) {
                                        steps = steps.concat(legSteps[i]);
                                    }
                                }

                                steps.forEach(function (step) {
                                    data.routeInstructions.push(new _model_RouteInstruction__WEBPACK_IMPORTED_MODULE_8__["default"]());
                                    data.routeInstructions[data.routeInstructions.length - 1].duration = step.durationSeconds;
                                    data.routeInstructions[data.routeInstructions.length - 1].distance = (options.distanceUnit === "m") ? step.distanceMeters : step.distance;
                                    data.routeInstructions[data.routeInstructions.length - 1].code = step.navInstruction;
                                    // geometrie en geojson
                                    var points = [];
                                    for (var i = 0; i < step.points.length; i++) {
                                        var point = step.points[i].split(",");
                                        if (point) {
                                            points.push(point);
                                        }
                                    }
                                    if (points && points.length !== 0) {
                                        data.routeInstructions[data.routeInstructions.length - 1].geometry = {
                                            coordinates : points,
                                            type : "LineString"
                                        };
                                    } else {
                                        data.routeInstructions[data.routeInstructions.length - 1].geometry = null;
                                    }

                                    /*
                                    Traduction du code en instruction
                                    * - F : tout droit
                                    * - B : demi-tour
                                    * - L : tourner à gauche
                                    * - R : tourner à droite
                                    * - BL : tourner très à gauche
                                    * - BR : tourner très à droite
                                    * - FL : tourner légèrement à gauche
                                    * - FR : tourner légèrement à droite
                                    * - round_about_entry : entrée rond-point
                                    * - round_about_exit : sortie rond-point
                                    */

                                    // on ne souhaite pas de ce type de valeur...
                                    if (step.name === "Valeur non renseignée") {
                                        step.name = "";
                                    }

                                    switch (step.navInstruction) {
                                        case "F":
                                            if (step.name) {
                                                data.routeInstructions[data.routeInstructions.length - 1].instruction = "Tout droit " + step.name;
                                            } else {
                                                data.routeInstructions[data.routeInstructions.length - 1].instruction = "Continuer tout droit ";
                                            }
                                            break;
                                        case "B":
                                            data.routeInstructions[data.routeInstructions.length - 1].instruction = "Demi-tour " + step.name;
                                            break;
                                        case "L":
                                            data.routeInstructions[data.routeInstructions.length - 1].instruction = "Tourner à gauche " + step.name;
                                            break;
                                        case "R":
                                            data.routeInstructions[data.routeInstructions.length - 1].instruction = "Tourner à droite " + step.name;
                                            break;
                                        case "BL":
                                            data.routeInstructions[data.routeInstructions.length - 1].instruction = "Tourner très à gauche " + step.name;
                                            break;
                                        case "BR":
                                            data.routeInstructions[data.routeInstructions.length - 1].instruction = "Tourner très à droite " + step.name;
                                            break;
                                        case "FL":
                                            data.routeInstructions[data.routeInstructions.length - 1].instruction = "Tourner légèrement à gauche " + step.name;
                                            break;
                                        case "FR":
                                            data.routeInstructions[data.routeInstructions.length - 1].instruction = "Tourner légèrement à droite " + step.name;
                                            break;
                                        case "round_about_entry":
                                            data.routeInstructions[data.routeInstructions.length - 1].instruction = "Entrée rond-point " + step.name;
                                            break;
                                        case "round_about_exit":
                                            data.routeInstructions[data.routeInstructions.length - 1].instruction = "Sortie rond-point " + step.name;
                                            break;
                                        case null:
                                            data.routeInstructions[data.routeInstructions.length - 1].instruction = "Prendre tout droit " + step.name;
                                            break;
                                        default:
                                            data.routeInstructions[data.routeInstructions.length - 1].instruction = "?" + step.navInstruction + "? " + step.name;
                                            break;
                                    }
                                });
                            }
                        }

                        if (!data) {
                            options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_ANALYSE", "json")));
                            return;
                        }
                        break;

                    default:
                        options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_FORMAT", "json", "xml")));
                        return;
                }

                // Si la réponse contenait une exception renvoyée par le service
                if (data && data.exceptionReport) {
                    options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EXCEPTION_2")));
                    return;
                }
            }
        } else {
            options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EMPTY")));
            return;
        }

        options.onSuccess.call(options.scope, data);
    }
};

/* harmony default export */ __webpack_exports__["default"] = (RouteResponseFactory);


/***/ }),
/* 129 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);


/**
 * Lecture / Ecriture du format WKT
 *
 * Les besoins sont assez simples :
 * 1. lecture des types suivants :
 *  - LINESTRING
 *  - POLYGON
 *  - (TODO)
 * 2. convertir aux formats suivants :
 *  - json
 *  - (TODO)
 *
 *
 * @example
 *  var strWKT = "LINESTRING (2.416907 48.846577, 2.416916 48.846613)";
 *  WKT.toJson (strWKT,
 *      function onSuccess (json) {
 *          // {
 *          //      type : 'LINESTRING',
 *          //      coordinates : [
 *          //          [2.416907, 48.846577],
 *          //          [2.416916, 48.846613]
 *          //      ]
 *          // }
 *      },
 *      function onError (error) {
 *          console.log(error);
 *      }
 *  );
 *
 * @module WKT
 * @alias Gp.Formats.WKT
 * @private
 */

var WKT = {

    /**
     * Parsing d'une chaine WKT
     *
     * @method toJson
     * @param {String} strWkt - chaine de type WKT
     * @param {Function} success - fonction callback
     * @param {Function} error   - fonction callback
     */
    toJson : function (strWkt, success, error) {
        var logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger();

        var json = null;

        try {
            if (!strWkt) {
                throw new Error("La chaine WKT n'est pas renseignée !");
            }

            if (!success) {
                // callback success par defaut
                success = function (json) {
                    console.log(json);
                };
            }

            if (!error) {
                // callback error par defaut
                error = function (e) {
                    console.log(e);
                };
            }

            var regex;
            var subst;

            // regex coordinates
            regex = /(-?\d+\.?[0-9]*)\s(-?\d+\.?[0-9]+)/g;
            subst = "[$1,$2]";
            strWkt = strWkt.replace(regex, subst);

            // regex type
            regex = /^(\w+)/;
            regex.exec(strWkt);
            if (RegExp.$1 === "POLYGON") {
                subst = "{\"type\" : \"Polygon\",";
                strWkt = strWkt.replace(RegExp.$1, subst);
                // clean
                // (( --> coordinates : [[
                regex = /(\({2}?)/;
                subst = "\"coordinates\" : [[";
                strWkt = strWkt.replace(regex, subst);
                // )) --> ]]}
                regex = /(\){2}?)/;
                subst = "]]}";
                strWkt = strWkt.replace(regex, subst);
                // all ( --> [
                regex = /(\()/g;
                subst = "[";
                strWkt = strWkt.replace(regex, subst);
                // all ) --> ]
                regex = /(\))/g;
                subst = "]";
                strWkt = strWkt.replace(regex, subst);
            } else if (RegExp.$1 === "LINESTRING") {
                subst = "{\"type\" : \"LineString\",";
                strWkt = strWkt.replace(RegExp.$1, subst);
                // clean
                regex = /(\(\(?)/;
                subst = "\"coordinates\" : [";
                strWkt = strWkt.replace(regex, subst);
                regex = /(\)\)?)/;
                subst = "]}";
                strWkt = strWkt.replace(regex, subst);
            }

            logger.trace(strWkt);

            json = JSON.parse(strWkt);

            if (!json) {
                throw new Error("Le JSON est vide !");
            }

            if (!json.type) {
                throw new Error("Le type de geometrie n'est pas connu !");
            }

            if (!json.coordinates) {
                throw new Error("La liste des points est vide !");
            }

            success.call(this, json);
        } catch (e) {
            if (e.name === "SyntaxError") {
                error.call(this, "Erreur de parsing JSON !");
                return;
            }
            error.call(this, e);
        }
    }
};

/* harmony default export */ __webpack_exports__["default"] = (WKT);


/***/ }),
/* 130 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44);
/* harmony import */ var _Formats_WKT__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(129);
/* harmony import */ var _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45);
/* harmony import */ var _Response_model_RouteResponse__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(131);
/* harmony import */ var _Response_model_RouteInstruction__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(132);
/**
 * Analyse de la reponse REST
 *
 * @module RouteResponseRESTReader
 * @alias Gp.Services.Route.Formats.RouteResponseRESTReader
 * @todo not yet implemented !
 * @private
 */

// import Logger from "../../../Utils/LoggerByDefault";






/**
 * Objet RouteResponseRestReader
 * @member {Object} RouteResponseRestReader
 *
 * @property {Object} RouteResponseRestReader.READERS - Objet contenant des fonctions de lecture, appelées "readers"
 *      dont chaque clé correspond au nom d'un tag du XML que l'on souhaite lire
 *      et la valeur associée est une fonction (node, data)
 *      où node est un noeud du document DOM
 *      et data est un objet où l'on stocke les informations lues dans le XML.
 *
 * @property {Method} RouteResponseRestReader.read - Méthode permettant de lancer la lecture d'une réponse XML du
 *      service de calcul d'itineraire, à l'aide des readers de la classe.
 *
 */

var RouteResponseRESTReader = {};

RouteResponseRESTReader.READERS = {

    /**
     * Route response
     * @param {Object} node - node
     * @returns {Object} response
     */
    routeResult : function (node) {
        var response = new _Response_model_RouteResponse__WEBPACK_IMPORTED_MODULE_3__["default"]();

        // on boucle sur les balises "enfant" de la réponse :
        // status, distance, duration, distanceMeters, durationSeconds, bounds, geometryWkt, simplifiedWkt, leg
        __getChildNodes(node, response);

        if (response.status === "error") {
            var message = _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_0__["default"].getMessage("SERVICE_RESPONSE_EXCEPTION",
                response.message);
            throw new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"]({
                message : message,
                type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"].TYPE_SRVERR
            });
        }

        return response;
    },

    /**
     * Route status
     * @param {Object} node - node
     * @param {Object} response - response
     */
    status : function (node, response) {
        var status = __getChildValue(node);
        if (status === "ERROR" || status === "error") {
            if (response) {
                response.status = "error";
            }
        }
    },

    /**
     * Route message
     * @param {Object} node - node
     * @param {Object} response - response
     */
    message : function (node, response) {
        if (response) {
            response.message = __getChildValue(node);
        }
    },

    /**
     * Route distance
     * @param {Object} node - node
     * @param {Object} response - response
     */
    distance : function (node, response) {
        if (response) {
            response.totalDistance = __getChildValue(node);
        }
    },

    /**
     * Route duration
     * @param {Object} node - node
     * @param {Object} response - response
     */
    durationSeconds : function (node, response) {
        if (response) {
            response.totalTime = parseFloat(__getChildValue(node));
        }
    },

    /**
     * Route bounds
     * @param {Object} node - node
     * @param {Object} response - response
     */
    bounds : function (node, response) {
        // get value et split et parseFloat
        if (response && response.bbox) {
            var coords = __getChildValue(node).split(/[,;]/);
            response.bbox.left = parseFloat(coords[0]);
            response.bbox.bottom = parseFloat(coords[1]);
            response.bbox.right = parseFloat(coords[2]);
            response.bbox.top = parseFloat(coords[3]);
        }
    },

    /**
     * Route geometry
     * @param {Object} node - node
     * @param {Object} response - response
     */
    geometryWkt : function (node, response) {
        if (response) {
            var geomWkt = node.innerHTML;

            var onWKTSuccess = function (json) {
                response.routeGeometry = json;
            };

            var onWKTError = function () {
                var msg = _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_0__["default"].getMessage("PARAM_FORMAT", ["geometryWkt"]);
                throw new Error(msg);
            };
            // get WKT Geometry from string
            _Formats_WKT__WEBPACK_IMPORTED_MODULE_1__["default"].toJson(geomWkt, onWKTSuccess, onWKTError);
        }
    },

    /**
     * Route step
     * @param {Object} node - node
     * @param {Object} response - response
     */
    step : function (node, response) {
        // création d'une nouvelle instruction
        var routeInstruction = new _Response_model_RouteInstruction__WEBPACK_IMPORTED_MODULE_4__["default"]();
        var name;

        // lecture des informations de l'instruction (balises enfants)
        if (node.hasChildNodes) {
            var children = node.childNodes;
            var child;
            var childName;

            for (var i = 0; i < children.length; i++) {
                child = children[i];

                if (child.nodeType === 1) { // 1 === node.ELEMENT_NODE
                    childName = child.localName || child.baseName || child.nodeName;

                    if (childName === "durationSeconds") {
                        routeInstruction.duration = __getChildValue(child);
                    } else if (childName === "distance") {
                        routeInstruction.distance = __getChildValue(child);
                    } else if (childName === "navInstruction") {
                        routeInstruction.code = __getChildValue(child);
                    } else if (childName === "name") {
                        name = __getChildValue(child);
                    }
                }
            }
        }

        // on teste le code de l'instruction pour y ajouter la bonne description
        if (routeInstruction.code) {
            switch (routeInstruction.code) {
                case "F":
                    if (name !== "Valeur non renseignée") {
                        routeInstruction.instruction = "Tout droit " + name;
                    } else {
                        routeInstruction.instruction = "Continuer tout droit ";
                    }
                    break;
                case "B":
                    routeInstruction.instruction = "Demi-tour " + name;
                    break;
                case "L":
                    routeInstruction.instruction = "Tourner à gauche " + name;
                    break;
                case "R":
                    routeInstruction.instruction = "Tourner à droite " + name;
                    break;
                case "BL":
                    routeInstruction.instruction = "Tourner très à gauche " + name;
                    break;
                case "BR":
                    routeInstruction.instruction = "Tourner très à droite " + name;
                    break;
                case "FL":
                    routeInstruction.instruction = "Tourner légèrement à gauche " + name;
                    break;
                case "FR":
                    routeInstruction.instruction = "Tourner légèrement à droite " + name;
                    break;
                case "round_about_entry":
                    routeInstruction.instruction = "Entrée rond-point " + name;
                    break;
                case "round_about_exit":
                    routeInstruction.instruction = "Sortie rond-point " + name;
                    break;
                case null:
                    routeInstruction.instruction = "Prendre " + name;
                    break;
                default:
                    routeInstruction.instruction = "?" + routeInstruction.code + "? " + name;
                    break;
            }
        }

        if (Array.isArray(response.routeInstructions)) {
            response.routeInstructions.push(routeInstruction);
        }
    }

};

/**
 * Méthode permettant de lancer la lecture d'une réponse XML du service de calcul d'itineraire,
 * à l'aide des readers de la classe.
 *
 * @method RouteResponseRESTReader.read
 * @param {DOMElement} root - racine de la réponse XML à lire
 * @static
 * @memberof RouteResponseRESTReader
 * @returns {DOMElement} response
 */
RouteResponseRESTReader.read = function (root) {
    var response;

    if (root.nodeName === "routeResult") {
        response = RouteResponseRESTReader.READERS["routeResult"](root);
        return response;
    } else {
        throw new Error("Erreur lors de la lecture de la réponse : elle n'est pas au format attendu.");
    }
};

/**
 * Lecture de la valeur du premier child d'un noeud, si elle existe.
 *
 * @private
 * @memberof RouteResponseRESTReader
 * @method __getChildValue
 * @param {DOMElement} node - a DOM node
 * @return {String} value - valeur du firstChild du noeud en entrée, ou chaîne vide.
 */
function __getChildValue (node) {
    var textNode;
    var value = "";

    if (node.hasChildNodes()) {
        textNode = node.firstChild;
        if (textNode && textNode.nodeType === 3) { // 3 === node.TEXT_NODE
            value = textNode.nodeValue;
        }
    }
    return value;
}

/**
 * Récupération des noeuds enfants à partir d'un noeud donné, pour lecture (readNode).
 *
 * @private
 * @memberof RouteResponseRESTReader
 * @method __getChildNodes
 * @param {DOMElement} node - a DOM node
 * @param {Array|Object} [data] - an object to be filled with node data
 */
function __getChildNodes (node, data) {
    if (node.hasChildNodes()) {
        var children = node.childNodes;
        var child;
        var childName;

        for (var i = 0; i < children.length; i++) {
            child = children[i];

            if (child.nodeType === 1) { // 1 === node.ELEMENT_NODE
                childName = child.localName || child.baseName || child.nodeName;

                if (RouteResponseRESTReader.READERS[childName]) {
                    var reader = RouteResponseRESTReader.READERS[childName];
                    reader(child, data);
                } else {
                    __getChildNodes(child, data);
                }
            }
        }
    }
}

/* harmony default export */ __webpack_exports__["default"] = (RouteResponseRESTReader);


/***/ }),
/* 131 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/**
 * Response object for {@link module:Services~route Gp.Services.route ()} invocation when successful. Received as the argument of onSuccess callback function.
 *
 * @property {Gp.BBox} bbox - Bounding Box of the route. Given when provideBBox parameter is used in function call.
 * @property {Object} routeGeometry - Geometry (expressed in [GeoJSON]{@link http://geojson.org/}) of the route.
 * @property {Array.<Gp.Services.Route.RouteInstruction>} routeInstructions - Instructions of the route.
 * @property {String} totalDistance - Length of the route. If distanceUnit parameter was set to "km" (default), totalDistance is a string containing the total distance expressed in kilometers, followed by " Km" (e.g. : "19.6 Km"). If distanceUnit parameter was set to "m", totalDistance is a string containing the total distance expressed in meters (e.g. : "19599.14").
 * @property {Float} totalTime - Route duration in seconds.
 *
 * @namespace
 * @alias Gp.Services.RouteResponse
 */
function RouteResponse () {
    if (!(this instanceof RouteResponse)) {
        throw new TypeError("RouteResponse constructor cannot be called as a function.");
    }

    this.totalTime = null;

    this.totalDistance = null;

    this.bbox = {
        left : null,
        right : null,
        top : null,
        bottom : null
    };

    this.routeGeometry = null; // FIXME can be null if option 'geometryInInstructions' is true !

    this.routeInstructions = [];
}

RouteResponse.prototype = {

    constructor : RouteResponse

};

/* harmony default export */ __webpack_exports__["default"] = (RouteResponse);


/***/ }),
/* 132 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

/**
 * Single Route Instruction object.
 *
 * @property {String} code - Instruction code :
 *
 * - "F" : Straight forward
 * - "B" : U-turn
 * - "L" : turn left
 * - "R" : turn right
 * - "BL" : turn left strongly
 * - "BR" : turn right strongly
 * - "FL" : turn lightly to the left
 * - "FR" : turn lightly to the right
 * - "round_about_entry" : round about entry
 * - "round_about_exit" : round about exit
 *
 * @property {String} instruction - Instruction text : translated code + street name
 * @property {Object} geometry - Geometry (expressed in [GeoJSON]{@link http://geojson.org/}) of the street.
 * @property {Float} distance - Length of the instruction. Expressed in km or m, depending on distanceUnit parameter.
 * @property {Float} duration - Instruction duration in seconds.
 *
 * @namespace
 * @alias Gp.Services.Route.RouteInstruction
 */
function RouteInstruction () {
    if (!(this instanceof RouteInstruction)) {
        throw new TypeError("RouteInstruction constructor cannot be called as a function.");
    }

    this.duration = null;

    this.distance = null;

    this.code = null;

    this.instruction = null;

    this.geometry = null; // FIXME can be null if option 'geometryInInstructions' is false !
}

RouteInstruction.prototype = {

    constructor : RouteInstruction

};

/* harmony default export */ __webpack_exports__["default"] = (RouteInstruction);


/***/ }),
/* 133 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/**
 * Analyse de la reponse OLS
 *
 * @module RouteResponseOLSReader
 * @alias Gp.Services.Route.Formats.RouteResponseOLSReader
 * @todo not yet implemented !
 * @private
 */



/**
 * Objet RouteResponseOLSReader
 * @member {Object} RouteResponseOLSReader
 *
 * @property {Object} RouteResponseOLSReader.READERS - Objet contenant des fonctions de lecture, appelées "readers"
 *      dont chaque clé correspond au nom d'un tag du XML que l'on souhaite lire
 *      et la valeur associée est une fonction (node, data)
 *      où node est un noeud du document DOM
 *      et data est un objet où l'on stocke les informations lues dans le XML.
 *
 * @property {Method} RouteResponseOLSReader.read -  Méthode permettant de lancer la lecture d'une réponse
 *      XML du service de calcul d'itineraire, à l'aide des readers de la classe.
 */
var RouteResponseOLSReader = {};

/**
 * Objet contenant des fonctions de lecture, appelées "readers"
 *      dont chaque clé correspond au nom d'un tag du XML que l'on souhaite lire
 *      et la valeur associée est une fonction (node, data)
 *      où node est un noeud du document DOM
 *      et data est un objet où l'on stocke les informations lues dans le XML.
 * @static
 * @memberof RouteResponseOLSReader
 */
RouteResponseOLSReader.READERS = {
    /*
        // INFO
        // pas de reponse en JSON pour l'API OLS, uniquement du XML !

        // INFO
        // Exemple d'erreur du service
        // <?xml version= "1.0" encoding= "UTF-8" standalone= "yes" ?>
        // <XLS version="1.2" xsi : schemaLocation = "http://www.opengis.net/xls http://schemas.opengis.net/ols/1.2/olsAll.xsd" xmlns : xls = "http://www.opengis.net/xls" xmlns= "http://www.opengis.net/xls" xmlns : xlsext = "http://www.opengis.net/xlsext" xmlns : gml = "http://www.opengis.net/gml" // xmlns : xsi = "http://www.w3.org/2001/XMLSchema-instance" >
        // <ResponseHeader>
        //     <ErrorList>
        //         <Error message="Routing error : Error in smartrouting com.geoconcept.smartrouting.SmartRoutingNativeException : failed to connect waypoint { 48.846577, 2.416907, 0.000000 } failed to connect waypoint { 48.846577, 2.416907, 0.000000 } " errorCode="InternalServerError"/>
        //     </ErrorList>
        // </ResponseHeader>
        // <Response version= "1.2" requestID= "f8358c74-8aee-4203-90b9-2c70db5996a1" />
        // </XLS>

        // INFO
        // Exemple d'erreur NGinx
        // <ExceptionReport><Exception exceptionCode="MissingParameter">Resource parameter not found</Exception></ExceptionReport>
    */
};

/**
 * Méthode permettant de lancer la lecture d'une réponse XML du service de calcul d'itineraire,
 * à l'aide des readers de la classe.
 *
 * @method RouteResponseOLSReader.read
 * @param {DOMElement} root - racine de la réponse XML à lire
 * @static
 * @memberof RouteResponseOLSReader
 */
RouteResponseOLSReader.read = function (root) {
    // logger
    var logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("RouteResponseOLSReader");
    logger.error("not yet implemented !");
};

/* harmony default export */ __webpack_exports__["default"] = (RouteResponseOLSReader);


/***/ }),
/* 134 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44);
/* harmony import */ var _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45);
/* harmony import */ var _CommonService__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46);
/* harmony import */ var _DefaultUrlService__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(56);
/* harmony import */ var _Request_ProcessIsoCurveRequest__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(135);
/* harmony import */ var _Response_ProcessIsoCurveResponseFactory__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(137);









/**
 * @classdesc
 * Appel du service d'isochrone/distance du Géoportail :
 *     envoi de la requête construite selon les paramètres en options,
 *     éventuellement parsing et analyse  de la réponse,
 *     retour d'une réponse en paramètre de la fonction onSuccess.
 * @constructor
 * @extends {Gp.Services.CommonService}
 * @alias Gp.Services.ProcessIsoCurve
 * @param {Object} options - options spécifiques au service (+ les options heritées)
 *
 * @param {String} options.outputFormat - Le format de la réponse du service iso : 'xml' ou 'json'.
 *      Ce paramètre déterminera l'extension '.xml' ou '.json' du service.
 *      Nécessaire si serverUrl est renseigné pour connaître le format dans lequel sera fournie la réponse (pour son traitement).
 *      Par défaut, ce paramètre vaut 'json'.
 *
 * @param {Object} options.position - Point de départ du calcul.
 *      Coordonnées exprimées en longitudes, latitudes (EPSG:4326)
 *      @param {Float} options.position.x - Abcisse du point de départ du calcul d'isochrone/distance.
 *      @param {Float} options.position.y - Ordonnée du point de départ du calcul d'isochrone/distance.
 *
 * @param {String} options.srs - Projection.
 *      Système de coordonnées dans lequel les coordonnées du point « location » sont exprimées et
 *      dans lequel la géométrie de la courbe résultante sera exprimée.
 *      Par défaut, le système de coordonnées utilisé sera « EPSG:4326 ».
 *
 * @param {String} [options.graph = "voiture"] - Nom du graphe à utiliser pour le calcul (« Pieton » ou « Voiture »).
 *      La valeur par défaut est : «voiture»
 *
 * @param {Array.<String>} [options.exclusions] - Critères d'exclusions à appliquer pour le calcul.
 *      On précise ici le type de tronçons que l'on ne veut pas que l'isochrone/distance emprunte
 *      (valeurs possibles : « toll » (éviter les péages), « bridge », « tunnel »).
 *
 * @param {String} [options.method = "time"] - Méthode utilisée pour le calcul de la courbe iso.
 *      Les valeurs possible sont "time" pour un calcul d'isochrone, "distance" pour un calcul d'isodistance.
 *      Pas de valeur spécifié équivaut à un calcul d'isochrone.
 *
 * @param {Float} options.time - Durée maximum (exprimée en secondes) à utiliser pour le calcul de la courbe à partir du ou jusqu'au point « location ».
 *      Ce paramètre doit être renseigné si l'option "méthod" a la valeur "time".
 *      Si l'option method n'est pas renseignée, ce paramètre doit être renseigné.
 *
 * @param {Float} options.distance - Distance maximum (exprimée en metres) à utiliser pour le calcul de la courbe à partir du ou j'usqu'au point « location ».
 *      Ce paramètre doit être renseigné si l'option "méthod" a la valeur "DISTANCE".
 *      Si l'option "method" n'est pas renseignée, ce paramètre sera ignoré.
 *
 * @param {Boolean} [options.reverse = false] - Indique si la géométrie résultante doit être lissée (« true ») pour ne pas avoir d'effet d'escalier.
 *      Par défaut, la valeur « false » est appliquée.
 *
 * @param {Boolean} [options.smoothing = false] - Indique si la géométrie résultante doit être lissée (« true ») pour ne pas avoir d'effet d'escalier.
 *      Par défaut, la valeur « false » est appliquée.
 *
 * @param {Boolean} [options.holes = false] - Indique si la géométrie résultante (surface) doit être retournée avec des trous (« true »).
 *      Par défaut, la valeur « false » est appliquée.
 *
 * @example
 *   var options = {
 *      // options communes aux services
 *      apiKey : null,
 *      serverUrl : 'http://localhost/service/',
 *      protocol : 'JSONP', // JSONP|XHR
 *      proxyURL : null,
 *      httpMethod : 'GET', // GET|POST
 *      timeOut : 10000, // ms
 *      rawResponse : false, // true|false
 *      scope : null, // this
 *      onSuccess : function (response) {},
 *      onFailure : function (error) {},
 *      // spécifique au service
 *      position : {
 *           x : 2.3242664298058053,
 *           y : 48.86118017324745
 *      },
 *      distance : 200,
 *      [time : ]
 *      method : "distance",
 *      exclusions : ["Bridge", "Tunnel", "Toll"],
 *      graph : "voiture",
 *      reverse : false,
 *      smoothing : false,
 *      holes : false
 *  };
 * @private
 */

function ProcessIsoCurve (options) {
    if (!(this instanceof ProcessIsoCurve)) {
        throw new TypeError(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("CLASS_CONSTRUCTOR", "ProcessIsoCurve"));
    }

    /**
     * Nom de la classe (heritage)
     * FIXME instance ou classe ?
     */
    this.CLASSNAME = "ProcessIsoCurve";

    // appel du constructeur par heritage
    _CommonService__WEBPACK_IMPORTED_MODULE_3__["default"].apply(this, arguments);

    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("Gp.Services.ProcessIsoCurve");
    this.logger.trace("[Constructeur ProcessIsoCurve (options)]");

    if (!options.position) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_MISSING", "position"));
    }

    // on lance une exception afin d'eviter au service de le faire...
    if (options.position.x === null) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_MISSING", "position.x"));
    }

    if (options.position.y === null) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_MISSING", "position.y"));
    }

    if (!options.time && !options.distance) {
        throw new Error("Parameter (s) 'distance' missing. Parameter time to calculate an isochrone, parameter distance for an isodistance");
    }

    // si on a que le paramètre "distance" en entrée, on calcule une isodistance.
    // Le paramètre "méthode" doit pour avoir une réponse du service, être passé à "distance"
    if (!options.time && options.distance) {
        this.options.method = "distance";
        // on supprime l'éventuel attribut time, résidu d'un appel antérieur
        if (this.options.time) {
            delete this.options.time;
        }
    }

    // si on a que le paramètre "time" en entrée, on calcule une isochrone.
    // Le paramètre "méthode" doit pour avoir une réponse du service, être passé à "time"
    if (options.time && !options.distance) {
        this.options.method = "time";
        // on supprime l'éventuel attribut time, résidu d'un appel antérieur
        if (this.options.distance) {
            delete this.options.distance;
        }
    }

    // au cas où on a ni l'un, ni l'autre...
    this.options.method = this.options.method || "time";

    // options par defaut du service
    this.options.exclusions = options.exclusions || null;
    this.options.graph = options.graph || "Voiture"; // TODO test de la valeur à faire !
    this.options.reverse = options.reverse || false;
    this.options.smoothing = options.smoothing || false;
    this.options.holes = options.holes || false;
    this.options.srs = options.srs || "EPSG:4326";

    // on passe l'option outputFormat en minuscules afin d'éviter des exceptions.
    this.options.outputFormat = (typeof options.outputFormat === "string") ? options.outputFormat.toLowerCase() : "json";

    // gestion de l'url du service par defaut
    // si l'url n'est pas renseignée, il faut utiliser les urls par defaut
    if (!this.options.serverUrl) {
        var lstUrlByDefault = _DefaultUrlService__WEBPACK_IMPORTED_MODULE_4__["default"].ProcessIsoCurve.url(this.options.apiKey);

        var urlFound = lstUrlByDefault["iso" + "-" + this.options.outputFormat];
        if (!urlFound) {
            throw new Error("Url by default not found !");
        }
        this.options.serverUrl = urlFound;
        this.logger.trace("Serveur URL par defaut : " + this.options.serverUrl);
    }

    // gestion du type de service
    // si l'extension de l'url est .json ou .xml, on surcharge le format de sortie (outputFormat)
    var idx = this.options.serverUrl.lastIndexOf(".");
    if (idx !== -1) {
        var extension = this.options.serverUrl.substring(idx + 1);
        if (extension && extension.length < 5) { // FIXME extension de moins de 4 car. ...
            this.logger.trace("Serveur Extension URL : " + extension);
            switch (extension.toLowerCase()) {
                case "json":
                case "xml":
                    this.options.outputFormat = extension.toLowerCase();
                    break;
                default:
                    throw new Error("type of service : unknown or unsupported (json or xml) !");
            }
        }
    }
}

/**
 * @lends module:ProcessIsoCurve#
 */
ProcessIsoCurve.prototype = Object.create(_CommonService__WEBPACK_IMPORTED_MODULE_3__["default"].prototype, {
    // todo
    // getter/setter
});

/*
 * Constructeur (alias)
 */
ProcessIsoCurve.prototype.constructor = ProcessIsoCurve;

/**
 * Création de la requête (overwrite)
 *
 * @param {Function} error   - callback des erreurs
 * @param {Function} success - callback
 */
ProcessIsoCurve.prototype.buildRequest = function (error, success) {
    try {
        var oIsoCurve = new _Request_ProcessIsoCurveRequest__WEBPACK_IMPORTED_MODULE_5__["default"](this.options);
        if (!oIsoCurve.processRequestString()) {
            throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_REQUEST_BUILD"));
        }

        this.request = oIsoCurve.requestString;
    } catch (e) {
        error.call(this, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](e.message));
        return;
    }

    success.call(this, this.request);
};

/**
 * (overwrite)
 * Analyse de la reponse
 *
 * @param {Function} onError   - callback des erreurs
 * @param {Function} onSuccess - callback de succès de l'analyse de la réponse
 */
ProcessIsoCurve.prototype.analyzeResponse = function (onError, onSuccess) {
    if (this.response) {
        var options = {
            response : this.response,
            outputFormat : this.options.outputFormat,
            rawResponse : this.options.rawResponse,
            onSuccess : onSuccess,
            onError : onError,
            scope : this
        };

        _Response_ProcessIsoCurveResponseFactory__WEBPACK_IMPORTED_MODULE_6__["default"].build(options);
    } else {
        onError.call(this, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EMPTY")));
    }
};

/* harmony default export */ __webpack_exports__["default"] = (ProcessIsoCurve);


/***/ }),
/* 135 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44);
/* harmony import */ var _model_ProcessIsoCurveParam__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(136);





/**
 * @classdesc
 * Classe de gestion des requêtes sur le service de calcul d'isoschrone/isodistance.
 *  Les requêtes peuvent être en mode GET ou POST,
 *  et le format de sorti est en JSON ou en XML.
 *
 * @constructor
 * @alias Gp.Services.ProcessIsoCurve.Request.ProcessIsoCurveRequest
 * @param {Object} options - options
 *
 * @example
 * var options = {
 *      httpMethod : 'GET', // GET|POST
 *      // spécifique au service
 *      exclusions : ['Bridge', 'Tunnel'],
 *      position : {
 *          x : 2.3242664298058053,
 *          y : 48.86118017324745
 *      },
 *      graph : "Voiture",
 *      method : 'time',
 *      time : 1000, //distance : 200
 *      reverse : false,
 *      smoothing : false,
 *      holes : false,
 *      srs : 'EPSG:4326'
 *  };
 *
 * try {
 *
 *      var oIsoCurve = new ProcessIsoCurveRequest (options);
 *      if (!oIsoCurve.processRequestString ()) {
 *          // error
 *      }
 *
 *      var request = oIsoCurve.requestString;
 *
 * } catch (e) {
 *      // error
 * }
 * @private
 */
function ProcessIsoCurveRequest (options) {
    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("ProcessIsoCurveRequest");
    this.logger.trace("[Constructeur ProcessIsoCurveRequest ()]");

    if (!(this instanceof ProcessIsoCurveRequest)) {
        throw new TypeError("ProcessIsoCurveRequest constructor cannot be called as a function.");
    }

    // existance des options
    if (!options) {
        throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_EMPTY", "options"));
    }

    /**
     * Liste des options
     */
    this.settings = options;

    /**
     * Mode HTPP.
     * Par defaut, "GET".
     * @type {String}
     */
    this.mode = this.settings.httpMethod || "GET";
}

ProcessIsoCurveRequest.prototype = {

    /**
     * @lends module:ProcessIsoCurveRequest#
     */

    /**
     * Requête
     * @type {String}
     */
    requestString : null,

    /**
     * Constructeur (alias)
     */
    constructor : ProcessIsoCurveRequest,

    /**
     * Template de la requête (POST)
     * * __X__ __Y__ __SRS__ __GRAPHNAME__ __METHOD__  (obligatoire)
     * * __REVERSE__ __SMOOTHING__ __HOLES__           (par defaut)
     * * __TIME__ __TIMEVALUE__                        (choix)
     * * __DISTANCE__ __DISTANCEVALUE__                (choix)
     * * __EXCLUSIONS__ __EXCLUSIONFEATURE__ __EXCLUSIONVALUE__ (optionnel)
     * * __PROFIL__ __PROFILID__ __PROFILNAME__                 (très optionnel)
     * * __ID__ __IDVALUE__                                     (très optionnel)
     */
    template : {
        container : "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
            "<isochroneRequest>\n" +
            "__ID__" +
            "\t<location>\n" +
            "\t\t<x>__X__</x>\n" +
            "\t\t<y>__Y__</y>\n" +
            "\t</location>\n" +
            "\t<srs>__SRS__</srs>\n" +
            "\t<graphName>__GRAPHNAME__</graphName>\n" +
            "__PROFIL__" +
            "__EXCLUSIONS__" +
            "\t<method>__METHOD__</method>\n" +
            "__TIME__" +
            "__DISTANCE__" +
            "\t<reverse>__REVERSE__</reverse>\n" +
            "\t<smoothing>__SMOOTHING__</smoothing>\n" +
            "\t<holes>__HOLES__</holes>\n" +
            "</isochroneRequest>",
        id : "\t<id>__IDVALUE__</id>\n",
        profil : "\t<profileId>__PROFILID__</profileId>\n" + "\t<profileName>__PROFILNAME__</profileName>\n",
        exclusions : {
            container : "\t<exclusions>\n" +
                "__EXCLUSIONFEATURE__\n" +
                "\t</exclusions>\n",
            feature : "\t\t<exclusion>__EXCLUSIONVALUE__</exclusion>"
        },
        time : "\t<time>__TIMEVALUE__</time>\n",
        distance : "\t<distance>__DISTANCEVALUE__</distance>\n"
    },

    /**
     * Construction de la requête.
     *
     * @example
     * // GET  out :
     *   //  (http://wxs.ign.fr/KEY/isochrone/isochrone.json?)
     *   //  location=&
     *   //  time=& ou distance=&
     *   //  method="DISTANCE|TIME"&
     *   //  graph=Pieton&
     *   //  graphName=Pieton&
     *   //  exclusions=&
     *   //  reverse=10&
     *   //  smoothing=&
     *   //  holes=&
     *   //  srs=
     *
     * // POST out :
     *   // <?xml version="1.0" encoding="UTF-8"?>
     *   // <isochroneRequest>
     *   //   <id>1</id>
     *   //   <location>
     *   //     <x>-1.557189</x>
     *   //     <y>47.217122</y>
     *   //   </location>
     *   //   <srs></srs>
     *   //   <graphName></graphName>
     *   //   <profileId></profileId>
     *   //   <profileName></profileName>
     *   //   <exclusions>
     *   //     <exclusion></exclusion>
     *   //     <exclusion></exclusion>
     *   //   </exclusions>
     *   //   <method></method>
     *   //   <time>50</time>
     *   //   <distance></distance>
     *   //   <reverse></reverse>
     *   //   <smoothing></smoothing>
     *   //   <holes></holes>
     *   // </isochroneRequest>
     *
     * @returns {String} request
     */
    processRequestString : function () {
        var request = "";
        var i = 0;

        switch (this.mode) {
            case "GET":
                this.logger.trace("Process GET Request");

                // Mapping des options avec le service de l'API REST
                var oParams = new _model_ProcessIsoCurveParam__WEBPACK_IMPORTED_MODULE_2__["default"](this.settings);
                var params = oParams.getParams();

                for (i = 0; i < params.length; i++) {
                    var o = params[i];
                    if (request) {
                        request += "&";
                    }
                    request += o.k + "=" + o.v;
                }

                break;

            case "POST":
                this.logger.trace("Process POST Request");

                request = this.template.container;

                // options non prises en compte car non implémentées !
                // clean : id
                request = request.replace(/__ID__/g, "");
                // clean : profil
                request = request.replace(/__PROFIL__/g, "");

                // options obligatoires
                request = request.replace(/__X__/g, this.settings.position.x);
                request = request.replace(/__Y__/g, this.settings.position.y);
                request = request.replace(/__GRAPHNAME__/g, this.settings.graph);

                // options par defaut
                request = request.replace(/__SRS__/g, this.settings.srs);
                request = request.replace(/__SMOOTHING__/g, this.settings.smoothing);
                request = request.replace(/__HOLES__/g, this.settings.holes);
                request = request.replace(/__REVERSE__/g, this.settings.reverse);

                // options conditionnelles

                // exclusions
                if (this.settings.exclusions) {
                    var tmplExclusions = this.template.exclusions.container;
                    var exclusions = [];
                    for (i = 0; i < this.settings.exclusions.length; i++) {
                        var tmplFeature = this.template.exclusions.feature;
                        tmplFeature = tmplFeature.replace(/__EXCLUSIONVALUE__/, this.settings.exclusions[i]);
                        exclusions.push(tmplFeature);
                    }
                    tmplExclusions = tmplExclusions.replace(/__EXCLUSIONFEATURE__/, exclusions.join("\n"));
                    request = request.replace(/__EXCLUSIONS__/g, tmplExclusions);
                }
                // clean exclusions
                request = request.replace(/__EXCLUSIONS__/g, "");

                // distance
                if (this.settings.distance) {
                    var tmplDistance = this.template.distance;
                    tmplDistance = tmplDistance.replace(/__DISTANCEVALUE__/g, this.settings.distance);
                    request = request.replace(/__DISTANCE__/g, tmplDistance);
                    // method
                    request = request.replace(/__METHOD__/g, "distance");
                }
                // clean
                request = request.replace(/__DISTANCE__/g, "");

                // time
                if (this.settings.time) {
                    var tmplTime = this.template.time;
                    tmplTime = tmplTime.replace(/__TIMEVALUE__/g, this.settings.time);
                    request = request.replace(/__TIME__/g, tmplTime);
                    // method
                    request = request.replace(/__METHOD__/g, "time");
                }
                // clean
                request = request.replace(/__TIME__/g, "");
                break;

            default:
                this.logger.error("No other HTTP method supported by the service !");
        }

        this.logger.trace(request);
        this.requestString = request;

        return this.requestString;
    }
};

/* harmony default export */ __webpack_exports__["default"] = (ProcessIsoCurveRequest);


/***/ }),
/* 136 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);



/**
 * @classdesc
 *
 * Classe de gestion des param. des requêtes du service de calcul des iso.
 * Permet le mapping avec les options du service.
 *
 * @constructor
 * @alias Gp.Services.ProcessIsoCurve.Request.ProcessIsoCurveParam
 * @param {Object} options - options
 * @private
 *
 */
function ProcessIsoCurveParam (options) {
    if (!(this instanceof ProcessIsoCurveParam)) {
        throw new TypeError("ProcessIsoCurveParam constructor cannot be called as a function.");
    }

    this.logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger();
    this.logger.trace("[Constructeur ProcessIsoCurveParam ()]");

    /**
     * Options en paramêtres du constructeur.
     */
    this.options = options || {};

    // mapping des options avec l'API REST

    /** Identifiant de l’isochrone */
    this.id = this.options.id;

    /** Coordonnées de départ (ou arrivée si le reverse est à true). */
    this.location = this.options.position;

    /** projection (code EPSG comme epsg:4326 ou wgs84) */
    this.srs = this.options.srs;

    /**
     * Profil de véhicule à utiliser pour le calcul.
     * Voiture ou Pieton
     */
    this.graphName = this.options.graph;

    /**
     * Identifiant et nom du véhicule
     * FIXME non utilisé
     */
    this.profileId = this.options.profileId || null; // TODO !
    this.profileName = this.options.profileName || null; // TODO !

    /** Liste des règles de restrictions à utiliser */
    this.exclusions = this.options.exclusions;

    this.reverse = this.options.reverse;
    this.smoothing = this.options.smoothing;
    this.holes = this.options.holes;

    /**
     * "time" pour isochrone ou "distance" for isodistance.
     * Par defaut, time...
     */
    var value = this.options.method;
    switch (value) {
        case "time":
            this.method = "time";
            this.time = this.options.time;
            break;
        case "distance":
            this.method = "distance";
            this.distance = this.options.distance;
            break;
        default:
            this.logger.warn("Par defaut, on calcule un isochrone !");
            this.method = "time";
    }
}

/**
 * CLASSNAME
 */
ProcessIsoCurveParam.CLASSNAME = "ProcessIsoCurveParam";

ProcessIsoCurveParam.prototype = {

    /**
     * @lends module:ProcessIsoCurveParam#
     */

    /**
     * Constructeur (alias)
     */
    constructor : ProcessIsoCurveParam,

    /**
     * Retourne la liste des exclusions
     * @returns {String} x,y
     */
    getLocation : function () {
        return this.location.x + "," + this.location.y;
    },

    /**
     * Retourne la liste des exclusions
     * @returns {String} exclusions
     */
    getExclusions : function () {
        return this.exclusions.join(";");
    }
};

/**
 * Tableau de clefs/valeurs pour param.
 *
 * @returns {Object[]} KVP
 */
ProcessIsoCurveParam.prototype.getParams = function () {
    var map = [];

    map.push({
        k : "location",
        v : this.getLocation()
    });

    map.push({
        k : "smoothing",
        v : this.smoothing
    });

    map.push({
        k : "holes",
        v : this.holes
    });

    map.push({
        k : "reverse",
        v : this.reverse
    });

    map.push({
        k : "method",
        v : this.method
    });

    if (this.time) {
        map.push({
            k : "time",
            v : this.time
        });
    }

    if (this.distance) {
        map.push({
            k : "distance",
            v : this.distance
        });
    }

    map.push({
        k : "graphName",
        v : this.graphName
    });

    if (this.exclusions) {
        map.push({
            k : "exclusions",
            v : this.getExclusions()
        });
    }

    if (this.srs) {
        map.push({
            k : "srs",
            v : this.srs
        });
    }

    return map;
};

/* harmony default export */ __webpack_exports__["default"] = (ProcessIsoCurveParam);


/***/ }),
/* 137 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44);
/* harmony import */ var _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45);
/* harmony import */ var _Formats_XML__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(66);
/* harmony import */ var _Formats_WKT__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(129);
/* harmony import */ var _Formats_ProcessIsoCurveResponseReader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(138);
/* harmony import */ var _model_ProcessIsoCurveResponse__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(139);
/**
 * Factory pour générer une reponse JSON à partir d'un XML ou d'un JSON
 * (Factory)
 *
 * @module ProcessIsoCurveResponseFactory
 * @alias Gp.Services.ProcessIsoCurve.Response.ProcessIsoCurveResponseFactory
 * @private
 */








var ProcessIsoCurveResponseFactory = {

    /**
     * interface unique
     *
     * @method build
     * @static
     * @param {Object} options - options definies dans le composant ProcessIsoCurve
     *
     * @example
     *   var options = {
     *      response :
     *      outputFormat :
     *      rawResponse :
     *      scope :
     *      onSuccess :
     *      onError :
     *   };
     *
     */
    build : function (options) {
        // logger
        var logger = _Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("ProcessIsoCurveResponseFactory");
        logger.trace(["ProcessIsoCurveResponseFactory::build()"]);

        var data = null;

        if (options.response) {
            if (options.rawResponse) {
                logger.trace("analyze response : raw");
                data = options.response;
            } else {
                switch (options.outputFormat) {
                    case "xml":
                        logger.trace("analyze response : xml");

                        try {
                            var p = new _Formats_XML__WEBPACK_IMPORTED_MODULE_3__["default"]({
                                reader : _Formats_ProcessIsoCurveResponseReader__WEBPACK_IMPORTED_MODULE_5__["default"]
                            });

                            // FIXME : mode XHR ne retourne que des string ? JSONP aussi à ce niveau ?
                            if (typeof options.response === "string") {
                                p.setXMLString(options.response);
                            } else {
                                p.setXMLDoc(options.response);
                            }

                            data = p.parse();

                            if (!data) {
                                throw new Error(_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EXCEPTION_2"));
                            }
                        } catch (e) {
                            var message = e.message;
                            message += "\n (raw response service : '" + options.response + "')";
                            options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"]({
                                message : _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EXCEPTION", message),
                                status : 200,
                                type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"].TYPE_SRVERR
                            }));
                            return;
                        }

                        break;

                    case "json":
                        logger.trace("analyze response : json");

                        var JSONResponse;
                        if (typeof options.response === "string") {
                            JSONResponse = JSON.parse(options.response);
                        } else {
                            JSONResponse = options.response;
                        }

                        // analyse de la reponse
                        if (JSONResponse.status === "OK" || JSONResponse.status === "ok") {
                            // création de l'objet de réponse
                            data = new _model_ProcessIsoCurveResponse__WEBPACK_IMPORTED_MODULE_6__["default"]();

                            // remplissage de l'objet créé avec les attribtuts de la réponse du service
                            if (data) {
                                data.time = JSONResponse.time;
                                data.distance = JSONResponse.distance;
                                data.message = JSONResponse.message;
                                data.id = JSONResponse.id;
                                data.srs = JSONResponse.srs;
                                // callback de la reponse
                                var onWKTSuccess = function (json) {
                                    data.geometry = json;
                                };
                                // callback d'erreur
                                var onWKTError = function () {
                                    options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"]({
                                        message : _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("PARAM_FORMAT", "wktGeometry")
                                    }));
                                };
                                if (data.hasOwnProperty("geometry")) {
                                    _Formats_WKT__WEBPACK_IMPORTED_MODULE_4__["default"].toJson(JSONResponse.wktGeometry, onWKTSuccess, onWKTError);
                                    if (!data.geometry) {
                                        return;
                                    }
                                }
                                var coords = JSONResponse.location.split(",");
                                if (data.location) {
                                    data.location.x = coords[0];
                                    data.location.y = coords[1];
                                }
                            } else {
                                options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_ANALYSE", options.response)));
                                return;
                            }
                        } else if (JSONResponse.status === "ERROR" || JSONResponse.status === "error") {
                            // JSHint bug if var message is used !?
                            var mess = JSONResponse.message;
                            mess += "\n (raw response service : '" + JSONResponse + "')";
                            options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EXCEPTION", mess)));
                            return;
                        }
                        break;

                    default:
                        options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_FORMAT", "json", "xml")));
                        return;
                }

                // info : en cas de problèmes de droits (clé invalide ou autre), la réponse est au format XML !!
                // ex. <ExceptionReport><Exception exceptionCode="MissingParameter">Key does not exist or has expired</Exception></ExceptionReport>
                // mais le statut est 403, l'erreur est donc remontée plus tôt.
                if (data && data.exceptionReport) {
                    options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"]({
                        message : _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EXCEPTION", data.exceptionReport),
                        type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"].TYPE_SRVERR,
                        status : 200
                    }));
                    return;
                }
            }
        } else {
            // si la réponse est vide, on appelle le callback d'erreur
            options.onError.call(options.scope, new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"](_Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_1__["default"].getMessage("SERVICE_RESPONSE_EMPTY")));
            return;
        }

        // si tout s'est bien passé, on appelle le callback de succès
        options.onSuccess.call(options.scope, data);
    }
};

/* harmony default export */ __webpack_exports__["default"] = (ProcessIsoCurveResponseFactory);


/***/ }),
/* 138 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44);
/* harmony import */ var _Formats_WKT__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(129);
/* harmony import */ var _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45);
/* harmony import */ var _Response_model_ProcessIsoCurveResponse__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(139);
/**
 * Analyse de la reponse XML
 *
 * @module ProcessIsoCurveResponseReader
 * @alias Gp.Services.ProcessIsoCurve.Formats.ProcessIsoCurveResponseReader
 * @todo not yet implemented !
 * @private
 */






/**
 * Objet ProcessIsoCurveResponseReader
 *
 * @member {Object} ProcessIsoCurveResponseReader
 *
 * @property {Object} ProcessIsoCurveResponseReader.READERS - Objet contenant des fonctions de lecture, appelées "readers"
 *      dont chaque clé correspond au nom d'un tag du XML que l'on souhaite lire
 *      et la valeur associée est une fonction (node, data)
 *      où node est un noeud du document DOM
 *      et data est un objet où l'on stocke les informations lues dans le XML.
 *
 * @property {Method} ProcessIsoCurveResponseReader.read -  Méthode permettant de lancer la lecture d'une réponse XML
 *       du service de calcul isochrone/isodistance, à l'aide des readers de la classe.
 *
 */

var ProcessIsoCurveResponseReader = {};

/*
    // INFO
    // Exemple d'erreur du service
    // <?xml version="1.0" encoding="UTF-8" standalone="yes" ?>
    // <isochroneResult>
    //  <message>Location point must have 2 components separated with a ,</message>
    //  <status>ERROR</status>
    // </isochroneResult>

    // <?xml version="1.0" encoding="UTF-8" standalone="yes" ?>
    // <serviceResult>
    //   <message>ServiceException : Error in isochron computation Error in smartrouting null</message>
    //   <status>ERROR</status>
    // </serviceResult>

    // INFO
    // Exemple d'erreur NGinx
    // <ExceptionReport><Exception exceptionCode="MissingParameter">Resource parameter not found</Exception></ExceptionReport>
*/

/*
    // INFO
    // Exemple de réponse du service

     // <IsochroneResult>
     //    <status>OK</status>
     //    <id/>
     //    <location>-1.557189,47.217122</location>
     //    <srs/>
     //    <distance>5000</distance>
     //    <wktGeometry>POLYGON ((-1.545312 47.178178, -1.545312 47.180418, ...))</wktGeometry>
     // </IsochroneResult>

    // <isochronResult>
    //    <status>OK</status>
    //    <id>1</id>
    //    <location>-1.557189,47.217122</location>
    //    <srs/>
    //    <time>50</time>
    //    <wktGeometry>POLYGON ((-1.556864 47.216487, -1.556864 47.216948, ...))</wktGeometry>
    // </isochronResult>
*/

ProcessIsoCurveResponseReader.READERS = {

    /** TODO : jsdoc block */
    isochronResult : function (root) {
        // racine de la réponse XML : on crée l'objet de réponse
        var response = new _Response_model_ProcessIsoCurveResponse__WEBPACK_IMPORTED_MODULE_3__["default"]();

        if (root.hasChildNodes()) {
            var children = root.childNodes;
            var child;

            for (var i = 0; i < children.length; i++) {
                child = children[i];

                if (ProcessIsoCurveResponseReader.READERS[child.nodeName]) {
                    ProcessIsoCurveResponseReader.READERS[child.nodeName](child, response);
                }
            }
        }

        if (response.status === "error") {
            var message = _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_0__["default"].getMessage("SERVICE_RESPONSE_EXCEPTION",
                response.message);
            throw new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"]({
                message : message,
                type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"].TYPE_SRVERR
            });
        }
        return response;
    },

    /** TODO : jsdoc block */
    message : function (node, response) {
        if (response) {
            response.message = __getChildValue(node);
        }
    },

    /** TODO : jsdoc block */
    status : function (node, response) {
        var status = __getChildValue(node);
        if (status === "ERROR" || status === "error") {
            if (response) {
                response.status = "error";
            }
        }
    },

    /** TODO : jsdoc block */
    id : function (node, response) {
        if (response) {
            response.id = __getChildValue(node);
        }
    },

    /** TODO : jsdoc block */
    location : function (node, response) {
        var coords = __getChildValue(node);
        if (response && response.location) {
            response.location.x = parseFloat(coords.split(",")[0]);
            response.location.y = parseFloat(coords.split(",")[1]);
        }
    },

    /** TODO : jsdoc block */
    srs : function (node, response) {
        if (response) {
            response.srs = __getChildValue(node);
        }
    },

    /** TODO : jsdoc block */
    distance : function (node, response) {
        if (response) {
            response.distance = parseFloat(__getChildValue(node));
        }
    },

    /** TODO : jsdoc block */
    time : function (node, response) {
        if (response) {
            response.time = parseFloat(__getChildValue(node));
        }
    },

    /** TODO : jsdoc block */
    wktGeometry : function (node, response) {
        if (response) {
            var wktGeometry = node.innerHTML;
            /** TODO : jsdoc block */
            var onWKTSuccess = function (json) {
                response.geometry = json;
            };
            /** TODO : jsdoc block */
            var onWKTError = function () {
                var msg = _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_0__["default"].getMessage("PARAM_FORMAT", ["wktGeometry"]);
                throw new Error(msg);
            };
            if (response.hasOwnProperty("geometry")) {
                _Formats_WKT__WEBPACK_IMPORTED_MODULE_1__["default"].toJson(wktGeometry, onWKTSuccess, onWKTError);
            }
        }
    },

    /** TODO : jsdoc block */
    serviceResult : function (node) {
        // en cas d'exception du service
        var response = {};
        if (node.hasChildNodes()) {
            var children = node.childNodes;
            var child;
            for (var i = 0; i < children.length; i++) {
                child = children[i];
                if (ProcessIsoCurveResponseReader.READERS[child.nodeName]) {
                    ProcessIsoCurveResponseReader.READERS[child.nodeName](child, response);
                }
            }
        }
        return response;
    },

    /** TODO : jsdoc block */
    ExceptionReport : function (node) {
        var response = {};
        if (node.hasChildNodes()) {
            var children = node.childNodes;
            var child;
            for (var i = 0; i < children.length; i++) {
                child = children[i];
                if (child.nodeName === "Exception") {
                    response.exceptionReport = ProcessIsoCurveResponseReader.READERS["Exception"](child);
                }
            }
        }
        return response;
    },

    /** TODO : jsdoc block */
    Exception : function (node) {
        var exceptionReport = {};

        // get exception code
        var exceptionCode = node.getAttribute("exceptionCode");
        if (exceptionCode) {
            exceptionReport.exceptionCode = exceptionCode;
        }

        // get exception message
        var textNode = node.firstChild;
        if (textNode && textNode.nodeType === 3) { // 3 === node.TEXT_NODE
            exceptionReport.exception = textNode.nodeValue;
        }

        return exceptionReport;
    }
};

/** TODO : jsdoc block */
ProcessIsoCurveResponseReader.read = function (root) {
    var response;

    if (root.nodeName === "isochronResult" || root.nodeName === "isochroneResult" || root.nodeName === "IsochroneResult") {
        response = ProcessIsoCurveResponseReader.READERS["isochronResult"](root);
        return response;
    } else if (root.nodeName === "ExceptionReport") {
        response = ProcessIsoCurveResponseReader.READERS[root.nodeName](root);
        return response;
    } else if (ProcessIsoCurveResponseReader.READERS[root.nodeName]) {
        response = ProcessIsoCurveResponseReader.READERS[root.nodeName](root);
        if (response.status === "error") {
            var errMsg = _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_0__["default"].getMessage("SERVICE_RESPONSE_EXCEPTION",
                response.message);
            throw new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"]({
                message : errMsg,
                type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"].TYPE_SRVERR
            });
        }
        return response;
    } else {
        throw new _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"]({
            message : _Utils_MessagesResources__WEBPACK_IMPORTED_MODULE_0__["default"].getMessage("SERVICE_RESPONSE_ANALYSE", root.nodeName),
            type : _Exceptions_ErrorService__WEBPACK_IMPORTED_MODULE_2__["default"].TYPE_UNKERR
        });
    }
};

/**
 * Lecture de la valeur du premier child d'un noeud, si elle existe.
 *
 * @private
 * @memberof ProcessIsoCurveResponseReader
 * @method __getChildValue
 * @param {DOMElement} node - a DOM node
 * @return {String} value - valeur du firstChild du noeud en entrée, ou chaîne vide.
 */
function __getChildValue (node) {
    var textNode;
    var value = "";

    if (node.hasChildNodes()) {
        textNode = node.firstChild;
        if (textNode && textNode.nodeType === 3) { // 3 === node.TEXT_NODE
            value = textNode.nodeValue;
        }
    }
    return value;
}

/* harmony default export */ __webpack_exports__["default"] = (ProcessIsoCurveResponseReader);


/***/ }),
/* 139 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

/**
 * Response object for {@link module:Services~isoCurve Gp.Services.isoCurve ()} invocation when successful. Received as the argument of onSuccess callback function.
 *
 * @property {Float} distance - distance (expressed in meters) used for the request.
 * @property {Float} time - time (expressed in seconds) used for the request.
 * @property {Object} geometry - Geometry (expressed in [GeoJSON]{@link http://geojson.org/}) of the isocurve.
 * @property {String} id - request id (used by underlying webservice).
 * @property {Gp.Point} location - Position of the start or end point used for the request (expressed in "srs" coordinates system).
 * @property {String} message - message
 * @property {String} srs - Identifier of the coordinates system used for the isocurve.
 *
 * @namespace
 * @alias Gp.Services.IsoCurveResponse
 *
 */
function ProcessIsoCurveResponse () {
    if (!(this instanceof ProcessIsoCurveResponse)) {
        throw new TypeError("ProcessIsoCurveResponse constructor cannot be called as a function.");
    }

    this.message = null;

    this.id = null;

    this.location = {};
    this.location.x = null;
    this.location.y = null;

    this.srs = null;

    this.geometry = null;

    this.time = null;

    this.distance = null;
}

ProcessIsoCurveResponse.prototype = {

    constructor : ProcessIsoCurveResponse

};

/* harmony default export */ __webpack_exports__["default"] = (ProcessIsoCurveResponse);


/***/ }),
/* 140 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Common_Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34);
/* harmony import */ var _Config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(141);


/* harmony default export */ __webpack_exports__["default"] = ({
  /**
   * Contrôle des droits sur les ressources.
   *
   * @param {Object} options - liste des options
   * @param {String} options.key - clef API
   * @param {Array} options.resources - liste des ressources
   * @param {Array} options.services - liste des services
   * @returns {Object} rightManagement - undefined ou {
   *       key : "",
   *       service-1 : [resource-1, resource-2],
   *       service-2 : [resource-1, resource-2]
   * }
   */
  check: function check(options) {
    // logger
    var logger = _Common_Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("checkrightmanagement"); // si aucune option n'est renseignée...

    if (!options) {
      // message orienté pour le developpeur !
      logger.error("WARNING : " + "no parameter specified !");
      return;
    } // les options


    var _key = options.key;

    var _resources = options.resources || [];

    var _services = options.services || []; // si aucune information sur les ressources,
    // il est impossible de controler quelquechose !!!


    if (!_resources || _resources.length === 0) {
      // message orienté pour le developpeur !
      logger.error("WARNING : " + "no parameter 'resources' specified !");
      return;
    } // si aucune information sur les services,
    // il est impossible de controler quelquechose !!!


    if (!_services || _services.length === 0) {
      // message orienté pour le developpeur !
      logger.error("WARNING : " + "no parameter 'services' specified !");
      return;
    } // les ressources controlées :
    // Ex.
    // {
    //   "Itineraire"     : ["Pieton", "Voiture"],
    //   "Geocode"        : ["PositionOfInterest", "StreetAddress", "CadastralParcel", "Administratif"],
    //   "AutoCompletion" : ["PositionOfInterest", "StreetAddress", "CadastralParcel", "Administratif"],
    //   "Elevation"      : ["SERVICE_CALCUL_ALTIMETRIQUE_RSC"]
    // }


    var _rightManagement = {}; // la clef API n'est pas renseignée

    if (!_key) {
      // on verifie si l'autoconfiguration est disponible
      if (!_Config__WEBPACK_IMPORTED_MODULE_1__["default"].isConfigLoaded()) {
        // si l'autoconfiguration n'est pas chargée,
        // aucune vérification des droits est possible...
        logger.warn("WARNING : " + "The 'apiKey' parameter is missing, " + "and the contract key configuration has not been loaded, " + "so impossible to check yours rights !");
        return;
      } else {
        // si l'autoconfiguration est chargée,
        // on recupere la clef API, et on en profitera ensuite pour controler
        // les droits sur les ressources.
        // FIXME par defaut, on recupere toujours la première...
        _key = Object.keys(_Config__WEBPACK_IMPORTED_MODULE_1__["default"].configuration.generalOptions.apiKeys)[0];
        logger.log(_key);
      }
    } // la clef API est renseignée ou recuperée de l'autoconfiguration


    if (_key) {
      // on verifie si l'autoconfiguration est disponible
      if (!_Config__WEBPACK_IMPORTED_MODULE_1__["default"].isConfigLoaded()) {
        // si l'autoconfiguration n'est pas chargée,
        // il est toujours possible de requeter le service avec une clef API,
        // mais les droits sur les ressources ne sont pas garantis, on risque
        // d'obtenir des erreurs 403 forbidden...
        // la responsabilité revient à l'utilisateur (message d'information)...
        logger.warn("WARNING : " + "the contract key configuration has not been loaded, " + "so be carefull !"); // les ressouces non controlées

        var _noRightManagement = {};

        for (var i = 0; i < _services.length; i++) {
          var service = _services[i];
          _noRightManagement[service] = [];

          for (var j = 0; j < _resources.length; j++) {
            var resource = _resources[j];

            _noRightManagement[service].push(resource);
          }
        } // on ajoute la clef


        _noRightManagement.key = _key;
        logger.log("right management not checked", _noRightManagement);
        return _noRightManagement;
      } else {
        // si l'autoconf est chargée,
        // on verifie la correspondance entre la clef et l'autoconfiguration,
        // on previent l'utilisateur (message d'information) s'il n'a
        // pas de droits sur certaines ressources ...
        // doit on ecarter les ressources sans droit ?
        // oui, si possible avec un message d'information pour l'utilisateur...
        for (var k = 0; k < _resources.length; k++) {
          var _resource = _resources[k];

          for (var l = 0; l < _services.length; l++) {
            var _service = _services[l];
            var params = _Config__WEBPACK_IMPORTED_MODULE_1__["default"].getServiceParams(_resource, _service, _key);

            if (!params || Object.keys(params).length === 0) {
              logger.warn("WARNING : " + "The contract key configuration has no rights to load this geoportal " + "resource (" + _resource + ") " + "for this service (" + _service + ") ");
              continue;
            }

            if (!_rightManagement[_service]) {
              _rightManagement[_service] = [];
            }

            _rightManagement[_service].push(_resource);
          }
        }

        if (!_rightManagement || Object.keys(_rightManagement).length === 0) {
          logger.warn("WARNING : " + "The contract key configuration has been loaded, " + "and the 'apiKey' parameter has been set, " + "but, there is a problem on the mapping between the contract and the key !");
          return;
        } // on ajoute la clef


        _rightManagement.key = _key;
        logger.log("right management checked", _rightManagement);
        return _rightManagement;
      }
    }
  }
});

/***/ }),
/* 141 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function(global) {/* harmony import */ var _Common_Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34);

var logger = _Common_Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_0__["default"].getLogger("config");
var Config = {
  /** autoconf */
  configuration: null,

  /**
   * Controle du chargement de l'autoconf
   *
   * @returns {Boolean} isConfigLoaded - True si l'autoconf a déjà été chargée, False sinon.
   */
  isConfigLoaded: function isConfigLoaded() {
    var scope = typeof window !== "undefined" ? window : typeof self !== "undefined" ? self : typeof global !== "undefined" ? global : {};

    if (scope.Gp && scope.Gp.Config && Object.keys(scope.Gp.Config).length !== 0) {
      this.configuration = scope.Gp.Config;
      return true;
    }

    return false;
  },

  /**
   * Recuperation de l'identifiant d'une couche donnée
   *
   * @param {String} layerName - nom de la couche (par ex. "ORTHOIMAGERY.ORTHOPHOTOS")
   * @param {String} service   - nom du service (par ex. "WMS" ou "WMTS")
   * @returns {String} layerId - identifiant de la couche (par ex. "ORTHOIMAGERY.ORTHOPHOTOS$GEOPORTAIL:OGC:WMTS")
   */
  getLayerId: function getLayerId(layerName, service) {
    var layerId = null; // layer
    // key : [layerName]$[contexte]:OGC:[service]
    // ex : "ORTHOIMAGERY.ORTHOPHOTOS$GEOPORTAIL:OGC:WMTS"
    // service
    // key : [layerName]$[contexte];[service]
    // ex : PositionOfInterest$OGC:OPENLS;ReverseGeocode

    if (this.configuration) {
      var layers = this.configuration["layers"];

      for (var key in layers) {
        if (layers.hasOwnProperty(key)) {
          var parts = key.split("$");

          if (layerName === parts[0]) {
            if (parts[1]) {
              var servicePartsLayer = parts[1].split(":");
              var servicePartsService = parts[1].split(";");

              if (servicePartsService[1] === service) {
                layerId = key;
                break;
              }

              if (servicePartsLayer[2] === service) {
                layerId = key;
                break;
              }
            }
          }
        }
      }
    }

    if (!layerId) {
      logger.error("ERROR layer id (layer name: " + layerName + " / service: " + service + ") was not found !?");
    }

    return layerId;
  },

  /**
   * Récupération des paramètres nécessaires à l'affichage d'une couche WMS ou WMTS
   *
   * @param {String} layerName - nom de la couche (par ex. "ORTHOIMAGERY.ORTHOPHOTOS")
   * @param {String} service   - nom du service (par ex. "WMS" ou "WMTS")
   * @param {String} [apiKey]  - Clé de contrat API
   * @returns {Object} params  - paramètres du service (WMS ou WMTS) pour la couche donnée
   * @returns {String} params.url        - Url du service à requêter pour afficher la couche
   * @returns {String} params.version    - Version du service
   * @returns {String} params.styles     - Style par défaut de la couche
   * @returns {String} params.format     - Format par défaut de la couche
   * @returns {String} params.projection - Projection par défaut de la couche
   * @returns {Number} params.minScale   - Dénominateur d'échelle minimum de la couche
   * @returns {Number} params.maxScale   - Dénominateur d'échelle maximum de la couche
   * @returns {Gp.BBox} params.extent    - Etendue de la couche, dans la projection de la couche
   * @returns {Array} params.legends     - Tableau des légendes associées à la couche
   * @returns {Array} params.metadata    - Tableau des métadonnées associées à la couche
   * @returns {Array} params.originators - Tableau des originators associés à la couche
   * @returns {Array} params.title       - Nom de la resource, lisible par un humain.
   * @returns {Array} params.description - Url de l'image d'aperçu rapide de la ressource.
   * @returns {Array} params.quicklookUrl- Tableau des originators associés à la couche
   * @returns {String} params.[TMSLink]          - Identifiant de la pyramide (TMS), dans le cas d'une couche WMTS
   * @returns {Gp.Point} params.[matrixOrigin]   - Origine de la matrice (top left corner), dans le cas d'une couche WMTS
   * @returns {Array} params.[nativeResolutions] - Tableau regroupant les résolutions de chaque niveau de la matrice, dans le cas d'une couche WMTS
   * @returns {Array} params.[matrixIds]         - Tableau regroupant les identifiants de chaque niveau de la matrice, dans le cas d'une couche WMTS
   */
  getLayerParams: function getLayerParams(layerName, service, apiKey) {
    var params = {};

    if (this.configuration) {
      // récupération de l'identifiant complet de la couche.
      var layerId = this.getLayerId(layerName, service);

      if (layerId) {
        // récupération de l'objet de configuration de la couche
        var layerConf = this.configuration.layers[layerId]; // controle de la clef

        var key = layerConf.apiKeys[0];

        if (apiKey) {
          if (apiKey !== key) {
            logger.error("ERROR different keys (" + apiKey + " !== " + key + ") !?");
            return;
          }
        }

        apiKey = apiKey || key;
        params.key = apiKey; // récupération des paramètres du service

        params.url = layerConf.getServerUrl(apiKey);
        params.version = layerConf.getServiceParams().version;
        params.styles = layerConf.getDefaultStyle();
        params.format = layerConf.getDefaultFormat();
        params.projection = layerConf.getDefaultProjection(); // récupération des infos de la couche

        params.minScale = layerConf.getMinScaleDenominator();
        params.maxScale = layerConf.getMaxScaleDenominator();
        params.extent = layerConf.getBBOX();
        params.legends = layerConf.getLegends();
        params.metadata = layerConf.getMetadata();
        params.originators = layerConf.getOriginators();
        params.title = layerConf.getTitle();
        params.description = layerConf.getDescription();
        params.quicklookUrl = layerConf.getQuicklookUrl(); // WMTS : récupération des tileMatrixSetLimits

        if (layerConf.wmtsOptions) {
          params.tileMatrixSetLimits = layerConf.wmtsOptions.tileMatrixSetLimits;
        } // WMTS : récupération des paramètres de la pyramide (TMS)


        var TMSLink = layerConf.getTMSID();

        if (TMSLink) {
          params.TMSLink = TMSLink;
          var tmsConf = this.configuration.getTMSConf(TMSLink); // Get matrix origin : Gp.Point = Object{x:Float, y:Float}

          params.matrixOrigin = tmsConf.getTopLeftCorner();
          params.nativeResolutions = tmsConf.nativeResolutions;
          params.matrixIds = tmsConf.matrixIds;
          params.tileMatrices = tmsConf.tileMatrices;
        }
      }
    }

    return params;
  },

  /**
   * Recuperation des parametres d'un service
   *
   * @param {String} [resource] - "PositionOfInterest", "StreetAddress", "Voiture", "Pieton", ...
   * @param {String} [service] - Geocode, Itineraire, ...
   * @param {String} [apiKey]  - Clé de contrat API
   * @returns {Object} params - paramètres de la ressource
   * @returns {String} params. -
   * @returns {String} params. -
   * @returns {String} params. -
   */
  getServiceParams: function getServiceParams(resource, service, apiKey) {
    var params = {};

    if (this.configuration) {
      // récupération de l'identifiant complet de la couche.
      var layerId = this.getLayerId(resource, service);

      if (layerId) {
        // récupération de l'objet de configuration de la couche
        var layerConf = this.configuration.layers[layerId]; // controle de la clef

        var key = layerConf.apiKeys[0];

        if (apiKey) {
          if (apiKey !== key) {
            return;
          }
        }

        apiKey = apiKey || key;
        params.key = apiKey; // récupération des paramètres du service

        params.url = layerConf.getServerUrl(apiKey);
        params.version = layerConf.getServiceParams().version; // récupération des infos de la couche

        params.extent = layerConf.getBBOX();
        params.title = layerConf.getTitle();
        params.description = layerConf.getDescription();
      }
    }

    return params;
  },

  /**
   * Resolution en geographique
   *
   * @returns {Array} resolutions
   */
  getResolutions: function getResolutions() {
    var resolutions = [];

    if (this.configuration) {
      resolutions = this.configuration["generalOptions"]["wgs84Resolutions"];
    }

    return resolutions;
  },

  /**
   * Recuperation des parametres TMS de la configuration
   * @param {String} tmsName - tile matrix set name
   *
   * @returns {Object} tile matrix set
   */
  getTileMatrix: function getTileMatrix(tmsName) {
    var tms = {};

    if (this.configuration) {
      if (tmsName) {
        tms = this.configuration["tileMatrixSets"][tmsName.toUpperCase()];
      }
    }

    return tms;
  },

  /**
   * Récupération des contraintes générales d'une couche donnée : extent, minScale, maxScale, projection
   *
   * @param {String} layerId - identifiant de la couche
   * @returns {Object} params - contraintes de la couche
   * @returns {String} params.projection - Projection par défaut de la couche
   * @returns {Number} params.minScale   - Dénominateur d'échelle minimum de la couche
   * @returns {Number} params.maxScale   - Dénominateur d'échelle maximum de la couche
   * @returns {Gp.BBox} params.extent    - Etendue de la couche, dans la projection de la couche
   */
  getGlobalConstraints: function getGlobalConstraints(layerId) {
    var params = {};

    if (layerId) {
      // récupération de l'objet de configuration de la couche
      var layerConf = this.configuration.layers[layerId];
      params.projection = layerConf.getDefaultProjection();
      params.minScale = layerConf.getMinScaleDenominator();
      params.maxScale = layerConf.getMaxScaleDenominator();
      params.extent = layerConf.getBBOX();
    }

    return params;
  }
};
/* harmony default export */ __webpack_exports__["default"] = (Config);
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(52)))

/***/ }),
/* 142 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var geoportal_access_lib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(40);
/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2);
/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Common_Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(34);
/* harmony import */ var _Common_Utils_CheckRightManagement__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(140);
/* harmony import */ var _Common_Utils_SelectorID__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(36);
/* harmony import */ var _Common_Controls_LocationSelectorDOM__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(143);
/* harmony import */ var _Utils_PositionFormater__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(144);
/* harmony import */ var _Utils_IconDefault__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(145);








var logger = _Common_Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_2__["default"].getLogger("locationselector");
/**
* @classdesc
*
* LocationSelector Control.
*
* @private
* @constructor LocationSelector
* @alias LocationSelector
* @extends {L.Control}
* LocationSelector component. Enables to select a location, using autocompletion or picking location on the map
* @param {Object} [options] - component options
* @param {Boolean} [options.displayInfo = true] - whether to display info in a popup or not (not implemented yet) Default is true
* @param {Boolean} [options.disableReverse = false] - whether to enable/disable the reverse geocoding.
* @param {Object} [options.tag] - tag options
* @param {Number} [options.tag.id = 0] - order id number in a locations group, in case several LocationSelector are used. For instance in route case : departure tag id should be 0, arrival tag id should be 1, and other ones : 2, 3, ...
* @param {Number} [options.tag.unique = null] - locationSelector global component id (in case locationSelector is called by another graphic component, e.g. route control)
* @param {String} [options.tag.label = ">"] - text to display in component (e.g. "Departure"). Default is ">"
* @param {String} [options.tag.color = blue] - color of marker (blue, green, orange and red)
* @param {Boolean} [options.tag.display = true] - whether to display or hide component. Default is true
* @param {Boolean} [options.tag.addOption = false] - whether to display picto to add another LocationSelector (in case of route control)
* @param {Boolean} [options.tag.removeOption = false] - whether to display picto to remove a LocationSelector (in case of route control)
* @param {Object} [options.autocompleteOptions] - autocomplete service options
* @param {Object} [options.reverseGeocodeOptions] - reverse geocoding service options

* @example
*  var point = L.geoportalControl.LocationSelector({
*  });
*/

var LocationSelector = leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.Control.extend(
/** @lends LocationSelector.prototype */
{
  includes: _Common_Controls_LocationSelectorDOM__WEBPACK_IMPORTED_MODULE_5__["default"],

  /**
   * options by default
   *
   * @private
   */
  options: {
    position: "topleft",
    tag: {
      id: 0,
      // numero d'ordre sur un groupe de locations !
      unique: null,
      // numero unique pour tous les locations d'un groupe !
      label: ">",
      color: "blue",
      display: true,
      addOption: false,
      removeOption: false
    },
    disableReverse: false,
    // on l'active par defaut !
    displayInfo: true,
    autocompleteOptions: {},
    reverseGeocodeOptions: {}
  },

  /**
   * constructor
   * (extend to L.Control)
   *
   * @param {Object} options - options of component
   * @param {String}  [options.position] - position of component into a map.
   * @param {Object}  [options.tag] - options ...
   * @param {Object}  [options.autocompleteOptions] - autocomplete service options
   * @param {Object}  [options.reverseGeocodeOptions] - reverse geocoding service options
   *
   * @private
   */
  initialize: function initialize(options) {
    // FIXME pb de merge sur tag:{} !?
    // on transmet les options au controle
    leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.Util.setOptions(this, options);
    /** uuid */

    this._uid = this.options.tag.unique || null;
    /** mode drag&drop */

    this._activeDragAndDrop = false;
    this._pressedKeyOnDragAndDrop = false;
    /** container map */

    this._map = null;
    /** container principal des entrées  */

    this._inputsContainer = null;
    /** container du label du point */

    this._inputLabelContainer = null;
    /** container de la saisi de l'autocompletion */

    this._inputAutoCompleteContainer = null;
    /** container du pointer de saisi sur la carte */

    this._inputShowPointerContainer = null;
    /** container des coordonnées */

    this._inputCoordinateContainer = null;
    /**
     * coordonnées du point selectionné
     * Ces dernieres sont envoyées à l'API service IGN,
     * donc X->LON et Y->LAT quelquesoit la logique des projections...
     */

    this._coordinate = null;
    /** container des reponses de l'autocompletion */

    this._suggestedContainer = null;
    /** listes des reponses de l'autocompletion */

    this._suggestedLocations = [];
    /** localisant */

    this._currentLocation = null;
    /** marker */

    this._marker = null;
    /** ressources du services d'autocompletion et geocodage inverse (ayant droit!) */

    this._resources = {};
    /** a t on des droits sur les ressources du service ? */

    this._noRightManagement = false; // gestion des droits sur les ressources/services

    this._checkRightsManagement(); // creation du DOM dans le constructeur uniquement si ce composant
    // est appelé par un autre composant graphique


    this._container = this._uid ? this._initLayout() : null;
  },
  // ################################################################### //
  // ################## handlers for display graphic ################### //
  // ################################################################### //

  /**
   * this method is called by this.addTo(map)
   * and fills variable : this._container = this.onAdd(map)
   *
   * @returns {DOMElement} DOM element
   * @private
   */
  onAdd: function onAdd()
  /* map */
  {
    // si on ajout ce composant à la carte en tant que objet graphique,
    // un uuid doit être generé automatiquement !
    this._uid = _Common_Utils_SelectorID__WEBPACK_IMPORTED_MODULE_4__["default"].generate(); // DOM du composant

    var container = this._initLayout(); // deactivate of events that may interfere with the map


    leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.DomEvent.disableClickPropagation(container).disableScrollPropagation(container);
    return container;
  },

  /**
   * this method is called when the control is removed from the map
   * and removes events on map.
   *
   * @private
   */
  onRemove: function onRemove()
  /* map */
  {},
  // ################################################################### //
  // ########################## publics methods ######################## //
  // ################################################################### //

  /**
   * get coordinate
   * @returns {Object} Coordinate
   */
  getCoordinate: function getCoordinate() {
    return this._coordinate;
  },

  /**
   * set coordinate : {lon,lat || x,y || N,E}
   * @param {Object} coordinate - Coordinate
   */
  setCoordinate: function setCoordinate(coordinate) {
    this._displayResultOfCoordinate(coordinate);
  },

  /**
   * get coordinate inverse (EPSG:4326)
   * @returns {Object} Coordinate
   */
  getCoordinateInverse: function getCoordinateInverse() {
    if (!this._coordinate) {
      return;
    }

    var coordinateInv = {
      x: this._coordinate.y,
      y: this._coordinate.x
    };
    return coordinateInv;
  },

  /**
   * set map
   *
   * @param {Object} map - the map
   */
  setMap: function setMap(map) {
    if (!this._map) {
      this._map = map;
    }
  },

  /**
   * clean
   */
  clear: function clear() {
    this._setCursor();

    this._setMarker();

    this._clearResults();

    this._inputLabelContainer.click();
  },

  /**
   * disable/enable the drag&drop mode
   *
   * @param {Boolean} active - true:enable | false:disable
   */
  dragging: function dragging(active) {
    if (this._marker) {
      if (active) {
        this._marker.dragging.enable();
      } else {
        this._marker.dragging.disable();
      }
    }
  },
  // ################################################################### //
  // ########################## pivates methods ######################## //
  // ################################################################### //

  /**
   * this method is called by this.onAdd(map)
   * and initialize the container HTMLElement
   *
   * @returns {DOMElement} DOM element
   *
   * @private
   */
  _initLayout: function _initLayout() {
    var id = this.options.tag.id; // create main container

    var container = this._createMainContainerElement();

    var inputs = this._inputsContainer = this._createLocationPointElement(id, this.options.tag.display);

    container.appendChild(inputs);

    var _inputLabel = this._inputLabelContainer = this._createLocationPointLabelElement(id, this.options.tag.label);

    inputs.appendChild(_inputLabel);

    var _inputAutoComplete = this._inputAutoCompleteContainer = this._createLocationAutoCompleteteInputElement(id);

    inputs.appendChild(_inputAutoComplete);

    var _inputCoordinate = this._inputCoordinateContainer = this._createLocationCoordinateInputElement(id);

    inputs.appendChild(_inputCoordinate);

    var _inputShowPointer = this._inputShowPointerContainer = this._createLocationPointerShowInputElement(id);

    inputs.appendChild(_inputShowPointer);

    var _inputPointer = this._createLocationPointerInputElement(id);

    inputs.appendChild(_inputPointer);

    if (this.options.tag.addOption) {
      var _inputAddStage = this._createLocationAddPointElement();

      inputs.appendChild(_inputAddStage);
    }

    if (this.options.tag.removeOption) {
      var _inputRemoveStage = this._createLocationRemovePointElement(id);

      inputs.appendChild(_inputRemoveStage);
    }

    var results = this._suggestedContainer = this._createLocationAutoCompleteResultElement(id);

    container.appendChild(results);
    return container;
  },

  /**
   * this method is called by constructor
   * and check the rights to resources and services
   *
   * @private
   */
  _checkRightsManagement: function _checkRightsManagement() {
    var _opts = null;
    var _res = [];
    var _key = null; // les ressources du service du calcul inverse de geocodage

    _key = this.options.reverseGeocodeOptions.apiKey;
    _opts = this.options.reverseGeocodeOptions.filterOptions;
    _res = _opts ? _opts.type : [];

    if (!_res || _res.length === 0) {
      _res = ["PositionOfInterest", "StreetAddress"];
    }

    var rightManagementRerverse = _Common_Utils_CheckRightManagement__WEBPACK_IMPORTED_MODULE_3__["default"].check({
      key: _key || this.options.apiKey,
      resources: _res,
      services: ["ReverseGeocode"]
    }); // les ressources du service d'autocompletion

    _key = this.options.autocompleteOptions.apiKey;
    _opts = this.options.autocompleteOptions.filterOptions;
    _res = _opts ? _opts.type : [];

    if (!_res || _res.length === 0) {
      _res = ["PositionOfInterest", "StreetAddress"];
    }

    var rightManagementAutoComplete = _Common_Utils_CheckRightManagement__WEBPACK_IMPORTED_MODULE_3__["default"].check({
      key: _key || this.options.apiKey,
      resources: _res,
      services: ["AutoCompletion"]
    }); // au cas où pas de droit !

    if (!rightManagementRerverse && !rightManagementAutoComplete) {
      this._noRightManagement = true;
    } // FIXME je reconstruis differement la structure pour la gestion des clefs differentes
    // pour chaque service...


    if (rightManagementAutoComplete) {
      this._resources["AutoCompletion"] = {};
      this._resources["AutoCompletion"]["resources"] = rightManagementAutoComplete["AutoCompletion"];
      this._resources["AutoCompletion"]["key"] = rightManagementAutoComplete["key"];
    }

    if (rightManagementRerverse) {
      this._resources["ReverseGeocode"] = {};
      this._resources["ReverseGeocode"]["resources"] = rightManagementRerverse["ReverseGeocode"];
      this._resources["ReverseGeocode"]["key"] = rightManagementRerverse["key"];
    }
  },
  // ################################################################### //
  // ################# privates methods use by events ################## //
  // ################################################################### //

  /**
   * this sends the label to the panel.
   *
   * @param {String} label - label suggested location
   *
   * @private
   */
  _setLabel: function _setLabel(label) {
    this._inputAutoCompleteContainer.value = label || "";
  },

  /**
   * this sends the coordinates to the panel.
   *
   * @param {Object} oLatLng - geographic coordinate (L.LatLng)
   *
   * @private
   */
  _setCoordinate: function _setCoordinate(oLatLng) {
    // structure
    // L.LatLng
    //     lat: 4.07249425916745
    //     lng: 2.4609375
    // FIXME les coordonnées en lat/lon sur du EPSG:4326 !
    // Mais règle sur les services : X -> LON et Y -> LAT
    this._coordinate = {
      x: oLatLng.lng,
      y: oLatLng.lat
    };
    var lat = null;
    var lng = null; // decimal by default !

    lat = _Utils_PositionFormater__WEBPACK_IMPORTED_MODULE_6__["default"].roundToDecimal(oLatLng.lat, 4);
    lng = _Utils_PositionFormater__WEBPACK_IMPORTED_MODULE_6__["default"].roundToDecimal(oLatLng.lng, 4); // on envoie du lon/lat à l'affichage

    var value = lng + " , " + lat;
    this.GPdisplayCoordinate(value);
  },

  /**
   * this method is called by this.on*ResultsItemClick()
   * and move/zoom on a position.
   *
   * @param {Object} position - {x: ..., y: ...}
   *
   * @private
   */
  _setPosition: function _setPosition(position) {
    logger.log("_setPosition()", position);
    var map = this._map; // TODO zoom
    // map.setZoomAround(L.latLng(position.y, position.x), map.getMaxZoom(), true);
    // FIXME on veut du lat/lon sur Leaflet donc on inverse !

    map.panTo(leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.latLng(position.y, position.x));
  },

  /**
   * this method is called by this.on*ResultsItemClick()
   * and displays a marker.
   * FIXME : marker IGN et informations ?
   *
   * @param {Object} position - position {x: ..., y: ...}
   * @param {Object|String} information - suggested or geocoded information
   * @param {Boolean} display - display a popup information
   *
   * @private
   */
  _setMarker: function _setMarker(position, information, display) {
    logger.log("_setMarker()", position, information, display); // sur du drag&drop, on garde le même marker !

    if (this._activeDragAndDrop) {
      return;
    }

    var map = this._map; // on supprime le marker, ainsi que les events
    // sur le drag&drop

    if (this._marker != null) {
      this._marker.off("mousedown", this.onMouseDownMarker, this);

      this._marker.off("dragstart", this.onStartDragMarker, this);

      this._marker.off("drag", this.onDragMarker, this);

      this._marker.off("dragend", this.onEndDragMarker, this);

      map.removeLayer(this._marker);
      this._marker = null;
    }

    if (position) {
      // cf. http://leafletjs.com/reference.html#marker-options
      var options = {
        icon: new _Utils_IconDefault__WEBPACK_IMPORTED_MODULE_7__["default"](this.options.tag.color),
        draggable: true,
        clickable: true,
        zIndexOffset: 1000
      }; // FIXME on veut du lat/lon sur Leaflet donc on inverse !

      this._marker = leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.marker(leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.latLng(position.y, position.x), options);

      this._marker.on("mousedown", this.onMouseDownMarker, this);

      this._marker.on("dragstart", this.onStartDragMarker, this);

      this._marker.on("drag", this.onDragMarker, this);

      this._marker.on("dragend", this.onEndDragMarker, this); // this._marker.on("movestart", this.onStartMoveMarker, this);
      // this._marker.on("move",      this.onMoveMarker, this);
      // this._marker.on("moveend",   this.onEndMoveMarker, this);


      this._marker.addTo(map); // FIXME
      // doit on mettre une information
      // - correctement construite ?
      // - uniquement informatif ?
      // - RIEN ?


      if (display) {
        var popupContent = null;

        if (typeof information !== "string") {
          if (information.fields.fullText) {
            popupContent = information.fields.fullText;
          } else {
            var values = [];
            values.push(information.fields.street || "");
            values.push(information.fields.postalCode || "");
            values.push(information.fields.commune || "");

            if (information.type === "PositionOfInterest") {
              values.push(information.fields.poi || "");
              values.push(information.fields.kind || "");
            }

            popupContent = values.join(" - ");
          }
        } else {
          popupContent = information;
        }

        this._marker.bindPopup(popupContent);
      }
    }
  },

  /**
   * this method is called by this.on()
   * and change the cursor of the map when entering a point.
   *
   * @param {String} cursor - cursor style
   *
   * @private
   */
  _setCursor: function _setCursor(cursor) {
    var div = this._map.getContainer();

    if (cursor) {
      div.style.cursor = cursor;
    } else {
      div.style.cursor = null;
    }
  },

  /**
   * this method is called by this.()
   * and it clears all results and the marker.
   *
   * @private
   */
  _clearResults: function _clearResults() {
    this._currentLocation = null;
    this._coordinate = null;

    this._clearSuggestedLocation();
  },

  /**
   * this method is called by this.onAutoCompleteSearchText()
   * and it clears all suggested location.
   *
   * @private
   */
  _clearSuggestedLocation: function _clearSuggestedLocation() {
    // suppression du dom
    this._suggestedLocations = [];

    if (this._suggestedContainer) {
      while (this._suggestedContainer.firstChild) {
        this._suggestedContainer.removeChild(this._suggestedContainer.firstChild);
      }
    }
  },
  // ################################################################### //
  // ############## privates methods use by autocomplete ############### //
  // ################################################################### //

  /**
   * this method is called by this.onAutoCompleteSearch()
   * and executes a request to the service.
   *
   * @param {Object} settings - service settings
   * @param {String}   settings.text - text
   * @param {Function} settings.onSuccess - callback
   * @param {Function} settings.onFailure - callback
   *
   * @private
   */
  _requestAutoComplete: function _requestAutoComplete(settings) {
    logger.log("_requestAutoComplete()", settings); // on ne fait pas de requête si on n'a pas renseigné de parametres !

    if (!settings || Object.keys(settings).length === 0) {
      return;
    } // on ne fait pas de requête si la parametre 'text' est vide !


    if (!settings.text) {
      return;
    }

    logger.log(settings); // on ne fait pas de requête si aucun droit !

    if (this._noRightManagement) {
      logger.log("no rights for all service !?");
      return;
    } // gestion des droits !


    if (!this._resources["AutoCompletion"]) {
      logger.log("no rights for this service !?");
      return;
    }

    var resources = this._resources["AutoCompletion"].resources;

    if (!resources || Object.keys(resources).length === 0) {
      return;
    } // gestion de la clef !


    var key = this._resources["AutoCompletion"]["key"];
    var options = {}; // on recupere les options du service

    leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.Util.extend(options, this.options.autocompleteOptions); // ainsi que la recherche et les callbacks

    leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.Util.extend(options, settings); // cas où la clef API n'est pas renseignée dans les options du service,
    // on utilise celle de l'autoconf ou celle renseignée au niveau du controle

    leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.Util.extend(options, {
      apiKey: options.apiKey || this.options.apiKey || key
    });
    logger.log(options);
    geoportal_access_lib__WEBPACK_IMPORTED_MODULE_0__["default"].Services.autoComplete(options);
  },

  /**
   * this method is called by this.onAutoCompleteSearchText()
   * and fills the container of the location list.
   * it creates a HTML Element per location
   * (cf. this. ...)
   *
   * @param {Object[]} locations - locations
   *
   * @private
   */
  _fillAutoCompletedLocationListContainer: function _fillAutoCompletedLocationListContainer(locations) {
    logger.log("_fillAutoCompletedLocationListContainer()", locations);

    if (!locations || locations.length === 0) {
      return;
    } // on vide la liste avant de la construire


    var element = this._suggestedContainer;

    if (element.childElementCount) {
      while (element.firstChild) {
        element.removeChild(element.firstChild);
      }
    }

    for (var i = 0; i < locations.length; i++) {
      // Proposals are dynamically filled in Javascript by autocomplete service
      this._createLocationAutoCompletedLocationElement(this.options.tag.id, locations[i], i);
    } // sauvegarde de l'etat des locations


    this._suggestedLocations = locations;
  },
  // ################################################################### //
  // ################# privates methods use by reverse ################# //
  // ################################################################### //

  /**
   * this method is called by this.onMouseMapClick() or this.onEndDragMarker()
   * and executes a request to the service.
   *
   * @param {Object} settings - service settings
   * @param {String}   settings.position - position
   * @param {Function} settings.onSuccess - callback
   * @param {Function} settings.onFailure - callback
   *
   * @private
   */
  _requestReverseGeocode: function _requestReverseGeocode(settings) {
    logger.log("_requestReverseGeocode()", settings); // on ne fait pas de requête si on n'a pas renseigné de parametres !

    if (!settings || Object.keys(settings).length === 0) {
      return;
    } // on ne fait pas de requête si la parametre 'position' est vide !


    if (!settings.position || Object.keys(settings.position).length === 0) {
      return;
    } // on ne fait pas de requête si aucun droit !


    if (this._noRightManagement) {
      logger.log("no rights for all service !?");
      return;
    } // gestion des droits !


    if (!this._resources["ReverseGeocode"]) {
      logger.log("no rights for this service !?");
      return;
    }

    var resources = this._resources["ReverseGeocode"].resources;

    if (!resources || Object.keys(resources).length === 0) {
      return;
    } // gestion de la clef !


    var key = this._resources["ReverseGeocode"]["key"];
    var options = {}; // on recupere les options du service

    leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.Util.extend(options, this.options.reverseGeocodeOptions); // ainsi que la positions et les callbacks

    leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.Util.extend(options, settings); // on force qq options !
    // La table de geocodage est toujours par defaut : StreetAddress !

    leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.Util.extend(options, {
      returnFreeForm: true,
      // FIXME cette option n'est pas implementée !?
      filterOptions: {
        type: ["StreetAddress"]
      }
    }); // cas où la clef API n'est pas renseignée dans les options du service,
    // on utilise celle de l'autoconf ou celle renseignée au niveau du controle

    leaflet__WEBPACK_IMPORTED_MODULE_1___default.a.Util.extend(options, {
      apiKey: options.apiKey || this.options.apiKey || key
    });
    logger.log(options);
    geoportal_access_lib__WEBPACK_IMPORTED_MODULE_0__["default"].Services.reverseGeocode(options);
  },

  /**
   * display Coordinate on panel, and places the marker on map
   *
   * @param {Object} oLatLng - geographic coordinate (L.LatLng)
   * @private
   */
  _displayResultOfCoordinate: function _displayResultOfCoordinate(oLatLng) {
    // on transmet les coordonnées au panneau
    this._setCoordinate(oLatLng); // on met en place le marker


    this._setMarker({
      x: oLatLng.lng,
      y: oLatLng.lat
    }, null, false);

    logger.log(this.getCoordinate()); // on desactive l'event sur la map en activant le gestionnaire !

    this.onActivateMapPointClick();
  },

  /**
   * display Label on panel, and places the marker on map
   *
   * @param {Object} oLocation - location Object
   * @private
   */
  _displayResultOfLabel: function _displayResultOfLabel(oLocation) {
    // FIXME Le service est intérrogé en SRS EPSG:4326 par defaut,
    // donc on récupère du lat/lon en reponse.
    // mais on inverse car on souhaite transmettre des coordonnées en lon/lat...
    // FIXME on construit une addresse car l'option freeForm ne semble pas
    // être fonctionnelle...
    // Par defaut, on doit être sur du type 'StreetAddress' par defaut.
    var places = oLocation.placeAttributes;
    var label = places.number + " " + places.street + ", " + places.postalCode + " " + places.commune; // on transmet les coordonnées au panneau,
    // même si on ne les affiche pas...

    this._setCoordinate({
      lat: oLocation.position.x,
      lng: oLocation.position.y
    }); // on transmet le texte au panneau


    this._setLabel(label); // on met en place le marker


    this._setMarker({
      x: oLocation.position.y,
      // LON
      y: oLocation.position.x // LAT

    }, null, false);

    this._inputShowPointerContainer.checked = false;
    this._inputAutoCompleteContainer.className = "GPlocationOriginVisible";
    this._inputCoordinateContainer.className = "GPlocationOriginHidden"; // on desactive l'event sur la map en activant le gestionnaire !

    this.onActivateMapPointClick();
  },
  // ################################################################### //
  // ###################### handlers events (dom) ###################### //
  // ################################################################### //

  /**
   * this method is called by event 'keyup' on 'GPLocationOrigin' tag input
   * (cf. this.), and it gets the value of input.
   * this value is passed as a parameter for the service autocomplete (text).
   * the results of the request are displayed into a drop down menu.
   * FIXME
   *
   * @param {Object} e - HTMLElement
   *
   * @private
   */
  onAutoCompleteSearchText: function onAutoCompleteSearchText(e) {
    logger.log("onAutoCompleteSearchText()", e);
    var value = e.target.value;

    if (!value) {
      return;
    } // aucun droits !
    // on evite une requête...


    if (this._noRightManagement) {
      logger.log("no rights for this service !?");
      return;
    } // on sauvegarde le localisant


    this._currentLocation = value; // on limite les requêtes à partir de 3 car. saisie !

    if (value.length < 3) {
      return;
    } // INFORMATION
    // on effectue la requête au service d'autocompletion.
    // on met en place des callbacks afin de recuperer les resultats ou
    // les messages d'erreurs du service.
    // les resultats sont affichés dans une liste deroulante.


    var context = this;

    this._requestAutoComplete({
      text: value,
      maximumResponses: 5,
      // FIXME je limite le nombre de reponse car le container DOM est limité dans l'affichage !!!
      // callback onSuccess
      onSuccess: function onSuccess(results) {
        logger.log(results);

        if (results) {
          var locations = results.suggestedLocations;

          context._fillAutoCompletedLocationListContainer(locations);
        }
      },
      // callback onFailure
      onFailure: function onFailure(error) {
        // FIXME
        // où affiche t on les messages : ex. 'No suggestion matching the search' ?
        // doit on nettoyer la liste des suggestions dernierement enregistrée :
        context._clearSuggestedLocation();

        logger.log(error.message);
      }
    });
  },

  /**
   * this method is called by event 'click' on 'GPautoCompleteResultsList' tag div
   * (cf. this._createAutoCompleteListElement), and it selects the location.
   * this location displays a marker on the map.
   * FIXME
   * TODO
   *
   * @param {Object} e - HTMLElement
   *
   * @private
   */
  onAutoCompletedResultsItemClick: function onAutoCompletedResultsItemClick(e) {
    logger.log("onAutoCompletedResultsItemClick()", e);
    var idx = _Common_Utils_SelectorID__WEBPACK_IMPORTED_MODULE_4__["default"].index(e.target.id);
    logger.log(idx);
    logger.log(this._suggestedLocations[idx]);

    if (!idx) {
      return;
    }

    var position = {
      x: this._suggestedLocations[idx].position.x,
      // LON !
      y: this._suggestedLocations[idx].position.y // LAT !

    };
    var info = {
      type: this._suggestedLocations[idx].type,
      fields: this._suggestedLocations[idx]
    };
    var label = this._suggestedLocations[idx].fullText;

    this._setLabel(label);

    this._setPosition(position);

    this._setMarker(position, info, this.options.displayInfo); // on sauvegarde le point courant


    this._coordinate = position;
  },

  /**
   * this method is called by event 'click' on '' tag input
   * (cf. this.), and it create or remove the event of click map.
   *
   * @param {Object} e - HTMLElement
   *
   * @private
   */
  onActivateMapPointClick: function onActivateMapPointClick(e) {
    logger.trace("onActivateMapPointClick()", e);
    var map = this._map;

    if (this._inputShowPointerContainer.checked) {
      if (!this._activeDragAndDrop) {
        map.on("click", this.onMouseMapClick, this); // on change le curseur

        this._setCursor("crosshair"); // on supprime le marker


        this._setMarker(); // on efface l'ancien resultat


        this._clearResults();
      }
    } else {
      if (!this._activeDragAndDrop) {
        map.off("click", this.onMouseMapClick, this); // on retablie le curseur d'origine

        this._setCursor();
      }
    }
  },

  /**
   * this method is called by event 'click' on '(n)' tag label
   * (cf. this.).
   * this point is erased.
   *
   * @param {Object} e - HTMLElement
   *
   * @private
   */
  onLocationClearPointClick: function onLocationClearPointClick(e) {
    logger.log("onLocationClearPointClick", e);

    this._setCursor();

    this._setMarker();

    this._clearResults();

    this._inputAutoCompleteContainer.focus();
  },

  /**
   * this method is called by event 'click' on '(n)' tag input
   * (cf. this.).
   * this point is deleted.
   *
   * @param {Object} e - HTMLElement
   *
   * @private
   */
  onLocationRemovePointClick: function onLocationRemovePointClick(e) {
    logger.log("onLocationRemovePointClick", e);

    this._setCursor();

    this._setMarker();

    this._clearResults();
  },

  /**
   * TODO this method is called by event 'click' on '(n)' tag input
   * (cf. this.).
   * this point is added as a parameter for the service Location.
   *
   * @param {Object} e - HTMLElement
   *
   * @private
   */
  onLocationAddPointClick: function onLocationAddPointClick(e) {
    logger.log("onLocationAddPointClick", e);
  },
  // ################################################################### //
  // #################### handlers events (control) #################### //
  // ################################################################### //

  /**
   * this method is called by event 'click' on map
   * (cf. this.onLocationMapPointClick), and it gets the coordinate of click on map.
   * this point is saved as a parameter for the service Location.
   *
   * @param {Object} e - HTMLElement
   *
   * @private
   */
  onMouseMapClick: function onMouseMapClick(e) {
    logger.log("onMouseMapClick", e); // les coordonnées

    var oLatLng = e.latlng; // si le geocodage inverse est desactivé,
    // on transmet les coordonnées au panneau,
    // sinon, on transmet la reponse du service

    if (this.options.disableReverse || this._noRightManagement) {
      // on transmet les coordonnées au panneau, puis on place le marker
      this._displayResultOfCoordinate(oLatLng);
    } else {
      // contexte
      var self = this; // on realise une requête au service, si la reponse est vide ou
      // en échec, on transmet les coordonnées !

      this._requestReverseGeocode({
        position: {
          x: oLatLng.lat,
          // on envoie X->LAT à l'API service IGN car on spécifie EPSG:4326
          y: oLatLng.lng // on envoie Y->LON à l'API service IGN car on spécifie EPSG:4326

        },
        srs: "EPSG:4326",
        // callback onSuccess
        onSuccess: function onSuccess(results) {
          logger.log(results);

          if (results.locations.length !== 0) {
            var oLocation = results.locations[0];

            self._displayResultOfLabel(oLocation);
          } else {
            self._displayResultOfCoordinate(oLatLng);
          }
        },
        // callback onFailure
        onFailure: function onFailure(error) {
          logger.log(error.message);

          self._displayResultOfCoordinate(oLatLng);
        }
      });
    }
  },

  /**
   * this method is called by event 'startdrag' on marker
   * and it initializes the drag&drop.
   *
   * @private
   */
  onStartDragMarker: function onStartDragMarker() {
    if (!this._marker) {
      return;
    }

    this._activeDragAndDrop = true;
    this._inputShowPointerContainer.checked = true;
    this._inputAutoCompleteContainer.className = "GPlocationOriginHidden";
    this._inputCoordinateContainer.className = "GPlocationOriginVisible";

    this._marker.unbindPopup();

    this._setLabel();

    this._clearResults();
  },

  /**
   * this method is called by event 'drag' on marker
   * and it updates the panel of coordinate.
   *
   * @private
   */
  onDragMarker: function onDragMarker() {
    if (!this._marker) {
      return;
    }

    this._activeDragAndDrop = false;
    this._inputShowPointerContainer.checked = true; // on transmet les coordonnées au panneau

    var oLatLng = this._marker.getLatLng();

    this._setCoordinate(oLatLng);
  },

  /**
   * this method is called by event 'enddrag' on marker
   * and it finishes the drag&drop.
   * this point is saved as a parameter for the service Location.
   *
   * @private
   */
  onEndDragMarker: function onEndDragMarker() {
    if (!this._marker) {
      return;
    }

    this._inputShowPointerContainer.checked = true;

    var oLatLng = this._marker.getLatLng();

    if (this._pressedKeyOnDragAndDrop) {
      // on transmet les coordonnées au panneau
      this._setCoordinate(oLatLng);
    } else {
      logger.log("No key pressed, so autocomplete solution !");
      this.onMouseMapClick({
        latlng: oLatLng
      });
    } // init


    this._activeDragAndDrop = false;
    this._pressedKeyOnDragAndDrop = false;
  },

  /**
   * this method is called by event 'mousedown' on marker..
   * this event gets the pressed key code.
   *
   * @param {Object} e - HTMLElement
   *
   * @private
   */
  onMouseDownMarker: function onMouseDownMarker(e) {
    if (!this._marker) {
      return;
    }

    this._pressedKeyOnDragAndDrop = e.originalEvent.ctrlKey;
  }
});
/* harmony default export */ __webpack_exports__["default"] = (LocationSelector);

/***/ }),
/* 143 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Utils_SelectorID__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36);
/* harmony import */ var _Common_Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(34);


var logger = _Common_Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_1__["default"].getLogger("LocationSelectorDOM");
var LocationSelectorDOM = {
  /**
  * Add uuid to the tag ID
  * @param {String} id - id selector
  * @returns {String} uid - id selector with an unique id
  */
  _addUID: function _addUID(id) {
    var uid = this._uid ? id + "-" + this._uid : id;
    return uid;
  },

  /**
   * Main container (DOM)
   *
   * @returns {DOMElement} DOM element
   */
  _createMainContainerElement: function _createMainContainerElement() {
    var container = document.createElement("div");
    container.className = this._addUID("GPlocationPoint"); // ceci permet de gerer les groupes de points !

    container.className += " GPwidget";
    return container;
  },

  /**
   * Create Container Point
   * see event !
   *
   * @param {Number} id - tag ID
   * @param {Number} display  - display
   * @returns {DOMElement} DOM element
   */
  _createLocationPointElement: function _createLocationPointElement(id, display) {
    var div = document.createElement("div");
    div.id = this._addUID("GPlocationPoint_" + id);
    div.className = display ? "GPflexInput GPlocationStageFlexInput" : "GPflexInput GPlocationStageFlexInputHidden";
    div.style.cssText = "";
    return div;
  },

  /**
   * Create Container Point
   * see event !
   *
   * @param {Number} id - tag ID
   * @param {String} text - label
   * @returns {DOMElement} DOM element
   */
  _createLocationPointLabelElement: function _createLocationPointLabelElement(id, text) {
    // contexte d'execution
    var self = this;
    var labelOrigin = document.createElement("label");
    labelOrigin.id = this._addUID("GPlocationOriginLabel_" + id);
    labelOrigin.htmlFor = "GPlocationOrigin_" + id;
    labelOrigin.innerHTML = text;
    labelOrigin.addEventListener("click", function (e) {
      var i = _Utils_SelectorID__WEBPACK_IMPORTED_MODULE_0__["default"].index(this.id);
      var points = document.getElementsByClassName(self._addUID("GPlocationPoint"));

      for (var j = 0; j < points.length; j++) {
        var tag = points[j].childNodes[0].id;
        var id = _Utils_SelectorID__WEBPACK_IMPORTED_MODULE_0__["default"].index(tag);
        document.getElementById(self._addUID("GPlocationPoint_" + id)).style.cssText = "";
      }

      document.getElementById(self._addUID("GPlocationOriginCoords_" + i)).value = "";
      document.getElementById(self._addUID("GPlocationOrigin_" + i)).value = "";
      document.getElementById(self._addUID("GPlocationPoint_" + i)).style.cssText = "";
      document.getElementById(self._addUID("GPlocationOriginPointer_" + i)).checked = false;
      document.getElementById(self._addUID("GPlocationOrigin_" + i)).className = "GPlocationOriginVisible";
      document.getElementById(self._addUID("GPlocationOriginCoords_" + i)).className = "GPlocationOriginHidden";

      if (document.getElementById(self._addUID("GPlocationStageRemove_" + i))) {
        document.getElementById(self._addUID("GPlocationStageRemove_" + i)).className = "GPlocationStageRemove";
      }

      if (document.getElementById(self._addUID("GPlocationStageAdd"))) {
        document.getElementById(self._addUID("GPlocationStageAdd")).className = "";
      } // document.getElementById(self._addUID("GPlocationOriginCoords_" + i)).disabled = true;


      self.onLocationClearPointClick(e);
    });
    return labelOrigin;
  },

  /**
   * Create Input AutoComplete Point tag
   *
   * @param {Number} id - tag ID
   * @returns {DOMElement} DOM element
   */
  _createLocationAutoCompleteteInputElement: function _createLocationAutoCompleteteInputElement(id) {
    // contexte d'execution
    var self = this;
    var inputOrigin = document.createElement("input");
    inputOrigin.id = this._addUID("GPlocationOrigin_" + id);
    inputOrigin.className = "GPlocationOriginVisible";
    inputOrigin.type = "text";
    inputOrigin.placeholder = "Saisir une adresse";
    inputOrigin.autocomplete = "off";
    inputOrigin.addEventListener("keyup", function (e) {
      var charCode = e.which || e.keyCode;

      if (charCode === 13 || charCode === 10 || charCode === 38 || charCode === 40) {
        return;
      }

      var i = _Utils_SelectorID__WEBPACK_IMPORTED_MODULE_0__["default"].index(this.id);

      if (document.getElementById(self._addUID("GPlocationOrigin_" + i)).value.length > 2) {
        document.getElementById(self._addUID("GPlocationAutoCompleteList_" + i)).style.display = "block";
      } else {
        document.getElementById(self._addUID("GPlocationAutoCompleteList_" + i)).style.display = "none";
      } // gestionnaire d'evenement :
      // on récupère la valeur de saisie pour une requête sur le service d'autocompletion.
      // le resultat de la requête nous permet de recuperer les coordonnées du point...


      self.onAutoCompleteSearchText(e);
    });
    inputOrigin.addEventListener("keydown", function (e) {
      var charCode = e.which || e.keyCode;
      var container = document.getElementById(self._addUID("GPlocationAutoCompleteList_" + id)); // si aucun container !?

      if (!container) {
        return;
      }

      var curr = container.getElementsByClassName("GPautoCompleteProposal current");
      var list = container.getElementsByClassName("GPautoCompleteProposal"); // si aucune suggestion, on ne va pas plus loin !

      var length = list.length;

      if (!length) {
        return;
      }

      var current = null; // si aucun item courant, on prend le 1er !

      if (!curr.length) {
        current = list[0];
        current.className = "GPautoCompleteProposal current";
        current.style.color = "#000000";
        current.style["background-color"] = "#CEDBEF";
        return;
      } else {
        current = curr[0];
      }

      var index = parseInt(_Utils_SelectorID__WEBPACK_IMPORTED_MODULE_0__["default"].index(current.id), 10);
      var next = index === length - 1 ? list[0] : list[index + 1];
      var prev = index === 0 ? list[length - 1] : list[index - 1];
      current.style["background-color"] = "";
      current.style.color = "";
      prev.style["background-color"] = "";
      prev.style.color = "";
      next.style["background-color"] = "";
      next.style.color = "";

      switch (charCode) {
        case 38:
          // arrow up
          logger.log("arrow up");
          current.className = "GPautoCompleteProposal";
          prev.className = "GPautoCompleteProposal current";
          prev.style.color = "#000000";
          prev.style["background-color"] = "#CEDBEF";
          break;

        case 40:
          // arrow down
          logger.log("arrow down");
          current.className = "GPautoCompleteProposal";
          next.className = "GPautoCompleteProposal current";
          next.style.color = "#000000";
          next.style["background-color"] = "#CEDBEF";
          break;

        case 13:
          // enter
          logger.log("enter");
          current.click(e);
          break;
      }

      current.focus();
    });
    return inputOrigin;
  },

  /**
   * Create Input Coordinate Point tag
   *
   * @param {Number} id - tag ID
   * @returns {DOMElement} DOM element
   */
  _createLocationCoordinateInputElement: function _createLocationCoordinateInputElement(id) {
    // contexte d'execution
    var self = this;
    var inputOriginCoord = document.createElement("input");
    inputOriginCoord.id = this._addUID("GPlocationOriginCoords_" + id);
    inputOriginCoord.className = "GPlocationOriginHidden";
    inputOriginCoord.type = "text";
    inputOriginCoord.disabled = false;
    inputOriginCoord.addEventListener("click", function () {
      var i = _Utils_SelectorID__WEBPACK_IMPORTED_MODULE_0__["default"].index(this.id);
      document.getElementById(self._addUID("GPlocationOriginLabel_" + i)).click();
    });
    return inputOriginCoord;
  },

  /**
   * Create Show Pointer tag
   *
   * @param {Number} id - tag ID
   * @returns {DOMElement} DOM element
   */
  _createLocationPointerShowInputElement: function _createLocationPointerShowInputElement(id) {
    var inputOriginPointer = document.createElement("input");
    inputOriginPointer.id = this._addUID("GPlocationOriginPointer_" + id);
    inputOriginPointer.type = "checkbox";
    return inputOriginPointer;
  },

  /**
   * Create Input Pointer tag
   *
   * @param {Number} id - tag ID
   * @returns {DOMElement} DOM element
   */
  _createLocationPointerInputElement: function _createLocationPointerInputElement(id) {
    // contexte d'execution
    var self = this;
    var labelOriginPointer = document.createElement("label");
    labelOriginPointer.id = this._addUID("GPlocationOriginPointerImg_" + id);
    labelOriginPointer.htmlFor = "GPlocationOriginPointer_" + id;
    labelOriginPointer.className = "GPlocationOriginPointerImg";
    labelOriginPointer.title = "Pointer un lieu sur la carte";
    labelOriginPointer.addEventListener("click", function (e) {
      e.preventDefault();
      e.stopPropagation();
      var i = _Utils_SelectorID__WEBPACK_IMPORTED_MODULE_0__["default"].index(this.id);
      var points = document.getElementsByClassName(self._addUID("GPlocationPoint"));
      var j;
      var tag;
      var id;

      for (j = 0; j < points.length; j++) {
        tag = points[j].childNodes[0].id;
        id = _Utils_SelectorID__WEBPACK_IMPORTED_MODULE_0__["default"].index(tag);

        if (i !== id) {
          document.getElementById(self._addUID("GPlocationOriginPointer_" + id)).checked = false;

          if (document.getElementById(self._addUID("GPlocationOriginCoords_" + id)).value === "Pointer un lieu sur la carte") {
            document.getElementById(self._addUID("GPlocationOriginCoords_" + id)).value = "";
            document.getElementById(self._addUID("GPlocationOrigin_" + id)).className = "GPlocationOriginVisible";
            document.getElementById(self._addUID("GPlocationOriginCoords_" + id)).className = "GPlocationOriginHidden";
          }
        }
      }

      if (document.getElementById(self._addUID("GPlocationOriginPointer_" + i)).checked) {
        document.getElementById(self._addUID("GPlocationOriginCoords_" + i)).value = "";

        for (j = 0; j < points.length; j++) {
          tag = points[j].childNodes[0].id;
          id = _Utils_SelectorID__WEBPACK_IMPORTED_MODULE_0__["default"].index(tag);
          document.getElementById(self._addUID("GPlocationPoint_" + id)).style.cssText = "";
        }

        if (document.getElementById(self._addUID("GPlocationStageRemove_" + i))) {
          document.getElementById(self._addUID("GPlocationStageRemove_" + i)).className = "GPlocationStageRemove";
        }

        if (document.getElementById(self._addUID("GPlocationStageAdd"))) {
          document.getElementById(self._addUID("GPlocationStageAdd")).className = "";
        }

        document.getElementById(self._addUID("GPlocationOriginPointer_" + i)).checked = false;
        document.getElementById(self._addUID("GPlocationOrigin_" + i)).className = "GPlocationOriginVisible";
        document.getElementById(self._addUID("GPlocationOriginCoords_" + i)).className = "GPlocationOriginHidden";
      } else {
        document.getElementById(self._addUID("GPlocationOriginCoords_" + i)).value = "Pointer un lieu sur la carte";

        for (j = 0; j < points.length; j++) {
          tag = points[j].childNodes[0].id;
          id = _Utils_SelectorID__WEBPACK_IMPORTED_MODULE_0__["default"].index(tag);

          if (i === id) {
            document.getElementById(self._addUID("GPlocationPoint_" + id)).style.cssText = "";
          } else {
            document.getElementById(self._addUID("GPlocationPoint_" + id)).style.display = "none";
          }
        }

        if (document.getElementById(self._addUID("GPlocationStageRemove_" + i))) {
          document.getElementById(self._addUID("GPlocationStageRemove_" + i)).className = "GPlocationOriginHidden";
        }

        if (document.getElementById(self._addUID("GPlocationStageAdd"))) {
          document.getElementById(self._addUID("GPlocationStageAdd")).className = "GPlocationOriginHidden";
        }

        document.getElementById(self._addUID("GPlocationOriginPointer_" + i)).checked = true;
        document.getElementById(self._addUID("GPlocationOrigin_" + i)).className = "GPlocationOriginHidden";
        document.getElementById(self._addUID("GPlocationOriginCoords_" + i)).className = "GPlocationOriginVisible";
        document.getElementById(self._addUID("GPlocationOriginCoords_" + i)).disabled = true;
      } // gestionnaire d'evenement :
      // on stocke la valeur du point, utilisée pour la requête sur le service de calcul d'itiniraire


      self.onActivateMapPointClick(e);
    });
    return labelOriginPointer;
  },

  /**
   * Create Remove Point tag
   * see event !
   *
   * @param {Number} id - tag ID
   * @returns {DOMElement} DOM element
   */
  _createLocationRemovePointElement: function _createLocationRemovePointElement(id) {
    // contexte d'execution
    var self = this;
    var divRm = document.createElement("div");
    divRm.id = this._addUID("GPlocationStageRemove_" + id);
    divRm.className = "GPlocationStageRemove";
    divRm.title = "Supprimer l'étape";
    divRm.addEventListener("click", function (e) {
      var points = document.getElementsByClassName(self._addUID("GPlocationPoint"));
      var last = points.length - 1;
      var start = points[0].childNodes[0].id;
      var end = points[last].childNodes[0].id;
      var startID = _Utils_SelectorID__WEBPACK_IMPORTED_MODULE_0__["default"].index(start);
      var endID = _Utils_SelectorID__WEBPACK_IMPORTED_MODULE_0__["default"].index(end);

      if (id !== startID && id !== endID) {
        var i = _Utils_SelectorID__WEBPACK_IMPORTED_MODULE_0__["default"].index(this.id);
        document.getElementById(self._addUID("GPlocationPoint_" + i)).className = "GPflexInput GPlocationStageFlexInputHidden";
        document.getElementById(self._addUID("GPlocationOrigin_" + i)).value = "";
        document.getElementById(self._addUID("GPlocationOrigin_" + i)).className = "GPlocationOriginVisible";
        document.getElementById(self._addUID("GPlocationOriginCoords_" + i)).value = "";
        document.getElementById(self._addUID("GPlocationOriginCoords_" + i)).className = "GPlocationOriginHidden";
        document.getElementById(self._addUID("GPlocationStageAdd")).style.display = ""; // Moving up exclusions picto
        // var exclusionsPictoTop = document.getElementById(self._addUID("GPshowLocationExclusionsPicto")).style.top;
        // document.getElementById(self._addUID("GPshowLocationExclusionsPicto")).style.top = (parseInt(exclusionsPictoTop) - 33).toString() + "px";
        // gestionnaire d'evenement :
        // on supprime le point, utilisé pour la requête sur le service d'itiniraire

        self.onLocationRemovePointClick(e);
      }
    });
    return divRm;
  },

  /**
   * Create Add Point tag
   * see event !
   *
   * @returns {DOMElement} DOM element
   */
  _createLocationAddPointElement: function _createLocationAddPointElement() {
    // contexte d'execution
    var self = this;
    var divAdd = document.createElement("div");
    divAdd.id = this._addUID("GPlocationStageAdd");
    divAdd.title = "Ajouter une étape";
    divAdd.addEventListener("click", function (e) {
      var lastStage = 1;
      var nbStages = 0;
      var points = document.getElementsByClassName(self._addUID("GPlocationPoint"));

      for (var i = 1; i < points.length - 1; i++) {
        var tag = points[i].childNodes[0].id;
        var id = _Utils_SelectorID__WEBPACK_IMPORTED_MODULE_0__["default"].index(tag);

        if (document.getElementById(self._addUID("GPlocationPoint_" + id))) {
          if (document.getElementById(self._addUID("GPlocationPoint_" + id)).className === "GPflexInput GPlocationStageFlexInputHidden") {
            if (lastStage === 1) {
              lastStage = id;
            }
          } else {
            nbStages++;
          }
        }
      } // FIXME algo à revoir : lastStage = id hors si id = 300 sur 3 points !?


      if (lastStage < points.length) {
        document.getElementById(self._addUID("GPlocationPoint_" + lastStage)).className = "GPflexInput GPlocationStageFlexInput"; // Moving down exclusions picto
        // var exclusionsPictoTop = document.getElementById(self._addUID("GPshowLocationExclusionsPicto")).style.top;
        // document.getElementById(self._addUID("GPshowLocationExclusionsPicto")).style.top = (parseInt(exclusionsPictoTop) + 33).toString() + "px";
      }

      if (nbStages === 4) {
        document.getElementById(self._addUID("GPlocationStageAdd")).style.display = "none";
      } // gestionnaire d'evenement :
      // on ajoute le point, utilisé pour la requête sur le service d'itiniraire


      self.onLocationAddPointClick(e);
    });
    return divAdd;
  },

  /**
   * Create Results autocompletion to the point
   * see event!
   *
   * @param {Number} id - tag ID
   * @returns {DOMElement} DOM element
   */
  _createLocationAutoCompleteResultElement: function _createLocationAutoCompleteResultElement(id) {
    // contexte d'execution
    var self = this;
    var div = document.createElement("div");
    div.id = this._addUID("GPlocationAutoCompleteList_" + id);
    div.className = "GPadvancedAutoCompleteList";

    if (div.addEventListener) {
      div.addEventListener("click", function (e) {
        self.onAutoCompletedResultsItemClick(e);
        document.getElementById(self._addUID("GPlocationAutoCompleteList_" + id)).style.display = "none";
      }, false);
    } else if (div.attachEvent) {
      div.attachEvent("onclick", function (e) {
        self.onAutoCompletedResultsItemClick(e);
        document.getElementById(self._addUID("GPlocationAutoCompleteList_" + id)).style.display = "none";
      });
    }

    return div;
  },

  /**
   * Autocompletion result to a point.
   * Proposals are dynamically filled in Javascript by autocomplete service
   *
   * TODO formaliser le contenu des reponse
   *
   * @param {Number} id - tag ID
   * @param {Object} location - suggested location result
   * @param {Number} n  - number of the point
   */
  _createLocationAutoCompletedLocationElement: function _createLocationAutoCompletedLocationElement(id, location, n) {
    var container = document.getElementById(this._addUID("GPlocationAutoCompleteList_" + id));
    var div = document.createElement("div");
    div.id = this._addUID("AutoCompletedLocation_" + n);
    div.className = "GPautoCompleteProposal";
    div.innerHTML = location.fullText;
    container.appendChild(div);
  },

  /**
  * Display Coordinate
  * @param {String} value - a Coordinate
  */
  GPdisplayCoordinate: function GPdisplayCoordinate(value) {
    var points = document.getElementsByClassName(this._addUID("GPlocationPoint"));

    for (var i = 0; i < points.length; i++) {
      var tag = points[i].childNodes[0].id;
      var id1 = _Utils_SelectorID__WEBPACK_IMPORTED_MODULE_0__["default"].index(tag);

      if (document.getElementById(this._addUID("GPlocationOriginPointer_" + id1)).checked) {
        document.getElementById(this._addUID("GPlocationOriginCoords_" + id1)).value = value;
        document.getElementById(this._addUID("GPlocationOriginCoords_" + id1)).disabled = false;

        for (var j = 0; j < points.length; j++) {
          tag = points[j].childNodes[0].id;
          var id2 = _Utils_SelectorID__WEBPACK_IMPORTED_MODULE_0__["default"].index(tag);
          document.getElementById(this._addUID("GPlocationPoint_" + id2)).style.cssText = "";

          if (document.getElementById(this._addUID("GPlocationStageRemove_" + id2))) {
            document.getElementById(this._addUID("GPlocationStageRemove_" + id2)).className = "GPlocationStageRemove";
          }
        }

        document.getElementById(this._addUID("GPlocationOriginPointer_" + id1)).checked = false;

        if (document.getElementById(this._addUID("GPlocationStageAdd"))) {
          document.getElementById(this._addUID("GPlocationStageAdd")).className = "";
        }

        return;
      }
    }
  }
};
/* harmony default export */ __webpack_exports__["default"] = (LocationSelectorDOM);

/***/ }),
/* 144 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/**
* implementation :
* cf. http://uihacker.blogspot.fr/2011/07/javascript-formatting-latitudelongitude.html?m=1
* cf. http://andrew.hedges.name/experiments/convert_lat_long/
* FIXME formater la sortie
* cf. http://mottie.github.io/javascript-number-formatter/
* cf. https://github.com/j-/number-formatter
*
*/

/** ... */
var PositionFormater = {
  /** ... */
  NORTH: "N",

  /** ... */
  SOUTH: "S",

  /** ... */
  EAST: "E",

  /** ... */
  WEST: "O",

  /** ... */
  digitSecond: 2,

  /** ... */
  digitDecimal: 5,

  /** ... */
  digitRadian: 8,

  /**
   * @param {Number} inputNum -inputNum
   * @param {Integer} numPoints - numPoints
   *
   * @returns {Number} rounded result
   */
  roundToDecimal: function roundToDecimal(inputNum, numPoints) {
    var multiplier = Math.pow(10, numPoints);
    return Math.round(inputNum * multiplier) / multiplier;
  },

  /**
   * @param {Number} location -location
   *
   * @returns {Number} location in radian
   */
  decimalToRadian: function decimalToRadian(location) {
    var d = 0.01745329251994329577;
    return this.roundToDecimal(location * d, this.digitRadian);
  },

  /**
   * @param {Number} location -location
   *
   * @returns {Number} location in grade
   */
  decimalToGrade: function decimalToGrade(location) {
    var d = 1.11111111111111111111;
    return this.roundToDecimal(location * d, this.digitRadian);
  },

  /**
   * @param {Number} location -location
   * @param {String} hemisphere -hemisphere
   * @param {Boolean} obj -specifies if an object must be returned
   *
   * @returns {String|Object} DMS (String or Object depending on obj parameter value)
   */
  decimalToDMS: function decimalToDMS(location, hemisphere, obj) {
    if (location < 0) {
      location *= -1; // strip dash '-'
    }

    var degrees = Math.floor(location); // strip decimal remainer for degrees

    var minutesFromRemainder = (location - degrees) * 60; // multiply the remainer by 60

    var minutes = Math.floor(minutesFromRemainder); // get minutes from integer

    var secondsFromRemainder = (minutesFromRemainder - minutes) * 60; // multiply the remainer by 60

    var seconds = this.roundToDecimal(secondsFromRemainder, this.digitSecond); // get minutes by rounding to integer

    var dms = degrees + "° " + minutes + "' " + seconds + "\" ";

    if (hemisphere) {
      dms += hemisphere;
    }

    if (obj) {
      return {
        d: degrees,
        m: minutes,
        s: seconds,
        direction: hemisphere
      };
    }

    return dms;
  },

  /**
   * @param {Number} location -location
   * @param {Boolean} obj -specifies if an object must be returned
   *
   * @returns {String|Object} DMS (String or Object depending on obj parameter value)
   */
  decimalLatToDMS: function decimalLatToDMS(location, obj) {
    var hemisphere = location < 0 ? this.SOUTH : this.NORTH; // south if negative

    return this.decimalToDMS(location, hemisphere, obj);
  },

  /**
   * @param {Number} location -location
   * @param {Boolean} obj -specifies if an object must be returned
   *
   * @returns {String|Object} DMS (String or Object depending on obj parameter value)
   */
  decimalLonToDMS: function decimalLonToDMS(location, obj) {
    var hemisphere = location < 0 ? this.WEST : this.EAST; // west if negative

    return this.decimalToDMS(location, hemisphere, obj);
  },

  /**
   * @param {Number} degrees -degrees
   * @param {Number} minutes -minutes
   * @param {Number} seconds -seconds
   * @param {String} hemisphere -hemisphere
   *
   * @returns {Number} decimal
   */
  DMSToDecimal: function DMSToDecimal(degrees, minutes, seconds, hemisphere) {
    var ddVal = degrees + minutes / 60 + seconds / 3600;
    ddVal = hemisphere === this.SOUTH || hemisphere === this.WEST ? ddVal * -1 : ddVal;
    var decimal = this.roundToDecimal(ddVal, this.digitDecimal);
    return decimal;
  }
};
/* harmony default export */ __webpack_exports__["default"] = (PositionFormater);

/***/ }),
/* 145 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2);
/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Common_Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(34);


var logger = _Common_Utils_LoggerByDefault__WEBPACK_IMPORTED_MODULE_1__["default"].getLogger("icondefault");
/**  cf. http://leafletjs.com/reference.html#icon */

var IconDefault = leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.Icon.Default.extend(
/** @lends IconDefault.prototype */
{
  /**
  * Liste des icones
  *   TODO : image retina à convertir en x2...
  */
  images: {
    retina: {
      shadow: "data:image/png;base64,...",
      color: {
        blue: "data:image/png;base64,...",
        orange: "data:image/png;base64,...",
        red: "data:image/png;base64,...",
        green: "data:image/png;base64,..."
      }
    },
    shadow: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACkAAAApCAYAAACoYAD2AAAC5ElEQVRYw+2YW4/TMBCF45S0S1luXZCABy5CgLQgwf//S4BYBLTdJLax0fFqmB07nnQfEGqkIydpVH85M+NLjPe++dcPc4Q8Qh4hj5D/AaQJx6H/4TMwB0PeBNwU7EGQAmAtsNfAzoZkgIa0ZgLMa4Aj6CxIAsjhjOCoL5z7Glg1JAOkaicgvQBXuncwJAWjksLtBTWZe04CnYRktUGdilALppZBOgHGZcBzL6OClABvMSVIzyBjazOgrvACf1ydC5mguqAVg6RhdkSWQFj2uxfaq/BrIZOLEWgZdALIDvcMcZLD8ZbLC9de4yR1sYMi4G20S4Q/PWeJYxTOZn5zJXANZHIxAd4JWhPIloTJZhzMQduM89WQ3MUVAE/RnhAXpTycqys3NZALOBbB7kFrgLesQl2h45Fcj8L1tTSohUwuxhy8H/Qg6K7gIs+3kkaigQCOcyEXCHN07wyQazhrmIulvKMQAwMcmLNqyCVyMAI+BuxSMeTk3OPikLY2J1uE+VHQk6ANrhds+tNARqBeaGc72cK550FP4WhXmFmcMGhTwAR1ifOe3EvPqIegFmF+C8gVy0OfAaWQPMR7gF1OQKqGoBjq90HPMP01BUjPOqGFksC4emE48tWQAH0YmvOgF3DST6xieJgHAWxPAHMuNhrImIdvoNOKNWIOcE+UXE0pYAnkX6uhWsgVXDxHdTfCmrEEmMB2zMFimLVOtiiajxiGWrbU52EeCdyOwPEQD8LqyPH9Ti2kgYMf4OhSKB7qYILbBv3CuVTJ11Y80oaseiMWOONc/Y7kJYe0xL2f0BaiFTxknHO5HaMGMublKwxFGzYdWsBF174H/QDknhTHmHHN39iWFnkZx8lPyM8WHfYELmlLKtgWNmFNzQcC1b47gJ4hL19i7o65dhH0Negbca8vONZoP7doIeOC9zXm8RjuL0Gf4d4OYaU5ljo3GYiqzrWQHfJxA6ALhDpVKv9qYeZA8eM3EhfPSCmpuD0AAAAASUVORK5CYII=",
    color: {
      blue: "data:image/png;base64,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",
      orange: "data:image/png;base64,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",
      red: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABkAAAApCAYAAADAk4LOAAAABGdBTUEAALGPC/xhBQAAAAFzUkdCAK7OHOkAAAAgY0hSTQAAeiYAAICEAAD6AAAAgOgAAHUwAADqYAAAOpgAABdwnLpRPAAAAAZiS0dEAP8A/wD/oL2nkwAAAAlwSFlzAAAASAAAAEgARslrPgAABe5JREFUWMOdlWuIXGcZx3/nPbe5ZWbO2c0a8VIEpSq0io2QBT8FUlIFEbzfokUUKfgxIuSbn+JtYTEQqFQCQmkxVIiNFhcLwZoVtrFNt40ESrPEJju7s/eZM+f+Pn6Y2XVnZ3Zn0/fwcA7veZ/ze5//87zPMf56fJIHGB8Far3n20D79Nz1kU7GXw6G+MD3gdPAKdtxMJQFQJZEaK0bwBXg2Sfmrl87AHJi2LwJnAXOVf3xSrFcoVAuDyzKs4yw3SLY2iTqBC8BP31ibnZ+AHJ1MBIfeK7qeaeqno9l2+g4IQ86ILpvoXIczCMVAFob66wuLYXAmc/PXb/cB3nxsRN7AdfrY2MPe+Pj6Cjufnyk6Aa2XyfshLQ21glarae+8OrsxZ3N7JHoj3Xff9jzx8jWN8hbbdB6tOU5aXOVguNQ98YAfnv1+OTJHYgAPTt7pFY76Xk+2fo6kiSg8wEzLLMr25B32eoqjm0x8b5jpsBzLx6f9LsQARF8Ec7Vq1V0J0CSuM9ZFVxsr47t1RHHxq7XsL06Vq06AEqby5RLReq12lERzvbkEkC+VatWKpapyNtt6JERwfY9DMdmdW2NOwsLrCmDdxYWWFpaIopjbN/rarLLJw8C6rUqID/682MnTEsQgK9XSiV0nHQ17g2rViWOI95tLPOxJ89w4sx3sCvdarr3txnmf/kbqnFE3auTrqzu+OkgwC4WcAuuH0XRpBKhIsJkwbHJN9f79TcVG5tbPHruZ3z8qR/vAAA+8PgpPvf737Eehug8Rbn2gHQl10WE00rgw7ZtmdtVspMH2yKJY/TEBA996YsDVSsilD/0QR76ypfZ3GphFgp9AN3p4FgmAp9UIuIrQw2UpXJdwijGe+SRoQAArTXepz9FEEbdfOzylyxHddfWLEESLbpblrtPtM4AQafJvgARIY8iDMMY8DcM6a5BQiUY99I8H9hJHgSUHZvluVfRaToA2obc/8c/qbg2kqV9/oapyPIcwbinRKSRZnlb53l3R9vhRjGWAYV2i7cuXByIAmBx9l+sz8xQK7jkW1v9EKVI0hQRuWt+9dj7Bfhs0VSfKFZK6CDoq/lKucTya69x/+Y8pWPHcMd8Nu8s8M7lF5j/xa+ZKBVwTdWFbPsZBmaxwGIrINP6J8bzj34G4GTZcf7+kXqFtNns77SlMma5xEaUsBbGhFmGY5rUXBu/6GIpNeBjHz3KRpTw7lZ75ms3bzxudQXg5XaSzLbjZLI8Nka2srLrYLWRqEPdH6Pu2n0f050OaRD0l54yQIS1MELg5wDbEIBfrYbRCxW3MvDfkEyTLi+NavjdKMYn2Ixi2mn28jdu3nil1yCFnl3ZiNO3ozjtNb5DtPihbV+z2okRkfPDWn0uMLUSxhim9Z4AlufRThK20uzGN9/498wOhN0HUfSllShuZnmOKhXZ826kGYbBSicG0ed3S7g7EgRCgaebYYxZLvW/GWGW79HJM9bT7LbAn/oh/8/Jtk0vRkmotUY5zqGlMpSi2cvFt+dfz/dEYrDHmoLxh5Uwxjxy5FAAs1olynJWUn1XMJ7dW3FKGHpN3Y2yXEQwTDVSKuU6NKMEQaa+++brySBkUC5E5LaIXF2LE0zfR7Te11SpRJLlNJK8KSLPDDs76oA9Ti3H+UipVLHIUpggcOF7b73RHg4ZHgkicm0r17OtLMc6Oj5cpnKJXAv3U90Wken9uoAaUZzTS1GGIQxPeLFEI04RuPjkrfnN9wq5vKJ5OxTBrNb2JNtFFPw3lURg6qB+dpBciEguItONOEO5zkDZLoYpInLpB7fmGwdDRp/nS4sZzVQEVS6DCIZjIyIspOQC5xkx1O6/4D7WRuTpRpRhlkrdRlirsxRnIPL8D//z5p2RkH0O497rwt2cRBBUwQWExVwQZGQUPchAWxlmDcG41Eg0Zq1GM9EEoq4KxvyhIA/QaacXs+5z736+O3+YSEamZMduBaKuNFNhU9Q1EV6RwzEOnZOdxnk/7eZie+aQcj3QuLaJegZ46UGc/gcUeTtzDg/o4wAAACV0RVh0ZGF0ZTpjcmVhdGUAMjAxMi0wOC0xOFQxNDo1MDo1NiswMTowMBZQpF8AAAAldEVYdGRhdGU6bW9kaWZ5ADIwMTItMDgtMThUMTQ6NTA6NTYrMDE6MDBnDRzjAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAABJRU5ErkJggg==",
      green: "data:image/png;base64,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"
    }
  },

  /**
   * constructor
   * (extend to L.Icon.Default)
   *
   * @param {String} color - blue, green or red, blue by default.
   * @param {Object} options - options of L.Icon
   */
  initialize: function initialize(color, options) {
    // on merge les options avec celles par defaut
    leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.Util.extend(this.options, options);
    var _color = null;
    var _images =
    /* (L.Browser.retina) ? this.images.retina : */
    this.images;

    switch (color) {
      case "red":
        _color = _images.color.red;
        break;

      case "green":
        _color = _images.color.green;
        break;

      case "orange":
        _color = _images.color.orange;
        break;

      case "blue":
        _color = _images.color.blue;
        break;

      default:
        _color = _images.color.blue;
    } // icones classiques


    this.options.iconUrl = _color;
    this.options.shadowUrl = _images.shadow; // icones pour écran Retina

    if (leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.Browser.retina) {
      this.options.iconRetinaUrl = _color;
      this.options.shadowRetinaUrl = _images.shadow;
    }
  },

  /**
   * Overload function to ensure compatibility between versions 0.7.X and 1.0.X
   * (extend to L.Icon._getIconUrl)
   *
   * @param {String} name - name
   *
   * @returns {String} url
   *
   */
  _getIconUrl: function _getIconUrl(name) {
    logger.trace("OVERWRITTEN L.Icon.Default._getIconUrl(" + name + ")");
    return leaflet__WEBPACK_IMPORTED_MODULE_0___default.a.Icon.prototype._getIconUrl.call(this, name);
  }
});
/* harmony default export */ __webpack_exports__["default"] = (IconDefault);

/***/ }),
/* 146 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
var IsoDOM = {
  /**
  * Add uuid to the tag ID
  * @param {String} id - id selector
  * @returns {String} uid - id selector with an unique id
  */
  _addUID: function _addUID(id) {
    var uid = this._uid ? id + "-" + this._uid : id;
    return uid;
  },

  /**
   * Main container (DOM)
   *
   * @returns {DOMElement} DOM element
   */
  _createMainContainerElement: function _createMainContainerElement() {
    var container = document.createElement("div");
    container.id = this._addUID("GPisochron");
    container.className = "GPwidget";
    return container;
  },
  // ################################################################### //
  // ################# Methods to display Main Panel ################### //
  // ################################################################### //

  /**
   * Hidden checkbox for minimizing/maximizing panel
   *
   * @returns {DOMElement} DOM element
   */
  _createShowIsoElement: function _createShowIsoElement() {
    var input = document.createElement("input");
    input.id = this._addUID("GPshowIsochron");
    input.type = "checkbox";
    return input;
  },

  /**
   * Show iso control
   * see event !
   *
   * @returns {DOMElement} DOM element
   */
  _createShowIsoPictoElement: function _createShowIsoPictoElement() {
    // contexte d'execution
    var context = this;
    var label = document.createElement("label");
    label.id = this._addUID("GPshowIsochronPicto");
    label.className = "GPshowAdvancedToolPicto";
    label.htmlFor = this._addUID("GPshowIsochron");
    label.title = "Calculer une isochrone"; // gestionnaire d'evenement :
    // on ouvre le menu de saisie du calcul d'isochrone
    // L'ouverture/Fermeture permet de faire le menage
    // (reinitialisation)

    if (label.addEventListener) {
      label.addEventListener("click", function (e) {
        context.onShowIsoPanelClick(e);
      });
    } else if (label.attachEvent) {
      label.attachEvent("onclick", function (e) {
        context.onShowIsoPanelClick(e);
      });
    }

    var spanOpen = document.createElement("span");
    spanOpen.id = this._addUID("GPshowIsochronOpen");
    spanOpen.className = "GPshowAdvancedToolOpen";
    label.appendChild(spanOpen);
    return label;
  },
  // ################################################################### //
  // ################## Methods to display Inputs Panel ################ //
  // ################################################################### //

  /**
   * Create Container Panel
   *
   * FIXME
   * don't call this._createIsoPanelHeaderElement
   * don't call this._createIsoPanelFormElement
   *
   * @returns {DOMElement} DOM element
   */
  _createIsoPanelElement: function _createIsoPanelElement() {
    var div = document.createElement("div");
    div.id = this._addUID("GPisochronPanel");
    div.className = "GPpanel"; // div.appendChild(this._createIsoPanelHeaderElement());
    // div.appendChild(this._createIsoPanelFormElement());

    return div;
  },

  /**
   * Create Header Panel
   *
   * @returns {DOMElement} DOM element
   */
  _createIsoPanelHeaderElement: function _createIsoPanelHeaderElement() {
    var self = this;
    var container = document.createElement("div");
    container.className = "GPpanelHeader";
    var div = document.createElement("div");
    div.className = "GPpanelTitle";
    div.innerHTML = "Calcul d'isochrone";
    container.appendChild(div); // on desactive l'impl. reduction de la fenetre
    // var divReduce  = document.createElement("div");
    // divReduce.id = this._addUID("GPisochronPanelReduce");
    // divReduce.className = "GPpanelReduce";
    // divReduce.title = "Masquer le panneau";
    //
    // if (divReduce.addEv