#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


from fanstatic import Library, Resource
from pyams_utils.fanstatic import ExternalResource


from pyramid.i18n import TranslationStringFactory
_ = TranslationStringFactory('pyams_gis')


library = Library('pyams_gis', 'resources')

leaflet_css = Resource(library, 'css/leaflet-1.7.1.css',
                       minified='css/leaflet-1.7.1.min.css')

leaflet = Resource(library, 'js/leaflet-1.7.1.js',
                   minified='js/leaflet-1.7.1.min.js',
                   depends=[leaflet_css, ],
                   bottom=True)

leaflet_gp = Resource(library, 'js/leaflet-gp-2.1.7.js',
                      minified='js/leaflet-gp-2.1.7.min.js',
                      depends=[leaflet, ],
                      bottom=True)

leaflet_esri = Resource(library, 'js/leaflet-esri-2.5.3.js',
                        minified='js/leaflet-esri-2.5.3.min.js',
                        depends=[leaflet, ],
                        bottom=True)

leaflet_google = ExternalResource(library, 'https://maps.googleapis.com/maps/api/js',
                                  bottom=True)

leaflet_google_mutant = Resource(library, 'js/leaflet-google-mutant.js',
                                 minified='js/leaflet-google-mutant.min.js',
                                 depends=[leaflet, ],
                                 bottom=True)

pyams_gis = Resource(library, 'js/pyams_gis.js',
                     minified='js/pyams_gis.min.js',
                     depends=[leaflet, ],
                     bottom=True)


def includeme(config):
    """Pyramid include"""

    from .include import include_package
    include_package(config)
