/*!
 * @brief French Geoportal Extension for Leaflet
 *
 * This software is released under the licence CeCILL-B (Free BSD compatible)
 * @see http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.txt
 * @see http://www.cecill.info/licences/Licence_CeCILL-B_V1-fr.txt
 * @see http://www.cecill.info/
 *
 * @copyright copyright (c) IGN 
 * @license CeCILL-B
 * @author IGN
 * @version 2.1.7
 * @date 09/12/2020
 *
 */
/*!
 * @overview  Proj4Leaflet - Smooth Proj4js integration with Leaflet
 * @copyright Copyright (c) 2012, Kartena AB
 * @license   BSD 2-Clause "Simplified" License
 *            See https://raw.githubusercontent.com/kartena/Proj4Leaflet/master/LICENSE
 * @version 1.0.2
 */
/*!
 * @overview  leaflet-draw - Vector drawing and editing plugin for Leaflet 
 * @copyright Copyright (c) 2012-2017 Jon West, Jacob Toye, and Leaflet
 * @license   Licensed under MIT license
 *            See https://raw.githubusercontent.com/Leaflet/Leaflet.draw/master/MIT-LICENSE.md
 * @version   1.0.4
 */
/*!
 * Sortable -- JavaScript library for reorderable drag-and-drop lists on modern
 * browsers and touch devices. No jQuery required. Supports Meteor, AngularJS,
 * React, Polymer, Vue, Knockout and any CSS library, e.g. Bootstrap.
 *
 * Released under MIT LICENSE
 *
 * Copyright Lebedev Konstantin <ibnRubaXa@gmail.com>
 * https://github.com/SortableJS/Sortable
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * @version 1.8.4
 */
/*!
 * @overview  es6-promise - a tiny implementation of Promises/A+.
 * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
 * @license   Licensed under MIT license
 *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
 * @version   v4.2.4
 */
/*!
 * @overview   Proj4js - Javascript reprojection library.
 *
 * @authors
 * - Mike Adair madairATdmsolutions.ca
 * - Richard Greenwood richATgreenwoodmap.com
 * - Didier Richard didier.richardATign.fr
 * - Stephen Irons stephen.ironsATclear.net.nz
 * - Olivier Terral oterralATgmail.com
 * - Calvin Metcalf cmetcalfATappgeo.com
 *
 * @copyright Copyright (c) 2014, Mike Adair, Richard Greenwood, Didier Richard, Stephen Irons, Olivier Terral and Calvin Metcalf
 * @license   Licensed under MIT license
 *            See https://raw.githubusercontent.com/proj4js/proj4js/master/LICENSE.md
 * @version   ^2.6.2
 */
!function(t,e){"object"==typeof exports&&"object"==typeof module?module.exports=e(require("leaflet"),require("request"),require("xmldom")):"function"==typeof define&&define.amd?define("Gp",["leaflet","require","require"],e):"object"==typeof exports?exports.Gp=e(require("leaflet"),require("request"),require("xmldom")):t.Gp=e(t.L,t[void 0],t[void 0])}(window,(function(t,e,i){return function(t){var e={};function i(o){if(e[o])return e[o].exports;var n=e[o]={i:o,l:!1,exports:{}};return t[o].call(n.exports,n,n.exports,i),n.l=!0,n.exports}return i.m=t,i.c=e,i.d=function(t,e,o){i.o(t,e)||Object.defineProperty(t,e,{enumerable:!0,get:o})},i.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},i.t=function(t,e){if(1&e&&(t=i(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var o=Object.create(null);if(i.r(o),Object.defineProperty(o,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var n in t)i.d(o,n,function(e){return t[e]}.bind(null,n));return o},i.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return i.d(e,"a",e),e},i.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},i.p="",i(i.s=0)}([function(t,e,i){"use strict";i.r(e),i.d(e,"Services",(function(){return f})),i.d(e,"Error",(function(){return _})),i.d(e,"Helper",(function(){return g})),i.d(e,"Protocols",(function(){return v})),i.d(e,"servicesDate",(function(){return y})),i.d(e,"servicesVersion",(function(){return E})),i.d(e,"leafletExtVersion",(function(){return P})),i.d(e,"leafletExtDate",(function(){return w}));var o=i(1),n=i(2),s=i.n(n);i.d(e,"LExtended",(function(){return s.a}));i(3),i(21);var a=i(32),r=i(166),l=i(170),c=i(150),u=(i(176),i(40)),h=i(172);i.d(e,"LayerUtils",(function(){return h.default}));var d=i(177);i.d(e,"ProxyUtils",(function(){return d.default}));var p=i(178);i.d(e,"ColorUtils",(function(){return p.default}));var m=i(148);i.d(e,"MathUtils",(function(){return m.default}));var f=u.default.Services,_=u.default.Error,g=u.default.Helper,v=u.default.Protocols,y=u.default.servicesDate,E=u.default.servicesVersion,P=o.leafletExtVersion,w=o.date;s.a.geoportalLayer=l.default,s.a.geoportalControl=a.default,s.a.geoportalControl.ElevationPath.DISPLAY_PROFILE_LIB_D3=r.default.DISPLAY_PROFILE_LIB_D3,s.a.geoportalControl.ElevationPath.DISPLAY_PROFILE_LIB_AMCHARTS=r.default.DISPLAY_PROFILE_LIB_AMCHARTS,s.a.geoportalControl.ElevationPath.DISPLAY_PROFILE_RAW=r.default.DISPLAY_PROFILE_RAW,s.a.geoportalControl.ElevationPath.DISPLAY_PROFILE_BY_DEFAULT=r.default.DISPLAY_PROFILE_BY_DEFAULT,s.a.geoportalCRS=c.default,s.a.geoportalCRS.EPSG2154=c.default.EPSG2154(),s.a.geoportalCRS.EPSG27572=c.default.EPSG27572(),s.a.geoportalCRS.EPSG4326=c.default.EPSG4326()},function(t){t.exports=JSON.parse('{"name":"geoportal-extensions","description":"French Geoportal Extensions for OpenLayers, Leaflet and iTowns libraries","version":"2.3.1","date":"09/12/2020","leafletExtName":"French Geoportal Extension for Leaflet","leafletExtVersion":"2.1.7","olExtName":"French Geoportal Extension for OpenLayers","olExtVersion":"3.0.13","itownsExtName":"French Geoportal Extension for Itowns","itownsExtVersion":"2.3.0","main":"dist/leaflet/GpPluginLeaflet.js, dist/openlayers/GpPluginOpenLayers.js, dist/itowns/GpPluginItowns.js","module":"src/Leaflet/index.js, src/OpenLayers/index.js, src/Itowns/index.js","directories":{},"scripts":{"setup":"npm install","clean":"echo \\"Warning: target not yet implemented!\\" && exit 0","eslint":"eslint src/","test":"npm run test:serve","test:serve":"cd test && webpack-dev-server --hot --config webpack.test.serve.js","sample":"npm run sample:serve","sample:serve":"npm run sample:ol:serve","sample:itowns:serve":"webpack-dev-server --config build/webpack/webpack.config.itowns --https --open-page samples/index-itowns-map.html --content-base . --output-public-path \'/dist/itowns/\' --port 9001 --open \'google-chrome\'","sample:leaflet:serve":"webpack-dev-server --config build/webpack/webpack.config.leaflet --https --open-page samples/index-leaflet-map.html --content-base . --output-public-path \'/dist/leaflet/\' --port 9001 --open \'google-chrome\'","sample:ol:serve":"webpack-dev-server --config build/webpack/webpack.config.openlayers --https --open-page samples/index-openlayers-map.html --content-base . --output-public-path \'/dist/openlayers/\' --port 9001 --open \'google-chrome\'","doc":"npm run doc:serve","doc:serve":"npm run doc:ol:serve","doc:itowns:serve":"webpack-dev-server --config build/webpack/webpack.config.itowns --content-base jsdoc/itowns --port 9001 --open","doc:leaflet:serve":"webpack-dev-server --config build/webpack/webpack.config.leaflet --content-base jsdoc/leaflet --port 9001 --open","doc:ol:serve":"webpack-dev-server --config build/webpack/webpack.config.openlayers --content-base jsdoc/openlayers --port 9001 --open","build:dev":"npm-run-all --print-label --print-name build:*:dev","build:prod":"npm-run-all --print-label --print-name build:*:prod","build:src":"npm-run-all --print-label --print-name build:*:src","build":"npm-run-all --print-label --print-name build:*:*","build:itowns":"npm-run-all --print-label --print-name build:itowns:*","build:itowns:dev":"webpack --config build/webpack/webpack.config.itowns --mode=development","build:itowns:prod":"webpack --config build/webpack/webpack.config.itowns --mode=production","build:itowns:src":"webpack --config build/webpack/webpack.config.itowns --mode=none","build:ol":"npm-run-all --print-label --print-name build:ol:*","build:ol:dev":"webpack --config build/webpack/webpack.config.openlayers --mode=development","build:ol:prod":"webpack --config build/webpack/webpack.config.openlayers --mode=production","build:ol:src":"webpack --config build/webpack/webpack.config.openlayers --mode=none","build:leaflet":"npm-run-all --print-label --print-name build:leaflet:*","build:leaflet:dev":"webpack --config build/webpack/webpack.config.leaflet --mode=development","build:leaflet:prod":"webpack --config build/webpack/webpack.config.leaflet --mode=production","build:leaflet:src":"webpack --config build/webpack/webpack.config.leaflet --mode=none"},"repository":{"type":"git","url":"https://github.com/IGNF/geoportal-extensions.git"},"author":"IGNF","keywords":["geoportail","javascript","OpenLayers","Leaflet","Itowns","3D"],"license":"CECILL-B","bugs":{"url":"https://github.com/IGNF/geoportal-extensions/issues"},"homepage":"https://github.com/IGNF/geoportal-extensions#readme","dependencies":{"@mapbox/mapbox-gl-style-spec":"13.11.0","eventbusjs":"0.2.0","geoportal-access-lib":"2.1.6","itowns":"2.27.0","leaflet":"1.7.1","leaflet-draw":"1.0.4","loglevel":"^1.6.7","ol":"5.3.0","ol-mapbox-style":"4.2.1","proj4":"^2.6.2","proj4leaflet":"1.0.2","sortablejs":"1.8.4","three":"^0.121.1","whatwg-fetch":"3.0.0"},"devDependencies":{"@babel/core":"^7.4.4","@babel/plugin-transform-template-literals":"^7.7.4","@babel/preset-env":"^7.4.4","babel-loader":"^8.0.5","chai":"^4.2.0","chalk":"^4.0.0","clean-webpack-plugin":"^3.0.0","copy-webpack-plugin":"^5.0.3","core-js":"^3.6.4","css-loader":"^3.4.2","eslint":"^6.8.0","eslint-config-standard":"^14.1.1","eslint-loader":"^4.0.0","eslint-plugin-import":"^2.17.2","eslint-plugin-node":"^11.1.0","eslint-plugin-promise":"^4.1.1","eslint-plugin-standard":"^4.0.0","exports-loader":"^0.7.0","expose-loader":"^0.7.5","fs-extra":"^9.0.0","handlebars":"^4.7.5","handlebars-layouts":"^3.1.4","html-webpack-plugin":"^4.0.4","jsdoc-webpack-plugin":"^0.3.0","mini-css-extract-plugin":"^0.9.0","mocha":"^7.1.1","mocha-loader":"^5.0.0","npm-run-all":"^4.1.5","optimize-css-assets-webpack-plugin":"^5.0.1","path":"^0.12.7","replace-bundle-webpack-plugin":"^1.0.0","requirejs":"^2.3.6","responsive-loader":"^1.2.0","speed-measure-webpack-plugin":"^1.3.0","string-template":"^1.0.0","style-loader":"^1.1.3","terser-webpack-plugin":"^2.0.0","url-loader":"^4.0.0","webpack":"^4.30.0","webpack-cli":"^3.3.1","webpack-dev-server":"^3.3.1","webpack-node-externals":"^1.7.2"}}')},function(e,i){e.exports=t},function(t,e,i){"use strict";i.r(e);i(4),i(5),i(6),i(7),i(8),i(9),i(10),i(11),i(12),i(13),i(14),i(15),i(16),i(17),i(18),i(19),i(20)},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){"use strict";i.r(e);i(22),i(23),i(24),i(25),i(26),i(27),i(28),i(29),i(30);i(31)},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){},function(t,e,i){"use strict";i.r(e);var o=i(33),n=i(39),s=i(147),a=i(158),r=i(161),l=i(163),c=i(166),u=i(169),h={LayerSwitcher:function(t){return new o.default(t)},Isocurve:function(t){return new n.default(t)},MousePosition:function(t){return new s.default(t)},ReverseGeocode:function(t){return new a.default(t)},Route:function(t){return new r.default(t)},SearchEngine:function(t){return new l.default(t)},ElevationPath:function(t){return new c.default(t)},Logo:function(t){return new u.default(t)}};e.default=h},function(t,e,i){"use strict";i.r(e);var o=i(2),n=i.n(o),s=i(34),a=i(36),r=i(37),l=s.default.getLogger("layerswitcher"),c=n.a.Control.Layers.extend({includes:r.default,options:{collapsed:!0,position:"topright",autoZIndex:!0,layers:[]},initialize:function(t){if(n.a.Util.setOptions(this,t),this._uid=a.default.generate(),this._hasLayersConfig=!(!this.options.layers||0===Object.keys(this.options.layers).length),this._layersConfig=this._hasLayersConfig?this.options.layers:[],this._layers={},this._lastZIndex=0,this._hasLayersConfig)for(var e=0;e<this._layersConfig.length;e++){var i=this._layersConfig[e];this._addLayer(i.layer,null,!0)}},onAdd:function(t){var e=t._layers;if(0!==Object.keys(e).length){var i=Object.keys(e);this._lastZIndex=0;for(var o=0;o<i.length;o++){var n=i[o];this.options.autoZIndex&&e[n].setZIndex&&(this._lastZIndex++,e[n].setZIndex(this._lastZIndex)),this._hasLayersConfig&&this._layers[n]||this.addOverlay(e[n])}}if(0===Object.keys(e).length){var s=this._layersConfig;this._lastZIndex=0;for(var a=0;a<s.length;a++){var r=s[a].layer;t.hasLayer(r)||(t.addLayer(r),this.addOverlay(r,null),this.options.autoZIndex&&r.setZIndex&&(this._lastZIndex++,r.setZIndex(this._lastZIndex)))}}for(var c in this._layers)if(this._layers.hasOwnProperty(c)){var u=this._layers[c],h=u.layer;u.visibility||this._updateVisibilityLayer(h)}return this._initLayout(),this._update(),t.on("layeradd",this._onLayerChange,this),t.on("layerremove",this._onLayerChange,this),t.eachLayer((function(t){t.on("visibilitychange",(function(){l.trace("visibilitychange",t)}),this),t.on("attributionchange",(function(){l.trace("attributionchange",t)}),this)})),this._container},_addLayer:function(t,e,i){var o=t._geoportal_id?t._geoportal_id:t._leaflet_id;if(void 0!==o){var s={};for(var a in this._layersConfig)if(this._layersConfig.hasOwnProperty(a)&&o===n.a.stamp(this._layersConfig[a].layer)){if(s=this._layersConfig[a].config,!(void 0===this._layersConfig[a].display||this._layersConfig[a].display))return;break}this._layers[o]={layer:t,id:o,overlay:i,title:t._geoportal_id&&t._title?t._title:e||o,description:t._geoportal_id&&t._description?t._description:e||o,visibility:!0,legends:t._geoportal_id?t._legends:null,metadata:t._geoportal_id?t._metadata:null,quicklookUrl:t._geoportal_id?t._quicklookUrl:null},s&&Object.keys(s)&&n.a.Util.extend(this._layers[o],s);var r=this._layers[o].visibility;t._geoportal_id&&t.setVisible(r),r||this._updateVisibilityLayer(t)}},addTo:function(t){return n.a.Control.prototype.addTo.call(this,t),this},_initLayout:function(){var t=this._container=this._createMainContainerElement(),e=this._createMainLayersShowElement();t.appendChild(e),this.options.collapsed||(e.checked=!0);var i=this._overlaysList=this._createMainLayersElement();t.appendChild(i);var o=this._createMainPictoElement();t.appendChild(o);var s=this._createMainInfoElement();switch(t.appendChild(s),this._createDraggableElement(this._overlaysList,this),n.a.DomEvent.disableClickPropagation(t).disableScrollPropagation(t),this._map.on("moveend",this._onOutOfRangeLayerZoom,this),this.getPosition()){case"topright":t.style.position="relative",t.style.top="0",t.style.right="0";break;case"topleft":case"bottomleft":t.style.position="relative",t.style.top="0",t.style.right="initial",o.style.float="left",i.style.borderBottomRightRadius="5px",i.style.borderBottomLeftRadius="0",s.style.right="initial",s.style.left="190px";break;case"bottomright":t.style.position="relative",t.style.top="0",t.style.right="0";break;default:t.style.position="relative",t.style.top="0",t.style.right="0"}},_update:function(){if(this._container){this._overlaysList.innerHTML="";var t=[];for(var e in this._layers)this._layers.hasOwnProperty(e)&&t.push(e);for(var i=t.sort((function(t,e){return parseInt(t,10)-parseInt(e,10)})).reverse(),o=0;o<i.length;o++){var n=i[o],s=this._layers[n];this._addItem(s)}}},_addItem:function(t){l.log("_addItem",t),t.opacity=t.layer.options.opacity;var e=this._createContainerLayerElement(t);return t.layer.options.minZoom>this._map.getZoom()||t.layer.options.maxZoom<this._map.getZoom()?n.a.DomUtil.addClass(e,"outOfRange"):n.a.DomUtil.removeClass(e,"outOfRange"),this._overlaysList.appendChild(e),e},_onLayerChange:function(t){var e=this._layers[n.a.stamp(t.layer)];if(e){this._handlingClick||this._update();var i="layeradd"===t.type?"overlayadd":"overlayremove";i&&this._map.fire(i,e)}},removeLayer:function(t){var e=n.a.stamp(t);delete this._layers[e],this._update();var i=this._map;return i&&i.hasLayer(t)&&i.removeLayer(t),this},_updateVisibilityLayer:function(t){if(this._map){this._handlingClick=!0;var e=this._layers[n.a.stamp(t)].visibility;e&&!this._map.hasLayer(t)?this._map.addLayer(t):!e&&this._map.hasLayer(t)?this._map.removeLayer(t):l.log("Status unknown layer !?"),this._handlingClick=!1,this._refocusOnMap()}},_updateVisibilityDOMLayer:function(t){var e=n.a.stamp(t),i=n.a.DomUtil.get(this._addUID("GPvisibility_ID_"+e)),o=this._layers[e].visibility;i.checked=o},_updateOpacityDOMLayer:function(t){var e=n.a.stamp(t),i=t.options.opacity,o=n.a.DomUtil.get(this._addUID("GPopacityValue_ID_"+e));o.innerHTML=parseInt(100*i,10)+"%",o.value=parseInt(100*i,10)},_onOutOfRangeLayerZoom:function(){var t=this._map,e=this._layers;for(var i in e)if(e.hasOwnProperty(i)){var o=e[i].layer,s=e[i].id,a=n.a.DomUtil.get(this._addUID("GPlayerSwitcher_ID_"+s));o.options.minZoom>t.getZoom()||o.options.maxZoom<t.getZoom()?n.a.DomUtil.addClass(a,"outOfRange"):n.a.DomUtil.removeClass(a,"outOfRange")}},_onVisibilityLayerClick:function(t){var e=t.target.id,i=a.default.index(e);this._layers[i].visibility=n.a.DomUtil.get(e).checked;var o=this._layers[i].layer;this._updateVisibilityLayer(o)},_onDropLayerClick:function(t){var e=t.target.id,i=a.default.index(e),o=this._layers[i].layer;this.removeLayer(o)},_onChangeLayerOpacity:function(t){var e=t.target.id,i=a.default.index(e),o=this._layers[i].layer,s=t.target.value;n.a.DomUtil.get(this._addUID("GPopacityValue_ID_"+i)).innerHTML=s+"%",this._map.hasLayer(o)&&(void 0!==o.setOpacity?o.setOpacity(s/100):o.setStyle({fillOpacity:s/100,opacity:s/100}))},_onOpenLayerInfoClick:function(t){var e=t.target.id,i=a.default.index(e),o=this._layers[i],s=n.a.DomUtil.get(t.target.id),r=null,l=null;if("GPlayerInfoOpened"===s.className)return n.a.DomUtil.removeClass(s,"GPlayerInfoOpened"),n.a.DomUtil.addClass(s,"GPlayerInfo"),r=n.a.DomUtil.get(this._addUID("GPlayerInfoPanel")),n.a.DomUtil.removeClass(r,"GPpanel"),n.a.DomUtil.removeClass(r,"GPlayerInfoPanelOpened"),n.a.DomUtil.addClass(r,"GPlayerInfoPanelClosed"),l=n.a.DomUtil.get(this._addUID("GPlayerInfoContent")),void r.removeChild(l);for(var c=document.getElementsByClassName("GPlayerInfoOpened"),u=0;u<c.length;u++)c[u].className="GPlayerInfo";n.a.DomUtil.removeClass(s,"GPlayerInfo"),n.a.DomUtil.addClass(s,"GPlayerInfoOpened"),r=n.a.DomUtil.get(this._addUID("GPlayerInfoPanel")),n.a.DomUtil.addClass(r,"GPpanel"),n.a.DomUtil.removeClass(r,"GPlayerInfoPanelClosed"),n.a.DomUtil.addClass(r,"GPlayerInfoPanelOpened"),(l=n.a.DomUtil.get(this._addUID("GPlayerInfoContent")))&&r.removeChild(l);var h=this._createContainerLayerInfoElement(o);r.appendChild(h)},_onDragAndDropLayerClick:function(t){var e=t.target.id,i=a.default.index(e),o=this._layers[i];l.log(o);var n=document.querySelectorAll("div.GPlayerSwitcher_layer");this._lastZIndex=n.length;for(var s=0;s<n.length;s++){var r=n[s].id,c=a.default.index(r),u=this._layers[c].layer;this.options.autoZIndex&&u.setZIndex&&(this._lastZIndex--,u.setZIndex(this._lastZIndex))}},addLayer:function(t,e){var i=this._map,o=this._layersConfig;if(t){i.hasLayer(t)||(l.log("[WARN] LayerSwitcher:addLayer - layer has not been added on map !"),i.addLayer(t));var s=n.a.stamp(t);for(var a in o)if(o.hasOwnProperty(a)&&s===n.a.stamp(o[a].layer)){delete o[a];break}var r=e||{};n.a.Util.extend(r,{layer:t}),o.push(r),this._layers[s]||t.setZIndex(this._lastZIndex++),this.addOverlay(t),this._update()}else l.log("[ERROR] LayerSwitcher:addLayer - missing layer parameter !")},setOpacity:function(t,e){l.trace(t,e),e>1||e<0||this._map.hasLayer(t)&&(void 0!==t.setOpacity?t.setOpacity(e):(t.options.opacity=e,t.setStyle({fillOpacity:e,opacity:e})),this._updateOpacityDOMLayer(t))},setVisibility:function(t,e){l.trace(t,e),this._layers[n.a.stamp(t)].visibility=e,this._updateVisibilityDOMLayer(t),this._updateVisibilityLayer(t)}});e.default=c},function(t,e,i){"use strict";i.r(e);var o=i(35),n={getLogger:function(t){"false".match(/true/)?o.disableAll():o.enableAll();var e=t||"default";return o.getLogger(e)}};e.default=n},function(t,e,i){var o,n;!function(s,a){"use strict";void 0===(n="function"==typeof(o=function(){var t=function(){},e="undefined",i=typeof window!==e&&typeof window.navigator!==e&&/Trident\/|MSIE /.test(window.navigator.userAgent),o=["trace","debug","info","warn","error"];function n(t,e){var i=t[e];if("function"==typeof i.bind)return i.bind(t);try{return Function.prototype.bind.call(i,t)}catch(e){return function(){return Function.prototype.apply.apply(i,[t,arguments])}}}function s(){console.log&&(console.log.apply?console.log.apply(console,arguments):Function.prototype.apply.apply(console.log,[console,arguments])),console.trace&&console.trace()}function a(e,i){for(var n=0;n<o.length;n++){var s=o[n];this[s]=n<e?t:this.methodFactory(s,e,i)}this.log=this.debug}function r(t,i,o){return function(){typeof console!==e&&(a.call(this,i,o),this[t].apply(this,arguments))}}function l(o,a,l){return function(o){return"debug"===o&&(o="log"),typeof console!==e&&("trace"===o&&i?s:void 0!==console[o]?n(console,o):void 0!==console.log?n(console,"log"):t)}(o)||r.apply(this,arguments)}function c(t,i,n){var s,r=this,c="loglevel";function u(){var t;if(typeof window!==e&&c){try{t=window.localStorage[c]}catch(t){}if(typeof t===e)try{var i=window.document.cookie,o=i.indexOf(encodeURIComponent(c)+"=");-1!==o&&(t=/^([^;]+)/.exec(i.slice(o))[1])}catch(t){}return void 0===r.levels[t]&&(t=void 0),t}}"string"==typeof t?c+=":"+t:"symbol"==typeof t&&(c=void 0),r.name=t,r.levels={TRACE:0,DEBUG:1,INFO:2,WARN:3,ERROR:4,SILENT:5},r.methodFactory=n||l,r.getLevel=function(){return s},r.setLevel=function(i,n){if("string"==typeof i&&void 0!==r.levels[i.toUpperCase()]&&(i=r.levels[i.toUpperCase()]),!("number"==typeof i&&i>=0&&i<=r.levels.SILENT))throw"log.setLevel() called with invalid level: "+i;if(s=i,!1!==n&&function(t){var i=(o[t]||"silent").toUpperCase();if(typeof window!==e&&c){try{return void(window.localStorage[c]=i)}catch(t){}try{window.document.cookie=encodeURIComponent(c)+"="+i+";"}catch(t){}}}(i),a.call(r,i,t),typeof console===e&&i<r.levels.SILENT)return"No console available for logging"},r.setDefaultLevel=function(t){u()||r.setLevel(t,!1)},r.enableAll=function(t){r.setLevel(r.levels.TRACE,t)},r.disableAll=function(t){r.setLevel(r.levels.SILENT,t)};var h=u();null==h&&(h=null==i?"WARN":i),r.setLevel(h,!1)}var u=new c,h={};u.getLogger=function(t){if("symbol"!=typeof t&&"string"!=typeof t||""===t)throw new TypeError("You must supply a name when creating a logger.");var e=h[t];return e||(e=h[t]=new c(t,u.getLevel(),u.methodFactory)),e};var d=typeof window!==e?window.log:void 0;return u.noConflict=function(){return typeof window!==e&&window.log===u&&(window.log=d),u},u.getLoggers=function(){return h},u.default=u,u})?o.call(e,i,e,t):o)||(t.exports=n)}()},function(t,e,i){"use strict";i.r(e);var o,n={generate:(o=Math.floor(Date.now()),function(){return o++}),name:function(t){var e=null,i=t.lastIndexOf("-");return e=-1===i?t:t.substring(0,i),e},index:function(t){var e=null,i=this.name(t),o=i.lastIndexOf("_");return-1!==o&&(e=i.substring(o+1)),e},uuid:function(t){var e=null,i=t.lastIndexOf("-");return-1!==i&&(e=parseInt(t.substring(i+1),10)),e}};e.default=n},function(t,e,i){"use strict";i.r(e);var o=i(38),n=i.n(o),s={_createDraggableElement:function(t,e){n.a.create(t,{handle:".GPlayerName",draggable:".draggable-layer",ghostClass:"GPghostLayer",animation:200,onEnd:function(t){e._onDragAndDropLayerClick(t)}})},_addUID:function(t){return this._uid?t+"-"+this._uid:t},_createMainContainerElement:function(){var t=document.createElement("div");return t.id=this._addUID("GPlayerSwitcher"),t.className="GPwidget",t},_createMainLayersShowElement:function(){var t=document.createElement("input");return t.id=this._addUID("GPshowLayersList"),t.type="checkbox",t},_createMainLayersElement:function(){var t=document.createElement("div");return t.id=this._addUID("GPlayersList"),t.className="GPpanel",t},_createMainPictoElement:function(){var t=this,e=document.createElement("label");e.id=this._addUID("GPshowLayersListPicto"),e.className="GPshowAdvancedToolPicto",e.htmlFor=this._addUID("GPshowLayersList"),e.title="Afficher/masquer le gestionnaire de couches";var i=document.createElement("span");i.id=this._addUID("GPshowLayersListOpen"),i.className="GPshowAdvancedToolOpen",i.addEventListener("click",(function(){if(document.getElementById(t._addUID("GPshowLayersList")).checked){for(var e=document.getElementsByClassName("GPlayerInfoOpened"),i=0;i<e.length;i++)e[i].className="GPlayerInfo";document.getElementById(t._addUID("GPlayerInfoPanel")).className="GPlayerInfoPanelClosed"}})),e.appendChild(i);var o=document.createElement("span");return o.addEventListener("click",(function(){if(document.getElementById(t._addUID("GPshowLayersList")).checked){for(var e=document.getElementsByClassName("GPlayerInfoOpened"),i=0;i<e.length;i++)e[i].className="GPlayerInfo";document.getElementById(t._addUID("GPlayerInfoPanel")).className="GPlayerInfoPanelClosed"}})),o.id=t._addUID("GPshowLayersListClose"),e.appendChild(o),e},_createMainInfoElement:function(){var t=document.createElement("div");return t.id=this._addUID("GPlayerInfoPanel"),t.className="GPpanel GPlayerInfoPanelClosed",t},_createContainerLayerElement:function(t){var e=document.createElement("div");e.id=this._addUID("GPlayerSwitcher_ID_"+t.id),e.className="GPlayerSwitcher_layer draggable-layer",e.appendChild(this._createBasicToolElement(t));for(var i=this._createAdvancedToolShowElement(t),o=0;o<i.length;o++)e.appendChild(i[o]);return e.appendChild(this._createAdvancedToolElement(t)),e},_createBasicToolElement:function(t){var e=document.createElement("div");e.id=this._addUID("GPbasicTools_ID_"+t.id),e.className="GPlayerBasicTools",e.appendChild(this._createBasicToolNameElement(t));for(var i=this._createBasicToolVisibilityElement(t),o=0;o<i.length;o++)e.appendChild(i[o]);return e},_createBasicToolNameElement:function(t){var e=document.createElement("span");return e.id=this._addUID("GPname_ID_"+t.id),e.className="GPlayerName",e.title=t.description||t.title,e.innerHTML=t.title,e},_createBasicToolVisibilityElement:function(t){var e=[],i=void 0===t.visibility||t.visibility,o=this._addUID("GPvisibility_ID_"+t.id),n=document.createElement("input");n.id=o,n.type="checkbox",n.checked=i;var s=document.createElement("label");s.htmlFor=o,s.id=this._addUID("GPvisibilityPicto_ID_"+t.id),s.className="GPlayerVisibility",s.title="Afficher/masquer la couche";var a=this;return n.addEventListener?n.addEventListener("click",(function(t){a._onVisibilityLayerClick(t)})):n.attachEvent&&n.attachEvent("onclick",(function(t){a._onVisibilityLayerClick(t)})),e.push(n),e.push(s),e},_createAdvancedToolShowElement:function(t){var e=[],i=document.createElement("label");i.id=this._addUID("GPshowAdvancedToolsPicto_ID_"+t.id),i.htmlFor=this._addUID("GPshowAdvancedTools_ID_"+t.id),i.title="Plus d'outils",i.className="GPshowMoreOptions GPshowLayerAdvancedTools";var o=document.createElement("input");return o.type="checkbox",o.id=this._addUID("GPshowAdvancedTools_ID_"+t.id),e.push(o),e.push(i),e},_createAdvancedToolElement:function(t){var e=document.createElement("div");if(e.id=this._addUID("GPadvancedTools_ID_"+t.id),e.className="GPlayerAdvancedTools",e.appendChild(this._createAdvancedToolDeleteElement(t)),t.title&&t.description&&e.appendChild(this._createAdvancedToolInformationElement(t)),"feature"!==t.type)for(var i=this._createAdvancedToolOpacityElement(t),o=0;o<i.length;o++)e.appendChild(i[o]);return e},_createAdvancedToolDeleteElement:function(t){var e=document.createElement("div");e.id=this._addUID("GPremove_ID_"+t.id),e.className="GPlayerRemove",e.title="Supprimer la couche",e.layerId=t.id;var i=this;return e.addEventListener?e.addEventListener("click",(function(t){i._onDropLayerClick(t)})):e.attachEvent&&e.attachEvent("onclick",(function(t){i._onDropLayerClick(t)})),e},_createAdvancedToolInformationElement:function(t){var e=document.createElement("div");e.id=this._addUID("GPinfo_ID_"+t.id),e.className="GPlayerInfo",e.title="Informations/légende",e.layerId=t.id;var i=this;return e.addEventListener?e.addEventListener("click",(function(t){i._onOpenLayerInfoClick(t)})):e.attachEvent&&e.attachEvent("onclick",(function(t){i._onOpenLayerInfoClick(t)})),e},_createAdvancedToolOpacityElement:function(t){var e=[],i=document.createElement("div");i.id=this._addUID("GPopacity_ID_"+t.id),i.className="GPlayerOpacity",i.title="Opacité";var o=void 0!==t.opacity?t.opacity:1;o=Math.round(100*o);var n=document.createElement("input");n.id=this._addUID("GPopacityValueDiv_ID_"+t.id),n.type="range",n.value=o;var s=this;n.addEventListener?n.addEventListener("change",(function(t){s._onChangeLayerOpacity(t)})):n.attachEvent&&n.attachEvent("onchange",(function(t){s._onChangeLayerOpacity(t)})),n.addEventListener?n.addEventListener("input",(function(t){s._onChangeLayerOpacity(t)})):n.attachEvent&&n.attachEvent("oninput",(function(t){s._onChangeLayerOpacity(t)})),i.appendChild(n);var a=document.createElement("div");a.id=this._addUID("GPopacityValueDiv_ID_"+t.id),a.className="GPlayerOpacityValue";var r=document.createElement("span");return r.id=this._addUID("GPopacityValue_ID_"+t.id),r.innerHTML=o+"%",a.appendChild(r),e.push(i),e.push(a),e},_createContainerLayerInfoElement:function(t){var e=document.createElement("div");e.id=this._addUID("GPlayerInfoContent");var i=document.createElement("div");if(i.id=this._addUID("GPlayerInfoTitle"),i.innerHTML=t.title,e.appendChild(i),t.quicklookUrl){var o=document.createElement("div");o.id=this._addUID("GPlayerInfoQuicklook"),o.title="Afficher un aperçu de la couche";var n=document.createElement("a");n.href=t.quicklookUrl,n.appendChild(o),e.appendChild(n)}var s=document.createElement("div");s.id=this._addUID("GPlayerInfoClose"),s.title="Fermer la fenêtre";var a=this,r=function(){document.getElementById(a._addUID("GPlayerInfoPanel")).className="GPlayerInfoPanelClosed";for(var t=document.getElementsByClassName("GPlayerInfoOpened"),e=0;e<t.length;e++)t[e].className="GPlayerInfo"};s.addEventListener?s.addEventListener("click",r):s.attachEvent&&s.attachEvent("onclick",r),e.appendChild(s);var l=document.createElement("div");if(l.id=this._addUID("GPlayerInfoDescription"),l.innerHTML=t.description,e.appendChild(l),t.metadata){var c=document.createElement("div");c.id=this._addUID("GPlayerInfoMetadata");var u=document.createElement("div");u.className="GPlayerInfoSubtitle",u.innerHTML="Métadonnées",c.appendChild(u);for(var h=0;h<t.metadata.length;h++){var d=t.metadata[h].url,p=document.createElement("div");p.className="GPlayerInfoLink";var m=document.createElement("a");m.href=d,m.innerHTML=d,p.appendChild(m),c.appendChild(p)}0!==t.metadata.length&&e.appendChild(c)}if(t.legends){var f=document.createElement("div");f.id=this._addUID("GPlayerInfoLegend");var _=document.createElement("div");_.className="GPlayerInfoSubtitle",_.innerHTML="Légende",f.appendChild(_);for(var g={},v=t.maxScaleDenominator||56e7,y=0;y<t.legends.length;y++){var E=t.legends[y].minScaleDenominator;if(E){var P=E.toString();E=Math.round(parseInt(P.substring(0,3),10)/10)*Math.pow(10,P.length-2)}else E=270;g[E]=t.legends[y]}for(var w in g)if(g.hasOwnProperty(w)){var C=g[w].url;if("string"==typeof C&&-1===C.toLowerCase().indexOf("nolegend.jpg")){var M=document.createElement("div");M.className="GPlayerInfoLink",v=g[w].maxScaleDenominator||v;var S=document.createElement("a");S.href=C,S.innerHTML="Du 1/"+w+" au 1/"+v,M.appendChild(S),f.appendChild(M)}else delete g[w]}0!==Object.keys(g).length&&e.appendChild(f)}return e}};e.default=s},function(t,e,i){var o,n;
/**!
 * Sortable
 * @author	RubaXa   <trash@rubaxa.org>
 * @author	owenm    <owen23355@gmail.com>
 * @license MIT
 */!function(s){"use strict";void 0===(n="function"==typeof(o=s)?o.call(e,i,e,t):o)||(t.exports=n)}((function(){"use strict";if("undefined"==typeof window||!window.document)return function(){throw new Error("Sortable.js requires a window with a document")};var t,e,i,o,n,s,a,r,l,c,u,h,d,p,m,f,_,g,v,y,E,P,w,C,M,S,L=[],b=!1,R=!1,x=!1,I=[],G=!1,A=!1,T=[],k=/\s+/g,D="Sortable"+(new Date).getTime(),O=window,N=O.document,U=O.parseInt,j=O.setTimeout,F=O.jQuery||O.Zepto,B=O.Polymer,z={capture:!1,passive:!1},q=!!navigator.userAgent.match(/(?:Trident.*rv[ :]?11\.|msie|iemobile)/i),H=!!navigator.userAgent.match(/Edge/i),W=!!navigator.userAgent.match(/firefox/i),V=!(!navigator.userAgent.match(/safari/i)||navigator.userAgent.match(/chrome/i)||navigator.userAgent.match(/android/i)),Y=!!navigator.userAgent.match(/iP(ad|od|hone)/i),X=H||q?"cssFloat":"float",K="draggable"in N.createElement("div"),Z=function(){if(q)return!1;var t=N.createElement("x");return t.style.cssText="pointer-events:auto","auto"===t.style.pointerEvents}(),Q=!1,J=!1,$=Math.abs,tt=Math.min,et=Math.max,it=[],ot=function(t,e){var i=Ct(t),o=U(i.width)-U(i.paddingLeft)-U(i.paddingRight)-U(i.borderLeftWidth)-U(i.borderRightWidth),n=It(t,0,e),s=It(t,1,e),a=n&&Ct(n),r=s&&Ct(s),l=a&&U(a.marginLeft)+U(a.marginRight)+Bt(n).width,c=r&&U(r.marginLeft)+U(r.marginRight)+Bt(s).width;if("flex"===i.display)return"column"===i.flexDirection||"column-reverse"===i.flexDirection?"vertical":"horizontal";if("grid"===i.display)return i.gridTemplateColumns.split(" ").length<=1?"vertical":"horizontal";if(n&&"none"!==a.float){var u="left"===a.float?"left":"right";return!s||"both"!==r.clear&&r.clear!==u?"horizontal":"vertical"}return n&&("block"===a.display||"flex"===a.display||"table"===a.display||"grid"===a.display||l>=o&&"none"===i[X]||s&&"none"===i[X]&&l+c>o)?"vertical":"horizontal"},nt=function(t,e){if(!t||!t.getBoundingClientRect)return st();var i=t,o=!1;do{if(i.clientWidth<i.scrollWidth||i.clientHeight<i.scrollHeight){var n=Ct(i);if(i.clientWidth<i.scrollWidth&&("auto"==n.overflowX||"scroll"==n.overflowX)||i.clientHeight<i.scrollHeight&&("auto"==n.overflowY||"scroll"==n.overflowY)){if(!i||!i.getBoundingClientRect||i===N.body)return st();if(o||e)return i;o=!0}}}while(i=i.parentNode);return st()},st=function(){return q?N.documentElement:N.scrollingElement},at=function(t,e,i){t.scrollLeft+=e,t.scrollTop+=i},rt=Ot((function(t,e,i,o){if(e.scroll){var n=i?i[D]:window,s=e.scrollSensitivity,a=e.scrollSpeed,u=t.clientX,h=t.clientY,d=st(),p=!1;l!==i&&(lt(),r=e.scroll,c=e.scrollFn,!0===r&&(r=nt(i,!0),l=r));var m=0,f=r;do{var _,g,y,E,P,w,C,M,S,R=f,x=Bt(R),I=x.top,G=x.bottom,A=x.left,T=x.right,k=x.width,O=x.height;if(_=R.scrollWidth,g=R.scrollHeight,y=Ct(R),M=R.scrollLeft,S=R.scrollTop,R===d?(w=k<_&&("auto"===y.overflowX||"scroll"===y.overflowX||"visible"===y.overflowX),C=O<g&&("auto"===y.overflowY||"scroll"===y.overflowY||"visible"===y.overflowY)):(w=k<_&&("auto"===y.overflowX||"scroll"===y.overflowX),C=O<g&&("auto"===y.overflowY||"scroll"===y.overflowY)),E=w&&($(T-u)<=s&&M+k<_)-($(A-u)<=s&&!!M),P=C&&($(G-h)<=s&&S+O<g)-($(I-h)<=s&&!!S),!L[m])for(var N=0;N<=m;N++)L[N]||(L[N]={});L[m].vx==E&&L[m].vy==P&&L[m].el===R||(L[m].el=R,L[m].vx=E,L[m].vy=P,clearInterval(L[m].pid),!R||0==E&&0==P||(p=!0,L[m].pid=setInterval(function(){o&&0===this.layer&&(gt.active._emulateDragOver(!0),gt.active._onTouchMove(v,!0));var e=L[this.layer].vy?L[this.layer].vy*a:0,i=L[this.layer].vx?L[this.layer].vx*a:0;"function"==typeof c&&"continue"!==c.call(n,i,e,t,v,L[this.layer].el)||at(L[this.layer].el,i,e)}.bind({layer:m}),24))),m++}while(e.bubbleScroll&&f!==d&&(f=nt(f,!1)));b=p}}),30),lt=function(){L.forEach((function(t){clearInterval(t.pid)})),L=[]},ct=function(t){function e(t,i){return function(o,n,s,a){var r=o.options.group.name&&n.options.group.name&&o.options.group.name===n.options.group.name;if(null==t&&(i||r))return!0;if(null==t||!1===t)return!1;if(i&&"clone"===t)return t;if("function"==typeof t)return e(t(o,n,s,a),i)(o,n,s,a);var l=(i?o:n).options.group.name;return!0===t||"string"==typeof t&&t===l||t.join&&t.indexOf(l)>-1}}var i={},o=t.group;o&&"object"==typeof o||(o={name:o}),i.name=o.name,i.checkPull=e(o.pull,!0),i.checkPut=e(o.put),i.revertClone=o.revertClone,t.group=i},ut=function(e){t&&t.parentNode&&t.parentNode[D]&&t.parentNode[D]._computeIsAligned(e)},ht=function(t,e){for(var i=e;!i[D];)i=i.parentNode;return t===i},dt=function(t,e,i){for(var o=t.parentNode;o&&!o[D];)o=o.parentNode;o&&o[D][i](Nt(e,{artificialBubble:!0}))},pt=function(){!Z&&i&&Ct(i,"display","none")},mt=function(){!Z&&i&&Ct(i,"display","")};N.addEventListener("click",(function(t){if(x)return t.preventDefault(),t.stopPropagation&&t.stopPropagation(),t.stopImmediatePropagation&&t.stopImmediatePropagation(),x=!1,!1}),!0);var ft,_t=function(e){if(e=e.touches?e.touches[0]:e,t){var i=function(t,e){for(var i=0;i<I.length;i++)if(!Gt(I[i])){var o=Bt(I[i]),n=I[i][D].options.emptyInsertThreshold,s=t>=o.left-n&&t<=o.right+n,a=e>=o.top-n&&e<=o.bottom+n;if(s&&a)return I[i]}}(e.clientX,e.clientY);i&&i[D]._onDragOver({clientX:e.clientX,clientY:e.clientY,target:i,rootEl:i})}};function gt(t,e){if(!t||!t.nodeType||1!==t.nodeType)throw"Sortable: `el` must be HTMLElement, not "+{}.toString.call(t);this.el=t,this.options=e=Nt({},e),t[D]=this;var i={group:null,sort:!0,disabled:!1,store:null,handle:null,scroll:!0,scrollSensitivity:30,scrollSpeed:10,bubbleScroll:!0,draggable:/[uo]l/i.test(t.nodeName)?">li":">*",swapThreshold:1,invertSwap:!1,invertedSwapThreshold:null,removeCloneOnHide:!0,direction:function(){return ot(t,this.options)},ghostClass:"sortable-ghost",chosenClass:"sortable-chosen",dragClass:"sortable-drag",ignore:"a, img",filter:null,preventOnFilter:!0,animation:0,easing:null,setData:function(t,e){t.setData("Text",e.textContent)},dropBubble:!1,dragoverBubble:!1,dataIdAttr:"data-id",delay:0,touchStartThreshold:U(window.devicePixelRatio,10)||1,forceFallback:!1,fallbackClass:"sortable-fallback",fallbackOnBody:!1,fallbackTolerance:0,fallbackOffset:{x:0,y:0},supportPointer:!1!==gt.supportPointer&&("PointerEvent"in window||window.navigator&&"msPointerEnabled"in window.navigator),emptyInsertThreshold:5};for(var o in i)!(o in e)&&(e[o]=i[o]);for(var n in ct(e),this)"_"===n.charAt(0)&&"function"==typeof this[n]&&(this[n]=this[n].bind(this));this.nativeDraggable=!e.forceFallback&&K,this.nativeDraggable&&(this.options.touchStartThreshold=1),e.supportPointer?Et(t,"pointerdown",this._onTapStart):(Et(t,"mousedown",this._onTapStart),Et(t,"touchstart",this._onTapStart)),this.nativeDraggable&&(Et(t,"dragover",this),Et(t,"dragenter",this)),I.push(this.el),e.store&&e.store.get&&this.sort(e.store.get(this)||[])}function vt(t,e,i,o){if(t){i=i||N;do{if(null!=e&&(">"===e[0]&&t.parentNode===i&&Dt(t,e.substring(1))||Dt(t,e))||o&&t===i)return t;if(t===i)break}while(t=yt(t))}return null}function yt(t){return t.host&&t!==N&&t.host.nodeType?t.host:t.parentNode}function Et(t,e,i){t.addEventListener(e,i,z)}function Pt(t,e,i){t.removeEventListener(e,i,z)}function wt(t,e,i){if(t&&e)if(t.classList)t.classList[i?"add":"remove"](e);else{var o=(" "+t.className+" ").replace(k," ").replace(" "+e+" "," ");t.className=(o+(i?" "+e:"")).replace(k," ")}}function Ct(t,e,i){var o=t&&t.style;if(o){if(void 0===i)return N.defaultView&&N.defaultView.getComputedStyle?i=N.defaultView.getComputedStyle(t,""):t.currentStyle&&(i=t.currentStyle),void 0===e?i:i[e];e in o||-1!==e.indexOf("webkit")||(e="-webkit-"+e),o[e]=i+("string"==typeof i?"":"px")}}function Mt(t){var e="";do{var i=Ct(t,"transform");i&&"none"!==i&&(e=i+" "+e)}while(t=t.parentNode);return window.DOMMatrix?new DOMMatrix(e):window.WebKitCSSMatrix?new WebKitCSSMatrix(e):window.CSSMatrix?new CSSMatrix(e):void 0}function St(t,e,i){if(t){var o=t.getElementsByTagName(e),n=0,s=o.length;if(i)for(;n<s;n++)i(o[n],n);return o}return[]}function Lt(t,e,i,n,s,a,r,l,c){var u,h=(t=t||e[D]).options,d="on"+i.charAt(0).toUpperCase()+i.substr(1);!window.CustomEvent||q||H?(u=N.createEvent("Event")).initEvent(i,!0,!0):u=new CustomEvent(i,{bubbles:!0,cancelable:!0}),u.to=s||e,u.from=a||e,u.item=n||e,u.clone=o,u.oldIndex=r,u.newIndex=l,u.originalEvent=c,u.pullMode=p?p.lastPutMode:void 0,e&&e.dispatchEvent(u),h[d]&&h[d].call(t,u)}function bt(t,e,i,o,n,s,a,r){var l,c,u=t[D],h=u.options.onMove;return!window.CustomEvent||q||H?(l=N.createEvent("Event")).initEvent("move",!0,!0):l=new CustomEvent("move",{bubbles:!0,cancelable:!0}),l.to=e,l.from=t,l.dragged=i,l.draggedRect=o,l.related=n||e,l.relatedRect=s||Bt(e),l.willInsertAfter=r,l.originalEvent=a,t.dispatchEvent(l),h&&(c=h.call(u,l,a)),c}function Rt(t){t.draggable=!1}function xt(){Q=!1}function It(e,o,n){for(var s=0,a=0,r=e.children;a<r.length;){if("none"!==r[a].style.display&&r[a]!==i&&r[a]!==t&&vt(r[a],n.draggable,e,!1)){if(s===o)return r[a];s++}a++}return null}function Gt(t){for(var e=t.lastElementChild;e&&(e===i||"none"===e.style.display);)e=e.previousElementSibling;return e||null}function At(e){return kt(t)<kt(e)?1:-1}function Tt(t){for(var e=t.tagName+t.className+t.src+t.href+t.textContent,i=e.length,o=0;i--;)o+=e.charCodeAt(i);return o.toString(36)}function kt(t,e){var i=0;if(!t||!t.parentNode)return-1;for(;t&&(t=t.previousElementSibling);)"TEMPLATE"!==t.nodeName.toUpperCase()&&t!==o&&i++;return i}function Dt(t,e){if(t)try{if(t.matches)return t.matches(e);if(t.msMatchesSelector)return t.msMatchesSelector(e);if(t.webkitMatchesSelector)return t.webkitMatchesSelector(e)}catch(t){return!1}return!1}function Ot(t,e){return function(){if(!ft){var i=arguments,o=this;ft=j((function(){1===i.length?t.call(o,i[0]):t.apply(o,i),ft=void 0}),e)}}}function Nt(t,e){if(t&&e)for(var i in e)e.hasOwnProperty(i)&&(t[i]=e[i]);return t}function Ut(t){return B&&B.dom?B.dom(t).cloneNode(!0):F?F(t).clone(!0)[0]:t.cloneNode(!0)}function jt(t){return j(t,0)}function Ft(t){return clearTimeout(t)}function Bt(t,e,i,o){if(t.getBoundingClientRect||t===O){var n,s,a,r,l,c,u;if(t!==O&&t!==st()?(s=(n=t.getBoundingClientRect()).top,a=n.left,r=n.bottom,l=n.right,c=n.height,u=n.width):(s=0,a=0,r=window.innerHeight,l=window.innerWidth,c=window.innerHeight,u=window.innerWidth),o&&t!==O&&(i=i||t.parentNode,!q))do{if(i&&i.getBoundingClientRect&&"none"!==Ct(i,"transform")){var h=i.getBoundingClientRect();s-=h.top+U(Ct(i,"border-top-width")),a-=h.left+U(Ct(i,"border-left-width")),r=s+n.height,l=a+n.width;break}}while(i=i.parentNode);if(e&&t!==O){var d=Mt(i||t),p=d&&d.a,m=d&&d.d;d&&(r=(s/=m)+(c/=m),l=(a/=p)+(u/=p))}return{top:s,left:a,bottom:r,right:l,width:u,height:c}}}function zt(t,e){for(var i=nt(t,!0),o=Bt(t)[e];i;){var n=Bt(i)[e];if(!("top"===e||"left"===e?o>=n:o<=n))return i;if(i===st())break;i=nt(i,!1)}return!1}function qt(t){var e=0,i=0,o=st();if(t)do{var n=Mt(t),s=n.a,a=n.d;e+=t.scrollLeft*s,i+=t.scrollTop*a}while(t!==o&&(t=t.parentNode));return[e,i]}return Et(N,"dragover",_t),Et(N,"mousemove",_t),Et(N,"touchmove",_t),gt.prototype={constructor:gt,_computeIsAligned:function(e){var o;if(i&&!Z?(pt(),o=N.elementFromPoint(e.clientX,e.clientY),mt()):o=e.target,o=vt(o,this.options.draggable,this.el,!1),!J&&t&&t.parentNode===this.el){for(var n,s,a,r,l,c,u,h,d=this.el.children,p=0;p<d.length;p++)vt(d[p],this.options.draggable,this.el,!1)&&d[p]!==o&&(d[p].sortableMouseAligned=(n=e.clientX,s=e.clientY,a=d[p],r=this._getDirection(e,null),this.options,l=void 0,c=void 0,u=void 0,h=void 0,l=Bt(a),c="vertical"===r?l.left:l.top,u="vertical"===r?l.right:l.bottom,c<(h="vertical"===r?n:s)&&h<u));vt(o,this.options.draggable,this.el,!0)||(E=null),J=!0,j((function(){J=!1}),30)}},_getDirection:function(e,i){return"function"==typeof this.options.direction?this.options.direction.call(this,e,i,t):this.options.direction},_onTapStart:function(e){if(e.cancelable){var i,o=this,n=this.el,s=this.options,r=s.preventOnFilter,l=e.type,c=e.touches&&e.touches[0],u=(c||e).target,h=e.target.shadowRoot&&(e.path&&e.path[0]||e.composedPath&&e.composedPath()[0])||u,d=s.filter;if(function(t){it.length=0;var e=t.getElementsByTagName("input"),i=e.length;for(;i--;){var o=e[i];o.checked&&it.push(o)}}(n),(!q||e.artificialBubble||ht(n,u))&&!t&&!(/mousedown|pointerdown/.test(l)&&0!==e.button||s.disabled||h.isContentEditable))if(u=vt(u,s.draggable,n,!1)){if(a!==u){if(i=kt(u,s.draggable),"function"==typeof d){if(d.call(this,e,u,this))return Lt(o,h,"filter",u,n,n,i),void(r&&e.cancelable&&e.preventDefault())}else if(d&&(d=d.split(",").some((function(t){if(t=vt(h,t.trim(),n,!1))return Lt(o,t,"filter",u,n,n,i),!0}))))return void(r&&e.cancelable&&e.preventDefault());s.handle&&!vt(h,s.handle,n,!1)||this._prepareDragStart(e,c,u,i)}}else q&&dt(n,e,"_onTapStart")}},_handleAutoScroll:function(e,i){if(t&&this.options.scroll){var o=e.clientX,n=e.clientY,s=N.elementFromPoint(o,n),a=this;if(i||H||q||V){rt(e,a.options,s,i);var r=nt(s,!0);!b||m&&o===f&&n===_||(m&&clearInterval(m),m=setInterval((function(){if(t){var s=nt(N.elementFromPoint(o,n),!0);s!==r&&(r=s,lt(),rt(e,a.options,r,i))}}),10),f=o,_=n)}else{if(!a.options.bubbleScroll||nt(s,!0)===st())return void lt();rt(e,a.options,nt(s,!1),!1)}}},_prepareDragStart:function(i,o,r,l){var c,h=this,p=h.el,m=h.options,f=p.ownerDocument;r&&!t&&r.parentNode===p&&(n=p,e=(t=r).parentNode,s=t.nextSibling,a=r,d=m.group,u=l,g={target:t,clientX:(o||i).clientX,clientY:(o||i).clientY},this._lastX=(o||i).clientX,this._lastY=(o||i).clientY,t.style["will-change"]="all",t.style.transition="",t.style.transform="",c=function(){h._disableDelayedDragEvents(),!W&&h.nativeDraggable&&(t.draggable=!0),h._triggerDragStart(i,o),Lt(h,n,"choose",t,n,n,u),wt(t,m.chosenClass,!0)},m.ignore.split(",").forEach((function(e){St(t,e.trim(),Rt)})),m.supportPointer?Et(f,"pointerup",h._onDrop):(Et(f,"mouseup",h._onDrop),Et(f,"touchend",h._onDrop),Et(f,"touchcancel",h._onDrop)),W&&this.nativeDraggable&&(this.options.touchStartThreshold=4,t.draggable=!0),!m.delay||this.nativeDraggable&&(H||q)?c():(Et(f,"mouseup",h._disableDelayedDrag),Et(f,"touchend",h._disableDelayedDrag),Et(f,"touchcancel",h._disableDelayedDrag),Et(f,"mousemove",h._delayedDragTouchMoveHandler),Et(f,"touchmove",h._delayedDragTouchMoveHandler),m.supportPointer&&Et(f,"pointermove",h._delayedDragTouchMoveHandler),h._dragStartTimer=j(c,m.delay)))},_delayedDragTouchMoveHandler:function(t){var e=t.touches?t.touches[0]:t;et($(e.clientX-this._lastX),$(e.clientY-this._lastY))>=Math.floor(this.options.touchStartThreshold/(this.nativeDraggable&&window.devicePixelRatio||1))&&this._disableDelayedDrag()},_disableDelayedDrag:function(){t&&Rt(t),clearTimeout(this._dragStartTimer),this._disableDelayedDragEvents()},_disableDelayedDragEvents:function(){var t=this.el.ownerDocument;Pt(t,"mouseup",this._disableDelayedDrag),Pt(t,"touchend",this._disableDelayedDrag),Pt(t,"touchcancel",this._disableDelayedDrag),Pt(t,"mousemove",this._delayedDragTouchMoveHandler),Pt(t,"touchmove",this._delayedDragTouchMoveHandler),Pt(t,"pointermove",this._delayedDragTouchMoveHandler)},_triggerDragStart:function(e,i){i=i||("touch"==e.pointerType?e:null),!this.nativeDraggable||i?this.options.supportPointer?Et(N,"pointermove",this._onTouchMove):Et(N,i?"touchmove":"mousemove",this._onTouchMove):(Et(t,"dragend",this),Et(n,"dragstart",this._onDragStart));try{N.selection?jt((function(){N.selection.empty()})):window.getSelection().removeAllRanges()}catch(t){}},_dragStarted:function(e,i){if(R=!1,n&&t){this.nativeDraggable&&(Et(N,"dragover",this._handleAutoScroll),Et(N,"dragover",ut));var o=this.options;!e&&wt(t,o.dragClass,!1),wt(t,o.ghostClass,!0),Ct(t,"transform",""),gt.active=this,e&&this._appendGhost(),Lt(this,n,"start",t,n,n,u,void 0,i)}else this._nulling()},_emulateDragOver:function(e){if(v){if(this._lastX===v.clientX&&this._lastY===v.clientY&&!e)return;this._lastX=v.clientX,this._lastY=v.clientY,pt();for(var i=N.elementFromPoint(v.clientX,v.clientY),o=i;i&&i.shadowRoot;)o=i=i.shadowRoot.elementFromPoint(v.clientX,v.clientY);if(o)do{if(o[D])if(o[D]._onDragOver({clientX:v.clientX,clientY:v.clientY,target:i,rootEl:o})&&!this.options.dragoverBubble)break;i=o}while(o=o.parentNode);t.parentNode[D]._computeIsAligned(v),mt()}},_onTouchMove:function(t,e){if(g){var o=this.options,n=o.fallbackTolerance,s=o.fallbackOffset,a=t.touches?t.touches[0]:t,r=i&&Mt(i),l=i&&r&&r.a,c=i&&r&&r.d,u=Y&&M&&qt(M),h=(a.clientX-g.clientX+s.x)/(l||1)+(u?u[0]-T[0]:0)/(l||1),d=(a.clientY-g.clientY+s.y)/(c||1)+(u?u[1]-T[1]:0)/(c||1),p=t.touches?"translate3d("+h+"px,"+d+"px,0)":"translate("+h+"px,"+d+"px)";if(!gt.active&&!R){if(n&&tt($(a.clientX-this._lastX),$(a.clientY-this._lastY))<n)return;this._onDragStart(t,!0)}!e&&this._handleAutoScroll(a,!0),y=!0,v=a,Ct(i,"webkitTransform",p),Ct(i,"mozTransform",p),Ct(i,"msTransform",p),Ct(i,"transform",p),t.cancelable&&t.preventDefault()}},_appendGhost:function(){if(!i){var e=this.options.fallbackOnBody?N.body:n,o=Bt(t,!0,e,!Y),s=(Ct(t),this.options);if(Y){for(M=e;"static"===Ct(M,"position")&&"none"===Ct(M,"transform")&&M!==N;)M=M.parentNode;if(M!==N){var a=Bt(M,!0);o.top-=a.top,o.left-=a.left}M!==N.body&&M!==N.documentElement?(M===N&&(M=st()),o.top+=M.scrollTop,o.left+=M.scrollLeft):M=st(),T=qt(M)}wt(i=t.cloneNode(!0),s.ghostClass,!1),wt(i,s.fallbackClass,!0),wt(i,s.dragClass,!0),Ct(i,"box-sizing","border-box"),Ct(i,"margin",0),Ct(i,"top",o.top),Ct(i,"left",o.left),Ct(i,"width",o.width),Ct(i,"height",o.height),Ct(i,"opacity","0.8"),Ct(i,"position",Y?"absolute":"fixed"),Ct(i,"zIndex","100000"),Ct(i,"pointerEvents","none"),e.appendChild(i)}},_onDragStart:function(e,i){var s=this,a=e.dataTransfer,r=s.options;(o=Ut(t)).draggable=!1,o.style["will-change"]="",this._hideClone(),wt(o,s.options.chosenClass,!1),s._cloneId=jt((function(){s.options.removeCloneOnHide||n.insertBefore(o,t),Lt(s,n,"clone",t)})),!i&&wt(t,r.dragClass,!0),i?(x=!0,s._loopId=setInterval(s._emulateDragOver,50)):(Pt(N,"mouseup",s._onDrop),Pt(N,"touchend",s._onDrop),Pt(N,"touchcancel",s._onDrop),a&&(a.effectAllowed="move",r.setData&&r.setData.call(s,a,t)),Et(N,"drop",s),Ct(t,"transform","translateZ(0)")),R=!0,s._dragStartId=jt(s._dragStarted.bind(s,i,e)),Et(N,"selectstart",s),V&&Ct(N.body,"user-select","none")},_onDragOver:function(i){var o,a,r,l=this.el,c=i.target,h=this.options,m=h.group,f=gt.active,_=d===m,g=h.sort,v=this;if(!Q&&(!q||i.rootEl||i.artificialBubble||ht(l,c))){if(void 0!==i.preventDefault&&i.cancelable&&i.preventDefault(),y=!0,c=vt(c,h.draggable,l,!0),vt(i.target,null,t,!0)||c.animated)return H(!1);if(c!==t&&(x=!1),f&&!h.disabled&&(_?g||(r=!n.contains(t)):p===this||(this.lastPutMode=d.checkPull(this,f,t,i))&&m.checkPut(this,f,t,i))){var M=this._getDirection(i,c);if(o=Bt(t),r)return this._hideClone(),e=n,s?n.insertBefore(t,s):n.appendChild(t),H(!0);var L=Gt(l);if(!L||function(t,e,i){var o=Bt(Gt(i)),n="vertical"===e?t.clientY:t.clientX,s="vertical"===e?t.clientX:t.clientY,a="vertical"===e?o.bottom:o.right,r="vertical"===e?o.left:o.top,l="vertical"===e?o.right:o.bottom;return"vertical"===e?s>l+10||s<=l&&n>a&&s>=r:n>a&&s>r||n<=a&&s>l+10}(i,M,l)&&!L.animated){if(L&&l===i.target&&(c=L),c&&(a=Bt(c)),_?f._hideClone():f._showClone(this),!1!==bt(n,l,t,o,c,a,i,!!c))return l.appendChild(t),e=l,S=null,W(),H(!0)}else if(c&&c!==t&&c.parentNode===l){var b,R=0,I=c.sortableMouseAligned,T=t.parentNode!==l,k="vertical"===M?"top":"left",O=zt(c,"top")||zt(t,"top"),U=O?O.scrollTop:void 0;if(E!==c&&(w=null,b=Bt(c)[k],G=!1),function(e,i,o){var n=e===t&&S||Bt(e),s=i===t&&S||Bt(i),a="vertical"===o?n.left:n.top,r="vertical"===o?n.right:n.bottom,l="vertical"===o?n.width:n.height,c="vertical"===o?s.left:s.top,u="vertical"===o?s.right:s.bottom,h="vertical"===o?s.width:s.height;return a===c||r===u||a+l/2===c+h/2}(t,c,M)&&I||T||O||h.invertSwap||"insert"===w||"swap"===w?("swap"!==w&&(A=h.invertSwap||T),R=function(e,i,o,n,s,a,r){var l=Bt(i),c="vertical"===o?e.clientY:e.clientX,u="vertical"===o?l.height:l.width,h="vertical"===o?l.top:l.left,d="vertical"===o?l.bottom:l.right,p=Bt(t),m=!1;if(!a)if(r&&C<u*n)if(!G&&(1===P?c>h+u*s/2:c<d-u*s/2)&&(G=!0),G)m=!0;else{"vertical"===o?p.top:p.left,"vertical"===o?p.bottom:p.right;if(1===P?c<h+C:c>d-C)return-1*P}else if(c>h+u*(1-n)/2&&c<d-u*(1-n)/2)return At(i);if((m=m||a)&&(c<h+u*s/2||c>d-u*s/2))return c>h+u/2?1:-1;return 0}(i,c,M,h.swapThreshold,null==h.invertedSwapThreshold?h.swapThreshold:h.invertedSwapThreshold,A,E===c),w="swap"):(R=At(c),w="insert"),0===R)return H(!1);S=null,E=c,P=R,a=Bt(c);var F=c.nextElementSibling,B=!1,z=bt(n,l,t,o,c,a,i,B=1===R);if(!1!==z)return 1!==z&&-1!==z||(B=1===z),Q=!0,j(xt,30),_?f._hideClone():f._showClone(this),B&&!F?l.appendChild(t):c.parentNode.insertBefore(t,B?F:c),O&&at(O,0,U-O.scrollTop),e=t.parentNode,void 0===b||A||(C=$(b-Bt(c)[k])),W(),H(!0)}if(l.contains(t))return H(!1)}return q&&!i.rootEl&&dt(l,i,"_onDragOver"),!1}function H(e){return e&&(_?f._hideClone():f._showClone(v),f&&(wt(t,p?p.options.ghostClass:f.options.ghostClass,!1),wt(t,h.ghostClass,!0)),p!==v&&v!==gt.active?p=v:v===gt.active&&(p=null),o&&v._animate(o,t),c&&a&&v._animate(a,c)),(c===t&&!t.animated||c===l&&!c.animated)&&(E=null),h.dragoverBubble||i.rootEl||c===N||(v._handleAutoScroll(i),t.parentNode[D]._computeIsAligned(i)),!h.dragoverBubble&&i.stopPropagation&&i.stopPropagation(),!0}function W(){Lt(v,n,"change",c,l,n,u,kt(t,h.draggable),i)}},_animate:function(e,i){var o=this.options.animation;if(o){var n=Bt(i);if(i===t&&(S=n),1===e.nodeType&&(e=Bt(e)),e.left+e.width/2!==n.left+n.width/2||e.top+e.height/2!==n.top+n.height/2){var s=Mt(this.el),a=s&&s.a,r=s&&s.d;Ct(i,"transition","none"),Ct(i,"transform","translate3d("+(e.left-n.left)/(a||1)+"px,"+(e.top-n.top)/(r||1)+"px,0)"),i.offsetWidth,Ct(i,"transition","transform "+o+"ms"+(this.options.easing?" "+this.options.easing:"")),Ct(i,"transform","translate3d(0,0,0)")}"number"==typeof i.animated&&clearTimeout(i.animated),i.animated=j((function(){Ct(i,"transition",""),Ct(i,"transform",""),i.animated=!1}),o)}},_offUpEvents:function(){var t=this.el.ownerDocument;Pt(N,"touchmove",this._onTouchMove),Pt(N,"pointermove",this._onTouchMove),Pt(t,"mouseup",this._onDrop),Pt(t,"touchend",this._onDrop),Pt(t,"pointerup",this._onDrop),Pt(t,"touchcancel",this._onDrop),Pt(N,"selectstart",this)},_onDrop:function(a){var r=this.el,l=this.options;R=!1,b=!1,A=!1,G=!1,clearInterval(this._loopId),clearInterval(m),lt(),clearTimeout(ft),ft=void 0,clearTimeout(this._dragStartTimer),Ft(this._cloneId),Ft(this._dragStartId),Pt(N,"mousemove",this._onTouchMove),this.nativeDraggable&&(Pt(N,"drop",this),Pt(r,"dragstart",this._onDragStart),Pt(N,"dragover",this._handleAutoScroll),Pt(N,"dragover",ut)),V&&Ct(N.body,"user-select",""),this._offUpEvents(),a&&(y&&(a.cancelable&&a.preventDefault(),!l.dropBubble&&a.stopPropagation()),i&&i.parentNode&&i.parentNode.removeChild(i),(n===e||p&&"clone"!==p.lastPutMode)&&o&&o.parentNode&&o.parentNode.removeChild(o),t&&(this.nativeDraggable&&Pt(t,"dragend",this),Rt(t),t.style["will-change"]="",wt(t,p?p.options.ghostClass:this.options.ghostClass,!1),wt(t,this.options.chosenClass,!1),Lt(this,n,"unchoose",t,e,n,u,null,a),n!==e?((h=kt(t,l.draggable))>=0&&(Lt(null,e,"add",t,e,n,u,h,a),Lt(this,n,"remove",t,e,n,u,h,a),Lt(null,e,"sort",t,e,n,u,h,a),Lt(this,n,"sort",t,e,n,u,h,a)),p&&p.save()):t.nextSibling!==s&&(h=kt(t,l.draggable))>=0&&(Lt(this,n,"update",t,e,n,u,h,a),Lt(this,n,"sort",t,e,n,u,h,a)),gt.active&&(null!=h&&-1!==h||(h=u),Lt(this,n,"end",t,e,n,u,h,a),this.save()))),this._nulling()},_nulling:function(){n=t=e=i=s=o=a=r=l=L.length=m=f=_=g=v=y=h=u=E=P=S=p=d=gt.active=null,it.forEach((function(t){t.checked=!0})),it.length=0},handleEvent:function(e){switch(e.type){case"drop":case"dragend":this._onDrop(e);break;case"dragenter":case"dragover":t&&(this._onDragOver(e),function(t){t.dataTransfer&&(t.dataTransfer.dropEffect="move");t.cancelable&&t.preventDefault()}(e));break;case"selectstart":e.preventDefault()}},toArray:function(){for(var t,e=[],i=this.el.children,o=0,n=i.length,s=this.options;o<n;o++)vt(t=i[o],s.draggable,this.el,!1)&&e.push(t.getAttribute(s.dataIdAttr)||Tt(t));return e},sort:function(t){var e={},i=this.el;this.toArray().forEach((function(t,o){var n=i.children[o];vt(n,this.options.draggable,i,!1)&&(e[t]=n)}),this),t.forEach((function(t){e[t]&&(i.removeChild(e[t]),i.appendChild(e[t]))}))},save:function(){var t=this.options.store;t&&t.set&&t.set(this)},closest:function(t,e){return vt(t,e||this.options.draggable,this.el,!1)},option:function(t,e){var i=this.options;if(void 0===e)return i[t];i[t]=e,"group"===t&&ct(i)},destroy:function(){var t=this.el;t[D]=null,Pt(t,"mousedown",this._onTapStart),Pt(t,"touchstart",this._onTapStart),Pt(t,"pointerdown",this._onTapStart),this.nativeDraggable&&(Pt(t,"dragover",this),Pt(t,"dragenter",this)),Array.prototype.forEach.call(t.querySelectorAll("[draggable]"),(function(t){t.removeAttribute("draggable")})),this._onDrop(),I.splice(I.indexOf(this.el),1),this.el=t=null},_hideClone:function(){o.cloneHidden||(Ct(o,"display","none"),o.cloneHidden=!0,o.parentNode&&this.options.removeCloneOnHide&&o.parentNode.removeChild(o))},_showClone:function(e){"clone"===e.lastPutMode?o.cloneHidden&&(n.contains(t)&&!this.options.group.revertClone?n.insertBefore(o,t):s?n.insertBefore(o,s):n.appendChild(o),this.options.group.revertClone&&this._animate(t,o),Ct(o,"display",""),o.cloneHidden=!1):this._hideClone()}},Et(N,"touchmove",(function(t){(gt.active||R)&&t.cancelable&&t.preventDefault()})),gt.utils={on:Et,off:Pt,css:Ct,find:St,is:function(t,e){return!!vt(t,e,t,!1)},extend:Nt,throttle:Ot,closest:vt,toggleClass:wt,clone:Ut,index:kt,nextTick:jt,cancelNextTick:Ft,detectDirection:ot,getChild:It},gt.create=function(t,e){return new gt(t,e)},gt.version="1.8.4",gt}))},function(t,e,i){"use strict";i.r(e);var o=i(2),n=i.n(o),s=i(34),a=i(40),r=i(140),l=i(36),c=i(142),u=i(146);function h(t){return(h="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}var d=s.default.getLogger("Isocurve"),p=n.a.Control.extend({includes:u.default,options:{position:"topleft",collapsed:!0,methods:["time","distance"],graphs:["Voiture","Pieton"],exclusions:{toll:!1,tunnel:!1,bridge:!1},directions:["departure","arrival"],disableReverse:!1,isocurveOptions:{},autocompleteOptions:{}},initialize:function(t){n.a.Util.setOptions(this,t),this._uid=l.default.generate(),this._isDesktop=this._detectSupport(),this._waitingContainer=null,this._showContainer=null,this._pictoContainer=null,this._formContainer=null,this._submitContainer=null,this._currentTransport=null,this._currentDirection=null,this._currentComputation=null,this._currentTimeHour=0,this._currentTimeMinute=0,this._currentDistance=0,this._currentExclusions=[],this._initTransport(),this._initComputation(),this._initDirection(),this._initExclusions(),this._currentPoint=null,this._geojsonIso=null,this._waiting=!1,this._timer=null,this._currentIsoResults=null,this._resources={},this._noRightManagement=!1,this._checkRightsManagement()},onAdd:function(t){var e=this._container=this._initLayout(t);return n.a.DomEvent.disableClickPropagation(e).disableScrollPropagation(e),e},onRemove:function(){},_initTransport:function(){this._currentTransport="Voiture";var t=this.options.graphs;t&&0!==t.length||(this.options.graphs=["Voiture","Pieton"]),n.a.Util.isArray(t)&&t.length&&("Voiture"!==t[0]&&"Pieton"!==t[0]||(this._currentTransport=t[0]));var e=this.options.isocurveOptions;e.graph&&(this._currentTransport=e.graph)},_initDirection:function(){this._currentDirection="departure";var t=this.options.directions;t&&0!==t.length||(this.options.directions=["departure","arrival"]),n.a.Util.isArray(t)&&t.length&&("departure"!==t[0]&&"arrival"!==t[0]||(this._currentDirection=t[0]));var e=this.options.isocurveOptions;e.reverse||(this._currentDirection="departure"),!0===e.reverse&&(this._currentDirection="arrival",this.options.directions=["arrival","departure"])},_initComputation:function(){this._currentComputation="time";var t=this.options.methods;t&&0!==t.length||(this.options.methods=["time","distance"]),n.a.Util.isArray(t)&&t.length&&("time"!==t[0]&&"distance"!==t[0]||(this._currentComputation=t[0]));var e=this.options.isocurveOptions;e.method&&(this._currentComputation=e.method),e.time&&(this._currentComputation="time"),e.distance&&(this._currentComputation="distance")},_initExclusions:function(){this._currentExclusions=[];var t=this.options.exclusions;if((!t||"object"===h(t)&&0===Object.keys(t).length)&&(this.options.exclusions={toll:!1,tunnel:!1,bridge:!1}),t&&"object"===h(t)&&Object.keys(t).length)for(var e in t)t.hasOwnProperty(e)&&t.k&&this._currentExclusions.push(e);var i=this.options.isocurveOptions;Array.isArray(i.exclusions)&&(this._currentExclusions=i.exclusions)},_checkRightsManagement:function(){var t=null,e=[],i=null;i=this.options.isocurveOptions.apiKey,(e=(t=this.options.isocurveOptions.filterOptions)?t.type:[])&&0!==e.length||(e=["Voiture","Pieton"]);var o=r.default.check({key:i||this.options.apiKey,resources:e,services:["Isochrone"]});d.log("rightManagementIsochrone",o),i=this.options.autocompleteOptions.apiKey,(e=(t=this.options.autocompleteOptions.filterOptions)?t.type:[])&&0!==e.length||(e=["PositionOfInterest","StreetAddress"]);var n=r.default.check({key:i||this.options.apiKey,resources:e,services:["AutoCompletion"]});d.log("rightManagementAutoComplete",n),o||n||(this._noRightManagement=!0),n&&(this._resources.AutoCompletion={},this._resources.AutoCompletion.resources=n.AutoCompletion,this._resources.AutoCompletion.key=n.key),o&&(this._resources.Isochrone={},this._resources.Isochrone.resources=o.Isochrone,this._resources.Isochrone.key=o.key)},_detectSupport:function(){var t=!0,e=window.navigator.userAgent.toLowerCase();return-1===e.indexOf("iphone")&&-1===e.indexOf("ipod")&&-1===e.indexOf("ipad")&&-1===e.indexOf("android")&&-1===e.indexOf("mobile")&&-1===e.indexOf("blackberry")&&-1===e.indexOf("tablet")&&-1===e.indexOf("phone")&&-1===e.indexOf("touch")||(t=!1),-1===e.indexOf("msie")&&-1===e.indexOf("trident")||(t=!0),t},_initLayout:function(t){var e=this._createMainContainerElement(),i=this._showContainer=this._createShowIsoElement();e.appendChild(i),this.options.collapsed||(i.checked=!0);var o=this._pictoContainer=this._createShowIsoPictoElement();e.appendChild(o);var n=this._createIsoPanelElement(),s=this._createIsoPanelHeaderElement();n.appendChild(s);var a=this._formContainer=this._createIsoPanelFormElement(),r=this._createIsoPanelFormPointElement(t);a.appendChild(r);for(var l=!1,c=!1,u=this._createIsoPanelFormTypeChoiceElement(),d=0;d<this.options.methods.length;d++)"time"===this.options.methods[d]&&(l=0===d,u.appendChild(this._createIsoPanelFormTypeChoiceChronElement(l))),"distance"===this.options.methods[d]&&(c=0===d,u.appendChild(this._createIsoPanelFormTypeChoiceDistElement(c)));a.appendChild(u),a.appendChild(this._createIsoPanelFormValueIsochronElement(l)),a.appendChild(this._createIsoPanelFormValueIsodistanceElement(c));var p=this._createIsoPanelFormModeChoiceElement();if(p.appendChild(this._createIsoPanelFormModeChoiceTransportElement(this.options.graphs)),p.appendChild(this._createIsoPanelFormModeChoiceDirectionElement(this.options.directions)),a.appendChild(p),this.options.exclusions&&"object"===h(this.options.exclusions)&&0!==Object.keys(this.options.exclusions).length){a.appendChild(this._createShowIsoExclusionsElement()),a.appendChild(this._createShowIsoExclusionsPictoElement());var m=this._createIsoPanelFormExclusionsElement();m.appendChild(this._createIsoPanelFormExclusionOptionsElement(this.options.exclusions)),a.appendChild(m)}var f=this._createIsoFormResetElement();a.appendChild(f);var _=this._submitContainer=this._createIsoSubmitFormElement();a.appendChild(_),n.appendChild(a);var g=this._waitingContainer=this._createIsoWaitingElement();return n.appendChild(g),e.appendChild(n),e},_createIsoPanelFormPointElement:function(t){return this._currentPoint=new c.default({apiKey:this.options.apiKey||null,tag:{id:0,unique:this._uid,label:"Départ",color:"red",display:!0},displayInfo:!0,disableReverse:this.options.disableReverse,autocompleteOptions:this.options.autocompleteOptions||null}),this._currentPoint.setMap(t),this._currentPoint.getContainer()},onShowIsoPanelClick:function(t){d.log("onShowIsoPanelClick",t)},onIsoResetClick:function(t){d.log("onIsoResetClick",t),this._clear()},onIsoTypeChoiceChange:function(t){var e=t.target.value;e&&("isodistance"===e&&(this._currentComputation="distance"),"isochron"===e&&(this._currentComputation="time"))},onIsoModeTransportChange:function(t){var e=t.target.value;e&&(this._currentTransport=e)},onIsoModeDirectionChange:function(t){var e=t.target.value;e&&(this._currentDirection=e)},onIsoValueChronTimeHourChange:function(t){var e=t.target.value;this._timeHourContainer=t.target,e&&(this._currentTimeHour=e)},onIsoValueChronTimeMinuteChange:function(t){var e=t.target.value;this._timeMinuteContainer=t.target,e&&(this._currentTimeMinute=e)},onIsoValueDistChange:function(t){var e=t.target.value;this._distanceContainer=t.target,e&&(this._currentDistance=e)},onIsoExclusionsChange:function(t){var e=t.target.value,i=t.target.checked;if(e){for(var o=!1,n=null,s=0;s<this._currentExclusions.length;s++)this._currentExclusions[s]===e&&(n=s,o=!0);o||i||this._currentExclusions.push(e),o&&i&&this._currentExclusions.splice(n,1)}},onIsoComputationSubmit:function(){var t,e;if(this._currentPoint&&this._currentPoint.getCoordinate&&this._currentPoint.getCoordinate())if("time"===this._currentComputation.toLowerCase()&&(t=3600*this._currentTimeHour+60*this._currentTimeMinute,d.log("time : ",t)),"distance"===this._currentComputation.toLowerCase()&&(e=1e3*this._currentDistance,d.log("distance : ",e)),t||e){if(!this._noRightManagement){this._displayWaitingContainer();var i=this;this._requestIsoCurve({position:i._currentPoint.getCoordinate(),graph:i._currentTransport,exclusions:i._currentExclusions,method:i._currentComputation,reverse:"arrival"===i._currentDirection.toLowerCase(),time:t,distance:e,smoothing:!0,timeout:7e3,protocol:"XHR",onSuccess:function(t){d.log(t),t&&i._drawIsoResults(t)},onFailure:function(t){i._hideWaitingContainer(),i._clearIsoResultsGeometry(),d.log(t.message)}})}}else d.log("Missing time or distance parameter")},_requestIsoCurve:function(t){if(t&&("object"!==h(t)||0!==Object.keys(t).length)&&t.position&&!this._noRightManagement){var e=this._resources.Isochrone;if(e){var i=e.resources;if(i&&("object"!==h(i)||0!==Object.keys(i).length)){var o={};n.a.Util.extend(o,t),n.a.Util.extend(o,this.options.isocurveOptions);for(var s=!1,r=0;r<i.length;r++)i[r]===o.graph&&(s=!0);if(s){var l=this._resources.Isochrone.key;o.apiKey=this.options.isocurveOptions.apiKey||this.options.apiKey||l,o.ssl=this.options.ssl,d.log(o),a.default.Services.isoCurve(o)}else d.log("no rights for this service !?")}}}},_drawIsoResults:function(t){if(this._clearIsoResultsGeometry(),this._currentIsoResults=t,t.geometry){var e=this._map,i=t.geometry;this._geojsonIso=n.a.geoJson(i,{style:{color:"#ff7800",weight:5,opacity:.65}}).addTo(e),this._hideWaitingContainer(),this._formContainer.className="GPisochroComponentHidden"}else this._hideWaitingContainer()},_clear:function(){this._initTransport(),this._initExclusions(),this._initComputation(),this._initDirection(),this._currentIsoResults=null,this._clearIsoResultsGeometry(),this._currentPoint.clear(),this._timeHourContainer&&(this._timeHourContainer.value=0),this._timeMinuteContainer&&(this._timeMinuteContainer.value=0),this._distanceContainer&&(this._distanceContainer.value=0)},_clearIsoResultsGeometry:function(){var t=this._map;null!=this._geojsonIso&&(t.removeLayer(this._geojsonIso),this._geojsonIso=null)},_displayWaitingContainer:function(){this._waitingContainer.className="GPisochronCalcWaitingContainerVisible",this._waiting=!0,this._timer&&(clearTimeout(this._timer),this._timer=null);var t=this;this._timer=setTimeout((function(){!0===t._waiting?t._hideWaitingContainer():t._timer&&clearTimeout(t._timer)}),16e3)},_hideWaitingContainer:function(){this._waiting&&(this._waitingContainer.className="GPisochronCalcWaitingContainerHidden",this._waiting=!1,clearTimeout(this._timer),this._timer=null)},compute:function(t,e,i){this._showContainer.checked||this._pictoContainer.click();var o=this._map;if(o){var s={direction:"departure",method:"time",transport:"Voiture",exclusions:[]};if(n.a.Util.extend(s,i),this._currentPoint.setCoordinate(t),n.a.DomUtil.get("GPlocationOrigin_0-"+this._uid).value=t.lng+" , "+t.lat,this._currentTransport=s.transport,"Voiture"===s.transport?n.a.DomUtil.get("GPisochronTransportCar-"+this._uid).checked=!0:n.a.DomUtil.get("GPisochronTransportPedestrian-"+this._uid).checked=!0,this._currentExclusions=s.exclusions,this._currentComputation=s.method,"time"===s.method){var a=e.split(".");this._currentTimeHour=a[0]||0,n.a.DomUtil.get("GPisochronValueChronInput1-"+this._uid).value=this._currentTimeHour,this._currentTimeMinute=a[1]||0,n.a.DomUtil.get("GPisochronValueChronInput2-"+this._uid).value=this._currentTimeMinute,n.a.DomUtil.get("GPisochronChoiceAltChron-"+this._uid).click()}else this._currentDistance=e,n.a.DomUtil.get("GPisochronValueDistInput-"+this._uid).value=this._currentDistance,n.a.DomUtil.get("GPisochronChoiceAltDist-"+this._uid).click();this._currentDirection=s.direction,n.a.DomUtil.get("GPisochronDirectionSelect-"+this._uid).selectedIndex="departure"===s.direction?0:1,this.onIsoComputationSubmit(),o.flyTo(t)}}});e.default=p},function(t,e,i){"use strict";i.r(e),i.d(e,"servicesVersion",(function(){return k})),i.d(e,"servicesDate",(function(){return D}));var o=i(41),n=i(56),s=i(68),a=i(69),r=i(117),l=i(118),c=i(73),u=i(74),h=i(75),d=i(76),p=i(77),m=i(78),f=i(79),_=i(80),g=i(81),v=i(82),y=i(83),E=i(85),P=i(86),w=i(84),C=i(107),M=i(109),S=i(108),L=i(114),b=i(139),R=i(131),x=i(132),I=i(49),G=i(45),A=i(47),T=i(57);const k=T.version,D=T.date;var O={};O.servicesVersion=k,O.servicesDate=D,O.Protocols={},O.Protocols.XHR=I.default,O.Services=o.default,O.Services.DefaultUrl=n.default,O.Services.AltiResponse=s.default,O.Services.Alti={},O.Services.Alti.Elevation=a.default,O.Services.AutoCompleteResponse=r.default,O.Services.AutoComplete={},O.Services.AutoComplete.SuggestedLocation=l.default,O.Services.GetConfigResponse=c.default,O.Services.Config={},O.Services.Config.Constraint=u.default,O.Services.Config.Format=h.default,O.Services.Config.Layer=d.default,O.Services.Config.Legend=p.default,O.Services.Config.Metadata=m.default,O.Services.Config.Originator=f.default,O.Services.Config.Service=_.default,O.Services.Config.Style=g.default,O.Services.Config.Territory=v.default,O.Services.Config.Thematic=y.default,O.Services.Config.TileMatrix=E.default,O.Services.Config.TileMatrixLimit=P.default,O.Services.Config.TileMatrixSet=w.default,O.Services.GeocodeResponse=C.default,O.Services.Geocode={},O.Services.Geocode.GeocodedLocation=M.default,O.Services.Geocode.DirectGeocodedLocation=S.default,O.Services.Geocode.ReverseGeocodedLocation=L.default,O.Services.IsoCurveResponse=b.default,O.Services.RouteResponse=R.default,O.Services.Route={},O.Services.Route.RouteInstruction=x.default,O.Error=G.default,O.Helper=A.default,e.default=O},function(t,e,i){"use strict";i.r(e);var o=i(42),n=i(70),s=i(87),a=i(110),r=i(115),l=i(119),c=i(134),u={getConfig:function(t){new n.default(t).call()},getAltitude:function(t){new o.default(t).call()},geocode:function(t){new s.default(t).call()},reverseGeocode:function(t){new a.default(t).call()},autoComplete:function(t){new r.default(t).call()},route:function(t){new l.default(t).call()},isoCurve:function(t){new c.default(t).call()}};e.default=u},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(44),s=i(45),a=i(46),r=i(56),l=i(58),c=i(65);function u(t){if(!(this instanceof u))throw new TypeError(n.default.getMessage("CLASS_CONSTRUCTOR","Alti"));if(this.CLASSNAME="Alti",a.default.apply(this,arguments),this.logger=o.default.getLogger("Gp.Services.Alti"),this.logger.trace("[Constructeur Alti (options)]"),!t.positions)throw new Error(n.default.getMessage("PARAM_MISSING","positions"));if(0===t.positions.length)throw new Error(n.default.getMessage("PARAM_EMPTY","positions"));if(this.options.positions=t.positions,this.options.outputFormat="string"==typeof t.outputFormat?t.outputFormat.toLowerCase():"xml",this.options.sampling=t.sampling||null,this.options.api="string"==typeof t.api?t.api.toUpperCase():"REST","REST"===this.options.api&&(this.options.httpMethod="GET"),this.options.zonly=t.zonly||!1,!this.options.serverUrl){var e=r.default.Alti.url(this.options.apiKey),i=null;switch(this.options.api){case"WPS":i=e.wps;break;case"REST":i=e[(t.sampling?"profil":"elevation")+"-"+this.options.outputFormat];break;default:throw new Error(n.default.getMessage("PARAM_UNKNOWN","api"))}if(!i)throw new Error("Url by default not found !");this.options.serverUrl=i,this.logger.trace("Server URL by default : "+this.options.serverUrl)}var s=this.options.serverUrl.lastIndexOf(".");if(-1!==s){var l=this.options.serverUrl.substring(s+1);if(l&&l.length<5)switch(this.logger.trace("Server Extension URL : "+l),l.toLowerCase()){case"json":case"xml":this.options.outputFormat=l.toLowerCase();break;default:throw new Error("type of service : unknown or unsupported (json or xml) !")}}}u.prototype=Object.create(a.default.prototype,{}),u.prototype.constructor=u,u.prototype.buildRequest=function(t,e){var i={httpMethod:this.options.httpMethod,onSuccess:function(t){this.request=t,e.call(this,this.request)},onError:t,scope:this,positions:this.options.positions,outputFormat:this.options.outputFormat,sampling:this.options.sampling,api:this.options.api,zonly:this.options.zonly};l.default.build(i)},u.prototype.analyzeResponse=function(t,e){if(this.response){var i={response:this.response,outputFormat:this.options.outputFormat,rawResponse:this.options.rawResponse,onError:t,onSuccess:e,scope:this};c.default.build(i)}else t.call(this,new s.default(n.default.getMessage("SERVICE_RESPONSE_EMPTY")))},e.default=u},function(t,e,i){"use strict";i.r(e);var o=i(35),n={getLogger:function(t){"false".match(/true/)?o.disableAll():o.enableAll();var e=t||"default";return o.getLogger(e)}};e.default=n},function(t,e,i){"use strict";i.r(e);var o={PARAM_MISSING:"Parameter(s) '%var%' missing",PARAM_EMPTY:"Parameter(s) '%var%' empty",PARAM_TYPE:"Wrong type(s) for parameter(s) '%var%'",PARAM_FORMAT:"Parameter(s) '%var%' not correctly formatted",PARAM_NOT_SUPPORT:"Value(s) for parameter(s) '%var%' not supported",PARAM_NOT_SUPPORT_NODEJS:"Value(s) for parameter(s) '%var%' not supported to NodeJS",PARAM_UNKNOWN:"Value(s) for parameter(s) '%var%' unknown",SERVICE_REQUEST_BUILD:"An error occurred during the request building of the service",SERVICE_REQUEST_EMPTY:"The request sent to the service is empty",SERVICE_RESPONSE_EXCEPTION:"The service returned an exception : '%var%'",SERVICE_RESPONSE_EXCEPTION_2:"The service returned an exception",SERVICE_RESPONSE_ANALYSE:"An error occurred while parsing the response '%var%' of the service",SERVICE_RESPONSE_ANALYSE_2:"An unknown error occurred while parsing the response",SERVICE_RESPONSE_EMPTY:"The response of the service is empty",SERVICE_RESPONSE_EMPTY_2:"The response from the service could not be analyzed or is empty",SERVICE_RESPONSE_FORMAT:"The format of the service response is not supported (handled format(s) : '%var%')",SERVICE_RESPONSE_FORMAT_2:"The format of the service response is not supported",SERVICE_RESPONSE_FORMAT_3:"No suggestion matching the search",CLASS_CONSTRUCTOR:"'%var%' constructor cannot be called as a function.",getMessage:function(t,e){if(0===Object.keys(arguments).length)return"Message indefined !";var i=Array.prototype.slice.call(arguments),o=i.shift(),n=i,s=this[o];try{s=Array.isArray(n)&&n.length>0?s.replace("%var%",n.join(" - ")):s.replace("%var%","%var% (not specified)")}catch(t){}return s}};e.default=o},function(t,e,i){"use strict";function o(t){if(!(this instanceof o))throw new TypeError("ErrorService constructor cannot be called as a function.");var e=t;"string"==typeof t||t instanceof String?(this.message=t,this.status=-1,this.type=o.TYPE_UNKERR):(this.message=e.message||"undefined!?",this.type=e.type,this.status=e.status||-1),this.name="ErrorService",this.stack=(new Error).stack}i.r(e),o.TYPE_SRVERR="SERVICE_ERROR",o.TYPE_USEERR="USAGE_ERROR",o.TYPE_UNKERR="UNKNOWN_ERROR",o.prototype=Object.create(Error.prototype,{constructor:{value:o,writable:!0,configurable:!0}}),e.default=o},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(47),s=i(44),a=i(48),r=i(45),l=i(56),c=i(57);function u(t){if(!(this instanceof u))throw new TypeError(s.default.getMessage("CLASS_CONSTRUCTOR"));for(var e in this.logger=o.default.getLogger("CommonService"),this.logger.trace("[Constructeur CommonService (options)]"),this.options={protocol:"XHR",ssl:!0,proxyURL:"",callbackSuffix:null,httpMethod:"GET",timeOut:0,rawResponse:!1,scope:this,onSuccess:function(t){console.log("onSuccess - la reponse est la suivante : ",t)},onFailure:function(t){200!==t.status&&t.status?console.log("onFailure - Erreur (",t.status,") : ",t.message):console.log("onFailure : ",t.message)}},t)t.hasOwnProperty(e)&&(this.options[e]=t[e]);if(!this.options.apiKey&&!this.options.serverUrl)throw new Error(s.default.getMessage("PARAM_MISSING","apiKey","serverUrl"));if(this.options.rawResponse&&!this.options.onSuccess&&(this.options.onSuccess=function(t){console.log("onSuccess - la réponse brute du service est la suivante : ",t)}),!!(null===this.options.onSuccess||"function"!=typeof this.options.onSuccess))throw new Error(s.default.getMessage("PARAM_MISSING","onSuccess()"));if(!this.options.serverUrl){l.default.ssl=this.options.ssl;var i=l.default[this.CLASSNAME].url(this.options.apiKey);"string"==typeof i?this.options.serverUrl=i:this.logger.trace("URL par defaut à determiner au niveau du composant...")}switch(this.options.httpMethod="string"==typeof t.httpMethod?t.httpMethod.toUpperCase():"GET",this.options.httpMethod){case"POST":case"GET":break;case"PUT":case"DELETE":case"HEAD":case"OPTIONS":throw new Error(s.default.getMessage("PARAM_NOT_SUPPORT","httpMethod"));default:throw new Error(s.default.getMessage("PARAM_UNKNOWN","httpMethod"))}switch(this.options.protocol="string"==typeof t.protocol?t.protocol.toUpperCase():"XHR",this.options.protocol){case"JSONP":case"XHR":break;default:throw new Error(s.default.getMessage("PARAM_UNKNOWN","protocol"))}if("undefined"==typeof window&&"JSONP"===this.options.protocol)throw new Error(s.default.getMessage("PARAM_NOT_SUPPORT_NODEJS","protocol=JSONP (instead use XHR)"));"JSONP"===this.options.protocol&&(this.options.httpMethod="GET"),this.options.nocache=t.nocache||!1,this.options.outputFormat=null,this.request=null,this.response=null}u.prototype={constructor:u,call:function(){this.logger.trace("CommonService::call ()");var t=this;function e(e){this.logger.trace("CommonService::onBuildRequest : ",e),this.callService.call(t,n,i)}function i(e){this.logger.trace("CommonService::onCallService : ",e),this.analyzeResponse.call(t,n,o)}function o(t){if(this.logger.trace("CommonService::onAnalyzeResponse : ",t),!t)return n.call(this,new r.default("Analyse de la reponse en échec !?"));this.options.onSuccess.call(this,t)}function n(t){this.logger.trace("CommonService::onError()");var e=t;e instanceof r.default||(e=new r.default(t.message)),this.options.onFailure.call(this,e)}(function(){this.logger.trace("CommonService::run ()"),this.buildRequest.call(t,n,e)}).call(t)},buildRequest:function(t,e){this.logger.error("overwritten method !"),t&&t.call(this,"This method must be overwritten !"),e.call(this,"This method must be overwritten !")},callService:function(t,e){var i=null,o=this.request,s=!(!this.options.proxyURL||"XHR"!==this.options.protocol);this.options.serverUrl=n.default.normalyzeUrl(this.options.serverUrl,{"gp-access-lib":c.version},!1),s&&("GET"===this.options.httpMethod&&(i=this.options.proxyURL+n.default.normalyzeUrl(this.options.serverUrl,this.request,!0),o=null),"POST"===this.options.httpMethod&&(i=this.options.proxyURL+n.default.normalyzeUrl(this.options.serverUrl,null,!0),o=this.request));var l=this,u={url:i||this.options.serverUrl,method:this.options.httpMethod,protocol:this.options.protocol,timeOut:this.options.timeOut||0,format:this.options.outputFormat,nocache:this.options.nocache||!1,wrap:"XHR"!==this.options.protocol,callbackSuffix:this.options.callbackSuffix,data:o,headers:null,content:this.options.contentType||"application/xml",scope:this.options.scope||this,onResponse:function(i){l.logger.trace("callService::onResponse()");var o=null;if("XHR"===l.options.protocol&&(l.logger.trace("Response XHR",i),o=i),"JSONP"===l.options.protocol){if(l.logger.trace("Response JSON",i),!i)return void t.call(l,new r.default("Le contenu de la reponse est vide !?"));if(i.http){if(200!==i.http.status)return void t.call(l,new r.default({status:i.http.status,message:i.http.error,type:r.default.TYPE_SRVERR}));o=i.xml,l.options.rawResponse&&(o=i)}else o=i}if("function"==typeof l.options.onBeforeParse){var n=l.options.onBeforeParse(o);"string"==typeof n&&(o=n)}l.response=o,e.call(l,o)},onFailure:function(e){l.logger.trace("callService::onFailure()"),e.type=r.default.TYPE_SRVERR,t.call(l,new r.default(e))},onTimeOut:function(){l.logger.trace("callService::onTimeOut()"),t.call(l,new r.default("TimeOut!"))}};a.default.send(u)},analyzeResponse:function(t,e){this.logger.error("overwritten method !"),t&&t.call(this,"This method must be overwritten !"),e.call(this,"This method must be overwritten !")}},e.default=u},function(t,e,i){"use strict";i.r(e);var o={normalyzeParameters:function(t){var e=null;if(t){var i=[];for(var o in t)if(t.hasOwnProperty(o)){var n=t[o];n||(n=""),i.push(o+"="+n)}e=i.join("&")}return e},normalyzeUrl:function(t,e,i){var o=t;if(t){var n=t.indexOf("?");-1===n&&(o+="?"),-1!==n&&n!==t.length-1&&(o+="&")}return e&&(o+="string"==typeof e?e:this.normalyzeParameters(e)),i&&(o=encodeURIComponent(o)),o},indent:function(t,e){return new Array((t||0)+1).join("\t")+e}};e.default=o},function(t,e,i){"use strict";i.r(e);var o=i(47),n=i(49),s=i(55),a={send:function(t){var e=t||{method:"GET",protocol:"XHR",timeOut:0,format:null,wrap:!0,nocache:!0,output:"json",callback:null,callbackSuffix:null};if("undefined"!=typeof window||"JSONP"!==t.protocol){if("XHR"===t.protocol||"json"===t.format?e.wrap=!1:"JSONP"===t.protocol&&"xml"===t.format&&(e.wrap=!0),e.callback=(t.protocol,null),e.output=e.wrap?"json":null,e.wrap){var i={};i.output=e.output,i.callback=e.callback,delete i.callback,e.url=o.default.normalyzeUrl(t.url,i)}switch(e.protocol){case"XHR":"GET"===t.method&&t.nocache&&(e.url=o.default.normalyzeUrl(e.url,{t:(new Date).getTime()})),n.default.call(e);break;case"JSONP":e.data&&(e.url=o.default.normalyzeUrl(e.url,e.data)),s.default.call(e);break;default:throw new Error("protocol not supported (XHR|JSONP) !")}}else console.log("Value (s) for parameter (s) 'protocol=JSONP (instead use XHR)' not supported to NodeJS")}};e.default=a},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(47),s=i(50),a=i.n(s),r={call:function(t){var e=o.default.getLogger("XHR");if(e.trace("[XHR::call()]"),a.a.polyfill(),!t.url)throw new Error("missing parameter : url is not defined !");if(!t.method)throw new Error("missing parameter : method is not defined !");t.format||(t.format="text");var i={};switch(i.url=t.url,i.data=t.data?t.data:null,i.method=t.method,i.timeOut=t.timeOut||0,i.scope=t.scope||this,i.proxy=t.proxy||null,i.content=t.content||null,i.headers=t.headers||{referer:"http://localhost"},t.method){case"DELETE":case"GET":break;case"PUT":case"POST":i.content=t.content?t.content:"application/x-www-form-urlencoded",i.headers=t.headers?t.headers:{referer:"http://localhost"};break;case"HEAD":case"OPTIONS":throw new Error("HTTP method not yet supported !");default:throw new Error("HTTP method unknown !")}switch(t.format){case"text":this.__call(i).then((function(i){e.trace(i),t.onResponse.call(this,i)})).catch((function(e){t.onFailure.call(this,e)}));break;case"json":this.__callJSON(i).then((function(i){e.trace(i),t.onResponse.call(this,i)})).catch((function(e){t.onFailure.call(this,e)}));break;case"xml":this.__callXML(i).then((function(i){e.trace(i),t.onResponse.call(this,i)})).catch((function(e){t.onFailure.call(this,e)}));break;default:throw new Error("This output Format is not yet supported !")}},__call:function(t){var e=o.default.getLogger("XHR");return e.trace("[XHR::__call()]"),new Promise((function(o,s){var a="POST"===t.method||"PUT"===t.method?1:0;t.data&&("object"==typeof t.data&&Object.keys(t.data).length||"string"==typeof t.data&&t.data.length)&&!a&&(t.url=n.default.normalyzeUrl(t.url,t.data)),e.trace("URL = ",t.url);var r=null;if("undefined"==typeof window){var l=i(53);t.data&&"string"==typeof t.data&&a&&(t.body=t.data),t.rejectUnauthorized=!1,l(t,(function(t,e,i){!t&&200===e.statusCode&&i?o(i):s("Errors Occured on Http Request (nodejs) : "+t)}))}else if(window.XMLHttpRequest){e.trace("XMLHttpRequest"),(r=new XMLHttpRequest).open(t.method,t.url,!0),r.overrideMimeType=t.content;var c=null;t.timeOut>0&&(e.trace("XHR - TimeOut actif !"),c=window.setTimeout((function(){s({message:"TimeOut Occured on Http Request with XMLHttpRequest !",status:-1})}),t.timeOut)),a&&(e.trace("data = ",t.data),r.setRequestHeader("Content-type",t.content)),r.onerror=function(t){console.log(t),s(new Error("Errors Occured on Http Request with XMLHttpRequest !"))},r.ontimeout=function(t){console.log(t),s(new Error("TimeOut Occured on Http Request with XMLHttpRequest !"))},r.onreadystatechange=function(t){if(4===r.readyState)if(200===r.status)window.clearTimeout(c),o(r.response);else{var e="Errors Occured on Http Request (status : '"+t.target.statusText+"' | url : '"+t.target.responseURL+"')",i=t.target.status;s({message:e,status:i})}};var u=t.data&&a?t.data:null;r.send(u)}else{if(!window.XDomainRequest)throw new Error("CORS not supported");e.trace("XDomainRequest"),(r=new XDomainRequest).open(t.method,t.url),r.overrideMimeType=t.content,t.timeOut>0&&(r.timeout=t.timeout,e.trace("XHR - TimeOut actif !")),a&&r.setRequestHeader("Content-type",t.content),r.onerror=function(){s(new Error("Errors Occured on Http Request with XMLHttpRequest !"))},r.ontimeout=function(){s(new Error("TimeOut Occured on Http Request with XMLHttpRequest !"))},r.onload=function(t){if(200===r.status)o(r.responseText);else{var e="Errors Occured on Http Request (status : '"+t.target.statusText+"' | url : '"+t.target.responseURL+"')",i=t.target.status;s({message:e,status:i})}};var h=t.data&&a?t.data:null;r.send(h)}}))},__callJSON:function(t){return this.__call(t).then(JSON.parse).catch((function(e){console.log("_callJSON failed on : ",t.url,e)}))},__callXML:function(t){return this.__call(t).then((function(t){var e;"undefined"==typeof window?e=(new(0,i(54).DOMParser)).parseFromString(t,"text/xml"):window.DOMParser?e=(new window.DOMParser).parseFromString(t,"text/xml"):((e=new window.ActiveXObject("Microsoft.XMLDOM")).async=!1,e.loadXML(t));return e})).catch((function(e){console.log("__callXML failed on : ",t.url,e)}))}};e.default=r},function(t,e,i){(function(e,i){
/*!
 * @overview es6-promise - a tiny implementation of Promises/A+.
 * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
 * @license   Licensed under MIT license
 *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
 * @version   v4.2.8+1e68dce6
 */var o;o=function(){"use strict";function t(t){return"function"==typeof t}var o=Array.isArray?Array.isArray:function(t){return"[object Array]"===Object.prototype.toString.call(t)},n=0,s=void 0,a=void 0,r=function(t,e){m[n]=t,m[n+1]=e,2===(n+=2)&&(a?a(f):E())},l="undefined"!=typeof window?window:void 0,c=l||{},u=c.MutationObserver||c.WebKitMutationObserver,h="undefined"==typeof self&&void 0!==e&&"[object process]"==={}.toString.call(e),d="undefined"!=typeof Uint8ClampedArray&&"undefined"!=typeof importScripts&&"undefined"!=typeof MessageChannel;function p(){var t=setTimeout;return function(){return t(f,1)}}var m=new Array(1e3);function f(){for(var t=0;t<n;t+=2)(0,m[t])(m[t+1]),m[t]=void 0,m[t+1]=void 0;n=0}var _,g,v,y,E=void 0;function P(t,e){var i=this,o=new this.constructor(M);void 0===o[C]&&N(o);var n=i._state;if(n){var s=arguments[n-1];r((function(){return D(n,o,s,i._result)}))}else T(i,o,t,e);return o}function w(t){if(t&&"object"==typeof t&&t.constructor===this)return t;var e=new this(M);return x(e,t),e}h?E=function(){return e.nextTick(f)}:u?(g=0,v=new u(f),y=document.createTextNode(""),v.observe(y,{characterData:!0}),E=function(){y.data=g=++g%2}):d?((_=new MessageChannel).port1.onmessage=f,E=function(){return _.port2.postMessage(0)}):E=void 0===l?function(){try{var t=Function("return this")().require("vertx");return void 0!==(s=t.runOnLoop||t.runOnContext)?function(){s(f)}:p()}catch(t){return p()}}():p();var C=Math.random().toString(36).substring(2);function M(){}var S=void 0,L=1,b=2;function R(e,i,o){i.constructor===e.constructor&&o===P&&i.constructor.resolve===w?function(t,e){e._state===L?G(t,e._result):e._state===b?A(t,e._result):T(e,void 0,(function(e){return x(t,e)}),(function(e){return A(t,e)}))}(e,i):void 0===o?G(e,i):t(o)?function(t,e,i){r((function(t){var o=!1,n=function(t,e,i,o){try{t.call(e,i,o)}catch(t){return t}}(i,e,(function(i){o||(o=!0,e!==i?x(t,i):G(t,i))}),(function(e){o||(o=!0,A(t,e))}),t._label);!o&&n&&(o=!0,A(t,n))}),t)}(e,i,o):G(e,i)}function x(t,e){if(t===e)A(t,new TypeError("You cannot resolve a promise with itself"));else if(function(t){var e=typeof t;return null!==t&&("object"===e||"function"===e)}(e)){var i=void 0;try{i=e.then}catch(e){return void A(t,e)}R(t,e,i)}else G(t,e)}function I(t){t._onerror&&t._onerror(t._result),k(t)}function G(t,e){t._state===S&&(t._result=e,t._state=L,0!==t._subscribers.length&&r(k,t))}function A(t,e){t._state===S&&(t._state=b,t._result=e,r(I,t))}function T(t,e,i,o){var n=t._subscribers,s=n.length;t._onerror=null,n[s]=e,n[s+L]=i,n[s+b]=o,0===s&&t._state&&r(k,t)}function k(t){var e=t._subscribers,i=t._state;if(0!==e.length){for(var o=void 0,n=void 0,s=t._result,a=0;a<e.length;a+=3)o=e[a],n=e[a+i],o?D(i,o,n,s):n(s);t._subscribers.length=0}}function D(e,i,o,n){var s=t(o),a=void 0,r=void 0,l=!0;if(s){try{a=o(n)}catch(t){l=!1,r=t}if(i===a)return void A(i,new TypeError("A promises callback cannot return that same promise."))}else a=n;i._state!==S||(s&&l?x(i,a):!1===l?A(i,r):e===L?G(i,a):e===b&&A(i,a))}var O=0;function N(t){t[C]=O++,t._state=void 0,t._result=void 0,t._subscribers=[]}var U=function(){function t(t,e){this._instanceConstructor=t,this.promise=new t(M),this.promise[C]||N(this.promise),o(e)?(this.length=e.length,this._remaining=e.length,this._result=new Array(this.length),0===this.length?G(this.promise,this._result):(this.length=this.length||0,this._enumerate(e),0===this._remaining&&G(this.promise,this._result))):A(this.promise,new Error("Array Methods must be provided an Array"))}return t.prototype._enumerate=function(t){for(var e=0;this._state===S&&e<t.length;e++)this._eachEntry(t[e],e)},t.prototype._eachEntry=function(t,e){var i=this._instanceConstructor,o=i.resolve;if(o===w){var n=void 0,s=void 0,a=!1;try{n=t.then}catch(t){a=!0,s=t}if(n===P&&t._state!==S)this._settledAt(t._state,e,t._result);else if("function"!=typeof n)this._remaining--,this._result[e]=t;else if(i===j){var r=new i(M);a?A(r,s):R(r,t,n),this._willSettleAt(r,e)}else this._willSettleAt(new i((function(e){return e(t)})),e)}else this._willSettleAt(o(t),e)},t.prototype._settledAt=function(t,e,i){var o=this.promise;o._state===S&&(this._remaining--,t===b?A(o,i):this._result[e]=i),0===this._remaining&&G(o,this._result)},t.prototype._willSettleAt=function(t,e){var i=this;T(t,void 0,(function(t){return i._settledAt(L,e,t)}),(function(t){return i._settledAt(b,e,t)}))},t}(),j=function(){function e(t){this[C]=O++,this._result=this._state=void 0,this._subscribers=[],M!==t&&("function"!=typeof t&&function(){throw new TypeError("You must pass a resolver function as the first argument to the promise constructor")}(),this instanceof e?function(t,e){try{e((function(e){x(t,e)}),(function(e){A(t,e)}))}catch(e){A(t,e)}}(this,t):function(){throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.")}())}return e.prototype.catch=function(t){return this.then(null,t)},e.prototype.finally=function(e){var i=this.constructor;return t(e)?this.then((function(t){return i.resolve(e()).then((function(){return t}))}),(function(t){return i.resolve(e()).then((function(){throw t}))})):this.then(e,e)},e}();return j.prototype.then=P,j.all=function(t){return new U(this,t).promise},j.race=function(t){var e=this;return o(t)?new e((function(i,o){for(var n=t.length,s=0;s<n;s++)e.resolve(t[s]).then(i,o)})):new e((function(t,e){return e(new TypeError("You must pass an array to race."))}))},j.resolve=w,j.reject=function(t){var e=new this(M);return A(e,t),e},j._setScheduler=function(t){a=t},j._setAsap=function(t){r=t},j._asap=r,j.polyfill=function(){var t=void 0;if(void 0!==i)t=i;else if("undefined"!=typeof self)t=self;else try{t=Function("return this")()}catch(t){throw new Error("polyfill failed because global object is unavailable in this environment")}var e=t.Promise;if(e){var o=null;try{o=Object.prototype.toString.call(e.resolve())}catch(t){}if("[object Promise]"===o&&!e.cast)return}t.Promise=j},j.Promise=j,j},t.exports=o()}).call(this,i(51),i(52))},function(t,e){var i,o,n=t.exports={};function s(){throw new Error("setTimeout has not been defined")}function a(){throw new Error("clearTimeout has not been defined")}function r(t){if(i===setTimeout)return setTimeout(t,0);if((i===s||!i)&&setTimeout)return i=setTimeout,setTimeout(t,0);try{return i(t,0)}catch(e){try{return i.call(null,t,0)}catch(e){return i.call(this,t,0)}}}!function(){try{i="function"==typeof setTimeout?setTimeout:s}catch(t){i=s}try{o="function"==typeof clearTimeout?clearTimeout:a}catch(t){o=a}}();var l,c=[],u=!1,h=-1;function d(){u&&l&&(u=!1,l.length?c=l.concat(c):h=-1,c.length&&p())}function p(){if(!u){var t=r(d);u=!0;for(var e=c.length;e;){for(l=c,c=[];++h<e;)l&&l[h].run();h=-1,e=c.length}l=null,u=!1,function(t){if(o===clearTimeout)return clearTimeout(t);if((o===a||!o)&&clearTimeout)return o=clearTimeout,clearTimeout(t);try{o(t)}catch(e){try{return o.call(null,t)}catch(e){return o.call(this,t)}}}(t)}}function m(t,e){this.fun=t,this.array=e}function f(){}n.nextTick=function(t){var e=new Array(arguments.length-1);if(arguments.length>1)for(var i=1;i<arguments.length;i++)e[i-1]=arguments[i];c.push(new m(t,e)),1!==c.length||u||r(p)},m.prototype.run=function(){this.fun.apply(null,this.array)},n.title="browser",n.browser=!0,n.env={},n.argv=[],n.version="",n.versions={},n.on=f,n.addListener=f,n.once=f,n.off=f,n.removeListener=f,n.removeAllListeners=f,n.emit=f,n.prependListener=f,n.prependOnceListener=f,n.listeners=function(t){return[]},n.binding=function(t){throw new Error("process.binding is not supported")},n.cwd=function(){return"/"},n.chdir=function(t){throw new Error("process.chdir is not supported")},n.umask=function(){return 0}},function(t,e){var i;i=function(){return this}();try{i=i||new Function("return this")()}catch(t){"object"==typeof window&&(i=window)}t.exports=i},function(t,i){t.exports=e},function(t,e){t.exports=i},function(t,e,i){"use strict";i.r(e);var o,n=i(43),s={uuid:(o=Math.floor(Date.now()),function(){return o++}),call:function(t){var e=n.default.getLogger("JSONP");if(e.trace("[JSONP::call ()]"),!t)throw e.error("missing parameter : options !"),new Error("missing parameter : options !");if(!t.url)throw e.error("missing parameter : options.url !"),new Error("missing parameter : options.url !");if(t.timeOut||(e.info("setting 'options.timeOut' default value"),t.timeOut=0),!t.onResponse)throw e.error("missing parameter : options.onResponse !"),new Error("missing parameter : options.onResponse !");var i="string"==typeof t.callbackSuffix?t.callbackSuffix:this.uuid(),o=!1,s=!1,a=t.url.indexOf("callback=");if(-1!==a){o=!0;var r=t.url.indexOf("&",a);-1===r&&(r=t.url.length);var l=t.url.substring(a+9,r);l&&(s=!0,t.callbackName=l,e.info("setting 'options.callbackName' value ("+t.callbackName+") from 'options.url' parameter"))}if(!o){var c=t.url.indexOf("?");-1===c?t.url=t.url+"?callback=":c===t.url.length?t.url=t.url+"callback=":t.url=t.url+"&callback=",e.info("setting callback default key in 'options.url' : "+t.url)}var u=!!t.callbackName||s;if(s||(t.callbackName||(e.info("setting 'options.callbackName' default value"),t.callbackName="callback",(i||""===i)&&(t.callbackName+=i)),t.url=t.url.replace("callback=","callback="+t.callbackName),e.info("setting callback function name in 'options.url' : "+t.url)),t.onTimeOut||(e.info("setting 'options.onTimeOut' default value"),t.onTimeOut=function(){console.log("TimeOut while invoking url : "+t.url)}),!u){var h=this,d=null;t.timeOut>0&&(d=window.setTimeout((function(){window[t.callbackName]=function(){},t.onTimeOut(),h._deleteScript(i)}),t.timeOut)),window[t.callbackName]=function(e){window.clearTimeout(d),t.onResponse(e),h._deleteScript(i)}}this._createScript(i,t.url)},_createScript:function(t,e){var i,o=document.getElementById("results"+t);(i=document.createElement("script")).setAttribute("type","text/javascript"),i.setAttribute("src",e),i.setAttribute("charset","UTF-8"),i.setAttribute("id","results"+t),i.setAttribute("async","true");var n=document.documentElement||document.getElementsByTagName("head")[0];null===o?n.appendChild(i):n.replaceChild(i,o)},_deleteScript:function(t){var e=document.getElementById("results"+t);if(e){var i=e.parentNode||document.documentElement;if(!i)return;i.removeChild(e)}}};e.default=s},function(t,e,i){"use strict";i.r(e);var o={ssl:!0,url:function(t,e){return(!1===o.ssl?"http://":"https://")+"wxs.ign.fr".concat("/",t,e)},Alti:{_key:{"elevation-json":"/alti/rest/elevation.json","elevation-xml":"/alti/rest/elevation.xml","profil-json":"/alti/rest/elevationLine.json","profil-xml":"/alti/rest/elevationLine.xml",wps:"/alti/wps"},url:function(t){return{"elevation-json":o.url(t,this._key["elevation-json"]),"elevation-xml":o.url(t,this._key["elevation-xml"]),"profil-json":o.url(t,this._key["profil-json"]),"profil-xml":o.url(t,this._key["profil-xml"]),wps:o.url(t,this._key.wps)}}},ProcessIsoCurve:{_key:{"iso-json":"/isochrone/isochrone.json","iso-xml":"/isochrone/isochrone.xml"},url:function(t){return{"iso-json":o.url(t,this._key["iso-json"]),"iso-xml":o.url(t,this._key["iso-xml"])}}},AutoComplete:{_key:"/ols/apis/completion",url:function(t){return o.url(t,this._key)}},ReverseGeocode:{_key:"/geoportail/ols",url:function(t){return o.url(t,this._key)}},AutoConf:{_key:{apiKey:"/autoconf",apiKeys:"/autoconf?keys=%KEYS%",aggregate:"/autoconf/id/"},url:function(t){var e="";if(Array.isArray(t)&&t.length>0){e=t[0];for(var i=1;i<t.length;i++)e+=","+t[i]}return{apiKey:o.url(t,this._key.apiKey),apiKeys:o.url(t[0],this._key.apiKeys).replace("%KEYS%",e),aggregate:o.url(t,this._key.aggregate)}}},Geocode:{_key:"/geoportail/ols",url:function(t){return o.url(t,this._key)}},Route:{_key:{ols:"/itineraire/ols","route-json":"/itineraire/rest/route.json","route-xml":"/itineraire/rest/route.xml"},url:function(t){return{ols:o.url(t,this._key.ols),"route-json":o.url(t,this._key["route-json"]),"route-xml":o.url(t,this._key["route-xml"])}}}};e.default=o},function(t){t.exports=JSON.parse('{"_from":"geoportal-access-lib@2.1.6","_id":"geoportal-access-lib@2.1.6","_inBundle":false,"_integrity":"sha512-zQpSjZq8YkGW+ooB1WloQd2KZHCKyg4/pbIFLSPCk3et2Zan/O2hZlKOf2alEX2zbsg7Wd+e8KiLc7cHZKniag==","_location":"/geoportal-access-lib","_phantomChildren":{},"_requested":{"type":"version","registry":true,"raw":"geoportal-access-lib@2.1.6","name":"geoportal-access-lib","escapedName":"geoportal-access-lib","rawSpec":"2.1.6","saveSpec":null,"fetchSpec":"2.1.6"},"_requiredBy":["/"],"_resolved":"https://registry.npmjs.org/geoportal-access-lib/-/geoportal-access-lib-2.1.6.tgz","_shasum":"8bb0d4cc7045c39c3392fe076ba699aace2b6066","_spec":"geoportal-access-lib@2.1.6","_where":"/home/runner/work/geoportal-extensions/geoportal-extensions","author":{"name":"IGNF"},"bugs":{"url":"https://github.com/IGNF/geoportal-access-lib/issues"},"bundleDependencies":false,"date":"03/10/2019","dependencies":{"es6-promise":"^4.2.4","request":"^2.87.0","xmldom":"^0.1.27"},"deprecated":false,"description":"French Geoportal resources access library","devDependencies":{"babel-core":"^6.26.3","babel-loader":"^7.1.2","babel-preset-env":"^1.7.0","chai":"^4.1.2","clean-webpack-plugin":"^0.1.18","copy-webpack-plugin":"^4.5.1","eslint":"^4.18.2","eslint-config-standard":"^11.0.0","eslint-loader":"^2.0.0","eslint-plugin-import":"^2.9.0","eslint-plugin-node":"^6.0.1","eslint-plugin-promise":"^3.7.0","eslint-plugin-standard":"^3.0.1","glob":"^7.1.2","handlebars-layouts":"^3.1.4","handlebars-webpack-plugin":"^1.4.1","html-webpack-plugin":"^2.30.1","istanbul-instrumenter-loader":"^3.0.1","jsdoc-webpack-plugin":"0.0.1","loglevel":"^1.6.1","mocha":"^4.0.0","mocha-loader":"^1.1.3","mocha-webpack":"^1.0.1","nyc":"^12.0.2","path":"^0.12.7","replace-bundle-webpack-plugin":"^1.0.0","sinon":"^4.3.0","sinon-es6":"0.0.3","speed-measure-webpack-plugin":"^1.2.2","string-template":"^1.0.0","webpack":"^3.11.0","webpack-dev-server":"^2.11.3","webpack-node-externals":"^1.6.0","webpack-shell-plugin":"^0.5.0"},"homepage":"https://github.com/IGNF/geoportal-access-lib#readme","keywords":["geoportail","webservice","javascript","es6"],"license":"CECILL-B","main":"dist/GpServices-src.js","module":"src/Gp.js","name":"geoportal-access-lib","nyc":{"include":["src/**/*.js"],"instrument":false,"sourceMap":false},"optionalDependencies":{},"peerDependencies":{},"repository":{"type":"git","url":"git+https://github.com/IGNF/geoportal-access-lib.git"},"scripts":{"build":"webpack","build:dev":"webpack --env.development","build:prod":"webpack --env.production","clean":"echo \\"Warning: no yet implemented!\\" && exit 0","cover":"nyc --reporter=lcov --reporter=text npm run test","doc":"npm run doc:serve","doc:serve":"webpack-dev-server --content-base jsdoc --port 9001 --open","sample":"npm run sample:serve","sample:serve":"webpack-dev-server --open-page samples/index-src.html --https --content-base .  --output-public-path \'/dist/\' --port 9001 --open \'google-chrome\'","sample:serve:dev":"webpack-dev-server --env.development --open-page samples/index-map.html --content-base . --output-public-path \'/dist/\' --port 9001 --open \'google-chrome","sample:serve:prod":"webpack-dev-server --env.production --open-page samples/index.html --content-base . --output-public-path \'/dist/\' --port 9001 --open \'google-chrome","setup":"npm install","test":"mocha-webpack --webpack-config webpack.test.js --glob \\"test_*.js\\" test/spec/","test:end-to-end:serve":"webpack-dev-server --hot --config webpack.end-to-end.serve.js","test:serve":"webpack-dev-server --hot --config webpack.test.serve.js"},"version":"2.1.6"}')},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(45),s=i(59),a=i(63),r={build:function(t){o.default.getLogger("AltiRequestFactory").trace(["AltiRequestFactory::build()"]);var e=null,i={type:t.sampling?"Profil":"Elevation",method:t.httpMethod,param:{positions:null,delimiter:null,indent:null,crs:null,format:null,sampling:null,zonly:null}};i.param.positions=t.positions,i.param.format=t.outputFormat,i.param.sampling=t.sampling,i.param.zonly=t.zonly;var r=!(null===t.onError||"function"!=typeof t.onError),l=!(null===t.onSuccess||"function"!=typeof t.onSuccess),c=null;switch(t.api){case"REST":var u=new s.default(i);if(!u.processRequestString()){if(c="Error in process request (rest) !",r)return void t.onError.call(t.scope,new n.default(c));throw new Error(c)}e=u.requestString;break;case"WPS":if(i.wps={service:null,version:null,identifier:null,rawdataoutput:null,request:null},!(e=a.default.build(i))){if(c="Error in process request (wps) !",r)return void t.onError.call(t.scope,new n.default(c));throw new Error(c)}break;default:if(c="Type of API is not supported by service (REST or WPS) !",r)return void t.onError.call(t.scope,new n.default(c));throw new Error(c)}return l&&t.onSuccess.call(t.scope,e),e}};e.default=r},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(44),s=i(60),a=i(62);function r(t){if(this.logger=o.default.getLogger("AltiRequestREST"),this.logger.trace("[Constructeur AltiRequestREST ()]"),!(this instanceof r))throw new TypeError("AltiRequestREST constructor cannot be called as a function.");if(this.options=t||{},!this.options)throw new Error(n.default.getMessage("PARAM_EMPTY","options"));if(!this.options.type)throw new Error(n.default.getMessage("PARAM_EMPTY","type (Elevation or Profil)"));switch(this.DataObject=null,this.options.type){case"Elevation":this.DataObject=new s.default(this.options.param);break;case"Profil":this.DataObject=new a.default(this.options.param);break;default:throw new Error(n.default.getMessage("PARAM_TYPE","type (Elevation or Profil)"))}this.method=this.options.method||"GET"}r.prototype={requestString:null,constructor:r,template:{get:{value:"lon=__LON__&lat=__LAT__&indent=__INDENT__&crs='__CRS__'",input:{point:"&zonly=__ZONLY__",profil:"&sampling=__SAMPLING__"}},post:{value:"lon=__LON__\nlat=__LAT__\nindent=__INDENT__\ncrs='__CRS__'\n",input:{point:"zonly=__ZONLY__",profil:"sampling=__SAMPLING__"}}},processRequestString:function(){this.logger.trace("AltiRequestREST::processRequestString ()");var t="";return"POST"===this.method?t=this.template.post.value:"GET"===this.method&&(t=this.template.get.value),t=(t=(t=(t=t.replace(/__LON__/g,this.DataObject.getLon())).replace(/__LAT__/g,this.DataObject.getLat())).replace(/__INDENT__/g,this.DataObject.indent)).replace(/__CRS__/g,this.DataObject.crs),t+=this.__addDataInputs(),this.logger.trace("traduction tmpl",t),this.requestString=t,this.requestString},__addDataInputs:function(){var t;if(this.logger.trace("AltiRequestREST::addDataInput ()"),"POST"===this.method)t=this.template.post;else{if("GET"!==this.method)throw new Error("No other HTTP method supported by the service !");t=this.template.get}if("AltiElevationRequest"===this.DataObject.CLASSNAME)return t.input.point.replace(/__ZONLY__/g,this.DataObject.zonly);if("AltiProfilRequest"===this.DataObject.CLASSNAME)return t.input.profil.replace(/__SAMPLING__/g,this.DataObject.sampling);throw new Error("No other object supported than elevation or profil !?")}},e.default=r},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(61);function s(t){if(!(this instanceof s))throw new TypeError("AltiElevationRequest constructor cannot be called as a function.");this.CLASSNAME="AltiElevationRequest",n.default.apply(this,arguments),this.logger=o.default.getLogger(),this.logger.trace("[Constructeur AltiElevationRequest ()]"),this.zonly=this.options.zonly||!1}s.prototype=Object.create(n.default.prototype,{zonly:{get:function(){return this._zonly},set:function(t){this._zonly=t}}}),s.prototype.constructor=s,s.prototype.getData=function(){var t=[];return t.push({k:"lon",v:this.getLon()}),t.push({k:"lat",v:this.getLat()}),t.push({k:"indent",v:this.indent}),t.push({k:"crs",v:this.crs}),t.push({k:"zonly",v:this.zonly}),t.push({k:"format",v:this.format}),t},e.default=s},function(t,e,i){"use strict";i.r(e);var o=i(43);function n(t){if(!(this instanceof n))throw new TypeError("AltiRequest constructor cannot be called as a function.");this.logger=o.default.getLogger(),this.logger.trace("[Constructeur AltiRequest ()]"),this.options=t||{},this.positions=this.options.positions||[],this.delimiter=this.options.delimiter||"|",this.indent=this.options.indent||!1,this.crs=this.options.crs||"CRS:84",this.format=this.options.format||"json"}n.CLASSNAME="AltiRequest",n.prototype={constructor:n,setPositions:function(t){for(var e=[],i=0;i<t.length;i++){var o=t[i];o.lon&&o.lat&&e.push(o)}this.positions=e},getPositions:function(t){if(!t)return this.positions;var e=this.positions.length-1;return t>e||t<e?(this.logger.warn("index out of range !"),this.positions):this.positions[t]},addPositions:function(t){for(var e=0;e<t.length;e++){var i=t[e];i.lon&&i.lat&&this.positions.push(t[e])}},getLon:function(){for(var t=[],e=0;e<this.positions.length;e++)t.push(this.positions[e].lon);return this.logger.trace(t),t.join(this.delimiter)},getLat:function(){for(var t=[],e=0;e<this.positions.length;e++)t.push(this.positions[e].lat);return this.logger.trace(t),t.join(this.delimiter)}},n.prototype.getData=function(){var t=[];return t.push({k:"lon",v:this.getLon()}),t.push({k:"lat",v:this.getLat()}),t.push({k:"delimiter",v:this.delimiter}),t.push({k:"indent",v:this.indent}),t.push({k:"crs",v:this.crs}),t.push({k:"format",v:this.format}),t},e.default=n},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(61);function s(t){if(!(this instanceof s))throw new TypeError("AltiProfilRequest constructor cannot be called as a function.");this.CLASSNAME="AltiProfilRequest",n.default.apply(this,arguments),this.logger=o.default.getLogger(),this.logger.trace("[Constructeur AltiProfilRequest ()]"),this.sampling=this.options.sampling||3}s.prototype=Object.create(n.default.prototype,{sampling:{get:function(){return this._sampling},set:function(t){this._sampling=t}}}),s.prototype.constructor=s,s.prototype.getData=function(){var t=[];return t.push({k:"lon",v:this.getLon()}),t.push({k:"lat",v:this.getLat()}),t.push({k:"indent",v:this.indent}),t.push({k:"crs",v:this.crs}),t.push({k:"sampling",v:this.sampling}),t.push({k:"format",v:this.format}),t},e.default=s},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(44),s=i(64),a=i(60),r=i(62),l={build:function(t){if(o.default.getLogger("AltiRequestWPS").trace(["AltiRequestWPS::build()"]),!t)throw new Error(n.default.getMessage("PARAM_EMPTY","options"));if(!t.type)throw new Error(n.default.getMessage("PARAM_EMPTY","type (Elevation or Profil)"));var e=null;switch(t.type){case"Elevation":t.wps.identifier="gs:WPSElevation",e=new a.default(t.param);break;case"Profil":t.wps.identifier="gs:WPSLineElevation",e=new r.default(t.param);break;default:throw new Error(n.default.getMessage("PARAM_TYPE","type (Elevation or Profil)"))}var i={data:e,method:t.method,param:t.wps},l=new s.default(i);if(!l.processRequestString())throw new Error("Enable to process request !");return l.requestString}};e.default=l},function(t,e,i){"use strict";i.r(e);var o=i(43);function n(t){if(this.logger=o.default.getLogger(),this.logger.trace("[Constructeur WPS()]"),!(this instanceof n))throw new TypeError("WPS constructor cannot be called as a function.");if(this.options=t||{},this.DataObject=this.options.data,!this.DataObject)throw new TypeError("This data object is not defined !");this.paramservice=this.options.param.service||"WPS",this.paramversion=this.options.param.version||"1.0.0",this.paramidentifier=this.options.param.identifier||"gs:WPS",this.paramrawdataoutput=this.options.param.rawdataoutput||"result",this.paramrequest=this.options.param.request||"Execute",this.method=this.options.method||"GET"}n.prototype={requestString:null,constructor:n,template:{get:{value:"service=__SERVICE__&version=__VERSION__&rawdataoutput=__RAWDATAOUTPUT__&identifier=__IDENTIFIER__&request=__REQUEST__&datainputs=\x3c!-- __DATAINPUTS__ --\x3e",input:"__KEY__=__DATA__"},post:{value:'<?xml version="1.0" encoding="UTF-8"?><wps:__REQUEST__ version="__VERSION__" service="__SERVICE__" __NAMESPACE__ __SCHEMALOCATION__><ows:Identifier>__IDENTIFIER__</ows:Identifier><wps:DataInputs>\x3c!-- __DATAINPUTS__ --\x3e</wps:DataInputs><wps:ResponseForm><wps:RawDataOutput><ows:Identifier>__RAWDATAOUTPUT__</ows:Identifier></wps:RawDataOutput></wps:ResponseForm></wps:__REQUEST__>',input:"<wps:Input><ows:Identifier>__KEY__</ows:Identifier><wps:Data><wps:LiteralData>__DATA__</wps:LiteralData></wps:Data></wps:Input>"}},namespaceByDefault:function(){return['xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"','xmlns="http://www.opengis.net/wps/1.0.0"','xmlns:wfs="http://www.opengis.net/wfs"','xmlns:wps="http://www.opengis.net/wps/1.0.0"','xmlns:ows="http://www.opengis.net/ows/1.1"','xmlns:gml="http://www.opengis.net/gml"','xmlns:ogc="http://www.opengis.net/ogc"','xmlns:wcs="http://www.opengis.net/wcs/1.1.1"','xmlns:xlink="http://www.w3.org/1999/xlink"'].join(" ")},schemaLocationByDefault:function(){return'xsi:schemaLocation="http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd"'},processRequestString:function(){this.logger.trace("WPS::processRequestString ()");var t="";if("POST"===this.method)t=this.template.post.value;else{if("GET"!==this.method)return this.logger.error("No other method supported by the service !"),!1;t=this.template.get.value}return t=(t=(t=(t=(t=t.replace(/__SERVICE__/g,this.paramservice)).replace(/__VERSION__/g,this.paramversion)).replace(/__RAWDATAOUTPUT__/g,this.paramrawdataoutput)).replace(/__IDENTIFIER__/g,this.paramidentifier)).replace(/__REQUEST__/g,this.paramrequest),"POST"===this.method&&(t=(t=t.replace(/__NAMESPACE__/g,this.namespaceByDefault)).replace(/__SCHEMALOCATION__/g,this.schemaLocationByDefault)),(t=t.replace(/<!-- __DATAINPUTS__ -->/g,this.__addDataInputs()))?(this.requestString=t,this.logger.trace("traduction tmpl",t),!0):(this.logger.warn("traduction tmpl : empty request !?"),!1)},__addDataInputs:function(){this.logger.trace("WPS::__addDataInputs ()");for(var t,e="GET"===this.method?this.template.get.input:this.template.post.input,i="GET"===this.method?";":"",o="",n=this,s=this.DataObject.getData(),a=0;a<s.length;a++)t=a,i&&(i=t===s.length-1?"":";"),o=o.concat(n.__addDataInput(e,s[t].k,s[t].v),i);return o},__addDataInput:function(t,e,i){var o=t;return o=(o=o.replace(/__KEY__/g,e)).replace(/__DATA__/g,i)},setMethod:function(t){"GET"===t||"POST"===t?this.method=t:this.logger.warn("support only GET and POST method !")},getMethod:function(){return this.method}},e.default=n},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(44),s=i(45),a=i(66),r=i(67),l=i(68),c=i(69),u={build:function(t){var e=o.default.getLogger("AltiResponseFactory");e.trace(["AltiResponseFactory::build()"]);var i=null;if(t.response){if(t.rawResponse)e.trace("analyze response : raw"),i=t.response;else{switch(t.outputFormat){case"xml":e.trace("analyze response : xml");try{var u=new a.default({reader:r.default});if("string"==typeof t.response?u.setXMLString(t.response):u.setXMLDoc(t.response),!(i=u.parse()))throw new Error(n.default.getMessage("SERVICE_RESPONSE_EXCEPTION_2"))}catch(e){var h=e.message;return void t.onError.call(t.scope,new s.default({message:n.default.getMessage("SERVICE_RESPONSE_EXCEPTION",h),status:200,type:s.default.TYPE_SRVERR}))}break;case"json":var d;if(e.trace("analyze response : json"),e.trace("analyze response : ",typeof t.response),(d="string"==typeof t.response?JSON.parse(t.response):t.response).error)return void t.onError.call(t.scope,new s.default({message:n.default.getMessage("SERVICE_RESPONSE_EXCEPTION",d.error.description),status:200,type:s.default.TYPE_SRVERR}));if(d){var p,m=d.elevations,f=new l.default;if(Array.isArray(m)&&m.length)for(var _=0;_<m.length;_++)p=new c.default,"object"==typeof m[_]?(m[_].lon&&(p.lon=m[_].lon),m[_].lat&&(p.lat=m[_].lat),m[_].z&&(p.z=m[_].z),m[_].acc&&(p.acc=m[_].acc)):"number"==typeof m[_]&&(p.z=m[_]),Array.isArray(f.elevations)&&f.elevations.push(p);i=f}if(!i)return void t.onError.call(t.scope,new s.default({message:n.default.getMessage("SERVICE_RESPONSE_ANALYSE_2"),type:s.default.TYPE_UNKERR,status:-1}));break;default:return void t.onError.call(t.scope,new s.default({message:n.default.getMessage("SERVICE_RESPONSE_FORMAT_2"),type:s.default.TYPE_UNKERR,status:-1}))}if(i.exceptionReport)return void t.onError.call(t.scope,new s.default({message:n.default.getMessage("SERVICE_RESPONSE_EXCEPTION",i.exceptionReport),type:s.default.TYPE_SRVERR,status:200}));if(i.error){var g=i.error.description;return void t.onError.call(t.scope,new s.default({message:n.default.getMessage("SERVICE_RESPONSE_EXCEPTION",g),type:s.default.TYPE_SRVERR,status:200}))}}t.onSuccess.call(t.scope,i)}else t.onError.call(t.scope,new s.default(n.default.getMessage("SERVICE_RESPONSE_EMPTY")))}};e.default=u},function(t,e,i){"use strict";i.r(e);var o=i(43);function n(t){if(!(this instanceof n))throw new TypeError("XML constructor cannot be called as a function.");this.logger=o.default.getLogger(),this.logger.trace("[Constructeur XML ()]"),this.xmlString=null,this.xmlDoc=null,this.reader=null,t&&(t.xmlString&&"string"==typeof t.xmlString&&(this.xmlString=t.xmlString,this.xmlDoc=s(t.xmlString)),t.reader&&this.setReader(t.reader))}function s(t){if("undefined"==typeof window)return(new(0,i(54).DOMParser)).parseFromString(t,"text/xml");var e,o,n="Erreur lors du parsing de la réponse du service : XML non conforme";if(window.ActiveXObject){(o=new window.ActiveXObject("Microsoft.XMLDOM")).async=!1,o.loadXML(t);var s=o.parseError;if(s.errorCode)throw s.line&&s.linepos&&(n+="( ligne "+s.line+", colonne "+s.linepos),s.reason&&(n+=":  "+s.reason+")"),new Error(n);return o}if(window.DOMParser){e=new window.DOMParser;try{o=e.parseFromString(t,"text/xml")}catch(t){throw"SyntaxError"===t.message?new Error(n):new Error("Erreur lors du parsing de la réponse du service : "+t.message)}if(o.getElementsByTagName("parsererror").length>0)for(var a=o.getElementsByTagName("parsererror"),r=0;r<a.length;r++){var l=a[r].innerHTML;if(-1===l.indexOf("Huge input lookup"))throw n+="("+l+")",new Error(n)}else if(!o.documentElement)throw new Error(n);return o}throw new Error("Incompatible DOM Parser pour ce navigateur !")}n.prototype={constructor:n,getXMLString:function(){return this.xmlString},setXMLString:function(t){t&&"string"==typeof t&&(this.xmlString=t,this.xmlDoc=s(t))},getReader:function(){return this.reader},setReader:function(t){t&&t.read&&"function"==typeof t.read&&(this.reader=t)},getXMLDoc:function(){return this.xmlDoc},setXMLDoc:function(t){this.xmlDoc=t},parse:function(){if(!this.xmlDoc&&this.xmlString&&(this.xmlDoc=s(this.xmlString)),this.xmlDoc){var t,e=function(t){var e;9===t.nodeType?e=t.documentElement:1===t.nodeType&&(e=t);return e}(this.xmlDoc);return e?(this.reader&&this.reader.read?t=this.reader.read(e):(t={})[e.nodeName]=function t(e){var i={};if(e.attributes.length>0){var o=function(t){if(t.attributes.length>0){for(var e={},i=t.attributes,o=0;o<i.length;o++){var n=i[o];e[n.nodeName]=n.nodeValue}return e}}(e);i.attributes=o}if(e.hasChildNodes())for(var n,s={},a=e.childNodes,r=0;r<a.length;r++)if(3===(n=a[r]).nodeType)i.textContent=n.nodeValue;else if(1===n.nodeType)if(s=t(n),i[n.nodeName]){if(!Array.isArray(i[n.nodeName])){var l=i[n.nodeName];i[n.nodeName]=[],i[n.nodeName].push(l)}i[n.nodeName].push(s)}else i[n.nodeName]=s;return i}(e),t):{}}}},e.default=n},function(t,e,i){"use strict";i.r(e);var o=i(68),n=i(69),s={};s.READERS={elevations:function(t){var e=new o.default;if(t.hasChildNodes())for(var i,n,a=t.childNodes,r=0;r<a.length;r++)i=a[r],s.READERS[i.nodeName]&&(n=s.READERS[i.nodeName](i),e.elevations.push(n));return e},elevation:function(t){var e=new n.default;if(t.hasChildNodes())for(var i,o=t.childNodes,a=0;a<o.length;a++)i=o[a],s.READERS[i.nodeName]&&s.READERS[i.nodeName](i,e);return e},lat:function(t,e){var i=t.firstChild;if(!i||3!==i.nodeType)throw new Error("Erreur dans la lecture de la réponse du service : latitude attendue mais absente");e.lat=parseFloat(i.nodeValue)},lon:function(t,e){var i=t.firstChild;if(!i||3!==i.nodeType)throw new Error("Erreur dans la lecture de la réponse du service : longitude attendue mais absente");e.lon=parseFloat(i.nodeValue)},z:function(t,e){var i=t.firstChild;if(!i||3!==i.nodeType)throw new Error("Erreur dans la lecture de la réponse du service : altitude attendue mais absente");if(!e)return(e=new n.default).z=parseFloat(i.nodeValue),e;e.z=parseFloat(i.nodeValue)},acc:function(t,e){var i=t.firstChild;if(!i||3!==i.nodeType)throw new Error("Erreur dans la lecture de la réponse du service : précision (acc) attendue mais absente");e.acc=parseFloat(i.nodeValue)},exceptionreport:function(t){var e={};if(t.hasChildNodes())for(var i,o=t.childNodes,n=0;n<o.length;n++)"Exception"===(i=o[n]).nodeName&&(e.exceptionReport=s.READERS.exception(i));return e},exception:function(t){var e={},i=t.getAttribute("exceptionCode");i&&(e.exceptionCode=i);var o=t.firstChild;return o&&3===o.nodeType&&(e.exception=o.nodeValue),e},error:function(t){var e={error:{}};if(t.hasChildNodes())for(var i,o=t.childNodes,n=0;n<o.length;n++){var s;1===(i=o[n]).nodeType&&"code"===i.nodeName&&(s=i.firstChild)&&3===s.nodeType&&(e.error.code=s.nodeValue),1===i.nodeType&&"description"===i.nodeName&&(s=i.firstChild)&&3===s.nodeType&&(e.error.description=s.nodeValue)}return e}},s.read=function(t){if("elevations"===t.nodeName)return s.READERS.elevations(t);if("ExceptionReport"===t.nodeName)return s.READERS.exceptionreport(t);if("error"===t.nodeName)return s.READERS.error(t);throw new Error("Erreur lors de la lecture de la réponse : elle n'est pas au format attendu.")},e.default=s},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("AltiResponse constructor cannot be called as a function.");this.elevations=[]}i.r(e),o.prototype={constructor:o},e.default=o},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("Elevation constructor cannot be called as a function.");this.z=null}i.r(e),o.prototype={constructor:o},e.default=o},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(44),s=i(47),a=i(45),r=i(56),l=i(46),c=i(71);function u(t){if(!(this instanceof u))throw new TypeError(n.default.getMessage("CLASS_CONSTRUCTOR","AutoConf"));if(this.CLASSNAME="AutoConf",t||(t={}),t.protocol=t.protocol||"JSONP",l.default.apply(this,arguments),this.logger=o.default.getLogger("Gp.Services.AutoConf"),this.logger.trace("[Constructeur AutoConf (options)]"),!this.options.serverUrl&&!this.options.serverUrl){var e=r.default.AutoConf.url(this.options.apiKey);this.options.layerId?this.options.serverUrl=e.aggregate+this.options.layerId:Array.isArray(this.options.apiKey)&&this.options.apiKey.length>0?this.options.serverUrl=e.apiKeys:this.options.serverUrl=e.apiKey}"XHR"===this.options.protocol&&"POST"===this.options.httpMethod&&(this.logger.warn("Le service ne gére pas le mode d'interrogation en POST, on bascule sur du GET !"),this.options.httpMethod="GET"),this.options.outputFormat=this.options.rawResponse?"":"xml"}u.prototype=Object.create(l.default.prototype,{}),u.prototype.constructor=u,u.prototype.buildRequest=function(t,e){var i="undefined"!=typeof window?window:{};if(i.Gp&&i.Gp.Config&&i.Gp.Config.generalOptions&&i.Gp.Config.layers&&i.Gp.Config.generalOptions.apiKeys[this.options.apiKey]){if(!this.options.layerId)return this.logger.warn("Gp.Config existe déjà pour cette clé"),void this.options.onSuccess.call(this,i.Gp.Config);if(i.Gp.Config.layers[this.options.layerId]&&i.Gp.Config.layers[this.options.layerId].aggregatedLayers)return this.logger.warn("Gp.Config existe déjà pour cette clé et cette couche"),void this.options.onSuccess.call(this,i.Gp.Config)}this.request="",!(-1===this.options.serverUrl.indexOf("http://"))&&this.layerId&&(this.request=s.default.normalyzeParameters({layerId:this.layerId})),this.request||""===this.request?e.call(this,this.request):t.call(this,new a.default(n.default.getMessage("SERVICE_REQUEST_BUILD")))},u.prototype.analyzeResponse=function(t,e){if(this.response){var i={layerId:this.options.layerId,response:this.response,rawResponse:this.options.rawResponse,onSuccess:e,onError:t,scope:this};c.default.build(i)}else t.call(this,new a.default(n.default.getMessage("SERVICE_RESPONSE_EMPTY")))},e.default=u},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(44),s=i(45),a=i(66),r=i(72),l={build:function(t){o.default.getLogger("AutoConfResponseFactory").trace(["AutoConfResponseFactory::build()"]);var e=null;if(t.response){if(t.rawResponse)e=t.response;else{try{var i=new a.default({reader:r.default});"string"==typeof t.response?i.setXMLString(t.response):i.setXMLDoc(t.response),e=i.parse()}catch(e){var l=e.message;return"string"==typeof t.response?l+="\n (raw response service'"+t.response+"')":l+="\n (raw response service'"+t.response.documentElement.innerHTML+"')",void t.onError.call(t.scope,new s.default({message:n.default.getMessage("SERVICE_RESPONSE_EXCEPTION",l),status:200,type:s.default.TYPE_SRVERR}))}var c=!0;for(var u in e)e.hasOwnProperty(u)&&(c=!1);if(c)return void t.onError.call(t.scope,new s.default(n.default.getMessage("SERVICE_RESPONSE_EMPTY_2")));if(e.exceptionReport)return void t.onError.call(t.scope,new s.default({message:n.default.getMessage("SERVICE_RESPONSE_EXCEPTION",e.exceptionReport),type:s.default.TYPE_SRVERR,status:200}))}var h="undefined"!=typeof window?window:{};h.Gp||(h.Gp={}),h.Gp.Config?this.mergeConfig(h.Gp.Config,e,t.layerId):h.Gp.Config=e,t.onSuccess.call(t.scope,h.Gp.Config)}else t.onError.call(t.scope,new s.default(n.default.getMessage("SERVICE_RESPONSE_EMPTY")))},mergeConfig:function(t,e,i){if(e&&t){for(var o in e)if(e.hasOwnProperty(o))if("generalOptions"===o)for(var n in e[o].apiKeys)e[o].apiKeys.hasOwnProperty(n)&&!t.generalOptions.apiKeys[n]&&(t.generalOptions.apiKeys[n]=e[o].apiKeys[n]);else if(t[o])for(var s in e[o])e[o].hasOwnProperty(s)&&!t[o][s]&&(t[o][s]=e[o][s]);if(i){var a=[];for(var r in e.layers)e.layers.hasOwnProperty(r)&&a.push(r);t.layers[i]&&(t.layers[i].aggregatedLayers=a)}}}};e.default=l},function(t,e,i){"use strict";i.r(e);var o=i(73),n=i(74),s=i(75),a=i(76),r=i(77),l=i(78),c=i(79),u=i(80),h=i(81),d=i(82),p=i(83),m=i(84),f=i(85),_=i(86),g={};function v(t,e){if(t.hasChildNodes())for(var i,o,n,s=t.childNodes,a=0;a<s.length;a++){if(1===(i=s[a]).nodeType)if(o=i.localName||i.baseName||i.nodeName,n=i.prefix||g.DEFAULTPREFIX,g.READERS[n][o])(0,g.READERS[n][o])(i,e);else v(i,e)}}function y(t){var e,i="";return t.hasChildNodes()&&(3!==(e=t.firstChild).nodeType&&4!==e.nodeType||(i=e.nodeValue)),i}g.VERSION="1.1.0",g.NAMESPACES={xmlns:"http://www.opengis.net/context",gpp:"http://api.ign.fr/geoportail",ows:"http://www.opengis.net/ows/1.1",sld:"http://www.opengis.net/sld",wmts:"http://www.opengis.net/wmts/1.0",xlink:"http://www.w3.org/1999/xlink",xsi:"http://www.w3.org/2001/XMLSchema-instance"},g.SCHEMALOCATION=["http://www.opengis.net/context http://wxs.ign.fr/schemas/extContext.xsd http://api.ign.fr/geoportail http://wxs.ign.fr/schemas/autoconf/autoconf.xsd","http://www.opengis.net/context http://wxs.ign.fr/schemas/extContext.xsd http://api.ign.fr/geoportail http://wxs.ign.fr/schemas/autoconf.xsd"],g.DEFAULTPREFIX="context",g.READERS={context:{ViewContext:function(t){!function(t){if(t.attributes.length>0){var e=function(t){if(t.attributes.length>0){for(var e={},i=t.attributes,o=0;o<i.length;o++){var n=i[o];e[n.nodeName]=n.nodeValue}return e}}(t);for(var i in e)if(e.hasOwnProperty(i)){if("version"===i&&e.version!==g.VERSION)return void console.log("[AutoConfResponseReader] autoconf version is not the expected one : there may be errors in parsing");if("xmlns"===i){if(e[i]!==g.NAMESPACES.xmlns)return void console.log("[AutoConfResponseReader] autoconf response default namespace is not the expected one");continue}var o=i.split(":")[0],n=i.split(":")[1];if("xmlns"===o&&n&&g.NAMESPACES[n]&&g.NAMESPACES[n]!==e[i])return void console.log("[AutoConfResponseReader] autoconf response "+i+" namespace is not the expected one");if("schemaLocation"===n&&e[i]!==g.SCHEMALOCATION[0]&&e[i]!==g.SCHEMALOCATION[1])return void console.log("[AutoConfResponseReader] autoconf response schema location is not the expected one")}}}(t);var e=new o.default;return v(t,e),e},Title:function(t,e){e&&e.generalOptions?e.generalOptions.title=y(t):e&&e.lyr&&(e.lyr.title=y(t))},Abstract:function(t,e){e&&e.lyr&&(e.lyr.description=y(t))},Server:function(t,e){var i=t.getAttribute("service"),o=t.getAttribute("title"),n=t.getAttribute("version");if(i)if(e&&e.services&&"object"==typeof e.services&&!e.services[i]){var s=new u.default;s.title=o,s.version=n,v(t,s),e.services[i]=s}else e&&e.lyr&&(e.lyr.serviceParams||(e.lyr.serviceParams={}),e.lyr.serviceParams.id=i,e.lyr.serviceParams.version=n)},OnlineResource:function(t,e){e&&e.hasOwnProperty("serverUrl")&&(e.serverUrl=t.getAttribute("xlink:href"))},LayerList:function(t,e){if(v(t,e),e&&e.layers&&e.generalOptions&&e.services)for(var i in e.layers)if(e.layers.hasOwnProperty(i)){var o=e.layers[i],n=o.apiKeys;if(n&&Array.isArray(n))for(var s=0;s<n.length;s++){var a=n[s];e.generalOptions.apiKeys&&(e.generalOptions.apiKeys[a]&&Array.isArray(e.generalOptions.apiKeys[a])||(e.generalOptions.apiKeys[a]=[]),e.generalOptions.apiKeys[a].push(i))}var r=o.serviceParams;if(r&&r.id&&!e.services[r.id]){var l=new u.default;r.serverUrl&&(l.serverUrl=r.serverUrl),r.version&&(l.version=r.version),e.services[r.id]=l}if(o.wmtsOptions&&o.wmtsOptions.tileMatrixSetLink&&e.tileMatrixSets){var c=o.wmtsOptions.tileMatrixSetLink,h=e.tileMatrixSets;for(var d in h)h.hasOwnProperty(d)&&d===c&&(o.defaultProjection=h[d].projection)}}},Layer:function(t,e){if(e&&e.layers){var i={lyr:new a.default,lyrId:null},o=t.getAttribute("hidden");i.lyr.hidden="1"===o;var n=t.getAttribute("queryable");if(i.lyr.queryable="1"===n,v(t,i),i.lyrId){if(i.lyr.serviceParams&&i.lyr.serviceParams.id){var s=i.lyr.serviceParams.id;if(-1!==s.toUpperCase().indexOf("OPENLS")||-1!==s.toUpperCase().indexOf("ELEVATION")){var r=i.lyrId.split("$")[0];i.lyrId=r+"$"+s}}i.lyr.layerId=i.lyrId,e.layers[i.lyrId]=i.lyr}}},Name:function(t,e){e&&e.lyr&&(e.lyr.name=y(t))},SRS:function(t,e){e&&e.lyr&&(e.lyr.defaultProjection=y(t))},Format:function(t,e){if(e&&e.lyr){var i=new s.default,o=t.getAttribute("current");i.current="1"===o,i.name=y(t),e.lyr.formats&&Array.isArray(e.lyr.formats)||(e.lyr.formats=[]),e.lyr.formats.push(i)}},Style:function(t,e){if(e&&e.lyr){var i=new h.default,o=t.getAttribute("current");if(i.current="1"===o||1===o,t.hasChildNodes)for(var n,s,a=t.childNodes,r=0;r<a.length;r++)1===(n=a[r]).nodeType&&("Name"===(s=n.localName||n.baseName||n.nodeName)?i.name=y(n):"Title"===s?i.title=y(n):"URL"===s&&(i.url=y(n)));e.lyr.styles&&Array.isArray(e.lyr.styles)||(e.lyr.styles=[]),e.lyr.styles.push(i)}},Dimension:function(t,e){var i=t.getAttribute("name"),o=y(t);e&&e.lyr&&(e.lyr.dimensions||(e.lyr.dimensions={}),"Type"===i?e.lyr.dimensions.type=o:"VisibilityRange"===i?e.lyr.dimensions.visibilityRange=o:"VisibilityMode "===i?e.lyr.dimensions.visibilityMode=o:"GeometricType"===i?e.lyr.dimensions.geometricType=o:"NoDataValue"===i&&(e.lyr.dimensions.noDataValue=o))}},gpp:{Theme:function(t,e){e&&e.generalOptions&&e.generalOptions.hasOwnProperty("theme")&&(e.generalOptions.theme=y(t))},defaultGMLGFIStyleUrl:function(t,e){e&&e.generalOptions&&e.generalOptions.hasOwnProperty("defaultGMLGFIStyle")&&(e.generalOptions.defaultGMLGFIStyle=y(t))},Territory:function(t,e){var i=t.getAttribute("id");if(i){var o=new d.default,n=t.getAttribute("default");o.isDefault="1"===n,v(t,o),e&&e.territories&&"object"==typeof e.territories&&(e.territories[i]=o)}},defaultCRS:function(t,e){e&&e.hasOwnProperty("defaultCRS")&&(e.defaultCRS=y(t))},AdditionalCRS:function(t,e){var i=y(t);i&&e&&(Array.isArray(e.additionalCRS)?e.additionalCRS.push(i):(e.additionalProjections&&Array.isArray(e.additionalProjections)||(e.additionalProjections=[]),e.additionalProjections.push(i)))},DefaultLayer:function(t,e){var i=t.getAttribute("layerId");i&&e&&Array.isArray(e.defaultLayers)&&e.defaultLayers.push(i)},BoundingBox:function(t,e){if(e){var i=y(t).split(",");if(4===i.length){var o={left:parseFloat(i[0]),right:parseFloat(i[2]),top:parseFloat(i[3]),bottom:parseFloat(i[1])},s=t.getAttribute("minT"),a=t.getAttribute("maxT");if(e.hasOwnProperty("geoBBOX"))e.geoBBOX=o;else if(e.hasOwnProperty("bbox"))if(e.bbox.left||e.bbox.right||e.bbox.top||e.bbox.bottom){e.multiConstraints||(e.multiConstraints=[]);var r=new n.default;r.bbox=o,r.temporalExtent=[s,a],e.multiConstraints.push(r)}else e.bbox=o,e.temporalExtent=[s,a];else e.globalConstraint||(e.globalConstraint=new n.default),e.globalConstraint.bbox=o,e.globalConstraint.temporalExtent=[s,a]}}},Resolution:function(t,e){var i=y(t);i&&e&&e.defaultOptions&&e.defaultOptions.hasOwnProperty("resolution")&&(e.defaultOptions.resolution=parseFloat(i))},x:function(t,e){var i=y(t);i&&e&&e.geoCenter&&e.geoCenter.hasOwnProperty("lon")&&(e.geoCenter.lon=parseFloat(i))},y:function(t,e){var i=y(t);i&&e&&e.geoCenter&&e.geoCenter.hasOwnProperty("lat")&&(e.geoCenter.lat=parseFloat(i))},Resolutions:function(t,e){e&&e.generalOptions&&e.generalOptions.hasOwnProperty("wgs84Resolutions")&&(e.generalOptions.wgs84Resolutions=y(t).split(","))},Layer:function(t,e){if(e&&e.hasOwnProperty("lyrId")&&e.lyr){e.lyrId=t.getAttribute("id");var i=t.getAttribute("aggregate"),o=t.getAttribute("more");(i||o)&&(e.lyr.isAggregate=!0),v(t,e.lyr)}},Constraint:function(t,e){var i=new n.default;if(v(t,i),e)if(e.constraints&&Array.isArray(e.constraints)||(e.constraints=[]),i.multiConstraints&&Array.isArray(i.multiConstraints)){var o=new n.default;o.crs=i.crs,o.bbox=i.bbox,o.minScaleDenominator=i.minScaleDenominator,o.maxScaleDenominator=i.maxScaleDenominator,o.temporalExtent=i.temporalExtent,e.constraints.push(o);for(var s=0;s<i.multiConstraints.length;s++)(o=new n.default).crs=i.crs,o.minScaleDenominator=i.minScaleDenominator,o.maxScaleDenominator=i.maxScaleDenominator,o.bbox=i.multiConstraints[s].bbox,o.temporalExtent=i.multiConstraints[s].temporalExtent,e.constraints.push(o)}else e.constraints.push(i)},CRS:function(t,e){e&&e.hasOwnProperty("crs")&&(e.crs=y(t))},Thematic:function(t,e){if(e){var i=new p.default;i.inspire=!1,i.name=y(t),e.thematics&&Array.isArray(e.thematics)||(e.thematics=[]),e.thematics.push(i)}},InspireThematic:function(t,e){if(e){var i=new p.default;i.inspire=!0,i.name=y(t),e.thematics&&Array.isArray(e.thematics)||(e.thematics=[]),e.thematics.push(i)}},Originator:function(t,e){if(e){var i=new c.default;i.name=t.getAttribute("name"),v(t,i),e.originators&&Array.isArray(e.originators)||(e.originators=[]),e.originators.push(i)}},Attribution:function(t,e){e&&e.hasOwnProperty("attribution")&&(e.attribution=y(t))},Logo:function(t,e){e&&e.hasOwnProperty("logo")&&(e.logo=y(t))},URL:function(t,e){e&&e.hasOwnProperty("url")&&(e.url=y(t))},Legend:function(t,e){var i=new r.default;v(t,i),e&&(e.legends&&Array.isArray(e.legends)||(e.legends=[]),e.legends.push(i))},LegendURL:function(t,e){if(e&&e.hasOwnProperty("format")&&(e.format=t.getAttribute("format"),t.hasChildNodes)){var i=t.childNodes[0];"OnlineResource"===(i.localName||i.baseName||i.nodeName)&&e.hasOwnProperty("url")&&(e.url=i.getAttribute("xlink:href"))}},QuickLook:function(t,e){if(t.hasChildNodes){var i=t.childNodes[0];"OnlineResource"===(i.localName||i.baseName||i.nodeName)&&e&&(e.quicklookUrl=i.getAttribute("xlink:href"))}},MetadataURL:function(t,e){if(e){var i=new l.default;if(i.format=t.getAttribute("format"),t.hasChildNodes){var o=t.childNodes[0];"OnlineResource"===(o.localName||o.baseName||o.nodeName)&&(i.url=o.getAttribute("xlink:href"))}e.metadata||Array.isArray(e.metadata)||(e.metadata=[]),e.metadata.push(i)}},Key:function(t,e){if(e){var i=t.getAttribute("id");e.apiKeys&&Array.isArray(e.apiKeys)||(e.apiKeys=[]),e.apiKeys.push(i);var o=y(t);e.serviceParams||(e.serviceParams={}),e.serviceParams.serverUrl||(e.serviceParams.serverUrl={}),e.serviceParams.serverUrl[i]||(e.serviceParams.serverUrl[i]=o)}}},ows:{Identifier:function(t,e){e&&e.hasOwnProperty("TMS")?e.identifier=y(t):e&&e.hasOwnProperty("matrixId")&&(e.matrixId=y(t))},SupportedCRS:function(t,e){e&&e.TMS&&e.TMS.hasOwnProperty("projection")&&(e.TMS.projection=y(t))}},sld:{MinScaleDenominator:function(t,e){var i=y(t);i&&e&&(e.hasOwnProperty("defaultOptions")?e.defaultOptions.minScaleDenominator=parseFloat(i):e.lyr?(e.lyr.globalConstraint||(e.lyr.globalConstraint=new n.default),e.lyr.globalConstraint.minScaleDenominator=parseFloat(i)):e.hasOwnProperty("minScaleDenominator")&&(e.minScaleDenominator=parseFloat(i)))},MaxScaleDenominator:function(t,e){var i=y(t);i&&e&&(e.hasOwnProperty("defaultOptions")?e.defaultOptions.maxScaleDenominator=parseFloat(i):e.lyr?(e.lyr.globalConstraint||(e.lyr.globalConstraint=new n.default),e.lyr.globalConstraint.maxScaleDenominator=parseFloat(i)):e.hasOwnProperty("maxScaleDenominator")&&(e.maxScaleDenominator=parseFloat(i)))}},wmts:{TileMatrixSetLimits:function(t,e){if(e){var i={};v(t,i),e.wmtsOptions||(e.wmtsOptions={}),e.wmtsOptions.tileMatrixSetLimits=i}},TileMatrixLimits:function(t,e){var i,o=new _.default;if(t.hasChildNodes){for(var n=t.childNodes,s=0;s<n.length;s++){var a=n[s],r=a.localName||a.baseName||a.nodeName;"TileMatrix"===r?i=y(a):"MinTileRow"===r?o.minTileRow=y(a):"MaxTileRow"===r?o.maxTileRow=y(a):"MinTileCol"===r?o.minTileCol=y(a):"MaxTileCol"===r&&(o.maxTileCol=y(a))}i&&e&&!e[i]&&(e[i]=o)}},TileMatrixSet:function(t,e){if(e&&e.tileMatrixSets){var i={};i.TMS=new m.default,i.resolutions=[],v(t,i);var o=i.TMS.tileMatrices;for(var n in o)o.hasOwnProperty(n)&&i.TMS.matrixIds.push(n);if(("IGNF:WGS84G"===i.TMS.getProjection()||"EPSG:4326"===i.TMS.getProjection())&&e.generalOptions&&Array.isArray(e.generalOptions.wgs84Resolutions))for(var s=e.generalOptions.wgs84Resolutions,a=0;a<s.length;a++)i.resolutions[a]=parseFloat(s[a]);Array.isArray(i.resolutions)&&void 0!==i.resolutions.sort&&i.resolutions.sort((function(t,e){return e-t})),i.TMS.nativeResolutions=i.resolutions,e.tileMatrixSets[i.identifier]=i.TMS}else e&&!e.wmtsOptions&&(e.wmtsOptions={}),e.wmtsOptions.tileMatrixSetLink=y(t)},TileMatrix:function(t,e){if(e){var i=new f.default;if(v(t,i),e.TMS&&e.TMS.getProjection()){var o=e.TMS.getProjection();if("EPSG:3857"===o||"EPSG:2154"===o){var n=28e-5*i.scaleDenominator;e.resolutions&&Array.isArray(e.resolutions)&&e.resolutions.push(n)}}e.TMS&&e.TMS.tileMatrices&&(e.TMS.tileMatrices[i.matrixId]=i)}},ScaleDenominator:function(t,e){var i=y(t);i&&e&&e.hasOwnProperty("scaleDenominator")&&(e.scaleDenominator=parseFloat(i))},TopLeftCorner:function(t,e){var i=y(t).split(" ");i&&e&&(e.topLeftCorner={},e.topLeftCorner.x=parseFloat(i[0]),e.topLeftCorner.y=parseFloat(i[1]))},TileWidth:function(t,e){var i=y(t);i&&e&&e.hasOwnProperty("tileWidth")&&(e.tileWidth=parseInt(i,10))},TileHeight:function(t,e){var i=y(t);i&&e&&e.hasOwnProperty("tileHeight")&&(e.tileHeight=parseInt(i,10))},MatrixWidth:function(t,e){var i=y(t);i&&e&&e.hasOwnProperty("matrixWidth")&&(e.matrixWidth=parseInt(i,10))},MatrixHeight:function(t,e){var i=y(t);i&&e&&e.hasOwnProperty("matrixHeight")&&(e.matrixHeight=parseInt(i,10))}},serviceException:function(t){var e={};if(t.hasChildNodes())for(var i,o=t.childNodes,n=0;n<o.length;n++)"exception"===(i=o[n]).nodeName&&(e.exceptionReport=g.READERS.exception(i));return e},exception:function(t){var e={},i=t.getAttribute("code");i&&(e.exceptionCode=i);var o=t.firstChild;return o&&3===o.nodeType&&(e.exception=o.nodeValue),e}},g.read=function(t){if("ViewContext"===t.nodeName){var e=t.prefix||g.DEFAULTPREFIX;return g.READERS[e][t.nodeName](t)}if("serviceException"===t.nodeName)return g.READERS[t.nodeName](t);throw new Error("Erreur lors de la lecture de la réponse : elle n'est pas au format attendu.")},e.default=g},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("AutoConfResponse constructor cannot be called as a function.");this.generalOptions={apiKeys:{},title:null,defaultGMLGFIStyle:null,theme:null,wgs84Resolutions:[]},this.layers={},this.territories={},this.tileMatrixSets={},this.services={}}i.r(e),o.prototype={constructor:o,isConfLoaded:function(t){if(t)return!!this.generalOptions.apiKeys[t]},getLayersId:function(t){return this.generalOptions.apiKeys[t]},getLayersConf:function(t){var e={},i=this.getLayersId(t);if(i)for(var o=0;o<i.length;o++){var n=i[o];e[n]=this.layers[n]}return e},getLayerConf:function(t){if(this.layers)return this.layers[t]},getTileMatrixSets:function(){return this.tileMatrixSets},getTMSConf:function(t){if(this.tileMatrixSets)return this.tileMatrixSets[t]},getTerritories:function(){return this.territories},getTerritoryConf:function(t){if(this.territories)return this.territories[t]},getServices:function(){return this.services},getServiceConf:function(t){if(this.services)return this.services[t]}},e.default=o},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("Constraint constructor cannot be called as a function.");this.crs=null,this.bbox={left:null,right:null,top:null,bottom:null},this.minScaleDenominator=null,this.maxScaleDenominator=null,this.temporalExtent=[null,null]}i.r(e),o.prototype={constructor:o},e.default=o},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("Format constructor cannot be called as a function.");this.current=null,this.name=null}i.r(e),o.prototype={constructor:o},e.default=o},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("Layer constructor cannot be called as a function.")}i.r(e),o.prototype={constructor:o,getName:function(){return this.name},getTitle:function(){return this.title},getDescription:function(){return this.description},getLayerId:function(){return this.layerId},getQuicklookUrl:function(){return this.quicklookUrl},getDefaultProjection:function(){return this.defaultProjection},getProjections:function(){var t=[];return t.push(this.defaultProjection),t.concat(this.additionalProjections)},getBBOX:function(){if(this.globalConstraint)return this.globalConstraint.bbox},getMinScaleDenominator:function(){if(this.globalConstraint)return this.globalConstraint.minScaleDenominator},getMaxScaleDenominator:function(){if(this.globalConstraint)return this.globalConstraint.maxScaleDenominator},getTMSID:function(){if(this.wmtsOptions)return this.wmtsOptions.tileMatrixSetLink},getServiceParams:function(){return this.serviceParams},getServerUrl:function(t){if(t&&this.serviceParams&&this.serviceParams.serverUrl)return this.serviceParams.serverUrl[t]},getLegends:function(){return this.legends},getMetadata:function(){return this.metadata},getStyles:function(){return this.styles},getDefaultStyle:function(){if(this.styles){for(var t,e=this.styles,i=0;i<e.length;i++)if(!0===e[i].current){t=e[i].name;break}return t}},getThematics:function(){return this.thematics},getDefaultFormat:function(){if(this.formats){for(var t,e=this.formats,i=0;i<e.length;i++)if(!0===e[i].current){t=e[i].name;break}return t}},getConstraints:function(){return this.constraints},getOriginators:function(){return this.originators},getDimensions:function(){return this.dimensions},getAggregatedLayers:function(){if(this.isAggregate)return this.aggregatedLayers}},e.default=o},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("Legend constructor cannot be called as a function.");this.format=null,this.url=null,this.minScaleDenominator=null}i.r(e),o.prototype={constructor:o},e.default=o},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("Metadata constructor cannot be called as a function.");this.format=null,this.url=null}i.r(e),o.prototype={constructor:o},e.default=o},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("Originator constructor cannot be called as a function.");this.name=null,this.attribution=null,this.logo=null,this.url=null,this.constraints=[]}i.r(e),o.prototype={constructor:o},e.default=o},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("Service constructor cannot be called as a function.");this.title=null,this.serverUrl=null,this.version=null}i.r(e),o.prototype={constructor:o},e.default=o},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("Style constructor cannot be called as a function.");this.name=null,this.title=null,this.current=null,this.url=null}i.r(e),o.prototype={constructor:o},e.default=o},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("Territory constructor cannot be called as a function.");this.isDefault=null,this.defaultCRS=null,this.additionalCRS=[],this.geoBBOX={left:null,right:null,top:null,bottom:null},this.geoCenter={lon:null,lat:null},this.defaultOptions={resolution:null,minScaleDenominator:null,maxScaleDenominator:null},this.defaultLayers=[]}i.r(e),o.prototype={constructor:o},e.default=o},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("Thematic constructor cannot be called as a function.");this.inspire=null,this.name=null}i.r(e),o.prototype={constructor:o},e.default=o},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("TileMatrixSet constructor cannot be called as a function.");this.projection=null,this.nativeResolutions=[],this.matrixIds=[],this.tileMatrices={}}i.r(e),o.prototype={constructor:o,getResolutions:function(){return this.nativeResolutions},getMatrixIds:function(){return this.matrixIds},getProjection:function(){return this.projection},getTileMatrices:function(){return this.tileMatrices},getTopLeftCorner:function(){var t,e=this.getTileMatrices();if(e)for(var i in e)if(e.hasOwnProperty(i)){t=e[i].topLeftCorner;break}return t}},e.default=o},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("TileMatrix constructor cannot be called as a function.");this.matrixId=null,this.matrixHeight=null,this.matrixWidth=null,this.scaleDenominator=null,this.tileHeight=null,this.tileWidth=null,this.topLeftCorner=null}i.r(e),o.prototype={constructor:o,getTopLeftCorner:function(){return this.topLeftCorner},getScaleDenominator:function(){return this.scaleDenominator},getTileHeight:function(){return this.tileHeight},getTileWidth:function(){return this.tileWidth},getMatrixHeight:function(){return this.matrixHeight},getMatrixWidth:function(){return this.matrixWidth}},e.default=o},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("TileMatrixLimit constructor cannot be called as a function.");this.minTileRow=null,this.maxTileRow=null,this.minTileCol=null,this.maxTileCol=null}i.r(e),o.prototype={constructor:o},e.default=o},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(44),s=i(45),a=i(46),r=i(88),l=i(105);function c(t){if(!(this instanceof c))throw new TypeError(n.default.getMessage("CLASS_CONSTRUCTOR","Geocode"));if(this.CLASSNAME="Geocode",a.default.apply(this,arguments),this.logger=o.default.getLogger("Gp.Services.Geocode"),this.logger.trace("[Constructeur Geocode (options)]"),!t.location)throw new Error(n.default.getMessage("PARAM_MISSING","location"));if("object"==typeof t.location&&0===Object.keys(t.location).length)throw new Error(n.default.getMessage("PARAM_EMPTY","location"));if("string"==typeof t.location&&0===t.location.length)throw new Error(n.default.getMessage("PARAM_EMPTY","location"));this.options.location=t.location,t.filterOptions&&"object"==typeof t.filterOptions||(this.options.filterOptions=t.filterOptions={type:["StreetAddress"]}),0===Object.keys(t.filterOptions).length&&(this.options.filterOptions={type:["StreetAddress"]});for(var e=Object.keys(t.filterOptions),i=0;i<e.length;i++){var s=e[i];-1!==["department","number","postalCode","insee","importance","ID","IDTR","absorbedCity","sheet","section","inseeRegion","inseeDepartment"].indexOf(s)&&"string"!=typeof t.filterOptions[s]&&(t.filterOptions[s]=t.filterOptions[s].toString()),t.filterOptions[s]||delete this.options.filterOptions[s]}this.options.filterOptions.type=t.filterOptions.type||["StreetAddress"],this.options.maximumResponses=t.maximumResponses||25,this.options.returnFreeForm=t.returnFreeForm||!1,this.options.srs=t.srs||"EPSG:4326",this.options.outputFormat=this.options.rawResponse?"":"xml"}c.prototype=Object.create(a.default.prototype,{}),c.prototype.constructor=c,c.prototype.buildRequest=function(t,e){var i={httpMethod:this.options.httpMethod,location:this.options.location,returnFreeForm:this.options.returnFreeForm,filterOptions:this.options.filterOptions,srs:this.options.srs,maximumResponses:this.options.maximumResponses};this.request=r.default.build(i),this.request?e.call(this,this.request):t.call(this,new s.default(n.default.getMessage("SERVICE_REQUEST_BUILD")))},c.prototype.analyzeResponse=function(t,e){if(this.response){var i={response:this.response,rawResponse:this.options.rawResponse,onError:t,onSuccess:e,scope:this};l.default.build(i)}else t.call(this,new s.default(n.default.getMessage("SERVICE_RESPONSE_EMPTY")))},e.default=c},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(89),s=i(93),a=i(96),r=i(100),l=i(102),c=i(103),u=i(104),h={build:function(t){var e=o.default.getLogger("DirectGeocodeRequestFactory");e.trace(["DirectGeocodeRequestFactory::build()"]);var i=null,h=new a.default;h.addFilterExtensions(new u.default),h.addFilterExtensions(new r.default),h.addFilterExtensions(new l.default),h.addFilterExtensions(new c.default);var d=new s.default({location:t.location,returnFreeForm:t.returnFreeForm,filterOptions:t.filterOptions});d.addFilter(h);var p=new n.default({srsName:t.srs,maximumResponses:t.maximumResponses});(p.namespace=!0,p.setService(d),i=p.build(),"GET"===t.httpMethod)&&(i="qxml="+encodeURIComponent(i).replace(/-/g,"%2D").replace(/_/g,"%5F").replace(/\./g,"%2E").replace(/!/g,"%21").replace(/~/g,"%7E").replace(/\*/g,"%2A").replace(/'/g,"%27").replace(/\(/g,"%28").replace(/\)/g,"%29"));return e.trace(i),i}};e.default=h},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(90),s=i(91),a=i(92);function r(t){if(this.logger=o.default.getLogger(),this.logger.trace("[Constructeur XLS()]"),!(this instanceof r))throw new TypeError("XLS constructor cannot be called as a function.");for(var e in this.options={srsName:"EPSG:4326",maximumResponses:25},t)t.hasOwnProperty(e)&&t[e]&&(this.options[e]=t[e])}r.VERSION="1.2",r.prototype={requestString:null,namespace:!1,oService:null,constructor:r,template:'<?xml version="1.0" encoding="UTF-8"?>\n<XLS version="__VERSION__"\n__NAMESPACE__ \n__SCHEMALOCATION__>\n__REQUESTHEADER__\n__REQUEST__\n</XLS>\n',namespaceByDefault:function(){return['xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"','xmlns:xls="http://www.opengis.net/xls"','xmlns:gml="http://www.opengis.net/gml"'].join(" ")},schemaLocationByDefault:function(){return'xsi:schemaLocation="http://www.opengis.net/xls http://schemas.opengis.net/ols/1.2/olsAll.xsd"'},setService:function(t){t?t instanceof a.default?this.oService=t:this.logger.error("L'objet n'est pas du type 'LocationUtilityService' ou 'RouteService' !?"):this.logger.trace("L'objet de type Service XSL n'est pas encore defini !?")},getService:function(){return this.oService}},r.prototype.addNamespace=function(t,e){for(var i,o,n=t.key,s=!1,a=this.namespaceByDefault().split(" "),r=0;r<a.length;r++){if(a[r].split("=")[0]==="xmlns:"+n){s=!0;break}}return s?(i=/<(\w+[\s>])/g,o="<"+n+":$1",e=e.replace(i,o),i=/<\/(\w+[\s>])/g,o="</"+n+":$1",e=e.replace(i,o),this.logger.trace("namespace",e),e):(this.logger.warn("L'ajout d'un nouvel namespace n'est pas encore implémenté !"),e)},r.prototype.build=function(){var t=!!this.getService(),e="";e=(e=(e=(e=this.template).replace(/__VERSION__/g,r.VERSION)).replace(/__NAMESPACE__/g,this.namespaceByDefault)).replace(/__SCHEMALOCATION__/g,this.schemaLocationByDefault);var i=new n.default({srsName:this.options.srsName});e=e.replace(/__REQUESTHEADER__/g,i.toString());var o=new s.default({maximumResponses:this.options.maximumResponses,version:r.VERSION,methodName:t?this.getService().CLASSTYPE:null});if(e=e.replace(/__REQUEST__/g,o.toString()),t&&(e=e.replace(/<!-- __REQUESTSERVICE__ -->/g,this.getService().toString())),e)return this.namespace&&(e=this.addNamespace({key:"xls",url:"http://www.opengis.net/xls"},e)),this.requestString=e,this.logger.trace("traduction tmpl",e),this.requestString;this.logger.warn("traduction tmpl : empty request !?")},e.default=r},function(t,e,i){"use strict";i.r(e);var o=i(43);function n(t){if(this.logger=o.default.getLogger(),this.logger.trace("[Constructeur RequestHeader ()]"),!(this instanceof n))throw new TypeError("RequestHeader constructor cannot be called as a function.");for(var e in this.options=t||{srsName:"EPSG:4326"},t)t.hasOwnProperty(e)&&(this.options[e]=t[e])}n.prototype={requestString:null,template:'<RequestHeader srsName="__SRSNAME__"/>',constructor:n,toString:function(){var t=null;return t=(t=this.template).replace(/__SRSNAME__/g,this.options.srsName),this.requestString=t,this.requestString}},e.default=n},function(t,e,i){"use strict";i.r(e);var o=i(43);function n(t){if(this.logger=o.default.getLogger(),this.logger.trace("[Constructeur Request ()]"),!(this instanceof n))throw new TypeError("Request constructor cannot be called as a function.");for(var e in this.options=t||{maximumResponses:25,methodName:null,version:"1.2"},t)t.hasOwnProperty(e)&&(this.options[e]=t[e])}n.prototype={requestString:null,template:'<Request maximumResponses="__MAXRESPONSES__" methodName="__METHODNAME__" requestID="__UUID__" version="__VERSION__">\x3c!-- __REQUESTSERVICE__ --\x3e</Request>',constructor:n,guid:function(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,(function(t){var e=16*Math.random()|0;return("x"===t?e:3&e|8).toString(16)}))},toString:function(){var t=null;return t=(t=(t=(t=(t=this.template).replace(/__MAXRESPONSES__/g,this.options.maximumResponses)).replace(/__METHODNAME__/g,this.options.methodName)).replace(/__UUID__/g,this.guid())).replace(/__VERSION__/g,this.options.version),this.requestString=t,this.requestString}},e.default=n},function(t,e,i){"use strict";i.r(e);var o=i(43);function n(t){if(this.logger=o.default.getLogger(),this.logger.trace("[Constructeur AbstractService ()]"),!(this instanceof n))throw new TypeError("AbstractService constructor cannot be called as a function.");for(var e in this.options=t||{},t)t.hasOwnProperty(e)&&(this.options[e]=t[e])}n.prototype={strRequest:null,oRequest:null,oFilter:null,constructor:n,addRequest:function(t){this.logger.error("overwritten method !")},addFilter:function(t){this.logger.error("overwritten method !")},toString:function(){this.logger.error("overwritten method !")}},e.default=n},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(92),s=i(94),a=i(97),r=i(96);function l(t){if(this.logger=o.default.getLogger(),this.logger.trace("[Constructeur LocationUtilityService ()]"),!(this instanceof l))throw new TypeError("LocationUtilityService constructor cannot be called as a function.");this.CLASSNAME="LocationUtilityService",this.CLASSTYPE=null,n.default.apply(this,arguments),this.options&&(this.CLASSTYPE=this.options.location?"GeocodeRequest":this.options.position?"ReverseGeocodeRequest":null)}l.prototype=Object.create(n.default.prototype,{}),l.prototype.constructor=l,l.prototype.addRequest=function(t){switch(this.CLASSTYPE=t.CLASSNAME,this.CLASSTYPE){case"GeocodeRequest":case"ReverseGeocodeRequest":this.oRequest=t;break;default:throw new Error("Ce n'est pas un objet de type 'LUS Request' !?")}},l.prototype.addFilter=function(t){t instanceof r.default&&(this.oFilter=t)},l.prototype.toString=function(){if(!this.oRequest){if(!this.options)throw new Error("Les options ne sont pas renseignées, impossible de construire la requête !");if("GeocodeRequest"===this.CLASSTYPE){var t={location:this.options.location,returnFreeForm:this.options.returnFreeForm,filterOptions:this.options.filterOptions||{}};this.oRequest=new s.default(t),this.oFilter&&this.oRequest.addFilter(this.oFilter)}else if("ReverseGeocodeRequest"===this.CLASSTYPE){var e={position:this.options.position,returnFreeForm:this.options.returnFreeForm,filterOptions:this.options.filterOptions||{}};this.oRequest=new a.default(e)}else this.logger.error("impossible de determiner le type de geocodage : Direct ou Inverse !?")}if(!this.oRequest)throw new Error("Type de Geocodage indefini !");return this.strRequest=this.oRequest.toString(),this.strRequest},e.default=l},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(95),s=i(96);function a(t){if(this.logger=o.default.getLogger(),this.logger.trace("[Constructeur GeocodeRequest ()]"),!(this instanceof a))throw new TypeError("GeocodeRequest constructor cannot be called as a function.");for(var e in this.options=t||{},t)t.hasOwnProperty(e)&&(this.options[e]=t[e]);this.CLASSNAME="GeocodeRequest"}a.prototype={strRequest:null,oAddress:null,oFilter:null,template:'<GeocodeRequest returnFreeForm="__RETURNFREEFORM__">__ADDRESS__</GeocodeRequest>',addAddress:function(t){t instanceof n.default&&(this.oAddress=t)},addFilter:function(t){t instanceof s.default&&(this.oFilter=t)},constructor:a,toString:function(){var t="";if(t=this.template,!this.oAddress){var e={};if(e.location=this.options.location,e.type=this.options.filterOptions.type||["StreetAddress"],e.filter=this.options.filterOptions,delete e.filter.type,this.oFilter)for(var i in e.filter={},e.type){var o=e.type[i],s=this.oFilter.getFilter(o);if(s){for(var a=this.options.filterOptions,r=s.attributesList,l=0;l<r.length;l++){var c=r[l];if(a[c]){var u=s.serviceAttributes[l];s.placeAttributes[u]=a[c],this.logger.trace("Selection du filtre '"+c+"' sur le type '"+o+"'.")}}var h=s.placeAttributes;for(var d in h)h.hasOwnProperty(d)&&(e.filter[d]=h[d])}else this.logger.warn("Le filtre '"+o+"' n'existe pas !?")}if(this.oAddress=new n.default(e),!this.oAddress)throw new Error("La construction de l'adresse n'est pas correctement definie !?")}return t=(t=t.replace(/__ADDRESS__/g,this.oAddress.toString())).replace(/__RETURNFREEFORM__/g,this.options.returnFreeForm?"true":"false"),this.strRequest=t,this.strRequest}},e.default=a},function(t,e,i){"use strict";i.r(e);var o=i(43);function n(t){if(this.logger=o.default.getLogger("Address"),this.logger.trace("[Constructeur Address ()]"),!(this instanceof n))throw new TypeError("Address constructor cannot be called as a function.");if(this.options=t||{location:{},type:["StreetAddress"],filter:{}},!t.location)throw new Error("l'option 'location' n'est pas renseignée !");for(var e in t)t.hasOwnProperty(e)&&(this.options[e]=t[e])}n.prototype={constructor:n,requestString:null,template:{address:'<Address countryCode="__COUNTRYCODE__">__LOCATION____PLACE____POSTALCODE____ENVELOPE__</Address>',location:{freeFormAddress:"<freeFormAddress>__FREEFORMADDRESSVALUE__</freeFormAddress>",streetAddress:{container:"<StreetAddress>__STREET____BUILDING__</StreetAddress>",building:'<Building number="__BUILDINGVALUE__"/>',street:"<Street>__STREETVALUE__</Street>"}},place:'<Place type="__PLACETYPE__">__PLACEVALUE__</Place>',postalCode:"<PostalCode>__POSTALCODEVALUE__</PostalCode>",envelope:"<gml:Envelope><gml:lowerCorner>__LEFT__ __BOTTOM__</gml:lowerCorner><gml:upperCorner>__RIGHT__ __TOP__</gml:upperCorner></gml:Envelope>"}},n.prototype.toString=function(){var t=null;if(t=(t=this.template.address).replace(/__COUNTRYCODE__/g,this.options.type),"string"==typeof this.options.location){var e=this.template.location.freeFormAddress;e=e.replace(/__FREEFORMADDRESSVALUE__/g,this.options.location),t=t.replace(/__LOCATION__/g,e)}else{var i="",o="";this.options.location.number&&(i=(i=this.template.location.streetAddress.building).replace(/__BUILDINGVALUE__/g,this.options.location.number)),this.options.location.street&&(o=(o=this.template.location.streetAddress.street).replace(/__STREETVALUE__/g,this.options.location.street));var n=this.template.location.streetAddress.container;n=(n=n.replace(/__STREET__/g,o)).replace(/__BUILDING__/g,i),t=t.replace(/__LOCATION__/g,n)}var s="";this.options.location.postalCode&&(s=(s=this.template.postalCode).replace(/__POSTALCODEVALUE__/g,this.options.location.postalCode));var a="";if(this.options.filter){var r=this.options.filter.bbox;r&&(a=(a=(a=(a=(a=this.template.envelope).replace(/__LEFT__/g,r.left)).replace(/__BOTTOM__/g,r.bottom)).replace(/__RIGHT__/g,r.right)).replace(/__TOP__/g,r.top))}var l=[],c="";if(this.options.filter){var u=this.options.filter;for(var h in u)"bbox"!==h&&(c=(c=(c=this.template.place).replace(/__PLACETYPE__/g,h)).replace(/__PLACEVALUE__/g,u[h]),l.push(c))}var d="";return this.options.location.city&&(d=(d=(d=this.template.place).replace(/__PLACETYPE__/g,"Municipality")).replace(/__PLACEVALUE__/g,this.options.location.city),l.push(d)),t=(t=(t=t.replace(/__POSTALCODE__/g,s)).replace(/__PLACE__/g,l.join("\n"))).replace(/__ENVELOPE__/g,a),this.requestString=t,this.requestString},e.default=n},function(t,e,i){"use strict";i.r(e);var o=i(43);function n(){if(this.logger=o.default.getLogger("GeocodeFilterExtension"),this.logger.trace("[Constructeur GeocodeFilterExtension ()]"),!(this instanceof n))throw new TypeError("GeocodeFilterExtension constructor cannot be called as a function.");this.filters=[]}n.prototype={constructor:n,addFilterExtensions:function(t){t&&this.filters.push(t)},getNames:function(){var t=[];for(var e in this.filters)t.push(this.filters[e].CLASSNAME);return this.logger.trace(t),t},getFilter:function(t){var e=null;for(var i in this.filters)this.filters[i].CLASSNAME===t&&(e=this.filters[i]);return this.logger.trace(e),e},getFilters:function(){return this.logger.trace(this.filters),this.filters},getAttributs:function(t){var e=[];for(var i in this.filters)this.filters[i].CLASSNAME===t&&(e=this.filters[i].attributesList);return this.logger.trace(e),e},setPlaceAttributs:function(t,e){var i=this.getFilter(t),o=this.getAttributs(t);for(var n in o){var s=o[n];e[s]&&(i.placeAttributes[s]=e[s])}},getPlaceAttributs:function(t){var e={};for(var i in this.filters)this.filters[i].CLASSNAME===t&&(e=this.filters[i].placeAttributes);return this.logger.trace(e),e}},e.default=n},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(98),s=i(99);function a(t){if(this.logger=o.default.getLogger(),this.logger.trace("[Constructeur ReverseGeocodeRequest ()]"),!(this instanceof a))throw new TypeError("ReverseGeocodeRequest constructor cannot be called as a function.");for(var e in this.options=t||{},t)t.hasOwnProperty(e)&&(this.options[e]=t[e]);this.CLASSNAME="ReverseGeocodeRequest"}a.prototype={strRequest:null,oPosition:null,oPreference:null,constructor:a,template:'<ReverseGeocodeRequest returnFreeForm="__RETURNFREEFORM__">__POSITION____PREFERENCE__</ReverseGeocodeRequest>',addPosition:function(t){t instanceof n.default&&(this.oPosition=t)},addPreferences:function(t){t instanceof s.default&&(this.oPreference=t)},toString:function(){var t="";if(t=this.template,!this.oPreference&&(this.oPreference=new s.default(this.options.filterOptions.type||["StreetAddress"]),!this.oPreference))throw new Error("Les preferences ne sont pas definies !?");if(t=t.replace(/__PREFERENCE__/g,this.oPreference.toString()),!this.oPosition){var e={position:this.options.position,filter:{}};if(this.options.filterOptions&&(e.filter=this.options.filterOptions,delete e.filter.type),this.oPosition=new n.default(e),!this.oPosition)throw new Error("La position et ses filtres ne sont pas definis !?")}return t=(t=t.replace(/__POSITION__/g,this.oPosition.toString())).replace(/__RETURNFREEFORM__/g,this.options.returnFreeForm?"true":"false"),this.strRequest=t,this.strRequest}},e.default=a},function(t,e,i){"use strict";i.r(e);var o=i(43);function n(t){if(this.logger=o.default.getLogger("Position"),this.logger.trace("[Constructeur Position ()]"),!(this instanceof n))throw new TypeError("Position constructor cannot be called as a function.");if(this.options=t||{},!t.position)throw new Error("l'option 'position' n'est pas renseignée !");for(var e in t)t.hasOwnProperty(e)&&(this.options[e]=t[e])}n.prototype={constructor:n,requestString:null,template:{position:"<Position>__GMLPOINT____GMLFILTER__</Position>",gml:{point:'<gml:Point xmlns:gml="http://www.opengis.net/gml"><gml:pos>__X__ __Y__</gml:pos></gml:Point>',pos:null,filter:{bbox:'<gml:Envelope xmlns:gml="http://www.opengis.net/gml"><gml:lowerCorner>__LEFT__ __BOTTOM__</gml:lowerCorner><gml:upperCorner>__RIGHT__ __TOP__</gml:upperCorner></gml:Envelope>',circle:'<gml:CircleByCenterPoint xmlns:gml="http://www.opengis.net/gml"><gml:pos>__X__ __Y__</gml:pos><gml:radius>__RADIUS__</gml:radius></gml:CircleByCenterPoint>',polygon:'<gml:Polygon xmlns:gml="http://www.opengis.net/gml"><gml:exterior><gml:LinearRing><gml:posList>__XY__</gml:posList></gml:LinearRing></gml:exterior></gml:Polygon>',multipolygon:null}}}},n.prototype.toString=function(){var t=this.template.position,e=this.template.gml.point;e=(e=e.replace(/__X__/g,this.options.position.x)).replace(/__Y__/g,this.options.position.y);var i="";if(this.options.filter){var o=this.options.filter;for(var n in o)switch(n){case"circle":i=(i=(i=(i=this.template.gml.filter[n]).replace(/__X__/g,o[n].x)).replace(/__Y__/g,o[n].y)).replace(/__RADIUS__/g,o[n].radius);break;case"bbox":i=(i=(i=(i=(i=this.template.gml.filter[n]).replace(/__LEFT__/g,o[n].left)).replace(/__BOTTOM__/g,o[n].bottom)).replace(/__RIGHT__/g,o[n].right)).replace(/__TOP__/g,o[n].top);break;case"polygon":i=this.template.gml.filter[n];for(var s="",a=o[n],r=0;r<a.length;r++){var l=a[r];if(Array.isArray(l)){this.logger.error("Holes are not implemented !");break}(l.x&&l.y||0===l.x||0===l.y)&&(s+=l.x+" "+l.y),a.length!==r+1&&(s+=" ")}i=i.replace(/__XY__/g,s);break;case"multipolygon":this.logger.warn("Filter '"+n+"' is not yet implemented !");break;default:this.logger.error("This filter '"+n+"' is not useful !")}}return t=(t=t.replace(/__GMLPOINT__/g,e)).replace(/__GMLFILTER__/g,i),this.requestString=t,this.requestString},e.default=n},function(t,e,i){"use strict";i.r(e);var o=i(43);function n(t){if(this.logger=o.default.getLogger("Preference"),this.logger.trace("[Constructeur Preference ()]"),!(this instanceof n))throw new TypeError("Preference constructor cannot be called as a function.");this.type=t}n.prototype={constructor:n,requestString:null,template:"<ReverseGeocodePreference>__TYPE__</ReverseGeocodePreference>"},n.prototype.toString=function(){for(var t=[],e="",i=0;i<this.type.length;i++)e=(e=this.template).replace(/__TYPE__/g,this.type[i]),t.push(e);return this.strRequest=t.join("\n"),this.strRequest},e.default=n},function(t,e,i){"use strict";i.r(e);var o=i(101);function n(){if(!(this instanceof n))throw new TypeError("StreetAddress constructor cannot be called as a function.");o.default.apply(this,arguments),this.CLASSNAME="StreetAddress",this.attributesList=["bbox","ID","IDTR","quality","territory","commune","department","insee","municipality"],this.serviceAttributes=["bbox","ID","IDTR","Qualite","Territoire","Commune","Departement","INSEE","Municipality"]}n.prototype=Object.create(o.default.prototype),n.prototype.constructor=n,e.default=n},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("GeocodeLocation constructor cannot be called as a function.");this.placeAttributes={},this.attributesList=[],this.serviceAttributes=[]}i.r(e),o.prototype={constructor:o},e.default=o},function(t,e,i){"use strict";i.r(e);var o=i(101);function n(){if(!(this instanceof n))throw new TypeError("PositionOfInterest constructor cannot be called as a function.");o.default.apply(this,arguments),this.CLASSNAME="PositionOfInterest",this.attributesList=["bbox","importance","nature","territory","commune","department","insee","municipality"],this.serviceAttributes=["bbox","Importance","Nature","Territoire","Commune","Departement","INSEE","Municipality"]}n.prototype=Object.create(o.default.prototype),n.prototype.constructor=n,e.default=n},function(t,e,i){"use strict";i.r(e);var o=i(101);function n(){if(!(this instanceof n))throw new TypeError("CadastralParcel constructor cannot be called as a function.");o.default.apply(this,arguments),this.CLASSNAME="CadastralParcel",this.attributesList=["absorbedCity","sheet","number","section","commune","department","insee","municipality","origin"],this.serviceAttributes=["CommuneAbsorbee","Feuille","Numero","Section","Commune","Departement","INSEE","Municipality","Type"]}n.prototype=Object.create(o.default.prototype),n.prototype.constructor=n,e.default=n},function(t,e,i){"use strict";i.r(e);var o=i(101);function n(){if(!(this instanceof n))throw new TypeError("Administratif constructor cannot be called as a function.");o.default.apply(this,arguments),this.CLASSNAME="Administratif",this.attributesList=["bbox","prefecture","inseeRegion","inseeDepartment","municipality"],this.serviceAttributes=["bbox","Prefecture","InseeRegion","InseeDepartement","Municipality"]}n.prototype=Object.create(o.default.prototype),n.prototype.constructor=n,e.default=n},function(t,e,i){"use strict";i.r(e);var o=i(45),n=i(44),s=i(66),a=i(106),r={build:function(t){var e=null;if(t.response){if(t.rawResponse)e=t.response;else{try{var i=new s.default({reader:a.default});if("string"==typeof t.response?i.setXMLString(t.response):i.setXMLDoc(t.response),!(e=i.parse()))throw new Error("L'analyse de la réponse du service !?")}catch(e){var r=e.message;return"string"==typeof t.response?r+="('"+t.response+"')":r+="('"+t.response.documentElement.innerHTML+"')",void t.onError.call(t.scope,new o.default({message:n.default.getMessage("SERVICE_RESPONSE_ANALYSE",r),type:o.default.TYPE_UNKERR,status:-1}))}if(e.exceptionReport)return void t.onError.call(t.scope,new o.default({message:n.default.getMessage("SERVICE_RESPONSE_EXCEPTION",e.exceptionReport),type:o.default.TYPE_SRVERR,status:200}))}t.onSuccess.call(t.scope,e)}else t.onError.call(t.scope,new o.default({message:n.default.getMessage("SERVICE_RESPONSE_EMPTY"),type:o.default.TYPE_SRVERR,status:-1}))}};e.default=r},function(t,e,i){"use strict";i.r(e);var o=i(44),n=i(45),s=i(107),a=i(108),r={};function l(t,e){if(t.hasChildNodes())for(var i,o,n,s=t.childNodes,a=0;a<s.length;a++){if(1===(i=s[a]).nodeType)if(o=i.localName||i.baseName||i.nodeName,n=i.prefix||r.DEFAULTPREFIX,r.READERS[n][o])(0,r.READERS[n][o])(i,e);else l(i,e)}}function c(t){var e,i="";return t.hasChildNodes()&&3===(e=t.firstChild).nodeType&&(i=e.nodeValue),i}r.VERSION="1.2",r.NAMESPACES={xmlns:"http://www.opengis.net/xls",gml:"http://www.opengis.net/gml",xls:"http://www.opengis.net/xls",xlsext:"http://www.opengis.net/xlsext",xsi:"http://www.w3.org/2001/XMLSchema-instance"},r.SCHEMALOCATION="http://wxs.ign.fr/schemas/olsAll.xsd",r.DEFAULTPREFIX="xls",r.READERS={xls:{XLS:function(t){var e=new s.default;return function(t){if(t.attributes.length>0){var e=function(t){if(t.attributes.length>0){for(var e={},i=t.attributes,o=0;o<i.length;o++){var n=i[o];e[n.nodeName]=n.nodeValue}return e}}(t);for(var i in e)if(e.hasOwnProperty(i)){if("version"===i&&e.version!==r.VERSION)return void console.log("[DirectGeocodeResponseReader] geocode version is not the expected one : there may be errors in parsing");if("xmlns"===i){if(e[i]!==r.NAMESPACES[r.DEFAULTPREFIX])return void console.log("[DirectGeocodeResponseReader] geocode response default namespace is not the expected one");continue}var o=i.split(":")[0],n=i.split(":")[1];if("xmlns"===o&&n&&r.NAMESPACES[n]&&r.NAMESPACES[n]!==e[i])return void console.log("[DirectGeocodeResponseReader] geocode response "+i+" namespace is not the expected one");if("schemaLocation"===n&&r.SCHEMALOCATION!==e[i])return void console.log("[DirectGeocodeResponseReader] geocode response schema location is not the expected one")}}}(t),l(t,e),e},GeocodedAddress:function(t,e){var i=new a.default;l(t,i),e&&Array.isArray(e.locations)&&e.locations.push(i)},GeocodeMatchCode:function(t,e){var i=t.getAttribute("accuracy");i&&e&&(e.accuracy=parseFloat(i));var o=t.getAttribute("matchType");o&&e&&(e.matchType=o)},Address:function(t,e){var i=t.getAttribute("countryCode");e&&i&&(e.type=i),l(t,e)},freeFormAddress:function(t,e){e&&e.hasOwnProperty("placeAttributes")&&(e.placeAttributes.freeform=c(t))},Building:function(t,e){var i=t.getAttribute("number");e&&e.hasOwnProperty("placeAttributes")&&(i?e.placeAttributes.number=i:t.getAttribute("buildingName")?e.placeAttributes.number=t.getAttribute("buildingName"):t.getAttribute("subdivision")&&(e.placeAttributes.number=t.getAttribute("subdivision")))},Street:function(t,e){e&&e.hasOwnProperty("placeAttributes")&&("StreetAddress"===e.type?e.placeAttributes.street=c(t):"CadastralParcel"===e.type&&(e.placeAttributes.cadastralParcel=c(t)))},Place:function(t,e){var i=t.getAttribute("type"),o=c(t);if(e&&e.hasOwnProperty("placeAttributes"))if("Municipality"===i)e.placeAttributes.municipality=o;else if("Bbox"===i){var n=o.split(";");4===n.length&&(e.placeAttributes.bbox={left:parseFloat(n[0]),right:parseFloat(n[2]),top:parseFloat(n[1]),bottom:parseFloat(n[3])})}else"Commune"===i?e.placeAttributes.commune=o:"Departement"===i?e.placeAttributes.department=o:"INSEE"===i?e.placeAttributes.insee=o:"Qualite"===i?e.placeAttributes.quality=o:"Territoire"===i?e.placeAttributes.territory=o:"ID"===i?e.placeAttributes.ID=o:"ID_TR"===i?e.placeAttributes.IDTR=o:"Importance"===i?e.placeAttributes.importance=parseInt(o,10):"Nature"===i?e.placeAttributes.nature=o:"Numero"===i?e.placeAttributes.number=o:"Feuille"===i?e.placeAttributes.sheet=o:"Section"===i?e.placeAttributes.section=o:"CommuneAbsorbee"===i?e.placeAttributes.absorbedCity=o:"Arrondissement"===i?o&&(e.placeAttributes.arrondissement=o):"Type"===i?e.placeAttributes.origin=o:"Prefecture"===i?e.placeAttributes.prefecture=o:"InseeRegion"===i?e.placeAttributes.inseeRegion=o:"InseeDepartment"===i&&(e.placeAttributes.inseeDepartment=o)},PostalCode:function(t,e){e&&e.hasOwnProperty("placeAttributes")&&(e.placeAttributes.postalCode=c(t))},Error:function(t){var e=t.getAttribute("message"),i=t.getAttribute("errorCode"),s=o.default.getMessage("SERVICE_RESPONSE_EXCEPTION","("+i+") : "+e);throw new n.default({message:s,type:n.default.TYPE_SRVERR})}},gml:{pos:function(t,e){var i=c(t);e&&i&&(e.position={x:parseFloat(i.split(" ")[0]),y:parseFloat(i.split(" ")[1])})}},ExceptionReport:function(t){var e={};if(t.hasChildNodes())for(var i,o=t.childNodes,n=0;n<o.length;n++)"Exception"===(i=o[n]).nodeName&&(e.exceptionReport=r.READERS.Exception(i));return e},Exception:function(t){var e={},i=t.getAttribute("exceptionCode");i&&(e.exceptionCode=i);var o=t.firstChild;return o&&3===o.nodeType&&(e.exception=o.nodeValue),e}},r.read=function(t){if("XLS"===t.nodeName){var e=t.prefix;return e||(e=r.DEFAULTPREFIX),r.READERS[e][t.nodeName](t)}if("ExceptionReport"===t.nodeName)return r.READERS[t.nodeName](t);var i=o.default.getMessage("SERVICE_RESPONSE_ANALYSE",t.nodeName);throw new n.default({message:i,type:n.default.TYPE_UNKERR,status:200})},e.default=r},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("GeocodeResponse constructor cannot be called as a function.");this.locations=[]}i.r(e),o.prototype={constructor:o},e.default=o},function(t,e,i){"use strict";i.r(e);var o=i(109);function n(){if(!(this instanceof n))throw new TypeError("DirectGeocodedLocation constructor cannot be called as a function.");o.default.apply(this,arguments),this.CLASSNAME="DirectGeocodedLocation",this.accuracy=null}n.prototype=Object.create(o.default.prototype),n.prototype.constructor=n,e.default=n},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("GeocodedLocation constructor cannot be called as a function.");this.position={x:null,y:null},this.matchType=null,this.placeAttributes={},this.type=null}i.r(e),o.prototype={constructor:o},e.default=o},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(44),s=i(45),a=i(46),r=i(111),l=i(112);function c(t){if(!(this instanceof c))throw new TypeError(n.default.getMessage("CLASS_CONSTRUCTOR","ReverseGeocode"));if(this.CLASSNAME="ReverseGeocode",a.default.apply(this,arguments),this.logger=o.default.getLogger("Gp.Services.ReverseGeocode"),this.logger.trace("[Constructeur ReverseGeocode (options)]"),!t.position)throw new Error(n.default.getMessage("PARAM_MISSING","position"));if(null===t.position.x)throw new Error(n.default.getMessage("PARAM_MISSING","position.x"));if(null===t.position.y)throw new Error(n.default.getMessage("PARAM_MISSING","position.y"));this.options.position=t.position,t.filterOptions&&"object"==typeof t.filterOptions||(this.options.filterOptions=t.filterOptions={type:["StreetAddress"]}),0===Object.keys(t.filterOptions).length&&(this.options.filterOptions={type:["StreetAddress"]});for(var e=Object.keys(t.filterOptions),i=0;i<e.length;i++){var s=e[i];t.filterOptions[s]&&0!==Object.keys(t.filterOptions[s]).length||delete this.options.filterOptions[s]}if(this.options.filterOptions.type=t.filterOptions.type||["StreetAddress"],!Array.isArray(this.options.filterOptions.type))throw new Error(n.default.getMessage("PARAM_TYPE","filterOptions.type"));if(this.options.maximumResponses=t.maximumResponses||25,this.options.returnFreeForm=t.returnFreeForm||!1,this.options.srs=t.srs||"CRS:84",-1===c.geoEPSG.indexOf(this.options.srs)){if(this.options.position={x:this.options.position.y,y:this.options.position.x},this.options.filterOptions&&this.options.filterOptions.circle){var r=this.options.filterOptions.circle;this.options.filterOptions.circle={x:r.y,y:r.x,radius:r.radius}}if(this.options.filterOptions&&this.options.filterOptions.polygon){var l=this.options.filterOptions.polygon;for(i=0;i<l.length;i++){var u=l[i];this.options.filterOptions.polygon[i]={x:u.y,y:u.x}}}}this.options.outputFormat=this.options.rawResponse?"":"xml"}c.prototype=Object.create(a.default.prototype,{}),c.prototype.constructor=c,c.prototype.buildRequest=function(t,e){var i={httpMethod:this.options.httpMethod,position:this.options.position,returnFreeForm:this.options.returnFreeForm,filterOptions:this.options.filterOptions,srs:"EPSG:4326",maximumResponses:this.options.maximumResponses};this.request=r.default.build(i),this.request?e.call(this,this.request):t.call(this,new s.default(n.default.getMessage("SERVICE_REQUEST_BUILD")))},c.prototype.analyzeResponse=function(t,e){if(this.response){var i={response:this.response,rawResponse:this.options.rawResponse,onError:t,onSuccess:e,scope:this};l.default.build(i)}else t.call(this,new s.default(n.default.getMessage("SERVICE_RESPONSE_EMPTY")))},c.geoEPSG=["EPSG:4326"],e.default=c},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(89),s=i(93),a={build:function(t){var e=o.default.getLogger("ReverseGeocodeRequestFactory");e.trace(["ReverseGeocodeRequestFactory::build()"]);var i=t||{},a=null,r=new s.default({position:i.position,returnFreeForm:i.returnFreeForm,filterOptions:i.filterOptions}),l=new n.default({srsName:i.srs,maximumResponses:i.maximumResponses});(l.namespace=!0,l.setService(r),a=l.build(),"GET"===i.httpMethod)&&(a="qxml="+encodeURIComponent(a).replace(/-/g,"%2D").replace(/_/g,"%5F").replace(/\./g,"%2E").replace(/!/g,"%21").replace(/~/g,"%7E").replace(/\*/g,"%2A").replace(/'/g,"%27").replace(/\(/g,"%28").replace(/\)/g,"%29"));return e.trace(a),a}};e.default=a},function(t,e,i){"use strict";i.r(e);var o=i(44),n=i(45),s=i(66),a=i(113),r={build:function(t){var e=null;if(t.response){if(t.rawResponse)e=t.response;else{try{var i=new s.default({reader:a.default});if("string"==typeof t.response?i.setXMLString(t.response):i.setXMLDoc(t.response),!(e=i.parse()))throw new Error("L'analyse de la réponse du service !?")}catch(e){return e.status=200,void t.onError.call(t.scope,e)}if(e.exceptionReport)return void t.onError.call(t.scope,new n.default({message:o.default.getMessage("SERVICE_RESPONSE_EXCEPTION",e.exceptionReport),type:n.default.TYPE_SRVERR,status:200}));var r,l;if(t.scope&&t.scope.options&&t.scope.options.srs&&"EPSG:4326"!==t.scope.options.srs)if(e||e.locations||e.locations.length)for(var c=0;c<e.locations.length;c++)(r=e.locations[c])&&(l=r.position)&&(r.position={x:l.y,y:l.x})}t.onSuccess.call(t.scope,e)}else t.onError.call(t.scope,new n.default({message:o.default.getMessage("SERVICE_RESPONSE_EMPTY"),type:n.default.TYPE_SRVERR,status:-1}))}};e.default=r},function(t,e,i){"use strict";i.r(e);var o=i(44),n=i(45),s=i(107),a=i(114),r={};function l(t,e){if(t.hasChildNodes())for(var i,o,n,s=t.childNodes,a=0;a<s.length;a++){if(1===(i=s[a]).nodeType)if(o=i.localName||i.baseName||i.nodeName,n=i.prefix||r.DEFAULTPREFIX,r.READERS[n][o])(0,r.READERS[n][o])(i,e);else l(i,e)}}function c(t){var e,i="";return t.hasChildNodes()&&3===(e=t.firstChild).nodeType&&(i=e.nodeValue),i}r.VERSION="1.2",r.NAMESPACES={xmlns:"http://www.opengis.net/xls",gml:"http://www.opengis.net/gml",xls:"http://www.opengis.net/xls",xlsext:"http://www.opengis.net/xlsext",xsi:"http://www.w3.org/2001/XMLSchema-instance"},r.SCHEMALOCATION="http://wxs.ign.fr/schemas/olsAll.xsd",r.DEFAULTPREFIX="xls",r.READERS={xls:{XLS:function(t){var e=new s.default;return function(t){if(t.attributes.length>0){var e=function(t){if(t.attributes.length>0){for(var e={},i=t.attributes,o=0;o<i.length;o++){var n=i[o];e[n.nodeName]=n.nodeValue}return e}}(t);for(var i in e)if(e.hasOwnProperty(i)){if("version"===i&&e.version!==r.VERSION)return void console.log("[ReverseGeocodeResponseReader] geocode version is not the expected one : there may be errors in parsing");if("xmlns"===i){if(e[i]!==r.NAMESPACES[r.DEFAULTPREFIX])return void console.log("[ReverseGeocodeResponseReader] geocode response default namespace is not the expected one");continue}var o=i.split(":")[0],n=i.split(":")[1];if("xmlns"===o&&n&&r.NAMESPACES[n]&&r.NAMESPACES[n]!==e[i])return void console.log("[ReverseGeocodeResponseReader] geocode response "+i+" namespace is not the expected one");if("schemaLocation"===n&&r.SCHEMALOCATION!==e[i])return void console.log("[ReverseGeocodeResponseReader] geocode response schema location is not the expected one")}}}(t),l(t,e),e},ReverseGeocodedLocation:function(t,e){var i=new a.default;l(t,i),e&&Array.isArray(e.locations)&&e.locations.push(i)},Address:function(t,e){var i=t.getAttribute("countryCode");e&&i&&(e.type=i),l(t,e)},Building:function(t,e){var i=t.getAttribute("number");e&&e.hasOwnProperty("placeAttributes")&&(i?e.placeAttributes.number=i:t.getAttribute("buildingName")?e.placeAttributes.number=t.getAttribute("buildingName"):t.getAttribute("subdivision")&&(e.placeAttributes.number=t.getAttribute("subdivision")))},Street:function(t,e){"StreetAddress"===e.type?e.placeAttributes.street=c(t):"CadastralParcel"===e.type&&(e.placeAttributes.cadastralParcel=c(t))},Place:function(t,e){var i=t.getAttribute("type"),o=c(t);if(e&&e.hasOwnProperty("placeAttributes"))if("Municipality"===i)e.placeAttributes.municipality=o;else if("Bbox"===i){var n=o.split(";");4===n.length&&(e.placeAttributes.bbox={left:parseFloat(n[0]),right:parseFloat(n[2]),top:parseFloat(n[1]),bottom:parseFloat(n[3])})}else"Commune"===i?e.placeAttributes.commune=o:"Departement"===i?e.placeAttributes.department=o:"INSEE"===i?e.placeAttributes.insee=o:"Qualite"===i?e.placeAttributes.quality=o:"Territoire"===i?e.placeAttributes.territory=o:"ID"===i?e.placeAttributes.ID=o:"ID_TR"===i?e.placeAttributes.IDTR=o:"Importance"===i?e.placeAttributes.importance=parseInt(o,10):"Nature"===i?e.placeAttributes.nature=o:"Numero"===i?e.placeAttributes.number=o:"Feuille"===i?e.placeAttributes.sheet=o:"Section"===i?e.placeAttributes.section=o:"CommuneAbsorbee"===i?e.placeAttributes.absorbedCity=o:"Arrondissement"===i?o&&(e.placeAttributes.arrondissement=o):"Type"===i?e.placeAttributes.origin=o:"Prefecture"===i?e.placeAttributes.prefecture=o:"InseeRegion"===i?e.placeAttributes.inseeRegion=o:"InseeDepartment"===i&&(e.placeAttributes.inseeDepartment=o)},PostalCode:function(t,e){e&&e.hasOwnProperty("placeAttributes")&&(e.placeAttributes.postalCode=c(t))},SearchCentreDistance:function(t,e){e&&(e.searchCenterDistance=parseFloat(t.getAttribute("value")))},Error:function(t){var e=t.getAttribute("message"),i=t.getAttribute("errorCode"),s=o.default.getMessage("SERVICE_RESPONSE_EXCEPTION","("+i+") : "+e);throw new n.default({message:s,type:n.default.TYPE_SRVERR})}},gml:{pos:function(t,e){var i=c(t);e&&i&&(e.position={x:parseFloat(i.split(" ")[0]),y:parseFloat(i.split(" ")[1])})}},xlsext:{ExtendedGeocodeMatchCode:function(t,e){e&&(e.matchType=c(t))}},ExceptionReport:function(t){var e={};if(t.hasChildNodes())for(var i,o=t.childNodes,n=0;n<o.length;n++)"Exception"===(i=o[n]).nodeName&&(e.exceptionReport=r.READERS.Exception(i));return e},Exception:function(t){var e={},i=t.getAttribute("exceptionCode");i&&(e.exceptionCode=i);var o=t.firstChild;return o&&3===o.nodeType&&(e.exception=o.nodeValue),e}},r.read=function(t){if("XLS"===t.nodeName){var e=t.prefix;return e||(e=r.DEFAULTPREFIX),r.READERS[e][t.nodeName](t)}if("ExceptionReport"===t.nodeName)return r.READERS[t.nodeName](t);throw new Error("Erreur lors de la lecture de la réponse : elle n'est pas au format attendu.")},e.default=r},function(t,e,i){"use strict";i.r(e);var o=i(109);function n(){if(!(this instanceof n))throw new TypeError("ReverseGeocodedLocation constructor cannot be called as a function.");o.default.apply(this,arguments),this.CLASSNAME="ReverseGeocodedLocation",this.searchCenterDistance=null}n.prototype=Object.create(o.default.prototype),n.prototype.constructor=n,e.default=n},function(t,e,i){"use strict";i.r(e);var o=i(46),n=i(116),s=i(43),a=i(44),r=i(47),l=i(45);function c(t){if(!(this instanceof c))throw new TypeError(a.default.getMessage("CLASS_CONSTRUCTOR","AutoComplete"));if(this.CLASSNAME="AutoComplete",o.default.apply(this,arguments),this.logger=s.default.getLogger("Gp.Services.AutoComplete"),this.logger.trace("[Constructeur AutoComplete (options)]"),!t.text)throw new Error(a.default.getMessage("PARAM_MISSING","text"));this.options.text=t.text,t.filterOptions&&"object"==typeof t.filterOptions||(this.options.filterOptions=t.filterOptions={territory:[],type:["StreetAddress"]}),0===Object.keys(t.filterOptions).length&&(this.options.filterOptions={territory:[],type:["StreetAddress"]}),this.options.filterOptions.type=t.filterOptions.type||["StreetAddress"],this.options.filterOptions.territory=t.filterOptions.territory||[],this.options.maximumResponses=t.maximumResponses||10,"XHR"===this.options.protocol&&"POST"===this.options.httpMethod&&(this.logger.warn("Le service ne gére pas le mode d'interrogation en POST, on bascule sur du GET !"),this.options.httpMethod="GET"),this.options.outputFormat=this.options.rawResponse?"":"json"}c.prototype=Object.create(o.default.prototype,{}),c.prototype.constructor=c,c.prototype.buildRequest=function(t,e){var i="";this.options.filterOptions.territory&&(i=this.options.filterOptions.territory.join(";"));var o="";this.options.filterOptions.type&&(o=this.options.filterOptions.type.join(",")),this.request=r.default.normalyzeParameters({text:encodeURIComponent(this.options.text),type:o,terr:i,maximumResponses:this.options.maximumResponses}),this.request?e.call(this,this.request):t.call(this,new l.default(a.default.getMessage("SERVICE_REQUEST_BUILD")))},c.prototype.analyzeResponse=function(t,e){if(this.response){var i={response:this.response,rawResponse:this.options.rawResponse,onSuccess:e,onError:t,scope:this};n.default.build(i)}else t.call(this,new l.default(a.default.getMessage("SERVICE_RESPONSE_EMPTY")))},e.default=c},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(44),s=i(45),a=i(117),r=i(118),l={build:function(t){var e=o.default.getLogger("AutoCompleteResponseFactory");e.trace(["AutoCompleteResponseFactory::build()"]);var i=null;if(t.response){if(t.rawResponse)e.trace("analyze response : raw"),i=t.response;else{var l;if(l="string"==typeof t.response?JSON.parse(t.response):t.response){if(l.error)return void t.onError.call(t.scope,new s.default({message:n.default.getMessage("SERVICE_RESPONSE_EXCEPTION",l.error.description),status:l.error.code,type:s.default.TYPE_SRVERR}));if(i=new a.default,!l.results||!Array.isArray(l.results))return void t.onError.call(t.scope,new s.default(n.default.getMessage("SERVICE_RESPONSE_FORMAT_3")));for(var c,u=0;u<l.results.length;u++){var h=l.results[u];(c=new r.default)&&(h&&"StreetAddress"===h.country?(c.street=h.street,c.type="StreetAddress"):h&&"PositionOfInterest"===h.country&&(c.poi=h.street,c.kind=h.kind,c.type="PositionOfInterest"),c.position&&(c.position.x=h.x,c.position.y=h.y),c.commune=h.city,c.fullText=h.fulltext,c.postalCode=h.zipcode,c.classification=h.classification),i.suggestedLocations.push(c)}if(!i.suggestedLocations.length)return void t.onError.call(t.scope,new s.default(n.default.getMessage("SERVICE_RESPONSE_FORMAT_3")))}if(!i)return void t.onError.call(t.scope,new s.default({message:n.default.getMessage("SERVICE_RESPONSE_ANALYSE_2"),type:s.default.TYPE_UNKERR,status:-1}));if(i.exceptionReport)return void t.onError.call(t.scope,new s.default({message:n.default.getMessage("SERVICE_RESPONSE_EXCEPTION",i.exceptionReport),type:s.default.TYPE_SRVERR,status:200}))}t.onSuccess.call(t.scope,i)}else t.onError.call(t.scope,new s.default(n.default.getMessage("SERVICE_RESPONSE_EMPTY")))}};e.default=l},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("AutoCompleteResponse constructor cannot be called as a function.");this.suggestedLocations=[]}i.r(e),o.prototype={constructor:o},e.default=o},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("SuggestedLocation constructor cannot be called as a function.");this.type=null,this.position={x:null,y:null},this.commune=null,this.fullText=null,this.postalCode=null,this.classification=null,this.street=null,this.poi=null,this.kind=null}i.r(e),o.prototype={constructor:o},e.default=o},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(44),s=i(45),a=i(46),r=i(56),l=i(120),c=i(128);function u(t){if(!(this instanceof u))throw new TypeError(n.default.getMessage("CLASS_CONSTRUCTOR","Route"));if(this.CLASSNAME="Route",a.default.apply(this,arguments),this.logger=o.default.getLogger("Gp.Services.Route"),this.logger.trace("[Constructeur Route (options)]"),!t.startPoint)throw new Error(n.default.getMessage("PARAM_MISSING","startPoint"));if(null===t.startPoint.x)throw new Error(n.default.getMessage("PARAM_MISSING","startPoint.x"));if(null===t.startPoint.y)throw new Error(n.default.getMessage("PARAM_MISSING","startPoint.y"));if(!t.endPoint)throw new Error(n.default.getMessage("PARAM_MISSING","endPoint"));if(null===t.endPoint.x)throw new Error(n.default.getMessage("PARAM_MISSING","endPoint.x"));if(null===t.endPoint.y)throw new Error(n.default.getMessage("PARAM_MISSING","endPoint.y"));if(this.options.api="string"==typeof t.api?t.api.toUpperCase():"REST",this.options.outputFormat="string"==typeof t.outputFormat?t.outputFormat.toLowerCase():"json",this.options.startPoint=t.startPoint,this.options.endPoint=t.endPoint,this.options.viaPoints=t.viaPoints||null,this.options.exclusions=t.exclusions||null,this.options.routePreference=t.routePreference||"fastest",this.options.graph=t.graph||"Voiture",this.options.geometryInInstructions=t.geometryInInstructions||!1,this.options.provideBbox=t.provideBbox||!0,this.options.distanceUnit=t.distanceUnit||"km",this.options.expectedStartTime=null,this.options.srs=t.srs||"EPSG:4326",this.options.api="REST",this.logger.warn("Surcharge option 'api' : REST (readers OLS non implémentés)"),"XHR"===this.options.protocol&&(this.options.httpMethod="GET",this.logger.trace("Surcharge option 'HttpMethod' : "+this.options.httpMethod)),!this.options.serverUrl){var e=r.default.Route.url(this.options.apiKey),i=null;switch(this.options.api){case"OLS":i=e.ols;break;case"REST":i=e["route-"+this.options.outputFormat];break;default:throw new Error(n.default.getMessage("PARAM_UNKNOWN","api"))}if(!i)throw new Error("Url by default not found !");this.options.serverUrl=i,this.logger.trace("Serveur URL par defaut : "+this.options.serverUrl)}var s=this.options.serverUrl.lastIndexOf(".");if(-1!==s){var l=this.options.serverUrl.substring(s+1);if(l&&l.length<5)switch(this.logger.trace("Serveur Extension URL : "+l),l.toLowerCase()){case"json":case"xml":this.options.outputFormat=l.toLowerCase();break;default:throw new Error("type of service : unknown or unsupported (json or xml) !")}}}u.prototype=Object.create(a.default.prototype,{}),u.prototype.constructor=u,u.prototype.buildRequest=function(t,e){var i={api:this.options.api,startPoint:this.options.startPoint,endPoint:this.options.endPoint,viaPoints:this.options.viaPoints,provideBbox:this.options.provideBbox,exclusions:this.options.exclusions,distanceUnit:this.options.distanceUnit,graph:this.options.graph,geometryInInstructions:this.options.geometryInInstructions,routePreference:this.options.routePreference,srs:this.options.srs};this.request=l.default.build(i),this.request?e.call(this,this.request):t.call(this,new s.default(n.default.getMessage("SERVICE_REQUEST_BUILD")))},u.prototype.analyzeResponse=function(t,e){if(this.response){var i={distanceUnit:this.options.distanceUnit,response:this.response,outputFormat:this.options.outputFormat,api:this.options.api,rawResponse:this.options.rawResponse,onError:t,onSuccess:e,scope:this};c.default.build(i)}else t.call(this,new s.default(n.default.getMessage("SERVICE_RESPONSE_EMPTY")))},e.default=u},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(45),s=i(121),a=i(126),r={build:function(t){o.default.getLogger("RouteRequestFactory").trace(["RouteRequestFactory::build()"]);var e=null,i=t||{},r=!(null===t.onError||"function"!=typeof t.onError),l=null;switch(t.api){case"REST":var c=new a.default(i);if(!c.processRequestString()){if(l="Error process request (rest) !",r)return void t.onError.call(t.scope,new n.default(l));throw new Error(l)}e=c.requestString;break;case"OLS":if(!(e=s.default.build(i))){if(l="Error process request (ols) !",r)return void t.onError.call(t.scope,new n.default(l));throw new Error(l)}break;default:if(l="Type of API is not supported by service (REST or OLS) !",r)return void t.onError.call(t.scope,new n.default(l));throw new Error(l)}return e}};e.default=r},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(89),s=i(122),a={build:function(t){o.default.getLogger("RouteRequestOLS").trace(["RouteRequestOLS::build()"]);var e=null,i={startPoint:t.startPoint,endPoint:t.endPoint,viaPoint:t.viaPoints,provideBoundingBox:t.provideBbox,avoidFeature:t.exclusions,expectedStartTime:t.expectedStartTime,distanceUnit:t.distanceUnit,graph:t.graph,provideGeometry:t.geometryInInstructions,routePreference:t.routePreference},a=new s.default(i),r=new n.default({srsName:t.srs,maximumResponses:t.maximumResponses});(r.namespace=!0,r.setService(a),e=r.build(),"GET"===t.httpMethod)&&(e="qxml="+encodeURIComponent(e).replace(/-/g,"%2D").replace(/_/g,"%5F").replace(/\./g,"%2E").replace(/!/g,"%21").replace(/~/g,"%7E").replace(/\*/g,"%2A").replace(/'/g,"%27").replace(/\(/g,"%28").replace(/\)/g,"%29"));return e}};e.default=a},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(92),s=i(123),a=i(125),r=i.n(a);function l(t){if(this.logger=o.default.getLogger(),this.logger.trace("[Constructeur RouteService ()]"),!(this instanceof l))throw new TypeError("RouteService constructor cannot be called as a function.");this.CLASSNAME="RouteService",this.CLASSTYPE="RouteRequest",n.default.apply(this,arguments)}l.prototype=Object.create(n.default.prototype,{}),l.prototype.constructor=l,l.prototype.addRequest=function(t){if("DetermineRouteRequest"!==t.CLASSNAME)throw new Error("Ce n'est pas un objet de type 'Route Request' !?");this.oRequest=t},l.prototype.addFilter=function(t){t instanceof r.a&&(this.oFilter=t)},l.prototype.toString=function(){if(!this.oRequest){if(!this.options)throw new Error("Les options ne sont pas renseignées, impossible de construire la requête !");if("RouteRequest"===this.CLASSTYPE){var t={distanceUnit:this.options.distanceUnit||null,provideGeometry:this.options.provideGeometry||null,provideBoundingBox:this.options.provideBoundingBox||null,route:{routePreference:this.options.routePreference||null,startPoint:this.options.startPoint,viaPoint:this.options.viaPoint||null,endPoint:this.options.endPoint,avoidFeature:this.options.avoidFeature||null,graph:this.options.graph||null,expectedStartTime:this.options.expectedStartTime||null}};this.oRequest=new s.default(t),this.oFilter&&this.oRequest.addFilter(this.oFilter)}}if(!this.oRequest)throw new Error("Type de requête indefini !");return this.strRequest=this.oRequest.toString(),this.strRequest},e.default=l},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(124);function s(t){if(this.logger=o.default.getLogger(),this.logger.trace("[Constructeur DetermineRouteRequest ()]"),!(this instanceof s))throw new TypeError("DetermineRouteRequest constructor cannot be called as a function.");for(var e in this.options=t||{},t)t.hasOwnProperty(e)&&(this.options[e]=t[e]);this.CLASSNAME="DetermineRouteRequest"}s.prototype={strRequest:null,oRoutePlan:null,template:{determineRouteRequest:'<DetermineRouteRequest distanceUnit="__DISTANCEUNIT__">__ROUTEPLAN____ROUTEINSTRUCTIONREQUEST____ROUTEGEOMETRYREQUEST____ROUTEMAPREQUEST__</DetermineRouteRequest>',routeInstructionRequest:'<RouteInstructionsRequest provideGeometry="__PROVIDEGEOMETRY__" provideBoundingBox="__PROVIDEBBOX__" />',routeGeometryRequest:"<RouteGeometryRequest />",routeMapRequest:""},addRoute:function(t){t instanceof n.default&&(this.oRoutePlan=t)},constructor:s,toString:function(){var t="";if(t=(t=this.template.determineRouteRequest).replace(/__DISTANCEUNIT__/g,this.options.distanceUnit||"KM"),!this.oRoutePlan){var e=this.options.route;if(this.oRoutePlan=new n.default(e),!this.oRoutePlan)throw new Error("La construction du calcul d'initineraire n'est pas correctement definie !?")}t=t.replace(/__ROUTEPLAN__/g,this.oRoutePlan.toString());var i=this.template.routeInstructionRequest;i=(i=i.replace(/__PROVIDEGEOMETRY__/g,this.options.provideGeometry||!1)).replace(/__PROVIDEBBOX__/g,this.options.provideBoundingBox||!1),t=t.replace(/__ROUTEINSTRUCTIONREQUEST__/g,i);var o=this.template.routeGeometryRequest;t=t.replace(/__ROUTEGEOMETRYREQUEST__/g,o);var s=this.template.routeMapRequest;return t=t.replace(/__ROUTEMAPREQUEST__/g,s),this.strRequest=t,this.strRequest}},e.default=s},function(t,e,i){"use strict";i.r(e);var o=i(43);function n(t){if(this.logger=o.default.getLogger("RoutePlan"),this.logger.trace("[Constructeur RoutePlan ()]"),!(this instanceof n))throw new TypeError("RoutePlan constructor cannot be called as a function.");if(this.options=t||{},!t.startPoint)throw new Error("l'option 'startPoint' n'est pas renseignée !");if(!t.endPoint)throw new Error("l'option 'endPoint' n'est pas renseignée !");for(var e in t)t.hasOwnProperty(e)&&(this.options[e]=t[e])}n.prototype={constructor:n,requestString:null,template:{routePlan:"<RoutePlan>__ROUTEPREFERENCE____GRAPH____WAYPOINTLIST____AVOIDLIST__</RoutePlan>",routePreference:"<RoutePreference>__VALUEROUTEPREFERENCE__</RoutePreference>",graph:'<xlsext:graphName xmlns:xlsext="http://www.opengis.net/xlsext" name="__VALUEGRAPH__"/>',wayPointList:{container:"<WayPointList>__STARTPOINT____VIAPOINT____ENDPOINT__</WayPointList>",point:'<Position><gml:Point xmlns:gml="http://www.opengis.net/gml"><gml:pos>__X__ __Y__</gml:pos></gml:Point></Position>',startPoint:"<StartPoint>__POINT__</StartPoint>",endPoint:"<EndPoint>__POINT__</EndPoint>",viaPoint:"<ViaPoint>__POINT__</ViaPoint>"},avoidList:{container:"<AvoidList>__AVOIDFEATURE__</AvoidList>",avoidFeature:"<AvoidFeature>__VALUEAVOIDFEATURE__</AvoidFeature>"}},toString:function(){var t="";if(t=this.template.routePlan,this.options.routePreference){var e=this.template.routePreference;e=e.replace(/__VALUEROUTEPREFERENCE__/,this.options.routePreference),t=t.replace(/__ROUTEPREFERENCE__/g,e)}if(t=t.replace(/__ROUTEPREFERENCE__/g,""),this.options.avoidFeature){for(var i=this.template.avoidList.container,o=[],n=0;n<this.options.avoidFeature.length;n++){var s=this.template.avoidList.avoidFeature;s=s.replace(/__VALUEAVOIDFEATURE__/,this.options.avoidFeature[n]),o.push(s)}i=i.replace(/__AVOIDFEATURE__/,o.join("\n")),t=t.replace(/__AVOIDLIST__/g,i)}if(t=t.replace(/__AVOIDLIST__/g,""),this.options.graph){var a=this.template.graph;a=a.replace(/__VALUEGRAPH__/,this.options.graph),t=t.replace(/__GRAPH__/g,a)}t=t.replace(/__GRAPH__/g,"");var r=this.template.wayPointList.container,l="";if(l=(l=(l=this.template.wayPointList.point).replace(/__X__/,this.options.startPoint.x)).replace(/__Y__/,this.options.startPoint.y),r=r.replace(/__STARTPOINT__/,this.template.wayPointList.startPoint.replace(/__POINT__/,l)),l=(l=(l=this.template.wayPointList.point).replace(/__X__/,this.options.endPoint.x)).replace(/__Y__/,this.options.endPoint.y),r=r.replace(/__ENDPOINT__/,this.template.wayPointList.endPoint.replace(/__POINT__/,l)),this.options.viaPoint){for(var c=[],u=0;u<this.options.viaPoint.length;u++){var h=this.options.viaPoint[u];l=(l=(l=this.template.wayPointList.point).replace(/__X__/,h.x)).replace(/__Y__/,h.y),c.push(l)}r=r.replace(/__VIAPOINT__/,this.template.wayPointList.viaPoint.replace(/__POINT__/,c.join("\n")))}else r=r.replace(/__VIAPOINT__/,"");return t=t.replace(/__WAYPOINTLIST__/g,r),this.requestString=t,this.requestString}},e.default=n},function(t,e){},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(44),s=i(127);function a(t){if(this.logger=o.default.getLogger("RouteRequestREST"),this.logger.trace("[Constructeur RouteRequestREST ()]"),!(this instanceof a))throw new TypeError("RouteRequestREST constructor cannot be called as a function.");if(!t)throw new Error(n.default.getMessage("PARAM_EMPTY","options"));this.settings=t}a.prototype={requestString:null,constructor:a,processRequestString:function(){this.logger.warn(" PROTOTYPE !");for(var t=new s.default(this.settings).getParams(),e="",i=0;i<t.length;i++){var o=t[i];e&&(e+="&"),e+=o.k+"="+o.v}return this.logger.trace(e),this.requestString=e,this.requestString}},e.default=a},function(t,e,i){"use strict";i.r(e);var o=i(43);function n(t){if(!(this instanceof n))throw new TypeError("RouteParamREST constructor cannot be called as a function.");if(this.logger=o.default.getLogger(),this.logger.trace("[Constructeur RouteParamREST ()]"),this.options=t||{},this.origin=this.options.startPoint.x+","+this.options.startPoint.y,this.destination=this.options.endPoint.x+","+this.options.endPoint.y,this.waypoints=this.options.viaPoints||null,this.startDateTime=this.options.expectedStartTime||null,this.graphName=this.options.graph,this.srs=this.options.srs,this.exclusions=this.options.exclusions,this.method="TIME",this.options.routePreference)switch(this.options.routePreference){case"fastest":this.method="TIME";break;case"shortest":this.method="DISTANCE";break;default:this.logger.warn("Par defaut, on prend l'itinéraire le plus rapide !"),this.method="TIME"}this.format=this.options.geometryInInstructions?"STANDARDEXT":"STANDARD",this.tolerance=10,this.profileId=null,this.profileName=null}n.CLASSNAME="RouteParamREST",n.prototype={constructor:n,getWaypoints:function(){if(this.waypoints){for(var t=[],e=0;e<this.waypoints.length;e++){var i=this.waypoints[e];t.push(i.x+","+i.y)}return t.join(";")}},getExclusions:function(){return this.exclusions.join(";")}},n.prototype.getParams=function(){var t=[];return t.push({k:"origin",v:this.origin}),t.push({k:"destination",v:this.destination}),t.push({k:"method",v:this.method}),this.waypoints&&t.push({k:"waypoints",v:this.getWaypoints()}),this.startDateTime&&t.push({k:"startDateTime",v:this.startDateTime}),this.graphName&&t.push({k:"graphName",v:this.graphName}),this.exclusions&&t.push({k:"exclusions",v:this.getExclusions()}),this.srs&&t.push({k:"srs",v:this.srs}),this.format&&t.push({k:"format",v:this.format}),t},e.default=n},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(44),s=i(45),a=i(66),r=i(129),l=i(130),c=i(133),u=i(131),h=i(132),d={build:function(t){var e=o.default.getLogger("RouteResponseFactory");e.trace("RouteResponseFactory::build()");var i=null;if(t.response){if(t.rawResponse)e.trace("analyze response : raw"),i=t.response;else{switch(t.outputFormat){case"xml":e.trace("analyze response : xml");var d="REST"===t.api?l.default:c.default;try{var p=new a.default({reader:d});if("string"==typeof t.response?p.setXMLString(t.response):p.setXMLDoc(t.response),!(i=p.parse()))throw new s.default(n.default.getMessage("SERVICE_RESPONSE_FORMAT","xml"))}catch(e){return void t.onError.call(t.scope,new s.default(n.default.getMessage("SERVICE_RESPONSE_ANALYSE",t.response)))}break;case"json":var m;if(e.trace("analyze response : json"),(m="string"==typeof t.response?JSON.parse(t.response):t.response).message)return void t.onError.call(t.scope,new s.default(n.default.getMessage("SERVICE_RESPONSE_EXCEPTION",m.message)));if(m){var f=[],_=[],g=[];if((i=new u.default).hasOwnProperty("totalTime")&&(i.totalTime=parseFloat(m.durationSeconds)),i.hasOwnProperty("totalDistance")&&(i.totalDistance="m"===t.distanceUnit?m.distanceMeters:m.distance),i.hasOwnProperty("bbox")){var v=m.bounds.split(/[,;]/);i.bbox.left=parseFloat(v[0]),i.bbox.bottom=parseFloat(v[1]),i.bbox.right=parseFloat(v[2]),i.bbox.top=parseFloat(v[3])}if(i.hasOwnProperty("routeGeometry")){var y=m.geometryWkt||m.simplifiedWkt;if(y&&(r.default.toJson(y,(function(t){i.routeGeometry=t}),(function(e){console.log(e),t.onError.call(t.scope,new s.default(n.default.getMessage("PARAM_FORMAT",["geometryWkt"])))})),!i.routeGeometry))return}if(i.hasOwnProperty("routeInstructions")){var E,P=m.legs;if(Array.isArray(P)&&P.length)for(E=0;E<P.length;E++)f.push(P[E]);if(Array.isArray(f)&&f.length)for(E=0;E<f.length;E++)_.push(f[E].steps);if(Array.isArray(_)&&_.length)for(E=0;E<_.length;E++)g=g.concat(_[E]);g.forEach((function(e){i.routeInstructions.push(new h.default),i.routeInstructions[i.routeInstructions.length-1].duration=e.durationSeconds,i.routeInstructions[i.routeInstructions.length-1].distance="m"===t.distanceUnit?e.distanceMeters:e.distance,i.routeInstructions[i.routeInstructions.length-1].code=e.navInstruction;for(var o=[],n=0;n<e.points.length;n++){var s=e.points[n].split(",");s&&o.push(s)}switch(o&&0!==o.length?i.routeInstructions[i.routeInstructions.length-1].geometry={coordinates:o,type:"LineString"}:i.routeInstructions[i.routeInstructions.length-1].geometry=null,"Valeur non renseignée"===e.name&&(e.name=""),e.navInstruction){case"F":e.name?i.routeInstructions[i.routeInstructions.length-1].instruction="Tout droit "+e.name:i.routeInstructions[i.routeInstructions.length-1].instruction="Continuer tout droit ";break;case"B":i.routeInstructions[i.routeInstructions.length-1].instruction="Demi-tour "+e.name;break;case"L":i.routeInstructions[i.routeInstructions.length-1].instruction="Tourner à gauche "+e.name;break;case"R":i.routeInstructions[i.routeInstructions.length-1].instruction="Tourner à droite "+e.name;break;case"BL":i.routeInstructions[i.routeInstructions.length-1].instruction="Tourner très à gauche "+e.name;break;case"BR":i.routeInstructions[i.routeInstructions.length-1].instruction="Tourner très à droite "+e.name;break;case"FL":i.routeInstructions[i.routeInstructions.length-1].instruction="Tourner légèrement à gauche "+e.name;break;case"FR":i.routeInstructions[i.routeInstructions.length-1].instruction="Tourner légèrement à droite "+e.name;break;case"round_about_entry":i.routeInstructions[i.routeInstructions.length-1].instruction="Entrée rond-point "+e.name;break;case"round_about_exit":i.routeInstructions[i.routeInstructions.length-1].instruction="Sortie rond-point "+e.name;break;case null:i.routeInstructions[i.routeInstructions.length-1].instruction="Prendre tout droit "+e.name;break;default:i.routeInstructions[i.routeInstructions.length-1].instruction="?"+e.navInstruction+"? "+e.name}}))}}if(!i)return void t.onError.call(t.scope,new s.default(n.default.getMessage("SERVICE_RESPONSE_ANALYSE","json")));break;default:return void t.onError.call(t.scope,new s.default(n.default.getMessage("SERVICE_RESPONSE_FORMAT","json","xml")))}if(i&&i.exceptionReport)return void t.onError.call(t.scope,new s.default(n.default.getMessage("SERVICE_RESPONSE_EXCEPTION_2")))}t.onSuccess.call(t.scope,i)}else t.onError.call(t.scope,new s.default(n.default.getMessage("SERVICE_RESPONSE_EMPTY")))}};e.default=d},function(t,e,i){"use strict";i.r(e);var o=i(43),n={toJson:function(t,e,i){var n=o.default.getLogger(),s=null;try{if(!t)throw new Error("La chaine WKT n'est pas renseignée !");var a,r;if(e||(e=function(t){console.log(t)}),i||(i=function(t){console.log(t)}),a=/(-?\d+\.?[0-9]*)\s(-?\d+\.?[0-9]+)/g,r="[$1,$2]",t=t.replace(a,r),(a=/^(\w+)/).exec(t),"POLYGON"===RegExp.$1?(r='{"type" : "Polygon",',t=t.replace(RegExp.$1,r),a=/(\({2}?)/,r='"coordinates" : [[',t=t.replace(a,r),a=/(\){2}?)/,r="]]}",t=t.replace(a,r),a=/(\()/g,r="[",t=t.replace(a,r),a=/(\))/g,r="]",t=t.replace(a,r)):"LINESTRING"===RegExp.$1&&(r='{"type" : "LineString",',t=t.replace(RegExp.$1,r),a=/(\(\(?)/,r='"coordinates" : [',t=t.replace(a,r),a=/(\)\)?)/,r="]}",t=t.replace(a,r)),n.trace(t),!(s=JSON.parse(t)))throw new Error("Le JSON est vide !");if(!s.type)throw new Error("Le type de geometrie n'est pas connu !");if(!s.coordinates)throw new Error("La liste des points est vide !");e.call(this,s)}catch(t){if("SyntaxError"===t.name)return void i.call(this,"Erreur de parsing JSON !");i.call(this,t)}}};e.default=n},function(t,e,i){"use strict";i.r(e);var o=i(44),n=i(129),s=i(45),a=i(131),r=i(132),l={};function c(t){var e,i="";return t.hasChildNodes()&&(e=t.firstChild)&&3===e.nodeType&&(i=e.nodeValue),i}l.READERS={routeResult:function(t){var e=new a.default;if(function t(e,i){if(e.hasChildNodes())for(var o,n,s=e.childNodes,a=0;a<s.length;a++){if(1===(o=s[a]).nodeType)if(n=o.localName||o.baseName||o.nodeName,l.READERS[n])(0,l.READERS[n])(o,i);else t(o,i)}}(t,e),"error"===e.status){var i=o.default.getMessage("SERVICE_RESPONSE_EXCEPTION",e.message);throw new s.default({message:i,type:s.default.TYPE_SRVERR})}return e},status:function(t,e){var i=c(t);"ERROR"!==i&&"error"!==i||e&&(e.status="error")},message:function(t,e){e&&(e.message=c(t))},distance:function(t,e){e&&(e.totalDistance=c(t))},durationSeconds:function(t,e){e&&(e.totalTime=parseFloat(c(t)))},bounds:function(t,e){if(e&&e.bbox){var i=c(t).split(/[,;]/);e.bbox.left=parseFloat(i[0]),e.bbox.bottom=parseFloat(i[1]),e.bbox.right=parseFloat(i[2]),e.bbox.top=parseFloat(i[3])}},geometryWkt:function(t,e){if(e){var i=t.innerHTML;n.default.toJson(i,(function(t){e.routeGeometry=t}),(function(){var t=o.default.getMessage("PARAM_FORMAT",["geometryWkt"]);throw new Error(t)}))}},step:function(t,e){var i,o=new r.default;if(t.hasChildNodes)for(var n,s,a=t.childNodes,l=0;l<a.length;l++)1===(n=a[l]).nodeType&&("durationSeconds"===(s=n.localName||n.baseName||n.nodeName)?o.duration=c(n):"distance"===s?o.distance=c(n):"navInstruction"===s?o.code=c(n):"name"===s&&(i=c(n)));if(o.code)switch(o.code){case"F":o.instruction="Valeur non renseignée"!==i?"Tout droit "+i:"Continuer tout droit ";break;case"B":o.instruction="Demi-tour "+i;break;case"L":o.instruction="Tourner à gauche "+i;break;case"R":o.instruction="Tourner à droite "+i;break;case"BL":o.instruction="Tourner très à gauche "+i;break;case"BR":o.instruction="Tourner très à droite "+i;break;case"FL":o.instruction="Tourner légèrement à gauche "+i;break;case"FR":o.instruction="Tourner légèrement à droite "+i;break;case"round_about_entry":o.instruction="Entrée rond-point "+i;break;case"round_about_exit":o.instruction="Sortie rond-point "+i;break;case null:o.instruction="Prendre "+i;break;default:o.instruction="?"+o.code+"? "+i}Array.isArray(e.routeInstructions)&&e.routeInstructions.push(o)}},l.read=function(t){if("routeResult"===t.nodeName)return l.READERS.routeResult(t);throw new Error("Erreur lors de la lecture de la réponse : elle n'est pas au format attendu.")},e.default=l},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("RouteResponse constructor cannot be called as a function.");this.totalTime=null,this.totalDistance=null,this.bbox={left:null,right:null,top:null,bottom:null},this.routeGeometry=null,this.routeInstructions=[]}i.r(e),o.prototype={constructor:o},e.default=o},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("RouteInstruction constructor cannot be called as a function.");this.duration=null,this.distance=null,this.code=null,this.instruction=null,this.geometry=null}i.r(e),o.prototype={constructor:o},e.default=o},function(t,e,i){"use strict";i.r(e);var o=i(43),n={READERS:{},read:function(t){o.default.getLogger("RouteResponseOLSReader").error("not yet implemented !")}};e.default=n},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(44),s=i(45),a=i(46),r=i(56),l=i(135),c=i(137);function u(t){if(!(this instanceof u))throw new TypeError(n.default.getMessage("CLASS_CONSTRUCTOR","ProcessIsoCurve"));if(this.CLASSNAME="ProcessIsoCurve",a.default.apply(this,arguments),this.logger=o.default.getLogger("Gp.Services.ProcessIsoCurve"),this.logger.trace("[Constructeur ProcessIsoCurve (options)]"),!t.position)throw new Error(n.default.getMessage("PARAM_MISSING","position"));if(null===t.position.x)throw new Error(n.default.getMessage("PARAM_MISSING","position.x"));if(null===t.position.y)throw new Error(n.default.getMessage("PARAM_MISSING","position.y"));if(!t.time&&!t.distance)throw new Error("Parameter (s) 'distance' missing. Parameter time to calculate an isochrone, parameter distance for an isodistance");if(!t.time&&t.distance&&(this.options.method="distance",this.options.time&&delete this.options.time),t.time&&!t.distance&&(this.options.method="time",this.options.distance&&delete this.options.distance),this.options.method=this.options.method||"time",this.options.exclusions=t.exclusions||null,this.options.graph=t.graph||"Voiture",this.options.reverse=t.reverse||!1,this.options.smoothing=t.smoothing||!1,this.options.holes=t.holes||!1,this.options.srs=t.srs||"EPSG:4326",this.options.outputFormat="string"==typeof t.outputFormat?t.outputFormat.toLowerCase():"json",!this.options.serverUrl){var e=r.default.ProcessIsoCurve.url(this.options.apiKey)["iso-"+this.options.outputFormat];if(!e)throw new Error("Url by default not found !");this.options.serverUrl=e,this.logger.trace("Serveur URL par defaut : "+this.options.serverUrl)}var i=this.options.serverUrl.lastIndexOf(".");if(-1!==i){var s=this.options.serverUrl.substring(i+1);if(s&&s.length<5)switch(this.logger.trace("Serveur Extension URL : "+s),s.toLowerCase()){case"json":case"xml":this.options.outputFormat=s.toLowerCase();break;default:throw new Error("type of service : unknown or unsupported (json or xml) !")}}}u.prototype=Object.create(a.default.prototype,{}),u.prototype.constructor=u,u.prototype.buildRequest=function(t,e){try{var i=new l.default(this.options);if(!i.processRequestString())throw new Error(n.default.getMessage("SERVICE_REQUEST_BUILD"));this.request=i.requestString}catch(e){return void t.call(this,new s.default(e.message))}e.call(this,this.request)},u.prototype.analyzeResponse=function(t,e){if(this.response){var i={response:this.response,outputFormat:this.options.outputFormat,rawResponse:this.options.rawResponse,onSuccess:e,onError:t,scope:this};c.default.build(i)}else t.call(this,new s.default(n.default.getMessage("SERVICE_RESPONSE_EMPTY")))},e.default=u},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(44),s=i(136);function a(t){if(this.logger=o.default.getLogger("ProcessIsoCurveRequest"),this.logger.trace("[Constructeur ProcessIsoCurveRequest ()]"),!(this instanceof a))throw new TypeError("ProcessIsoCurveRequest constructor cannot be called as a function.");if(!t)throw new Error(n.default.getMessage("PARAM_EMPTY","options"));this.settings=t,this.mode=this.settings.httpMethod||"GET"}a.prototype={requestString:null,constructor:a,template:{container:'<?xml version="1.0" encoding="UTF-8"?>\n<isochroneRequest>\n__ID__\t<location>\n\t\t<x>__X__</x>\n\t\t<y>__Y__</y>\n\t</location>\n\t<srs>__SRS__</srs>\n\t<graphName>__GRAPHNAME__</graphName>\n__PROFIL____EXCLUSIONS__\t<method>__METHOD__</method>\n__TIME____DISTANCE__\t<reverse>__REVERSE__</reverse>\n\t<smoothing>__SMOOTHING__</smoothing>\n\t<holes>__HOLES__</holes>\n</isochroneRequest>',id:"\t<id>__IDVALUE__</id>\n",profil:"\t<profileId>__PROFILID__</profileId>\n\t<profileName>__PROFILNAME__</profileName>\n",exclusions:{container:"\t<exclusions>\n__EXCLUSIONFEATURE__\n\t</exclusions>\n",feature:"\t\t<exclusion>__EXCLUSIONVALUE__</exclusion>"},time:"\t<time>__TIMEVALUE__</time>\n",distance:"\t<distance>__DISTANCEVALUE__</distance>\n"},processRequestString:function(){var t="",e=0;switch(this.mode){case"GET":this.logger.trace("Process GET Request");var i=new s.default(this.settings).getParams();for(e=0;e<i.length;e++){var o=i[e];t&&(t+="&"),t+=o.k+"="+o.v}break;case"POST":if(this.logger.trace("Process POST Request"),t=(t=(t=(t=(t=(t=(t=(t=(t=(t=this.template.container).replace(/__ID__/g,"")).replace(/__PROFIL__/g,"")).replace(/__X__/g,this.settings.position.x)).replace(/__Y__/g,this.settings.position.y)).replace(/__GRAPHNAME__/g,this.settings.graph)).replace(/__SRS__/g,this.settings.srs)).replace(/__SMOOTHING__/g,this.settings.smoothing)).replace(/__HOLES__/g,this.settings.holes)).replace(/__REVERSE__/g,this.settings.reverse),this.settings.exclusions){var n=this.template.exclusions.container,a=[];for(e=0;e<this.settings.exclusions.length;e++){var r=this.template.exclusions.feature;r=r.replace(/__EXCLUSIONVALUE__/,this.settings.exclusions[e]),a.push(r)}n=n.replace(/__EXCLUSIONFEATURE__/,a.join("\n")),t=t.replace(/__EXCLUSIONS__/g,n)}if(t=t.replace(/__EXCLUSIONS__/g,""),this.settings.distance){var l=this.template.distance;l=l.replace(/__DISTANCEVALUE__/g,this.settings.distance),t=(t=t.replace(/__DISTANCE__/g,l)).replace(/__METHOD__/g,"distance")}if(t=t.replace(/__DISTANCE__/g,""),this.settings.time){var c=this.template.time;c=c.replace(/__TIMEVALUE__/g,this.settings.time),t=(t=t.replace(/__TIME__/g,c)).replace(/__METHOD__/g,"time")}t=t.replace(/__TIME__/g,"");break;default:this.logger.error("No other HTTP method supported by the service !")}return this.logger.trace(t),this.requestString=t,this.requestString}},e.default=a},function(t,e,i){"use strict";i.r(e);var o=i(43);function n(t){if(!(this instanceof n))throw new TypeError("ProcessIsoCurveParam constructor cannot be called as a function.");switch(this.logger=o.default.getLogger(),this.logger.trace("[Constructeur ProcessIsoCurveParam ()]"),this.options=t||{},this.id=this.options.id,this.location=this.options.position,this.srs=this.options.srs,this.graphName=this.options.graph,this.profileId=this.options.profileId||null,this.profileName=this.options.profileName||null,this.exclusions=this.options.exclusions,this.reverse=this.options.reverse,this.smoothing=this.options.smoothing,this.holes=this.options.holes,this.options.method){case"time":this.method="time",this.time=this.options.time;break;case"distance":this.method="distance",this.distance=this.options.distance;break;default:this.logger.warn("Par defaut, on calcule un isochrone !"),this.method="time"}}n.CLASSNAME="ProcessIsoCurveParam",n.prototype={constructor:n,getLocation:function(){return this.location.x+","+this.location.y},getExclusions:function(){return this.exclusions.join(";")}},n.prototype.getParams=function(){var t=[];return t.push({k:"location",v:this.getLocation()}),t.push({k:"smoothing",v:this.smoothing}),t.push({k:"holes",v:this.holes}),t.push({k:"reverse",v:this.reverse}),t.push({k:"method",v:this.method}),this.time&&t.push({k:"time",v:this.time}),this.distance&&t.push({k:"distance",v:this.distance}),t.push({k:"graphName",v:this.graphName}),this.exclusions&&t.push({k:"exclusions",v:this.getExclusions()}),this.srs&&t.push({k:"srs",v:this.srs}),t},e.default=n},function(t,e,i){"use strict";i.r(e);var o=i(43),n=i(44),s=i(45),a=i(66),r=i(129),l=i(138),c=i(139),u={build:function(t){var e=o.default.getLogger("ProcessIsoCurveResponseFactory");e.trace(["ProcessIsoCurveResponseFactory::build()"]);var i=null;if(t.response){if(t.rawResponse)e.trace("analyze response : raw"),i=t.response;else{switch(t.outputFormat){case"xml":e.trace("analyze response : xml");try{var u=new a.default({reader:l.default});if("string"==typeof t.response?u.setXMLString(t.response):u.setXMLDoc(t.response),!(i=u.parse()))throw new Error(n.default.getMessage("SERVICE_RESPONSE_EXCEPTION_2"))}catch(e){var h=e.message;return h+="\n (raw response service : '"+t.response+"')",void t.onError.call(t.scope,new s.default({message:n.default.getMessage("SERVICE_RESPONSE_EXCEPTION",h),status:200,type:s.default.TYPE_SRVERR}))}break;case"json":var d;if(e.trace("analyze response : json"),"OK"===(d="string"==typeof t.response?JSON.parse(t.response):t.response).status||"ok"===d.status){if(!(i=new c.default))return void t.onError.call(t.scope,new s.default(n.default.getMessage("SERVICE_RESPONSE_ANALYSE",t.response)));i.time=d.time,i.distance=d.distance,i.message=d.message,i.id=d.id,i.srs=d.srs;if(i.hasOwnProperty("geometry")&&(r.default.toJson(d.wktGeometry,(function(t){i.geometry=t}),(function(){t.onError.call(t.scope,new s.default({message:n.default.getMessage("PARAM_FORMAT","wktGeometry")}))})),!i.geometry))return;var p=d.location.split(",");i.location&&(i.location.x=p[0],i.location.y=p[1])}else if("ERROR"===d.status||"error"===d.status){var m=d.message;return m+="\n (raw response service : '"+d+"')",void t.onError.call(t.scope,new s.default(n.default.getMessage("SERVICE_RESPONSE_EXCEPTION",m)))}break;default:return void t.onError.call(t.scope,new s.default(n.default.getMessage("SERVICE_RESPONSE_FORMAT","json","xml")))}if(i&&i.exceptionReport)return void t.onError.call(t.scope,new s.default({message:n.default.getMessage("SERVICE_RESPONSE_EXCEPTION",i.exceptionReport),type:s.default.TYPE_SRVERR,status:200}))}t.onSuccess.call(t.scope,i)}else t.onError.call(t.scope,new s.default(n.default.getMessage("SERVICE_RESPONSE_EMPTY")))}};e.default=u},function(t,e,i){"use strict";i.r(e);var o=i(44),n=i(129),s=i(45),a=i(139),r={};function l(t){var e,i="";return t.hasChildNodes()&&(e=t.firstChild)&&3===e.nodeType&&(i=e.nodeValue),i}r.READERS={isochronResult:function(t){var e=new a.default;if(t.hasChildNodes())for(var i,n=t.childNodes,l=0;l<n.length;l++)i=n[l],r.READERS[i.nodeName]&&r.READERS[i.nodeName](i,e);if("error"===e.status){var c=o.default.getMessage("SERVICE_RESPONSE_EXCEPTION",e.message);throw new s.default({message:c,type:s.default.TYPE_SRVERR})}return e},message:function(t,e){e&&(e.message=l(t))},status:function(t,e){var i=l(t);"ERROR"!==i&&"error"!==i||e&&(e.status="error")},id:function(t,e){e&&(e.id=l(t))},location:function(t,e){var i=l(t);e&&e.location&&(e.location.x=parseFloat(i.split(",")[0]),e.location.y=parseFloat(i.split(",")[1]))},srs:function(t,e){e&&(e.srs=l(t))},distance:function(t,e){e&&(e.distance=parseFloat(l(t)))},time:function(t,e){e&&(e.time=parseFloat(l(t)))},wktGeometry:function(t,e){if(e){var i=t.innerHTML;e.hasOwnProperty("geometry")&&n.default.toJson(i,(function(t){e.geometry=t}),(function(){var t=o.default.getMessage("PARAM_FORMAT",["wktGeometry"]);throw new Error(t)}))}},serviceResult:function(t){var e={};if(t.hasChildNodes())for(var i,o=t.childNodes,n=0;n<o.length;n++)i=o[n],r.READERS[i.nodeName]&&r.READERS[i.nodeName](i,e);return e},ExceptionReport:function(t){var e={};if(t.hasChildNodes())for(var i,o=t.childNodes,n=0;n<o.length;n++)"Exception"===(i=o[n]).nodeName&&(e.exceptionReport=r.READERS.Exception(i));return e},Exception:function(t){var e={},i=t.getAttribute("exceptionCode");i&&(e.exceptionCode=i);var o=t.firstChild;return o&&3===o.nodeType&&(e.exception=o.nodeValue),e}},r.read=function(t){var e;if("isochronResult"===t.nodeName||"isochroneResult"===t.nodeName||"IsochroneResult"===t.nodeName)return e=r.READERS.isochronResult(t);if("ExceptionReport"===t.nodeName)return e=r.READERS[t.nodeName](t);if(r.READERS[t.nodeName]){if("error"===(e=r.READERS[t.nodeName](t)).status){var i=o.default.getMessage("SERVICE_RESPONSE_EXCEPTION",e.message);throw new s.default({message:i,type:s.default.TYPE_SRVERR})}return e}throw new s.default({message:o.default.getMessage("SERVICE_RESPONSE_ANALYSE",t.nodeName),type:s.default.TYPE_UNKERR})},e.default=r},function(t,e,i){"use strict";function o(){if(!(this instanceof o))throw new TypeError("ProcessIsoCurveResponse constructor cannot be called as a function.");this.message=null,this.id=null,this.location={},this.location.x=null,this.location.y=null,this.srs=null,this.geometry=null,this.time=null,this.distance=null}i.r(e),o.prototype={constructor:o},e.default=o},function(t,e,i){"use strict";i.r(e);var o=i(34),n=i(141);e.default={check:function(t){var e=o.default.getLogger("checkrightmanagement");if(t){var i=t.key,s=t.resources||[],a=t.services||[];if(s&&0!==s.length)if(a&&0!==a.length){var r={};if(!i){if(!n.default.isConfigLoaded())return void e.warn("WARNING : The 'apiKey' parameter is missing, and the contract key configuration has not been loaded, so impossible to check yours rights !");i=Object.keys(n.default.configuration.generalOptions.apiKeys)[0],e.log(i)}if(i){if(n.default.isConfigLoaded()){for(var l=0;l<s.length;l++)for(var c=s[l],u=0;u<a.length;u++){var h=a[u],d=n.default.getServiceParams(c,h,i);d&&0!==Object.keys(d).length?(r[h]||(r[h]=[]),r[h].push(c)):e.warn("WARNING : The contract key configuration has no rights to load this geoportal resource ("+c+") for this service ("+h+") ")}return r&&0!==Object.keys(r).length?(r.key=i,e.log("right management checked",r),r):void e.warn("WARNING : The contract key configuration has been loaded, and the 'apiKey' parameter has been set, but, there is a problem on the mapping between the contract and the key !")}e.warn("WARNING : the contract key configuration has not been loaded, so be carefull !");for(var p={},m=0;m<a.length;m++){var f=a[m];p[f]=[];for(var _=0;_<s.length;_++){var g=s[_];p[f].push(g)}}return p.key=i,e.log("right management not checked",p),p}}else e.error("WARNING : no parameter 'services' specified !");else e.error("WARNING : no parameter 'resources' specified !")}else e.error("WARNING : no parameter specified !")}}},function(t,e,i){"use strict";i.r(e),function(t){var o=i(34).default.getLogger("config"),n={configuration:null,isConfigLoaded:function(){var e="undefined"!=typeof window?window:"undefined"!=typeof self?self:void 0!==t?t:{};return!(!e.Gp||!e.Gp.Config||0===Object.keys(e.Gp.Config).length)&&(this.configuration=e.Gp.Config,!0)},getLayerId:function(t,e){var i=null;if(this.configuration){var n=this.configuration.layers;for(var s in n)if(n.hasOwnProperty(s)){var a=s.split("$");if(t===a[0]&&a[1]){var r=a[1].split(":");if(a[1].split(";")[1]===e){i=s;break}if(r[2]===e){i=s;break}}}}return i||o.error("ERROR layer id (layer name: "+t+" / service: "+e+") was not found !?"),i},getLayerParams:function(t,e,i){var n={};if(this.configuration){var s=this.getLayerId(t,e);if(s){var a=this.configuration.layers[s],r=a.apiKeys[0];if(i&&i!==r)return void o.error("ERROR different keys ("+i+" !== "+r+") !?");i=i||r,n.key=i,n.url=a.getServerUrl(i),n.version=a.getServiceParams().version,n.styles=a.getDefaultStyle(),n.format=a.getDefaultFormat(),n.projection=a.getDefaultProjection(),n.minScale=a.getMinScaleDenominator(),n.maxScale=a.getMaxScaleDenominator(),n.extent=a.getBBOX(),n.legends=a.getLegends(),n.metadata=a.getMetadata(),n.originators=a.getOriginators(),n.title=a.getTitle(),n.description=a.getDescription(),n.quicklookUrl=a.getQuicklookUrl(),a.wmtsOptions&&(n.tileMatrixSetLimits=a.wmtsOptions.tileMatrixSetLimits);var l=a.getTMSID();if(l){n.TMSLink=l;var c=this.configuration.getTMSConf(l);n.matrixOrigin=c.getTopLeftCorner(),n.nativeResolutions=c.nativeResolutions,n.matrixIds=c.matrixIds,n.tileMatrices=c.tileMatrices}}}return n},getServiceParams:function(t,e,i){var o={};if(this.configuration){var n=this.getLayerId(t,e);if(n){var s=this.configuration.layers[n],a=s.apiKeys[0];if(i&&i!==a)return;i=i||a,o.key=i,o.url=s.getServerUrl(i),o.version=s.getServiceParams().version,o.extent=s.getBBOX(),o.title=s.getTitle(),o.description=s.getDescription()}}return o},getResolutions:function(){var t=[];return this.configuration&&(t=this.configuration.generalOptions.wgs84Resolutions),t},getTileMatrix:function(t){var e={};return this.configuration&&t&&(e=this.configuration.tileMatrixSets[t.toUpperCase()]),e},getGlobalConstraints:function(t){var e={};if(t){var i=this.configuration.layers[t];e.projection=i.getDefaultProjection(),e.minScale=i.getMinScaleDenominator(),e.maxScale=i.getMaxScaleDenominator(),e.extent=i.getBBOX()}return e}};e.default=n}.call(this,i(52))},function(t,e,i){"use strict";i.r(e);var o=i(40),n=i(2),s=i.n(n),a=i(34),r=i(140),l=i(36),c=i(143),u=i(144),h=i(145),d=a.default.getLogger("locationselector"),p=s.a.Control.extend({includes:c.default,options:{position:"topleft",tag:{id:0,unique:null,label:">",color:"blue",display:!0,addOption:!1,removeOption:!1},disableReverse:!1,displayInfo:!0,autocompleteOptions:{},reverseGeocodeOptions:{}},initialize:function(t){s.a.Util.setOptions(this,t),this._uid=this.options.tag.unique||null,this._activeDragAndDrop=!1,this._pressedKeyOnDragAndDrop=!1,this._map=null,this._inputsContainer=null,this._inputLabelContainer=null,this._inputAutoCompleteContainer=null,this._inputShowPointerContainer=null,this._inputCoordinateContainer=null,this._coordinate=null,this._suggestedContainer=null,this._suggestedLocations=[],this._currentLocation=null,this._marker=null,this._resources={},this._noRightManagement=!1,this._checkRightsManagement(),this._container=this._uid?this._initLayout():null},onAdd:function(){this._uid=l.default.generate();var t=this._initLayout();return s.a.DomEvent.disableClickPropagation(t).disableScrollPropagation(t),t},onRemove:function(){},getCoordinate:function(){return this._coordinate},setCoordinate:function(t){this._displayResultOfCoordinate(t)},getCoordinateInverse:function(){if(this._coordinate)return{x:this._coordinate.y,y:this._coordinate.x}},setMap:function(t){this._map||(this._map=t)},clear:function(){this._setCursor(),this._setMarker(),this._clearResults(),this._inputLabelContainer.click()},dragging:function(t){this._marker&&(t?this._marker.dragging.enable():this._marker.dragging.disable())},_initLayout:function(){var t=this.options.tag.id,e=this._createMainContainerElement(),i=this._inputsContainer=this._createLocationPointElement(t,this.options.tag.display);e.appendChild(i);var o=this._inputLabelContainer=this._createLocationPointLabelElement(t,this.options.tag.label);i.appendChild(o);var n=this._inputAutoCompleteContainer=this._createLocationAutoCompleteteInputElement(t);i.appendChild(n);var s=this._inputCoordinateContainer=this._createLocationCoordinateInputElement(t);i.appendChild(s);var a=this._inputShowPointerContainer=this._createLocationPointerShowInputElement(t);i.appendChild(a);var r=this._createLocationPointerInputElement(t);if(i.appendChild(r),this.options.tag.addOption){var l=this._createLocationAddPointElement();i.appendChild(l)}if(this.options.tag.removeOption){var c=this._createLocationRemovePointElement(t);i.appendChild(c)}var u=this._suggestedContainer=this._createLocationAutoCompleteResultElement(t);return e.appendChild(u),e},_checkRightsManagement:function(){var t=null,e=[],i=null;i=this.options.reverseGeocodeOptions.apiKey,(e=(t=this.options.reverseGeocodeOptions.filterOptions)?t.type:[])&&0!==e.length||(e=["PositionOfInterest","StreetAddress"]);var o=r.default.check({key:i||this.options.apiKey,resources:e,services:["ReverseGeocode"]});i=this.options.autocompleteOptions.apiKey,(e=(t=this.options.autocompleteOptions.filterOptions)?t.type:[])&&0!==e.length||(e=["PositionOfInterest","StreetAddress"]);var n=r.default.check({key:i||this.options.apiKey,resources:e,services:["AutoCompletion"]});o||n||(this._noRightManagement=!0),n&&(this._resources.AutoCompletion={},this._resources.AutoCompletion.resources=n.AutoCompletion,this._resources.AutoCompletion.key=n.key),o&&(this._resources.ReverseGeocode={},this._resources.ReverseGeocode.resources=o.ReverseGeocode,this._resources.ReverseGeocode.key=o.key)},_setLabel:function(t){this._inputAutoCompleteContainer.value=t||""},_setCoordinate:function(t){this._coordinate={x:t.lng,y:t.lat};var e;e=u.default.roundToDecimal(t.lat,4);var i=u.default.roundToDecimal(t.lng,4)+" , "+e;this.GPdisplayCoordinate(i)},_setPosition:function(t){d.log("_setPosition()",t),this._map.panTo(s.a.latLng(t.y,t.x))},_setMarker:function(t,e,i){if(d.log("_setMarker()",t,e,i),!this._activeDragAndDrop){var o=this._map;if(null!=this._marker&&(this._marker.off("mousedown",this.onMouseDownMarker,this),this._marker.off("dragstart",this.onStartDragMarker,this),this._marker.off("drag",this.onDragMarker,this),this._marker.off("dragend",this.onEndDragMarker,this),o.removeLayer(this._marker),this._marker=null),t){var n={icon:new h.default(this.options.tag.color),draggable:!0,clickable:!0,zIndexOffset:1e3};if(this._marker=s.a.marker(s.a.latLng(t.y,t.x),n),this._marker.on("mousedown",this.onMouseDownMarker,this),this._marker.on("dragstart",this.onStartDragMarker,this),this._marker.on("drag",this.onDragMarker,this),this._marker.on("dragend",this.onEndDragMarker,this),this._marker.addTo(o),i){var a=null;if("string"!=typeof e)if(e.fields.fullText)a=e.fields.fullText;else{var r=[];r.push(e.fields.street||""),r.push(e.fields.postalCode||""),r.push(e.fields.commune||""),"PositionOfInterest"===e.type&&(r.push(e.fields.poi||""),r.push(e.fields.kind||"")),a=r.join(" - ")}else a=e;this._marker.bindPopup(a)}}}},_setCursor:function(t){var e=this._map.getContainer();e.style.cursor=t||null},_clearResults:function(){this._currentLocation=null,this._coordinate=null,this._clearSuggestedLocation()},_clearSuggestedLocation:function(){if(this._suggestedLocations=[],this._suggestedContainer)for(;this._suggestedContainer.firstChild;)this._suggestedContainer.removeChild(this._suggestedContainer.firstChild)},_requestAutoComplete:function(t){if(d.log("_requestAutoComplete()",t),t&&0!==Object.keys(t).length&&t.text)if(d.log(t),this._noRightManagement)d.log("no rights for all service !?");else if(this._resources.AutoCompletion){var e=this._resources.AutoCompletion.resources;if(e&&0!==Object.keys(e).length){var i=this._resources.AutoCompletion.key,n={};s.a.Util.extend(n,this.options.autocompleteOptions),s.a.Util.extend(n,t),s.a.Util.extend(n,{apiKey:n.apiKey||this.options.apiKey||i}),d.log(n),o.default.Services.autoComplete(n)}}else d.log("no rights for this service !?")},_fillAutoCompletedLocationListContainer:function(t){if(d.log("_fillAutoCompletedLocationListContainer()",t),t&&0!==t.length){var e=this._suggestedContainer;if(e.childElementCount)for(;e.firstChild;)e.removeChild(e.firstChild);for(var i=0;i<t.length;i++)this._createLocationAutoCompletedLocationElement(this.options.tag.id,t[i],i);this._suggestedLocations=t}},_requestReverseGeocode:function(t){if(d.log("_requestReverseGeocode()",t),t&&0!==Object.keys(t).length&&t.position&&0!==Object.keys(t.position).length)if(this._noRightManagement)d.log("no rights for all service !?");else if(this._resources.ReverseGeocode){var e=this._resources.ReverseGeocode.resources;if(e&&0!==Object.keys(e).length){var i=this._resources.ReverseGeocode.key,n={};s.a.Util.extend(n,this.options.reverseGeocodeOptions),s.a.Util.extend(n,t),s.a.Util.extend(n,{returnFreeForm:!0,filterOptions:{type:["StreetAddress"]}}),s.a.Util.extend(n,{apiKey:n.apiKey||this.options.apiKey||i}),d.log(n),o.default.Services.reverseGeocode(n)}}else d.log("no rights for this service !?")},_displayResultOfCoordinate:function(t){this._setCoordinate(t),this._setMarker({x:t.lng,y:t.lat},null,!1),d.log(this.getCoordinate()),this.onActivateMapPointClick()},_displayResultOfLabel:function(t){var e=t.placeAttributes,i=e.number+" "+e.street+", "+e.postalCode+" "+e.commune;this._setCoordinate({lat:t.position.x,lng:t.position.y}),this._setLabel(i),this._setMarker({x:t.position.y,y:t.position.x},null,!1),this._inputShowPointerContainer.checked=!1,this._inputAutoCompleteContainer.className="GPlocationOriginVisible",this._inputCoordinateContainer.className="GPlocationOriginHidden",this.onActivateMapPointClick()},onAutoCompleteSearchText:function(t){d.log("onAutoCompleteSearchText()",t);var e=t.target.value;if(e)if(this._noRightManagement)d.log("no rights for this service !?");else if(this._currentLocation=e,!(e.length<3)){var i=this;this._requestAutoComplete({text:e,maximumResponses:5,onSuccess:function(t){if(d.log(t),t){var e=t.suggestedLocations;i._fillAutoCompletedLocationListContainer(e)}},onFailure:function(t){i._clearSuggestedLocation(),d.log(t.message)}})}},onAutoCompletedResultsItemClick:function(t){d.log("onAutoCompletedResultsItemClick()",t);var e=l.default.index(t.target.id);if(d.log(e),d.log(this._suggestedLocations[e]),e){var i={x:this._suggestedLocations[e].position.x,y:this._suggestedLocations[e].position.y},o={type:this._suggestedLocations[e].type,fields:this._suggestedLocations[e]},n=this._suggestedLocations[e].fullText;this._setLabel(n),this._setPosition(i),this._setMarker(i,o,this.options.displayInfo),this._coordinate=i}},onActivateMapPointClick:function(t){d.trace("onActivateMapPointClick()",t);var e=this._map;this._inputShowPointerContainer.checked?this._activeDragAndDrop||(e.on("click",this.onMouseMapClick,this),this._setCursor("crosshair"),this._setMarker(),this._clearResults()):this._activeDragAndDrop||(e.off("click",this.onMouseMapClick,this),this._setCursor())},onLocationClearPointClick:function(t){d.log("onLocationClearPointClick",t),this._setCursor(),this._setMarker(),this._clearResults(),this._inputAutoCompleteContainer.focus()},onLocationRemovePointClick:function(t){d.log("onLocationRemovePointClick",t),this._setCursor(),this._setMarker(),this._clearResults()},onLocationAddPointClick:function(t){d.log("onLocationAddPointClick",t)},onMouseMapClick:function(t){d.log("onMouseMapClick",t);var e=t.latlng;if(this.options.disableReverse||this._noRightManagement)this._displayResultOfCoordinate(e);else{var i=this;this._requestReverseGeocode({position:{x:e.lat,y:e.lng},srs:"EPSG:4326",onSuccess:function(t){if(d.log(t),0!==t.locations.length){var o=t.locations[0];i._displayResultOfLabel(o)}else i._displayResultOfCoordinate(e)},onFailure:function(t){d.log(t.message),i._displayResultOfCoordinate(e)}})}},onStartDragMarker:function(){this._marker&&(this._activeDragAndDrop=!0,this._inputShowPointerContainer.checked=!0,this._inputAutoCompleteContainer.className="GPlocationOriginHidden",this._inputCoordinateContainer.className="GPlocationOriginVisible",this._marker.unbindPopup(),this._setLabel(),this._clearResults())},onDragMarker:function(){if(this._marker){this._activeDragAndDrop=!1,this._inputShowPointerContainer.checked=!0;var t=this._marker.getLatLng();this._setCoordinate(t)}},onEndDragMarker:function(){if(this._marker){this._inputShowPointerContainer.checked=!0;var t=this._marker.getLatLng();this._pressedKeyOnDragAndDrop?this._setCoordinate(t):(d.log("No key pressed, so autocomplete solution !"),this.onMouseMapClick({latlng:t})),this._activeDragAndDrop=!1,this._pressedKeyOnDragAndDrop=!1}},onMouseDownMarker:function(t){this._marker&&(this._pressedKeyOnDragAndDrop=t.originalEvent.ctrlKey)}});e.default=p},function(t,e,i){"use strict";i.r(e);var o=i(36),n=i(34).default.getLogger("LocationSelectorDOM"),s={_addUID:function(t){return this._uid?t+"-"+this._uid:t},_createMainContainerElement:function(){var t=document.createElement("div");return t.className=this._addUID("GPlocationPoint"),t.className+=" GPwidget",t},_createLocationPointElement:function(t,e){var i=document.createElement("div");return i.id=this._addUID("GPlocationPoint_"+t),i.className=e?"GPflexInput GPlocationStageFlexInput":"GPflexInput GPlocationStageFlexInputHidden",i.style.cssText="",i},_createLocationPointLabelElement:function(t,e){var i=this,n=document.createElement("label");return n.id=this._addUID("GPlocationOriginLabel_"+t),n.htmlFor="GPlocationOrigin_"+t,n.innerHTML=e,n.addEventListener("click",(function(t){for(var e=o.default.index(this.id),n=document.getElementsByClassName(i._addUID("GPlocationPoint")),s=0;s<n.length;s++){var a=n[s].childNodes[0].id,r=o.default.index(a);document.getElementById(i._addUID("GPlocationPoint_"+r)).style.cssText=""}document.getElementById(i._addUID("GPlocationOriginCoords_"+e)).value="",document.getElementById(i._addUID("GPlocationOrigin_"+e)).value="",document.getElementById(i._addUID("GPlocationPoint_"+e)).style.cssText="",document.getElementById(i._addUID("GPlocationOriginPointer_"+e)).checked=!1,document.getElementById(i._addUID("GPlocationOrigin_"+e)).className="GPlocationOriginVisible",document.getElementById(i._addUID("GPlocationOriginCoords_"+e)).className="GPlocationOriginHidden",document.getElementById(i._addUID("GPlocationStageRemove_"+e))&&(document.getElementById(i._addUID("GPlocationStageRemove_"+e)).className="GPlocationStageRemove"),document.getElementById(i._addUID("GPlocationStageAdd"))&&(document.getElementById(i._addUID("GPlocationStageAdd")).className=""),i.onLocationClearPointClick(t)})),n},_createLocationAutoCompleteteInputElement:function(t){var e=this,i=document.createElement("input");return i.id=this._addUID("GPlocationOrigin_"+t),i.className="GPlocationOriginVisible",i.type="text",i.placeholder="Saisir une adresse",i.autocomplete="off",i.addEventListener("keyup",(function(t){var i=t.which||t.keyCode;if(13!==i&&10!==i&&38!==i&&40!==i){var n=o.default.index(this.id);document.getElementById(e._addUID("GPlocationOrigin_"+n)).value.length>2?document.getElementById(e._addUID("GPlocationAutoCompleteList_"+n)).style.display="block":document.getElementById(e._addUID("GPlocationAutoCompleteList_"+n)).style.display="none",e.onAutoCompleteSearchText(t)}})),i.addEventListener("keydown",(function(i){var s=i.which||i.keyCode,a=document.getElementById(e._addUID("GPlocationAutoCompleteList_"+t));if(a){var r=a.getElementsByClassName("GPautoCompleteProposal current"),l=a.getElementsByClassName("GPautoCompleteProposal"),c=l.length;if(c){var u=null;if(!r.length)return(u=l[0]).className="GPautoCompleteProposal current",u.style.color="#000000",void(u.style["background-color"]="#CEDBEF");u=r[0];var h=parseInt(o.default.index(u.id),10),d=h===c-1?l[0]:l[h+1],p=0===h?l[c-1]:l[h-1];switch(u.style["background-color"]="",u.style.color="",p.style["background-color"]="",p.style.color="",d.style["background-color"]="",d.style.color="",s){case 38:n.log("arrow up"),u.className="GPautoCompleteProposal",p.className="GPautoCompleteProposal current",p.style.color="#000000",p.style["background-color"]="#CEDBEF";break;case 40:n.log("arrow down"),u.className="GPautoCompleteProposal",d.className="GPautoCompleteProposal current",d.style.color="#000000",d.style["background-color"]="#CEDBEF";break;case 13:n.log("enter"),u.click(i)}u.focus()}}})),i},_createLocationCoordinateInputElement:function(t){var e=this,i=document.createElement("input");return i.id=this._addUID("GPlocationOriginCoords_"+t),i.className="GPlocationOriginHidden",i.type="text",i.disabled=!1,i.addEventListener("click",(function(){var t=o.default.index(this.id);document.getElementById(e._addUID("GPlocationOriginLabel_"+t)).click()})),i},_createLocationPointerShowInputElement:function(t){var e=document.createElement("input");return e.id=this._addUID("GPlocationOriginPointer_"+t),e.type="checkbox",e},_createLocationPointerInputElement:function(t){var e=this,i=document.createElement("label");return i.id=this._addUID("GPlocationOriginPointerImg_"+t),i.htmlFor="GPlocationOriginPointer_"+t,i.className="GPlocationOriginPointerImg",i.title="Pointer un lieu sur la carte",i.addEventListener("click",(function(t){t.preventDefault(),t.stopPropagation();var i,n,s,a=o.default.index(this.id),r=document.getElementsByClassName(e._addUID("GPlocationPoint"));for(i=0;i<r.length;i++)n=r[i].childNodes[0].id,a!==(s=o.default.index(n))&&(document.getElementById(e._addUID("GPlocationOriginPointer_"+s)).checked=!1,"Pointer un lieu sur la carte"===document.getElementById(e._addUID("GPlocationOriginCoords_"+s)).value&&(document.getElementById(e._addUID("GPlocationOriginCoords_"+s)).value="",document.getElementById(e._addUID("GPlocationOrigin_"+s)).className="GPlocationOriginVisible",document.getElementById(e._addUID("GPlocationOriginCoords_"+s)).className="GPlocationOriginHidden"));if(document.getElementById(e._addUID("GPlocationOriginPointer_"+a)).checked){for(document.getElementById(e._addUID("GPlocationOriginCoords_"+a)).value="",i=0;i<r.length;i++)n=r[i].childNodes[0].id,s=o.default.index(n),document.getElementById(e._addUID("GPlocationPoint_"+s)).style.cssText="";document.getElementById(e._addUID("GPlocationStageRemove_"+a))&&(document.getElementById(e._addUID("GPlocationStageRemove_"+a)).className="GPlocationStageRemove"),document.getElementById(e._addUID("GPlocationStageAdd"))&&(document.getElementById(e._addUID("GPlocationStageAdd")).className=""),document.getElementById(e._addUID("GPlocationOriginPointer_"+a)).checked=!1,document.getElementById(e._addUID("GPlocationOrigin_"+a)).className="GPlocationOriginVisible",document.getElementById(e._addUID("GPlocationOriginCoords_"+a)).className="GPlocationOriginHidden"}else{for(document.getElementById(e._addUID("GPlocationOriginCoords_"+a)).value="Pointer un lieu sur la carte",i=0;i<r.length;i++)n=r[i].childNodes[0].id,a===(s=o.default.index(n))?document.getElementById(e._addUID("GPlocationPoint_"+s)).style.cssText="":document.getElementById(e._addUID("GPlocationPoint_"+s)).style.display="none";document.getElementById(e._addUID("GPlocationStageRemove_"+a))&&(document.getElementById(e._addUID("GPlocationStageRemove_"+a)).className="GPlocationOriginHidden"),document.getElementById(e._addUID("GPlocationStageAdd"))&&(document.getElementById(e._addUID("GPlocationStageAdd")).className="GPlocationOriginHidden"),document.getElementById(e._addUID("GPlocationOriginPointer_"+a)).checked=!0,document.getElementById(e._addUID("GPlocationOrigin_"+a)).className="GPlocationOriginHidden",document.getElementById(e._addUID("GPlocationOriginCoords_"+a)).className="GPlocationOriginVisible",document.getElementById(e._addUID("GPlocationOriginCoords_"+a)).disabled=!0}e.onActivateMapPointClick(t)})),i},_createLocationRemovePointElement:function(t){var e=this,i=document.createElement("div");return i.id=this._addUID("GPlocationStageRemove_"+t),i.className="GPlocationStageRemove",i.title="Supprimer l'étape",i.addEventListener("click",(function(i){var n=document.getElementsByClassName(e._addUID("GPlocationPoint")),s=n.length-1,a=n[0].childNodes[0].id,r=n[s].childNodes[0].id,l=o.default.index(a),c=o.default.index(r);if(t!==l&&t!==c){var u=o.default.index(this.id);document.getElementById(e._addUID("GPlocationPoint_"+u)).className="GPflexInput GPlocationStageFlexInputHidden",document.getElementById(e._addUID("GPlocationOrigin_"+u)).value="",document.getElementById(e._addUID("GPlocationOrigin_"+u)).className="GPlocationOriginVisible",document.getElementById(e._addUID("GPlocationOriginCoords_"+u)).value="",document.getElementById(e._addUID("GPlocationOriginCoords_"+u)).className="GPlocationOriginHidden",document.getElementById(e._addUID("GPlocationStageAdd")).style.display="",e.onLocationRemovePointClick(i)}})),i},_createLocationAddPointElement:function(){var t=this,e=document.createElement("div");return e.id=this._addUID("GPlocationStageAdd"),e.title="Ajouter une étape",e.addEventListener("click",(function(e){for(var i=1,n=0,s=document.getElementsByClassName(t._addUID("GPlocationPoint")),a=1;a<s.length-1;a++){var r=s[a].childNodes[0].id,l=o.default.index(r);document.getElementById(t._addUID("GPlocationPoint_"+l))&&("GPflexInput GPlocationStageFlexInputHidden"===document.getElementById(t._addUID("GPlocationPoint_"+l)).className?1===i&&(i=l):n++)}i<s.length&&(document.getElementById(t._addUID("GPlocationPoint_"+i)).className="GPflexInput GPlocationStageFlexInput"),4===n&&(document.getElementById(t._addUID("GPlocationStageAdd")).style.display="none"),t.onLocationAddPointClick(e)})),e},_createLocationAutoCompleteResultElement:function(t){var e=this,i=document.createElement("div");return i.id=this._addUID("GPlocationAutoCompleteList_"+t),i.className="GPadvancedAutoCompleteList",i.addEventListener?i.addEventListener("click",(function(i){e.onAutoCompletedResultsItemClick(i),document.getElementById(e._addUID("GPlocationAutoCompleteList_"+t)).style.display="none"}),!1):i.attachEvent&&i.attachEvent("onclick",(function(i){e.onAutoCompletedResultsItemClick(i),document.getElementById(e._addUID("GPlocationAutoCompleteList_"+t)).style.display="none"})),i},_createLocationAutoCompletedLocationElement:function(t,e,i){var o=document.getElementById(this._addUID("GPlocationAutoCompleteList_"+t)),n=document.createElement("div");n.id=this._addUID("AutoCompletedLocation_"+i),n.className="GPautoCompleteProposal",n.innerHTML=e.fullText,o.appendChild(n)},GPdisplayCoordinate:function(t){for(var e=document.getElementsByClassName(this._addUID("GPlocationPoint")),i=0;i<e.length;i++){var n=e[i].childNodes[0].id,s=o.default.index(n);if(document.getElementById(this._addUID("GPlocationOriginPointer_"+s)).checked){document.getElementById(this._addUID("GPlocationOriginCoords_"+s)).value=t,document.getElementById(this._addUID("GPlocationOriginCoords_"+s)).disabled=!1;for(var a=0;a<e.length;a++){n=e[a].childNodes[0].id;var r=o.default.index(n);document.getElementById(this._addUID("GPlocationPoint_"+r)).style.cssText="",document.getElementById(this._addUID("GPlocationStageRemove_"+r))&&(document.getElementById(this._addUID("GPlocationStageRemove_"+r)).className="GPlocationStageRemove")}return document.getElementById(this._addUID("GPlocationOriginPointer_"+s)).checked=!1,void(document.getElementById(this._addUID("GPlocationStageAdd"))&&(document.getElementById(this._addUID("GPlocationStageAdd")).className=""))}}}};e.default=s},function(t,e,i){"use strict";i.r(e);var o={NORTH:"N",SOUTH:"S",EAST:"E",WEST:"O",digitSecond:2,digitDecimal:5,digitRadian:8,roundToDecimal:function(t,e){var i=Math.pow(10,e);return Math.round(t*i)/i},decimalToRadian:function(t){return this.roundToDecimal(.017453292519943295*t,this.digitRadian)},decimalToGrade:function(t){return this.roundToDecimal(1.1111111111111112*t,this.digitRadian)},decimalToDMS:function(t,e,i){t<0&&(t*=-1);var o=Math.floor(t),n=60*(t-o),s=Math.floor(n),a=60*(n-s),r=this.roundToDecimal(a,this.digitSecond),l=o+"° "+s+"' "+r+'" ';return e&&(l+=e),i?{d:o,m:s,s:r,direction:e}:l},decimalLatToDMS:function(t,e){var i=t<0?this.SOUTH:this.NORTH;return this.decimalToDMS(t,i,e)},decimalLonToDMS:function(t,e){var i=t<0?this.WEST:this.EAST;return this.decimalToDMS(t,i,e)},DMSToDecimal:function(t,e,i,o){var n=t+e/60+i/3600;return n=o===this.SOUTH||o===this.WEST?-1*n:n,this.roundToDecimal(n,this.digitDecimal)}};e.default=o},function(t,e,i){"use strict";i.r(e);var o=i(2),n=i.n(o),s=i(34).default.getLogger("icondefault"),a=n.a.Icon.Default.extend({images:{retina:{shadow:"data:image/png;base64,...",color:{blue:"data:image/png;base64,...",orange:"data:image/png;base64,...",red:"data:image/png;base64,...",green:"data:image/png;base64,..."}},shadow:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACkAAAApCAYAAACoYAD2AAAC5ElEQVRYw+2YW4/TMBCF45S0S1luXZCABy5CgLQgwf//S4BYBLTdJLax0fFqmB07nnQfEGqkIydpVH85M+NLjPe++dcPc4Q8Qh4hj5D/AaQJx6H/4TMwB0PeBNwU7EGQAmAtsNfAzoZkgIa0ZgLMa4Aj6CxIAsjhjOCoL5z7Glg1JAOkaicgvQBXuncwJAWjksLtBTWZe04CnYRktUGdilALppZBOgHGZcBzL6OClABvMSVIzyBjazOgrvACf1ydC5mguqAVg6RhdkSWQFj2uxfaq/BrIZOLEWgZdALIDvcMcZLD8ZbLC9de4yR1sYMi4G20S4Q/PWeJYxTOZn5zJXANZHIxAd4JWhPIloTJZhzMQduM89WQ3MUVAE/RnhAXpTycqys3NZALOBbB7kFrgLesQl2h45Fcj8L1tTSohUwuxhy8H/Qg6K7gIs+3kkaigQCOcyEXCHN07wyQazhrmIulvKMQAwMcmLNqyCVyMAI+BuxSMeTk3OPikLY2J1uE+VHQk6ANrhds+tNARqBeaGc72cK550FP4WhXmFmcMGhTwAR1ifOe3EvPqIegFmF+C8gVy0OfAaWQPMR7gF1OQKqGoBjq90HPMP01BUjPOqGFksC4emE48tWQAH0YmvOgF3DST6xieJgHAWxPAHMuNhrImIdvoNOKNWIOcE+UXE0pYAnkX6uhWsgVXDxHdTfCmrEEmMB2zMFimLVOtiiajxiGWrbU52EeCdyOwPEQD8LqyPH9Ti2kgYMf4OhSKB7qYILbBv3CuVTJ11Y80oaseiMWOONc/Y7kJYe0xL2f0BaiFTxknHO5HaMGMublKwxFGzYdWsBF174H/QDknhTHmHHN39iWFnkZx8lPyM8WHfYELmlLKtgWNmFNzQcC1b47gJ4hL19i7o65dhH0Negbca8vONZoP7doIeOC9zXm8RjuL0Gf4d4OYaU5ljo3GYiqzrWQHfJxA6ALhDpVKv9qYeZA8eM3EhfPSCmpuD0AAAAASUVORK5CYII=",color:{blue:"data:image/png;base64,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",orange:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABkAAAApCAYAAADAk4LOAAAABGdBTUEAALGPC/xhBQAAAAFzUkdCAK7OHOkAAAAgY0hSTQAAeiYAAICEAAD6AAAAgOgAAHUwAADqYAAAOpgAABdwnLpRPAAAAAZiS0dEAP8A/wD/oL2nkwAAAAlwSFlzAAAASAAAAEgARslrPgAABghJREFUWMOdl1uInGcdxn/feWa+mflmJmZbqVqKigewKK5goHgRSEm8EC88F6tBFLfgZbzJnVdRYWExrVBoXazWlAYL0dVisLBYzEUUSbeNjZQmxGZ3NjO7c57v/P69mNnD7MzuzvrCA8PM+/+e93n+h/cb7c9PzXKE9RHAG36+BXRPP3390CDtT3MHklSA7wKngVOWbaOhA5AkEUqpKnAFePHMM9eX9yeZrMQAzgHni14ln826ZLLu2KY0TfD7XXq9NoHffxX48Zmnr6+MkSyNK6kAl4ql8qlisYxpWagoJA16gIxs1E0bI1cAoNNuslFb94Env/jM9csj+0SEXaiIyN+9cuVU5dhxdEmI23XSoAOoIckOVBISt+vE7Q0KRY8H3v+BbM7Nv7w0Nzs3QrLHopdL5crHyqUKSbdB6ndA1BRIiVs1Mo5NySsD/GJpbvbkjpKds50rFL2T5VKZpNdAkmjiAzXDHOye8FvS2cC2LWZmHjAELv1xbrYyIFGCKKmIkvMlr4iK+0gaDe0ZQHcyWIUyVqGMmDZWvoRVKGO63sg+UMSdGq6bo+R5x0XJuYFdGqDxLa9UzJumQRp0R3y3ChU002Zjc5Pbd+6wGem8e/sO6+vrBGGIVagMTdmJScMepZIHGj/4ww8/a5jDevl63s2h4nAgfbhM1yOMQt67V+WjZ87y+VNPYmXzANz7x19YufQzilFIySsTt+vbcSrsYTlZnEymEgTBCV2U5EXJiUzGJg1aI9I1w6DZbPHoE+f5+Jee2iYAeGj2cR479zyNjo+SFN12xqzLZRxEyWld4EOWbRmIApVuJ1E3LaIwRLkzPPzYl8caUURwZz7Iw1/4Cq1WG8POjBSBCvvYtonAJ3URqeiaNlYpuuXg+wHlRz41kQBAKUX5w5+m1/PHKk7SBF0DEfFMgUjJMGnaro7WFGig0nhfAhEhjQI0TRuL1wwNFSkEfF2Ee3GSjp0kDXq4WZv7b19HJeNEWySrN/5G3nUQlezpJ4MkTRHhni4i1ThOuipNByfakhsHmIZGRnV565WLYyoA1t68RuONq3j5DKnfHiXRdKIoRkTuGl/9zIMCfC7rGJ/I5vOocGsQCoiQz7vc/8+/WH37BrnKgzjFY7RWb/Pu8mVWLv2UmUoOxzYGJFtxmobhZFmrd0hS9SPtpbOPApx0s/ZfH3moRNyujU5aO4eRcWl2AjZbPn6YYFsGXt6h4mUxDX0sxioep9kJeG+9ffVrz994fKsZX+v60bVuPzzhFo6RdHY1VtRDEp9S4RilgjPyMBX2iXu90dIbFsFm20fgJwCm7BTEzzda/u/zrjVspl2JVoq4vc40yyrO0OqGdPvxa9/41Y3XYfQ+udLshO8EQYyZK0454idAKTYafUTkwrblu0Z9KjBfb/pouvl/EZhuma4f0e7H//zm4htXt0n23HaL9VZQS5IU3c4emUTTNOoNH9hRsVcJAr7As7VWgJHJDTp4SpiFMv0oodGLbwm8MkoyescjIgtrm4GvlEI37SOo0Kk1AkTkwhOLK+keEtiDmggv1FshRrYwFYGRLRJEKfV2fFeEF/dW3F67tjB/txamIoKm65N37IJu2dRaEQLz3/71m9E4ybhdiMgtEVna7EQY+Qoial/oTo4oTqk2opqIPDepd/QDzjh/vxmDOtgq3cqy3ogQuPidF97qTiaZrAQRWW776bVOkGIW3jfZJidHqoTVRtwVkYX9psCkxO/GwnojRhvMlvGE2zmqzRgRfnn2Nzdb+5McnNbL9a56x48FI+vtSbaDaPDfjSQSmD9onh1kFyKSishCtZmgW/ZY2a5txojI4vd+e7N6CMmBdiHC4lojrcWpoDsuIGimhYhwp5amIlzgkKUf1gMgXZBnq40Ew8kNBmGuxHozAeSl7//u37cPJTmUYoCLdzdVJMNcgLDWFoTDVUxrFyJURVisNhVGzqPWVvQCWRJhZSqS4Qv3NFhYaw10rbUENC4MansaJYO/DtPgZi+QK7W20OrLsih5XZRMSTJdTrZHzWpzkIut76az62hrueXzHPDqUYL+B8XVKUzuUimfAAAAJXRFWHRkYXRlOmNyZWF0ZQAyMDEyLTA4LTE4VDE0OjUwOjU2KzAxOjAwFlCkXwAAACV0RVh0ZGF0ZTptb2RpZnkAMjAxMi0wOC0xOFQxNDo1MDo1NiswMTowMGcNHOMAAAAZdEVYdFNvZnR3YXJlAEFkb2JlIEltYWdlUmVhZHlxyWU8AAAAAElFTkSuQmCC",red:"data:image/png;base64,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",green:"data:image/png;base64,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"}},initialize:function(t,e){n.a.Util.extend(this.options,e);var i=null,o=this.images;switch(t){case"red":i=o.color.red;break;case"green":i=o.color.green;break;case"orange":i=o.color.orange;break;case"blue":i=o.color.blue;break;default:i=o.color.blue}this.options.iconUrl=i,this.options.shadowUrl=o.shadow,n.a.Browser.retina&&(this.options.iconRetinaUrl=i,this.options.shadowRetinaUrl=o.shadow)},_getIconUrl:function(t){return s.trace("OVERWRITTEN L.Icon.Default._getIconUrl("+t+")"),n.a.Icon.prototype._getIconUrl.call(this,t)}});e.default=a},function(t,e,i){"use strict";i.r(e);var o={_addUID:function(t){return this._uid?t+"-"+this._uid:t},_createMainContainerElement:function(){var t=document.createElement("div");return t.id=this._addUID("GPisochron"),t.className="GPwidget",t},_createShowIsoElement:function(){var t=document.createElement("input");return t.id=this._addUID("GPshowIsochron"),t.type="checkbox",t},_createShowIsoPictoElement:function(){var t=this,e=document.createElement("label");e.id=this._addUID("GPshowIsochronPicto"),e.className="GPshowAdvancedToolPicto",e.htmlFor=this._addUID("GPshowIsochron"),e.title="Calculer une isochrone",e.addEventListener?e.addEventListener("click",(function(e){t.onShowIsoPanelClick(e)})):e.attachEvent&&e.attachEvent("onclick",(function(e){t.onShowIsoPanelClick(e)}));var i=document.createElement("span");return i.id=this._addUID("GPshowIsochronOpen"),i.className="GPshowAdvancedToolOpen",e.appendChild(i),e},_createIsoPanelElement:function(){var t=document.createElement("div");return t.id=this._addUID("GPisochronPanel"),t.className="GPpanel",t},_createIsoPanelHeaderElement:function(){var t=this,e=document.createElement("div");e.className="GPpanelHeader";var i=document.createElement("div");i.className="GPpanelTitle",i.innerHTML="Calcul d'isochrone",e.appendChild(i);var o=document.createElement("div");return o.id=this._addUID("GPisochronPanelClose"),o.className="GPpanelClose",o.title="Fermer le panneau",o.addEventListener?o.addEventListener("click",(function(){document.getElementById(t._addUID("GPshowIsochronPicto")).click()}),!1):o.attachEvent&&o.attachEvent("onclick",(function(){document.getElementById(t._addUID("GPshowIsochronPicto")).click()})),e.appendChild(o),e},_createIsoPanelFormElement:function(){var t=this,e=document.createElement("form");return e.id=this._addUID("GPisochronForm"),e.addEventListener("submit",(function(e){return e.preventDefault(),t.onIsoComputationSubmit(e),!1})),e},_createIsoWaitingElement:function(){var t=document.createElement("div");t.id=this._addUID("GPisochronCalcWaitingContainer"),t.className="GPisochronCalcWaitingContainerHidden";var e=document.createElement("p");return e.className="GPisochronCalcWaiting",e.innerHTML="Calcul en cours...",t.appendChild(e),t},_createIsoPanelFormTypeChoiceElement:function(){var t=document.createElement("div");return t.id=this._addUID("GPisochronChoice"),t},_createIsoPanelFormTypeChoiceChronElement:function(t){var e=this,i=document.createElement("div");i.className="GPisochronChoiceAlt";var o=document.createElement("input");o.id=this._addUID("GPisochronChoiceAltChron"),o.name="GPisochronChoiceMode",o.type="radio",o.checked=!!t,o.addEventListener?o.addEventListener("change",(function(t){document.getElementById(e._addUID("GPisochronValueChron")).className="GPflexInput",document.getElementById(e._addUID("GPisochronValueDist")).className="GPisochronValueHidden",e.onIsoTypeChoiceChange(t)}),!1):o.attachEvent&&o.attachEvent("onchange",(function(){document.getElementById(e._addUID("GPisochronValueChron")).className="GPflexInput",document.getElementById(e._addUID("GPisochronValueDist")).className="GPisochronValueHidden",e.onIsoTypeChoiceChange()})),o.value="isochron",i.appendChild(o);var n=document.createElement("label");n.className="GPisochronChoiceAltImg",n.htmlFor=this._addUID("GPisochronChoiceAltChron"),i.appendChild(n);var s=document.createElement("span");return s.id=this._addUID("GPisochronChoiceAltChronTxt"),s.innerHTML="isochrone",s.addEventListener?s.addEventListener("click",(function(){document.getElementById(e._addUID("GPisochronChoiceAltChron")).click()}),!1):s.attachEvent&&s.attachEvent("onclick",(function(){document.getElementById(e._addUID("GPisochronChoiceAltChron")).click()})),i.appendChild(s),i},_createIsoPanelFormTypeChoiceDistElement:function(t){var e=this,i=document.createElement("div");i.className="GPisochronChoiceAlt";var o=document.createElement("input");o.id=this._addUID("GPisochronChoiceAltDist"),o.name="GPisochronChoiceMode",o.type="radio",o.checked=!!t,o.addEventListener?o.addEventListener("change",(function(t){document.getElementById(e._addUID("GPisochronValueDist")).className="GPflexInput",document.getElementById(e._addUID("GPisochronValueChron")).className="GPisochronValueHidden",e.onIsoTypeChoiceChange(t)}),!1):o.attachEvent&&o.attachEvent("onchange",(function(){document.getElementById(e._addUID("GPisochronValueDist")).className="GPflexInput",document.getElementById(e._addUID("GPisochronValueChron")).className="GPisochronValueHidden",e.onIsoTypeChoiceChange()})),o.value="isodistance",i.appendChild(o);var n=document.createElement("label");n.className="GPisochronChoiceAltImg",n.htmlFor=this._addUID("GPisochronChoiceAltDist"),i.appendChild(n);var s=document.createElement("span");return s.id=this._addUID("GPisochronChoiceAltDistTxt"),s.innerHTML="isodistance",s.addEventListener?s.addEventListener("click",(function(){document.getElementById(e._addUID("GPisochronChoiceAltDist")).click()}),!1):s.attachEvent&&s.attachEvent("onclick",(function(){document.getElementById(e._addUID("GPisochronChoiceAltDist")).click()})),i.appendChild(s),i},_createIsoPanelFormValueIsochronElement:function(t){var e=this,i=document.createElement("div");i.id=this._addUID("GPisochronValueChron"),i.className=t?"GPflexInput":"GPisochronValueHidden";var o=document.createElement("label");o.id=this._addUID("GPisochronValueChronLabel"),o.htmlFor=this._addUID("GPisochronValueChronInput"),o.innerHTML="Temps",i.appendChild(o);var n=document.createElement("input");n.id=this._addUID("GPisochronValueChronInput1"),n.min="0",n.step="1",n.value="0",n.type="number",n.addEventListener?n.addEventListener("change",(function(t){"function"==typeof e.onIsoValueChronTimeMinuteChange&&e.onIsoValueChronTimeHourChange(t)})):n.attachEvent&&n.attachEvent("onchange",(function(t){"function"==typeof e.onIsoValueChronTimeMinuteChange&&e.onIsoValueChronTimeHourChange(t)})),i.appendChild(n);var s=document.createElement("label");s.innerHTML="h",i.appendChild(s);var a=document.createElement("input");a.id=this._addUID("GPisochronValueChronInput2"),a.min="0",a.max="59",a.step="1",a.value="0",a.type="number",a.addEventListener?a.addEventListener("change",(function(t){"function"==typeof e.onIsoValueChronTimeMinuteChange&&e.onIsoValueChronTimeMinuteChange(t)})):a.attachEvent&&a.attachEvent("onchange",(function(t){"function"==typeof e.onIsoValueChronTimeMinuteChange&&e.onIsoValueChronTimeMinuteChange(t)})),i.appendChild(a);var r=document.createElement("label");return r.innerHTML="min",i.appendChild(r),i},_createIsoPanelFormValueIsodistanceElement:function(t){var e=this,i=document.createElement("div");i.id=this._addUID("GPisochronValueDist"),i.className=t?"GPflexInput":"GPisochronValueHidden";var o=document.createElement("label");o.id=this._addUID("GPisochronValueDistLabel"),o.htmlFor=this._addUID("GPisochronValueDistInput"),o.innerHTML="Distance",i.appendChild(o);var n=document.createElement("input");n.id=this._addUID("GPisochronValueDistInput"),n.min="0",n.step="any",n.value="0",n.type="number",n.addEventListener?n.addEventListener("change",(function(t){"function"==typeof e.onIsoValueDistChange&&e.onIsoValueDistChange(t)})):n.attachEvent&&n.attachEvent("onchange",(function(t){"function"==typeof e.onIsoValueDistChange&&e.onIsoValueDistChange(t)})),i.appendChild(n);var s=document.createElement("label");return s.innerHTML="km",i.appendChild(s),i},_createIsoPanelFormModeChoiceElement:function(){var t=document.createElement("div");return t.id=this._addUID("GPisochronModeChoice"),t},_createIsoPanelFormModeChoiceTransportElement:function(t){var e=this,i=document.createElement("div");i.id=this._addUID("GPisochronTransportChoice");var o=document.createElement("span");o.className="GPisochronModeLabel",o.innerHTML="Mode de transport",i.appendChild(o);for(var n=0;n<t.length;n++){var s=t[n];if("Voiture"===s){var a=document.createElement("input");a.id=this._addUID("GPisochronTransportCar"),a.type="radio",a.name="GPisochronTransport",0===n&&(a.checked=!0),a.addEventListener?a.addEventListener("change",(function(t){e.onIsoModeTransportChange(t)})):a.attachEvent&&a.attachEvent("onchange",(function(t){e.onIsoModeTransportChange(t)})),a.value="Voiture",i.appendChild(a);var r=document.createElement("label");r.className="GPisochronTransportImg",r.htmlFor=this._addUID("GPisochronTransportCar"),r.title="Voiture",i.appendChild(r)}if("Pieton"===s){var l=document.createElement("input");l.id=this._addUID("GPisochronTransportPedestrian"),l.type="radio",l.name="GPisochronTransport",0===n&&(l.checked=!0),l.addEventListener?l.addEventListener("change",(function(t){e.onIsoModeTransportChange(t)})):l.attachEvent&&l.attachEvent("onchange",(function(t){e.onIsoModeTransportChange(t)})),l.value="Pieton",i.appendChild(l);var c=document.createElement("label");c.className="GPisochronTransportImg",c.htmlFor=this._addUID("GPisochronTransportPedestrian"),c.title="Piéton",i.appendChild(c)}}return i},_createIsoPanelFormModeChoiceDirectionElement:function(t){var e=this,i=document.createElement("div");i.id=this._addUID("GPisochronDirectionChoice");var o=document.createElement("span");o.className="GPisochronModeLabel",o.innerHTML="Sens de parcours",i.appendChild(o);var n=document.createElement("select");n.id=this._addUID("GPisochronDirectionSelect"),n.className="GPinputSelect",n.addEventListener("change",(function(t){e.onIsoModeDirectionChange(t)}));for(var s=0;s<t.length;s++){var a=t[s];if("departure"===a.toLowerCase()){var r=document.createElement("option");0===s&&(r.selected="selected"),r.value="departure",r.text="Départ",n.appendChild(r)}if("arrival"===a.toLowerCase()){var l=document.createElement("option");0===s&&(l.selected="selected"),l.value="arrival",l.text="Arrivée",n.appendChild(l)}}return i.appendChild(n),i},_createShowIsoExclusionsElement:function(){var t=document.createElement("input");return t.id=this._addUID("GPshowIsoExclusions"),t.type="checkbox",t},_createShowIsoExclusionsPictoElement:function(){var t=document.createElement("label");return t.id=this._addUID("GPshowIsoExclusionsPicto"),t.className="GPshowMoreOptionsImage GPshowMoreOptions GPshowIsoExclusionsPicto",t.htmlFor=this._addUID("GPshowIsoExclusions"),t.title="Exclusions",t.style.top="240px",t},_createIsoPanelFormExclusionsElement:function(){var t=document.createElement("div");t.id=this._addUID("GPisoExclusions");var e=document.createElement("span");return e.className="GPisoExclusionsLabel",e.innerHTML="Passages autorisés",t.appendChild(e),t},_createIsoPanelFormExclusionOptionsElement:function(t){var e=this,i=document.createElement("div");for(var o in i.className="GPisoExclusionsOptions",t)if(t.hasOwnProperty(o)){var n=t[o];switch(o){case"toll":var s=document.createElement("input");s.id=this._addUID("GPisoExclusionsToll"),s.type="checkbox",s.checked=!n,s.addEventListener?s.addEventListener("change",(function(t){e.onIsoExclusionsChange(t)})):s.attachEvent&&s.attachEvent("onchange",(function(t){e.onIsoExclusionsChange(t)})),s.value="Toll",i.appendChild(s);var a=document.createElement("label");a.className="GPisoExclusionsOption",a.htmlFor=this._addUID("GPisoExclusionsToll"),a.innerHTML="Péages",i.appendChild(a);break;case"tunnel":var r=document.createElement("input");r.id=this._addUID("GPisoExclusionsTunnel"),r.type="checkbox",r.checked=!n,r.addEventListener?r.addEventListener("change",(function(t){e.onIsoExclusionsChange(t)})):r.attachEvent&&r.attachEvent("onchange",(function(t){e.onIsoExclusionsChange(t)})),r.value="Tunnel",i.appendChild(r);var l=document.createElement("label");l.className="GPisoExclusionsOption",l.htmlFor=this._addUID("GPisoExclusionsTunnel"),l.innerHTML="Tunnels",i.appendChild(l);break;case"bridge":var c=document.createElement("input");c.id=this._addUID("GPisoExclusionsBridge"),c.type="checkbox",c.checked=!n,c.addEventListener?c.addEventListener("change",(function(t){e.onIsoExclusionsChange(t)})):c.attachEvent&&c.attachEvent("onchange",(function(t){e.onIsoExclusionsChange(t)})),c.value="Bridge",i.appendChild(c);var u=document.createElement("label");u.className="GPisoExclusionsOption",u.htmlFor=this._addUID("GPisoExclusionsBridge"),u.innerHTML="Ponts",i.appendChild(u)}}return i},_createIsoSubmitFormElement:function(){var t=document.createElement("input");return t.id=this._addUID("GPisochronSubmit"),t.className="GPinputSubmit",t.type="submit",t.value="Calculer",t},_createIsoFormResetElement:function(){var t=this,e=document.createElement("div");return e.id=this._addUID("GPisochronReset"),e.title="Réinitialiser les paramètres",e.addEventListener("click",(function(e){t.onIsoResetClick(e)})),e}};e.default=o},function(t,e,i){"use strict";i.r(e);var o=i(40),n=i(2),s=i.n(n),a=i(34),r=i(140),l=i(36),c=i(148),u=i(149),h=i(144),d=i(150);function p(t){return(p="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}var m=a.default.getLogger("mouseposition"),f=s.a.Control.extend({includes:u.default,options:{position:"bottomleft",collapsed:!0,units:[],systems:[],displayAltitude:!0,displayCoordinates:!0,editCoordinates:!1,altitude:{triggerDelay:200,responseDelay:500,noDataValue:-99999,noDataValueTolerance:9e4,serviceOptions:{}}},initialize:function(t){s.a.Util.extend(this.options,t),this._uid=l.default.generate(),this._projectionSystems=[],this._initProjectionSystems(),this._projectionUnits={},this._initProjectionUnits(),this._isDesktop=this._detectSupport(),this.options.altitude.triggerDelay<100&&(this.options.altitude.triggerDelay=100),this._timer=this.options.altitude.triggerDelay,this._currentProjectionSystems=this._projectionSystems[0],this._projectionSystemsContainer=null,this._currentProjectionType=this._projectionSystems[0].type,this._currentProjectionUnits=this._projectionUnits[this._currentProjectionType][0].code,this._projectionUnitsContainer=null,this._showContainer=null,this._pictoContainer=null,this._panelContainer=null,this._panelHeaderContainer=null,this.options.displayAltitude||this.options.displayCoordinates||(this.options.displayCoordinates=!0),this.options.displayCoordinates||(this.options.editCoordinates=!1),this._isEditing=!1,this._noRightManagement=!1,this.options.displayAltitude&&this._checkRightsManagement(),s.a.Util.setOptions(this,this.options)},onAdd:function(t){var e=this._container=this._initLayout();return this.options.collapsed||(this._isDesktop?t.on("mousemove",this.onMouseMove,this):t.on("move",this.onMapMove,this)),s.a.DomEvent.disableClickPropagation(e).disableScrollPropagation(e),s.a.DomEvent.addListener(e,"mousemove",s.a.DomEvent.stopPropagation).addListener(e,"mousemove",s.a.DomEvent.preventDefault),e},onRemove:function(t){t.off("mousemove",this.onMouseMove)},_initProjectionSystems:function(){for(var t=[{label:"Géographique",crs:s.a.CRS.Simple,type:"Geographical"},{label:"Web Mercator",crs:s.a.CRS.EPSG3395,type:"Metric"},{label:"Lambert 93",crs:d.default.EPSG2154,type:"Metric",geoBBox:{left:-9.86,bottom:41.15,right:10.38,top:51.56}},{label:"Lambert II étendu",crs:d.default.EPSG27572,type:"Metric",geoBBox:{left:-4.87,bottom:42.33,right:8.23,top:51.14}}],e=this.options.systems,i=0;i<e.length;i++){var o=e[i];if(o.label)if(o.crs){o.type||(m.warn("type srs not defined, use 'Metric' by default !"),o.type="Metric"),this._projectionSystems.push(e[i]);for(var n=!1,a=0;a<t.length;a++){var r=t[a];o.crs===r.crs&&(n=!0,m.info("crs '{}' already configured by default",r.code))}n||m.info("crs '{}' not found, it's a new projection",o.code||o.label)}else m.error("crs not defined !");else m.error("not defined !")}0===this._projectionSystems.length&&(this._projectionSystems=t);for(var l=0;l<this._projectionSystems.length;++l)this._projectionSystems[l].code=l},_initProjectionUnits:function(){var t={Geographical:[{code:"DEC",label:"degrés décimaux",format:this._displayDEC},{code:"DMS",label:"degrés sexagésimaux",format:this._displayDMS},{code:"RAD",label:"radians",format:this._displayRAD},{code:"GON",label:"grades",format:this._displayGON}],Metric:[{code:"M",label:"mètres",format:this._displayMeter},{code:"KM",label:"kilomètres",format:this._displayKMeter}]},e=this.options.units;for(var i in t)if(t.hasOwnProperty(i)){for(var o=!1,n=0;n<t[i].length;n++)for(var s=t[i][n],a=0;a<e.length;a++){var r=e[a];s.code===r&&(o=!0,this._projectionUnits[i]||(this._projectionUnits[i]=[]),this._projectionUnits[i].push(s))}o||(this._projectionUnits[i]=t[i])}0===Object.keys(this._projectionUnits).length&&(this._projectionUnits=t)},_checkRightsManagement:function(){var t=r.default.check({key:this.options.apiKey,resources:["SERVICE_CALCUL_ALTIMETRIQUE_RSC"],services:["Elevation"]});this._noRightManagement=!t,this.options.apiKey||(this.options.apiKey=t?t.key:null)},_detectSupport:function(){var t=!0,e=window.navigator.userAgent.toLowerCase();return-1===e.indexOf("iphone")&&-1===e.indexOf("ipod")&&-1===e.indexOf("ipad")&&-1===e.indexOf("android")&&-1===e.indexOf("mobile")&&-1===e.indexOf("blackberry")&&-1===e.indexOf("tablet")&&-1===e.indexOf("phone")&&-1===e.indexOf("touch")||(t=!1),-1===e.indexOf("msie")&&-1===e.indexOf("trident")||(t=!0),t},_initLayout:function(){var t=this._createMainContainerElement(),e=this._showContainer=this._createShowMousePositionElement();t.appendChild(e),this.options.collapsed||(e.checked=!0);var i=this._pictoContainer=this._createShowMousePositionPictoElement(this._isDesktop);t.appendChild(i);var o=this._panelContainer=this._createMousePositionPanelElement(),n=this._panelHeaderContainer=this._createMousePositionPanelHeaderElement();o.appendChild(n);var s=this._createMousePositionPanelBasicElement(this.options.displayAltitude,this.options.displayCoordinates,this.options.editCoordinates);o.appendChild(s);for(var a=this._createShowMousePositionSettingsElement(this.options.displayCoordinates),r=0;r<a.length;r++)o.appendChild(a[r]);var l=this._createMousePositionSettingsElement(),c=this._projectionSystemsContainer=this._createMousePositionSettingsSystemsElement(this._projectionSystems),u=this._projectionUnitsContainer=this._createMousePositionSettingsUnitsElement(this._projectionUnits[this._currentProjectionType]);l.appendChild(c),l.appendChild(u),o.appendChild(l),t.appendChild(o);var h=this._createMapCenter();return this._map.getContainer().appendChild(h),t},_setElevationPanel:function(t){t||(s.a.DomUtil.get(this._addUID("GPmousePositionAltitude")).style.display="none"),t&&this._noRightManagement&&(s.a.DomUtil.get(this._addUID("GPmousePositionAlt")).innerHTML="no right !")},_setCoordinatePanel:function(t){t||(s.a.DomUtil.get(this._addUID("GPmousePositionCoordinate")).style.display="none")},_setSettingsPanel:function(t){if(!t){var e=s.a.DomUtil.get("GPshowMousePositionSettingsPicto"),i=s.a.DomUtil.get(this._addUID("GPmousePositionSettings"));e.style.display="none",i.style.display="none"}},_setTypeUnitsPanel:function(t){for(var e=this._projectionUnitsContainer;e.firstChild;)e.removeChild(e.firstChild);for(var i=this._projectionUnits[t],o=0;o<i.length;o++){var n=i[o],s=document.createElement("option");s.value=n.code?n.code:o,s.text=n.label||o,e.appendChild(s)}var a=this._projectionUnits[t][0].code;"DMS"!==this._currentProjectionUnits&&"DMS"!==a||(this._resetCoordinateElements(this.options.editCoordinates,t,a),this._setEditMode(this._isEditing)),this._currentProjectionType=t,this._resetLabelElements(t),this._resetUnitElements(a),this._currentProjectionUnits=this._projectionUnits[t][0].code},_displayDEC:function(t){var e={};return e.lat=h.default.roundToDecimal(t.lat,6),e.lng=h.default.roundToDecimal(t.lng,6),e.unit="°",e},_displayDMS:function(t){var e={};return e.lat=h.default.decimalLatToDMS(t.lat,!0),e.lng=h.default.decimalLonToDMS(t.lng,!0),e},_displayRAD:function(t){var e={};return e.lat=h.default.decimalToRadian(t.lat),e.lng=h.default.decimalToRadian(t.lng),e.unit="rad",e},_displayGON:function(t){var e={};return e.lat=h.default.decimalToGrade(t.lat),e.lng=h.default.decimalToGrade(t.lng),e.unit="gon",e},_displayMeter:function(t){var e={};return e.x=s.a.Util.formatNum(t.x,2),e.y=s.a.Util.formatNum(t.y,2),e.unit="m",e},_displayKMeter:function(t){var e={};return e.x=s.a.Util.formatNum(t.x/1e3,2),e.y=s.a.Util.formatNum(t.y/1e3,2),e.unit="km",e},_project:function(t,e){if("function"==typeof e&&(e=e()),"object"===p(e)){if(e===s.a.CRS.Simple)return t;if(e.projection&&"object"===p(e.projection)){var i=e.projection.project(t);return"Geographical"===this._currentProjectionType&&(i.lat=i.y,i.lng=i.x),i&&0!==Object.keys(i).length||m.error("Failed to project with crs code : "+e.code),i}m.error("projection is not an object !")}else m.log("crs is not an object !")},_unproject:function(t){var e=this._currentProjectionSystems.crs;if(e)if("function"==typeof e&&(e=e()),"object"===p(e)){if(e===s.a.CRS.Simple)return{lat:t.y,lng:t.x};if("Geographical"===this._currentProjectionType)return{lat:t.y,lng:t.x};if(e.projection&&"object"===p(e.projection)){var i=e.projection.unproject(t);return i&&0!==Object.keys(i).length||m.error("Failed to unproject coordinate"),i}m.error("projection is not an object !")}else m.log("crs is not an object !");else m.log("system crs not found")},_setCoordinate:function(t){for(var e=this._currentProjectionSystems.type,i=null,o=this._projectionUnits[e],n=0;n<o.length;n++)if(o[n].code===this._currentProjectionUnits){i=o[n].format;break}var s,a=this._currentProjectionSystems.crs;a?(s=i(this._project(t,a)))&&0!==Object.keys(s).lenght&&this.GPdisplayCoords(s):m.error("crs not found !")},_setElevation:function(t){var e=this.options.altitude.responseDelay,i=this.options.altitude.noDataValue,o=this.options.altitude.noDataValueTolerance;this.GPdisplayElevation(t,e,i,o)},onMoveStopped:function(t){this._noRightManagement||this._setElevation(t)},onMouseMove:function(t){var e=this,i=t.latlng;this._setCoordinate(i),clearTimeout(this._timer),this._timer=setTimeout((function(){e.onMoveStopped(i)}),this.options.altitude.triggerDelay)},onMapMove:function(){var t=this,e=this._map.getCenter();this._setCoordinate(e),clearTimeout(this._timer),this._timer=setTimeout((function(){t.onMoveStopped(e)}),this.options.altitude.triggerDelay)},onRequestAltitude:function(t,e){if(m.log("onRequestAltitude"),t&&0!==Object.keys(t).length&&this.options.displayAltitude&&!this._noRightManagement){m.log(t);var i={};s.a.Util.extend(i,this.options.altitude.serviceOptions),s.a.Util.extend(i,{zonly:!0,positions:[{lon:t.lon||t.lng,lat:t.lat}]}),s.a.Util.extend(i,{scope:this,onSuccess:function(t){m.log(t),t&&Object.keys(t)&&e.call(this,t.elevations[0].z)},onFailure:function(t){m.error(t.message)}}),s.a.Util.extend(i,{apiKey:i.apiKey||this.options.apiKey}),s.a.Util.extend(i,{ssl:this.options.ssl}),m.log(i),o.default.Services.getAltitude(i)}},onShowMousePositionClick:function(t){m.log(t);var e=this._map;this._showContainer.checked?this._isDesktop?e.off("mousemove",this.onMouseMove,this):e.off("move",this.onMapMove,this):this._isDesktop?e.on("mousemove",this.onMouseMove,this):e.on("move",this.onMapMove,this),this._setElevationPanel(this.options.displayAltitude),this._setCoordinatePanel(this.options.displayCoordinates),this.options.displayCoordinates||this._setSettingsPanel(!1)},onMousePositionEditModeClick:function(t){if(this.options.editCoordinates&&this._isEditing!==t){this._isEditing=t,this._setEditMode(this._isEditing);var e=this._map;this._isDesktop?this._isEditing?e.off("mousemove",this.onMouseMove,this):e.on("mousemove",this.onMouseMove,this):this._isEditing?e.off("move",this.onMapMove,this):e.on("move",this.onMapMove,this)}},_convertCoordinate:function(t,e){var i;if("DEC"===e||"DMS"===e)i=t;else if("M"===e)i=t;else if("KM"===e)i=1e3*t;else if("RAD"===e){i=(t*(180/Math.PI).toFixed(20)).toFixed(20)}else if("GON"===e){i=(t*.9.toFixed(20)).toFixed(20)}return i},validateExtentCoordinate:function(t,e,i){if(void 0!==i)return!0;if(-1===["Lon","Lat"].indexOf(t))return!1;var o=this._currentProjectionSystems.geoBBox;if(void 0===o)return!0;if(o){var n=[o.left,o.bottom,o.right,o.top],s=this._currentProjectionUnits,a=this._unproject({x:"Lon"===t?this._convertCoordinate(e,s):0,y:"Lat"===t?this._convertCoordinate(e,s):0});if("Lon"===t&&(a.lng<n[0]||a.lng>n[2]))return m.warn("coordinates (lon) out of extent !?"),!1;if("Lat"===t&&(a.lat<n[1]||a.lat>n[3]))return m.warn("coordinates (lat) out of extent !?"),!1}return!0},_getCoordinate:function(t){var e=s.a.DomUtil.get(this._addUID("GPmousePosition"+t+"Degrees")),i=e.value;if(!i)return null;if(i=i.replace(",","."),!c.default.isInteger(i))return null;var o=c.default.toInteger(i);if(o<Number(e.dataset.min)||o>Number(e.dataset.max))return null;var n=s.a.DomUtil.get(this._addUID("GPmousePosition"+t+"Direction")).value,a=s.a.DomUtil.get(this._addUID("GPmousePosition"+t+"Minutes")),r=a.value;if(r&&(r=r.replace(",","."),c.default.isInteger(r))){var l=c.default.toInteger(r);l>=Number(a.dataset.min)&&l<=Number(a.dataset.max)&&(o+=l/60)}var u=s.a.DomUtil.get(this._addUID("GPmousePosition"+t+"Seconds")),h=u.value;if(h){h=h.replace(",",".");var d=c.default.toFloat(h);d&&d>=Number(u.dataset.min)&&d<=Number(u.dataset.max)&&(o+=d/3600)}return"O"!==n&&"S"!==n||(o=-o),o},_locateDMSCoordinates:function(){var t={lat:this._getCoordinate("Lat"),lng:this._getCoordinate("Lon")};this.validateExtentCoordinate("Lon",t.lng)&&(this.validateExtentCoordinate("Lat",t.lat)&&this._map.panTo(t))},_locateCoordinates:function(){var t=s.a.DomUtil.get(this._addUID("GPmousePositionLon")).value;if(t=t.replace(",","."),t=parseFloat(t),!isNaN(t)){var e=s.a.DomUtil.get(this._addUID("GPmousePositionLat")).value;if(e=e.replace(",","."),e=parseFloat(e),!isNaN(e)){var i=null,o=null,n=null,a=null;if("Geographical"===this._currentProjectionType?(i=t,o=e):(n=e,a=t),this.validateExtentCoordinate("Lon",i||n)&&this.validateExtentCoordinate("Lat",o||a)){var r=this._currentProjectionUnits,l=this._unproject({x:this._convertCoordinate(null!==i?i:n,r),y:this._convertCoordinate(null!==o?o:a,r)});this._map.panTo(l)}}}},onMousePositionEditModeLocateClick:function(){this.options.editCoordinates&&(this._isEditing?"DMS"===this._currentProjectionUnits?this._locateDMSCoordinates():this._locateCoordinates():this.onMousePositionEditModeClick(!0))},onMousePositionProjectionSystemChange:function(t){m.log("onMousePositionProjectionSystemChange",t);var e=t.target.selectedIndex,i=t.target.options[e].value,o=t.target.options[e].label;m.log(e,i,o),this._setCurrentSystem(i)},_setCurrentSystem:function(t){for(var e=null,i=0;i<this._projectionSystems.length;++i)if(this._projectionSystems[i].code===Number(t)){e=this._projectionSystems[i].type;break}e?(e!==this._currentProjectionType&&this._setTypeUnitsPanel(e),this._currentProjectionSystems=this._projectionSystems[Number(t)],this._isDesktop||this.onMapMove()):m.log("system not found in projection systems container")},onMousePositionProjectionSystemMouseOver:function(t){m.log("onMousePositionProjectionSystemMouseOver",t);var e=this._map;if(e){var i=s.a.DomUtil.get(this._addUID("GPmousePositionProjectionSystem"));i.innerHTML="";for(var o=0;o<this._projectionSystems.length;o++){var n=this._projectionSystems[o],a=null;n.geoBBox&&(e.getBounds()._southWest.lng>n.geoBBox.right||e.getBounds()._southWest.lat>n.geoBBox.top||e.getBounds()._northEast.lng<n.geoBBox.left||e.getBounds()._northEast.lat<n.geoBBox.bottom)?n===this._currentProjectionSystems&&((a=document.createElement("option")).value=n.code,a.text=n.label||o,a.setAttribute("selected","selected"),a.setAttribute("disabled","disabled"),i.appendChild(a)):((a=document.createElement("option")).value=n.code,a.text=n.label||o,n===this._currentProjectionSystems&&a.setAttribute("selected","selected"),i.appendChild(a))}}},onMousePositionProjectionUnitsChange:function(t){m.log("onMousePositionProjectionUnitsChange",t);var e=t.target.selectedIndex,i=t.target.options[e].value,o=t.target.options[e].label;m.log(e,i,o);var n=this._currentProjectionUnits,s=this._currentProjectionUnits=i,a=this._currentProjectionType;this._resetLabelElements(a),this._resetUnitElements(s),"DMS"!==n&&"DMS"!==s||(this._resetCoordinateElements(this.options.editCoordinates,a,s),this._setEditMode(this._isEditing)),this._isDesktop||this.onMapMove()},moveTo:function(t,e,i){this._showContainer.checked||this._pictoContainer.click();var o=this._map;o&&(this.onMouseMove({latlng:t}),o.flyTo(t,e||10,i||{}))}});e.default=f},function(t,e,i){"use strict";i.r(e);var o={modulo:function(t,e){var i=t%e;return i*e<0?i+e:i},decimalToDMS:function(t,e,i){var o=this.modulo(t+180,360)-180,n=Math.abs(3600*o),s=i||0,a=Math.pow(10,s),r=Math.floor(n/3600),l=Math.floor((n-3600*r)/60),c=n-3600*r-60*l;return(c=Math.ceil(c*a)/a)>=60&&(c=0,l+=1),l>=60&&(l=0,r+=1),{d:r,m:l,s:c,direction:e.charAt(o<0?1:0)}},toInteger:function(t,e){var i=parseInt(t,e||10);return!isNaN(i)&&isFinite(i)?i:null},isInteger:function(t){if(isNaN(t))return!1;var e=parseFloat(t);return(0|e)===e},toFloat:function(t){var e=parseFloat(t);return!isNaN(e)&&isFinite(e)?e:null}};e.default=o},function(t,e,i){"use strict";function o(t){return(o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}i.r(e);var n={_addUID:function(t){return this._uid?t+"-"+this._uid:t},_createMainContainerElement:function(){var t=document.createElement("div");return t.id=this._addUID("GPmousePosition"),t.className="GPwidget",t},_createShowMousePositionElement:function(){var t=document.createElement("input");return t.id=this._addUID("GPshowMousePosition"),t.type="checkbox",t},_createShowMousePositionPictoElement:function(t){var e=this,i=document.createElement("label");i.id=this._addUID("GPshowMousePositionPicto"),i.className="GPshowAdvancedToolPicto",i.htmlFor=this._addUID("GPshowMousePosition"),i.title="Afficher les coordonnées du curseur",i.addEventListener("click",(function(i){var o="";document.getElementById(e._addUID("GPshowMousePosition")).checked||t||(o="GPmapCenterVisible"),document.getElementById("GPmapCenter").className=o,e.onShowMousePositionClick(i)}));var o=document.createElement("span");return o.id=this._addUID("GPshowMousePositionOpen"),o.className="GPshowAdvancedToolOpen",i.appendChild(o),i},_createMousePositionPanelElement:function(){var t=document.createElement("div");return t.id=this._addUID("GPmousePositionPanel"),t.className="GPpanel",t},_createMapCenter:function(){var t=document.createElement("div");return t.id="GPmapCenter",t.className="",t},_createMousePositionPanelHeaderElement:function(){var t=document.createElement("div");t.className="GPpanelHeader";var e=document.createElement("div");e.className="GPpanelTitle",e.innerHTML="Coordonnées",t.appendChild(e);var i=document.createElement("div");i.id="GPmousePositionPanelClose",i.className="GPpanelClose",i.title="Fermer le panneau";var o=this;return i.addEventListener?i.addEventListener("click",(function(){document.getElementById(o._addUID("GPshowMousePositionPicto")).click()}),!1):i.attachEvent&&i.attachEvent("onclick",(function(){document.getElementById(o._addUID("GPshowMousePositionPicto")).click()})),t.appendChild(i),t},_createMousePositionPanelBasicElement:function(t,e,i,o){t=void 0===t||t,e=void 0===e||e,i=void 0!==i&&i;var n=document.createElement("div");return n.id=this._addUID("GPmousePositionBasicPanel"),n.appendChild(this._createMousePositionPanelBasicCoordinateElement(e,i,o)),n.appendChild(this._createMousePositionPanelEditToolsElement(i)),n.appendChild(this._createMousePositionPanelBasicAltitudeElement(t)),n},_createCoordinateElement:function(t,e){var i=this;if(-1===["Lon","Lat"].indexOf(t))return[];var o=[],n=document.createElement("input");n.id=this._addUID("GPmousePosition"+t),n.title=!0===e?"Cliquer pour saisir des coordonnées":"",n.readOnly=!0,e&&(n.addEventListener("click",(function(){i.onMousePositionEditModeClick(!0)})),n.addEventListener("change",(function(e){this.classList.remove("error"),i.validateExtentCoordinate(t,this.value,e)?this.classList.remove("error"):this.classList.add("error")}))),o.push(n);var s=document.createElement("span");return s.className="GPmousePositionUnits",o.push(s),o},_createDMSCoordinateElement:function(t,e){if(-1===["Lon","Lat"].indexOf(t))return[];var i=this,o=[],n=document.createElement("input");n.id=this._addUID("GPmousePosition"+t+"Degrees"),n.className="GPSexagesimal",n.setAttribute("name","degrees"),n.title=!0===e?"Cliquer pour saisir des coordonnées":"",n.readOnly=!0,n.dataset.min=0,n.dataset.max="Lon"===t?180:90,e&&(n.addEventListener("click",(function(){i.onMousePositionEditModeClick(!0)})),n.addEventListener("change",(function(){this.classList.remove("error"),i._checkDMSDegrees(t,this)?this.classList.remove("error"):this.classList.add("error")}))),o.push(n);var s=document.createElement("span");s.className="GPmousePositionSexagesimalLabel",s.innerHTML="°",o.push(s);var a=document.createElement("input");a.id=this._addUID("GPmousePosition"+t+"Minutes"),a.className="GPSexagesimal",a.setAttribute("name","minutes"),a.title=!0===e?"Cliquer pour saisir des coordonnées":"",a.readOnly=!0,a.dataset.min=0,a.dataset.max=59,e&&(a.addEventListener("click",(function(){i.onMousePositionEditModeClick(!0)})),a.addEventListener("change",(function(){this.classList.remove("error"),i._checkDMSElement(this)?this.classList.remove("error"):this.classList.add("error")}))),o.push(a);var r=document.createElement("span");r.className="GPmousePositionSexagesimalLabel",r.innerHTML="'",o.push(r);var l=document.createElement("input");l.id=this._addUID("GPmousePosition"+t+"Seconds"),l.className="GPSexagesimalsec",l.setAttribute("name","seconds"),l.title=!0===e?"Cliquer pour saisir des coordonnées":"",l.readOnly=!0,l.dataset.min=0,l.dataset.max=59,e&&(l.addEventListener("click",(function(){i.onMousePositionEditModeClick(!0)})),l.addEventListener("change",(function(){this.classList.remove("error"),i._checkDMSElement(this,!0)?this.classList.remove("error"):this.classList.add("error")}))),o.push(l);var c=document.createElement("span");c.className="GPmousePositionSexagesimalLabel",c.innerHTML="''",o.push(c);var u=document.createElement("select");u.id=this._addUID("GPmousePosition"+t+"Direction"),u.className="GPmousePositionDirection",u.setAttribute("name","direction"),u.disabled=!0;var h=document.createElement("option");h.value="Lon"===t?"E":"N",h.innerHTML="Lon"===t?"E":"N",u.appendChild(h);var d=document.createElement("option");return d.value="Lon"===t?"O":"S",d.innerHTML="Lon"===t?"O":"S",u.appendChild(d),o.push(u),o},_createMousePositionPanelBasicCoordinateElement:function(t,e,i){var o=document.createElement("div");o.id=this._addUID("GPmousePositionCoordinate"),o.style.display=t?"block":"none";var n=document.createElement("div"),s=document.createElement("span");s.className="GPmousePositionLabel",s.id=this._addUID("GPmousePositionLatLabel"),s.innerHTML="Latitude : ",n.appendChild(s);var a,r=document.createElement("span");r.id=this._addUID("GPmousePositionLatCoordinate"),a="DMS"===i?this._createDMSCoordinateElement("Lat",e):this._createCoordinateElement("Lat",e);for(var l=0;l<a.length;l++)r.appendChild(a[l]);n.appendChild(r),o.appendChild(n);var c=document.createElement("div"),u=document.createElement("span");u.className="GPmousePositionLabel",u.id=this._addUID("GPmousePositionLonLabel"),u.innerHTML="Longitude : ",c.appendChild(u);var h,d=document.createElement("span");d.id=this._addUID("GPmousePositionLonCoordinate"),h="DMS"===i?this._createDMSCoordinateElement("Lon",e):this._createCoordinateElement("Lon",e);for(var p=0;p<h.length;p++)d.appendChild(h[p]);return c.appendChild(d),o.appendChild(c),o},_createMousePositionPanelBasicAltitudeElement:function(t){var e=document.createElement("div");e.id=this._addUID("GPmousePositionAltitude"),e.style.display=t?"block":"none";var i=document.createElement("span");i.className="GPmousePositionLabel",i.innerHTML="Altitude : ",e.appendChild(i);var o=document.createElement("span");o.className="GPmousePositionCoords",o.id=this._addUID("GPmousePositionAlt"),o.innerHTML="...",e.appendChild(o);var n=document.createElement("span");return n.className="GPmousePositionAltitudeUnits",n.innerHTML="m",e.appendChild(n),e},_createMousePositionPanelEditToolsElement:function(t){var e=this,i=document.createElement("div");i.className="GPmousePositionPanelEditTools",i.id=this._addUID("GPmousePositionPanelEditTools"),t||(i.style.display="none");var o=document.createElement("span");o.className="GPmousePositionEditTool",o.id=this._addUID("GPmousePositionLocate"),o.title=!0===t?"Cliquer pour saisir des coordonnées":"",t&&o.addEventListener("click",(function(){e.onMousePositionEditModeLocateClick()})),i.appendChild(o);var n=document.createElement("span");return n.className="GPmousePositionEditTool",n.id=this._addUID("GPmousePositionCloseEdit"),n.title="Quitter la saisie des coordonnées",n.style.display="none",t&&n.addEventListener("click",(function(){e.onMousePositionEditModeClick(!1)})),i.appendChild(n),i},_createShowMousePositionSettingsElement:function(t){var e=[],i=this,o=document.createElement("input");o.type="checkbox",o.id=this._addUID("GPshowMousePositionSettings");var n=document.createElement("label");return n.id=this._addUID("GPshowMousePositionSettingsPicto"),n.htmlFor=this._addUID("GPshowMousePositionSettings"),n.title="Réglages",n.className="GPshowMoreOptionsImage GPshowMoreOptions GPshowMousePositionSettingsPicto",n.style.display=t?"block":"none",n.addEventListener?n.addEventListener("click",(function(t){"function"==typeof i.onShowMousePositionSettingsClick&&i.onShowMousePositionSettingsClick(t)}),!1):n.attachEvent&&n.attachEvent("onclick",(function(t){"function"==typeof i.onShowMousePositionSettingsClick&&i.onShowMousePositionSettingsClick(t)})),e.push(o),e.push(n),e},_createMousePositionSettingsElement:function(t){var e=document.createElement("div");e.id=this._addUID("GPmousePositionSettings"),e.style.display=void 0===t||t?"block":"none";var i=document.createElement("span");return i.className="GPmousePositionSettingsLabel",i.innerHTML="Système de référence",e.appendChild(i),e},_createMousePositionSettingsSystemsElement:function(t){var e=this,i=document.createElement("select");i.id=this._addUID("GPmousePositionProjectionSystem"),i.className="GPinputSelect GPmousePositionSettingsSelect",i.addEventListener("change",(function(t){e.onMousePositionProjectionSystemChange(t)})),i.addEventListener("mouseover",(function(t){"OPTION"!==t.target.nodeName&&e.onMousePositionProjectionSystemMouseOver(t)}));for(var o=0;o<t.length;o++){var n=t[o],s=document.createElement("option");s.value=n.code,s.text=n.label||o,i.appendChild(s)}return i},_createMousePositionSettingsUnitsElement:function(t){var e=this,i=document.createElement("select");i.id=this._addUID("GPmousePositionProjectionUnits"),i.className="GPinputSelect GPmousePositionSettingsSelect",i.addEventListener("change",(function(t){e.onMousePositionProjectionUnitsChange(t)}));for(var o=0;o<t.length;o++){var n=t[o],s=document.createElement("option");s.value=n.code?n.code:o,s.text=n.label||o,i.appendChild(s)}return i},_resetLabelElements:function(t){document.getElementById(this._addUID("GPmousePositionLatLabel")).innerHTML="Geographical"===t?"Latitude :":"X :",document.getElementById(this._addUID("GPmousePositionLonLabel")).innerHTML="Geographical"===t?"Longitude :":"Y :"},_resetUnitElements:function(t){var e="";"M"!==t&&"KM"!==t||(e=t.toLowerCase());for(var i=document.getElementsByClassName("GPmousePositionUnits"),o=0;o<i.length;o++)i[o].innerHTML=e},_resetCoordinateElements:function(t,e,i){for(var o,n=document.getElementById(this._addUID("GPmousePositionLatCoordinate"));n.firstChild;)n.removeChild(n.firstChild);o="DMS"===i?this._createDMSCoordinateElement("Lat",t):this._createCoordinateElement("Lat",t);for(var s=0;s<o.length;s++)n.appendChild(o[s]);for(var a,r=document.getElementById(this._addUID("GPmousePositionLonCoordinate"));r.firstChild;)r.removeChild(r.firstChild);a="DMS"===i?this._createDMSCoordinateElement("Lon",t):this._createCoordinateElement("Lon",t);for(var l=0;l<a.length;l++)r.appendChild(a[l])},_setEditMode:function(t){document.getElementById(this._addUID("GPmousePositionLocate")).title=t?"Aller à la position ...":"Cliquer pour saisir des coordonnées",document.getElementById(this._addUID("GPmousePositionCloseEdit")).style.display=t?"inline-block":"none";for(var e="div[id^="+this._addUID("GPmousePositionCoordinate")+"]",i=document.querySelectorAll(e+" input"),o=0;o<i.length;o++)i[o].readOnly=!t,t&&(i[o].value="",i[o].classList.remove("error"));for(var n=document.querySelectorAll(e+" select"),s=0;s<n.length;s++)n[s].disabled=!t},_checkDMSElement:function(t,e){var i=void 0!==e,o=t.value;if(i&&(o=o.replace(",",".")),isNaN(o))return!1;var n=parseFloat(o);if(!i&&(0|n)!==n)return!1;var s=Number(t.dataset.min),a=Number(t.dataset.max);return n>=s&&n<=a},_checkDMSDegrees:function(t,e){if(isNaN(e.value))return!1;var i=parseFloat(e.value);if((0|i)!==i)return!1;var o=Number(e.dataset.min),n=Number(e.dataset.max);if(i<o||i>n)return!1;var s=document.getElementById(this._addUID("GPmousePosition"+t+"Minutes")),a=document.getElementById(this._addUID("GPmousePosition"+t+"Seconds"));return i>=n?(s.dataset.max=0,a.dataset.max=0):(s.dataset.max=59,a.dataset.max=59.9999),!0},GPdisplayCoords:function(t){if(t&&null!=t){var e=document.getElementById(this._addUID("GPmousePositionLonLabel")),i=document.getElementById(this._addUID("GPmousePositionLatLabel"));if(t.x||t.y?(i.innerHTML="X : ",e.innerHTML="Y : "):t.e||t.n?(i.innerHTML="E : ",e.innerHTML="N : "):(i.innerHTML="Latitude : ",e.innerHTML="Longitude : "),"object"===o(t.lat)&&"object"===o(t.lng)){var n={lng:"Lon",lat:"Lat"},s=["Degrees","Minutes","Seconds"];for(var a in n)for(var r=0;r<s.length;++r){var l="GPmousePosition"+n[a]+s[r],c=document.getElementById(this._addUID(l)),u=s[r].charAt(0).toLowerCase();c.value=t[a][u]}document.getElementById(this._addUID("GPmousePositionLonDirection")).value=t.lng.direction,document.getElementById(this._addUID("GPmousePositionLatDirection")).value=t.lat.direction}else{var h=document.getElementById(this._addUID("GPmousePositionLat")),d=document.getElementById(this._addUID("GPmousePositionLon"));h.value=t.x||t.lat||t.e||"0",d.value=t.y||t.lng||t.lon||t.n||"0";for(var p=void 0===t.unit?"":t.unit,m=document.getElementsByClassName("GPmousePositionUnits"),f=0;f<m.length;++f)m[f].innerHTML=p}}},GPdisplayElevation:function(t,e,i,o){var n,s=this;e||(e=500),clearTimeout(n),document.getElementById(this._addUID("GPmousePositionAlt")).innerHTML="...",null==i&&(i=-99999),null==o&&(o=99980);var a=i+o,r=i-o;t&&null!=t&&document.getElementById(this._addUID("GPmousePositionAltitude"))&&(n=setTimeout((function(){s.onRequestAltitude(t,(function(t){r<t&&t<a?s.GPresetElevation():document.getElementById(s._addUID("GPmousePositionAlt")).innerHTML=t}))}),e))},GPresetElevation:function(){document.getElementById(this._addUID("GPmousePositionAltitude"))&&(document.getElementById(this._addUID("GPmousePositionAlt")).innerHTML="---")}};e.default=n},function(t,e,i){"use strict";i.r(e);var o=i(151),n=i.n(o),s=(i(153),i(154)),a=i(155),r=i(156),l=i(157);s.default.load(n.a);var c={EPSG2154:function(){return a.default.build()},EPSG27572:function(){return r.default.build()},EPSG4326:function(){return l.default.build()}};e.default=c},function(t,e,i){(function(e){t.exports=e.proj4=i(152)}).call(this,i(52))},function(t,e,i){t.exports=function(){"use strict";var t=1,e=2,i=4,o=5,n=484813681109536e-20,s=Math.PI/2,a=.16666666666666666,r=.04722222222222222,l=.022156084656084655,c=1e-10,u=.017453292519943295,h=57.29577951308232,d=Math.PI/4,p=2*Math.PI,m=3.14159265359,f={greenwich:0,lisbon:-9.131906111111,paris:2.337229166667,bogota:-74.080916666667,madrid:-3.687938888889,rome:12.452333333333,bern:7.439583333333,jakarta:106.807719444444,ferro:-17.666666666667,brussels:4.367975,stockholm:18.058277777778,athens:23.7163375,oslo:10.722916666667},_={ft:{to_meter:.3048},"us-ft":{to_meter:1200/3937}},g=/[\s_\-\/\(\)]/g;function v(t,e){if(t[e])return t[e];for(var i,o=Object.keys(t),n=e.toLowerCase().replace(g,""),s=-1;++s<o.length;)if((i=o[s]).toLowerCase().replace(g,"")===n)return t[i]}var y=function(t){var e,i,o,n={},s=t.split("+").map((function(t){return t.trim()})).filter((function(t){return t})).reduce((function(t,e){var i=e.split("=");return i.push(!0),t[i[0].toLowerCase()]=i[1],t}),{}),a={proj:"projName",datum:"datumCode",rf:function(t){n.rf=parseFloat(t)},lat_0:function(t){n.lat0=t*u},lat_1:function(t){n.lat1=t*u},lat_2:function(t){n.lat2=t*u},lat_ts:function(t){n.lat_ts=t*u},lon_0:function(t){n.long0=t*u},lon_1:function(t){n.long1=t*u},lon_2:function(t){n.long2=t*u},alpha:function(t){n.alpha=parseFloat(t)*u},lonc:function(t){n.longc=t*u},x_0:function(t){n.x0=parseFloat(t)},y_0:function(t){n.y0=parseFloat(t)},k_0:function(t){n.k0=parseFloat(t)},k:function(t){n.k0=parseFloat(t)},a:function(t){n.a=parseFloat(t)},b:function(t){n.b=parseFloat(t)},r_a:function(){n.R_A=!0},zone:function(t){n.zone=parseInt(t,10)},south:function(){n.utmSouth=!0},towgs84:function(t){n.datum_params=t.split(",").map((function(t){return parseFloat(t)}))},to_meter:function(t){n.to_meter=parseFloat(t)},units:function(t){n.units=t;var e=v(_,t);e&&(n.to_meter=e.to_meter)},from_greenwich:function(t){n.from_greenwich=t*u},pm:function(t){var e=v(f,t);n.from_greenwich=(e||parseFloat(t))*u},nadgrids:function(t){"@null"===t?n.datumCode="none":n.nadgrids=t},axis:function(t){3===t.length&&-1!=="ewnsud".indexOf(t.substr(0,1))&&-1!=="ewnsud".indexOf(t.substr(1,1))&&-1!=="ewnsud".indexOf(t.substr(2,1))&&(n.axis=t)}};for(e in s)i=s[e],e in a?"function"==typeof(o=a[e])?o(i):n[o]=i:n[e]=i;return"string"==typeof n.datumCode&&"WGS84"!==n.datumCode&&(n.datumCode=n.datumCode.toLowerCase()),n},E=1,P=/\s/,w=/[A-Za-z]/,C=/[A-Za-z84]/,M=/[,\]]/,S=/[\d\.E\-\+]/;function L(t){if("string"!=typeof t)throw new Error("not a string");this.text=t.trim(),this.level=0,this.place=0,this.root=null,this.stack=[],this.currentObject=null,this.state=E}function b(t,e,i){Array.isArray(e)&&(i.unshift(e),e=null);var o=e?{}:t,n=i.reduce((function(t,e){return R(e,t),t}),o);e&&(t[e]=n)}function R(t,e){if(Array.isArray(t)){var i=t.shift();if("PARAMETER"===i&&(i=t.shift()),1===t.length)return Array.isArray(t[0])?(e[i]={},void R(t[0],e[i])):void(e[i]=t[0]);if(t.length)if("TOWGS84"!==i){if("AXIS"===i)return i in e||(e[i]=[]),void e[i].push(t);var o;switch(Array.isArray(i)||(e[i]={}),i){case"UNIT":case"PRIMEM":case"VERT_DATUM":return e[i]={name:t[0].toLowerCase(),convert:t[1]},void(3===t.length&&R(t[2],e[i]));case"SPHEROID":case"ELLIPSOID":return e[i]={name:t[0],a:t[1],rf:t[2]},void(4===t.length&&R(t[3],e[i]));case"PROJECTEDCRS":case"PROJCRS":case"GEOGCS":case"GEOCCS":case"PROJCS":case"LOCAL_CS":case"GEODCRS":case"GEODETICCRS":case"GEODETICDATUM":case"EDATUM":case"ENGINEERINGDATUM":case"VERT_CS":case"VERTCRS":case"VERTICALCRS":case"COMPD_CS":case"COMPOUNDCRS":case"ENGINEERINGCRS":case"ENGCRS":case"FITTED_CS":case"LOCAL_DATUM":case"DATUM":return t[0]=["name",t[0]],void b(e,i,t);default:for(o=-1;++o<t.length;)if(!Array.isArray(t[o]))return R(t,e[i]);return b(e,i,t)}}else e[i]=t;else e[i]=!0}else e[t]=!0}L.prototype.readCharicter=function(){var t=this.text[this.place++];if(4!==this.state)for(;P.test(t);){if(this.place>=this.text.length)return;t=this.text[this.place++]}switch(this.state){case E:return this.neutral(t);case 2:return this.keyword(t);case 4:return this.quoted(t);case 5:return this.afterquote(t);case 3:return this.number(t);case-1:return}},L.prototype.afterquote=function(t){if('"'===t)return this.word+='"',void(this.state=4);if(M.test(t))return this.word=this.word.trim(),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in afterquote yet, index '+this.place)},L.prototype.afterItem=function(t){return","===t?(null!==this.word&&this.currentObject.push(this.word),this.word=null,void(this.state=E)):"]"===t?(this.level--,null!==this.word&&(this.currentObject.push(this.word),this.word=null),this.state=E,this.currentObject=this.stack.pop(),void(this.currentObject||(this.state=-1))):void 0},L.prototype.number=function(t){if(!S.test(t)){if(M.test(t))return this.word=parseFloat(this.word),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in number yet, index '+this.place)}this.word+=t},L.prototype.quoted=function(t){'"'!==t?this.word+=t:this.state=5},L.prototype.keyword=function(t){if(C.test(t))this.word+=t;else{if("["===t){var e=[];return e.push(this.word),this.level++,null===this.root?this.root=e:this.currentObject.push(e),this.stack.push(this.currentObject),this.currentObject=e,void(this.state=E)}if(!M.test(t))throw new Error("havn't handled \""+t+'" in keyword yet, index '+this.place);this.afterItem(t)}},L.prototype.neutral=function(t){if(w.test(t))return this.word=t,void(this.state=2);if('"'===t)return this.word="",void(this.state=4);if(S.test(t))return this.word=t,void(this.state=3);if(!M.test(t))throw new Error("havn't handled \""+t+'" in neutral yet, index '+this.place);this.afterItem(t)},L.prototype.output=function(){for(;this.place<this.text.length;)this.readCharicter();if(-1===this.state)return this.root;throw new Error('unable to parse string "'+this.text+'". State is '+this.state)};var x=.017453292519943295;function I(t){return t*x}var G=function(t){var e=new L(t).output(),i=e.shift(),o=e.shift();e.unshift(["name",o]),e.unshift(["type",i]);var n={};return R(e,n),function(t){if("GEOGCS"===t.type?t.projName="longlat":"LOCAL_CS"===t.type?(t.projName="identity",t.local=!0):"object"==typeof t.PROJECTION?t.projName=Object.keys(t.PROJECTION)[0]:t.projName=t.PROJECTION,t.AXIS){for(var e="",i=0,o=t.AXIS.length;i<o;++i){var n=t.AXIS[i][0].toLowerCase();-1!==n.indexOf("north")?e+="n":-1!==n.indexOf("south")?e+="s":-1!==n.indexOf("east")?e+="e":-1!==n.indexOf("west")&&(e+="w")}2===e.length&&(e+="u"),3===e.length&&(t.axis=e)}t.UNIT&&(t.units=t.UNIT.name.toLowerCase(),"metre"===t.units&&(t.units="meter"),t.UNIT.convert&&("GEOGCS"===t.type?t.DATUM&&t.DATUM.SPHEROID&&(t.to_meter=t.UNIT.convert*t.DATUM.SPHEROID.a):t.to_meter=t.UNIT.convert));var s=t.GEOGCS;function a(e){return e*(t.to_meter||1)}"GEOGCS"===t.type&&(s=t),s&&(s.DATUM?t.datumCode=s.DATUM.name.toLowerCase():t.datumCode=s.name.toLowerCase(),"d_"===t.datumCode.slice(0,2)&&(t.datumCode=t.datumCode.slice(2)),"new_zealand_geodetic_datum_1949"!==t.datumCode&&"new_zealand_1949"!==t.datumCode||(t.datumCode="nzgd49"),"wgs_1984"!==t.datumCode&&"world_geodetic_system_1984"!==t.datumCode||("Mercator_Auxiliary_Sphere"===t.PROJECTION&&(t.sphere=!0),t.datumCode="wgs84"),"_ferro"===t.datumCode.slice(-6)&&(t.datumCode=t.datumCode.slice(0,-6)),"_jakarta"===t.datumCode.slice(-8)&&(t.datumCode=t.datumCode.slice(0,-8)),~t.datumCode.indexOf("belge")&&(t.datumCode="rnb72"),s.DATUM&&s.DATUM.SPHEROID&&(t.ellps=s.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),"international"===t.ellps.toLowerCase().slice(0,13)&&(t.ellps="intl"),t.a=s.DATUM.SPHEROID.a,t.rf=parseFloat(s.DATUM.SPHEROID.rf,10)),s.DATUM&&s.DATUM.TOWGS84&&(t.datum_params=s.DATUM.TOWGS84),~t.datumCode.indexOf("osgb_1936")&&(t.datumCode="osgb36"),~t.datumCode.indexOf("osni_1952")&&(t.datumCode="osni52"),(~t.datumCode.indexOf("tm65")||~t.datumCode.indexOf("geodetic_datum_of_1965"))&&(t.datumCode="ire65"),"ch1903+"===t.datumCode&&(t.datumCode="ch1903"),~t.datumCode.indexOf("israel")&&(t.datumCode="isr93")),t.b&&!isFinite(t.b)&&(t.b=t.a),[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_2","Standard_Parallel_2"],["false_easting","False_Easting"],["false_northing","False_Northing"],["central_meridian","Central_Meridian"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_Of_Center"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",I],["longitude_of_center","Longitude_Of_Center"],["longitude_of_center","Longitude_of_center"],["longc","longitude_of_center",I],["x0","false_easting",a],["y0","false_northing",a],["long0","central_meridian",I],["lat0","latitude_of_origin",I],["lat0","standard_parallel_1",I],["lat1","standard_parallel_1",I],["lat2","standard_parallel_2",I],["azimuth","Azimuth"],["alpha","azimuth",I],["srsCode","name"]].forEach((function(e){return function(t,e){var i=e[0],o=e[1];!(i in t)&&o in t&&(t[i]=t[o],3===e.length&&(t[i]=e[2](t[i])))}(t,e)})),t.long0||!t.longc||"Albers_Conic_Equal_Area"!==t.projName&&"Lambert_Azimuthal_Equal_Area"!==t.projName||(t.long0=t.longc),t.lat_ts||!t.lat1||"Stereographic_South_Pole"!==t.projName&&"Polar Stereographic (variant B)"!==t.projName||(t.lat0=I(t.lat1>0?90:-90),t.lat_ts=t.lat1)}(n),n};function A(t){var e=this;if(2===arguments.length){var i=arguments[1];"string"==typeof i?"+"===i.charAt(0)?A[t]=y(arguments[1]):A[t]=G(arguments[1]):A[t]=i}else if(1===arguments.length){if(Array.isArray(t))return t.map((function(t){Array.isArray(t)?A.apply(e,t):A(t)}));if("string"==typeof t){if(t in A)return A[t]}else"EPSG"in t?A["EPSG:"+t.EPSG]=t:"ESRI"in t?A["ESRI:"+t.ESRI]=t:"IAU2000"in t?A["IAU2000:"+t.IAU2000]=t:console.log(t);return}}!function(t){t("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),t("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),t("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"),t.WGS84=t["EPSG:4326"],t["EPSG:3785"]=t["EPSG:3857"],t.GOOGLE=t["EPSG:3857"],t["EPSG:900913"]=t["EPSG:3857"],t["EPSG:102113"]=t["EPSG:3857"]}(A);var T=["PROJECTEDCRS","PROJCRS","GEOGCS","GEOCCS","PROJCS","LOCAL_CS","GEODCRS","GEODETICCRS","GEODETICDATUM","ENGCRS","ENGINEERINGCRS"],k=["3857","900913","3785","102113"];function D(t){if(!function(t){return"string"==typeof t}(t))return t;if(function(t){return t in A}(t))return A[t];if(function(t){return T.some((function(e){return t.indexOf(e)>-1}))}(t)){var e=G(t);if(function(t){var e=v(t,"authority");if(e){var i=v(e,"epsg");return i&&k.indexOf(i)>-1}}(e))return A["EPSG:3857"];var i=function(t){var e=v(t,"extension");if(e)return v(e,"proj4")}(e);return i?y(i):e}return function(t){return"+"===t[0]}(t)?y(t):void 0}var O=function(t,e){var i,o;if(t=t||{},!e)return t;for(o in e)void 0!==(i=e[o])&&(t[o]=i);return t},N=function(t,e,i){var o=t*e;return i/Math.sqrt(1-o*o)},U=function(t){return t<0?-1:1},j=function(t){return Math.abs(t)<=m?t:t-U(t)*p},F=function(t,e,i){var o=t*i,n=.5*t;return o=Math.pow((1-o)/(1+o),n),Math.tan(.5*(s-e))/o},B=function(t,e){for(var i,o,n=.5*t,a=s-2*Math.atan(e),r=0;r<=15;r++)if(i=t*Math.sin(a),a+=o=s-2*Math.atan(e*Math.pow((1-i)/(1+i),n))-a,Math.abs(o)<=1e-10)return a;return-9999};function z(t){return t}var q=[{init:function(){var t=this.b/this.a;this.es=1-t*t,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=N(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)},forward:function(t){var e,i,o=t.x,n=t.y;if(n*h>90&&n*h<-90&&o*h>180&&o*h<-180)return null;if(Math.abs(Math.abs(n)-s)<=c)return null;if(this.sphere)e=this.x0+this.a*this.k0*j(o-this.long0),i=this.y0+this.a*this.k0*Math.log(Math.tan(d+.5*n));else{var a=Math.sin(n),r=F(this.e,n,a);e=this.x0+this.a*this.k0*j(o-this.long0),i=this.y0-this.a*this.k0*Math.log(r)}return t.x=e,t.y=i,t},inverse:function(t){var e,i,o=t.x-this.x0,n=t.y-this.y0;if(this.sphere)i=s-2*Math.atan(Math.exp(-n/(this.a*this.k0)));else{var a=Math.exp(-n/(this.a*this.k0));if(-9999===(i=B(this.e,a)))return null}return e=j(this.long0+o/(this.a*this.k0)),t.x=e,t.y=i,t},names:["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"]},{init:function(){},forward:z,inverse:z,names:["longlat","identity"]}],H={},W=[];function V(t,e){var i=W.length;return t.names?(W[i]=t,t.names.forEach((function(t){H[t.toLowerCase()]=i})),this):(console.log(e),!0)}var Y={start:function(){q.forEach(V)},add:V,get:function(t){if(!t)return!1;var e=t.toLowerCase();return void 0!==H[e]&&W[H[e]]?W[H[e]]:void 0}},X={MERIT:{a:6378137,rf:298.257,ellipseName:"MERIT 1983"},SGS85:{a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},GRS80:{a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},IAU76:{a:6378140,rf:298.257,ellipseName:"IAU 1976"},airy:{a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},APL4:{a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},NWL9D:{a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},mod_airy:{a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},andrae:{a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},aust_SA:{a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},GRS67:{a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},bessel:{a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},bess_nam:{a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},clrk66:{a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},clrk80:{a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},clrk58:{a:6378293.645208759,rf:294.2606763692654,ellipseName:"Clarke 1858"},CPM:{a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},delmbr:{a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},engelis:{a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},evrst30:{a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},evrst48:{a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},evrst56:{a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},evrst69:{a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},evrstSS:{a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},fschr60:{a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},fschr60m:{a:6378155,rf:298.3,ellipseName:"Fischer 1960"},fschr68:{a:6378150,rf:298.3,ellipseName:"Fischer 1968"},helmert:{a:6378200,rf:298.3,ellipseName:"Helmert 1906"},hough:{a:6378270,rf:297,ellipseName:"Hough"},intl:{a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},kaula:{a:6378163,rf:298.24,ellipseName:"Kaula 1961"},lerch:{a:6378139,rf:298.257,ellipseName:"Lerch 1979"},mprts:{a:6397300,rf:191,ellipseName:"Maupertius 1738"},new_intl:{a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},plessis:{a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},krass:{a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},SEasia:{a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},walbeck:{a:6376896,b:6355834.8467,ellipseName:"Walbeck"},WGS60:{a:6378165,rf:298.3,ellipseName:"WGS 60"},WGS66:{a:6378145,rf:298.25,ellipseName:"WGS 66"},WGS7:{a:6378135,rf:298.26,ellipseName:"WGS 72"}},K=X.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"};X.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"};var Z={};function Q(s,u){if(!(this instanceof Q))return new Q(s);u=u||function(t){if(t)throw t};var h=D(s);if("object"==typeof h){var d=Q.projections.get(h.projName);if(d){if(h.datumCode&&"none"!==h.datumCode){var p=v(Z,h.datumCode);p&&(h.datum_params=p.towgs84?p.towgs84.split(","):null,h.ellps=p.ellipse,h.datumName=p.datumName?p.datumName:h.datumCode)}h.k0=h.k0||1,h.axis=h.axis||"enu",h.ellps=h.ellps||"wgs84";var m,f,_,g,y,E,P,w=function(t,e,i,o,n){if(!t){var s=v(X,o);s||(s=K),t=s.a,e=s.b,i=s.rf}return i&&!e&&(e=(1-1/i)*t),(0===i||Math.abs(t-e)<c)&&(n=!0,e=t),{a:t,b:e,rf:i,sphere:n}}(h.a,h.b,h.rf,h.ellps,h.sphere),C=(m=w.a,f=w.b,w.rf,_=h.R_A,E=((g=m*m)-(y=f*f))/g,P=0,_?(g=(m*=1-E*(a+E*(r+E*l)))*m,E=0):P=Math.sqrt(E),{es:E,e:P,ep2:(g-y)/y}),M=h.datum||function(s,a,r,l,c,u){var h={};return h.datum_type=void 0===s||"none"===s?o:i,a&&(h.datum_params=a.map(parseFloat),0===h.datum_params[0]&&0===h.datum_params[1]&&0===h.datum_params[2]||(h.datum_type=t),h.datum_params.length>3&&(0===h.datum_params[3]&&0===h.datum_params[4]&&0===h.datum_params[5]&&0===h.datum_params[6]||(h.datum_type=e,h.datum_params[3]*=n,h.datum_params[4]*=n,h.datum_params[5]*=n,h.datum_params[6]=h.datum_params[6]/1e6+1))),h.a=r,h.b=l,h.es=c,h.ep2=u,h}(h.datumCode,h.datum_params,w.a,w.b,C.es,C.ep2);O(this,h),O(this,d),this.a=w.a,this.b=w.b,this.rf=w.rf,this.sphere=w.sphere,this.es=C.es,this.e=C.e,this.ep2=C.ep2,this.datum=M,this.init(),u(null,this)}else u(s)}else u(s)}function J(t,e,i){var o,n,a,r,l=t.x,c=t.y,u=t.z?t.z:0;if(c<-s&&c>-1.001*s)c=-s;else if(c>s&&c<1.001*s)c=s;else{if(c<-s)return{x:-1/0,y:-1/0,z:t.z};if(c>s)return{x:1/0,y:1/0,z:t.z}}return l>Math.PI&&(l-=2*Math.PI),n=Math.sin(c),r=Math.cos(c),a=n*n,{x:((o=i/Math.sqrt(1-e*a))+u)*r*Math.cos(l),y:(o+u)*r*Math.sin(l),z:(o*(1-e)+u)*n}}function $(t,e,i,o){var n,s,a,r,l,c,u,h,d,p,m,f,_,g,v,y=t.x,E=t.y,P=t.z?t.z:0;if(n=Math.sqrt(y*y+E*E),s=Math.sqrt(y*y+E*E+P*P),n/i<1e-12){if(g=0,s/i<1e-12)return v=-o,{x:t.x,y:t.y,z:t.z}}else g=Math.atan2(E,y);a=P/s,h=(r=n/s)*(1-e)*(l=1/Math.sqrt(1-e*(2-e)*r*r)),d=a*l,_=0;do{_++,c=e*(u=i/Math.sqrt(1-e*d*d))/(u+(v=n*h+P*d-u*(1-e*d*d))),f=(m=a*(l=1/Math.sqrt(1-c*(2-c)*r*r)))*h-(p=r*(1-c)*l)*d,h=p,d=m}while(f*f>1e-24&&_<30);return{x:g,y:Math.atan(m/Math.abs(p)),z:v}}function tt(i){return i===t||i===e}Z.wgs84={towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},Z.ch1903={towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},Z.ggrs87={towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},Z.nad83={towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},Z.nad27={nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},Z.potsdam={towgs84:"606.0,23.0,413.0",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},Z.carthage={towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},Z.hermannskogel={towgs84:"653.0,-212.0,449.0",ellipse:"bessel",datumName:"Hermannskogel"},Z.osni52={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"airy",datumName:"Irish National"},Z.ire65={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},Z.rassadiran={towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},Z.nzgd49={towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},Z.osgb36={towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"},Z.s_jtsk={towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},Z.beduaram={towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},Z.gunung_segara={towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},Z.rnb72={towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"},Q.projections=Y,Q.projections.start();var et=function(i,n,s){return function(i,o){return i.datum_type===o.datum_type&&!(i.a!==o.a||Math.abs(i.es-o.es)>5e-11)&&(i.datum_type===t?i.datum_params[0]===o.datum_params[0]&&i.datum_params[1]===o.datum_params[1]&&i.datum_params[2]===o.datum_params[2]:i.datum_type!==e||i.datum_params[0]===o.datum_params[0]&&i.datum_params[1]===o.datum_params[1]&&i.datum_params[2]===o.datum_params[2]&&i.datum_params[3]===o.datum_params[3]&&i.datum_params[4]===o.datum_params[4]&&i.datum_params[5]===o.datum_params[5]&&i.datum_params[6]===o.datum_params[6])}(i,n)?s:i.datum_type===o||n.datum_type===o?s:i.es!==n.es||i.a!==n.a||tt(i.datum_type)||tt(n.datum_type)?(s=J(s,i.es,i.a),tt(i.datum_type)&&(s=function(i,o,n){if(o===t)return{x:i.x+n[0],y:i.y+n[1],z:i.z+n[2]};if(o===e){var s=n[0],a=n[1],r=n[2],l=n[3],c=n[4],u=n[5],h=n[6];return{x:h*(i.x-u*i.y+c*i.z)+s,y:h*(u*i.x+i.y-l*i.z)+a,z:h*(-c*i.x+l*i.y+i.z)+r}}}(s,i.datum_type,i.datum_params)),tt(n.datum_type)&&(s=function(i,o,n){if(o===t)return{x:i.x-n[0],y:i.y-n[1],z:i.z-n[2]};if(o===e){var s=n[0],a=n[1],r=n[2],l=n[3],c=n[4],u=n[5],h=n[6],d=(i.x-s)/h,p=(i.y-a)/h,m=(i.z-r)/h;return{x:d+u*p-c*m,y:-u*d+p+l*m,z:c*d-l*p+m}}}(s,n.datum_type,n.datum_params)),$(s,n.es,n.a,n.b)):s},it=function(t,e,i){var o,n,s,a=i.x,r=i.y,l=i.z||0,c={};for(s=0;s<3;s++)if(!e||2!==s||void 0!==i.z)switch(0===s?(o=a,n=-1!=="ew".indexOf(t.axis[s])?"x":"y"):1===s?(o=r,n=-1!=="ns".indexOf(t.axis[s])?"y":"x"):(o=l,n="z"),t.axis[s]){case"e":c[n]=o;break;case"w":c[n]=-o;break;case"n":c[n]=o;break;case"s":c[n]=-o;break;case"u":void 0!==i[n]&&(c.z=o);break;case"d":void 0!==i[n]&&(c.z=-o);break;default:return null}return c},ot=function(t){var e={x:t[0],y:t[1]};return t.length>2&&(e.z=t[2]),t.length>3&&(e.m=t[3]),e},nt=function(t){st(t.x),st(t.y)};function st(t){if("function"==typeof Number.isFinite){if(Number.isFinite(t))return;throw new TypeError("coordinates must be finite numbers")}if("number"!=typeof t||t!=t||!isFinite(t))throw new TypeError("coordinates must be finite numbers")}function at(i,o,n){var s;if(Array.isArray(n)&&(n=ot(n)),nt(n),i.datum&&o.datum&&function(i,o){return(i.datum.datum_type===t||i.datum.datum_type===e)&&"WGS84"!==o.datumCode||(o.datum.datum_type===t||o.datum.datum_type===e)&&"WGS84"!==i.datumCode}(i,o)&&(n=at(i,s=new Q("WGS84"),n),i=s),"enu"!==i.axis&&(n=it(i,!1,n)),"longlat"===i.projName)n={x:n.x*u,y:n.y*u,z:n.z||0};else if(i.to_meter&&(n={x:n.x*i.to_meter,y:n.y*i.to_meter,z:n.z||0}),!(n=i.inverse(n)))return;return i.from_greenwich&&(n.x+=i.from_greenwich),n=et(i.datum,o.datum,n),o.from_greenwich&&(n={x:n.x-o.from_greenwich,y:n.y,z:n.z||0}),"longlat"===o.projName?n={x:n.x*h,y:n.y*h,z:n.z||0}:(n=o.forward(n),o.to_meter&&(n={x:n.x/o.to_meter,y:n.y/o.to_meter,z:n.z||0})),"enu"!==o.axis?it(o,!0,n):n}var rt=Q("WGS84");function lt(t,e,i){var o,n,s;return Array.isArray(i)?(o=at(t,e,i)||{x:NaN,y:NaN},i.length>2?void 0!==t.name&&"geocent"===t.name||void 0!==e.name&&"geocent"===e.name?"number"==typeof o.z?[o.x,o.y,o.z].concat(i.splice(3)):[o.x,o.y,i[2]].concat(i.splice(3)):[o.x,o.y].concat(i.splice(2)):[o.x,o.y]):(n=at(t,e,i),2===(s=Object.keys(i)).length?n:(s.forEach((function(o){if(void 0!==t.name&&"geocent"===t.name||void 0!==e.name&&"geocent"===e.name){if("x"===o||"y"===o||"z"===o)return}else if("x"===o||"y"===o)return;n[o]=i[o]})),n))}function ct(t){return t instanceof Q?t:t.oProj?t.oProj:Q(t)}function ut(t,e,i){t=ct(t);var o,n=!1;return void 0===e?(e=t,t=rt,n=!0):(void 0!==e.x||Array.isArray(e))&&(i=e,e=t,t=rt,n=!0),e=ct(e),i?lt(t,e,i):(o={forward:function(i){return lt(t,e,i)},inverse:function(i){return lt(e,t,i)}},n&&(o.oProj=e),o)}var ht=6,dt="AJSAJS",pt="AFAFAF",mt=65,ft=73,_t=79,gt=86,vt=90,yt={forward:Et,inverse:function(t){var e=Mt(Lt(t.toUpperCase()));return e.lat&&e.lon?[e.lon,e.lat,e.lon,e.lat]:[e.left,e.bottom,e.right,e.top]},toPoint:Pt};function Et(t,e){return e=e||5,function(t,e){var i,o,n,s,a,r,l,c,u,h,d,p,m,f,_="00000"+t.easting,g="00000"+t.northing;return t.zoneNumber+t.zoneLetter+(u=t.easting,h=t.northing,d=t.zoneNumber,p=St(d),m=Math.floor(u/1e5),f=Math.floor(h/1e5)%20,i=m,o=f,n=p-1,s=dt.charCodeAt(n),a=pt.charCodeAt(n),c=!1,(r=s+i-1)>vt&&(r=r-vt+mt-1,c=!0),(r===ft||s<ft&&r>ft||(r>ft||s<ft)&&c)&&r++,(r===_t||s<_t&&r>_t||(r>_t||s<_t)&&c)&&++r===ft&&r++,r>vt&&(r=r-vt+mt-1),(l=a+o)>gt?(l=l-gt+mt-1,c=!0):c=!1,(l===ft||a<ft&&l>ft||(l>ft||a<ft)&&c)&&l++,(l===_t||a<_t&&l>_t||(l>_t||a<_t)&&c)&&++l===ft&&l++,l>gt&&(l=l-gt+mt-1),String.fromCharCode(r)+String.fromCharCode(l))+_.substr(_.length-5,e)+g.substr(g.length-5,e)}(function(t){var e,i,o,n,s,a,r,l=t.lat,c=t.lon,u=6378137,h=wt(l),d=wt(c);r=Math.floor((c+180)/6)+1,180===c&&(r=60),l>=56&&l<64&&c>=3&&c<12&&(r=32),l>=72&&l<84&&(c>=0&&c<9?r=31:c>=9&&c<21?r=33:c>=21&&c<33?r=35:c>=33&&c<42&&(r=37)),a=wt(6*(r-1)-180+3),e=u/Math.sqrt(1-.00669438*Math.sin(h)*Math.sin(h)),i=Math.tan(h)*Math.tan(h),o=.006739496752268451*Math.cos(h)*Math.cos(h),n=Math.cos(h)*(d-a),s=u*(.9983242984503243*h-.002514607064228144*Math.sin(2*h)+2639046602129982e-21*Math.sin(4*h)-3.418046101696858e-9*Math.sin(6*h));var p,m,f=.9996*e*(n+(1-i+o)*n*n*n/6+(5-18*i+i*i+72*o-.39089081163157013)*n*n*n*n*n/120)+5e5,_=.9996*(s+e*Math.tan(h)*(n*n/2+(5-i+9*o+4*o*o)*n*n*n*n/24+(61-58*i+i*i+600*o-2.2240339282485886)*n*n*n*n*n*n/720));return l<0&&(_+=1e7),{northing:Math.round(_),easting:Math.round(f),zoneNumber:r,zoneLetter:(p=l,m="Z",84>=p&&p>=72?m="X":72>p&&p>=64?m="W":64>p&&p>=56?m="V":56>p&&p>=48?m="U":48>p&&p>=40?m="T":40>p&&p>=32?m="S":32>p&&p>=24?m="R":24>p&&p>=16?m="Q":16>p&&p>=8?m="P":8>p&&p>=0?m="N":0>p&&p>=-8?m="M":-8>p&&p>=-16?m="L":-16>p&&p>=-24?m="K":-24>p&&p>=-32?m="J":-32>p&&p>=-40?m="H":-40>p&&p>=-48?m="G":-48>p&&p>=-56?m="F":-56>p&&p>=-64?m="E":-64>p&&p>=-72?m="D":-72>p&&p>=-80&&(m="C"),m)}}({lat:t[1],lon:t[0]}),e)}function Pt(t){var e=Mt(Lt(t.toUpperCase()));return e.lat&&e.lon?[e.lon,e.lat]:[(e.left+e.right)/2,(e.top+e.bottom)/2]}function wt(t){return t*(Math.PI/180)}function Ct(t){return t/Math.PI*180}function Mt(t){var e=t.northing,i=t.easting,o=t.zoneLetter,n=t.zoneNumber;if(n<0||n>60)return null;var s,a,r,l,c,u,h,d,p=6378137,m=(1-Math.sqrt(.99330562))/(1+Math.sqrt(.99330562)),f=i-5e5,_=e;o<"N"&&(_-=1e7),u=6*(n-1)-180+3,d=(h=_/.9996/6367449.145945056)+(3*m/2-27*m*m*m/32)*Math.sin(2*h)+(21*m*m/16-55*m*m*m*m/32)*Math.sin(4*h)+151*m*m*m/96*Math.sin(6*h),s=p/Math.sqrt(1-.00669438*Math.sin(d)*Math.sin(d)),a=Math.tan(d)*Math.tan(d),r=.006739496752268451*Math.cos(d)*Math.cos(d),l=.99330562*p/Math.pow(1-.00669438*Math.sin(d)*Math.sin(d),1.5),c=f/(.9996*s);var g=d-s*Math.tan(d)/l*(c*c/2-(5+3*a+10*r-4*r*r-.06065547077041606)*c*c*c*c/24+(61+90*a+298*r+45*a*a-1.6983531815716497-3*r*r)*c*c*c*c*c*c/720);g=Ct(g);var v,y=(c-(1+2*a+r)*c*c*c/6+(5-2*r+28*a-3*r*r+.05391597401814761+24*a*a)*c*c*c*c*c/120)/Math.cos(d);if(y=u+Ct(y),t.accuracy){var E=Mt({northing:t.northing+t.accuracy,easting:t.easting+t.accuracy,zoneLetter:t.zoneLetter,zoneNumber:t.zoneNumber});v={top:E.lat,right:E.lon,bottom:g,left:y}}else v={lat:g,lon:y};return v}function St(t){var e=t%ht;return 0===e&&(e=ht),e}function Lt(t){if(t&&0===t.length)throw"MGRSPoint coverting from nothing";for(var e,i=t.length,o=null,n="",s=0;!/[A-Z]/.test(e=t.charAt(s));){if(s>=2)throw"MGRSPoint bad conversion from: "+t;n+=e,s++}var a=parseInt(n,10);if(0===s||s+3>i)throw"MGRSPoint bad conversion from: "+t;var r=t.charAt(s++);if(r<="A"||"B"===r||"Y"===r||r>="Z"||"I"===r||"O"===r)throw"MGRSPoint zone letter "+r+" not handled: "+t;o=t.substring(s,s+=2);for(var l=St(a),c=function(t,e){for(var i=dt.charCodeAt(e-1),o=1e5,n=!1;i!==t.charCodeAt(0);){if(++i===ft&&i++,i===_t&&i++,i>vt){if(n)throw"Bad character: "+t;i=mt,n=!0}o+=1e5}return o}(o.charAt(0),l),u=function(t,e){if(t>"V")throw"MGRSPoint given invalid Northing "+t;for(var i=pt.charCodeAt(e-1),o=0,n=!1;i!==t.charCodeAt(0);){if(++i===ft&&i++,i===_t&&i++,i>gt){if(n)throw"Bad character: "+t;i=mt,n=!0}o+=1e5}return o}(o.charAt(1),l);u<bt(r);)u+=2e6;var h=i-s;if(h%2!=0)throw"MGRSPoint has to have an even number \nof digits after the zone letter and two 100km letters - front \nhalf for easting meters, second half for \nnorthing meters"+t;var d,p,m,f=h/2,_=0,g=0;return f>0&&(d=1e5/Math.pow(10,f),p=t.substring(s,s+f),_=parseFloat(p)*d,m=t.substring(s+f),g=parseFloat(m)*d),{easting:_+c,northing:g+u,zoneLetter:r,zoneNumber:a,accuracy:d}}function bt(t){var e;switch(t){case"C":e=11e5;break;case"D":e=2e6;break;case"E":e=28e5;break;case"F":e=37e5;break;case"G":e=46e5;break;case"H":e=55e5;break;case"J":e=64e5;break;case"K":e=73e5;break;case"L":e=82e5;break;case"M":e=91e5;break;case"N":e=0;break;case"P":e=8e5;break;case"Q":e=17e5;break;case"R":e=26e5;break;case"S":e=35e5;break;case"T":e=44e5;break;case"U":e=53e5;break;case"V":e=62e5;break;case"W":e=7e6;break;case"X":e=79e5;break;default:e=-1}if(e>=0)return e;throw"Invalid zone letter: "+t}function Rt(t,e,i){if(!(this instanceof Rt))return new Rt(t,e,i);if(Array.isArray(t))this.x=t[0],this.y=t[1],this.z=t[2]||0;else if("object"==typeof t)this.x=t.x,this.y=t.y,this.z=t.z||0;else if("string"==typeof t&&void 0===e){var o=t.split(",");this.x=parseFloat(o[0],10),this.y=parseFloat(o[1],10),this.z=parseFloat(o[2],10)||0}else this.x=t,this.y=e,this.z=i||0;console.warn("proj4.Point will be removed in version 3, use proj4.toPoint")}Rt.fromMGRS=function(t){return new Rt(Pt(t))},Rt.prototype.toMGRS=function(t){return Et([this.x,this.y],t)};var xt=.01068115234375,It=function(t){var e=[];e[0]=1-t*(.25+t*(.046875+t*(.01953125+t*xt))),e[1]=t*(.75-t*(.046875+t*(.01953125+t*xt)));var i=t*t;return e[2]=i*(.46875-t*(.013020833333333334+.007120768229166667*t)),i*=t,e[3]=i*(.3645833333333333-.005696614583333333*t),e[4]=i*t*.3076171875,e},Gt=function(t,e,i,o){return i*=e,e*=e,o[0]*t-i*(o[1]+e*(o[2]+e*(o[3]+e*o[4])))},At=function(t,e,i){for(var o=1/(1-e),n=t,s=20;s;--s){var a=Math.sin(n),r=1-e*a*a;if(n-=r=(Gt(n,a,Math.cos(n),i)-t)*(r*Math.sqrt(r))*o,Math.abs(r)<c)return n}return n},Tt={init:function(){this.x0=void 0!==this.x0?this.x0:0,this.y0=void 0!==this.y0?this.y0:0,this.long0=void 0!==this.long0?this.long0:0,this.lat0=void 0!==this.lat0?this.lat0:0,this.es&&(this.en=It(this.es),this.ml0=Gt(this.lat0,Math.sin(this.lat0),Math.cos(this.lat0),this.en))},forward:function(t){var e,i,o,n=t.x,s=t.y,a=j(n-this.long0),r=Math.sin(s),l=Math.cos(s);if(this.es){var u=l*a,h=Math.pow(u,2),d=this.ep2*Math.pow(l,2),p=Math.pow(d,2),m=Math.abs(l)>c?Math.tan(s):0,f=Math.pow(m,2),_=Math.pow(f,2);e=1-this.es*Math.pow(r,2),u/=Math.sqrt(e);var g=Gt(s,r,l,this.en);i=this.a*(this.k0*u*(1+h/6*(1-f+d+h/20*(5-18*f+_+14*d-58*f*d+h/42*(61+179*_-_*f-479*f)))))+this.x0,o=this.a*(this.k0*(g-this.ml0+r*a*u/2*(1+h/12*(5-f+9*d+4*p+h/30*(61+_-58*f+270*d-330*f*d+h/56*(1385+543*_-_*f-3111*f))))))+this.y0}else{var v=l*Math.sin(a);if(Math.abs(Math.abs(v)-1)<c)return 93;if(i=.5*this.a*this.k0*Math.log((1+v)/(1-v))+this.x0,o=l*Math.cos(a)/Math.sqrt(1-Math.pow(v,2)),(v=Math.abs(o))>=1){if(v-1>c)return 93;o=0}else o=Math.acos(o);s<0&&(o=-o),o=this.a*this.k0*(o-this.lat0)+this.y0}return t.x=i,t.y=o,t},inverse:function(t){var e,i,o,n,a=(t.x-this.x0)*(1/this.a),r=(t.y-this.y0)*(1/this.a);if(this.es)if(e=this.ml0+r/this.k0,i=At(e,this.es,this.en),Math.abs(i)<s){var l=Math.sin(i),u=Math.cos(i),h=Math.abs(u)>c?Math.tan(i):0,d=this.ep2*Math.pow(u,2),p=Math.pow(d,2),m=Math.pow(h,2),f=Math.pow(m,2);e=1-this.es*Math.pow(l,2);var _=a*Math.sqrt(e)/this.k0,g=Math.pow(_,2);o=i-(e*=h)*g/(1-this.es)*.5*(1-g/12*(5+3*m-9*d*m+d-4*p-g/30*(61+90*m-252*d*m+45*f+46*d-g/56*(1385+3633*m+4095*f+1574*f*m)))),n=j(this.long0+_*(1-g/6*(1+2*m+d-g/20*(5+28*m+24*f+8*d*m+6*d-g/42*(61+662*m+1320*f+720*f*m))))/u)}else o=s*U(r),n=0;else{var v=Math.exp(a/this.k0),y=.5*(v-1/v),E=this.lat0+r/this.k0,P=Math.cos(E);e=Math.sqrt((1-Math.pow(P,2))/(1+Math.pow(y,2))),o=Math.asin(e),r<0&&(o=-o),n=0===y&&0===P?0:j(Math.atan2(y,P)+this.long0)}return t.x=n,t.y=o,t},names:["Transverse_Mercator","Transverse Mercator","tmerc"]},kt=function(t){var e=Math.exp(t);return e=(e-1/e)/2},Dt=function(t,e){t=Math.abs(t),e=Math.abs(e);var i=Math.max(t,e),o=Math.min(t,e)/(i||1);return i*Math.sqrt(1+Math.pow(o,2))},Ot=function(t){var e=Math.abs(t);return e=function(t){var e=1+t,i=e-1;return 0===i?t:t*Math.log(e)/i}(e*(1+e/(Dt(1,e)+1))),t<0?-e:e},Nt=function(t,e){for(var i,o=2*Math.cos(2*e),n=t.length-1,s=t[n],a=0;--n>=0;)i=o*s-a+t[n],a=s,s=i;return e+i*Math.sin(2*e)},Ut=function(t,e){for(var i,o=2*Math.cos(e),n=t.length-1,s=t[n],a=0;--n>=0;)i=o*s-a+t[n],a=s,s=i;return Math.sin(e)*i},jt=function(t,e,i){for(var o,n,s=Math.sin(e),a=Math.cos(e),r=kt(i),l=function(t){var e=Math.exp(t);return e=(e+1/e)/2}(i),c=2*a*l,u=-2*s*r,h=t.length-1,d=t[h],p=0,m=0,f=0;--h>=0;)o=m,n=p,d=c*(m=d)-o-u*(p=f)+t[h],f=u*m-n+c*p;return[(c=s*l)*d-(u=a*r)*f,c*f+u*d]},Ft={init:function(){if(void 0===this.es||this.es<=0)throw new Error("incorrect elliptical usage");this.x0=void 0!==this.x0?this.x0:0,this.y0=void 0!==this.y0?this.y0:0,this.long0=void 0!==this.long0?this.long0:0,this.lat0=void 0!==this.lat0?this.lat0:0,this.cgb=[],this.cbg=[],this.utg=[],this.gtu=[];var t=this.es/(1+Math.sqrt(1-this.es)),e=t/(2-t),i=e;this.cgb[0]=e*(2+e*(-2/3+e*(e*(116/45+e*(26/45+e*(-2854/675)))-2))),this.cbg[0]=e*(e*(2/3+e*(4/3+e*(-82/45+e*(32/45+e*(4642/4725)))))-2),i*=e,this.cgb[1]=i*(7/3+e*(e*(-227/45+e*(2704/315+e*(2323/945)))-1.6)),this.cbg[1]=i*(5/3+e*(-16/15+e*(-13/9+e*(904/315+e*(-1522/945))))),i*=e,this.cgb[2]=i*(56/15+e*(-136/35+e*(-1262/105+e*(73814/2835)))),this.cbg[2]=i*(-26/15+e*(34/21+e*(1.6+e*(-12686/2835)))),i*=e,this.cgb[3]=i*(4279/630+e*(-332/35+e*(-399572/14175))),this.cbg[3]=i*(1237/630+e*(e*(-24832/14175)-2.4)),i*=e,this.cgb[4]=i*(4174/315+e*(-144838/6237)),this.cbg[4]=i*(-734/315+e*(109598/31185)),i*=e,this.cgb[5]=i*(601676/22275),this.cbg[5]=i*(444337/155925),i=Math.pow(e,2),this.Qn=this.k0/(1+e)*(1+i*(.25+i*(1/64+i/256))),this.utg[0]=e*(e*(2/3+e*(-37/96+e*(1/360+e*(81/512+e*(-96199/604800)))))-.5),this.gtu[0]=e*(.5+e*(-2/3+e*(5/16+e*(41/180+e*(-127/288+e*(7891/37800)))))),this.utg[1]=i*(-1/48+e*(-1/15+e*(437/1440+e*(-46/105+e*(1118711/3870720))))),this.gtu[1]=i*(13/48+e*(e*(557/1440+e*(281/630+e*(-1983433/1935360)))-.6)),i*=e,this.utg[2]=i*(-17/480+e*(37/840+e*(209/4480+e*(-5569/90720)))),this.gtu[2]=i*(61/240+e*(-103/140+e*(15061/26880+e*(167603/181440)))),i*=e,this.utg[3]=i*(-4397/161280+e*(11/504+e*(830251/7257600))),this.gtu[3]=i*(49561/161280+e*(-179/168+e*(6601661/7257600))),i*=e,this.utg[4]=i*(-4583/161280+e*(108847/3991680)),this.gtu[4]=i*(34729/80640+e*(-3418889/1995840)),i*=e,this.utg[5]=-.03233083094085698*i,this.gtu[5]=.6650675310896665*i;var o=Nt(this.cbg,this.lat0);this.Zb=-this.Qn*(o+Ut(this.gtu,2*o))},forward:function(t){var e=j(t.x-this.long0),i=t.y;i=Nt(this.cbg,i);var o=Math.sin(i),n=Math.cos(i),s=Math.sin(e),a=Math.cos(e);i=Math.atan2(o,a*n),e=Math.atan2(s*n,Dt(o,n*a)),e=Ot(Math.tan(e));var r,l,c=jt(this.gtu,2*i,2*e);return i+=c[0],e+=c[1],Math.abs(e)<=2.623395162778?(r=this.a*(this.Qn*e)+this.x0,l=this.a*(this.Qn*i+this.Zb)+this.y0):(r=1/0,l=1/0),t.x=r,t.y=l,t},inverse:function(t){var e,i,o=(t.x-this.x0)*(1/this.a),n=(t.y-this.y0)*(1/this.a);if(n=(n-this.Zb)/this.Qn,o/=this.Qn,Math.abs(o)<=2.623395162778){var s=jt(this.utg,2*n,2*o);n+=s[0],o+=s[1],o=Math.atan(kt(o));var a=Math.sin(n),r=Math.cos(n),l=Math.sin(o),c=Math.cos(o);n=Math.atan2(a*c,Dt(l,c*r)),o=Math.atan2(l,c*r),e=j(o+this.long0),i=Nt(this.cgb,n)}else e=1/0,i=1/0;return t.x=e,t.y=i,t},names:["Extended_Transverse_Mercator","Extended Transverse Mercator","etmerc"]},Bt=function(t,e){if(void 0===t){if((t=Math.floor(30*(j(e)+Math.PI)/Math.PI)+1)<0)return 0;if(t>60)return 60}return t},zt={init:function(){var t=Bt(this.zone,this.long0);if(void 0===t)throw new Error("unknown utm zone");this.lat0=0,this.long0=(6*Math.abs(t)-183)*u,this.x0=5e5,this.y0=this.utmSouth?1e7:0,this.k0=.9996,Ft.init.apply(this),this.forward=Ft.forward,this.inverse=Ft.inverse},names:["Universal Transverse Mercator System","utm"],dependsOn:"etmerc"},qt=function(t,e){return Math.pow((1-t)/(1+t),e)},Ht=20,Wt={init:function(){var t=Math.sin(this.lat0),e=Math.cos(this.lat0);e*=e,this.rc=Math.sqrt(1-this.es)/(1-this.es*t*t),this.C=Math.sqrt(1+this.es*e*e/(1-this.es)),this.phic0=Math.asin(t/this.C),this.ratexp=.5*this.C*this.e,this.K=Math.tan(.5*this.phic0+d)/(Math.pow(Math.tan(.5*this.lat0+d),this.C)*qt(this.e*t,this.ratexp))},forward:function(t){var e=t.x,i=t.y;return t.y=2*Math.atan(this.K*Math.pow(Math.tan(.5*i+d),this.C)*qt(this.e*Math.sin(i),this.ratexp))-s,t.x=this.C*e,t},inverse:function(t){for(var e=t.x/this.C,i=t.y,o=Math.pow(Math.tan(.5*i+d)/this.K,1/this.C),n=Ht;n>0&&(i=2*Math.atan(o*qt(this.e*Math.sin(t.y),-.5*this.e))-s,!(Math.abs(i-t.y)<1e-14));--n)t.y=i;return n?(t.x=e,t.y=i,t):null},names:["gauss"]},Vt={init:function(){Wt.init.apply(this),this.rc&&(this.sinc0=Math.sin(this.phic0),this.cosc0=Math.cos(this.phic0),this.R2=2*this.rc,this.title||(this.title="Oblique Stereographic Alternative"))},forward:function(t){var e,i,o,n;return t.x=j(t.x-this.long0),Wt.forward.apply(this,[t]),e=Math.sin(t.y),i=Math.cos(t.y),o=Math.cos(t.x),n=this.k0*this.R2/(1+this.sinc0*e+this.cosc0*i*o),t.x=n*i*Math.sin(t.x),t.y=n*(this.cosc0*e-this.sinc0*i*o),t.x=this.a*t.x+this.x0,t.y=this.a*t.y+this.y0,t},inverse:function(t){var e,i,o,n,s;if(t.x=(t.x-this.x0)/this.a,t.y=(t.y-this.y0)/this.a,t.x/=this.k0,t.y/=this.k0,s=Math.sqrt(t.x*t.x+t.y*t.y)){var a=2*Math.atan2(s,this.R2);e=Math.sin(a),i=Math.cos(a),n=Math.asin(i*this.sinc0+t.y*e*this.cosc0/s),o=Math.atan2(t.x*e,s*this.cosc0*i-t.y*this.sinc0*e)}else n=this.phic0,o=0;return t.x=o,t.y=n,Wt.inverse.apply(this,[t]),t.x=j(t.x+this.long0),t},names:["Stereographic_North_Pole","Oblique_Stereographic","Polar_Stereographic","sterea","Oblique Stereographic Alternative","Double_Stereographic"]},Yt={init:function(){this.coslat0=Math.cos(this.lat0),this.sinlat0=Math.sin(this.lat0),this.sphere?1===this.k0&&!isNaN(this.lat_ts)&&Math.abs(this.coslat0)<=c&&(this.k0=.5*(1+U(this.lat0)*Math.sin(this.lat_ts))):(Math.abs(this.coslat0)<=c&&(this.lat0>0?this.con=1:this.con=-1),this.cons=Math.sqrt(Math.pow(1+this.e,1+this.e)*Math.pow(1-this.e,1-this.e)),1===this.k0&&!isNaN(this.lat_ts)&&Math.abs(this.coslat0)<=c&&(this.k0=.5*this.cons*N(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts))/F(this.e,this.con*this.lat_ts,this.con*Math.sin(this.lat_ts))),this.ms1=N(this.e,this.sinlat0,this.coslat0),this.X0=2*Math.atan(this.ssfn_(this.lat0,this.sinlat0,this.e))-s,this.cosX0=Math.cos(this.X0),this.sinX0=Math.sin(this.X0))},forward:function(t){var e,i,o,n,a,r,l=t.x,u=t.y,h=Math.sin(u),d=Math.cos(u),p=j(l-this.long0);return Math.abs(Math.abs(l-this.long0)-Math.PI)<=c&&Math.abs(u+this.lat0)<=c?(t.x=NaN,t.y=NaN,t):this.sphere?(e=2*this.k0/(1+this.sinlat0*h+this.coslat0*d*Math.cos(p)),t.x=this.a*e*d*Math.sin(p)+this.x0,t.y=this.a*e*(this.coslat0*h-this.sinlat0*d*Math.cos(p))+this.y0,t):(i=2*Math.atan(this.ssfn_(u,h,this.e))-s,n=Math.cos(i),o=Math.sin(i),Math.abs(this.coslat0)<=c?(a=F(this.e,u*this.con,this.con*h),r=2*this.a*this.k0*a/this.cons,t.x=this.x0+r*Math.sin(l-this.long0),t.y=this.y0-this.con*r*Math.cos(l-this.long0),t):(Math.abs(this.sinlat0)<c?(e=2*this.a*this.k0/(1+n*Math.cos(p)),t.y=e*o):(e=2*this.a*this.k0*this.ms1/(this.cosX0*(1+this.sinX0*o+this.cosX0*n*Math.cos(p))),t.y=e*(this.cosX0*o-this.sinX0*n*Math.cos(p))+this.y0),t.x=e*n*Math.sin(p)+this.x0,t))},inverse:function(t){var e,i,o,n,a;t.x-=this.x0,t.y-=this.y0;var r=Math.sqrt(t.x*t.x+t.y*t.y);if(this.sphere){var l=2*Math.atan(r/(2*this.a*this.k0));return e=this.long0,i=this.lat0,r<=c?(t.x=e,t.y=i,t):(i=Math.asin(Math.cos(l)*this.sinlat0+t.y*Math.sin(l)*this.coslat0/r),e=Math.abs(this.coslat0)<c?this.lat0>0?j(this.long0+Math.atan2(t.x,-1*t.y)):j(this.long0+Math.atan2(t.x,t.y)):j(this.long0+Math.atan2(t.x*Math.sin(l),r*this.coslat0*Math.cos(l)-t.y*this.sinlat0*Math.sin(l))),t.x=e,t.y=i,t)}if(Math.abs(this.coslat0)<=c){if(r<=c)return i=this.lat0,e=this.long0,t.x=e,t.y=i,t;t.x*=this.con,t.y*=this.con,o=r*this.cons/(2*this.a*this.k0),i=this.con*B(this.e,o),e=this.con*j(this.con*this.long0+Math.atan2(t.x,-1*t.y))}else n=2*Math.atan(r*this.cosX0/(2*this.a*this.k0*this.ms1)),e=this.long0,r<=c?a=this.X0:(a=Math.asin(Math.cos(n)*this.sinX0+t.y*Math.sin(n)*this.cosX0/r),e=j(this.long0+Math.atan2(t.x*Math.sin(n),r*this.cosX0*Math.cos(n)-t.y*this.sinX0*Math.sin(n)))),i=-1*B(this.e,Math.tan(.5*(s+a)));return t.x=e,t.y=i,t},names:["stere","Stereographic_South_Pole","Polar Stereographic (variant B)"],ssfn_:function(t,e,i){return e*=i,Math.tan(.5*(s+t))*Math.pow((1-e)/(1+e),.5*i)}},Xt={init:function(){var t=this.lat0;this.lambda0=this.long0;var e=Math.sin(t),i=this.a,o=1/this.rf,n=2*o-Math.pow(o,2),s=this.e=Math.sqrt(n);this.R=this.k0*i*Math.sqrt(1-n)/(1-n*Math.pow(e,2)),this.alpha=Math.sqrt(1+n/(1-n)*Math.pow(Math.cos(t),4)),this.b0=Math.asin(e/this.alpha);var a=Math.log(Math.tan(Math.PI/4+this.b0/2)),r=Math.log(Math.tan(Math.PI/4+t/2)),l=Math.log((1+s*e)/(1-s*e));this.K=a-this.alpha*r+this.alpha*s/2*l},forward:function(t){var e=Math.log(Math.tan(Math.PI/4-t.y/2)),i=this.e/2*Math.log((1+this.e*Math.sin(t.y))/(1-this.e*Math.sin(t.y))),o=-this.alpha*(e+i)+this.K,n=2*(Math.atan(Math.exp(o))-Math.PI/4),s=this.alpha*(t.x-this.lambda0),a=Math.atan(Math.sin(s)/(Math.sin(this.b0)*Math.tan(n)+Math.cos(this.b0)*Math.cos(s))),r=Math.asin(Math.cos(this.b0)*Math.sin(n)-Math.sin(this.b0)*Math.cos(n)*Math.cos(s));return t.y=this.R/2*Math.log((1+Math.sin(r))/(1-Math.sin(r)))+this.y0,t.x=this.R*a+this.x0,t},inverse:function(t){for(var e=t.x-this.x0,i=t.y-this.y0,o=e/this.R,n=2*(Math.atan(Math.exp(i/this.R))-Math.PI/4),s=Math.asin(Math.cos(this.b0)*Math.sin(n)+Math.sin(this.b0)*Math.cos(n)*Math.cos(o)),a=Math.atan(Math.sin(o)/(Math.cos(this.b0)*Math.cos(o)-Math.sin(this.b0)*Math.tan(n))),r=this.lambda0+a/this.alpha,l=0,c=s,u=-1e3,h=0;Math.abs(c-u)>1e-7;){if(++h>20)return;l=1/this.alpha*(Math.log(Math.tan(Math.PI/4+s/2))-this.K)+this.e*Math.log(Math.tan(Math.PI/4+Math.asin(this.e*Math.sin(c))/2)),u=c,c=2*Math.atan(Math.exp(l))-Math.PI/2}return t.x=r,t.y=c,t},names:["somerc"]},Kt={init:function(){this.no_off=this.no_off||!1,this.no_rot=this.no_rot||!1,isNaN(this.k0)&&(this.k0=1);var t=Math.sin(this.lat0),e=Math.cos(this.lat0),i=this.e*t;this.bl=Math.sqrt(1+this.es/(1-this.es)*Math.pow(e,4)),this.al=this.a*this.bl*this.k0*Math.sqrt(1-this.es)/(1-i*i);var o,n,s=F(this.e,this.lat0,t),a=this.bl/e*Math.sqrt((1-this.es)/(1-i*i));if(a*a<1&&(a=1),isNaN(this.longc)){var r=F(this.e,this.lat1,Math.sin(this.lat1)),l=F(this.e,this.lat2,Math.sin(this.lat2));this.lat0>=0?this.el=(a+Math.sqrt(a*a-1))*Math.pow(s,this.bl):this.el=(a-Math.sqrt(a*a-1))*Math.pow(s,this.bl);var c=Math.pow(r,this.bl),u=Math.pow(l,this.bl);n=.5*((o=this.el/c)-1/o);var h=(this.el*this.el-u*c)/(this.el*this.el+u*c),d=(u-c)/(u+c),p=j(this.long1-this.long2);this.long0=.5*(this.long1+this.long2)-Math.atan(h*Math.tan(.5*this.bl*p)/d)/this.bl,this.long0=j(this.long0);var m=j(this.long1-this.long0);this.gamma0=Math.atan(Math.sin(this.bl*m)/n),this.alpha=Math.asin(a*Math.sin(this.gamma0))}else o=this.lat0>=0?a+Math.sqrt(a*a-1):a-Math.sqrt(a*a-1),this.el=o*Math.pow(s,this.bl),n=.5*(o-1/o),this.gamma0=Math.asin(Math.sin(this.alpha)/a),this.long0=this.longc-Math.asin(n*Math.tan(this.gamma0))/this.bl;this.no_off?this.uc=0:this.lat0>=0?this.uc=this.al/this.bl*Math.atan2(Math.sqrt(a*a-1),Math.cos(this.alpha)):this.uc=-1*this.al/this.bl*Math.atan2(Math.sqrt(a*a-1),Math.cos(this.alpha))},forward:function(t){var e,i,o,n=t.x,a=t.y,r=j(n-this.long0);if(Math.abs(Math.abs(a)-s)<=c)o=a>0?-1:1,i=this.al/this.bl*Math.log(Math.tan(d+o*this.gamma0*.5)),e=-1*o*s*this.al/this.bl;else{var l=F(this.e,a,Math.sin(a)),u=this.el/Math.pow(l,this.bl),h=.5*(u-1/u),p=.5*(u+1/u),m=Math.sin(this.bl*r),f=(h*Math.sin(this.gamma0)-m*Math.cos(this.gamma0))/p;i=Math.abs(Math.abs(f)-1)<=c?Number.POSITIVE_INFINITY:.5*this.al*Math.log((1-f)/(1+f))/this.bl,e=Math.abs(Math.cos(this.bl*r))<=c?this.al*this.bl*r:this.al*Math.atan2(h*Math.cos(this.gamma0)+m*Math.sin(this.gamma0),Math.cos(this.bl*r))/this.bl}return this.no_rot?(t.x=this.x0+e,t.y=this.y0+i):(e-=this.uc,t.x=this.x0+i*Math.cos(this.alpha)+e*Math.sin(this.alpha),t.y=this.y0+e*Math.cos(this.alpha)-i*Math.sin(this.alpha)),t},inverse:function(t){var e,i;this.no_rot?(i=t.y-this.y0,e=t.x-this.x0):(i=(t.x-this.x0)*Math.cos(this.alpha)-(t.y-this.y0)*Math.sin(this.alpha),e=(t.y-this.y0)*Math.cos(this.alpha)+(t.x-this.x0)*Math.sin(this.alpha),e+=this.uc);var o=Math.exp(-1*this.bl*i/this.al),n=.5*(o-1/o),a=.5*(o+1/o),r=Math.sin(this.bl*e/this.al),l=(r*Math.cos(this.gamma0)+n*Math.sin(this.gamma0))/a,u=Math.pow(this.el/Math.sqrt((1+l)/(1-l)),1/this.bl);return Math.abs(l-1)<c?(t.x=this.long0,t.y=s):Math.abs(l+1)<c?(t.x=this.long0,t.y=-1*s):(t.y=B(this.e,u),t.x=j(this.long0-Math.atan2(n*Math.cos(this.gamma0)-r*Math.sin(this.gamma0),Math.cos(this.bl*e/this.al))/this.bl)),t},names:["Hotine_Oblique_Mercator","Hotine Oblique Mercator","Hotine_Oblique_Mercator_Azimuth_Natural_Origin","Hotine_Oblique_Mercator_Azimuth_Center","omerc"]},Zt={init:function(){if(this.lat2||(this.lat2=this.lat1),this.k0||(this.k0=1),this.x0=this.x0||0,this.y0=this.y0||0,!(Math.abs(this.lat1+this.lat2)<c)){var t=this.b/this.a;this.e=Math.sqrt(1-t*t);var e=Math.sin(this.lat1),i=Math.cos(this.lat1),o=N(this.e,e,i),n=F(this.e,this.lat1,e),s=Math.sin(this.lat2),a=Math.cos(this.lat2),r=N(this.e,s,a),l=F(this.e,this.lat2,s),u=F(this.e,this.lat0,Math.sin(this.lat0));Math.abs(this.lat1-this.lat2)>c?this.ns=Math.log(o/r)/Math.log(n/l):this.ns=e,isNaN(this.ns)&&(this.ns=e),this.f0=o/(this.ns*Math.pow(n,this.ns)),this.rh=this.a*this.f0*Math.pow(u,this.ns),this.title||(this.title="Lambert Conformal Conic")}},forward:function(t){var e=t.x,i=t.y;Math.abs(2*Math.abs(i)-Math.PI)<=c&&(i=U(i)*(s-2*c));var o,n,a=Math.abs(Math.abs(i)-s);if(a>c)o=F(this.e,i,Math.sin(i)),n=this.a*this.f0*Math.pow(o,this.ns);else{if((a=i*this.ns)<=0)return null;n=0}var r=this.ns*j(e-this.long0);return t.x=this.k0*(n*Math.sin(r))+this.x0,t.y=this.k0*(this.rh-n*Math.cos(r))+this.y0,t},inverse:function(t){var e,i,o,n,a,r=(t.x-this.x0)/this.k0,l=this.rh-(t.y-this.y0)/this.k0;this.ns>0?(e=Math.sqrt(r*r+l*l),i=1):(e=-Math.sqrt(r*r+l*l),i=-1);var c=0;if(0!==e&&(c=Math.atan2(i*r,i*l)),0!==e||this.ns>0){if(i=1/this.ns,o=Math.pow(e/(this.a*this.f0),i),-9999===(n=B(this.e,o)))return null}else n=-s;return a=j(c/this.ns+this.long0),t.x=a,t.y=n,t},names:["Lambert Tangential Conformal Conic Projection","Lambert_Conformal_Conic","Lambert_Conformal_Conic_2SP","lcc"]},Qt={init:function(){this.a=6377397.155,this.es=.006674372230614,this.e=Math.sqrt(this.es),this.lat0||(this.lat0=.863937979737193),this.long0||(this.long0=.4334234309119251),this.k0||(this.k0=.9999),this.s45=.785398163397448,this.s90=2*this.s45,this.fi0=this.lat0,this.e2=this.es,this.e=Math.sqrt(this.e2),this.alfa=Math.sqrt(1+this.e2*Math.pow(Math.cos(this.fi0),4)/(1-this.e2)),this.uq=1.04216856380474,this.u0=Math.asin(Math.sin(this.fi0)/this.alfa),this.g=Math.pow((1+this.e*Math.sin(this.fi0))/(1-this.e*Math.sin(this.fi0)),this.alfa*this.e/2),this.k=Math.tan(this.u0/2+this.s45)/Math.pow(Math.tan(this.fi0/2+this.s45),this.alfa)*this.g,this.k1=this.k0,this.n0=this.a*Math.sqrt(1-this.e2)/(1-this.e2*Math.pow(Math.sin(this.fi0),2)),this.s0=1.37008346281555,this.n=Math.sin(this.s0),this.ro0=this.k1*this.n0/Math.tan(this.s0),this.ad=this.s90-this.uq},forward:function(t){var e,i,o,n,s,a,r,l=t.x,c=t.y,u=j(l-this.long0);return e=Math.pow((1+this.e*Math.sin(c))/(1-this.e*Math.sin(c)),this.alfa*this.e/2),i=2*(Math.atan(this.k*Math.pow(Math.tan(c/2+this.s45),this.alfa)/e)-this.s45),o=-u*this.alfa,n=Math.asin(Math.cos(this.ad)*Math.sin(i)+Math.sin(this.ad)*Math.cos(i)*Math.cos(o)),s=Math.asin(Math.cos(i)*Math.sin(o)/Math.cos(n)),a=this.n*s,r=this.ro0*Math.pow(Math.tan(this.s0/2+this.s45),this.n)/Math.pow(Math.tan(n/2+this.s45),this.n),t.y=r*Math.cos(a)/1,t.x=r*Math.sin(a)/1,this.czech||(t.y*=-1,t.x*=-1),t},inverse:function(t){var e,i,o,n,s,a,r,l=t.x;t.x=t.y,t.y=l,this.czech||(t.y*=-1,t.x*=-1),s=Math.sqrt(t.x*t.x+t.y*t.y),n=Math.atan2(t.y,t.x)/Math.sin(this.s0),o=2*(Math.atan(Math.pow(this.ro0/s,1/this.n)*Math.tan(this.s0/2+this.s45))-this.s45),e=Math.asin(Math.cos(this.ad)*Math.sin(o)-Math.sin(this.ad)*Math.cos(o)*Math.cos(n)),i=Math.asin(Math.cos(o)*Math.sin(n)/Math.cos(e)),t.x=this.long0-i/this.alfa,a=e,r=0;var c=0;do{t.y=2*(Math.atan(Math.pow(this.k,-1/this.alfa)*Math.pow(Math.tan(e/2+this.s45),1/this.alfa)*Math.pow((1+this.e*Math.sin(a))/(1-this.e*Math.sin(a)),this.e/2))-this.s45),Math.abs(a-t.y)<1e-10&&(r=1),a=t.y,c+=1}while(0===r&&c<15);return c>=15?null:t},names:["Krovak","krovak"]},Jt=function(t,e,i,o,n){return t*n-e*Math.sin(2*n)+i*Math.sin(4*n)-o*Math.sin(6*n)},$t=function(t){return 1-.25*t*(1+t/16*(3+1.25*t))},te=function(t){return.375*t*(1+.25*t*(1+.46875*t))},ee=function(t){return.05859375*t*t*(1+.75*t)},ie=function(t){return t*t*t*(35/3072)},oe=function(t,e,i){var o=e*i;return t/Math.sqrt(1-o*o)},ne=function(t){return Math.abs(t)<s?t:t-U(t)*Math.PI},se=function(t,e,i,o,n){var s,a;s=t/e;for(var r=0;r<15;r++)if(s+=a=(t-(e*s-i*Math.sin(2*s)+o*Math.sin(4*s)-n*Math.sin(6*s)))/(e-2*i*Math.cos(2*s)+4*o*Math.cos(4*s)-6*n*Math.cos(6*s)),Math.abs(a)<=1e-10)return s;return NaN},ae={init:function(){this.sphere||(this.e0=$t(this.es),this.e1=te(this.es),this.e2=ee(this.es),this.e3=ie(this.es),this.ml0=this.a*Jt(this.e0,this.e1,this.e2,this.e3,this.lat0))},forward:function(t){var e,i,o=t.x,n=t.y;if(o=j(o-this.long0),this.sphere)e=this.a*Math.asin(Math.cos(n)*Math.sin(o)),i=this.a*(Math.atan2(Math.tan(n),Math.cos(o))-this.lat0);else{var s=Math.sin(n),a=Math.cos(n),r=oe(this.a,this.e,s),l=Math.tan(n)*Math.tan(n),c=o*Math.cos(n),u=c*c,h=this.es*a*a/(1-this.es);e=r*c*(1-u*l*(1/6-(8-l+8*h)*u/120)),i=this.a*Jt(this.e0,this.e1,this.e2,this.e3,n)-this.ml0+r*s/a*u*(.5+(5-l+6*h)*u/24)}return t.x=e+this.x0,t.y=i+this.y0,t},inverse:function(t){t.x-=this.x0,t.y-=this.y0;var e,i,o=t.x/this.a,n=t.y/this.a;if(this.sphere){var a=n+this.lat0;e=Math.asin(Math.sin(a)*Math.cos(o)),i=Math.atan2(Math.tan(o),Math.cos(a))}else{var r=this.ml0/this.a+n,l=se(r,this.e0,this.e1,this.e2,this.e3);if(Math.abs(Math.abs(l)-s)<=c)return t.x=this.long0,t.y=s,n<0&&(t.y*=-1),t;var u=oe(this.a,this.e,Math.sin(l)),h=u*u*u/this.a/this.a*(1-this.es),d=Math.pow(Math.tan(l),2),p=o*this.a/u,m=p*p;e=l-u*Math.tan(l)/h*p*p*(.5-(1+3*d)*p*p/24),i=p*(1-m*(d/3+(1+3*d)*d*m/15))/Math.cos(l)}return t.x=j(i+this.long0),t.y=ne(e),t},names:["Cassini","Cassini_Soldner","cass"]},re=function(t,e){var i;return t>1e-7?(1-t*t)*(e/(1-(i=t*e)*i)-.5/t*Math.log((1-i)/(1+i))):2*e},le=.3333333333333333,ce=.17222222222222222,ue=.10257936507936508,he=.06388888888888888,de=.0664021164021164,pe=.016415012942191543,me={init:function(){var t,e=Math.abs(this.lat0);if(Math.abs(e-s)<c?this.mode=this.lat0<0?this.S_POLE:this.N_POLE:Math.abs(e)<c?this.mode=this.EQUIT:this.mode=this.OBLIQ,this.es>0)switch(this.qp=re(this.e,1),this.mmf=.5/(1-this.es),this.apa=function(t){var e,i=[];return i[0]=t*le,e=t*t,i[0]+=e*ce,i[1]=e*he,e*=t,i[0]+=e*ue,i[1]+=e*de,i[2]=e*pe,i}(this.es),this.mode){case this.N_POLE:case this.S_POLE:this.dd=1;break;case this.EQUIT:this.rq=Math.sqrt(.5*this.qp),this.dd=1/this.rq,this.xmf=1,this.ymf=.5*this.qp;break;case this.OBLIQ:this.rq=Math.sqrt(.5*this.qp),t=Math.sin(this.lat0),this.sinb1=re(this.e,t)/this.qp,this.cosb1=Math.sqrt(1-this.sinb1*this.sinb1),this.dd=Math.cos(this.lat0)/(Math.sqrt(1-this.es*t*t)*this.rq*this.cosb1),this.ymf=(this.xmf=this.rq)/this.dd,this.xmf*=this.dd}else this.mode===this.OBLIQ&&(this.sinph0=Math.sin(this.lat0),this.cosph0=Math.cos(this.lat0))},forward:function(t){var e,i,o,n,a,r,l,u,h,p,m=t.x,f=t.y;if(m=j(m-this.long0),this.sphere){if(a=Math.sin(f),p=Math.cos(f),o=Math.cos(m),this.mode===this.OBLIQ||this.mode===this.EQUIT){if((i=this.mode===this.EQUIT?1+p*o:1+this.sinph0*a+this.cosph0*p*o)<=c)return null;e=(i=Math.sqrt(2/i))*p*Math.sin(m),i*=this.mode===this.EQUIT?a:this.cosph0*a-this.sinph0*p*o}else if(this.mode===this.N_POLE||this.mode===this.S_POLE){if(this.mode===this.N_POLE&&(o=-o),Math.abs(f+this.lat0)<c)return null;i=d-.5*f,e=(i=2*(this.mode===this.S_POLE?Math.cos(i):Math.sin(i)))*Math.sin(m),i*=o}}else{switch(l=0,u=0,h=0,o=Math.cos(m),n=Math.sin(m),a=Math.sin(f),r=re(this.e,a),this.mode!==this.OBLIQ&&this.mode!==this.EQUIT||(l=r/this.qp,u=Math.sqrt(1-l*l)),this.mode){case this.OBLIQ:h=1+this.sinb1*l+this.cosb1*u*o;break;case this.EQUIT:h=1+u*o;break;case this.N_POLE:h=s+f,r=this.qp-r;break;case this.S_POLE:h=f-s,r=this.qp+r}if(Math.abs(h)<c)return null;switch(this.mode){case this.OBLIQ:case this.EQUIT:h=Math.sqrt(2/h),i=this.mode===this.OBLIQ?this.ymf*h*(this.cosb1*l-this.sinb1*u*o):(h=Math.sqrt(2/(1+u*o)))*l*this.ymf,e=this.xmf*h*u*n;break;case this.N_POLE:case this.S_POLE:r>=0?(e=(h=Math.sqrt(r))*n,i=o*(this.mode===this.S_POLE?h:-h)):e=i=0}}return t.x=this.a*e+this.x0,t.y=this.a*i+this.y0,t},inverse:function(t){t.x-=this.x0,t.y-=this.y0;var e,i,o,n,a,r,l,u,h,d,p=t.x/this.a,m=t.y/this.a;if(this.sphere){var f,_=0,g=0;if((i=.5*(f=Math.sqrt(p*p+m*m)))>1)return null;switch(i=2*Math.asin(i),this.mode!==this.OBLIQ&&this.mode!==this.EQUIT||(g=Math.sin(i),_=Math.cos(i)),this.mode){case this.EQUIT:i=Math.abs(f)<=c?0:Math.asin(m*g/f),p*=g,m=_*f;break;case this.OBLIQ:i=Math.abs(f)<=c?this.lat0:Math.asin(_*this.sinph0+m*g*this.cosph0/f),p*=g*this.cosph0,m=(_-Math.sin(i)*this.sinph0)*f;break;case this.N_POLE:m=-m,i=s-i;break;case this.S_POLE:i-=s}e=0!==m||this.mode!==this.EQUIT&&this.mode!==this.OBLIQ?Math.atan2(p,m):0}else{if(l=0,this.mode===this.OBLIQ||this.mode===this.EQUIT){if(p/=this.dd,m*=this.dd,(r=Math.sqrt(p*p+m*m))<c)return t.x=this.long0,t.y=this.lat0,t;n=2*Math.asin(.5*r/this.rq),o=Math.cos(n),p*=n=Math.sin(n),this.mode===this.OBLIQ?(l=o*this.sinb1+m*n*this.cosb1/r,a=this.qp*l,m=r*this.cosb1*o-m*this.sinb1*n):(l=m*n/r,a=this.qp*l,m=r*o)}else if(this.mode===this.N_POLE||this.mode===this.S_POLE){if(this.mode===this.N_POLE&&(m=-m),!(a=p*p+m*m))return t.x=this.long0,t.y=this.lat0,t;l=1-a/this.qp,this.mode===this.S_POLE&&(l=-l)}e=Math.atan2(p,m),u=Math.asin(l),h=this.apa,d=u+u,i=u+h[0]*Math.sin(d)+h[1]*Math.sin(d+d)+h[2]*Math.sin(d+d+d)}return t.x=j(this.long0+e),t.y=i,t},names:["Lambert Azimuthal Equal Area","Lambert_Azimuthal_Equal_Area","laea"],S_POLE:1,N_POLE:2,EQUIT:3,OBLIQ:4},fe=function(t){return Math.abs(t)>1&&(t=t>1?1:-1),Math.asin(t)},_e={init:function(){Math.abs(this.lat1+this.lat2)<c||(this.temp=this.b/this.a,this.es=1-Math.pow(this.temp,2),this.e3=Math.sqrt(this.es),this.sin_po=Math.sin(this.lat1),this.cos_po=Math.cos(this.lat1),this.t1=this.sin_po,this.con=this.sin_po,this.ms1=N(this.e3,this.sin_po,this.cos_po),this.qs1=re(this.e3,this.sin_po,this.cos_po),this.sin_po=Math.sin(this.lat2),this.cos_po=Math.cos(this.lat2),this.t2=this.sin_po,this.ms2=N(this.e3,this.sin_po,this.cos_po),this.qs2=re(this.e3,this.sin_po,this.cos_po),this.sin_po=Math.sin(this.lat0),this.cos_po=Math.cos(this.lat0),this.t3=this.sin_po,this.qs0=re(this.e3,this.sin_po,this.cos_po),Math.abs(this.lat1-this.lat2)>c?this.ns0=(this.ms1*this.ms1-this.ms2*this.ms2)/(this.qs2-this.qs1):this.ns0=this.con,this.c=this.ms1*this.ms1+this.ns0*this.qs1,this.rh=this.a*Math.sqrt(this.c-this.ns0*this.qs0)/this.ns0)},forward:function(t){var e=t.x,i=t.y;this.sin_phi=Math.sin(i),this.cos_phi=Math.cos(i);var o=re(this.e3,this.sin_phi,this.cos_phi),n=this.a*Math.sqrt(this.c-this.ns0*o)/this.ns0,s=this.ns0*j(e-this.long0),a=n*Math.sin(s)+this.x0,r=this.rh-n*Math.cos(s)+this.y0;return t.x=a,t.y=r,t},inverse:function(t){var e,i,o,n,s,a;return t.x-=this.x0,t.y=this.rh-t.y+this.y0,this.ns0>=0?(e=Math.sqrt(t.x*t.x+t.y*t.y),o=1):(e=-Math.sqrt(t.x*t.x+t.y*t.y),o=-1),n=0,0!==e&&(n=Math.atan2(o*t.x,o*t.y)),o=e*this.ns0/this.a,this.sphere?a=Math.asin((this.c-o*o)/(2*this.ns0)):(i=(this.c-o*o)/this.ns0,a=this.phi1z(this.e3,i)),s=j(n/this.ns0+this.long0),t.x=s,t.y=a,t},names:["Albers_Conic_Equal_Area","Albers","aea"],phi1z:function(t,e){var i,o,n,s,a=fe(.5*e);if(t<c)return a;for(var r=t*t,l=1;l<=25;l++)if(a+=s=.5*(n=1-(o=t*(i=Math.sin(a)))*o)*n/Math.cos(a)*(e/(1-r)-i/n+.5/t*Math.log((1-o)/(1+o))),Math.abs(s)<=1e-7)return a;return null}},ge={init:function(){this.sin_p14=Math.sin(this.lat0),this.cos_p14=Math.cos(this.lat0),this.infinity_dist=1e3*this.a,this.rc=1},forward:function(t){var e,i,o,n,s,a,r,l=t.x,u=t.y;return o=j(l-this.long0),e=Math.sin(u),i=Math.cos(u),n=Math.cos(o),(s=this.sin_p14*e+this.cos_p14*i*n)>0||Math.abs(s)<=c?(a=this.x0+1*this.a*i*Math.sin(o)/s,r=this.y0+1*this.a*(this.cos_p14*e-this.sin_p14*i*n)/s):(a=this.x0+this.infinity_dist*i*Math.sin(o),r=this.y0+this.infinity_dist*(this.cos_p14*e-this.sin_p14*i*n)),t.x=a,t.y=r,t},inverse:function(t){var e,i,o,n,s,a;return t.x=(t.x-this.x0)/this.a,t.y=(t.y-this.y0)/this.a,t.x/=this.k0,t.y/=this.k0,(e=Math.sqrt(t.x*t.x+t.y*t.y))?(n=Math.atan2(e,this.rc),i=Math.sin(n),o=Math.cos(n),a=fe(o*this.sin_p14+t.y*i*this.cos_p14/e),s=Math.atan2(t.x*i,e*this.cos_p14*o-t.y*this.sin_p14*i),s=j(this.long0+s)):(a=this.phic0,s=0),t.x=s,t.y=a,t},names:["gnom"]},ve=function(t,e){var i=1-(1-t*t)/(2*t)*Math.log((1-t)/(1+t));if(Math.abs(Math.abs(e)-i)<1e-6)return e<0?-1*s:s;for(var o,n,a,r,l=Math.asin(.5*e),c=0;c<30;c++)if(n=Math.sin(l),a=Math.cos(l),r=t*n,l+=o=Math.pow(1-r*r,2)/(2*a)*(e/(1-t*t)-n/(1-r*r)+.5/t*Math.log((1-r)/(1+r))),Math.abs(o)<=1e-10)return l;return NaN},ye={init:function(){this.sphere||(this.k0=N(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)))},forward:function(t){var e,i,o=t.x,n=t.y,s=j(o-this.long0);if(this.sphere)e=this.x0+this.a*s*Math.cos(this.lat_ts),i=this.y0+this.a*Math.sin(n)/Math.cos(this.lat_ts);else{var a=re(this.e,Math.sin(n));e=this.x0+this.a*this.k0*s,i=this.y0+this.a*a*.5/this.k0}return t.x=e,t.y=i,t},inverse:function(t){var e,i;return t.x-=this.x0,t.y-=this.y0,this.sphere?(e=j(this.long0+t.x/this.a/Math.cos(this.lat_ts)),i=Math.asin(t.y/this.a*Math.cos(this.lat_ts))):(i=ve(this.e,2*t.y*this.k0/this.a),e=j(this.long0+t.x/(this.a*this.k0))),t.x=e,t.y=i,t},names:["cea"]},Ee={init:function(){this.x0=this.x0||0,this.y0=this.y0||0,this.lat0=this.lat0||0,this.long0=this.long0||0,this.lat_ts=this.lat_ts||0,this.title=this.title||"Equidistant Cylindrical (Plate Carre)",this.rc=Math.cos(this.lat_ts)},forward:function(t){var e=t.x,i=t.y,o=j(e-this.long0),n=ne(i-this.lat0);return t.x=this.x0+this.a*o*this.rc,t.y=this.y0+this.a*n,t},inverse:function(t){var e=t.x,i=t.y;return t.x=j(this.long0+(e-this.x0)/(this.a*this.rc)),t.y=ne(this.lat0+(i-this.y0)/this.a),t},names:["Equirectangular","Equidistant_Cylindrical","eqc"]},Pe=20,we={init:function(){this.temp=this.b/this.a,this.es=1-Math.pow(this.temp,2),this.e=Math.sqrt(this.es),this.e0=$t(this.es),this.e1=te(this.es),this.e2=ee(this.es),this.e3=ie(this.es),this.ml0=this.a*Jt(this.e0,this.e1,this.e2,this.e3,this.lat0)},forward:function(t){var e,i,o,n=t.x,s=t.y,a=j(n-this.long0);if(o=a*Math.sin(s),this.sphere)Math.abs(s)<=c?(e=this.a*a,i=-1*this.a*this.lat0):(e=this.a*Math.sin(o)/Math.tan(s),i=this.a*(ne(s-this.lat0)+(1-Math.cos(o))/Math.tan(s)));else if(Math.abs(s)<=c)e=this.a*a,i=-1*this.ml0;else{var r=oe(this.a,this.e,Math.sin(s))/Math.tan(s);e=r*Math.sin(o),i=this.a*Jt(this.e0,this.e1,this.e2,this.e3,s)-this.ml0+r*(1-Math.cos(o))}return t.x=e+this.x0,t.y=i+this.y0,t},inverse:function(t){var e,i,o,n,s,a,r,l,u;if(o=t.x-this.x0,n=t.y-this.y0,this.sphere)if(Math.abs(n+this.a*this.lat0)<=c)e=j(o/this.a+this.long0),i=0;else{var h;for(a=this.lat0+n/this.a,r=o*o/this.a/this.a+a*a,l=a,s=Pe;s;--s)if(l+=u=-1*(a*(l*(h=Math.tan(l))+1)-l-.5*(l*l+r)*h)/((l-a)/h-1),Math.abs(u)<=c){i=l;break}e=j(this.long0+Math.asin(o*Math.tan(l)/this.a)/Math.sin(i))}else if(Math.abs(n+this.ml0)<=c)i=0,e=j(this.long0+o/this.a);else{var d,p,m,f,_;for(a=(this.ml0+n)/this.a,r=o*o/this.a/this.a+a*a,l=a,s=Pe;s;--s)if(_=this.e*Math.sin(l),d=Math.sqrt(1-_*_)*Math.tan(l),p=this.a*Jt(this.e0,this.e1,this.e2,this.e3,l),m=this.e0-2*this.e1*Math.cos(2*l)+4*this.e2*Math.cos(4*l)-6*this.e3*Math.cos(6*l),l-=u=(a*(d*(f=p/this.a)+1)-f-.5*d*(f*f+r))/(this.es*Math.sin(2*l)*(f*f+r-2*a*f)/(4*d)+(a-f)*(d*m-2/Math.sin(2*l))-m),Math.abs(u)<=c){i=l;break}d=Math.sqrt(1-this.es*Math.pow(Math.sin(i),2))*Math.tan(i),e=j(this.long0+Math.asin(o*d/this.a)/Math.sin(i))}return t.x=e,t.y=i,t},names:["Polyconic","poly"]},Ce={init:function(){this.A=[],this.A[1]=.6399175073,this.A[2]=-.1358797613,this.A[3]=.063294409,this.A[4]=-.02526853,this.A[5]=.0117879,this.A[6]=-.0055161,this.A[7]=.0026906,this.A[8]=-.001333,this.A[9]=67e-5,this.A[10]=-34e-5,this.B_re=[],this.B_im=[],this.B_re[1]=.7557853228,this.B_im[1]=0,this.B_re[2]=.249204646,this.B_im[2]=.003371507,this.B_re[3]=-.001541739,this.B_im[3]=.04105856,this.B_re[4]=-.10162907,this.B_im[4]=.01727609,this.B_re[5]=-.26623489,this.B_im[5]=-.36249218,this.B_re[6]=-.6870983,this.B_im[6]=-1.1651967,this.C_re=[],this.C_im=[],this.C_re[1]=1.3231270439,this.C_im[1]=0,this.C_re[2]=-.577245789,this.C_im[2]=-.007809598,this.C_re[3]=.508307513,this.C_im[3]=-.112208952,this.C_re[4]=-.15094762,this.C_im[4]=.18200602,this.C_re[5]=1.01418179,this.C_im[5]=1.64497696,this.C_re[6]=1.9660549,this.C_im[6]=2.5127645,this.D=[],this.D[1]=1.5627014243,this.D[2]=.5185406398,this.D[3]=-.03333098,this.D[4]=-.1052906,this.D[5]=-.0368594,this.D[6]=.007317,this.D[7]=.0122,this.D[8]=.00394,this.D[9]=-.0013},forward:function(t){var e,i=t.x,o=t.y-this.lat0,s=i-this.long0,a=o/n*1e-5,r=s,l=1,c=0;for(e=1;e<=10;e++)l*=a,c+=this.A[e]*l;var u,h=c,d=r,p=1,m=0,f=0,_=0;for(e=1;e<=6;e++)u=m*h+p*d,p=p*h-m*d,m=u,f=f+this.B_re[e]*p-this.B_im[e]*m,_=_+this.B_im[e]*p+this.B_re[e]*m;return t.x=_*this.a+this.x0,t.y=f*this.a+this.y0,t},inverse:function(t){var e,i,o=t.x,s=t.y,a=o-this.x0,r=(s-this.y0)/this.a,l=a/this.a,c=1,u=0,h=0,d=0;for(e=1;e<=6;e++)i=u*r+c*l,c=c*r-u*l,u=i,h=h+this.C_re[e]*c-this.C_im[e]*u,d=d+this.C_im[e]*c+this.C_re[e]*u;for(var p=0;p<this.iterations;p++){var m,f=h,_=d,g=r,v=l;for(e=2;e<=6;e++)m=_*h+f*d,f=f*h-_*d,_=m,g+=(e-1)*(this.B_re[e]*f-this.B_im[e]*_),v+=(e-1)*(this.B_im[e]*f+this.B_re[e]*_);f=1,_=0;var y=this.B_re[1],E=this.B_im[1];for(e=2;e<=6;e++)m=_*h+f*d,f=f*h-_*d,_=m,y+=e*(this.B_re[e]*f-this.B_im[e]*_),E+=e*(this.B_im[e]*f+this.B_re[e]*_);var P=y*y+E*E;h=(g*y+v*E)/P,d=(v*y-g*E)/P}var w=h,C=d,M=1,S=0;for(e=1;e<=9;e++)M*=w,S+=this.D[e]*M;var L=this.lat0+S*n*1e5,b=this.long0+C;return t.x=b,t.y=L,t},names:["New_Zealand_Map_Grid","nzmg"]},Me={init:function(){},forward:function(t){var e=t.x,i=t.y,o=j(e-this.long0),n=this.x0+this.a*o,s=this.y0+this.a*Math.log(Math.tan(Math.PI/4+i/2.5))*1.25;return t.x=n,t.y=s,t},inverse:function(t){t.x-=this.x0,t.y-=this.y0;var e=j(this.long0+t.x/this.a),i=2.5*(Math.atan(Math.exp(.8*t.y/this.a))-Math.PI/4);return t.x=e,t.y=i,t},names:["Miller_Cylindrical","mill"]},Se=20,Le={init:function(){this.sphere?(this.n=1,this.m=0,this.es=0,this.C_y=Math.sqrt((this.m+1)/this.n),this.C_x=this.C_y/(this.m+1)):this.en=It(this.es)},forward:function(t){var e,i,o=t.x,n=t.y;if(o=j(o-this.long0),this.sphere){if(this.m)for(var s=this.n*Math.sin(n),a=Se;a;--a){var r=(this.m*n+Math.sin(n)-s)/(this.m+Math.cos(n));if(n-=r,Math.abs(r)<c)break}else n=1!==this.n?Math.asin(this.n*Math.sin(n)):n;e=this.a*this.C_x*o*(this.m+Math.cos(n)),i=this.a*this.C_y*n}else{var l=Math.sin(n),u=Math.cos(n);i=this.a*Gt(n,l,u,this.en),e=this.a*o*u/Math.sqrt(1-this.es*l*l)}return t.x=e,t.y=i,t},inverse:function(t){var e,i,o,n;return t.x-=this.x0,o=t.x/this.a,t.y-=this.y0,e=t.y/this.a,this.sphere?(e/=this.C_y,o/=this.C_x*(this.m+Math.cos(e)),this.m?e=fe((this.m*e+Math.sin(e))/this.n):1!==this.n&&(e=fe(Math.sin(e)/this.n)),o=j(o+this.long0),e=ne(e)):(e=At(t.y/this.a,this.es,this.en),(n=Math.abs(e))<s?(n=Math.sin(e),i=this.long0+t.x*Math.sqrt(1-this.es*n*n)/(this.a*Math.cos(e)),o=j(i)):n-c<s&&(o=this.long0)),t.x=o,t.y=e,t},names:["Sinusoidal","sinu"]},be={init:function(){},forward:function(t){for(var e=t.x,i=t.y,o=j(e-this.long0),n=i,s=Math.PI*Math.sin(i);;){var a=-(n+Math.sin(n)-s)/(1+Math.cos(n));if(n+=a,Math.abs(a)<c)break}n/=2,Math.PI/2-Math.abs(i)<c&&(o=0);var r=.900316316158*this.a*o*Math.cos(n)+this.x0,l=1.4142135623731*this.a*Math.sin(n)+this.y0;return t.x=r,t.y=l,t},inverse:function(t){var e,i;t.x-=this.x0,t.y-=this.y0,i=t.y/(1.4142135623731*this.a),Math.abs(i)>.999999999999&&(i=.999999999999),e=Math.asin(i);var o=j(this.long0+t.x/(.900316316158*this.a*Math.cos(e)));o<-Math.PI&&(o=-Math.PI),o>Math.PI&&(o=Math.PI),i=(2*e+Math.sin(2*e))/Math.PI,Math.abs(i)>1&&(i=1);var n=Math.asin(i);return t.x=o,t.y=n,t},names:["Mollweide","moll"]},Re={init:function(){Math.abs(this.lat1+this.lat2)<c||(this.lat2=this.lat2||this.lat1,this.temp=this.b/this.a,this.es=1-Math.pow(this.temp,2),this.e=Math.sqrt(this.es),this.e0=$t(this.es),this.e1=te(this.es),this.e2=ee(this.es),this.e3=ie(this.es),this.sinphi=Math.sin(this.lat1),this.cosphi=Math.cos(this.lat1),this.ms1=N(this.e,this.sinphi,this.cosphi),this.ml1=Jt(this.e0,this.e1,this.e2,this.e3,this.lat1),Math.abs(this.lat1-this.lat2)<c?this.ns=this.sinphi:(this.sinphi=Math.sin(this.lat2),this.cosphi=Math.cos(this.lat2),this.ms2=N(this.e,this.sinphi,this.cosphi),this.ml2=Jt(this.e0,this.e1,this.e2,this.e3,this.lat2),this.ns=(this.ms1-this.ms2)/(this.ml2-this.ml1)),this.g=this.ml1+this.ms1/this.ns,this.ml0=Jt(this.e0,this.e1,this.e2,this.e3,this.lat0),this.rh=this.a*(this.g-this.ml0))},forward:function(t){var e,i=t.x,o=t.y;if(this.sphere)e=this.a*(this.g-o);else{var n=Jt(this.e0,this.e1,this.e2,this.e3,o);e=this.a*(this.g-n)}var s=this.ns*j(i-this.long0),a=this.x0+e*Math.sin(s),r=this.y0+this.rh-e*Math.cos(s);return t.x=a,t.y=r,t},inverse:function(t){var e,i,o,n;t.x-=this.x0,t.y=this.rh-t.y+this.y0,this.ns>=0?(i=Math.sqrt(t.x*t.x+t.y*t.y),e=1):(i=-Math.sqrt(t.x*t.x+t.y*t.y),e=-1);var s=0;if(0!==i&&(s=Math.atan2(e*t.x,e*t.y)),this.sphere)return n=j(this.long0+s/this.ns),o=ne(this.g-i/this.a),t.x=n,t.y=o,t;var a=this.g-i/this.a;return o=se(a,this.e0,this.e1,this.e2,this.e3),n=j(this.long0+s/this.ns),t.x=n,t.y=o,t},names:["Equidistant_Conic","eqdc"]},xe={init:function(){this.R=this.a},forward:function(t){var e,i,o=t.x,n=t.y,a=j(o-this.long0);Math.abs(n)<=c&&(e=this.x0+this.R*a,i=this.y0);var r=fe(2*Math.abs(n/Math.PI));(Math.abs(a)<=c||Math.abs(Math.abs(n)-s)<=c)&&(e=this.x0,i=n>=0?this.y0+Math.PI*this.R*Math.tan(.5*r):this.y0+Math.PI*this.R*-Math.tan(.5*r));var l=.5*Math.abs(Math.PI/a-a/Math.PI),u=l*l,h=Math.sin(r),d=Math.cos(r),p=d/(h+d-1),m=p*p,f=p*(2/h-1),_=f*f,g=Math.PI*this.R*(l*(p-_)+Math.sqrt(u*(p-_)*(p-_)-(_+u)*(m-_)))/(_+u);a<0&&(g=-g),e=this.x0+g;var v=u+p;return g=Math.PI*this.R*(f*v-l*Math.sqrt((_+u)*(u+1)-v*v))/(_+u),i=n>=0?this.y0+g:this.y0-g,t.x=e,t.y=i,t},inverse:function(t){var e,i,o,n,s,a,r,l,u,h,d,p;return t.x-=this.x0,t.y-=this.y0,d=Math.PI*this.R,s=(o=t.x/d)*o+(n=t.y/d)*n,d=3*(n*n/(l=-2*(a=-Math.abs(n)*(1+s))+1+2*n*n+s*s)+(2*(r=a-2*n*n+o*o)*r*r/l/l/l-9*a*r/l/l)/27)/(u=(a-r*r/3/l)/l)/(h=2*Math.sqrt(-u/3)),Math.abs(d)>1&&(d=d>=0?1:-1),p=Math.acos(d)/3,i=t.y>=0?(-h*Math.cos(p+Math.PI/3)-r/3/l)*Math.PI:-(-h*Math.cos(p+Math.PI/3)-r/3/l)*Math.PI,e=Math.abs(o)<c?this.long0:j(this.long0+Math.PI*(s-1+Math.sqrt(1+2*(o*o-n*n)+s*s))/2/o),t.x=e,t.y=i,t},names:["Van_der_Grinten_I","VanDerGrinten","vandg"]},Ie={init:function(){this.sin_p12=Math.sin(this.lat0),this.cos_p12=Math.cos(this.lat0)},forward:function(t){var e,i,o,n,a,r,l,u,h,d,p,m,f,_,g,v,y,E,P,w,C,M,S=t.x,L=t.y,b=Math.sin(t.y),R=Math.cos(t.y),x=j(S-this.long0);return this.sphere?Math.abs(this.sin_p12-1)<=c?(t.x=this.x0+this.a*(s-L)*Math.sin(x),t.y=this.y0-this.a*(s-L)*Math.cos(x),t):Math.abs(this.sin_p12+1)<=c?(t.x=this.x0+this.a*(s+L)*Math.sin(x),t.y=this.y0+this.a*(s+L)*Math.cos(x),t):(E=this.sin_p12*b+this.cos_p12*R*Math.cos(x),y=(v=Math.acos(E))?v/Math.sin(v):1,t.x=this.x0+this.a*y*R*Math.sin(x),t.y=this.y0+this.a*y*(this.cos_p12*b-this.sin_p12*R*Math.cos(x)),t):(e=$t(this.es),i=te(this.es),o=ee(this.es),n=ie(this.es),Math.abs(this.sin_p12-1)<=c?(a=this.a*Jt(e,i,o,n,s),r=this.a*Jt(e,i,o,n,L),t.x=this.x0+(a-r)*Math.sin(x),t.y=this.y0-(a-r)*Math.cos(x),t):Math.abs(this.sin_p12+1)<=c?(a=this.a*Jt(e,i,o,n,s),r=this.a*Jt(e,i,o,n,L),t.x=this.x0+(a+r)*Math.sin(x),t.y=this.y0+(a+r)*Math.cos(x),t):(l=b/R,u=oe(this.a,this.e,this.sin_p12),h=oe(this.a,this.e,b),d=Math.atan((1-this.es)*l+this.es*u*this.sin_p12/(h*R)),P=0===(p=Math.atan2(Math.sin(x),this.cos_p12*Math.tan(d)-this.sin_p12*Math.cos(x)))?Math.asin(this.cos_p12*Math.sin(d)-this.sin_p12*Math.cos(d)):Math.abs(Math.abs(p)-Math.PI)<=c?-Math.asin(this.cos_p12*Math.sin(d)-this.sin_p12*Math.cos(d)):Math.asin(Math.sin(x)*Math.cos(d)/Math.sin(p)),m=this.e*this.sin_p12/Math.sqrt(1-this.es),v=u*P*(1-(w=P*P)*(g=(f=this.e*this.cos_p12*Math.cos(p)/Math.sqrt(1-this.es))*f)*(1-g)/6+(C=w*P)/8*(_=m*f)*(1-2*g)+(M=C*P)/120*(g*(4-7*g)-3*m*m*(1-7*g))-M*P/48*_),t.x=this.x0+v*Math.sin(p),t.y=this.y0+v*Math.cos(p),t))},inverse:function(t){var e,i,o,n,a,r,l,u,h,d,p,m,f,_,g,v,y,E,P,w,C,M,S;if(t.x-=this.x0,t.y-=this.y0,this.sphere){if((e=Math.sqrt(t.x*t.x+t.y*t.y))>2*s*this.a)return;return i=e/this.a,o=Math.sin(i),n=Math.cos(i),a=this.long0,Math.abs(e)<=c?r=this.lat0:(r=fe(n*this.sin_p12+t.y*o*this.cos_p12/e),l=Math.abs(this.lat0)-s,a=Math.abs(l)<=c?this.lat0>=0?j(this.long0+Math.atan2(t.x,-t.y)):j(this.long0-Math.atan2(-t.x,t.y)):j(this.long0+Math.atan2(t.x*o,e*this.cos_p12*n-t.y*this.sin_p12*o))),t.x=a,t.y=r,t}return u=$t(this.es),h=te(this.es),d=ee(this.es),p=ie(this.es),Math.abs(this.sin_p12-1)<=c?(m=this.a*Jt(u,h,d,p,s),e=Math.sqrt(t.x*t.x+t.y*t.y),r=se((m-e)/this.a,u,h,d,p),a=j(this.long0+Math.atan2(t.x,-1*t.y)),t.x=a,t.y=r,t):Math.abs(this.sin_p12+1)<=c?(m=this.a*Jt(u,h,d,p,s),e=Math.sqrt(t.x*t.x+t.y*t.y),r=se((e-m)/this.a,u,h,d,p),a=j(this.long0+Math.atan2(t.x,t.y)),t.x=a,t.y=r,t):(e=Math.sqrt(t.x*t.x+t.y*t.y),g=Math.atan2(t.x,t.y),f=oe(this.a,this.e,this.sin_p12),v=Math.cos(g),E=-(y=this.e*this.cos_p12*v)*y/(1-this.es),P=3*this.es*(1-E)*this.sin_p12*this.cos_p12*v/(1-this.es),M=1-E*(C=(w=e/f)-E*(1+E)*Math.pow(w,3)/6-P*(1+3*E)*Math.pow(w,4)/24)*C/2-w*C*C*C/6,_=Math.asin(this.sin_p12*Math.cos(C)+this.cos_p12*Math.sin(C)*v),a=j(this.long0+Math.asin(Math.sin(g)*Math.sin(C)/Math.cos(_))),S=Math.sin(_),r=Math.atan2((S-this.es*M*this.sin_p12)*Math.tan(_),S*(1-this.es)),t.x=a,t.y=r,t)},names:["Azimuthal_Equidistant","aeqd"]},Ge={init:function(){this.sin_p14=Math.sin(this.lat0),this.cos_p14=Math.cos(this.lat0)},forward:function(t){var e,i,o,n,s,a,r,l=t.x,u=t.y;return o=j(l-this.long0),e=Math.sin(u),i=Math.cos(u),n=Math.cos(o),((s=this.sin_p14*e+this.cos_p14*i*n)>0||Math.abs(s)<=c)&&(a=1*this.a*i*Math.sin(o),r=this.y0+1*this.a*(this.cos_p14*e-this.sin_p14*i*n)),t.x=a,t.y=r,t},inverse:function(t){var e,i,o,n,a,r,l;return t.x-=this.x0,t.y-=this.y0,e=Math.sqrt(t.x*t.x+t.y*t.y),i=fe(e/this.a),o=Math.sin(i),n=Math.cos(i),r=this.long0,Math.abs(e)<=c?(l=this.lat0,t.x=r,t.y=l,t):(l=fe(n*this.sin_p14+t.y*o*this.cos_p14/e),a=Math.abs(this.lat0)-s,Math.abs(a)<=c?(r=this.lat0>=0?j(this.long0+Math.atan2(t.x,-t.y)):j(this.long0-Math.atan2(-t.x,t.y)),t.x=r,t.y=l,t):(r=j(this.long0+Math.atan2(t.x*o,e*this.cos_p14*n-t.y*this.sin_p14*o)),t.x=r,t.y=l,t))},names:["ortho"]},Ae={FRONT:1,RIGHT:2,BACK:3,LEFT:4,TOP:5,BOTTOM:6},Te={AREA_0:1,AREA_1:2,AREA_2:3,AREA_3:4};function ke(t,e,i,o){var n;return t<c?(o.value=Te.AREA_0,n=0):(n=Math.atan2(e,i),Math.abs(n)<=d?o.value=Te.AREA_0:n>d&&n<=s+d?(o.value=Te.AREA_1,n-=s):n>s+d||n<=-(s+d)?(o.value=Te.AREA_2,n=n>=0?n-m:n+m):(o.value=Te.AREA_3,n+=s)),n}function De(t,e){var i=t+e;return i<-m?i+=p:i>+m&&(i-=p),i}var Oe,Ne={init:function(){this.x0=this.x0||0,this.y0=this.y0||0,this.lat0=this.lat0||0,this.long0=this.long0||0,this.lat_ts=this.lat_ts||0,this.title=this.title||"Quadrilateralized Spherical Cube",this.lat0>=s-d/2?this.face=Ae.TOP:this.lat0<=-(s-d/2)?this.face=Ae.BOTTOM:Math.abs(this.long0)<=d?this.face=Ae.FRONT:Math.abs(this.long0)<=s+d?this.face=this.long0>0?Ae.RIGHT:Ae.LEFT:this.face=Ae.BACK,0!==this.es&&(this.one_minus_f=1-(this.a-this.b)/this.a,this.one_minus_f_squared=this.one_minus_f*this.one_minus_f)},forward:function(t){var e,i,o,n,a,r,l={x:0,y:0},c={value:0};if(t.x-=this.long0,e=0!==this.es?Math.atan(this.one_minus_f_squared*Math.tan(t.y)):t.y,i=t.x,this.face===Ae.TOP)n=s-e,i>=d&&i<=s+d?(c.value=Te.AREA_0,o=i-s):i>s+d||i<=-(s+d)?(c.value=Te.AREA_1,o=i>0?i-m:i+m):i>-(s+d)&&i<=-d?(c.value=Te.AREA_2,o=i+s):(c.value=Te.AREA_3,o=i);else if(this.face===Ae.BOTTOM)n=s+e,i>=d&&i<=s+d?(c.value=Te.AREA_0,o=-i+s):i<d&&i>=-d?(c.value=Te.AREA_1,o=-i):i<-d&&i>=-(s+d)?(c.value=Te.AREA_2,o=-i-s):(c.value=Te.AREA_3,o=i>0?-i+m:-i-m);else{var u,h,p,f,_,g;this.face===Ae.RIGHT?i=De(i,+s):this.face===Ae.BACK?i=De(i,+m):this.face===Ae.LEFT&&(i=De(i,-s)),f=Math.sin(e),_=Math.cos(e),g=Math.sin(i),u=_*Math.cos(i),h=_*g,p=f,this.face===Ae.FRONT?o=ke(n=Math.acos(u),p,h,c):this.face===Ae.RIGHT?o=ke(n=Math.acos(h),p,-u,c):this.face===Ae.BACK?o=ke(n=Math.acos(-u),p,-h,c):this.face===Ae.LEFT?o=ke(n=Math.acos(-h),p,u,c):(n=o=0,c.value=Te.AREA_0)}return r=Math.atan(12/m*(o+Math.acos(Math.sin(o)*Math.cos(d))-s)),a=Math.sqrt((1-Math.cos(n))/(Math.cos(r)*Math.cos(r))/(1-Math.cos(Math.atan(1/Math.cos(o))))),c.value===Te.AREA_1?r+=s:c.value===Te.AREA_2?r+=m:c.value===Te.AREA_3&&(r+=1.5*m),l.x=a*Math.cos(r),l.y=a*Math.sin(r),l.x=l.x*this.a+this.x0,l.y=l.y*this.a+this.y0,t.x=l.x,t.y=l.y,t},inverse:function(t){var e,i,o,n,a,r,l,c,u,h,d,p,f={lam:0,phi:0},_={value:0};if(t.x=(t.x-this.x0)/this.a,t.y=(t.y-this.y0)/this.a,i=Math.atan(Math.sqrt(t.x*t.x+t.y*t.y)),e=Math.atan2(t.y,t.x),t.x>=0&&t.x>=Math.abs(t.y)?_.value=Te.AREA_0:t.y>=0&&t.y>=Math.abs(t.x)?(_.value=Te.AREA_1,e-=s):t.x<0&&-t.x>=Math.abs(t.y)?(_.value=Te.AREA_2,e=e<0?e+m:e-m):(_.value=Te.AREA_3,e+=s),u=m/12*Math.tan(e),a=Math.sin(u)/(Math.cos(u)-1/Math.sqrt(2)),r=Math.atan(a),(l=1-(o=Math.cos(e))*o*(n=Math.tan(i))*n*(1-Math.cos(Math.atan(1/Math.cos(r)))))<-1?l=-1:l>1&&(l=1),this.face===Ae.TOP)c=Math.acos(l),f.phi=s-c,_.value===Te.AREA_0?f.lam=r+s:_.value===Te.AREA_1?f.lam=r<0?r+m:r-m:_.value===Te.AREA_2?f.lam=r-s:f.lam=r;else if(this.face===Ae.BOTTOM)c=Math.acos(l),f.phi=c-s,_.value===Te.AREA_0?f.lam=-r+s:_.value===Te.AREA_1?f.lam=-r:_.value===Te.AREA_2?f.lam=-r-s:f.lam=r<0?-r-m:-r+m;else{var g,v,y;u=(g=l)*g,v=(u+=(y=u>=1?0:Math.sqrt(1-u)*Math.sin(r))*y)>=1?0:Math.sqrt(1-u),_.value===Te.AREA_1?(u=v,v=-y,y=u):_.value===Te.AREA_2?(v=-v,y=-y):_.value===Te.AREA_3&&(u=v,v=y,y=-u),this.face===Ae.RIGHT?(u=g,g=-v,v=u):this.face===Ae.BACK?(g=-g,v=-v):this.face===Ae.LEFT&&(u=g,g=v,v=-u),f.phi=Math.acos(-y)-s,f.lam=Math.atan2(v,g),this.face===Ae.RIGHT?f.lam=De(f.lam,-s):this.face===Ae.BACK?f.lam=De(f.lam,-m):this.face===Ae.LEFT&&(f.lam=De(f.lam,+s))}return 0!==this.es&&(h=f.phi<0?1:0,d=Math.tan(f.phi),p=this.b/Math.sqrt(d*d+this.one_minus_f_squared),f.phi=Math.atan(Math.sqrt(this.a*this.a-p*p)/(this.one_minus_f*p)),h&&(f.phi=-f.phi)),f.lam+=this.long0,t.x=f.lam,t.y=f.phi,t},names:["Quadrilateralized Spherical Cube","Quadrilateralized_Spherical_Cube","qsc"]},Ue=[[1,22199e-21,-715515e-10,31103e-10],[.9986,-482243e-9,-24897e-9,-13309e-10],[.9954,-83103e-8,-448605e-10,-9.86701e-7],[.99,-.00135364,-59661e-9,36777e-10],[.9822,-.00167442,-449547e-11,-572411e-11],[.973,-.00214868,-903571e-10,1.8736e-8],[.96,-.00305085,-900761e-10,164917e-11],[.9427,-.00382792,-653386e-10,-26154e-10],[.9216,-.00467746,-10457e-8,481243e-11],[.8962,-.00536223,-323831e-10,-543432e-11],[.8679,-.00609363,-113898e-9,332484e-11],[.835,-.00698325,-640253e-10,9.34959e-7],[.7986,-.00755338,-500009e-10,9.35324e-7],[.7597,-.00798324,-35971e-9,-227626e-11],[.7186,-.00851367,-701149e-10,-86303e-10],[.6732,-.00986209,-199569e-9,191974e-10],[.6213,-.010418,883923e-10,624051e-11],[.5722,-.00906601,182e-6,624051e-11],[.5322,-.00677797,275608e-9,624051e-11]],je=[[-520417e-23,.0124,121431e-23,-845284e-16],[.062,.0124,-1.26793e-9,4.22642e-10],[.124,.0124,5.07171e-9,-1.60604e-9],[.186,.0123999,-1.90189e-8,6.00152e-9],[.248,.0124002,7.10039e-8,-2.24e-8],[.31,.0123992,-2.64997e-7,8.35986e-8],[.372,.0124029,9.88983e-7,-3.11994e-7],[.434,.0123893,-369093e-11,-4.35621e-7],[.4958,.0123198,-102252e-10,-3.45523e-7],[.5571,.0121916,-154081e-10,-5.82288e-7],[.6176,.0119938,-241424e-10,-5.25327e-7],[.6769,.011713,-320223e-10,-5.16405e-7],[.7346,.0113541,-397684e-10,-6.09052e-7],[.7903,.0109107,-489042e-10,-104739e-11],[.8435,.0103431,-64615e-9,-1.40374e-9],[.8936,.00969686,-64636e-9,-8547e-9],[.9394,.00840947,-192841e-9,-42106e-10],[.9761,.00616527,-256e-6,-42106e-10],[1,.00328947,-319159e-9,-42106e-10]],Fe=.8487,Be=1.3523,ze=h/5,qe=1/ze,He=18,We=function(t,e){return t[0]+e*(t[1]+e*(t[2]+e*t[3]))},Ve=function(t,e){return t[1]+e*(2*t[2]+3*e*t[3])},Ye={init:function(){this.x0=this.x0||0,this.y0=this.y0||0,this.long0=this.long0||0,this.es=0,this.title=this.title||"Robinson"},forward:function(t){var e=j(t.x-this.long0),i=Math.abs(t.y),o=Math.floor(i*ze);o<0?o=0:o>=He&&(o=He-1),i=h*(i-qe*o);var n={x:We(Ue[o],i)*e,y:We(je[o],i)};return t.y<0&&(n.y=-n.y),n.x=n.x*this.a*Fe+this.x0,n.y=n.y*this.a*Be+this.y0,n},inverse:function(t){var e={x:(t.x-this.x0)/(this.a*Fe),y:Math.abs(t.y-this.y0)/(this.a*Be)};if(e.y>=1)e.x/=Ue[He][0],e.y=t.y<0?-s:s;else{var i=Math.floor(e.y*He);for(i<0?i=0:i>=He&&(i=He-1);;)if(je[i][0]>e.y)--i;else{if(!(je[i+1][0]<=e.y))break;++i}var o=je[i],n=5*(e.y-o[0])/(je[i+1][0]-o[0]);n=function(t,e,i,o){for(var n=e;o;--o){var s=t(n);if(n-=s,Math.abs(s)<i)break}return n}((function(t){return(We(o,t)-e.y)/Ve(o,t)}),n,c,100),e.x/=We(Ue[i],n),e.y=(5*i+n)*u,t.y<0&&(e.y=-e.y)}return e.x=j(e.x+this.long0),e},names:["Robinson","robin"]},Xe={init:function(){this.name="geocent"},forward:function(t){return J(t,this.es,this.a)},inverse:function(t){return $(t,this.es,this.a,this.b)},names:["Geocentric","geocentric","geocent","Geocent"]},Ke={N_POLE:0,S_POLE:1,EQUIT:2,OBLIQ:3},Ze={h:{def:1e5,num:!0},azi:{def:0,num:!0,degrees:!0},tilt:{def:0,num:!0,degrees:!0},long0:{def:0,num:!0},lat0:{def:0,num:!0}},Qe={init:function(){if(Object.keys(Ze).forEach(function(t){if(void 0===this[t])this[t]=Ze[t].def;else{if(Ze[t].num&&isNaN(this[t]))throw new Error("Invalid parameter value, must be numeric "+t+" = "+this[t]);Ze[t].num&&(this[t]=parseFloat(this[t]))}Ze[t].degrees&&(this[t]=this[t]*u)}.bind(this)),Math.abs(Math.abs(this.lat0)-s)<c?this.mode=this.lat0<0?Ke.S_POLE:Ke.N_POLE:Math.abs(this.lat0)<c?this.mode=Ke.EQUIT:(this.mode=Ke.OBLIQ,this.sinph0=Math.sin(this.lat0),this.cosph0=Math.cos(this.lat0)),this.pn1=this.h/this.a,this.pn1<=0||this.pn1>1e10)throw new Error("Invalid height");this.p=1+this.pn1,this.rp=1/this.p,this.h1=1/this.pn1,this.pfact=(this.p+1)*this.h1,this.es=0;var t=this.tilt,e=this.azi;this.cg=Math.cos(e),this.sg=Math.sin(e),this.cw=Math.cos(t),this.sw=Math.sin(t)},forward:function(t){t.x-=this.long0;var e,i,o,n,s=Math.sin(t.y),a=Math.cos(t.y),r=Math.cos(t.x);switch(this.mode){case Ke.OBLIQ:i=this.sinph0*s+this.cosph0*a*r;break;case Ke.EQUIT:i=a*r;break;case Ke.S_POLE:i=-s;break;case Ke.N_POLE:i=s}switch(e=(i=this.pn1/(this.p-i))*a*Math.sin(t.x),this.mode){case Ke.OBLIQ:i*=this.cosph0*s-this.sinph0*a*r;break;case Ke.EQUIT:i*=s;break;case Ke.N_POLE:i*=-a*r;break;case Ke.S_POLE:i*=a*r}return n=1/((o=i*this.cg+e*this.sg)*this.sw*this.h1+this.cw),e=(e*this.cg-i*this.sg)*this.cw*n,i=o*n,t.x=e*this.a,t.y=i*this.a,t},inverse:function(t){t.x/=this.a,t.y/=this.a;var e,i,o,n={x:t.x,y:t.y};o=1/(this.pn1-t.y*this.sw),e=this.pn1*t.x*o,i=this.pn1*t.y*this.cw*o,t.x=e*this.cg+i*this.sg,t.y=i*this.cg-e*this.sg;var s=Dt(t.x,t.y);if(Math.abs(s)<c)n.x=0,n.y=t.y;else{var a,r;switch(r=1-s*s*this.pfact,r=(this.p-Math.sqrt(r))/(this.pn1/s+s/this.pn1),a=Math.sqrt(1-r*r),this.mode){case Ke.OBLIQ:n.y=Math.asin(a*this.sinph0+t.y*r*this.cosph0/s),t.y=(a-this.sinph0*Math.sin(n.y))*s,t.x*=r*this.cosph0;break;case Ke.EQUIT:n.y=Math.asin(t.y*r/s),t.y=a*s,t.x*=r;break;case Ke.N_POLE:n.y=Math.asin(a),t.y=-t.y;break;case Ke.S_POLE:n.y=-Math.asin(a)}n.x=Math.atan2(t.x,t.y)}return t.x=n.x+this.long0,t.y=n.y,t},names:["Tilted_Perspective","tpers"]};return ut.defaultDatum="WGS84",ut.Proj=Q,ut.WGS84=new ut.Proj("WGS84"),ut.Point=Rt,ut.toPoint=ot,ut.defs=A,ut.transform=at,ut.mgrs=yt,ut.version="2.6.3",(Oe=ut).Proj.projections.add(Tt),Oe.Proj.projections.add(Ft),Oe.Proj.projections.add(zt),Oe.Proj.projections.add(Vt),Oe.Proj.projections.add(Yt),Oe.Proj.projections.add(Xt),Oe.Proj.projections.add(Kt),Oe.Proj.projections.add(Zt),Oe.Proj.projections.add(Qt),Oe.Proj.projections.add(ae),Oe.Proj.projections.add(me),Oe.Proj.projections.add(_e),Oe.Proj.projections.add(ge),Oe.Proj.projections.add(ye),Oe.Proj.projections.add(Ee),Oe.Proj.projections.add(we),Oe.Proj.projections.add(Ce),Oe.Proj.projections.add(Me),Oe.Proj.projections.add(Le),Oe.Proj.projections.add(be),Oe.Proj.projections.add(Re),Oe.Proj.projections.add(xe),Oe.Proj.projections.add(Ie),Oe.Proj.projections.add(Ge),Oe.Proj.projections.add(Ne),Oe.Proj.projections.add(Ye),Oe.Proj.projections.add(Xe),Oe.Proj.projections.add(Qe),ut}()},function(t,e,i){var o,n,s;n=[i(2),i(151)],void 0===(s="function"==typeof(o=function(t,e){return e.__esModule&&e.default&&(e=e.default),t.Proj={},t.Proj._isProj4Obj=function(t){return void 0!==t.inverse&&void 0!==t.forward},t.Proj.Projection=t.Class.extend({initialize:function(e,i,o){var n=t.Proj._isProj4Obj(e);this._proj=n?e:this._projFromCodeDef(e,i),this.bounds=n?i:o},project:function(e){var i=this._proj.forward([e.lng,e.lat]);return new t.Point(i[0],i[1])},unproject:function(e,i){var o=this._proj.inverse([e.x,e.y]);return new t.LatLng(o[1],o[0],i)},_projFromCodeDef:function(t,i){if(i)e.defs(t,i);else if(void 0===e.defs[t]){var o=t.split(":");if(o.length>3&&(t=o[o.length-3]+":"+o[o.length-1]),void 0===e.defs[t])throw"No projection definition for code "+t}return e(t)}}),t.Proj.CRS=t.Class.extend({includes:t.CRS,options:{transformation:new t.Transformation(1,0,-1,0)},initialize:function(e,i,o){var n,s,a,r;if(t.Proj._isProj4Obj(e)?(n=(s=e).srsCode,r=i||{},this.projection=new t.Proj.Projection(s,r.bounds)):(n=e,a=i,r=o||{},this.projection=new t.Proj.Projection(n,a,r.bounds)),t.Util.setOptions(this,r),this.code=n,this.transformation=this.options.transformation,this.options.origin&&(this.transformation=new t.Transformation(1,-this.options.origin[0],-1,this.options.origin[1])),this.options.scales)this._scales=this.options.scales;else if(this.options.resolutions){this._scales=[];for(var l=this.options.resolutions.length-1;l>=0;l--)this.options.resolutions[l]&&(this._scales[l]=1/this.options.resolutions[l])}this.infinite=!this.options.bounds},scale:function(t){var e,i=Math.floor(t);return t===i?this._scales[t]:(e=this._scales[i])+(this._scales[i+1]-e)*(t-i)},zoom:function(t){var e,i,o=this._closestElement(this._scales,t),n=this._scales.indexOf(o);return t===o?n:void 0===o?-1/0:(i=n+1,void 0===(e=this._scales[i])?1/0:(t-o)/(e-o)+n)},distance:t.CRS.Earth.distance,R:t.CRS.Earth.R,_closestElement:function(t,e){for(var i,o=t.length;o--;)t[o]<=e&&(void 0===i||i<t[o])&&(i=t[o]);return i}}),t.Proj.GeoJSON=t.GeoJSON.extend({initialize:function(e,i){this._callLevel=0,t.GeoJSON.prototype.initialize.call(this,e,i)},addData:function(e){var i;e&&(e.crs&&"name"===e.crs.type?i=new t.Proj.CRS(e.crs.properties.name):e.crs&&e.crs.type&&(i=new t.Proj.CRS(e.crs.type+":"+e.crs.properties.code)),void 0!==i&&(this.options.coordsToLatLng=function(e){var o=t.point(e[0],e[1]);return i.projection.unproject(o)})),this._callLevel++;try{t.GeoJSON.prototype.addData.call(this,e)}finally{this._callLevel--,0===this._callLevel&&delete this.options.coordsToLatLng}}}),t.Proj.geoJson=function(e,i){return new t.Proj.GeoJSON(e,i)},t.Proj.ImageOverlay=t.ImageOverlay.extend({initialize:function(e,i,o){t.ImageOverlay.prototype.initialize.call(this,e,null,o),this._projectedBounds=i},_animateZoom:function(e){var i=this._map.getZoomScale(e.zoom),o=t.point(this._projectedBounds.min.x,this._projectedBounds.max.y),n=this._projectedToNewLayerPoint(o,e.zoom,e.center);t.DomUtil.setTransform(this._image,n,i)},_reset:function(){var e=this._map.getZoom(),i=this._map.getPixelOrigin(),o=t.bounds(this._transform(this._projectedBounds.min,e)._subtract(i),this._transform(this._projectedBounds.max,e)._subtract(i)),n=o.getSize();t.DomUtil.setPosition(this._image,o.min),this._image.style.width=n.x+"px",this._image.style.height=n.y+"px"},_projectedToNewLayerPoint:function(t,e,i){var o=this._map.getSize()._divideBy(2),n=this._map.project(i,e)._subtract(o)._round().add(this._map._getMapPanePos());return this._transform(t,e)._subtract(n)},_transform:function(t,e){var i=this._map.options.crs,o=i.transformation,n=i.scale(e);return o.transform(t,n)}}),t.Proj.imageOverlay=function(e,i,o){return new t.Proj.ImageOverlay(e,i,o)},t.Proj})?o.apply(e,n):o)||(t.exports=s)},function(t,e,i){"use strict";i.r(e);var o={isLoaded:!1,get:function(t){if(""!==t&&null!=t){var e=t.split(":");if(2===e.length){var i=e[0],o=e[1];if(this.hasOwnProperty(i)&&this[i].hasOwnProperty(o))return this[i][o]}}},exist:function(t){if(""===t||null==t)return!1;var e=t.split(":");if(2!==e.length)return!1;var i=e[0],o=e[1];return!!this.hasOwnProperty(i)&&!!this[i].hasOwnProperty(o)},load:function(t){if(!this.isLoaded){for(var e=["IGNF","EPSG","CRS"],i=0;i<e.length;i++){var o=e[i],n=this[o];for(var s in n)if(n.hasOwnProperty(s)){var a=o+":"+s;t.defs(a,this.get(a))}}this.isLoaded=!0}},loadByDefault:function(t){var e={EPSG:{2154:o.EPSG[2154],27571:o.EPSG[27571],27572:o.EPSG[27572],27573:o.EPSG[27573],27574:o.EPSG[27574]},CRS:{84:o.CRS[84]},IGNF:{LAMB93:o.IGNF.LAMB93,LAMBE:o.IGNF.LAMBE,LAMB1:o.IGNF.LAMB1,LAMB2:o.IGNF.LAMB2,LAMB3:o.IGNF.LAMB3,LAMB4:o.IGNF.LAMB4,RGF93G:o.IGNF.RGF93G,WGS84G:o.IGNF.WGS84G}};for(var i in e)if(e.hasOwnProperty(i)){var n=e[i];for(var s in n)if(n.hasOwnProperty(s)){var a=i+":"+s;t.defs(a,n[s])}}},loadByName:function(t,e){if(!this.exist(e))return!1;try{t.defs(e,this.get(e))}catch(t){return!1}return!0},EPSG:{3857:"+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +wktext  +no_defs",3785:"+title=WGS 84 / Pseudo-Mercator (deprecated) +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +wktext  +no_defs",4149:"+title=CH1903 +proj=longlat +ellps=bessel +towgs84=674.374,15.056,405.346,0,0,0,0 +no_defs ",4150:"+title=CH1903plus +proj=longlat +ellps=bessel +towgs84=674.374,15.056,405.346,0,0,0,0 +no_defs ",4151:"+title=CHTRF95 +proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ",4171:"+title=RGF93 +proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ",4230:"+title=ED50 +proj=longlat +ellps=intl +no_defs ",4235:"+title=Guyane Francaise +proj=longlat +ellps=intl +no_defs ",4258:"+title=ETRS89 +proj=longlat +ellps=GRS80 +no_defs ",4275:"+title=NTF +proj=longlat +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +no_defs ",4322:"+title=WGS 72 +proj=longlat +ellps=WGS72 +no_defs ",4326:"+title=WGS 84 +proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs ",4467:"+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",4470:"+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ",4471:"+proj=utm +zone=38 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",4474:"+proj=utm +zone=38 +south +ellps=intl +towgs84=-382,-59,-262,0,0,0,0 +units=m +no_defs ",4558:"+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ",4559:"+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",4621:"+title=Fort Marigot +proj=longlat +ellps=intl +towgs84=137,248,-430,0,0,0,0 +no_defs ",4622:"+title=Guadeloupe 1948 +proj=longlat +ellps=intl +no_defs ",4623:"+title=CSG67 +proj=longlat +ellps=intl +towgs84=-186,230,110,0,0,0,0 +no_defs ",4624:"+title=RGFG95 +proj=longlat +ellps=GRS80 +towgs84=2,2,-2,0,0,0,0 +no_defs ",4625:"+title=Martinique 1938 +proj=longlat +ellps=intl +no_defs ",4626:"+title=Reunion 1947 +proj=longlat +ellps=intl +no_defs ",4627:"+title=RGR92 +proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ",4628:"+title=Tahiti 52 +proj=longlat +ellps=intl +towgs84=162,117,154,0,0,0,0 +no_defs ",4629:"+title=Tahaa 54 +proj=longlat +ellps=intl +no_defs ",4630:"+title=IGN72 Nuku Hiva +proj=longlat +ellps=intl +no_defs ",4632:"+title=Combani 1950 +proj=longlat +ellps=intl +towgs84=-382,-59,-262,0,0,0,0 +no_defs ",4633:"+title=IGN56 Lifou +proj=longlat +ellps=intl +no_defs ",4634:"+title=IGN72 Grand Terre +proj=longlat +ellps=intl +no_defs ",4637:"+title=Perroud 1950 +proj=longlat +ellps=intl +towgs84=325,154,172,0,0,0,0 +no_defs ",4638:"+title=Saint Pierre et Miquelon 1950 +proj=longlat +ellps=clrk66 +towgs84=30,430,368,0,0,0,0 +no_defs ",4640:"+title=RRAF 1991 +proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ",4641:"+title=IGN53 Mare +proj=longlat +ellps=intl +no_defs ",4645:"+title=RGNC 1991 +proj=longlat +ellps=intl +towgs84=0,0,0,0,0,0,0 +no_defs ",4687:"+proj=longlat +ellps=GRS80 +no_defs ",4662:"+title=IGN72 Grande Terre +proj=longlat +ellps=intl +no_defs ",4689:"+title=IGN63 Hiva Oa +proj=longlat +ellps=intl +no_defs ",4690:"+title=Tahiti 79 +proj=longlat +ellps=intl +no_defs ",4691:"+title=Moorea 87 +proj=longlat +ellps=intl +towgs84=215.525,149.593,176.229,-3.2624,-1.692,-1.1571,10.4773 +no_defs ",4692:"+title=Maupiti 83 +proj=longlat +ellps=intl +towgs84=217.037,86.959,23.956,0,0,0,0 +no_defs ",4698:"+title=IGN 1962 Kerguelen +proj=longlat +ellps=intl +towgs84=145,-187,103,0,0,0,0 +no_defs ",4749:"+title=RGNC91-93 +proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ",4750:"+title=ST87 Ouvea +proj=longlat +ellps=WGS84 +towgs84=-56.263,16.136,-22.856,0,0,0,0 +no_defs ",4807:"+title=NTF (Paris) +proj=longlat +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +no_defs ",2056:"+title=CH1903+ / LV95 +proj=somerc +lat_0=46.95240555555556 +lon_0=7.439583333333333 +x_0=2600000 +y_0=1200000 +ellps=bessel +towgs84=674.374,15.056,405.346,0,0,0,0 +units=m +no_defs ",2154:"+title=RGF93 / Lambert-93 +proj=lcc +lat_1=49 +lat_2=44 +lat_0=46.5 +lon_0=3 +x_0=700000 +y_0=6600000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",2213:"+title=ETRS89 / TM 30 NE +proj=tmerc +lat_0=0 +lon_0=30 +k=0.9996 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ",2969:"+title=Fort Marigot / UTM zone 20N +proj=utm +zone=20 +ellps=intl +towgs84=137,248,-430,0,0,0,0 +units=m +no_defs ",2970:"+title=Guadeloupe 1948 / UTM zone 20N +proj=utm +zone=20 +ellps=intl +units=m +no_defs ",2971:"+title=CSG67 / UTM zone 22N +proj=utm +zone=22 +ellps=intl +towgs84=-186,230,110,0,0,0,0 +units=m +no_defs ",2972:"+title=RGFG95 / UTM zone 22N +proj=utm +zone=22 +ellps=GRS80 +towgs84=2,2,-2,0,0,0,0 +units=m +no_defs ",2973:"+title=Martinique 1938 / UTM zone 20N +proj=utm +zone=20 +ellps=intl +units=m +no_defs ",2975:"+title=RGR92 / UTM zone 40S +proj=utm +zone=40 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",2976:"+title=Tahiti 52 / UTM zone 6S +proj=utm +zone=6 +south +ellps=intl +towgs84=162,117,154,0,0,0,0 +units=m +no_defs ",2977:"+title=Tahaa 54 / UTM zone 5S +proj=utm +zone=5 +south +ellps=intl +units=m +no_defs ",2978:"+title=IGN72 Nuku Hiva / UTM zone 7S +proj=utm +zone=7 +south +ellps=intl +units=m +no_defs ",2980:"+title=Combani 1950 / UTM zone 38S +proj=utm +zone=38 +south +ellps=intl +towgs84=-382,-59,-262,0,0,0,0 +units=m +no_defs ",2981:"+title=IGN56 Lifou / UTM zone 58S +proj=utm +zone=58 +south +ellps=intl +units=m +no_defs ",2982:"+title=IGN72 Grand Terre / UTM zone 58S (deprecated) +proj=utm +zone=58 +south +ellps=intl +units=m +no_defs ",2984:"+title=RGNC 1991 / Lambert New Caledonia (deprecated) +proj=lcc +lat_1=-20.66666666666667 +lat_2=-22.33333333333333 +lat_0=-21.5 +lon_0=166 +x_0=400000 +y_0=300000 +ellps=intl +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",2986:"+title=Terre Adelie 1950 +proj=stere +towgs84=324.9120,153.2820,172.0260 +a=6378388.0000 +rf=297.0000000000000 +lat_0=-90.000000000 +lon_0=140.000000000 +lat_ts=-67.000000000 +k=0.96027295 +x_0=300000.000 +y_0=-2299363.482 +units=m +no_defs",2987:"+title=Saint Pierre et Miquelon 1950 / UTM zone 21N +proj=utm +zone=21 +ellps=clrk66 +towgs84=30,430,368,0,0,0,0 +units=m +no_defs ",2989:"+title=RRAF 1991 / UTM zone 20N +proj=utm +zone=20 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",2990:"+title=Reunion 1947 / TM Reunion (deprecated) +proj=tmerc +lat_0=-21.11666666666667 +lon_0=55.53333333333333 +k=1 +x_0=50000 +y_0=160000 +ellps=intl +units=m +no_defs ",2995:"+title=IGN53 Mare / UTM zone 58S +proj=utm +zone=58 +south +ellps=intl +units=m +no_defs ",3038:"+proj=utm +zone=26 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",3039:"+proj=utm +zone=27 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",3040:"+proj=utm +zone=28 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",3041:"+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",3045:"+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",3046:"+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",3047:"+proj=utm +zone=35 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",3048:"+proj=utm +zone=36 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",3049:"+proj=utm +zone=37 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",3050:"+proj=utm +zone=38 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",3051:"+proj=utm +zone=39 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",3034:"+title=ETRS89 / ETRS-LCC +proj=lcc +lat_1=35 +lat_2=65 +lat_0=52 +lon_0=10 +x_0=4000000 +y_0=2800000 +ellps=GRS80 +units=m +no_defs ",3035:"+title=ETRS89 / ETRS-LAEA +proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000 +ellps=GRS80 +units=m +no_defs ",3042:"+title=ETRS89 / ETRS-TM30 +proj=utm +zone=30 +ellps=GRS80 +units=m +no_defs ",3043:"+title=ETRS89 / ETRS-TM31 +proj=utm +zone=31 +ellps=GRS80 +units=m +no_defs ",3044:"+title=ETRS89 / ETRS-TM32 +proj=utm +zone=32 +ellps=GRS80 +units=m +no_defs ",25828:"+proj=utm +zone=28 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",25829:"+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",25833:"+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",25834:"+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",25835:"+proj=utm +zone=35 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",25836:"+proj=utm +zone=36 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",25837:"+proj=utm +zone=37 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",25838:"+proj=utm +zone=38 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",3060:"+title=IGN72 Grande Terre / UTM zone 58S +proj=utm +zone=58 +south +ellps=intl +units=m +no_defs ",3163:"+title=RGNC91-93 / Lambert New Caledonia +proj=lcc +lat_1=-20.66666666666667 +lat_2=-22.33333333333333 +lat_0=-21.5 +lon_0=166 +x_0=400000 +y_0=300000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",3164:"+title=ST87 Ouvea / UTM zone 58S +proj=utm +zone=58 +south +ellps=WGS84 +towgs84=-56.263,16.136,-22.856,0,0,0,0 +units=m +no_defs ",3165:"+title=NEA74 Noumea / Noumea Lambert +proj=lcc +lat_1=-22.24469175 +lat_2=-22.29469175 +lat_0=-22.26969175 +lon_0=166.44242575 +x_0=0.66 +y_0=1.02 +ellps=intl +units=m +no_defs ",3166:"+title=NEA74 Noumea / Noumea Lambert 2 +proj=lcc +lat_1=-22.24472222222222 +lat_2=-22.29472222222222 +lat_0=-22.26972222222222 +lon_0=166.4425 +x_0=8.313000000000001 +y_0=-2.354 +ellps=intl +units=m +no_defs ",3169:"+title=RGNC91-93 / UTM zone 57S +proj=utm +zone=57 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",3170:"+title=RGNC91-93 / UTM zone 58S +proj=utm +zone=58 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",3171:"+title=RGNC91-93 / UTM zone 59S +proj=utm +zone=59 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ",3172:"+title=IGN53 Mare / UTM zone 59S +proj=utm +zone=59 +south +ellps=intl +units=m +no_defs ",3296:"+title=RGPF / UTM zone 5S +proj=utm +zone=5 +south +ellps=GRS80 +units=m +no_defs ",3297:"+title=RGPF / UTM zone 6S +proj=utm +zone=6 +south +ellps=GRS80 +units=m +no_defs ",3298:"+title=RGPF / UTM zone 7S +proj=utm +zone=7 +south +ellps=GRS80 +units=m +no_defs ",3299:"+title=RGPF / UTM zone 8S +proj=utm +zone=8 +south +ellps=GRS80 +units=m +no_defs ",3302:"+title=IGN63 Hiva Oa / UTM zone 7S +proj=utm +zone=7 +south +ellps=intl +units=m +no_defs ",3303:"+title=Fatu Iva 72 / UTM zone 7S +proj=utm +zone=7 +south +ellps=intl +towgs84=347.103,1078.12,2623.92,-33.8875,70.6773,-9.3943,186.074 +units=m +no_defs ",3304:"+title=Tahiti 79 / UTM zone 6S +proj=utm +zone=6 +south +ellps=intl +units=m +no_defs ",3305:"+title=Moorea 87 / UTM zone 6S +proj=utm +zone=6 +south +ellps=intl +towgs84=215.525,149.593,176.229,-3.2624,-1.692,-1.1571,10.4773 +units=m +no_defs ",3306:"+title=Maupiti 83 / UTM zone 5S +proj=utm +zone=5 +south +ellps=intl +towgs84=217.037,86.959,23.956,0,0,0,0 +units=m +no_defs ",3312:"+title=CSG67 / UTM zone 21N +proj=utm +zone=21 +ellps=intl +towgs84=-186,230,110,0,0,0,0 +units=m +no_defs ",3313:"+title=RGFG95 / UTM zone 21N +proj=utm +zone=21 +ellps=GRS80 +towgs84=2,2,-2,0,0,0,0 +units=m +no_defs ",3336:"+title=IGN 1962 Kerguelen / UTM zone 42S +proj=utm +zone=42 +south +ellps=intl +towgs84=145,-187,103,0,0,0,0 +units=m +no_defs ",3395:"+title=WGS 84 / World Mercator +proj=merc +lon_0=0 +k=1 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",3727:"+title=Reunion 1947 / TM Reunion +proj=tmerc +lat_0=-21.11666666666667 +lon_0=55.53333333333333 +k=1 +x_0=160000 +y_0=50000 +ellps=intl +units=m +no_defs ",21781:"+title=CH1903 / LV03 +proj=somerc +lat_0=46.95240555555556 +lon_0=7.439583333333333 +x_0=600000 +y_0=200000 +ellps=bessel +towgs84=674.374,15.056,405.346,0,0,0,0 +units=m +no_defs ",25830:"+title=ETRS89 / UTM zone 30N +proj=utm +zone=30 +ellps=GRS80 +units=m +no_defs ",25831:"+title=ETRS89 / UTM zone 31N +proj=utm +zone=31 +ellps=GRS80 +units=m +no_defs ",25832:"+title=ETRS89 / UTM zone 32N +proj=utm +zone=32 +ellps=GRS80 +units=m +no_defs ",27561:"+title=NTF (Paris) / Lambert Nord France +proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ",27562:"+title=NTF (Paris) / Lambert Centre France +proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.99987742 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ",27563:"+title=NTF (Paris) / Lambert Sud France +proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000001 +lon_0=0 +k_0=0.9998774990000001 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ",27564:"+title=NTF (Paris) / Lambert Corse +proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000001 +lon_0=0 +k_0=0.9999447100000001 +x_0=234.358 +y_0=185861.369 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ",27571:"+title=NTF (Paris) / Lambert zone I +proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=1200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ",27572:"+title=NTF (Paris) / Lambert zone II +proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.99987742 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ",27573:"+title=NTF (Paris) / Lambert zone III +proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000001 +lon_0=0 +k_0=0.9998774990000001 +x_0=600000 +y_0=3200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ",27574:"+title=NTF (Paris) / Lambert zone IV +proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000001 +lon_0=0 +k_0=0.9999447100000001 +x_0=234.358 +y_0=4185861.369 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ",27581:"+title=NTF (Paris) / France I (deprecated) +proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=1200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ",27582:"+title=NTF (Paris) / France II (deprecated) +proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.99987742 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ",27583:"+title=NTF (Paris) / France III (deprecated) +proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000001 +lon_0=0 +k_0=0.9998774990000001 +x_0=600000 +y_0=3200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ",27584:"+title=NTF (Paris) / France IV (deprecated) +proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000001 +lon_0=0 +k_0=0.9999447100000001 +x_0=234.358 +y_0=4185861.369 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ",27591:"+title=NTF (Paris) / Nord France (deprecated) +proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ",27592:"+title=NTF (Paris) / Centre France (deprecated) +proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.99987742 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ",27593:"+title=NTF (Paris) / Sud France (deprecated) +proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000001 +lon_0=0 +k_0=0.9998774990000001 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ",27594:"+title=NTF (Paris) / Corse (deprecated) +proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000001 +lon_0=0 +k_0=0.9999447100000001 +x_0=234.358 +y_0=185861.369 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ",32601:"+proj=utm +zone=1 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32602:"+proj=utm +zone=2 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32603:"+proj=utm +zone=3 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32604:"+proj=utm +zone=4 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32605:"+proj=utm +zone=5 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32606:"+proj=utm +zone=6 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32607:"+proj=utm +zone=7 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32608:"+proj=utm +zone=8 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32609:"+proj=utm +zone=9 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32610:"+proj=utm +zone=10 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32611:"+proj=utm +zone=11 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32612:"+proj=utm +zone=12 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32613:"+proj=utm +zone=13 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32614:"+proj=utm +zone=14 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32615:"+proj=utm +zone=15 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32616:"+proj=utm +zone=16 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32617:"+proj=utm +zone=17 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32618:"+proj=utm +zone=18 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32619:"+proj=utm +zone=19 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32620:"+proj=utm +zone=20 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32621:"+proj=utm +zone=21 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32622:"+proj=utm +zone=22 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32623:"+proj=utm +zone=23 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32624:"+proj=utm +zone=24 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32625:"+proj=utm +zone=25 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32626:"+proj=utm +zone=26 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32627:"+proj=utm +zone=27 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32628:"+proj=utm +zone=28 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32629:"+proj=utm +zone=29 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32630:"+proj=utm +zone=30 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32631:"+proj=utm +zone=31 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32632:"+proj=utm +zone=32 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32633:"+proj=utm +zone=33 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32634:"+proj=utm +zone=34 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32635:"+proj=utm +zone=35 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32636:"+proj=utm +zone=36 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32637:"+proj=utm +zone=37 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32638:"+proj=utm +zone=38 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32639:"+proj=utm +zone=39 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32640:"+proj=utm +zone=40 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32641:"+proj=utm +zone=41 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32642:"+proj=utm +zone=42 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32643:"+proj=utm +zone=43 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32644:"+proj=utm +zone=44 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32645:"+proj=utm +zone=45 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32646:"+proj=utm +zone=46 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32647:"+proj=utm +zone=47 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32648:"+proj=utm +zone=48 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32649:"+proj=utm +zone=49 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32650:"+proj=utm +zone=50 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32651:"+proj=utm +zone=51 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32652:"+proj=utm +zone=52 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32653:"+proj=utm +zone=53 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32654:"+proj=utm +zone=54 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32655:"+proj=utm +zone=55 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32656:"+proj=utm +zone=56 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32657:"+proj=utm +zone=57 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32658:"+proj=utm +zone=58 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32659:"+proj=utm +zone=59 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32660:"+proj=utm +zone=60 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32661:"+proj=stere +lat_0=90 +lat_ts=90 +lon_0=0 +k=0.994 +x_0=2000000 +y_0=2000000 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32662:"+title=WGS 84 / Plate Carree +proj=eqc +lat_ts=0 +lon_0=0 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32701:"+proj=utm +zone=1 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32702:"+proj=utm +zone=2 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32703:"+proj=utm +zone=3 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32704:"+proj=utm +zone=4 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32705:"+proj=utm +zone=5 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32706:"+proj=utm +zone=6 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32707:"+proj=utm +zone=7 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32708:"+proj=utm +zone=8 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32709:"+proj=utm +zone=9 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32710:"+proj=utm +zone=10 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32711:"+proj=utm +zone=11 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32712:"+proj=utm +zone=12 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32713:"+proj=utm +zone=13 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32714:"+proj=utm +zone=14 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32715:"+proj=utm +zone=15 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32716:"+proj=utm +zone=16 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32717:"+proj=utm +zone=17 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32718:"+proj=utm +zone=18 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32719:"+proj=utm +zone=19 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32720:"+proj=utm +zone=20 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32721:"+proj=utm +zone=21 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32722:"+proj=utm +zone=22 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32723:"+proj=utm +zone=23 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32724:"+proj=utm +zone=24 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32725:"+proj=utm +zone=25 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32726:"+proj=utm +zone=26 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32727:"+proj=utm +zone=27 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32728:"+proj=utm +zone=28 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32729:"+proj=utm +zone=29 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32730:"+proj=utm +zone=30 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32731:"+proj=utm +zone=31 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32732:"+proj=utm +zone=32 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32733:"+proj=utm +zone=33 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32734:"+proj=utm +zone=34 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32735:"+proj=utm +zone=35 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32736:"+proj=utm +zone=36 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32737:"+proj=utm +zone=37 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32738:"+proj=utm +zone=38 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32739:"+proj=utm +zone=39 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32740:"+proj=utm +zone=40 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32741:"+proj=utm +zone=41 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32742:"+proj=utm +zone=42 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32743:"+proj=utm +zone=43 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32744:"+proj=utm +zone=44 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32745:"+proj=utm +zone=45 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32746:"+proj=utm +zone=46 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32747:"+proj=utm +zone=47 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32748:"+proj=utm +zone=48 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32749:"+proj=utm +zone=49 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32750:"+proj=utm +zone=50 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32751:"+proj=utm +zone=51 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32752:"+proj=utm +zone=52 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32753:"+proj=utm +zone=53 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32754:"+proj=utm +zone=54 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32755:"+proj=utm +zone=55 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32756:"+proj=utm +zone=56 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32757:"+proj=utm +zone=57 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32758:"+proj=utm +zone=58 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32759:"+proj=utm +zone=59 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32760:"+proj=utm +zone=60 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",32761:"+proj=stere +lat_0=-90 +lat_ts=-90 +lon_0=0 +k=0.994 +x_0=2000000 +y_0=2000000 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ",310024802:"+title=Geoportail - France metropolitaine +proj=eqc +nadgrids=null +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=46.500000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",310915814:"+title=Geoportail - Antilles francaises +proj=eqc +nadgrids=null +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=15.000000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",310486805:"+title=Geoportail - Guyane +proj=eqc +nadgrids=null +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=4.000000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",310700806:"+title=Geoportail - Reunion et dependances +proj=eqc +nadgrids=null +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=-21.000000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",310702807:"+title=Geoportail - Mayotte +proj=eqc +nadgrids=null +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=-12.000000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",310706808:"+title=Geoportail - Saint-Pierre et Miquelon +proj=eqc +nadgrids=null +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=47.000000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",310547809:"+title=Geoportail - Nouvelle-Caledonie +proj=eqc +nadgrids=null +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=-22.000000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",310642810:"+title=Geoportail - Wallis et Futuna +proj=eqc +nadgrids=null +towgs84=0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.000000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=-14.000000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",310032811:"+title=Geoportail - Polynesie francaise +proj=eqc +nadgrids=null +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=-15.000000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",310642812:"+title=Geoportail - Kerguelen +proj=eqc +nadgrids=null +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=-49.500000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",310642801:"+title=Geoportail - Crozet +proj=eqc +nadgrids=null +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=-46.000000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",310642813:"+title=Geoportail - Amsterdam et Saint-Paul +proj=eqc +nadgrids=null +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=-38.000000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",310642901:"+title=Geoportail - Monde +proj=mill +towgs84=0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.000000 +a=6378137.0000 +rf=298.2572221010000 +lon_0=0.000000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",5489:"+title=RGAF09 geographiques (dms) +proj=longlat +nadgrids=@null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137 +rf=298.257222101 +units=m +no_defs",5490:"+title=RGAF09 UTM Nord Fuseau 20 +proj=tmerc +nadgrids=@null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137 +rf=298.257222101 +lat_0=0.000000000 +lon_0=-63.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs"},CRS:{84:"+title=WGS 84 longitude-latitude +proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs "},IGNF:{AMST63GEO:"+title=Amsterdam 1963 +proj=longlat +towgs84=109.753,-528.133,-362.244,0,0,0,0 +a=6378388.0000 +rf=297.0000000000000 +units=m +no_defs",CROZ63GEO:"+title=Crozet 1963 +proj=longlat +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378388.0000 +rf=297.0000000000000 +units=m +no_defs",CSG67GEO:"+title=Guyane CSG67 +proj=longlat +towgs84=-193.0660,236.9930,105.4470,0.4814,-0.8074,0.1276,1.564900 +a=6378388.0000 +rf=297.0000000000000 +units=m +no_defs",ED50G:"+title=ED50 +proj=longlat +towgs84=-84.0000,-97.0000,-117.0000 +a=6378388.0000 +rf=297.0000000000000 +units=m +no_defs",GUAD48GEO:"+title=Guadeloupe Ste Anne +proj=longlat +towgs84=-472.2900,-5.6300,-304.1200,0.4362,-0.8374,0.2563,1.898400 +a=6378388.0000 +rf=297.0000000000000 +units=m +no_defs",GUADFM49GEO:"+title=Guadeloupe Fort Marigot +proj=longlat +towgs84=136.5960,248.1480,-429.7890 +a=6378388.0000 +rf=297.0000000000000 +units=m +no_defs",IGN63GEO:"+title=IGN 1963 (Hiva Oa, Tahuata, Mohotani) +proj=longlat +towgs84=410.7210,55.0490,80.7460,-2.5779,-2.3514,-0.6664,17.331100 +a=6378388.0000 +rf=297.0000000000000 +units=m +no_defs",IGN72GEO:"+title=IGN 1972 Grande-Terre / Ile des Pins +proj=longlat +towgs84=-11.6400,-348.6000,291.6800 +a=6378388.0000 +rf=297.0000000000000 +units=m +no_defs",KERG62GEO:"+title=Kerguelen - K0 +proj=longlat +towgs84=144.8990,-186.7700,100.9230 +a=6378388.0000 +rf=297.0000000000000 +units=m +no_defs",MART38GEO:"+title=Martinique Fort-Desaix +proj=longlat +towgs84=126.9260,547.9390,130.4090,-2.7867,5.1612,-0.8584,13.822650 +a=6378388.0000 +rf=297.0000000000000 +units=m +no_defs",MAYO50GEO:"+title=Mayotte Combani +proj=longlat +towgs84=-599.9280,-275.5520,-195.6650,-0.0835,-0.4715,0.0602,49.281400 +a=6378388.0000 +rf=297.0000000000000 +units=m +no_defs",MOOREA87GEO:"+title=Moorea 1987 +proj=longlat +towgs84=215.9820,149.5930,176.2290,3.2624,1.6920,1.1571,10.477300 +a=6378388.0000 +rf=297.0000000000000 +units=m +no_defs",NTFG:"+title=Nouvelle Triangulation Francaise Greenwich degres sexagesimaux +proj=longlat +nadgrids=ntf_r93.gsb,null +wktext +towgs84=-168.0000,-60.0000,320.0000 +a=6378249.2000 +rf=293.4660210000000 +units=m +no_defs",NTFP:"+title=Nouvelle Triangulation Francaise Paris grades +proj=longlat +nadgrids=ntf_r93.gsb,null +wktext +towgs84=-168.0000,-60.0000,320.0000 +a=6378249.2000 +rf=293.4660210000000 +pm=2.337229167 +units=m +no_defs",NUKU72GEO:"+title=IGN 1972 Nuku Hiva +proj=longlat +towgs84=165.7320,216.7200,180.5050,-0.6434,-0.4512,-0.0791,7.420400 +a=6378388.0000 +rf=297.0000000000000 +units=m +no_defs",REUN47GEO:"+title=Reunion 1947 +proj=longlat +towgs84=789.5240,-626.4860,-89.9040,0.6006,76.7946,-10.5788,-32.324100 +a=6378388.0000 +rf=297.0000000000000 +units=m +no_defs",RGF93G:"+title=Reseau geodesique francais 1993 +proj=longlat +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +units=m +no_defs",RGFG95GEO:"+title=Reseau geodesique francais de Guyane 1995 +proj=longlat +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +units=m +no_defs",RGM04GEO:"+title=RGM04 (Reseau Geodesique de Mayotte 2004) +proj=longlat +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +units=m +no_defs",RGNCGEO:"+title=Reseau Geodesique de Nouvelle-Caledonie +proj=longlat +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +units=m +no_defs",RGPFGEO:"+title=RGPF (Reseau Geodesique de Polynesie Francaise) +proj=longlat +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +units=m +no_defs",RGR92GEO:"+title=Reseau geodesique de la Reunion 1992 +proj=longlat +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +units=m +no_defs",RGSPM06GEO:"+title=Saint-Pierre-et-Miquelon (2006) +proj=longlat +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +units=m +no_defs",RGTAAF07G:"+title=Reseau Geodesique des TAAF (2007) (dms) +proj=longlat +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +units=m +no_defs",STPL69GEO:"+title=Saint-Paul 1969 +proj=longlat +towgs84=225.571,-346.608,-46.567,0,0,0,0 +a=6378388.0000 +rf=297.0000000000000 +units=m +no_defs",STPM50GEO:"+title=St Pierre et Miquelon 1950  +proj=longlat +towgs84=-95.5930,573.7630,173.4420,-0.9602,1.2510,-1.3918,42.626500 +a=6378206.4000 +rf=294.9786982000000 +units=m +no_defs",TAHAAGEO:"+title=Raiatea - Tahaa 51-54 (Tahaa, Base Terme Est) +proj=longlat +towgs84=72.4380,345.9180,79.4860,-1.6045,-0.8823,-0.5565,1.374600 +a=6378388.0000 +rf=297.0000000000000 +units=m +no_defs",TAHI79GEO:"+title=IGN79 (Tahiti) Iles de la Societe +proj=longlat +towgs84=221.5250,152.9480,176.7680,2.3847,1.3896,0.8770,11.474100 +a=6378388.0000 +rf=297.0000000000000 +units=m +no_defs",TERA50G:"+title=Pointe Geologie - Perroud 1950 +proj=longlat +towgs84=324.9120,153.2820,172.0260 +a=6378388.0000 +rf=297.0000000000000 +units=m +no_defs",WALL78GEO:"+title=Wallis - Uvea 1978 (MOP78) +proj=longlat +towgs84=253.0000,-133.0000,-127.0000 +a=6378388.0000 +rf=297.0000000000000 +units=m +no_defs",WGS72G:"+title=WGS72 +proj=longlat +towgs84=0.0000,12.0000,6.0000 +a=6378135.0000 +rf=298.2600000000000 +units=m +no_defs",WGS84G:"+title=World Geodetic System 1984 +proj=longlat +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +units=m +no_defs",WGS84RRAFGEO:"+title=Reseau de reference des Antilles francaises (1988-1991) +proj=longlat +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +units=m +no_defs",XGEO:"+title=Systeme CIO-BIH +proj=longlat +towgs84=0.0000,0.0000,0.5000,0.0000,0.0000,0.0140,-0.100000 +a=6378137.0000 +rf=298.2572221010000 +units=m +no_defs",AMST63UTM43S:"+title=Amsterdam 1963 UTM fuseau 43 Sud +proj=tmerc +towgs84=109.753,-528.133,-362.244,0,0,0,0 +a=6378388.0000 +rf=297.0000000000000 +lat_0=0.000000000 +lon_0=75.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",CROZ63UTM39S:"+title=Crozet 1963 +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378388.0000 +rf=297.0000000000000 +lat_0=0.000000000 +lon_0=51.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",CSG67UTM21:"+title=Guyane CSG67 UTM fuseau 21 +proj=tmerc +towgs84=-193.0660,236.9930,105.4470,0.4814,-0.8074,0.1276,1.564900 +a=6378388.0000 +rf=297.0000000000000 +lat_0=0.000000000 +lon_0=-57.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs",CSG67UTM22:"+title=Guyane CSG67 UTM fuseau 22 +proj=tmerc +towgs84=-193.0660,236.9930,105.4470,0.4814,-0.8074,0.1276,1.564900 +a=6378388.0000 +rf=297.0000000000000 +lat_0=0.000000000 +lon_0=-51.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs",GEOPORTALANF:"+title=Geoportail - Antilles francaises +proj=eqc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=15.000000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",GEOPORTALASP:"+title=Geoportail - Amsterdam et Saint-Paul +proj=eqc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=-38.000000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",GEOPORTALCRZ:"+title=Geoportail - Crozet +proj=eqc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=-46.000000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",GEOPORTALFXX:"+title=Geoportail - France metropolitaine +proj=eqc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=46.500000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",GEOPORTALGUF:"+title=Geoportail - Guyane +proj=eqc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=4.000000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",GEOPORTALKER:"+title=Geoportail - Kerguelen +proj=eqc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=-49.500000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",GEOPORTALMYT:"+title=Geoportail - Mayotte +proj=eqc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=-12.000000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",GEOPORTALNCL:"+title=Geoportail - Nouvelle-Caledonie +proj=eqc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=-22.000000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",GEOPORTALPYF:"+title=Geoportail - Polynesie francaise +proj=eqc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=-15.000000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",GEOPORTALREU:"+title=Geoportail - Reunion et dependances +proj=eqc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=-21.000000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",GEOPORTALSPM:"+title=Geoportail - Saint-Pierre et Miquelon +proj=eqc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=47.000000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",GEOPORTALWLF:"+title=Geoportail - Wallis et Futuna +proj=eqc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=0.000000000 +lat_ts=-14.000000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",GUAD48UTM20:"+title=Guadeloupe Ste Anne +proj=tmerc +towgs84=-472.2900,-5.6300,-304.1200,0.4362,-0.8374,0.2563,1.898400 +a=6378388.0000 +rf=297.0000000000000 +lat_0=0.000000000 +lon_0=-63.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs",GUADFM49U20:"+title=Guadeloupe Fort Marigot  +proj=tmerc +towgs84=136.5960,248.1480,-429.7890 +a=6378388.0000 +rf=297.0000000000000 +lat_0=0.000000000 +lon_0=-63.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs",IGN63UTM7S:"+title=IGN 1963 - Hiva Oa, Tahuata, Mohotani - UTM fuseau 7 Sud +proj=tmerc +towgs84=410.7210,55.0490,80.7460,-2.5779,-2.3514,-0.6664,17.331100 +a=6378388.0000 +rf=297.0000000000000 +lat_0=0.000000000 +lon_0=-141.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",IGN72UTM58S:"+title=IGN 1972 - UTM fuseau 58 Sud +proj=tmerc +towgs84=-11.6400,-348.6000,291.6800 +a=6378388.0000 +rf=297.0000000000000 +lat_0=0.000000000 +lon_0=165.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",KERG62UTM42S:"+title=Kerguelen 1962 +proj=tmerc +towgs84=144.8990,-186.7700,100.9230 +a=6378388.0000 +rf=297.0000000000000 +lat_0=0.000000000 +lon_0=69.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",LAMB1:"+title=Lambert I +proj=lcc +nadgrids=ntf_r93.gsb,null +wktext +towgs84=-168.0000,-60.0000,320.0000 +a=6378249.2000 +rf=293.4660210000000 +pm=2.337229167 +lat_0=49.500000000 +lon_0=0.000000000 +k_0=0.99987734 +lat_1=49.500000000 +x_0=600000.000 +y_0=200000.000 +units=m +no_defs",LAMB1C:"+title=Lambert I Carto +proj=lcc +nadgrids=ntf_r93.gsb,null +wktext +towgs84=-168.0000,-60.0000,320.0000 +a=6378249.2000 +rf=293.4660210000000 +pm=2.337229167 +lat_0=49.500000000 +lon_0=0.000000000 +k_0=0.99987734 +lat_1=49.500000000 +x_0=600000.000 +y_0=1200000.000 +units=m +no_defs",LAMB2:"+title=Lambert II +proj=lcc +nadgrids=ntf_r93.gsb,null +wktext +towgs84=-168.0000,-60.0000,320.0000 +a=6378249.2000 +rf=293.4660210000000 +pm=2.337229167 +lat_0=46.800000000 +lon_0=0.000000000 +k_0=0.99987742 +lat_1=46.800000000 +x_0=600000.000 +y_0=200000.000 +units=m +no_defs",LAMB2C:"+title=Lambert II Carto +proj=lcc +nadgrids=ntf_r93.gsb,null +wktext +towgs84=-168.0000,-60.0000,320.0000 +a=6378249.2000 +rf=293.4660210000000 +pm=2.337229167 +lat_0=46.800000000 +lon_0=0.000000000 +k_0=0.99987742 +lat_1=46.800000000 +x_0=600000.000 +y_0=2200000.000 +units=m +no_defs",LAMB3:"+title=Lambert III +proj=lcc +nadgrids=ntf_r93.gsb,null +wktext +towgs84=-168.0000,-60.0000,320.0000 +a=6378249.2000 +rf=293.4660210000000 +pm=2.337229167 +lat_0=44.100000000 +lon_0=0.000000000 +k_0=0.99987750 +lat_1=44.100000000 +x_0=600000.000 +y_0=200000.000 +units=m +no_defs",LAMB3C:"+title=Lambert III Carto +proj=lcc +nadgrids=ntf_r93.gsb,null +wktext +towgs84=-168.0000,-60.0000,320.0000 +a=6378249.2000 +rf=293.4660210000000 +pm=2.337229167 +lat_0=44.100000000 +lon_0=0.000000000 +k_0=0.99987750 +lat_1=44.100000000 +x_0=600000.000 +y_0=3200000.000 +units=m +no_defs",LAMB4:"+title=Lambert IV +proj=lcc +nadgrids=ntf_r93.gsb,null +wktext +towgs84=-168.0000,-60.0000,320.0000 +a=6378249.2000 +rf=293.4660210000000 +pm=2.337229167 +lat_0=42.165000000 +lon_0=0.000000000 +k_0=0.99994471 +lat_1=42.165000000 +x_0=234.358 +y_0=185861.369 +units=m +no_defs",LAMB4C:"+title=Lambert IV Carto +proj=lcc +nadgrids=ntf_r93.gsb,null +wktext +towgs84=-168.0000,-60.0000,320.0000 +a=6378249.2000 +rf=293.4660210000000 +pm=2.337229167 +lat_0=42.165000000 +lon_0=0.000000000 +k_0=0.99994471 +lat_1=42.165000000 +x_0=234.358 +y_0=4185861.369 +units=m +no_defs",LAMB93:"+title=Lambert 93 +proj=lcc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=46.500000000 +lon_0=3.000000000 +lat_1=44.000000000 +lat_2=49.000000000 +x_0=700000.000 +y_0=6600000.000 +units=m +no_defs",RGF93CC42:"+title=Lambert conique conforme Zone 1 +proj=lcc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=42.000000000 +lon_0=3.000000000 +lat_1=41.200000000 +lat_2=42.800000000 +x_0=1700000.000 +y_0=1200000.000 +units=m +no_defs",RGF93CC43:"+title=Lambert conique conforme Zone 2 +proj=lcc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=43.000000000 +lon_0=3.000000000 +lat_1=42.200000000 +lat_2=43.800000000 +x_0=1700000.000 +y_0=2200000.000 +units=m +no_defs",RGF93CC44:"+title=Lambert conique conforme Zone 3 +proj=lcc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=44.000000000 +lon_0=3.000000000 +lat_1=43.200000000 +lat_2=44.800000000 +x_0=1700000.000 +y_0=3200000.000 +units=m +no_defs",RGF93CC45:"+title=Lambert conique conforme Zone 4 +proj=lcc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=45.000000000 +lon_0=3.000000000 +lat_1=44.200000000 +lat_2=45.800000000 +x_0=1700000.000 +y_0=4200000.000 +units=m +no_defs",RGF93CC46:"+title=Lambert conique conforme Zone 5 +proj=lcc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=46.000000000 +lon_0=3.000000000 +lat_1=45.200000000 +lat_2=46.800000000 +x_0=1700000.000 +y_0=5200000.000 +units=m +no_defs",RGF93CC47:"+title=Lambert conique conforme Zone 6 +proj=lcc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=47.000000000 +lon_0=3.000000000 +lat_1=46.200000000 +lat_2=47.800000000 +x_0=1700000.000 +y_0=6200000.000 +units=m +no_defs",RGF93CC48:"+title=Lambert conique conforme Zone 7 +proj=lcc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=48.000000000 +lon_0=3.000000000 +lat_1=47.200000000 +lat_2=48.800000000 +x_0=1700000.000 +y_0=7200000.000 +units=m +no_defs",RGF93CC49:"+title=Lambert conique conforme Zone 8 +proj=lcc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=49.000000000 +lon_0=3.000000000 +lat_1=48.200000000 +lat_2=49.800000000 +x_0=1700000.000 +y_0=8200000.000 +units=m +no_defs",RGF93CC50:"+title=Lambert conique conforme Zone 9 +proj=lcc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=50.000000000 +lon_0=3.000000000 +lat_1=49.200000000 +lat_2=50.800000000 +x_0=1700000.000 +y_0=9200000.000 +units=m +no_defs",LAMBE:"+title=Lambert II etendu +proj=lcc +nadgrids=ntf_r93.gsb,null +wktext +towgs84=-168.0000,-60.0000,320.0000 +a=6378249.2000 +rf=293.4660210000000 +pm=2.337229167 +lat_0=46.800000000 +lon_0=0.000000000 +k_0=0.99987742 +lat_1=46.800000000 +x_0=600000.000 +y_0=2200000.000 +units=m +no_defs",MART38UTM20:"+title=Martinique Fort-Desaix +proj=tmerc +towgs84=126.9260,547.9390,130.4090,-2.7867,5.1612,-0.8584,13.822650 +a=6378388.0000 +rf=297.0000000000000 +lat_0=0.000000000 +lon_0=-63.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs",MAYO50UTM38S:"+title=Mayotte Combani +proj=tmerc +towgs84=-599.9280,-275.5520,-195.6650,-0.0835,-0.4715,0.0602,49.281400 +a=6378388.0000 +rf=297.0000000000000 +lat_0=0.000000000 +lon_0=45.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",MILLER:"+title=Geoportail - Monde +proj=mill +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lon_0=0.000000000 +x_0=0.000 +y_0=0.000 +units=m +no_defs",MOOREA87U6S:"+title=Moorea 1987 - UTM fuseau 6 Sud +proj=tmerc +towgs84=215.9820,149.5930,176.2290,3.2624,1.6920,1.1571,10.477300 +a=6378388.0000 +rf=297.0000000000000 +lat_0=0.000000000 +lon_0=-147.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",NUKU72U7S:"+title=IGN 1972 Nuku Hiva - UTM fuseau 7 Sud +proj=tmerc +towgs84=165.7320,216.7200,180.5050,-0.6434,-0.4512,-0.0791,7.420400 +a=6378388.0000 +rf=297.0000000000000 +lat_0=0.000000000 +lon_0=-141.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",RGM04UTM38S:"+title=UTM fuseau 38 Sud (Reseau Geodesique de Mayotte 2004) +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=45.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",RGNCUTM57S:"+title=Reseau Geodesique de Nouvelle-Caledonie - UTM fuseau 57 Sud +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=159.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",RGNCUTM58S:"+title=Reseau Geodesique de Nouvelle-Caledonie - UTM fuseau 58 Sud +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=165.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",RGNCUTM59S:"+title=Reseau Geodesique de Nouvelle-Caledonie - UTM fuseau 59 Sud +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=171.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",RGPFUTM5S:"+title=RGPF - UTM fuseau 5 Sud +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=-153.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",RGPFUTM6S:"+title=RGPF - UTM fuseau 6 Sud +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=-147.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",RGPFUTM7S:"+title=RGPF - UTM fuseau 7 Sud +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=-141.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",RGR92UTM40S:"+title=RGR92 UTM fuseau 40 Sud +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=57.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",RGSPM06U21:"+title=Saint-Pierre-et-Miquelon (2006) UTM Fuseau 21 Nord +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=-57.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs",STPL69UTM43S:"+title=Saint-Paul 1969 UTM fuseau 43 Sud +proj=tmerc +towgs84=225.571,-346.608,-46.567,0,0,0,0 +a=6378388.0000 +rf=297.0000000000000 +lat_0=0.000000000 +lon_0=75.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",STPM50UTM21:"+title=St Pierre et Miquelon 1950 +proj=tmerc +towgs84=-95.5930,573.7630,173.4420,-0.9602,1.2510,-1.3918,42.626500 +a=6378206.4000 +rf=294.9786982000000 +lat_0=0.000000000 +lon_0=-57.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs",TAHAAUTM05S:"+title=Tahaa 1951 +proj=tmerc +towgs84=72.4380,345.9180,79.4860,-1.6045,-0.8823,-0.5565,1.374600 +a=6378388.0000 +rf=297.0000000000000 +lat_0=0.000000000 +lon_0=-153.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",TAHI51UTM06S:"+title=Tahiti-Terme Nord UTM fuseau 6 Sud +proj=tmerc +towgs84=162.0000,117.0000,154.0000 +a=6378388.0000 +rf=297.0000000000000 +lat_0=0.000000000 +lon_0=-147.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",TAHI79UTM6S:"+title=Tahiti 1979 +proj=tmerc +towgs84=221.5250,152.9480,176.7680,2.3847,1.3896,0.8770,11.474100 +a=6378388.0000 +rf=297.0000000000000 +lat_0=0.000000000 +lon_0=-147.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",TERA50STEREO:"+title=Terre Adelie 1950 +proj=stere +towgs84=324.9120,153.2820,172.0260 +a=6378388.0000 +rf=297.0000000000000 +lat_0=-90.000000000 +lon_0=140.000000000 +lat_ts=-67 +k=0.96027295 +x_0=300000.000 +y_0=-2299363.482 +units=m +no_defs",UTM01SW84:"+title=World Geodetic System 1984 UTM fuseau 01 Sud +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=-177.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",UTM20W84GUAD:"+title=World Geodetic System 1984 UTM fuseau 20 Nord-Guadeloupe +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=-63.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs",UTM20W84MART:"+title=World Geodetic System 1984 UTM fuseau 20 Nord-Martinique +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=-63.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs",UTM22RGFG95:"+title=RGFG95 UTM fuseau 22 Nord-Guyane +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=-51.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs",UTM39SW84:"+title=World Geodetic System 1984 UTM fuseau 39 Sud +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=51.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",UTM42SW84:"+title=World Geodetic System 1984 UTM fuseau 42 Sud +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=69.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",UTM43SW84:"+title=World Geodetic System 1984 UTM fuseau 43 Sud +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=75.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",WALL78UTM1S:"+title=Wallis-Uvea 1978 (MOP78) UTM 1 SUD +proj=tmerc +towgs84=253.0000,-133.0000,-127.0000 +a=6378388.0000 +rf=297.0000000000000 +lat_0=0.000000000 +lon_0=-177.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=10000000.000 +units=m +no_defs",ETRS89GEO:"+title=ETRS89 geographiques (dms) +proj=longlat +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +units=m +no_defs",ETRS89LAEA:"+title=ETRS89 Lambert Azimutal Equal Area +proj=laea +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=52.000000000 +lon_0=10.000000000 +x_0=4321000.000 +y_0=3210000.000 +units=m +no_defs",ETRS89LCC:"+title=ETRS89 Lambert Conformal Conic +proj=lcc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=52.000000000 +lon_0=9.999999995 +lat_1=35.000000000 +lat_2=65.000000000 +x_0=4000000.000 +y_0=2800000.000 +units=m +no_defs",UTM26ETRS89:"+title=Europe - de 30d a 24d Ouest +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=-27.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs",UTM27ETRS89:"+title=Europe - de 24d a 18d Ouest +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=-21.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs",UTM28ETRS89:"+title=Europe - de 18d a 12d Ouest +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=-15.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs",UTM29ETRS89:"+title=Europe - de 12d a 6d Ouest +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=-9.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs",UTM30ETRS89:"+title=Europe - de -6d a 0d Ouest +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=-3.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs",UTM31ETRS89:"+title=Europe - de 0d a 6d Est +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=3.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs",UTM32ETRS89:"+title=Europe - de 6d a 12d Est +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=9.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs",UTM33ETRS89:"+title=Europe - de 12d a 18d Est +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=15.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs",UTM34ETRS89:"+title=Europe - de 18d a 24d Est +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=21.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs",UTM35ETRS89:"+title=Europe - de 24d a 30d Est +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=27.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs",UTM36ETRS89:"+title=Europe - de 30d a 36d Est +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=33.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs",UTM37ETRS89:"+title=Europe - de 36d a 42d Est +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=39.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs",UTM38ETRS89:"+title=Europe - de 42d a 48d Est +proj=tmerc +nadgrids=null +wktext +towgs84=0.0000,0.0000,0.0000 +a=6378137.0000 +rf=298.2572221010000 +lat_0=0.000000000 +lon_0=45.000000000 +k_0=0.99960000 +x_0=500000.000 +y_0=0.000 +units=m +no_defs"}};e.default=o},function(t,e,i){"use strict";i.r(e);var o=i(2),n=i.n(o),s=i(141),a=i(154),r={instance:null,build:function(){if(!this.instance){var t=new n.a.Proj.CRS("EPSG:2154",a.default.get("EPSG:2154"),{resolutions:this._getResolutions(),origin:this._getOrigin()});this.instance=t}return this.instance},_getResolutions:function(){var t=[];s.default.isConfigLoaded()&&(t=s.default.getTileMatrix("LAMB93").nativeResolutions);return t.length?t:[104579.22454989408,52277.53235379051,26135.487078595408,13066.891381800004,6533.228604113456,3266.5595244626675,1633.2660045974187,816.6295549860224,408.31391467683596,204.15674151090204,102.07831678324082,51.0391448966112,25.519569074269395,12.759783693647506,6.379891635966491,3.18994576530532,1.5949728694977277,.7974864315474559,.398743214900604,.19937160727567999,.099685803696052,.049842901818919996]},_getOrigin:function(){return[0,12e6]}};e.default=r},function(t,e,i){"use strict";i.r(e);var o=i(2),n=i.n(o),s=i(141),a=i(154),r={instance:null,build:function(){if(!this.instance){var t=new n.a.Proj.CRS("EPSG:27572",a.default.get("EPSG:27572"),{resolutions:this._getResolutions(),origin:this._getOrigin()});this.instance=t}return this.instance},_getResolutions:function(){var t=[];if(s.default.isConfigLoaded()){var e=s.default.getTileMatrix("LAMB2E");e&&Object.keys(e)&&(t=e.nativeResolutions)}return t.length?t:[104579.22454989408,52277.53235379051,26135.487078595408,13066.891381800004,6533.228604113456,3266.5595244626675,1633.2660045974187,816.6295549860224,408.31391467683596,204.15674151090204,102.07831678324082,51.0391448966112,25.519569074269395,12.759783693647506,6.379891635966491,3.18994576530532,1.5949728694977277,.7974864315474559,.398743214900604,.19937160727567999,.099685803696052,.049842901818919996]},_getOrigin:function(){return[0,12e6]}};e.default=r},function(t,e,i){"use strict";i.r(e);var o=i(2),n=i.n(o),s=i(141),a=i(154),r={instance:null,build:function(){if(!this.instance){var t=new n.a.Proj.CRS("EPSG:4326",a.default.get("EPSG:4326"),{resolutions:this._getResolutions(),origin:[-180,90]});this.instance=t}return this.instance},_getResolutions:function(){var t=[];return s.default.isConfigLoaded()&&(t=s.default.getResolutions()),t.length?t:[1.40625,.703125,.3515625,.17578125,.087890625,.0439453125,.02197265625,.010986328125,.0054931640625,.00274658203125,.001373291015625,.0006866455078125,.00034332275390625,.000171661376953126,858306884765628e-19,429153442382813e-19,214576721191407e-19,107288360595703e-19,536441802978517e-20,268220901489259e-20,13411045074463e-19,6.70552253723145e-7,3.3527612686157e-7]},_getOrigin:function(){}};e.default=r},function(t,e,i){"use strict";i.r(e);var o=i(40),n=i(2),s=i.n(n),a=(i(159),i(34)),r=i(140),l=i(36),c=i(145),u=i(160),h=a.default.getLogger("reversegeocoding"),d=s.a.Control.extend({includes:u.default,options:{position:"bottomleft",collapsed:!0,resources:["StreetAddress","PositionOfInterest"],delimitations:["Point","Circle","Extent"],reverseGeocodeOptions:{}},initialize:function(t){s.a.Util.extend(this.options,t),this._noRightManagement=!1,this._servicesRightManagement={},this._checkRightsManagement(),this._checkInputOptions(),this._uid=l.default.generate(),this._currentGeocodingType=null,this._initGeocodingType(),this._currentGeocodingDelimitation=null,this._initGeocodingDelimitation(),this._showReverseGeocodingContainer=null,this._panelHeaderContainer=null,this._panelTitleContainer=null,this._returnPictoContainer=null,this._formContainer=null,this._resultsContainer=null,this._resultsListContainer=null,this._waitingContainer=null,this._inputFeaturesLayer=null,this._inputResultsLayer=null,this._lastIdLayer=0,this._currentIdLayer=0,this._currentFeature=null,this._requestPosition=null,this._requestCircleFilter=null,this._requestBboxFilter=null,this._waiting=!1,this._timer=null,this._reverseGeocodingLocations=[]},onAdd:function(t){var e=this._container=this._initLayout();return s.a.DomEvent.disableClickPropagation(e).disableScrollPropagation(e),t&&(this.options.collapsed||this._activateMapInteraction(t)),e},onRemove:function(t){this._clearLocations(),this._clearLocationsFeature(t),this._clearInputRequest(),this._removeMapInteraction(t)},_checkRightsManagement:function(){var t,e,i=[];t=this.options.reverseGeocodeOptions.apiKey,(i=(e=this.options.reverseGeocodeOptions.filterOptions)?e.type:[])&&0!==i.length||(i=this.options.resources),i&&0!==i.length||(i=["StreetAddress","PositionOfInterest"]);var o=r.default.check({key:t||this.options.apiKey,resources:i,services:["Geocode"]});h.log("rightManagementGeocode",o),o?(this.options.apiKey||(this.options.apiKey=o.key),o&&(this._servicesRightManagement.Geocode=o.Geocode)):this._noRightManagement=!0},_checkInputOptions:function(){var t;if(this.options.resources){var e=this.options.resources;Array.isArray(e)||(h.log("[ReverseGeocoding] 'options.resources' parameter should be an array"),e=null);var i=["StreetAddress","PositionOfInterest","CadastralParcel","Administratif"];for(t=0;t<e.length;t++)-1===i.indexOf(e[t])&&h.log("[ReverseGeocoding] options.resources : "+e[t]+" is not a resource for reverse geocode")}if(this.options.delimitations){var o=this.options.delimitations;Array.isArray(o)||(h.log("[ReverseGeocoding] 'options.delimitations' parameter should be an array"),o=null);var n=["Circle","Point","Extent"];for(t=0;t<o.length;t++)-1===n.indexOf(o[t])&&h.log("[ReverseGeocoding] options.delimitations : "+o[t]+" is not a delimitation for reverse geocode")}},_initGeocodingType:function(){this._currentGeocodingType="StreetAddress";var t=this.options.resources;if(t&&0!==t.length||(this.options.resources=["StreetAddress","PositionOfInterest","CadastralParcel"]),Array.isArray(t)&&t.length){for(var e=[],i=0;i<t.length;i++)this._servicesRightManagement.Geocode.indexOf(t[i])<0&&(e.push(i),h.log("[ReverseGeocode] no rights for options.resources : "+t[i]));if(0!==e.length)for(var o=0;o<e.length;o++)t.splice(e[o],1);"StreetAddress"!==t[0]&&"PositionOfInterest"!==t[0]&&"CadastralParcel"!==t[0]&&"Administratif"!==t[0]||(this._currentGeocodingType=t[0])}var n=this.options.reverseGeocodeOptions;n.filterOptions&&Array.isArray(n.filterOptions.type)&&0!==n.filterOptions.type.length&&(this._currentGeocodingType=n.filterOptions.type[0])},_initGeocodingDelimitation:function(){this._currentGeocodingDelimitation="Point";var t=this.options.delimitations;if(t&&0!==t.length||(this.options.delimitations=["Point","Circle","Extent"]),Array.isArray(t)&&t.length){var e=t[0].toLowerCase();"point"!==e&&"circle"!==e&&"extent"!==e||(this._currentGeocodingDelimitation=t[0])}},_initLayout:function(){var t=this._createMainContainerElement(),e=this._showReverseGeocodingContainer=this._createShowReverseGeocodingElement();t.appendChild(e),this.options.collapsed||(e.checked=!0);var i=this._createShowReverseGeocodingPictoElement();t.appendChild(i);var o=this._createReverseGeocodingPanelElement(),n=this._panelHeaderContainer=this._createReverseGeocodingPanelHeaderElement(),s=this._returnPictoContainer=this._createReverseGeocodingPanelReturnPictoElement();n.appendChild(s);var a=this._panelTitleContainer=this._createReverseGeocodingPanelTitleElement();n.appendChild(a);var r=this._createReverseGeocodingPanelCloseElement();n.appendChild(r),o.appendChild(n);var l=this._formContainer=this._createReverseGeocodingPanelFormElement();l.appendChild(this._createReverseGeocodingFormModeChoiceGeocodingTypeElement(this.options.resources)),l.appendChild(this._createReverseGeocodingFormModeChoiceGeocodingDelimitationElement(this.options.delimitations));var c=this._createReverseGeocodingSubmitFormElement();l.appendChild(c),o.appendChild(l);var u=this._waitingContainer=this._createReverseGeocodingWaitingElement();o.appendChild(u);var d=this._resultsContainer=this._createReverseGeocodingResultsPanelElement(),p=this._resultsListContainer=this._createReverseGeocodingResultsListElement();return d.appendChild(p),o.appendChild(d),t.appendChild(o),h.log(t),t},_activateMapInteraction:function(t){if(h.info("_activateMapInteraction()"),null===this._inputFeaturesLayer){this._inputFeaturesLayer=new s.a.FeatureGroup,t.addLayer(this._inputFeaturesLayer);var e=this;t.on("draw:created",(function(t){var i=t.layer,o=t.layerType;h.trace("draw:created"),e._setFeaturePosition(i,o),e._currentIdLayer=s.a.Util.stamp(i),e._setFeatureLayer(i)})),t.on("draw:drawstart",(function(){h.trace("draw:drawstart"),e._removeFeatureLayer(e._lastIdLayer),e._lastIdLayer=e._currentIdLayer})),t.on("draw:drawstop",(function(){h.trace("draw:drawstop")}))}switch(this._currentGeocodingDelimitation.toLowerCase()){case"point":this._activatePointInteraction(t);break;case"circle":this._activateCircleInteraction(t);break;case"extent":this._activateBoxInteraction(t)}},_removeMapInteraction:function(t){t&&(null!==this._inputFeaturesLayer&&(t.off("draw:created"),t.off("draw:drawstart"),t.off("draw:drawstop"),t.removeLayer(this._inputFeaturesLayer),this._inputFeaturesLayer=null),this._lastIdLayer=this._currentIdLayer=0,this._currentFeature&&this._currentFeature.disable())},_activatePointInteraction:function(t){h.info("_activatePointInteraction()"),this._currentFeature&&this._currentFeature.disable(),s.a.drawLocal.draw.handlers.marker.tooltip.start="click map to place search point";this._currentFeature=new s.a.Draw.Marker(t,{repeatMode:!0}),this._currentFeature.enable()},_activateCircleInteraction:function(t){h.info("_activateCircleInteraction()"),this._currentFeature&&this._currentFeature.disable();this._currentFeature=new s.a.Draw.Circle(t,{repeatMode:!0}),this._currentFeature.enable()},_activateBoxInteraction:function(t){h.info("_activateBoxInteraction()"),this._currentFeature&&this._currentFeature.disable();this._currentFeature=new s.a.Draw.Rectangle(t,{repeatMode:!0}),this._currentFeature.enable()},_setFeaturePosition:function(t,e){var i=null;if("marker"===e)i=t.getLatLng(),this._requestPosition={x:i.lat,y:i.lng};else if("circle"===e)i=t.getLatLng(),this._requestPosition={x:i.lat,y:i.lng},this._requestCircleFilter={x:i.lat,y:i.lng,radius:t.getRadius()};else if("rectangle"===e){var o={lng:((i=t.getBounds()).getSouthWest().lng+i.getNorthEast().lng)/2,lat:(i.getSouthWest().lat+i.getNorthEast().lat)/2};this._requestPosition={x:o.lat,y:o.lng},this._requestBboxFilter={left:i.getSouthWest().lat,right:i.getNorthEast().lat,bottom:i.getSouthWest().lng,top:i.getNorthEast().lng}}else h.warn("type gemetric not defined !?");h.log(i)},_setFeatureLayer:function(t){this._inputFeaturesLayer&&this._inputFeaturesLayer.addLayer(t)},_removeFeatureLayer:function(t){this._inputFeaturesLayer&&0!==t&&(t?this._inputFeaturesLayer.removeLayer(t):this._inputFeaturesLayer.clearLayers())},_reverseGeocodingRequest:function(t){var e=this._map;this._removeMapInteraction(e);var i={};s.a.Util.extend(i,this.options.reverseGeocodeOptions),s.a.Util.extend(i,t),s.a.Util.extend(i,{apiKey:this.options.apiKey,ssl:this.options.ssl,srs:"EPSG:4326",returnFreeForm:!1,timeOut:3e4,protocol:"XHR"});var n=i.filterOptions.type;"circle"===this._currentGeocodingDelimitation.toLowerCase()&&this._requestCircleFilter&&(this._requestCircleFilter.radius>1e3&&(h.log("INFO : initial circle radius ("+this._requestCircleFilter.radius+") limited to 1000m."),this._requestCircleFilter.radius=1e3),s.a.Util.extend(i,{filterOptions:{type:n,circle:this._requestCircleFilter}})),"extent"===this._currentGeocodingDelimitation.toLowerCase()&&this._requestBboxFilter&&s.a.Util.extend(i,{filterOptions:{type:n,bbox:this._requestBboxFilter}}),h.log("reverseGeocode request options : ",i),this._displayWaitingContainer(),o.default.Services.reverseGeocode(i)},_displayGeocodedLocations:function(t){var e=this._map;this._clearLocations(),this._clearLocationsFeature(e),this._reverseGeocodingLocations=t,t&&0!==t.length?(this._formContainer.className="GPreverseGeocodingComponentHidden",this._hideWaitingContainer(),this._panelTitleContainer.innerHTML="Résultats de la recherche",this._returnPictoContainer.className="",this._resultsContainer.className="GPpanel",this._fillGeocodedLocationListContainer(t),this._displayGeocodedLocationsOnMap(t),e.fitBounds(this._inputResultsLayer.getBounds())):this._clearInputRequest()},_fillGeocodedLocationListContainer:function(t){for(var e=0;e<t.length;e++){var i=t[e];h.log(i);var o=this._fillGeocodedLocationDescription(i);0!==o.length&&this._createReverseGeocodingResultElement(o,e)}},_fillGeocodedLocationDescription:function(t){if(t&&t.placeAttributes){var e=t.placeAttributes,i="";switch(t.type){case"StreetAddress":e.street&&(i+=e.number?e.number+" ":"",i+=e.street+", "),i+=e.postalCode+" "+e.commune;break;case"PositionOfInterest":"City"===t.matchType&&e.commune?(i+=e.commune,i+=e.postalCode?", "+e.postalCode:""):"Département"===t.matchType&&e.municipality?(i+=e.municipality,i+=e.postalCode?", "+e.postalCode:""):"Toponym"===t.matchType&&e.municipality?(i+=e.municipality,i+=e.postalCode?", "+e.postalCode:"",i+=e.commune?" "+e.commune:""):i+=e.municipality?e.municipality:"",i+=e.nature?" ("+e.nature+") ":"";break;case"CadastralParcel":i+=e.cadastralParcel?e.cadastralParcel:"",i+=e.municipality?" ("+e.municipality+")":"";break;case"Administratif":i+=e.municipality?e.municipality:"",e.inseeDepartment?i+="(Département)":e.inseeRegion&&(i+="(Région)");break;default:i+=e.municipality?e.municipality:""}return i}},_displayGeocodedLocationsOnMap:function(t){var e=this._map,i=this;function o(t){var e=t.target;e.setIcon(new c.default("red"));var o=s.a.DomUtil.get("ReverseGeocodedLocation_"+e.options.id+"-"+i._uid);s.a.DomUtil.addClass(o,"GPreverseGeocodedLocationHighlight"),o.scrollIntoView(!1)}function n(t){var e=t.target;e.setIcon(new c.default("green"));var o=s.a.DomUtil.get("ReverseGeocodedLocation_"+e.options.id+"-"+i._uid);s.a.DomUtil.removeClass(o,"GPreverseGeocodedLocationHighlight")}this._inputResultsLayer=new s.a.FeatureGroup,e.addLayer(this._inputResultsLayer);for(var a=0;a<t.length;a++){var r=t[a];if(r){var l={id:a,icon:new c.default("green"),riseOnHover:!0,draggable:!1,clickable:!0,zIndexOffset:1e3},u=s.a.marker(s.a.latLng(r.position.x,r.position.y),l),h="<ul>",d=r.placeAttributes;for(var p in d)d.hasOwnProperty(p)&&"bbox"!==p&&(h+="<li>",h+='<span class="gp-attname-others-span">'+p.toUpperCase()+" : </span>",h+=d[p],h+=" </li>");h+=" </ul>",u.bindPopup(h),u.on("mouseover",o),u.on("mouseout",n),this._inputResultsLayer.addLayer(u)}}},onShowReverseGeocodingClick:function(){var t=this._map;this._showReverseGeocodingContainer.checked?this._removeMapInteraction(t):this._waiting||this._reverseGeocodingLocations.length||this._activateMapInteraction(t)},onReverseGeocodingTypeChange:function(t){var e=t.target.selectedIndex,i=t.target.options[e].value;i&&(h.log(i),this._currentGeocodingType=i)},onReverseGeocodingDelimitationChange:function(t){var e=t.target.selectedIndex,i=t.target.options[e].value;if(i){h.log(i),this._currentGeocodingDelimitation=i,this._clearInputRequest();var o=this._map;this._removeMapInteraction(o),this._activateMapInteraction(o)}},onGPreverseGeocodingReturnPictoClick:function(){var t=this._map;this._clearLocations(),this._clearLocationsFeature(t),this._clearInputRequest(),this._activateMapInteraction(t)},onReverseGeocodingSubmit:function(){if(this._requestPosition){if(!this._noRightManagement){var t=this._map,e=this;this._reverseGeocodingRequest({position:e._requestPosition,filterOptions:{type:[e._currentGeocodingType]},onSuccess:function(t){if(h.log(t),t){var i=t.locations;e._displayGeocodedLocations(i),e._hideWaitingContainer()}},onFailure:function(i){e._hideWaitingContainer(),e._clearLocations(),e._clearLocationsFeature(t),e._clearInputRequest(),h.log(i.message)}})}}else h.log("missing position")},onReverseGeocodingResultClick:function(t){h.log("onReverseGeocodingResultClick",t)},onReverseGeocodingResultMouseOver:function(t){var e=l.default.index(t.target.id);t.target.classList&&t.target.classList.add("GPreverseGeocodedLocationHighlight"),this._inputResultsLayer&&this._inputResultsLayer.eachLayer((function(t){t.options.id===parseInt(e,10)&&t.fire("mouseover")}))},onReverseGeocodingResultMouseOut:function(t){var e=l.default.index(t.target.id);t.target.classList&&t.target.classList.remove("GPreverseGeocodedLocationHighlight"),this._inputResultsLayer&&this._inputResultsLayer.eachLayer((function(t){t.options.id===parseInt(e,10)&&t.fire("mouseout")}))},_clearLocations:function(){if(this._reverseGeocodingLocations=[],this._resultsListContainer)for(;this._resultsListContainer.firstChild;)this._resultsListContainer.removeChild(this._resultsListContainer.firstChild)},_clearLocationsFeature:function(t){null!==this._inputResultsLayer&&(t.removeLayer(this._inputResultsLayer),this._inputResultsLayer=null)},_clearInputRequest:function(){this._requestPosition=null,this._requestCircleFilter=null,this._requestBboxFilter=null},_displayWaitingContainer:function(){this._waitingContainer.className="GPreverseGeocodingCalcWaitingContainerVisible",this._waiting=!0,this._timer&&(clearTimeout(this._timer),this._timer=null);var t=this;this._timer=setTimeout((function(){!0===t._waiting?t._hideWaitingContainer():t._timer&&clearTimeout(t._timer)}),16e3)},_hideWaitingContainer:function(){this._waiting&&(this._waitingContainer.className="GPreverseGeocodingCalcWaitingContainerHidden",this._waiting=!1,clearTimeout(this._timer),this._timer=null)}});e.default=d},function(t,e){!function(t,e,i){var o;L.drawVersion="1.0.4",L.Draw={},L.drawLocal={draw:{toolbar:{actions:{title:"Cancel drawing",text:"Cancel"},finish:{title:"Finish drawing",text:"Finish"},undo:{title:"Delete last point drawn",text:"Delete last point"},buttons:{polyline:"Draw a polyline",polygon:"Draw a polygon",rectangle:"Draw a rectangle",circle:"Draw a circle",marker:"Draw a marker",circlemarker:"Draw a circlemarker"}},handlers:{circle:{tooltip:{start:"Click and drag to draw circle."},radius:"Radius"},circlemarker:{tooltip:{start:"Click map to place circle marker."}},marker:{tooltip:{start:"Click map to place marker."}},polygon:{tooltip:{start:"Click to start drawing shape.",cont:"Click to continue drawing shape.",end:"Click first point to close this shape."}},polyline:{error:"<strong>Error:</strong> shape edges cannot cross!",tooltip:{start:"Click to start drawing line.",cont:"Click to continue drawing line.",end:"Click last point to finish line."}},rectangle:{tooltip:{start:"Click and drag to draw rectangle."}},simpleshape:{tooltip:{end:"Release mouse to finish drawing."}}}},edit:{toolbar:{actions:{save:{title:"Save changes",text:"Save"},cancel:{title:"Cancel editing, discards all changes",text:"Cancel"},clearAll:{title:"Clear all layers",text:"Clear All"}},buttons:{edit:"Edit layers",editDisabled:"No layers to edit",remove:"Delete layers",removeDisabled:"No layers to delete"}},handlers:{edit:{tooltip:{text:"Drag handles or markers to edit features.",subtext:"Click cancel to undo changes."}},remove:{tooltip:{text:"Click on a feature to remove."}}}}},L.Draw.Event={},L.Draw.Event.CREATED="draw:created",L.Draw.Event.EDITED="draw:edited",L.Draw.Event.DELETED="draw:deleted",L.Draw.Event.DRAWSTART="draw:drawstart",L.Draw.Event.DRAWSTOP="draw:drawstop",L.Draw.Event.DRAWVERTEX="draw:drawvertex",L.Draw.Event.EDITSTART="draw:editstart",L.Draw.Event.EDITMOVE="draw:editmove",L.Draw.Event.EDITRESIZE="draw:editresize",L.Draw.Event.EDITVERTEX="draw:editvertex",L.Draw.Event.EDITSTOP="draw:editstop",L.Draw.Event.DELETESTART="draw:deletestart",L.Draw.Event.DELETESTOP="draw:deletestop",L.Draw.Event.TOOLBAROPENED="draw:toolbaropened",L.Draw.Event.TOOLBARCLOSED="draw:toolbarclosed",L.Draw.Event.MARKERCONTEXT="draw:markercontext",L.Draw=L.Draw||{},L.Draw.Feature=L.Handler.extend({initialize:function(t,e){this._map=t,this._container=t._container,this._overlayPane=t._panes.overlayPane,this._popupPane=t._panes.popupPane,e&&e.shapeOptions&&(e.shapeOptions=L.Util.extend({},this.options.shapeOptions,e.shapeOptions)),L.setOptions(this,e);var i=L.version.split(".");1===parseInt(i[0],10)&&parseInt(i[1],10)>=2?L.Draw.Feature.include(L.Evented.prototype):L.Draw.Feature.include(L.Mixin.Events)},enable:function(){this._enabled||(L.Handler.prototype.enable.call(this),this.fire("enabled",{handler:this.type}),this._map.fire(L.Draw.Event.DRAWSTART,{layerType:this.type}))},disable:function(){this._enabled&&(L.Handler.prototype.disable.call(this),this._map.fire(L.Draw.Event.DRAWSTOP,{layerType:this.type}),this.fire("disabled",{handler:this.type}))},addHooks:function(){var t=this._map;t&&(L.DomUtil.disableTextSelection(),t.getContainer().focus(),this._tooltip=new L.Draw.Tooltip(this._map),L.DomEvent.on(this._container,"keyup",this._cancelDrawing,this))},removeHooks:function(){this._map&&(L.DomUtil.enableTextSelection(),this._tooltip.dispose(),this._tooltip=null,L.DomEvent.off(this._container,"keyup",this._cancelDrawing,this))},setOptions:function(t){L.setOptions(this,t)},_fireCreatedEvent:function(t){this._map.fire(L.Draw.Event.CREATED,{layer:t,layerType:this.type})},_cancelDrawing:function(t){27===t.keyCode&&(this._map.fire("draw:canceled",{layerType:this.type}),this.disable())}}),L.Draw.Polyline=L.Draw.Feature.extend({statics:{TYPE:"polyline"},Poly:L.Polyline,options:{allowIntersection:!0,repeatMode:!1,drawError:{color:"#b00b00",timeout:2500},icon:new L.DivIcon({iconSize:new L.Point(8,8),className:"leaflet-div-icon leaflet-editing-icon"}),touchIcon:new L.DivIcon({iconSize:new L.Point(20,20),className:"leaflet-div-icon leaflet-editing-icon leaflet-touch-icon"}),guidelineDistance:20,maxGuideLineLength:4e3,shapeOptions:{stroke:!0,color:"#3388ff",weight:4,opacity:.5,fill:!1,clickable:!0},metric:!0,feet:!0,nautic:!1,showLength:!0,zIndexOffset:2e3,factor:1,maxPoints:0},initialize:function(t,e){L.Browser.touch&&(this.options.icon=this.options.touchIcon),this.options.drawError.message=L.drawLocal.draw.handlers.polyline.error,e&&e.drawError&&(e.drawError=L.Util.extend({},this.options.drawError,e.drawError)),this.type=L.Draw.Polyline.TYPE,L.Draw.Feature.prototype.initialize.call(this,t,e)},addHooks:function(){L.Draw.Feature.prototype.addHooks.call(this),this._map&&(this._markers=[],this._markerGroup=new L.LayerGroup,this._map.addLayer(this._markerGroup),this._poly=new L.Polyline([],this.options.shapeOptions),this._tooltip.updateContent(this._getTooltipText()),this._mouseMarker||(this._mouseMarker=L.marker(this._map.getCenter(),{icon:L.divIcon({className:"leaflet-mouse-marker",iconAnchor:[20,20],iconSize:[40,40]}),opacity:0,zIndexOffset:this.options.zIndexOffset})),this._mouseMarker.on("mouseout",this._onMouseOut,this).on("mousemove",this._onMouseMove,this).on("mousedown",this._onMouseDown,this).on("mouseup",this._onMouseUp,this).addTo(this._map),this._map.on("mouseup",this._onMouseUp,this).on("mousemove",this._onMouseMove,this).on("zoomlevelschange",this._onZoomEnd,this).on("touchstart",this._onTouch,this).on("zoomend",this._onZoomEnd,this))},removeHooks:function(){L.Draw.Feature.prototype.removeHooks.call(this),this._clearHideErrorTimeout(),this._cleanUpShape(),this._map.removeLayer(this._markerGroup),delete this._markerGroup,delete this._markers,this._map.removeLayer(this._poly),delete this._poly,this._mouseMarker.off("mousedown",this._onMouseDown,this).off("mouseout",this._onMouseOut,this).off("mouseup",this._onMouseUp,this).off("mousemove",this._onMouseMove,this),this._map.removeLayer(this._mouseMarker),delete this._mouseMarker,this._clearGuides(),this._map.off("mouseup",this._onMouseUp,this).off("mousemove",this._onMouseMove,this).off("zoomlevelschange",this._onZoomEnd,this).off("zoomend",this._onZoomEnd,this).off("touchstart",this._onTouch,this).off("click",this._onTouch,this)},deleteLastVertex:function(){if(!(this._markers.length<=1)){var t=this._markers.pop(),e=this._poly,i=e.getLatLngs(),o=i.splice(-1,1)[0];this._poly.setLatLngs(i),this._markerGroup.removeLayer(t),e.getLatLngs().length<2&&this._map.removeLayer(e),this._vertexChanged(o,!1)}},addVertex:function(t){this._markers.length>=2&&!this.options.allowIntersection&&this._poly.newLatLngIntersects(t)?this._showErrorTooltip():(this._errorShown&&this._hideErrorTooltip(),this._markers.push(this._createMarker(t)),this._poly.addLatLng(t),2===this._poly.getLatLngs().length&&this._map.addLayer(this._poly),this._vertexChanged(t,!0))},completeShape:function(){this._markers.length<=1||!this._shapeIsValid()||(this._fireCreatedEvent(),this.disable(),this.options.repeatMode&&this.enable())},_finishShape:function(){var t=this._poly._defaultShape?this._poly._defaultShape():this._poly.getLatLngs(),e=this._poly.newLatLngIntersects(t[t.length-1]);!this.options.allowIntersection&&e||!this._shapeIsValid()?this._showErrorTooltip():(this._fireCreatedEvent(),this.disable(),this.options.repeatMode&&this.enable())},_shapeIsValid:function(){return!0},_onZoomEnd:function(){null!==this._markers&&this._updateGuide()},_onMouseMove:function(t){var e=this._map.mouseEventToLayerPoint(t.originalEvent),i=this._map.layerPointToLatLng(e);this._currentLatLng=i,this._updateTooltip(i),this._updateGuide(e),this._mouseMarker.setLatLng(i),L.DomEvent.preventDefault(t.originalEvent)},_vertexChanged:function(t,e){this._map.fire(L.Draw.Event.DRAWVERTEX,{layers:this._markerGroup}),this._updateFinishHandler(),this._updateRunningMeasure(t,e),this._clearGuides(),this._updateTooltip()},_onMouseDown:function(t){if(!this._clickHandled&&!this._touchHandled&&!this._disableMarkers){this._onMouseMove(t),this._clickHandled=!0,this._disableNewMarkers();var e=t.originalEvent,i=e.clientX,o=e.clientY;this._startPoint.call(this,i,o)}},_startPoint:function(t,e){this._mouseDownOrigin=L.point(t,e)},_onMouseUp:function(t){var e=t.originalEvent,i=e.clientX,o=e.clientY;this._endPoint.call(this,i,o,t),this._clickHandled=null},_endPoint:function(e,i,o){if(this._mouseDownOrigin){var n=L.point(e,i).distanceTo(this._mouseDownOrigin),s=this._calculateFinishDistance(o.latlng);this.options.maxPoints>1&&this.options.maxPoints==this._markers.length+1?(this.addVertex(o.latlng),this._finishShape()):s<10&&L.Browser.touch?this._finishShape():Math.abs(n)<9*(t.devicePixelRatio||1)&&this.addVertex(o.latlng),this._enableNewMarkers()}this._mouseDownOrigin=null},_onTouch:function(t){var e,i,o=t.originalEvent;!o.touches||!o.touches[0]||this._clickHandled||this._touchHandled||this._disableMarkers||(e=o.touches[0].clientX,i=o.touches[0].clientY,this._disableNewMarkers(),this._touchHandled=!0,this._startPoint.call(this,e,i),this._endPoint.call(this,e,i,t),this._touchHandled=null),this._clickHandled=null},_onMouseOut:function(){this._tooltip&&this._tooltip._onMouseOut.call(this._tooltip)},_calculateFinishDistance:function(t){var e;if(this._markers.length>0){var i;if(this.type===L.Draw.Polyline.TYPE)i=this._markers[this._markers.length-1];else{if(this.type!==L.Draw.Polygon.TYPE)return 1/0;i=this._markers[0]}var o=this._map.latLngToContainerPoint(i.getLatLng()),n=new L.Marker(t,{icon:this.options.icon,zIndexOffset:2*this.options.zIndexOffset}),s=this._map.latLngToContainerPoint(n.getLatLng());e=o.distanceTo(s)}else e=1/0;return e},_updateFinishHandler:function(){var t=this._markers.length;t>1&&this._markers[t-1].on("click",this._finishShape,this),t>2&&this._markers[t-2].off("click",this._finishShape,this)},_createMarker:function(t){var e=new L.Marker(t,{icon:this.options.icon,zIndexOffset:2*this.options.zIndexOffset});return this._markerGroup.addLayer(e),e},_updateGuide:function(t){var e=this._markers?this._markers.length:0;e>0&&(t=t||this._map.latLngToLayerPoint(this._currentLatLng),this._clearGuides(),this._drawGuide(this._map.latLngToLayerPoint(this._markers[e-1].getLatLng()),t))},_updateTooltip:function(t){var e=this._getTooltipText();t&&this._tooltip.updatePosition(t),this._errorShown||this._tooltip.updateContent(e)},_drawGuide:function(t,e){var i,o,n,s=Math.floor(Math.sqrt(Math.pow(e.x-t.x,2)+Math.pow(e.y-t.y,2))),a=this.options.guidelineDistance,r=this.options.maxGuideLineLength,l=s>r?s-r:a;for(this._guidesContainer||(this._guidesContainer=L.DomUtil.create("div","leaflet-draw-guides",this._overlayPane));l<s;l+=this.options.guidelineDistance)i=l/s,o={x:Math.floor(t.x*(1-i)+i*e.x),y:Math.floor(t.y*(1-i)+i*e.y)},(n=L.DomUtil.create("div","leaflet-draw-guide-dash",this._guidesContainer)).style.backgroundColor=this._errorShown?this.options.drawError.color:this.options.shapeOptions.color,L.DomUtil.setPosition(n,o)},_updateGuideColor:function(t){if(this._guidesContainer)for(var e=0,i=this._guidesContainer.childNodes.length;e<i;e++)this._guidesContainer.childNodes[e].style.backgroundColor=t},_clearGuides:function(){if(this._guidesContainer)for(;this._guidesContainer.firstChild;)this._guidesContainer.removeChild(this._guidesContainer.firstChild)},_getTooltipText:function(){var t,e,i=this.options.showLength;return 0===this._markers.length?t={text:L.drawLocal.draw.handlers.polyline.tooltip.start}:(e=i?this._getMeasurementString():"",t=1===this._markers.length?{text:L.drawLocal.draw.handlers.polyline.tooltip.cont,subtext:e}:{text:L.drawLocal.draw.handlers.polyline.tooltip.end,subtext:e}),t},_updateRunningMeasure:function(t,e){var i,o,n=this._markers.length;1===this._markers.length?this._measurementRunningTotal=0:(i=n-(e?2:1),o=L.GeometryUtil.isVersion07x()?t.distanceTo(this._markers[i].getLatLng())*(this.options.factor||1):this._map.distance(t,this._markers[i].getLatLng())*(this.options.factor||1),this._measurementRunningTotal+=o*(e?1:-1))},_getMeasurementString:function(){var t,e=this._currentLatLng,i=this._markers[this._markers.length-1].getLatLng();return t=L.GeometryUtil.isVersion07x()?i&&e&&e.distanceTo?this._measurementRunningTotal+e.distanceTo(i)*(this.options.factor||1):this._measurementRunningTotal||0:i&&e?this._measurementRunningTotal+this._map.distance(e,i)*(this.options.factor||1):this._measurementRunningTotal||0,L.GeometryUtil.readableDistance(t,this.options.metric,this.options.feet,this.options.nautic,this.options.precision)},_showErrorTooltip:function(){this._errorShown=!0,this._tooltip.showAsError().updateContent({text:this.options.drawError.message}),this._updateGuideColor(this.options.drawError.color),this._poly.setStyle({color:this.options.drawError.color}),this._clearHideErrorTimeout(),this._hideErrorTimeout=setTimeout(L.Util.bind(this._hideErrorTooltip,this),this.options.drawError.timeout)},_hideErrorTooltip:function(){this._errorShown=!1,this._clearHideErrorTimeout(),this._tooltip.removeError().updateContent(this._getTooltipText()),this._updateGuideColor(this.options.shapeOptions.color),this._poly.setStyle({color:this.options.shapeOptions.color})},_clearHideErrorTimeout:function(){this._hideErrorTimeout&&(clearTimeout(this._hideErrorTimeout),this._hideErrorTimeout=null)},_disableNewMarkers:function(){this._disableMarkers=!0},_enableNewMarkers:function(){setTimeout(function(){this._disableMarkers=!1}.bind(this),50)},_cleanUpShape:function(){this._markers.length>1&&this._markers[this._markers.length-1].off("click",this._finishShape,this)},_fireCreatedEvent:function(){var t=new this.Poly(this._poly.getLatLngs(),this.options.shapeOptions);L.Draw.Feature.prototype._fireCreatedEvent.call(this,t)}}),L.Draw.Polygon=L.Draw.Polyline.extend({statics:{TYPE:"polygon"},Poly:L.Polygon,options:{showArea:!1,showLength:!1,shapeOptions:{stroke:!0,color:"#3388ff",weight:4,opacity:.5,fill:!0,fillColor:null,fillOpacity:.2,clickable:!0},metric:!0,feet:!0,nautic:!1,precision:{}},initialize:function(t,e){L.Draw.Polyline.prototype.initialize.call(this,t,e),this.type=L.Draw.Polygon.TYPE},_updateFinishHandler:function(){var t=this._markers.length;1===t&&this._markers[0].on("click",this._finishShape,this),t>2&&(this._markers[t-1].on("dblclick",this._finishShape,this),t>3&&this._markers[t-2].off("dblclick",this._finishShape,this))},_getTooltipText:function(){var t,e;return 0===this._markers.length?t=L.drawLocal.draw.handlers.polygon.tooltip.start:this._markers.length<3?(t=L.drawLocal.draw.handlers.polygon.tooltip.cont,e=this._getMeasurementString()):(t=L.drawLocal.draw.handlers.polygon.tooltip.end,e=this._getMeasurementString()),{text:t,subtext:e}},_getMeasurementString:function(){var t=this._area,e="";return t||this.options.showLength?(this.options.showLength&&(e=L.Draw.Polyline.prototype._getMeasurementString.call(this)),t&&(e+="<br>"+L.GeometryUtil.readableArea(t,this.options.metric,this.options.precision)),e):null},_shapeIsValid:function(){return this._markers.length>=3},_vertexChanged:function(t,e){var i;!this.options.allowIntersection&&this.options.showArea&&(i=this._poly.getLatLngs(),this._area=L.GeometryUtil.geodesicArea(i)),L.Draw.Polyline.prototype._vertexChanged.call(this,t,e)},_cleanUpShape:function(){var t=this._markers.length;t>0&&(this._markers[0].off("click",this._finishShape,this),t>2&&this._markers[t-1].off("dblclick",this._finishShape,this))}}),L.SimpleShape={},L.Draw.SimpleShape=L.Draw.Feature.extend({options:{repeatMode:!1},initialize:function(t,e){this._endLabelText=L.drawLocal.draw.handlers.simpleshape.tooltip.end,L.Draw.Feature.prototype.initialize.call(this,t,e)},addHooks:function(){L.Draw.Feature.prototype.addHooks.call(this),this._map&&(this._mapDraggable=this._map.dragging.enabled(),this._mapDraggable&&this._map.dragging.disable(),this._container.style.cursor="crosshair",this._tooltip.updateContent({text:this._initialLabelText}),this._map.on("mousedown",this._onMouseDown,this).on("mousemove",this._onMouseMove,this).on("touchstart",this._onMouseDown,this).on("touchmove",this._onMouseMove,this),e.addEventListener("touchstart",L.DomEvent.preventDefault,{passive:!1}))},removeHooks:function(){L.Draw.Feature.prototype.removeHooks.call(this),this._map&&(this._mapDraggable&&this._map.dragging.enable(),this._container.style.cursor="",this._map.off("mousedown",this._onMouseDown,this).off("mousemove",this._onMouseMove,this).off("touchstart",this._onMouseDown,this).off("touchmove",this._onMouseMove,this),L.DomEvent.off(e,"mouseup",this._onMouseUp,this),L.DomEvent.off(e,"touchend",this._onMouseUp,this),e.removeEventListener("touchstart",L.DomEvent.preventDefault),this._shape&&(this._map.removeLayer(this._shape),delete this._shape)),this._isDrawing=!1},_getTooltipText:function(){return{text:this._endLabelText}},_onMouseDown:function(t){this._isDrawing=!0,this._startLatLng=t.latlng,L.DomEvent.on(e,"mouseup",this._onMouseUp,this).on(e,"touchend",this._onMouseUp,this).preventDefault(t.originalEvent)},_onMouseMove:function(t){var e=t.latlng;this._tooltip.updatePosition(e),this._isDrawing&&(this._tooltip.updateContent(this._getTooltipText()),this._drawShape(e))},_onMouseUp:function(){this._shape&&this._fireCreatedEvent(),this.disable(),this.options.repeatMode&&this.enable()}}),L.Draw.Rectangle=L.Draw.SimpleShape.extend({statics:{TYPE:"rectangle"},options:{shapeOptions:{stroke:!0,color:"#3388ff",weight:4,opacity:.5,fill:!0,fillColor:null,fillOpacity:.2,clickable:!0},showArea:!0,metric:!0},initialize:function(t,e){this.type=L.Draw.Rectangle.TYPE,this._initialLabelText=L.drawLocal.draw.handlers.rectangle.tooltip.start,L.Draw.SimpleShape.prototype.initialize.call(this,t,e)},disable:function(){this._enabled&&(this._isCurrentlyTwoClickDrawing=!1,L.Draw.SimpleShape.prototype.disable.call(this))},_onMouseUp:function(t){this._shape||this._isCurrentlyTwoClickDrawing?this._isCurrentlyTwoClickDrawing&&!function(t,e){for(;(t=t.parentElement)&&!t.classList.contains(e););return t}(t.target,"leaflet-pane")||L.Draw.SimpleShape.prototype._onMouseUp.call(this):this._isCurrentlyTwoClickDrawing=!0},_drawShape:function(t){this._shape?this._shape.setBounds(new L.LatLngBounds(this._startLatLng,t)):(this._shape=new L.Rectangle(new L.LatLngBounds(this._startLatLng,t),this.options.shapeOptions),this._map.addLayer(this._shape))},_fireCreatedEvent:function(){var t=new L.Rectangle(this._shape.getBounds(),this.options.shapeOptions);L.Draw.SimpleShape.prototype._fireCreatedEvent.call(this,t)},_getTooltipText:function(){var t,e,i,o=L.Draw.SimpleShape.prototype._getTooltipText.call(this),n=this._shape,s=this.options.showArea;return n&&(t=this._shape._defaultShape?this._shape._defaultShape():this._shape.getLatLngs(),e=L.GeometryUtil.geodesicArea(t),i=s?L.GeometryUtil.readableArea(e,this.options.metric):""),{text:o.text,subtext:i}}}),L.Draw.Marker=L.Draw.Feature.extend({statics:{TYPE:"marker"},options:{icon:new L.Icon.Default,repeatMode:!1,zIndexOffset:2e3},initialize:function(t,e){this.type=L.Draw.Marker.TYPE,this._initialLabelText=L.drawLocal.draw.handlers.marker.tooltip.start,L.Draw.Feature.prototype.initialize.call(this,t,e)},addHooks:function(){L.Draw.Feature.prototype.addHooks.call(this),this._map&&(this._tooltip.updateContent({text:this._initialLabelText}),this._mouseMarker||(this._mouseMarker=L.marker(this._map.getCenter(),{icon:L.divIcon({className:"leaflet-mouse-marker",iconAnchor:[20,20],iconSize:[40,40]}),opacity:0,zIndexOffset:this.options.zIndexOffset})),this._mouseMarker.on("click",this._onClick,this).addTo(this._map),this._map.on("mousemove",this._onMouseMove,this),this._map.on("click",this._onTouch,this))},removeHooks:function(){L.Draw.Feature.prototype.removeHooks.call(this),this._map&&(this._map.off("click",this._onClick,this).off("click",this._onTouch,this),this._marker&&(this._marker.off("click",this._onClick,this),this._map.removeLayer(this._marker),delete this._marker),this._mouseMarker.off("click",this._onClick,this),this._map.removeLayer(this._mouseMarker),delete this._mouseMarker,this._map.off("mousemove",this._onMouseMove,this))},_onMouseMove:function(t){var e=t.latlng;this._tooltip.updatePosition(e),this._mouseMarker.setLatLng(e),this._marker?(e=this._mouseMarker.getLatLng(),this._marker.setLatLng(e)):(this._marker=this._createMarker(e),this._marker.on("click",this._onClick,this),this._map.on("click",this._onClick,this).addLayer(this._marker))},_createMarker:function(t){return new L.Marker(t,{icon:this.options.icon,zIndexOffset:this.options.zIndexOffset})},_onClick:function(){this._fireCreatedEvent(),this.disable(),this.options.repeatMode&&this.enable()},_onTouch:function(t){this._onMouseMove(t),this._onClick()},_fireCreatedEvent:function(){var t=new L.Marker.Touch(this._marker.getLatLng(),{icon:this.options.icon});L.Draw.Feature.prototype._fireCreatedEvent.call(this,t)}}),L.Draw.CircleMarker=L.Draw.Marker.extend({statics:{TYPE:"circlemarker"},options:{stroke:!0,color:"#3388ff",weight:4,opacity:.5,fill:!0,fillColor:null,fillOpacity:.2,clickable:!0,zIndexOffset:2e3},initialize:function(t,e){this.type=L.Draw.CircleMarker.TYPE,this._initialLabelText=L.drawLocal.draw.handlers.circlemarker.tooltip.start,L.Draw.Feature.prototype.initialize.call(this,t,e)},_fireCreatedEvent:function(){var t=new L.CircleMarker(this._marker.getLatLng(),this.options);L.Draw.Feature.prototype._fireCreatedEvent.call(this,t)},_createMarker:function(t){return new L.CircleMarker(t,this.options)}}),L.Draw.Circle=L.Draw.SimpleShape.extend({statics:{TYPE:"circle"},options:{shapeOptions:{stroke:!0,color:"#3388ff",weight:4,opacity:.5,fill:!0,fillColor:null,fillOpacity:.2,clickable:!0},showRadius:!0,metric:!0,feet:!0,nautic:!1},initialize:function(t,e){this.type=L.Draw.Circle.TYPE,this._initialLabelText=L.drawLocal.draw.handlers.circle.tooltip.start,L.Draw.SimpleShape.prototype.initialize.call(this,t,e)},_drawShape:function(t){if(L.GeometryUtil.isVersion07x())var e=this._startLatLng.distanceTo(t);else e=this._map.distance(this._startLatLng,t);this._shape?this._shape.setRadius(e):(this._shape=new L.Circle(this._startLatLng,e,this.options.shapeOptions),this._map.addLayer(this._shape))},_fireCreatedEvent:function(){var t=new L.Circle(this._startLatLng,this._shape.getRadius(),this.options.shapeOptions);L.Draw.SimpleShape.prototype._fireCreatedEvent.call(this,t)},_onMouseMove:function(t){var e,i=t.latlng,o=this.options.showRadius,n=this.options.metric;if(this._tooltip.updatePosition(i),this._isDrawing){this._drawShape(i),e=this._shape.getRadius().toFixed(1);var s="";o&&(s=L.drawLocal.draw.handlers.circle.radius+": "+L.GeometryUtil.readableDistance(e,n,this.options.feet,this.options.nautic)),this._tooltip.updateContent({text:this._endLabelText,subtext:s})}}}),L.Edit=L.Edit||{},L.Edit.Marker=L.Handler.extend({initialize:function(t,e){this._marker=t,L.setOptions(this,e)},addHooks:function(){var t=this._marker;t.dragging.enable(),t.on("dragend",this._onDragEnd,t),this._toggleMarkerHighlight()},removeHooks:function(){var t=this._marker;t.dragging.disable(),t.off("dragend",this._onDragEnd,t),this._toggleMarkerHighlight()},_onDragEnd:function(t){var e=t.target;e.edited=!0,this._map.fire(L.Draw.Event.EDITMOVE,{layer:e})},_toggleMarkerHighlight:function(){var t=this._marker._icon;t&&(t.style.display="none",L.DomUtil.hasClass(t,"leaflet-edit-marker-selected")?(L.DomUtil.removeClass(t,"leaflet-edit-marker-selected"),this._offsetMarker(t,-4)):(L.DomUtil.addClass(t,"leaflet-edit-marker-selected"),this._offsetMarker(t,4)),t.style.display="")},_offsetMarker:function(t,e){var i=parseInt(t.style.marginTop,10)-e,o=parseInt(t.style.marginLeft,10)-e;t.style.marginTop=i+"px",t.style.marginLeft=o+"px"}}),L.Marker.addInitHook((function(){L.Edit.Marker&&(this.editing=new L.Edit.Marker(this),this.options.editable&&this.editing.enable())})),L.Edit=L.Edit||{},L.Edit.Poly=L.Handler.extend({initialize:function(t){this.latlngs=[t._latlngs],t._holes&&(this.latlngs=this.latlngs.concat(t._holes)),this._poly=t,this._poly.on("revert-edited",this._updateLatLngs,this)},_defaultShape:function(){return L.Polyline._flat?L.Polyline._flat(this._poly._latlngs)?this._poly._latlngs:this._poly._latlngs[0]:this._poly._latlngs},_eachVertexHandler:function(t){for(var e=0;e<this._verticesHandlers.length;e++)t(this._verticesHandlers[e])},addHooks:function(){this._initHandlers(),this._eachVertexHandler((function(t){t.addHooks()}))},removeHooks:function(){this._eachVertexHandler((function(t){t.removeHooks()}))},updateMarkers:function(){this._eachVertexHandler((function(t){t.updateMarkers()}))},_initHandlers:function(){this._verticesHandlers=[];for(var t=0;t<this.latlngs.length;t++)this._verticesHandlers.push(new L.Edit.PolyVerticesEdit(this._poly,this.latlngs[t],this._poly.options.poly))},_updateLatLngs:function(t){this.latlngs=[t.layer._latlngs],t.layer._holes&&(this.latlngs=this.latlngs.concat(t.layer._holes))}}),L.Edit.PolyVerticesEdit=L.Handler.extend({options:{icon:new L.DivIcon({iconSize:new L.Point(8,8),className:"leaflet-div-icon leaflet-editing-icon"}),touchIcon:new L.DivIcon({iconSize:new L.Point(20,20),className:"leaflet-div-icon leaflet-editing-icon leaflet-touch-icon"}),drawError:{color:"#b00b00",timeout:1e3}},initialize:function(t,e,i){L.Browser.touch&&(this.options.icon=this.options.touchIcon),this._poly=t,i&&i.drawError&&(i.drawError=L.Util.extend({},this.options.drawError,i.drawError)),this._latlngs=e,L.setOptions(this,i)},_defaultShape:function(){return L.Polyline._flat?L.Polyline._flat(this._latlngs)?this._latlngs:this._latlngs[0]:this._latlngs},addHooks:function(){var t=this._poly,e=t._path;t instanceof L.Polygon||(t.options.fill=!1,t.options.editing&&(t.options.editing.fill=!1)),e&&t.options.editing&&t.options.editing.className&&(t.options.original.className&&t.options.original.className.split(" ").forEach((function(t){L.DomUtil.removeClass(e,t)})),t.options.editing.className.split(" ").forEach((function(t){L.DomUtil.addClass(e,t)}))),t.setStyle(t.options.editing),this._poly._map&&(this._map=this._poly._map,this._markerGroup||this._initMarkers(),this._poly._map.addLayer(this._markerGroup))},removeHooks:function(){var t=this._poly,e=t._path;e&&t.options.editing&&t.options.editing.className&&(t.options.editing.className.split(" ").forEach((function(t){L.DomUtil.removeClass(e,t)})),t.options.original.className&&t.options.original.className.split(" ").forEach((function(t){L.DomUtil.addClass(e,t)}))),t.setStyle(t.options.original),t._map&&(t._map.removeLayer(this._markerGroup),delete this._markerGroup,delete this._markers)},updateMarkers:function(){this._markerGroup.clearLayers(),this._initMarkers()},_initMarkers:function(){this._markerGroup||(this._markerGroup=new L.LayerGroup),this._markers=[];var t,e,i,o,n,s,a=this._defaultShape();for(t=0,i=a.length;t<i;t++)(o=this._createMarker(a[t],t)).on("click",this._onMarkerClick,this),o.on("contextmenu",this._onContextMenu,this),this._markers.push(o);for(t=0,e=i-1;t<i;e=t++)(0!==t||L.Polygon&&this._poly instanceof L.Polygon)&&(n=this._markers[e],s=this._markers[t],this._createMiddleMarker(n,s),this._updatePrevNext(n,s))},_createMarker:function(t,e){var i=new L.Marker.Touch(t,{draggable:!0,icon:this.options.icon});return i._origLatLng=t,i._index=e,i.on("dragstart",this._onMarkerDragStart,this).on("drag",this._onMarkerDrag,this).on("dragend",this._fireEdit,this).on("touchmove",this._onTouchMove,this).on("touchend",this._fireEdit,this).on("MSPointerMove",this._onTouchMove,this).on("MSPointerUp",this._fireEdit,this),this._markerGroup.addLayer(i),i},_onMarkerDragStart:function(){this._poly.fire("editstart")},_spliceLatLngs:function(){var t=this._defaultShape(),e=[].splice.apply(t,arguments);return this._poly._convertLatLngs(t,!0),this._poly.redraw(),e},_removeMarker:function(t){var e=t._index;this._markerGroup.removeLayer(t),this._markers.splice(e,1),this._spliceLatLngs(e,1),this._updateIndexes(e,-1),t.off("dragstart",this._onMarkerDragStart,this).off("drag",this._onMarkerDrag,this).off("dragend",this._fireEdit,this).off("touchmove",this._onMarkerDrag,this).off("touchend",this._fireEdit,this).off("click",this._onMarkerClick,this).off("MSPointerMove",this._onTouchMove,this).off("MSPointerUp",this._fireEdit,this)},_fireEdit:function(){this._poly.edited=!0,this._poly.fire("edit"),this._poly._map.fire(L.Draw.Event.EDITVERTEX,{layers:this._markerGroup,poly:this._poly})},_onMarkerDrag:function(t){var e=t.target,i=this._poly,o=L.LatLngUtil.cloneLatLng(e._origLatLng);if(L.extend(e._origLatLng,e._latlng),i.options.poly){var n=i._map._editTooltip;if(!i.options.poly.allowIntersection&&i.intersects()){L.extend(e._origLatLng,o),e.setLatLng(o);var s=i.options.color;i.setStyle({color:this.options.drawError.color}),n&&n.updateContent({text:L.drawLocal.draw.handlers.polyline.error}),setTimeout((function(){i.setStyle({color:s}),n&&n.updateContent({text:L.drawLocal.edit.handlers.edit.tooltip.text,subtext:L.drawLocal.edit.handlers.edit.tooltip.subtext})}),1e3)}}e._middleLeft&&e._middleLeft.setLatLng(this._getMiddleLatLng(e._prev,e)),e._middleRight&&e._middleRight.setLatLng(this._getMiddleLatLng(e,e._next)),this._poly._bounds._southWest=L.latLng(1/0,1/0),this._poly._bounds._northEast=L.latLng(-1/0,-1/0);var a=this._poly.getLatLngs();this._poly._convertLatLngs(a,!0),this._poly.redraw(),this._poly.fire("editdrag")},_onMarkerClick:function(t){var e=L.Polygon&&this._poly instanceof L.Polygon?4:3,i=t.target;this._defaultShape().length<e||(this._removeMarker(i),this._updatePrevNext(i._prev,i._next),i._middleLeft&&this._markerGroup.removeLayer(i._middleLeft),i._middleRight&&this._markerGroup.removeLayer(i._middleRight),i._prev&&i._next?this._createMiddleMarker(i._prev,i._next):i._prev?i._next||(i._prev._middleRight=null):i._next._middleLeft=null,this._fireEdit())},_onContextMenu:function(t){var e=t.target;this._poly;this._poly._map.fire(L.Draw.Event.MARKERCONTEXT,{marker:e,layers:this._markerGroup,poly:this._poly}),L.DomEvent.stopPropagation},_onTouchMove:function(t){var e=this._map.mouseEventToLayerPoint(t.originalEvent.touches[0]),i=this._map.layerPointToLatLng(e),o=t.target;L.extend(o._origLatLng,i),o._middleLeft&&o._middleLeft.setLatLng(this._getMiddleLatLng(o._prev,o)),o._middleRight&&o._middleRight.setLatLng(this._getMiddleLatLng(o,o._next)),this._poly.redraw(),this.updateMarkers()},_updateIndexes:function(t,e){this._markerGroup.eachLayer((function(i){i._index>t&&(i._index+=e)}))},_createMiddleMarker:function(t,e){var i,o,n,s=this._getMiddleLatLng(t,e),a=this._createMarker(s);a.setOpacity(.6),t._middleRight=e._middleLeft=a,o=function(){a.off("touchmove",o,this);var n=e._index;a._index=n,a.off("click",i,this).on("click",this._onMarkerClick,this),s.lat=a.getLatLng().lat,s.lng=a.getLatLng().lng,this._spliceLatLngs(n,0,s),this._markers.splice(n,0,a),a.setOpacity(1),this._updateIndexes(n,1),e._index++,this._updatePrevNext(t,a),this._updatePrevNext(a,e),this._poly.fire("editstart")},n=function(){a.off("dragstart",o,this),a.off("dragend",n,this),a.off("touchmove",o,this),this._createMiddleMarker(t,a),this._createMiddleMarker(a,e)},i=function(){o.call(this),n.call(this),this._fireEdit()},a.on("click",i,this).on("dragstart",o,this).on("dragend",n,this).on("touchmove",o,this),this._markerGroup.addLayer(a)},_updatePrevNext:function(t,e){t&&(t._next=e),e&&(e._prev=t)},_getMiddleLatLng:function(t,e){var i=this._poly._map,o=i.project(t.getLatLng()),n=i.project(e.getLatLng());return i.unproject(o._add(n)._divideBy(2))}}),L.Polyline.addInitHook((function(){this.editing||(L.Edit.Poly&&(this.editing=new L.Edit.Poly(this),this.options.editable&&this.editing.enable()),this.on("add",(function(){this.editing&&this.editing.enabled()&&this.editing.addHooks()})),this.on("remove",(function(){this.editing&&this.editing.enabled()&&this.editing.removeHooks()})))})),L.Edit=L.Edit||{},L.Edit.SimpleShape=L.Handler.extend({options:{moveIcon:new L.DivIcon({iconSize:new L.Point(8,8),className:"leaflet-div-icon leaflet-editing-icon leaflet-edit-move"}),resizeIcon:new L.DivIcon({iconSize:new L.Point(8,8),className:"leaflet-div-icon leaflet-editing-icon leaflet-edit-resize"}),touchMoveIcon:new L.DivIcon({iconSize:new L.Point(20,20),className:"leaflet-div-icon leaflet-editing-icon leaflet-edit-move leaflet-touch-icon"}),touchResizeIcon:new L.DivIcon({iconSize:new L.Point(20,20),className:"leaflet-div-icon leaflet-editing-icon leaflet-edit-resize leaflet-touch-icon"})},initialize:function(t,e){L.Browser.touch&&(this.options.moveIcon=this.options.touchMoveIcon,this.options.resizeIcon=this.options.touchResizeIcon),this._shape=t,L.Util.setOptions(this,e)},addHooks:function(){var t=this._shape;this._shape._map&&(this._map=this._shape._map,t.setStyle(t.options.editing),t._map&&(this._map=t._map,this._markerGroup||this._initMarkers(),this._map.addLayer(this._markerGroup)))},removeHooks:function(){var t=this._shape;if(t.setStyle(t.options.original),t._map){this._unbindMarker(this._moveMarker);for(var e=0,i=this._resizeMarkers.length;e<i;e++)this._unbindMarker(this._resizeMarkers[e]);this._resizeMarkers=null,this._map.removeLayer(this._markerGroup),delete this._markerGroup}this._map=null},updateMarkers:function(){this._markerGroup.clearLayers(),this._initMarkers()},_initMarkers:function(){this._markerGroup||(this._markerGroup=new L.LayerGroup),this._createMoveMarker(),this._createResizeMarker()},_createMoveMarker:function(){},_createResizeMarker:function(){},_createMarker:function(t,e){var i=new L.Marker.Touch(t,{draggable:!0,icon:e,zIndexOffset:10});return this._bindMarker(i),this._markerGroup.addLayer(i),i},_bindMarker:function(t){t.on("dragstart",this._onMarkerDragStart,this).on("drag",this._onMarkerDrag,this).on("dragend",this._onMarkerDragEnd,this).on("touchstart",this._onTouchStart,this).on("touchmove",this._onTouchMove,this).on("MSPointerMove",this._onTouchMove,this).on("touchend",this._onTouchEnd,this).on("MSPointerUp",this._onTouchEnd,this)},_unbindMarker:function(t){t.off("dragstart",this._onMarkerDragStart,this).off("drag",this._onMarkerDrag,this).off("dragend",this._onMarkerDragEnd,this).off("touchstart",this._onTouchStart,this).off("touchmove",this._onTouchMove,this).off("MSPointerMove",this._onTouchMove,this).off("touchend",this._onTouchEnd,this).off("MSPointerUp",this._onTouchEnd,this)},_onMarkerDragStart:function(t){t.target.setOpacity(0),this._shape.fire("editstart")},_fireEdit:function(){this._shape.edited=!0,this._shape.fire("edit")},_onMarkerDrag:function(t){var e=t.target,i=e.getLatLng();e===this._moveMarker?this._move(i):this._resize(i),this._shape.redraw(),this._shape.fire("editdrag")},_onMarkerDragEnd:function(t){t.target.setOpacity(1),this._fireEdit()},_onTouchStart:function(t){if(L.Edit.SimpleShape.prototype._onMarkerDragStart.call(this,t),"function"==typeof this._getCorners){var e=this._getCorners(),i=t.target,o=i._cornerIndex;i.setOpacity(0),this._oppositeCorner=e[(o+2)%4],this._toggleCornerMarkers(0,o)}this._shape.fire("editstart")},_onTouchMove:function(t){var e=this._map.mouseEventToLayerPoint(t.originalEvent.touches[0]),i=this._map.layerPointToLatLng(e);return t.target===this._moveMarker?this._move(i):this._resize(i),this._shape.redraw(),!1},_onTouchEnd:function(t){t.target.setOpacity(1),this.updateMarkers(),this._fireEdit()},_move:function(){},_resize:function(){}}),L.Edit=L.Edit||{},L.Edit.Rectangle=L.Edit.SimpleShape.extend({_createMoveMarker:function(){var t=this._shape.getBounds().getCenter();this._moveMarker=this._createMarker(t,this.options.moveIcon)},_createResizeMarker:function(){var t=this._getCorners();this._resizeMarkers=[];for(var e=0,i=t.length;e<i;e++)this._resizeMarkers.push(this._createMarker(t[e],this.options.resizeIcon)),this._resizeMarkers[e]._cornerIndex=e},_onMarkerDragStart:function(t){L.Edit.SimpleShape.prototype._onMarkerDragStart.call(this,t);var e=this._getCorners(),i=t.target._cornerIndex;this._oppositeCorner=e[(i+2)%4],this._toggleCornerMarkers(0,i)},_onMarkerDragEnd:function(t){var e,i=t.target;i===this._moveMarker&&(e=this._shape.getBounds().getCenter(),i.setLatLng(e)),this._toggleCornerMarkers(1),this._repositionCornerMarkers(),L.Edit.SimpleShape.prototype._onMarkerDragEnd.call(this,t)},_move:function(t){for(var e,i=this._shape._defaultShape?this._shape._defaultShape():this._shape.getLatLngs(),o=this._shape.getBounds().getCenter(),n=[],s=0,a=i.length;s<a;s++)e=[i[s].lat-o.lat,i[s].lng-o.lng],n.push([t.lat+e[0],t.lng+e[1]]);this._shape.setLatLngs(n),this._repositionCornerMarkers(),this._map.fire(L.Draw.Event.EDITMOVE,{layer:this._shape})},_resize:function(t){var e;this._shape.setBounds(L.latLngBounds(t,this._oppositeCorner)),e=this._shape.getBounds(),this._moveMarker.setLatLng(e.getCenter()),this._map.fire(L.Draw.Event.EDITRESIZE,{layer:this._shape})},_getCorners:function(){var t=this._shape.getBounds();return[t.getNorthWest(),t.getNorthEast(),t.getSouthEast(),t.getSouthWest()]},_toggleCornerMarkers:function(t){for(var e=0,i=this._resizeMarkers.length;e<i;e++)this._resizeMarkers[e].setOpacity(t)},_repositionCornerMarkers:function(){for(var t=this._getCorners(),e=0,i=this._resizeMarkers.length;e<i;e++)this._resizeMarkers[e].setLatLng(t[e])}}),L.Rectangle.addInitHook((function(){L.Edit.Rectangle&&(this.editing=new L.Edit.Rectangle(this),this.options.editable&&this.editing.enable())})),L.Edit=L.Edit||{},L.Edit.CircleMarker=L.Edit.SimpleShape.extend({_createMoveMarker:function(){var t=this._shape.getLatLng();this._moveMarker=this._createMarker(t,this.options.moveIcon)},_createResizeMarker:function(){this._resizeMarkers=[]},_move:function(t){if(this._resizeMarkers.length){var e=this._getResizeMarkerPoint(t);this._resizeMarkers[0].setLatLng(e)}this._shape.setLatLng(t),this._map.fire(L.Draw.Event.EDITMOVE,{layer:this._shape})}}),L.CircleMarker.addInitHook((function(){L.Edit.CircleMarker&&(this.editing=new L.Edit.CircleMarker(this),this.options.editable&&this.editing.enable()),this.on("add",(function(){this.editing&&this.editing.enabled()&&this.editing.addHooks()})),this.on("remove",(function(){this.editing&&this.editing.enabled()&&this.editing.removeHooks()}))})),L.Edit=L.Edit||{},L.Edit.Circle=L.Edit.CircleMarker.extend({_createResizeMarker:function(){var t=this._shape.getLatLng(),e=this._getResizeMarkerPoint(t);this._resizeMarkers=[],this._resizeMarkers.push(this._createMarker(e,this.options.resizeIcon))},_getResizeMarkerPoint:function(t){var e=this._shape._radius*Math.cos(Math.PI/4),i=this._map.project(t);return this._map.unproject([i.x+e,i.y-e])},_resize:function(t){var e=this._moveMarker.getLatLng();L.GeometryUtil.isVersion07x()?radius=e.distanceTo(t):radius=this._map.distance(e,t),this._shape.setRadius(radius),this._map.editTooltip&&this._map._editTooltip.updateContent({text:L.drawLocal.edit.handlers.edit.tooltip.subtext+"<br />"+L.drawLocal.edit.handlers.edit.tooltip.text,subtext:L.drawLocal.draw.handlers.circle.radius+": "+L.GeometryUtil.readableDistance(radius,!0,this.options.feet,this.options.nautic)}),this._shape.setRadius(radius),this._map.fire(L.Draw.Event.EDITRESIZE,{layer:this._shape})}}),L.Circle.addInitHook((function(){L.Edit.Circle&&(this.editing=new L.Edit.Circle(this),this.options.editable&&this.editing.enable())})),L.Map.mergeOptions({touchExtend:!0}),L.Map.TouchExtend=L.Handler.extend({initialize:function(t){this._map=t,this._container=t._container,this._pane=t._panes.overlayPane},addHooks:function(){L.DomEvent.on(this._container,"touchstart",this._onTouchStart,this),L.DomEvent.on(this._container,"touchend",this._onTouchEnd,this),L.DomEvent.on(this._container,"touchmove",this._onTouchMove,this),this._detectIE()?(L.DomEvent.on(this._container,"MSPointerDown",this._onTouchStart,this),L.DomEvent.on(this._container,"MSPointerUp",this._onTouchEnd,this),L.DomEvent.on(this._container,"MSPointerMove",this._onTouchMove,this),L.DomEvent.on(this._container,"MSPointerCancel",this._onTouchCancel,this)):(L.DomEvent.on(this._container,"touchcancel",this._onTouchCancel,this),L.DomEvent.on(this._container,"touchleave",this._onTouchLeave,this))},removeHooks:function(){L.DomEvent.off(this._container,"touchstart",this._onTouchStart,this),L.DomEvent.off(this._container,"touchend",this._onTouchEnd,this),L.DomEvent.off(this._container,"touchmove",this._onTouchMove,this),this._detectIE()?(L.DomEvent.off(this._container,"MSPointerDown",this._onTouchStart,this),L.DomEvent.off(this._container,"MSPointerUp",this._onTouchEnd,this),L.DomEvent.off(this._container,"MSPointerMove",this._onTouchMove,this),L.DomEvent.off(this._container,"MSPointerCancel",this._onTouchCancel,this)):(L.DomEvent.off(this._container,"touchcancel",this._onTouchCancel,this),L.DomEvent.off(this._container,"touchleave",this._onTouchLeave,this))},_touchEvent:function(t,e){var i={};if(void 0!==t.touches){if(!t.touches.length)return;i=t.touches[0]}else{if("touch"!==t.pointerType)return;if(i=t,!this._filterClick(t))return}var o=this._map.mouseEventToContainerPoint(i),n=this._map.mouseEventToLayerPoint(i),s=this._map.layerPointToLatLng(n);this._map.fire(e,{latlng:s,layerPoint:n,containerPoint:o,pageX:i.pageX,pageY:i.pageY,originalEvent:t})},_filterClick:function(t){var e=t.timeStamp||t.originalEvent.timeStamp,i=L.DomEvent._lastClick&&e-L.DomEvent._lastClick;return i&&i>100&&i<500||t.target._simulatedClick&&!t._simulated?(L.DomEvent.stop(t),!1):(L.DomEvent._lastClick=e,!0)},_onTouchStart:function(t){if(this._map._loaded){this._touchEvent(t,"touchstart")}},_onTouchEnd:function(t){if(this._map._loaded){this._touchEvent(t,"touchend")}},_onTouchCancel:function(t){if(this._map._loaded){var e="touchcancel";this._detectIE()&&(e="pointercancel"),this._touchEvent(t,e)}},_onTouchLeave:function(t){if(this._map._loaded){this._touchEvent(t,"touchleave")}},_onTouchMove:function(t){if(this._map._loaded){this._touchEvent(t,"touchmove")}},_detectIE:function(){var e=t.navigator.userAgent,i=e.indexOf("MSIE ");if(i>0)return parseInt(e.substring(i+5,e.indexOf(".",i)),10);if(e.indexOf("Trident/")>0){var o=e.indexOf("rv:");return parseInt(e.substring(o+3,e.indexOf(".",o)),10)}var n=e.indexOf("Edge/");return n>0&&parseInt(e.substring(n+5,e.indexOf(".",n)),10)}}),L.Map.addInitHook("addHandler","touchExtend",L.Map.TouchExtend),L.Marker.Touch=L.Marker.extend({_initInteraction:function(){return this.addInteractiveTarget?L.Marker.prototype._initInteraction.apply(this):this._initInteractionLegacy()},_initInteractionLegacy:function(){if(this.options.clickable){var t=this._icon,e=["dblclick","mousedown","mouseover","mouseout","contextmenu","touchstart","touchend","touchmove"];this._detectIE?e.concat(["MSPointerDown","MSPointerUp","MSPointerMove","MSPointerCancel"]):e.concat(["touchcancel"]),L.DomUtil.addClass(t,"leaflet-clickable"),L.DomEvent.on(t,"click",this._onMouseClick,this),L.DomEvent.on(t,"keypress",this._onKeyPress,this);for(var i=0;i<e.length;i++)L.DomEvent.on(t,e[i],this._fireMouseEvent,this);L.Handler.MarkerDrag&&(this.dragging=new L.Handler.MarkerDrag(this),this.options.draggable&&this.dragging.enable())}},_detectIE:function(){var e=t.navigator.userAgent,i=e.indexOf("MSIE ");if(i>0)return parseInt(e.substring(i+5,e.indexOf(".",i)),10);if(e.indexOf("Trident/")>0){var o=e.indexOf("rv:");return parseInt(e.substring(o+3,e.indexOf(".",o)),10)}var n=e.indexOf("Edge/");return n>0&&parseInt(e.substring(n+5,e.indexOf(".",n)),10)}}),L.LatLngUtil={cloneLatLngs:function(t){for(var e=[],i=0,o=t.length;i<o;i++)Array.isArray(t[i])?e.push(L.LatLngUtil.cloneLatLngs(t[i])):e.push(this.cloneLatLng(t[i]));return e},cloneLatLng:function(t){return L.latLng(t.lat,t.lng)}},o={km:2,ha:2,m:0,mi:2,ac:2,yd:0,ft:0,nm:2},L.GeometryUtil=L.extend(L.GeometryUtil||{},{geodesicArea:function(t){var e,i,o=t.length,n=0,s=Math.PI/180;if(o>2){for(var a=0;a<o;a++)e=t[a],n+=((i=t[(a+1)%o]).lng-e.lng)*s*(2+Math.sin(e.lat*s)+Math.sin(i.lat*s));n=6378137*n*6378137/2}return Math.abs(n)},formattedNumber:function(t,e){var i=parseFloat(t).toFixed(e),o=L.drawLocal.format&&L.drawLocal.format.numeric,n=o&&o.delimiters,s=n&&n.thousands,a=n&&n.decimal;if(s||a){var r=i.split(".");i=s?r[0].replace(/(\d)(?=(\d{3})+(?!\d))/g,"$1"+s):r[0],a=a||".",r.length>1&&(i=i+a+r[1])}return i},readableArea:function(t,e,i){var n,s;return i=L.Util.extend({},o,i),e?(s=["ha","m"],type=typeof e,"string"===type?s=[e]:"boolean"!==type&&(s=e),n=t>=1e6&&-1!==s.indexOf("km")?L.GeometryUtil.formattedNumber(1e-6*t,i.km)+" km²":t>=1e4&&-1!==s.indexOf("ha")?L.GeometryUtil.formattedNumber(1e-4*t,i.ha)+" ha":L.GeometryUtil.formattedNumber(t,i.m)+" m²"):n=(t/=.836127)>=3097600?L.GeometryUtil.formattedNumber(t/3097600,i.mi)+" mi²":t>=4840?L.GeometryUtil.formattedNumber(t/4840,i.ac)+" acres":L.GeometryUtil.formattedNumber(t,i.yd)+" yd²",n},readableDistance:function(t,e,i,n,s){var a;switch(s=L.Util.extend({},o,s),e?"string"==typeof e?e:"metric":i?"feet":n?"nauticalMile":"yards"){case"metric":a=t>1e3?L.GeometryUtil.formattedNumber(t/1e3,s.km)+" km":L.GeometryUtil.formattedNumber(t,s.m)+" m";break;case"feet":t*=3.28083,a=L.GeometryUtil.formattedNumber(t,s.ft)+" ft";break;case"nauticalMile":t*=.53996,a=L.GeometryUtil.formattedNumber(t/1e3,s.nm)+" nm";break;case"yards":default:a=(t*=1.09361)>1760?L.GeometryUtil.formattedNumber(t/1760,s.mi)+" miles":L.GeometryUtil.formattedNumber(t,s.yd)+" yd"}return a},isVersion07x:function(){var t=L.version.split(".");return 0===parseInt(t[0],10)&&7===parseInt(t[1],10)}}),L.Util.extend(L.LineUtil,{segmentsIntersect:function(t,e,i,o){return this._checkCounterclockwise(t,i,o)!==this._checkCounterclockwise(e,i,o)&&this._checkCounterclockwise(t,e,i)!==this._checkCounterclockwise(t,e,o)},_checkCounterclockwise:function(t,e,i){return(i.y-t.y)*(e.x-t.x)>(e.y-t.y)*(i.x-t.x)}}),L.Polyline.include({intersects:function(){var t,e,i,o=this._getProjectedPoints(),n=o?o.length:0;if(this._tooFewPointsForIntersection())return!1;for(t=n-1;t>=3;t--)if(e=o[t-1],i=o[t],this._lineSegmentsIntersectsRange(e,i,t-2))return!0;return!1},newLatLngIntersects:function(t,e){return!!this._map&&this.newPointIntersects(this._map.latLngToLayerPoint(t),e)},newPointIntersects:function(t,e){var i=this._getProjectedPoints(),o=i?i.length:0,n=i?i[o-1]:null,s=o-2;return!this._tooFewPointsForIntersection(1)&&this._lineSegmentsIntersectsRange(n,t,s,e?1:0)},_tooFewPointsForIntersection:function(t){var e=this._getProjectedPoints(),i=e?e.length:0;return!e||(i+=t||0)<=3},_lineSegmentsIntersectsRange:function(t,e,i,o){var n,s,a=this._getProjectedPoints();o=o||0;for(var r=i;r>o;r--)if(n=a[r-1],s=a[r],L.LineUtil.segmentsIntersect(t,e,n,s))return!0;return!1},_getProjectedPoints:function(){if(!this._defaultShape)return this._originalPoints;for(var t=[],e=this._defaultShape(),i=0;i<e.length;i++)t.push(this._map.latLngToLayerPoint(e[i]));return t}}),L.Polygon.include({intersects:function(){var t,e,i,o,n=this._getProjectedPoints();return!this._tooFewPointsForIntersection()&&(!!L.Polyline.prototype.intersects.call(this)||(t=n.length,e=n[0],i=n[t-1],o=t-2,this._lineSegmentsIntersectsRange(i,e,o,1)))}}),L.Control.Draw=L.Control.extend({options:{position:"topleft",draw:{},edit:!1},initialize:function(t){if(L.version<"0.7")throw new Error("Leaflet.draw 0.2.3+ requires Leaflet 0.7.0+. Download latest from https://github.com/Leaflet/Leaflet/");var e;L.Control.prototype.initialize.call(this,t),this._toolbars={},L.DrawToolbar&&this.options.draw&&(e=new L.DrawToolbar(this.options.draw),this._toolbars[L.DrawToolbar.TYPE]=e,this._toolbars[L.DrawToolbar.TYPE].on("enable",this._toolbarEnabled,this)),L.EditToolbar&&this.options.edit&&(e=new L.EditToolbar(this.options.edit),this._toolbars[L.EditToolbar.TYPE]=e,this._toolbars[L.EditToolbar.TYPE].on("enable",this._toolbarEnabled,this)),L.toolbar=this},onAdd:function(t){var e,i=L.DomUtil.create("div","leaflet-draw"),o=!1;for(var n in this._toolbars)this._toolbars.hasOwnProperty(n)&&(e=this._toolbars[n].addToolbar(t))&&(o||(L.DomUtil.hasClass(e,"leaflet-draw-toolbar-top")||L.DomUtil.addClass(e.childNodes[0],"leaflet-draw-toolbar-top"),o=!0),i.appendChild(e));return i},onRemove:function(){for(var t in this._toolbars)this._toolbars.hasOwnProperty(t)&&this._toolbars[t].removeToolbar()},setDrawingOptions:function(t){for(var e in this._toolbars)this._toolbars[e]instanceof L.DrawToolbar&&this._toolbars[e].setOptions(t)},_toolbarEnabled:function(t){var e=t.target;for(var i in this._toolbars)this._toolbars[i]!==e&&this._toolbars[i].disable()}}),L.Map.mergeOptions({drawControlTooltips:!0,drawControl:!1}),L.Map.addInitHook((function(){this.options.drawControl&&(this.drawControl=new L.Control.Draw,this.addControl(this.drawControl))})),L.Toolbar=L.Class.extend({initialize:function(t){L.setOptions(this,t),this._modes={},this._actionButtons=[],this._activeMode=null;var e=L.version.split(".");1===parseInt(e[0],10)&&parseInt(e[1],10)>=2?L.Toolbar.include(L.Evented.prototype):L.Toolbar.include(L.Mixin.Events)},enabled:function(){return null!==this._activeMode},disable:function(){this.enabled()&&this._activeMode.handler.disable()},addToolbar:function(t){var e,i=L.DomUtil.create("div","leaflet-draw-section"),o=0,n=this._toolbarClass||"",s=this.getModeHandlers(t);for(this._toolbarContainer=L.DomUtil.create("div","leaflet-draw-toolbar leaflet-bar"),this._map=t,e=0;e<s.length;e++)s[e].enabled&&this._initModeHandler(s[e].handler,this._toolbarContainer,o++,n,s[e].title);if(o)return this._lastButtonIndex=--o,this._actionsContainer=L.DomUtil.create("ul","leaflet-draw-actions"),i.appendChild(this._toolbarContainer),i.appendChild(this._actionsContainer),i},removeToolbar:function(){for(var t in this._modes)this._modes.hasOwnProperty(t)&&(this._disposeButton(this._modes[t].button,this._modes[t].handler.enable,this._modes[t].handler),this._modes[t].handler.disable(),this._modes[t].handler.off("enabled",this._handlerActivated,this).off("disabled",this._handlerDeactivated,this));this._modes={};for(var e=0,i=this._actionButtons.length;e<i;e++)this._disposeButton(this._actionButtons[e].button,this._actionButtons[e].callback,this);this._actionButtons=[],this._actionsContainer=null},_initModeHandler:function(t,e,i,o,n){var s=t.type;this._modes[s]={},this._modes[s].handler=t,this._modes[s].button=this._createButton({type:s,title:n,className:o+"-"+s,container:e,callback:this._modes[s].handler.enable,context:this._modes[s].handler}),this._modes[s].buttonIndex=i,this._modes[s].handler.on("enabled",this._handlerActivated,this).on("disabled",this._handlerDeactivated,this)},_detectIOS:function(){return/iPad|iPhone|iPod/.test(navigator.userAgent)&&!t.MSStream},_createButton:function(t){var e=L.DomUtil.create("a",t.className||"",t.container),i=L.DomUtil.create("span","sr-only",t.container);e.href="#",e.appendChild(i),t.title&&(e.title=t.title,i.innerHTML=t.title),t.text&&(e.innerHTML=t.text,i.innerHTML=t.text);var o=this._detectIOS()?"touchstart":"click";return L.DomEvent.on(e,"click",L.DomEvent.stopPropagation).on(e,"mousedown",L.DomEvent.stopPropagation).on(e,"dblclick",L.DomEvent.stopPropagation).on(e,"touchstart",L.DomEvent.stopPropagation).on(e,"click",L.DomEvent.preventDefault).on(e,o,t.callback,t.context),e},_disposeButton:function(t,e){var i=this._detectIOS()?"touchstart":"click";L.DomEvent.off(t,"click",L.DomEvent.stopPropagation).off(t,"mousedown",L.DomEvent.stopPropagation).off(t,"dblclick",L.DomEvent.stopPropagation).off(t,"touchstart",L.DomEvent.stopPropagation).off(t,"click",L.DomEvent.preventDefault).off(t,i,e)},_handlerActivated:function(t){this.disable(),this._activeMode=this._modes[t.handler],L.DomUtil.addClass(this._activeMode.button,"leaflet-draw-toolbar-button-enabled"),this._showActionsToolbar(),this.fire("enable")},_handlerDeactivated:function(){this._hideActionsToolbar(),L.DomUtil.removeClass(this._activeMode.button,"leaflet-draw-toolbar-button-enabled"),this._activeMode=null,this.fire("disable")},_createActions:function(t){var e,i,o,n,s=this._actionsContainer,a=this.getActions(t),r=a.length;for(i=0,o=this._actionButtons.length;i<o;i++)this._disposeButton(this._actionButtons[i].button,this._actionButtons[i].callback);for(this._actionButtons=[];s.firstChild;)s.removeChild(s.firstChild);for(var l=0;l<r;l++)"enabled"in a[l]&&!a[l].enabled||(e=L.DomUtil.create("li","",s),n=this._createButton({title:a[l].title,text:a[l].text,container:e,callback:a[l].callback,context:a[l].context}),this._actionButtons.push({button:n,callback:a[l].callback}))},_showActionsToolbar:function(){var t=this._activeMode.buttonIndex,e=this._lastButtonIndex,i=this._activeMode.button.offsetTop-1;this._createActions(this._activeMode.handler),this._actionsContainer.style.top=i+"px",0===t&&(L.DomUtil.addClass(this._toolbarContainer,"leaflet-draw-toolbar-notop"),L.DomUtil.addClass(this._actionsContainer,"leaflet-draw-actions-top")),t===e&&(L.DomUtil.addClass(this._toolbarContainer,"leaflet-draw-toolbar-nobottom"),L.DomUtil.addClass(this._actionsContainer,"leaflet-draw-actions-bottom")),this._actionsContainer.style.display="block",this._map.fire(L.Draw.Event.TOOLBAROPENED)},_hideActionsToolbar:function(){this._actionsContainer.style.display="none",L.DomUtil.removeClass(this._toolbarContainer,"leaflet-draw-toolbar-notop"),L.DomUtil.removeClass(this._toolbarContainer,"leaflet-draw-toolbar-nobottom"),L.DomUtil.removeClass(this._actionsContainer,"leaflet-draw-actions-top"),L.DomUtil.removeClass(this._actionsContainer,"leaflet-draw-actions-bottom"),this._map.fire(L.Draw.Event.TOOLBARCLOSED)}}),L.Draw=L.Draw||{},L.Draw.Tooltip=L.Class.extend({initialize:function(t){this._map=t,this._popupPane=t._panes.popupPane,this._visible=!1,this._container=t.options.drawControlTooltips?L.DomUtil.create("div","leaflet-draw-tooltip",this._popupPane):null,this._singleLineLabel=!1,this._map.on("mouseout",this._onMouseOut,this)},dispose:function(){this._map.off("mouseout",this._onMouseOut,this),this._container&&(this._popupPane.removeChild(this._container),this._container=null)},updateContent:function(t){return this._container?(t.subtext=t.subtext||"",0!==t.subtext.length||this._singleLineLabel?t.subtext.length>0&&this._singleLineLabel&&(L.DomUtil.removeClass(this._container,"leaflet-draw-tooltip-single"),this._singleLineLabel=!1):(L.DomUtil.addClass(this._container,"leaflet-draw-tooltip-single"),this._singleLineLabel=!0),this._container.innerHTML=(t.subtext.length>0?'<span class="leaflet-draw-tooltip-subtext">'+t.subtext+"</span><br />":"")+"<span>"+t.text+"</span>",t.text||t.subtext?(this._visible=!0,this._container.style.visibility="inherit"):(this._visible=!1,this._container.style.visibility="hidden"),this):this},updatePosition:function(t){var e=this._map.latLngToLayerPoint(t),i=this._container;return this._container&&(this._visible&&(i.style.visibility="inherit"),L.DomUtil.setPosition(i,e)),this},showAsError:function(){return this._container&&L.DomUtil.addClass(this._container,"leaflet-error-draw-tooltip"),this},removeError:function(){return this._container&&L.DomUtil.removeClass(this._container,"leaflet-error-draw-tooltip"),this},_onMouseOut:function(){this._container&&(this._container.style.visibility="hidden")}}),L.DrawToolbar=L.Toolbar.extend({statics:{TYPE:"draw"},options:{polyline:{},polygon:{},rectangle:{},circle:{},marker:{},circlemarker:{}},initialize:function(t){for(var e in this.options)this.options.hasOwnProperty(e)&&t[e]&&(t[e]=L.extend({},this.options[e],t[e]));this._toolbarClass="leaflet-draw-draw",L.Toolbar.prototype.initialize.call(this,t)},getModeHandlers:function(t){return[{enabled:this.options.polyline,handler:new L.Draw.Polyline(t,this.options.polyline),title:L.drawLocal.draw.toolbar.buttons.polyline},{enabled:this.options.polygon,handler:new L.Draw.Polygon(t,this.options.polygon),title:L.drawLocal.draw.toolbar.buttons.polygon},{enabled:this.options.rectangle,handler:new L.Draw.Rectangle(t,this.options.rectangle),title:L.drawLocal.draw.toolbar.buttons.rectangle},{enabled:this.options.circle,handler:new L.Draw.Circle(t,this.options.circle),title:L.drawLocal.draw.toolbar.buttons.circle},{enabled:this.options.marker,handler:new L.Draw.Marker(t,this.options.marker),title:L.drawLocal.draw.toolbar.buttons.marker},{enabled:this.options.circlemarker,handler:new L.Draw.CircleMarker(t,this.options.circlemarker),title:L.drawLocal.draw.toolbar.buttons.circlemarker}]},getActions:function(t){return[{enabled:t.completeShape,title:L.drawLocal.draw.toolbar.finish.title,text:L.drawLocal.draw.toolbar.finish.text,callback:t.completeShape,context:t},{enabled:t.deleteLastVertex,title:L.drawLocal.draw.toolbar.undo.title,text:L.drawLocal.draw.toolbar.undo.text,callback:t.deleteLastVertex,context:t},{title:L.drawLocal.draw.toolbar.actions.title,text:L.drawLocal.draw.toolbar.actions.text,callback:this.disable,context:this}]},setOptions:function(t){for(var e in L.setOptions(this,t),this._modes)this._modes.hasOwnProperty(e)&&t.hasOwnProperty(e)&&this._modes[e].handler.setOptions(t[e])}}),L.EditToolbar=L.Toolbar.extend({statics:{TYPE:"edit"},options:{edit:{selectedPathOptions:{dashArray:"10, 10",fill:!0,fillColor:"#fe57a1",fillOpacity:.1,maintainColor:!1}},remove:{},poly:null,featureGroup:null},initialize:function(t){t.edit&&(void 0===t.edit.selectedPathOptions&&(t.edit.selectedPathOptions=this.options.edit.selectedPathOptions),t.edit.selectedPathOptions=L.extend({},this.options.edit.selectedPathOptions,t.edit.selectedPathOptions)),t.remove&&(t.remove=L.extend({},this.options.remove,t.remove)),t.poly&&(t.poly=L.extend({},this.options.poly,t.poly)),this._toolbarClass="leaflet-draw-edit",L.Toolbar.prototype.initialize.call(this,t),this._selectedFeatureCount=0},getModeHandlers:function(t){var e=this.options.featureGroup;return[{enabled:this.options.edit,handler:new L.EditToolbar.Edit(t,{featureGroup:e,selectedPathOptions:this.options.edit.selectedPathOptions,poly:this.options.poly}),title:L.drawLocal.edit.toolbar.buttons.edit},{enabled:this.options.remove,handler:new L.EditToolbar.Delete(t,{featureGroup:e}),title:L.drawLocal.edit.toolbar.buttons.remove}]},getActions:function(t){var e=[{title:L.drawLocal.edit.toolbar.actions.save.title,text:L.drawLocal.edit.toolbar.actions.save.text,callback:this._save,context:this},{title:L.drawLocal.edit.toolbar.actions.cancel.title,text:L.drawLocal.edit.toolbar.actions.cancel.text,callback:this.disable,context:this}];return t.removeAllLayers&&e.push({title:L.drawLocal.edit.toolbar.actions.clearAll.title,text:L.drawLocal.edit.toolbar.actions.clearAll.text,callback:this._clearAllLayers,context:this}),e},addToolbar:function(t){var e=L.Toolbar.prototype.addToolbar.call(this,t);return this._checkDisabled(),this.options.featureGroup.on("layeradd layerremove",this._checkDisabled,this),e},removeToolbar:function(){this.options.featureGroup.off("layeradd layerremove",this._checkDisabled,this),L.Toolbar.prototype.removeToolbar.call(this)},disable:function(){this.enabled()&&(this._activeMode.handler.revertLayers(),L.Toolbar.prototype.disable.call(this))},_save:function(){this._activeMode.handler.save(),this._activeMode&&this._activeMode.handler.disable()},_clearAllLayers:function(){this._activeMode.handler.removeAllLayers(),this._activeMode&&this._activeMode.handler.disable()},_checkDisabled:function(){var t,e=0!==this.options.featureGroup.getLayers().length;this.options.edit&&(t=this._modes[L.EditToolbar.Edit.TYPE].button,e?L.DomUtil.removeClass(t,"leaflet-disabled"):L.DomUtil.addClass(t,"leaflet-disabled"),t.setAttribute("title",e?L.drawLocal.edit.toolbar.buttons.edit:L.drawLocal.edit.toolbar.buttons.editDisabled)),this.options.remove&&(t=this._modes[L.EditToolbar.Delete.TYPE].button,e?L.DomUtil.removeClass(t,"leaflet-disabled"):L.DomUtil.addClass(t,"leaflet-disabled"),t.setAttribute("title",e?L.drawLocal.edit.toolbar.buttons.remove:L.drawLocal.edit.toolbar.buttons.removeDisabled))}}),L.EditToolbar.Edit=L.Handler.extend({statics:{TYPE:"edit"},initialize:function(t,e){if(L.Handler.prototype.initialize.call(this,t),L.setOptions(this,e),this._featureGroup=e.featureGroup,!(this._featureGroup instanceof L.FeatureGroup))throw new Error("options.featureGroup must be a L.FeatureGroup");this._uneditedLayerProps={},this.type=L.EditToolbar.Edit.TYPE;var i=L.version.split(".");1===parseInt(i[0],10)&&parseInt(i[1],10)>=2?L.EditToolbar.Edit.include(L.Evented.prototype):L.EditToolbar.Edit.include(L.Mixin.Events)},enable:function(){!this._enabled&&this._hasAvailableLayers()&&(this.fire("enabled",{handler:this.type}),this._map.fire(L.Draw.Event.EDITSTART,{handler:this.type}),L.Handler.prototype.enable.call(this),this._featureGroup.on("layeradd",this._enableLayerEdit,this).on("layerremove",this._disableLayerEdit,this))},disable:function(){this._enabled&&(this._featureGroup.off("layeradd",this._enableLayerEdit,this).off("layerremove",this._disableLayerEdit,this),L.Handler.prototype.disable.call(this),this._map.fire(L.Draw.Event.EDITSTOP,{handler:this.type}),this.fire("disabled",{handler:this.type}))},addHooks:function(){var t=this._map;t&&(t.getContainer().focus(),this._featureGroup.eachLayer(this._enableLayerEdit,this),this._tooltip=new L.Draw.Tooltip(this._map),this._tooltip.updateContent({text:L.drawLocal.edit.handlers.edit.tooltip.text,subtext:L.drawLocal.edit.handlers.edit.tooltip.subtext}),t._editTooltip=this._tooltip,this._updateTooltip(),this._map.on("mousemove",this._onMouseMove,this).on("touchmove",this._onMouseMove,this).on("MSPointerMove",this._onMouseMove,this).on(L.Draw.Event.EDITVERTEX,this._updateTooltip,this))},removeHooks:function(){this._map&&(this._featureGroup.eachLayer(this._disableLayerEdit,this),this._uneditedLayerProps={},this._tooltip.dispose(),this._tooltip=null,this._map.off("mousemove",this._onMouseMove,this).off("touchmove",this._onMouseMove,this).off("MSPointerMove",this._onMouseMove,this).off(L.Draw.Event.EDITVERTEX,this._updateTooltip,this))},revertLayers:function(){this._featureGroup.eachLayer((function(t){this._revertLayer(t)}),this)},save:function(){var t=new L.LayerGroup;this._featureGroup.eachLayer((function(e){e.edited&&(t.addLayer(e),e.edited=!1)})),this._map.fire(L.Draw.Event.EDITED,{layers:t})},_backupLayer:function(t){var e=L.Util.stamp(t);this._uneditedLayerProps[e]||(t instanceof L.Polyline||t instanceof L.Polygon||t instanceof L.Rectangle?this._uneditedLayerProps[e]={latlngs:L.LatLngUtil.cloneLatLngs(t.getLatLngs())}:t instanceof L.Circle?this._uneditedLayerProps[e]={latlng:L.LatLngUtil.cloneLatLng(t.getLatLng()),radius:t.getRadius()}:(t instanceof L.Marker||t instanceof L.CircleMarker)&&(this._uneditedLayerProps[e]={latlng:L.LatLngUtil.cloneLatLng(t.getLatLng())}))},_getTooltipText:function(){return{text:L.drawLocal.edit.handlers.edit.tooltip.text,subtext:L.drawLocal.edit.handlers.edit.tooltip.subtext}},_updateTooltip:function(){this._tooltip.updateContent(this._getTooltipText())},_revertLayer:function(t){var e=L.Util.stamp(t);t.edited=!1,this._uneditedLayerProps.hasOwnProperty(e)&&(t instanceof L.Polyline||t instanceof L.Polygon||t instanceof L.Rectangle?t.setLatLngs(this._uneditedLayerProps[e].latlngs):t instanceof L.Circle?(t.setLatLng(this._uneditedLayerProps[e].latlng),t.setRadius(this._uneditedLayerProps[e].radius)):(t instanceof L.Marker||t instanceof L.CircleMarker)&&t.setLatLng(this._uneditedLayerProps[e].latlng),t.fire("revert-edited",{layer:t}))},_enableLayerEdit:function(t){var e,i,o=t.layer||t.target||t;this._backupLayer(o),this.options.poly&&(i=L.Util.extend({},this.options.poly),o.options.poly=i),this.options.selectedPathOptions&&((e=L.Util.extend({},this.options.selectedPathOptions)).maintainColor&&(e.color=o.options.color,e.fillColor=o.options.fillColor),o.options.original=L.extend({},o.options),o.options.editing=e),o instanceof L.Marker?(o.editing&&o.editing.enable(),o.dragging.enable(),o.on("dragend",this._onMarkerDragEnd).on("touchmove",this._onTouchMove,this).on("MSPointerMove",this._onTouchMove,this).on("touchend",this._onMarkerDragEnd,this).on("MSPointerUp",this._onMarkerDragEnd,this)):o.editing.enable()},_disableLayerEdit:function(t){var e=t.layer||t.target||t;e.edited=!1,e.editing&&e.editing.disable(),delete e.options.editing,delete e.options.original,this._selectedPathOptions&&(e instanceof L.Marker?this._toggleMarkerHighlight(e):(e.setStyle(e.options.previousOptions),delete e.options.previousOptions)),e instanceof L.Marker?(e.dragging.disable(),e.off("dragend",this._onMarkerDragEnd,this).off("touchmove",this._onTouchMove,this).off("MSPointerMove",this._onTouchMove,this).off("touchend",this._onMarkerDragEnd,this).off("MSPointerUp",this._onMarkerDragEnd,this)):e.editing.disable()},_onMouseMove:function(t){this._tooltip.updatePosition(t.latlng)},_onMarkerDragEnd:function(t){var e=t.target;e.edited=!0,this._map.fire(L.Draw.Event.EDITMOVE,{layer:e})},_onTouchMove:function(t){var e=t.originalEvent.changedTouches[0],i=this._map.mouseEventToLayerPoint(e),o=this._map.layerPointToLatLng(i);t.target.setLatLng(o)},_hasAvailableLayers:function(){return 0!==this._featureGroup.getLayers().length}}),L.EditToolbar.Delete=L.Handler.extend({statics:{TYPE:"remove"},initialize:function(t,e){if(L.Handler.prototype.initialize.call(this,t),L.Util.setOptions(this,e),this._deletableLayers=this.options.featureGroup,!(this._deletableLayers instanceof L.FeatureGroup))throw new Error("options.featureGroup must be a L.FeatureGroup");this.type=L.EditToolbar.Delete.TYPE;var i=L.version.split(".");1===parseInt(i[0],10)&&parseInt(i[1],10)>=2?L.EditToolbar.Delete.include(L.Evented.prototype):L.EditToolbar.Delete.include(L.Mixin.Events)},enable:function(){!this._enabled&&this._hasAvailableLayers()&&(this.fire("enabled",{handler:this.type}),this._map.fire(L.Draw.Event.DELETESTART,{handler:this.type}),L.Handler.prototype.enable.call(this),this._deletableLayers.on("layeradd",this._enableLayerDelete,this).on("layerremove",this._disableLayerDelete,this))},disable:function(){this._enabled&&(this._deletableLayers.off("layeradd",this._enableLayerDelete,this).off("layerremove",this._disableLayerDelete,this),L.Handler.prototype.disable.call(this),this._map.fire(L.Draw.Event.DELETESTOP,{handler:this.type}),this.fire("disabled",{handler:this.type}))},addHooks:function(){var t=this._map;t&&(t.getContainer().focus(),this._deletableLayers.eachLayer(this._enableLayerDelete,this),this._deletedLayers=new L.LayerGroup,this._tooltip=new L.Draw.Tooltip(this._map),this._tooltip.updateContent({text:L.drawLocal.edit.handlers.remove.tooltip.text}),this._map.on("mousemove",this._onMouseMove,this))},removeHooks:function(){this._map&&(this._deletableLayers.eachLayer(this._disableLayerDelete,this),this._deletedLayers=null,this._tooltip.dispose(),this._tooltip=null,this._map.off("mousemove",this._onMouseMove,this))},revertLayers:function(){this._deletedLayers.eachLayer((function(t){this._deletableLayers.addLayer(t),t.fire("revert-deleted",{layer:t})}),this)},save:function(){this._map.fire(L.Draw.Event.DELETED,{layers:this._deletedLayers})},removeAllLayers:function(){this._deletableLayers.eachLayer((function(t){this._removeLayer({layer:t})}),this),this.save()},_enableLayerDelete:function(t){(t.layer||t.target||t).on("click",this._removeLayer,this)},_disableLayerDelete:function(t){var e=t.layer||t.target||t;e.off("click",this._removeLayer,this),this._deletedLayers.removeLayer(e)},_removeLayer:function(t){var e=t.layer||t.target||t;this._deletableLayers.removeLayer(e),this._deletedLayers.addLayer(e),e.fire("deleted")},_onMouseMove:function(t){this._tooltip.updatePosition(t.latlng)},_hasAvailableLayers:function(){return 0!==this._deletableLayers.getLayers().length}})}(window,document)},function(t,e,i){"use strict";i.r(e);var o={_addUID:function(t){return this._uid?t+"-"+this._uid:t},_createMainContainerElement:function(){var t=document.createElement("div");return t.id=this._addUID("GPreverseGeocoding"),t.className="GPwidget",t},_createShowReverseGeocodingElement:function(){var t=document.createElement("input");return t.id=this._addUID("GPshowReverseGeocoding"),t.type="checkbox",t},_createShowReverseGeocodingPictoElement:function(){var t=this,e=document.createElement("label");e.id=this._addUID("GPshowReverseGeocodingPicto"),e.className="GPshowAdvancedToolPicto",e.htmlFor=this._addUID("GPshowReverseGeocoding"),e.title="Ouvrir la recherche inverse",e.addEventListener?e.addEventListener("click",(function(){t.onShowReverseGeocodingClick()})):e.attachEvent&&e.attachEvent("onclick",(function(){t.onShowReverseGeocodingClick()}));var i=document.createElement("span");return i.id=this._addUID("GPshowReverseGeocodingOpen"),i.className="GPshowAdvancedToolOpen",e.appendChild(i),e},_createReverseGeocodingWaitingElement:function(){var t=document.createElement("div");t.id=this._addUID("GPreverseGeocodingCalcWaitingContainer"),t.className="GPreverseGeocodingCalcWaitingContainerHidden";var e=document.createElement("p");return e.className="GPreverseGeocodingCalcWaiting",e.innerHTML="Recherche en cours...",t.appendChild(e),t},_createReverseGeocodingResultsPanelElement:function(){var t=document.createElement("div");return t.id=this._addUID("GPreverseGeocodingResultsPanel"),t.className="GPpanel GPreverseGeocodingComponentHidden",t},_createReverseGeocodingResultsListElement:function(){var t=document.createElement("div");return t.id=this._addUID("GPreverseGeocodingResultsList"),t},_createReverseGeocodingResultElement:function(t,e){var i=this,o=document.getElementById(this._addUID("GPreverseGeocodingResultsList")),n=document.createElement("div");n.id=this._addUID("ReverseGeocodedLocation_"+e),n.className="GPautoCompleteProposal",n.innerHTML=t,n.title=t,n.addEventListener?(n.addEventListener("mouseover",(function(t){i.onReverseGeocodingResultMouseOver(t)})),n.addEventListener("mouseout",(function(t){i.onReverseGeocodingResultMouseOut(t)})),n.addEventListener("click",(function(t){"function"==typeof i.onReverseGeocodingResultClick&&i.onReverseGeocodingResultClick(t)}))):n.attachEvent&&(n.attachEvent("onmouseover",(function(t){i.onReverseGeocodingResultMouseOver(t)})),n.attachEvent("onmouseout",(function(t){i.onReverseGeocodingResultMouseOut(t)})),n.attachEvent("onclick",(function(t){"function"==typeof i.onReverseGeocodingResultClick&&i.onReverseGeocodingResultClick(t)}))),o.appendChild(n)},_createReverseGeocodingPanelElement:function(){var t=document.createElement("div");return t.id=this._addUID("GPreverseGeocodingPanel"),t.className="GPpanel",t},_createReverseGeocodingPanelHeaderElement:function(){var t=document.createElement("div");return t.className="GPpanelHeader",t},_createReverseGeocodingPanelReturnPictoElement:function(){var t=this,e=document.createElement("div");return e.id=this._addUID("GPreverseGeocodingReturnPicto"),e.title="Nouvelle recherche",e.className="GPreverseGeocodingReturnPictoHidden",e.addEventListener?e.addEventListener("click",(function(e){document.getElementById(t._addUID("GPreverseGeocodingResultsPanel")).className="GProuteComponentHidden",document.getElementById(t._addUID("GPreverseGeocodingForm")).className="",document.getElementById(t._addUID("GPreverseGeocodingHeaderTitle")).innerHTML="Recherche inverse",document.getElementById(t._addUID("GPreverseGeocodingReturnPicto")).className="GPreverseGeocodingReturnPictoHidden",t.onGPreverseGeocodingReturnPictoClick(e)})):e.attachEvent&&e.attachEvent("onclick",(function(e){document.getElementById(t._addUID("GPreverseGeocodingResultsPanel")).className="GProuteComponentHidden",document.getElementById(t._addUID("GPreverseGeocodingForm")).className="",document.getElementById(t._addUID("GPreverseGeocodingHeaderTitle")).innerHTML="Recherche inverse",document.getElementById(t._addUID("GPreverseGeocodingReturnPicto")).className="GPreverseGeocodingReturnPictoHidden",t.onGPreverseGeocodingReturnPictoClick(e)})),e},_createReverseGeocodingPanelTitleElement:function(){var t=document.createElement("div");return t.className="GPpanelTitle",t.id=this._addUID("GPreverseGeocodingHeaderTitle"),t.innerHTML="Recherche inverse",t},_createReverseGeocodingPanelCloseElement:function(){var t=this,e=document.createElement("div");return e.id=this._addUID("GPreverseGeocodingPanelClose"),e.className="GPpanelClose",e.title="Fermer le panneau",e.addEventListener?e.addEventListener("click",(function(){document.getElementById(t._addUID("GPshowReverseGeocodingPicto")).click()}),!1):e.attachEvent&&e.attachEvent("onclick",(function(){document.getElementById(t._addUID("GPshowReverseGeocodingPicto")).click()})),e},_createReverseGeocodingPanelFormElement:function(){var t=this,e=document.createElement("form");return e.id=this._addUID("GPreverseGeocodingForm"),e.addEventListener?e.addEventListener("submit",(function(e){e.preventDefault(),t.onReverseGeocodingSubmit()})):e.attachEvent&&e.attachEvent("onsubmit",(function(e){e.preventDefault(),t.onReverseGeocodingSubmit()})),e},_createReverseGeocodingFormModeChoiceGeocodingTypeElement:function(t){var e=this,i=document.createElement("div");i.className="GPflexInput";var o=document.createElement("label");o.className="GPreverseGeocodingCodeLabel",o.innerHTML="Recherche par",o.title="Recherche par",i.appendChild(o);var n=document.createElement("select");n.className="GPreverseGeocodingCode",n.addEventListener?n.addEventListener("change",(function(t){e.onReverseGeocodingTypeChange(t)})):n.attachEvent&&n.attachEvent("onchange",(function(t){e.onReverseGeocodingTypeChange(t)})),t&&Array.isArray(t)||(t=["StreetAddress","PositionOfInterest","CadastralParcel"]);for(var s=0;s<t.length;s++)switch(t[s]){case"PositionOfInterest":var a=document.createElement("option");a.value="PositionOfInterest",a.text="Lieux/toponymes",n.appendChild(a);break;case"StreetAddress":var r=document.createElement("option");r.value="StreetAddress",r.text="Adresses",n.appendChild(r);break;case"CadastralParcel":var l=document.createElement("option");l.value="CadastralParcel",l.text="Parcelles cadastrales",n.appendChild(l);break;case"Administratif":var c=document.createElement("option");c.value="Administratif",c.text="Unités administratives",n.appendChild(c)}return i.appendChild(n),i},_createReverseGeocodingFormModeChoiceGeocodingDelimitationElement:function(t){var e=this,i=document.createElement("div");i.className="GPflexInput";var o=document.createElement("label");o.className="GPreverseGeocodingCodeLabel",o.innerHTML="Délimitation",o.title="Délimitation",i.appendChild(o);var n=document.createElement("select");n.className="GPreverseGeocodingCode",n.addEventListener?n.addEventListener("change",(function(t){e.onReverseGeocodingDelimitationChange(t)})):n.attachEvent&&n.attachEvent("onchange",(function(t){e.onReverseGeocodingDelimitationChange(t)})),t&&Array.isArray(t)||(t=["Point","Circle","Extent"]);for(var s=0;s<t.length;s++)switch(t[s].toLowerCase()){case"point":var a=document.createElement("option");a.value="point",a.text="Pointer un lieu",n.appendChild(a);break;case"circle":var r=document.createElement("option");r.value="circle",r.text="Dessiner un cercle",n.appendChild(r);break;case"extent":var l=document.createElement("option");l.value="extent",l.text="Dessiner une emprise",n.appendChild(l)}return i.appendChild(n),i},_createReverseGeocodingSubmitFormElement:function(){var t=document.createElement("input");return t.id=this._addUID("GPreverseGeocodingSubmit"),t.className="GPinputSubmit",t.type="submit",t.value="Rechercher",t}};e.default=o},function(t,e,i){"use strict";i.r(e);var o=i(40),n=i(2),s=i.n(n),a=i(34),r=i(140),l=i(36),c=i(142),u=i(162),h=a.default.getLogger("route(plus)"),d=s.a.Control.extend({includes:u.default,options:{position:"topleft",collapsed:!0,graphs:["Voiture","Pieton"],exclusions:{toll:!1,tunnel:!1,bridge:!1},disableReverse:!1,routeOptions:{},autocompleteOptions:{}},initialize:function(t){s.a.Util.setOptions(this,t),this._uid=l.default.generate(),this._initTransport(),this._initExclusions(),this._initComputation(),this._showRouteContainer=null,this._pictoRouteContainer=null,this._waitingContainer=null,this._formRouteContainer=null,this._resultsRouteContainer=null,this._isDesktop=this._detectSupport(),this._currentPoints=[],this._currentTransport=null,this._currentComputation=null,this._currentExclusions=[],this._geojsonRoute=null,this._geojsonSections=null,this._waiting=!1,this._timer=null,this._currentRouteInformations=null,this._resources={},this._noRightManagement=!1,this._checkRightsManagement()},onAdd:function(t){var e=this._container=this._initLayout(t);return s.a.DomEvent.disableClickPropagation(e).disableScrollPropagation(e),e},onRemove:function(){},_initTransport:function(){this._currentTransport="Voiture";var t=this.options.graphs;t&&0!==t.length||(this.options.graphs=["Voiture","Pieton"]),s.a.Util.isArray(t)&&t.length&&("Voiture"!==t[0]&&"Pieton"!==t[0]||(this._currentTransport=t[0]));var e=this.options.routeOptions;e.graph&&(this._currentTransport=e.graph)},_initComputation:function(){this._currentComputation="fastest";var t=this.options.routeOptions;t.routePreference&&(this._currentComputation=t.routePreference)},_initExclusions:function(){this._currentExclusions=[];var t=this.options.exclusions;if(t&&0!==Object.keys(t).length||(this.options.exclusions={toll:!1,tunnel:!1,bridge:!1}),t&&Object.keys(t).length)for(var e in t)t.hasOwnProperty(e)&&t.k&&this._currentExclusions.push(e);var i=this.options.routeOptions;s.a.Util.isArray(i.exclusions)&&(this._currentExclusions=i.exclusions)},_checkRightsManagement:function(){var t=null,e=[],i=null;i=this.options.routeOptions.apiKey,(e=(t=this.options.routeOptions.filterOptions)?t.type:[])&&0!==e.length||(e=["Voiture","Pieton"]);var o=r.default.check({key:i||this.options.apiKey,resources:e,services:["Itineraire"]});i=this.options.autocompleteOptions.apiKey,(e=(t=this.options.autocompleteOptions.filterOptions)?t.type:[])&&0!==e.length||(e=["StreetAddress","PositionOfInterest"]);var n=r.default.check({key:i||this.options.apiKey,resources:e,services:["AutoCompletion"]});o||n||(this._noRightManagement=!0),n&&(this._resources.AutoCompletion={},this._resources.AutoCompletion.resources=n.AutoCompletion,this._resources.AutoCompletion.key=n.key),o&&(this._resources.Itineraire={},this._resources.Itineraire.resources=o.Itineraire,this._resources.Itineraire.key=o.key)},_detectSupport:function(){var t=!0,e=window.navigator.userAgent.toLowerCase();return-1===e.indexOf("iphone")&&-1===e.indexOf("ipod")&&-1===e.indexOf("ipad")&&-1===e.indexOf("android")&&-1===e.indexOf("mobile")&&-1===e.indexOf("blackberry")&&-1===e.indexOf("tablet")&&-1===e.indexOf("phone")&&-1===e.indexOf("touch")||(t=!1),-1===e.indexOf("msie")&&-1===e.indexOf("trident")||(t=!0),t},_initLayout:function(t){var e=this._createMainContainerElement(),i=this._showRouteContainer=this._createShowRouteElement();e.appendChild(i),this.options.collapsed||(i.checked=!0);var o=this._pictoRouteContainer=this._createShowRoutePictoElement();e.appendChild(o);var n=this._createRoutePanelElement(),s=this._createRoutePanelHeaderElement();n.appendChild(s);for(var a=this._formRouteContainer=this._createRoutePanelFormElement(),r=this._createRoutePanelFormPointsElement(t),l=0;l<r.length;l++)a.appendChild(r[l]);var c=this._createRoutePanelFormModeChoiceElement();c.appendChild(this._createRoutePanelFormModeChoiceTransportElement(this.options.graphs)),c.appendChild(this._createRoutePanelFormModeChoiceComputeElement()),a.appendChild(c),a.appendChild(this._createShowRouteExclusionsElement()),a.appendChild(this._createShowRouteExclusionsPictoElement());var u=this._createRoutePanelFormExclusionsElement();u.appendChild(this._createRoutePanelFormExclusionOptionsElement(this.options.exclusions)),a.appendChild(u);var h=this._createRouteSubmitFormElement();a.appendChild(h),n.appendChild(a);var d=this._resultsRouteContainer=this._createRoutePanelResultsElement();n.appendChild(d);var p=this._waitingContainer=this._createRouteWaitingElement();return n.appendChild(p),e.appendChild(n),e},_createRoutePanelFormPointsElement:function(t){var e=[],i=1,o=new c.default({apiKey:this.options.apiKey||null,tag:{id:i,unique:this._uid,label:"Départ",color:"blue",display:!0},disableReverse:this.options.disableReverse,autocompleteOptions:this.options.autocompleteOptions||null});o.setMap(t);var n=this.options.routeOptions;for(n.startPoint&&(o._inputAutoCompleteContainer.value=n.startPoint.x+" , "+n.startPoint.y,o.setCoordinate({lng:n.startPoint.x,lat:n.startPoint.y})),e.push(o.getContainer()),this._currentPoints.push(o),i=2;i<7;i++){var s=new c.default({apiKey:this.options.apiKey||null,tag:{id:i,unique:this._uid,label:"Etape",color:"green",display:!1,removeOption:!0},disableReverse:this.options.disableReverse,autocompleteOptions:this.options.autocompleteOptions||null});s.setMap(t),e.push(s.getContainer()),this._currentPoints.push(s)}var a=new c.default({apiKey:this.options.apiKey||null,tag:{id:i,unique:this._uid,label:"Arrivée",color:"red",display:!0,addOption:!0,removeOption:!1},disableReverse:this.options.disableReverse,autocompleteOptions:this.options.autocompleteOptions||null});return a.setMap(t),n.endPoint&&(a._inputAutoCompleteContainer.value=n.endPoint.x+" , "+n.endPoint.y,a.setCoordinate({lng:n.endPoint.x,lat:n.endPoint.y})),e.push(a.getContainer()),this._currentPoints.push(a),e},onShowRoutePanelClick:function(t){h.log("onShowRoutePanelClick",t),this._geojsonSections||this._clear()},onRouteModeComputationChange:function(t){h.log("onRouteModeComputationChange",t);var e=t.target.selectedIndex,i=t.target.options[e].value;i&&(h.log(i),this._currentComputation=i)},onRouteModeComputationChangeAndRun:function(t){h.log("onRouteModeComputationChangeAndRun",t),this.onRouteModeComputationChange(t),this._clearRouteResultsDetails(),this._clearRouteResultsGeometry(),this._clearRouteResultsFeatureGeometry(),this.onRouteComputationSubmit({computation:this._currentComputation,transport:this._currentTransport,exclusions:this._currentExclusions})},onRouteModeTransportChange:function(t){h.log("onRouteModeTransportChange",t);var e=t.target.value;e&&(h.log(e),this._currentTransport=e)},onShowRouteExclusionsClick:function(t){h.log("onShowRouteExclusionsClick",t)},onRouteExclusionsChange:function(t){h.log("onRouteExclusionsChange",t);var e=t.target.value,i=t.target.checked;if(e){h.log(e,i);for(var o=!1,n=null,s=0;s<this._currentExclusions.length;s++)this._currentExclusions[s]===e&&(n=s,o=!0);!o&&i&&this._currentExclusions.push(e),o&&!i&&(this._currentExclusions[n]=null)}},onRouteComputationSubmit:function(t){h.log("onRouteComputationSubmit",t);var e=this._currentPoints,i=e[0].getCoordinate();e[0].dragging(!1),h.log("start",i);var o=e[e.length-1].getCoordinate();e[e.length-1].dragging(!1),h.log("end",o);for(var n=[],s=1;s<e.length-1;s++){var a=e[s].getCoordinate();e[s].dragging(!1),a&&(h.log("step",a),n.push(a))}if(!this._noRightManagement){this._currentTransport=t.transport,this._currentComputation=t.computation,this._currentExclusions=t.exclusions,this._displayWaitingContainer();var r=this;this._requestRouting({startPoint:i,endPoint:o,viaPoints:n,graph:this._currentTransport,routePreference:this._currentComputation,exclusions:this._currentExclusions,geometryInInstructions:!0,distanceUnit:"m",onSuccess:function(t){h.log(t),t&&r._fillRouteResultsDetails(t)},onFailure:function(t){r._hideWaitingContainer(),r._clearRouteResultsDetails(),h.log(t.message)}})}},onShowRouteResultsNewClick:function(t){h.log("onShowRouteResultsNewClick",t);for(var e=this._currentPoints,i=0;i<e.length;i++)e[i].dragging(!0);this._clearRouteResultsDetails(),this._clearRouteResultsGeometry(),this._clearRouteResultsFeatureGeometry()},onRouteResultsDetailsMouseOver:function(t){h.log("onRouteResultsDetailsMouseOver",t);var e=l.default.index(t.target.id);this._isDesktop&&this._geojsonSections&&this._geojsonSections.eachLayer((function(t){t.feature.id===parseInt(e,10)&&t.setStyle({weight:10,color:"#0F9DE8",opacity:.5})}))},onRouteResultsDetailsMouseOut:function(t){h.log("onRouteResultsDetailsMouseOut",t);var e=l.default.index(t.target.id);this._isDesktop&&this._geojsonSections&&this._geojsonSections.eachLayer((function(t){t.feature.id===parseInt(e,10)&&t.setStyle({color:"#ED7F10",weight:5,opacity:.75})}))},onRouteResultsDetailsClick:function(t){h.log("onRouteResultsDetailsClick",t);var e=l.default.index(t.target.id),i=this;if(!this._isDesktop&&this._geojsonSections){var o=t.target.title,n=t.target.innerHTML;this._geojsonSections.eachLayer((function(i){i.feature.id===parseInt(e,10)&&(t.target.innerHTML=o,i.setStyle({weight:10,color:"#0F9DE8",opacity:.5}))})),clearTimeout(1e3),setTimeout((function(){i._geojsonSections.eachLayer((function(i){i.feature.id===parseInt(e,10)&&(t.target.innerHTML=n,i.setStyle({color:"#ED7F10",weight:5,opacity:.75}))}))}),1e3)}},_requestRouting:function(t){if(t&&0!==Object.keys(t).length&&t.startPoint&&t.endPoint)if(h.log(t),this._noRightManagement)h.log("no rights for all service !?");else if(this._resources.Itineraire){var e=this._resources.Itineraire.resources;if(e&&0!==Object.keys(e).length){var i=this._resources.Itineraire.key,n={};s.a.Util.extend(n,this.options.routeOptions),s.a.Util.extend(n,t);for(var a=!1,r=0;r<e.length;r++)e[r]===n.graph&&(a=!0);a?(s.a.Util.extend(n,{apiKey:this.options.routeOptions.apiKey||this.options.apiKey||i}),s.a.Util.extend(n,{ssl:this.options.ssl}),h.log(n),o.default.Services.route(n)):h.log("no rights for this service !?")}}else h.log("no rights for this service !?")},_fillRouteResultsDetails:function(t){var e=t.totalDistance,i=t.totalTime,o=this._simplifiedInstructions(t.routeInstructions);o&&this._fillRouteResultsDetailsContainer(e,i,o);var n=t.routeGeometry;n&&this._fillRouteResultsDetailsGeometry(n);var a=0!==o[0].geometry.length;o&&a&&this._fillRouteResultsDetailsFeatureGeometry(o);var r=t.bbox;if(r){var l=this._map,c=s.a.latLngBounds([r.bottom,r.left],[r.top,r.right]);l.fitBounds(c,{padding:[1,1]})}this._currentRouteInformations=t,this._formRouteContainer.className="GProuteComponentHidden",this._hideWaitingContainer(),this._resultsRouteContainer.className=""},_fillRouteResultsDetailsContainer:function(t,e,i){this._resultsRouteValuesContainer=this._addRouteResultsValuesElement(t,e,this._convertSecondsToTime),this._resultsRouteDetailsContainer=this._addRouteResultsDetailsElement(i,this._convertSecondsToTime)},_fillRouteResultsDetailsGeometry:function(t){this._clearRouteResultsGeometry();var e=this._map;this._geojsonRoute=s.a.geoJson(t,{style:{color:"#ff7800",weight:5,opacity:.65}}).addTo(e)},_fillRouteResultsDetailsFeatureGeometry:function(t){this._clearRouteResultsFeatureGeometry();for(var e=this._map,i={type:"FeatureCollection",features:[]},o=0;o<t.length;o++){var n=t[o],a=o+1;i.features.push({id:a,type:"Feature",geometry:n.geometry,properties:{popupContent:"("+a+") distance : "+this._convertDistance(n.distance)+" / temps : "+this._convertSecondsToTime(n.duration)}})}var r=this;function l(t){var e=t.target;r._geojsonSections.resetStyle(e);var i=s.a.DomUtil.get("GProuteResultsDetailsInstruction_"+e.feature.id+"-"+r._uid);s.a.DomUtil.removeClass(i,"GProuteResultsDetailsHighlight")}function c(t){var e=t.target;h.log(e),e.setStyle({weight:10,color:"#0F9DE8",opacity:.5});var i=s.a.DomUtil.get("GProuteResultsDetailsInstruction_"+e.feature.id+"-"+r._uid);s.a.DomUtil.addClass(i,"GProuteResultsDetailsHighlight")}this._geojsonSections=s.a.geoJson(i,{style:{color:"#ED7F10",weight:5,opacity:.75},onEachFeature:function(t,e){e.on({mouseover:c,mouseout:l}),e.bindPopup(t.properties.popupContent)}}).addTo(e)},_clear:function(){this._currentTransport=null,this._currentExclusions=[],this._currentComputation=null,this._clearRouteResultsDetails(),this._clearRouteResultsGeometry(),this._clearRouteResultsFeatureGeometry();for(var t=0;t<this._currentPoints.length;t++)this._currentPoints[t].clear()},_clearRouteResultsDetails:function(){if(this._currentRouteInformations=null,this._resultsRouteDetailsContainer){var t=this._resultsRouteDetailsContainer;if(t.childElementCount)for(;t.firstChild;)t.removeChild(t.firstChild)}if(this._resultsRouteValuesContainer){var e=this._resultsRouteValuesContainer;if(e.childElementCount)for(;e.firstChild;)e.removeChild(e.firstChild)}},_clearRouteResultsGeometry:function(){var t=this._map;null!=this._geojsonRoute&&(t.removeLayer(this._geojsonRoute),this._geojsonRoute=null)},_clearRouteResultsFeatureGeometry:function(){var t=this._map;null!=this._geojsonSections&&(t.removeLayer(this._geojsonSections),this._geojsonSections=null)},_displayWaitingContainer:function(){this._waitingContainer.className="GProuteCalcWaitingContainerVisible",this._waiting=!0,this._timer&&(clearTimeout(this._timer),this._timer=null);var t=this;this._timer=setTimeout((function(){!0===t._waiting?t._hideWaitingContainer():t._timer&&clearTimeout(t._timer)}),16e3)},_hideWaitingContainer:function(){this._waiting&&(this._waitingContainer.className="GProuteCalcWaitingContainerHidden",this._waiting=!1,clearTimeout(this._timer),this._timer=null)},_simplifiedInstructions:function(t){var e=[],i=t[0];1===t.length&&e.push(i);for(var o=1;o<t.length;o++){var n=t[o];if(n.instruction===i.instruction){i.distance=(parseFloat(n.distance)+parseFloat(i.distance)).toString(),i.duration=(parseFloat(n.duration)+parseFloat(i.duration)).toString();for(var s=1;s<n.geometry.coordinates.length;s++)i.geometry.coordinates.push(n.geometry.coordinates[s]);o===t.length-1&&(e.push(i),i=null)}else e.push(i),i=n,o===t.length-1&&(e.push(n),i=null)}return h.log(e),e},_convertSecondsToTime:function(t){t=Math.round(t);var e=Math.floor(t/3600);e||(e="00");var i=t%3600,o=Math.floor(i/60);o||(o="00");var n=i%60,s=Math.ceil(n);return s||(s="00"),e+"h "+o+"m "+s+"s"},_convertDistance:function(t){var e=parseInt(t/1e3,10);return e?e+" km":parseInt(t,10)+" m"},compute:function(t,e){if(this._showRouteContainer.checked||this._pictoRouteContainer.click(),this._map){var i={computation:"fastest",transport:"Voiture",exclusions:[]};s.a.Util.extend(i,e);var o=this._currentPoints;o[0].setCoordinate(t[0]),s.a.DomUtil.get("GPlocationOrigin_1-"+this._uid).value=t[0].lng+" , "+t[0].lat;var n=t.length-1;o[6].setCoordinate(t[n]),s.a.DomUtil.get("GPlocationOrigin_7-"+this._uid).value=t[n].lng+" , "+t[n].lat;for(var a=1;a<t.length-1;a++){o[a].setCoordinate(t[a]),s.a.DomUtil.get("GPlocationOrigin_"+a+"-"+this._uid).value=t[a].lng+" , "+t[a].lat}"Voiture"===i.transport?s.a.DomUtil.get("GProuteTransportCar-"+this._uid).checked=!0:s.a.DomUtil.get("GProuteTransportPedestrian-"+this._uid).checked=!0,s.a.DomUtil.get("GProuteComputationSelect-"+this._uid).selectedIndex="fastest"===i.computation?0:1,this.onRouteComputationSubmit(i)}}});e.default=d},function(t,e,i){"use strict";i.r(e);var o=i(36),n=i(34).default.getLogger("RouteDOM"),s={_addUID:function(t){return this._uid?t+"-"+this._uid:t},_createMainContainerElement:function(){var t=document.createElement("div");return t.id=this._addUID("GProute"),t.className="GPwidget",t},_createShowRouteElement:function(){var t=document.createElement("input");return t.id=this._addUID("GPshowRoute"),t.type="checkbox",t},_createShowRoutePictoElement:function(){var t=this,e=document.createElement("label");e.id=this._addUID("GPshowRoutePicto"),e.className="GPshowAdvancedToolPicto",e.htmlFor=this._addUID("GPshowRoute"),e.title="Ouvrir le calcul d'itinéraire",e.addEventListener?e.addEventListener("click",(function(e){t.onShowRoutePanelClick(e)})):e.attachEvent&&e.attachEvent("onclick",(function(e){t.onShowRoutePanelClick(e)}));var i=document.createElement("span");return i.id=this._addUID("GPshowRouteOpen"),i.className="GPshowAdvancedToolOpen",e.appendChild(i),e},_createRoutePanelElement:function(){var t=document.createElement("div");return t.id=this._addUID("GProutePanel"),t.className="GPpanel",t},_createRoutePanelHeaderElement:function(){var t=this,e=document.createElement("div");e.className="GPpanelHeader";var i=document.createElement("div");i.className="GPpanelTitle",i.innerHTML="Calcul d'itinéraire",e.appendChild(i);var o=document.createElement("div");return o.id=this._addUID("GProutePanelClose"),o.className="GPpanelClose",o.title="Masquer le panneau",o.addEventListener?o.addEventListener("click",(function(){document.getElementById(t._addUID("GPshowRoutePicto")).click()}),!1):o.attachEvent&&o.attachEvent("onclick",(function(){document.getElementById(t._addUID("GPshowRoutePicto")).click()})),e.appendChild(o),e},_createRoutePanelFormElement:function(){var t=this,e=document.createElement("form");return e.id=this._addUID("GProuteForm"),e.setAttribute("onkeypress","return event.keyCode != 13;"),e.addEventListener("submit",(function(e){n.log(e),e.preventDefault();var i,s=document.getElementsByClassName(t._addUID("GPlocationPoint")),a=s[0].childNodes[0].id,r=s[s.length-1].childNodes[0].id,l=o.default.index(a),c=o.default.index(r);if(""===document.getElementById(t._addUID("GPlocationOrigin_"+l)).value&&""===document.getElementById(t._addUID("GPlocationOriginCoords_"+l)).value||""===document.getElementById(t._addUID("GPlocationOrigin_"+c)).value&&""===document.getElementById(t._addUID("GPlocationOriginCoords_"+c)).value)return!1;document.getElementById(t._addUID("GProuteResultsStages")).innerHTML="";for(var u=0;u<s.length;u++){var h=s[u].childNodes[0].id;if(i=o.default.index(h),"GPflexInput GPlocationStageFlexInput"===document.getElementById(t._addUID("GPlocationPoint_"+i)).className){var d=document.createElement("div");d.className="GProuteResultsStages";var p=document.createElement("div");p.className="GProuteResultStageLabel",p.innerHTML=document.getElementById(t._addUID("GPlocationOriginLabel_"+i)).innerHTML+" :",d.appendChild(p);var m=document.createElement("div");m.className="GProuteResultStageValue";var f=document.getElementById(t._addUID("GPlocationOriginCoords_"+i)),_=f.value,g="GPlocationOriginVisible"===f.className;m.innerHTML=null!==_&&""!==_&&g?_:document.getElementById(t._addUID("GPlocationOrigin_"+i)).value,d.appendChild(m),""!==m.innerHTML&&document.getElementById(t._addUID("GProuteResultsStages")).appendChild(d)}}var v=null;if(document.getElementById(t._addUID("GProuteComputationSelect"))){var y=document.getElementById(t._addUID("GProuteResultsComputationSelect"));y.selectedIndex=document.getElementById(t._addUID("GProuteComputationSelect")).selectedIndex,v=y.options[y.selectedIndex].value}var E=null;document.getElementById(t._addUID("GProuteTransportCar"))&&document.getElementById(t._addUID("GProuteTransportCar")).checked&&(E=document.getElementById(t._addUID("GProuteTransportCar")).value),document.getElementById(t._addUID("GProuteTransportPedestrian"))&&document.getElementById(t._addUID("GProuteTransportPedestrian")).checked&&(E=document.getElementById(t._addUID("GProuteTransportPedestrian")).value);for(var P=[],w=document.getElementsByClassName("GProuteExclusionsOption"),C=0;C<w.length;C++){i=w[C].htmlFor;var M=document.getElementById(i);M.checked||P.push(M.value)}return t.onRouteComputationSubmit({computation:v,transport:E,exclusions:P}),!1})),e},_createRoutePanelResultsElement:function(){var t=document.createElement("div");t.id=this._addUID("GProuteResultsPanel"),t.className="GProuteComponentHidden",t.appendChild(this._createRouteResultsStagesElement()),t.appendChild(this._createRouteResultsElement());var e=document.createElement("div");e.className="GPfakeBorder GPfakeBorderLeft",t.appendChild(e),t.appendChild(this._createRouteShowResultsDetailsElement());var i=document.createElement("label");i.htmlFor=this._addUID("GProuteResultsShowDetails"),i.innerHTML="Afficher le détail",t.appendChild(i);var o=document.createElement("label");o.htmlFor=this._addUID("GProuteResultsShowDetails"),o.innerHTML="Masquer le détail",t.appendChild(o);var n=document.createElement("div");return n.className="GPfakeBorder",t.appendChild(n),t.appendChild(this._createRouteResultsDetailsElement()),t},_createRouteWaitingElement:function(){var t=document.createElement("div");t.id=this._addUID("GProuteCalcWaitingContainer"),t.className="GProuteCalcWaitingContainerHidden";var e=document.createElement("p");return e.className="GProuteCalcWaiting",e.innerHTML="Calcul en cours...",t.appendChild(e),t},_createRouteResultsStagesElement:function(){var t=document.createElement("div");return t.id=this._addUID("GProuteResultsStages"),t},_createRouteResultsElement:function(){var t=this,e=document.createElement("div");e.id=this._addUID("GProuteResults");var i=document.createElement("div");i.id=this._addUID("GProuteResultsValues"),e.appendChild(i);var o=document.createElement("div");o.id=this._addUID("GProuteResultsMode");var n=document.createElement("select");n.id=this._addUID("GProuteResultsComputationSelect"),n.className="GPinputSelect",n.addEventListener("change",(function(e){t.onRouteModeComputationChangeAndRun(e)}));for(var s=[{code:"fastest",label:"Plus rapide"},{code:"shortest",label:"Plus court"}],a=0;a<s.length;a++){var r=document.createElement("option");r.value=s[a].code,r.text=s[a].label,n.appendChild(r)}o.appendChild(n),e.appendChild(o);var l=document.createElement("div");return l.id=this._addUID("GProuteResultsNew"),l.title="Modifier le calcul",l.addEventListener("click",(function(e){document.getElementById(t._addUID("GProuteResultsPanel")).className="GProuteComponentHidden",document.getElementById(t._addUID("GProuteForm")).className="",t.onShowRouteResultsNewClick(e)})),e.appendChild(l),e},_addRouteResultsValuesElement:function(t,e,i){var o=document.getElementById(this._addUID("GProuteResultsValues"));if(o.childElementCount)for(;o.firstChild;)o.removeChild(o.firstChild);var n=document.createElement("div");n.className="GProuteResultsValue";var s=document.createElement("label");s.className="GProuteResultsValueLabel",s.innerHTML="Distance :",n.appendChild(s);var a=0;if(parseInt(t/1e3,10)){var r=Math.round(t);a=(r/=1e3)+" km"}else a=Math.round(t)+" m";var l=document.createElement("div");l.id=this._addUID("GProuteResultsValueDist"),l.innerHTML=a,n.appendChild(l),o.appendChild(n);var c=document.createElement("div");c.className="GProuteResultsValue";var u=document.createElement("label");u.className="GProuteResultsValueLabel",u.innerHTML="Durée :",c.appendChild(u);var h=document.createElement("div");return h.id=this._addUID("GProuteResultsValueDist"),h.innerHTML=i(e),c.appendChild(h),o.appendChild(c),o},_createRouteShowResultsDetailsElement:function(){var t=document.createElement("input");return t.id=this._addUID("GProuteResultsShowDetails"),t.type="checkbox",t},_createRouteResultsDetailsElement:function(){var t=document.createElement("div");return t.id=this._addUID("GProuteResultsDetails"),t},_addRouteResultsDetailsElement:function(t,e){var i=this,o=document.getElementById(this._addUID("GProuteResultsDetails"));if(o.childElementCount)for(;o.firstChild;)o.removeChild(o.firstChild);for(var n=0,s=0,a=0;a<t.length;a++){var r=a+1,l=t[a],c=document.createElement("div");c.className="GProuteResultsDetailsNumber",c.innerHTML=r+".",o.appendChild(c),s+=parseFloat(l.duration),n+=parseFloat(l.distance);var u=0;if(parseInt(n/1e3,10)){var h=Math.round(n);u=(h/=1e3)+" km"}else u=Math.round(n)+" m";var d=document.createElement("div");d.className="GProuteResultsDetailsInstruction",d.id=this._addUID("GProuteResultsDetailsInstruction_"+r),d.title="distance : "+u+" / temps : "+e(s),d.innerHTML=l.instruction,d.addEventListener("mouseover",(function(t){i.onRouteResultsDetailsMouseOver(t)})),d.addEventListener("mouseout",(function(t){i.onRouteResultsDetailsMouseOut(t)})),d.addEventListener("click",(function(t){"function"==typeof i.onRouteResultsDetailsClick&&i.onRouteResultsDetailsClick(t)})),o.appendChild(d)}return o},_createRoutePanelFormPointElement:function(t,e,i){var o=this,n=document.createElement("div");n.id="GProutePoint"+t,n.className=i?"GPflexInput GProuteStageFlexInput":"GPflexInput GProuteStageFlexInputHidden";var s=document.createElement("label");s.id="GProuteOriginLabel"+t,s.htmlFor="GProuteOrigin"+t,s.innerHTML=e,s.addEventListener("click",(function(){var t=this.id.charAt(this.id.length-1);document.getElementById("GProuteOriginCoords"+t).value="";for(var e=1;e<8;e++)document.getElementById("GProutePoint"+e).style.display="flex";document.getElementById("GProuteForm").className="",document.getElementById("GProuteOriginPointer"+t).checked=!1,document.getElementById("GProuteOrigin"+t).className="GProuteOriginVisible",document.getElementById("GProuteOriginCoords"+t).className="GProuteOriginHidden"})),n.appendChild(s);var a=document.createElement("input");a.id="GProuteOrigin"+t,a.className="GProuteOriginVisible",a.type="text",a.placeholder="Saisir une adresse",a.addEventListener("keyup",(function(t){var e=t.which||t.keyCode;if(13!==e&&10!==e){var i=this.id.charAt(this.id.length-1);document.getElementById("GProuteOrigin"+i).value.length>2?document.getElementById("GProuteAutoCompleteList"+i).style.display="block":document.getElementById("GProuteAutoCompleteList"+i).style.display="none",o.onAutoCompleteSearchText(t)}})),a.addEventListener("blur",(function(){var t=this.id.charAt(this.id.length-1);document.getElementById("GProuteAutoCompleteList"+t).style.display="none"})),n.appendChild(a);var r=document.createElement("input");r.id="GProuteOriginCoords"+t,r.className="GProuteOriginHidden",r.type="text",r.disabled=!0,n.appendChild(r);var l=document.createElement("input");l.id="GProuteOriginPointer"+t,l.type="checkbox",n.appendChild(l);var c=document.createElement("label");return c.id="GProuteOriginPointerImg"+t,c.htmlFor="GProuteOriginPointer"+t,c.className="GProuteOriginPointerImg",c.title="Pointer un lieu sur la carte",c.addEventListener("click",(function(t){t.preventDefault(),t.stopPropagation();var e,i=this.id.charAt(this.id.length-1);for(e=1;e<8;e++)i!==e&&(document.getElementById("GProuteOriginPointer"+e).checked=!1,"Pointer un lieu sur la carte"===document.getElementById("GProuteOriginCoords"+e).value&&(document.getElementById("GProuteOriginCoords"+e).value="",document.getElementById("GProuteOrigin"+e).className="GProuteOriginVisible",document.getElementById("GProuteOriginCoords"+e).className="GProuteOriginHidden"));if(document.getElementById("GProuteOriginPointer"+i).checked){for(document.getElementById("GProuteOriginCoords"+i).value="",e=1;e<8;e++)document.getElementById("GProutePoint"+e).style.display="flex";document.getElementById("GProuteForm").className="",document.getElementById("GProuteOriginPointer"+i).checked=!1,document.getElementById("GProuteOrigin"+i).className="GProuteOriginVisible",document.getElementById("GProuteOriginCoords"+i).className="GProuteOriginHidden"}else{for(document.getElementById("GProuteOriginCoords"+i).value="Pointer un lieu sur la carte",e=1;e<8;e++)document.getElementById("GProutePoint"+e).style.display=i===e?"flex":"none";document.getElementById("GProuteForm").className="GProuteFormMini",document.getElementById("GProuteOriginPointer"+i).checked=!0,document.getElementById("GProuteOrigin"+i).className="GProuteOriginHidden",document.getElementById("GProuteOriginCoords"+i).className="GProuteOriginVisible"}o.onRouteMapPointClick(t)})),n.appendChild(c),n},_createRoutePanelFormRemoveStageElement:function(t){var e=this,i=document.createElement("div");return i.id="GProuteStageRemove"+t,i.className="GProuteStageRemove",i.title="Supprimer l'étape",1!==t&&7!==t&&i.addEventListener("click",(function(t){var i=this.id.charAt(this.id.length-1);document.getElementById("GProutePoint"+i).className="GPflexInput GProuteStageFlexInputHidden",document.getElementById("GProuteOrigin"+i).value="",document.getElementById("GProuteOrigin"+i).className="GProuteOriginVisible",document.getElementById("GProuteOriginCoords"+i).value="",document.getElementById("GProuteOriginCoords"+i).className="GProuteOriginHidden",document.getElementById("GProuteStageAdd").style.display="",e.onRouteRemovePointClick(t)})),i},_createRoutePanelFormAddStageElement:function(){var t=this,e=document.createElement("div");return e.id="GProuteStageAdd",e.title="Ajouter une étape",e.addEventListener("click",(function(e){for(var i=1,o=0,n=2;n<7;n++)"GPflexInput GProuteStageFlexInputHidden"===document.getElementById("GProutePoint"+n).className?1===i&&(i=n):o++;i<7&&(document.getElementById("GProutePoint"+i).className="GPflexInput GProuteStageFlexInput"),4===o&&(document.getElementById("GProuteStageAdd").style.display="none"),t.onRouteAddPointClick(e)})),e},_createRoutePanelFormAutoCompleteListElement:function(t){var e=this,i=document.createElement("div");return i.id="GProuteAutoCompleteList"+t,i.className="GPadvancedAutoCompleteList",i.addEventListener?i.addEventListener("click",(function(i){e.onAutoCompletedResultsItemClick(i),document.getElementById("GProuteAutoCompleteList"+t).style.display="none"}),!1):i.attachEvent&&i.attachEvent("onclick",(function(i){e.onAutoCompletedResultsItemClick(i),document.getElementById("GProuteAutoCompleteList"+t).style.display="none"})),i},_createRouteAutoCompletedLocationElement:function(t,e,i){var o=document.getElementById("GProuteAutoCompleteList"+e),n=document.createElement("div");n.id="AutoCompletedLocation"+i,n.className="GPautoCompleteProposal",n.innerHTML=t.fullText,o.appendChild(n)},_createRoutePanelFormModeChoiceElement:function(){var t=document.createElement("div");return t.id=this._addUID("GProuteModeChoice"),t},_createRoutePanelFormModeChoiceTransportElement:function(t){var e=this,i=document.createElement("div");i.id=this._addUID("GProuteTransportChoice");var o=document.createElement("span");o.className="GProuteModeLabel",o.innerHTML="Mode de transport",i.appendChild(o);for(var n=0;n<t.length;n++){var s=t[n];if("Voiture"===s){var a=document.createElement("input");a.id=this._addUID("GProuteTransportCar"),a.type="radio",a.name="GProuteTransport",a.value="Voiture",0===n&&(a.checked=!0),a.addEventListener?a.addEventListener("change",(function(t){e.onRouteModeTransportChange(t)})):a.attachEvent&&a.attachEvent("onchange",(function(t){e.onRouteModeTransportChange(t)})),i.appendChild(a);var r=document.createElement("label");r.className="GProuteTransportImg",r.htmlFor=this._addUID("GProuteTransportCar"),r.title="Voiture",i.appendChild(r)}if("Pieton"===s){var l=document.createElement("input");l.id=this._addUID("GProuteTransportPedestrian"),l.type="radio",l.name="GProuteTransport",l.value="Pieton",0===n&&(l.checked=!0),l.addEventListener?l.addEventListener("change",(function(t){e.onRouteModeTransportChange(t)})):l.attachEvent&&l.attachEvent("onchange",(function(t){e.onRouteModeTransportChange(t)})),i.appendChild(l);var c=document.createElement("label");c.className="GProuteTransportImg",c.htmlFor=this._addUID("GProuteTransportPedestrian"),c.title="Piéton",i.appendChild(c)}}return i},_createRoutePanelFormModeChoiceComputeElement:function(){var t=this,e=document.createElement("div");e.id=this._addUID("GProuteComputationChoice");var i=document.createElement("span");i.className="GProuteModeLabel",i.innerHTML="Mode de calcul",e.appendChild(i);var o=document.createElement("select");o.id=this._addUID("GProuteComputationSelect"),o.className="GPinputSelect",o.addEventListener("change",(function(e){t.onRouteModeComputationChange(e)}));for(var n=[{code:"fastest",label:"Plus rapide"},{code:"shortest",label:"Plus court"}],s=0;s<n.length;s++){var a=document.createElement("option");a.value=n[s].code,a.text=n[s].label,o.appendChild(a)}return e.appendChild(o),e},_createShowRouteExclusionsElement:function(){var t=document.createElement("input");return t.id=this._addUID("GPshowRouteExclusions"),t.type="checkbox",t},_createShowRouteExclusionsPictoElement:function(){var t=this,e=document.createElement("label");return e.id=this._addUID("GPshowRouteExclusionsPicto"),e.className="GPshowMoreOptionsImage GPshowMoreOptions GPshowRouteExclusionsPicto",e.htmlFor=this._addUID("GPshowRouteExclusions"),e.title="Exclusions",e.addEventListener?e.addEventListener("click",(function(e){t.onShowRouteExclusionsClick(e)})):e.attachEvent&&e.attachEvent("onclick",(function(e){t.onShowRouteExclusionsClick(e)})),e},_createRoutePanelFormExclusionsElement:function(){var t=document.createElement("div");t.id=this._addUID("GProuteExclusions");var e=document.createElement("span");return e.className="GProuteExclusionsLabel",e.innerHTML="Passages autorisés",t.appendChild(e),t},_createRoutePanelFormExclusionOptionsElement:function(t){var e=this,i=document.createElement("div");for(var o in i.className="GProuteExclusionsOptions",t)if(t.hasOwnProperty(o)){var n=t[o];switch(o){case"toll":var s=document.createElement("input");s.id=this._addUID("GProuteExclusionsToll"),s.type="checkbox",s.value="Toll",s.checked=!n,s.addEventListener?s.addEventListener("change",(function(t){e.onRouteExclusionsChange(t)})):s.attachEvent&&s.attachEvent("onchange",(function(t){e.onRouteExclusionsChange(t)})),i.appendChild(s);var a=document.createElement("label");a.className="GProuteExclusionsOption",a.htmlFor=this._addUID("GProuteExclusionsToll"),a.innerHTML="Péages",i.appendChild(a);break;case"tunnel":var r=document.createElement("input");r.id=this._addUID("GProuteExclusionsTunnel"),r.type="checkbox",r.value="Tunnel",r.checked=!n,r.addEventListener?r.addEventListener("change",(function(t){e.onRouteExclusionsChange(t)})):r.attachEvent&&r.attachEvent("onchange",(function(t){e.onRouteExclusionsChange(t)})),i.appendChild(r);var l=document.createElement("label");l.className="GProuteExclusionsOption",l.htmlFor=this._addUID("GProuteExclusionsTunnel"),l.innerHTML="Tunnels",i.appendChild(l);break;case"bridge":var c=document.createElement("input");c.id=this._addUID("GProuteExclusionsBridge"),c.type="checkbox",c.value="Bridge",c.checked=!n,c.addEventListener?c.addEventListener("change",(function(t){e.onRouteExclusionsChange(t)})):c.attachEvent&&c.attachEvent("onchange",(function(t){e.onRouteExclusionsChange(t)})),i.appendChild(c);var u=document.createElement("label");u.className="GProuteExclusionsOption",u.htmlFor=this._addUID("GProuteExclusionsBridge"),u.innerHTML="Ponts",i.appendChild(u)}}return i},_createRouteSubmitFormElement:function(){var t=document.createElement("input");return t.id=this._addUID("GProuteSubmit"),t.className="GPinputSubmit",t.type="submit",t.value="Calculer",t},_createRouteFormResetElement:function(){var t=this,e=document.createElement("div");return e.id=this._addUID("GProuteReset"),e.title="Réinitialiser les paramètres",e.addEventListener("click",(function(e){t.onRouteResetClick(e)})),e}};e.default=s},function(t,e,i){"use strict";i.r(e);var o=i(40),n=i(2),s=i.n(n),a=i(34),r=i(140),l=i(36),c=i(164),u=i(145),h=i(165),d=a.default.getLogger("searchengine"),p=s.a.Control.extend({includes:h.default,options:{position:"topleft",collapsed:!0,displayInfo:!0,zoomTo:"",resources:[],placeholder:"Rechercher un lieu, une adresse",displayMarker:!0,markerStyle:"blue",displayAdvancedSearch:!0,advancedSearch:{},geocodeOptions:{},autocompleteOptions:{serviceOptions:{},triggerGeocode:!1,triggerDelay:1e3}},initialize:function(t){s.a.Util.setOptions(this,t),this._uid=l.default.generate(),this._showContainer=null,this._pictoContainer=null,this._inputContainer=null,this._suggestedContainer=null,this._suggestedLocations=[],this._geocodedContainer=null,this._geocodedLocations=[],this._filterContainer=null,this._currentGeocodingCode=null,this._currentGeocodingLocation=null,this._advancedSearchFilters={},this._advancedSearchCodes=[],this._marker=null,this._servicesRightManagement={},this._noRightManagement=!1,this._checkRightsManagement(),this._triggerHandler=null},onAdd:function(){this._initAdvancedSearchCodes(),this._initAdvancedSearchFilters();var t=this._initLayout();return s.a.DomEvent.disableClickPropagation(t).disableScrollPropagation(t),t},onRemove:function(t){this._clearSuggestedLocation(),this._clearGeocodedLocation(),null!=this._marker&&(t.removeLayer(this._marker),this._marker=null)},_checkRightsManagement:function(){this.options.resources&&0!==this.options.resources.length||(this.options.resources=["StreetAddress","PositionOfInterest"]);var t=null,e=[],i=null;i=this.options.geocodeOptions.apiKey,(e=(t=this.options.geocodeOptions.filterOptions)?t.type:[])&&0!==e.length||(e=this.options.resources||["StreetAddress","PositionOfInterest"]);var o=r.default.check({key:i||this.options.apiKey,resources:e,services:["Geocode"]});i=this.options.autocompleteOptions.apiKey,(e=(t=this.options.autocompleteOptions.filterOptions)?t.type:[])&&0!==e.length||(e=this.options.resources||["StreetAddress","PositionOfInterest"]);var n=r.default.check({key:i||this.options.apiKey,resources:e,services:["AutoCompletion"]});if(o||n||(this._noRightManagement=!0),n&&(this._servicesRightManagement.AutoCompletion={},this._servicesRightManagement.AutoCompletion.resources=n.AutoCompletion,this._servicesRightManagement.AutoCompletion.key=n.key),o&&(this._servicesRightManagement.Geocode={},this._servicesRightManagement.Geocode.resources=o.Geocode,this._servicesRightManagement.Geocode.key=o.key),!this.options.advancedSearch||0===Object.keys(this.options.advancedSearch).length)for(var s=this._servicesRightManagement.Geocode.resources,a=0;a<s.length;a++){var l=s[a];this.options.advancedSearch[l]=[]}},_initLayout:function(){var t=this._createMainContainerElement(),e=this._showContainer=this._createShowSearchEngineElement();t.appendChild(e),this.options.collapsed||(e.checked="true");var i=this._pictoContainer=this._createShowSearchEnginePictoElement();t.appendChild(i);var o=this._createSearchInputElement(this.options.placeholder);if(t.appendChild(o),this.options.displayAdvancedSearch){var n=this._createShowAdvancedSearchElement();t.appendChild(n);var s=this._createAdvancedSearchPanelElement(),a=this._createAdvancedSearchPanelHeaderElement(),r=this._createAdvancedSearchPanelFormElement(this._advancedSearchCodes),l=this._filterContainer=this._createAdvancedSearchFormFiltersElement();this._setFilter(this._advancedSearchCodes[0].id);var c=this._createAdvancedSearchFormInputElement();r.appendChild(l),r.appendChild(c),s.appendChild(a),s.appendChild(r),t.appendChild(s)}var u=this._createAutoCompleteElement(),h=this._suggestedContainer=this._createAutoCompleteListElement();u.appendChild(h),t.appendChild(u);var d=this._createGeocodeResultsElement(),p=this._geocodedContainer=this._createGeocodeResultsListElement();return d.appendChild(p),t.appendChild(d),t},_initAdvancedSearchCodes:function(){for(var t=[{id:"PositionOfInterest",title:"Lieux/toponymes"},{id:"StreetAddress",title:"Adresses"},{id:"CadastralParcel",title:"Parcelles cadastrales"},{id:"Administratif",title:"Administratif"}],e=Object.keys(this.options.advancedSearch),i=0;i<e.length;i++)for(var o=e[i],n=0;n<t.length;n++)t[n].id===o&&this._advancedSearchCodes.push(t[n]);0===this._advancedSearchCodes.length&&(this._advancedSearchCodes=t),d.log("advancedSearchCodes",this._advancedSearchCodes)},_initAdvancedSearchFilters:function(){var t={PositionOfInterest:[{name:"city",title:"Ville",filter:!1,sep:!0},{name:"importance",title:"Importance",filter:!0},{name:"nature",title:"Nature",filter:!0},{name:"territory",title:"Territoire",filter:!0},{name:"insee",title:"Code commune (INSEE)",filter:!0},{name:"department",title:"Département",filter:!0}],StreetAddress:[{name:"number",title:"Numéro",filter:!1,sep:!0},{name:"street",title:"Rue",filter:!1,sep:!0},{name:"postalCode",title:"Code Postal",filter:!1,sep:!0},{name:"city",title:"Ville",filter:!1,sep:!0},{name:"territory",title:"Territoire",filter:!0},{name:"insee",title:"Code commune (INSEE)",filter:!0},{name:"department",title:"Département",filter:!0}],CadastralParcel:[{name:"department",title:"Département",filter:!1,sep:!1,value:"__"},{name:"commune",title:"Commune",filter:!1,sep:!1,value:"___"},{name:"absorbedCity",title:"Commune absorbée",filter:!1,sep:!1,value:"___"},{name:"section",title:"Section",filter:!1,sep:!1,value:"__"},{name:"number",title:"Numéro",filter:!1,sep:!1,value:"____"}],Administratif:[{name:"prefecture",title:"Préfecture",filter:!0},{name:"inseeRegion",title:"Code région (INSEE)",filter:!0},{name:"inseeDepartment",title:"Code département (INSEE)",filter:!0},{name:"city",title:"Ville",filter:!1,sep:!0}]},e=this.options.advancedSearch;for(var i in e)if(e.hasOwnProperty(i)){if(!e[i]||0===e[i].length){e[i]=t[i];continue}for(var o=e[i],n=0;n<o.length;n++){var a=o[n];a.hasOwnProperty("filter")||(a.filter="municipality"!==a.name)}}s.a.Util.extend(this._advancedSearchFilters,t,e),d.log("advancedSearchFilters",this._advancedSearchFilters)},_setFilter:function(t){for(var e=this._filterContainer,i=!1,o=0;o<this._advancedSearchCodes.length;o++)if(this._advancedSearchCodes[o].id===t){i=!0;break}if(i){for(this._currentGeocodingCode=t;e.firstChild;)e.removeChild(e.firstChild);var n=this._advancedSearchFilters[t];if(n&&0!==n.length){for(var s=this._createAdvancedSearchFiltersTableElement(t,!0),a=0;a<n.length;a++){var r=this._createAdvancedSearchFiltersAttributElement(n[a]);s.appendChild(r)}return e.appendChild(s),e}}else for(;e.firstChild;)e.removeChild(e.firstChild)},_requestAutoComplete:function(t){if(t&&0!==Object.keys(t).length&&t.text)if(d.log(t),this._noRightManagement)d.log("no rights for all service !?");else if(this._servicesRightManagement.AutoCompletion){var e={};s.a.Util.extend(e,this.options.autocompleteOptions.serviceOptions),s.a.Util.extend(e,t);var i=this._servicesRightManagement.AutoCompletion.resources;if(i&&0!==Object.keys(i).length){i&&s.a.Util.isArray(i)&&!e.filterOptions&&(e.filterOptions||(e.filterOptions={}),e.filterOptions.type=i);var n=this._servicesRightManagement.AutoCompletion.key;s.a.Util.extend(e,{apiKey:e.apiKey||this.options.apiKey||n}),s.a.Util.extend(e,{ssl:this.options.ssl}),d.log(e),o.default.Services.autoComplete(e)}}else d.log("no rights for this service !?")},_fillAutoCompletedLocationListContainer:function(t){if(t&&0!==t.length){var e=this._suggestedContainer;if(e.childElementCount)for(;e.firstChild;)e.removeChild(e.firstChild);for(var i=0;i<t.length;i++)this._createAutoCompletedLocationElement(t[i],i)}},_requestGeocoding:function(t){if(t&&0!==Object.keys(t).length&&t.location)if(d.log(t),this._noRightManagement)d.log("no rights for all service !?");else if(this._servicesRightManagement.Geocode){var e={};s.a.Util.extend(e,this.options.geocodeOptions),s.a.Util.extend(e,t),e.hasOwnProperty("returnFreeForm")||s.a.Util.extend(e,{returnFreeForm:!0});var i=this._servicesRightManagement.Geocode.resources;if(i&&0!==Object.keys(i).length){i&&s.a.Util.isArray(i)&&!e.filterOptions&&(e.filterOptions||(e.filterOptions={}),e.filterOptions.type=i);var n=this._servicesRightManagement.Geocode.key;s.a.Util.extend(e,{apiKey:e.apiKey||this.options.apiKey||n}),s.a.Util.extend(e,{ssl:this.options.ssl}),d.log(e),o.default.Services.geocode(e)}}else d.log("no rights for this service !?")},_fillGeocodedLocationListContainer:function(t){if(t&&0!==t.length){var e=this._geocodedContainer;if(e.childElementCount)for(;e.firstChild;)e.removeChild(e.firstChild);for(var i=0;i<t.length;i++)d.log(t[i]),this._createGeocodedLocationElement(t[i],i);this._geocodedLocations=t}else this._clearGeocodedLocation()},_getGeocodeCoordinatesFromFullText:function(t,e){var i=t.fullText,o=this;this._requestGeocoding({location:i,onSuccess:function(t){d.log("request from Geocoding (coordinates null)",t),t.locations&&0!==t.locations.length&&t.locations[0].position&&o._suggestedLocations&&o._suggestedLocations[e]&&(o._suggestedLocations[e].position={x:t.locations[0].position.y,y:t.locations[0].position.x},o._locationsToBeDisplayed.unshift(o._suggestedLocations[e]),o._fillAutoCompletedLocationListContainer(o._locationsToBeDisplayed))},onFailure:function(){o._suggestedLocations&&o._suggestedLocations[e]&&o._createAutoCompletedLocationElement(o._suggestedLocations[e],e)}})},_setLabel:function(t){s.a.DomUtil.get("GPsearchInputText-"+this._uid).value=t||""},_setPosition:function(t,e){var i=this._map;i.setZoomAround(s.a.latLng(t.x,t.y),e,!0),i.panTo(s.a.latLng(t.x,t.y))},_getZoom:function(t){var e=this._map,i=this.options.zoomTo,o=null;if("function"==typeof i&&(d.trace("zoom function"),o=i.call(this,t)),"number"==typeof i&&(d.trace("zoom level"),o=i),"string"==typeof i)if("auto"===i)d.trace("zoom auto"),o=c.default.zoomToResultsByDefault(t);else{d.trace("zoom level parsing");var n=parseInt(i,10);isNaN(n)||(d.trace("zoom parsing"),o=n)}Number.isInteger=Number.isInteger||function(t){return"number"==typeof t&&isFinite(t)&&Math.floor(t)===t},o&&""!==o&&Number.isInteger(o)||(d.trace("zoom not found, current zoom..."),o=e.getZoom());var s=e.getMinZoom(),a=e.getMaxZoom();return o<s&&(d.trace("zoom level min..."),o=s),o>a&&(d.trace("zoom level max..."),o=a),d.trace("zoom",o),o},_setMarker:function(t,e,i,o){var n=this._map;if(null!=this._marker&&(n.removeLayer(this._marker),this._marker=null),t){var a=null;"string"==typeof o?a=new u.default(o):o instanceof s.a.Icon?a=o:(a=new u.default("blue"),d.log("Utilisation du marker par défaut !"));var r={clickable:!0,zIndexOffset:1e3,icon:a};if(this._marker=s.a.marker(s.a.latLng(t.x,t.y),r),this._marker.addTo(n),i){var l=null;if("string"!=typeof e){var c=[];if("DirectGeocodedLocation"===e.service)if(e.fields.freeform)l=e.fields.freeform;else{for(var h=this._advancedSearchFilters[e.type],p=0;p<h.length;p++){var m=h[p].name,f=e.fields[m];"string"!=typeof f&&"number"!=typeof f||c.push(f)}l=c.join(" - ")}else"SuggestedLocation"===e.service?e.fields.fullText?l=e.fields.fullText:(c.push(e.fields.street||""),c.push(e.fields.postalCode||""),c.push(e.fields.commune||""),"PositionOfInterest"===e.type&&(c.push(e.fields.poi||""),c.push(e.fields.kind||"")),l=c.join(" - ")):l="sans informations."}else l=e;this._marker.bindPopup(l)}}},_clearResults:function(){this._currentGeocodingLocation=null,this._clearSuggestedLocation(),this._clearGeocodedLocation(),this._setMarker()},_clearSuggestedLocation:function(){if(this._suggestedLocations=[],this._suggestedContainer)for(;this._suggestedContainer.firstChild;)this._suggestedContainer.removeChild(this._suggestedContainer.firstChild)},_clearGeocodedLocation:function(){if(this._geocodedLocations=[],this._geocodedContainer)for(;this._geocodedContainer.firstChild;)this._geocodedContainer.removeChild(this._geocodedContainer.firstChild)},onShowSearchEngineClick:function(){},onSearchResetClick:function(){this._clearResults()},onAutoCompleteSearchText:function(t){var e=t.target.value;if(e&&!(this._noRightManagement||(this._currentGeocodingLocation=e,e.length<3))){var i=this.options.autocompleteOptions.triggerGeocode,o=this.options.autocompleteOptions.triggerDelay,n=this;this._requestAutoComplete({text:e,onSuccess:function(t){if(d.log("request from AutoComplete",t),t){if(n._suggestedLocations=t.suggestedLocations,n._locationsToBeDisplayed=[],n._servicesRightManagement.Geocode&&n._servicesRightManagement.Geocode.key)for(var e=0;e<n._suggestedLocations.length;e++){var i=n._suggestedLocations[e];i.position&&0===i.position.x&&0===i.position.y&&i.fullText?n._getGeocodeCoordinatesFromFullText(i,e):n._locationsToBeDisplayed.push(i)}else n._locationsToBeDisplayed=n._suggestedLocations;n._fillAutoCompletedLocationListContainer(n._locationsToBeDisplayed),n._triggerHandler&&(clearTimeout(n._triggerHandler),n._triggerHandler=null,d.warn("Cancel a geocode request !"))}},onFailure:function(t){n._clearSuggestedLocation(),d.log(t.message),"No suggestion matching the search"===t.message&&i&&(n._triggerHandler&&(clearTimeout(n._triggerHandler),d.warn("Cancel the last geocode request !")),n._triggerHandler=setTimeout((function(){d.warn("Launch a geocode request (code postal) !"),n._requestGeocoding({location:e,returnFreeForm:!0,onSuccess:function(t){if(d.log("request from Geocoding",t),t){n._locationsToBeDisplayed=[];for(var e=t.locations,i=0;i<e.length;i++){var o=e[i];o.fullText=o.placeAttributes.freeform,o.position={x:o.position.y,y:o.position.x},n._locationsToBeDisplayed.push(o)}n._fillAutoCompletedLocationListContainer(e)}},onFailure:function(t){d.log(t.message)}})}),o))}})}},onAutoCompletedResultsItemClick:function(t){var e=l.default.index(t.target.id),i=t.target.innerHTML;if(d.log(e,i),d.log(this._locationsToBeDisplayed[e]),e){var o={x:this._locationsToBeDisplayed[e].position.y,y:this._locationsToBeDisplayed[e].position.x},n={service:"SuggestedLocation",type:this._locationsToBeDisplayed[e].type,fields:this._locationsToBeDisplayed[e]},s=this._getZoom(n);this._setLabel(i),this._setPosition(o,s),this.options.displayMarker&&this._setMarker(o,n,this.options.displayInfo,this.options.markerStyle)}},onGeocodingSearchSubmit:function(t){d.log(t);var e=t.target[0].value;if(e&&!this._noRightManagement){this._currentGeocodingLocation=e;var i=this;this._requestGeocoding({location:e,onSuccess:function(t){if(d.log("request from Geocoding",t),t){var e=t.locations;i._fillGeocodedLocationListContainer(e)}},onFailure:function(t){i._clearGeocodedLocation(),d.log(t.message)}})}},onGeocodedResultsItemClick:function(t){var e=l.default.index(t.target.id),i=t.target.innerHTML;if(d.log(e,i),d.log(this._geocodedLocations[e]),e){var o=this._geocodedLocations[e].position,n={service:"DirectGeocodedLocation",type:this._geocodedLocations[e].type,fields:this._geocodedLocations[e].placeAttributes},s=this._getZoom(n);this._setLabel(i),this._setPosition(o,s),this.options.displayMarker&&this._setMarker(o,n,this.options.displayInfo,this.options.markerStyle)}},onGeocodingAdvancedSearchCodeChange:function(t){d.log(t);var e=t.target.selectedIndex,i=t.target.options[e].value;i&&this._setFilter(i)},onGeocodingAdvancedSearchSubmit:function(t,e){if(d.log(e),e&&0!==e.length){var i={};i.type=[this._currentGeocodingCode];var o=this._currentGeocodingLocation||"";"CadastralParcel"===this._currentGeocodingCode&&(o="");for(var n=0;n<e.length;n++){var s=e[n];if(s.value)for(var a=this._advancedSearchFilters[this._currentGeocodingCode],r=0;r<a.length;r++){var l=a[r];if(l.name===s.key)if(l.filter)i[s.key]=s.value;else if(l.value){var c=s.value.length,u=l.value.length;if(u!==c){for(var h=u-c,p=l.value.charAt(0);p.length<h;)p+=p;var m=p.slice(0,h);s.value=s.value+m}o+=s.value}else"string"==typeof o&&(o={}),o[s.key]=s.value}}var f=this;this._requestGeocoding({location:o,filterOptions:i,onSuccess:function(t){if(d.log(t),t){var e=t.locations;f._fillGeocodedLocationListContainer(e)}},onFailure:function(t){f._clearGeocodedLocation(),d.log(t.message)}})}},setText:function(t,e,i){this._showContainer.checked||this._pictoContainer.click(),s.a.Util.extend(this.options,i);var o=s.a.DomUtil.get("GPsearchInputText-"+this._uid);(o.value=t,e)?s.a.DomUtil.get("GPsearchInput-"+this._uid).dispatchEvent(new Event("submit",{bubbles:!0,cancelable:!0})):o.dispatchEvent(new KeyboardEvent("keyup"))}});e.default=p},function(t,e,i){"use strict";i.r(e);e.default={advancedSearchFiltersByDefault:{PositionOfInterest:[{name:"importance",title:"Importance"},{name:"nature",title:"Nature"},{name:"territory",title:"Territoire"},{name:"insee",title:"Code INSEE"},{name:"municipality",title:"Ville"},{name:"department",title:"Département"}],StreetAddress:[{name:"territory",title:"Territoire"},{name:"insee",title:"Code INSEE"},{name:"municipality",title:"Ville"},{name:"department",title:"Département"}],CadastralParcel:[{name:"department",title:"Département",description:"Numéro du département (ex: 01, 94)"},{name:"commune",title:"Code commune (INSEE)",description:"Code commune (INSEE) : 3 chiffres (ex: 067)"},{name:"absorbedCity",title:"Commune absorbée",description:"Commune absorbée : 3 chiffres (ex: 000, 001)"},{name:"section",title:"Section",description:"Section : 2 caractères (ex: AA, 0D)"},{name:"number",title:"Numéro",description:"Numéro de la parcelle : 4 chiffres (ex: 0041, 0250)"}],Administratif:[{name:"prefecture",title:"Préfecture"},{name:"inseeRegion",title:"Code région (INSEE)"},{name:"inseeDepartment",title:"Code département (INSEE)"},{name:"municipality",title:"Ville"}]},zoomToResultsByDefault:function(t){var e=15,i=t.service,o=t.fields,n=t.type,s={1:11,2:12,3:13,4:14,5:15,6:16,7:17,8:17};return"SuggestedLocation"===i&&"PositionOfInterest"===n&&(e=s[o.classification]),"DirectGeocodedLocation"===i&&"PositionOfInterest"===n&&(e=s[o.importance]||14),"StreetAddress"===n&&(e=17),"CadastralParcel"===n&&(e=17),"Administratif"===n&&(e=12),e}}},function(t,e,i){"use strict";i.r(e);var o=i(36),n={_addUID:function(t){return this._uid?t+"-"+this._uid:t},_createMainContainerElement:function(){var t=document.createElement("div");return t.id=this._addUID("GPsearchEngine"),t.className="GPwidget",t},_createShowSearchEngineElement:function(){var t=document.createElement("input");return t.id=this._addUID("GPshowSearchEngine"),t.type="checkbox",t},_createShowSearchEnginePictoElement:function(){var t=this,e=document.createElement("label");e.id=this._addUID("GPshowSearchEnginePicto"),e.className="GPshowAdvancedToolPicto",e.htmlFor=this._addUID("GPshowSearchEngine"),e.title="Afficher/masquer la recherche par lieux",e.addEventListener("click",(function(){document.getElementById(t._addUID("GPautoCompleteList")).style.display="none",document.getElementById(t._addUID("GPgeocodeResultsList")).style.display="none";var e=document.getElementById(t._addUID("GPshowAdvancedSearch"));e&&(e.style.display=null,document.getElementById(t._addUID("GPadvancedSearchPanel")).style.display="none");var i="#GPsearchInput-"+t._uid;document.querySelector(i+" input").disabled=!1,t.onShowSearchEngineClick()}));var i=document.createElement("span");return i.id=this._addUID("GPshowSearchEngineOpen"),i.className="GPshowAdvancedToolOpen",e.appendChild(i),e},_createSearchInputElement:function(t){var e=this,i=document.createElement("form");i.id=this._addUID("GPsearchInput"),i.addEventListener("submit",(function(t){return t.preventDefault(),document.getElementById(e._addUID("GPgeocodeResultsList")).style.display="block",document.getElementById(e._addUID("GPautoCompleteList")).style.display="none",e.onGeocodingSearchSubmit(t),!1}));var n=document.createElement("input");n.id=this._addUID("GPsearchInputText"),n.type="text",n.placeholder=t,n.autocomplete="off",n.addEventListener("keyup",(function(t){var i=t.which||t.keyCode;13!==i&&10!==i&&38!==i&&40!==i&&(document.getElementById(e._addUID("GPgeocodeResultsList")).style.display="none",n.value.length>2?document.getElementById(e._addUID("GPautoCompleteList")).style.display="block":document.getElementById(e._addUID("GPautoCompleteList")).style.display="none",e.onAutoCompleteSearchText(t))})),n.addEventListener("keydown",(function(t){var i=t.which||t.keyCode,n=document.getElementById(e._addUID("GPautocompleteResults"));if(n){var s=n.getElementsByClassName("GPautoCompleteProposal current"),a=n.getElementsByClassName("GPautoCompleteProposal"),r=a.length;if(r){var l=null;if(!s.length)return(l=a[0]).className="GPautoCompleteProposal current",l.style.color="#000000",void(l.style["background-color"]="#CEDBEF");l=s[0];var c=parseInt(o.default.index(l.id),10),u=c===r-1?a[0]:a[c+1],h=0===c?a[r-1]:a[c-1];switch(l.style["background-color"]="",l.style.color="",h.style["background-color"]="",h.style.color="",u.style["background-color"]="",u.style.color="",i){case 38:l.className="GPautoCompleteProposal",h.className="GPautoCompleteProposal current",h.style.color="#000000",h.style["background-color"]="#CEDBEF";break;case 40:l.className="GPautoCompleteProposal",u.className="GPautoCompleteProposal current",u.style.color="#000000",u.style["background-color"]="#CEDBEF";break;case 13:t.preventDefault(),l.click(t)}l.focus()}}})),i.appendChild(n);var s=document.createElement("div");return s.id=this._addUID("GPsearchInputReset"),s.addEventListener("click",(function(){document.getElementById(e._addUID("GPsearchInputText")).value="",document.getElementById(e._addUID("GPautoCompleteList")).style.display="none",document.getElementById(e._addUID("GPgeocodeResultsList")).style.display="none",e.onSearchResetClick()})),i.appendChild(s),i},_createShowAdvancedSearchElement:function(){var t=this,e=document.createElement("div");e.id=this._addUID("GPshowAdvancedSearch"),e.className="GPshowAdvancedToolPicto",e.title="Ouvrir la recherche avancée",e.addEventListener("click",(function(){var e="#GPsearchInput-"+t._uid;document.querySelector(e+" input").disabled=!0,document.getElementById(t._addUID("GPautoCompleteList")).style.display="none",document.getElementById(t._addUID("GPgeocodeResultsList")).style.display="none",document.getElementById(t._addUID("GPshowAdvancedSearch")).style.display="none",document.getElementById(t._addUID("GPadvancedSearchPanel")).style.display="inline-block"}));var i=document.createElement("span");return i.id=this._addUID("GPshowAdvancedSearchOpen"),i.className="GPshowAdvancedToolOpen",e.appendChild(i),e},_createAdvancedSearchPanelElement:function(){var t=document.createElement("div");return t.id=this._addUID("GPadvancedSearchPanel"),t.className="GPpanel",t.style.display="none",t},_createGeocodeResultsElement:function(){var t=document.createElement("div");return t.id=this._addUID("GPgeocodeResultsList"),t.className="GPpanel",t.style.display="none",t.appendChild(this._createGeocodeResultsHeaderElement()),t},_createAutoCompleteElement:function(){var t=document.createElement("div");return t.id=this._addUID("GPautoCompleteList"),t.className="GPautoCompleteList",t.style.display="none",t},_createAutoCompleteListElement:function(){var t=this,e=document.createElement("div");return e.id=this._addUID("GPautocompleteResults"),e.addEventListener?e.addEventListener("click",(function(e){t.onAutoCompletedResultsItemClick(e),document.getElementById(t._addUID("GPautoCompleteList")).style.display="none"}),!1):e.attachEvent&&e.attachEvent("onclick",(function(e){t.onAutoCompletedResultsItemClick(e),document.getElementById(t._addUID("GPautoCompleteList")).style.display="none"})),e},_createAutoCompletedLocationElement:function(t,e){var i=document.getElementById(this._addUID("GPautocompleteResults")),o=document.createElement("div");o.id=this._addUID("AutoCompletedLocation_"+e),o.className="GPautoCompleteProposal",o.innerHTML=t.fullText,o.addEventListener?o.addEventListener("click",(function(t){i.click(t)}),!1):o.attachEvent&&o.attachEvent("onclick",(function(t){i.click(t)})),i.appendChild(o)},_createAdvancedSearchPanelHeaderElement:function(){var t=this,e=document.createElement("div");e.className="GPpanelHeader";var i=document.createElement("div");i.className="GPpanelTitle",i.innerHTML="Recherche avancée",e.appendChild(i);var o=document.createElement("div");return o.id=this._addUID("GPadvancedSearchClose"),o.className="GPpanelClose",o.title="Fermer la recherche avancée",o.addEventListener?o.addEventListener("click",(function(){var e="#GPsearchInput-"+t._uid;document.querySelector(e+" input").disabled=!1,document.getElementById(t._addUID("GPgeocodeResultsList")).style.display="none",document.getElementById(t._addUID("GPshowAdvancedSearch")).style.display="inline-block",document.getElementById(t._addUID("GPadvancedSearchPanel")).style.display="none"}),!1):o.attachEvent&&o.attachEvent("onclick",(function(){var e="#GPsearchInput-"+t._uid;document.querySelector(e+" input").disabled=!1,document.getElementById(t._addUID("GPgeocodeResultsList")).style.display="none",document.getElementById(t._addUID("GPshowAdvancedSearch")).style.display="inline-block",document.getElementById(t._addUID("GPadvancedSearchPanel")).style.display="none"})),e.appendChild(o),e},_createAdvancedSearchPanelFormElement:function(t){var e=this,i=document.createElement("form");i.id=this._addUID("GPadvancedSearchForm"),i.addEventListener("submit",(function(t){t.preventDefault();for(var i=[],o="#GPadvancedSearchFilters-"+e._uid,n=document.querySelectorAll(o+" > div > div > input"),s=0;s<n.length;s++){var a=n[s];i.push({key:a.name,value:a.value})}return e.onGeocodingAdvancedSearchSubmit(t,i),document.getElementById(e._addUID("GPgeocodeResultsList")).style.display="block",!1}));var o=document.createElement("div");o.className="GPflexInput";var n=document.createElement("label");n.className="GPadvancedSearchCodeLabel",n.innerHTML="Recherche par",o.appendChild(n);var s=this._createAdvancedSearchFormCodeElement(t);return o.appendChild(s),i.appendChild(o),i},_createAdvancedSearchFormCodeElement:function(t){var e=this,i=document.createElement("select");i.id=this._addUID("GPadvancedSearchCode"),i.className="GPadvancedSearchCode",i.addEventListener("change",(function(t){e.onGeocodingAdvancedSearchCodeChange(t)}),!1),t||(t=[{id:"PositionOfInterest",title:"Lieux/toponymes"},{id:"StreetAddress",title:"Adresses"},{id:"CadastralParcel",title:"Parcelles cadastrales"},{id:"Administratif",title:"Administratif"}]);for(var o=0;o<t.length;o++){var n=document.createElement("option");n.value=t[o].id,n.text=t[o].title,i.appendChild(n)}return i},_createAdvancedSearchFormInputElement:function(){var t=document.createElement("input");return t.type="submit",t.id=this._addUID("GPadvancedSearchSubmit"),t.className="GPinputSubmit",t.value="Chercher",t},_createAdvancedSearchFormFiltersElement:function(){var t=document.createElement("div");return t.id=this._addUID("GPadvancedSearchFilters"),t},_createAdvancedSearchFiltersTableElement:function(t,e){var i=document.createElement("div");return i.id=this._addUID(t),e||(i.style.display="none"),i},_createAdvancedSearchFiltersAttributElement:function(t){var e=null,i=t.name,o=t.title,n=t.description,s=t.code,a=t.value,r=document.createElement("div");r.className="GPflexInput";var l=document.createElement("label");l.className="GPadvancedSearchFilterLabel",l.htmlFor=i,l.title=n||o,l.innerHTML=o,r.appendChild(l);var c=document.createElement("input");return c.id=i,c.className="GPadvancedSearchFilterInput",c.type="text",c.name=i,a&&(c.value=a),r.appendChild(c),(e=document.getElementById(this._addUID(s)))?e.appendChild(r):e=r,e},_createGeocodeResultsHeaderElement:function(){var t=this,e=document.createElement("div");e.className="GPpanelHeader";var i=document.createElement("div");i.className="GPpanelTitle",i.innerHTML="Résultats de la recherche",e.appendChild(i);var o=document.createElement("div");return o.id=this._addUID("GPgeocodeResultsClose"),o.className="GPpanelClose",o.title="Fermer la fenêtre de résultats",o.addEventListener?o.addEventListener("click",(function(){document.getElementById(t._addUID("GPgeocodeResultsList")).style.display="none"}),!1):o.attachEvent&&o.attachEvent("onclick",(function(){document.getElementById(t._addUID("GPgeocodeResultsList")).style.display="none"})),e.appendChild(o),e},_createGeocodeResultsListElement:function(){var t=this,e=document.createElement("div");return e.id=this._addUID("GPgeocodeResults"),e.addEventListener?e.addEventListener("click",(function(e){e.ctrlKey||(document.getElementById(t._addUID("GPgeocodeResultsList")).style.display="none"),t.onGeocodedResultsItemClick(e)}),!1):e.attachEvent&&e.attachEvent("onclick",(function(e){e.ctrlKey||(document.getElementById(t._addUID("GPgeocodeResultsList")).style.display="none"),t.onGeocodedResultsItemClick(e)})),e},_createGeocodedLocationElement:function(t,e){var i=document.getElementById(this._addUID("GPgeocodeResults")),o=document.createElement("div");if(o.id=this._addUID("GeocodedLocation_"+e),o.className="GPautoCompleteProposal","string"==typeof t)o.innerHTML=t;else{var n=t.placeAttributes;n.freeform?o.innerHTML=n.freeform:n.postalCode?o.innerHTML=n.postalCode+" "+n.commune:n.cadastralParcel?o.innerHTML=n.cadastralParcel:o.innerHTML="..."}i.appendChild(o)}};e.default=n},function(t,e,i){"use strict";i.r(e);var o=i(40),n=i(2),s=i.n(n),a=(i(159),i(34)),r=i(140),l=i(36),c=i(144),u=i(145),h=i(167),d=i(168),p=a.default.getLogger("ElevationPath"),m=s.a.Control.extend({includes:h.default,options:{position:"topleft",active:!1,elevationPathOptions:{},stylesOptions:{},displayProfileOptions:{greaterSlope:!0,meanSlope:!0,ascendingElevation:!0,descendingElevation:!0,currentSlope:!0,apply:null,target:null}},initialize:function(t){s.a.Util.setOptions(this,t),this._uid=l.default.generate(),this._initDisplayProfileOptions(),this._showContainer=null,this._pictoContainer=null,this._panelContainer=null,this._profilContainer=null,this._waitingContainer=null,this._infoContainer=null,this._timerHdlr=null,this._reducePanel=!1,this._featuresLayer=null,this._lastIdLayer=0,this._currentIdLayer=0,this._currentFeature=null,this._profile=null,this._marker=null,this._geometry=null,this._distance=0,this._data={},this._noRightManagement=!1,this._checkRightsManagement()},onAdd:function(t){var e=this._container=this._initLayout();return t&&this.options.active&&(null===this._profile&&(this._panelContainer.style.display="none"),this._activateMapInteraction(t)),s.a.DomEvent.disableClickPropagation(e).disableScrollPropagation(e),e},onRemove:function(){},_checkRightsManagement:function(){var t=r.default.check({key:this.options.apiKey,resources:["SERVICE_CALCUL_ALTIMETRIQUE_RSC"],services:["ElevationLine"]});t||(this._noRightManagement=!0),this.options.apiKey||(this.options.apiKey=t.key)},_initDisplayProfileOptions:function(){var t=this.options.displayProfileOptions,e=t.apply;t.apply="function"==typeof e?e:m.DISPLAY_PROFILE_BY_DEFAULT;var i=t.target;t.target=void 0!==i?i:null;var o=Object.getPrototypeOf(this.options);void 0===t.meanSlope&&(t.meanSlope=o.displayProfileOptions.meanSlope),void 0===t.greaterSlope&&(t.greaterSlope=o.displayProfileOptions.greaterSlope),void 0===t.ascendingElevation&&(t.ascendingElevation=o.displayProfileOptions.ascendingElevation),void 0===t.descendingElevation&&(t.descendingElevation=o.displayProfileOptions.descendingElevation),void 0===t.currentSlope&&(t.currentSlope=o.displayProfileOptions.currentSlope)},_initLayout:function(){var t=this._createMainContainerElement(),e=this._showContainer=this._createShowElevationPathElement();t.appendChild(e),this.options.active&&(this._showContainer.checked=!0);var i=this._pictoContainer=this._createShowElevationPathPictoElement();t.appendChild(i);var o=this._panelContainer=this._createElevationPathPanelElement(),n=this._createElevationPathPanelHeaderElement();o.appendChild(n);var s=this._profilContainer=this._createElevationPathPanelProfilElement();o.appendChild(s);var a=this._waitingContainer=this._createElevationPathWaitingElement();o.appendChild(a);var r=this._infoContainer=this._createElevationPathInformationsElement();return o.appendChild(r),t.appendChild(o),t},onShowElevationPathClick:function(t){p.trace(t);var e=this._map;this._reducePanel?null!==this._profile&&(null===this.options.displayProfileOptions.target&&(this._pictoContainer.style.display="none"),this._panelContainer.style.display="block"):this._showContainer.checked?(this._pictoContainer.style.display="block",this._panelContainer.style.display="none",this._removeMapInteraction(e),this._clear()):(null===this._profile&&(this._panelContainer.style.display="none"),this._activateMapInteraction(e)),this._reducePanel=!1},onReduceElevationPathPanelClick:function(){this._reducePanel=!0,this._pictoContainer.style.display="block",this._panelContainer.style.display="none"},onOpenElevationPathInfoClick:function(){var t=this.options.displayProfileOptions.meanSlope,e=this.options.displayProfileOptions.greaterSlope,i=this.options.displayProfileOptions.ascendingElevation,o=this.options.displayProfileOptions.descendingElevation,n=this._infoContainer;if(n.childElementCount)for(;n.firstChild;)n.removeChild(n.firstChild);i&&this._addElevationPathInformationsItem("Dénivelé positif : "+this._data.ascendingElevation.toLocaleString()+" m"),o&&this._addElevationPathInformationsItem("Dénivelé négatif : "+this._data.descendingElevation.toLocaleString()+" m"),t&&this._addElevationPathInformationsItem("Pente moyenne : "+this._data.meanSlope.toLocaleString()+" %"),e&&this._addElevationPathInformationsItem("Plus forte pente : "+this._data.greaterSlope.toLocaleString()+" %"),"GPelevationPathInformationsContainerVisible"===n.className?(clearTimeout(this._timerHdlr),n.className="GPelevationPathInformationsContainerHidden"):n.className="GPelevationPathInformationsContainerVisible",this._timerHdlr=setTimeout((function(){n.className="GPelevationPathInformationsContainerHidden"}),4e3)},_activateMapInteraction:function(t){if(p.info("_activateMapInteraction()"),null===this._featuresLayer){this._featuresLayer=new s.a.FeatureGroup,t.addLayer(this._featuresLayer);var e=this;t.on("contextmenu",(function(){})),t.on("draw:created",(function(t){p.trace("draw:created"),e._currentIdLayer=s.a.Util.stamp(t.layer),e._getFeatureGeometry(t.layer),e._addFeatureLayer(t.layer)})),t.on("draw:drawstart",(function(){p.trace("draw:drawstart"),e._removeFeatureLayer(e._lastIdLayer),e._lastIdLayer=e._currentIdLayer})),t.on("draw:drawstop",(function(){p.trace("draw:drawstop"),void 0===e.options.elevationPathOptions.onSuccess&&null===e.options.displayProfileOptions.target&&(e._pictoContainer.style.display="none",e._panelContainer.style.display="block"),e._altiRequest()}))}this._activatePolyLineInteraction(t)},_removeMapInteraction:function(t){t&&(null!==this._featuresLayer&&(t.off("draw:created"),t.off("draw:drawstart"),t.off("draw:drawstop"),t.removeLayer(this._featuresLayer),this._featuresLayer=null),this._lastIdLayer=this._currentIdLayer=0,this._currentFeature&&this._currentFeature.disable())},_activatePolyLineInteraction:function(t){this._currentFeature&&this._currentFeature.disable();var e=this.options.stylesOptions||{},i=0!==Object.keys(e).length?e:{stroke:!0,color:"#C77A04",weight:4,opacity:.5,fill:!1};this._currentFeature=new s.a.Draw.Polyline(t,{shapeOptions:i}),this._currentFeature.enable()},_getFeatureGeometry:function(t){p.log(t.getLatLngs()),null!==this._geometry&&(this._geometry=null),this._geometry=[],this._distance=0;for(var e=t.getLatLngs(),i=0;i<e.length;i++){var o=e[i],n=e[i+1];this._geometry.push({lon:o.lng,lat:o.lat}),n&&(this._distance+=o.distanceTo(n))}p.log("Geometry",this._geometry),p.log("Distance",this._distance)},_addFeatureLayer:function(t){this._featuresLayer&&this._featuresLayer.addLayer(t)},_removeFeatureLayer:function(t){this._featuresLayer&&0!==t&&(t?this._featuresLayer.removeLayer(t):this._featuresLayer.clearLayers())},_altiRequest:function(){if(p.log("_altiRequest"),this._geometry){if(!this._noRightManagement){var t={};s.a.Util.extend(t,this.options.elevationPathOptions),s.a.Util.extend(t,{apiKey:t.apiKey||this.options.apiKey}),s.a.Util.extend(t,{ssl:this.options.ssl});var e=t.sampling;if(!e){var i=this._currentFeature._measurementRunningTotal;p.trace("length",i);var n=Math.floor(i)/5;e=n>=200?200:Math.floor(n)}var a=this;s.a.Util.extend(t,{sampling:e,onSuccess:this.options.elevationPathOptions.onSuccess||function(t){p.log(t),t&&(null!==a.options.displayProfileOptions.target&&(a._pictoContainer.style.display="block",a._panelContainer.style.display="block"),a._displayProfil(t.elevations),a._waitingContainer.className="GPelevationPathCalcWaitingContainerHidden",a._waiting=!1)},onFailure:this.options.elevationPathOptions.onFailure||function(t){p.log(t.message),a._pictoContainer.style.display="block",a._panelContainer.style.display="none",a._waitingContainer.className="GPelevationPathCalcWaitingContainerHidden",a._waiting=!1,a._clear()}});var r=this._geometry;s.a.Util.extend(t,{positions:r}),p.log(t),this._waitingContainer.className="GPelevationPathCalcWaitingContainerVisible",o.default.Services.getAltitude(t)}}else p.log("missing position")},_computeElevationMeasure:function(t){var e=function(t,e){var i=c.default.decimalToRadian(t[1]),o=c.default.decimalToRadian(e[1]),n=(o-i)/2,s=c.default.decimalToRadian(e[0]-t[0])/2,a=Math.sin(n)*Math.sin(n)+Math.sin(s)*Math.sin(s)*Math.cos(i)*Math.cos(o);return 12756274*Math.atan2(Math.sqrt(a),Math.sqrt(1-a))},i=t,o="km",n=1e3;this._distance<2e3&&(n=1,o="m"),i[0].dist=0,i[0].slope=0;for(var s=0,a=0,r=0,l=0,u=0,h=0,d=1;d<i.length;d++){var p=e([i[d].lon,i[d].lat],[i[d-1].lon,i[d-1].lat]),m=i[d].z,f=i[d-1].z;m<0&&(m=0),f<0&&(f=0);var _=m-f;_<0?(s+=p,l+=_):_>0&&(a+=p,r+=_),u+=p/n,i[d].dist=u,h+=_?Math.abs(Math.round(_/p*100)):0,i[d].slope=_?Math.abs(Math.round(_/p*100)):0;var g=i[d].slope;i[d].color=g>15&&g<30?"#005b4c":g>30&&g<45?"#00362d":g>45?"#00120f":"#00B798",i[d].lat=Math.round(1e4*i[d].lat)/1e4,i[d].lon=Math.round(1e4*i[d].lon)/1e4}var v=100;u>100?v=1:u>10&&(v=10),u=Math.round(u*v)/v,s=Math.round(s*v)/v,a=Math.round(a*v)/v;for(var y=i[0].z,E=i[0].z,P=i[0].slope,w=0;w<i.length;w++){var C=i[w];C.z<0&&(C.z=0),C.z>=E&&(E=C.z),C.z<=y&&(y=C.z),C.dist=Math.round(C.dist*v)/v,C.slope>P&&(P=C.slope)}return{greaterSlope:P,meanSlope:Math.round(h/i.length),distancePlus:a.toLocaleString(),distanceMinus:s.toLocaleString(),ascendingElevation:r,descendingElevation:l,altMin:y.toLocaleString(),altMax:E.toLocaleString(),distance:u.toLocaleString(),unit:o,points:i}},_displayProfil:function(t){this._map.off("contextmenu"),this._data&&(this._data={});var e=this._data=this._computeElevationMeasure(t),i=this.options.displayProfileOptions.target;i&&i.appendChild(this._panelContainer),i=this._profilContainer;var o=this.options.displayProfileOptions,n=o.apply;"undefined"!=typeof AmCharts&&"undefined"!=typeof d3&&p.trace("Aucune lib. n'est presente !"),n.call(this,e,i,this);var a=s.a.DomUtil.get("GPelevationPathPanelInfo-"+this._uid);(o.greaterSlope||o.meanSlope||o.ascendingElevation||o.descendingElevation)&&(a.style.display="block")},_clear:function(){if(this._geometry=null,this._profile=null,this._profilContainer)for(;this._profilContainer.firstChild;)this._profilContainer.removeChild(this._profilContainer.firstChild);var t=this._map;this._marker&&(t.removeLayer(this._marker),this._marker=null)}});m.__createProfileMarker=function(t,e){p.log("__createProfileMarker");var i=t,o=i._map;i._marker=s.a.marker(s.a.latLng(e),{icon:new u.default("orange"),draggable:!1,clickable:!1,zIndexOffset:1e3}),i._marker.addTo(o)},m.__updateProfileMarker=function(t,e){p.log("__updateProfileMarker");var i=t,o=i._map;i._marker?(i._marker.setLatLng(s.a.latLng(e)),i._marker.update()):(i._marker=s.a.marker(s.a.latLng(e),{icon:new u.default("orange"),draggable:!1,clickable:!1,zIndexOffset:1e3}),i._marker.addTo(o))},m.__removeProfileMarker=function(t){p.log("__removeProfileMarker");var e=t,i=e._map;e._marker&&(i.removeLayer(e._marker),e._marker=null)},m.__customRawProfileOperation=function(){p.log("__customRawProfileOperation")},m.__customRawProfileMouseOverEvent=function(t,e){p.log("__customRawProfileMouseOverEvent",t,e)},m.DISPLAY_PROFILE_BY_DEFAULT=function(t,e,i){p.trace("ElevationPath.DISPLAY_PROFILE_BY_DEFAULT");var o=d.default.displayProfileByDefault(t,e,i,m);o&&(this._profile=o)},m.DISPLAY_PROFILE_RAW=function(t,e,i){p.trace("ElevationPath.DISPLAY_PROFILE_RAW");var o=d.default.displayProfileRaw(t,e,i,m);o&&(this._profile=o)},m.DISPLAY_PROFILE_LIB_D3=function(t,e,i){if(p.trace("ElevationPath.DISPLAY_PROFILE_LIB_D3"),"undefined"!=typeof d3){var o=d.default.displayProfileLibD3(t,e,i,m);o&&(this._profile=o)}else p.log("Lib. D3 is not loaded !")},m.DISPLAY_PROFILE_LIB_AMCHARTS=function(t,e,i){if(p.trace("ElevationPath.DISPLAY_PROFILE_LIB_AMCHARTS"),"undefined"!=typeof AmCharts){var o=d.default.displayProfileLibAmCharts(t,e,i,m);o&&(this._profile=o)}else p.log("Lib. AmCharts is not loaded !")},e.default=m},function(t,e,i){"use strict";i.r(e);var o={_addUID:function(t){return this._uid?t+"-"+this._uid:t},_createMainContainerElement:function(){var t=document.createElement("div");return t.id=this._addUID("GPelevationPath"),t.className="GPwidget",t},_createShowElevationPathElement:function(){var t=document.createElement("input");return t.id=this._addUID("GPshowElevationPath"),t.type="checkbox",t},_createShowElevationPathPictoElement:function(){var t=this,e=document.createElement("label");e.id=this._addUID("GPshowElevationPathPicto"),e.className="GPshowAdvancedToolPicto",e.htmlFor=this._addUID("GPshowElevationPath"),e.title="Calculer un profil",e.addEventListener?e.addEventListener("click",(function(e){t.onShowElevationPathClick(e)})):e.attachEvent&&e.attachEvent("onclick",(function(e){t.onShowElevationPathClick(e)}));var i=document.createElement("span");return i.id=this._addUID("GPshowElevationPathOpen"),i.className="GPshowAdvancedToolOpen",e.appendChild(i),e},_createElevationPathPanelElement:function(){var t=document.createElement("div");return t.id=this._addUID("GPelevationPathPanel"),t.className="GPpanel",t},_createElevationPathPanelHeaderElement:function(){var t=this,e=document.createElement("div");e.className="GPpanelHeader";var i=document.createElement("div");i.id=this._addUID("GPelevationPathPanelInfo"),i.className="GPpanelInfo",i.title="Informations",i.addEventListener?i.addEventListener("click",(function(){t.onOpenElevationPathInfoClick()})):i.attachEvent&&i.attachEvent("onclick",(function(){t.onOpenElevationPathInfoClick()})),e.appendChild(i);var o=document.createElement("div");o.className="GPpanelTitle",o.innerHTML="Profil Altimétrique",e.appendChild(o);var n=document.createElement("div");n.id=this._addUID("GPelevationPathPanelReduce"),n.className="GPpanelReduce",n.title="Masquer le panneau",n.addEventListener?n.addEventListener("click",(function(){"function"==typeof t.onReduceElevationPathPanelClick&&(document.getElementById(t._addUID("GPshowElevationPath")).checked=!1,t.onReduceElevationPathPanelClick())}),!1):n.attachEvent&&n.attachEvent("onclick",(function(){"function"==typeof t.onReduceElevationPathPanelClick&&(document.getElementById(t._addUID("GPshowElevationPath")).checked=!1,t.onReduceElevationPathPanelClick())})),e.appendChild(n);var s=document.createElement("div");return s.id=this._addUID("GPelevationPathPanelClose"),s.className="GPpanelClose",s.title="Fermer le panneau",s.addEventListener?s.addEventListener("click",(function(){document.getElementById(t._addUID("GPshowElevationPathPicto")).click()}),!1):s.attachEvent&&s.attachEvent("onclick",(function(){document.getElementById(t._addUID("GPshowElevationPathPicto")).click()})),e.appendChild(s),e},_createElevationPathPanelProfilElement:function(){var t=document.createElement("div");return t.id="GPelevationPathProfil",t},_createElevationPathWaitingElement:function(){var t=document.createElement("div");t.id=this._addUID("GPelevationPathCalcWaitingContainer"),t.className="GPelevationPathCalcWaitingContainerHidden";var e=document.createElement("p");return e.className="GPelevationPathCalcWaiting",e.innerHTML="Calcul en cours...",t.appendChild(e),t},_createElevationPathInformationsElement:function(){var t=document.createElement("div");t.id=this._addUID("GPelevationPathInformationsContainer"),t.className="GPelevationPathInformationsContainerHidden";var e=document.createElement("p");return e.className="GPelevationPathInformations",e.innerHTML="Aucune information...",t.appendChild(e),t},_addElevationPathInformationsItem:function(t){var e=document.getElementById(this._addUID("GPelevationPathInformationsContainer"));if(e){var i=document.createElement("p");i.className="GPelevationPathInformations",i.innerHTML=t,e.appendChild(i)}return e}};e.default=o},function(t,e,i){"use strict";i.r(e);var o={displayProfileByDefault:function(t,e,i,o){var n=i;if(e)for(;e.firstChild;)e.removeChild(e.firstChild);if(t){var s=n.options.displayProfileOptions,a=t.points,r=JSON.parse(JSON.stringify(a));r.sort((function(t,e){return t.z-e.z}));var l=r[0].z,c=r[r.length-1].z,u=c-l,h=t.distance,d=t.unit,p=100/a.length,m=document.createElement("div");m.id="profileElevationByDefault",e.appendChild(m);var f=document.createElement("div");f.className="profile-box";var _=document.createElement("div");_.className="profile-z-vertical";var g=document.createElement("ul"),v=document.createElement("li");v.setAttribute("class","profile-min-z"),v.innerHTML=l+" m";var y=document.createElement("li");y.setAttribute("class","profile-max-z"),y.innerHTML=c+" m",g.appendChild(y),g.appendChild(v),_.appendChild(g),f.appendChild(_);var E=document.createElement("div");E.className="profile-content",E.addEventListener("mouseover",(function(t){var e=parseFloat(t.target.dataset.lon),i=parseFloat(t.target.dataset.lat);e&&i&&o.__createProfileMarker(n,{lat:i,lon:e})})),E.addEventListener("mousemove",(function(t){var e=parseFloat(t.target.dataset.lon),i=parseFloat(t.target.dataset.lat);e&&i&&o.__updateProfileMarker(n,{lat:i,lon:e})})),E.addEventListener("mouseout",(function(){o.__removeProfileMarker(n)}));var P=document.createElement("ul");P.id="profile-data",P.className="profile-z-axis profile-x-axis",E.appendChild(P);for(var w=0;w<a.length;w++){var C=a[w],M=document.createElement("li");M.setAttribute("data-z",C.z),M.setAttribute("data-lon",C.lon),M.setAttribute("data-lat",C.lat),M.setAttribute("data-dist",C.dist);var S=Math.floor(100*(C.z-l)/u);M.setAttribute("class","percent v"+S),M.title="Altitude : "+C.z+"m",s.currentSlope&&(M.title+=" - Pente : "+C.slope+"%"),M.title+=" (Lat : "+C.lat+" / Lon : "+C.lon+")",M.setAttribute("style","width: "+p+"%"),P.appendChild(M)}f.appendChild(E),m.appendChild(f);var L=document.createElement("div");L.className="profile-x-horizontal";var b=document.createElement("ul"),R=document.createElement("li");R.setAttribute("class","profile-min-x"),R.innerHTML="";var x=document.createElement("li");return x.setAttribute("class","profile-max-x"),x.innerHTML=h+" "+d,b.appendChild(R),b.appendChild(x),L.appendChild(b),m.appendChild(L),e}},displayProfileRaw:function(t,e,i,o){if(e)for(;e.firstChild;)e.removeChild(e.firstChild);var n=t.points,s=document.createElement("textarea");return s.id="profilElevationResults",s.rows=10,s.cols=50,s.style.width="100%",s.innerHTML=JSON.stringify(n,void 0,4),s.addEventListener("mouseover",(function(t){o.__customRawProfileMouseOverEvent(i,t)})),e.appendChild(s),e},displayProfileLibD3:function(t,e,i,o){var n=i;if(e)for(;e.firstChild;)e.removeChild(e.firstChild);var s=t.points,a=n.options.displayProfileOptions,r=20,l=20,c=30,u=40,h=e.clientWidth-u-l,d=e.clientHeight-r-c,p=d3.scale.linear().range([0,h]),m=d3.scale.linear().range([d,0]),f=d3.svg.axis().scale(p).orient("bottom").ticks(5),_=d3.svg.axis().scale(m).orient("left").ticks(5),g=d3.svg.line().interpolate("basis").x((function(t){return p(t.dist)})).y((function(t){return m(t.z)})),v=d3.svg.area().interpolate("basis").x((function(t){return p(t.dist)})).y0(d).y1((function(t){return m(t.z)})),y=d3.select(e).append("svg").attr("width",h+u+l).attr("height",d+r+c).append("g").attr("transform","translate("+u+","+r+")"),E=d3.extent(s,(function(t){return t.dist}));p.domain(E);var P=[0,d3.max(s,(function(t){return t.z}))];m.domain(P),y.append("path").datum(s).attr("class","area-d3").attr("d",v),y.append("g").attr("class","x axis-d3").attr("transform","translate(0,"+d+")").call(f).append("text").attr("y",-15).attr("dy",".71em").attr("x",h).text("Distance ("+t.unit+")"),y.append("g").attr("class","y axis-d3").call(_).append("text").attr("transform","rotate(-90)").attr("y",6).attr("dy",".71em").text("Altitude (m)"),y.append("g").attr("class","grid-d3 vertical").attr("transform","translate(0,"+d+")").call(f.orient("bottom").tickSize(-d,0,0).tickFormat("")),y.append("g").attr("class","grid-d3 horizontal").call(_.orient("left").tickSize(-h,0,0).tickFormat("")),y.append("path").datum(s).attr("class","line-d3").attr("d",g),y.selectAll("circle").data(s).enter().append("circle").attr("cx",(function(t){return p(t.dist)})).attr("cy",(function(t){return m(t.z)})).attr("r",0).attr("class","circle-d3");var w=y.append("g").style("display","none");w.append("line").attr("id","focusLineX").attr("class","focusLine-d3"),w.append("line").attr("id","focusLineY").attr("class","focusLine-d3"),w.append("circle").attr("id","focusCircle").attr("r",4).attr("class","circle-d3 focusCircle-d3");var C=d3.select(e).append("div").attr("class","tooltip-d3").style("opacity",0),M=d3.bisector((function(t){return t.dist})).left;return y.append("rect").attr("class","overlay-d3").attr("width",h).attr("height",d).on("mouseover",(function(){w.style("display",null),o.__createProfileMarker(n,s[0])})).on("mouseout",(function(){w.style("display","none"),o.__removeProfileMarker(n),C.transition().duration(500).style("opacity",0)})).on("mousemove",(function(){var t=d3.mouse(this),e=p.invert(t[0]),i=M(s,e),r=s[i-1],l=s[i],c=e-r[0]>l[0]-e?l:r,u=p(c.dist),h=m(c.z);w.select("#focusCircle").attr("cx",u).attr("cy",h),w.select("#focusLineX").attr("x1",u).attr("y1",m(P[0])).attr("x2",u).attr("y2",m(P[1])),w.select("#focusLineY").attr("x1",p(E[0])).attr("y1",h).attr("x2",p(E[1])).attr("y2",h),o.__updateProfileMarker(n,c),C.transition().duration(200).style("opacity",.9);var d="";d+=" Altitude : "+c.z+" m",a.currentSlope&&(d+="<br/> Pente : "+c.slope+" %"),d+="<br/> (Lat : "+c.lat+"/ Lon : "+c.lon+")",C.html(d).style("left",d3.event.pageX+"px").style("top",d3.event.pageY-28+"px")})),y},displayProfileLibAmCharts:function(t,e,i,o){var n=i,s=t.points,a="<span class='altiPathValue'>[[title]] : [[value]]m</span><br/>";n.options.displayProfileOptions.currentSlope&&(a+="<span class='altiPathValue'>Pente : [[slope]] %</span><br/>"),a+="<span class='altiPathCoords'>(Lat: [[lat]] / Lon:[[lon]])</span>",AmCharts.addInitHandler((function(){}));var r={type:"serial",pathToImages:"http://cdn.amcharts.com/lib/3/images/",categoryField:"dist",autoMarginOffset:0,marginRight:10,marginTop:10,startDuration:0,color:"#5E5E5E",fontSize:8,theme:"light",thousandsSeparator:"",numberFormatter:{precision:-1,decimalSeparator:",",thousandsSeparato:" "},categoryAxis:{color:"#5E5E5E",gridPosition:"start",minHorizontalGap:40,tickPosition:"start",title:"Distance ("+t.unit+")",titleColor:"#5E5E5E",labelOffset:0,startOnAxis:!0},chartCursor:{animationDuration:0,bulletsEnabled:!0,bulletSize:10,categoryBalloonEnabled:!1,cursorColor:"#F90",graphBulletAlpha:1,graphBulletSize:1,zoomable:!1},trendLines:[],graphs:[{balloonColor:"#CCCCCC",balloonText:a,bullet:"round",bulletAlpha:0,bulletBorderColor:"#FFF",bulletBorderThickness:2,bulletColor:"#F90",bulletSize:6,hidden:!1,id:"AmGraph-1",fillAlphas:.4,fillColors:"#C77A04",lineAlpha:1,lineColor:"#C77A04",lineThickness:1,title:"Altitude",valueField:"z"}],guides:[],valueAxes:[{id:"ValueAxis-1",minVerticalGap:20,title:"Altitude (m)"}],balloon:{borderColor:"#CCCCCC",borderThickness:1,fillColor:"#FFFFFF",showBullet:!0},titles:[],allLabels:[],dataProvider:s},l=AmCharts.makeChart(e,r);return l.addListener("changed",(function(t){var e=t.chart.dataProvider[t.index];o.__updateProfileMarker(n,e)})),l}};e.default=o},function(t,e,i){"use strict";i.r(e);var o=i(2),n=i.n(o),s=n.a.Control.extend({options:{position:"topright",picto:null,url:null,text:null,size:"30px"},initialize:function(t){n.a.setOptions(this,t)},onAdd:function(){var t=null;t=n.a.DomUtil.create("div","gp-control-logo",t);var e=!(!this.options.url&&!this.options.text),i=null;e&&((i=n.a.DomUtil.create("a","",t)).target="_blank",this.options.url&&(i.href=this.options.url,this.options.text&&(i.title=this.options.text))),e&&this.options.text&&(i.text=this.options.text);var o=null;return!!this.options.picto&&((o=e?n.a.DomUtil.create("img","",i):n.a.DomUtil.create("img","",t)).src=this.options.picto,"string"==typeof this.options.size?o.style.height=o.style.width=this.options.size:(o.style.height=this.options.size.height,o.style.width=this.options.size.width)),t}});e.default=s},function(t,e,i){"use strict";i.r(e);var o=i(2),n=i.n(o),s=i(34),a=i(171),r=i(173),l=i(175),c=s.default.getLogger("layers"),u={options:{},params:{},protocol:null,serviceUrl:"http://localhost?no-rights-found-for=[{layer}]",_initOptions:function(){if(!this.options||0===Object.keys(this.options))throw new Error("PARAM_MISSING : options !");if(!this.options.layer)throw new Error("PARAM_MISSING : layer !");this.options.apiKey||c.log("PARAM_MISSING : apiKey !"),void 0===this.options.ssl&&(this.options.ssl=!0)},_initContext:function(){this.protocol=!1===this.options.ssl?"http://":"https://"},_initParams:function(t){t||(t="WMTS"),this.params=a.default.get({key:this.options.apiKey,layer:this.options.layer,service:t}),this.params&&0!==Object.keys(this.params)||(this.params={},this.options.apiKey||c.log("WARNING PARAM_MISSING : parameter 'apiKey' is mandatory if the contract key configuration has not been loaded !"))},WMS:function(t,e){var i=s.default.getLogger("layers-wms");this.options=t||{},this._initOptions(),this.settings=e||{},this._initContext(),this._initParams("WMS"),i.log(this.params);var o=null;o=this.params.key||this.options.apiKey?this.params.url||n.a.Util.template("https://wxs.ign.fr/{key}/geoportail/r/wms",{key:this.params.key||this.options.apiKey}):n.a.Util.template(this.serviceUrl,{layer:this.options.layer});var a={layers:this.options.layer,styles:this.params.styles||"normal",format:this.params.format||"image/jpeg",version:this.params.version||"1.3.0"},l={minZoom:this.params.minZoom||1,maxZoom:this.params.maxZoom||21};return n.a.Util.extend(l,this.settings),new r.default(o.replace(/(http|https):\/\//,this.protocol),{paramsNative:l,paramsWms:a,originators:this.params.originators||[],legends:this.params.legends||[],metadata:this.params.metadata||[],title:this.params.title||null,description:this.params.description||null,quicklookUrl:this.params.quicklookUrl||null})},WMTS:function(t,e){var i=s.default.getLogger("layers-wmts");this.options=t||{},this._initOptions(),this.settings=e||{},this._initContext(),this._initParams("WMTS"),i.log(this.params);var o=null;o=this.params.key||this.options.apiKey?this.params.url||n.a.Util.template("https://wxs.ign.fr/{key}/geoportail/wmts",{key:this.params.key||this.options.apiKey}):n.a.Util.template(this.serviceUrl,{layer:this.options.layer});var a={layer:this.options.layer,style:this.params.styles||"normal",format:this.params.format||"image/jpeg",version:this.params.version||"1.0.0",tilematrixset:this.params.TMSLink||"PM"},r={minZoom:this.params.minZoom||1,maxZoom:this.params.maxZoom||21};return n.a.Util.extend(r,this.settings),new l.default(o.replace(/(http|https):\/\//,this.protocol),{paramsNative:r,paramsWmts:a,originators:this.params.originators||[],legends:this.params.legends||[],metadata:this.params.metadata||[],title:this.params.title||"",description:this.params.description||"",quicklookUrl:this.params.quicklookUrl||""})}};e.default=u},function(t,e,i){"use strict";i.r(e);var o=i(34),n=i(141),s=i(172),a=o.default.getLogger("layer-config"),r={get:function(t){var e={};if(n.default.isConfigLoaded()){if((e=n.default.getLayerParams(t.layer,t.service,t.key))&&0!==Object.keys(e).length)return e.minZoom=s.default.getZoomLevelFromScaleDenominator(e.maxScale)||1,e.maxZoom=s.default.getZoomLevelFromScaleDenominator(e.minScale)||21,e;a.warn("WARNING AUTOCONF_FAILED : params not found ?!")}else a.warn("WARNING AUTOCONF_MISSING : contract key configuration has to be loaded to load Geoportal layers !")}};e.default=r},function(t,e,i){"use strict";i.r(e);var o={getZoomLevelFromScaleDenominator:function(t,e){var i={};switch(e){case"EPSG:2154":i={0:104579.224549894,1:52277.5323537905,2:26135.4870785954,3:13066.8913818,4:6533.2286041135,5:3266.5595244627,6:1633.2660045974,7:816.629554986,8:408.3139146768,9:204.1567415109,10:102.0783167832,11:51.0391448966,12:25.5195690743,13:12.7597836936,14:6.379891636,15:3.1899457653,16:1.5949728695,17:.7974864315,18:.3987432149,19:.1993716073,20:.0996858037,21:.0498429018};break;default:i={0:156543.033928041,1:78271.51696402048,2:39135.758482010235,3:19567.87924100512,4:9783.93962050256,5:4891.96981025128,6:2445.98490512564,7:1222.99245256282,8:611.49622628141,9:305.7481131407048,10:152.8740565703525,11:76.43702828517624,12:38.21851414258813,13:19.10925707129406,14:9.554628535647032,15:4.777314267823516,16:2.388657133911758,17:1.194328566955879,18:.5971642834779395,19:.2985821417389697,20:.1492910708694849,21:.0746455354347424}}var o=28e-5*t;for(var n in i)if(i.hasOwnProperty(n)&&i[n]<=o)return n=parseInt(n,10);return 0},getAttributions:function(t){var e=t.zoom,i=[];if(null!=t.originators&&t.visibility)for(var o,n=0,s=t.originators.length;n<s;n++){o=!0;for(var a=t.originators[n],r=t.originators[n].constraints||[],l=0,c=r.length;l<c;l++){var u=r[l];o=!0;var h=this.getZoomLevelFromScaleDenominator(u.maxScaleDenominator,t.crs),d=this.getZoomLevelFromScaleDenominator(u.minScaleDenominator,t.crs)||21;h&&h>e&&(o=!1),o&&null!==d&&d<e&&(o=!1);var p=u.bbox;if(o&&p){o=!1;var m=t.extent;if(m){var f=[p.top,p.left,p.bottom,p.right];if(this.intersects(m,f)){o=!0;break}}}}if(o){var _=a.logo,g=a.url,v=a.name?a.name:"",y=a.attribution,E=document.createElement("div");E.className="gp-control-attribution";var P=null;(P=document.createElement("a")).className="gp-control-attribution-link",P.target="_blank",E.appendChild(P),g&&(P.href=g);var w=null;!!_?(w=document.createElement("img"),P?(w.className="gp-control-attribution-image",P.appendChild(w)):(w.className="",E.appendChild(w)),w.src=_,w.title=y||v,w.style.height="30px",w.style.width="30px"):P.textContent=v||(y||(g||"")),i.push(E.innerHTML+" ")}}return i},intersects:function(t,e){var i=t[1]<=e[3]&&e[1]<=t[3],o=t[2]<=e[0]&&e[2]<=t[0];return i&&o}};e.default=o},function(t,e,i){"use strict";i.r(e);var o=i(40),n=i(2),s=i.n(n),a=i(34),r=i(174),l=i(1),c=a.default.getLogger("wms"),u=s.a.TileLayer.WMS.extend({includes:r.default,initialize:function(t,e){var i={};s.a.Util.extend(i,e.paramsWms,e.paramsNative),s.a.TileLayer.WMS.prototype.initialize.call(this,o.default.Helper.normalyzeUrl(t,{"gp-leaflet-ext":l.leafletExtVersion||l.version},!1),i),this._originators=e.originators,this._legends=e.legends,this._metadata=e.metadata,this._title=e.title,this._description=e.description,this._quicklookUrl=e.quicklookUrl,this._geoportal_id=0},onAdd:function(t){c.trace("onAdd layer",this._geoportal_id),this._map=t,this._geoportal_id=s.a.stamp(this),s.a.TileLayer.WMS.prototype.onAdd.call(this,t),this.setVisible(!0),this.updateAttributions(t),t.on({overlayremove:this._onRemoveLayer,overlayadd:this._onAddLayer,layerremove:this._onRemoveLayer,layeradd:this._onAddLayer,moveend:this._onMoveEndLayer},this)},onRemove:function(t){c.trace("onRemove layer",this._geoportal_id),this._map=t,s.a.TileLayer.prototype.onRemove.call(this,t),this.setVisible(!1),this.removeAttributions(t),t.off({overlayremove:this._onRemoveLayer,overlayadd:this._onAddLayer,layerremove:this._onRemoveLayer,layeradd:this._onAddLayer,moveend:this._onMoveEndLayer},this)},getTileUrl:function(t){var e=this._map,i=this.options.tileSize,o=t.multiplyBy(i),n=o.add([i,i]),a=this._crs.project(e.unproject(o,t.z)),r=this._crs.project(e.unproject(n,t.z)),l=this._wmsVersion>=1.3&&-1!==["EPSG:4326"].indexOf(this._crs.code)?[r.y,a.x,a.y,r.x].join(","):[a.x,r.y,r.x,a.y].join(","),c=s.a.Util.template(this._url,{s:this._getSubdomain(t)});return c+s.a.Util.getParamString(this.wmsParams,c,!0)+"&BBOX="+l}});e.default=u},function(t,e,i){"use strict";i.r(e);var o=i(34),n=i(172),s=o.default.getLogger("layer-event"),a={_id:null,_attributions:[],_visibility:!0,_originators:[],isEnable:function(t){return!!t.attributionControl},setVisible:function(t){s.log("visibility",t),this._visibility=t,this.fire("visibilitychange")},getVisible:function(){return this._visibility},_onRemoveLayer:function(t){s.trace("onRemove event",t),t.layer._geoportal_id===this._geoportal_id&&this.setVisible(!1)},_onAddLayer:function(t){s.trace("onAdd event",t),t.layer._geoportal_id===this._geoportal_id&&this.setVisible(!0)},_onMoveEndLayer:function(t){s.trace("moveend event",t),this.updateAttributions(this._map,this)},updateAttributions:function(t){this.isEnable(t)&&(this.removeAttributions(t),this.addAttributions(t),this.fire("attributionchange"))},removeAttributions:function(t){if(s.trace("removeAttributions...",this._geoportal_id),this.isEnable(t)){for(var e=0;e<this._attributions.length;e++)t.attributionControl.removeAttribution(this._attributions[e]);this._attributions&&(this._attributions=[])}},addAttributions:function(t){if(s.trace("addAttributions...",this._geoportal_id),this.isEnable(t)){var e=t.getBounds().getNorthWest(),i=t.getBounds().getSouthEast(),o={extent:[e.lat,e.lng,i.lat,i.lng],zoom:t.getZoom(),originators:this._originators,visibility:this._visibility};s.log(o);var a=n.default.getAttributions(o);if(s.log(a),a&&0!==a.length)for(var r=0;r<a.length;r++)this._attributions.push(a[r]),t.attributionControl.addAttribution(a[r])}}};e.default=a},function(t,e,i){"use strict";i.r(e);var o=i(40),n=i(2),s=i.n(n),a=i(34),r=i(174),l=i(1),c=a.default.getLogger("wmts"),u=s.a.TileLayer.extend({includes:r.default,defaultWmtsParams:{service:"WMTS",request:"GetTile",version:"1.0.0",layer:"",style:"",tilematrixset:"PM",format:"image/jpeg"},initialize:function(t,e){c.log("initialize"),this._wmtsParams={},s.a.Util.extend(this._wmtsParams,this.defaultWmtsParams,e.paramsWmts),s.a.TileLayer.prototype.initialize.call(this,o.default.Helper.normalyzeUrl(t,{"gp-leaflet-ext":l.leafletExtVersion||l.version},!1),e.paramsNative),this._originators=e.originators,this._legends=e.legends,this._metadata=e.metadata,this._title=e.title,this._description=e.description,this._quicklookUrl=e.quicklookUrl,this._geoportal_id=0},onAdd:function(t){c.trace("onAdd layer",this._geoportal_id),this._map=t,this._geoportal_id=s.a.stamp(this),s.a.TileLayer.prototype.onAdd.call(this,t),this.setVisible(!0),this.updateAttributions(t),t.on({overlayremove:this._onRemoveLayer,overlayadd:this._onAddLayer,layerremove:this._onRemoveLayer,layeradd:this._onAddLayer,moveend:this._onMoveEndLayer},this)},onRemove:function(t){c.trace("onRemove layer",this._geoportal_id),this._map=t,s.a.TileLayer.prototype.onRemove.call(this,t),this.setVisible(!1),this.removeAttributions(t),t.off({overlayremove:this._onRemoveLayer,overlayadd:this._onAddLayer,layerremove:this._onRemoveLayer,layeradd:this._onAddLayer,moveend:this._onMoveEndLayer},this)},getTileUrl:function(t){var e=this._getZoomForUrl(),i=s.a.Util.template(this._url,{s:this._getSubdomain(t)});return i+s.a.Util.getParamString(this._wmtsParams,i)+"&tilematrix="+e+"&tilerow="+t.y+"&tilecol="+t.x},setParams:function(t,e){return s.a.extend(this._wmtsParams,t),e||this.redraw(),this}});e.default=u},function(t,e,i){"use strict";i.r(e);var o=i(40);!function(){var t=document.getElementsByTagName("script"),e=t[t.length-1].getAttribute("data-key");if(e){var i=e.split(/;|,|\|/);if(e&&i.length>1){for(var n=[],s=0;s<i.length;s++)n.push(i[s]);e=n}}var a=t[t.length-1].getAttribute("data-url"),r=t[t.length-1].getAttribute("data-timeout");if(e||a){var l={apiKey:e,onSuccess:function(){},onFailure:function(t){throw new Error("Configuration load failed : "+t.message)}};a&&(l.serverUrl=a,l.callbackSuffix=""),r&&(l.timeOut=r),o.default.Config||o.default.Services.getConfig(l)}}()},function(t,e,i){"use strict";i.r(e);var o=i(34),n={proxifyUrl:function(t,e){var i=o.default.getLogger("proxifyUrl");if(!e||!e.hasOwnProperty("proxyUrl")||null===e.proxyUrl||0===e.proxyUrl.trim().length)return t;if(e.noProxyDomains&&Array.isArray(e.noProxyDomains)&&e.noProxyDomains.length>0)for(var n in e.noProxyDomains)if(i.trace("[ProxyUtils] proxifyUrl : analyzing "+e.noProxyDomains[n]),-1!==t.indexOf(e.noProxyDomains[n]))return i.info("[ProxyUtils] proxifyUrl : "+t+" found in noProxyDomains list ("+e.noProxyDomains[n]+")."),t;return e.proxyUrl+encodeURIComponent(t)}};e.default=n},function(t,e,i){"use strict";i.r(e);var o={rgbaToHex:function(t){function e(t){if(t>255)throw new Error("'"+t+"'' is greater than 255(0xff);");return("0"+Number(t).toString(16)).slice(-2)}var i=/rgba?\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(?:,\s*(0?.?\d+)\s*)?\)/.exec(t);if(!i)throw new Error("Invalid format: "+t);var o=i[1],n=i[2],s=i[3],a=i[4],r=[e(o),e(n),e(s)],l={};return l.hex="#"+r.join(""),a&&(l.opacity=parseFloat(a)),l},hexToRgba:function(t,e){if(!t)throw new Error("Invalid format");t=t.replace(/^#?([a-f\d])([a-f\d])([a-f\d])$/i,(function(t,e,i,o){return e+e+i+i+o+o}));var i=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(t);return(i=i?{r:parseInt(i[1],16),g:parseInt(i[2],16),b:parseInt(i[3],16)}:null)?"rgba("+i.r+", "+i.g+", "+i.b+", "+e+")":null}};e.default=o}])}));
