#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_file.interfaces import IFile, IFileModifierForm
from pyams_form.interfaces.form import IFormContextPermissionChecker
from pyams_utils.interfaces import MANAGE_PERMISSION, FORBIDDEN_PERMISSION

# import packages
from pyams_skin.viewlet.toolbar import ToolbarActionItem
from pyams_utils.adapter import adapter_config, ContextRequestViewAdapter
from pyramid.location import lineage
from zope.interface import Interface


class FileModifierAction(ToolbarActionItem):
    """Base file modifier action"""

    hint_gravity = 'nw'

    @property
    def permission(self):
        try:
            return self.__parent__.form.edit_permission
        except AttributeError:
            return MANAGE_PERMISSION


@adapter_config(context=(IFile, Interface, IFileModifierForm), provides=IFormContextPermissionChecker)
class FileModifierFormPermissionChecker(ContextRequestViewAdapter):
    """File form permission checker

    File modifier forms are files properties and images resizer/crop/thumbnails selection forms, for
    which edit permission is not based directly on form's context (the *file*), but on parent.
    """

    @property
    def edit_permission(self):
        registry = self.request.registry
        for parent in lineage(self.context):
            checker = registry.queryAdapter(parent, IFormContextPermissionChecker)
            if checker is not None:
                return checker.edit_permission
        return FORBIDDEN_PERMISSION
