#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

import json

from pyramid.renderers import render
from zope.interface import Interface

from pyams_utils.adapter import ContextRequestViewAdapter, adapter_config
from pyams_utils.interfaces.tales import ITALESExtension


#
# Responsive 'picture' TALES extension
#

@adapter_config(name='picture',
                context=(Interface, Interface, Interface),
                provides=ITALESExtension)
class PictureTALESExtension(ContextRequestViewAdapter):
    """Picture TALES adapter

    This TALES adapter can be used to automatically create a 'picture' HTML tag
    embedding all image attributes.
    """

    def render(self, context=None, lg_thumb='lg', lg_width=12, md_thumb='md', md_width=12,
               sm_thumb='sm', sm_width=12, xs_thumb='xs', xs_width=12,
               def_thumb=None, def_width=None, alt='', css_class='', pic_class=None,
               img_width='100%', data=None):
        if context is None:
            context = self.context
        if context.content_type.startswith('image/svg'):
            return render('templates/svg-picture.pt', {
                'image': context,
                'lg_width': lg_width,
                'md_width': md_width,
                'sm_width': sm_width,
                'xs_width': xs_width,
                'alt': alt,
                'css_class': css_class,
                'img_width': img_width
            }, request=self.request)
        else:
            if def_thumb is None:
                def_thumb = md_thumb or lg_thumb or sm_thumb or xs_thumb
            if def_width is None:
                def_width = md_width or lg_width or sm_width or xs_width
            data = json.dumps(data) if data else ''
            return render('templates/picture.pt', {
                'image': context,
                'lg_thumb': lg_thumb or 'lg',
                'lg_width': lg_width,
                'md_thumb': md_thumb or 'md',
                'md_width': md_width,
                'sm_thumb': sm_thumb or 'sm',
                'sm_width': sm_width,
                'xs_thumb': xs_thumb or 'xs',
                'xs_width': xs_width,
                'def_thumb': def_thumb or 'md',
                'def_width': def_width,
                'alt': alt,
                'pic_class': pic_class,
                'css_class': css_class,
                'img_width': img_width,
                'data': data
            }, request=self.request)
