#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

import logging

from zope.intid import IIntIds

from pyams_file.interfaces import IBlobReferenceManager, IFile
from pyams_utils.registry import get_local_registry, get_utility, set_local_registry


logger = logging.getLogger('PyAMS (file)')


def evolve(site):
    """Evolve 2: create reference for all files blobs"""
    registry = get_local_registry()
    try:
        files = set()
        set_local_registry(site.getSiteManager())
        logger.warning("Creating references to all blobs...")
        intids = get_utility(IIntIds)
        references = get_utility(IBlobReferenceManager)
        for ref in list(intids.refs.keys()):
            obj = intids.queryObject(ref)
            if IFile.providedBy(obj):
                blob = getattr(obj, '_blob', None)
                if blob is not None:
                    references.add_reference(blob, obj)
                logger.debug(">>> updated blob reference for file {!r}".format(obj))
        logger.warning("{} files updated".format(len(files)))
    finally:
        set_local_registry(registry)
