#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

import logging

from zope.intid import IIntIds

from pyams_file.interfaces import IMediaFile, IThumbnails
from pyams_utils.registry import get_local_registry, get_utility, set_local_registry


logger = logging.getLogger('PyAMS (file)')


def evolve(site):
    """Evolve 1: remove all images thumbnails to free blobs"""
    registry = get_local_registry()
    try:
        medias = set()
        set_local_registry(site.getSiteManager())
        logger.warning("Removing all thumbnails from database to free unused blobs...")
        intids = get_utility(IIntIds)
        for ref in list(intids.refs.keys()):
            obj = intids.queryObject(ref)
            if IMediaFile.providedBy(obj):
                logger.debug(">>> removing thumbnails for image {!r}".format(obj))
                thumbnails = IThumbnails(obj, None)
                if thumbnails is not None:
                    medias.add(obj)
                    thumbnails.clear_thumbnails()
        logger.warning("Thumbnails cleanup is finished. Launch *zodbpack* command if you are using RelStorage "
                       "to remove all unused blobs.")
        logger.warning("{} images updated".format(len(medias)))
    finally:
        set_local_registry(registry)
