#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from datetime import datetime

from zope.dublincore.interfaces import IZopeDublinCore
from zope.interface import Interface

from pyams_skin.interfaces.configuration import IConfiguration
from pyams_skin.interfaces.metas import IHTMLContentMetas
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.metas import LinkMeta
from pyams_utils.adapter import ContextRequestViewAdapter, adapter_config
from pyams_utils.timezone import tztime
from pyams_utils.url import absolute_url


@adapter_config(name='icon', context=(Interface, IPyAMSLayer, Interface), provides=IHTMLContentMetas)
class IconMetasAdapter(ContextRequestViewAdapter):
    """Icon metas adapter"""

    order = 20

    def get_metas(self):
        config = IConfiguration(self.request.root, None)
        if (config is not None) and (config.icon is not None):
            icon = config.icon
            icon_url = absolute_url(icon, self.request)
            icon_size = icon.get_image_size()[0]
            dc = IZopeDublinCore(icon)
            timestamp = datetime.timestamp(tztime(dc.modified))
            for size in (180, 144, 114, 72, 32, 16):
                if icon_size >= size:
                    yield LinkMeta('apple-touch-icon',
                                   type=icon.content_type,
                                   href='{}/++thumb++{}x{}?_={}'.format(icon_url, size, size, timestamp),
                                   sizes='{0}x{0}'.format(size))
            for size in (128, 124, 32):
                if icon_size >= size:
                    yield LinkMeta('icon',
                                   type=icon.content_type,
                                   href='{}/++thumb++{}x{}?_={}'.format(icon_url, size, size, timestamp),
                                   sizes='{0}x{0}'.format(size))
            yield LinkMeta('shortcut-icon', type=icon.content_type, href=icon_url)
