#
# Copyright (c) 2008-2017 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.features.header.interfaces import IHeaderTarget, IHeaderSettings
from pyams_default_theme.features.header import ISimpleHeaderRendererSettings
from pyams_skin.layer import IPyAMSUserLayer

# import packages
from pyams_template.template import template_config
from pyams_utils.traversing import get_parent
from pyams_viewlet.viewlet import contentprovider_config, ViewContentProvider
from zope.interface import Interface


@contentprovider_config(name='pyams.logo', layer=IPyAMSUserLayer, view=Interface)
@template_config(template='templates/logo.pt', layer=IPyAMSUserLayer)
class LogoContentProvider(ViewContentProvider):
    """Logo content provider"""

    @property
    def settings(self):
        target = get_parent(self.request.display_context, IHeaderTarget)
        settings = IHeaderSettings(target)
        while settings.inherit:
            settings = IHeaderSettings(settings.parent)
        return ISimpleHeaderRendererSettings(settings.settings, None)
