#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface
from zope.location import ILocation

from pyams_skin.interfaces.viewlet import IBreadcrumbs
from pyams_skin.layer import IPyAMSUserLayer
from pyams_skin.viewlet.breadcrumb import BreadcrumbsContentProvider, BreadcrumbsAdapter as BaseBreadcrumbsAdapter
from pyams_template.template import override_template
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces.url import DISPLAY_CONTEXT


@adapter_config(context=(ILocation, IPyAMSUserLayer, Interface), provides=IBreadcrumbs)
class BreadcrumbsAdapter(BaseBreadcrumbsAdapter):
    """Breadcrumbs adapter"""

    @property
    def items(self):
        source = self.request.annotations.get(DISPLAY_CONTEXT)
        if source is None:
            source = self.request.context
        if source is not None:
            yield from self.get_items(source)


override_template(context=BreadcrumbsContentProvider, layer=IPyAMSUserLayer,
                  template='breadcrumbs.pt')
