#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyramid.decorator import reify
from zope.interface import Interface

from pyams_content.features.header.interfaces import IHeaderTarget, IHeaderSettings
from pyams_default_theme.features.header.interfaces import ISimpleHeaderRendererSettings
from pyams_default_theme.interfaces import IContentBannerIllustration
from pyams_i18n.interfaces import II18n
from pyams_skin.layer import IPyAMSUserLayer
from pyams_template.template import template_config
from pyams_utils.traversing import get_parent
from pyams_viewlet.viewlet import contentprovider_config, ViewContentProvider


@contentprovider_config(name='pyams.banner', layer=IPyAMSUserLayer, view=Interface)
@template_config(template='templates/banner.pt', layer=IPyAMSUserLayer)
class Banner(ViewContentProvider):
    """Banner content provider"""

    @reify
    def settings(self):
        target = get_parent(self.context, IHeaderTarget)
        settings = IHeaderSettings(target)
        while settings.inherit:
            settings = IHeaderSettings(settings.parent)
        return ISimpleHeaderRendererSettings(settings.settings, None)

    @property
    def banner(self):
        settings = self.settings
        if settings is not None:
            banner = settings.banner
            if banner is not None:
                return banner
        registry = self.request.registry
        illustration = registry.queryMultiAdapter((self.context, self.request),
                                                  IContentBannerIllustration)
        if illustration is not None:
            return II18n(illustration).query_attribute('data', request=self.request)
